/*
 * settings.h - classes and other stuff required for saving and
 *              restoring settings of objects
 *
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox/at/users.sourceforge.net>
 * 
 * This file is part of Linux MultiMedia Studio - http://lmms.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _SETTING_H
#define _SETTING_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


class QDomDocument;
class QDomElement;


class settings
{
public:
	settings()
	{
	}
	virtual ~settings()
	{
	}

	virtual void FASTCALL saveSettings( QDomDocument & _doc,
						QDomElement & _parent ) = 0;
	virtual void FASTCALL loadSettings( const QDomElement & _this ) = 0;
	virtual QString nodeName( void ) const = 0;

} ;


#endif
