/*
 * lmms_main_win.h - declaration of class lmmsMainWin which is the widget for
 *                   the main window of LMMS
 *
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox/at/users.sourceforge.net>
 * 
 * This file is part of Linux MultiMedia Studio - http://lmms.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _LMMS_MAIN_WIN_H
#define _LMMS_MAIN_WIN_H

#include "qt3support.h"

#ifdef QT4

#include <QMainWindow>
#include <QWorkspace>
#include <QWhatsThis>

#else

#include <qmainwindow.h>
#include <qworkspace.h>
#include <qwhatsthis.h>

#endif


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "types.h"


class QGridLayout;
class QSplashScreen;

class configManager;
class songEditor;
class toolButton;




class lmmsMainWin : public QMainWindow
{
	Q_OBJECT
public:
	static inline lmmsMainWin * inst( void )
	{
		if( s_instanceOfMe == NULL )
		{
			s_instanceOfMe = new lmmsMainWin();
		}
		return( s_instanceOfMe );
	}
	inline QWorkspace * workspace( void )
	{
		return( m_workspace );
	}

	inline QWidget * toolBar( void )
	{
		return( m_toolBar );
	}

	int addWidgetToToolBar( QWidget * _w, int _row = -1, int _col = -1 );
	void addSpacingToToolBar( int _size );

	void FASTCALL resetWindowTitle( const QString & _add = "" );

	static inline bool isCtrlPressed( void )
	{
		return( inst()->m_keyMods.m_ctrl );
	}

	static inline bool isShiftPressed( void )
	{
		return( inst()->m_keyMods.m_shift );
	}

	static inline bool isAltPressed( void )
	{
		return( inst()->m_keyMods.m_alt );
	}

	static QSplashScreen * s_splashScreen;


public slots:
	inline void emptySlot( void )
	{
	}
	inline void enterWhatsThisMode( void )
	{
		QWhatsThis::enterWhatsThisMode();
	}
	void createNewProject( void );
	void createNewProjectFromTemplate( int _idx );
	void openProject( void );
	bool saveProject( void );
	bool saveProjectAs( void );
	void showSettingsDialog( void );
	void aboutLMMS( void );
	void help( void );
	void toggleBBEditorWin( void );
	void toggleSongEditorWin( void );
	void toggleProjectNotesWin( void );
	void togglePianoRollWin( void );


protected:
	virtual void keyPressEvent( QKeyEvent * _ke );
	virtual void keyReleaseEvent( QKeyEvent * _ke );
	virtual void closeEvent( QCloseEvent * _ce );


private:
	static lmmsMainWin * s_instanceOfMe;

	QWorkspace * m_workspace;

	QWidget * m_toolBar;
	QGridLayout * m_toolBarLayout;

	QMenu * m_templatesMenu;

	struct keyModifiers
	{
		keyModifiers() :
			m_ctrl( FALSE ),
			m_shift( FALSE ),
			m_alt( FALSE )
		{
		}
		bool m_ctrl;
		bool m_shift;
		bool m_alt;
	} m_keyMods;


	lmmsMainWin();
	~lmmsMainWin();
	lmmsMainWin( const lmmsMainWin & );

	// only main() is allowed to delete an instance of lmmsMainWin
	friend int main( int argc, char * * argv );

	friend class songEditor;
	friend class bbEditor;
	friend class configManager;

} ;

#endif

