// Copyright (C) 2001, 2002, 2003 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

#include "bits/c++config.h"
#include "bits/gthr.h"
#include <fstream>
#include <istream>
#include <ostream>
#include <locale>
#include <ext/stdio_filebuf.h>
#include <ext/stdio_sync_filebuf.h>

// On AIX, and perhaps other systems, library initialization order is
// not guaranteed.  For example, the static initializers for the main
// program might run before the static initializers for this library.
// That means that we cannot rely on static initialization in the
// library; there is no guarantee that things will get initialized in
// time.  This file contains definitions of all global variables that
// require initialization as arrays of characters.

// NB: asm directives can rename these non-exported, namespace
// __gnu_cxx symbols into exported, namespace std symbols with the
// appropriate symbol version name.
// The rename syntax is 
//   asm (".symver currentname,oldname@@GLIBCXX_3.2")
// In macro form:
// _GLIBCXX_ASM_SYMVER(currentname, oldname, GLIBCXX_3.2)


namespace std
{
#define lsizeof(a) (((a)+sizeof(long)-1)/sizeof(long))

  // Standard stream objects.
  // NB: Iff <iostream> is included, these definitions become wonky.
  typedef long fake_istream[lsizeof(sizeof(istream)) ]
  __attribute__ ((aligned(__alignof__(istream))));
  typedef long fake_ostream[lsizeof(sizeof(ostream)) ] 
  __attribute__ ((aligned(__alignof__(ostream))));
  fake_istream cin;
  fake_ostream cout;
  fake_ostream cerr;
  fake_ostream clog;

#ifdef _GLIBCXX_USE_WCHAR_T
  typedef long fake_wistream[lsizeof(sizeof(wistream)) ] 
  __attribute__ ((aligned(__alignof__(wistream))));
  typedef long fake_wostream[lsizeof(sizeof(wostream)) ] 
  __attribute__ ((aligned(__alignof__(wostream))));
  fake_wistream wcin;
  fake_wostream wcout;
  fake_wostream wcerr;
  fake_wostream wclog;
#endif
} // namespace std

namespace __gnu_cxx
{
  using namespace std;

  // We use different stream buffer types depending on whether
  // ios_base::sync_with_stdio(false) has been called.
  typedef long fake_stdiobuf[lsizeof(sizeof(stdio_sync_filebuf<char>)) ]
  __attribute__ ((aligned(__alignof__(stdio_sync_filebuf<char>))));
  fake_stdiobuf buf_cout_sync;
  fake_stdiobuf buf_cin_sync;
  fake_stdiobuf buf_cerr_sync;

  typedef long fake_filebuf[lsizeof(sizeof(stdio_filebuf<char>)) ]
  __attribute__ ((aligned(__alignof__(stdio_filebuf<char>))));
  fake_filebuf buf_cout;
  fake_filebuf buf_cin;
  fake_filebuf buf_cerr;

#ifdef _GLIBCXX_USE_WCHAR_T
  typedef long fake_wstdiobuf[lsizeof(sizeof(stdio_sync_filebuf<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(stdio_sync_filebuf<wchar_t>))));
  fake_wstdiobuf buf_wcout_sync;
  fake_wstdiobuf buf_wcin_sync;
  fake_wstdiobuf buf_wcerr_sync;

  typedef long fake_wfilebuf[lsizeof(sizeof(stdio_filebuf<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(stdio_filebuf<wchar_t>))));
  fake_wfilebuf buf_wcout;
  fake_wfilebuf buf_wcin;
  fake_wfilebuf buf_wcerr;
#endif

  typedef long fake_locale_Impl[lsizeof(sizeof(locale::_Impl)) ]
  __attribute__ ((aligned(__alignof__(locale::_Impl))));
  fake_locale_Impl c_locale_impl;

  typedef long fake_locale[lsizeof(sizeof(locale)) ]
  __attribute__ ((aligned(__alignof__(locale))));
  fake_locale c_locale;

  typedef long fake_name_vec[lsizeof(sizeof(char*)) ]
  __attribute__ ((aligned(__alignof__(char*))));
  fake_name_vec name_vec[6 + _GLIBCXX_NUM_CATEGORIES];

  typedef long fake_names[lsizeof(sizeof(char[2])) ]
  __attribute__ ((aligned(__alignof__(char[2]))));
  fake_names name_c[6 + _GLIBCXX_NUM_CATEGORIES];

  typedef long fake_facet_vec[lsizeof(sizeof(locale::facet*)) ]
  __attribute__ ((aligned(__alignof__(locale::facet*))));
  fake_facet_vec facet_vec[_GLIBCXX_NUM_FACETS];

  typedef long fake_cache_vec[lsizeof(sizeof(locale::facet*)) ]
  __attribute__ ((aligned(__alignof__(locale::facet*))));
  fake_cache_vec cache_vec[_GLIBCXX_NUM_FACETS];

  typedef long fake_ctype_c[lsizeof(sizeof(std::ctype<char>)) ]
  __attribute__ ((aligned(__alignof__(std::ctype<char>))));
  fake_ctype_c ctype_c;

  typedef long fake_collate_c[lsizeof(sizeof(std::collate<char>)) ]
  __attribute__ ((aligned(__alignof__(std::collate<char>))));
  fake_collate_c collate_c;

  typedef long fake_numpunct_c[lsizeof(sizeof (numpunct<char>)) ]
  __attribute__ ((aligned(__alignof__(numpunct<char>))));
  fake_numpunct_c numpunct_c;

  typedef long fake_num_get_c[lsizeof(sizeof (num_get<char>)) ]
  __attribute__ ((aligned(__alignof__(num_get<char>))));
  fake_num_get_c num_get_c;

  typedef long fake_num_put_c[lsizeof(sizeof(num_put<char>)) ]
  __attribute__ ((aligned(__alignof__(num_put<char>))));
  fake_num_put_c num_put_c;

  typedef long fake_codecvt_c[lsizeof(sizeof(codecvt<char, char, mbstate_t>)) ]
  __attribute__ ((aligned(__alignof__(codecvt<char, char, mbstate_t>))));
  fake_codecvt_c codecvt_c;

  typedef long fake_moneypunct_c[lsizeof(sizeof(moneypunct<char, true>)) ]
  __attribute__ ((aligned(__alignof__(moneypunct<char, true>))));
  fake_moneypunct_c moneypunct_ct;
  fake_moneypunct_c moneypunct_cf;

  typedef long fake_money_get_c[lsizeof(sizeof(money_get<char>)) ]
  __attribute__ ((aligned(__alignof__(money_get<char>))));
  fake_money_get_c money_get_c;
  
  typedef long fake_money_put_c[lsizeof(sizeof(money_put<char>)) ]
  __attribute__ ((aligned(__alignof__(money_put<char>))));
  fake_money_put_c money_put_c;

  typedef long fake_timepunct_c[lsizeof(sizeof(__timepunct<char>)) ]
  __attribute__ ((aligned(__alignof__(__timepunct<char>))));
  fake_timepunct_c timepunct_c;

  typedef long fake_time_get_c[lsizeof(sizeof(time_get<char>)) ]
  __attribute__ ((aligned(__alignof__(time_get<char>))));
  fake_time_get_c time_get_c;

  typedef long fake_time_put_c[lsizeof(sizeof (time_put<char>)) ]
  __attribute__ ((aligned(__alignof__(time_put<char>))));
  fake_time_put_c time_put_c;

  typedef long fake_messages_c[lsizeof(sizeof (messages<char>)) ]
  __attribute__ ((aligned(__alignof__(messages<char>))));
  fake_messages_c messages_c;

#ifdef  _GLIBCXX_USE_WCHAR_T
  typedef long fake_wtype_w[lsizeof(sizeof (std::ctype<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(std::ctype<wchar_t>))));
  fake_wtype_w ctype_w;

  typedef long fake_wollate_w[lsizeof(sizeof (std::collate<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(std::collate<wchar_t>))));
  fake_wollate_w collate_w;

  typedef long fake_numpunct_w[lsizeof(sizeof (numpunct<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(numpunct<wchar_t>))));
  fake_numpunct_w numpunct_w;

  typedef long fake_num_get_w[lsizeof(sizeof (num_get<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(num_get<wchar_t>))));
  fake_num_get_w num_get_w;

  typedef long fake_num_put_w[lsizeof(sizeof (num_put<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(num_put<wchar_t>))));
  fake_num_put_w num_put_w;

  typedef long fake_wodecvt_w[lsizeof(sizeof (codecvt<wchar_t, char, mbstate_t>)) ]
  __attribute__ ((aligned(__alignof__(codecvt<wchar_t, char, mbstate_t>))));
  fake_wodecvt_w codecvt_w;

  typedef long fake_moneypunct_w[lsizeof(sizeof (moneypunct<wchar_t, true>)) ]
  __attribute__ ((aligned(__alignof__(moneypunct<wchar_t, true>))));
  fake_moneypunct_w moneypunct_wt;
  fake_moneypunct_w moneypunct_wf;

  typedef long fake_money_get_w[lsizeof(sizeof (money_get<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(money_get<wchar_t>))));
  fake_money_get_w money_get_w;
  
  typedef long fake_money_put_w[lsizeof(sizeof (money_put<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(money_put<wchar_t>))));
  fake_money_put_w money_put_w;

  typedef long fake_timepunct_w[lsizeof(sizeof (__timepunct<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(__timepunct<wchar_t>))));
  fake_timepunct_w timepunct_w;

  typedef long fake_time_get_w[lsizeof(sizeof (time_get<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(time_get<wchar_t>))));
  fake_time_get_w time_get_w;

  typedef long fake_time_put_w[lsizeof(sizeof (time_put<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(time_put<wchar_t>))));
  fake_time_put_w time_put_w;

  typedef long fake_messages_w[lsizeof(sizeof (messages<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(messages<wchar_t>))));
  fake_messages_w messages_w;
#endif

  // Storage for "C" locale caches.
  typedef long fake_num_cache_c[lsizeof(sizeof (std::__numpunct_cache<char>)) ]
  __attribute__ ((aligned(__alignof__(std::__numpunct_cache<char>))));
  fake_num_cache_c numpunct_cache_c;

  typedef long fake_money_cache_c[lsizeof(sizeof (std::__moneypunct_cache<char>)) ]
  __attribute__ ((aligned(__alignof__(std::__moneypunct_cache<char>))));
  fake_money_cache_c moneypunct_cache_ct;
  fake_money_cache_c moneypunct_cache_cf;

  typedef long fake_time_cache_c[lsizeof(sizeof (std::__timepunct_cache<char>)) ]
  __attribute__ ((aligned(__alignof__(std::__timepunct_cache<char>))));
  fake_time_cache_c timepunct_cache_c;

#ifdef _GLIBCXX_USE_WCHAR_T
  typedef long fake_num_cache_w[lsizeof(sizeof (std::__numpunct_cache<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(std::__numpunct_cache<wchar_t>))));
  fake_num_cache_w numpunct_cache_w;

  typedef long fake_money_cache_w[lsizeof(sizeof (std::__moneypunct_cache<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(std::__moneypunct_cache<wchar_t>))));
  fake_money_cache_w moneypunct_cache_wt;
  fake_money_cache_w moneypunct_cache_wf;

  typedef long fake_time_cache_w[lsizeof(sizeof (std::__timepunct_cache<wchar_t>)) ]
  __attribute__ ((aligned(__alignof__(std::__timepunct_cache<wchar_t>))));
  fake_time_cache_w timepunct_cache_w;
#endif

  // Globals for once-only runtime initialization of mutex objects.  This
  // allows static initialization of these objects on systems that need a
  // function call to initialize a mutex.  For example, see stl_threads.h.
#ifdef __GTHREAD_MUTEX_INIT
#elif defined(__GTHREAD_MUTEX_INIT_FUNCTION)
  __gthread_once_t _GLIBCXX_once = __GTHREAD_ONCE_INIT;
  __gthread_mutex_t _GLIBCXX_mutex;
  __gthread_mutex_t *_GLIBCXX_mutex_address;
  
  // Once-only initializer function for _GLIBCXX_mutex.  
  void
  _GLIBCXX_mutex_init ()
  { __GTHREAD_MUTEX_INIT_FUNCTION (&_GLIBCXX_mutex); }

  // Once-only initializer function for _GLIBCXX_mutex_address.  
  void
  _GLIBCXX_mutex_address_init ()
  { __GTHREAD_MUTEX_INIT_FUNCTION (_GLIBCXX_mutex_address); }
#endif
} // namespace __gnu_cxx
