; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+avx | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=BROADWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=SKYLAKE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver2 -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=BDVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-avx2 | FileCheck %s --check-prefix=CHECK --check-prefix=ZNVER1

define <4 x double> @test_addpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_addpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_addpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_addpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_addpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_addpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_addpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_addpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_addpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_addpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fadd <4 x double> %a0, %a1
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = fadd <4 x double> %1, %2
  ret <4 x double> %3
}

define <8 x float> @test_addps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_addps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_addps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_addps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_addps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_addps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_addps:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_addps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_addps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_addps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fadd <8 x float> %a0, %a1
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = fadd <8 x float> %1, %2
  ret <8 x float> %3
}

define <4 x double> @test_addsubpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_addsubpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_addsubpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_addsubpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_addsubpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_addsubpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_addsubpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_addsubpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_addsubpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_addsubpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.addsub.pd.256(<4 x double> %a0, <4 x double> %a1)
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = call <4 x double> @llvm.x86.avx.addsub.pd.256(<4 x double> %1, <4 x double> %2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.addsub.pd.256(<4 x double>, <4 x double>) nounwind readnone

define <8 x float> @test_addsubps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_addsubps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_addsubps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_addsubps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_addsubps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_addsubps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_addsubps:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_addsubps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_addsubps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_addsubps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.addsub.ps.256(<8 x float> %a0, <8 x float> %a1)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.addsub.ps.256(<8 x float> %1, <8 x float> %2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.addsub.ps.256(<8 x float>, <8 x float>) nounwind readnone

define <4 x double> @test_andnotpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_andnotpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_andnotpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_andnotpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_andnotpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_andnotpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_andnotpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_andnotpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_andnotpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_andnotpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandnpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x double> %a0 to <4 x i64>
  %2 = bitcast <4 x double> %a1 to <4 x i64>
  %3 = xor <4 x i64> %1, <i64 -1, i64 -1, i64 -1, i64 -1>
  %4 = and <4 x i64> %3, %2
  %5 = load <4 x double>, <4 x double> *%a2, align 32
  %6 = bitcast <4 x double> %5 to <4 x i64>
  %7 = xor <4 x i64> %4, <i64 -1, i64 -1, i64 -1, i64 -1>
  %8 = and <4 x i64> %6, %7
  %9 = bitcast <4 x i64> %8 to <4 x double>
  %10 = fadd <4 x double> %a1, %9
  ret <4 x double> %10
}

define <8 x float> @test_andnotps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_andnotps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_andnotps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_andnotps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_andnotps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_andnotps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_andnotps:
; SKX:       # %bb.0:
; SKX-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_andnotps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_andnotps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_andnotps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vandnps %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandnps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <8 x float> %a0 to <4 x i64>
  %2 = bitcast <8 x float> %a1 to <4 x i64>
  %3 = xor <4 x i64> %1, <i64 -1, i64 -1, i64 -1, i64 -1>
  %4 = and <4 x i64> %3, %2
  %5 = load <8 x float>, <8 x float> *%a2, align 32
  %6 = bitcast <8 x float> %5 to <4 x i64>
  %7 = xor <4 x i64> %4, <i64 -1, i64 -1, i64 -1, i64 -1>
  %8 = and <4 x i64> %6, %7
  %9 = bitcast <4 x i64> %8 to <8 x float>
  %10 = fadd <8 x float> %a1, %9
  ret <8 x float> %10
}

define <4 x double> @test_andpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_andpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_andpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_andpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_andpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_andpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_andpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_andpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_andpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_andpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vandpd %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x double> %a0 to <4 x i64>
  %2 = bitcast <4 x double> %a1 to <4 x i64>
  %3 = and <4 x i64> %1, %2
  %4 = load <4 x double>, <4 x double> *%a2, align 32
  %5 = bitcast <4 x double> %4 to <4 x i64>
  %6 = and <4 x i64> %3, %5
  %7 = bitcast <4 x i64> %6 to <4 x double>
  %8 = fadd <4 x double> %a1, %7
  ret <4 x double> %8
}

define <8 x float> @test_andps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_andps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_andps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_andps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_andps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_andps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_andps:
; SKX:       # %bb.0:
; SKX-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_andps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_andps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_andps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vandps %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <8 x float> %a0 to <4 x i64>
  %2 = bitcast <8 x float> %a1 to <4 x i64>
  %3 = and <4 x i64> %1, %2
  %4 = load <8 x float>, <8 x float> *%a2, align 32
  %5 = bitcast <8 x float> %4 to <4 x i64>
  %6 = and <4 x i64> %3, %5
  %7 = bitcast <4 x i64> %6 to <8 x float>
  %8 = fadd <8 x float> %a1, %7
  ret <8 x float> %8
}

define <4 x double> @test_blendpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_blendpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.50]
; GENERIC-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [8:0.50]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.50]
; SANDY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [8:0.50]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_blendpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.33]
; HASWELL-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [8:0.50]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.33]
; BROADWELL-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [7:0.50]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.33]
; SKYLAKE-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [8:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.33]
; SKX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [8:0.50]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_blendpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [2:1.00]
; BDVER2-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_blendpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:1.00]
; BTVER2-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_blendpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3] sched: [1:0.50]
; ZNVER1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1],mem[2,3] sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 0, i32 5, i32 6, i32 3>
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = shufflevector <4 x double> %1, <4 x double> %2, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <8 x float> @test_blendps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_blendps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.50]
; GENERIC-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [8:0.50]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.50]
; SANDY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [8:0.50]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_blendps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.33]
; HASWELL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [8:0.50]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.33]
; BROADWELL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [7:0.50]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.33]
; SKYLAKE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [8:0.50]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendps:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.33]
; SKX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [8:0.50]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_blendps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [2:1.00]
; BDVER2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [7:1.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_blendps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:1.00]
; BTVER2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [6:2.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_blendps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7] sched: [1:0.50]
; ZNVER1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3],mem[4,5,6],ymm1[7] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> %a1, <8 x i32> <i32 0, i32 9, i32 10, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = shufflevector <8 x float> %a1, <8 x float> %2, <8 x i32> <i32 0, i32 1, i32 10, i32 3, i32 12, i32 13, i32 14, i32 7>
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}

define <4 x double> @test_blendvpd(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_blendvpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; GENERIC-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendvpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; SANDY-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_blendvpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; HASWELL-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendvpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendvpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:0.67]
; SKYLAKE-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendvpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:0.67]
; SKX-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_blendvpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:3.00]
; BDVER2-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [7:3.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_blendvpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BTVER2-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_blendvpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vblendvpd %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.blendv.pd.256(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2)
  %2 = load <4 x double>, <4 x double> *%a3, align 32
  %3 = call <4 x double> @llvm.x86.avx.blendv.pd.256(<4 x double> %1, <4 x double> %2, <4 x double> %a2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.blendv.pd.256(<4 x double>, <4 x double>, <4 x double>) nounwind readnone

define <8 x float> @test_blendvps(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2, <8 x float> *%a3) {
; GENERIC-LABEL: test_blendvps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; GENERIC-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_blendvps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; SANDY-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_blendvps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; HASWELL-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_blendvps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BROADWELL-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_blendvps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:0.67]
; SKYLAKE-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_blendvps:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:0.67]
; SKX-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [9:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_blendvps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:3.00]
; BDVER2-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [7:3.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_blendvps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BTVER2-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_blendvps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vblendvps %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.blendv.ps.256(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2)
  %2 = load <8 x float>, <8 x float> *%a3, align 32
  %3 = call <8 x float> @llvm.x86.avx.blendv.ps.256(<8 x float> %1, <8 x float> %2, <8 x float> %a2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.blendv.ps.256(<8 x float>, <8 x float>, <8 x float>) nounwind readnone

define <8 x float> @test_broadcastf128(<4 x float> *%a0) {
; GENERIC-LABEL: test_broadcastf128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_broadcastf128:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_broadcastf128:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_broadcastf128:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_broadcastf128:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_broadcastf128:
; SKX:       # %bb.0:
; SKX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_broadcastf128:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [7:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_broadcastf128:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_broadcastf128:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <4 x float>, <4 x float> *%a0, align 32
  %2 = shufflevector <4 x float> %1, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <8 x float> %2
}

define <4 x double> @test_broadcastsd_ymm(double *%a0) {
; GENERIC-LABEL: test_broadcastsd_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_broadcastsd_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_broadcastsd_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_broadcastsd_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_broadcastsd_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_broadcastsd_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_broadcastsd_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [6:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_broadcastsd_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_broadcastsd_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vbroadcastsd (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load double, double *%a0, align 8
  %2 = insertelement <4 x double> undef, double %1, i32 0
  %3 = shufflevector <4 x double> %2, <4 x double> undef, <4 x i32> zeroinitializer
  ret <4 x double> %3
}

define <4 x float> @test_broadcastss(float *%a0) {
; GENERIC-LABEL: test_broadcastss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [6:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_broadcastss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_broadcastss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_broadcastss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_broadcastss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_broadcastss:
; SKX:       # %bb.0:
; SKX-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [6:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_broadcastss:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [7:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_broadcastss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_broadcastss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vbroadcastss (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load float, float *%a0, align 4
  %2 = insertelement <4 x float> undef, float %1, i32 0
  %3 = shufflevector <4 x float> %2, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %3
}

define <8 x float> @test_broadcastss_ymm(float *%a0) {
; GENERIC-LABEL: test_broadcastss_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_broadcastss_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_broadcastss_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_broadcastss_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_broadcastss_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_broadcastss_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_broadcastss_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [6:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_broadcastss_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_broadcastss_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vbroadcastss (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load float, float *%a0, align 4
  %2 = insertelement <8 x float> undef, float %1, i32 0
  %3 = shufflevector <8 x float> %2, <8 x float> undef, <8 x i32> zeroinitializer
  ret <8 x float> %3
}

define <4 x double> @test_cmppd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_cmppd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; GENERIC-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cmppd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; SANDY-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmppd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; HASWELL-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmppd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; BROADWELL-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmppd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmppd:
; SKX:       # %bb.0:
; SKX-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [4:0.50]
; SKX-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cmppd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [2:2.00]
; BDVER2-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BDVER2-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cmppd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [2:2.00]
; BTVER2-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmppd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcmpeqpd %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; ZNVER1-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    vorpd %ymm0, %ymm1, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fcmp oeq <4 x double> %a0, %a1
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = fcmp oeq <4 x double> %a0, %2
  %4 = sext <4 x i1> %1 to <4 x i64>
  %5 = sext <4 x i1> %3 to <4 x i64>
  %6 = or <4 x i64> %4, %5
  %7 = bitcast <4 x i64> %6 to <4 x double>
  ret <4 x double> %7
}

define <8 x float> @test_cmpps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_cmpps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; GENERIC-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cmpps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; SANDY-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmpps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; HASWELL-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmpps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; BROADWELL-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmpps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmpps:
; SKX:       # %bb.0:
; SKX-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [4:0.50]
; SKX-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cmpps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [2:2.00]
; BDVER2-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BDVER2-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cmpps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [2:2.00]
; BTVER2-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmpps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1 # sched: [3:1.00]
; ZNVER1-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    vorps %ymm0, %ymm1, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fcmp oeq <8 x float> %a0, %a1
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = fcmp oeq <8 x float> %a0, %2
  %4 = sext <8 x i1> %1 to <8 x i32>
  %5 = sext <8 x i1> %3 to <8 x i32>
  %6 = or <8 x i32> %4, %5
  %7 = bitcast <8 x i32> %6 to <8 x float>
  ret <8 x float> %7
}

define <4 x double> @test_cvtdq2pd(<4 x i32> %a0, <4 x i32> *%a1) {
; GENERIC-LABEL: test_cvtdq2pd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [4:1.00]
; GENERIC-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtdq2pd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [4:1.00]
; SANDY-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtdq2pd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [6:1.00]
; HASWELL-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [12:1.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtdq2pd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [11:1.00]
; BROADWELL-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [6:1.00]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtdq2pd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [13:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtdq2pd:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [7:1.00]
; SKX-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [13:1.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvtdq2pd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [13:2.00]
; BDVER2-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [8:2.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvtdq2pd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [8:2.00]
; BTVER2-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtdq2pd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtdq2pd (%rdi), %ymm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtdq2pd %xmm0, %ymm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = sitofp <4 x i32> %a0 to <4 x double>
  %2 = load <4 x i32>, <4 x i32> *%a1, align 16
  %3 = sitofp <4 x i32> %2 to <4 x double>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <8 x float> @test_cvtdq2ps(<8 x i32> %a0, <8 x i32> *%a1) {
; GENERIC-LABEL: test_cvtdq2ps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtdq2ps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovaps (%rdi), %xmm1 # sched: [6:0.50]
; SANDY-NEXT:    vinsertf128 $1, 16(%rdi), %ymm1, %ymm1 # sched: [7:0.50]
; SANDY-NEXT:    vcvtdq2ps %ymm1, %ymm1 # sched: [3:1.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtdq2ps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [10:1.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtdq2ps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [9:1.00]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtdq2ps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [11:0.50]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtdq2ps:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [11:0.50]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvtdq2ps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [9:2.00]
; BDVER2-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [4:2.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvtdq2ps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [8:2.00]
; BTVER2-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtdq2ps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtdq2ps (%rdi), %ymm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtdq2ps %ymm0, %ymm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = sitofp <8 x i32> %a0 to <8 x float>
  %2 = load <8 x i32>, <8 x i32> *%a1, align 16
  %3 = sitofp <8 x i32> %2 to <8 x float>
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}

define <8 x i32> @test_cvtpd2dq(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_cvtpd2dq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [4:1.00]
; GENERIC-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [11:1.00]
; GENERIC-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtpd2dq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [4:1.00]
; SANDY-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtpd2dq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [6:1.00]
; HASWELL-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [8:1.00]
; HASWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtpd2dq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [8:1.00]
; BROADWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtpd2dq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [8:1.00]
; SKYLAKE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtpd2dq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [7:1.00]
; SKX-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [8:0.50]
; SKX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvtpd2dq:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [13:2.00]
; BDVER2-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [8:2.00]
; BDVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [2:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvtpd2dq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [11:2.00]
; BTVER2-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [6:2.00]
; BTVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtpd2dq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtpd2dqy (%rdi), %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtpd2dq %ymm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [2:0.67]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %a0)
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %2)
  %4 = shufflevector <4 x i32> %1, <4 x i32> %3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %4
}
declare <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double>) nounwind readnone

define <8 x i32> @test_cvttpd2dq(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_cvttpd2dq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [4:1.00]
; GENERIC-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [11:1.00]
; GENERIC-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvttpd2dq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [4:1.00]
; SANDY-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvttpd2dq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [6:1.00]
; HASWELL-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [8:1.00]
; HASWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvttpd2dq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [8:1.00]
; BROADWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvttpd2dq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [8:1.00]
; SKYLAKE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvttpd2dq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [7:1.00]
; SKX-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [8:0.50]
; SKX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvttpd2dq:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [13:2.00]
; BDVER2-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [8:2.00]
; BDVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [2:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvttpd2dq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [11:2.00]
; BTVER2-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [6:2.00]
; BTVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvttpd2dq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvttpd2dqy (%rdi), %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vcvttpd2dq %ymm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [2:0.67]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fptosi <4 x double> %a0 to <4 x i32>
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = fptosi <4 x double> %2 to <4 x i32>
  %4 = shufflevector <4 x i32> %1, <4 x i32> %3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %4
}

define <8 x float> @test_cvtpd2ps(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_cvtpd2ps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [4:1.00]
; GENERIC-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [11:1.00]
; GENERIC-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtpd2ps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [4:1.00]
; SANDY-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtpd2ps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [6:1.00]
; HASWELL-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [8:1.00]
; HASWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtpd2ps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [8:1.00]
; BROADWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtpd2ps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [8:1.00]
; SKYLAKE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtpd2ps:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [7:1.00]
; SKX-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [8:1.00]
; SKX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [3:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvtpd2ps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [13:2.00]
; BDVER2-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [8:2.00]
; BDVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [2:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvtpd2ps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [11:2.00]
; BTVER2-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [6:2.00]
; BTVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtpd2ps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtpd2psy (%rdi), %xmm1 # sched: [11:1.00]
; ZNVER1-NEXT:    vcvtpd2ps %ymm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0 # sched: [2:0.67]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fptrunc <4 x double> %a0 to <4 x float>
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = fptrunc <4 x double> %2 to <4 x float>
  %4 = shufflevector <4 x float> %1, <4 x float> %3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %4
}

define <8 x i32> @test_cvtps2dq(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_cvtps2dq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtps2dq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [10:1.00]
; SANDY-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtps2dq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [10:1.00]
; HASWELL-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtps2dq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [9:1.00]
; BROADWELL-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtps2dq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [11:0.50]
; SKYLAKE-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtps2dq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [11:0.50]
; SKX-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvtps2dq:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [9:2.00]
; BDVER2-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [4:2.00]
; BDVER2-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvtps2dq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [8:2.00]
; BTVER2-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtps2dq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtps2dq (%rdi), %ymm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtps2dq %ymm0, %ymm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %a0)
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %2)
  %4 = or <8 x i32> %1, %3
  ret <8 x i32> %4
}
declare <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float>) nounwind readnone

define <8 x i32> @test_cvttps2dq(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_cvttps2dq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvttps2dq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [10:1.00]
; SANDY-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvttps2dq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [10:1.00]
; HASWELL-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvttps2dq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [9:1.00]
; BROADWELL-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvttps2dq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [11:0.50]
; SKYLAKE-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvttps2dq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [3:0.50]
; SKX-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [11:0.50]
; SKX-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_cvttps2dq:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [9:2.00]
; BDVER2-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [4:2.00]
; BDVER2-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_cvttps2dq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [8:2.00]
; BTVER2-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvttps2dq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvttps2dq (%rdi), %ymm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vcvttps2dq %ymm0, %ymm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fptosi <8 x float> %a0 to <8 x i32>
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = fptosi <8 x float> %2 to <8 x i32>
  %4 = or <8 x i32> %1, %3
  ret <8 x i32> %4
}

define <4 x double> @test_divpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_divpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [45:44.00]
; GENERIC-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [52:44.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_divpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [45:44.00]
; SANDY-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [52:44.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_divpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [35:28.00]
; HASWELL-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [42:28.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_divpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [23:16.00]
; BROADWELL-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [29:16.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_divpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [14:5.00]
; SKYLAKE-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [21:8.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_divpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [14:5.00]
; SKX-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [21:8.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_divpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [9:19.00]
; BDVER2-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [14:19.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_divpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [38:38.00]
; BTVER2-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [43:38.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_divpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdivpd %ymm1, %ymm0, %ymm0 # sched: [15:15.00]
; ZNVER1-NEXT:    vdivpd (%rdi), %ymm0, %ymm0 # sched: [22:22.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fdiv <4 x double> %a0, %a1
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = fdiv <4 x double> %1, %2
  ret <4 x double> %3
}

define <8 x float> @test_divps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_divps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [29:28.00]
; GENERIC-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [36:28.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_divps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [29:28.00]
; SANDY-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [36:28.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_divps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [21:14.00]
; HASWELL-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [28:14.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_divps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [17:10.00]
; BROADWELL-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [23:10.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_divps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [11:5.00]
; SKYLAKE-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [18:5.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_divps:
; SKX:       # %bb.0:
; SKX-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [11:5.00]
; SKX-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [18:5.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_divps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [9:19.00]
; BDVER2-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [14:19.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_divps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [38:38.00]
; BTVER2-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [43:38.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_divps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdivps %ymm1, %ymm0, %ymm0 # sched: [12:12.00]
; ZNVER1-NEXT:    vdivps (%rdi), %ymm0, %ymm0 # sched: [19:19.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fdiv <8 x float> %a0, %a1
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = fdiv <8 x float> %1, %2
  ret <8 x float> %3
}

define <8 x float> @test_dpps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_dpps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [12:2.00]
; GENERIC-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [19:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_dpps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [12:2.00]
; SANDY-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [19:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_dpps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [14:2.00]
; HASWELL-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [21:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_dpps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [14:2.00]
; BROADWELL-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [20:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_dpps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [13:1.50]
; SKYLAKE-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [20:1.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_dpps:
; SKX:       # %bb.0:
; SKX-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [13:1.33]
; SKX-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [20:1.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_dpps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [27:3.00]
; BDVER2-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [32:3.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_dpps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [12:6.00]
; BTVER2-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [17:6.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_dpps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vdpps $7, (%rdi), %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.dp.ps.256(<8 x float> %a0, <8 x float> %a1, i8 7)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.dp.ps.256(<8 x float> %1, <8 x float> %2, i8 7)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.dp.ps.256(<8 x float>, <8 x float>, i8) nounwind readnone

define <4 x float> @test_extractf128(<8 x float> %a0, <8 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_extractf128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_extractf128:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_extractf128:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_extractf128:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_extractf128:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_extractf128:
; SKX:       # %bb.0:
; SKX-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [3:1.00]
; SKX-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_extractf128:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [2:0.50]
; BDVER2-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [7:0.50]
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_extractf128:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_extractf128:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vextractf128 $1, %ymm0, %xmm0 # sched: [1:0.33]
; ZNVER1-NEXT:    vextractf128 $1, %ymm1, (%rdi) # sched: [8:0.50]
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <8 x float> %a1, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  store <4 x float> %2, <4 x float> *%a2
  ret <4 x float> %1
}

define <4 x double> @test_haddpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_haddpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; GENERIC-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_haddpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; SANDY-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_haddpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_haddpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BROADWELL-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [11:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_haddpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKYLAKE-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_haddpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKX-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_haddpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [11:2.00]
; BDVER2-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [16:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_haddpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [4:2.00]
; BTVER2-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [9:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_haddpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vhaddpd (%rdi), %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.hadd.pd.256(<4 x double> %a0, <4 x double> %a1)
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = call <4 x double> @llvm.x86.avx.hadd.pd.256(<4 x double> %1, <4 x double> %2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.hadd.pd.256(<4 x double>, <4 x double>) nounwind readnone

define <8 x float> @test_haddps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_haddps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; GENERIC-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_haddps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; SANDY-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_haddps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_haddps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BROADWELL-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [11:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_haddps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKYLAKE-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_haddps:
; SKX:       # %bb.0:
; SKX-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKX-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_haddps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [11:2.00]
; BDVER2-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [16:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_haddps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [4:2.00]
; BTVER2-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [9:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_haddps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vhaddps %ymm1, %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vhaddps (%rdi), %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.hadd.ps.256(<8 x float> %a0, <8 x float> %a1)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.hadd.ps.256(<8 x float> %1, <8 x float> %2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.hadd.ps.256(<8 x float>, <8 x float>) nounwind readnone

define <4 x double> @test_hsubpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_hsubpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; GENERIC-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_hsubpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; SANDY-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_hsubpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_hsubpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BROADWELL-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [11:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_hsubpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKYLAKE-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_hsubpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKX-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_hsubpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [11:2.00]
; BDVER2-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [16:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_hsubpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [4:2.00]
; BTVER2-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [9:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_hsubpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vhsubpd (%rdi), %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.hsub.pd.256(<4 x double> %a0, <4 x double> %a1)
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = call <4 x double> @llvm.x86.avx.hsub.pd.256(<4 x double> %1, <4 x double> %2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.hsub.pd.256(<4 x double>, <4 x double>) nounwind readnone

define <8 x float> @test_hsubps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_hsubps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; GENERIC-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_hsubps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; SANDY-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_hsubps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [12:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_hsubps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BROADWELL-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [11:2.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_hsubps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKYLAKE-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_hsubps:
; SKX:       # %bb.0:
; SKX-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [6:2.00]
; SKX-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [13:2.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_hsubps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [11:2.00]
; BDVER2-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [16:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_hsubps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [4:2.00]
; BTVER2-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [9:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_hsubps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vhsubps %ymm1, %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vhsubps (%rdi), %ymm0, %ymm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.hsub.ps.256(<8 x float> %a0, <8 x float> %a1)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.hsub.ps.256(<8 x float> %1, <8 x float> %2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.hsub.ps.256(<8 x float>, <8 x float>) nounwind readnone

define <8 x float> @test_insertf128(<8 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_insertf128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [1:1.00]
; GENERIC-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_insertf128:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [1:1.00]
; SANDY-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_insertf128:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [3:1.00]
; HASWELL-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_insertf128:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [3:1.00]
; BROADWELL-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_insertf128:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [3:1.00]
; SKYLAKE-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_insertf128:
; SKX:       # %bb.0:
; SKX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [3:1.00]
; SKX-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_insertf128:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [2:0.50]
; BDVER2-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; BDVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_insertf128:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [1:1.00]
; BTVER2-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [6:1.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_insertf128:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1 # sched: [2:0.67]
; ZNVER1-NEXT:    vinsertf128 $1, (%rdi), %ymm0, %ymm0 # sched: [9:0.67]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a1, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %2 = shufflevector <8 x float> %a0, <8 x float> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11>
  %3 = load <4 x float>, <4 x float> *%a2, align 16
  %4 = shufflevector <4 x float> %3, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <8 x float> %a0, <8 x float> %4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11>
  %6 = fadd <8 x float> %2, %5
  ret <8 x float> %6
}

define <32 x i8> @test_lddqu(i8* %a0) {
; GENERIC-LABEL: test_lddqu:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vlddqu (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_lddqu:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vlddqu (%rdi), %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_lddqu:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vlddqu (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_lddqu:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vlddqu (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_lddqu:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vlddqu (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_lddqu:
; SKX:       # %bb.0:
; SKX-NEXT:    vlddqu (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_lddqu:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vlddqu (%rdi), %ymm0 # sched: [5:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_lddqu:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vlddqu (%rdi), %ymm0 # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_lddqu:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vlddqu (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <32 x i8> @llvm.x86.avx.ldu.dq.256(i8* %a0)
  ret <32 x i8> %1
}
declare <32 x i8> @llvm.x86.avx.ldu.dq.256(i8*) nounwind readonly

define <2 x double> @test_maskmovpd(i8* %a0, <2 x i64> %a1, <2 x double> %a2) {
; GENERIC-LABEL: test_maskmovpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [8:1.00]
; GENERIC-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maskmovpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [8:1.00]
; SANDY-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maskmovpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [8:2.00]
; HASWELL-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; HASWELL-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maskmovpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [7:2.00]
; BROADWELL-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; BROADWELL-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maskmovpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [7:0.50]
; SKYLAKE-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maskmovpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [7:0.50]
; SKX-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_maskmovpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [6:1.00]
; BDVER2-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [6:2.00]
; BDVER2-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_maskmovpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [6:1.00]
; BTVER2-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [6:2.00]
; BTVER2-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maskmovpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2 # sched: [8:0.50]
; ZNVER1-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi) # sched: [4:0.50]
; ZNVER1-NEXT:    vmovapd %xmm2, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.avx.maskload.pd(i8* %a0, <2 x i64> %a1)
  call void @llvm.x86.avx.maskstore.pd(i8* %a0, <2 x i64> %a1, <2 x double> %a2)
  ret <2 x double> %1
}
declare <2 x double> @llvm.x86.avx.maskload.pd(i8*, <2 x i64>) nounwind readonly
declare void @llvm.x86.avx.maskstore.pd(i8*, <2 x i64>, <2 x double>) nounwind

define <4 x double> @test_maskmovpd_ymm(i8* %a0, <4 x i64> %a1, <4 x double> %a2) {
; GENERIC-LABEL: test_maskmovpd_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [9:1.00]
; GENERIC-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maskmovpd_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [9:1.00]
; SANDY-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maskmovpd_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [9:2.00]
; HASWELL-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; HASWELL-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maskmovpd_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [8:2.00]
; BROADWELL-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; BROADWELL-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maskmovpd_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [8:0.50]
; SKYLAKE-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maskmovpd_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [8:0.50]
; SKX-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_maskmovpd_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [6:2.00]
; BDVER2-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [6:2.00]
; BDVER2-NEXT:    vmovapd %ymm2, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_maskmovpd_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [6:2.00]
; BTVER2-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [6:2.00]
; BTVER2-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maskmovpd_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2 # sched: [8:1.00]
; ZNVER1-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; ZNVER1-NEXT:    vmovapd %ymm2, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.maskload.pd.256(i8* %a0, <4 x i64> %a1)
  call void @llvm.x86.avx.maskstore.pd.256(i8* %a0, <4 x i64> %a1, <4 x double> %a2)
  ret <4 x double> %1
}
declare <4 x double> @llvm.x86.avx.maskload.pd.256(i8*, <4 x i64>) nounwind readonly
declare void @llvm.x86.avx.maskstore.pd.256(i8*, <4 x i64>, <4 x double>) nounwind

define <4 x float> @test_maskmovps(i8* %a0, <4 x i32> %a1, <4 x float> %a2) {
; GENERIC-LABEL: test_maskmovps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [8:1.00]
; GENERIC-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maskmovps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [8:1.00]
; SANDY-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maskmovps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [8:2.00]
; HASWELL-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; HASWELL-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maskmovps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [7:2.00]
; BROADWELL-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [5:1.00]
; BROADWELL-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maskmovps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [7:0.50]
; SKYLAKE-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maskmovps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [7:0.50]
; SKX-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_maskmovps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [6:1.00]
; BDVER2-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [6:2.00]
; BDVER2-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:0.50]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_maskmovps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [6:1.00]
; BTVER2-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [6:2.00]
; BTVER2-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maskmovps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2 # sched: [8:0.50]
; ZNVER1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi) # sched: [4:0.50]
; ZNVER1-NEXT:    vmovaps %xmm2, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.avx.maskload.ps(i8* %a0, <4 x i32> %a1)
  call void @llvm.x86.avx.maskstore.ps(i8* %a0, <4 x i32> %a1, <4 x float> %a2)
  ret <4 x float> %1
}
declare <4 x float> @llvm.x86.avx.maskload.ps(i8*, <4 x i32>) nounwind readonly
declare void @llvm.x86.avx.maskstore.ps(i8*, <4 x i32>, <4 x float>) nounwind

define <8 x float> @test_maskmovps_ymm(i8* %a0, <8 x i32> %a1, <8 x float> %a2) {
; GENERIC-LABEL: test_maskmovps_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [9:1.00]
; GENERIC-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maskmovps_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [9:1.00]
; SANDY-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maskmovps_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [9:2.00]
; HASWELL-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; HASWELL-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maskmovps_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [8:2.00]
; BROADWELL-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; BROADWELL-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maskmovps_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [8:0.50]
; SKYLAKE-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maskmovps_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [8:0.50]
; SKX-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_maskmovps_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [6:2.00]
; BDVER2-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [6:2.00]
; BDVER2-NEXT:    vmovaps %ymm2, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_maskmovps_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [6:2.00]
; BTVER2-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [6:2.00]
; BTVER2-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maskmovps_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2 # sched: [8:1.00]
; ZNVER1-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi) # sched: [5:1.00]
; ZNVER1-NEXT:    vmovaps %ymm2, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.maskload.ps.256(i8* %a0, <8 x i32> %a1)
  call void @llvm.x86.avx.maskstore.ps.256(i8* %a0, <8 x i32> %a1, <8 x float> %a2)
  ret <8 x float> %1
}
declare <8 x float> @llvm.x86.avx.maskload.ps.256(i8*, <8 x i32>) nounwind readonly
declare void @llvm.x86.avx.maskstore.ps.256(i8*, <8 x i32>, <8 x float>) nounwind

define <4 x double> @test_maxpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_maxpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maxpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maxpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maxpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maxpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maxpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_maxpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BDVER2-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_maxpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maxpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmaxpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.max.pd.256(<4 x double> %a0, <4 x double> %a1)
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = call <4 x double> @llvm.x86.avx.max.pd.256(<4 x double> %1, <4 x double> %2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.max.pd.256(<4 x double>, <4 x double>) nounwind readnone

define <8 x float> @test_maxps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_maxps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maxps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maxps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maxps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maxps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maxps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_maxps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BDVER2-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_maxps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maxps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaxps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmaxps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.max.ps.256(<8 x float> %a0, <8 x float> %a1)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.max.ps.256(<8 x float> %1, <8 x float> %2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.max.ps.256(<8 x float>, <8 x float>) nounwind readnone

define <4 x double> @test_minpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_minpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_minpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_minpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_minpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_minpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_minpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_minpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BDVER2-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_minpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_minpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vminpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vminpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.min.pd.256(<4 x double> %a0, <4 x double> %a1)
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = call <4 x double> @llvm.x86.avx.min.pd.256(<4 x double> %1, <4 x double> %2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.min.pd.256(<4 x double>, <4 x double>) nounwind readnone

define <8 x float> @test_minps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_minps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_minps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_minps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_minps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_minps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_minps:
; SKX:       # %bb.0:
; SKX-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_minps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BDVER2-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_minps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_minps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vminps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vminps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.min.ps.256(<8 x float> %a0, <8 x float> %a1)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.min.ps.256(<8 x float> %1, <8 x float> %2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.min.ps.256(<8 x float>, <8 x float>) nounwind readnone

define <4 x double> @test_movapd(<4 x double> *%a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_movapd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovapd (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movapd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovapd (%rdi), %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movapd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovapd (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movapd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovapd (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movapd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovapd (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movapd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovapd (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movapd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovapd (%rdi), %ymm0 # sched: [5:0.50]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movapd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovapd (%rdi), %ymm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movapd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovapd (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovapd %ymm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <4 x double>, <4 x double> *%a0, align 32
  %2 = fadd <4 x double> %1, %1
  store <4 x double> %2, <4 x double> *%a1, align 32
  ret <4 x double> %2
}

define <8 x float> @test_movaps(<8 x float> *%a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_movaps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovaps (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movaps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovaps (%rdi), %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movaps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovaps (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movaps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovaps (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movaps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovaps (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movaps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovaps (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movaps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovaps (%rdi), %ymm0 # sched: [5:0.50]
; BDVER2-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movaps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovaps (%rdi), %ymm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movaps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovaps (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovaps %ymm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <8 x float>, <8 x float> *%a0, align 32
  %2 = fadd <8 x float> %1, %1
  store <8 x float> %2, <8 x float> *%a1, align 32
  ret <8 x float> %2
}

define <4 x double> @test_movddup(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_movddup:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; GENERIC-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [7:0.50]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movddup:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; SANDY-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [7:0.50]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movddup:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; HASWELL-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [7:0.50]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movddup:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; BROADWELL-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [6:0.50]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movddup:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; SKYLAKE-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [7:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movddup:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; SKX-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [7:0.50]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movddup:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [7:1.00]
; BDVER2-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [2:1.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movddup:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [6:2.00]
; BTVER2-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:1.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movddup:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovddup {{.*#+}} ymm1 = mem[0,0,2,2] sched: [8:0.50]
; ZNVER1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2] sched: [1:0.50]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = shufflevector <4 x double> %2, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define i32 @test_movmskpd(<4 x double> %a0) {
; GENERIC-LABEL: test_movmskpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovmskpd %ymm0, %eax # sched: [2:1.00]
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movmskpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovmskpd %ymm0, %eax # sched: [2:1.00]
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movmskpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovmskpd %ymm0, %eax # sched: [3:1.00]
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movmskpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovmskpd %ymm0, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movmskpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovmskpd %ymm0, %eax # sched: [2:1.00]
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movmskpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovmskpd %ymm0, %eax # sched: [2:1.00]
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movmskpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovmskpd %ymm0, %eax # sched: [10:1.00]
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movmskpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovmskpd %ymm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movmskpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovmskpd %ymm0, %eax # sched: [1:1.00]
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.avx.movmsk.pd.256(<4 x double> %a0)
  ret i32 %1
}
declare i32 @llvm.x86.avx.movmsk.pd.256(<4 x double>) nounwind readnone

define i32 @test_movmskps(<8 x float> %a0) {
; GENERIC-LABEL: test_movmskps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovmskps %ymm0, %eax # sched: [2:1.00]
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movmskps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovmskps %ymm0, %eax # sched: [2:1.00]
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movmskps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovmskps %ymm0, %eax # sched: [3:1.00]
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movmskps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovmskps %ymm0, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movmskps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovmskps %ymm0, %eax # sched: [2:1.00]
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movmskps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovmskps %ymm0, %eax # sched: [2:1.00]
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movmskps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovmskps %ymm0, %eax # sched: [10:1.00]
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movmskps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovmskps %ymm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movmskps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovmskps %ymm0, %eax # sched: [1:1.00]
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.avx.movmsk.ps.256(<8 x float> %a0)
  ret i32 %1
}
declare i32 @llvm.x86.avx.movmsk.ps.256(<8 x float>) nounwind readnone

define void @test_movntdq(<4 x i64> %a0, <4 x i64> *%a1) {
; GENERIC-LABEL: test_movntdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movntdq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movntdq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movntdq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movntdq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movntdq:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movntdq:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    #APP
; BDVER2-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [2:2.00]
; BDVER2-NEXT:    #NO_APP
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movntdq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [2:2.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movntdq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    vmovntdq %ymm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void asm sideeffect "vmovntdq $0, $1", "x,*m"(<4 x i64> %a0, <4 x i64> *%a1)
  ret void
}

define <4 x double> @test_movntpd(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_movntpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movntpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movntpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movntpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movntpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movntpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movntpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [3:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movntpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movntpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovntpd %ymm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fadd <4 x double> %a0, %a0
  store <4 x double> %1, <4 x double> *%a1, align 32, !nontemporal !0
  ret <4 x double> %1
}

define <8 x float> @test_movntps(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_movntps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movntps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movntps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movntps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movntps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movntps:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movntps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmovntps %ymm0, (%rdi) # sched: [3:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movntps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmovntps %ymm0, (%rdi) # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movntps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovntps %ymm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fadd <8 x float> %a0, %a0
  store <8 x float> %1, <8 x float> *%a1, align 32, !nontemporal !0
  ret <8 x float> %1
}

define <8 x float> @test_movshdup(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_movshdup:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; GENERIC-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [7:0.50]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movshdup:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; SANDY-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [7:0.50]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movshdup:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; HASWELL-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [7:0.50]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movshdup:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; BROADWELL-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movshdup:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; SKYLAKE-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [7:0.50]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movshdup:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; SKX-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [7:0.50]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movshdup:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [7:1.00]
; BDVER2-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [2:1.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movshdup:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [6:2.00]
; BTVER2-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:1.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movshdup:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovshdup {{.*#+}} ymm1 = mem[1,1,3,3,5,5,7,7] sched: [8:0.50]
; ZNVER1-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7] sched: [1:0.50]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = shufflevector <8 x float> %2, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}

define <8 x float> @test_movsldup(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_movsldup:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; GENERIC-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [7:0.50]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movsldup:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; SANDY-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [7:0.50]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movsldup:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; HASWELL-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [7:0.50]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movsldup:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; BROADWELL-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movsldup:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; SKYLAKE-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [7:0.50]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movsldup:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; SKX-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [7:0.50]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movsldup:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [7:1.00]
; BDVER2-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [2:1.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movsldup:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [6:2.00]
; BTVER2-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:1.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movsldup:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovsldup {{.*#+}} ymm1 = mem[0,0,2,2,4,4,6,6] sched: [8:0.50]
; ZNVER1-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6] sched: [1:0.50]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = shufflevector <8 x float> %2, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}

define <4 x double> @test_movupd(<4 x double> *%a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_movupd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovupd (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movupd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    vinsertf128 $1, 16(%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vextractf128 $1, %ymm0, 16(%rsi) # sched: [1:1.00]
; SANDY-NEXT:    vmovupd %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movupd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovupd (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movupd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovupd (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movupd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovupd (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movupd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovupd (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movupd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovupd (%rdi), %ymm0 # sched: [5:0.50]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movupd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovupd (%rdi), %ymm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movupd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovupd (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovupd %ymm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <4 x double>, <4 x double> *%a0, align 1
  %2 = fadd <4 x double> %1, %1
  store <4 x double> %2, <4 x double> *%a1, align 1
  ret <4 x double> %2
}

define <8 x float> @test_movups(<8 x float> *%a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_movups:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmovups (%rdi), %ymm0 # sched: [7:0.50]
; GENERIC-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movups:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    vinsertf128 $1, 16(%rdi), %ymm0, %ymm0 # sched: [7:0.50]
; SANDY-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vextractf128 $1, %ymm0, 16(%rsi) # sched: [1:1.00]
; SANDY-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movups:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovups (%rdi), %ymm0 # sched: [7:0.50]
; HASWELL-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movups:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovups (%rdi), %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movups:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovups (%rdi), %ymm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movups:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovups (%rdi), %ymm0 # sched: [7:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_movups:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmovups (%rdi), %ymm0 # sched: [5:0.50]
; BDVER2-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_movups:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovups (%rdi), %ymm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movups:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovups (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovups %ymm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <8 x float>, <8 x float> *%a0, align 1
  %2 = fadd <8 x float> %1, %1
  store <8 x float> %2, <8 x float> *%a1, align 1
  ret <8 x float> %2
}

define <4 x double> @test_mulpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_mulpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; GENERIC-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [12:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_mulpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [12:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_mulpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [5:0.50]
; HASWELL-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [12:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_mulpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [3:0.50]
; BROADWELL-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [9:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_mulpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_mulpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_mulpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_mulpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [4:4.00]
; BTVER2-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [9:4.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_mulpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmulpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; ZNVER1-NEXT:    vmulpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fmul <4 x double> %a0, %a1
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = fmul <4 x double> %1, %2
  ret <4 x double> %3
}

define <8 x float> @test_mulps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_mulps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; GENERIC-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [12:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_mulps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [12:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_mulps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:0.50]
; HASWELL-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [12:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_mulps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [3:0.50]
; BROADWELL-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [9:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_mulps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_mulps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_mulps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_mulps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_mulps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; ZNVER1-NEXT:    vmulps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fmul <8 x float> %a0, %a1
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = fmul <8 x float> %1, %2
  ret <8 x float> %3
}

define <4 x double> @orpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: orpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: orpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: orpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: orpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: orpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: orpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: orpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: orpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: orpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vorpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x double> %a0 to <4 x i64>
  %2 = bitcast <4 x double> %a1 to <4 x i64>
  %3 = or <4 x i64> %1, %2
  %4 = load <4 x double>, <4 x double> *%a2, align 32
  %5 = bitcast <4 x double> %4 to <4 x i64>
  %6 = or <4 x i64> %3, %5
  %7 = bitcast <4 x i64> %6 to <4 x double>
  %8 = fadd <4 x double> %a1, %7
  ret <4 x double> %8
}

define <8 x float> @test_orps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_orps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_orps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_orps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_orps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_orps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_orps:
; SKX:       # %bb.0:
; SKX-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_orps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_orps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_orps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vorps %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vorps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <8 x float> %a0 to <4 x i64>
  %2 = bitcast <8 x float> %a1 to <4 x i64>
  %3 = or <4 x i64> %1, %2
  %4 = load <8 x float>, <8 x float> *%a2, align 32
  %5 = bitcast <8 x float> %4 to <4 x i64>
  %6 = or <4 x i64> %3, %5
  %7 = bitcast <4 x i64> %6 to <8 x float>
  %8 = fadd <8 x float> %a1, %7
  ret <8 x float> %8
}

define <4 x double> @test_perm2f128(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_perm2f128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [1:1.00]
; GENERIC-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_perm2f128:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [1:1.00]
; SANDY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_perm2f128:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [3:1.00]
; HASWELL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [10:1.00]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_perm2f128:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [3:1.00]
; BROADWELL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [9:1.00]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_perm2f128:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [3:1.00]
; SKYLAKE-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [10:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_perm2f128:
; SKX:       # %bb.0:
; SKX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [3:1.00]
; SKX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [10:1.00]
; SKX-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_perm2f128:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [4:0.50]
; BDVER2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [8:0.50]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_perm2f128:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [1:1.00]
; BTVER2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [6:1.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_perm2f128:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1] sched: [100:0.25]
; ZNVER1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[0,1] sched: [100:0.25]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = shufflevector <4 x double> %a0, <4 x double> %2, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <2 x double> @test_permilpd(<2 x double> %a0, <2 x double> *%a1) {
; GENERIC-LABEL: test_permilpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:1.00]
; GENERIC-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [7:1.00]
; GENERIC-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:1.00]
; SANDY-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [7:1.00]
; SANDY-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:1.00]
; HASWELL-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [7:1.00]
; HASWELL-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:1.00]
; BROADWELL-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [6:1.00]
; BROADWELL-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [7:1.00]
; SKYLAKE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:1.00]
; SKX-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [7:1.00]
; SKX-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [7:0.50]
; BDVER2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [2:0.50]
; BDVER2-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [6:1.00]
; BTVER2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:0.50]
; BTVER2-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilpd {{.*#+}} xmm1 = mem[1,0] sched: [8:0.50]
; ZNVER1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0] sched: [1:0.50]
; ZNVER1-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <2 x double> %a0, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %2 = load <2 x double>, <2 x double> *%a1, align 16
  %3 = shufflevector <2 x double> %2, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %4 = fadd <2 x double> %1, %3
  ret <2 x double> %4
}

define <4 x double> @test_permilpd_ymm(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_permilpd_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; GENERIC-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilpd_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; SANDY-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilpd_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; HASWELL-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilpd_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; BROADWELL-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilpd_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [8:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilpd_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; SKX-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [8:1.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilpd_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [7:1.00]
; BDVER2-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [2:1.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilpd_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [6:2.00]
; BTVER2-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:1.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilpd_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilpd {{.*#+}} ymm1 = mem[1,0,2,3] sched: [8:0.50]
; ZNVER1-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3] sched: [1:0.50]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> undef, <4 x i32> <i32 1, i32 0, i32 2, i32 3>
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = shufflevector <4 x double> %2, <4 x double> undef, <4 x i32> <i32 1, i32 0, i32 2, i32 3>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <4 x float> @test_permilps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_permilps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:1.00]
; GENERIC-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [7:1.00]
; GENERIC-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:1.00]
; SANDY-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:1.00]
; HASWELL-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [7:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:1.00]
; BROADWELL-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [6:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [7:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilps:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:1.00]
; SKX-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [7:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [7:0.50]
; BDVER2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [2:0.50]
; BDVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [6:1.00]
; BTVER2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:0.50]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilps {{.*#+}} xmm1 = mem[3,2,1,0] sched: [8:0.50]
; ZNVER1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0] sched: [1:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = shufflevector <4 x float> %2, <4 x float> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}

define <8 x float> @test_permilps_ymm(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_permilps_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; GENERIC-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [8:1.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilps_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; SANDY-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [8:1.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilps_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; HASWELL-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [8:1.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilps_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; BROADWELL-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [7:1.00]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilps_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [8:1.00]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilps_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; SKX-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [8:1.00]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilps_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [7:1.00]
; BDVER2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [2:1.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilps_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [6:2.00]
; BTVER2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:1.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilps_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilps {{.*#+}} ymm1 = mem[3,2,1,0,7,6,5,4] sched: [8:0.50]
; ZNVER1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4] sched: [1:0.50]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = shufflevector <8 x float> %2, <8 x float> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}

define <2 x double> @test_permilvarpd(<2 x double> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_permilvarpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilvarpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilvarpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilvarpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilvarpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilvarpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilvarpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [3:2.00]
; BDVER2-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilvarpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BTVER2-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilvarpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vpermilpd (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %a0, <2 x i64> %a1)
  %2 = load <2 x i64>, <2 x i64> *%a2, align 16
  %3 = call <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %1, <2 x i64> %2)
  ret <2 x double> %3
}
declare <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double>, <2 x i64>) nounwind readnone

define <4 x double> @test_permilvarpd_ymm(<4 x double> %a0, <4 x i64> %a1, <4 x i64> *%a2) {
; GENERIC-LABEL: test_permilvarpd_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilvarpd_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilvarpd_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilvarpd_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilvarpd_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilvarpd_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SKX-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilvarpd_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BDVER2-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilvarpd_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BTVER2-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilvarpd_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vpermilpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double> %a0, <4 x i64> %a1)
  %2 = load <4 x i64>, <4 x i64> *%a2, align 32
  %3 = call <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double> %1, <4 x i64> %2)
  ret <4 x double> %3
}
declare <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double>, <4 x i64>) nounwind readnone

define <4 x float> @test_permilvarps(<4 x float> %a0, <4 x i32> %a1, <4 x i32> *%a2) {
; GENERIC-LABEL: test_permilvarps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilvarps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilvarps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilvarps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilvarps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilvarps:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilvarps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [3:2.00]
; BDVER2-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilvarps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [2:2.00]
; BTVER2-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilvarps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vpermilps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.avx.vpermilvar.ps(<4 x float> %a0, <4 x i32> %a1)
  %2 = load <4 x i32>, <4 x i32> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.avx.vpermilvar.ps(<4 x float> %1, <4 x i32> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.avx.vpermilvar.ps(<4 x float>, <4 x i32>) nounwind readnone

define <8 x float> @test_permilvarps_ymm(<8 x float> %a0, <8 x i32> %a1, <8 x i32> *%a2) {
; GENERIC-LABEL: test_permilvarps_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_permilvarps_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_permilvarps_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_permilvarps_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_permilvarps_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_permilvarps_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SKX-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_permilvarps_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BDVER2-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_permilvarps_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BTVER2-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_permilvarps_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpermilps %ymm1, %ymm0, %ymm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vpermilps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.vpermilvar.ps.256(<8 x float> %a0, <8 x i32> %a1)
  %2 = load <8 x i32>, <8 x i32> *%a2, align 32
  %3 = call <8 x float> @llvm.x86.avx.vpermilvar.ps.256(<8 x float> %1, <8 x i32> %2)
  ret <8 x float> %3
}
declare <8 x float> @llvm.x86.avx.vpermilvar.ps.256(<8 x float>, <8 x i32>) nounwind readnone

define <8 x float> @test_rcpps(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_rcpps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vrcpps (%rdi), %ymm1 # sched: [14:2.00]
; GENERIC-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_rcpps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vrcpps (%rdi), %ymm1 # sched: [14:2.00]
; SANDY-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_rcpps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vrcpps (%rdi), %ymm1 # sched: [18:2.00]
; HASWELL-NEXT:    vrcpps %ymm0, %ymm0 # sched: [11:2.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_rcpps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vrcpps %ymm0, %ymm0 # sched: [11:2.00]
; BROADWELL-NEXT:    vrcpps (%rdi), %ymm1 # sched: [17:2.00]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_rcpps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vrcpps %ymm0, %ymm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    vrcpps (%rdi), %ymm1 # sched: [11:1.00]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_rcpps:
; SKX:       # %bb.0:
; SKX-NEXT:    vrcpps %ymm0, %ymm0 # sched: [4:1.00]
; SKX-NEXT:    vrcpps (%rdi), %ymm1 # sched: [11:1.00]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_rcpps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vrcpps (%rdi), %ymm1 # sched: [10:2.00]
; BDVER2-NEXT:    vrcpps %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_rcpps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vrcpps (%rdi), %ymm1 # sched: [7:2.00]
; BTVER2-NEXT:    vrcpps %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_rcpps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vrcpps (%rdi), %ymm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vrcpps %ymm0, %ymm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.rcp.ps.256(<8 x float> %a0)
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = call <8 x float> @llvm.x86.avx.rcp.ps.256(<8 x float> %2)
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}
declare <8 x float> @llvm.x86.avx.rcp.ps.256(<8 x float>) nounwind readnone

define <4 x double> @test_roundpd(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_roundpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_roundpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_roundpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [6:0.50]
; HASWELL-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [13:2.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_roundpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [12:2.00]
; BROADWELL-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_roundpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [15:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_roundpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [8:1.00]
; SKX-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [15:1.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_roundpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [9:2.00]
; BDVER2-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [4:2.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_roundpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [8:2.00]
; BTVER2-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_roundpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vroundpd $7, (%rdi), %ymm1 # sched: [11:1.00]
; ZNVER1-NEXT:    vroundpd $7, %ymm0, %ymm0 # sched: [4:1.00]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.round.pd.256(<4 x double> %a0, i32 7)
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = call <4 x double> @llvm.x86.avx.round.pd.256(<4 x double> %2, i32 7)
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}
declare <4 x double> @llvm.x86.avx.round.pd.256(<4 x double>, i32) nounwind readnone

define <8 x float> @test_roundps(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_roundps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_roundps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_roundps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [6:0.50]
; HASWELL-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [13:2.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_roundps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [12:2.00]
; BROADWELL-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [6:0.50]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_roundps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [15:1.00]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_roundps:
; SKX:       # %bb.0:
; SKX-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [8:1.00]
; SKX-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [15:1.00]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_roundps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [9:2.00]
; BDVER2-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [4:2.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_roundps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [8:2.00]
; BTVER2-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_roundps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vroundps $7, (%rdi), %ymm1 # sched: [11:1.00]
; ZNVER1-NEXT:    vroundps $7, %ymm0, %ymm0 # sched: [4:1.00]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.round.ps.256(<8 x float> %a0, i32 7)
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = call <8 x float> @llvm.x86.avx.round.ps.256(<8 x float> %2, i32 7)
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}
declare <8 x float> @llvm.x86.avx.round.ps.256(<8 x float>, i32) nounwind readnone

define <8 x float> @test_rsqrtps(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_rsqrtps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [14:2.00]
; GENERIC-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [7:2.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_rsqrtps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [14:2.00]
; SANDY-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [7:2.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_rsqrtps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [18:2.00]
; HASWELL-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [11:2.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_rsqrtps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [11:2.00]
; BROADWELL-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [17:2.00]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_rsqrtps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [11:1.00]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_rsqrtps:
; SKX:       # %bb.0:
; SKX-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [4:1.00]
; SKX-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [11:1.00]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_rsqrtps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [10:2.00]
; BDVER2-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_rsqrtps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [7:2.00]
; BTVER2-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_rsqrtps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vrsqrtps (%rdi), %ymm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vrsqrtps %ymm0, %ymm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.rsqrt.ps.256(<8 x float> %a0)
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = call <8 x float> @llvm.x86.avx.rsqrt.ps.256(<8 x float> %2)
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}
declare <8 x float> @llvm.x86.avx.rsqrt.ps.256(<8 x float>) nounwind readnone

define <4 x double> @test_shufpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_shufpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; GENERIC-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_shufpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; SANDY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_shufpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; HASWELL-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_shufpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; BROADWELL-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_shufpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; SKYLAKE-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [8:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_shufpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; SKX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [8:1.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_shufpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [2:1.00]
; BDVER2-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_shufpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:1.00]
; BTVER2-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_shufpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[3] sched: [1:0.50]
; ZNVER1-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],mem[0],ymm1[2],mem[3] sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 1, i32 4, i32 2, i32 7>
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = shufflevector <4 x double> %a1, <4 x double> %2, <4 x i32> <i32 1, i32 4, i32 2, i32 7>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <8 x float> @test_shufps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) nounwind {
; GENERIC-LABEL: test_shufps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; GENERIC-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [8:1.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_shufps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; SANDY-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [8:1.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_shufps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; HASWELL-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [8:1.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_shufps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; BROADWELL-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [7:1.00]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_shufps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; SKYLAKE-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [8:1.00]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_shufps:
; SKX:       # %bb.0:
; SKX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; SKX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [8:1.00]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_shufps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [2:1.00]
; BDVER2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [7:1.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_shufps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:1.00]
; BTVER2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [6:2.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_shufps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4] sched: [1:0.50]
; ZNVER1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,3],mem[0,0],ymm1[4,7],mem[4,4] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> %a1, <8 x i32> <i32 0, i32 0, i32 8, i32 8, i32 4, i32 4, i32 12, i32 12>
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = shufflevector <8 x float> %a1, <8 x float> %2, <8 x i32> <i32 0, i32 3, i32 8, i32 8, i32 4, i32 7, i32 12, i32 12>
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}

define <4 x double> @test_sqrtpd(<4 x double> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_sqrtpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [52:44.00]
; GENERIC-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [45:44.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_sqrtpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [52:44.00]
; SANDY-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [45:44.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_sqrtpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [42:28.00]
; HASWELL-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [35:28.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_sqrtpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [29:28.00]
; BROADWELL-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [35:28.00]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_sqrtpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [18:12.00]
; SKYLAKE-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [25:12.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_sqrtpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [18:12.00]
; SKX-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [25:12.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_sqrtpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [14:27.00]
; BDVER2-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [9:27.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_sqrtpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [59:54.00]
; BTVER2-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [54:54.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_sqrtpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsqrtpd (%rdi), %ymm1 # sched: [47:40.00]
; ZNVER1-NEXT:    vsqrtpd %ymm0, %ymm0 # sched: [40:40.00]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x double> @llvm.x86.avx.sqrt.pd.256(<4 x double> %a0)
  %2 = load <4 x double>, <4 x double> *%a1, align 32
  %3 = call <4 x double> @llvm.x86.avx.sqrt.pd.256(<4 x double> %2)
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}
declare <4 x double> @llvm.x86.avx.sqrt.pd.256(<4 x double>) nounwind readnone

define <8 x float> @test_sqrtps(<8 x float> %a0, <8 x float> *%a1) {
; GENERIC-LABEL: test_sqrtps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [36:28.00]
; GENERIC-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [29:28.00]
; GENERIC-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_sqrtps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [36:28.00]
; SANDY-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [29:28.00]
; SANDY-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_sqrtps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [28:14.00]
; HASWELL-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [21:14.00]
; HASWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_sqrtps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [21:14.00]
; BROADWELL-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [27:14.00]
; BROADWELL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_sqrtps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [12:6.00]
; SKYLAKE-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [19:6.00]
; SKYLAKE-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_sqrtps:
; SKX:       # %bb.0:
; SKX-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [12:6.00]
; SKX-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [19:6.00]
; SKX-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_sqrtps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [14:21.00]
; BDVER2-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [9:21.00]
; BDVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_sqrtps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [47:42.00]
; BTVER2-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [42:42.00]
; BTVER2-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_sqrtps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsqrtps (%rdi), %ymm1 # sched: [35:28.00]
; ZNVER1-NEXT:    vsqrtps %ymm0, %ymm0 # sched: [28:28.00]
; ZNVER1-NEXT:    vaddps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <8 x float> @llvm.x86.avx.sqrt.ps.256(<8 x float> %a0)
  %2 = load <8 x float>, <8 x float> *%a1, align 32
  %3 = call <8 x float> @llvm.x86.avx.sqrt.ps.256(<8 x float> %2)
  %4 = fadd <8 x float> %1, %3
  ret <8 x float> %4
}
declare <8 x float> @llvm.x86.avx.sqrt.ps.256(<8 x float>) nounwind readnone

define <4 x double> @test_subpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_subpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_subpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_subpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_subpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_subpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_subpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_subpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_subpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_subpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsubpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vsubpd (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fsub <4 x double> %a0, %a1
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = fsub <4 x double> %1, %2
  ret <4 x double> %3
}

define <8 x float> @test_subps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_subps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_subps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_subps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_subps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [9:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_subps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_subps:
; SKX:       # %bb.0:
; SKX-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [11:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_subps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [10:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_subps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [8:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_subps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsubps %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vsubps (%rdi), %ymm0, %ymm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fsub <8 x float> %a0, %a1
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = fsub <8 x float> %1, %2
  ret <8 x float> %3
}

define i32 @test_testpd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_testpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; GENERIC-NEXT:    vtestpd %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    vtestpd (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    adcl $0, %eax # sched: [2:0.67]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_testpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; SANDY-NEXT:    vtestpd %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    setb %al # sched: [1:0.50]
; SANDY-NEXT:    vtestpd (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    adcl $0, %eax # sched: [2:0.67]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_testpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; HASWELL-NEXT:    vtestpd %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    setb %al # sched: [1:0.50]
; HASWELL-NEXT:    vtestpd (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    adcl $0, %eax # sched: [2:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_testpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    vtestpd %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    setb %al # sched: [1:0.50]
; BROADWELL-NEXT:    vtestpd (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    adcl $0, %eax # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_testpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    vtestpd %xmm1, %xmm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    setb %al # sched: [1:0.50]
; SKYLAKE-NEXT:    vtestpd (%rdi), %xmm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_testpd:
; SKX:       # %bb.0:
; SKX-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKX-NEXT:    vtestpd %xmm1, %xmm0 # sched: [2:1.00]
; SKX-NEXT:    setb %al # sched: [1:0.50]
; SKX-NEXT:    vtestpd (%rdi), %xmm0 # sched: [8:1.00]
; SKX-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_testpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; BDVER2-NEXT:    vtestpd %xmm1, %xmm0 # sched: [1:1.00]
; BDVER2-NEXT:    setb %al # sched: [1:0.50]
; BDVER2-NEXT:    vtestpd (%rdi), %xmm0 # sched: [6:1.00]
; BDVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_testpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    xorl %eax, %eax # sched: [0:0.50]
; BTVER2-NEXT:    vtestpd %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setb %al # sched: [1:0.50]
; BTVER2-NEXT:    vtestpd (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_testpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vtestpd %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    setb %al # sched: [1:0.25]
; ZNVER1-NEXT:    vtestpd (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    adcl $0, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.avx.vtestc.pd(<2 x double> %a0, <2 x double> %a1)
  %2 = load <2 x double>, <2 x double> *%a2, align 16
  %3 = call i32 @llvm.x86.avx.vtestc.pd(<2 x double> %a0, <2 x double> %2)
  %4 = add i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.avx.vtestc.pd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_testpd_ymm(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_testpd_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; GENERIC-NEXT:    vtestpd %ymm1, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    vtestpd (%rdi), %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    adcl $0, %eax # sched: [2:0.67]
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_testpd_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; SANDY-NEXT:    vtestpd %ymm1, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    setb %al # sched: [1:0.50]
; SANDY-NEXT:    vtestpd (%rdi), %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    adcl $0, %eax # sched: [2:0.67]
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_testpd_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; HASWELL-NEXT:    vtestpd %ymm1, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    setb %al # sched: [1:0.50]
; HASWELL-NEXT:    vtestpd (%rdi), %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    adcl $0, %eax # sched: [2:0.50]
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_testpd_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    vtestpd %ymm1, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    setb %al # sched: [1:0.50]
; BROADWELL-NEXT:    vtestpd (%rdi), %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    adcl $0, %eax # sched: [1:0.50]
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_testpd_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    vtestpd %ymm1, %ymm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    setb %al # sched: [1:0.50]
; SKYLAKE-NEXT:    vtestpd (%rdi), %ymm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_testpd_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKX-NEXT:    vtestpd %ymm1, %ymm0 # sched: [2:1.00]
; SKX-NEXT:    setb %al # sched: [1:0.50]
; SKX-NEXT:    vtestpd (%rdi), %ymm0 # sched: [9:1.00]
; SKX-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_testpd_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; BDVER2-NEXT:    vtestpd %ymm1, %ymm0 # sched: [1:1.00]
; BDVER2-NEXT:    setb %al # sched: [1:0.50]
; BDVER2-NEXT:    vtestpd (%rdi), %ymm0 # sched: [6:1.00]
; BDVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_testpd_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    xorl %eax, %eax # sched: [0:0.50]
; BTVER2-NEXT:    vtestpd %ymm1, %ymm0 # sched: [4:2.00]
; BTVER2-NEXT:    setb %al # sched: [1:0.50]
; BTVER2-NEXT:    vtestpd (%rdi), %ymm0 # sched: [9:2.00]
; BTVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_testpd_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vtestpd %ymm1, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    setb %al # sched: [1:0.25]
; ZNVER1-NEXT:    vtestpd (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    adcl $0, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.avx.vtestc.pd.256(<4 x double> %a0, <4 x double> %a1)
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = call i32 @llvm.x86.avx.vtestc.pd.256(<4 x double> %a0, <4 x double> %2)
  %4 = add i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.avx.vtestc.pd.256(<4 x double>, <4 x double>) nounwind readnone

define i32 @test_testps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_testps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; GENERIC-NEXT:    vtestps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    vtestps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    adcl $0, %eax # sched: [2:0.67]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_testps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; SANDY-NEXT:    vtestps %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    setb %al # sched: [1:0.50]
; SANDY-NEXT:    vtestps (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    adcl $0, %eax # sched: [2:0.67]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_testps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; HASWELL-NEXT:    vtestps %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    setb %al # sched: [1:0.50]
; HASWELL-NEXT:    vtestps (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    adcl $0, %eax # sched: [2:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_testps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    vtestps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    setb %al # sched: [1:0.50]
; BROADWELL-NEXT:    vtestps (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    adcl $0, %eax # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_testps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    vtestps %xmm1, %xmm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    setb %al # sched: [1:0.50]
; SKYLAKE-NEXT:    vtestps (%rdi), %xmm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_testps:
; SKX:       # %bb.0:
; SKX-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKX-NEXT:    vtestps %xmm1, %xmm0 # sched: [2:1.00]
; SKX-NEXT:    setb %al # sched: [1:0.50]
; SKX-NEXT:    vtestps (%rdi), %xmm0 # sched: [8:1.00]
; SKX-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_testps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; BDVER2-NEXT:    vtestps %xmm1, %xmm0 # sched: [1:1.00]
; BDVER2-NEXT:    setb %al # sched: [1:0.50]
; BDVER2-NEXT:    vtestps (%rdi), %xmm0 # sched: [6:1.00]
; BDVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_testps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    xorl %eax, %eax # sched: [0:0.50]
; BTVER2-NEXT:    vtestps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setb %al # sched: [1:0.50]
; BTVER2-NEXT:    vtestps (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_testps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vtestps %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    setb %al # sched: [1:0.25]
; ZNVER1-NEXT:    vtestps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    adcl $0, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.avx.vtestc.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call i32 @llvm.x86.avx.vtestc.ps(<4 x float> %a0, <4 x float> %2)
  %4 = add i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.avx.vtestc.ps(<4 x float>, <4 x float>) nounwind readnone

define i32 @test_testps_ymm(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_testps_ymm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; GENERIC-NEXT:    vtestps %ymm1, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    vtestps (%rdi), %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    adcl $0, %eax # sched: [2:0.67]
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_testps_ymm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; SANDY-NEXT:    vtestps %ymm1, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    setb %al # sched: [1:0.50]
; SANDY-NEXT:    vtestps (%rdi), %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    adcl $0, %eax # sched: [2:0.67]
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_testps_ymm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; HASWELL-NEXT:    vtestps %ymm1, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    setb %al # sched: [1:0.50]
; HASWELL-NEXT:    vtestps (%rdi), %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    adcl $0, %eax # sched: [2:0.50]
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_testps_ymm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    vtestps %ymm1, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    setb %al # sched: [1:0.50]
; BROADWELL-NEXT:    vtestps (%rdi), %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    adcl $0, %eax # sched: [1:0.50]
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_testps_ymm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    vtestps %ymm1, %ymm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    setb %al # sched: [1:0.50]
; SKYLAKE-NEXT:    vtestps (%rdi), %ymm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_testps_ymm:
; SKX:       # %bb.0:
; SKX-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; SKX-NEXT:    vtestps %ymm1, %ymm0 # sched: [2:1.00]
; SKX-NEXT:    setb %al # sched: [1:0.50]
; SKX-NEXT:    vtestps (%rdi), %ymm0 # sched: [9:1.00]
; SKX-NEXT:    adcl $0, %eax # sched: [1:0.50]
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_testps_ymm:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    xorl %eax, %eax # sched: [0:0.25]
; BDVER2-NEXT:    vtestps %ymm1, %ymm0 # sched: [1:1.00]
; BDVER2-NEXT:    setb %al # sched: [1:0.50]
; BDVER2-NEXT:    vtestps (%rdi), %ymm0 # sched: [6:1.00]
; BDVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_testps_ymm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    xorl %eax, %eax # sched: [0:0.50]
; BTVER2-NEXT:    vtestps %ymm1, %ymm0 # sched: [4:2.00]
; BTVER2-NEXT:    setb %al # sched: [1:0.50]
; BTVER2-NEXT:    vtestps (%rdi), %ymm0 # sched: [9:2.00]
; BTVER2-NEXT:    adcl $0, %eax # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_testps_ymm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    xorl %eax, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vtestps %ymm1, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    setb %al # sched: [1:0.25]
; ZNVER1-NEXT:    vtestps (%rdi), %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    adcl $0, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.avx.vtestc.ps.256(<8 x float> %a0, <8 x float> %a1)
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = call i32 @llvm.x86.avx.vtestc.ps.256(<8 x float> %a0, <8 x float> %2)
  %4 = add i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.avx.vtestc.ps.256(<8 x float>, <8 x float>) nounwind readnone

define <4 x double> @test_unpckhpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_unpckhpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; GENERIC-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_unpckhpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; SANDY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_unpckhpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; HASWELL-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_unpckhpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; BROADWELL-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_unpckhpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; SKYLAKE-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [8:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_unpckhpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; SKX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [8:1.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_unpckhpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [2:1.00]
; BDVER2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_unpckhpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:1.00]
; BTVER2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_unpckhpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3] sched: [1:0.50]
; ZNVER1-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3] sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = shufflevector <4 x double> %a1, <4 x double> %2, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <8 x float> @test_unpckhps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) nounwind {
; GENERIC-LABEL: test_unpckhps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; GENERIC-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_unpckhps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; SANDY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_unpckhps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; HASWELL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_unpckhps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; BROADWELL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [7:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_unpckhps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; SKYLAKE-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_unpckhps:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; SKX-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_unpckhps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [2:1.00]
; BDVER2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [7:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_unpckhps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:1.00]
; BTVER2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_unpckhps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7] sched: [1:0.50]
; ZNVER1-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> %a1, <8 x i32> <i32 2, i32 10, i32 3, i32 11, i32 6, i32 14, i32 7, i32 15>
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = shufflevector <8 x float> %1, <8 x float> %2, <8 x i32> <i32 2, i32 10, i32 3, i32 11, i32 6, i32 14, i32 7, i32 15>
  ret <8 x float> %3
}

define <4 x double> @test_unpcklpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_unpcklpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; GENERIC-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_unpcklpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; SANDY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_unpcklpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; HASWELL-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_unpcklpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; BROADWELL-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_unpcklpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; SKYLAKE-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [8:1.00]
; SKYLAKE-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_unpcklpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; SKX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [8:1.00]
; SKX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_unpcklpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [2:1.00]
; BDVER2-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_unpcklpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:1.00]
; BTVER2-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_unpcklpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2] sched: [1:0.50]
; ZNVER1-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2] sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %2 = load <4 x double>, <4 x double> *%a2, align 32
  %3 = shufflevector <4 x double> %a1, <4 x double> %2, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %4 = fadd <4 x double> %1, %3
  ret <4 x double> %4
}

define <8 x float> @test_unpcklps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) nounwind {
; GENERIC-LABEL: test_unpcklps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; GENERIC-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_unpcklps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; SANDY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_unpcklps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; HASWELL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_unpcklps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; BROADWELL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [7:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_unpcklps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; SKYLAKE-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_unpcklps:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; SKX-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_unpcklps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [2:1.00]
; BDVER2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [7:1.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_unpcklps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:1.00]
; BTVER2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_unpcklps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5] sched: [1:0.50]
; ZNVER1-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <8 x float> %a0, <8 x float> %a1, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 4, i32 12, i32 5, i32 13>
  %2 = load <8 x float>, <8 x float> *%a2, align 32
  %3 = shufflevector <8 x float> %1, <8 x float> %2, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 4, i32 12, i32 5, i32 13>
  ret <8 x float> %3
}

define <4 x double> @test_xorpd(<4 x double> %a0, <4 x double> %a1, <4 x double> *%a2) {
; GENERIC-LABEL: test_xorpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_xorpd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_xorpd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_xorpd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_xorpd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_xorpd:
; SKX:       # %bb.0:
; SKX-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_xorpd:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_xorpd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_xorpd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vxorpd (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddpd %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x double> %a0 to <4 x i64>
  %2 = bitcast <4 x double> %a1 to <4 x i64>
  %3 = xor <4 x i64> %1, %2
  %4 = load <4 x double>, <4 x double> *%a2, align 32
  %5 = bitcast <4 x double> %4 to <4 x i64>
  %6 = xor <4 x i64> %3, %5
  %7 = bitcast <4 x i64> %6 to <4 x double>
  %8 = fadd <4 x double> %a1, %7
  ret <4 x double> %8
}

define <8 x float> @test_xorps(<8 x float> %a0, <8 x float> %a1, <8 x float> *%a2) {
; GENERIC-LABEL: test_xorps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_xorps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_xorps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; HASWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_xorps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BROADWELL-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_xorps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKYLAKE-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_xorps:
; SKX:       # %bb.0:
; SKX-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; SKX-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_xorps:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [5:2.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_xorps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; BTVER2-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [6:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_xorps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vxorps %ymm1, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vxorps (%rdi), %ymm0, %ymm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <8 x float> %a0 to <4 x i64>
  %2 = bitcast <8 x float> %a1 to <4 x i64>
  %3 = xor <4 x i64> %1, %2
  %4 = load <8 x float>, <8 x float> *%a2, align 32
  %5 = bitcast <8 x float> %4 to <4 x i64>
  %6 = xor <4 x i64> %3, %5
  %7 = bitcast <4 x i64> %6 to <8 x float>
  %8 = fadd <8 x float> %a1, %7
  ret <8 x float> %8
}

define void @test_zeroall() {
; GENERIC-LABEL: test_zeroall:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vzeroall # sched: [9:2.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_zeroall:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vzeroall # sched: [9:2.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_zeroall:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vzeroall # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_zeroall:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vzeroall # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_zeroall:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vzeroall # sched: [16:4.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_zeroall:
; SKX:       # %bb.0:
; SKX-NEXT:    vzeroall # sched: [12:5.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_zeroall:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vzeroall # sched: [90:8.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_zeroall:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vzeroall # sched: [90:36.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_zeroall:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vzeroall # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void @llvm.x86.avx.vzeroall()
  ret void
}
declare void @llvm.x86.avx.vzeroall() nounwind

define void @test_zeroupper() {
; GENERIC-LABEL: test_zeroupper:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_zeroupper:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vzeroupper # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_zeroupper:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vzeroupper # sched: [0:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_zeroupper:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vzeroupper # sched: [0:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_zeroupper:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vzeroupper # sched: [0:0.67]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_zeroupper:
; SKX:       # %bb.0:
; SKX-NEXT:    vzeroupper # sched: [0:0.67]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_zeroupper:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_zeroupper:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vzeroupper # sched: [46:18.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_zeroupper:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vzeroupper # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void @llvm.x86.avx.vzeroupper()
  ret void
}

define void @test_avx256_zero_idioms() {
; GENERIC-LABEL: test_avx256_zero_idioms:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:1.00]
; GENERIC-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:1.00]
; GENERIC-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_avx256_zero_idioms:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:1.00]
; SANDY-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:1.00]
; SANDY-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:1.00]
; SANDY-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_avx256_zero_idioms:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:1.00]
; HASWELL-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:1.00]
; HASWELL-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:1.00]
; HASWELL-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_avx256_zero_idioms:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:1.00]
; BROADWELL-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:1.00]
; BROADWELL-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_avx256_zero_idioms:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:0.33]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_avx256_zero_idioms:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:0.33]
; SKX-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:0.33]
; SKX-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:0.33]
; SKX-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:0.33]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BDVER2-LABEL: test_avx256_zero_idioms:
; BDVER2:       # %bb.0:
; BDVER2-NEXT:    #APP
; BDVER2-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [2:1.00]
; BDVER2-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [2:1.00]
; BDVER2-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [2:1.00]
; BDVER2-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [2:1.00]
; BDVER2-NEXT:    #NO_APP
; BDVER2-NEXT:    retq # sched: [5:1.00]
;
; BTVER2-LABEL: test_avx256_zero_idioms:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:0.50]
; BTVER2-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:0.50]
; BTVER2-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:0.50]
; BTVER2-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_avx256_zero_idioms:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    vxorps %ymm0, %ymm0, %ymm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vxorpd %ymm1, %ymm1, %ymm1 # sched: [1:0.25]
; ZNVER1-NEXT:    vandnps %ymm2, %ymm2, %ymm2 # sched: [1:0.25]
; ZNVER1-NEXT:    vandnpd %ymm3, %ymm3, %ymm3 # sched: [1:0.25]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void asm sideeffect "vxorps %ymm0, %ymm0, %ymm0\0Avxorpd %ymm1, %ymm1, %ymm1\0Avandnps %ymm2, %ymm2, %ymm2\0Avandnpd %ymm3, %ymm3, %ymm3", ""()
  ret void
}
declare void @llvm.x86.avx.vzeroupper() nounwind

!0 = !{i32 1}
