; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i386-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 -x86-experimental-vector-widening-legalization | FileCheck %s --check-prefix=X64_WIDEN
; RUN: llc < %s -mtriple=i386-unknown-unknown -mattr=+sse2 -x86-experimental-vector-widening-legalization | FileCheck %s --check-prefix=X86_WIDEN

define void @test_udiv7_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_udiv7_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; X64-NEXT:    shrq $32, %rcx
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    shrl $2, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; X64-NEXT:    shrq $32, %rdx
; X64-NEXT:    subl %edx, %ecx
; X64-NEXT:    shrl %ecx
; X64-NEXT:    addl %edx, %ecx
; X64-NEXT:    shrl $2, %ecx
; X64-NEXT:    movd %ecx, %xmm0
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_udiv7_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %esi
; X86-NEXT:    movl $613566757, %ebx # imm = 0x24924925
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    subl %edx, %esi
; X86-NEXT:    shrl %esi
; X86-NEXT:    addl %edx, %esi
; X86-NEXT:    shrl $2, %esi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    subl %edx, %ecx
; X86-NEXT:    shrl %ecx
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    shrl $2, %ecx
; X86-NEXT:    movd %ecx, %xmm0
; X86-NEXT:    movd %esi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%edi)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_udiv7_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    subl %ecx, %eax
; X64_WIDEN-NEXT:    shrl %eax
; X64_WIDEN-NEXT:    addl %ecx, %eax
; X64_WIDEN-NEXT:    shrl $2, %eax
; X64_WIDEN-NEXT:    movd %eax, %xmm1
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    subl %ecx, %eax
; X64_WIDEN-NEXT:    shrl %eax
; X64_WIDEN-NEXT:    addl %ecx, %eax
; X64_WIDEN-NEXT:    shrl $2, %eax
; X64_WIDEN-NEXT:    movd %eax, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm1, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_udiv7_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl (%eax), %ecx
; X86_WIDEN-NEXT:    movl 4(%eax), %esi
; X86_WIDEN-NEXT:    movl $613566757, %ebx # imm = 0x24924925
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    mull %ebx
; X86_WIDEN-NEXT:    subl %edx, %ecx
; X86_WIDEN-NEXT:    shrl %ecx
; X86_WIDEN-NEXT:    addl %edx, %ecx
; X86_WIDEN-NEXT:    shrl $2, %ecx
; X86_WIDEN-NEXT:    movl %esi, %eax
; X86_WIDEN-NEXT:    mull %ebx
; X86_WIDEN-NEXT:    subl %edx, %esi
; X86_WIDEN-NEXT:    shrl %esi
; X86_WIDEN-NEXT:    addl %edx, %esi
; X86_WIDEN-NEXT:    shrl $2, %esi
; X86_WIDEN-NEXT:    movl %esi, 4(%edi)
; X86_WIDEN-NEXT:    movl %ecx, (%edi)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = udiv <2 x i32> %a, <i32 7, i32 7>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_urem7_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_urem7_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; X64-NEXT:    shrq $32, %rdx
; X64-NEXT:    movl %ecx, %eax
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    addl %edx, %eax
; X64-NEXT:    shrl $2, %eax
; X64-NEXT:    leal (,%rax,8), %edx
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; X64-NEXT:    shrq $32, %rdx
; X64-NEXT:    movl %ecx, %edi
; X64-NEXT:    subl %edx, %edi
; X64-NEXT:    shrl %edi
; X64-NEXT:    addl %edx, %edi
; X64-NEXT:    shrl $2, %edi
; X64-NEXT:    leal (,%rdi,8), %edx
; X64-NEXT:    subl %edx, %edi
; X64-NEXT:    addl %ecx, %edi
; X64-NEXT:    movd %edi, %xmm0
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_urem7_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %esi
; X86-NEXT:    movl $613566757, %edi # imm = 0x24924925
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %esi, %ebx
; X86-NEXT:    subl %edx, %ebx
; X86-NEXT:    shrl %ebx
; X86-NEXT:    addl %edx, %ebx
; X86-NEXT:    shrl $2, %ebx
; X86-NEXT:    leal (,%ebx,8), %eax
; X86-NEXT:    subl %eax, %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    addl %esi, %ebx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    leal (,%eax,8), %edx
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movd %eax, %xmm0
; X86-NEXT:    movd %ebx, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%ebp)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_urem7_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    movl %eax, %edx
; X64_WIDEN-NEXT:    subl %ecx, %edx
; X64_WIDEN-NEXT:    shrl %edx
; X64_WIDEN-NEXT:    addl %ecx, %edx
; X64_WIDEN-NEXT:    shrl $2, %edx
; X64_WIDEN-NEXT:    leal (,%rdx,8), %ecx
; X64_WIDEN-NEXT:    subl %ecx, %edx
; X64_WIDEN-NEXT:    addl %eax, %edx
; X64_WIDEN-NEXT:    movd %edx, %xmm1
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    movl %eax, %edx
; X64_WIDEN-NEXT:    subl %ecx, %edx
; X64_WIDEN-NEXT:    shrl %edx
; X64_WIDEN-NEXT:    addl %ecx, %edx
; X64_WIDEN-NEXT:    shrl $2, %edx
; X64_WIDEN-NEXT:    leal (,%rdx,8), %ecx
; X64_WIDEN-NEXT:    subl %ecx, %edx
; X64_WIDEN-NEXT:    addl %eax, %edx
; X64_WIDEN-NEXT:    movd %edx, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm1, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_urem7_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebp
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl (%eax), %esi
; X86_WIDEN-NEXT:    movl 4(%eax), %ecx
; X86_WIDEN-NEXT:    movl $613566757, %ebx # imm = 0x24924925
; X86_WIDEN-NEXT:    movl %esi, %eax
; X86_WIDEN-NEXT:    mull %ebx
; X86_WIDEN-NEXT:    movl %esi, %ebp
; X86_WIDEN-NEXT:    subl %edx, %ebp
; X86_WIDEN-NEXT:    shrl %ebp
; X86_WIDEN-NEXT:    addl %edx, %ebp
; X86_WIDEN-NEXT:    shrl $2, %ebp
; X86_WIDEN-NEXT:    leal (,%ebp,8), %eax
; X86_WIDEN-NEXT:    subl %eax, %ebp
; X86_WIDEN-NEXT:    addl %esi, %ebp
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    mull %ebx
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    subl %edx, %eax
; X86_WIDEN-NEXT:    shrl %eax
; X86_WIDEN-NEXT:    addl %edx, %eax
; X86_WIDEN-NEXT:    shrl $2, %eax
; X86_WIDEN-NEXT:    leal (,%eax,8), %edx
; X86_WIDEN-NEXT:    subl %edx, %eax
; X86_WIDEN-NEXT:    addl %ecx, %eax
; X86_WIDEN-NEXT:    movl %eax, 4(%edi)
; X86_WIDEN-NEXT:    movl %ebp, (%edi)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    popl %ebp
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = urem <2 x i32> %a, <i32 7, i32 7>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_sdiv7_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_sdiv7_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    cltq
; X64-NEXT:    imulq $-1840700269, %rax, %rcx # imm = 0x92492493
; X64-NEXT:    shrq $32, %rcx
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    movl %eax, %ecx
; X64-NEXT:    shrl $31, %ecx
; X64-NEXT:    sarl $2, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    movslq %ecx, %rcx
; X64-NEXT:    imulq $-1840700269, %rcx, %rdx # imm = 0x92492493
; X64-NEXT:    shrq $32, %rdx
; X64-NEXT:    addl %edx, %ecx
; X64-NEXT:    movl %ecx, %edx
; X64-NEXT:    shrl $31, %edx
; X64-NEXT:    sarl $2, %ecx
; X64-NEXT:    addl %edx, %ecx
; X64-NEXT:    movd %ecx, %xmm0
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_sdiv7_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %esi
; X86-NEXT:    movl $-1840700269, %ebp # imm = 0x92492493
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    imull %ebp
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    addl %esi, %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    shrl $31, %eax
; X86-NEXT:    sarl $2, %edi
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    imull %ebp
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    shrl $31, %eax
; X86-NEXT:    sarl $2, %edx
; X86-NEXT:    addl %eax, %edx
; X86-NEXT:    movd %edx, %xmm0
; X86-NEXT:    movd %edi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%ebx)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_sdiv7_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    cltq
; X64_WIDEN-NEXT:    imulq $-1840700269, %rax, %rcx # imm = 0x92492493
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    addl %ecx, %eax
; X64_WIDEN-NEXT:    movl %eax, %ecx
; X64_WIDEN-NEXT:    shrl $31, %ecx
; X64_WIDEN-NEXT:    sarl $2, %eax
; X64_WIDEN-NEXT:    addl %ecx, %eax
; X64_WIDEN-NEXT:    movd %eax, %xmm1
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    cltq
; X64_WIDEN-NEXT:    imulq $-1840700269, %rax, %rcx # imm = 0x92492493
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    addl %ecx, %eax
; X64_WIDEN-NEXT:    movl %eax, %ecx
; X64_WIDEN-NEXT:    shrl $31, %ecx
; X64_WIDEN-NEXT:    sarl $2, %eax
; X64_WIDEN-NEXT:    addl %ecx, %eax
; X64_WIDEN-NEXT:    movd %eax, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm1, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_sdiv7_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebp
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl (%eax), %ecx
; X86_WIDEN-NEXT:    movl 4(%eax), %esi
; X86_WIDEN-NEXT:    movl $-1840700269, %ebp # imm = 0x92492493
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    imull %ebp
; X86_WIDEN-NEXT:    movl %edx, %edi
; X86_WIDEN-NEXT:    addl %ecx, %edi
; X86_WIDEN-NEXT:    movl %edi, %eax
; X86_WIDEN-NEXT:    shrl $31, %eax
; X86_WIDEN-NEXT:    sarl $2, %edi
; X86_WIDEN-NEXT:    addl %eax, %edi
; X86_WIDEN-NEXT:    movl %esi, %eax
; X86_WIDEN-NEXT:    imull %ebp
; X86_WIDEN-NEXT:    addl %esi, %edx
; X86_WIDEN-NEXT:    movl %edx, %eax
; X86_WIDEN-NEXT:    shrl $31, %eax
; X86_WIDEN-NEXT:    sarl $2, %edx
; X86_WIDEN-NEXT:    addl %eax, %edx
; X86_WIDEN-NEXT:    movl %edx, 4(%ebx)
; X86_WIDEN-NEXT:    movl %edi, (%ebx)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    popl %ebp
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = sdiv <2 x i32> %a, <i32 7, i32 7>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_srem7_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_srem7_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movslq %eax, %rcx
; X64-NEXT:    imulq $-1840700269, %rcx, %rax # imm = 0x92492493
; X64-NEXT:    shrq $32, %rax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    movl %eax, %edx
; X64-NEXT:    shrl $31, %edx
; X64-NEXT:    sarl $2, %eax
; X64-NEXT:    addl %edx, %eax
; X64-NEXT:    leal (,%rax,8), %edx
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    movslq %ecx, %rcx
; X64-NEXT:    imulq $-1840700269, %rcx, %rdx # imm = 0x92492493
; X64-NEXT:    shrq $32, %rdx
; X64-NEXT:    addl %ecx, %edx
; X64-NEXT:    movl %edx, %edi
; X64-NEXT:    shrl $31, %edi
; X64-NEXT:    sarl $2, %edx
; X64-NEXT:    addl %edi, %edx
; X64-NEXT:    leal (,%rdx,8), %edi
; X64-NEXT:    subl %edi, %edx
; X64-NEXT:    addl %ecx, %edx
; X64-NEXT:    movd %edx, %xmm0
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_srem7_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %esi
; X86-NEXT:    movl $-1840700269, %ebx # imm = 0x92492493
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    imull %ebx
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    addl %esi, %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    shrl $31, %eax
; X86-NEXT:    sarl $2, %edi
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    leal (,%edi,8), %eax
; X86-NEXT:    subl %eax, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    addl %esi, %edi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    imull %ebx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    shrl $31, %eax
; X86-NEXT:    sarl $2, %edx
; X86-NEXT:    addl %eax, %edx
; X86-NEXT:    leal (,%edx,8), %eax
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movd %edx, %xmm0
; X86-NEXT:    movd %edi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%ebp)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_srem7_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    cltq
; X64_WIDEN-NEXT:    imulq $-1840700269, %rax, %rcx # imm = 0x92492493
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    addl %eax, %ecx
; X64_WIDEN-NEXT:    movl %ecx, %edx
; X64_WIDEN-NEXT:    shrl $31, %edx
; X64_WIDEN-NEXT:    sarl $2, %ecx
; X64_WIDEN-NEXT:    addl %edx, %ecx
; X64_WIDEN-NEXT:    leal (,%rcx,8), %edx
; X64_WIDEN-NEXT:    subl %edx, %ecx
; X64_WIDEN-NEXT:    addl %eax, %ecx
; X64_WIDEN-NEXT:    movd %ecx, %xmm1
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    cltq
; X64_WIDEN-NEXT:    imulq $-1840700269, %rax, %rcx # imm = 0x92492493
; X64_WIDEN-NEXT:    shrq $32, %rcx
; X64_WIDEN-NEXT:    addl %eax, %ecx
; X64_WIDEN-NEXT:    movl %ecx, %edx
; X64_WIDEN-NEXT:    shrl $31, %edx
; X64_WIDEN-NEXT:    sarl $2, %ecx
; X64_WIDEN-NEXT:    addl %edx, %ecx
; X64_WIDEN-NEXT:    leal (,%rcx,8), %edx
; X64_WIDEN-NEXT:    subl %edx, %ecx
; X64_WIDEN-NEXT:    addl %eax, %ecx
; X64_WIDEN-NEXT:    movd %ecx, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm1, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_srem7_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebp
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl (%eax), %edi
; X86_WIDEN-NEXT:    movl 4(%eax), %ecx
; X86_WIDEN-NEXT:    movl $-1840700269, %ebp # imm = 0x92492493
; X86_WIDEN-NEXT:    movl %edi, %eax
; X86_WIDEN-NEXT:    imull %ebp
; X86_WIDEN-NEXT:    movl %edx, %esi
; X86_WIDEN-NEXT:    addl %edi, %esi
; X86_WIDEN-NEXT:    movl %esi, %eax
; X86_WIDEN-NEXT:    shrl $31, %eax
; X86_WIDEN-NEXT:    sarl $2, %esi
; X86_WIDEN-NEXT:    addl %eax, %esi
; X86_WIDEN-NEXT:    leal (,%esi,8), %eax
; X86_WIDEN-NEXT:    subl %eax, %esi
; X86_WIDEN-NEXT:    addl %edi, %esi
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    imull %ebp
; X86_WIDEN-NEXT:    addl %ecx, %edx
; X86_WIDEN-NEXT:    movl %edx, %eax
; X86_WIDEN-NEXT:    shrl $31, %eax
; X86_WIDEN-NEXT:    sarl $2, %edx
; X86_WIDEN-NEXT:    addl %eax, %edx
; X86_WIDEN-NEXT:    leal (,%edx,8), %eax
; X86_WIDEN-NEXT:    subl %eax, %edx
; X86_WIDEN-NEXT:    addl %ecx, %edx
; X86_WIDEN-NEXT:    movl %edx, 4(%ebx)
; X86_WIDEN-NEXT:    movl %esi, (%ebx)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    popl %ebp
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = srem <2 x i32> %a, <i32 7, i32 7>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_udiv_pow2_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_udiv_pow2_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pxor %xmm1, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    psrlq $3, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_udiv_pow2_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    pxor %xmm1, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    psrlq $3, %xmm0
; X86-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-NEXT:    movq %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_udiv_pow2_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    psrld $3, %xmm0
; X64_WIDEN-NEXT:    movq %xmm0, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_udiv_pow2_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86_WIDEN-NEXT:    psrld $3, %xmm0
; X86_WIDEN-NEXT:    movd %xmm0, (%eax)
; X86_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X86_WIDEN-NEXT:    movd %xmm0, 4(%eax)
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = udiv <2 x i32> %a, <i32 8, i32 8>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_urem_pow2_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_urem_pow2_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movl (%rdi), %eax
; X64-NEXT:    movl 4(%rdi), %ecx
; X64-NEXT:    movq %rcx, %xmm0
; X64-NEXT:    movq %rax, %xmm1
; X64-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; X64-NEXT:    pand {{.*}}(%rip), %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_urem_pow2_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; X86-NEXT:    pand {{\.LCPI.*}}, %xmm1
; X86-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; X86-NEXT:    movq %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_urem_pow2_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    andps {{.*}}(%rip), %xmm0
; X64_WIDEN-NEXT:    movlps %xmm0, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_urem_pow2_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86_WIDEN-NEXT:    pand {{\.LCPI.*}}, %xmm0
; X86_WIDEN-NEXT:    movd %xmm0, (%eax)
; X86_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X86_WIDEN-NEXT:    movd %xmm0, 4(%eax)
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = urem <2 x i32> %a, <i32 8, i32 8>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_sdiv_pow2_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_sdiv_pow2_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pxor %xmm1, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-NEXT:    psrad $31, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    psrlq $31, %xmm0
; X64-NEXT:    pand {{.*}}(%rip), %xmm0
; X64-NEXT:    psrlq $29, %xmm0
; X64-NEXT:    paddq %xmm2, %xmm0
; X64-NEXT:    psllq $32, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; X64-NEXT:    psrad $31, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; X64-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-NEXT:    psrlq $3, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_sdiv_pow2_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    pxor %xmm1, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-NEXT:    psrad $31, %xmm1
; X86-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,3,2,3]
; X86-NEXT:    movdqa %xmm0, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; X86-NEXT:    movdqa {{.*#+}} xmm2 = [0,2147483648,0,2147483648]
; X86-NEXT:    movdqa {{.*#+}} xmm3 = [31,0,31,0]
; X86-NEXT:    movdqa %xmm2, %xmm4
; X86-NEXT:    psrlq %xmm3, %xmm4
; X86-NEXT:    movl $31, %ecx
; X86-NEXT:    movd %ecx, %xmm5
; X86-NEXT:    psrlq %xmm5, %xmm2
; X86-NEXT:    movsd {{.*#+}} xmm2 = xmm4[0],xmm2[1]
; X86-NEXT:    movdqa %xmm1, %xmm4
; X86-NEXT:    psrlq %xmm3, %xmm4
; X86-NEXT:    psrlq %xmm5, %xmm1
; X86-NEXT:    movsd {{.*#+}} xmm1 = xmm4[0],xmm1[1]
; X86-NEXT:    xorpd %xmm2, %xmm1
; X86-NEXT:    psubq %xmm2, %xmm1
; X86-NEXT:    pand {{\.LCPI.*}}, %xmm1
; X86-NEXT:    psrlq $29, %xmm1
; X86-NEXT:    paddq %xmm0, %xmm1
; X86-NEXT:    psllq $32, %xmm1
; X86-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,3,2,3]
; X86-NEXT:    psrad $31, %xmm1
; X86-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    psrlq $3, %xmm0
; X86-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-NEXT:    movq %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_sdiv_pow2_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movdqa %xmm0, %xmm1
; X64_WIDEN-NEXT:    psrad $31, %xmm1
; X64_WIDEN-NEXT:    psrld $29, %xmm1
; X64_WIDEN-NEXT:    paddd %xmm0, %xmm1
; X64_WIDEN-NEXT:    psrad $3, %xmm1
; X64_WIDEN-NEXT:    movq %xmm1, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_sdiv_pow2_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86_WIDEN-NEXT:    movdqa %xmm0, %xmm1
; X86_WIDEN-NEXT:    psrad $31, %xmm1
; X86_WIDEN-NEXT:    psrld $29, %xmm1
; X86_WIDEN-NEXT:    paddd %xmm0, %xmm1
; X86_WIDEN-NEXT:    psrad $3, %xmm1
; X86_WIDEN-NEXT:    movd %xmm1, (%eax)
; X86_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; X86_WIDEN-NEXT:    movd %xmm0, 4(%eax)
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = sdiv <2 x i32> %a, <i32 8, i32 8>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_srem_pow2_v2i32(<2 x i32>* %x, <2 x i32>* %y) nounwind {
; X64-LABEL: test_srem_pow2_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pxor %xmm1, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    psrlq $3, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X64-NEXT:    movq %xmm0, (%rsi)
; X64-NEXT:    retq
;
; X86-LABEL: test_srem_pow2_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    pxor %xmm1, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    psrlq $3, %xmm0
; X86-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-NEXT:    movq %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_srem_pow2_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    psrld $3, %xmm0
; X64_WIDEN-NEXT:    movq %xmm0, (%rsi)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_srem_pow2_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86_WIDEN-NEXT:    psrld $3, %xmm0
; X86_WIDEN-NEXT:    movd %xmm0, (%eax)
; X86_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X86_WIDEN-NEXT:    movd %xmm0, 4(%eax)
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = udiv <2 x i32> %a, <i32 8, i32 8>
  store <2 x i32> %b, <2 x i32>* %y
  ret void
}

define void @test_udiv_v2i32(<2 x i32>* %x, <2 x i32>* %y, <2 x i32>* %z) nounwind {
; X64-LABEL: test_udiv_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,3,0,1]
; X64-NEXT:    movd %xmm2, %esi
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    divl %esi
; X64-NEXT:    movl %eax, %esi
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    movd %xmm1, %edi
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    divl %edi
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    movd %esi, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rcx)
; X64-NEXT:    retq
;
; X86-LABEL: test_udiv_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %eax
; X86-NEXT:    movd %xmm1, %ebx
; X86-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,0,1]
; X86-NEXT:    movd %xmm1, %esi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    divl %esi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    divl %ebx
; X86-NEXT:    movd %eax, %xmm0
; X86-NEXT:    movd %esi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%edi)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_udiv_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq %rdx, %rcx
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    movd %xmm1, %esi
; X64_WIDEN-NEXT:    xorl %edx, %edx
; X64_WIDEN-NEXT:    divl %esi
; X64_WIDEN-NEXT:    movd %eax, %xmm2
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %esi
; X64_WIDEN-NEXT:    xorl %edx, %edx
; X64_WIDEN-NEXT:    divl %esi
; X64_WIDEN-NEXT:    movd %eax, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm2, (%rcx)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_udiv_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movl (%ecx), %eax
; X86_WIDEN-NEXT:    movl 4(%ecx), %ecx
; X86_WIDEN-NEXT:    xorl %edx, %edx
; X86_WIDEN-NEXT:    divl (%ebx)
; X86_WIDEN-NEXT:    movl %eax, %esi
; X86_WIDEN-NEXT:    xorl %edx, %edx
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    divl 4(%ebx)
; X86_WIDEN-NEXT:    movl %eax, 4(%edi)
; X86_WIDEN-NEXT:    movl %esi, (%edi)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = load <2 x i32>, <2 x i32>* %y
  %c = udiv <2 x i32> %a, %b
  store <2 x i32> %c, <2 x i32>* %z
  ret void
}

define void @test_urem_v2i32(<2 x i32>* %x, <2 x i32>* %y, <2 x i32>* %z) nounwind {
; X64-LABEL: test_urem_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,3,0,1]
; X64-NEXT:    movd %xmm2, %esi
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    divl %esi
; X64-NEXT:    movl %edx, %esi
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    movd %xmm1, %edi
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    divl %edi
; X64-NEXT:    movd %edx, %xmm0
; X64-NEXT:    movd %esi, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rcx)
; X64-NEXT:    retq
;
; X86-LABEL: test_urem_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %eax
; X86-NEXT:    movd %xmm1, %ebx
; X86-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,0,1]
; X86-NEXT:    movd %xmm1, %esi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    divl %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    divl %ebx
; X86-NEXT:    movd %edx, %xmm0
; X86-NEXT:    movd %esi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%edi)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_urem_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq %rdx, %rcx
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    movd %xmm1, %esi
; X64_WIDEN-NEXT:    xorl %edx, %edx
; X64_WIDEN-NEXT:    divl %esi
; X64_WIDEN-NEXT:    movd %edx, %xmm2
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %esi
; X64_WIDEN-NEXT:    xorl %edx, %edx
; X64_WIDEN-NEXT:    divl %esi
; X64_WIDEN-NEXT:    movd %edx, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm2, (%rcx)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_urem_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movl (%ecx), %eax
; X86_WIDEN-NEXT:    movl 4(%ecx), %ecx
; X86_WIDEN-NEXT:    xorl %edx, %edx
; X86_WIDEN-NEXT:    divl (%ebx)
; X86_WIDEN-NEXT:    movl %edx, %esi
; X86_WIDEN-NEXT:    xorl %edx, %edx
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    divl 4(%ebx)
; X86_WIDEN-NEXT:    movl %edx, 4(%edi)
; X86_WIDEN-NEXT:    movl %esi, (%edi)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = load <2 x i32>, <2 x i32>* %y
  %c = urem <2 x i32> %a, %b
  store <2 x i32> %c, <2 x i32>* %z
  ret void
}

define void @test_sdiv_v2i32(<2 x i32>* %x, <2 x i32>* %y, <2 x i32>* %z) nounwind {
; X64-LABEL: test_sdiv_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,3,0,1]
; X64-NEXT:    movd %xmm2, %esi
; X64-NEXT:    cltd
; X64-NEXT:    idivl %esi
; X64-NEXT:    movl %eax, %esi
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    movd %xmm1, %edi
; X64-NEXT:    cltd
; X64-NEXT:    idivl %edi
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    movd %esi, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rcx)
; X64-NEXT:    retq
;
; X86-LABEL: test_sdiv_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %eax
; X86-NEXT:    movd %xmm1, %ebx
; X86-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,0,1]
; X86-NEXT:    movd %xmm1, %esi
; X86-NEXT:    cltd
; X86-NEXT:    idivl %esi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    cltd
; X86-NEXT:    idivl %ebx
; X86-NEXT:    movd %eax, %xmm0
; X86-NEXT:    movd %esi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%edi)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_sdiv_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq %rdx, %rcx
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    movd %xmm1, %esi
; X64_WIDEN-NEXT:    cltd
; X64_WIDEN-NEXT:    idivl %esi
; X64_WIDEN-NEXT:    movd %eax, %xmm2
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %esi
; X64_WIDEN-NEXT:    cltd
; X64_WIDEN-NEXT:    idivl %esi
; X64_WIDEN-NEXT:    movd %eax, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm2, (%rcx)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_sdiv_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movl (%ecx), %eax
; X86_WIDEN-NEXT:    movl 4(%ecx), %ecx
; X86_WIDEN-NEXT:    cltd
; X86_WIDEN-NEXT:    idivl (%ebx)
; X86_WIDEN-NEXT:    movl %eax, %esi
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    cltd
; X86_WIDEN-NEXT:    idivl 4(%ebx)
; X86_WIDEN-NEXT:    movl %eax, 4(%edi)
; X86_WIDEN-NEXT:    movl %esi, (%edi)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = load <2 x i32>, <2 x i32>* %y
  %c = sdiv <2 x i32> %a, %b
  store <2 x i32> %c, <2 x i32>* %z
  ret void
}

define void @test_srem_v2i32(<2 x i32>* %x, <2 x i32>* %y, <2 x i32>* %z) nounwind {
; X64-LABEL: test_srem_v2i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,3,0,1]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,3,0,1]
; X64-NEXT:    movd %xmm2, %esi
; X64-NEXT:    cltd
; X64-NEXT:    idivl %esi
; X64-NEXT:    movl %eax, %esi
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    movd %xmm1, %edi
; X64-NEXT:    cltd
; X64-NEXT:    idivl %edi
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    movd %esi, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    movq %xmm0, (%rcx)
; X64-NEXT:    retq
;
; X86-LABEL: test_srem_v2i32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    movd %xmm0, %ecx
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,0,1]
; X86-NEXT:    movd %xmm0, %eax
; X86-NEXT:    movd %xmm1, %ebx
; X86-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,0,1]
; X86-NEXT:    movd %xmm1, %esi
; X86-NEXT:    cltd
; X86-NEXT:    idivl %esi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    cltd
; X86-NEXT:    idivl %ebx
; X86-NEXT:    movd %eax, %xmm0
; X86-NEXT:    movd %esi, %xmm1
; X86-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-NEXT:    movq %xmm0, (%edi)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64_WIDEN-LABEL: test_srem_v2i32:
; X64_WIDEN:       # %bb.0:
; X64_WIDEN-NEXT:    movq %rdx, %rcx
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64_WIDEN-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    movd %xmm1, %esi
; X64_WIDEN-NEXT:    cltd
; X64_WIDEN-NEXT:    idivl %esi
; X64_WIDEN-NEXT:    movd %eax, %xmm2
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %eax
; X64_WIDEN-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; X64_WIDEN-NEXT:    movd %xmm0, %esi
; X64_WIDEN-NEXT:    cltd
; X64_WIDEN-NEXT:    idivl %esi
; X64_WIDEN-NEXT:    movd %eax, %xmm0
; X64_WIDEN-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64_WIDEN-NEXT:    movq %xmm2, (%rcx)
; X64_WIDEN-NEXT:    retq
;
; X86_WIDEN-LABEL: test_srem_v2i32:
; X86_WIDEN:       # %bb.0:
; X86_WIDEN-NEXT:    pushl %ebx
; X86_WIDEN-NEXT:    pushl %edi
; X86_WIDEN-NEXT:    pushl %esi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86_WIDEN-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86_WIDEN-NEXT:    movl (%ecx), %eax
; X86_WIDEN-NEXT:    movl 4(%ecx), %ecx
; X86_WIDEN-NEXT:    cltd
; X86_WIDEN-NEXT:    idivl (%ebx)
; X86_WIDEN-NEXT:    movl %eax, %esi
; X86_WIDEN-NEXT:    movl %ecx, %eax
; X86_WIDEN-NEXT:    cltd
; X86_WIDEN-NEXT:    idivl 4(%ebx)
; X86_WIDEN-NEXT:    movl %eax, 4(%edi)
; X86_WIDEN-NEXT:    movl %esi, (%edi)
; X86_WIDEN-NEXT:    popl %esi
; X86_WIDEN-NEXT:    popl %edi
; X86_WIDEN-NEXT:    popl %ebx
; X86_WIDEN-NEXT:    retl
  %a = load <2 x i32>, <2 x i32>* %x
  %b = load <2 x i32>, <2 x i32>* %y
  %c = sdiv <2 x i32> %a, %b
  store <2 x i32> %c, <2 x i32>* %z
  ret void
}
