; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=X64

define void @t1(float* %R, <4 x float>* %P1) nounwind {
; X32-LABEL: t1:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X32-NEXT:    movss %xmm0, (%eax)
; X32-NEXT:    retl
;
; X64-LABEL: t1:
; X64:       # %bb.0:
; X64-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    movss %xmm0, (%rdi)
; X64-NEXT:    retq
  %X = load <4 x float>, <4 x float>* %P1
  %tmp = extractelement <4 x float> %X, i32 3
  store float %tmp, float* %R
  ret void
}

define float @t2(<4 x float>* %P1) nounwind {
; X32-LABEL: t2:
; X32:       # %bb.0:
; X32-NEXT:    pushl %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X32-NEXT:    movss %xmm0, (%esp)
; X32-NEXT:    flds (%esp)
; X32-NEXT:    popl %eax
; X32-NEXT:    retl
;
; X64-LABEL: t2:
; X64:       # %bb.0:
; X64-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    retq
  %X = load <4 x float>, <4 x float>* %P1
  %tmp = extractelement <4 x float> %X, i32 2
  ret float %tmp
}

define void @t3(i32* %R, <4 x i32>* %P1) nounwind {
; X32-LABEL: t3:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl 12(%ecx), %ecx
; X32-NEXT:    movl %ecx, (%eax)
; X32-NEXT:    retl
;
; X64-LABEL: t3:
; X64:       # %bb.0:
; X64-NEXT:    movl 12(%rsi), %eax
; X64-NEXT:    movl %eax, (%rdi)
; X64-NEXT:    retq
  %X = load <4 x i32>, <4 x i32>* %P1
  %tmp = extractelement <4 x i32> %X, i32 3
  store i32 %tmp, i32* %R
  ret void
}

define i32 @t4(<4 x i32>* %P1) nounwind {
; X32-LABEL: t4:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 12(%eax), %eax
; X32-NEXT:    retl
;
; X64-LABEL: t4:
; X64:       # %bb.0:
; X64-NEXT:    movl 12(%rdi), %eax
; X64-NEXT:    retq
  %X = load <4 x i32>, <4 x i32>* %P1
  %tmp = extractelement <4 x i32> %X, i32 3
  ret i32 %tmp
}
