; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+sse4.2,+pclmul | FileCheck %s --check-prefixes=CHECK,GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm -mattr=-avx | FileCheck %s --check-prefixes=CHECK,SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,SANDY-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,SANDY-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,HASWELL-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,BROADWELL-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,BROADWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,SKYLAKE-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SKYLAKE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,SKX-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,BTVER2-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-avx  | FileCheck %s --check-prefixes=CHECK,ZNVER1-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,ZNVER1

define i32 @crc32_32_8(i32 %a0, i8 %a1, i8 *%a2) {
; GENERIC-LABEL: crc32_32_8:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl %edi, %eax # sched: [1:0.33]
; GENERIC-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; GENERIC-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: crc32_32_8:
; SLM:       # %bb.0:
; SLM-NEXT:    movl %edi, %eax # sched: [1:0.50]
; SLM-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SLM-NEXT:    crc32b (%rdx), %eax # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: crc32_32_8:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movl %edi, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: crc32_32_8:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl %edi, %eax # sched: [1:0.33]
; SANDY-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SANDY-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: crc32_32_8:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; HASWELL-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: crc32_32_8:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl %edi, %eax # sched: [1:0.25]
; HASWELL-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; HASWELL-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: crc32_32_8:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: crc32_32_8:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl %edi, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: crc32_32_8:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: crc32_32_8:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: crc32_32_8:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: crc32_32_8:
; SKX:       # %bb.0:
; SKX-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKX-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKX-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: crc32_32_8:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movl %edi, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    crc32b %sil, %eax # sched: [3:2.00]
; BTVER2-SSE-NEXT:    crc32b (%rdx), %eax # sched: [6:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: crc32_32_8:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl %edi, %eax # sched: [1:0.50]
; BTVER2-NEXT:    crc32b %sil, %eax # sched: [3:2.00]
; BTVER2-NEXT:    crc32b (%rdx), %eax # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: crc32_32_8:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    crc32b (%rdx), %eax # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: crc32_32_8:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl %edi, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; ZNVER1-NEXT:    crc32b (%rdx), %eax # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse42.crc32.32.8(i32 %a0, i8 %a1)
  %2 = load i8, i8 *%a2
  %3 = call i32 @llvm.x86.sse42.crc32.32.8(i32 %1, i8 %2)
  ret i32 %3
}
declare i32 @llvm.x86.sse42.crc32.32.8(i32, i8) nounwind

define i32 @crc32_32_16(i32 %a0, i16 %a1, i16 *%a2) {
; GENERIC-LABEL: crc32_32_16:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl %edi, %eax # sched: [1:0.33]
; GENERIC-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; GENERIC-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: crc32_32_16:
; SLM:       # %bb.0:
; SLM-NEXT:    movl %edi, %eax # sched: [1:0.50]
; SLM-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SLM-NEXT:    crc32w (%rdx), %eax # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: crc32_32_16:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movl %edi, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: crc32_32_16:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl %edi, %eax # sched: [1:0.33]
; SANDY-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SANDY-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: crc32_32_16:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; HASWELL-SSE-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: crc32_32_16:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl %edi, %eax # sched: [1:0.25]
; HASWELL-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; HASWELL-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: crc32_32_16:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: crc32_32_16:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl %edi, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: crc32_32_16:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: crc32_32_16:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: crc32_32_16:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: crc32_32_16:
; SKX:       # %bb.0:
; SKX-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKX-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; SKX-NEXT:    crc32w (%rdx), %eax # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: crc32_32_16:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movl %edi, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    crc32w %si, %eax # sched: [3:2.00]
; BTVER2-SSE-NEXT:    crc32w (%rdx), %eax # sched: [6:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: crc32_32_16:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl %edi, %eax # sched: [1:0.50]
; BTVER2-NEXT:    crc32w %si, %eax # sched: [3:2.00]
; BTVER2-NEXT:    crc32w (%rdx), %eax # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: crc32_32_16:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    crc32w (%rdx), %eax # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: crc32_32_16:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl %edi, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    crc32w %si, %eax # sched: [3:1.00]
; ZNVER1-NEXT:    crc32w (%rdx), %eax # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse42.crc32.32.16(i32 %a0, i16 %a1)
  %2 = load i16, i16 *%a2
  %3 = call i32 @llvm.x86.sse42.crc32.32.16(i32 %1, i16 %2)
  ret i32 %3
}
declare i32 @llvm.x86.sse42.crc32.32.16(i32, i16) nounwind

define i32 @crc32_32_32(i32 %a0, i32 %a1, i32 *%a2) {
; GENERIC-LABEL: crc32_32_32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl %edi, %eax # sched: [1:0.33]
; GENERIC-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; GENERIC-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: crc32_32_32:
; SLM:       # %bb.0:
; SLM-NEXT:    movl %edi, %eax # sched: [1:0.50]
; SLM-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SLM-NEXT:    crc32l (%rdx), %eax # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: crc32_32_32:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movl %edi, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: crc32_32_32:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl %edi, %eax # sched: [1:0.33]
; SANDY-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SANDY-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: crc32_32_32:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; HASWELL-SSE-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: crc32_32_32:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl %edi, %eax # sched: [1:0.25]
; HASWELL-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; HASWELL-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: crc32_32_32:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: crc32_32_32:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl %edi, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: crc32_32_32:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: crc32_32_32:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: crc32_32_32:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: crc32_32_32:
; SKX:       # %bb.0:
; SKX-NEXT:    movl %edi, %eax # sched: [1:0.25]
; SKX-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; SKX-NEXT:    crc32l (%rdx), %eax # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: crc32_32_32:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movl %edi, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    crc32l %esi, %eax # sched: [3:2.00]
; BTVER2-SSE-NEXT:    crc32l (%rdx), %eax # sched: [6:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: crc32_32_32:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl %edi, %eax # sched: [1:0.50]
; BTVER2-NEXT:    crc32l %esi, %eax # sched: [3:2.00]
; BTVER2-NEXT:    crc32l (%rdx), %eax # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: crc32_32_32:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movl %edi, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    crc32l (%rdx), %eax # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: crc32_32_32:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl %edi, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    crc32l %esi, %eax # sched: [3:1.00]
; ZNVER1-NEXT:    crc32l (%rdx), %eax # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse42.crc32.32.32(i32 %a0, i32 %a1)
  %2 = load i32, i32 *%a2
  %3 = call i32 @llvm.x86.sse42.crc32.32.32(i32 %1, i32 %2)
  ret i32 %3
}
declare i32 @llvm.x86.sse42.crc32.32.32(i32, i32) nounwind

define i64 @crc32_64_8(i64 %a0, i8 %a1, i8 *%a2) nounwind {
; GENERIC-LABEL: crc32_64_8:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movq %rdi, %rax # sched: [1:0.33]
; GENERIC-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; GENERIC-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: crc32_64_8:
; SLM:       # %bb.0:
; SLM-NEXT:    movq %rdi, %rax # sched: [1:0.50]
; SLM-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SLM-NEXT:    crc32b (%rdx), %eax # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: crc32_64_8:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.33]
; SANDY-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SANDY-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: crc32_64_8:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movq %rdi, %rax # sched: [1:0.33]
; SANDY-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SANDY-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: crc32_64_8:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; HASWELL-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: crc32_64_8:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; HASWELL-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; HASWELL-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: crc32_64_8:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: crc32_64_8:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; BROADWELL-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: crc32_64_8:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: crc32_64_8:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKYLAKE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: crc32_64_8:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKX-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKX-SSE-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: crc32_64_8:
; SKX:       # %bb.0:
; SKX-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKX-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; SKX-NEXT:    crc32b (%rdx), %eax # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: crc32_64_8:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    crc32b %sil, %eax # sched: [3:2.00]
; BTVER2-SSE-NEXT:    crc32b (%rdx), %eax # sched: [6:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: crc32_64_8:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movq %rdi, %rax # sched: [1:0.50]
; BTVER2-NEXT:    crc32b %sil, %eax # sched: [3:2.00]
; BTVER2-NEXT:    crc32b (%rdx), %eax # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: crc32_64_8:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    crc32b (%rdx), %eax # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: crc32_64_8:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; ZNVER1-NEXT:    crc32b %sil, %eax # sched: [3:1.00]
; ZNVER1-NEXT:    crc32b (%rdx), %eax # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i64 @llvm.x86.sse42.crc32.64.8(i64 %a0, i8 %a1)
  %2 = load i8, i8 *%a2
  %3 = call i64 @llvm.x86.sse42.crc32.64.8(i64 %1, i8 %2)
  ret i64 %3
}
declare i64 @llvm.x86.sse42.crc32.64.8(i64, i8) nounwind

define i64 @crc32_64_64(i64 %a0, i64 %a1, i64 *%a2) {
; GENERIC-LABEL: crc32_64_64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movq %rdi, %rax # sched: [1:0.33]
; GENERIC-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; GENERIC-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: crc32_64_64:
; SLM:       # %bb.0:
; SLM-NEXT:    movq %rdi, %rax # sched: [1:0.50]
; SLM-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SLM-NEXT:    crc32q (%rdx), %rax # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: crc32_64_64:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.33]
; SANDY-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SANDY-SSE-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: crc32_64_64:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movq %rdi, %rax # sched: [1:0.33]
; SANDY-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SANDY-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: crc32_64_64:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; HASWELL-SSE-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: crc32_64_64:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; HASWELL-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; HASWELL-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: crc32_64_64:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: crc32_64_64:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; BROADWELL-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; BROADWELL-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: crc32_64_64:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: crc32_64_64:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKYLAKE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SKYLAKE-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: crc32_64_64:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKX-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SKX-SSE-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: crc32_64_64:
; SKX:       # %bb.0:
; SKX-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; SKX-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; SKX-NEXT:    crc32q (%rdx), %rax # sched: [8:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: crc32_64_64:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:2.00]
; BTVER2-SSE-NEXT:    crc32q (%rdx), %rax # sched: [6:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: crc32_64_64:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movq %rdi, %rax # sched: [1:0.50]
; BTVER2-NEXT:    crc32q %rsi, %rax # sched: [3:2.00]
; BTVER2-NEXT:    crc32q (%rdx), %rax # sched: [6:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: crc32_64_64:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    crc32q (%rdx), %rax # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: crc32_64_64:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movq %rdi, %rax # sched: [1:0.25]
; ZNVER1-NEXT:    crc32q %rsi, %rax # sched: [3:1.00]
; ZNVER1-NEXT:    crc32q (%rdx), %rax # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i64 @llvm.x86.sse42.crc32.64.64(i64 %a0, i64 %a1)
  %2 = load i64, i64 *%a2
  %3 = call i64 @llvm.x86.sse42.crc32.64.64(i64 %1, i64 %2)
  ret i64 %3
}
declare i64 @llvm.x86.sse42.crc32.64.64(i64, i64) nounwind

define i32 @test_pcmpestri(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_pcmpestri:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl $7, %eax # sched: [1:0.33]
; GENERIC-NEXT:    movl $7, %edx # sched: [1:0.33]
; GENERIC-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [4:2.67]
; GENERIC-NEXT:    movl %ecx, %esi # sched: [1:0.33]
; GENERIC-NEXT:    movl $7, %eax # sched: [1:0.33]
; GENERIC-NEXT:    movl $7, %edx # sched: [1:0.33]
; GENERIC-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [4:2.33]
; GENERIC-NEXT:    # kill: def $ecx killed $ecx def $rcx
; GENERIC-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pcmpestri:
; SLM:       # %bb.0:
; SLM-NEXT:    movl $7, %eax # sched: [1:0.50]
; SLM-NEXT:    movl $7, %edx # sched: [1:0.50]
; SLM-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [21:21.00]
; SLM-NEXT:    movl $7, %eax # sched: [1:0.50]
; SLM-NEXT:    movl $7, %edx # sched: [1:0.50]
; SLM-NEXT:    movl %ecx, %esi # sched: [1:0.50]
; SLM-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [21:21.00]
; SLM-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SLM-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pcmpestri:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [4:2.67]
; SANDY-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.33]
; SANDY-SSE-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [4:2.33]
; SANDY-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SANDY-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pcmpestri:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [4:2.67]
; SANDY-NEXT:    movl %ecx, %esi # sched: [1:0.33]
; SANDY-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [4:2.33]
; SANDY-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SANDY-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pcmpestri:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; HASWELL-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [24:4.00]
; HASWELL-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; HASWELL-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pcmpestri:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; HASWELL-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; HASWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [24:4.00]
; HASWELL-NEXT:    # kill: def $ecx killed $ecx def $rcx
; HASWELL-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pcmpestri:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; BROADWELL-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [23:4.00]
; BROADWELL-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BROADWELL-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpestri:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; BROADWELL-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; BROADWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [23:4.00]
; BROADWELL-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BROADWELL-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pcmpestri:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; SKYLAKE-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [24:4.00]
; SKYLAKE-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKYLAKE-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpestri:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; SKYLAKE-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; SKYLAKE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [24:4.00]
; SKYLAKE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKYLAKE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pcmpestri:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; SKX-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; SKX-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [24:4.00]
; SKX-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKX-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpestri:
; SKX:       # %bb.0:
; SKX-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [18:4.00]
; SKX-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; SKX-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [24:4.00]
; SKX-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKX-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pcmpestri:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [14:5.00]
; BTVER2-SSE-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [19:5.00]
; BTVER2-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BTVER2-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pcmpestri:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [14:5.00]
; BTVER2-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-NEXT:    movl %ecx, %esi # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [19:5.00]
; BTVER2-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BTVER2-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pcmpestri:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pcmpestri $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pcmpestri $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; ZNVER1-SSE-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pcmpestri:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-NEXT:    vpcmpestri $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-NEXT:    movl %ecx, %esi # sched: [1:0.25]
; ZNVER1-NEXT:    vpcmpestri $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    # kill: def $ecx killed $ecx def $rcx
; ZNVER1-NEXT:    leal (%rcx,%rsi), %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %a0, i32 7, <16 x i8> %a1, i32 7, i8 7)
  %2 = load <16 x i8>, <16 x i8> *%a2, align 16
  %3 = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %a0, i32 7, <16 x i8> %2, i32 7, i8 7)
  %4 = add i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse42.pcmpestri128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define <16 x i8> @test_pcmpestrm(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_pcmpestrm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl $7, %eax # sched: [1:0.33]
; GENERIC-NEXT:    movl $7, %edx # sched: [1:0.33]
; GENERIC-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [11:2.67]
; GENERIC-NEXT:    movl $7, %eax # sched: [1:0.33]
; GENERIC-NEXT:    movl $7, %edx # sched: [1:0.33]
; GENERIC-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [11:2.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pcmpestrm:
; SLM:       # %bb.0:
; SLM-NEXT:    movl $7, %eax # sched: [1:0.50]
; SLM-NEXT:    movl $7, %edx # sched: [1:0.50]
; SLM-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [17:17.00]
; SLM-NEXT:    movl $7, %eax # sched: [1:0.50]
; SLM-NEXT:    movl $7, %edx # sched: [1:0.50]
; SLM-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [17:17.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pcmpestrm:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [11:2.67]
; SANDY-SSE-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [11:2.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pcmpestrm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [11:2.67]
; SANDY-NEXT:    movl $7, %eax # sched: [1:0.33]
; SANDY-NEXT:    movl $7, %edx # sched: [1:0.33]
; SANDY-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [11:2.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pcmpestrm:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; HASWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [25:4.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pcmpestrm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; HASWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; HASWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; HASWELL-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [25:4.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pcmpestrm:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; BROADWELL-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [24:4.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpestrm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; BROADWELL-NEXT:    movl $7, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    movl $7, %edx # sched: [1:0.25]
; BROADWELL-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [24:4.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pcmpestrm:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; SKYLAKE-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [25:4.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpestrm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; SKYLAKE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKYLAKE-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [25:4.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pcmpestrm:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; SKX-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [25:4.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpestrm:
; SKX:       # %bb.0:
; SKX-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [19:4.00]
; SKX-NEXT:    movl $7, %eax # sched: [1:0.25]
; SKX-NEXT:    movl $7, %edx # sched: [1:0.25]
; SKX-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [25:4.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pcmpestrm:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [14:5.00]
; BTVER2-SSE-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [19:5.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pcmpestrm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [14:5.00]
; BTVER2-NEXT:    movl $7, %eax # sched: [1:0.50]
; BTVER2-NEXT:    movl $7, %edx # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [19:5.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pcmpestrm:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pcmpestrm $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pcmpestrm $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pcmpestrm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-NEXT:    vpcmpestrm $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    movl $7, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    movl $7, %edx # sched: [1:0.25]
; ZNVER1-NEXT:    vpcmpestrm $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %a0, i32 7, <16 x i8> %a1, i32 7, i8 7)
  %2 = load <16 x i8>, <16 x i8> *%a2, align 16
  %3 = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %1, i32 7, <16 x i8> %2, i32 7, i8 7)
  ret <16 x i8> %3
}
declare <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define i32 @test_pcmpistri(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_pcmpistri:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; GENERIC-NEXT:    movl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [17:3.00]
; GENERIC-NEXT:    # kill: def $ecx killed $ecx def $rcx
; GENERIC-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pcmpistri:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [17:17.00]
; SLM-NEXT:    movl %ecx, %eax # sched: [1:0.50]
; SLM-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [17:17.00]
; SLM-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SLM-NEXT:    leal (%rcx,%rax), %eax # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pcmpistri:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; SANDY-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [17:3.00]
; SANDY-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SANDY-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pcmpistri:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; SANDY-NEXT:    movl %ecx, %eax # sched: [1:0.33]
; SANDY-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [17:3.00]
; SANDY-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SANDY-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pcmpistri:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; HASWELL-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [17:3.00]
; HASWELL-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; HASWELL-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pcmpistri:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; HASWELL-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; HASWELL-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [17:3.00]
; HASWELL-NEXT:    # kill: def $ecx killed $ecx def $rcx
; HASWELL-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pcmpistri:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; BROADWELL-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [16:3.00]
; BROADWELL-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BROADWELL-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpistri:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [11:3.00]
; BROADWELL-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [16:3.00]
; BROADWELL-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BROADWELL-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pcmpistri:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKYLAKE-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKYLAKE-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKYLAKE-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpistri:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKYLAKE-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKYLAKE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKYLAKE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pcmpistri:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKX-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKX-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKX-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpistri:
; SKX:       # %bb.0:
; SKX-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKX-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; SKX-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKX-NEXT:    # kill: def $ecx killed $ecx def $rcx
; SKX-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pcmpistri:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [7:2.00]
; BTVER2-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [12:2.00]
; BTVER2-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BTVER2-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pcmpistri:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [7:2.00]
; BTVER2-NEXT:    movl %ecx, %eax # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [12:2.00]
; BTVER2-NEXT:    # kill: def $ecx killed $ecx def $rcx
; BTVER2-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pcmpistri:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pcmpistri $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    pcmpistri $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    # kill: def $ecx killed $ecx def $rcx
; ZNVER1-SSE-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pcmpistri:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpcmpistri $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    movl %ecx, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    vpcmpistri $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    # kill: def $ecx killed $ecx def $rcx
; ZNVER1-NEXT:    leal (%rcx,%rax), %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %a0, <16 x i8> %a1, i8 7)
  %2 = load <16 x i8>, <16 x i8> *%a2, align 16
  %3 = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %a0, <16 x i8> %2, i8 7)
  %4 = add i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse42.pcmpistri128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define <16 x i8> @test_pcmpistrm(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> *%a2) {
; GENERIC-LABEL: test_pcmpistrm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; GENERIC-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [17:3.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pcmpistrm:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [13:13.00]
; SLM-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [13:13.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pcmpistrm:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; SANDY-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [17:3.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pcmpistrm:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; SANDY-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [17:3.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pcmpistrm:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; HASWELL-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [17:3.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pcmpistrm:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; HASWELL-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [17:3.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pcmpistrm:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; BROADWELL-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [16:3.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpistrm:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [11:3.00]
; BROADWELL-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [16:3.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pcmpistrm:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKYLAKE-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpistrm:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKYLAKE-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pcmpistrm:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKX-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpistrm:
; SKX:       # %bb.0:
; SKX-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [10:3.00]
; SKX-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [16:3.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pcmpistrm:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [8:2.00]
; BTVER2-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [13:2.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pcmpistrm:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [8:2.00]
; BTVER2-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [13:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pcmpistrm:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pcmpistrm $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    pcmpistrm $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pcmpistrm:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpcmpistrm $7, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vpcmpistrm $7, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %a0, <16 x i8> %a1, i8 7)
  %2 = load <16 x i8>, <16 x i8> *%a2, align 16
  %3 = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %1, <16 x i8> %2, i8 7)
  ret <16 x i8> %3
}
declare <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define <2 x i64> @test_pcmpgtq(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_pcmpgtq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pcmpgtq:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pcmpgtq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pcmpgtq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pcmpgtq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [11:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pcmpgtq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pcmpgtq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpgtq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pcmpgtq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [3:1.00]
; SKYLAKE-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [9:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpgtq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pcmpgtq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [3:1.00]
; SKX-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [9:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpgtq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SKX-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pcmpgtq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pcmpgtq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pcmpgtq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pcmpgtq %xmm1, %xmm0 # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    pcmpgtq (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pcmpgtq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; ZNVER1-NEXT:    vpcmpgtq (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = icmp sgt <2 x i64> %a0, %a1
  %2 = sext <2 x i1> %1 to <2 x i64>
  %3 = load <2 x i64>, <2 x i64>*%a2, align 16
  %4 = icmp sgt <2 x i64> %2, %3
  %5 = sext <2 x i1> %4 to <2 x i64>
  ret <2 x i64> %5
}

define <2 x i64> @test_pclmulqdq(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_pclmulqdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [14:6.00]
; GENERIC-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [14:5.67]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; SLM-LABEL: test_pclmulqdq:
; SLM:       # %bb.0:
; SLM-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [10:10.00]
; SLM-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [10:10.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_pclmulqdq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [14:6.00]
; SANDY-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [14:5.67]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_pclmulqdq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [14:6.00]
; SANDY-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [14:5.67]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_pclmulqdq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [11:2.00]
; HASWELL-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [17:2.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_pclmulqdq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [11:2.00]
; HASWELL-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [17:2.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_pclmulqdq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pclmulqdq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_pclmulqdq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [12:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pclmulqdq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [12:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_pclmulqdq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [6:1.00]
; SKX-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [12:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pclmulqdq:
; SKX:       # %bb.0:
; SKX-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [6:1.00]
; SKX-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [12:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_pclmulqdq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_pclmulqdq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_pclmulqdq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    pclmulqdq $0, %xmm1, %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    pclmulqdq $0, (%rdi), %xmm0 # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_pclmulqdq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    vpclmulqdq $0, (%rdi), %xmm0, %xmm0 # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <2 x i64>, <2 x i64> *%a2, align 16
  %2 = call <2 x i64> @llvm.x86.pclmulqdq(<2 x i64> %a0, <2 x i64> %a1, i8 0)
  %3 = call <2 x i64> @llvm.x86.pclmulqdq(<2 x i64> %1, <2 x i64> %2, i8 0)
  ret <2 x i64> %3
}
declare <2 x i64> @llvm.x86.pclmulqdq(<2 x i64>, <2 x i64>, i8)
