; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=-bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X86,NOBMI,X86-NOBMI
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X86,BMI1,X86-BMI1,BMI1NOTBM,X86-BMI1NOTBM
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+bmi,+tbm,-bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X86,BMI1,X86-BMI1,BMI1TBM,X86-BMI1TBM
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+bmi,+tbm,+bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X86,BMI1,X86-BMI1,BMI1BMI2,X86-BMI1BMI2,BMI1TBM,X86-BMI1TBM,BMI1TBMBMI2,X86-BMI1TBMBMI2
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+bmi,-tbm,+bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X86,BMI1,X86-BMI1,BMI1BMI2,X86-BMI1BMI2,BMI1NOTBMBMI2,X86-BMI1NOTBMBMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=-bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X64,NOBMI,X64-NOBMI
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X64,BMI1,X64-BMI1,BMI1NOTBM,X64-BMI1NOTBM
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,+tbm,-bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X64,BMI1,X64-BMI1,BMI1TBM,X64-BMI1TBM
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,+tbm,+bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X64,BMI1,X64-BMI1,BMI1BMI2,X64-BMI1BMI2,BMI1TBM,X64-BMI1TBM,BMI1TBMBMI2,X64-BMI1TBMBMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,-tbm,+bmi2 < %s | FileCheck %s --check-prefixes=CHECK,X64,BMI1,X64-BMI1,BMI1BMI2,X64-BMI1BMI2,BMI1NOTBMBMI2,X64-BMI1NOTBMBMI2

; *Please* keep in sync with test/CodeGen/AArch64/extract-bits.ll

; https://bugs.llvm.org/show_bug.cgi?id=36419
; https://bugs.llvm.org/show_bug.cgi?id=37603
; https://bugs.llvm.org/show_bug.cgi?id=37610

; Patterns:
;   a) (x >> start) &  (1 << nbits) - 1
;   b) (x >> start) & ~(-1 << nbits)
;   c) (x >> start) &  (-1 >> (32 - y))
;   d) (x >> start) << (32 - y) >> (32 - y)
; are equivalent.

declare void @use32(i32)
declare void @use64(i64)

; ---------------------------------------------------------------------------- ;
; Pattern a. 32-bit
; ---------------------------------------------------------------------------- ;

define i32 @bextr32_a0(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_a0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    decl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_a0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    decl %eax
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_a0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_a0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    decl %eax
; X64-NOBMI-NEXT:    andl %edi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_a0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    decl %eax
; X64-BMI1NOTBM-NEXT:    andl %edi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_a0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %onebit = shl i32 1, %numlowbits
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_a1_indexzext(i32 %val, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_a1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    decl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_a1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    decl %eax
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_a1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_a1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    decl %eax
; X64-NOBMI-NEXT:    andl %edi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_a1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    decl %eax
; X64-BMI1NOTBM-NEXT:    andl %edi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_a1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %conv = zext i8 %numlowbits to i32
  %onebit = shl i32 1, %conv
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_a2_load(i32* %w, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_a2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    decl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_a2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %esi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    decl %eax
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_a2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_a2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %esi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %esi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    decl %eax
; X64-NOBMI-NEXT:    andl %esi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_a2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %esi
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    decl %eax
; X64-BMI1NOTBM-NEXT:    andl %esi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_a2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %shifted = lshr i32 %val, %numskipbits
  %onebit = shl i32 1, %numlowbits
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_a3_load_indexzext(i32* %w, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_a3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    decl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_a3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %esi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    decl %eax
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_a3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_a3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %esi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %esi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    decl %eax
; X64-NOBMI-NEXT:    andl %esi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_a3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %esi
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    decl %eax
; X64-BMI1NOTBM-NEXT:    andl %esi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_a3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %conv = zext i8 %numlowbits to i32
  %onebit = shl i32 1, %conv
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_a4_commutative(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_a4_commutative:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    decl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_a4_commutative:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    decl %eax
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_a4_commutative:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_a4_commutative:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    decl %eax
; X64-NOBMI-NEXT:    andl %edi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_a4_commutative:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    decl %eax
; X64-BMI1NOTBM-NEXT:    andl %edi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_a4_commutative:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %onebit = shl i32 1, %numlowbits
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %shifted, %mask ; swapped order
  ret i32 %masked
}

define i32 @bextr32_a5_skipextrauses(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_a5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    pushl %eax
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    movl $1, %esi
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    decl %esi
; X86-NOBMI-NEXT:    andl %edi, %esi
; X86-NOBMI-NEXT:    movl %eax, (%esp)
; X86-NOBMI-NEXT:    calll use32
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    addl $4, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_a5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    pushl %eax
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    movl $1, %esi
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    decl %esi
; X86-BMI1NOTBM-NEXT:    andl %edi, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, (%esp)
; X86-BMI1NOTBM-NEXT:    calll use32
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    addl $4, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_a5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %edx, %esi
; X86-BMI1BMI2-NEXT:    movl %ecx, (%esp)
; X86-BMI1BMI2-NEXT:    calll use32
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    addl $8, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_a5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $1, %ebx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %ebx
; X64-NOBMI-NEXT:    decl %ebx
; X64-NOBMI-NEXT:    andl %edi, %ebx
; X64-NOBMI-NEXT:    movl %esi, %edi
; X64-NOBMI-NEXT:    callq use32
; X64-NOBMI-NEXT:    movl %ebx, %eax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_a5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $1, %ebx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X64-BMI1NOTBM-NEXT:    decl %ebx
; X64-BMI1NOTBM-NEXT:    andl %edi, %ebx
; X64-BMI1NOTBM-NEXT:    movl %esi, %edi
; X64-BMI1NOTBM-NEXT:    callq use32
; X64-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_a5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %ebx
; X64-BMI1BMI2-NEXT:    movl %esi, %edi
; X64-BMI1BMI2-NEXT:    callq use32
; X64-BMI1BMI2-NEXT:    movl %ebx, %eax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %onebit = shl i32 1, %numlowbits
  %mask = add nsw i32 %onebit, -1
  %masked = and i32 %mask, %shifted
  call void @use32(i32 %numskipbits)
  ret i32 %masked
}

; 64-bit

define i64 @bextr64_a0(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_a0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB6_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB6_2:
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shldl %cl, %eax, %edx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB6_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB6_4:
; X86-NOBMI-NEXT:    addl $-1, %eax
; X86-NOBMI-NEXT:    adcl $-1, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_a0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB6_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB6_2:
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:    movb %ch, %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %ch
; X86-BMI1NOTBM-NEXT:    je .LBB6_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB6_4:
; X86-BMI1NOTBM-NEXT:    addl $-1, %eax
; X86-BMI1NOTBM-NEXT:    adcl $-1, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_a0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB6_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB6_2:
; X86-BMI1BMI2-NEXT:    movl $1, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    movl %ebx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1BMI2-NEXT:    shlxl %ebx, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %bl
; X86-BMI1BMI2-NEXT:    je .LBB6_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:    xorl %eax, %eax
; X86-BMI1BMI2-NEXT:  .LBB6_4:
; X86-BMI1BMI2-NEXT:    addl $-1, %eax
; X86-BMI1BMI2-NEXT:    adcl $-1, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_a0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    decq %rax
; X64-NOBMI-NEXT:    andq %rdi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_a0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    decq %rax
; X64-BMI1NOTBM-NEXT:    andq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_a0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %onebit = shl i64 1, %numlowbits
  %mask = add nsw i64 %onebit, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_a1_indexzext(i64 %val, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_a1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB7_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB7_2:
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shldl %cl, %eax, %edx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB7_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB7_4:
; X86-NOBMI-NEXT:    addl $-1, %eax
; X86-NOBMI-NEXT:    adcl $-1, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_a1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB7_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB7_2:
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:    movb %ch, %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %ch
; X86-BMI1NOTBM-NEXT:    je .LBB7_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB7_4:
; X86-BMI1NOTBM-NEXT:    addl $-1, %eax
; X86-BMI1NOTBM-NEXT:    adcl $-1, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_a1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB7_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB7_2:
; X86-BMI1BMI2-NEXT:    movl $1, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    movl %ebx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1BMI2-NEXT:    shlxl %ebx, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %bl
; X86-BMI1BMI2-NEXT:    je .LBB7_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:    xorl %eax, %eax
; X86-BMI1BMI2-NEXT:  .LBB7_4:
; X86-BMI1BMI2-NEXT:    addl $-1, %eax
; X86-BMI1BMI2-NEXT:    adcl $-1, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_a1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    decq %rax
; X64-NOBMI-NEXT:    andq %rdi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_a1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    decq %rax
; X64-BMI1NOTBM-NEXT:    andq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_a1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %conv = zext i8 %numlowbits to i64
  %onebit = shl i64 1, %conv
  %mask = add nsw i64 %onebit, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_a2_load(i64* %w, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_a2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    movl 4(%eax), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB8_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB8_2:
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shldl %cl, %eax, %edx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB8_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB8_4:
; X86-NOBMI-NEXT:    addl $-1, %eax
; X86-NOBMI-NEXT:    adcl $-1, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_a2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %esi
; X86-BMI1NOTBM-NEXT:    movl 4(%eax), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB8_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB8_2:
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:    movb %ch, %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %ch
; X86-BMI1NOTBM-NEXT:    je .LBB8_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB8_4:
; X86-BMI1NOTBM-NEXT:    addl $-1, %eax
; X86-BMI1NOTBM-NEXT:    adcl $-1, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_a2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl (%eax), %esi
; X86-BMI1BMI2-NEXT:    movl 4(%eax), %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB8_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB8_2:
; X86-BMI1BMI2-NEXT:    movl $1, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    movl %ebx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1BMI2-NEXT:    shlxl %ebx, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %bl
; X86-BMI1BMI2-NEXT:    je .LBB8_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:    xorl %eax, %eax
; X86-BMI1BMI2-NEXT:  .LBB8_4:
; X86-BMI1BMI2-NEXT:    addl $-1, %eax
; X86-BMI1BMI2-NEXT:    adcl $-1, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_a2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq (%rdi), %rsi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rsi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    decq %rax
; X64-NOBMI-NEXT:    andq %rsi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_a2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rsi
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rsi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    decq %rax
; X64-BMI1NOTBM-NEXT:    andq %rsi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_a2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %shifted = lshr i64 %val, %numskipbits
  %onebit = shl i64 1, %numlowbits
  %mask = add nsw i64 %onebit, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_a3_load_indexzext(i64* %w, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_a3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    movl 4(%eax), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB9_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB9_2:
; X86-NOBMI-NEXT:    movl $1, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shldl %cl, %eax, %edx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB9_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB9_4:
; X86-NOBMI-NEXT:    addl $-1, %eax
; X86-NOBMI-NEXT:    adcl $-1, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_a3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %esi
; X86-BMI1NOTBM-NEXT:    movl 4(%eax), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB9_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB9_2:
; X86-BMI1NOTBM-NEXT:    movl $1, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:    movb %ch, %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %ch
; X86-BMI1NOTBM-NEXT:    je .LBB9_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB9_4:
; X86-BMI1NOTBM-NEXT:    addl $-1, %eax
; X86-BMI1NOTBM-NEXT:    adcl $-1, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_a3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl (%eax), %esi
; X86-BMI1BMI2-NEXT:    movl 4(%eax), %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB9_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB9_2:
; X86-BMI1BMI2-NEXT:    movl $1, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    movl %ebx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %edx
; X86-BMI1BMI2-NEXT:    shlxl %ebx, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %bl
; X86-BMI1BMI2-NEXT:    je .LBB9_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:    xorl %eax, %eax
; X86-BMI1BMI2-NEXT:  .LBB9_4:
; X86-BMI1BMI2-NEXT:    addl $-1, %eax
; X86-BMI1BMI2-NEXT:    adcl $-1, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_a3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movq (%rdi), %rsi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rsi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    decq %rax
; X64-NOBMI-NEXT:    andq %rsi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_a3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rsi
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rsi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    decq %rax
; X64-BMI1NOTBM-NEXT:    andq %rsi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_a3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %conv = zext i8 %numlowbits to i64
  %onebit = shl i64 1, %conv
  %mask = add nsw i64 %onebit, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_a4_commutative(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_a4_commutative:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl %esi, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB10_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB10_2:
; X86-NOBMI-NEXT:    movl $1, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shldl %cl, %esi, %edi
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB10_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %esi, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:  .LBB10_4:
; X86-NOBMI-NEXT:    addl $-1, %esi
; X86-NOBMI-NEXT:    adcl $-1, %edi
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_a4_commutative:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl %esi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %esi, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB10_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB10_2:
; X86-BMI1NOTBM-NEXT:    movl $1, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:    movb %ch, %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %esi, %edi
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %ch
; X86-BMI1NOTBM-NEXT:    je .LBB10_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %esi, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:  .LBB10_4:
; X86-BMI1NOTBM-NEXT:    addl $-1, %esi
; X86-BMI1NOTBM-NEXT:    adcl $-1, %edi
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_a4_commutative:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB10_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB10_2:
; X86-BMI1BMI2-NEXT:    movl $1, %edi
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:    movl %ebx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %esi
; X86-BMI1BMI2-NEXT:    shlxl %ebx, %edi, %ecx
; X86-BMI1BMI2-NEXT:    testb $32, %bl
; X86-BMI1BMI2-NEXT:    je .LBB10_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ecx, %esi
; X86-BMI1BMI2-NEXT:    xorl %ecx, %ecx
; X86-BMI1BMI2-NEXT:  .LBB10_4:
; X86-BMI1BMI2-NEXT:    addl $-1, %ecx
; X86-BMI1BMI2-NEXT:    adcl $-1, %esi
; X86-BMI1BMI2-NEXT:    andl %ecx, %eax
; X86-BMI1BMI2-NEXT:    andl %esi, %edx
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_a4_commutative:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movl $1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    decq %rax
; X64-NOBMI-NEXT:    andq %rdi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_a4_commutative:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movl $1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    decq %rax
; X64-BMI1NOTBM-NEXT:    andq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_a4_commutative:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %onebit = shl i64 1, %numlowbits
  %mask = add nsw i64 %onebit, -1
  %masked = and i64 %shifted, %mask ; swapped order
  ret i64 %masked
}

define i64 @bextr64_a5_skipextrauses(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_a5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebp
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    subl $12, %esp
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %esi, %ebp
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %ebp
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %ebx
; X86-NOBMI-NEXT:    testb $32, %al
; X86-NOBMI-NEXT:    je .LBB11_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %ebp, %ebx
; X86-NOBMI-NEXT:    xorl %ebp, %ebp
; X86-NOBMI-NEXT:  .LBB11_2:
; X86-NOBMI-NEXT:    movl $1, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shldl %cl, %esi, %edi
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    testb $32, %dl
; X86-NOBMI-NEXT:    je .LBB11_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %esi, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:  .LBB11_4:
; X86-NOBMI-NEXT:    addl $-1, %esi
; X86-NOBMI-NEXT:    adcl $-1, %edi
; X86-NOBMI-NEXT:    andl %ebx, %esi
; X86-NOBMI-NEXT:    andl %ebp, %edi
; X86-NOBMI-NEXT:    subl $8, %esp
; X86-NOBMI-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NOBMI-NEXT:    pushl %eax
; X86-NOBMI-NEXT:    calll use64
; X86-NOBMI-NEXT:    addl $16, %esp
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    movl %edi, %edx
; X86-NOBMI-NEXT:    addl $12, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    popl %ebp
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_a5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebp
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    subl $12, %esp
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %esi, %ebp
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %ebp
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %esi, %ebx
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB11_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %ebp, %ebx
; X86-BMI1NOTBM-NEXT:    xorl %ebp, %ebp
; X86-BMI1NOTBM-NEXT:  .LBB11_2:
; X86-BMI1NOTBM-NEXT:    movl $1, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %esi, %edi
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %dl
; X86-BMI1NOTBM-NEXT:    je .LBB11_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %esi, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:  .LBB11_4:
; X86-BMI1NOTBM-NEXT:    addl $-1, %esi
; X86-BMI1NOTBM-NEXT:    adcl $-1, %edi
; X86-BMI1NOTBM-NEXT:    andl %ebx, %esi
; X86-BMI1NOTBM-NEXT:    andl %ebp, %edi
; X86-BMI1NOTBM-NEXT:    subl $8, %esp
; X86-BMI1NOTBM-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-BMI1NOTBM-NEXT:    pushl %eax
; X86-BMI1NOTBM-NEXT:    calll use64
; X86-BMI1NOTBM-NEXT:    addl $16, %esp
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    addl $12, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    popl %ebp
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_a5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebp
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $12, %esp
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %ebx
; X86-BMI1BMI2-NEXT:    shrxl %eax, %esi, %ebp
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB11_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %ebp, %ebx
; X86-BMI1BMI2-NEXT:    xorl %ebp, %ebp
; X86-BMI1BMI2-NEXT:  .LBB11_2:
; X86-BMI1BMI2-NEXT:    movl $1, %edi
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:    movl %edx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %esi
; X86-BMI1BMI2-NEXT:    shlxl %edx, %edi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %dl
; X86-BMI1BMI2-NEXT:    je .LBB11_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB11_4:
; X86-BMI1BMI2-NEXT:    addl $-1, %edi
; X86-BMI1BMI2-NEXT:    adcl $-1, %esi
; X86-BMI1BMI2-NEXT:    andl %ebx, %edi
; X86-BMI1BMI2-NEXT:    andl %ebp, %esi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-BMI1BMI2-NEXT:    pushl %eax
; X86-BMI1BMI2-NEXT:    calll use64
; X86-BMI1BMI2-NEXT:    addl $16, %esp
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:    movl %esi, %edx
; X86-BMI1BMI2-NEXT:    addl $12, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    popl %ebp
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_a5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movl $1, %ebx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rbx
; X64-NOBMI-NEXT:    decq %rbx
; X64-NOBMI-NEXT:    andq %rdi, %rbx
; X64-NOBMI-NEXT:    movq %rsi, %rdi
; X64-NOBMI-NEXT:    callq use64
; X64-NOBMI-NEXT:    movq %rbx, %rax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_a5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movl $1, %ebx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    decq %rbx
; X64-BMI1NOTBM-NEXT:    andq %rdi, %rbx
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rdi
; X64-BMI1NOTBM-NEXT:    callq use64
; X64-BMI1NOTBM-NEXT:    movq %rbx, %rax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_a5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rbx
; X64-BMI1BMI2-NEXT:    movq %rsi, %rdi
; X64-BMI1BMI2-NEXT:    callq use64
; X64-BMI1BMI2-NEXT:    movq %rbx, %rax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %onebit = shl i64 1, %numlowbits
  %mask = add nsw i64 %onebit, -1
  %masked = and i64 %mask, %shifted
  call void @use64(i64 %numskipbits)
  ret i64 %masked
}

; ---------------------------------------------------------------------------- ;
; Pattern b. 32-bit
; ---------------------------------------------------------------------------- ;

define i32 @bextr32_b0(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_b0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_b0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    andnl %edx, %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_b0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_b0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $-1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    notl %eax
; X64-NOBMI-NEXT:    andl %edi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_b0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $-1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    andnl %edi, %eax, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_b0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %notmask = shl i32 -1, %numlowbits
  %mask = xor i32 %notmask, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_b1_indexzext(i32 %val, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_b1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_b1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    andnl %edx, %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_b1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_b1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $-1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    notl %eax
; X64-NOBMI-NEXT:    andl %edi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_b1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $-1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    andnl %edi, %eax, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_b1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %conv = zext i8 %numlowbits to i32
  %notmask = shl i32 -1, %conv
  %mask = xor i32 %notmask, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_b2_load(i32* %w, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_b2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_b2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl (%edx), %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    andnl %edx, %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_b2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_b2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %esi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %esi
; X64-NOBMI-NEXT:    movl $-1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    notl %eax
; X64-NOBMI-NEXT:    andl %esi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_b2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    movl $-1, %esi
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %esi
; X64-BMI1NOTBM-NEXT:    andnl %eax, %esi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_b2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %shifted = lshr i32 %val, %numskipbits
  %notmask = shl i32 -1, %numlowbits
  %mask = xor i32 %notmask, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_b3_load_indexzext(i32* %w, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_b3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_b3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl (%edx), %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    andnl %edx, %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_b3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_b3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %esi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %esi
; X64-NOBMI-NEXT:    movl $-1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    notl %eax
; X64-NOBMI-NEXT:    andl %esi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_b3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    movl $-1, %esi
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %esi
; X64-BMI1NOTBM-NEXT:    andnl %eax, %esi, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_b3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %conv = zext i8 %numlowbits to i32
  %notmask = shl i32 -1, %conv
  %mask = xor i32 %notmask, -1
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_b4_commutative(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_b4_commutative:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_b4_commutative:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    andnl %edx, %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_b4_commutative:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_b4_commutative:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $-1, %eax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    notl %eax
; X64-NOBMI-NEXT:    andl %edi, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_b4_commutative:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $-1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    andnl %edi, %eax, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_b4_commutative:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %notmask = shl i32 -1, %numlowbits
  %mask = xor i32 %notmask, -1
  %masked = and i32 %shifted, %mask ; swapped order
  ret i32 %masked
}

define i32 @bextr32_b5_skipextrauses(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_b5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    pushl %eax
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    movl $-1, %esi
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    notl %esi
; X86-NOBMI-NEXT:    andl %edi, %esi
; X86-NOBMI-NEXT:    movl %eax, (%esp)
; X86-NOBMI-NEXT:    calll use32
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    addl $4, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_b5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    pushl %eax
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %edi
; X86-BMI1NOTBM-NEXT:    andnl %esi, %edi, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, (%esp)
; X86-BMI1NOTBM-NEXT:    calll use32
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    addl $4, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_b5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %edx, %esi
; X86-BMI1BMI2-NEXT:    movl %ecx, (%esp)
; X86-BMI1BMI2-NEXT:    calll use32
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    addl $8, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_b5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrl %cl, %edi
; X64-NOBMI-NEXT:    movl $-1, %ebx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %ebx
; X64-NOBMI-NEXT:    notl %ebx
; X64-NOBMI-NEXT:    andl %edi, %ebx
; X64-NOBMI-NEXT:    movl %esi, %edi
; X64-NOBMI-NEXT:    callq use32
; X64-NOBMI-NEXT:    movl %ebx, %eax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_b5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X64-BMI1NOTBM-NEXT:    movl $-1, %eax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    andnl %edi, %eax, %ebx
; X64-BMI1NOTBM-NEXT:    movl %esi, %edi
; X64-BMI1NOTBM-NEXT:    callq use32
; X64-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_b5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %ebx
; X64-BMI1BMI2-NEXT:    movl %esi, %edi
; X64-BMI1BMI2-NEXT:    callq use32
; X64-BMI1BMI2-NEXT:    movl %ebx, %eax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %notmask = shl i32 -1, %numlowbits
  %mask = xor i32 %notmask, -1
  %masked = and i32 %mask, %shifted
  call void @use32(i32 %numskipbits)
  ret i32 %masked
}

; 64-bit

define i64 @bextr64_b0(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_b0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB18_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB18_2:
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    shldl %cl, %edx, %edx
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB18_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB18_4:
; X86-NOBMI-NEXT:    notl %edx
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_b0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB18_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB18_2:
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebx
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB18_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %ebx, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB18_4:
; X86-BMI1NOTBM-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1NOTBM-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_b0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB18_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB18_2:
; X86-BMI1BMI2-NEXT:    movl $-1, %edi
; X86-BMI1BMI2-NEXT:    shlxl %eax, %edi, %ebx
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB18_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edi
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB18_4:
; X86-BMI1BMI2-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1BMI2-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_b0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movq $-1, %rax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    notq %rax
; X64-NOBMI-NEXT:    andq %rdi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_b0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movq $-1, %rax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    andnq %rdi, %rax, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_b0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %notmask = shl i64 -1, %numlowbits
  %mask = xor i64 %notmask, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_b1_indexzext(i64 %val, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_b1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB19_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB19_2:
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    shldl %cl, %edx, %edx
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB19_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB19_4:
; X86-NOBMI-NEXT:    notl %edx
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_b1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB19_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB19_2:
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebx
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB19_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %ebx, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB19_4:
; X86-BMI1NOTBM-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1NOTBM-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_b1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB19_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB19_2:
; X86-BMI1BMI2-NEXT:    movl $-1, %edi
; X86-BMI1BMI2-NEXT:    shlxl %eax, %edi, %ebx
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB19_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edi
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB19_4:
; X86-BMI1BMI2-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1BMI2-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_b1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movq $-1, %rax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    notq %rax
; X64-NOBMI-NEXT:    andq %rdi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_b1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movq $-1, %rax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    andnq %rdi, %rax, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_b1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %conv = zext i8 %numlowbits to i64
  %notmask = shl i64 -1, %conv
  %mask = xor i64 %notmask, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_b2_load(i64* %w, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_b2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    movl 4(%eax), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB20_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB20_2:
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    shldl %cl, %edx, %edx
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB20_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB20_4:
; X86-NOBMI-NEXT:    notl %edx
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_b2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl (%edx), %esi
; X86-BMI1NOTBM-NEXT:    movl 4(%edx), %edi
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB20_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB20_2:
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebx
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB20_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %ebx, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB20_4:
; X86-BMI1NOTBM-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1NOTBM-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_b2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    movl (%edx), %esi
; X86-BMI1BMI2-NEXT:    movl 4(%edx), %edi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edi, %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB20_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB20_2:
; X86-BMI1BMI2-NEXT:    movl $-1, %edi
; X86-BMI1BMI2-NEXT:    shlxl %eax, %edi, %ebx
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB20_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edi
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB20_4:
; X86-BMI1BMI2-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1BMI2-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_b2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq (%rdi), %rsi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rsi
; X64-NOBMI-NEXT:    movq $-1, %rax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    notq %rax
; X64-NOBMI-NEXT:    andq %rsi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_b2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    movq $-1, %rsi
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rsi
; X64-BMI1NOTBM-NEXT:    andnq %rax, %rsi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_b2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %shifted = lshr i64 %val, %numskipbits
  %notmask = shl i64 -1, %numlowbits
  %mask = xor i64 %notmask, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_b3_load_indexzext(i64* %w, i8 zeroext %numskipbits, i8 zeroext %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_b3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    movl 4(%eax), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB21_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB21_2:
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    shldl %cl, %edx, %edx
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB21_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB21_4:
; X86-NOBMI-NEXT:    notl %edx
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    notl %eax
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_b3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl (%edx), %esi
; X86-BMI1NOTBM-NEXT:    movl 4(%edx), %edi
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB21_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB21_2:
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebx
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB21_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %ebx, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB21_4:
; X86-BMI1NOTBM-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1NOTBM-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_b3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    movl (%edx), %esi
; X86-BMI1BMI2-NEXT:    movl 4(%edx), %edi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edi, %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB21_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB21_2:
; X86-BMI1BMI2-NEXT:    movl $-1, %edi
; X86-BMI1BMI2-NEXT:    shlxl %eax, %edi, %ebx
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB21_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edi
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB21_4:
; X86-BMI1BMI2-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1BMI2-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_b3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movq (%rdi), %rsi
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rsi
; X64-NOBMI-NEXT:    movq $-1, %rax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    notq %rax
; X64-NOBMI-NEXT:    andq %rsi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_b3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    movq $-1, %rsi
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rsi
; X64-BMI1NOTBM-NEXT:    andnq %rax, %rsi, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_b3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %conv = zext i8 %numlowbits to i64
  %notmask = shl i64 -1, %conv
  %mask = xor i64 %notmask, -1
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_b4_commutative(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_b4_commutative:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl %esi, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB22_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB22_2:
; X86-NOBMI-NEXT:    movl $-1, %edi
; X86-NOBMI-NEXT:    movl $-1, %esi
; X86-NOBMI-NEXT:    movb %ch, %cl
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    shldl %cl, %edi, %edi
; X86-NOBMI-NEXT:    testb $32, %ch
; X86-NOBMI-NEXT:    je .LBB22_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %esi, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:  .LBB22_4:
; X86-NOBMI-NEXT:    notl %edi
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    notl %esi
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_b4_commutative:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB22_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB22_2:
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebx
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB22_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %ebx, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB22_4:
; X86-BMI1NOTBM-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1NOTBM-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_b4_commutative:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB22_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB22_2:
; X86-BMI1BMI2-NEXT:    movl $-1, %edi
; X86-BMI1BMI2-NEXT:    shlxl %eax, %edi, %ebx
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB22_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edi
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB22_4:
; X86-BMI1BMI2-NEXT:    andnl %edx, %edi, %edx
; X86-BMI1BMI2-NEXT:    andnl %esi, %ebx, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_b4_commutative:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movq $-1, %rax
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    notq %rax
; X64-NOBMI-NEXT:    andq %rdi, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_b4_commutative:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movq $-1, %rax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    andnq %rdi, %rax, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_b4_commutative:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %notmask = shl i64 -1, %numlowbits
  %mask = xor i64 %notmask, -1
  %masked = and i64 %shifted, %mask ; swapped order
  ret i64 %masked
}

define i64 @bextr64_b5_skipextrauses(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_b5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebp
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    subl $12, %esp
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %esi, %ebp
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %ebp
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %ebx
; X86-NOBMI-NEXT:    testb $32, %al
; X86-NOBMI-NEXT:    je .LBB23_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %ebp, %ebx
; X86-NOBMI-NEXT:    xorl %ebp, %ebp
; X86-NOBMI-NEXT:  .LBB23_2:
; X86-NOBMI-NEXT:    movl $-1, %esi
; X86-NOBMI-NEXT:    movl $-1, %edi
; X86-NOBMI-NEXT:    movl %edx, %ecx
; X86-NOBMI-NEXT:    shll %cl, %edi
; X86-NOBMI-NEXT:    shldl %cl, %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %dl
; X86-NOBMI-NEXT:    je .LBB23_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB23_4:
; X86-NOBMI-NEXT:    notl %esi
; X86-NOBMI-NEXT:    andl %ebp, %esi
; X86-NOBMI-NEXT:    notl %edi
; X86-NOBMI-NEXT:    andl %ebx, %edi
; X86-NOBMI-NEXT:    subl $8, %esp
; X86-NOBMI-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NOBMI-NEXT:    pushl %eax
; X86-NOBMI-NEXT:    calll use64
; X86-NOBMI-NEXT:    addl $16, %esp
; X86-NOBMI-NEXT:    movl %edi, %eax
; X86-NOBMI-NEXT:    movl %esi, %edx
; X86-NOBMI-NEXT:    addl $12, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    popl %ebp
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_b5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebp
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    subl $12, %esp
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %ebx, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %ebx, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB23_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %esi, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:  .LBB23_2:
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebx
; X86-BMI1NOTBM-NEXT:    movl $-1, %ebp
; X86-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebp
; X86-BMI1NOTBM-NEXT:    shldl %cl, %ebx, %ebx
; X86-BMI1NOTBM-NEXT:    testb $32, %dl
; X86-BMI1NOTBM-NEXT:    je .LBB23_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %ebp, %ebx
; X86-BMI1NOTBM-NEXT:    xorl %ebp, %ebp
; X86-BMI1NOTBM-NEXT:  .LBB23_4:
; X86-BMI1NOTBM-NEXT:    andnl %esi, %ebx, %esi
; X86-BMI1NOTBM-NEXT:    andnl %edi, %ebp, %edi
; X86-BMI1NOTBM-NEXT:    subl $8, %esp
; X86-BMI1NOTBM-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-BMI1NOTBM-NEXT:    pushl %eax
; X86-BMI1NOTBM-NEXT:    calll use64
; X86-BMI1NOTBM-NEXT:    addl $16, %esp
; X86-BMI1NOTBM-NEXT:    movl %edi, %eax
; X86-BMI1NOTBM-NEXT:    movl %esi, %edx
; X86-BMI1NOTBM-NEXT:    addl $12, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    popl %ebp
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_b5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebp
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $12, %esp
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %edi
; X86-BMI1BMI2-NEXT:    shrxl %eax, %esi, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB23_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %esi, %edi
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:  .LBB23_2:
; X86-BMI1BMI2-NEXT:    movl $-1, %ebp
; X86-BMI1BMI2-NEXT:    shlxl %edx, %ebp, %ebx
; X86-BMI1BMI2-NEXT:    movl %edx, %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %ebp, %ebp
; X86-BMI1BMI2-NEXT:    testb $32, %dl
; X86-BMI1BMI2-NEXT:    je .LBB23_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %ebp
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB23_4:
; X86-BMI1BMI2-NEXT:    andnl %esi, %ebp, %esi
; X86-BMI1BMI2-NEXT:    andnl %edi, %ebx, %edi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-BMI1BMI2-NEXT:    pushl %eax
; X86-BMI1BMI2-NEXT:    calll use64
; X86-BMI1BMI2-NEXT:    addl $16, %esp
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:    movl %esi, %edx
; X86-BMI1BMI2-NEXT:    addl $12, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    popl %ebp
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_b5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrq %cl, %rdi
; X64-NOBMI-NEXT:    movq $-1, %rbx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rbx
; X64-NOBMI-NEXT:    notq %rbx
; X64-NOBMI-NEXT:    andq %rdi, %rbx
; X64-NOBMI-NEXT:    movq %rsi, %rdi
; X64-NOBMI-NEXT:    callq use64
; X64-NOBMI-NEXT:    movq %rbx, %rax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_b5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rdi
; X64-BMI1NOTBM-NEXT:    movq $-1, %rax
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    andnq %rdi, %rax, %rbx
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rdi
; X64-BMI1NOTBM-NEXT:    callq use64
; X64-BMI1NOTBM-NEXT:    movq %rbx, %rax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_b5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rbx
; X64-BMI1BMI2-NEXT:    movq %rsi, %rdi
; X64-BMI1BMI2-NEXT:    callq use64
; X64-BMI1BMI2-NEXT:    movq %rbx, %rax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %notmask = shl i64 -1, %numlowbits
  %mask = xor i64 %notmask, -1
  %masked = and i64 %mask, %shifted
  call void @use64(i64 %numskipbits)
  ret i64 %masked
}

; ---------------------------------------------------------------------------- ;
; Pattern c. 32-bit
; ---------------------------------------------------------------------------- ;

define i32 @bextr32_c0(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_c0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_c0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_c0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_c0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl %edi, %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_c0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl %edi, %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_c0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_c1_indexzext(i32 %val, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_c1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_c1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_c1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_c1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl %edi, %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_c1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl %edi, %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_c1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %numhighbits = sub i8 32, %numlowbits
  %sh_prom = zext i8 %numhighbits to i32
  %mask = lshr i32 -1, %sh_prom
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_c2_load(i32* %w, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_c2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_c2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_c2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_c2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_c2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_c2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_c3_load_indexzext(i32* %w, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_c3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_c3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_c3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_c3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_c3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_c3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %numhighbits = sub i8 32, %numlowbits
  %sh_prom = zext i8 %numhighbits to i32
  %mask = lshr i32 -1, %sh_prom
  %masked = and i32 %mask, %shifted
  ret i32 %masked
}

define i32 @bextr32_c4_commutative(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_c4_commutative:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_c4_commutative:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_c4_commutative:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_c4_commutative:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl %edi, %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_c4_commutative:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl %edi, %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_c4_commutative:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %shifted, %mask ; swapped order
  ret i32 %masked
}

define i32 @bextr32_c5_skipextrauses(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_c5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    subl $8, %esp
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl %eax, (%esp)
; X86-NOBMI-NEXT:    calll use32
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    addl $8, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_c5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    subl $8, %esp
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, (%esp)
; X86-BMI1NOTBM-NEXT:    calll use32
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    addl $8, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_c5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %edx, %esi
; X86-BMI1BMI2-NEXT:    movl %ecx, (%esp)
; X86-BMI1BMI2-NEXT:    calll use32
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    addl $8, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_c5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movl %edi, %ebx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrl %cl, %ebx
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %ebx
; X64-NOBMI-NEXT:    shrl %cl, %ebx
; X64-NOBMI-NEXT:    movl %esi, %edi
; X64-NOBMI-NEXT:    callq use32
; X64-NOBMI-NEXT:    movl %ebx, %eax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_c5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movl %edi, %ebx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %ebx
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %ebx
; X64-BMI1NOTBM-NEXT:    movl %esi, %edi
; X64-BMI1NOTBM-NEXT:    callq use32
; X64-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_c5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %ebx
; X64-BMI1BMI2-NEXT:    movl %esi, %edi
; X64-BMI1BMI2-NEXT:    callq use32
; X64-BMI1BMI2-NEXT:    movl %ebx, %eax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %shifted
  call void @use32(i32 %numskipbits)
  ret i32 %masked
}

; 64-bit

define i64 @bextr64_c0(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_c0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB30_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB30_2:
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB30_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB30_4:
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_c0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB30_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB30_2:
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    movl $-1, %eax
; X86-BMI1NOTBM-NEXT:    movl $-1, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB30_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB30_4:
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_c0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB30_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB30_2:
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movl $-1, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB30_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB30_4:
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_c0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq %rdi, %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_c0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_c0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_c1_indexzext(i64 %val, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_c1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB31_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB31_2:
; X86-NOBMI-NEXT:    movb $64, %cl
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB31_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB31_4:
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_c1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB31_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB31_2:
; X86-BMI1NOTBM-NEXT:    movb $64, %cl
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl $-1, %eax
; X86-BMI1NOTBM-NEXT:    movl $-1, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB31_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB31_4:
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_c1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB31_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB31_2:
; X86-BMI1BMI2-NEXT:    movb $64, %cl
; X86-BMI1BMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl $-1, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB31_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB31_4:
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_c1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movq %rdi, %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_c1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_c1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %numhighbits = sub i8 64, %numlowbits
  %sh_prom = zext i8 %numhighbits to i64
  %mask = lshr i64 -1, %sh_prom
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_c2_load(i64* %w, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_c2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    movl 4(%eax), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB32_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB32_2:
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB32_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB32_4:
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_c2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %esi
; X86-BMI1NOTBM-NEXT:    movl 4(%eax), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB32_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB32_2:
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    movl $-1, %eax
; X86-BMI1NOTBM-NEXT:    movl $-1, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB32_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB32_4:
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_c2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl (%eax), %esi
; X86-BMI1BMI2-NEXT:    movl 4(%eax), %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB32_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB32_2:
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movl $-1, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB32_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB32_4:
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_c2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq (%rdi), %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_c2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_c2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_c3_load_indexzext(i64* %w, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_c3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %esi
; X86-NOBMI-NEXT:    movl 4(%eax), %eax
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB33_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB33_2:
; X86-NOBMI-NEXT:    movb $64, %cl
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl $-1, %eax
; X86-NOBMI-NEXT:    movl $-1, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %eax, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB33_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB33_4:
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_c3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %esi
; X86-BMI1NOTBM-NEXT:    movl 4(%eax), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB33_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB33_2:
; X86-BMI1NOTBM-NEXT:    movb $64, %cl
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl $-1, %eax
; X86-BMI1NOTBM-NEXT:    movl $-1, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB33_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB33_4:
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_c3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl (%eax), %esi
; X86-BMI1BMI2-NEXT:    movl 4(%eax), %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB33_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB33_2:
; X86-BMI1BMI2-NEXT:    movb $64, %cl
; X86-BMI1BMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl $-1, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %eax, %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %eax, %eax
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB33_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB33_4:
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_c3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movq (%rdi), %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_c3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_c3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %numhighbits = sub i8 64, %numlowbits
  %sh_prom = zext i8 %numhighbits to i64
  %mask = lshr i64 -1, %sh_prom
  %masked = and i64 %mask, %shifted
  ret i64 %masked
}

define i64 @bextr64_c4_commutative(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_c4_commutative:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl %esi, %edx
; X86-NOBMI-NEXT:    shrl %cl, %edx
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB34_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:  .LBB34_2:
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    movl $-1, %esi
; X86-NOBMI-NEXT:    movl $-1, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB34_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB34_4:
; X86-NOBMI-NEXT:    andl %edi, %edx
; X86-NOBMI-NEXT:    andl %esi, %eax
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_c4_commutative:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl %esi, %edx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %esi, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB34_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:  .LBB34_2:
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %esi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB34_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB34_4:
; X86-BMI1NOTBM-NEXT:    andl %edi, %edx
; X86-BMI1NOTBM-NEXT:    andl %esi, %eax
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_c4_commutative:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB34_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB34_2:
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movl $-1, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %esi, %edi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB34_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB34_4:
; X86-BMI1BMI2-NEXT:    andl %edi, %edx
; X86-BMI1BMI2-NEXT:    andl %esi, %eax
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_c4_commutative:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq %rdi, %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_c4_commutative:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_c4_commutative:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %shifted, %mask ; swapped order
  ret i64 %masked
}

define i64 @bextr64_c5_skipextrauses(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_c5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebp
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    subl $12, %esp
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %esi, %ebx
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %ebx
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %edx
; X86-NOBMI-NEXT:    testb $32, %al
; X86-NOBMI-NEXT:    je .LBB35_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %ebx, %edx
; X86-NOBMI-NEXT:    xorl %ebx, %ebx
; X86-NOBMI-NEXT:  .LBB35_2:
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    movl $-1, %esi
; X86-NOBMI-NEXT:    movl $-1, %edi
; X86-NOBMI-NEXT:    shrl %cl, %edi
; X86-NOBMI-NEXT:    shrdl %cl, %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB35_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    xorl %edi, %edi
; X86-NOBMI-NEXT:  .LBB35_4:
; X86-NOBMI-NEXT:    andl %ebx, %edi
; X86-NOBMI-NEXT:    andl %edx, %esi
; X86-NOBMI-NEXT:    subl $8, %esp
; X86-NOBMI-NEXT:    pushl %ebp
; X86-NOBMI-NEXT:    pushl %eax
; X86-NOBMI-NEXT:    calll use64
; X86-NOBMI-NEXT:    addl $16, %esp
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    movl %edi, %edx
; X86-NOBMI-NEXT:    addl $12, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    popl %ebp
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_c5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebp
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    subl $12, %esp
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %esi, %ebx
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %ebx
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %esi, %edx
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB35_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edx
; X86-BMI1NOTBM-NEXT:    xorl %ebx, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB35_2:
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    movl $-1, %esi
; X86-BMI1NOTBM-NEXT:    movl $-1, %edi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %edi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %esi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB35_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    xorl %edi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB35_4:
; X86-BMI1NOTBM-NEXT:    andl %ebx, %edi
; X86-BMI1NOTBM-NEXT:    andl %edx, %esi
; X86-BMI1NOTBM-NEXT:    subl $8, %esp
; X86-BMI1NOTBM-NEXT:    pushl %ebp
; X86-BMI1NOTBM-NEXT:    pushl %eax
; X86-BMI1NOTBM-NEXT:    calll use64
; X86-BMI1NOTBM-NEXT:    addl $16, %esp
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    addl $12, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    popl %ebp
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_c5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebp
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $12, %esp
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %edx
; X86-BMI1BMI2-NEXT:    shrxl %eax, %esi, %ebx
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB35_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edx
; X86-BMI1BMI2-NEXT:    xorl %ebx, %ebx
; X86-BMI1BMI2-NEXT:  .LBB35_2:
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movl $-1, %esi
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %esi, %edi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB35_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    xorl %edi, %edi
; X86-BMI1BMI2-NEXT:  .LBB35_4:
; X86-BMI1BMI2-NEXT:    andl %ebx, %edi
; X86-BMI1BMI2-NEXT:    andl %edx, %esi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    pushl %ebp
; X86-BMI1BMI2-NEXT:    pushl %eax
; X86-BMI1BMI2-NEXT:    calll use64
; X86-BMI1BMI2-NEXT:    addl $16, %esp
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    movl %edi, %edx
; X86-BMI1BMI2-NEXT:    addl $12, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    popl %ebp
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_c5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movq %rdi, %rbx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrq %cl, %rbx
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rbx
; X64-NOBMI-NEXT:    shrq %cl, %rbx
; X64-NOBMI-NEXT:    movq %rsi, %rdi
; X64-NOBMI-NEXT:    callq use64
; X64-NOBMI-NEXT:    movq %rbx, %rax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_c5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rbx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rdi
; X64-BMI1NOTBM-NEXT:    callq use64
; X64-BMI1NOTBM-NEXT:    movq %rbx, %rax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_c5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rbx
; X64-BMI1BMI2-NEXT:    movq %rsi, %rdi
; X64-BMI1BMI2-NEXT:    callq use64
; X64-BMI1BMI2-NEXT:    movq %rbx, %rax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %mask, %shifted
  call void @use64(i64 %numskipbits)
  ret i64 %masked
}

; ---------------------------------------------------------------------------- ;
; Pattern d. 32-bit.
; ---------------------------------------------------------------------------- ;

define i32 @bextr32_d0(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_d0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_d0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_d0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_d0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl %edi, %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_d0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl %edi, %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_d0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %highbitscleared = shl i32 %shifted, %numhighbits
  %masked = lshr i32 %highbitscleared, %numhighbits
  ret i32 %masked
}

define i32 @bextr32_d1_indexzext(i32 %val, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_d1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_d1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_d1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_d1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl %edi, %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_d1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl %edi, %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_d1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %numhighbits = sub i8 32, %numlowbits
  %sh_prom = zext i8 %numhighbits to i32
  %highbitscleared = shl i32 %shifted, %sh_prom
  %masked = lshr i32 %highbitscleared, %sh_prom
  ret i32 %masked
}

define i32 @bextr32_d2_load(i32* %w, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_d2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_d2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_d2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_d2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_d2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_d2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %highbitscleared = shl i32 %shifted, %numhighbits
  %masked = lshr i32 %highbitscleared, %numhighbits
  ret i32 %masked
}

define i32 @bextr32_d3_load_indexzext(i32* %w, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_d3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    shll %cl, %eax
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_d3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    shll %cl, %eax
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_d3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-BMI1BMI2-NEXT:    shrxl %edx, (%ecx), %ecx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %ecx, %eax
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_d3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movl (%rdi), %eax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %eax
; X64-NOBMI-NEXT:    shrl %cl, %eax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_d3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movl (%rdi), %eax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %eax
; X64-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_d3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxl %esi, (%rdi), %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %eax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %skip = zext i8 %numskipbits to i32
  %shifted = lshr i32 %val, %skip
  %numhighbits = sub i8 32, %numlowbits
  %sh_prom = zext i8 %numhighbits to i32
  %highbitscleared = shl i32 %shifted, %sh_prom
  %masked = lshr i32 %highbitscleared, %sh_prom
  ret i32 %masked
}

define i32 @bextr32_d5_skipextrauses(i32 %val, i32 %numskipbits, i32 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr32_d5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    subl $8, %esp
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    xorl %ecx, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shll %cl, %esi
; X86-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    movl %eax, (%esp)
; X86-NOBMI-NEXT:    calll use32
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    addl $8, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr32_d5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    subl $8, %esp
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    xorl %ecx, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shll %cl, %esi
; X86-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, (%esp)
; X86-BMI1NOTBM-NEXT:    calll use32
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    addl $8, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr32_d5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shrxl %ecx, {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    bzhil %eax, %edx, %esi
; X86-BMI1BMI2-NEXT:    movl %ecx, (%esp)
; X86-BMI1BMI2-NEXT:    calll use32
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    addl $8, %esp
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr32_d5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movl %edi, %ebx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrl %cl, %ebx
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shll %cl, %ebx
; X64-NOBMI-NEXT:    shrl %cl, %ebx
; X64-NOBMI-NEXT:    movl %esi, %edi
; X64-NOBMI-NEXT:    callq use32
; X64-NOBMI-NEXT:    movl %ebx, %eax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr32_d5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movl %edi, %ebx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %ebx
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X64-BMI1NOTBM-NEXT:    shrl %cl, %ebx
; X64-BMI1NOTBM-NEXT:    movl %esi, %edi
; X64-BMI1NOTBM-NEXT:    callq use32
; X64-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr32_d5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxl %esi, %edi, %eax
; X64-BMI1BMI2-NEXT:    bzhil %edx, %eax, %ebx
; X64-BMI1BMI2-NEXT:    movl %esi, %edi
; X64-BMI1BMI2-NEXT:    callq use32
; X64-BMI1BMI2-NEXT:    movl %ebx, %eax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i32 %val, %numskipbits
  %numhighbits = sub i32 32, %numlowbits
  %highbitscleared = shl i32 %shifted, %numhighbits
  %masked = lshr i32 %highbitscleared, %numhighbits
  call void @use32(i32 %numskipbits)
  ret i32 %masked
}

; 64-bit.

define i64 @bextr64_d0(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_d0:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    shrdl %cl, %edx, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB41_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB41_2:
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shldl %cl, %edi, %eax
; X86-NOBMI-NEXT:    shll %cl, %edi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl %edi, %ebx
; X86-NOBMI-NEXT:    jne .LBB41_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %ebx
; X86-NOBMI-NEXT:  .LBB41_4:
; X86-NOBMI-NEXT:    movl %ebx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl $0, %edx
; X86-NOBMI-NEXT:    jne .LBB41_6
; X86-NOBMI-NEXT:  # %bb.5:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:  .LBB41_6:
; X86-NOBMI-NEXT:    shrdl %cl, %ebx, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    jne .LBB41_8
; X86-NOBMI-NEXT:  # %bb.7:
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:  .LBB41_8:
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_d0:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB41_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB41_2:
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %eax
; X86-BMI1NOTBM-NEXT:    shll %cl, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl %edi, %ebx
; X86-BMI1NOTBM-NEXT:    jne .LBB41_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB41_4:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl $0, %edx
; X86-BMI1NOTBM-NEXT:    jne .LBB41_6
; X86-BMI1NOTBM-NEXT:  # %bb.5:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:  .LBB41_6:
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %ebx, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    jne .LBB41_8
; X86-BMI1NOTBM-NEXT:  # %bb.7:
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:  .LBB41_8:
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_d0:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB41_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:  .LBB41_2:
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shlxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB41_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    movl $0, %edi
; X86-BMI1BMI2-NEXT:  .LBB41_4:
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %esi, %eax
; X86-BMI1BMI2-NEXT:    jne .LBB41_6
; X86-BMI1BMI2-NEXT:  # %bb.5:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:  .LBB41_6:
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    jne .LBB41_8
; X86-BMI1BMI2-NEXT:  # %bb.7:
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:  .LBB41_8:
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_d0:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq %rdi, %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_d0:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_d0:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %highbitscleared = shl i64 %shifted, %numhighbits
  %masked = lshr i64 %highbitscleared, %numhighbits
  ret i64 %masked
}

define i64 @bextr64_d1_indexzext(i64 %val, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_d1_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    shrdl %cl, %edx, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB42_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB42_2:
; X86-NOBMI-NEXT:    movb $64, %cl
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    shldl %cl, %edi, %eax
; X86-NOBMI-NEXT:    shll %cl, %edi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl %edi, %ebx
; X86-NOBMI-NEXT:    jne .LBB42_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %ebx
; X86-NOBMI-NEXT:  .LBB42_4:
; X86-NOBMI-NEXT:    movl %ebx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl $0, %edx
; X86-NOBMI-NEXT:    jne .LBB42_6
; X86-NOBMI-NEXT:  # %bb.5:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:  .LBB42_6:
; X86-NOBMI-NEXT:    shrdl %cl, %ebx, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    jne .LBB42_8
; X86-NOBMI-NEXT:  # %bb.7:
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:  .LBB42_8:
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_d1_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB42_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB42_2:
; X86-BMI1NOTBM-NEXT:    movb $64, %cl
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %eax
; X86-BMI1NOTBM-NEXT:    shll %cl, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl %edi, %ebx
; X86-BMI1NOTBM-NEXT:    jne .LBB42_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB42_4:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl $0, %edx
; X86-BMI1NOTBM-NEXT:    jne .LBB42_6
; X86-BMI1NOTBM-NEXT:  # %bb.5:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:  .LBB42_6:
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %ebx, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    jne .LBB42_8
; X86-BMI1NOTBM-NEXT:  # %bb.7:
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:  .LBB42_8:
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_d1_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %eax
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %esi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB42_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:  .LBB42_2:
; X86-BMI1BMI2-NEXT:    movb $64, %cl
; X86-BMI1BMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shlxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB42_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    movl $0, %edi
; X86-BMI1BMI2-NEXT:  .LBB42_4:
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %esi, %eax
; X86-BMI1BMI2-NEXT:    jne .LBB42_6
; X86-BMI1BMI2-NEXT:  # %bb.5:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:  .LBB42_6:
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    jne .LBB42_8
; X86-BMI1BMI2-NEXT:  # %bb.7:
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:  .LBB42_8:
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_d1_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movq %rdi, %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_d1_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_d1_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %numhighbits = sub i8 64, %numlowbits
  %sh_prom = zext i8 %numhighbits to i64
  %highbitscleared = shl i64 %shifted, %sh_prom
  %masked = lshr i64 %highbitscleared, %sh_prom
  ret i64 %masked
}

define i64 @bextr64_d2_load(i64* %w, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_d2_load:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %edi
; X86-NOBMI-NEXT:    movl 4(%eax), %edx
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    shrdl %cl, %edx, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB43_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB43_2:
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shldl %cl, %edi, %eax
; X86-NOBMI-NEXT:    shll %cl, %edi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl %edi, %ebx
; X86-NOBMI-NEXT:    jne .LBB43_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %ebx
; X86-NOBMI-NEXT:  .LBB43_4:
; X86-NOBMI-NEXT:    movl %ebx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl $0, %edx
; X86-NOBMI-NEXT:    jne .LBB43_6
; X86-NOBMI-NEXT:  # %bb.5:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:  .LBB43_6:
; X86-NOBMI-NEXT:    shrdl %cl, %ebx, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    jne .LBB43_8
; X86-NOBMI-NEXT:  # %bb.7:
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:  .LBB43_8:
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_d2_load:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %edi
; X86-BMI1NOTBM-NEXT:    movl 4(%eax), %edx
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB43_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB43_2:
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %eax
; X86-BMI1NOTBM-NEXT:    shll %cl, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl %edi, %ebx
; X86-BMI1NOTBM-NEXT:    jne .LBB43_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB43_4:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl $0, %edx
; X86-BMI1NOTBM-NEXT:    jne .LBB43_6
; X86-BMI1NOTBM-NEXT:  # %bb.5:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:  .LBB43_6:
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %ebx, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    jne .LBB43_8
; X86-BMI1NOTBM-NEXT:  # %bb.7:
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:  .LBB43_8:
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_d2_load:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    movl (%edx), %eax
; X86-BMI1BMI2-NEXT:    movl 4(%edx), %edx
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %esi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB43_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:  .LBB43_2:
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shlxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB43_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    movl $0, %edi
; X86-BMI1BMI2-NEXT:  .LBB43_4:
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %esi, %eax
; X86-BMI1BMI2-NEXT:    jne .LBB43_6
; X86-BMI1BMI2-NEXT:  # %bb.5:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:  .LBB43_6:
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    jne .LBB43_8
; X86-BMI1BMI2-NEXT:  # %bb.7:
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:  .LBB43_8:
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_d2_load:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movq %rsi, %rcx
; X64-NOBMI-NEXT:    movq (%rdi), %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_d2_load:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rcx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_d2_load:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %highbitscleared = shl i64 %shifted, %numhighbits
  %masked = lshr i64 %highbitscleared, %numhighbits
  ret i64 %masked
}

define i64 @bextr64_d3_load_indexzext(i64* %w, i8 %numskipbits, i8 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_d3_load_indexzext:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl (%eax), %edi
; X86-NOBMI-NEXT:    movl 4(%eax), %edx
; X86-NOBMI-NEXT:    movl %edx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    shrdl %cl, %edx, %edi
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    je .LBB44_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %eax, %edi
; X86-NOBMI-NEXT:    xorl %eax, %eax
; X86-NOBMI-NEXT:  .LBB44_2:
; X86-NOBMI-NEXT:    movb $64, %cl
; X86-NOBMI-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI-NEXT:    shldl %cl, %edi, %eax
; X86-NOBMI-NEXT:    shll %cl, %edi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl %edi, %ebx
; X86-NOBMI-NEXT:    jne .LBB44_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %eax, %ebx
; X86-NOBMI-NEXT:  .LBB44_4:
; X86-NOBMI-NEXT:    movl %ebx, %eax
; X86-NOBMI-NEXT:    shrl %cl, %eax
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl $0, %edx
; X86-NOBMI-NEXT:    jne .LBB44_6
; X86-NOBMI-NEXT:  # %bb.5:
; X86-NOBMI-NEXT:    movl %edi, %esi
; X86-NOBMI-NEXT:    movl %eax, %edx
; X86-NOBMI-NEXT:  .LBB44_6:
; X86-NOBMI-NEXT:    shrdl %cl, %ebx, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    jne .LBB44_8
; X86-NOBMI-NEXT:  # %bb.7:
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:  .LBB44_8:
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_d3_load_indexzext:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl (%eax), %edi
; X86-BMI1NOTBM-NEXT:    movl 4(%eax), %edx
; X86-BMI1NOTBM-NEXT:    movl %edx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edx, %edi
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    je .LBB44_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %eax, %edi
; X86-BMI1NOTBM-NEXT:    xorl %eax, %eax
; X86-BMI1NOTBM-NEXT:  .LBB44_2:
; X86-BMI1NOTBM-NEXT:    movb $64, %cl
; X86-BMI1NOTBM-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1NOTBM-NEXT:    shldl %cl, %edi, %eax
; X86-BMI1NOTBM-NEXT:    shll %cl, %edi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl %edi, %ebx
; X86-BMI1NOTBM-NEXT:    jne .LBB44_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %eax, %ebx
; X86-BMI1NOTBM-NEXT:  .LBB44_4:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %eax
; X86-BMI1NOTBM-NEXT:    shrl %cl, %eax
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl $0, %edx
; X86-BMI1NOTBM-NEXT:    jne .LBB44_6
; X86-BMI1NOTBM-NEXT:  # %bb.5:
; X86-BMI1NOTBM-NEXT:    movl %edi, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %edx
; X86-BMI1NOTBM-NEXT:  .LBB44_6:
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %ebx, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    jne .LBB44_8
; X86-BMI1NOTBM-NEXT:  # %bb.7:
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:  .LBB44_8:
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_d3_load_indexzext:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    movl (%edx), %eax
; X86-BMI1BMI2-NEXT:    movl 4(%edx), %edx
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %esi
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %eax
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB44_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %esi, %eax
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:  .LBB44_2:
; X86-BMI1BMI2-NEXT:    movb $64, %cl
; X86-BMI1BMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-BMI1BMI2-NEXT:    shldl %cl, %eax, %esi
; X86-BMI1BMI2-NEXT:    shlxl %ecx, %eax, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB44_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:    movl $0, %edi
; X86-BMI1BMI2-NEXT:  .LBB44_4:
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %esi, %eax
; X86-BMI1BMI2-NEXT:    jne .LBB44_6
; X86-BMI1BMI2-NEXT:  # %bb.5:
; X86-BMI1BMI2-NEXT:    movl %eax, %edx
; X86-BMI1BMI2-NEXT:  .LBB44_6:
; X86-BMI1BMI2-NEXT:    shrdl %cl, %esi, %edi
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    jne .LBB44_8
; X86-BMI1BMI2-NEXT:  # %bb.7:
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:  .LBB44_8:
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_d3_load_indexzext:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    movq (%rdi), %rax
; X64-NOBMI-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    negb %dl
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rax
; X64-NOBMI-NEXT:    shrq %cl, %rax
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_d3_load_indexzext:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    movq (%rdi), %rax
; X64-BMI1NOTBM-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    negb %dl
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rax
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rax
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_d3_load_indexzext:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-BMI1BMI2-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-BMI1BMI2-NEXT:    shrxq %rsi, (%rdi), %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rax
; X64-BMI1BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %skip = zext i8 %numskipbits to i64
  %shifted = lshr i64 %val, %skip
  %numhighbits = sub i8 64, %numlowbits
  %sh_prom = zext i8 %numhighbits to i64
  %highbitscleared = shl i64 %shifted, %sh_prom
  %masked = lshr i64 %highbitscleared, %sh_prom
  ret i64 %masked
}

define i64 @bextr64_d5_skipextrauses(i64 %val, i64 %numskipbits, i64 %numlowbits) nounwind {
; X86-NOBMI-LABEL: bextr64_d5_skipextrauses:
; X86-NOBMI:       # %bb.0:
; X86-NOBMI-NEXT:    pushl %ebp
; X86-NOBMI-NEXT:    pushl %ebx
; X86-NOBMI-NEXT:    pushl %edi
; X86-NOBMI-NEXT:    pushl %esi
; X86-NOBMI-NEXT:    subl $12, %esp
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI-NEXT:    movl %edx, %esi
; X86-NOBMI-NEXT:    movl %eax, %ecx
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    shrdl %cl, %edx, %ebx
; X86-NOBMI-NEXT:    xorl %edx, %edx
; X86-NOBMI-NEXT:    testb $32, %al
; X86-NOBMI-NEXT:    je .LBB45_2
; X86-NOBMI-NEXT:  # %bb.1:
; X86-NOBMI-NEXT:    movl %esi, %ebx
; X86-NOBMI-NEXT:    xorl %esi, %esi
; X86-NOBMI-NEXT:  .LBB45_2:
; X86-NOBMI-NEXT:    movl $64, %ecx
; X86-NOBMI-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    shldl %cl, %ebx, %esi
; X86-NOBMI-NEXT:    shll %cl, %ebx
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl %ebx, %ebp
; X86-NOBMI-NEXT:    jne .LBB45_4
; X86-NOBMI-NEXT:  # %bb.3:
; X86-NOBMI-NEXT:    movl %esi, %ebp
; X86-NOBMI-NEXT:  .LBB45_4:
; X86-NOBMI-NEXT:    movl %ebp, %esi
; X86-NOBMI-NEXT:    shrl %cl, %esi
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl $0, %edi
; X86-NOBMI-NEXT:    jne .LBB45_6
; X86-NOBMI-NEXT:  # %bb.5:
; X86-NOBMI-NEXT:    movl %ebx, %edx
; X86-NOBMI-NEXT:    movl %esi, %edi
; X86-NOBMI-NEXT:  .LBB45_6:
; X86-NOBMI-NEXT:    shrdl %cl, %ebp, %edx
; X86-NOBMI-NEXT:    testb $32, %cl
; X86-NOBMI-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NOBMI-NEXT:    jne .LBB45_8
; X86-NOBMI-NEXT:  # %bb.7:
; X86-NOBMI-NEXT:    movl %edx, %esi
; X86-NOBMI-NEXT:  .LBB45_8:
; X86-NOBMI-NEXT:    subl $8, %esp
; X86-NOBMI-NEXT:    pushl %ecx
; X86-NOBMI-NEXT:    pushl %eax
; X86-NOBMI-NEXT:    calll use64
; X86-NOBMI-NEXT:    addl $16, %esp
; X86-NOBMI-NEXT:    movl %esi, %eax
; X86-NOBMI-NEXT:    movl %edi, %edx
; X86-NOBMI-NEXT:    addl $12, %esp
; X86-NOBMI-NEXT:    popl %esi
; X86-NOBMI-NEXT:    popl %edi
; X86-NOBMI-NEXT:    popl %ebx
; X86-NOBMI-NEXT:    popl %ebp
; X86-NOBMI-NEXT:    retl
;
; X86-BMI1NOTBM-LABEL: bextr64_d5_skipextrauses:
; X86-BMI1NOTBM:       # %bb.0:
; X86-BMI1NOTBM-NEXT:    pushl %ebp
; X86-BMI1NOTBM-NEXT:    pushl %ebx
; X86-BMI1NOTBM-NEXT:    pushl %edi
; X86-BMI1NOTBM-NEXT:    pushl %esi
; X86-BMI1NOTBM-NEXT:    subl $12, %esp
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:    movl %eax, %ecx
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %edx, %ebx
; X86-BMI1NOTBM-NEXT:    xorl %edx, %edx
; X86-BMI1NOTBM-NEXT:    testb $32, %al
; X86-BMI1NOTBM-NEXT:    je .LBB45_2
; X86-BMI1NOTBM-NEXT:  # %bb.1:
; X86-BMI1NOTBM-NEXT:    movl %esi, %ebx
; X86-BMI1NOTBM-NEXT:    xorl %esi, %esi
; X86-BMI1NOTBM-NEXT:  .LBB45_2:
; X86-BMI1NOTBM-NEXT:    movl $64, %ecx
; X86-BMI1NOTBM-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    shldl %cl, %ebx, %esi
; X86-BMI1NOTBM-NEXT:    shll %cl, %ebx
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl %ebx, %ebp
; X86-BMI1NOTBM-NEXT:    jne .LBB45_4
; X86-BMI1NOTBM-NEXT:  # %bb.3:
; X86-BMI1NOTBM-NEXT:    movl %esi, %ebp
; X86-BMI1NOTBM-NEXT:  .LBB45_4:
; X86-BMI1NOTBM-NEXT:    movl %ebp, %esi
; X86-BMI1NOTBM-NEXT:    shrl %cl, %esi
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl $0, %edi
; X86-BMI1NOTBM-NEXT:    jne .LBB45_6
; X86-BMI1NOTBM-NEXT:  # %bb.5:
; X86-BMI1NOTBM-NEXT:    movl %ebx, %edx
; X86-BMI1NOTBM-NEXT:    movl %esi, %edi
; X86-BMI1NOTBM-NEXT:  .LBB45_6:
; X86-BMI1NOTBM-NEXT:    shrdl %cl, %ebp, %edx
; X86-BMI1NOTBM-NEXT:    testb $32, %cl
; X86-BMI1NOTBM-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1NOTBM-NEXT:    jne .LBB45_8
; X86-BMI1NOTBM-NEXT:  # %bb.7:
; X86-BMI1NOTBM-NEXT:    movl %edx, %esi
; X86-BMI1NOTBM-NEXT:  .LBB45_8:
; X86-BMI1NOTBM-NEXT:    subl $8, %esp
; X86-BMI1NOTBM-NEXT:    pushl %ecx
; X86-BMI1NOTBM-NEXT:    pushl %eax
; X86-BMI1NOTBM-NEXT:    calll use64
; X86-BMI1NOTBM-NEXT:    addl $16, %esp
; X86-BMI1NOTBM-NEXT:    movl %esi, %eax
; X86-BMI1NOTBM-NEXT:    movl %edi, %edx
; X86-BMI1NOTBM-NEXT:    addl $12, %esp
; X86-BMI1NOTBM-NEXT:    popl %esi
; X86-BMI1NOTBM-NEXT:    popl %edi
; X86-BMI1NOTBM-NEXT:    popl %ebx
; X86-BMI1NOTBM-NEXT:    popl %ebp
; X86-BMI1NOTBM-NEXT:    retl
;
; X86-BMI1BMI2-LABEL: bextr64_d5_skipextrauses:
; X86-BMI1BMI2:       # %bb.0:
; X86-BMI1BMI2-NEXT:    pushl %ebx
; X86-BMI1BMI2-NEXT:    pushl %edi
; X86-BMI1BMI2-NEXT:    pushl %esi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI1BMI2-NEXT:    movl %eax, %ecx
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %edi
; X86-BMI1BMI2-NEXT:    shrxl %eax, %edx, %edx
; X86-BMI1BMI2-NEXT:    xorl %esi, %esi
; X86-BMI1BMI2-NEXT:    testb $32, %al
; X86-BMI1BMI2-NEXT:    je .LBB45_2
; X86-BMI1BMI2-NEXT:  # %bb.1:
; X86-BMI1BMI2-NEXT:    movl %edx, %edi
; X86-BMI1BMI2-NEXT:    xorl %edx, %edx
; X86-BMI1BMI2-NEXT:  .LBB45_2:
; X86-BMI1BMI2-NEXT:    movl $64, %ecx
; X86-BMI1BMI2-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    shldl %cl, %edi, %edx
; X86-BMI1BMI2-NEXT:    shlxl %ecx, %edi, %ebx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    je .LBB45_4
; X86-BMI1BMI2-NEXT:  # %bb.3:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edx
; X86-BMI1BMI2-NEXT:    movl $0, %ebx
; X86-BMI1BMI2-NEXT:  .LBB45_4:
; X86-BMI1BMI2-NEXT:    shrxl %ecx, %edx, %edi
; X86-BMI1BMI2-NEXT:    jne .LBB45_6
; X86-BMI1BMI2-NEXT:  # %bb.5:
; X86-BMI1BMI2-NEXT:    movl %edi, %esi
; X86-BMI1BMI2-NEXT:  .LBB45_6:
; X86-BMI1BMI2-NEXT:    shrdl %cl, %edx, %ebx
; X86-BMI1BMI2-NEXT:    testb $32, %cl
; X86-BMI1BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI1BMI2-NEXT:    jne .LBB45_8
; X86-BMI1BMI2-NEXT:  # %bb.7:
; X86-BMI1BMI2-NEXT:    movl %ebx, %edi
; X86-BMI1BMI2-NEXT:  .LBB45_8:
; X86-BMI1BMI2-NEXT:    subl $8, %esp
; X86-BMI1BMI2-NEXT:    pushl %ecx
; X86-BMI1BMI2-NEXT:    pushl %eax
; X86-BMI1BMI2-NEXT:    calll use64
; X86-BMI1BMI2-NEXT:    addl $16, %esp
; X86-BMI1BMI2-NEXT:    movl %edi, %eax
; X86-BMI1BMI2-NEXT:    movl %esi, %edx
; X86-BMI1BMI2-NEXT:    popl %esi
; X86-BMI1BMI2-NEXT:    popl %edi
; X86-BMI1BMI2-NEXT:    popl %ebx
; X86-BMI1BMI2-NEXT:    retl
;
; X64-NOBMI-LABEL: bextr64_d5_skipextrauses:
; X64-NOBMI:       # %bb.0:
; X64-NOBMI-NEXT:    pushq %rbx
; X64-NOBMI-NEXT:    movq %rdi, %rbx
; X64-NOBMI-NEXT:    movl %esi, %ecx
; X64-NOBMI-NEXT:    shrq %cl, %rbx
; X64-NOBMI-NEXT:    negl %edx
; X64-NOBMI-NEXT:    movl %edx, %ecx
; X64-NOBMI-NEXT:    shlq %cl, %rbx
; X64-NOBMI-NEXT:    shrq %cl, %rbx
; X64-NOBMI-NEXT:    movq %rsi, %rdi
; X64-NOBMI-NEXT:    callq use64
; X64-NOBMI-NEXT:    movq %rbx, %rax
; X64-NOBMI-NEXT:    popq %rbx
; X64-NOBMI-NEXT:    retq
;
; X64-BMI1NOTBM-LABEL: bextr64_d5_skipextrauses:
; X64-BMI1NOTBM:       # %bb.0:
; X64-BMI1NOTBM-NEXT:    pushq %rbx
; X64-BMI1NOTBM-NEXT:    movq %rdi, %rbx
; X64-BMI1NOTBM-NEXT:    movl %esi, %ecx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    negl %edx
; X64-BMI1NOTBM-NEXT:    movl %edx, %ecx
; X64-BMI1NOTBM-NEXT:    shlq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    shrq %cl, %rbx
; X64-BMI1NOTBM-NEXT:    movq %rsi, %rdi
; X64-BMI1NOTBM-NEXT:    callq use64
; X64-BMI1NOTBM-NEXT:    movq %rbx, %rax
; X64-BMI1NOTBM-NEXT:    popq %rbx
; X64-BMI1NOTBM-NEXT:    retq
;
; X64-BMI1BMI2-LABEL: bextr64_d5_skipextrauses:
; X64-BMI1BMI2:       # %bb.0:
; X64-BMI1BMI2-NEXT:    pushq %rbx
; X64-BMI1BMI2-NEXT:    shrxq %rsi, %rdi, %rax
; X64-BMI1BMI2-NEXT:    bzhiq %rdx, %rax, %rbx
; X64-BMI1BMI2-NEXT:    movq %rsi, %rdi
; X64-BMI1BMI2-NEXT:    callq use64
; X64-BMI1BMI2-NEXT:    movq %rbx, %rax
; X64-BMI1BMI2-NEXT:    popq %rbx
; X64-BMI1BMI2-NEXT:    retq
  %shifted = lshr i64 %val, %numskipbits
  %numhighbits = sub i64 64, %numlowbits
  %highbitscleared = shl i64 %shifted, %numhighbits
  %masked = lshr i64 %highbitscleared, %numhighbits
  call void @use64(i64 %numskipbits)
  ret i64 %masked
}

; ---------------------------------------------------------------------------- ;
; Constant
; ---------------------------------------------------------------------------- ;

define void @pr38938(i32* %a0, i64* %a1) {
; X86-LABEL: pr38938:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl (%ecx), %ecx
; X86-NEXT:    shrl $19, %ecx
; X86-NEXT:    andl $4092, %ecx # imm = 0xFFC
; X86-NEXT:    incl (%eax,%ecx)
; X86-NEXT:    retl
;
; X64-LABEL: pr38938:
; X64:       # %bb.0:
; X64-NEXT:    movq (%rsi), %rax
; X64-NEXT:    shrq $19, %rax
; X64-NEXT:    andl $4092, %eax # imm = 0xFFC
; X64-NEXT:    incl (%rdi,%rax)
; X64-NEXT:    retq
  %tmp = load i64, i64* %a1, align 8
  %tmp1 = lshr i64 %tmp, 21
  %tmp2 = and i64 %tmp1, 1023
  %tmp3 = getelementptr inbounds i32, i32* %a0, i64 %tmp2
  %tmp4 = load i32, i32* %tmp3, align 4
  %tmp5 = add nsw i32 %tmp4, 1
  store i32 %tmp5, i32* %tmp3, align 4
  ret void
}
