; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -stop-after=irtranslator -verify-machineinstrs %s -o - | FileCheck %s -check-prefixes=MIPS32

define i32 @and(i32 %a, i32 %b) {
  ; MIPS32-LABEL: name: and
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[AND:%[0-9]+]]:_(s32) = G_AND [[COPY1]], [[COPY]]
  ; MIPS32:   $v0 = COPY [[AND]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %and = and i32 %b, %a
  ret i32 %and
}

define i32 @or(i32 %a, i32 %b) {
  ; MIPS32-LABEL: name: or
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[OR:%[0-9]+]]:_(s32) = G_OR [[COPY1]], [[COPY]]
  ; MIPS32:   $v0 = COPY [[OR]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %or = or i32 %b, %a
  ret i32 %or
}

define i32 @xor(i32 %a, i32 %b) {
  ; MIPS32-LABEL: name: xor
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[XOR:%[0-9]+]]:_(s32) = G_XOR [[COPY1]], [[COPY]]
  ; MIPS32:   $v0 = COPY [[XOR]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %xor = xor i32 %b, %a
  ret i32 %xor
}

define i32 @shl(i32 %a) {
  ; MIPS32-LABEL: name: shl
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; MIPS32:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[COPY]], [[C]]
  ; MIPS32:   $v0 = COPY [[SHL]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %shl = shl i32 %a, 1
  ret i32 %shl
}

define i32 @ashr(i32 %a) {
  ; MIPS32-LABEL: name: ashr
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; MIPS32:   [[ASHR:%[0-9]+]]:_(s32) = G_ASHR [[COPY]], [[C]]
  ; MIPS32:   $v0 = COPY [[ASHR]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %shr = ashr i32 %a, 1
  ret i32 %shr
}

define i32 @lshr(i32 %a) {
  ; MIPS32-LABEL: name: lshr
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; MIPS32:   [[LSHR:%[0-9]+]]:_(s32) = G_LSHR [[COPY]], [[C]]
  ; MIPS32:   $v0 = COPY [[LSHR]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %shr = lshr i32 %a, 1
  ret i32 %shr
}

define i32 @shlv(i32 %a, i32 %b) {
  ; MIPS32-LABEL: name: shlv
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[COPY]], [[COPY1]]
  ; MIPS32:   $v0 = COPY [[SHL]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %shl = shl i32 %a, %b
  ret i32 %shl
}

define i32 @ashrv(i32 %a, i32 %b) {
  ; MIPS32-LABEL: name: ashrv
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[ASHR:%[0-9]+]]:_(s32) = G_ASHR [[COPY]], [[COPY1]]
  ; MIPS32:   $v0 = COPY [[ASHR]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %shr = ashr i32 %a, %b
  ret i32 %shr
}

define i32 @lshrv(i32 %a, i32 %b) {
  ; MIPS32-LABEL: name: lshrv
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[LSHR:%[0-9]+]]:_(s32) = G_LSHR [[COPY]], [[COPY1]]
  ; MIPS32:   $v0 = COPY [[LSHR]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %shr = lshr i32 %a, %b
  ret i32 %shr
}

