; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=i686 | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=atom | FileCheck %s --check-prefix=CHECK --check-prefix=ATOM
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=slm | FileCheck %s --check-prefix=CHECK --check-prefix=SLM
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=sandybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=ivybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=haswell | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=broadwell | FileCheck %s --check-prefix=CHECK --check-prefix=BROADWELL
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=skylake | FileCheck %s --check-prefix=CHECK --check-prefix=SKYLAKE
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=skx | FileCheck %s --check-prefix=CHECK --check-prefix=SKX
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=btver2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=znver1 | FileCheck %s --check-prefix=CHECK --check-prefix=ZNVER1

define i8 @test_aaa(i8 %a0) optsize {
; GENERIC-LABEL: test_aaa:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movb {{[0-9]+}}(%esp), %al
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    aaa
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_aaa:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    aaa # sched: [13:6.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_aaa:
; SLM:       # %bb.0:
; SLM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    aaa # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_aaa:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    aaa # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_aaa:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    aaa # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_aaa:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    aaa # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_aaa:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    aaa # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_aaa:
; SKX:       # %bb.0:
; SKX-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    aaa # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_aaa:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    aaa # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_aaa:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    aaa # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i8 asm "aaa", "=r,r"(i8 %a0) nounwind
  ret i8 %1
}

define i8 @test_aad(i16 %a0) optsize {
; GENERIC-LABEL: test_aad:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    aad
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_aad:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    aad # sched: [7:3.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_aad:
; SLM:       # %bb.0:
; SLM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    aad # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_aad:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    aad # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_aad:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    aad # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_aad:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    aad # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_aad:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    aad # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_aad:
; SKX:       # %bb.0:
; SKX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    aad # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_aad:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    aad # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_aad:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    aad # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i8 asm "aad", "=r,r"(i16 %a0) nounwind
  ret i8 %1
}

define i16 @test_aam(i8 %a0) optsize {
; GENERIC-LABEL: test_aam:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movb {{[0-9]+}}(%esp), %al
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    aam
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_aam:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    aam # sched: [21:10.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_aam:
; SLM:       # %bb.0:
; SLM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    aam # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_aam:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    aam # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_aam:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    aam # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_aam:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    aam # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_aam:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    aam # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_aam:
; SKX:       # %bb.0:
; SKX-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    aam # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_aam:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    aam # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_aam:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    aam # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i16 asm "aam", "=r,r"(i8 %a0) nounwind
  ret i16 %1
}

define i8 @test_aas(i8 %a0) optsize {
; GENERIC-LABEL: test_aas:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movb {{[0-9]+}}(%esp), %al
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    aas
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_aas:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    aas # sched: [13:6.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_aas:
; SLM:       # %bb.0:
; SLM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    aas # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_aas:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    aas # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_aas:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    aas # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_aas:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    aas # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_aas:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    aas # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_aas:
; SKX:       # %bb.0:
; SKX-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    aas # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_aas:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    aas # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_aas:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    aas # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i8 asm "aas", "=r,r"(i8 %a0) nounwind
  ret i8 %1
}

define void @test_arpl(i16 %a0, i16 *%a1) optsize {
; GENERIC-LABEL: test_arpl:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    arpl %ax, (%ecx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_arpl:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    arpl %ax, (%ecx) # sched: [23:11.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_arpl:
; SLM:       # %bb.0:
; SLM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    arpl %ax, (%ecx) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_arpl:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    arpl %ax, (%ecx) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_arpl:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    arpl %ax, (%ecx) # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_arpl:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    arpl %ax, (%ecx) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_arpl:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    arpl %ax, (%ecx) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_arpl:
; SKX:       # %bb.0:
; SKX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    arpl %ax, (%ecx) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_arpl:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    arpl %ax, (%ecx) # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_arpl:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    arpl %ax, (%ecx) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "arpl $0, $1", "r,*m"(i16 %a0, i16 *%a1)
  ret void
}

define void @test_bound(i16 %a0, i16 *%a1, i32 %a2, i32 *%a3) optsize {
; GENERIC-LABEL: test_bound:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pushl %esi
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    .cfi_offset %esi, -8
; GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %esi
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    bound %ax, (%esi)
; GENERIC-NEXT:    bound %ecx, (%edx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    popl %esi
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_bound:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pushl %esi # sched: [1:1.00]
; ATOM-NEXT:    .cfi_def_cfa_offset 8
; ATOM-NEXT:    .cfi_offset %esi, -8
; ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    bound %ax, (%esi) # sched: [11:5.50]
; ATOM-NEXT:    bound %ecx, (%edx) # sched: [11:5.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    popl %esi # sched: [1:1.00]
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_bound:
; SLM:       # %bb.0:
; SLM-NEXT:    pushl %esi # sched: [1:1.00]
; SLM-NEXT:    .cfi_def_cfa_offset 8
; SLM-NEXT:    .cfi_offset %esi, -8
; SLM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    bound %ax, (%esi) # sched: [100:1.00]
; SLM-NEXT:    bound %ecx, (%edx) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    popl %esi # sched: [3:1.00]
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_bound:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pushl %esi # sched: [5:1.00]
; SANDY-NEXT:    .cfi_def_cfa_offset 8
; SANDY-NEXT:    .cfi_offset %esi, -8
; SANDY-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    bound %ax, (%esi) # sched: [100:0.33]
; SANDY-NEXT:    bound %ecx, (%edx) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    popl %esi # sched: [6:0.50]
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_bound:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pushl %esi # sched: [2:1.00]
; HASWELL-NEXT:    .cfi_def_cfa_offset 8
; HASWELL-NEXT:    .cfi_offset %esi, -8
; HASWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    bound %ax, (%esi) # sched: [1:?]
; HASWELL-NEXT:    bound %ecx, (%edx) # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    popl %esi # sched: [6:0.50]
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_bound:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pushl %esi # sched: [2:1.00]
; BROADWELL-NEXT:    .cfi_def_cfa_offset 8
; BROADWELL-NEXT:    .cfi_offset %esi, -8
; BROADWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    bound %ax, (%esi) # sched: [100:0.25]
; BROADWELL-NEXT:    bound %ecx, (%edx) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    popl %esi # sched: [6:0.50]
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_bound:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pushl %esi # sched: [2:1.00]
; SKYLAKE-NEXT:    .cfi_def_cfa_offset 8
; SKYLAKE-NEXT:    .cfi_offset %esi, -8
; SKYLAKE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    bound %ax, (%esi) # sched: [100:0.25]
; SKYLAKE-NEXT:    bound %ecx, (%edx) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    popl %esi # sched: [6:0.50]
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_bound:
; SKX:       # %bb.0:
; SKX-NEXT:    pushl %esi # sched: [2:1.00]
; SKX-NEXT:    .cfi_def_cfa_offset 8
; SKX-NEXT:    .cfi_offset %esi, -8
; SKX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    bound %ax, (%esi) # sched: [100:0.25]
; SKX-NEXT:    bound %ecx, (%edx) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    popl %esi # sched: [6:0.50]
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_bound:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pushl %esi # sched: [1:1.00]
; BTVER2-NEXT:    .cfi_def_cfa_offset 8
; BTVER2-NEXT:    .cfi_offset %esi, -8
; BTVER2-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    bound %ax, (%esi) # sched: [100:0.50]
; BTVER2-NEXT:    bound %ecx, (%edx) # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    popl %esi # sched: [5:1.00]
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_bound:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pushl %esi # sched: [1:0.50]
; ZNVER1-NEXT:    .cfi_def_cfa_offset 8
; ZNVER1-NEXT:    .cfi_offset %esi, -8
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %esi # sched: [8:0.50]
; ZNVER1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    bound %ax, (%esi) # sched: [100:?]
; ZNVER1-NEXT:    bound %ecx, (%edx) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    popl %esi # sched: [8:0.50]
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "bound $0, $1 \0A\09 bound $2, $3", "r,*m,r,*m"(i16 %a0, i16 *%a1, i32 %a2, i32 *%a3)
  ret void
}

define i8 @test_daa(i8 %a0) optsize {
; GENERIC-LABEL: test_daa:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movb {{[0-9]+}}(%esp), %al
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    daa
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_daa:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    daa # sched: [18:9.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_daa:
; SLM:       # %bb.0:
; SLM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    daa # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_daa:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    daa # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_daa:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    daa # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_daa:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    daa # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_daa:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    daa # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_daa:
; SKX:       # %bb.0:
; SKX-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    daa # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_daa:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    daa # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_daa:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    daa # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i8 asm "daa", "=r,r"(i8 %a0) nounwind
  ret i8 %1
}

define i8 @test_das(i8 %a0) optsize {
; GENERIC-LABEL: test_das:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movb {{[0-9]+}}(%esp), %al
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    das
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_das:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    das # sched: [20:10.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_das:
; SLM:       # %bb.0:
; SLM-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    das # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_das:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    das # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_das:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    das # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_das:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    das # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_das:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    das # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_das:
; SKX:       # %bb.0:
; SKX-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    das # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_das:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    das # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_das:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movb {{[0-9]+}}(%esp), %al # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    das # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i8 asm "das", "=r,r"(i8 %a0) nounwind
  ret i8 %1
}

define void @test_dec16(i16 %a0, i16* %a1) optsize {
; GENERIC-LABEL: test_dec16:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    decw %ax
; GENERIC-NEXT:    decw (%ecx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_dec16:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    decw %ax # sched: [1:0.50]
; ATOM-NEXT:    decw (%ecx) # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_dec16:
; SLM:       # %bb.0:
; SLM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    decw %ax # sched: [1:0.50]
; SLM-NEXT:    decw (%ecx) # sched: [4:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_dec16:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    decw %ax # sched: [1:0.33]
; SANDY-NEXT:    decw (%ecx) # sched: [7:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_dec16:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    decw %ax # sched: [1:0.25]
; HASWELL-NEXT:    decw (%ecx) # sched: [7:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_dec16:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    decw %ax # sched: [1:0.25]
; BROADWELL-NEXT:    decw (%ecx) # sched: [6:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_dec16:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    decw %ax # sched: [1:0.25]
; SKYLAKE-NEXT:    decw (%ecx) # sched: [6:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_dec16:
; SKX:       # %bb.0:
; SKX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    decw %ax # sched: [1:0.25]
; SKX-NEXT:    decw (%ecx) # sched: [6:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_dec16:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    decw %ax # sched: [1:0.50]
; BTVER2-NEXT:    decw (%ecx) # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_dec16:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    decw %ax # sched: [1:0.25]
; ZNVER1-NEXT:    decw (%ecx) # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm "decw $0 \0A\09 decw $1", "r,*m"(i16 %a0, i16* %a1) nounwind
  ret void
}
define void @test_dec32(i32 %a0, i32* %a1) optsize {
; GENERIC-LABEL: test_dec32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    decl %eax
; GENERIC-NEXT:    decl (%ecx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_dec32:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    decl %eax # sched: [1:0.50]
; ATOM-NEXT:    decl (%ecx) # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_dec32:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    decl %eax # sched: [1:0.50]
; SLM-NEXT:    decl (%ecx) # sched: [4:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_dec32:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    decl %eax # sched: [1:0.33]
; SANDY-NEXT:    decl (%ecx) # sched: [7:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_dec32:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    decl %eax # sched: [1:0.25]
; HASWELL-NEXT:    decl (%ecx) # sched: [7:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_dec32:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    decl %eax # sched: [1:0.25]
; BROADWELL-NEXT:    decl (%ecx) # sched: [6:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_dec32:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    decl %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    decl (%ecx) # sched: [6:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_dec32:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    decl %eax # sched: [1:0.25]
; SKX-NEXT:    decl (%ecx) # sched: [6:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_dec32:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    decl %eax # sched: [1:0.50]
; BTVER2-NEXT:    decl (%ecx) # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_dec32:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    decl %eax # sched: [1:0.25]
; ZNVER1-NEXT:    decl (%ecx) # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm "decl $0 \0A\09 decl $1", "r,*m"(i32 %a0, i32* %a1) nounwind
  ret void
}

define void @test_inc16(i16 %a0, i16* %a1) optsize {
; GENERIC-LABEL: test_inc16:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    incw %ax
; GENERIC-NEXT:    incw (%ecx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_inc16:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    incw %ax # sched: [1:0.50]
; ATOM-NEXT:    incw (%ecx) # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_inc16:
; SLM:       # %bb.0:
; SLM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    incw %ax # sched: [1:0.50]
; SLM-NEXT:    incw (%ecx) # sched: [4:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_inc16:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    incw %ax # sched: [1:0.33]
; SANDY-NEXT:    incw (%ecx) # sched: [7:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_inc16:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    incw %ax # sched: [1:0.25]
; HASWELL-NEXT:    incw (%ecx) # sched: [7:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_inc16:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    incw %ax # sched: [1:0.25]
; BROADWELL-NEXT:    incw (%ecx) # sched: [6:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_inc16:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    incw %ax # sched: [1:0.25]
; SKYLAKE-NEXT:    incw (%ecx) # sched: [6:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_inc16:
; SKX:       # %bb.0:
; SKX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    incw %ax # sched: [1:0.25]
; SKX-NEXT:    incw (%ecx) # sched: [6:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_inc16:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    incw %ax # sched: [1:0.50]
; BTVER2-NEXT:    incw (%ecx) # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_inc16:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    incw %ax # sched: [1:0.25]
; ZNVER1-NEXT:    incw (%ecx) # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm "incw $0 \0A\09 incw $1", "r,*m"(i16 %a0, i16* %a1) nounwind
  ret void
}
define void @test_inc32(i32 %a0, i32* %a1) optsize {
; GENERIC-LABEL: test_inc32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    incl %eax
; GENERIC-NEXT:    incl (%ecx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_inc32:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    incl %eax # sched: [1:0.50]
; ATOM-NEXT:    incl (%ecx) # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_inc32:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    incl %eax # sched: [1:0.50]
; SLM-NEXT:    incl (%ecx) # sched: [4:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_inc32:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    incl %eax # sched: [1:0.33]
; SANDY-NEXT:    incl (%ecx) # sched: [7:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_inc32:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    incl %eax # sched: [1:0.25]
; HASWELL-NEXT:    incl (%ecx) # sched: [7:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_inc32:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    incl %eax # sched: [1:0.25]
; BROADWELL-NEXT:    incl (%ecx) # sched: [6:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_inc32:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    incl %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    incl (%ecx) # sched: [6:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_inc32:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    incl %eax # sched: [1:0.25]
; SKX-NEXT:    incl (%ecx) # sched: [6:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_inc32:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    incl %eax # sched: [1:0.50]
; BTVER2-NEXT:    incl (%ecx) # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_inc32:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    incl %eax # sched: [1:0.25]
; ZNVER1-NEXT:    incl (%ecx) # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm "incl $0 \0A\09 incl $1", "r,*m"(i32 %a0, i32* %a1) nounwind
  ret void
}

define void @test_into() optsize {
; GENERIC-LABEL: test_into:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    into
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_into:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    into # sched: [0:?]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_into:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    into # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_into:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    into # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_into:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    into # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_into:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    into # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_into:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    into # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_into:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    into # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_into:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    into # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_into:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    into # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "into", ""()
  ret void
}

define void @test_jcxz_jecxz() optsize {
; GENERIC-LABEL: test_jcxz_jecxz:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:  JXTGT:
; GENERIC-NEXT:    jcxz JXTGT
; GENERIC-NEXT:    jecxz JXTGT
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_jcxz_jecxz:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:  JXTGT:
; ATOM-NEXT:    jcxz JXTGT # sched: [4:2.00]
; ATOM-NEXT:    jecxz JXTGT # sched: [4:2.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_jcxz_jecxz:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:  JXTGT:
; SLM-NEXT:    jcxz JXTGT # sched: [1:1.00]
; SLM-NEXT:    jecxz JXTGT # sched: [1:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_jcxz_jecxz:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:  JXTGT:
; SANDY-NEXT:    jcxz JXTGT # sched: [1:1.00]
; SANDY-NEXT:    jecxz JXTGT # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_jcxz_jecxz:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:  JXTGT:
; HASWELL-NEXT:    jcxz JXTGT # sched: [1:0.50]
; HASWELL-NEXT:    jecxz JXTGT # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_jcxz_jecxz:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:  JXTGT:
; BROADWELL-NEXT:    jcxz JXTGT # sched: [1:0.50]
; BROADWELL-NEXT:    jecxz JXTGT # sched: [1:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_jcxz_jecxz:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:  JXTGT:
; SKYLAKE-NEXT:    jcxz JXTGT # sched: [1:0.50]
; SKYLAKE-NEXT:    jecxz JXTGT # sched: [1:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_jcxz_jecxz:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:  JXTGT:
; SKX-NEXT:    jcxz JXTGT # sched: [1:0.50]
; SKX-NEXT:    jecxz JXTGT # sched: [1:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_jcxz_jecxz:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:  JXTGT:
; BTVER2-NEXT:    jcxz JXTGT # sched: [1:0.50]
; BTVER2-NEXT:    jecxz JXTGT # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_jcxz_jecxz:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:  JXTGT:
; ZNVER1-NEXT:    jcxz JXTGT # sched: [1:0.50]
; ZNVER1-NEXT:    jecxz JXTGT # sched: [1:0.25]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "JXTGT: \0A\09 jcxz JXTGT \0A\09 jecxz JXTGT", ""()
  ret void
}

define void @test_leave() optsize {
; GENERIC-LABEL: test_leave:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    leave
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_leave:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    leave # sched: [2:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_leave:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    leave # sched: [1:0.50]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_leave:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    leave # sched: [1:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_leave:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    leave # sched: [1:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_leave:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    leave # sched: [1:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_leave:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    leave # sched: [1:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_leave:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    leave # sched: [1:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_leave:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    leave # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_leave:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    leave # sched: [8:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm "leave", ""() nounwind
  ret void
}

define void @test_pop_push() optsize {
; GENERIC-LABEL: test_pop_push:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    popl %ds
; GENERIC-NEXT:    popl %es
; GENERIC-NEXT:    popl %ss
; GENERIC-NEXT:    popl %fs
; GENERIC-NEXT:    popl %gs
; GENERIC-NEXT:    pushl %cs
; GENERIC-NEXT:    pushl %ds
; GENERIC-NEXT:    pushl %es
; GENERIC-NEXT:    pushl %ss
; GENERIC-NEXT:    pushl %fs
; GENERIC-NEXT:    pushl %gs
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_pop_push:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    popl %ds # sched: [29:14.50]
; ATOM-NEXT:    popl %es # sched: [29:14.50]
; ATOM-NEXT:    popl %ss # sched: [48:24.00]
; ATOM-NEXT:    popl %fs # sched: [29:14.50]
; ATOM-NEXT:    popl %gs # sched: [29:14.50]
; ATOM-NEXT:    pushl %cs # sched: [2:1.00]
; ATOM-NEXT:    pushl %ds # sched: [2:1.00]
; ATOM-NEXT:    pushl %es # sched: [2:1.00]
; ATOM-NEXT:    pushl %ss # sched: [2:1.00]
; ATOM-NEXT:    pushl %fs # sched: [2:1.00]
; ATOM-NEXT:    pushl %gs # sched: [2:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_pop_push:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    popl %ds # sched: [100:1.00]
; SLM-NEXT:    popl %es # sched: [100:1.00]
; SLM-NEXT:    popl %ss # sched: [100:1.00]
; SLM-NEXT:    popl %fs # sched: [100:1.00]
; SLM-NEXT:    popl %gs # sched: [100:1.00]
; SLM-NEXT:    pushl %cs # sched: [100:1.00]
; SLM-NEXT:    pushl %ds # sched: [100:1.00]
; SLM-NEXT:    pushl %es # sched: [100:1.00]
; SLM-NEXT:    pushl %ss # sched: [100:1.00]
; SLM-NEXT:    pushl %fs # sched: [100:1.00]
; SLM-NEXT:    pushl %gs # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_pop_push:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    popl %ds # sched: [100:0.33]
; SANDY-NEXT:    popl %es # sched: [100:0.33]
; SANDY-NEXT:    popl %ss # sched: [100:0.33]
; SANDY-NEXT:    popl %fs # sched: [100:0.33]
; SANDY-NEXT:    popl %gs # sched: [100:0.33]
; SANDY-NEXT:    pushl %cs # sched: [100:0.33]
; SANDY-NEXT:    pushl %ds # sched: [100:0.33]
; SANDY-NEXT:    pushl %es # sched: [100:0.33]
; SANDY-NEXT:    pushl %ss # sched: [100:0.33]
; SANDY-NEXT:    pushl %fs # sched: [100:0.33]
; SANDY-NEXT:    pushl %gs # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_pop_push:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    popl %ds # sched: [100:0.25]
; HASWELL-NEXT:    popl %es # sched: [100:0.25]
; HASWELL-NEXT:    popl %ss # sched: [100:0.25]
; HASWELL-NEXT:    popl %fs # sched: [100:0.25]
; HASWELL-NEXT:    popl %gs # sched: [100:0.25]
; HASWELL-NEXT:    pushl %cs # sched: [100:0.25]
; HASWELL-NEXT:    pushl %ds # sched: [100:0.25]
; HASWELL-NEXT:    pushl %es # sched: [100:0.25]
; HASWELL-NEXT:    pushl %ss # sched: [100:0.25]
; HASWELL-NEXT:    pushl %fs # sched: [100:0.25]
; HASWELL-NEXT:    pushl %gs # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pop_push:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    popl %ds # sched: [100:0.25]
; BROADWELL-NEXT:    popl %es # sched: [100:0.25]
; BROADWELL-NEXT:    popl %ss # sched: [100:0.25]
; BROADWELL-NEXT:    popl %fs # sched: [100:0.25]
; BROADWELL-NEXT:    popl %gs # sched: [100:0.25]
; BROADWELL-NEXT:    pushl %cs # sched: [100:0.25]
; BROADWELL-NEXT:    pushl %ds # sched: [100:0.25]
; BROADWELL-NEXT:    pushl %es # sched: [100:0.25]
; BROADWELL-NEXT:    pushl %ss # sched: [100:0.25]
; BROADWELL-NEXT:    pushl %fs # sched: [100:0.25]
; BROADWELL-NEXT:    pushl %gs # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_pop_push:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    popl %ds # sched: [100:0.25]
; SKYLAKE-NEXT:    popl %es # sched: [100:0.25]
; SKYLAKE-NEXT:    popl %ss # sched: [100:0.25]
; SKYLAKE-NEXT:    popl %fs # sched: [100:0.25]
; SKYLAKE-NEXT:    popl %gs # sched: [100:0.25]
; SKYLAKE-NEXT:    pushl %cs # sched: [100:0.25]
; SKYLAKE-NEXT:    pushl %ds # sched: [100:0.25]
; SKYLAKE-NEXT:    pushl %es # sched: [100:0.25]
; SKYLAKE-NEXT:    pushl %ss # sched: [100:0.25]
; SKYLAKE-NEXT:    pushl %fs # sched: [100:0.25]
; SKYLAKE-NEXT:    pushl %gs # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_pop_push:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    popl %ds # sched: [100:0.25]
; SKX-NEXT:    popl %es # sched: [100:0.25]
; SKX-NEXT:    popl %ss # sched: [100:0.25]
; SKX-NEXT:    popl %fs # sched: [100:0.25]
; SKX-NEXT:    popl %gs # sched: [100:0.25]
; SKX-NEXT:    pushl %cs # sched: [100:0.25]
; SKX-NEXT:    pushl %ds # sched: [100:0.25]
; SKX-NEXT:    pushl %es # sched: [100:0.25]
; SKX-NEXT:    pushl %ss # sched: [100:0.25]
; SKX-NEXT:    pushl %fs # sched: [100:0.25]
; SKX-NEXT:    pushl %gs # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_pop_push:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    popl %ds # sched: [100:0.50]
; BTVER2-NEXT:    popl %es # sched: [100:0.50]
; BTVER2-NEXT:    popl %ss # sched: [100:0.50]
; BTVER2-NEXT:    popl %fs # sched: [100:0.50]
; BTVER2-NEXT:    popl %gs # sched: [100:0.50]
; BTVER2-NEXT:    pushl %cs # sched: [100:0.50]
; BTVER2-NEXT:    pushl %ds # sched: [100:0.50]
; BTVER2-NEXT:    pushl %es # sched: [100:0.50]
; BTVER2-NEXT:    pushl %ss # sched: [100:0.50]
; BTVER2-NEXT:    pushl %fs # sched: [100:0.50]
; BTVER2-NEXT:    pushl %gs # sched: [100:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pop_push:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    popl %ds # sched: [100:?]
; ZNVER1-NEXT:    popl %es # sched: [100:?]
; ZNVER1-NEXT:    popl %ss # sched: [100:?]
; ZNVER1-NEXT:    popl %fs # sched: [100:?]
; ZNVER1-NEXT:    popl %gs # sched: [100:?]
; ZNVER1-NEXT:    pushl %cs # sched: [100:?]
; ZNVER1-NEXT:    pushl %ds # sched: [100:?]
; ZNVER1-NEXT:    pushl %es # sched: [100:?]
; ZNVER1-NEXT:    pushl %ss # sched: [100:?]
; ZNVER1-NEXT:    pushl %fs # sched: [100:?]
; ZNVER1-NEXT:    pushl %gs # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "pop %DS \0A\09 pop %ES \0A\09 pop %SS \0A\09 pop %FS \0A\09 pop %GS \0A\09 push %CS \0A\09 push %DS \0A\09 push %ES \0A\09 push %SS \0A\09 push %FS \0A\09 push %GS", ""()
  ret void
}
define i16 @test_pop_push_16(i16 %a0, i16 *%a1) optsize {
; GENERIC-LABEL: test_pop_push_16:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    popw %ax
; GENERIC-NEXT:    popw (%ecx)
; GENERIC-NEXT:    pushw %ax
; GENERIC-NEXT:    pushw (%ecx)
; GENERIC-NEXT:    pushw $4095 # imm = 0xFFF
; GENERIC-NEXT:    pushw $7
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_pop_push_16:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    popw %ax # sched: [2:1.00]
; ATOM-NEXT:    popw (%ecx) # sched: [3:1.50]
; ATOM-NEXT:    pushw %ax # sched: [1:1.00]
; ATOM-NEXT:    pushw (%ecx) # sched: [2:1.00]
; ATOM-NEXT:    pushw $4095 # imm = 0xFFF
; ATOM-NEXT:    # sched: [1:1.00]
; ATOM-NEXT:    pushw $7 # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_pop_push_16:
; SLM:       # %bb.0:
; SLM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    popw %ax # sched: [3:1.00]
; SLM-NEXT:    popw (%ecx) # sched: [1:1.00]
; SLM-NEXT:    pushw %ax # sched: [1:1.00]
; SLM-NEXT:    pushw (%ecx) # sched: [1:1.00]
; SLM-NEXT:    pushw $4095 # imm = 0xFFF
; SLM-NEXT:    # sched: [1:1.00]
; SLM-NEXT:    pushw $7 # sched: [1:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_pop_push_16:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    popw %ax # sched: [6:0.50]
; SANDY-NEXT:    popw (%ecx) # sched: [6:0.50]
; SANDY-NEXT:    pushw %ax # sched: [5:1.00]
; SANDY-NEXT:    pushw (%ecx) # sched: [5:1.00]
; SANDY-NEXT:    pushw $4095 # imm = 0xFFF
; SANDY-NEXT:    # sched: [1:1.00]
; SANDY-NEXT:    pushw $7 # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_pop_push_16:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    popw %ax # sched: [6:0.50]
; HASWELL-NEXT:    popw (%ecx) # sched: [1:1.00]
; HASWELL-NEXT:    pushw %ax # sched: [2:1.00]
; HASWELL-NEXT:    pushw (%ecx) # sched: [1:1.00]
; HASWELL-NEXT:    pushw $4095 # imm = 0xFFF
; HASWELL-NEXT:    # sched: [1:1.00]
; HASWELL-NEXT:    pushw $7 # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pop_push_16:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    popw %ax # sched: [6:0.50]
; BROADWELL-NEXT:    popw (%ecx) # sched: [6:0.50]
; BROADWELL-NEXT:    pushw %ax # sched: [2:1.00]
; BROADWELL-NEXT:    pushw (%ecx) # sched: [2:1.00]
; BROADWELL-NEXT:    pushw $4095 # imm = 0xFFF
; BROADWELL-NEXT:    # sched: [1:1.00]
; BROADWELL-NEXT:    pushw $7 # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_pop_push_16:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    popw %ax # sched: [6:0.50]
; SKYLAKE-NEXT:    popw (%ecx) # sched: [6:0.50]
; SKYLAKE-NEXT:    pushw %ax # sched: [2:1.00]
; SKYLAKE-NEXT:    pushw (%ecx) # sched: [2:1.00]
; SKYLAKE-NEXT:    pushw $4095 # imm = 0xFFF
; SKYLAKE-NEXT:    # sched: [1:1.00]
; SKYLAKE-NEXT:    pushw $7 # sched: [1:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_pop_push_16:
; SKX:       # %bb.0:
; SKX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    popw %ax # sched: [6:0.50]
; SKX-NEXT:    popw (%ecx) # sched: [6:0.50]
; SKX-NEXT:    pushw %ax # sched: [2:1.00]
; SKX-NEXT:    pushw (%ecx) # sched: [2:1.00]
; SKX-NEXT:    pushw $4095 # imm = 0xFFF
; SKX-NEXT:    # sched: [1:1.00]
; SKX-NEXT:    pushw $7 # sched: [1:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_pop_push_16:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [4:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    popw %ax # sched: [5:1.00]
; BTVER2-NEXT:    popw (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    pushw %ax # sched: [1:1.00]
; BTVER2-NEXT:    pushw (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    pushw $4095 # imm = 0xFFF
; BTVER2-NEXT:    # sched: [1:1.00]
; BTVER2-NEXT:    pushw $7 # sched: [1:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pop_push_16:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    popw %ax # sched: [8:0.50]
; ZNVER1-NEXT:    popw (%ecx) # sched: [5:0.50]
; ZNVER1-NEXT:    pushw %ax # sched: [1:0.50]
; ZNVER1-NEXT:    pushw (%ecx) # sched: [4:0.50]
; ZNVER1-NEXT:    pushw $4095 # imm = 0xFFF
; ZNVER1-NEXT:    # sched: [1:0.50]
; ZNVER1-NEXT:    pushw $7 # sched: [1:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = call i16 asm sideeffect "popw $0 \0A\09 popw $2 \0A\09 pushw $1 \0A\09 pushw $2 \0A\09 pushw $3 \0A\09 pushw $4", "=r,r,*m,i,i"(i16 %a0, i16 *%a1, i16 4095, i8 7)
  ret i16 %1
}
define i32 @test_pop_push_32(i32 %a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_pop_push_32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    popl %eax
; GENERIC-NEXT:    popl (%ecx)
; GENERIC-NEXT:    pushl %eax
; GENERIC-NEXT:    pushl (%ecx)
; GENERIC-NEXT:    pushl $4095 # imm = 0xFFF
; GENERIC-NEXT:    pushl $7
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_pop_push_32:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    popl %eax # sched: [1:1.00]
; ATOM-NEXT:    popl (%ecx) # sched: [3:1.50]
; ATOM-NEXT:    pushl %eax # sched: [1:1.00]
; ATOM-NEXT:    pushl (%ecx) # sched: [2:1.00]
; ATOM-NEXT:    pushl $4095 # imm = 0xFFF
; ATOM-NEXT:    # sched: [1:1.00]
; ATOM-NEXT:    pushl $7 # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_pop_push_32:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    popl %eax # sched: [3:1.00]
; SLM-NEXT:    popl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    pushl %eax # sched: [1:1.00]
; SLM-NEXT:    pushl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    pushl $4095 # imm = 0xFFF
; SLM-NEXT:    # sched: [1:1.00]
; SLM-NEXT:    pushl $7 # sched: [1:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_pop_push_32:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    popl %eax # sched: [6:0.50]
; SANDY-NEXT:    popl (%ecx) # sched: [6:0.50]
; SANDY-NEXT:    pushl %eax # sched: [5:1.00]
; SANDY-NEXT:    pushl (%ecx) # sched: [5:1.00]
; SANDY-NEXT:    pushl $4095 # imm = 0xFFF
; SANDY-NEXT:    # sched: [1:1.00]
; SANDY-NEXT:    pushl $7 # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_pop_push_32:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    popl %eax # sched: [6:0.50]
; HASWELL-NEXT:    popl (%ecx) # sched: [1:1.00]
; HASWELL-NEXT:    pushl %eax # sched: [2:1.00]
; HASWELL-NEXT:    pushl (%ecx) # sched: [1:1.00]
; HASWELL-NEXT:    pushl $4095 # imm = 0xFFF
; HASWELL-NEXT:    # sched: [1:1.00]
; HASWELL-NEXT:    pushl $7 # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pop_push_32:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    popl %eax # sched: [6:0.50]
; BROADWELL-NEXT:    popl (%ecx) # sched: [6:0.50]
; BROADWELL-NEXT:    pushl %eax # sched: [2:1.00]
; BROADWELL-NEXT:    pushl (%ecx) # sched: [2:1.00]
; BROADWELL-NEXT:    pushl $4095 # imm = 0xFFF
; BROADWELL-NEXT:    # sched: [1:1.00]
; BROADWELL-NEXT:    pushl $7 # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_pop_push_32:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    popl %eax # sched: [6:0.50]
; SKYLAKE-NEXT:    popl (%ecx) # sched: [6:0.50]
; SKYLAKE-NEXT:    pushl %eax # sched: [2:1.00]
; SKYLAKE-NEXT:    pushl (%ecx) # sched: [2:1.00]
; SKYLAKE-NEXT:    pushl $4095 # imm = 0xFFF
; SKYLAKE-NEXT:    # sched: [1:1.00]
; SKYLAKE-NEXT:    pushl $7 # sched: [1:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_pop_push_32:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    popl %eax # sched: [6:0.50]
; SKX-NEXT:    popl (%ecx) # sched: [6:0.50]
; SKX-NEXT:    pushl %eax # sched: [2:1.00]
; SKX-NEXT:    pushl (%ecx) # sched: [2:1.00]
; SKX-NEXT:    pushl $4095 # imm = 0xFFF
; SKX-NEXT:    # sched: [1:1.00]
; SKX-NEXT:    pushl $7 # sched: [1:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_pop_push_32:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    popl %eax # sched: [5:1.00]
; BTVER2-NEXT:    popl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    pushl %eax # sched: [1:1.00]
; BTVER2-NEXT:    pushl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    pushl $4095 # imm = 0xFFF
; BTVER2-NEXT:    # sched: [1:1.00]
; BTVER2-NEXT:    pushl $7 # sched: [1:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pop_push_32:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    popl %eax # sched: [8:0.50]
; ZNVER1-NEXT:    popl (%ecx) # sched: [1:0.50]
; ZNVER1-NEXT:    pushl %eax # sched: [1:0.50]
; ZNVER1-NEXT:    pushl (%ecx) # sched: [4:0.50]
; ZNVER1-NEXT:    pushl $4095 # imm = 0xFFF
; ZNVER1-NEXT:    # sched: [1:0.50]
; ZNVER1-NEXT:    pushl $7 # sched: [1:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = call i32 asm sideeffect "popl $0 \0A\09 popl $2 \0A\09 pushl $1 \0A\09 pushl $2 \0A\09 pushl $3 \0A\09 pushl $4", "=r,r,*m,i,i"(i32 %a0, i32 *%a1, i32 4095, i8 7)
  ret i32 %1
}

define void @test_popa_popf_pusha_pushf() optsize {
; GENERIC-LABEL: test_popa_popf_pusha_pushf:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    popal
; GENERIC-NEXT:    popfl
; GENERIC-NEXT:    pushal
; GENERIC-NEXT:    pushfl
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_popa_popf_pusha_pushf:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    popal # sched: [9:4.50]
; ATOM-NEXT:    popfl # sched: [26:13.00]
; ATOM-NEXT:    pushal # sched: [8:4.00]
; ATOM-NEXT:    pushfl # sched: [9:4.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_popa_popf_pusha_pushf:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    popal # sched: [3:1.00]
; SLM-NEXT:    popfl # sched: [3:1.00]
; SLM-NEXT:    pushal # sched: [1:1.00]
; SLM-NEXT:    pushfl # sched: [1:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_popa_popf_pusha_pushf:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    popal # sched: [4:0.50]
; SANDY-NEXT:    popfl # sched: [4:0.50]
; SANDY-NEXT:    pushal # sched: [1:1.00]
; SANDY-NEXT:    pushfl # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_popa_popf_pusha_pushf:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    popal # sched: [1:?]
; HASWELL-NEXT:    popfl # sched: [5:0.50]
; HASWELL-NEXT:    pushal # sched: [1:?]
; HASWELL-NEXT:    pushfl # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_popa_popf_pusha_pushf:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    popal # sched: [5:0.50]
; BROADWELL-NEXT:    popfl # sched: [5:0.50]
; BROADWELL-NEXT:    pushal # sched: [1:1.00]
; BROADWELL-NEXT:    pushfl # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_popa_popf_pusha_pushf:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    popal # sched: [5:0.50]
; SKYLAKE-NEXT:    popfl # sched: [5:0.50]
; SKYLAKE-NEXT:    pushal # sched: [1:1.00]
; SKYLAKE-NEXT:    pushfl # sched: [1:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_popa_popf_pusha_pushf:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    popal # sched: [5:0.50]
; SKX-NEXT:    popfl # sched: [5:0.50]
; SKX-NEXT:    pushal # sched: [1:1.00]
; SKX-NEXT:    pushfl # sched: [1:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_popa_popf_pusha_pushf:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    popal # sched: [5:1.00]
; BTVER2-NEXT:    popfl # sched: [5:1.00]
; BTVER2-NEXT:    pushal # sched: [1:1.00]
; BTVER2-NEXT:    pushfl # sched: [1:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_popa_popf_pusha_pushf:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    popal # sched: [100:?]
; ZNVER1-NEXT:    popfl # sched: [100:?]
; ZNVER1-NEXT:    pushal # sched: [8:0.50]
; ZNVER1-NEXT:    pushfl # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "popa \0A\09 popf \0A\09 pusha \0A\09 pushf", ""()
  ret void
}

define void @test_ret() optsize {
; GENERIC-LABEL: test_ret:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    retl
; GENERIC-NEXT:    retl $4095 # imm = 0xFFF
; GENERIC-NEXT:    lretl
; GENERIC-NEXT:    lretl $4095 # imm = 0xFFF
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_ret:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    retl # sched: [79:39.50]
; ATOM-NEXT:    retl $4095 # imm = 0xFFF
; ATOM-NEXT:    # sched: [1:1.00]
; ATOM-NEXT:    lretl # sched: [79:39.50]
; ATOM-NEXT:    lretl $4095 # imm = 0xFFF
; ATOM-NEXT:    # sched: [79:39.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_ret:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    retl # sched: [4:1.00]
; SLM-NEXT:    retl $4095 # imm = 0xFFF
; SLM-NEXT:    # sched: [4:1.00]
; SLM-NEXT:    lretl # sched: [4:1.00]
; SLM-NEXT:    lretl $4095 # imm = 0xFFF
; SLM-NEXT:    # sched: [4:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_ret:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    retl # sched: [5:1.00]
; SANDY-NEXT:    retl $4095 # imm = 0xFFF
; SANDY-NEXT:    # sched: [5:1.00]
; SANDY-NEXT:    lretl # sched: [5:1.00]
; SANDY-NEXT:    lretl $4095 # imm = 0xFFF
; SANDY-NEXT:    # sched: [5:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_ret:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
; HASWELL-NEXT:    retl $4095 # imm = 0xFFF
; HASWELL-NEXT:    # sched: [1:2.00]
; HASWELL-NEXT:    lretl # sched: [6:0.50]
; HASWELL-NEXT:    lretl $4095 # imm = 0xFFF
; HASWELL-NEXT:    # sched: [1:2.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ret:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
; BROADWELL-NEXT:    retl $4095 # imm = 0xFFF
; BROADWELL-NEXT:    # sched: [6:0.50]
; BROADWELL-NEXT:    lretl # sched: [6:0.50]
; BROADWELL-NEXT:    lretl $4095 # imm = 0xFFF
; BROADWELL-NEXT:    # sched: [6:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_ret:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
; SKYLAKE-NEXT:    retl $4095 # imm = 0xFFF
; SKYLAKE-NEXT:    # sched: [6:0.50]
; SKYLAKE-NEXT:    lretl # sched: [6:0.50]
; SKYLAKE-NEXT:    lretl $4095 # imm = 0xFFF
; SKYLAKE-NEXT:    # sched: [6:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_ret:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    retl # sched: [6:0.50]
; SKX-NEXT:    retl $4095 # imm = 0xFFF
; SKX-NEXT:    # sched: [6:0.50]
; SKX-NEXT:    lretl # sched: [6:0.50]
; SKX-NEXT:    lretl $4095 # imm = 0xFFF
; SKX-NEXT:    # sched: [6:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_ret:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
; BTVER2-NEXT:    retl $4095 # imm = 0xFFF
; BTVER2-NEXT:    # sched: [4:1.00]
; BTVER2-NEXT:    lretl # sched: [4:1.00]
; BTVER2-NEXT:    lretl $4095 # imm = 0xFFF
; BTVER2-NEXT:    # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_ret:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
; ZNVER1-NEXT:    retl $4095 # imm = 0xFFF
; ZNVER1-NEXT:    # sched: [5:0.50]
; ZNVER1-NEXT:    lretl # sched: [1:0.50]
; ZNVER1-NEXT:    lretl $4095 # imm = 0xFFF
; ZNVER1-NEXT:    # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  call void asm sideeffect "ret \0A\09 ret $0 \0A\09 lret \0A\09 lret $0", "i"(i16 4095)
  ret void
}

define i8 @test_salc() optsize {
; GENERIC-LABEL: test_salc:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    salc
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_salc:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    salc # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_salc:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    salc # sched: [1:0.50]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_salc:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    salc # sched: [1:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_salc:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    salc # sched: [1:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_salc:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    salc # sched: [1:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_salc:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    salc # sched: [1:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_salc:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    salc # sched: [1:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_salc:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    salc # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_salc:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    salc # sched: [1:0.25]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  %1 = tail call i8 asm "salc", "=r"() nounwind
  ret i8 %1
}

define void @test_xchg_32(i32 %a0, i32 %a1, i32 *%a2) optsize {
; GENERIC-LABEL: test_xchg_32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    xchgl %eax, %eax
; GENERIC-NEXT:    xchgl %ecx, %eax
; GENERIC-NEXT:    xchgl %eax, (%edx)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_xchg_32:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    xchgl %eax, %eax # sched: [2:1.00]
; ATOM-NEXT:    xchgl %ecx, %eax # sched: [2:1.00]
; ATOM-NEXT:    xchgl %eax, (%edx) # sched: [3:1.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_xchg_32:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    xchgl %eax, %eax # sched: [1:0.50]
; SLM-NEXT:    xchgl %ecx, %eax # sched: [1:0.50]
; SLM-NEXT:    xchgl %eax, (%edx) # sched: [4:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_xchg_32:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    xchgl %eax, %eax # sched: [1:0.33]
; SANDY-NEXT:    xchgl %ecx, %eax # sched: [1:0.33]
; SANDY-NEXT:    xchgl %eax, (%edx) # sched: [5:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_xchg_32:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    xchgl %eax, %eax # sched: [1:0.25]
; HASWELL-NEXT:    xchgl %ecx, %eax # sched: [1:0.25]
; HASWELL-NEXT:    xchgl %eax, (%edx) # sched: [9:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_xchg_32:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    xchgl %eax, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    xchgl %ecx, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    xchgl %eax, (%edx) # sched: [8:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_xchg_32:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    xchgl %eax, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    xchgl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    xchgl %eax, (%edx) # sched: [10:1.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_xchg_32:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    xchgl %eax, %eax # sched: [1:0.25]
; SKX-NEXT:    xchgl %ecx, %eax # sched: [1:0.25]
; SKX-NEXT:    xchgl %eax, (%edx) # sched: [10:1.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_xchg_32:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    xchgl %eax, %eax # sched: [1:0.50]
; BTVER2-NEXT:    xchgl %ecx, %eax # sched: [1:0.50]
; BTVER2-NEXT:    xchgl %eax, (%edx) # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_xchg_32:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    xchgl %eax, %eax # sched: [1:0.50]
; ZNVER1-NEXT:    xchgl %ecx, %eax # sched: [1:0.50]
; ZNVER1-NEXT:    xchgl %eax, (%edx) # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm "xchg %EAX, $0 \0A\09 xchg $1, $0 \0A\09 xchg $2, $0", "r,r,*m"(i32 %a0, i32 %a1, i32 *%a2) nounwind
  ret void
}
