; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -aggressive-instcombine -S | FileCheck %s
; RUN: opt < %s -passes=aggressive-instcombine -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64"

; Aggressive Instcombine should be able to reduce width of these expressions.

declare i32 @use32(i32)
declare i32 @use64(i64)
declare <2 x i32> @use32_vec(<2 x i32>)
declare <2 x i32> @use64_vec(<2 x i64>)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; These tests check cases where expression dag post-dominated by TruncInst
;; contains instruction, which has more than one usage.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

define void @multi_uses_add(i32 %X) {
; CHECK-LABEL: @multi_uses_add(
; CHECK-NEXT:    [[A1:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[B1:%.*]] = add i32 [[X]], 15
; CHECK-NEXT:    [[C1:%.*]] = mul i32 [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @use64(i64 [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext i32 %X to i64
  %B1 = add i64 %A1, 15
  %C1 = mul i64 %B1, %B1
  %T1 = trunc i64 %C1 to i32
  call i32 @use32(i32 %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call i32 @use64(i64 %A1)
  ret void
}

define void @multi_uses_or(i32 %X) {
; CHECK-LABEL: @multi_uses_or(
; CHECK-NEXT:    [[A1:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[B1:%.*]] = or i32 [[X]], 15
; CHECK-NEXT:    [[C1:%.*]] = mul i32 [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @use64(i64 [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext i32 %X to i64
  %B1 = or i64 %A1, 15
  %C1 = mul i64 %B1, %B1
  %T1 = trunc i64 %C1 to i32
  call i32 @use32(i32 %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call i32 @use64(i64 %A1)
  ret void
}

define void @multi_uses_xor(i32 %X) {
; CHECK-LABEL: @multi_uses_xor(
; CHECK-NEXT:    [[A1:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[B1:%.*]] = xor i32 [[X]], 15
; CHECK-NEXT:    [[C1:%.*]] = mul i32 [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @use64(i64 [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext i32 %X to i64
  %B1 = xor i64 %A1, 15
  %C1 = mul i64 %B1, %B1
  %T1 = trunc i64 %C1 to i32
  call i32 @use32(i32 %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call i32 @use64(i64 %A1)
  ret void
}

define void @multi_uses_and(i32 %X) {
; CHECK-LABEL: @multi_uses_and(
; CHECK-NEXT:    [[A1:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[B1:%.*]] = and i32 [[X]], 15
; CHECK-NEXT:    [[C1:%.*]] = mul i32 [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @use64(i64 [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext i32 %X to i64
  %B1 = and i64 %A1, 15
  %C1 = mul i64 %B1, %B1
  %T1 = trunc i64 %C1 to i32
  call i32 @use32(i32 %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call i32 @use64(i64 %A1)
  ret void
}

define void @multi_uses_sub(i32 %X, i32 %Y) {
; CHECK-LABEL: @multi_uses_sub(
; CHECK-NEXT:    [[A1:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[A2:%.*]] = zext i32 [[Y:%.*]] to i64
; CHECK-NEXT:    [[B1:%.*]] = sub i32 [[X]], [[Y]]
; CHECK-NEXT:    [[C1:%.*]] = mul i32 [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @use64(i64 [[A1]])
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @use64(i64 [[A2]])
; CHECK-NEXT:    ret void
;
  %A1 = zext i32 %X to i64
  %A2 = zext i32 %Y to i64
  %B1 = sub i64 %A1, %A2
  %C1 = mul i64 %B1, %B1
  %T1 = trunc i64 %C1 to i32
  call i32 @use32(i32 %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call i32 @use64(i64 %A1)
  call i32 @use64(i64 %A2)
  ret void
}

define void @multi_use_vec_add(<2 x i32> %X) {
; CHECK-LABEL: @multi_use_vec_add(
; CHECK-NEXT:    [[A1:%.*]] = zext <2 x i32> [[X:%.*]] to <2 x i64>
; CHECK-NEXT:    [[B1:%.*]] = add <2 x i32> [[X]], <i32 15, i32 15>
; CHECK-NEXT:    [[C1:%.*]] = mul <2 x i32> [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i32> @use64_vec(<2 x i64> [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext <2 x i32> %X to <2 x i64>
  %B1 = add <2 x i64> %A1, <i64 15, i64 15>
  %C1 = mul <2 x i64> %B1, %B1
  %T1 = trunc <2 x i64> %C1 to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call <2 x i32> @use64_vec(<2 x i64> %A1)
  ret void
}

define void @multi_use_vec_or(<2 x i32> %X) {
; CHECK-LABEL: @multi_use_vec_or(
; CHECK-NEXT:    [[A1:%.*]] = zext <2 x i32> [[X:%.*]] to <2 x i64>
; CHECK-NEXT:    [[B1:%.*]] = or <2 x i32> [[X]], <i32 15, i32 15>
; CHECK-NEXT:    [[C1:%.*]] = mul <2 x i32> [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i32> @use64_vec(<2 x i64> [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext <2 x i32> %X to <2 x i64>
  %B1 = or <2 x i64> %A1, <i64 15, i64 15>
  %C1 = mul <2 x i64> %B1, %B1
  %T1 = trunc <2 x i64> %C1 to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call <2 x i32> @use64_vec(<2 x i64> %A1)
  ret void
}

define void @multi_use_vec_xor(<2 x i32> %X) {
; CHECK-LABEL: @multi_use_vec_xor(
; CHECK-NEXT:    [[A1:%.*]] = zext <2 x i32> [[X:%.*]] to <2 x i64>
; CHECK-NEXT:    [[B1:%.*]] = xor <2 x i32> [[X]], <i32 15, i32 15>
; CHECK-NEXT:    [[C1:%.*]] = mul <2 x i32> [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i32> @use64_vec(<2 x i64> [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext <2 x i32> %X to <2 x i64>
  %B1 = xor <2 x i64> %A1, <i64 15, i64 15>
  %C1 = mul <2 x i64> %B1, %B1
  %T1 = trunc <2 x i64> %C1 to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call <2 x i32> @use64_vec(<2 x i64> %A1)
  ret void
}

define void @multi_use_vec_and(<2 x i32> %X) {
; CHECK-LABEL: @multi_use_vec_and(
; CHECK-NEXT:    [[A1:%.*]] = zext <2 x i32> [[X:%.*]] to <2 x i64>
; CHECK-NEXT:    [[B1:%.*]] = and <2 x i32> [[X]], <i32 15, i32 15>
; CHECK-NEXT:    [[C1:%.*]] = mul <2 x i32> [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i32> @use64_vec(<2 x i64> [[A1]])
; CHECK-NEXT:    ret void
;
  %A1 = zext <2 x i32> %X to <2 x i64>
  %B1 = and <2 x i64> %A1, <i64 15, i64 15>
  %C1 = mul <2 x i64> %B1, %B1
  %T1 = trunc <2 x i64> %C1 to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call <2 x i32> @use64_vec(<2 x i64> %A1)
  ret void
}

define void @multi_use_vec_sub(<2 x i32> %X, <2 x i32> %Y) {
; CHECK-LABEL: @multi_use_vec_sub(
; CHECK-NEXT:    [[A1:%.*]] = zext <2 x i32> [[X:%.*]] to <2 x i64>
; CHECK-NEXT:    [[A2:%.*]] = zext <2 x i32> [[Y:%.*]] to <2 x i64>
; CHECK-NEXT:    [[B1:%.*]] = sub <2 x i32> [[X]], [[Y]]
; CHECK-NEXT:    [[C1:%.*]] = mul <2 x i32> [[B1]], [[B1]]
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> [[C1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i32> @use64_vec(<2 x i64> [[A1]])
; CHECK-NEXT:    [[TMP3:%.*]] = call <2 x i32> @use64_vec(<2 x i64> [[A2]])
; CHECK-NEXT:    ret void
;
  %A1 = zext <2 x i32> %X to <2 x i64>
  %A2 = zext <2 x i32> %Y to <2 x i64>
  %B1 = sub <2 x i64> %A1, %A2
  %C1 = mul <2 x i64> %B1, %B1
  %T1 = trunc <2 x i64> %C1 to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T1)
  ; make sure zext have another use that is not post-dominated by the TruncInst.
  call <2 x i32> @use64_vec(<2 x i64> %A1)
  call <2 x i32> @use64_vec(<2 x i64> %A2)
  ret void
}
