; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -aggressive-instcombine -S | FileCheck %s
; RUN: opt < %s -passes=aggressive-instcombine -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64"

; Aggressive Instcombine should be able to reduce width of these constant
; expressions, without crashing.

declare i32 @use32(i32)
declare <2 x i32> @use32_vec(<2 x i32>)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; These tests check cases where expression dag post-dominated by TruncInst
;; contains instruction, which has more than one usage.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

define void @const_expression_mul() {
; CHECK-LABEL: @const_expression_mul(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 242)
; CHECK-NEXT:    ret void
;
  %A = mul i64 11, 22
  %T = trunc i64 %A to i32
  call i32 @use32(i32 %T)
  ret void
}

define void @const_expression_zext() {
; CHECK-LABEL: @const_expression_zext(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 33)
; CHECK-NEXT:    ret void
;
  %A = zext i32 33 to i64
  %T = trunc i64 %A to i32
  call i32 @use32(i32 %T)
  ret void
}

define void @const_expression_trunc() {
; CHECK-LABEL: @const_expression_trunc(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @use32(i32 44)
; CHECK-NEXT:    ret void
;
  %T = trunc i64 44 to i32
  call i32 @use32(i32 %T)
  ret void
}

define void @const_expression_mul_vec() {
; CHECK-LABEL: @const_expression_mul_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> <i32 24531, i32 24864>)
; CHECK-NEXT:    ret void
;
  %A = mul <2 x i64> <i64 111, i64 112>, <i64 221, i64 222>
  %T = trunc <2 x i64> %A to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T)
  ret void
}

define void @const_expression_zext_vec() {
; CHECK-LABEL: @const_expression_zext_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> <i32 331, i32 332>)
; CHECK-NEXT:    ret void
;
  %A = zext <2 x i32> <i32 331, i32 332> to <2 x i64>
  %T = trunc <2 x i64> %A to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T)
  ret void
}

define void @const_expression_trunc_vec() {
; CHECK-LABEL: @const_expression_trunc_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @use32_vec(<2 x i32> <i32 551, i32 552>)
; CHECK-NEXT:    ret void
;
  %T = trunc <2 x i64> <i64 551, i64 552> to <2 x i32>
  call <2 x i32> @use32_vec(<2 x i32> %T)
  ret void
}
