; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefix=ALL --check-prefix=AVX256 --check-prefix=AVX256BW --check-prefix=AVX256BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,-prefer-256-bit | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512BW --check-prefix=AVX512BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+prefer-256-bit | FileCheck %s --check-prefix=ALL --check-prefix=AVX256 --check-prefix=AVX256VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,-prefer-256-bit | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+prefer-256-bit | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512BW --check-prefix=AVX512BWNOVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,-prefer-256-bit | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512BW --check-prefix=AVX512BWNOVL

define <32 x i8> @var_shl_v32i8(<32 x i8> %a, <32 x i8> %b) {
; AVX256-LABEL: var_shl_v32i8:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX256-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX256-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX256-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX256-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX256-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX256-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX256-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX256-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    retq
;
; AVX512BW-LABEL: var_shl_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: var_shl_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %shift = shl <32 x i8> %a, %b
  ret <32 x i8> %shift
}

define <16 x i16> @var_shl_v16i16(<16 x i16> %a, <16 x i16> %b) {
; AVX256BW-LABEL: var_shl_v16i16:
; AVX256BW:       # %bb.0:
; AVX256BW-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; AVX256BW-NEXT:    retq
;
; AVX512BWVL-LABEL: var_shl_v16i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; AVX256VL-LABEL: var_shl_v16i16:
; AVX256VL:       # %bb.0:
; AVX256VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX256VL-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; AVX256VL-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; AVX256VL-NEXT:    vpsllvd %ymm3, %ymm4, %ymm3
; AVX256VL-NEXT:    vpsrld $16, %ymm3, %ymm3
; AVX256VL-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; AVX256VL-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; AVX256VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX256VL-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX256VL-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX256VL-NEXT:    retq
;
; AVX512VL-LABEL: var_shl_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BWNOVL-LABEL: var_shl_v16i16:
; AVX512BWNOVL:       # %bb.0:
; AVX512BWNOVL-NEXT:    # kill: def %ymm1 killed %ymm1 def %zmm1
; AVX512BWNOVL-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; AVX512BWNOVL-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BWNOVL-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512BWNOVL-NEXT:    retq
  %shift = shl <16 x i16> %a, %b
  ret <16 x i16> %shift
}

define <16 x i8> @var_shl_v16i8(<16 x i8> %a, <16 x i8> %b) {
; AVX256BW-LABEL: var_shl_v16i8:
; AVX256BW:       # %bb.0:
; AVX256BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX256BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX256BW-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; AVX256BW-NEXT:    vpmovwb %ymm0, %xmm0
; AVX256BW-NEXT:    vzeroupper
; AVX256BW-NEXT:    retq
;
; AVX512BWVL-LABEL: var_shl_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BWVL-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; AVX256VL-LABEL: var_shl_v16i8:
; AVX256VL:       # %bb.0:
; AVX256VL-NEXT:    vpsllw $5, %xmm1, %xmm1
; AVX256VL-NEXT:    vpsllw $4, %xmm0, %xmm2
; AVX256VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    vpsllw $2, %xmm0, %xmm2
; AVX256VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX256VL-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    vpaddb %xmm0, %xmm0, %xmm2
; AVX256VL-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    retq
;
; AVX512VL-LABEL: var_shl_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512VL-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BWNOVL-LABEL: var_shl_v16i8:
; AVX512BWNOVL:       # %bb.0:
; AVX512BWNOVL-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BWNOVL-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BWNOVL-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BWNOVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWNOVL-NEXT:    # kill: def %xmm0 killed %xmm0 killed %ymm0
; AVX512BWNOVL-NEXT:    vzeroupper
; AVX512BWNOVL-NEXT:    retq
  %shift = shl <16 x i8> %a, %b
  ret <16 x i8> %shift
}

define <32 x i8> @var_lshr_v32i8(<32 x i8> %a, <32 x i8> %b) {
; AVX256-LABEL: var_lshr_v32i8:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX256-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX256-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX256-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX256-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX256-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX256-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX256-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX256-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX256-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    retq
;
; AVX512BW-LABEL: var_lshr_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: var_lshr_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %shift = lshr <32 x i8> %a, %b
  ret <32 x i8> %shift
}

define <16 x i16> @var_lshr_v16i16(<16 x i16> %a, <16 x i16> %b) {
; AVX256BW-LABEL: var_lshr_v16i16:
; AVX256BW:       # %bb.0:
; AVX256BW-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; AVX256BW-NEXT:    retq
;
; AVX512BWVL-LABEL: var_lshr_v16i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; AVX256VL-LABEL: var_lshr_v16i16:
; AVX256VL:       # %bb.0:
; AVX256VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX256VL-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; AVX256VL-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; AVX256VL-NEXT:    vpsrlvd %ymm3, %ymm4, %ymm3
; AVX256VL-NEXT:    vpsrld $16, %ymm3, %ymm3
; AVX256VL-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; AVX256VL-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; AVX256VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX256VL-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX256VL-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX256VL-NEXT:    retq
;
; AVX512VL-LABEL: var_lshr_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BWNOVL-LABEL: var_lshr_v16i16:
; AVX512BWNOVL:       # %bb.0:
; AVX512BWNOVL-NEXT:    # kill: def %ymm1 killed %ymm1 def %zmm1
; AVX512BWNOVL-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; AVX512BWNOVL-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BWNOVL-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512BWNOVL-NEXT:    retq
  %shift = lshr <16 x i16> %a, %b
  ret <16 x i16> %shift
}

define <16 x i8> @var_lshr_v16i8(<16 x i8> %a, <16 x i8> %b) {
; AVX256BW-LABEL: var_lshr_v16i8:
; AVX256BW:       # %bb.0:
; AVX256BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX256BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX256BW-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; AVX256BW-NEXT:    vpmovwb %ymm0, %xmm0
; AVX256BW-NEXT:    vzeroupper
; AVX256BW-NEXT:    retq
;
; AVX512BWVL-LABEL: var_lshr_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BWVL-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; AVX256VL-LABEL: var_lshr_v16i8:
; AVX256VL:       # %bb.0:
; AVX256VL-NEXT:    vpsllw $5, %xmm1, %xmm1
; AVX256VL-NEXT:    vpsrlw $4, %xmm0, %xmm2
; AVX256VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    vpsrlw $2, %xmm0, %xmm2
; AVX256VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX256VL-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    vpsrlw $1, %xmm0, %xmm2
; AVX256VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX256VL-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    retq
;
; AVX512VL-LABEL: var_lshr_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BWNOVL-LABEL: var_lshr_v16i8:
; AVX512BWNOVL:       # %bb.0:
; AVX512BWNOVL-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BWNOVL-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BWNOVL-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BWNOVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWNOVL-NEXT:    # kill: def %xmm0 killed %xmm0 killed %ymm0
; AVX512BWNOVL-NEXT:    vzeroupper
; AVX512BWNOVL-NEXT:    retq
  %shift = lshr <16 x i8> %a, %b
  ret <16 x i8> %shift
}

define <32 x i8> @var_ashr_v32i8(<32 x i8> %a, <32 x i8> %b) {
; AVX256-LABEL: var_ashr_v32i8:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX256-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; AVX256-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX256-NEXT:    vpsraw $4, %ymm3, %ymm4
; AVX256-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; AVX256-NEXT:    vpsraw $2, %ymm3, %ymm4
; AVX256-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX256-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; AVX256-NEXT:    vpsraw $1, %ymm3, %ymm4
; AVX256-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX256-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm2
; AVX256-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX256-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; AVX256-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX256-NEXT:    vpsraw $4, %ymm0, %ymm3
; AVX256-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; AVX256-NEXT:    vpsraw $2, %ymm0, %ymm3
; AVX256-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; AVX256-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; AVX256-NEXT:    vpsraw $1, %ymm0, %ymm3
; AVX256-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; AVX256-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; AVX256-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX256-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX256-NEXT:    retq
;
; AVX512BW-LABEL: var_ashr_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0
; AVX512BW-NEXT:    vpsravw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: var_ashr_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512VL-NEXT:    vpsraw $4, %ymm3, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsraw $2, %ymm3, %ymm4
; AVX512VL-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsraw $1, %ymm3, %ymm4
; AVX512VL-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512VL-NEXT:    vpsraw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsraw $2, %ymm0, %ymm3
; AVX512VL-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsraw $1, %ymm0, %ymm3
; AVX512VL-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %shift = ashr <32 x i8> %a, %b
  ret <32 x i8> %shift
}

define <16 x i16> @var_ashr_v16i16(<16 x i16> %a, <16 x i16> %b) {
; AVX256BW-LABEL: var_ashr_v16i16:
; AVX256BW:       # %bb.0:
; AVX256BW-NEXT:    vpsravw %ymm1, %ymm0, %ymm0
; AVX256BW-NEXT:    retq
;
; AVX512BWVL-LABEL: var_ashr_v16i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpsravw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; AVX256VL-LABEL: var_ashr_v16i16:
; AVX256VL:       # %bb.0:
; AVX256VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX256VL-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; AVX256VL-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; AVX256VL-NEXT:    vpsravd %ymm3, %ymm4, %ymm3
; AVX256VL-NEXT:    vpsrld $16, %ymm3, %ymm3
; AVX256VL-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; AVX256VL-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; AVX256VL-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX256VL-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX256VL-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX256VL-NEXT:    retq
;
; AVX512VL-LABEL: var_ashr_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512VL-NEXT:    vpsravd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BWNOVL-LABEL: var_ashr_v16i16:
; AVX512BWNOVL:       # %bb.0:
; AVX512BWNOVL-NEXT:    # kill: def %ymm1 killed %ymm1 def %zmm1
; AVX512BWNOVL-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; AVX512BWNOVL-NEXT:    vpsravw %zmm1, %zmm0, %zmm0
; AVX512BWNOVL-NEXT:    # kill: def %ymm0 killed %ymm0 killed %zmm0
; AVX512BWNOVL-NEXT:    retq
  %shift = ashr <16 x i16> %a, %b
  ret <16 x i16> %shift
}

define <16 x i8> @var_ashr_v16i8(<16 x i8> %a, <16 x i8> %b) {
; AVX256BW-LABEL: var_ashr_v16i8:
; AVX256BW:       # %bb.0:
; AVX256BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX256BW-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX256BW-NEXT:    vpsravw %ymm1, %ymm0, %ymm0
; AVX256BW-NEXT:    vpmovwb %ymm0, %xmm0
; AVX256BW-NEXT:    vzeroupper
; AVX256BW-NEXT:    retq
;
; AVX512BWVL-LABEL: var_ashr_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BWVL-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512BWVL-NEXT:    vpsravw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; AVX256VL-LABEL: var_ashr_v16i8:
; AVX256VL:       # %bb.0:
; AVX256VL-NEXT:    vpsllw $5, %xmm1, %xmm1
; AVX256VL-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX256VL-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX256VL-NEXT:    vpsraw $4, %xmm3, %xmm4
; AVX256VL-NEXT:    vpblendvb %xmm2, %xmm4, %xmm3, %xmm3
; AVX256VL-NEXT:    vpsraw $2, %xmm3, %xmm4
; AVX256VL-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; AVX256VL-NEXT:    vpblendvb %xmm2, %xmm4, %xmm3, %xmm3
; AVX256VL-NEXT:    vpsraw $1, %xmm3, %xmm4
; AVX256VL-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; AVX256VL-NEXT:    vpblendvb %xmm2, %xmm4, %xmm3, %xmm2
; AVX256VL-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX256VL-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX256VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; AVX256VL-NEXT:    vpsraw $4, %xmm0, %xmm3
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX256VL-NEXT:    vpsraw $2, %xmm0, %xmm3
; AVX256VL-NEXT:    vpaddw %xmm1, %xmm1, %xmm1
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX256VL-NEXT:    vpsraw $1, %xmm0, %xmm3
; AVX256VL-NEXT:    vpaddw %xmm1, %xmm1, %xmm1
; AVX256VL-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX256VL-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX256VL-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX256VL-NEXT:    retq
;
; AVX512VL-LABEL: var_ashr_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512VL-NEXT:    vpsravd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BWNOVL-LABEL: var_ashr_v16i8:
; AVX512BWNOVL:       # %bb.0:
; AVX512BWNOVL-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BWNOVL-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512BWNOVL-NEXT:    vpsravw %zmm1, %zmm0, %zmm0
; AVX512BWNOVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWNOVL-NEXT:    # kill: def %xmm0 killed %xmm0 killed %ymm0
; AVX512BWNOVL-NEXT:    vzeroupper
; AVX512BWNOVL-NEXT:    retq
  %shift = ashr <16 x i8> %a, %b
  ret <16 x i8> %shift
}
