; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv32 -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IM %s

define i32 @square(i32 %a) nounwind {
; RV32I-LABEL: square:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    lui a1, %hi(__mulsi3)
; RV32I-NEXT:    addi a2, a1, %lo(__mulsi3)
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    jalr a2
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: square:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    mul a0, a0, a0
; RV32IM-NEXT:    ret
  %1 = mul i32 %a, %a
  ret i32 %1
}

define i32 @mul(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: mul:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    lui a2, %hi(__mulsi3)
; RV32I-NEXT:    addi a2, a2, %lo(__mulsi3)
; RV32I-NEXT:    jalr a2
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mul:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    mul a0, a0, a1
; RV32IM-NEXT:    ret
  %1 = mul i32 %a, %b
  ret i32 %1
}

define i32 @mul_constant(i32 %a) nounwind {
; RV32I-LABEL: mul_constant:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    lui a1, %hi(__mulsi3)
; RV32I-NEXT:    addi a2, a1, %lo(__mulsi3)
; RV32I-NEXT:    addi a1, zero, 5
; RV32I-NEXT:    jalr a2
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mul_constant:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    addi a1, zero, 5
; RV32IM-NEXT:    mul a0, a0, a1
; RV32IM-NEXT:    ret
  %1 = mul i32 %a, 5
  ret i32 %1
}

define i32 @mul_pow2(i32 %a) nounwind {
; RV32I-LABEL: mul_pow2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 3
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mul_pow2:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    slli a0, a0, 3
; RV32IM-NEXT:    ret
  %1 = mul i32 %a, 8
  ret i32 %1
}

define i64 @mul64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: mul64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    lui a4, %hi(__muldi3)
; RV32I-NEXT:    addi a4, a4, %lo(__muldi3)
; RV32I-NEXT:    jalr a4
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mul64:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    mul a3, a0, a3
; RV32IM-NEXT:    mulhu a4, a0, a2
; RV32IM-NEXT:    add a3, a4, a3
; RV32IM-NEXT:    mul a1, a1, a2
; RV32IM-NEXT:    add a1, a3, a1
; RV32IM-NEXT:    mul a0, a0, a2
; RV32IM-NEXT:    ret
  %1 = mul i64 %a, %b
  ret i64 %1
}

define i64 @mul64_constant(i64 %a) nounwind {
; RV32I-LABEL: mul64_constant:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    lui a2, %hi(__muldi3)
; RV32I-NEXT:    addi a4, a2, %lo(__muldi3)
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    jalr a4
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mul64_constant:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    addi a2, zero, 5
; RV32IM-NEXT:    mul a1, a1, a2
; RV32IM-NEXT:    mulhu a3, a0, a2
; RV32IM-NEXT:    add a1, a3, a1
; RV32IM-NEXT:    mul a0, a0, a2
; RV32IM-NEXT:    ret
  %1 = mul i64 %a, 5
  ret i64 %1
}

define i32 @mulhs(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: mulhs:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    lui a1, %hi(__muldi3)
; RV32I-NEXT:    addi a4, a1, %lo(__muldi3)
; RV32I-NEXT:    srai a1, a0, 31
; RV32I-NEXT:    srai a3, a2, 31
; RV32I-NEXT:    jalr a4
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mulhs:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    mulh a0, a0, a1
; RV32IM-NEXT:    ret
  %1 = sext i32 %a to i64
  %2 = sext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}

define i32 @mulhu(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: mulhu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp)
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    lui a1, %hi(__muldi3)
; RV32I-NEXT:    addi a4, a1, %lo(__muldi3)
; RV32I-NEXT:    mv a1, zero
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    jalr a4
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw ra, 12(sp)
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IM-LABEL: mulhu:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    mulhu a0, a0, a1
; RV32IM-NEXT:    ret
  %1 = zext i32 %a to i64
  %2 = zext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}
