; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefix=ALL --check-prefix=XOP --check-prefix=XOPAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=XOP --check-prefix=XOPAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=knl -mattr=+avx512dq | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=knl -mattr=+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=knl -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX512VL --check-prefix=AVX512DQVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=knl -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX512VL --check-prefix=AVX512BWVL
;
; 32-bit runs to make sure we do reasonable things for i64 shifts.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx  | FileCheck %s --check-prefix=ALL --check-prefix=X32-AVX --check-prefix=X32-AVX1
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=X32-AVX --check-prefix=X32-AVX2

;
; Variable Shifts
;

define <4 x i64> @var_shift_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: var_shift_v4i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v4i64:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpshlq %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubq %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpshlq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v4i64:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: var_shift_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shift_v4i64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: var_shift_v4i64:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X32-AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm4
; X32-AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; X32-AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; X32-AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; X32-AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5,6,7]
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: var_shift_v4i64:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <4 x i64> %a, %b
  ret <4 x i64> %shift
}

define <8 x i32> @var_shift_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: var_shift_v8i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm3[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsrld %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vpsrlq $32, %xmm3, %xmm5
; AVX1-NEXT:    vpsrld %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX1-NEXT:    vpsrld %xmm6, %xmm2, %xmm6
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero
; AVX1-NEXT:    vpsrld %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm6[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm1[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsrld %xmm3, %xmm0, %xmm3
; AVX1-NEXT:    vpsrlq $32, %xmm1, %xmm4
; AVX1-NEXT:    vpsrld %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; AVX1-NEXT:    vpsrld %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3],xmm0[4,5],xmm3[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v8i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v8i32:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpshld %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubd %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpshld %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v8i32:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: var_shift_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: var_shift_v8i32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: var_shift_v8i32:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X32-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; X32-AVX1-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm3[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X32-AVX1-NEXT:    vpsrld %xmm4, %xmm2, %xmm4
; X32-AVX1-NEXT:    vpsrlq $32, %xmm3, %xmm5
; X32-AVX1-NEXT:    vpsrld %xmm5, %xmm2, %xmm5
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2,3],xmm4[4,5,6,7]
; X32-AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; X32-AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; X32-AVX1-NEXT:    vpsrld %xmm6, %xmm2, %xmm6
; X32-AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero
; X32-AVX1-NEXT:    vpsrld %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm6[4,5,6,7]
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; X32-AVX1-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm1[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X32-AVX1-NEXT:    vpsrld %xmm3, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpsrlq $32, %xmm1, %xmm4
; X32-AVX1-NEXT:    vpsrld %xmm4, %xmm0, %xmm4
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; X32-AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; X32-AVX1-NEXT:    vpsrld %xmm4, %xmm0, %xmm4
; X32-AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; X32-AVX1-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm4[4,5,6,7]
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3],xmm0[4,5],xmm3[6,7]
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: var_shift_v8i32:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <8 x i32> %a, %b
  ret <8 x i32> %shift
}

define <16 x i16> @var_shift_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: var_shift_v16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsllw $12, %xmm2, %xmm3
; AVX1-NEXT:    vpsllw $4, %xmm2, %xmm2
; AVX1-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm5
; AVX1-NEXT:    vpblendvb %xmm2, %xmm5, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm4
; AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $2, %xmm2, %xmm4
; AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm4
; AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $12, %xmm1, %xmm3
; AVX1-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm4
; AVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm1
; AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm1
; AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm1
; AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; AVX2-NEXT:    vpsrlvd %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v16i16:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubw %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpshlw %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubw %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v16i16:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpsubw %xmm2, %xmm3, %xmm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; XOPAVX2-NEXT:    vpshlw %xmm2, %xmm4, %xmm2
; XOPAVX2-NEXT:    vpsubw %xmm1, %xmm3, %xmm1
; XOPAVX2-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: var_shift_v16i16:
; AVX512DQ:       # BB#0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: var_shift_v16i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    # kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; AVX512BW-NEXT:    # kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    # kill: %YMM0<def> %YMM0<kill> %ZMM0<kill>
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: var_shift_v16i16:
; AVX512DQVL:       # BB#0:
; AVX512DQVL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512DQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQVL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512DQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: var_shift_v16i16:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X32-AVX1-LABEL: var_shift_v16i16:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X32-AVX1-NEXT:    vpsllw $12, %xmm2, %xmm3
; X32-AVX1-NEXT:    vpsllw $4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpor %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm3
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; X32-AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm5
; X32-AVX1-NEXT:    vpblendvb %xmm2, %xmm5, %xmm4, %xmm2
; X32-AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm4
; X32-AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $2, %xmm2, %xmm4
; X32-AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm4
; X32-AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsllw $12, %xmm1, %xmm3
; X32-AVX1-NEXT:    vpsllw $4, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpor %xmm3, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpaddw %xmm1, %xmm1, %xmm3
; X32-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm4
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm1
; X32-AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm1
; X32-AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: var_shift_v16i16:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X32-AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15]
; X32-AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; X32-AVX2-NEXT:    vpsrlvd %ymm3, %ymm4, %ymm3
; X32-AVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; X32-AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11]
; X32-AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; X32-AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <16 x i16> %a, %b
  ret <16 x i16> %shift
}

define <32 x i8> @var_shift_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: var_shift_v32i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $2, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_shift_v32i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: var_shift_v32i8:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_shift_v32i8:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; XOPAVX2-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX2-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: var_shift_v32i8:
; AVX512DQ:       # BB#0:
; AVX512DQ-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: var_shift_v32i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: var_shift_v32i8:
; AVX512DQVL:       # BB#0:
; AVX512DQVL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: var_shift_v32i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X32-AVX1-LABEL: var_shift_v32i8:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X32-AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm3
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; X32-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; X32-AVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; X32-AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $2, %xmm2, %xmm3
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; X32-AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; X32-AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm3
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; X32-AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; X32-AVX1-NEXT:    vpblendvb %xmm5, %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: var_shift_v32i8:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm2
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrlw $2, %ymm0, %ymm2
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm2
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <32 x i8> %a, %b
  ret <32 x i8> %shift
}

;
; Uniform Variable Shifts
;

define <4 x i64> @splatvar_shift_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v4i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrlq %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v4i64:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpsrlq %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v4i64:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_shift_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_shift_v4i64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatvar_shift_v4i64:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X32-AVX1-NEXT:    vpsrlq %xmm1, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatvar_shift_v4i64:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %splat = shufflevector <4 x i64> %b, <4 x i64> undef, <4 x i32> zeroinitializer
  %shift = lshr <4 x i64> %a, %splat
  ret <4 x i64> %shift
}

define <8 x i32> @splatvar_shift_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v8i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsrld %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v8i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v8i32:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; XOPAVX1-NEXT:    vpsrld %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v8i32:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; XOPAVX2-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_shift_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX512-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_shift_v8i32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX512VL-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatvar_shift_v8i32:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X32-AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; X32-AVX1-NEXT:    vpsrld %xmm1, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatvar_shift_v8i32:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; X32-AVX2-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %splat = shufflevector <8 x i32> %b, <8 x i32> undef, <8 x i32> zeroinitializer
  %shift = lshr <8 x i32> %a, %splat
  ret <8 x i32> %shift
}

define <16 x i16> @splatvar_shift_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v16i16:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; XOPAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v16i16:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; XOPAVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatvar_shift_v16i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX512-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_shift_v16i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatvar_shift_v16i16:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X32-AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; X32-AVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatvar_shift_v16i16:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; X32-AVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %splat = shufflevector <16 x i16> %b, <16 x i16> undef, <16 x i32> zeroinitializer
  %shift = lshr <16 x i16> %a, %splat
  ret <16 x i16> %shift
}

define <32 x i8> @splatvar_shift_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: splatvar_shift_v32i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm8, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $2, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm6
; AVX1-NEXT:    vpblendvb %xmm6, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm4
; AVX1-NEXT:    vpblendvb %xmm4, %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm8, %xmm3, %xmm3
; AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm1
; AVX1-NEXT:    vpand %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm6, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm4, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_shift_v32i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_shift_v32i8:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_shift_v32i8:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; XOPAVX2-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX2-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: splatvar_shift_v32i8:
; AVX512DQ:       # BB#0:
; AVX512DQ-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_shift_v32i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: splatvar_shift_v32i8:
; AVX512DQVL:       # BB#0:
; AVX512DQVL-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512DQVL-NEXT:    vpsrlw $4, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsrlw $2, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsrlw $1, %ymm0, %ymm2
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: splatvar_shift_v32i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BWVL-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X32-AVX1-LABEL: splatvar_shift_v32i8:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X32-AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm3
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpsrlw $2, %xmm2, %xmm4
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; X32-AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm4
; X32-AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm4
; X32-AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm3
; X32-AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm4
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; X32-AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm4
; X32-AVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm4
; X32-AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatvar_shift_v32i8:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; X32-AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm2
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrlw $2, %ymm0, %ymm2
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm2
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %splat = shufflevector <32 x i8> %b, <32 x i8> undef, <32 x i32> zeroinitializer
  %shift = lshr <32 x i8> %a, %splat
  ret <32 x i8> %shift
}

;
; Constant Shifts
;

define <4 x i64> @constant_shift_v4i64(<4 x i64> %a) nounwind {
; AVX1-LABEL: constant_shift_v4i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrlq $62, %xmm1, %xmm2
; AVX1-NEXT:    vpsrlq $31, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsrlq $7, %xmm0, %xmm2
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlvq {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v4i64:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubq {{.*}}(%rip), %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshlq %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubq {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshlq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v4i64:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlvq {{.*}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: constant_shift_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlvq {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: constant_shift_v4i64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlvq {{.*}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: constant_shift_v4i64:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} ymm1 = [1,0,7,0,31,0,62,0]
; X32-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X32-AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm4
; X32-AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; X32-AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; X32-AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; X32-AVX1-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5,6,7]
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: constant_shift_v4i64:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlvq {{\.LCPI.*}}, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <4 x i64> %a, <i64 1, i64 7, i64 31, i64 62>
  ret <4 x i64> %shift
}

define <8 x i32> @constant_shift_v8i32(<8 x i32> %a) nounwind {
; AVX1-LABEL: constant_shift_v8i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpsrld $7, %xmm0, %xmm1
; AVX1-NEXT:    vpsrld $5, %xmm0, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vpsrld $6, %xmm0, %xmm2
; AVX1-NEXT:    vpsrld $4, %xmm0, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3],xmm2[4,5],xmm1[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrld $7, %xmm0, %xmm2
; AVX1-NEXT:    vpsrld $9, %xmm0, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsrld $8, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v8i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlvd {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v8i32:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpshld {{.*}}(%rip), %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshld {{.*}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v8i32:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlvd {{.*}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: constant_shift_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlvd {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: constant_shift_v8i32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlvd {{.*}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: constant_shift_v8i32:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vpsrld $7, %xmm0, %xmm1
; X32-AVX1-NEXT:    vpsrld $5, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3],xmm1[4,5,6,7]
; X32-AVX1-NEXT:    vpsrld $6, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpsrld $4, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3],xmm2[4,5,6,7]
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3],xmm2[4,5],xmm1[6,7]
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X32-AVX1-NEXT:    vpsrld $7, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpsrld $9, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3],xmm2[4,5,6,7]
; X32-AVX1-NEXT:    vpsrld $8, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: constant_shift_v8i32:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlvd {{\.LCPI.*}}, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <8 x i32> %a, <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 8, i32 7>
  ret <8 x i32> %shift
}

define <16 x i16> @constant_shift_v16i16(<16 x i16> %a) nounwind {
; AVX1-LABEL: constant_shift_v16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsrlw $2, %xmm1, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4],xmm2[5],xmm1[6],xmm2[7]
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5],xmm0[6],xmm2[7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm2[4],ymm1[4],ymm2[5],ymm1[5],ymm2[6],ymm1[6],ymm2[7],ymm1[7],ymm2[12],ymm1[12],ymm2[13],ymm1[13],ymm2[14],ymm1[14],ymm2[15],ymm1[15]
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15]
; AVX2-NEXT:    vpsrlvd %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[8],ymm1[8],ymm2[9],ymm1[9],ymm2[10],ymm1[10],ymm2[11],ymm1[11]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11]
; AVX2-NEXT:    vpsrlvd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v16i16:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubw {{.*}}(%rip), %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshlw %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubw {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v16i16:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX2-NEXT:    vpsubw {{.*}}(%rip), %xmm1, %xmm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; XOPAVX2-NEXT:    vpshlw %xmm2, %xmm3, %xmm2
; XOPAVX2-NEXT:    vpsubw {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: constant_shift_v16i16:
; AVX512DQ:       # BB#0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpsrlvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v16i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    # kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    # kill: %YMM0<def> %YMM0<kill> %ZMM0<kill>
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: constant_shift_v16i16:
; AVX512DQVL:       # BB#0:
; AVX512DQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQVL-NEXT:    vpsrlvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512DQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: constant_shift_v16i16:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vpsrlvw {{.*}}(%rip), %ymm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X32-AVX1-LABEL: constant_shift_v16i16:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X32-AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; X32-AVX1-NEXT:    vpsrlw $2, %xmm1, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; X32-AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4],xmm2[5],xmm1[6],xmm2[7]
; X32-AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; X32-AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; X32-AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5],xmm0[6],xmm2[7]
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: constant_shift_v16i16:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; X32-AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm2[4],ymm1[4],ymm2[5],ymm1[5],ymm2[6],ymm1[6],ymm2[7],ymm1[7],ymm2[12],ymm1[12],ymm2[13],ymm1[13],ymm2[14],ymm1[14],ymm2[15],ymm1[15]
; X32-AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15]
; X32-AVX2-NEXT:    vpsrlvd %ymm3, %ymm4, %ymm3
; X32-AVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; X32-AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[8],ymm1[8],ymm2[9],ymm1[9],ymm2[10],ymm1[10],ymm2[11],ymm1[11]
; X32-AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11]
; X32-AVX2-NEXT:    vpsrlvd %ymm2, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <16 x i16> %a, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  ret <16 x i16> %shift
}

define <32 x i8> @constant_shift_v32i8(<32 x i8> %a) nounwind {
; AVX1-LABEL: constant_shift_v32i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm8, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [8192,24640,41088,57536,49376,32928,16480,32]
; AVX1-NEXT:    vpblendvb %xmm4, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $2, %xmm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX1-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm6
; AVX1-NEXT:    vpblendvb %xmm6, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm3
; AVX1-NEXT:    vpblendvb %xmm3, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm8, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm4, %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm6, %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm3, %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_shift_v32i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [8192,24640,41088,57536,49376,32928,16480,32,8192,24640,41088,57536,49376,32928,16480,32]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $2, %ymm0, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_shift_v32i8:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubb {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_shift_v32i8:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX2-NEXT:    vpsubb {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: constant_shift_v32i8:
; AVX512DQ:       # BB#0:
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm1
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [8192,24640,41088,57536,49376,32928,16480,32,8192,24640,41088,57536,49376,32928,16480,32]
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $2, %ymm0, %ymm1
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $1, %ymm0, %ymm1
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v32i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512DQVL-LABEL: constant_shift_v32i8:
; AVX512DQVL:       # BB#0:
; AVX512DQVL-NEXT:    vpsrlw $4, %ymm0, %ymm1
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512DQVL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8192,24640,41088,57536,49376,32928,16480,32,8192,24640,41088,57536,49376,32928,16480,32]
; AVX512DQVL-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsrlw $2, %ymm0, %ymm1
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpsrlw $1, %ymm0, %ymm1
; AVX512DQVL-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512DQVL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512DQVL-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512DQVL-NEXT:    retq
;
; AVX512BWVL-LABEL: constant_shift_v32i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BWVL-NEXT:    vpsrlvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; X32-AVX1-LABEL: constant_shift_v32i8:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X32-AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm2
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [8192,24640,41088,57536,49376,32928,16480,32]
; X32-AVX1-NEXT:    vpblendvb %xmm4, %xmm2, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm2
; X32-AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; X32-AVX1-NEXT:    vpsrlw $2, %xmm1, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm4, %xmm2, %xmm0, %xmm0
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; X32-AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm4
; X32-AVX1-NEXT:    vpblendvb %xmm4, %xmm3, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpsrlw $2, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm2
; X32-AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm3
; X32-AVX1-NEXT:    vpblendvb %xmm4, %xmm2, %xmm0, %xmm0
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; X32-AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm4
; X32-AVX1-NEXT:    vpblendvb %xmm4, %xmm3, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm3
; X32-AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm2
; X32-AVX1-NEXT:    vpblendvb %xmm4, %xmm2, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: constant_shift_v32i8:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm1
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm1, %ymm1
; X32-AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [8192,24640,41088,57536,49376,32928,16480,32,8192,24640,41088,57536,49376,32928,16480,32]
; X32-AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrlw $2, %ymm0, %ymm1
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm1
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <32 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <32 x i8> %shift
}

;
; Uniform Constant Shifts
;

define <4 x i64> @splatconstant_shift_v4i64(<4 x i64> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v4i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpsrlq $7, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrlq $7, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlq $7, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v4i64:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpsrlq $7, %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsrlq $7, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v4i64:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlq $7, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlq $7, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v4i64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlq $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatconstant_shift_v4i64:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vpsrlq $7, %xmm0, %xmm1
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X32-AVX1-NEXT:    vpsrlq $7, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatconstant_shift_v4i64:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlq $7, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <4 x i64> %a, <i64 7, i64 7, i64 7, i64 7>
  ret <4 x i64> %shift
}

define <8 x i32> @splatconstant_shift_v8i32(<8 x i32> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v8i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpsrld $5, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrld $5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v8i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrld $5, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v8i32:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpsrld $5, %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsrld $5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v8i32:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrld $5, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrld $5, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v8i32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrld $5, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatconstant_shift_v8i32:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vpsrld $5, %xmm0, %xmm1
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X32-AVX1-NEXT:    vpsrld $5, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatconstant_shift_v8i32:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrld $5, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <8 x i32> %a, <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  ret <8 x i32> %shift
}

define <16 x i16> @splatconstant_shift_v16i16(<16 x i16> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpsrlw $3, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsrlw $3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v16i16:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpsrlw $3, %xmm0, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsrlw $3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v16i16:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlw $3, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v16i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v16i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatconstant_shift_v16i16:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vpsrlw $3, %xmm0, %xmm1
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X32-AVX1-NEXT:    vpsrlw $3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatconstant_shift_v16i16:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlw $3, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <16 x i16> %a, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <16 x i16> %shift
}

define <32 x i8> @splatconstant_shift_v32i8(<32 x i8> %a) nounwind {
; AVX1-LABEL: splatconstant_shift_v32i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrlw $3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_shift_v32i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_shift_v32i8:
; XOPAVX1:       # BB#0:
; XOPAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubb {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_shift_v32i8:
; XOPAVX2:       # BB#0:
; XOPAVX2-NEXT:    vpsrlw $3, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512-LABEL: splatconstant_shift_v32i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX512-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_shift_v32i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; X32-AVX1-LABEL: splatconstant_shift_v32i8:
; X32-AVX1:       # BB#0:
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X32-AVX1-NEXT:    vpsrlw $3, %xmm1, %xmm1
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; X32-AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; X32-AVX1-NEXT:    vpsrlw $3, %xmm0, %xmm0
; X32-AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: splatconstant_shift_v32i8:
; X32-AVX2:       # BB#0:
; X32-AVX2-NEXT:    vpsrlw $3, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpand {{\.LCPI.*}}, %ymm0, %ymm0
; X32-AVX2-NEXT:    retl
  %shift = lshr <32 x i8> %a, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <32 x i8> %shift
}
