; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=atom | FileCheck %s --check-prefix=CHECK --check-prefix=ATOM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm | FileCheck %s --check-prefix=CHECK --check-prefix=SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 | FileCheck %s --check-prefix=CHECK --check-prefix=ZNVER1

define <4 x float> @test_addps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_addps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    addps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_addps:
; ATOM:       # BB#0:
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    addps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_addps:
; SLM:       # BB#0:
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_addps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_addps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_addps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_addps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fadd <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fadd <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_addss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_addss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    addss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_addss:
; ATOM:       # BB#0:
; ATOM-NEXT:    addss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    addss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_addss:
; SLM:       # BB#0:
; SLM-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_addss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_addss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_addss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_addss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fadd float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fadd float %1, %2
  ret float %3
}

define <4 x float> @test_andps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_andps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    andps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    andps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_andps:
; ATOM:       # BB#0:
; ATOM-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    andps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_andps:
; SLM:       # BB#0:
; SLM-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    andps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_andps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_andps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_andps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_andps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = and <4 x i32> %1, %2
  %4 = load <4 x float>, <4 x float> *%a2, align 16
  %5 = bitcast <4 x float> %4 to <4 x i32>
  %6 = and <4 x i32> %3, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

define <4 x float> @test_andnotps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_andnotps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    andnps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    andnps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_andnotps:
; ATOM:       # BB#0:
; ATOM-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    andnps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_andnotps:
; SLM:       # BB#0:
; SLM-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    andnps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_andnotps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_andnotps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_andnotps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_andnotps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = xor <4 x i32> %1, <i32 -1, i32 -1, i32 -1, i32 -1>
  %4 = and <4 x i32> %3, %2
  %5 = load <4 x float>, <4 x float> *%a2, align 16
  %6 = bitcast <4 x float> %5 to <4 x i32>
  %7 = xor <4 x i32> %4, <i32 -1, i32 -1, i32 -1, i32 -1>
  %8 = and <4 x i32> %6, %7
  %9 = bitcast <4 x i32> %8 to <4 x float>
  ret <4 x float> %9
}

define <4 x float> @test_cmpps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_cmpps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmpps:
; ATOM:       # BB#0:
; ATOM-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmpps:
; SLM:       # BB#0:
; SLM-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cmpps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmpps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; HASWELL-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cmpps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmpps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; ZNVER1-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fcmp oeq <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fcmp oeq <4 x float> %a0, %2
  %4 = or <4 x i1> %1, %3
  %5 = sext <4 x i1> %4 to <4 x i32>
  %6 = bitcast <4 x i32> %5 to <4 x float>
  ret <4 x float> %6
}

define float @test_cmpss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_cmpss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmpss:
; ATOM:       # BB#0:
; ATOM-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmpss:
; SLM:       # BB#0:
; SLM-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cmpss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmpss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cmpss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmpss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = insertelement <4 x float> undef, float %a1, i32 0
  %3 = call <4 x float> @llvm.x86.sse.cmp.ss(<4 x float> %1, <4 x float> %2, i8 0)
  %4 = load float, float *%a2, align 4
  %5 = insertelement <4 x float> undef, float %4, i32 0
  %6 = call <4 x float> @llvm.x86.sse.cmp.ss(<4 x float> %3, <4 x float> %5, i8 0)
  %7 = extractelement <4 x float> %6, i32 0
  ret float %7
}
declare <4 x float> @llvm.x86.sse.cmp.ss(<4 x float>, <4 x float>, i8) nounwind readnone

define i32 @test_comiss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_comiss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %cl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %cl # sched: [1:0.33]
; GENERIC-NEXT:    comiss (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %dl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %dl # sched: [1:0.33]
; GENERIC-NEXT:    orb %cl, %dl # sched: [1:0.33]
; GENERIC-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_comiss:
; ATOM:       # BB#0:
; ATOM-NEXT:    comiss %xmm1, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %cl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %cl # sched: [1:0.50]
; ATOM-NEXT:    comiss (%rdi), %xmm0 # sched: [10:5.00]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %dl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %dl # sched: [1:0.50]
; ATOM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; ATOM-NEXT:    movzbl %dl, %eax # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_comiss:
; SLM:       # BB#0:
; SLM-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %cl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %cl # sched: [1:0.50]
; SLM-NEXT:    comiss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %dl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %dl # sched: [1:0.50]
; SLM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; SLM-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_comiss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %cl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-NEXT:    vcomiss (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %dl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %dl # sched: [1:0.33]
; SANDY-NEXT:    orb %cl, %dl # sched: [1:0.33]
; SANDY-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_comiss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %cl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-NEXT:    vcomiss (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %dl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %dl # sched: [1:0.25]
; HASWELL-NEXT:    orb %cl, %dl # sched: [1:0.25]
; HASWELL-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_comiss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %cl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-NEXT:    vcomiss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %dl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %dl # sched: [1:0.50]
; BTVER2-NEXT:    orb %cl, %dl # sched: [1:0.50]
; BTVER2-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_comiss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %cl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-NEXT:    vcomiss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %dl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    orb %cl, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call i32 @llvm.x86.sse.comieq.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 4
  %3 = call i32 @llvm.x86.sse.comieq.ss(<4 x float> %a0, <4 x float> %2)
  %4 = or i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse.comieq.ss(<4 x float>, <4 x float>) nounwind readnone

define float @test_cvtsi2ss(i32 %a0, i32 *%a1) {
; GENERIC-LABEL: test_cvtsi2ss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [5:2.00]
; GENERIC-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [10:1.00]
; GENERIC-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtsi2ss:
; ATOM:       # BB#0:
; ATOM-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [7:3.50]
; ATOM-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [6:3.00]
; ATOM-NEXT:    addss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtsi2ss:
; SLM:       # BB#0:
; SLM-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [4:0.50]
; SLM-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtsi2ss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [5:2.00]
; SANDY-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtsi2ss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [4:1.00]
; HASWELL-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [8:1.00]
; HASWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cvtsi2ss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [8:1.00]
; BTVER2-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtsi2ss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = sitofp i32 %a0 to float
  %2 = load i32, i32 *%a1, align 4
  %3 = sitofp i32 %2 to float
  %4 = fadd float %1, %3
  ret float %4
}

define float @test_cvtsi2ssq(i64 %a0, i64 *%a1) {
; GENERIC-LABEL: test_cvtsi2ssq:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [5:2.00]
; GENERIC-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [10:1.00]
; GENERIC-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtsi2ssq:
; ATOM:       # BB#0:
; ATOM-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [7:3.50]
; ATOM-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [6:3.00]
; ATOM-NEXT:    addss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtsi2ssq:
; SLM:       # BB#0:
; SLM-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [4:0.50]
; SLM-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtsi2ssq:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [5:2.00]
; SANDY-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtsi2ssq:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [4:1.00]
; HASWELL-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [8:1.00]
; HASWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cvtsi2ssq:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [8:1.00]
; BTVER2-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtsi2ssq:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = sitofp i64 %a0 to float
  %2 = load i64, i64 *%a1, align 8
  %3 = sitofp i64 %2 to float
  %4 = fadd float %1, %3
  ret float %4
}

define i32 @test_cvtss2si(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvtss2si:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cvtss2si %xmm0, %ecx # sched: [5:1.00]
; GENERIC-NEXT:    cvtss2si (%rdi), %eax # sched: [9:1.00]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtss2si:
; ATOM:       # BB#0:
; ATOM-NEXT:    cvtss2si (%rdi), %eax # sched: [9:4.50]
; ATOM-NEXT:    cvtss2si %xmm0, %ecx # sched: [8:4.00]
; ATOM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtss2si:
; SLM:       # BB#0:
; SLM-NEXT:    cvtss2si (%rdi), %eax # sched: [7:1.00]
; SLM-NEXT:    cvtss2si %xmm0, %ecx # sched: [4:0.50]
; SLM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtss2si:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcvtss2si %xmm0, %ecx # sched: [5:1.00]
; SANDY-NEXT:    vcvtss2si (%rdi), %eax # sched: [10:1.00]
; SANDY-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtss2si:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcvtss2si %xmm0, %ecx # sched: [4:1.00]
; HASWELL-NEXT:    vcvtss2si (%rdi), %eax # sched: [8:1.00]
; HASWELL-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cvtss2si:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcvtss2si (%rdi), %eax # sched: [8:1.00]
; BTVER2-NEXT:    vcvtss2si %xmm0, %ecx # sched: [3:1.00]
; BTVER2-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtss2si:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcvtss2si (%rdi), %eax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtss2si %xmm0, %ecx # sched: [5:1.00]
; ZNVER1-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call i32 @llvm.x86.sse.cvtss2si(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call i32 @llvm.x86.sse.cvtss2si(<4 x float> %4)
  %6 = add i32 %2, %5
  ret i32 %6
}
declare i32 @llvm.x86.sse.cvtss2si(<4 x float>) nounwind readnone

define i64 @test_cvtss2siq(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvtss2siq:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cvtss2si %xmm0, %rcx # sched: [5:1.00]
; GENERIC-NEXT:    cvtss2si (%rdi), %rax # sched: [9:1.00]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtss2siq:
; ATOM:       # BB#0:
; ATOM-NEXT:    cvtss2si (%rdi), %rax # sched: [10:5.00]
; ATOM-NEXT:    cvtss2si %xmm0, %rcx # sched: [9:4.50]
; ATOM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtss2siq:
; SLM:       # BB#0:
; SLM-NEXT:    cvtss2si (%rdi), %rax # sched: [7:1.00]
; SLM-NEXT:    cvtss2si %xmm0, %rcx # sched: [4:0.50]
; SLM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtss2siq:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcvtss2si %xmm0, %rcx # sched: [5:1.00]
; SANDY-NEXT:    vcvtss2si (%rdi), %rax # sched: [10:1.00]
; SANDY-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtss2siq:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcvtss2si %xmm0, %rcx # sched: [4:1.00]
; HASWELL-NEXT:    vcvtss2si (%rdi), %rax # sched: [8:1.00]
; HASWELL-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cvtss2siq:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcvtss2si (%rdi), %rax # sched: [8:1.00]
; BTVER2-NEXT:    vcvtss2si %xmm0, %rcx # sched: [3:1.00]
; BTVER2-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtss2siq:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcvtss2si (%rdi), %rax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtss2si %xmm0, %rcx # sched: [5:1.00]
; ZNVER1-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call i64 @llvm.x86.sse.cvtss2si64(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call i64 @llvm.x86.sse.cvtss2si64(<4 x float> %4)
  %6 = add i64 %2, %5
  ret i64 %6
}
declare i64 @llvm.x86.sse.cvtss2si64(<4 x float>) nounwind readnone

define i32 @test_cvttss2si(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvttss2si:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cvttss2si %xmm0, %ecx # sched: [5:1.00]
; GENERIC-NEXT:    cvttss2si (%rdi), %eax # sched: [9:1.00]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvttss2si:
; ATOM:       # BB#0:
; ATOM-NEXT:    cvttss2si (%rdi), %eax # sched: [9:4.50]
; ATOM-NEXT:    cvttss2si %xmm0, %ecx # sched: [8:4.00]
; ATOM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvttss2si:
; SLM:       # BB#0:
; SLM-NEXT:    cvttss2si (%rdi), %eax # sched: [7:1.00]
; SLM-NEXT:    cvttss2si %xmm0, %ecx # sched: [4:0.50]
; SLM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvttss2si:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcvttss2si %xmm0, %ecx # sched: [5:1.00]
; SANDY-NEXT:    vcvttss2si (%rdi), %eax # sched: [10:1.00]
; SANDY-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvttss2si:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcvttss2si %xmm0, %ecx # sched: [4:1.00]
; HASWELL-NEXT:    vcvttss2si (%rdi), %eax # sched: [8:1.00]
; HASWELL-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cvttss2si:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcvttss2si (%rdi), %eax # sched: [8:1.00]
; BTVER2-NEXT:    vcvttss2si %xmm0, %ecx # sched: [3:1.00]
; BTVER2-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvttss2si:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcvttss2si (%rdi), %eax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvttss2si %xmm0, %ecx # sched: [5:1.00]
; ZNVER1-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fptosi float %a0 to i32
  %2 = load float, float *%a1, align 4
  %3 = fptosi float %2 to i32
  %4 = add i32 %1, %3
  ret i32 %4
}

define i64 @test_cvttss2siq(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvttss2siq:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    cvttss2si %xmm0, %rcx # sched: [5:1.00]
; GENERIC-NEXT:    cvttss2si (%rdi), %rax # sched: [9:1.00]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvttss2siq:
; ATOM:       # BB#0:
; ATOM-NEXT:    cvttss2si (%rdi), %rax # sched: [10:5.00]
; ATOM-NEXT:    cvttss2si %xmm0, %rcx # sched: [9:4.50]
; ATOM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvttss2siq:
; SLM:       # BB#0:
; SLM-NEXT:    cvttss2si (%rdi), %rax # sched: [7:1.00]
; SLM-NEXT:    cvttss2si %xmm0, %rcx # sched: [4:0.50]
; SLM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvttss2siq:
; SANDY:       # BB#0:
; SANDY-NEXT:    vcvttss2si %xmm0, %rcx # sched: [5:1.00]
; SANDY-NEXT:    vcvttss2si (%rdi), %rax # sched: [10:1.00]
; SANDY-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvttss2siq:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vcvttss2si %xmm0, %rcx # sched: [4:1.00]
; HASWELL-NEXT:    vcvttss2si (%rdi), %rax # sched: [8:1.00]
; HASWELL-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_cvttss2siq:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vcvttss2si (%rdi), %rax # sched: [8:1.00]
; BTVER2-NEXT:    vcvttss2si %xmm0, %rcx # sched: [3:1.00]
; BTVER2-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvttss2siq:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vcvttss2si (%rdi), %rax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvttss2si %xmm0, %rcx # sched: [5:1.00]
; ZNVER1-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fptosi float %a0 to i64
  %2 = load float, float *%a1, align 4
  %3 = fptosi float %2 to i64
  %4 = add i64 %1, %3
  ret i64 %4
}

define <4 x float> @test_divps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_divps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    divps %xmm1, %xmm0 # sched: [14:1.00]
; GENERIC-NEXT:    divps (%rdi), %xmm0 # sched: [20:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_divps:
; ATOM:       # BB#0:
; ATOM-NEXT:    divps %xmm1, %xmm0 # sched: [70:35.00]
; ATOM-NEXT:    divps (%rdi), %xmm0 # sched: [125:62.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_divps:
; SLM:       # BB#0:
; SLM-NEXT:    divps %xmm1, %xmm0 # sched: [34:34.00]
; SLM-NEXT:    divps (%rdi), %xmm0 # sched: [37:34.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_divps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [14:1.00]
; SANDY-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [20:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_divps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [12:1.00]
; HASWELL-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [16:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_divps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [19:19.00]
; BTVER2-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [24:19.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_divps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [15:1.00]
; ZNVER1-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [22:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fdiv <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fdiv <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_divss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_divss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    divss %xmm1, %xmm0 # sched: [14:1.00]
; GENERIC-NEXT:    divss (%rdi), %xmm0 # sched: [20:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_divss:
; ATOM:       # BB#0:
; ATOM-NEXT:    divss %xmm1, %xmm0 # sched: [34:17.00]
; ATOM-NEXT:    divss (%rdi), %xmm0 # sched: [62:31.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_divss:
; SLM:       # BB#0:
; SLM-NEXT:    divss %xmm1, %xmm0 # sched: [34:34.00]
; SLM-NEXT:    divss (%rdi), %xmm0 # sched: [37:34.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_divss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [14:1.00]
; SANDY-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [20:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_divss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [12:1.00]
; HASWELL-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [16:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_divss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [19:19.00]
; BTVER2-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [24:19.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_divss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [15:1.00]
; ZNVER1-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [22:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fdiv float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fdiv float %1, %2
  ret float %3
}

define void @test_ldmxcsr(i32 %a0) {
; GENERIC-LABEL: test_ldmxcsr:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_ldmxcsr:
; ATOM:       # BB#0:
; ATOM-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; ATOM-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:2.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_ldmxcsr:
; SLM:       # BB#0:
; SLM-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SLM-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_ldmxcsr:
; SANDY:       # BB#0:
; SANDY-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_ldmxcsr:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; HASWELL-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [6:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_ldmxcsr:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_ldmxcsr:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:0.50]
; ZNVER1-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = alloca i32, align 4
  %2 = bitcast i32* %1 to i8*
  store i32 %a0, i32* %1
  call void @llvm.x86.sse.ldmxcsr(i8* %2)
  ret void
}
declare void @llvm.x86.sse.ldmxcsr(i8*) nounwind readnone

define <4 x float> @test_maxps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_maxps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    maxps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_maxps:
; ATOM:       # BB#0:
; ATOM-NEXT:    maxps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    maxps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_maxps:
; SLM:       # BB#0:
; SLM-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    maxps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_maxps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maxps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_maxps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maxps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.max.ps(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_maxss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_maxss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    maxss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_maxss:
; ATOM:       # BB#0:
; ATOM-NEXT:    maxss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    maxss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_maxss:
; SLM:       # BB#0:
; SLM-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    maxss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_maxss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maxss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_maxss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maxss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.max.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.max.ss(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.max.ss(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_minps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_minps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    minps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_minps:
; ATOM:       # BB#0:
; ATOM-NEXT:    minps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    minps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_minps:
; SLM:       # BB#0:
; SLM-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    minps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_minps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_minps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_minps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_minps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.min.ps(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_minss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_minss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    minss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_minss:
; ATOM:       # BB#0:
; ATOM-NEXT:    minss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    minss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_minss:
; SLM:       # BB#0:
; SLM-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    minss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_minss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_minss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_minss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_minss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.min.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.min.ss(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.min.ss(<4 x float>, <4 x float>) nounwind readnone

define void @test_movaps(<4 x float> *%a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movaps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movaps (%rdi), %xmm0 # sched: [6:0.50]
; GENERIC-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    movaps %xmm0, (%rsi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movaps:
; ATOM:       # BB#0:
; ATOM-NEXT:    movaps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    addps %xmm0, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movaps:
; SLM:       # BB#0:
; SLM-NEXT:    movaps (%rdi), %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movaps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovaps (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovaps %xmm0, (%rsi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movaps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovaps (%rdi), %xmm0 # sched: [4:0.50]
; HASWELL-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movaps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movaps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovaps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = load <4 x float>, <4 x float> *%a0, align 16
  %2 = fadd <4 x float> %1, %1
  store <4 x float> %2, <4 x float> *%a1, align 16
  ret void
}

; TODO (v)movhlps

define <4 x float> @test_movhlps(<4 x float> %a0, <4 x float> %a1) {
; GENERIC-LABEL: test_movhlps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movhlps:
; ATOM:       # BB#0:
; ATOM-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movhlps:
; SLM:       # BB#0:
; SLM-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movhlps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movhlps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movhlps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movhlps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 6, i32 7, i32 2, i32 3>
  ret <4 x float> %1
}

; TODO (v)movhps

define void @test_movhps(<4 x float> %a0, <4 x float> %a1, x86_mmx *%a2) {
; GENERIC-LABEL: test_movhps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; GENERIC-NEXT:    movlps %xmm1, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movhps:
; ATOM:       # BB#0:
; ATOM-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; ATOM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movhps:
; SLM:       # BB#0:
; SLM-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [4:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    pextrq $1, %xmm1, (%rdi) # sched: [4:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movhps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movhps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [5:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movhps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movhps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [8:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = bitcast x86_mmx* %a2 to <2 x float>*
  %2 = load <2 x float>, <2 x float> *%1, align 8
  %3 = shufflevector <2 x float> %2, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x float> %a1, <4 x float> %3, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %5 = fadd <4 x float> %a0, %4
  %6 = shufflevector <4 x float> %5, <4 x float> undef, <2 x i32> <i32 2, i32 3>
  store <2 x float> %6, <2 x float>* %1
  ret void
}

; TODO (v)movlhps

define <4 x float> @test_movlhps(<4 x float> %a0, <4 x float> %a1) {
; GENERIC-LABEL: test_movlhps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movlhps:
; ATOM:       # BB#0:
; ATOM-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movlhps:
; SLM:       # BB#0:
; SLM-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movlhps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SANDY-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movlhps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; HASWELL-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movlhps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:0.50]
; BTVER2-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movlhps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:0.50]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %2 = fadd <4 x float> %a1, %1
  ret <4 x float> %2
}

define void @test_movlps(<4 x float> %a0, <4 x float> %a1, x86_mmx *%a2) {
; GENERIC-LABEL: test_movlps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    movlps %xmm1, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movlps:
; ATOM:       # BB#0:
; ATOM-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movlps:
; SLM:       # BB#0:
; SLM-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [4:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movlps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovlps %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movlps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [5:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movlps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movlps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = bitcast x86_mmx* %a2 to <2 x float>*
  %2 = load <2 x float>, <2 x float> *%1, align 8
  %3 = shufflevector <2 x float> %2, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x float> %a1, <4 x float> %3, <4 x i32> <i32 4, i32 5, i32 2, i32 3>
  %5 = fadd <4 x float> %a0, %4
  %6 = shufflevector <4 x float> %5, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  store <2 x float> %6, <2 x float>* %1
  ret void
}

define i32 @test_movmskps(<4 x float> %a0) {
; GENERIC-LABEL: test_movmskps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movmskps %xmm0, %eax # sched: [2:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movmskps:
; ATOM:       # BB#0:
; ATOM-NEXT:    movmskps %xmm0, %eax # sched: [3:3.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movmskps:
; SLM:       # BB#0:
; SLM-NEXT:    movmskps %xmm0, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movmskps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovmskps %xmm0, %eax # sched: [2:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movmskps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovmskps %xmm0, %eax # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movmskps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovmskps %xmm0, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movmskps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovmskps %xmm0, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call i32 @llvm.x86.sse.movmsk.ps(<4 x float> %a0)
  ret i32 %1
}
declare i32 @llvm.x86.sse.movmsk.ps(<4 x float>) nounwind readnone

define void @test_movntps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movntps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movntps %xmm0, (%rdi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movntps:
; ATOM:       # BB#0:
; ATOM-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movntps:
; SLM:       # BB#0:
; SLM-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movntps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovntps %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movntps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movntps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movntps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  store <4 x float> %a0, <4 x float> *%a1, align 16, !nontemporal !0
  ret void
}

define void @test_movss_mem(float* %a0, float* %a1) {
; GENERIC-LABEL: test_movss_mem:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    movss %xmm0, (%rsi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movss_mem:
; ATOM:       # BB#0:
; ATOM-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    addss %xmm0, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movss_mem:
; SLM:       # BB#0:
; SLM-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movss_mem:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovss %xmm0, (%rsi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movss_mem:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movss_mem:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movss_mem:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = load float, float* %a0, align 1
  %2 = fadd float %1, %1
  store float %2, float *%a1, align 1
  ret void
}

define <4 x float> @test_movss_reg(<4 x float> %a0, <4 x float> %a1) {
; GENERIC-LABEL: test_movss_reg:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movss_reg:
; ATOM:       # BB#0:
; ATOM-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movss_reg:
; SLM:       # BB#0:
; SLM-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movss_reg:
; SANDY:       # BB#0:
; SANDY-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movss_reg:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.33]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movss_reg:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movss_reg:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x float> %1
}

define void @test_movups(<4 x float> *%a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movups:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movups (%rdi), %xmm0 # sched: [6:0.50]
; GENERIC-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    movups %xmm0, (%rsi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movups:
; ATOM:       # BB#0:
; ATOM-NEXT:    movups (%rdi), %xmm0 # sched: [3:1.50]
; ATOM-NEXT:    addps %xmm0, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    movups %xmm0, (%rsi) # sched: [2:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movups:
; SLM:       # BB#0:
; SLM-NEXT:    movups (%rdi), %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movups:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovups %xmm0, (%rsi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movups:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovups (%rdi), %xmm0 # sched: [4:0.50]
; HASWELL-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movups:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovups (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movups:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovups (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = load <4 x float>, <4 x float> *%a0, align 1
  %2 = fadd <4 x float> %1, %1
  store <4 x float> %2, <4 x float> *%a1, align 1
  ret void
}

define <4 x float> @test_mulps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_mulps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    mulps %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    mulps (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_mulps:
; ATOM:       # BB#0:
; ATOM-NEXT:    mulps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    mulps (%rdi), %xmm0 # sched: [10:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_mulps:
; SLM:       # BB#0:
; SLM-NEXT:    mulps %xmm1, %xmm0 # sched: [5:2.00]
; SLM-NEXT:    mulps (%rdi), %xmm0 # sched: [8:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_mulps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_mulps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_mulps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_mulps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [12:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fmul <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fmul <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_mulss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_mulss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    mulss %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    mulss (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_mulss:
; ATOM:       # BB#0:
; ATOM-NEXT:    mulss %xmm1, %xmm0 # sched: [4:4.00]
; ATOM-NEXT:    mulss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_mulss:
; SLM:       # BB#0:
; SLM-NEXT:    mulss %xmm1, %xmm0 # sched: [5:2.00]
; SLM-NEXT:    mulss (%rdi), %xmm0 # sched: [8:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_mulss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_mulss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_mulss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_mulss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [12:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fmul float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fmul float %1, %2
  ret float %3
}

define <4 x float> @test_orps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_orps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    orps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_orps:
; ATOM:       # BB#0:
; ATOM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    orps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_orps:
; SLM:       # BB#0:
; SLM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    orps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_orps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_orps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_orps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_orps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = or <4 x i32> %1, %2
  %4 = load <4 x float>, <4 x float> *%a2, align 16
  %5 = bitcast <4 x float> %4 to <4 x i32>
  %6 = or <4 x i32> %3, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

define void @test_prefetchnta(i8* %a0) {
; GENERIC-LABEL: test_prefetchnta:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_prefetchnta:
; ATOM:       # BB#0:
; ATOM-NEXT:    prefetchnta (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_prefetchnta:
; SLM:       # BB#0:
; SLM-NEXT:    prefetchnta (%rdi) # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_prefetchnta:
; SANDY:       # BB#0:
; SANDY-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_prefetchnta:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    prefetchnta (%rdi) # sched: [4:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_prefetchnta:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    prefetchnta (%rdi) # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_prefetchnta:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    prefetchnta (%rdi) # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  call void @llvm.prefetch(i8* %a0, i32 0, i32 0, i32 1)
  ret void
}
declare void @llvm.prefetch(i8* nocapture, i32, i32, i32) nounwind readnone

define <4 x float> @test_rcpps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_rcpps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    rcpps %xmm0, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    rcpps (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rcpps:
; ATOM:       # BB#0:
; ATOM-NEXT:    rcpps (%rdi), %xmm1 # sched: [10:5.00]
; ATOM-NEXT:    rcpps %xmm0, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rcpps:
; SLM:       # BB#0:
; SLM-NEXT:    rcpps (%rdi), %xmm1 # sched: [8:1.00]
; SLM-NEXT:    rcpps %xmm0, %xmm0 # sched: [5:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_rcpps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vrcpps (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_rcpps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vrcpps (%rdi), %xmm1 # sched: [9:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_rcpps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vrcpps (%rdi), %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vrcpps %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_rcpps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vrcpps (%rdi), %xmm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.rcp.ps(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.rcp.ps(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.rcp.ps(<4 x float>) nounwind readnone

; TODO - rcpss_m

define <4 x float> @test_rcpss(float %a0, float *%a1) {
; GENERIC-LABEL: test_rcpss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rcpss:
; ATOM:       # BB#0:
; ATOM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    rcpss %xmm0, %xmm0
; ATOM-NEXT:    rcpss %xmm1, %xmm1
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rcpss:
; SLM:       # BB#0:
; SLM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    rcpss %xmm0, %xmm0 # sched: [8:1.00]
; SLM-NEXT:    rcpss %xmm1, %xmm1 # sched: [8:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_rcpss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_rcpss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [9:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_rcpss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_rcpss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [12:0.50]
; ZNVER1-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call <4 x float> @llvm.x86.sse.rcp.ss(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call <4 x float> @llvm.x86.sse.rcp.ss(<4 x float> %4)
  %6 = fadd <4 x float> %2, %5
  ret <4 x float> %6
}
declare <4 x float> @llvm.x86.sse.rcp.ss(<4 x float>) nounwind readnone

define <4 x float> @test_rsqrtps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_rsqrtps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rsqrtps:
; ATOM:       # BB#0:
; ATOM-NEXT:    rsqrtps (%rdi), %xmm1 # sched: [10:5.00]
; ATOM-NEXT:    rsqrtps %xmm0, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rsqrtps:
; SLM:       # BB#0:
; SLM-NEXT:    rsqrtps (%rdi), %xmm1 # sched: [8:1.00]
; SLM-NEXT:    rsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_rsqrtps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_rsqrtps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [9:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_rsqrtps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_rsqrtps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float>) nounwind readnone

; TODO - rsqrtss_m

define <4 x float> @test_rsqrtss(float %a0, float *%a1) {
; GENERIC-LABEL: test_rsqrtss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rsqrtss:
; ATOM:       # BB#0:
; ATOM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    rsqrtss %xmm0, %xmm0
; ATOM-NEXT:    rsqrtss %xmm1, %xmm1
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rsqrtss:
; SLM:       # BB#0:
; SLM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [8:1.00]
; SLM-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [8:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_rsqrtss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_rsqrtss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_rsqrtss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_rsqrtss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [12:0.50]
; ZNVER1-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float> %4)
  %6 = fadd <4 x float> %2, %5
  ret <4 x float> %6
}
declare <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float>) nounwind readnone

define void @test_sfence() {
; GENERIC-LABEL: test_sfence:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    sfence # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_sfence:
; ATOM:       # BB#0:
; ATOM-NEXT:    sfence # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_sfence:
; SLM:       # BB#0:
; SLM-NEXT:    sfence # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_sfence:
; SANDY:       # BB#0:
; SANDY-NEXT:    sfence # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_sfence:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    sfence # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_sfence:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    sfence # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_sfence:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    sfence # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  call void @llvm.x86.sse.sfence()
  ret void
}
declare void @llvm.x86.sse.sfence() nounwind readnone

define <4 x float> @test_shufps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) nounwind {
; GENERIC-LABEL: test_shufps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; GENERIC-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_shufps:
; ATOM:       # BB#0:
; ATOM-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; ATOM-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_shufps:
; SLM:       # BB#0:
; SLM-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SLM-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_shufps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SANDY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_shufps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; HASWELL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_shufps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:0.50]
; BTVER2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_shufps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:0.50]
; ZNVER1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,3],mem[0,0] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 0, i32 4, i32 4>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %1, <4 x float> %2, <4 x i32> <i32 0, i32 3, i32 4, i32 4>
  ret <4 x float> %3
}

define <4 x float> @test_sqrtps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_sqrtps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    sqrtps %xmm0, %xmm1 # sched: [14:1.00]
; GENERIC-NEXT:    sqrtps (%rdi), %xmm0 # sched: [20:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_sqrtps:
; ATOM:       # BB#0:
; ATOM-NEXT:    sqrtps %xmm0, %xmm1 # sched: [70:35.00]
; ATOM-NEXT:    sqrtps (%rdi), %xmm0 # sched: [70:35.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_sqrtps:
; SLM:       # BB#0:
; SLM-NEXT:    sqrtps (%rdi), %xmm1 # sched: [18:1.00]
; SLM-NEXT:    sqrtps %xmm0, %xmm0 # sched: [15:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_sqrtps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [14:1.00]
; SANDY-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [20:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_sqrtps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [15:1.00]
; HASWELL-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [19:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_sqrtps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [26:21.00]
; BTVER2-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [21:21.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_sqrtps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [27:1.00]
; ZNVER1-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [20:1.00]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float>) nounwind readnone

; TODO - sqrtss_m

define <4 x float> @test_sqrtss(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_sqrtss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    sqrtss %xmm0, %xmm0 # sched: [14:1.00]
; GENERIC-NEXT:    movaps (%rdi), %xmm1 # sched: [6:0.50]
; GENERIC-NEXT:    sqrtss %xmm1, %xmm1 # sched: [14:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_sqrtss:
; ATOM:       # BB#0:
; ATOM-NEXT:    movaps (%rdi), %xmm1 # sched: [1:1.00]
; ATOM-NEXT:    sqrtss %xmm0, %xmm0
; ATOM-NEXT:    sqrtss %xmm1, %xmm1
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_sqrtss:
; SLM:       # BB#0:
; SLM-NEXT:    movaps (%rdi), %xmm1 # sched: [3:1.00]
; SLM-NEXT:    sqrtss %xmm0, %xmm0 # sched: [18:1.00]
; SLM-NEXT:    sqrtss %xmm1, %xmm1 # sched: [18:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_sqrtss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [114:1.00]
; SANDY-NEXT:    vmovaps (%rdi), %xmm1 # sched: [6:0.50]
; SANDY-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [114:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_sqrtss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [19:1.00]
; HASWELL-NEXT:    vmovaps (%rdi), %xmm1 # sched: [4:0.50]
; HASWELL-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [19:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_sqrtss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps (%rdi), %xmm1 # sched: [5:1.00]
; BTVER2-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [26:21.00]
; BTVER2-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [26:21.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_sqrtss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vmovaps (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [27:1.00]
; ZNVER1-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [27:1.00]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float>) nounwind readnone

define i32 @test_stmxcsr() {
; GENERIC-LABEL: test_stmxcsr:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_stmxcsr:
; ATOM:       # BB#0:
; ATOM-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [15:7.50]
; ATOM-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_stmxcsr:
; SLM:       # BB#0:
; SLM-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SLM-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_stmxcsr:
; SANDY:       # BB#0:
; SANDY-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_stmxcsr:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; HASWELL-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [4:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_stmxcsr:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_stmxcsr:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [1:0.50]
; ZNVER1-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = alloca i32, align 4
  %2 = bitcast i32* %1 to i8*
  call void @llvm.x86.sse.stmxcsr(i8* %2)
  %3 = load i32, i32* %1, align 4
  ret i32 %3
}
declare void @llvm.x86.sse.stmxcsr(i8*) nounwind readnone

define <4 x float> @test_subps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_subps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    subps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_subps:
; ATOM:       # BB#0:
; ATOM-NEXT:    subps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    subps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_subps:
; SLM:       # BB#0:
; SLM-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    subps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_subps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_subps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_subps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_subps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fsub <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fsub <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_subss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_subss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    subss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_subss:
; ATOM:       # BB#0:
; ATOM-NEXT:    subss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    subss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_subss:
; SLM:       # BB#0:
; SLM-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    subss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_subss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_subss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_subss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_subss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = fsub float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fsub float %1, %2
  ret float %3
}

define i32 @test_ucomiss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_ucomiss:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %cl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %cl # sched: [1:0.33]
; GENERIC-NEXT:    ucomiss (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %dl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %dl # sched: [1:0.33]
; GENERIC-NEXT:    orb %cl, %dl # sched: [1:0.33]
; GENERIC-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_ucomiss:
; ATOM:       # BB#0:
; ATOM-NEXT:    ucomiss %xmm1, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %cl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %cl # sched: [1:0.50]
; ATOM-NEXT:    ucomiss (%rdi), %xmm0 # sched: [10:5.00]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %dl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %dl # sched: [1:0.50]
; ATOM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; ATOM-NEXT:    movzbl %dl, %eax # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_ucomiss:
; SLM:       # BB#0:
; SLM-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %cl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %cl # sched: [1:0.50]
; SLM-NEXT:    ucomiss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %dl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %dl # sched: [1:0.50]
; SLM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; SLM-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_ucomiss:
; SANDY:       # BB#0:
; SANDY-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %cl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-NEXT:    vucomiss (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %dl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %dl # sched: [1:0.33]
; SANDY-NEXT:    orb %cl, %dl # sched: [1:0.33]
; SANDY-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_ucomiss:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %cl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-NEXT:    vucomiss (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %dl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %dl # sched: [1:0.25]
; HASWELL-NEXT:    orb %cl, %dl # sched: [1:0.25]
; HASWELL-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_ucomiss:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %cl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-NEXT:    vucomiss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %dl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %dl # sched: [1:0.50]
; BTVER2-NEXT:    orb %cl, %dl # sched: [1:0.50]
; BTVER2-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_ucomiss:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %cl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-NEXT:    vucomiss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %dl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    orb %cl, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = call i32 @llvm.x86.sse.ucomieq.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 4
  %3 = call i32 @llvm.x86.sse.ucomieq.ss(<4 x float> %a0, <4 x float> %2)
  %4 = or i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse.ucomieq.ss(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_unpckhps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_unpckhps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; GENERIC-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_unpckhps:
; ATOM:       # BB#0:
; ATOM-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; ATOM-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_unpckhps:
; SLM:       # BB#0:
; SLM-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SLM-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_unpckhps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SANDY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_unpckhps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; HASWELL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_unpckhps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:0.50]
; BTVER2-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_unpckhps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:0.50]
; ZNVER1-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],mem[2],xmm0[3],mem[3] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %1, <4 x float> %2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  ret <4 x float> %3
}

define <4 x float> @test_unpcklps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_unpcklps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; GENERIC-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_unpcklps:
; ATOM:       # BB#0:
; ATOM-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; ATOM-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_unpcklps:
; SLM:       # BB#0:
; SLM-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SLM-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_unpcklps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SANDY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_unpcklps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; HASWELL-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_unpcklps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:0.50]
; BTVER2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_unpcklps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:0.50]
; ZNVER1-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1] sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %1, <4 x float> %2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  ret <4 x float> %3
}

define <4 x float> @test_xorps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_xorps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    xorps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    xorps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_xorps:
; ATOM:       # BB#0:
; ATOM-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    xorps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_xorps:
; SLM:       # BB#0:
; SLM-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    xorps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_xorps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_xorps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_xorps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_xorps:
; ZNVER1:       # BB#0:
; ZNVER1-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [5:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = xor <4 x i32> %1, %2
  %4 = load <4 x float>, <4 x float> *%a2, align 16
  %5 = bitcast <4 x float> %4 to <4 x i32>
  %6 = xor <4 x i32> %3, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

!0 = !{i32 1}
