; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-macosx   | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-apple-macosx | FileCheck %s --check-prefix=X64

define i32 @t1(i32 %t, i32 %val) nounwind {
; X32-LABEL: t1:
; X32:       ## BB#0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll %cl, %eax
; X32-NEXT:    retl
; X32-NEXT:    ## -- End function
;
; X64-LABEL: t1:
; X64:       ## BB#0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    shll %cl, %esi
; X64-NEXT:    movl %esi, %eax
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function

       %shamt = and i32 %t, 31
       %res = shl i32 %val, %shamt
       ret i32 %res
}

define i32 @t2(i32 %t, i32 %val) nounwind {
; X32-LABEL: t2:
; X32:       ## BB#0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    shll %cl, %eax
; X32-NEXT:    retl
; X32-NEXT:    ## -- End function
;
; X64-LABEL: t2:
; X64:       ## BB#0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    shll %cl, %esi
; X64-NEXT:    movl %esi, %eax
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function

       %shamt = and i32 %t, 63
       %res = shl i32 %val, %shamt
       ret i32 %res
}

@X = internal global i16 0

define void @t3(i16 %t) nounwind {
; X32-LABEL: t3:
; X32:       ## BB#0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X32-NEXT:    sarw %cl, _X
; X32-NEXT:    retl
; X32-NEXT:    ## -- End function
;
; X64-LABEL: t3:
; X64:       ## BB#0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    sarw %cl, {{.*}}(%rip)
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function

       %shamt = and i16 %t, 31
       %tmp = load i16, i16* @X
       %tmp1 = ashr i16 %tmp, %shamt
       store i16 %tmp1, i16* @X
       ret void
}

define i64 @t4(i64 %t, i64 %val) nounwind {
; X64-LABEL: t4:
; X64:       ## BB#0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    shrq %cl, %rsi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function
       %shamt = and i64 %t, 63
       %res = lshr i64 %val, %shamt
       ret i64 %res
}

define i64 @t5(i64 %t, i64 %val) nounwind {
; X64-LABEL: t5:
; X64:       ## BB#0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    shrq %cl, %rsi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function
       %shamt = and i64 %t, 191
       %res = lshr i64 %val, %shamt
       ret i64 %res
}

define void @t5ptr(i64 %t, i64* %ptr) nounwind {
; X64-LABEL: t5ptr:
; X64:       ## BB#0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    shrq %cl, (%rsi)
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function
       %shamt = and i64 %t, 191
       %tmp = load i64, i64* %ptr
       %tmp1 = lshr i64 %tmp, %shamt
       store i64 %tmp1, i64* %ptr
       ret void
}


; rdar://11866926
define i64 @t6(i64 %key, i64* nocapture %val) nounwind {
; X64-LABEL: t6:
; X64:       ## BB#0:
; X64-NEXT:    shrq $3, %rdi
; X64-NEXT:    movq (%rsi), %rax
; X64-NEXT:    decq %rax
; X64-NEXT:    andq %rdi, %rax
; X64-NEXT:    retq
; X64-NEXT:    ## -- End function
; X64-NEXT:  .zerofill __DATA,__bss,_X,2,1 ## @X
  %shr = lshr i64 %key, 3
  %1 = load i64, i64* %val, align 8
  %sub = add i64 %1, 2305843009213693951
  %and = and i64 %sub, %shr
  ret i64 %and
}
