; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+cmov | FileCheck %s --check-prefix=CMOV
; RUN: llc < %s -mtriple=i686-unknown-unknown   -mattr=-cmov | FileCheck %s --check-prefix=NO_CMOV

define i32 @cmov_zpromotion_16_to_32(i1 %c) {
; CMOV-LABEL: cmov_zpromotion_16_to_32:
; CMOV:       # BB#0:
; CMOV-NEXT:    testb $1, %dil
; CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; CMOV-NEXT:    movw $-1, %cx
; CMOV-NEXT:    cmovnew %ax, %cx
; CMOV-NEXT:    movzwl %cx, %eax
; CMOV-NEXT:    retq
;
; NO_CMOV-LABEL: cmov_zpromotion_16_to_32:
; NO_CMOV:       # BB#0:
; NO_CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; NO_CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; NO_CMOV-NEXT:    jne .LBB0_2
; NO_CMOV-NEXT:  # BB#1:
; NO_CMOV-NEXT:    movw $-1, %ax
; NO_CMOV-NEXT:  .LBB0_2:
; NO_CMOV-NEXT:    movzwl %ax, %eax
; NO_CMOV-NEXT:    retl
  %t0 = select i1 %c, i16 12414, i16 -1
  %ret = zext i16 %t0 to i32
  ret i32 %ret
}

define i64 @cmov_zpromotion_16_to_64(i1 %c) {
; CMOV-LABEL: cmov_zpromotion_16_to_64:
; CMOV:       # BB#0:
; CMOV-NEXT:    testb $1, %dil
; CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; CMOV-NEXT:    movw $-1, %cx
; CMOV-NEXT:    cmovnew %ax, %cx
; CMOV-NEXT:    movzwl %cx, %eax
; CMOV-NEXT:    retq
;
; NO_CMOV-LABEL: cmov_zpromotion_16_to_64:
; NO_CMOV:       # BB#0:
; NO_CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; NO_CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; NO_CMOV-NEXT:    jne .LBB1_2
; NO_CMOV-NEXT:  # BB#1:
; NO_CMOV-NEXT:    movw $-1, %ax
; NO_CMOV-NEXT:  .LBB1_2:
; NO_CMOV-NEXT:    movzwl %ax, %eax
; NO_CMOV-NEXT:    xorl %edx, %edx
; NO_CMOV-NEXT:    retl
  %t0 = select i1 %c, i16 12414, i16 -1
  %ret = zext i16 %t0 to i64
  ret i64 %ret
}

define i32 @cmov_spromotion_16_to_32(i1 %c) {
; CMOV-LABEL: cmov_spromotion_16_to_32:
; CMOV:       # BB#0:
; CMOV-NEXT:    testb $1, %dil
; CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; CMOV-NEXT:    movw $-1, %cx
; CMOV-NEXT:    cmovnew %ax, %cx
; CMOV-NEXT:    movswl %cx, %eax
; CMOV-NEXT:    retq
;
; NO_CMOV-LABEL: cmov_spromotion_16_to_32:
; NO_CMOV:       # BB#0:
; NO_CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; NO_CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; NO_CMOV-NEXT:    jne .LBB2_2
; NO_CMOV-NEXT:  # BB#1:
; NO_CMOV-NEXT:    movw $-1, %ax
; NO_CMOV-NEXT:  .LBB2_2:
; NO_CMOV-NEXT:    cwtl
; NO_CMOV-NEXT:    retl
  %t0 = select i1 %c, i16 12414, i16 -1
  %ret = sext i16 %t0 to i32
  ret i32 %ret
}

define i64 @cmov_spromotion_16_to_64(i1 %c) {
; CMOV-LABEL: cmov_spromotion_16_to_64:
; CMOV:       # BB#0:
; CMOV-NEXT:    testb $1, %dil
; CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; CMOV-NEXT:    movw $-1, %cx
; CMOV-NEXT:    cmovnew %ax, %cx
; CMOV-NEXT:    movswq %cx, %rax
; CMOV-NEXT:    retq
;
; NO_CMOV-LABEL: cmov_spromotion_16_to_64:
; NO_CMOV:       # BB#0:
; NO_CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; NO_CMOV-NEXT:    movw $12414, %ax # imm = 0x307E
; NO_CMOV-NEXT:    jne .LBB3_2
; NO_CMOV-NEXT:  # BB#1:
; NO_CMOV-NEXT:    movw $-1, %ax
; NO_CMOV-NEXT:  .LBB3_2:
; NO_CMOV-NEXT:    cwtl
; NO_CMOV-NEXT:    movl %eax, %edx
; NO_CMOV-NEXT:    sarl $31, %edx
; NO_CMOV-NEXT:    retl
  %t0 = select i1 %c, i16 12414, i16 -1
  %ret = sext i16 %t0 to i64
  ret i64 %ret
}

