; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl -mattr=+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512BW
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu -mcpu=knl -mattr=+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512F-32

declare void @llvm.x86.avx512.mask.storeu.b.512(i8*, <64 x i8>, i64)

define void@test_int_x86_avx512_mask_storeu_b_512(i8* %ptr1, i8* %ptr2, <64 x i8> %x1, i64 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_storeu_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vmovdqu32 %zmm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_storeu_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovdqu8 %zmm0, (%ecx) {%k1}
; AVX512F-32-NEXT:    vmovdqu32 %zmm0, (%eax)
; AVX512F-32-NEXT:    retl
  call void @llvm.x86.avx512.mask.storeu.b.512(i8* %ptr1, <64 x i8> %x1, i64 %x2)
  call void @llvm.x86.avx512.mask.storeu.b.512(i8* %ptr2, <64 x i8> %x1, i64 -1)
  ret void
}

declare void @llvm.x86.avx512.mask.storeu.w.512(i8*, <32 x i16>, i32)

define void@test_int_x86_avx512_mask_storeu_w_512(i8* %ptr1, i8* %ptr2, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_storeu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vmovdqu32 %zmm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_storeu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovdqu16 %zmm0, (%ecx) {%k1}
; AVX512F-32-NEXT:    vmovdqu32 %zmm0, (%eax)
; AVX512F-32-NEXT:    retl
  call void @llvm.x86.avx512.mask.storeu.w.512(i8* %ptr1, <32 x i16> %x1, i32 %x2)
  call void @llvm.x86.avx512.mask.storeu.w.512(i8* %ptr2, <32 x i16> %x1, i32 -1)
  ret void
}

declare <32 x i16> @llvm.x86.avx512.mask.loadu.w.512(i8*, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_loadu_w_512(i8* %ptr, i8* %ptr2, <32 x i16> %x1, i32 %mask) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_loadu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vmovdqu64 (%rdi), %zmm0
; AVX512BW-NEXT:    kmovd %edx, %k1
; AVX512BW-NEXT:    vmovdqu16 (%rsi), %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu16 (%rdi), %zmm1 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_loadu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    vmovdqu64 (%ecx), %zmm0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovdqu16 (%eax), %zmm0 {%k1}
; AVX512F-32-NEXT:    vmovdqu16 (%ecx), %zmm1 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res0 = call <32 x i16> @llvm.x86.avx512.mask.loadu.w.512(i8* %ptr, <32 x i16> %x1, i32 -1)
  %res = call <32 x i16> @llvm.x86.avx512.mask.loadu.w.512(i8* %ptr2, <32 x i16> %res0, i32 %mask)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.loadu.w.512(i8* %ptr, <32 x i16> zeroinitializer, i32 %mask)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.loadu.b.512(i8*, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_loadu_b_512(i8* %ptr, i8* %ptr2, <64 x i8> %x1, i64 %mask) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_loadu_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vmovdqu64 (%rdi), %zmm0
; AVX512BW-NEXT:    kmovq %rdx, %k1
; AVX512BW-NEXT:    vmovdqu8 (%rsi), %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu8 (%rdi), %zmm1 {%k1} {z}
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_loadu_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    vmovdqu64 (%ecx), %zmm0
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovdqu8 (%eax), %zmm0 {%k1}
; AVX512F-32-NEXT:    vmovdqu8 (%ecx), %zmm1 {%k1} {z}
; AVX512F-32-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res0 = call <64 x i8> @llvm.x86.avx512.mask.loadu.b.512(i8* %ptr, <64 x i8> %x1, i64 -1)
  %res = call <64 x i8> @llvm.x86.avx512.mask.loadu.b.512(i8* %ptr2, <64 x i8> %res0, i64 %mask)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.loadu.b.512(i8* %ptr, <64 x i8> zeroinitializer, i64 %mask)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64>, i32)

define <8 x i64>@test_int_x86_avx512_psll_dq_512(<8 x i64> %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_psll_dq_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpslldq {{.*#+}} zmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zmm0[0,1,2,3,4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[16,17,18,19,20,21,22,23],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[32,33,34,35,36,37,38,39],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[48,49,50,51,52,53,54,55]
; AVX512BW-NEXT:    vpslldq {{.*#+}} zmm0 = zero,zero,zero,zero,zmm0[0,1,2,3,4,5,6,7,8,9,10,11],zero,zero,zero,zero,zmm0[16,17,18,19,20,21,22,23,24,25,26,27],zero,zero,zero,zero,zmm0[32,33,34,35,36,37,38,39,40,41,42,43],zero,zero,zero,zero,zmm0[48,49,50,51,52,53,54,55,56,57,58,59]
; AVX512BW-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_psll_dq_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpslldq {{.*#+}} zmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zmm0[0,1,2,3,4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[16,17,18,19,20,21,22,23],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[32,33,34,35,36,37,38,39],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[48,49,50,51,52,53,54,55]
; AVX512F-32-NEXT:    vpslldq {{.*#+}} zmm0 = zero,zero,zero,zero,zmm0[0,1,2,3,4,5,6,7,8,9,10,11],zero,zero,zero,zero,zmm0[16,17,18,19,20,21,22,23,24,25,26,27],zero,zero,zero,zero,zmm0[32,33,34,35,36,37,38,39,40,41,42,43],zero,zero,zero,zero,zmm0[48,49,50,51,52,53,54,55,56,57,58,59]
; AVX512F-32-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64> %x0, i32 8)
  %res1 = call <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64> %x0, i32 4)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}

define <8 x i64>@test_int_x86_avx512_psll_load_dq_512(<8 x i64>* %p0) {
; AVX512BW-LABEL: test_int_x86_avx512_psll_load_dq_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpslldq {{.*#+}} zmm0 = zero,zero,zero,zero,mem[0,1,2,3,4,5,6,7,8,9,10,11],zero,zero,zero,zero,mem[16,17,18,19,20,21,22,23,24,25,26,27],zero,zero,zero,zero,mem[32,33,34,35,36,37,38,39,40,41,42,43],zero,zero,zero,zero,mem[48,49,50,51,52,53,54,55,56,57,58,59]
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_psll_load_dq_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpslldq {{.*#+}} zmm0 = zero,zero,zero,zero,mem[0,1,2,3,4,5,6,7,8,9,10,11],zero,zero,zero,zero,mem[16,17,18,19,20,21,22,23,24,25,26,27],zero,zero,zero,zero,mem[32,33,34,35,36,37,38,39,40,41,42,43],zero,zero,zero,zero,mem[48,49,50,51,52,53,54,55,56,57,58,59]
; AVX512F-32-NEXT:    retl
  %x0 = load <8 x i64>, <8 x i64> *%p0
  %res = call <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64> %x0, i32 4)
  ret <8 x i64> %res
}

declare <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64>, i32)

define <8 x i64>@test_int_x86_avx512_psrl_dq_512(<8 x i64> %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_psrl_dq_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsrldq {{.*#+}} zmm1 = zmm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[24,25,26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[40,41,42,43,44,45,46,47],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[56,57,58,59,60,61,62,63],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsrldq {{.*#+}} zmm0 = zmm0[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zmm0[20,21,22,23,24,25,26,27,28,29,30,31],zero,zero,zero,zero,zmm0[36,37,38,39,40,41,42,43,44,45,46,47],zero,zero,zero,zero,zmm0[52,53,54,55,56,57,58,59,60,61,62,63],zero,zero,zero,zero
; AVX512BW-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_psrl_dq_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsrldq {{.*#+}} zmm1 = zmm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[24,25,26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[40,41,42,43,44,45,46,47],zero,zero,zero,zero,zero,zero,zero,zero,zmm0[56,57,58,59,60,61,62,63],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-32-NEXT:    vpsrldq {{.*#+}} zmm0 = zmm0[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zmm0[20,21,22,23,24,25,26,27,28,29,30,31],zero,zero,zero,zero,zmm0[36,37,38,39,40,41,42,43,44,45,46,47],zero,zero,zero,zero,zmm0[52,53,54,55,56,57,58,59,60,61,62,63],zero,zero,zero,zero
; AVX512F-32-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64> %x0, i32 8)
  %res1 = call <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64> %x0, i32 4)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}

define <8 x i64>@test_int_x86_avx512_psrl_load_dq_512(<8 x i64>* %p0) {
; AVX512BW-LABEL: test_int_x86_avx512_psrl_load_dq_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsrldq {{.*#+}} zmm0 = mem[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,mem[20,21,22,23,24,25,26,27,28,29,30,31],zero,zero,zero,zero,mem[36,37,38,39,40,41,42,43,44,45,46,47],zero,zero,zero,zero,mem[52,53,54,55,56,57,58,59,60,61,62,63],zero,zero,zero,zero
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_psrl_load_dq_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpsrldq {{.*#+}} zmm0 = mem[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,mem[20,21,22,23,24,25,26,27,28,29,30,31],zero,zero,zero,zero,mem[36,37,38,39,40,41,42,43,44,45,46,47],zero,zero,zero,zero,mem[52,53,54,55,56,57,58,59,60,61,62,63],zero,zero,zero,zero
; AVX512F-32-NEXT:    retl
  %x0 = load <8 x i64>, <8 x i64> *%p0
  %res = call <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64> %x0, i32 4)
  ret <8 x i64> %res
}

declare <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8>, <64 x i8>, i32, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_palignr_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x3, i64 %x4) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_palignr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpalignr {{.*#+}} zmm3 = zmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zmm0[0,1],zmm1[18,19,20,21,22,23,24,25,26,27,28,29,30,31],zmm0[16,17],zmm1[34,35,36,37,38,39,40,41,42,43,44,45,46,47],zmm0[32,33],zmm1[50,51,52,53,54,55,56,57,58,59,60,61,62,63],zmm0[48,49]
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpalignr {{.*#+}} zmm2 {%k1} = zmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zmm0[0,1],zmm1[18,19,20,21,22,23,24,25,26,27,28,29,30,31],zmm0[16,17],zmm1[34,35,36,37,38,39,40,41,42,43,44,45,46,47],zmm0[32,33],zmm1[50,51,52,53,54,55,56,57,58,59,60,61,62,63],zmm0[48,49]
; AVX512BW-NEXT:    vpalignr {{.*#+}} zmm0 {%k1} {z} = zmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zmm0[0,1],zmm1[18,19,20,21,22,23,24,25,26,27,28,29,30,31],zmm0[16,17],zmm1[34,35,36,37,38,39,40,41,42,43,44,45,46,47],zmm0[32,33],zmm1[50,51,52,53,54,55,56,57,58,59,60,61,62,63],zmm0[48,49]
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_palignr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpalignr {{.*#+}} zmm3 = zmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zmm0[0,1],zmm1[18,19,20,21,22,23,24,25,26,27,28,29,30,31],zmm0[16,17],zmm1[34,35,36,37,38,39,40,41,42,43,44,45,46,47],zmm0[32,33],zmm1[50,51,52,53,54,55,56,57,58,59,60,61,62,63],zmm0[48,49]
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpalignr {{.*#+}} zmm2 {%k1} = zmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zmm0[0,1],zmm1[18,19,20,21,22,23,24,25,26,27,28,29,30,31],zmm0[16,17],zmm1[34,35,36,37,38,39,40,41,42,43,44,45,46,47],zmm0[32,33],zmm1[50,51,52,53,54,55,56,57,58,59,60,61,62,63],zmm0[48,49]
; AVX512F-32-NEXT:    vpalignr {{.*#+}} zmm0 {%k1} {z} = zmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zmm0[0,1],zmm1[18,19,20,21,22,23,24,25,26,27,28,29,30,31],zmm0[16,17],zmm1[34,35,36,37,38,39,40,41,42,43,44,45,46,47],zmm0[32,33],zmm1[50,51,52,53,54,55,56,57,58,59,60,61,62,63],zmm0[48,49]
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <64 x i8> %x3, i64 %x4)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <64 x i8> zeroinitializer, i64 %x4)
  %res2 = call <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <64 x i8> %x3, i64 -1)
  %res3 = add <64 x i8> %res, %res1
  %res4 = add <64 x i8> %res3, %res2
  ret <64 x i8> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16>, i32, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pshufh_w_512(<32 x i16> %x0, i32 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pshufh_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpshufhw {{.*#+}} zmm2 = zmm0[0,1,2,3,7,4,4,4,8,9,10,11,15,12,12,12,16,17,18,19,23,20,20,20,24,25,26,27,31,28,28,28]
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpshufhw {{.*#+}} zmm1 {%k1} = zmm0[0,1,2,3,7,4,4,4,8,9,10,11,15,12,12,12,16,17,18,19,23,20,20,20,24,25,26,27,31,28,28,28]
; AVX512BW-NEXT:    vpshufhw {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3,7,4,4,4,8,9,10,11,15,12,12,12,16,17,18,19,23,20,20,20,24,25,26,27,31,28,28,28]
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pshufh_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpshufhw {{.*#+}} zmm2 = zmm0[0,1,2,3,7,4,4,4,8,9,10,11,15,12,12,12,16,17,18,19,23,20,20,20,24,25,26,27,31,28,28,28]
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpshufhw {{.*#+}} zmm1 {%k1} = zmm0[0,1,2,3,7,4,4,4,8,9,10,11,15,12,12,12,16,17,18,19,23,20,20,20,24,25,26,27,31,28,28,28]
; AVX512F-32-NEXT:    vpshufhw {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3,7,4,4,4,8,9,10,11,15,12,12,12,16,17,18,19,23,20,20,20,24,25,26,27,31,28,28,28]
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16> %x0, i32 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16>, i32, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pshufl_w_512(<32 x i16> %x0, i32 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pshufl_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpshuflw {{.*#+}} zmm2 = zmm0[3,0,0,0,4,5,6,7,11,8,8,8,12,13,14,15,19,16,16,16,20,21,22,23,27,24,24,24,28,29,30,31]
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpshuflw {{.*#+}} zmm1 {%k1} = zmm0[3,0,0,0,4,5,6,7,11,8,8,8,12,13,14,15,19,16,16,16,20,21,22,23,27,24,24,24,28,29,30,31]
; AVX512BW-NEXT:    vpshuflw {{.*#+}} zmm0 {%k1} {z} = zmm0[3,0,0,0,4,5,6,7,11,8,8,8,12,13,14,15,19,16,16,16,20,21,22,23,27,24,24,24,28,29,30,31]
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pshufl_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpshuflw {{.*#+}} zmm2 = zmm0[3,0,0,0,4,5,6,7,11,8,8,8,12,13,14,15,19,16,16,16,20,21,22,23,27,24,24,24,28,29,30,31]
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpshuflw {{.*#+}} zmm1 {%k1} = zmm0[3,0,0,0,4,5,6,7,11,8,8,8,12,13,14,15,19,16,16,16,20,21,22,23,27,24,24,24,28,29,30,31]
; AVX512F-32-NEXT:    vpshuflw {{.*#+}} zmm0 {%k1} {z} = zmm0[3,0,0,0,4,5,6,7,11,8,8,8,12,13,14,15,19,16,16,16,20,21,22,23,27,24,24,24,28,29,30,31]
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16> %x0, i32 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

define i64 @test_pcmpeq_b(<64 x i8> %a, <64 x i8> %b) {
; AVX512BW-LABEL: test_pcmpeq_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpeq_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Lcfi0:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpeq.b.512(<64 x i8> %a, <64 x i8> %b, i64 -1)
  ret i64 %res
}

define i64 @test_mask_pcmpeq_b(<64 x i8> %a, <64 x i8> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_pcmpeq_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpeq_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Lcfi1:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpeq.b.512(<64 x i8> %a, <64 x i8> %b, i64 %mask)
  ret i64 %res
}

declare i64 @llvm.x86.avx512.mask.pcmpeq.b.512(<64 x i8>, <64 x i8>, i64)

define i32 @test_pcmpeq_w(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_pcmpeq_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpeq_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpeq.w.512(<32 x i16> %a, <32 x i16> %b, i32 -1)
  ret i32 %res
}

define i32 @test_mask_pcmpeq_w(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_pcmpeq_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpeq_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpeq.w.512(<32 x i16> %a, <32 x i16> %b, i32 %mask)
  ret i32 %res
}

declare i32 @llvm.x86.avx512.mask.pcmpeq.w.512(<32 x i16>, <32 x i16>, i32)

define i64 @test_pcmpgt_b(<64 x i8> %a, <64 x i8> %b) {
; AVX512BW-LABEL: test_pcmpgt_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpgt_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Lcfi2:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpgt.b.512(<64 x i8> %a, <64 x i8> %b, i64 -1)
  ret i64 %res
}

define i64 @test_mask_pcmpgt_b(<64 x i8> %a, <64 x i8> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_pcmpgt_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpgt_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Lcfi3:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpgt.b.512(<64 x i8> %a, <64 x i8> %b, i64 %mask)
  ret i64 %res
}

declare i64 @llvm.x86.avx512.mask.pcmpgt.b.512(<64 x i8>, <64 x i8>, i64)

define i32 @test_pcmpgt_w(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_pcmpgt_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpgt_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpgt.w.512(<32 x i16> %a, <32 x i16> %b, i32 -1)
  ret i32 %res
}

define i32 @test_mask_pcmpgt_w(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_pcmpgt_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpgt_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpgt.w.512(<32 x i16> %a, <32 x i16> %b, i32 %mask)
  ret i32 %res
}

declare i32 @llvm.x86.avx512.mask.pcmpgt.w.512(<32 x i16>, <32 x i16>, i32)

declare <64 x i8> @llvm.x86.avx512.mask.punpckhb.w.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_punpckhb_w_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpckhb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 {%k1} = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpckhb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpunpckhbw {{.*#+}} zmm2 {%k1} = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.punpckhb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.punpckhb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.punpcklb.w.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_punpcklb_w_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpcklb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm3 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm2 {%k1} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpcklb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpunpcklbw {{.*#+}} zmm3 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpunpcklbw {{.*#+}} zmm2 {%k1} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.punpcklb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.punpcklb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.punpckhw.d.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_punpckhw_d_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpckhw_d_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpunpckhwd {{.*#+}} zmm3 = zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31]
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpunpckhwd {{.*#+}} zmm2 {%k1} = zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31]
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpckhw_d_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpunpckhwd {{.*#+}} zmm3 = zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31]
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpunpckhwd {{.*#+}} zmm2 {%k1} = zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31]
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.punpckhw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.punpckhw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.punpcklw.d.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_punpcklw_d_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpcklw_d_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} zmm3 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27]
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} zmm2 {%k1} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27]
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpcklw_d_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpunpcklwd {{.*#+}} zmm3 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27]
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpunpcklwd {{.*#+}} zmm2 {%k1} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27]
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.punpcklw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.punpcklw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pmaxs.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pmaxs_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxs_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxs_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pmaxs.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pmaxs.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmaxs.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmaxs_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxs_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxs_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmaxs.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmaxs.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pmaxu.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pmaxu_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxu_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmaxub %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpmaxub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxu_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmaxub %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaxub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pmaxu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pmaxu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmaxu.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmaxu_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmaxu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmaxu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pmins.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pmins_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmins_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmins_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpminsb %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpminsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pmins.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pmins.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmins.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmins_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmins_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmins_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpminsw %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpminsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmins.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmins.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pminu.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pminu_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pminu_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpminub %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpminub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pminu_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpminub %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpminub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pminu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pminu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pminu.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pminu_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pminu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpminuw %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpminuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pminu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpminuw %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpminuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pminu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pminu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmovzxb_w_512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovzxb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 {%k1} = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 {%k1} {z} = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmovzxb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmovzxbw {{.*#+}} zmm1 {%k1} = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512F-32-NEXT:    vpmovzxbw {{.*#+}} zmm0 {%k1} {z} = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8> %x0, <32 x i16> zeroinitializer, i32 %x2)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmovsxb_w_512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovsxb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm2
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmovsxb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmovsxbw %ymm0, %zmm2
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmovsxbw %ymm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vpmovsxbw %ymm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8> %x0, <32 x i16> zeroinitializer, i32 %x2)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16>, <8 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psrl_w_512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrl_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psrl_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsrlw %xmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsrlw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm2
; AVX512F-32-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16>, i32, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psrl_wi_512(<32 x i16> %x0, i32 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrl_wi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm2
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psrl_wi_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsrlw $3, %zmm0, %zmm2
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsrlw $3, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm1, %zmm1
; AVX512F-32-NEXT:    vpsrlw $3, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 -1)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16> %x0, i32 3, <32 x i16> zeroinitializer, i32 %x3)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16>, <8 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psra_w_512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psra_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psra_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsraw %xmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsraw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpsraw %xmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16>, i32, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psra_wi_512(<32 x i16> %x0, i32 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psra_wi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm2
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psra_wi_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsraw $3, %zmm0, %zmm2
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsraw $3, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vpsraw $3, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16> %x0, i32 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16>, <8 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psll_w_512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psll_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psll_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsllw %xmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsllw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpsllw %xmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16>, i32, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psll_wi_512(<32 x i16> %x0, i32 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psll_wi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsllw $3, %zmm0, %zmm2
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsllw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsllw $3, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psll_wi_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsllw $3, %zmm0, %zmm2
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsllw $3, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vpsllw $3, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16> %x0, i32 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16> %x0, i32 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <64 x i8> @llvm.x86.avx512.mask.pshuf.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pshuf_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pshuf_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpshufb %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpshufb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pshuf_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpshufb %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpshufb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pshuf.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pshuf.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}


declare <64 x i8> @llvm.x86.avx512.cvtmask2b.512(i64)

define <64 x i8>@test_int_x86_avx512_cvtmask2b_512(i64 %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_cvtmask2b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_cvtmask2b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.cvtmask2b.512(i64 %x0)
  ret <64 x i8> %res
}

declare <32 x i16> @llvm.x86.avx512.cvtmask2w.512(i32)

define <32 x i16>@test_int_x86_avx512_cvtmask2w_512(i32 %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_cvtmask2w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k0
; AVX512BW-NEXT:    vpmovm2w %k0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_cvtmask2w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    vpmovm2w %k0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.cvtmask2w.512(i32 %x0)
  ret <32 x i16> %res
}
define <32 x i16> @test_mask_packs_epi32_rr_512(<16 x i32> %a, <16 x i32> %b) {
; AVX512BW-LABEL: test_mask_packs_epi32_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rrk_512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackssdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rrkz_512(<16 x i32> %a, <16 x i32> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rm_512(<16 x i32> %a, <16 x i32>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packs_epi32_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackssdw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackssdw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmk_512(<16 x i32> %a, <16 x i32>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmkz_512(<16 x i32> %a, <16 x i32>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmb_512(<16 x i32> %a, i32* %ptr_b) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackssdw (%rdi){1to16}, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackssdw (%eax){1to16}, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmbk_512(<16 x i32> %a, i32* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmbk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi){1to16}, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmbk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax){1to16}, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmbkz_512(<16 x i32> %a, i32* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmbkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmbkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32>, <16 x i32>, <32 x i16>, i32)

define <64 x i8> @test_mask_packs_epi16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_packs_epi16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rrk_512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpacksswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpacksswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packs_epi16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpacksswb (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpacksswb (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpacksswb (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpacksswb (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpacksswb (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpacksswb (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

declare <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16>, <32 x i16>, <64 x i8>, i64)


define <32 x i16> @test_mask_packus_epi32_rr_512(<16 x i32> %a, <16 x i32> %b) {
; AVX512BW-LABEL: test_mask_packus_epi32_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rrk_512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackusdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rrkz_512(<16 x i32> %a, <16 x i32> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rm_512(<16 x i32> %a, <16 x i32>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packus_epi32_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackusdw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackusdw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmk_512(<16 x i32> %a, <16 x i32>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmkz_512(<16 x i32> %a, <16 x i32>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmb_512(<16 x i32> %a, i32* %ptr_b) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackusdw (%rdi){1to16}, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackusdw (%eax){1to16}, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmbk_512(<16 x i32> %a, i32* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmbk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi){1to16}, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmbk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax){1to16}, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmbkz_512(<16 x i32> %a, i32* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmbkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmbkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32>, <16 x i32>, <32 x i16>, i32)

define <64 x i8> @test_mask_packus_epi16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_packus_epi16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rrk_512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackuswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packus_epi16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackuswb (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackuswb (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpackuswb (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackuswb (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpackuswb (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovq {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackuswb (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

declare <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16>, <32 x i16>, <64 x i8>, i64)

define i64 @test_cmp_b_512(<64 x i8> %a0, <64 x i8> %a1) {
; AVX512BW-LABEL: test_cmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpgtb %zmm0, %zmm1, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleb %zmm0, %zmm1, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    kxnorq %k0, %k0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_cmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $60, %esp
; AVX512F-32-NEXT:  .Lcfi4:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 64
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpgtb %zmm0, %zmm1, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleb %zmm0, %zmm1, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    addl (%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kxnorq %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $60, %esp
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 -1)
  %res1 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 -1)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 -1)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 -1)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 -1)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 -1)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 -1)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 -1)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

define i64 @test_mask_cmp_b_512(<64 x i8> %a0, <64 x i8> %a1, i64 %mask) {
; AVX512BW-LABEL: test_mask_cmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpgtb %zmm0, %zmm1, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    kxorq %k0, %k0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    orq %rax, %rcx
; AVX512BW-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpleb %zmm0, %zmm1, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    addq %rdi, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_cmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    pushl %ebx
; AVX512F-32-NEXT:  .Lcfi5:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512F-32-NEXT:    pushl %esi
; AVX512F-32-NEXT:  .Lcfi6:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 12
; AVX512F-32-NEXT:    subl $60, %esp
; AVX512F-32-NEXT:  .Lcfi7:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 72
; AVX512F-32-NEXT:  .Lcfi8:
; AVX512F-32-NEXT:    .cfi_offset %esi, -12
; AVX512F-32-NEXT:  .Lcfi9:
; AVX512F-32-NEXT:    .cfi_offset %ebx, -8
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512F-32-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $5, %al
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    movb %cl, %bl
; AVX512F-32-NEXT:    andb $15, %bl
; AVX512F-32-NEXT:    movb %cl, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k0
; AVX512F-32-NEXT:    movb %bl, %dl
; AVX512F-32-NEXT:    shrb $2, %bl
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    movb %cl, %bl
; AVX512F-32-NEXT:    shrb $4, %bl
; AVX512F-32-NEXT:    shrb $3, %dl
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX512F-32-NEXT:    kmovd %ecx, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm3
; AVX512F-32-NEXT:    vpbroadcastw %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    kmovd %edx, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpslld $24, %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    kmovd %ebx, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpbroadcastd %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpsllq $40, %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $6, %al
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $7, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllq $56, %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %ch, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    andb $2, %al
; AVX512F-32-NEXT:    shrb %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %ch, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $61440, %eax # imm = 0xF000
; AVX512F-32-NEXT:    shrl $12, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $13, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $49152, %eax # imm = 0xC000
; AVX512F-32-NEXT:    shrl $14, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $32768, %eax # imm = 0x8000
; AVX512F-32-NEXT:    shrl $15, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $16, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %bl
; AVX512F-32-NEXT:    andb $15, %bl
; AVX512F-32-NEXT:    movb %bl, %dl
; AVX512F-32-NEXT:    shrb $2, %bl
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    shrb $3, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslld $24, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $4, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $5, %dl
; AVX512F-32-NEXT:    andb $1, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllq $40, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $6, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    # kill: %AL<def> %AL<kill> %EAX<kill> %EAX<def>
; AVX512F-32-NEXT:    shrb $7, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllq $56, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $24, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastq %xmm2, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm3, %ymm4, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm4[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $28, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm4, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm4[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    movl %ecx, %esi
; AVX512F-32-NEXT:    shrl $29, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm1, %ymm0, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm2[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %esi, %eax
; AVX512F-32-NEXT:    shrl $30, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255]
; AVX512F-32-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm1
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %esi, %eax
; AVX512F-32-NEXT:    shrl $31, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm1[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    kmovd %ecx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm7
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm4, %ymm1, %ymm7, %ymm1
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    andb $2, %al
; AVX512F-32-NEXT:    shrb %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllw $8, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslld $24, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $4, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $5, %al
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $40, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $6, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $7, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $56, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %ch, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastq %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    andb $2, %al
; AVX512F-32-NEXT:    shrb %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %ch, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $61440, %eax # imm = 0xF000
; AVX512F-32-NEXT:    shrl $12, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $13, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $49152, %eax # imm = 0xC000
; AVX512F-32-NEXT:    shrl $14, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $32768, %eax # imm = 0x8000
; AVX512F-32-NEXT:    shrl $15, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %ebx
; AVX512F-32-NEXT:    shrl $16, %ebx
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllw $8, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    andb $15, %al
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $2, %al
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    shrb $3, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslld $24, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    shrb $4, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    shrb $5, %al
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $40, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    shrb $6, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    # kill: %BL<def> %BL<kill> %EBX<kill> %EBX<def>
; AVX512F-32-NEXT:    shrb $7, %bl
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $56, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $24, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastq %xmm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-32-NEXT:    vpblendvb %ymm3, %ymm4, %ymm1, %ymm1
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $29, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $28, %eax
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm3
; AVX512F-32-NEXT:    vpbroadcastd %xmm3, %xmm3
; AVX512F-32-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1,2]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $30, %eax
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpbroadcastw %xmm3, %xmm3
; AVX512F-32-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-32-NEXT:    vpblendvb %ymm2, %ymm1, %ymm3, %ymm1
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $31, %eax
; AVX512F-32-NEXT:    kshiftlq $1, %k0, %k0
; AVX512F-32-NEXT:    kshiftrq $1, %k0, %k0
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    kshiftlq $63, %k1, %k1
; AVX512F-32-NEXT:    korq %k1, %k0, %k1
; AVX512F-32-NEXT:    vpcmpeqb %zmm6, %zmm5, %k0 {%k1}
; AVX512F-32-NEXT:    vpcmpgtb %zmm5, %zmm6, %k2 {%k1}
; AVX512F-32-NEXT:    vpcmpleb %zmm6, %zmm5, %k3 {%k1}
; AVX512F-32-NEXT:    vpcmpneqb %zmm6, %zmm5, %k4 {%k1}
; AVX512F-32-NEXT:    vpcmpleb %zmm5, %zmm6, %k5 {%k1}
; AVX512F-32-NEXT:    vpcmpgtb %zmm6, %zmm5, %k1 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k2, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k3, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kxorq %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    orl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovq %k4, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k5, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k1, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl %esi, %eax
; AVX512F-32-NEXT:    adcxl %ecx, %edx
; AVX512F-32-NEXT:    addl $60, %esp
; AVX512F-32-NEXT:    popl %esi
; AVX512F-32-NEXT:    popl %ebx
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 %mask)
  %res1 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 %mask)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 %mask)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 %mask)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 %mask)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 %mask)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 %mask)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 %mask)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

declare i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8>, <64 x i8>, i32, i64) nounwind readnone

define i64 @test_ucmp_b_512(<64 x i8> %a0, <64 x i8> %a1) {
; AVX512BW-LABEL: test_ucmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpltub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    kxnorq %k0, %k0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_ucmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $60, %esp
; AVX512F-32-NEXT:  .Lcfi10:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 64
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpltub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    addl (%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kxnorq %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $60, %esp
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 -1)
  %res1 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 -1)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 -1)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 -1)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 -1)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 -1)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 -1)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 -1)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

define i64 @test_mask_x86_avx512_ucmp_b_512(<64 x i8> %a0, <64 x i8> %a1, i64 %mask) {
; AVX512BW-LABEL: test_mask_x86_avx512_ucmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpltub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    kxorq %k0, %k0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    orq %rax, %rcx
; AVX512BW-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    addq %rdi, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_x86_avx512_ucmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    pushl %ebx
; AVX512F-32-NEXT:  .Lcfi11:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512F-32-NEXT:    pushl %esi
; AVX512F-32-NEXT:  .Lcfi12:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 12
; AVX512F-32-NEXT:    subl $60, %esp
; AVX512F-32-NEXT:  .Lcfi13:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 72
; AVX512F-32-NEXT:  .Lcfi14:
; AVX512F-32-NEXT:    .cfi_offset %esi, -12
; AVX512F-32-NEXT:  .Lcfi15:
; AVX512F-32-NEXT:    .cfi_offset %ebx, -8
; AVX512F-32-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512F-32-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $5, %al
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    movb %cl, %bl
; AVX512F-32-NEXT:    andb $15, %bl
; AVX512F-32-NEXT:    movb %cl, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k0
; AVX512F-32-NEXT:    movb %bl, %dl
; AVX512F-32-NEXT:    shrb $2, %bl
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    movb %cl, %bl
; AVX512F-32-NEXT:    shrb $4, %bl
; AVX512F-32-NEXT:    shrb $3, %dl
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX512F-32-NEXT:    kmovd %ecx, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm3
; AVX512F-32-NEXT:    vpbroadcastw %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    kmovd %edx, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpslld $24, %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    kmovd %ebx, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpbroadcastd %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm2
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpsllq $40, %xmm3, %xmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm3
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $6, %al
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $7, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllq $56, %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %ch, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    andb $2, %al
; AVX512F-32-NEXT:    shrb %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %ch, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $61440, %eax # imm = 0xF000
; AVX512F-32-NEXT:    shrl $12, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $13, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $49152, %eax # imm = 0xC000
; AVX512F-32-NEXT:    shrl $14, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $32768, %eax # imm = 0x8000
; AVX512F-32-NEXT:    shrl $15, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $16, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %bl
; AVX512F-32-NEXT:    andb $15, %bl
; AVX512F-32-NEXT:    movb %bl, %dl
; AVX512F-32-NEXT:    shrb $2, %bl
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    shrb $3, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslld $24, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $4, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $5, %dl
; AVX512F-32-NEXT:    andb $1, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllq $40, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $6, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    # kill: %AL<def> %AL<kill> %EAX<kill> %EAX<def>
; AVX512F-32-NEXT:    shrb $7, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpsllq $56, %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $24, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastq %xmm2, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm3[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm3, %ymm4, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm4[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $28, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm0, %ymm4, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm4[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm2, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    movl %ecx, %esi
; AVX512F-32-NEXT:    shrl $29, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm2
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm1, %ymm0, %ymm2, %ymm2
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm2[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %esi, %eax
; AVX512F-32-NEXT:    shrl $30, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255]
; AVX512F-32-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm1
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %esi, %eax
; AVX512F-32-NEXT:    shrl $31, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm1[4,5,6,7]
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    kmovd %ecx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm7
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm4, %ymm1, %ymm7, %ymm1
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    andb $2, %al
; AVX512F-32-NEXT:    shrb %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllw $8, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslld $24, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $4, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $5, %al
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $40, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $6, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %cl, %al
; AVX512F-32-NEXT:    shrb $7, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $56, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %ch, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastq %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    andb $2, %al
; AVX512F-32-NEXT:    shrb %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %ch, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $61440, %eax # imm = 0xF000
; AVX512F-32-NEXT:    shrl $12, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $13, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $49152, %eax # imm = 0xC000
; AVX512F-32-NEXT:    shrl $14, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    andl $32768, %eax # imm = 0x8000
; AVX512F-32-NEXT:    shrl $15, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0]
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %ebx
; AVX512F-32-NEXT:    shrl $16, %ebx
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllw $8, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    andb $15, %al
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    shrb $2, %al
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    shrb $3, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslld $24, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    shrb $4, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    shrb $5, %al
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $40, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %bl, %al
; AVX512F-32-NEXT:    shrb $6, %al
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    # kill: %BL<def> %BL<kill> %EBX<kill> %EBX<def>
; AVX512F-32-NEXT:    shrb $7, %bl
; AVX512F-32-NEXT:    kmovd %ebx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpsllq $56, %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $24, %eax
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpbroadcastq %xmm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $2, %dl
; AVX512F-32-NEXT:    shrb %dl
; AVX512F-32-NEXT:    kmovd %edx, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    movb %al, %dl
; AVX512F-32-NEXT:    andb $15, %dl
; AVX512F-32-NEXT:    movb %dl, %al
; AVX512F-32-NEXT:    shrb $2, %dl
; AVX512F-32-NEXT:    kmovd %edx, %k0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm7, %ymm4, %ymm0, %ymm0
; AVX512F-32-NEXT:    shrb $3, %al
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm1
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-32-NEXT:    vpblendvb %ymm3, %ymm4, %ymm1, %ymm1
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $29, %eax
; AVX512F-32-NEXT:    andb $1, %al
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $28, %eax
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm3
; AVX512F-32-NEXT:    vpbroadcastd %xmm3, %xmm3
; AVX512F-32-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k1
; AVX512F-32-NEXT:    vpmovm2b %k1, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1,2]
; AVX512F-32-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-32-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255]
; AVX512F-32-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $30, %eax
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-32-NEXT:    kmovd %eax, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm3
; AVX512F-32-NEXT:    vpbroadcastw %xmm3, %xmm3
; AVX512F-32-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-32-NEXT:    vpblendvb %ymm2, %ymm1, %ymm3, %ymm1
; AVX512F-32-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    movl %ecx, %eax
; AVX512F-32-NEXT:    shrl $31, %eax
; AVX512F-32-NEXT:    kshiftlq $1, %k0, %k0
; AVX512F-32-NEXT:    kshiftrq $1, %k0, %k0
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    kshiftlq $63, %k1, %k1
; AVX512F-32-NEXT:    korq %k1, %k0, %k1
; AVX512F-32-NEXT:    vpcmpeqb %zmm6, %zmm5, %k0 {%k1}
; AVX512F-32-NEXT:    vpcmpltub %zmm6, %zmm5, %k2 {%k1}
; AVX512F-32-NEXT:    vpcmpleub %zmm6, %zmm5, %k3 {%k1}
; AVX512F-32-NEXT:    vpcmpneqb %zmm6, %zmm5, %k4 {%k1}
; AVX512F-32-NEXT:    vpcmpnltub %zmm6, %zmm5, %k5 {%k1}
; AVX512F-32-NEXT:    vpcmpnleub %zmm6, %zmm5, %k1 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k2, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k3, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kxorq %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    orl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovq %k4, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k5, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    kmovq %k1, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcxl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl %esi, %eax
; AVX512F-32-NEXT:    adcxl %ecx, %edx
; AVX512F-32-NEXT:    addl $60, %esp
; AVX512F-32-NEXT:    popl %esi
; AVX512F-32-NEXT:    popl %ebx
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 %mask)
  %res1 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 %mask)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 %mask)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 %mask)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 %mask)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 %mask)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 %mask)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 %mask)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

declare i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8>, <64 x i8>, i32, i64) nounwind readnone

define i32 @test_cmp_w_512(<32 x i16> %a0, <32 x i16> %a1) {
; AVX512BW-LABEL: test_cmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpgtw %zmm0, %zmm1, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmplew %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmplew %zmm0, %zmm1, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    kxnord %k0, %k0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_cmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpgtw %zmm0, %zmm1, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmplew %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmplew %zmm0, %zmm1, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    kxnord %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 -1)
  %res1 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 -1)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 -1)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 -1)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 -1)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 -1)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 -1)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 -1)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

define i32 @test_mask_cmp_w_512(<32 x i16> %a0, <32 x i16> %a1, i32 %mask) {
; AVX512BW-LABEL: test_mask_cmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpgtw %zmm0, %zmm1, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmplew %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    kxord %k0, %k0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    orl %eax, %ecx
; AVX512BW-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmplew %zmm0, %zmm1, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    addl %edi, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_cmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    kmovd %ecx, %k1
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpgtw %zmm0, %zmm1, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %eax, %edx
; AVX512F-32-NEXT:    vpcmplew %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    kxord %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    orl %eax, %edx
; AVX512F-32-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    vpcmplew %zmm0, %zmm1, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %eax, %edx
; AVX512F-32-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 %mask)
  %res1 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 %mask)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 %mask)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 %mask)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 %mask)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 %mask)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 %mask)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 %mask)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

declare i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16>, <32 x i16>, i32, i32) nounwind readnone

define i32 @test_ucmp_w_512(<32 x i16> %a0, <32 x i16> %a1) {
; AVX512BW-LABEL: test_ucmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    kxnord %k0, %k0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_ucmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    kxnord %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 -1)
  %res1 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 -1)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 -1)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 -1)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 -1)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 -1)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 -1)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 -1)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

define i32 @test_mask_ucmp_w_512(<32 x i16> %a0, <32 x i16> %a1, i32 %mask) {
; AVX512BW-LABEL: test_mask_ucmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    kxord %k0, %k0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    orl %eax, %ecx
; AVX512BW-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    addl %edi, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_ucmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    kmovd %ecx, %k1
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %eax, %edx
; AVX512F-32-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    kxord %k0, %k0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    orl %eax, %edx
; AVX512F-32-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %eax, %edx
; AVX512F-32-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 %mask)
  %res1 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 %mask)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 %mask)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 %mask)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 %mask)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 %mask)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 %mask)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 %mask)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

declare i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16>, <32 x i16>, i32, i32) nounwind readnone
