; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X64

define <8 x i32> @select00(i32 %a, <8 x i32> %b) nounwind {
; X86-LABEL: select00:
; X86:       # BB#0:
; X86-NEXT:    cmpl $255, {{[0-9]+}}(%esp)
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    je .LBB0_2
; X86-NEXT:  # BB#1:
; X86-NEXT:    vmovaps %ymm0, %ymm1
; X86-NEXT:  .LBB0_2:
; X86-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: select00:
; X64:       # BB#0:
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    cmpl $255, %edi
; X64-NEXT:    je .LBB0_2
; X64-NEXT:  # BB#1:
; X64-NEXT:    vmovaps %ymm0, %ymm1
; X64-NEXT:  .LBB0_2:
; X64-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %cmpres = icmp eq i32 %a, 255
  %selres = select i1 %cmpres, <8 x i32> zeroinitializer, <8 x i32> %b
  %res = xor <8 x i32> %b, %selres
  ret <8 x i32> %res
}

define <4 x i64> @select01(i32 %a, <4 x i64> %b) nounwind {
; X86-LABEL: select01:
; X86:       # BB#0:
; X86-NEXT:    cmpl $255, {{[0-9]+}}(%esp)
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    je .LBB1_2
; X86-NEXT:  # BB#1:
; X86-NEXT:    vmovaps %ymm0, %ymm1
; X86-NEXT:  .LBB1_2:
; X86-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: select01:
; X64:       # BB#0:
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    cmpl $255, %edi
; X64-NEXT:    je .LBB1_2
; X64-NEXT:  # BB#1:
; X64-NEXT:    vmovaps %ymm0, %ymm1
; X64-NEXT:  .LBB1_2:
; X64-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %cmpres = icmp eq i32 %a, 255
  %selres = select i1 %cmpres, <4 x i64> zeroinitializer, <4 x i64> %b
  %res = xor <4 x i64> %b, %selres
  ret <4 x i64> %res
}

