; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mattr=+sse3 | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=atom | FileCheck %s --check-prefix=CHECK --check-prefix=ATOM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm | FileCheck %s --check-prefix=CHECK --check-prefix=SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2

define <2 x double> @test_addsubpd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_addsubpd:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    addsubpd %xmm1, %xmm0
; GENERIC-NEXT:    addsubpd (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_addsubpd:
; ATOM:       # BB#0:
; ATOM-NEXT:    addsubpd %xmm1, %xmm0
; ATOM-NEXT:    addsubpd (%rdi), %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_addsubpd:
; SLM:       # BB#0:
; SLM-NEXT:    addsubpd %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addsubpd (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_addsubpd:
; SANDY:       # BB#0:
; SANDY-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddsubpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_addsubpd:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddsubpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_addsubpd:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddsubpd (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double> %a0, <2 x double> %a1)
  %2 = load <2 x double>, <2 x double> *%a2, align 16
  %3 = call <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double> %1, <2 x double> %2)
  ret <2 x double> %3
}
declare <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_addsubps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_addsubps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    addsubps %xmm1, %xmm0
; GENERIC-NEXT:    addsubps (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_addsubps:
; ATOM:       # BB#0:
; ATOM-NEXT:    addsubps %xmm1, %xmm0
; ATOM-NEXT:    addsubps (%rdi), %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_addsubps:
; SLM:       # BB#0:
; SLM-NEXT:    addsubps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addsubps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_addsubps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddsubps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_addsubps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddsubps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_addsubps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddsubps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float>, <4 x float>) nounwind readnone

define <2 x double> @test_haddpd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_haddpd:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    haddpd %xmm1, %xmm0
; GENERIC-NEXT:    haddpd (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_haddpd:
; ATOM:       # BB#0:
; ATOM-NEXT:    haddpd %xmm1, %xmm0
; ATOM-NEXT:    haddpd (%rdi), %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_haddpd:
; SLM:       # BB#0:
; SLM-NEXT:    haddpd %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    haddpd (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_haddpd:
; SANDY:       # BB#0:
; SANDY-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vhaddpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_haddpd:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhaddpd (%rdi), %xmm0, %xmm0 # sched: [9:2.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_haddpd:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vhaddpd (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double> %a0, <2 x double> %a1)
  %2 = load <2 x double>, <2 x double> *%a2, align 16
  %3 = call <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double> %1, <2 x double> %2)
  ret <2 x double> %3
}
declare <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_haddps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_haddps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    haddps %xmm1, %xmm0
; GENERIC-NEXT:    haddps (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_haddps:
; ATOM:       # BB#0:
; ATOM-NEXT:    haddps %xmm1, %xmm0
; ATOM-NEXT:    haddps (%rdi), %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_haddps:
; SLM:       # BB#0:
; SLM-NEXT:    haddps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    haddps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_haddps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vhaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vhaddps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_haddps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vhaddps %xmm1, %xmm0, %xmm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhaddps (%rdi), %xmm0, %xmm0 # sched: [9:2.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_haddps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vhaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vhaddps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float>, <4 x float>) nounwind readnone

define <2 x double> @test_hsubpd(<2 x double> %a0, <2 x double> %a1, <2 x double> *%a2) {
; GENERIC-LABEL: test_hsubpd:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    hsubpd %xmm1, %xmm0
; GENERIC-NEXT:    hsubpd (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_hsubpd:
; ATOM:       # BB#0:
; ATOM-NEXT:    hsubpd %xmm1, %xmm0
; ATOM-NEXT:    hsubpd (%rdi), %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_hsubpd:
; SLM:       # BB#0:
; SLM-NEXT:    hsubpd %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    hsubpd (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_hsubpd:
; SANDY:       # BB#0:
; SANDY-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vhsubpd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_hsubpd:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhsubpd (%rdi), %xmm0, %xmm0 # sched: [9:2.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_hsubpd:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vhsubpd (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double> %a0, <2 x double> %a1)
  %2 = load <2 x double>, <2 x double> *%a2, align 16
  %3 = call <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double> %1, <2 x double> %2)
  ret <2 x double> %3
}
declare <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_hsubps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_hsubps:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    hsubps %xmm1, %xmm0
; GENERIC-NEXT:    hsubps (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_hsubps:
; ATOM:       # BB#0:
; ATOM-NEXT:    hsubps %xmm1, %xmm0
; ATOM-NEXT:    hsubps (%rdi), %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_hsubps:
; SLM:       # BB#0:
; SLM-NEXT:    hsubps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    hsubps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_hsubps:
; SANDY:       # BB#0:
; SANDY-NEXT:    vhsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vhsubps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_hsubps:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vhsubps %xmm1, %xmm0, %xmm0 # sched: [5:2.00]
; HASWELL-NEXT:    vhsubps (%rdi), %xmm0, %xmm0 # sched: [9:2.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_hsubps:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vhsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vhsubps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float>, <4 x float>) nounwind readnone

define <16 x i8> @test_lddqu(i8* %a0) {
; GENERIC-LABEL: test_lddqu:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    lddqu (%rdi), %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_lddqu:
; ATOM:       # BB#0:
; ATOM-NEXT:    lddqu (%rdi), %xmm0
; ATOM-NEXT:    nop
; ATOM-NEXT:    nop
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_lddqu:
; SLM:       # BB#0:
; SLM-NEXT:    lddqu (%rdi), %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_lddqu:
; SANDY:       # BB#0:
; SANDY-NEXT:    vlddqu (%rdi), %xmm0 # sched: [4:0.50]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_lddqu:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vlddqu (%rdi), %xmm0 # sched: [4:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_lddqu:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vlddqu (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = call <16 x i8> @llvm.x86.sse3.ldu.dq(i8* %a0)
  ret <16 x i8> %1
}
declare <16 x i8> @llvm.x86.sse3.ldu.dq(i8*) nounwind readonly

define <2 x double> @test_movddup(<2 x double> %a0, <2 x double> *%a1) {
; GENERIC-LABEL: test_movddup:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movddup {{.*#+}} xmm1 = xmm0[0,0]
; GENERIC-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0]
; GENERIC-NEXT:    addpd %xmm1, %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_movddup:
; ATOM:       # BB#0:
; ATOM-NEXT:    movddup {{.*#+}} xmm1 = mem[0,0]
; ATOM-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; ATOM-NEXT:    addpd %xmm0, %xmm1
; ATOM-NEXT:    movapd %xmm1, %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_movddup:
; SLM:       # BB#0:
; SLM-NEXT:    movddup {{.*#+}} xmm1 = xmm0[0,0] sched: [1:1.00]
; SLM-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0] sched: [3:1.00]
; SLM-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movddup:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0] sched: [1:1.00]
; SANDY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0] sched: [4:0.50]
; SANDY-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_movddup:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0] sched: [1:1.00]
; HASWELL-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0] sched: [4:0.50]
; HASWELL-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movddup:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0] sched: [5:1.00]
; BTVER2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0] sched: [1:0.50]
; BTVER2-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = shufflevector <2 x double> %a0, <2 x double> undef, <2 x i32> zeroinitializer
  %2 = load <2 x double>, <2 x double> *%a1, align 16
  %3 = shufflevector <2 x double> %2, <2 x double> undef, <2 x i32> zeroinitializer
  %4 = fadd <2 x double> %1, %3
  ret <2 x double> %4
}

define <4 x float> @test_movshdup(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movshdup:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; GENERIC-NEXT:    movshdup {{.*#+}} xmm0 = mem[1,1,3,3]
; GENERIC-NEXT:    addps %xmm1, %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_movshdup:
; ATOM:       # BB#0:
; ATOM-NEXT:    movshdup {{.*#+}} xmm1 = mem[1,1,3,3]
; ATOM-NEXT:    movshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; ATOM-NEXT:    addps %xmm0, %xmm1
; ATOM-NEXT:    movaps %xmm1, %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_movshdup:
; SLM:       # BB#0:
; SLM-NEXT:    movshdup {{.*#+}} xmm1 = xmm0[1,1,3,3] sched: [1:1.00]
; SLM-NEXT:    movshdup {{.*#+}} xmm0 = mem[1,1,3,3] sched: [3:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movshdup:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3] sched: [1:1.00]
; SANDY-NEXT:    vmovshdup {{.*#+}} xmm1 = mem[1,1,3,3] sched: [4:0.50]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_movshdup:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3] sched: [1:1.00]
; HASWELL-NEXT:    vmovshdup {{.*#+}} xmm1 = mem[1,1,3,3] sched: [4:0.50]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movshdup:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovshdup {{.*#+}} xmm1 = mem[1,1,3,3] sched: [5:1.00]
; BTVER2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3] sched: [1:0.50]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = shufflevector <4 x float> %2, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}

define <4 x float> @test_movsldup(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movsldup:
; GENERIC:       # BB#0:
; GENERIC-NEXT:    movsldup {{.*#+}} xmm1 = xmm0[0,0,2,2]
; GENERIC-NEXT:    movsldup {{.*#+}} xmm0 = mem[0,0,2,2]
; GENERIC-NEXT:    addps %xmm1, %xmm0
; GENERIC-NEXT:    retq
;
; ATOM-LABEL: test_movsldup:
; ATOM:       # BB#0:
; ATOM-NEXT:    movsldup {{.*#+}} xmm1 = mem[0,0,2,2]
; ATOM-NEXT:    movsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; ATOM-NEXT:    addps %xmm0, %xmm1
; ATOM-NEXT:    movaps %xmm1, %xmm0
; ATOM-NEXT:    retq
;
; SLM-LABEL: test_movsldup:
; SLM:       # BB#0:
; SLM-NEXT:    movsldup {{.*#+}} xmm1 = xmm0[0,0,2,2] sched: [1:1.00]
; SLM-NEXT:    movsldup {{.*#+}} xmm0 = mem[0,0,2,2] sched: [3:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movsldup:
; SANDY:       # BB#0:
; SANDY-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2] sched: [1:1.00]
; SANDY-NEXT:    vmovsldup {{.*#+}} xmm1 = mem[0,0,2,2] sched: [4:0.50]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [5:1.00]
;
; HASWELL-LABEL: test_movsldup:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2] sched: [1:1.00]
; HASWELL-NEXT:    vmovsldup {{.*#+}} xmm1 = mem[0,0,2,2] sched: [4:0.50]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; BTVER2-LABEL: test_movsldup:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovsldup {{.*#+}} xmm1 = mem[0,0,2,2] sched: [5:1.00]
; BTVER2-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2] sched: [1:0.50]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
  %1 = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = shufflevector <4 x float> %2, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
