// RUN: rm -f %t
// RUN: %clang_analyze_cc1 -fblocks -analyzer-checker=core,unix.Malloc -analyzer-output=plist -analyzer-config path-diagnostics-alternate=false -o %t %s
// RUN: FileCheck -input-file %t %s

typedef __typeof(sizeof(int)) size_t;
void *malloc(size_t);
void free(void *);
void *realloc(void *ptr, size_t size);

void diagnosticTest(int in) {
    if (in > 5) {
        int *p = malloc(12);
        (*p)++;
    }
    in++; // expected-warning {{leak}}
}

void myArrayAllocation() {
    int **A;
    A = malloc(2*sizeof(int*));
    A[0] = 0;// expected-warning {{leak}}
}

void reallocDiagnostics() {
    char * buf = malloc(100);
    char * tmp;
    tmp = (char*)realloc(buf, 0x1000000);
    if (!tmp) {
        return;// expected-warning {{leak}}
    }
    buf = tmp;
    free(buf);
}

void *wrapper() {
  void *x = malloc(100);
  // This is intentionally done to test diagnostic emission.
  if (x)
    return x;
  return 0;
}

void test_wrapper() {
  void *buf = wrapper();
  (void) buf;
}

// Test what happens when the same call frees and allocated memory.
// Also tests the stack hint for parameters, when they are passed directly or via pointer.
void my_free(void *x) {
    free(x);
}
void my_malloc_and_free(void **x) {
    *x = malloc(100);
    if (*x)
      my_free(*x);
    return;
}
void *test_double_action_call() {
    void *buf;
    my_malloc_and_free(&buf);
    return buf;
}

// Test stack hint for 'reallocation failed'.
char *my_realloc(char *buf) {
    char *tmp;
    tmp = (char*)realloc(buf, 0x1000000);
    if (!tmp) {
        return tmp;
    }
    return tmp;
}
void reallocIntra() {
    char *buf = (char *)malloc(100);
    buf = my_realloc(buf);
    free(buf);
}

// Test stack hint when returning a result.
static char *malloc_wrapper_ret() {
    return (char*)malloc(12);
}
void use_ret() {
    char *v;
    v = malloc_wrapper_ret();
}

// Passing a block as a parameter to an inlined call for which we generate
// a stack hint message caused crashes.
// rdar://problem/21291971
void myfree_takingblock(void (^ignored)(void), int *p) {
  free(p);
}

void call_myfree_takingblock() {
  void (^some_block)(void) = ^void(void) { };

  int *p = malloc(sizeof(int));
  myfree_takingblock(some_block, p);
  *p = 3;
}

// Test that we refer to the last symbol used in the leak diagnostic.
void LeakedSymbol(int in) {
    int *m = 0;
    int *p;
    p = (int*)malloc(12);
    (*p)++;
    m = p;
    p = 0;
    (*m)++;
    in++;
}

// Tests that exercise running remove dead bindings at Call exit.
static void function_with_leak1() {
    char *x = (char*)malloc(12);
}
void use_function_with_leak1() {
    function_with_leak1();
    int y = 0;
}

static void function_with_leak2() {
    char *x = (char*)malloc(12);
    int m = 0;
}
void use_function_with_leak2() {
    function_with_leak2();
}

static void function_with_leak3(int y) {
    char *x = (char*)malloc(12);
    if (y)
        y++;
}
void use_function_with_leak3(int y) {
    function_with_leak3(y);
}

static void function_with_leak4(int y) {
    char *x = (char*)malloc(12);
    if (y)
        y++;
    else
        y--;
}
void use_function_with_leak4(int y) {
    function_with_leak4(y);
}

int anotherFunction5() {
    return 5;
}
static int function_with_leak5() {
    char *x = (char*)malloc(12);
    return anotherFunction5();
}
void use_function_with_leak5() {
    function_with_leak5();
}

void anotherFunction6(int m) {
    m++;
}
static void function_with_leak6() {
    char *x = (char*)malloc(12);
    anotherFunction6(3);
}
void use_function_with_leak6() {
    function_with_leak6();
}

static void empty_function(){
}
void use_empty_function() {
    empty_function();
}
static char *function_with_leak7() {
    return (char*)malloc(12);
}
void use_function_with_leak7() {
    function_with_leak7();
}

// Test that we do not print the name of a variable not visible from where
// the issue is reported.
int *my_malloc() {
  int *p = malloc(12);
  return p;
}
void testOnlyRefferToVisibleVariables() {
  my_malloc();
} // expected-warning {{Potential leak of memory}}

struct PointerWrapper{
  int*p;
};
int *my_malloc_into_struct() {
  struct PointerWrapper w;
  w.p = malloc(12);
  return w.p;
}
void testMyMalloc() {
  my_malloc_into_struct(); // expected-warning {{Potential leak of memory}}
}

// CHECK:   <key>diagnostics</key>
// CHECK-NEXT:   <array>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>11</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>11</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>11</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>11</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>11</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>11</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>11</integer>
// CHECK-NEXT:           <key>col</key><integer>14</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming &apos;in&apos; is &gt; 5</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming &apos;in&apos; is &gt; 5</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>11</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>11</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>11</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>11</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>23</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>12</integer>
// CHECK-NEXT:        <key>col</key><integer>18</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>12</integer>
// CHECK-NEXT:           <key>col</key><integer>18</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>12</integer>
// CHECK-NEXT:           <key>col</key><integer>27</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>12</integer>
// CHECK-NEXT:             <key>col</key><integer>23</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>15</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>15</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>15</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;p&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;p&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;p&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>c60b35a3e46fd104f362f430a1eaca5d</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>diagnosticTest</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>2</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>15</integer>
// CHECK-NEXT:     <key>col</key><integer>5</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>19</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>19</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>14</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>20</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>20</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>20</integer>
// CHECK-NEXT:           <key>col</key><integer>30</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>20</integer>
// CHECK-NEXT:             <key>col</key><integer>14</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>22</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>22</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>22</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;A&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;A&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;A&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>9b732ec46c4a08108dfbd37aa0955c51</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>myArrayAllocation</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>2</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>22</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>25</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>25</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>25</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>25</integer>
// CHECK-NEXT:             <key>col</key><integer>23</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>25</integer>
// CHECK-NEXT:        <key>col</key><integer>18</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>25</integer>
// CHECK-NEXT:           <key>col</key><integer>18</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>25</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>25</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>25</integer>
// CHECK-NEXT:             <key>col</key><integer>23</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>24</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>27</integer>
// CHECK-NEXT:        <key>col</key><integer>18</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>27</integer>
// CHECK-NEXT:           <key>col</key><integer>18</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>27</integer>
// CHECK-NEXT:           <key>col</key><integer>40</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Attempt to reallocate memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Attempt to reallocate memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>27</integer>
// CHECK-NEXT:             <key>col</key><integer>24</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>28</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>28</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>28</integer>
// CHECK-NEXT:           <key>col</key><integer>12</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming &apos;tmp&apos; is null</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming &apos;tmp&apos; is null</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>28</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>28</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>28</integer>
// CHECK-NEXT:           <key>col</key><integer>6</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Reallocation failed</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Reallocation failed</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>28</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>29</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>29</integer>
// CHECK-NEXT:             <key>col</key><integer>14</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>29</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>37c0b1a1e65d26af6f9fb840cf159149</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>reallocDiagnostics</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>29</integer>
// CHECK-NEXT:     <key>col</key><integer>9</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>44</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>44</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>44</integer>
// CHECK-NEXT:             <key>col</key><integer>15</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>44</integer>
// CHECK-NEXT:             <key>col</key><integer>21</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>44</integer>
// CHECK-NEXT:        <key>col</key><integer>15</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>44</integer>
// CHECK-NEXT:           <key>col</key><integer>15</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>44</integer>
// CHECK-NEXT:           <key>col</key><integer>23</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;wrapper&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;wrapper&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>35</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;test_wrapper&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;test_wrapper&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>35</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>35</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>13</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>36</integer>
// CHECK-NEXT:        <key>col</key><integer>13</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>36</integer>
// CHECK-NEXT:           <key>col</key><integer>13</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>36</integer>
// CHECK-NEXT:           <key>col</key><integer>23</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>13</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>36</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>38</integer>
// CHECK-NEXT:        <key>col</key><integer>7</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>38</integer>
// CHECK-NEXT:           <key>col</key><integer>7</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>38</integer>
// CHECK-NEXT:           <key>col</key><integer>7</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming &apos;x&apos; is non-null</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming &apos;x&apos; is non-null</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>38</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>39</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>39</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>44</integer>
// CHECK-NEXT:        <key>col</key><integer>15</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>44</integer>
// CHECK-NEXT:           <key>col</key><integer>15</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>44</integer>
// CHECK-NEXT:           <key>col</key><integer>23</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>44</integer>
// CHECK-NEXT:             <key>col</key><integer>15</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>44</integer>
// CHECK-NEXT:             <key>col</key><integer>21</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>46</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>46</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>46</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>384d1700f3d9c8eeea96d171e3030bdf</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>test_wrapper</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>46</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>60</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>60</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>61</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>61</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>61</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>61</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>61</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;my_malloc_and_free&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;my_malloc_and_free&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>53</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;test_double_action_call&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;test_double_action_call&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>53</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>53</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>15</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>54</integer>
// CHECK-NEXT:        <key>col</key><integer>10</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>54</integer>
// CHECK-NEXT:           <key>col</key><integer>10</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>54</integer>
// CHECK-NEXT:           <key>col</key><integer>20</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>54</integer>
// CHECK-NEXT:             <key>col</key><integer>15</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>55</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>55</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>55</integer>
// CHECK-NEXT:           <key>col</key><integer>10</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming the condition is true</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming the condition is true</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>55</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>56</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>56</integer>
// CHECK-NEXT:             <key>col</key><integer>13</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>56</integer>
// CHECK-NEXT:        <key>col</key><integer>7</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>56</integer>
// CHECK-NEXT:           <key>col</key><integer>7</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>56</integer>
// CHECK-NEXT:           <key>col</key><integer>17</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;my_free&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;my_free&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>50</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>2</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;my_malloc_and_free&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;my_malloc_and_free&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>50</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>50</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>51</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>51</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>51</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>51</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>51</integer>
// CHECK-NEXT:           <key>col</key><integer>11</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>2</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is released</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is released</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>56</integer>
// CHECK-NEXT:        <key>col</key><integer>7</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>56</integer>
// CHECK-NEXT:           <key>col</key><integer>7</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>56</integer>
// CHECK-NEXT:           <key>col</key><integer>17</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returning; memory was released via 1st parameter</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returning; memory was released via 1st parameter</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>56</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>56</integer>
// CHECK-NEXT:             <key>col</key><integer>13</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>57</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>57</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>61</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>61</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>61</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returning; memory was released via 1st parameter</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returning; memory was released via 1st parameter</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>61</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>61</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>62</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>62</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>62</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>62</integer>
// CHECK-NEXT:           <key>col</key><integer>12</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>62</integer>
// CHECK-NEXT:           <key>col</key><integer>14</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Use of memory after it is freed</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Use of memory after it is freed</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Use of memory after it is freed</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Use-after-free</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>422436dc85b85cde7e15046a5616ee99</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>test_double_action_call</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>3</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>62</integer>
// CHECK-NEXT:     <key>col</key><integer>5</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>75</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>75</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>75</integer>
// CHECK-NEXT:             <key>col</key><integer>25</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>75</integer>
// CHECK-NEXT:             <key>col</key><integer>30</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>75</integer>
// CHECK-NEXT:        <key>col</key><integer>25</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>75</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>75</integer>
// CHECK-NEXT:           <key>col</key><integer>35</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>75</integer>
// CHECK-NEXT:             <key>col</key><integer>25</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>75</integer>
// CHECK-NEXT:             <key>col</key><integer>30</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>76</integer>
// CHECK-NEXT:             <key>col</key><integer>11</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>76</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>76</integer>
// CHECK-NEXT:        <key>col</key><integer>11</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>76</integer>
// CHECK-NEXT:           <key>col</key><integer>11</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>76</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;my_realloc&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;my_realloc&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>66</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;reallocIntra&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;reallocIntra&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>66</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>66</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>67</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>67</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>67</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>67</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>24</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>68</integer>
// CHECK-NEXT:        <key>col</key><integer>18</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>68</integer>
// CHECK-NEXT:           <key>col</key><integer>18</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>68</integer>
// CHECK-NEXT:           <key>col</key><integer>40</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Attempt to reallocate memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Attempt to reallocate memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>18</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>68</integer>
// CHECK-NEXT:             <key>col</key><integer>24</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>69</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>69</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>69</integer>
// CHECK-NEXT:           <key>col</key><integer>12</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming &apos;tmp&apos; is null</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming &apos;tmp&apos; is null</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>69</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>69</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>69</integer>
// CHECK-NEXT:           <key>col</key><integer>6</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Reallocation failed</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Reallocation failed</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>69</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>70</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>70</integer>
// CHECK-NEXT:             <key>col</key><integer>14</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>76</integer>
// CHECK-NEXT:        <key>col</key><integer>11</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>76</integer>
// CHECK-NEXT:           <key>col</key><integer>11</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>76</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Reallocation of 1st parameter failed</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Reallocation of 1st parameter failed</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>76</integer>
// CHECK-NEXT:             <key>col</key><integer>11</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>76</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>77</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>77</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>77</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;buf&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>23a6c295a515c455bea1c81519bc05b6</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>reallocIntra</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>77</integer>
// CHECK-NEXT:     <key>col</key><integer>5</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>85</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>85</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>86</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>86</integer>
// CHECK-NEXT:             <key>col</key><integer>26</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>86</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>86</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>86</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;malloc_wrapper_ret&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;malloc_wrapper_ret&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>81</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_ret&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_ret&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>81</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>81</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>82</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>82</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>82</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>82</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>82</integer>
// CHECK-NEXT:             <key>col</key><integer>19</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>82</integer>
// CHECK-NEXT:             <key>col</key><integer>24</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>82</integer>
// CHECK-NEXT:        <key>col</key><integer>19</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>82</integer>
// CHECK-NEXT:           <key>col</key><integer>19</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>82</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>86</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>86</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>86</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>86</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>86</integer>
// CHECK-NEXT:             <key>col</key><integer>26</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>87</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>87</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>87</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;v&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;v&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;v&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>45181c7fc1df81a732346f1ed1b3f238</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>use_ret</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>2</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>87</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>97</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>97</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>12</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>17</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>99</integer>
// CHECK-NEXT:        <key>col</key><integer>12</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>99</integer>
// CHECK-NEXT:           <key>col</key><integer>12</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>99</integer>
// CHECK-NEXT:           <key>col</key><integer>30</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>12</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>99</integer>
// CHECK-NEXT:             <key>col</key><integer>17</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>100</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>100</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>100</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>100</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>100</integer>
// CHECK-NEXT:           <key>col</key><integer>35</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;myfree_takingblock&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;myfree_takingblock&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>92</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;call_myfree_takingblock&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;call_myfree_takingblock&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>92</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>92</integer>
// CHECK-NEXT:             <key>col</key><integer>4</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>93</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>93</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>93</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>93</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>93</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is released</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is released</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>100</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>100</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>100</integer>
// CHECK-NEXT:           <key>col</key><integer>35</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returning; memory was released via 2nd parameter</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returning; memory was released via 2nd parameter</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>100</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>100</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>101</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>101</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>101</integer>
// CHECK-NEXT:        <key>col</key><integer>6</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>101</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>101</integer>
// CHECK-NEXT:           <key>col</key><integer>4</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Use of memory after it is freed</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Use of memory after it is freed</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Use of memory after it is freed</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Use-after-free</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>652c97005df876a65d64ecd286d6030a</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>call_myfree_takingblock</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>5</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>101</integer>
// CHECK-NEXT:     <key>col</key><integer>6</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>106</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>106</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>15</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>108</integer>
// CHECK-NEXT:        <key>col</key><integer>15</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>108</integer>
// CHECK-NEXT:           <key>col</key><integer>15</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>108</integer>
// CHECK-NEXT:           <key>col</key><integer>24</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>15</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>108</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>113</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>113</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>113</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;m&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;m&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;m&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>d8483ccf1d5a1af1e8bcaac6905a18b3</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>LeakedSymbol</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>3</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>113</integer>
// CHECK-NEXT:     <key>col</key><integer>5</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>121</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>121</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>121</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak1&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak1&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>117</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak1&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak1&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>117</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>117</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>118</integer>
// CHECK-NEXT:        <key>col</key><integer>22</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>118</integer>
// CHECK-NEXT:           <key>col</key><integer>22</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>118</integer>
// CHECK-NEXT:           <key>col</key><integer>31</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>118</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>119</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>119</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>119</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>b07aebe89e4ba5ea104a9f957df9531b</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>function_with_leak1</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>119</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>130</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>130</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>130</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak2&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak2&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>125</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak2&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak2&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>125</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>125</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>126</integer>
// CHECK-NEXT:        <key>col</key><integer>22</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>126</integer>
// CHECK-NEXT:           <key>col</key><integer>22</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>126</integer>
// CHECK-NEXT:           <key>col</key><integer>31</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>126</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>127</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>127</integer>
// CHECK-NEXT:             <key>col</key><integer>7</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>127</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>efe2ffcb7c227e872aa732c5f793895d</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>function_with_leak2</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>127</integer>
// CHECK-NEXT:     <key>col</key><integer>5</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>139</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>139</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>139</integer>
// CHECK-NEXT:           <key>col</key><integer>26</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak3&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak3&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>133</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak3&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak3&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>133</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>133</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>134</integer>
// CHECK-NEXT:        <key>col</key><integer>22</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>134</integer>
// CHECK-NEXT:           <key>col</key><integer>22</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>134</integer>
// CHECK-NEXT:           <key>col</key><integer>31</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>134</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>135</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>135</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>135</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming &apos;y&apos; is not equal to 0</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming &apos;y&apos; is not equal to 0</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>135</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>136</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>136</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>136</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>0ddc87e8a7e7104428af3905f3057611</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>function_with_leak3</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>136</integer>
// CHECK-NEXT:     <key>col</key><integer>9</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>150</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>150</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>150</integer>
// CHECK-NEXT:           <key>col</key><integer>26</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak4&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak4&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>142</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak4&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak4&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>142</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>142</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>143</integer>
// CHECK-NEXT:        <key>col</key><integer>22</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>143</integer>
// CHECK-NEXT:           <key>col</key><integer>22</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>143</integer>
// CHECK-NEXT:           <key>col</key><integer>31</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>143</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>144</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>144</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>144</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Assuming &apos;y&apos; is 0</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Assuming &apos;y&apos; is 0</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>144</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>147</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>147</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>147</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>948d356840e67fc4baa8cc5d0600463c</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>function_with_leak4</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>147</integer>
// CHECK-NEXT:     <key>col</key><integer>9</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>161</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>161</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>161</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak5&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak5&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>156</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak5&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak5&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>156</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>156</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>157</integer>
// CHECK-NEXT:        <key>col</key><integer>22</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>157</integer>
// CHECK-NEXT:           <key>col</key><integer>22</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>157</integer>
// CHECK-NEXT:           <key>col</key><integer>31</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>157</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>158</integer>
// CHECK-NEXT:             <key>col</key><integer>12</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>158</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>158</integer>
// CHECK-NEXT:        <key>col</key><integer>12</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>2b0361060027060b94915ff4de8aa782</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>function_with_leak5</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>158</integer>
// CHECK-NEXT:     <key>col</key><integer>12</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>172</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>172</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>172</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak6&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak6&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>167</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak6&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak6&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>167</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>167</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>168</integer>
// CHECK-NEXT:        <key>col</key><integer>22</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>168</integer>
// CHECK-NEXT:           <key>col</key><integer>22</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>168</integer>
// CHECK-NEXT:           <key>col</key><integer>31</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>22</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>168</integer>
// CHECK-NEXT:             <key>col</key><integer>27</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>169</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>169</integer>
// CHECK-NEXT:             <key>col</key><integer>20</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>169</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential leak of memory pointed to by &apos;x&apos;</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>73f573faa903ad4308d5155ef979cf31</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>function_with_leak6</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>169</integer>
// CHECK-NEXT:     <key>col</key><integer>5</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>184</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>184</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>184</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak7&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;function_with_leak7&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>180</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak7&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;use_function_with_leak7&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>180</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>180</integer>
// CHECK-NEXT:             <key>col</key><integer>6</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>181</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>181</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>181</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>181</integer>
// CHECK-NEXT:             <key>col</key><integer>10</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>181</integer>
// CHECK-NEXT:             <key>col</key><integer>19</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>181</integer>
// CHECK-NEXT:             <key>col</key><integer>24</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>181</integer>
// CHECK-NEXT:        <key>col</key><integer>19</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>181</integer>
// CHECK-NEXT:           <key>col</key><integer>19</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>181</integer>
// CHECK-NEXT:           <key>col</key><integer>28</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>184</integer>
// CHECK-NEXT:        <key>col</key><integer>5</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>184</integer>
// CHECK-NEXT:           <key>col</key><integer>5</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>184</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>184</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>184</integer>
// CHECK-NEXT:             <key>col</key><integer>23</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>185</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>185</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>185</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential memory leak</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential memory leak</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential memory leak</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>eb5628850b9b9118fbda903e721436a5</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>use_function_with_leak7</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>185</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>194</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>194</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>194</integer>
// CHECK-NEXT:           <key>col</key><integer>13</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;my_malloc&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;my_malloc&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>189</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;testOnlyRefferToVisibleVariables&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;testOnlyRefferToVisibleVariables&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>189</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>189</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>190</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>190</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>190</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>190</integer>
// CHECK-NEXT:             <key>col</key><integer>5</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>190</integer>
// CHECK-NEXT:             <key>col</key><integer>12</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>190</integer>
// CHECK-NEXT:             <key>col</key><integer>17</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>190</integer>
// CHECK-NEXT:        <key>col</key><integer>12</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>190</integer>
// CHECK-NEXT:           <key>col</key><integer>12</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>190</integer>
// CHECK-NEXT:           <key>col</key><integer>21</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>194</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>194</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>194</integer>
// CHECK-NEXT:           <key>col</key><integer>13</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>194</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>194</integer>
// CHECK-NEXT:             <key>col</key><integer>11</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>195</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>195</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>195</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential memory leak</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential memory leak</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential memory leak</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>ad5b603037bc3581ff94947e86dbb1c8</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>testOnlyRefferToVisibleVariables</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>195</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>path</key>
// CHECK-NEXT:     <array>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>206</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>206</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>206</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Calling &apos;my_malloc_into_struct&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Calling &apos;my_malloc_into_struct&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>200</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Entered call from &apos;testMyMalloc&apos;</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Entered call from &apos;testMyMalloc&apos;</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>200</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>200</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>201</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>201</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>201</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>201</integer>
// CHECK-NEXT:             <key>col</key><integer>8</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>202</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>202</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>202</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>202</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>202</integer>
// CHECK-NEXT:             <key>col</key><integer>9</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>202</integer>
// CHECK-NEXT:             <key>col</key><integer>14</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>202</integer>
// CHECK-NEXT:        <key>col</key><integer>9</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>202</integer>
// CHECK-NEXT:           <key>col</key><integer>9</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>202</integer>
// CHECK-NEXT:           <key>col</key><integer>18</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>1</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Memory is allocated</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>206</integer>
// CHECK-NEXT:        <key>col</key><integer>3</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>ranges</key>
// CHECK-NEXT:       <array>
// CHECK-NEXT:         <array>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>206</integer>
// CHECK-NEXT:           <key>col</key><integer>3</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:          <dict>
// CHECK-NEXT:           <key>line</key><integer>206</integer>
// CHECK-NEXT:           <key>col</key><integer>25</integer>
// CHECK-NEXT:           <key>file</key><integer>0</integer>
// CHECK-NEXT:          </dict>
// CHECK-NEXT:         </array>
// CHECK-NEXT:       </array>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Returned allocated memory</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>control</string>
// CHECK-NEXT:       <key>edges</key>
// CHECK-NEXT:        <array>
// CHECK-NEXT:         <dict>
// CHECK-NEXT:          <key>start</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>206</integer>
// CHECK-NEXT:             <key>col</key><integer>3</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>206</integer>
// CHECK-NEXT:             <key>col</key><integer>23</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:          <key>end</key>
// CHECK-NEXT:           <array>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>207</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:            <dict>
// CHECK-NEXT:             <key>line</key><integer>207</integer>
// CHECK-NEXT:             <key>col</key><integer>1</integer>
// CHECK-NEXT:             <key>file</key><integer>0</integer>
// CHECK-NEXT:            </dict>
// CHECK-NEXT:           </array>
// CHECK-NEXT:         </dict>
// CHECK-NEXT:        </array>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:      <dict>
// CHECK-NEXT:       <key>kind</key><string>event</string>
// CHECK-NEXT:       <key>location</key>
// CHECK-NEXT:       <dict>
// CHECK-NEXT:        <key>line</key><integer>207</integer>
// CHECK-NEXT:        <key>col</key><integer>1</integer>
// CHECK-NEXT:        <key>file</key><integer>0</integer>
// CHECK-NEXT:       </dict>
// CHECK-NEXT:       <key>depth</key><integer>0</integer>
// CHECK-NEXT:       <key>extended_message</key>
// CHECK-NEXT:       <string>Potential memory leak</string>
// CHECK-NEXT:       <key>message</key>
// CHECK-NEXT:       <string>Potential memory leak</string>
// CHECK-NEXT:      </dict>
// CHECK-NEXT:     </array>
// CHECK-NEXT:     <key>description</key><string>Potential memory leak</string>
// CHECK-NEXT:     <key>category</key><string>Memory Error</string>
// CHECK-NEXT:     <key>type</key><string>Memory leak</string>
// CHECK-NEXT:     <key>check_name</key><string>unix.Malloc</string>
// CHECK-NEXT:     <!-- This hash is experimental and going to change! -->
// CHECK-NEXT:     <key>issue_hash_content_of_line_in_context</key><string>8d59cc5cc4b7db55d432abc18b0e6c23</string>
// CHECK-NEXT:    <key>issue_context_kind</key><string>function</string>
// CHECK-NEXT:    <key>issue_context</key><string>testMyMalloc</string>
// CHECK-NEXT:    <key>issue_hash_function_offset</key><string>1</string>
// CHECK-NEXT:    <key>location</key>
// CHECK-NEXT:    <dict>
// CHECK-NEXT:     <key>line</key><integer>207</integer>
// CHECK-NEXT:     <key>col</key><integer>1</integer>
// CHECK-NEXT:     <key>file</key><integer>0</integer>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:    </dict>
// CHECK-NEXT:   </array>
// CHECK-NEXT:  </dict>
// CHECK-NEXT:  </plist>
