; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512BWVL

; PR31551
; Pairs of shufflevector:trunc functions with functional equivalence.
; Ideally, the shuffles should be lowered to code with the same quality as the truncates.

define void @shuffle_v64i8_to_v32i8(<64 x i8>* %L, <32 x i8>* %S) nounwind {
; AVX512F-LABEL: shuffle_v64i8_to_v32i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30]
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512F-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v64i8_to_v32i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512VL-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30]
; AVX512VL-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30,u,u,u,u,u,u,u,u]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: shuffle_v64i8_to_v32i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512BW-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: shuffle_v64i8_to_v32i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512BWVL-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30]
; AVX512BWVL-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u,16,18,20,22,24,26,28,30,u,u,u,u,u,u,u,u]
; AVX512BWVL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512BWVL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512BWVL-NEXT:    vmovdqu %ymm0, (%rsi)
; AVX512BWVL-NEXT:    retq
  %vec = load <64 x i8>, <64 x i8>* %L
  %strided.vec = shufflevector <64 x i8> %vec, <64 x i8> undef, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62>
  store <32 x i8> %strided.vec, <32 x i8>* %S
  ret void
}

define void @trunc_v32i16_to_v32i8(<64 x i8>* %L, <32 x i8>* %S) nounwind {
; AVX512F-LABEL: trunc_v32i16_to_v32i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpmovsxwd (%rdi), %zmm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpmovsxwd 32(%rdi), %zmm1
; AVX512F-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v32i16_to_v32i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovsxwd (%rdi), %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vpmovsxwd 32(%rdi), %zmm1
; AVX512VL-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v32i16_to_v32i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_v32i16_to_v32i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, (%rsi)
; AVX512BWVL-NEXT:    retq
  %vec = load <64 x i8>, <64 x i8>* %L
  %bc = bitcast <64 x i8> %vec to <32 x i16>
  %strided.vec = trunc <32 x i16> %bc to <32 x i8>
  store <32 x i8> %strided.vec, <32 x i8>* %S
  ret void
}

define void @shuffle_v32i16_to_v16i16(<32 x i16>* %L, <16 x i16>* %S) nounwind {
; AVX512F-LABEL: shuffle_v32i16_to_v16i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5,4,5,6,7,0,1,4,5,8,9,12,13,16,17,20,21,20,21,22,23,16,17,20,21,24,25,28,29]
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512F-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v32i16_to_v16i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpshuflw {{.*#+}} ymm0 = mem[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm0[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX512VL-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,1,0,2,4,5,4,6]
; AVX512VL-NEXT:    vpshuflw {{.*#+}} ymm1 = mem[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm1[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX512VL-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,2,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: shuffle_v32i16_to_v16i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5,4,5,6,7,0,1,4,5,8,9,12,13,16,17,20,21,20,21,22,23,16,17,20,21,24,25,28,29]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512BW-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: shuffle_v32i16_to_v16i16:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512BWVL-NEXT:    vmovdqu {{.*#+}} ymm2 = [0,2,4,6,16,18,20,22,8,10,12,14,24,26,28,30]
; AVX512BWVL-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512BWVL-NEXT:    vpermq {{.*#+}} ymm0 = ymm2[0,2,1,3]
; AVX512BWVL-NEXT:    vmovdqu %ymm0, (%rsi)
; AVX512BWVL-NEXT:    retq
  %vec = load <32 x i16>, <32 x i16>* %L
  %strided.vec = shufflevector <32 x i16> %vec, <32 x i16> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  store <16 x i16> %strided.vec, <16 x i16>* %S
  ret void
}

define void @trunc_v16i32_to_v16i16(<32 x i16>* %L, <16 x i16>* %S) nounwind {
; AVX512-LABEL: trunc_v16i32_to_v16i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovdqa32 (%rdi), %zmm0
; AVX512-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-NEXT:    retq
  %vec = load <32 x i16>, <32 x i16>* %L
  %bc = bitcast <32 x i16> %vec to <16 x i32>
  %strided.vec = trunc <16 x i32> %bc to <16 x i16>
  store <16 x i16> %strided.vec, <16 x i16>* %S
  ret void
}

define void @shuffle_v16i32_to_v8i32(<16 x i32>* %L, <8 x i32>* %S) nounwind {
; AVX512-LABEL: shuffle_v16i32_to_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovdqa32 (%rdi), %zmm0
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512-NEXT:    retq
  %vec = load <16 x i32>, <16 x i32>* %L
  %strided.vec = shufflevector <16 x i32> %vec, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  store <8 x i32> %strided.vec, <8 x i32>* %S
  ret void
}

define void @trunc_v8i64_to_v8i32(<16 x i32>* %L, <8 x i32>* %S) nounwind {
; AVX512-LABEL: trunc_v8i64_to_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512-NEXT:    retq
  %vec = load <16 x i32>, <16 x i32>* %L
  %bc = bitcast <16 x i32> %vec to <8 x i64>
  %strided.vec = trunc <8 x i64> %bc to <8 x i32>
  store <8 x i32> %strided.vec, <8 x i32>* %S
  ret void
}

define void @shuffle_v64i8_to_v16i8(<64 x i8>* %L, <16 x i8>* %S) nounwind {
; AVX512F-LABEL: shuffle_v64i8_to_v16i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; AVX512F-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512F-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX512F-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v64i8_to_v16i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512VL-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX512VL-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: shuffle_v64i8_to_v16i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm1
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm0
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm1, %xmm0
; AVX512BW-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: shuffle_v64i8_to_v16i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BWVL-NEXT:    vpextrb $0, %xmm0, %ecx
; AVX512BWVL-NEXT:    vmovd %ecx, %xmm1
; AVX512BWVL-NEXT:    vpinsrb $1, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $2, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $3, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BWVL-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $4, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $5, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $6, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $7, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BWVL-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $8, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $9, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $10, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $11, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $3, %zmm0, %xmm0
; AVX512BWVL-NEXT:    vpextrb $0, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $12, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $13, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $14, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $15, %eax, %xmm1, %xmm0
; AVX512BWVL-NEXT:    vmovdqu %xmm0, (%rsi)
; AVX512BWVL-NEXT:    retq
  %vec = load <64 x i8>, <64 x i8>* %L
  %strided.vec = shufflevector <64 x i8> %vec, <64 x i8> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  store <16 x i8> %strided.vec, <16 x i8>* %S
  ret void
}

define void @trunc_v16i32_to_v16i8(<64 x i8>* %L, <16 x i8>* %S) nounwind {
; AVX512-LABEL: trunc_v16i32_to_v16i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovdqa32 (%rdi), %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, (%rsi)
; AVX512-NEXT:    retq
  %vec = load <64 x i8>, <64 x i8>* %L
  %bc = bitcast <64 x i8> %vec to <16 x i32>
  %strided.vec = trunc <16 x i32> %bc to <16 x i8>
  store <16 x i8> %strided.vec, <16 x i8>* %S
  ret void
}

define void @shuffle_v32i16_to_v8i16(<32 x i16>* %L, <8 x i16>* %S) nounwind {
; AVX512F-LABEL: shuffle_v32i16_to_v8i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX512F-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,0,2,4,5,6,7]
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX512F-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,0,2,4,5,6,7]
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX512F-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX512F-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v32i16_to_v8i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512VL-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,0,2,4,5,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,0,2,4,5,6,7]
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX512VL-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: shuffle_v32i16_to_v8i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BW-NEXT:    vpextrw $4, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrw $1, %eax, %xmm0, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BW-NEXT:    vmovd %xmm2, %eax
; AVX512BW-NEXT:    vpinsrw $2, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrw $4, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrw $3, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BW-NEXT:    vmovd %xmm2, %eax
; AVX512BW-NEXT:    vpinsrw $4, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrw $4, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrw $5, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, %eax
; AVX512BW-NEXT:    vpinsrw $6, %eax, %xmm1, %xmm1
; AVX512BW-NEXT:    vpextrw $4, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrw $7, %eax, %xmm1, %xmm0
; AVX512BW-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: shuffle_v32i16_to_v8i16:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vpextrw $4, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrw $1, %eax, %xmm0, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BWVL-NEXT:    vmovd %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrw $2, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrw $4, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrw $3, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BWVL-NEXT:    vmovd %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrw $4, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrw $4, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrw $5, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $3, %zmm0, %xmm0
; AVX512BWVL-NEXT:    vmovd %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrw $6, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrw $4, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrw $7, %eax, %xmm1, %xmm0
; AVX512BWVL-NEXT:    vmovdqu %xmm0, (%rsi)
; AVX512BWVL-NEXT:    retq
  %vec = load <32 x i16>, <32 x i16>* %L
  %strided.vec = shufflevector <32 x i16> %vec, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  store <8 x i16> %strided.vec, <8 x i16>* %S
  ret void
}

define void @trunc_v8i64_to_v8i16(<32 x i16>* %L, <8 x i16>* %S) nounwind {
; AVX512-LABEL: trunc_v8i64_to_v8i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, (%rsi)
; AVX512-NEXT:    retq
  %vec = load <32 x i16>, <32 x i16>* %L
  %bc = bitcast <32 x i16> %vec to <8 x i64>
  %strided.vec = trunc <8 x i64> %bc to <8 x i16>
  store <8 x i16> %strided.vec, <8 x i16>* %S
  ret void
}

define void @shuffle_v64i8_to_v8i8(<64 x i8>* %L, <8 x i8>* %S) nounwind {
; AVX512F-LABEL: shuffle_v64i8_to_v8i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,0,8,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512F-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512F-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX512F-NEXT:    vmovq %xmm0, (%rsi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v64i8_to_v8i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512VL-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,0,8,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX512VL-NEXT:    vmovq %xmm0, (%rsi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: shuffle_v64i8_to_v8i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %r8d
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %r9d
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %r10d
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %r11d
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm1
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %edi
; AVX512BW-NEXT:    vmovd %edi, %xmm0
; AVX512BW-NEXT:    vpinsrb $1, %edx, %xmm0, %xmm0
; AVX512BW-NEXT:    vpinsrb $2, %ecx, %xmm0, %xmm0
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm0, %xmm0
; AVX512BW-NEXT:    vpinsrb $4, %r11d, %xmm0, %xmm0
; AVX512BW-NEXT:    vpinsrb $5, %r10d, %xmm0, %xmm0
; AVX512BW-NEXT:    vpinsrb $6, %r9d, %xmm0, %xmm0
; AVX512BW-NEXT:    vpinsrb $7, %r8d, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rsi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: shuffle_v64i8_to_v8i8:
; AVX512BWVL:       # BB#0:
; AVX512BWVL-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BWVL-NEXT:    vpextrb $0, %xmm0, %ecx
; AVX512BWVL-NEXT:    vmovd %ecx, %xmm1
; AVX512BWVL-NEXT:    vpinsrb $2, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BWVL-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $4, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $6, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BWVL-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $8, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BWVL-NEXT:    vpinsrb $10, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vextracti32x4 $3, %zmm0, %xmm0
; AVX512BWVL-NEXT:    vpextrb $0, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $12, %eax, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BWVL-NEXT:    vpinsrb $14, %eax, %xmm1, %xmm0
; AVX512BWVL-NEXT:    vpmovwb %xmm0, (%rsi)
; AVX512BWVL-NEXT:    retq
  %vec = load <64 x i8>, <64 x i8>* %L
  %strided.vec = shufflevector <64 x i8> %vec, <64 x i8> undef, <8 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 56>
  store <8 x i8> %strided.vec, <8 x i8>* %S
  ret void
}

define void @trunc_v8i64_to_v8i8(<64 x i8>* %L, <8 x i8>* %S) nounwind {
; AVX512-LABEL: trunc_v8i64_to_v8i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, (%rsi)
; AVX512-NEXT:    retq
  %vec = load <64 x i8>, <64 x i8>* %L
  %bc = bitcast <64 x i8> %vec to <8 x i64>
  %strided.vec = trunc <8 x i64> %bc to <8 x i8>
  store <8 x i8> %strided.vec, <8 x i8>* %S
  ret void
}
