; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=x86 -mattr=+cmov,cx16 -mtriple=i386-pc-linux -verify-machineinstrs < %s | FileCheck %s -check-prefix=LINUX
; RUN: llc -march=x86 -mattr=cx16 -mtriple=i386-macosx -relocation-model=pic -verify-machineinstrs < %s | FileCheck %s -check-prefix=PIC

@sc64 = external global i64

define void @atomic_maxmin_i6432() {
; LINUX-LABEL: atomic_maxmin_i6432:
; LINUX:       # BB#0:
; LINUX-NEXT:    pushl %ebx
; LINUX-NEXT:  .Lcfi0:
; LINUX-NEXT:    .cfi_def_cfa_offset 8
; LINUX-NEXT:    pushl %esi
; LINUX-NEXT:  .Lcfi1:
; LINUX-NEXT:    .cfi_def_cfa_offset 12
; LINUX-NEXT:  .Lcfi2:
; LINUX-NEXT:    .cfi_offset %esi, -12
; LINUX-NEXT:  .Lcfi3:
; LINUX-NEXT:    .cfi_offset %ebx, -8
; LINUX-NEXT:    movl sc64+4, %edx
; LINUX-NEXT:    movl sc64, %eax
; LINUX-NEXT:    movl $4, %esi
; LINUX-NEXT:    .p2align 4, 0x90
; LINUX-NEXT:  .LBB0_1: # %atomicrmw.start
; LINUX-NEXT:    # =>This Inner Loop Header: Depth=1
; LINUX-NEXT:    cmpl %eax, %esi
; LINUX-NEXT:    movl $0, %ecx
; LINUX-NEXT:    sbbl %edx, %ecx
; LINUX-NEXT:    setl %cl
; LINUX-NEXT:    andb $1, %cl
; LINUX-NEXT:    movl $5, %ebx
; LINUX-NEXT:    cmovnel %eax, %ebx
; LINUX-NEXT:    testb %cl, %cl
; LINUX-NEXT:    movl $0, %ecx
; LINUX-NEXT:    cmovnel %edx, %ecx
; LINUX-NEXT:    lock cmpxchg8b sc64
; LINUX-NEXT:    jne .LBB0_1
; LINUX-NEXT:  # BB#2: # %atomicrmw.end
; LINUX-NEXT:    movl sc64+4, %edx
; LINUX-NEXT:    movl sc64, %eax
; LINUX-NEXT:    .p2align 4, 0x90
; LINUX-NEXT:  .LBB0_3: # %atomicrmw.start2
; LINUX-NEXT:    # =>This Inner Loop Header: Depth=1
; LINUX-NEXT:    cmpl $7, %eax
; LINUX-NEXT:    movl %edx, %ecx
; LINUX-NEXT:    sbbl $0, %ecx
; LINUX-NEXT:    setl %cl
; LINUX-NEXT:    andb $1, %cl
; LINUX-NEXT:    movl $6, %ebx
; LINUX-NEXT:    cmovnel %eax, %ebx
; LINUX-NEXT:    testb %cl, %cl
; LINUX-NEXT:    movl $0, %ecx
; LINUX-NEXT:    cmovnel %edx, %ecx
; LINUX-NEXT:    lock cmpxchg8b sc64
; LINUX-NEXT:    jne .LBB0_3
; LINUX-NEXT:  # BB#4: # %atomicrmw.end1
; LINUX-NEXT:    movl sc64+4, %edx
; LINUX-NEXT:    movl sc64, %eax
; LINUX-NEXT:    movl $7, %esi
; LINUX-NEXT:    .p2align 4, 0x90
; LINUX-NEXT:  .LBB0_5: # %atomicrmw.start8
; LINUX-NEXT:    # =>This Inner Loop Header: Depth=1
; LINUX-NEXT:    cmpl %eax, %esi
; LINUX-NEXT:    movl $0, %ecx
; LINUX-NEXT:    sbbl %edx, %ecx
; LINUX-NEXT:    setb %cl
; LINUX-NEXT:    andb $1, %cl
; LINUX-NEXT:    movl $7, %ebx
; LINUX-NEXT:    cmovnel %eax, %ebx
; LINUX-NEXT:    testb %cl, %cl
; LINUX-NEXT:    movl $0, %ecx
; LINUX-NEXT:    cmovnel %edx, %ecx
; LINUX-NEXT:    lock cmpxchg8b sc64
; LINUX-NEXT:    jne .LBB0_5
; LINUX-NEXT:  # BB#6: # %atomicrmw.end7
; LINUX-NEXT:    movl sc64+4, %edx
; LINUX-NEXT:    movl sc64, %eax
; LINUX-NEXT:    .p2align 4, 0x90
; LINUX-NEXT:  .LBB0_7: # %atomicrmw.start14
; LINUX-NEXT:    # =>This Inner Loop Header: Depth=1
; LINUX-NEXT:    cmpl $9, %eax
; LINUX-NEXT:    movl %edx, %ecx
; LINUX-NEXT:    sbbl $0, %ecx
; LINUX-NEXT:    setb %cl
; LINUX-NEXT:    andb $1, %cl
; LINUX-NEXT:    movl $8, %ebx
; LINUX-NEXT:    cmovnel %eax, %ebx
; LINUX-NEXT:    testb %cl, %cl
; LINUX-NEXT:    movl $0, %ecx
; LINUX-NEXT:    cmovnel %edx, %ecx
; LINUX-NEXT:    lock cmpxchg8b sc64
; LINUX-NEXT:    jne .LBB0_7
; LINUX-NEXT:  # BB#8: # %atomicrmw.end13
; LINUX-NEXT:    popl %esi
; LINUX-NEXT:    popl %ebx
; LINUX-NEXT:    retl
;
; PIC-LABEL: atomic_maxmin_i6432:
; PIC:       ## BB#0:
; PIC-NEXT:    pushl %ebx
; PIC-NEXT:  Lcfi0:
; PIC-NEXT:    .cfi_def_cfa_offset 8
; PIC-NEXT:    pushl %edi
; PIC-NEXT:  Lcfi1:
; PIC-NEXT:    .cfi_def_cfa_offset 12
; PIC-NEXT:    pushl %esi
; PIC-NEXT:  Lcfi2:
; PIC-NEXT:    .cfi_def_cfa_offset 16
; PIC-NEXT:  Lcfi3:
; PIC-NEXT:    .cfi_offset %esi, -16
; PIC-NEXT:  Lcfi4:
; PIC-NEXT:    .cfi_offset %edi, -12
; PIC-NEXT:  Lcfi5:
; PIC-NEXT:    .cfi_offset %ebx, -8
; PIC-NEXT:    calll L0$pb
; PIC-NEXT:  Lcfi6:
; PIC-NEXT:    .cfi_adjust_cfa_offset 4
; PIC-NEXT:  L0$pb:
; PIC-NEXT:    popl %eax
; PIC-NEXT:  Lcfi7:
; PIC-NEXT:    .cfi_adjust_cfa_offset -4
; PIC-NEXT:    movl L_sc64$non_lazy_ptr-L0$pb(%eax), %esi
; PIC-NEXT:    movl (%esi), %eax
; PIC-NEXT:    movl 4(%esi), %edx
; PIC-NEXT:    movl $4, %edi
; PIC-NEXT:    .p2align 4, 0x90
; PIC-NEXT:  LBB0_1: ## %atomicrmw.start
; PIC-NEXT:    ## =>This Inner Loop Header: Depth=1
; PIC-NEXT:    cmpl %eax, %edi
; PIC-NEXT:    movl $0, %ecx
; PIC-NEXT:    sbbl %edx, %ecx
; PIC-NEXT:    setl %cl
; PIC-NEXT:    andb $1, %cl
; PIC-NEXT:    movl $5, %ebx
; PIC-NEXT:    cmovnel %eax, %ebx
; PIC-NEXT:    testb %cl, %cl
; PIC-NEXT:    movl $0, %ecx
; PIC-NEXT:    cmovnel %edx, %ecx
; PIC-NEXT:    lock cmpxchg8b (%esi)
; PIC-NEXT:    jne LBB0_1
; PIC-NEXT:  ## BB#2: ## %atomicrmw.end
; PIC-NEXT:    movl (%esi), %eax
; PIC-NEXT:    movl 4(%esi), %edx
; PIC-NEXT:    .p2align 4, 0x90
; PIC-NEXT:  LBB0_3: ## %atomicrmw.start2
; PIC-NEXT:    ## =>This Inner Loop Header: Depth=1
; PIC-NEXT:    cmpl $7, %eax
; PIC-NEXT:    movl %edx, %ecx
; PIC-NEXT:    sbbl $0, %ecx
; PIC-NEXT:    setl %cl
; PIC-NEXT:    andb $1, %cl
; PIC-NEXT:    movl $6, %ebx
; PIC-NEXT:    cmovnel %eax, %ebx
; PIC-NEXT:    testb %cl, %cl
; PIC-NEXT:    movl $0, %ecx
; PIC-NEXT:    cmovnel %edx, %ecx
; PIC-NEXT:    lock cmpxchg8b (%esi)
; PIC-NEXT:    jne LBB0_3
; PIC-NEXT:  ## BB#4: ## %atomicrmw.end1
; PIC-NEXT:    movl (%esi), %eax
; PIC-NEXT:    movl 4(%esi), %edx
; PIC-NEXT:    movl $7, %edi
; PIC-NEXT:    .p2align 4, 0x90
; PIC-NEXT:  LBB0_5: ## %atomicrmw.start8
; PIC-NEXT:    ## =>This Inner Loop Header: Depth=1
; PIC-NEXT:    cmpl %eax, %edi
; PIC-NEXT:    movl $0, %ecx
; PIC-NEXT:    sbbl %edx, %ecx
; PIC-NEXT:    setb %cl
; PIC-NEXT:    andb $1, %cl
; PIC-NEXT:    movl $7, %ebx
; PIC-NEXT:    cmovnel %eax, %ebx
; PIC-NEXT:    testb %cl, %cl
; PIC-NEXT:    movl $0, %ecx
; PIC-NEXT:    cmovnel %edx, %ecx
; PIC-NEXT:    lock cmpxchg8b (%esi)
; PIC-NEXT:    jne LBB0_5
; PIC-NEXT:  ## BB#6: ## %atomicrmw.end7
; PIC-NEXT:    movl (%esi), %eax
; PIC-NEXT:    movl 4(%esi), %edx
; PIC-NEXT:    .p2align 4, 0x90
; PIC-NEXT:  LBB0_7: ## %atomicrmw.start14
; PIC-NEXT:    ## =>This Inner Loop Header: Depth=1
; PIC-NEXT:    cmpl $9, %eax
; PIC-NEXT:    movl %edx, %ecx
; PIC-NEXT:    sbbl $0, %ecx
; PIC-NEXT:    setb %cl
; PIC-NEXT:    andb $1, %cl
; PIC-NEXT:    movl $8, %ebx
; PIC-NEXT:    cmovnel %eax, %ebx
; PIC-NEXT:    testb %cl, %cl
; PIC-NEXT:    movl $0, %ecx
; PIC-NEXT:    cmovnel %edx, %ecx
; PIC-NEXT:    lock cmpxchg8b (%esi)
; PIC-NEXT:    jne LBB0_7
; PIC-NEXT:  ## BB#8: ## %atomicrmw.end13
; PIC-NEXT:    popl %esi
; PIC-NEXT:    popl %edi
; PIC-NEXT:    popl %ebx
; PIC-NEXT:    retl
  %1 = atomicrmw max  i64* @sc64, i64 5 acquire
  %2 = atomicrmw min  i64* @sc64, i64 6 acquire
  %3 = atomicrmw umax i64* @sc64, i64 7 acquire
  %4 = atomicrmw umin i64* @sc64, i64 8 acquire
  ret void
}

; rdar://12453106
@id = internal global i64 0, align 8

define void @tf_bug(i8* %ptr) nounwind {
; LINUX-LABEL: tf_bug:
; LINUX:       # BB#0:
; LINUX-NEXT:    pushl %ebx
; LINUX-NEXT:    pushl %esi
; LINUX-NEXT:    movl {{[0-9]+}}(%esp), %esi
; LINUX-NEXT:    movl id+4, %edx
; LINUX-NEXT:    movl id, %eax
; LINUX-NEXT:    .p2align 4, 0x90
; LINUX-NEXT:  .LBB1_1: # %atomicrmw.start
; LINUX-NEXT:    # =>This Inner Loop Header: Depth=1
; LINUX-NEXT:    movl %eax, %ebx
; LINUX-NEXT:    addl $1, %ebx
; LINUX-NEXT:    movl %edx, %ecx
; LINUX-NEXT:    adcl $0, %ecx
; LINUX-NEXT:    lock cmpxchg8b id
; LINUX-NEXT:    jne .LBB1_1
; LINUX-NEXT:  # BB#2: # %atomicrmw.end
; LINUX-NEXT:    addl $1, %eax
; LINUX-NEXT:    adcl $0, %edx
; LINUX-NEXT:    movl %eax, (%esi)
; LINUX-NEXT:    movl %edx, 4(%esi)
; LINUX-NEXT:    popl %esi
; LINUX-NEXT:    popl %ebx
; LINUX-NEXT:    retl
;
; PIC-LABEL: tf_bug:
; PIC:       ## BB#0:
; PIC-NEXT:    pushl %ebx
; PIC-NEXT:    pushl %edi
; PIC-NEXT:    pushl %esi
; PIC-NEXT:    calll L1$pb
; PIC-NEXT:  L1$pb:
; PIC-NEXT:    popl %edi
; PIC-NEXT:    movl {{[0-9]+}}(%esp), %esi
; PIC-NEXT:    movl (_id-L1$pb)+4(%edi), %edx
; PIC-NEXT:    movl _id-L1$pb(%edi), %eax
; PIC-NEXT:    .p2align 4, 0x90
; PIC-NEXT:  LBB1_1: ## %atomicrmw.start
; PIC-NEXT:    ## =>This Inner Loop Header: Depth=1
; PIC-NEXT:    movl %eax, %ebx
; PIC-NEXT:    addl $1, %ebx
; PIC-NEXT:    movl %edx, %ecx
; PIC-NEXT:    adcl $0, %ecx
; PIC-NEXT:    lock cmpxchg8b _id-L1$pb(%edi)
; PIC-NEXT:    jne LBB1_1
; PIC-NEXT:  ## BB#2: ## %atomicrmw.end
; PIC-NEXT:    addl $1, %eax
; PIC-NEXT:    adcl $0, %edx
; PIC-NEXT:    movl %eax, (%esi)
; PIC-NEXT:    movl %edx, 4(%esi)
; PIC-NEXT:    popl %esi
; PIC-NEXT:    popl %edi
; PIC-NEXT:    popl %ebx
; PIC-NEXT:    retl
  %tmp1 = atomicrmw add i64* @id, i64 1 seq_cst
  %tmp2 = add i64 %tmp1, 1
  %tmp3 = bitcast i8* %ptr to i64*
  store i64 %tmp2, i64* %tmp3, align 4
  ret void
}
