; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=i686-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX

; PR11674
define void @fpext_frommem(<2 x float>* %in, <2 x double>* %out) {
; SSE-LABEL: fpext_frommem:
; SSE:       # BB#0: # %entry
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE-NEXT:    cvtps2pd (%ecx), %xmm0
; SSE-NEXT:    movups %xmm0, (%eax)
; SSE-NEXT:    retl
;
; AVX-LABEL: fpext_frommem:
; AVX:       # BB#0: # %entry
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    vcvtps2pd (%ecx), %xmm0
; AVX-NEXT:    vmovups %xmm0, (%eax)
; AVX-NEXT:    retl
entry:
  %0 = load <2 x float>, <2 x float>* %in, align 8
  %1 = fpext <2 x float> %0 to <2 x double>
  store <2 x double> %1, <2 x double>* %out, align 1
  ret void
}

define void @fpext_frommem4(<4 x float>* %in, <4 x double>* %out) {
; SSE-LABEL: fpext_frommem4:
; SSE:       # BB#0: # %entry
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE-NEXT:    cvtps2pd (%ecx), %xmm0
; SSE-NEXT:    cvtps2pd 8(%ecx), %xmm1
; SSE-NEXT:    movups %xmm1, 16(%eax)
; SSE-NEXT:    movups %xmm0, (%eax)
; SSE-NEXT:    retl
;
; AVX-LABEL: fpext_frommem4:
; AVX:       # BB#0: # %entry
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    vcvtps2pd (%ecx), %ymm0
; AVX-NEXT:    vmovups %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
entry:
  %0 = load <4 x float>, <4 x float>* %in
  %1 = fpext <4 x float> %0 to <4 x double>
  store <4 x double> %1, <4 x double>* %out, align 1
  ret void
}

define void @fpext_frommem8(<8 x float>* %in, <8 x double>* %out) {
; SSE-LABEL: fpext_frommem8:
; SSE:       # BB#0: # %entry
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE-NEXT:    cvtps2pd (%ecx), %xmm0
; SSE-NEXT:    cvtps2pd 8(%ecx), %xmm1
; SSE-NEXT:    cvtps2pd 16(%ecx), %xmm2
; SSE-NEXT:    cvtps2pd 24(%ecx), %xmm3
; SSE-NEXT:    movups %xmm3, 48(%eax)
; SSE-NEXT:    movups %xmm2, 32(%eax)
; SSE-NEXT:    movups %xmm1, 16(%eax)
; SSE-NEXT:    movups %xmm0, (%eax)
; SSE-NEXT:    retl
;
; AVX-LABEL: fpext_frommem8:
; AVX:       # BB#0: # %entry
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    vcvtps2pd (%ecx), %ymm0
; AVX-NEXT:    vcvtps2pd 16(%ecx), %ymm1
; AVX-NEXT:    vmovups %ymm1, 32(%eax)
; AVX-NEXT:    vmovups %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
entry:
  %0 = load <8 x float>, <8 x float>* %in
  %1 = fpext <8 x float> %0 to <8 x double>
  store <8 x double> %1, <8 x double>* %out, align 1
  ret void
}

define <2 x double> @fpext_fromconst() {
; SSE-LABEL: fpext_fromconst:
; SSE:       # BB#0: # %entry
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1.000000e+00,-2.000000e+00]
; SSE-NEXT:    retl
;
; AVX-LABEL: fpext_fromconst:
; AVX:       # BB#0: # %entry
; AVX-NEXT:    vmovaps {{.*#+}} xmm0 = [1.000000e+00,-2.000000e+00]
; AVX-NEXT:    retl
entry:
  %0  = insertelement <2 x float> undef, float 1.0, i32 0
  %1  = insertelement <2 x float> %0, float -2.0, i32 1
  %2  = fpext <2 x float> %1 to <2 x double>
  ret <2 x double> %2
}
