; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-apple-darwin -mattr=avx < %s | FileCheck %s --check-prefix=AVX  --check-prefix=AVX1
; RUN: llc -mtriple=x86_64-apple-darwin -mattr=avx2 < %s | FileCheck %s --check-prefix=AVX --check-prefix=AVX2
; RUN: llc -mtriple=x86_64-apple-darwin -mattr=avx512f < %s | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512bw,avx512vl < %s | FileCheck %s --check-prefix=AVX512 --check-prefix=SKX

; To test for the case where masked load/store is not legal, we should add a run with a target
; that does not have AVX, but that case should probably be a separate test file using less tests
; because it takes over 1.2 seconds to codegen these tests on Haswell 4GHz if there's no maskmov.

define <16 x i32> @test1(<16 x i32> %trigger, <16 x i32>* %addr) {
; AVX1-LABEL: test1:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovps 32(%rdi), %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test1:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpmaskmovd 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test1:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512-NEXT:    vpcmpeqd %zmm1, %zmm0, %k1
; AVX512-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1} {z}
; AVX512-NEXT:    retq
  %mask = icmp eq <16 x i32> %trigger, zeroinitializer
  %res = call <16 x i32> @llvm.masked.load.v16i32(<16 x i32>* %addr, i32 4, <16 x i1>%mask, <16 x i32>undef)
  ret <16 x i32> %res
}

define <16 x i32> @test2(<16 x i32> %trigger, <16 x i32>* %addr) {
; AVX1-LABEL: test2:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovps 32(%rdi), %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test2:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpmaskmovd 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test2:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512-NEXT:    vpcmpeqd %zmm1, %zmm0, %k1
; AVX512-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1} {z}
; AVX512-NEXT:    retq
  %mask = icmp eq <16 x i32> %trigger, zeroinitializer
  %res = call <16 x i32> @llvm.masked.load.v16i32(<16 x i32>* %addr, i32 4, <16 x i1>%mask, <16 x i32>zeroinitializer)
  ret <16 x i32> %res
}

define void @test3(<16 x i32> %trigger, <16 x i32>* %addr, <16 x i32> %val) {
; AVX1-LABEL: test3:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovps %ymm3, %ymm1, 32(%rdi)
; AVX1-NEXT:    vmaskmovps %ymm2, %ymm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test3:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpmaskmovd %ymm3, %ymm1, 32(%rdi)
; AVX2-NEXT:    vpmaskmovd %ymm2, %ymm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test3:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpxord %zmm2, %zmm2, %zmm2
; AVX512-NEXT:    vpcmpeqd %zmm2, %zmm0, %k1
; AVX512-NEXT:    vmovdqu32 %zmm1, (%rdi) {%k1}
; AVX512-NEXT:    retq
  %mask = icmp eq <16 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v16i32(<16 x i32>%val, <16 x i32>* %addr, i32 4, <16 x i1>%mask)
  ret void
}

define <16 x float> @test4(<16 x i32> %trigger, <16 x float>* %addr, <16 x float> %dst) {
; AVX1-LABEL: test4:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm4
; AVX1-NEXT:    vblendvps %ymm0, %ymm4, %ymm2, %ymm0
; AVX1-NEXT:    vmaskmovps 32(%rdi), %ymm1, %ymm2
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm3, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test4:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm4
; AVX2-NEXT:    vblendvps %ymm0, %ymm4, %ymm2, %ymm0
; AVX2-NEXT:    vmaskmovps 32(%rdi), %ymm1, %ymm2
; AVX2-NEXT:    vblendvps %ymm1, %ymm2, %ymm3, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test4:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpxord %zmm2, %zmm2, %zmm2
; AVX512-NEXT:    vpcmpeqd %zmm2, %zmm0, %k1
; AVX512-NEXT:    vmovups (%rdi), %zmm1 {%k1}
; AVX512-NEXT:    vmovaps %zmm1, %zmm0
; AVX512-NEXT:    retq
  %mask = icmp eq <16 x i32> %trigger, zeroinitializer
  %res = call <16 x float> @llvm.masked.load.v16f32(<16 x float>* %addr, i32 4, <16 x i1>%mask, <16 x float> %dst)
  ret <16 x float> %res
}

define <8 x double> @test5(<8 x i32> %trigger, <8 x double>* %addr, <8 x double> %dst) {
; AVX1-LABEL: test5:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm0
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm4
; AVX1-NEXT:    vblendvpd %ymm0, %ymm4, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovpd 32(%rdi), %ymm3, %ymm1
; AVX1-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test5:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpmovsxdq %xmm3, %ymm3
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm4
; AVX2-NEXT:    vblendvpd %ymm0, %ymm4, %ymm1, %ymm0
; AVX2-NEXT:    vmaskmovpd 32(%rdi), %ymm3, %ymm1
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test5:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpeqd %zmm2, %zmm0, %k1
; AVX512F-NEXT:    vmovupd (%rdi), %zmm1 {%k1}
; AVX512F-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test5:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; SKX-NEXT:    vpcmpeqd %ymm2, %ymm0, %k1
; SKX-NEXT:    vmovupd (%rdi), %zmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <8 x i32> %trigger, zeroinitializer
  %res = call <8 x double> @llvm.masked.load.v8f64(<8 x double>* %addr, i32 4, <8 x i1>%mask, <8 x double>%dst)
  ret <8 x double> %res
}

define <2 x double> @test6(<2 x i64> %trigger, <2 x double>* %addr, <2 x double> %dst) {
; AVX-LABEL: test6:
; AVX:       ## BB#0:
; AVX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2
; AVX-NEXT:    vblendvpd %xmm0, %xmm2, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: test6:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2
; AVX512F-NEXT:    vblendvpd %xmm0, %xmm2, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test6:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpcmpeqq %xmm2, %xmm0, %k1
; SKX-NEXT:    vmovupd (%rdi), %xmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <2 x i64> %trigger, zeroinitializer
  %res = call <2 x double> @llvm.masked.load.v2f64(<2 x double>* %addr, i32 4, <2 x i1>%mask, <2 x double>%dst)
  ret <2 x double> %res
}

define <4 x float> @test7(<4 x i32> %trigger, <4 x float>* %addr, <4 x float> %dst) {
; AVX-LABEL: test7:
; AVX:       ## BB#0:
; AVX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: test7:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX512F-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test7:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpcmpeqd %xmm2, %xmm0, %k1
; SKX-NEXT:    vmovups (%rdi), %xmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.load.v4f32(<4 x float>* %addr, i32 4, <4 x i1>%mask, <4 x float>%dst)
  ret <4 x float> %res
}

define <4 x i32> @test8(<4 x i32> %trigger, <4 x i32>* %addr, <4 x i32> %dst) {
; AVX1-LABEL: test8:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test8:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmaskmovd (%rdi), %xmm0, %xmm2
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test8:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpmaskmovd (%rdi), %xmm0, %xmm2
; AVX512F-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpcmpeqd %xmm2, %xmm0, %k1
; SKX-NEXT:    vmovdqu32 (%rdi), %xmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x i32> @llvm.masked.load.v4i32(<4 x i32>* %addr, i32 4, <4 x i1>%mask, <4 x i32>%dst)
  ret <4 x i32> %res
}

define void @test9(<4 x i32> %trigger, <4 x i32>* %addr, <4 x i32> %val) {
; AVX1-LABEL: test9:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test9:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test9:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test9:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpcmpeqd %xmm2, %xmm0, %k1
; SKX-NEXT:    vmovdqu32 %xmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v4i32(<4 x i32>%val, <4 x i32>* %addr, i32 4, <4 x i1>%mask)
  ret void
}

define <4 x double> @test10(<4 x i32> %trigger, <4 x double>* %addr, <4 x double> %dst) {
; AVX1-LABEL: test10:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2
; AVX1-NEXT:    vblendvpd %ymm0, %ymm2, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test10:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm0, %ymm2, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test10:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX512F-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vblendvpd %ymm0, %ymm2, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test10:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpcmpeqd %xmm2, %xmm0, %k1
; SKX-NEXT:    vmovapd (%rdi), %ymm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x double> @llvm.masked.load.v4f64(<4 x double>* %addr, i32 32, <4 x i1>%mask, <4 x double>%dst)
  ret <4 x double> %res
}

define <4 x double> @test10b(<4 x i32> %trigger, <4 x double>* %addr, <4 x double> %dst) {
; AVX1-LABEL: test10b:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test10b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test10b:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX512F-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test10b:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpcmpeqd %xmm1, %xmm0, %k1
; SKX-NEXT:    vmovapd (%rdi), %ymm0 {%k1} {z}
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x double> @llvm.masked.load.v4f64(<4 x double>* %addr, i32 32, <4 x i1>%mask, <4 x double>zeroinitializer)
  ret <4 x double> %res
}

define <8 x float> @test11a(<8 x i32> %trigger, <8 x float>* %addr, <8 x float> %dst) {
; AVX1-LABEL: test11a:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2
; AVX1-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11a:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test11a:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpeqd %zmm2, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm1 {%k1}
; AVX512F-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test11a:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; SKX-NEXT:    vpcmpeqd %ymm2, %ymm0, %k1
; SKX-NEXT:    vmovaps (%rdi), %ymm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <8 x i32> %trigger, zeroinitializer
  %res = call <8 x float> @llvm.masked.load.v8f32(<8 x float>* %addr, i32 32, <8 x i1>%mask, <8 x float>%dst)
  ret <8 x float> %res
}

define <8 x i32> @test11b(<8 x i1> %mask, <8 x i32>* %addr, <8 x i32> %dst) {
; AVX1-LABEL: test11b:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2
; AVX1-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test11b:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm1 {%k1}
; AVX512F-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test11b:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $15, %xmm0, %xmm0
; SKX-NEXT:    vpmovw2m %xmm0, %k1
; SKX-NEXT:    vmovdqu32 (%rdi), %ymm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %res = call <8 x i32> @llvm.masked.load.v8i32(<8 x i32>* %addr, i32 4, <8 x i1>%mask, <8 x i32>%dst)
  ret <8 x i32> %res
}

define <8 x float> @test11c(<8 x i1> %mask, <8 x float>* %addr) {
; AVX1-LABEL: test11c:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11c:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test11c:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test11c:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $15, %xmm0, %xmm0
; SKX-NEXT:    vpmovw2m %xmm0, %k1
; SKX-NEXT:    vmovaps (%rdi), %ymm0 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <8 x float> @llvm.masked.load.v8f32(<8 x float>* %addr, i32 32, <8 x i1> %mask, <8 x float> zeroinitializer)
  ret <8 x float> %res
}

define <8 x i32> @test11d(<8 x i1> %mask, <8 x i32>* %addr) {
; AVX1-LABEL: test11d:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test11d:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test11d:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $15, %xmm0, %xmm0
; SKX-NEXT:    vpmovw2m %xmm0, %k1
; SKX-NEXT:    vmovdqu32 (%rdi), %ymm0 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <8 x i32> @llvm.masked.load.v8i32(<8 x i32>* %addr, i32 4, <8 x i1> %mask, <8 x i32> zeroinitializer)
  ret <8 x i32> %res
}

define void @test12(<8 x i32> %trigger, <8 x i32>* %addr, <8 x i32> %val) {
; AVX1-LABEL: test12:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test12:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaskmovd %ymm1, %ymm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test12:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpeqd %zmm2, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test12:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; SKX-NEXT:    vpcmpeqd %ymm2, %ymm0, %k1
; SKX-NEXT:    vmovdqu32 %ymm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  %mask = icmp eq <8 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v8i32(<8 x i32>%val, <8 x i32>* %addr, i32 4, <8 x i1>%mask)
  ret void
}

define void @test13(<16 x i32> %trigger, <16 x float>* %addr, <16 x float> %val) {
; AVX1-LABEL: test13:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovps %ymm3, %ymm1, 32(%rdi)
; AVX1-NEXT:    vmaskmovps %ymm2, %ymm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test13:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vmaskmovps %ymm3, %ymm1, 32(%rdi)
; AVX2-NEXT:    vmaskmovps %ymm2, %ymm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test13:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpxord %zmm2, %zmm2, %zmm2
; AVX512-NEXT:    vpcmpeqd %zmm2, %zmm0, %k1
; AVX512-NEXT:    vmovups %zmm1, (%rdi) {%k1}
; AVX512-NEXT:    retq
  %mask = icmp eq <16 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v16f32(<16 x float>%val, <16 x float>* %addr, i32 4, <16 x i1>%mask)
  ret void
}

define void @test14(<2 x i32> %trigger, <2 x float>* %addr, <2 x float> %val) {
; AVX1-LABEL: test14:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test14:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX2-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test14:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512F-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test14:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; SKX-NEXT:    vpcmpeqq %xmm2, %xmm0, %k0
; SKX-NEXT:    kshiftlw $14, %k0, %k0
; SKX-NEXT:    kshiftrw $14, %k0, %k1
; SKX-NEXT:    vmovups %xmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v2f32(<2 x float>%val, <2 x float>* %addr, i32 4, <2 x i1>%mask)
  ret void
}

define void @test15(<2 x i32> %trigger, <2 x i32>* %addr, <2 x i32> %val) {
; AVX1-LABEL: test15:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test15:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test15:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX512F-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test15:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; SKX-NEXT:    vpcmpeqq %xmm2, %xmm0, %k1
; SKX-NEXT:    vpmovqd %xmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v2i32(<2 x i32>%val, <2 x i32>* %addr, i32 4, <2 x i1>%mask)
  ret void
}

define <2 x float> @test16(<2 x i32> %trigger, <2 x float>* %addr, <2 x float> %dst) {
; AVX1-LABEL: test16:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test16:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test16:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512F-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX512F-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; SKX-NEXT:    vpcmpeqq %xmm2, %xmm0, %k0
; SKX-NEXT:    kshiftlw $14, %k0, %k0
; SKX-NEXT:    kshiftrw $14, %k0, %k1
; SKX-NEXT:    vmovups (%rdi), %xmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x float> @llvm.masked.load.v2f32(<2 x float>* %addr, i32 4, <2 x i1>%mask, <2 x float>%dst)
  ret <2 x float> %res
}

define <2 x i32> @test17(<2 x i32> %trigger, <2 x i32>* %addr, <2 x i32> %dst) {
; AVX1-LABEL: test17:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test17:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX2-NEXT:    vpmaskmovd (%rdi), %xmm0, %xmm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test17:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512F-NEXT:    vpmaskmovd (%rdi), %xmm0, %xmm2
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX512F-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX512F-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test17:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; SKX-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; SKX-NEXT:    vpcmpeqq %xmm2, %xmm0, %k0
; SKX-NEXT:    kshiftlw $14, %k0, %k0
; SKX-NEXT:    kshiftrw $14, %k0, %k1
; SKX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SKX-NEXT:    vmovdqu32 (%rdi), %xmm0 {%k1}
; SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; SKX-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x i32> @llvm.masked.load.v2i32(<2 x i32>* %addr, i32 4, <2 x i1>%mask, <2 x i32>%dst)
  ret <2 x i32> %res
}

define <2 x float> @test18(<2 x i32> %trigger, <2 x float>* %addr) {
; AVX1-LABEL: test18:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test18:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test18:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512F-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512F-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test18:
; SKX:       ## BB#0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; SKX-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; SKX-NEXT:    kshiftlw $14, %k0, %k0
; SKX-NEXT:    kshiftrw $14, %k0, %k1
; SKX-NEXT:    vmovups (%rdi), %xmm0 {%k1} {z}
; SKX-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x float> @llvm.masked.load.v2f32(<2 x float>* %addr, i32 4, <2 x i1>%mask, <2 x float>undef)
  ret <2 x float> %res
}

define <4 x float> @test19(<4 x i32> %trigger, <4 x float>* %addr) {
; AVX-LABEL: test19:
; AVX:       ## BB#0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: test19:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test19:
; SKX:       ## BB#0:
; SKX-NEXT:    kxnorw %k0, %k0, %k1
; SKX-NEXT:    vmovups (%rdi), %xmm0 {%k1} {z}
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.load.v4f32(<4 x float>* %addr, i32 4, <4 x i1><i1 true, i1 true, i1 true, i1 true>, <4 x float>undef)
  ret <4 x float> %res
}

;;; Loads with Constant Masks - these should be optimized to use something other than a variable blend.

; 128-bit FP vectors are supported with AVX.

define <4 x float> @mload_constmask_v4f32(<4 x float>* %addr, <4 x float> %dst) {
; AVX-LABEL: mload_constmask_v4f32:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovaps {{.*#+}} xmm1 = [4294967295,0,4294967295,4294967295]
; AVX-NEXT:    vmaskmovps (%rdi), %xmm1, %xmm2
; AVX-NEXT:    vblendvps %xmm1, %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4f32:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vmovaps {{.*#+}} xmm1 = [4294967295,0,4294967295,4294967295]
; AVX512F-NEXT:    vmaskmovps (%rdi), %xmm1, %xmm2
; AVX512F-NEXT:    vblendvps %xmm1, %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: mload_constmask_v4f32:
; SKX:       ## BB#0:
; SKX-NEXT:    movb $13, %al
; SKX-NEXT:    kmovw %eax, %k1
; SKX-NEXT:    vmovups (%rdi), %xmm0 {%k1}
; SKX-NEXT:    retq
  %res = call <4 x float> @llvm.masked.load.v4f32(<4 x float>* %addr, i32 4, <4 x i1> <i1 1, i1 0, i1 1, i1 1>, <4 x float> %dst)
  ret <4 x float> %res
}

; 128-bit integer vectors are supported with AVX2.

define <4 x i32> @mload_constmask_v4i32(<4 x i32>* %addr, <4 x i32> %dst) {
; AVX1-LABEL: mload_constmask_v4i32:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vmovaps {{.*#+}} xmm1 = [0,4294967295,4294967295,4294967295]
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm1, %xmm2
; AVX1-NEXT:    vblendvps %xmm1, %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: mload_constmask_v4i32:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpmaskmovd (%rdi), %xmm1, %xmm2
; AVX2-NEXT:    vblendvps %xmm1, %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4i32:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,4294967295,4294967295,4294967295]
; AVX512F-NEXT:    vpmaskmovd (%rdi), %xmm1, %xmm2
; AVX512F-NEXT:    vblendvps %xmm1, %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: mload_constmask_v4i32:
; SKX:       ## BB#0:
; SKX-NEXT:    movb $14, %al
; SKX-NEXT:    kmovw %eax, %k1
; SKX-NEXT:    vmovdqu32 (%rdi), %xmm0 {%k1}
; SKX-NEXT:    retq
  %res = call <4 x i32> @llvm.masked.load.v4i32(<4 x i32>* %addr, i32 4, <4 x i1> <i1 0, i1 1, i1 1, i1 1>, <4 x i32> %dst)
  ret <4 x i32> %res
}

; 256-bit FP vectors are supported with AVX.

define <8 x float> @mload_constmask_v8f32(<8 x float>* %addr, <8 x float> %dst) {
; AVX-LABEL: mload_constmask_v8f32:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,0,0,0,0,0]
; AVX-NEXT:    vmaskmovps (%rdi), %ymm1, %ymm2
; AVX-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v8f32:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    movw $7, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: mload_constmask_v8f32:
; SKX:       ## BB#0:
; SKX-NEXT:    movb $7, %al
; SKX-NEXT:    kmovw %eax, %k1
; SKX-NEXT:    vmovups (%rdi), %ymm0 {%k1}
; SKX-NEXT:    retq
  %res = call <8 x float> @llvm.masked.load.v8f32(<8 x float>* %addr, i32 4, <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 0, i1 0, i1 0, i1 0>, <8 x float> %dst)
  ret <8 x float> %res
}

define <4 x double> @mload_constmask_v4f64(<4 x double>* %addr, <4 x double> %dst) {
; AVX-LABEL: mload_constmask_v4f64:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovapd {{.*#+}} ymm1 = [18446744073709551615,18446744073709551615,18446744073709551615,0]
; AVX-NEXT:    vmaskmovpd (%rdi), %ymm1, %ymm2
; AVX-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4f64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vmovapd {{.*#+}} ymm1 = [18446744073709551615,18446744073709551615,18446744073709551615,0]
; AVX512F-NEXT:    vmaskmovpd (%rdi), %ymm1, %ymm2
; AVX512F-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: mload_constmask_v4f64:
; SKX:       ## BB#0:
; SKX-NEXT:    movb $7, %al
; SKX-NEXT:    kmovw %eax, %k1
; SKX-NEXT:    vmovupd (%rdi), %ymm0 {%k1}
; SKX-NEXT:    retq
  %res = call <4 x double> @llvm.masked.load.v4f64(<4 x double>* %addr, i32 4, <4 x i1> <i1 1, i1 1, i1 1, i1 0>, <4 x double> %dst)
  ret <4 x double> %res
}

; 256-bit integer vectors are supported with AVX2.

define <8 x i32> @mload_constmask_v8i32(<8 x i32>* %addr, <8 x i32> %dst) {
; AVX1-LABEL: mload_constmask_v8i32:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,0,0,0,0,4294967295]
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm1, %ymm2
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: mload_constmask_v8i32:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,0,0,0,0,4294967295]
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm1, %ymm2
; AVX2-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v8i32:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    movw $135, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: mload_constmask_v8i32:
; SKX:       ## BB#0:
; SKX-NEXT:    movb $-121, %al
; SKX-NEXT:    kmovw %eax, %k1
; SKX-NEXT:    vmovdqu32 (%rdi), %ymm0 {%k1}
; SKX-NEXT:    retq
  %res = call <8 x i32> @llvm.masked.load.v8i32(<8 x i32>* %addr, i32 4, <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 0, i1 0, i1 0, i1 1>, <8 x i32> %dst)
  ret <8 x i32> %res
}

define <4 x i64> @mload_constmask_v4i64(<4 x i64>* %addr, <4 x i64> %dst) {
; AVX1-LABEL: mload_constmask_v4i64:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [18446744073709551615,0,0,18446744073709551615]
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm1, %ymm2
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: mload_constmask_v4i64:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [18446744073709551615,0,0,18446744073709551615]
; AVX2-NEXT:    vpmaskmovq (%rdi), %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4i64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm1 = [18446744073709551615,0,0,18446744073709551615]
; AVX512F-NEXT:    vpmaskmovq (%rdi), %ymm1, %ymm2
; AVX512F-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: mload_constmask_v4i64:
; SKX:       ## BB#0:
; SKX-NEXT:    movb $9, %al
; SKX-NEXT:    kmovw %eax, %k1
; SKX-NEXT:    vmovdqu64 (%rdi), %ymm0 {%k1}
; SKX-NEXT:    retq
  %res = call <4 x i64> @llvm.masked.load.v4i64(<4 x i64>* %addr, i32 4, <4 x i1> <i1 1, i1 0, i1 0, i1 1>, <4 x i64> %dst)
  ret <4 x i64> %res
}

; 512-bit FP vectors are supported with AVX512.

define <8 x double> @mload_constmask_v8f64(<8 x double>* %addr, <8 x double> %dst) {
; AVX-LABEL: mload_constmask_v8f64:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovapd {{.*#+}} ymm2 = [18446744073709551615,18446744073709551615,18446744073709551615,0]
; AVX-NEXT:    vmaskmovpd (%rdi), %ymm2, %ymm3
; AVX-NEXT:    vblendvpd %ymm2, %ymm3, %ymm0, %ymm0
; AVX-NEXT:    vmovapd {{.*#+}} ymm2 = [0,0,0,18446744073709551615]
; AVX-NEXT:    vmaskmovpd 32(%rdi), %ymm2, %ymm3
; AVX-NEXT:    vblendvpd %ymm2, %ymm3, %ymm1, %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: mload_constmask_v8f64:
; AVX512:       ## BB#0:
; AVX512-NEXT:    movb $-121, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovupd (%rdi), %zmm0 {%k1}
; AVX512-NEXT:    retq
  %res = call <8 x double> @llvm.masked.load.v8f64(<8 x double>* %addr, i32 4, <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 0, i1 0, i1 0, i1 1>, <8 x double> %dst)
  ret <8 x double> %res
}

define void @test21(<4 x i32> %trigger, <4 x i32>* %addr, <4 x i32> %val) {
; AVX1-LABEL: test21:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test21:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test21:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test21:
; SKX:       ## BB#0:
; SKX-NEXT:    kxnorw %k0, %k0, %k1
; SKX-NEXT:    vmovdqu32 %xmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v4i32(<4 x i32>%val, <4 x i32>* %addr, i32 4, <4 x i1><i1 true, i1 true, i1 true, i1 true>)
  ret void
}

;  When only one element of the mask is set, reduce to a scalar store.

define void @one_mask_bit_set1(<4 x i32>* %addr, <4 x i32> %val) {
; AVX-LABEL: one_mask_bit_set1:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovd %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512-LABEL: one_mask_bit_set1:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vmovd %xmm0, (%rdi)
; AVX512-NEXT:    retq
  call void @llvm.masked.store.v4i32(<4 x i32> %val, <4 x i32>* %addr, i32 4, <4 x i1><i1 true, i1 false, i1 false, i1 false>)
  ret void
}

; Choose a different element to show that the correct address offset is produced.

define void @one_mask_bit_set2(<4 x float>* %addr, <4 x float> %val) {
; AVX-LABEL: one_mask_bit_set2:
; AVX:       ## BB#0:
; AVX-NEXT:    vextractps $2, %xmm0, 8(%rdi)
; AVX-NEXT:    retq
;
; AVX512-LABEL: one_mask_bit_set2:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vextractps $2, %xmm0, 8(%rdi)
; AVX512-NEXT:    retq
  call void @llvm.masked.store.v4f32(<4 x float> %val, <4 x float>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>)
  ret void
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define void @one_mask_bit_set3(<4 x i64>* %addr, <4 x i64> %val) {
; AVX-LABEL: one_mask_bit_set3:
; AVX:       ## BB#0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vmovlps %xmm0, 16(%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX512-LABEL: one_mask_bit_set3:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vmovq %xmm0, 16(%rdi)
; AVX512-NEXT:    retq
  call void @llvm.masked.store.v4i64(<4 x i64> %val, <4 x i64>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>)
  ret void
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define void @one_mask_bit_set4(<4 x double>* %addr, <4 x double> %val) {
; AVX-LABEL: one_mask_bit_set4:
; AVX:       ## BB#0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vmovhpd %xmm0, 24(%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX512-LABEL: one_mask_bit_set4:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vmovhpd %xmm0, 24(%rdi)
; AVX512-NEXT:    retq
  call void @llvm.masked.store.v4f64(<4 x double> %val, <4 x double>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 false, i1 true>)
  ret void
}

; Try a 512-bit vector to make sure AVX doesn't die and AVX512 works as expected.

define void @one_mask_bit_set5(<8 x double>* %addr, <8 x double> %val) {
; AVX-LABEL: one_mask_bit_set5:
; AVX:       ## BB#0:
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX-NEXT:    vmovlps %xmm0, 48(%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX512-LABEL: one_mask_bit_set5:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vextractf32x4 $3, %zmm0, %xmm0
; AVX512-NEXT:    vmovlpd %xmm0, 48(%rdi)
; AVX512-NEXT:    retq
  call void @llvm.masked.store.v8f64(<8 x double> %val, <8 x double>* %addr, i32 4, <8 x i1><i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true, i1 false>)
  ret void
}

;  When only one element of the mask is set, reduce to a scalar load.

define <4 x i32> @load_one_mask_bit_set1(<4 x i32>* %addr, <4 x i32> %val) {
; AVX-LABEL: load_one_mask_bit_set1:
; AVX:       ## BB#0:
; AVX-NEXT:    vpinsrd $0, (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_one_mask_bit_set1:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpinsrd $0, (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %res = call <4 x i32> @llvm.masked.load.v4i32(<4 x i32>* %addr, i32 4, <4 x i1><i1 true, i1 false, i1 false, i1 false>, <4 x i32> %val)
  ret <4 x i32> %res
}

; Choose a different element to show that the correct address offset is produced.

define <4 x float> @load_one_mask_bit_set2(<4 x float>* %addr, <4 x float> %val) {
; AVX-LABEL: load_one_mask_bit_set2:
; AVX:       ## BB#0:
; AVX-NEXT:    vinsertps $32, 8(%rdi), %xmm0, %xmm0 ## xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_one_mask_bit_set2:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vinsertps $32, 8(%rdi), %xmm0, %xmm0 ## xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX512-NEXT:    retq
  %res = call <4 x float> @llvm.masked.load.v4f32(<4 x float>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>, <4 x float> %val)
  ret <4 x float> %res
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define <4 x i64> @load_one_mask_bit_set3(<4 x i64>* %addr, <4 x i64> %val) {
; AVX1-LABEL: load_one_mask_bit_set3:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_one_mask_bit_set3:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_one_mask_bit_set3:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: load_one_mask_bit_set3:
; SKX:       ## BB#0:
; SKX-NEXT:    vextracti128 $1, %ymm0, %xmm1
; SKX-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; SKX-NEXT:    vinserti32x4 $1, %xmm1, %ymm0, %ymm0
; SKX-NEXT:    retq
  %res = call <4 x i64> @llvm.masked.load.v4i64(<4 x i64>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>, <4 x i64> %val)
  ret <4 x i64> %res
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define <4 x double> @load_one_mask_bit_set4(<4 x double>* %addr, <4 x double> %val) {
; AVX-LABEL: load_one_mask_bit_set4:
; AVX:       ## BB#0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vmovhpd 24(%rdi), %xmm1, %xmm1  ## xmm1 = xmm1[0],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: load_one_mask_bit_set4:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vmovhpd 24(%rdi), %xmm1, %xmm1  ## xmm1 = xmm1[0],mem[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; SKX-LABEL: load_one_mask_bit_set4:
; SKX:       ## BB#0:
; SKX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; SKX-NEXT:    vmovhpd 24(%rdi), %xmm1, %xmm1  ## xmm1 = xmm1[0],mem[0]
; SKX-NEXT:    vinsertf32x4 $1, %xmm1, %ymm0, %ymm0
; SKX-NEXT:    retq
  %res = call <4 x double> @llvm.masked.load.v4f64(<4 x double>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 false, i1 true>, <4 x double> %val)
  ret <4 x double> %res
}

; Try a 512-bit vector to make sure AVX doesn't die and AVX512 works as expected.

define <8 x double> @load_one_mask_bit_set5(<8 x double>* %addr, <8 x double> %val) {
; AVX-LABEL: load_one_mask_bit_set5:
; AVX:       ## BB#0:
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_one_mask_bit_set5:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vextractf32x4 $3, %zmm0, %xmm1
; AVX512-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512-NEXT:    vinsertf32x4 $3, %xmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <8 x double> @llvm.masked.load.v8f64(<8 x double>* %addr, i32 4, <8 x i1><i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true>, <8 x double> %val)
  ret <8 x double> %res
}

declare <16 x i32> @llvm.masked.load.v16i32(<16 x i32>*, i32, <16 x i1>, <16 x i32>)
declare <4 x i32> @llvm.masked.load.v4i32(<4 x i32>*, i32, <4 x i1>, <4 x i32>)
declare <2 x i32> @llvm.masked.load.v2i32(<2 x i32>*, i32, <2 x i1>, <2 x i32>)
declare <4 x i64> @llvm.masked.load.v4i64(<4 x i64>*, i32, <4 x i1>, <4 x i64>)
declare void @llvm.masked.store.v16i32(<16 x i32>, <16 x i32>*, i32, <16 x i1>)
declare void @llvm.masked.store.v8i32(<8 x i32>, <8 x i32>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4i32(<4 x i32>, <4 x i32>*, i32, <4 x i1>)
declare void @llvm.masked.store.v4i64(<4 x i64>, <4 x i64>*, i32, <4 x i1>)
declare void @llvm.masked.store.v2f32(<2 x float>, <2 x float>*, i32, <2 x i1>)
declare void @llvm.masked.store.v2i32(<2 x i32>, <2 x i32>*, i32, <2 x i1>)
declare void @llvm.masked.store.v4f32(<4 x float>, <4 x float>*, i32, <4 x i1>)
declare void @llvm.masked.store.v16f32(<16 x float>, <16 x float>*, i32, <16 x i1>)
declare void @llvm.masked.store.v16f32p(<16 x float>*, <16 x float>**, i32, <16 x i1>)
declare <16 x float> @llvm.masked.load.v16f32(<16 x float>*, i32, <16 x i1>, <16 x float>)
declare <8 x float> @llvm.masked.load.v8f32(<8 x float>*, i32, <8 x i1>, <8 x float>)
declare <8 x i32> @llvm.masked.load.v8i32(<8 x i32>*, i32, <8 x i1>, <8 x i32>)
declare <4 x float> @llvm.masked.load.v4f32(<4 x float>*, i32, <4 x i1>, <4 x float>)
declare <2 x float> @llvm.masked.load.v2f32(<2 x float>*, i32, <2 x i1>, <2 x float>)
declare <8 x double> @llvm.masked.load.v8f64(<8 x double>*, i32, <8 x i1>, <8 x double>)
declare <4 x double> @llvm.masked.load.v4f64(<4 x double>*, i32, <4 x i1>, <4 x double>)
declare <2 x double> @llvm.masked.load.v2f64(<2 x double>*, i32, <2 x i1>, <2 x double>)
declare void @llvm.masked.store.v8f64(<8 x double>, <8 x double>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4f64(<4 x double>, <4 x double>*, i32, <4 x i1>)
declare void @llvm.masked.store.v2f64(<2 x double>, <2 x double>*, i32, <2 x i1>)
declare void @llvm.masked.store.v2i64(<2 x i64>, <2 x i64>*, i32, <2 x i1>)

declare <16 x i32*> @llvm.masked.load.v16p0i32(<16 x i32*>*, i32, <16 x i1>, <16 x i32*>)

define <16 x i32*> @test23(<16 x i32*> %trigger, <16 x i32*>* %addr) {
; AVX1-LABEL: test23:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:    vmaskmovpd 96(%rdi), %ymm3, %ymm3
; AVX1-NEXT:    vmaskmovpd 64(%rdi), %ymm2, %ymm2
; AVX1-NEXT:    vmaskmovpd 32(%rdi), %ymm1, %ymm1
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test23:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpxor %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqq %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqq %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqq %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpmaskmovq 96(%rdi), %ymm3, %ymm3
; AVX2-NEXT:    vpmaskmovq 64(%rdi), %ymm2, %ymm2
; AVX2-NEXT:    vpmaskmovq 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vpmaskmovq (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test23:
; AVX512:       ## BB#0:
; AVX512-NEXT:    vpxord %zmm2, %zmm2, %zmm2
; AVX512-NEXT:    vpcmpeqq %zmm2, %zmm0, %k1
; AVX512-NEXT:    vpcmpeqq %zmm2, %zmm1, %k2
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm1 {%k2} {z}
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm0 {%k1} {z}
; AVX512-NEXT:    retq
  %mask = icmp eq <16 x i32*> %trigger, zeroinitializer
  %res = call <16 x i32*> @llvm.masked.load.v16p0i32(<16 x i32*>* %addr, i32 4, <16 x i1>%mask, <16 x i32*>zeroinitializer)
  ret <16 x i32*> %res
}

%mystruct = type { i16, i16, [1 x i8*] }

declare <16 x %mystruct*> @llvm.masked.load.v16p0mystruct(<16 x %mystruct*>*, i32, <16 x i1>, <16 x %mystruct*>)

define <16 x %mystruct*> @test24(<16 x i1> %mask, <16 x %mystruct*>* %addr) {
; AVX1-LABEL: test24:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm1, %ymm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmaskmovpd 96(%rdi), %ymm1, %ymm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmaskmovpd 64(%rdi), %ymm1, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovpd 32(%rdi), %ymm0, %ymm1
; AVX1-NEXT:    vmovapd %ymm4, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test24:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpmaskmovq (%rdi), %ymm1, %ymm4
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpmaskmovq 96(%rdi), %ymm1, %ymm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpmaskmovq 64(%rdi), %ymm1, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpmaskmovq 32(%rdi), %ymm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm4, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test24:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqu64 (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    kshiftrw $8, %k1, %k1
; AVX512F-NEXT:    vmovdqu64 64(%rdi), %zmm1 {%k1} {z}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test24:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu64 (%rdi), %zmm0 {%k1} {z}
; SKX-NEXT:    kshiftrw $8, %k1, %k1
; SKX-NEXT:    vmovdqu64 64(%rdi), %zmm1 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <16 x %mystruct*> @llvm.masked.load.v16p0mystruct(<16 x %mystruct*>* %addr, i32 4, <16 x i1>%mask, <16 x %mystruct*>zeroinitializer)
  ret <16 x %mystruct*> %res
}

define void @test_store_16i64(<16 x i64>* %ptrs, <16 x i1> %mask, <16 x i64> %src0)  {
; AVX1-LABEL: test_store_16i64:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX1-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-NEXT:    vmaskmovpd %ymm1, %ymm5, (%rdi)
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX1-NEXT:    vmaskmovpd %ymm4, %ymm1, 96(%rdi)
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm4, %ymm1
; AVX1-NEXT:    vmaskmovpd %ymm3, %ymm1, 64(%rdi)
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovpd %ymm2, %ymm0, 32(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_store_16i64:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX2-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxdq %xmm5, %ymm5
; AVX2-NEXT:    vpmaskmovq %ymm1, %ymm5, (%rdi)
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpmaskmovq %ymm4, %ymm1, 96(%rdi)
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpmaskmovq %ymm3, %ymm1, 64(%rdi)
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpmaskmovq %ymm2, %ymm0, 32(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_store_16i64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqu64 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    kshiftrw $8, %k1, %k1
; AVX512F-NEXT:    vmovdqu64 %zmm2, 64(%rdi) {%k1}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test_store_16i64:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu64 %zmm1, (%rdi) {%k1}
; SKX-NEXT:    kshiftrw $8, %k1, %k1
; SKX-NEXT:    vmovdqu64 %zmm2, 64(%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v16i64(<16 x i64> %src0, <16 x i64>* %ptrs, i32 4, <16 x i1> %mask)
  ret void
}
declare void @llvm.masked.store.v16i64(<16 x i64> %src0, <16 x i64>* %ptrs, i32, <16 x i1> %mask)

define void @test_store_16f64(<16 x double>* %ptrs, <16 x i1> %mask, <16 x double> %src0)  {
; AVX1-LABEL: test_store_16f64:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX1-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-NEXT:    vmaskmovpd %ymm1, %ymm5, (%rdi)
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX1-NEXT:    vmaskmovpd %ymm4, %ymm1, 96(%rdi)
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm4, %ymm1
; AVX1-NEXT:    vmaskmovpd %ymm3, %ymm1, 64(%rdi)
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovpd %ymm2, %ymm0, 32(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_store_16f64:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX2-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxdq %xmm5, %ymm5
; AVX2-NEXT:    vmaskmovpd %ymm1, %ymm5, (%rdi)
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vmaskmovpd %ymm4, %ymm1, 96(%rdi)
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vmaskmovpd %ymm3, %ymm1, 64(%rdi)
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd %ymm2, %ymm0, 32(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_store_16f64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovupd %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    kshiftrw $8, %k1, %k1
; AVX512F-NEXT:    vmovupd %zmm2, 64(%rdi) {%k1}
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test_store_16f64:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovupd %zmm1, (%rdi) {%k1}
; SKX-NEXT:    kshiftrw $8, %k1, %k1
; SKX-NEXT:    vmovupd %zmm2, 64(%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v16f64(<16 x double> %src0, <16 x double>* %ptrs, i32 4, <16 x i1> %mask)
  ret void
}
declare void @llvm.masked.store.v16f64(<16 x double> %src0, <16 x double>* %ptrs, i32, <16 x i1> %mask)

define <16 x i64> @test_load_16i64(<16 x i64>* %ptrs, <16 x i1> %mask, <16 x i64> %src0)  {
; AVX1-LABEL: test_load_16i64:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX1-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm5, %ymm6
; AVX1-NEXT:    vblendvpd %ymm5, %ymm6, %ymm1, %ymm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm6, %ymm1
; AVX1-NEXT:    vmaskmovpd 32(%rdi), %ymm1, %ymm6
; AVX1-NEXT:    vblendvpd %ymm1, %ymm6, %ymm2, %ymm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm6, %ymm2
; AVX1-NEXT:    vmaskmovpd 64(%rdi), %ymm2, %ymm6
; AVX1-NEXT:    vblendvpd %ymm2, %ymm6, %ymm3, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vmaskmovpd 96(%rdi), %ymm0, %ymm3
; AVX1-NEXT:    vblendvpd %ymm0, %ymm3, %ymm4, %ymm3
; AVX1-NEXT:    vmovapd %ymm5, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_load_16i64:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX2-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxdq %xmm5, %ymm5
; AVX2-NEXT:    vpmaskmovq (%rdi), %ymm5, %ymm6
; AVX2-NEXT:    vblendvpd %ymm5, %ymm6, %ymm1, %ymm5
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpmaskmovq 32(%rdi), %ymm1, %ymm6
; AVX2-NEXT:    vblendvpd %ymm1, %ymm6, %ymm2, %ymm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX2-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX2-NEXT:    vpmovsxdq %xmm2, %ymm2
; AVX2-NEXT:    vpmaskmovq 64(%rdi), %ymm2, %ymm6
; AVX2-NEXT:    vblendvpd %ymm2, %ymm6, %ymm3, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vpmaskmovq 96(%rdi), %ymm0, %ymm3
; AVX2-NEXT:    vblendvpd %ymm0, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vmovapd %ymm5, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_load_16i64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqu64 (%rdi), %zmm1 {%k1}
; AVX512F-NEXT:    kshiftrw $8, %k1, %k1
; AVX512F-NEXT:    vmovdqu64 64(%rdi), %zmm2 {%k1}
; AVX512F-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-NEXT:    vmovaps %zmm2, %zmm1
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test_load_16i64:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu64 (%rdi), %zmm1 {%k1}
; SKX-NEXT:    kshiftrw $8, %k1, %k1
; SKX-NEXT:    vmovdqu64 64(%rdi), %zmm2 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    vmovaps %zmm2, %zmm1
; SKX-NEXT:    retq
  %res = call <16 x i64> @llvm.masked.load.v16i64(<16 x i64>* %ptrs, i32 4, <16 x i1> %mask, <16 x i64> %src0)
  ret <16 x i64> %res
}
declare <16 x i64> @llvm.masked.load.v16i64(<16 x i64>* %ptrs, i32, <16 x i1> %mask, <16 x i64> %src0)

define <16 x double> @test_load_16f64(<16 x double>* %ptrs, <16 x i1> %mask, <16 x double> %src0)  {
; AVX1-LABEL: test_load_16f64:
; AVX1:       ## BB#0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX1-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm5, %ymm6
; AVX1-NEXT:    vblendvpd %ymm5, %ymm6, %ymm1, %ymm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm6, %ymm1
; AVX1-NEXT:    vmaskmovpd 32(%rdi), %ymm1, %ymm6
; AVX1-NEXT:    vblendvpd %ymm1, %ymm6, %ymm2, %ymm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm6, %ymm2
; AVX1-NEXT:    vmaskmovpd 64(%rdi), %ymm2, %ymm6
; AVX1-NEXT:    vblendvpd %ymm2, %ymm6, %ymm3, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vmaskmovpd 96(%rdi), %ymm0, %ymm3
; AVX1-NEXT:    vblendvpd %ymm0, %ymm3, %ymm4, %ymm3
; AVX1-NEXT:    vmovapd %ymm5, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_load_16f64:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX2-NEXT:    vpsrad $31, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxdq %xmm5, %ymm5
; AVX2-NEXT:    vmaskmovpd (%rdi), %ymm5, %ymm6
; AVX2-NEXT:    vblendvpd %ymm5, %ymm6, %ymm1, %ymm5
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vmaskmovpd 32(%rdi), %ymm1, %ymm6
; AVX2-NEXT:    vblendvpd %ymm1, %ymm6, %ymm2, %ymm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX2-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX2-NEXT:    vpmovsxdq %xmm2, %ymm2
; AVX2-NEXT:    vmaskmovpd 64(%rdi), %ymm2, %ymm6
; AVX2-NEXT:    vblendvpd %ymm2, %ymm6, %ymm3, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd 96(%rdi), %ymm0, %ymm3
; AVX2-NEXT:    vblendvpd %ymm0, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vmovapd %ymm5, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_load_16f64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovupd (%rdi), %zmm1 {%k1}
; AVX512F-NEXT:    kshiftrw $8, %k1, %k1
; AVX512F-NEXT:    vmovupd 64(%rdi), %zmm2 {%k1}
; AVX512F-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-NEXT:    vmovaps %zmm2, %zmm1
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test_load_16f64:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovupd (%rdi), %zmm1 {%k1}
; SKX-NEXT:    kshiftrw $8, %k1, %k1
; SKX-NEXT:    vmovupd 64(%rdi), %zmm2 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    vmovaps %zmm2, %zmm1
; SKX-NEXT:    retq
  %res = call <16 x double> @llvm.masked.load.v16f64(<16 x double>* %ptrs, i32 4, <16 x i1> %mask, <16 x double> %src0)
  ret <16 x double> %res
}
declare <16 x double> @llvm.masked.load.v16f64(<16 x double>* %ptrs, i32, <16 x i1> %mask, <16 x double> %src0)

define <32 x double> @test_load_32f64(<32 x double>* %ptrs, <32 x i1> %mask, <32 x double> %src0)  {
; AVX1-LABEL: test_load_32f64:
; AVX1:       ## BB#0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:  Ltmp0:
; AVX1-NEXT:    .cfi_def_cfa_offset 16
; AVX1-NEXT:  Ltmp1:
; AVX1-NEXT:    .cfi_offset %rbp, -16
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:  Ltmp2:
; AVX1-NEXT:    .cfi_def_cfa_register %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $32, %rsp
; AVX1-NEXT:    vmovapd 16(%rbp), %ymm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm9, %xmm9
; AVX1-NEXT:    vpsrad $31, %xmm9, %xmm9
; AVX1-NEXT:    vpmovsxdq %xmm9, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm9, %xmm9
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-NEXT:    vmaskmovpd 32(%rsi), %ymm9, %ymm10
; AVX1-NEXT:    vblendvpd %ymm9, %ymm10, %ymm2, %ymm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm10, %ymm2
; AVX1-NEXT:    vmaskmovpd 64(%rsi), %ymm2, %ymm10
; AVX1-NEXT:    vblendvpd %ymm2, %ymm10, %ymm3, %ymm11
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm10, %ymm2
; AVX1-NEXT:    vmaskmovpd 96(%rsi), %ymm2, %ymm10
; AVX1-NEXT:    vblendvpd %ymm2, %ymm10, %ymm4, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm3, %xmm3
; AVX1-NEXT:    vpsrad $31, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm10, %ymm3
; AVX1-NEXT:    vmaskmovpd 160(%rsi), %ymm3, %ymm10
; AVX1-NEXT:    vblendvpd %ymm3, %ymm10, %ymm6, %ymm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm3, %xmm3
; AVX1-NEXT:    vpsrad $31, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm10, %ymm3
; AVX1-NEXT:    vmaskmovpd 192(%rsi), %ymm3, %ymm10
; AVX1-NEXT:    vblendvpd %ymm3, %ymm10, %ymm7, %ymm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm3, %xmm3
; AVX1-NEXT:    vpsrad $31, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm10
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm10, %ymm3
; AVX1-NEXT:    vmaskmovpd 224(%rsi), %ymm3, %ymm10
; AVX1-NEXT:    vblendvpd %ymm3, %ymm10, %ymm8, %ymm3
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm8, %ymm0
; AVX1-NEXT:    vmaskmovpd (%rsi), %ymm0, %ymm8
; AVX1-NEXT:    vblendvpd %ymm0, %ymm8, %ymm1, %ymm0
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmaskmovpd 128(%rsi), %ymm1, %ymm2
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm5, %ymm1
; AVX1-NEXT:    vmovapd %ymm1, 128(%rdi)
; AVX1-NEXT:    vmovapd %ymm0, (%rdi)
; AVX1-NEXT:    vmovapd %ymm3, 224(%rdi)
; AVX1-NEXT:    vmovapd %ymm7, 192(%rdi)
; AVX1-NEXT:    vmovapd %ymm6, 160(%rdi)
; AVX1-NEXT:    vmovapd %ymm4, 96(%rdi)
; AVX1-NEXT:    vmovapd %ymm11, 64(%rdi)
; AVX1-NEXT:    vmovapd %ymm9, 32(%rdi)
; AVX1-NEXT:    movq %rdi, %rax
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_load_32f64:
; AVX2:       ## BB#0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:  Ltmp0:
; AVX2-NEXT:    .cfi_def_cfa_offset 16
; AVX2-NEXT:  Ltmp1:
; AVX2-NEXT:    .cfi_offset %rbp, -16
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:  Ltmp2:
; AVX2-NEXT:    .cfi_def_cfa_register %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $32, %rsp
; AVX2-NEXT:    vmovapd 16(%rbp), %ymm8
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm9, %xmm9
; AVX2-NEXT:    vpsrad $31, %xmm9, %xmm9
; AVX2-NEXT:    vpmovsxdq %xmm9, %ymm9
; AVX2-NEXT:    vmaskmovpd 32(%rsi), %ymm9, %ymm10
; AVX2-NEXT:    vblendvpd %ymm9, %ymm10, %ymm2, %ymm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX2-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX2-NEXT:    vpmovsxdq %xmm2, %ymm2
; AVX2-NEXT:    vmaskmovpd 64(%rsi), %ymm2, %ymm10
; AVX2-NEXT:    vblendvpd %ymm2, %ymm10, %ymm3, %ymm11
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX2-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX2-NEXT:    vpmovsxdq %xmm2, %ymm2
; AVX2-NEXT:    vmaskmovpd 96(%rsi), %ymm2, %ymm10
; AVX2-NEXT:    vblendvpd %ymm2, %ymm10, %ymm4, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm3, %xmm3
; AVX2-NEXT:    vpsrad $31, %xmm3, %xmm3
; AVX2-NEXT:    vpmovsxdq %xmm3, %ymm3
; AVX2-NEXT:    vmaskmovpd 160(%rsi), %ymm3, %ymm10
; AVX2-NEXT:    vblendvpd %ymm3, %ymm10, %ymm6, %ymm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm6, %xmm6
; AVX2-NEXT:    vpsrad $31, %xmm6, %xmm6
; AVX2-NEXT:    vpmovsxdq %xmm6, %ymm6
; AVX2-NEXT:    vmaskmovpd 192(%rsi), %ymm6, %ymm10
; AVX2-NEXT:    vblendvpd %ymm6, %ymm10, %ymm7, %ymm6
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[3,1,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm7, %xmm7
; AVX2-NEXT:    vpsrad $31, %xmm7, %xmm7
; AVX2-NEXT:    vpmovsxdq %xmm7, %ymm7
; AVX2-NEXT:    vmaskmovpd 224(%rsi), %ymm7, %ymm10
; AVX2-NEXT:    vblendvpd %ymm7, %ymm10, %ymm8, %ymm7
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd (%rsi), %ymm0, %ymm8
; AVX2-NEXT:    vblendvpd %ymm0, %ymm8, %ymm1, %ymm0
; AVX2-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vmaskmovpd 128(%rsi), %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm5, %ymm1
; AVX2-NEXT:    vmovapd %ymm1, 128(%rdi)
; AVX2-NEXT:    vmovapd %ymm0, (%rdi)
; AVX2-NEXT:    vmovapd %ymm7, 224(%rdi)
; AVX2-NEXT:    vmovapd %ymm6, 192(%rdi)
; AVX2-NEXT:    vmovapd %ymm3, 160(%rdi)
; AVX2-NEXT:    vmovapd %ymm4, 96(%rdi)
; AVX2-NEXT:    vmovapd %ymm11, 64(%rdi)
; AVX2-NEXT:    vmovapd %ymm9, 32(%rdi)
; AVX2-NEXT:    movq %rdi, %rax
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_load_32f64:
; AVX512F:       ## BB#0:
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX512F-NEXT:    vpmovsxbd %xmm5, %zmm5
; AVX512F-NEXT:    vpslld $31, %zmm5, %zmm5
; AVX512F-NEXT:    vptestmd %zmm5, %zmm5, %k1
; AVX512F-NEXT:    vmovupd 128(%rdi), %zmm3 {%k1}
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512F-NEXT:    vmovupd (%rdi), %zmm1 {%k2}
; AVX512F-NEXT:    kshiftrw $8, %k1, %k1
; AVX512F-NEXT:    vmovupd 192(%rdi), %zmm4 {%k1}
; AVX512F-NEXT:    kshiftrw $8, %k2, %k1
; AVX512F-NEXT:    vmovupd 64(%rdi), %zmm2 {%k1}
; AVX512F-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-NEXT:    vmovaps %zmm2, %zmm1
; AVX512F-NEXT:    vmovaps %zmm3, %zmm2
; AVX512F-NEXT:    vmovaps %zmm4, %zmm3
; AVX512F-NEXT:    retq
;
; SKX-LABEL: test_load_32f64:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %ymm0, %ymm0
; SKX-NEXT:    vpmovb2m %ymm0, %k1
; SKX-NEXT:    vmovupd (%rdi), %zmm1 {%k1}
; SKX-NEXT:    kshiftrd $16, %k1, %k2
; SKX-NEXT:    vmovupd 128(%rdi), %zmm3 {%k2}
; SKX-NEXT:    kshiftrw $8, %k1, %k1
; SKX-NEXT:    vmovupd 64(%rdi), %zmm2 {%k1}
; SKX-NEXT:    kshiftrw $8, %k2, %k1
; SKX-NEXT:    vmovupd 192(%rdi), %zmm4 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    vmovaps %zmm2, %zmm1
; SKX-NEXT:    vmovaps %zmm3, %zmm2
; SKX-NEXT:    vmovaps %zmm4, %zmm3
; SKX-NEXT:    retq
  %res = call <32 x double> @llvm.masked.load.v32f64(<32 x double>* %ptrs, i32 4, <32 x i1> %mask, <32 x double> %src0)
  ret <32 x double> %res
}
declare <32 x double> @llvm.masked.load.v32f64(<32 x double>* %ptrs, i32, <32 x i1> %mask, <32 x double> %src0)

define <16 x i8> @test_mask_load_16xi8(<16 x i1> %mask, <16 x i8>* %addr, <16 x i8> %val) {
; SKX-LABEL: test_mask_load_16xi8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu8 (%rdi), %xmm0 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <16 x i8> @llvm.masked.load.v16i8(<16 x i8>* %addr, i32 4, <16 x i1>%mask, <16 x i8> undef)
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.masked.load.v16i8(<16 x i8>*, i32, <16 x i1>, <16 x i8>)

define <32 x i8> @test_mask_load_32xi8(<32 x i1> %mask, <32 x i8>* %addr, <32 x i8> %val) {
; SKX-LABEL: test_mask_load_32xi8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %ymm0, %ymm0
; SKX-NEXT:    vpmovb2m %ymm0, %k1
; SKX-NEXT:    vmovdqu8 (%rdi), %ymm0 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <32 x i8> @llvm.masked.load.v32i8(<32 x i8>* %addr, i32 4, <32 x i1>%mask, <32 x i8> zeroinitializer)
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.masked.load.v32i8(<32 x i8>*, i32, <32 x i1>, <32 x i8>)

define <64 x i8> @test_mask_load_64xi8(<64 x i1> %mask, <64 x i8>* %addr, <64 x i8> %val) {
; SKX-LABEL: test_mask_load_64xi8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %zmm0, %zmm0
; SKX-NEXT:    vpmovb2m %zmm0, %k1
; SKX-NEXT:    vmovdqu8 (%rdi), %zmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %res = call <64 x i8> @llvm.masked.load.v64i8(<64 x i8>* %addr, i32 4, <64 x i1>%mask, <64 x i8> %val)
  ret <64 x i8> %res
}
declare <64 x i8> @llvm.masked.load.v64i8(<64 x i8>*, i32, <64 x i1>, <64 x i8>)

define <8 x i16> @test_mask_load_8xi16(<8 x i1> %mask, <8 x i16>* %addr, <8 x i16> %val) {
; SKX-LABEL: test_mask_load_8xi16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $15, %xmm0, %xmm0
; SKX-NEXT:    vpmovw2m %xmm0, %k1
; SKX-NEXT:    vmovdqu16 (%rdi), %xmm0 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <8 x i16> @llvm.masked.load.v8i16(<8 x i16>* %addr, i32 4, <8 x i1>%mask, <8 x i16> undef)
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.masked.load.v8i16(<8 x i16>*, i32, <8 x i1>, <8 x i16>)

define <16 x i16> @test_mask_load_16xi16(<16 x i1> %mask, <16 x i16>* %addr, <16 x i16> %val) {
; SKX-LABEL: test_mask_load_16xi16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu16 (%rdi), %ymm0 {%k1} {z}
; SKX-NEXT:    retq
  %res = call <16 x i16> @llvm.masked.load.v16i16(<16 x i16>* %addr, i32 4, <16 x i1>%mask, <16 x i16> zeroinitializer)
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.masked.load.v16i16(<16 x i16>*, i32, <16 x i1>, <16 x i16>)

define <32 x i16> @test_mask_load_32xi16(<32 x i1> %mask, <32 x i16>* %addr, <32 x i16> %val) {
; SKX-LABEL: test_mask_load_32xi16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %ymm0, %ymm0
; SKX-NEXT:    vpmovb2m %ymm0, %k1
; SKX-NEXT:    vmovdqu16 (%rdi), %zmm1 {%k1}
; SKX-NEXT:    vmovaps %zmm1, %zmm0
; SKX-NEXT:    retq
  %res = call <32 x i16> @llvm.masked.load.v32i16(<32 x i16>* %addr, i32 4, <32 x i1>%mask, <32 x i16> %val)
  ret <32 x i16> %res
}
declare <32 x i16> @llvm.masked.load.v32i16(<32 x i16>*, i32, <32 x i1>, <32 x i16>)

define void @test_mask_store_16xi8(<16 x i1> %mask, <16 x i8>* %addr, <16 x i8> %val) {
; SKX-LABEL: test_mask_store_16xi8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu8 %xmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v16i8(<16 x i8> %val, <16 x i8>* %addr, i32 4, <16 x i1>%mask)
  ret void
}
declare void @llvm.masked.store.v16i8(<16 x i8>, <16 x i8>*, i32, <16 x i1>)

define void @test_mask_store_32xi8(<32 x i1> %mask, <32 x i8>* %addr, <32 x i8> %val) {
; SKX-LABEL: test_mask_store_32xi8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %ymm0, %ymm0
; SKX-NEXT:    vpmovb2m %ymm0, %k1
; SKX-NEXT:    vmovdqu8 %ymm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v32i8(<32 x i8> %val, <32 x i8>* %addr, i32 4, <32 x i1>%mask)
  ret void
}
declare void @llvm.masked.store.v32i8(<32 x i8>, <32 x i8>*, i32, <32 x i1>)

define void @test_mask_store_64xi8(<64 x i1> %mask, <64 x i8>* %addr, <64 x i8> %val) {
; SKX-LABEL: test_mask_store_64xi8:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %zmm0, %zmm0
; SKX-NEXT:    vpmovb2m %zmm0, %k1
; SKX-NEXT:    vmovdqu8 %zmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v64i8(<64 x i8> %val, <64 x i8>* %addr, i32 4, <64 x i1>%mask)
  ret void
}
declare void @llvm.masked.store.v64i8(<64 x i8>, <64 x i8>*, i32, <64 x i1>)

define void @test_mask_store_8xi16(<8 x i1> %mask, <8 x i16>* %addr, <8 x i16> %val) {
; SKX-LABEL: test_mask_store_8xi16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $15, %xmm0, %xmm0
; SKX-NEXT:    vpmovw2m %xmm0, %k1
; SKX-NEXT:    vmovdqu16 %xmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v8i16(<8 x i16> %val, <8 x i16>* %addr, i32 4, <8 x i1>%mask)
  ret void
}
declare void @llvm.masked.store.v8i16(<8 x i16>, <8 x i16>*, i32, <8 x i1>)

define void @test_mask_store_16xi16(<16 x i1> %mask, <16 x i16>* %addr, <16 x i16> %val) {
; SKX-LABEL: test_mask_store_16xi16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %xmm0, %xmm0
; SKX-NEXT:    vpmovb2m %xmm0, %k1
; SKX-NEXT:    vmovdqu16 %ymm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v16i16(<16 x i16> %val, <16 x i16>* %addr, i32 4, <16 x i1>%mask)
  ret void
}
declare void @llvm.masked.store.v16i16(<16 x i16>, <16 x i16>*, i32, <16 x i1>)

define void @test_mask_store_32xi16(<32 x i1> %mask, <32 x i16>* %addr, <32 x i16> %val) {
; SKX-LABEL: test_mask_store_32xi16:
; SKX:       ## BB#0:
; SKX-NEXT:    vpsllw $7, %ymm0, %ymm0
; SKX-NEXT:    vpmovb2m %ymm0, %k1
; SKX-NEXT:    vmovdqu16 %zmm1, (%rdi) {%k1}
; SKX-NEXT:    retq
  call void @llvm.masked.store.v32i16(<32 x i16> %val, <32 x i16>* %addr, i32 4, <32 x i1>%mask)
  ret void
}
declare void @llvm.masked.store.v32i16(<32 x i16>, <32 x i16>*, i32, <32 x i1>)