; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx | FileCheck %s

define <8 x i32> @select00(i32 %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: select00:
; CHECK:       ## BB#0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    cmpl $255, %edi
; CHECK-NEXT:    je LBB0_2
; CHECK-NEXT:  ## BB#1:
; CHECK-NEXT:    vmovaps %ymm0, %ymm1
; CHECK-NEXT:  LBB0_2:
; CHECK-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %cmpres = icmp eq i32 %a, 255
  %selres = select i1 %cmpres, <8 x i32> zeroinitializer, <8 x i32> %b
  %res = xor <8 x i32> %b, %selres
  ret <8 x i32> %res
}

define <4 x i64> @select01(i32 %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: select01:
; CHECK:       ## BB#0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    cmpl $255, %edi
; CHECK-NEXT:    je LBB1_2
; CHECK-NEXT:  ## BB#1:
; CHECK-NEXT:    vmovaps %ymm0, %ymm1
; CHECK-NEXT:  LBB1_2:
; CHECK-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %cmpres = icmp eq i32 %a, 255
  %selres = select i1 %cmpres, <4 x i64> zeroinitializer, <4 x i64> %b
  %res = xor <4 x i64> %b, %selres
  ret <4 x i64> %res
}

