//===-- RegisterContext_mips64.h --------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#ifndef liblldb_RegisterContext_mips64_H_
#define liblldb_RegisterContext_mips64_H_

// GCC and DWARF Register numbers (eRegisterKindGCC & eRegisterKindDWARF)
enum
{
    // GP Registers
    gcc_dwarf_zero_mips = 0,
    gcc_dwarf_r1_mips,
    gcc_dwarf_r2_mips,
    gcc_dwarf_r3_mips,
    gcc_dwarf_r4_mips,
    gcc_dwarf_r5_mips,
    gcc_dwarf_r6_mips,
    gcc_dwarf_r7_mips,
    gcc_dwarf_r8_mips,
    gcc_dwarf_r9_mips,
    gcc_dwarf_r10_mips,
    gcc_dwarf_r11_mips,
    gcc_dwarf_r12_mips,
    gcc_dwarf_r13_mips,
    gcc_dwarf_r14_mips,
    gcc_dwarf_r15_mips,
    gcc_dwarf_r16_mips,
    gcc_dwarf_r17_mips,
    gcc_dwarf_r18_mips,
    gcc_dwarf_r19_mips,
    gcc_dwarf_r20_mips,
    gcc_dwarf_r21_mips,
    gcc_dwarf_r22_mips,
    gcc_dwarf_r23_mips,
    gcc_dwarf_r24_mips,
    gcc_dwarf_r25_mips,
    gcc_dwarf_r26_mips,
    gcc_dwarf_r27_mips,
    gcc_dwarf_gp_mips,
    gcc_dwarf_sp_mips,
    gcc_dwarf_r30_mips,
    gcc_dwarf_ra_mips,
    gcc_dwarf_lo_mips,
    gcc_dwarf_hi_mips,
    gcc_dwarf_pc_mips,
    gcc_dwarf_bad_mips,
    gcc_dwarf_sr_mips,
    gcc_dwarf_cause_mips,
    gcc_dwarf_f0_mips,
    gcc_dwarf_f1_mips,
    gcc_dwarf_f2_mips,
    gcc_dwarf_f3_mips,
    gcc_dwarf_f4_mips,
    gcc_dwarf_f5_mips,
    gcc_dwarf_f6_mips,
    gcc_dwarf_f7_mips,
    gcc_dwarf_f8_mips,
    gcc_dwarf_f9_mips,
    gcc_dwarf_f10_mips,
    gcc_dwarf_f11_mips,
    gcc_dwarf_f12_mips,
    gcc_dwarf_f13_mips,
    gcc_dwarf_f14_mips,
    gcc_dwarf_f15_mips,
    gcc_dwarf_f16_mips,
    gcc_dwarf_f17_mips,
    gcc_dwarf_f18_mips,
    gcc_dwarf_f19_mips,
    gcc_dwarf_f20_mips,
    gcc_dwarf_f21_mips,
    gcc_dwarf_f22_mips,
    gcc_dwarf_f23_mips,
    gcc_dwarf_f24_mips,
    gcc_dwarf_f25_mips,
    gcc_dwarf_f26_mips,
    gcc_dwarf_f27_mips,
    gcc_dwarf_f28_mips,
    gcc_dwarf_f29_mips,
    gcc_dwarf_f30_mips,
    gcc_dwarf_f31_mips,
    gcc_dwarf_fcsr_mips,
    gcc_dwarf_fir_mips,
    gcc_dwarf_ic_mips,
    gcc_dwarf_dummy_mips
};

enum
{
    gcc_dwarf_zero_mips64 = 0,
    gcc_dwarf_r1_mips64,
    gcc_dwarf_r2_mips64,
    gcc_dwarf_r3_mips64,
    gcc_dwarf_r4_mips64,
    gcc_dwarf_r5_mips64,
    gcc_dwarf_r6_mips64,
    gcc_dwarf_r7_mips64,
    gcc_dwarf_r8_mips64,
    gcc_dwarf_r9_mips64,
    gcc_dwarf_r10_mips64,
    gcc_dwarf_r11_mips64,
    gcc_dwarf_r12_mips64,
    gcc_dwarf_r13_mips64,
    gcc_dwarf_r14_mips64,
    gcc_dwarf_r15_mips64,
    gcc_dwarf_r16_mips64,
    gcc_dwarf_r17_mips64,
    gcc_dwarf_r18_mips64,
    gcc_dwarf_r19_mips64,
    gcc_dwarf_r20_mips64,
    gcc_dwarf_r21_mips64,
    gcc_dwarf_r22_mips64,
    gcc_dwarf_r23_mips64,
    gcc_dwarf_r24_mips64,
    gcc_dwarf_r25_mips64,
    gcc_dwarf_r26_mips64,
    gcc_dwarf_r27_mips64,
    gcc_dwarf_gp_mips64,
    gcc_dwarf_sp_mips64,
    gcc_dwarf_r30_mips64,
    gcc_dwarf_ra_mips64,
    gcc_dwarf_sr_mips64,
    gcc_dwarf_lo_mips64,
    gcc_dwarf_hi_mips64,
    gcc_dwarf_bad_mips64,
    gcc_dwarf_cause_mips64,
    gcc_dwarf_pc_mips64,
    gcc_dwarf_f0_mips64,
    gcc_dwarf_f1_mips64,
    gcc_dwarf_f2_mips64,
    gcc_dwarf_f3_mips64,
    gcc_dwarf_f4_mips64,
    gcc_dwarf_f5_mips64,
    gcc_dwarf_f6_mips64,
    gcc_dwarf_f7_mips64,
    gcc_dwarf_f8_mips64,
    gcc_dwarf_f9_mips64,
    gcc_dwarf_f10_mips64,
    gcc_dwarf_f11_mips64,
    gcc_dwarf_f12_mips64,
    gcc_dwarf_f13_mips64,
    gcc_dwarf_f14_mips64,
    gcc_dwarf_f15_mips64,
    gcc_dwarf_f16_mips64,
    gcc_dwarf_f17_mips64,
    gcc_dwarf_f18_mips64,
    gcc_dwarf_f19_mips64,
    gcc_dwarf_f20_mips64,
    gcc_dwarf_f21_mips64,
    gcc_dwarf_f22_mips64,
    gcc_dwarf_f23_mips64,
    gcc_dwarf_f24_mips64,
    gcc_dwarf_f25_mips64,
    gcc_dwarf_f26_mips64,
    gcc_dwarf_f27_mips64,
    gcc_dwarf_f28_mips64,
    gcc_dwarf_f29_mips64,
    gcc_dwarf_f30_mips64,
    gcc_dwarf_f31_mips64,
    gcc_dwarf_fcsr_mips64,
    gcc_dwarf_fir_mips64,
    gcc_dwarf_ic_mips64,
    gcc_dwarf_dummy_mips64
};

// GDB Register numbers (eRegisterKindGDB)
enum
{
    gdb_zero_mips = 0,
    gdb_r1_mips,
    gdb_r2_mips,
    gdb_r3_mips,
    gdb_r4_mips,
    gdb_r5_mips,
    gdb_r6_mips,
    gdb_r7_mips,
    gdb_r8_mips,
    gdb_r9_mips,
    gdb_r10_mips,
    gdb_r11_mips,
    gdb_r12_mips,
    gdb_r13_mips,
    gdb_r14_mips,
    gdb_r15_mips,
    gdb_r16_mips,
    gdb_r17_mips,
    gdb_r18_mips,
    gdb_r19_mips,
    gdb_r20_mips,
    gdb_r21_mips,
    gdb_r22_mips,
    gdb_r23_mips,
    gdb_r24_mips,
    gdb_r25_mips,
    gdb_r26_mips,
    gdb_r27_mips,
    gdb_gp_mips,
    gdb_sp_mips,
    gdb_r30_mips,
    gdb_ra_mips,
    gdb_lo_mips,
    gdb_hi_mips,
    gdb_pc_mips,
    gdb_bad_mips,
    gdb_sr_mips,
    gdb_cause_mips,
    gdb_f0_mips,
    gdb_f1_mips,
    gdb_f2_mips,
    gdb_f3_mips,
    gdb_f4_mips,
    gdb_f5_mips,
    gdb_f6_mips,
    gdb_f7_mips,
    gdb_f8_mips,
    gdb_f9_mips,
    gdb_f10_mips,
    gdb_f11_mips,
    gdb_f12_mips,
    gdb_f13_mips,
    gdb_f14_mips,
    gdb_f15_mips,
    gdb_f16_mips,
    gdb_f17_mips,
    gdb_f18_mips,
    gdb_f19_mips,
    gdb_f20_mips,
    gdb_f21_mips,
    gdb_f22_mips,
    gdb_f23_mips,
    gdb_f24_mips,
    gdb_f25_mips,
    gdb_f26_mips,
    gdb_f27_mips,
    gdb_f28_mips,
    gdb_f29_mips,
    gdb_f30_mips,
    gdb_f31_mips,
    gdb_fcsr_mips,
    gdb_fir_mips,
    gdb_ic_mips,
    gdb_dummy_mips
};

enum
{
    gdb_zero_mips64 = 0,
    gdb_r1_mips64,
    gdb_r2_mips64,
    gdb_r3_mips64,
    gdb_r4_mips64,
    gdb_r5_mips64,
    gdb_r6_mips64,
    gdb_r7_mips64,
    gdb_r8_mips64,
    gdb_r9_mips64,
    gdb_r10_mips64,
    gdb_r11_mips64,
    gdb_r12_mips64,
    gdb_r13_mips64,
    gdb_r14_mips64,
    gdb_r15_mips64,
    gdb_r16_mips64,
    gdb_r17_mips64,
    gdb_r18_mips64,
    gdb_r19_mips64,
    gdb_r20_mips64,
    gdb_r21_mips64,
    gdb_r22_mips64,
    gdb_r23_mips64,
    gdb_r24_mips64,
    gdb_r25_mips64,
    gdb_r26_mips64,
    gdb_r27_mips64,
    gdb_gp_mips64,
    gdb_sp_mips64,
    gdb_r30_mips64,
    gdb_ra_mips64,
    gdb_sr_mips64,
    gdb_lo_mips64,
    gdb_hi_mips64,
    gdb_bad_mips64,
    gdb_cause_mips64,
    gdb_pc_mips64,
    gdb_f0_mips64,
    gdb_f1_mips64,
    gdb_f2_mips64,
    gdb_f3_mips64,
    gdb_f4_mips64,
    gdb_f5_mips64,
    gdb_f6_mips64,
    gdb_f7_mips64,
    gdb_f8_mips64,
    gdb_f9_mips64,
    gdb_f10_mips64,
    gdb_f11_mips64,
    gdb_f12_mips64,
    gdb_f13_mips64,
    gdb_f14_mips64,
    gdb_f15_mips64,
    gdb_f16_mips64,
    gdb_f17_mips64,
    gdb_f18_mips64,
    gdb_f19_mips64,
    gdb_f20_mips64,
    gdb_f21_mips64,
    gdb_f22_mips64,
    gdb_f23_mips64,
    gdb_f24_mips64,
    gdb_f25_mips64,
    gdb_f26_mips64,
    gdb_f27_mips64,
    gdb_f28_mips64,
    gdb_f29_mips64,
    gdb_f30_mips64,
    gdb_f31_mips64,
    gdb_fcsr_mips64,
    gdb_fir_mips64,
    gdb_ic_mips64,
    gdb_dummy_mips64
};

// FP registers
struct FPR_mips
{
    uint64_t    fp_reg[32];
    uint32_t    fcsr;        /* FPU status register */
    uint32_t    fir;        /* FPU control register */
};

#endif // liblldb_RegisterContext_mips64_H_
