// RUN: not llvm-mc -triple x86_64-unknown-unknown -mcpu=knl --show-encoding %s 2> %t.err | FileCheck %s
// RUN: FileCheck --check-prefix=ERR < %t.err %s

// CHECK: vaddpd %zmm6, %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0xc6]
          vaddpd %zmm6, %zmm27, %zmm8

// CHECK: vaddpd %zmm6, %zmm27, %zmm8 {%k7}
// CHECK:  encoding: [0x62,0x71,0xa5,0x47,0x58,0xc6]
          vaddpd %zmm6, %zmm27, %zmm8 {%k7}

// CHECK: vaddpd %zmm6, %zmm27, %zmm8 {%k7} {z}
// CHECK:  encoding: [0x62,0x71,0xa5,0xc7,0x58,0xc6]
          vaddpd %zmm6, %zmm27, %zmm8 {%k7} {z}

// CHECK: vaddpd (%rcx), %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x01]
          vaddpd (%rcx), %zmm27, %zmm8

// CHECK: vaddpd 291(%rax,%r14,8), %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x31,0xa5,0x40,0x58,0x84,0xf0,0x23,0x01,0x00,0x00]
          vaddpd 291(%rax,%r14,8), %zmm27, %zmm8

// CHECK: vaddpd (%rcx){1to8}, %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x01]
          vaddpd (%rcx){1to8}, %zmm27, %zmm8

// CHECK: vaddpd 8128(%rdx), %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x42,0x7f]
          vaddpd 8128(%rdx), %zmm27, %zmm8

// CHECK: vaddpd 8192(%rdx), %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x82,0x00,0x20,0x00,0x00]
          vaddpd 8192(%rdx), %zmm27, %zmm8

// CHECK: vaddpd -8192(%rdx), %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x42,0x80]
          vaddpd -8192(%rdx), %zmm27, %zmm8

// CHECK: vaddpd -8256(%rdx), %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x82,0xc0,0xdf,0xff,0xff]
          vaddpd -8256(%rdx), %zmm27, %zmm8

// CHECK: vaddpd 1016(%rdx){1to8}, %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x42,0x7f]
          vaddpd 1016(%rdx){1to8}, %zmm27, %zmm8

// CHECK: vaddpd 1024(%rdx){1to8}, %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x82,0x00,0x04,0x00,0x00]
          vaddpd 1024(%rdx){1to8}, %zmm27, %zmm8

// CHECK: vaddpd -1024(%rdx){1to8}, %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x42,0x80]
          vaddpd -1024(%rdx){1to8}, %zmm27, %zmm8

// CHECK: vaddpd -1032(%rdx){1to8}, %zmm27, %zmm8
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x82,0xf8,0xfb,0xff,0xff]
          vaddpd -1032(%rdx){1to8}, %zmm27, %zmm8

// CHECK: vaddps %zmm2, %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0xd2]
          vaddps %zmm2, %zmm13, %zmm18

// CHECK: vaddps %zmm2, %zmm13, %zmm18 {%k4}
// CHECK:  encoding: [0x62,0xe1,0x14,0x4c,0x58,0xd2]
          vaddps %zmm2, %zmm13, %zmm18 {%k4}

// CHECK: vaddps %zmm2, %zmm13, %zmm18 {%k4} {z}
// CHECK:  encoding: [0x62,0xe1,0x14,0xcc,0x58,0xd2]
          vaddps %zmm2, %zmm13, %zmm18 {%k4} {z}

// CHECK: vaddps (%rcx), %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x11]
          vaddps (%rcx), %zmm13, %zmm18

// CHECK: vaddps 291(%rax,%r14,8), %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x14,0x48,0x58,0x94,0xf0,0x23,0x01,0x00,0x00]
          vaddps 291(%rax,%r14,8), %zmm13, %zmm18

// CHECK: vaddps (%rcx){1to16}, %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x11]
          vaddps (%rcx){1to16}, %zmm13, %zmm18

// CHECK: vaddps 8128(%rdx), %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x52,0x7f]
          vaddps 8128(%rdx), %zmm13, %zmm18

// CHECK: vaddps 8192(%rdx), %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x92,0x00,0x20,0x00,0x00]
          vaddps 8192(%rdx), %zmm13, %zmm18

// CHECK: vaddps -8192(%rdx), %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x52,0x80]
          vaddps -8192(%rdx), %zmm13, %zmm18

// CHECK: vaddps -8256(%rdx), %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x92,0xc0,0xdf,0xff,0xff]
          vaddps -8256(%rdx), %zmm13, %zmm18

// CHECK: vaddps 508(%rdx){1to16}, %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x52,0x7f]
          vaddps 508(%rdx){1to16}, %zmm13, %zmm18

// CHECK: vaddps 512(%rdx){1to16}, %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x92,0x00,0x02,0x00,0x00]
          vaddps 512(%rdx){1to16}, %zmm13, %zmm18

// CHECK: vaddps -512(%rdx){1to16}, %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x52,0x80]
          vaddps -512(%rdx){1to16}, %zmm13, %zmm18

// CHECK: vaddps -516(%rdx){1to16}, %zmm13, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x92,0xfc,0xfd,0xff,0xff]
          vaddps -516(%rdx){1to16}, %zmm13, %zmm18

// CHECK: vdivpd %zmm11, %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xc1,0xcd,0x48,0x5e,0xd3]
          vdivpd %zmm11, %zmm6, %zmm18

// CHECK: vdivpd %zmm11, %zmm6, %zmm18 {%k4}
// CHECK:  encoding: [0x62,0xc1,0xcd,0x4c,0x5e,0xd3]
          vdivpd %zmm11, %zmm6, %zmm18 {%k4}

// CHECK: vdivpd %zmm11, %zmm6, %zmm18 {%k4} {z}
// CHECK:  encoding: [0x62,0xc1,0xcd,0xcc,0x5e,0xd3]
          vdivpd %zmm11, %zmm6, %zmm18 {%k4} {z}

// CHECK: vdivpd (%rcx), %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x11]
          vdivpd (%rcx), %zmm6, %zmm18

// CHECK: vdivpd 291(%rax,%r14,8), %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xa1,0xcd,0x48,0x5e,0x94,0xf0,0x23,0x01,0x00,0x00]
          vdivpd 291(%rax,%r14,8), %zmm6, %zmm18

// CHECK: vdivpd (%rcx){1to8}, %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x11]
          vdivpd (%rcx){1to8}, %zmm6, %zmm18

// CHECK: vdivpd 8128(%rdx), %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x52,0x7f]
          vdivpd 8128(%rdx), %zmm6, %zmm18

// CHECK: vdivpd 8192(%rdx), %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x92,0x00,0x20,0x00,0x00]
          vdivpd 8192(%rdx), %zmm6, %zmm18

// CHECK: vdivpd -8192(%rdx), %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x52,0x80]
          vdivpd -8192(%rdx), %zmm6, %zmm18

// CHECK: vdivpd -8256(%rdx), %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x92,0xc0,0xdf,0xff,0xff]
          vdivpd -8256(%rdx), %zmm6, %zmm18

// CHECK: vdivpd 1016(%rdx){1to8}, %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x52,0x7f]
          vdivpd 1016(%rdx){1to8}, %zmm6, %zmm18

// CHECK: vdivpd 1024(%rdx){1to8}, %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x92,0x00,0x04,0x00,0x00]
          vdivpd 1024(%rdx){1to8}, %zmm6, %zmm18

// CHECK: vdivpd -1024(%rdx){1to8}, %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x52,0x80]
          vdivpd -1024(%rdx){1to8}, %zmm6, %zmm18

// CHECK: vdivpd -1032(%rdx){1to8}, %zmm6, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x92,0xf8,0xfb,0xff,0xff]
          vdivpd -1032(%rdx){1to8}, %zmm6, %zmm18

// CHECK: vdivps %zmm28, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0x81,0x44,0x40,0x5e,0xfc]
          vdivps %zmm28, %zmm23, %zmm23

// CHECK: vdivps %zmm28, %zmm23, %zmm23 {%k2}
// CHECK:  encoding: [0x62,0x81,0x44,0x42,0x5e,0xfc]
          vdivps %zmm28, %zmm23, %zmm23 {%k2}

// CHECK: vdivps %zmm28, %zmm23, %zmm23 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x44,0xc2,0x5e,0xfc]
          vdivps %zmm28, %zmm23, %zmm23 {%k2} {z}

// CHECK: vdivps (%rcx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0x39]
          vdivps (%rcx), %zmm23, %zmm23

// CHECK: vdivps 291(%rax,%r14,8), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x44,0x40,0x5e,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vdivps 291(%rax,%r14,8), %zmm23, %zmm23

// CHECK: vdivps (%rcx){1to16}, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0x39]
          vdivps (%rcx){1to16}, %zmm23, %zmm23

// CHECK: vdivps 8128(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0x7a,0x7f]
          vdivps 8128(%rdx), %zmm23, %zmm23

// CHECK: vdivps 8192(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0xba,0x00,0x20,0x00,0x00]
          vdivps 8192(%rdx), %zmm23, %zmm23

// CHECK: vdivps -8192(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0x7a,0x80]
          vdivps -8192(%rdx), %zmm23, %zmm23

// CHECK: vdivps -8256(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0xba,0xc0,0xdf,0xff,0xff]
          vdivps -8256(%rdx), %zmm23, %zmm23

// CHECK: vdivps 508(%rdx){1to16}, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0x7a,0x7f]
          vdivps 508(%rdx){1to16}, %zmm23, %zmm23

// CHECK: vdivps 512(%rdx){1to16}, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0xba,0x00,0x02,0x00,0x00]
          vdivps 512(%rdx){1to16}, %zmm23, %zmm23

// CHECK: vdivps -512(%rdx){1to16}, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0x7a,0x80]
          vdivps -512(%rdx){1to16}, %zmm23, %zmm23

// CHECK: vdivps -516(%rdx){1to16}, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0xba,0xfc,0xfd,0xff,0xff]
          vdivps -516(%rdx){1to16}, %zmm23, %zmm23

// CHECK: vmaxpd %zmm20, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0x5f,0xf4]
          vmaxpd %zmm20, %zmm28, %zmm30

// CHECK: vmaxpd %zmm20, %zmm28, %zmm30 {%k1}
// CHECK:  encoding: [0x62,0x21,0x9d,0x41,0x5f,0xf4]
          vmaxpd %zmm20, %zmm28, %zmm30 {%k1}

// CHECK: vmaxpd %zmm20, %zmm28, %zmm30 {%k1} {z}
// CHECK:  encoding: [0x62,0x21,0x9d,0xc1,0x5f,0xf4]
          vmaxpd %zmm20, %zmm28, %zmm30 {%k1} {z}

// CHECK: vmaxpd (%rcx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0x31]
          vmaxpd (%rcx), %zmm28, %zmm30

// CHECK: vmaxpd 291(%rax,%r14,8), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0x5f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmaxpd 291(%rax,%r14,8), %zmm28, %zmm30

// CHECK: vmaxpd (%rcx){1to8}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0x31]
          vmaxpd (%rcx){1to8}, %zmm28, %zmm30

// CHECK: vmaxpd 8128(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0x72,0x7f]
          vmaxpd 8128(%rdx), %zmm28, %zmm30

// CHECK: vmaxpd 8192(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0xb2,0x00,0x20,0x00,0x00]
          vmaxpd 8192(%rdx), %zmm28, %zmm30

// CHECK: vmaxpd -8192(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0x72,0x80]
          vmaxpd -8192(%rdx), %zmm28, %zmm30

// CHECK: vmaxpd -8256(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0xb2,0xc0,0xdf,0xff,0xff]
          vmaxpd -8256(%rdx), %zmm28, %zmm30

// CHECK: vmaxpd 1016(%rdx){1to8}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0x72,0x7f]
          vmaxpd 1016(%rdx){1to8}, %zmm28, %zmm30

// CHECK: vmaxpd 1024(%rdx){1to8}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0xb2,0x00,0x04,0x00,0x00]
          vmaxpd 1024(%rdx){1to8}, %zmm28, %zmm30

// CHECK: vmaxpd -1024(%rdx){1to8}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0x72,0x80]
          vmaxpd -1024(%rdx){1to8}, %zmm28, %zmm30

// CHECK: vmaxpd -1032(%rdx){1to8}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0xb2,0xf8,0xfb,0xff,0xff]
          vmaxpd -1032(%rdx){1to8}, %zmm28, %zmm30

// CHECK: vmaxps %zmm20, %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x21,0x4c,0x48,0x5f,0xcc]
          vmaxps %zmm20, %zmm6, %zmm25

// CHECK: vmaxps %zmm20, %zmm6, %zmm25 {%k1}
// CHECK:  encoding: [0x62,0x21,0x4c,0x49,0x5f,0xcc]
          vmaxps %zmm20, %zmm6, %zmm25 {%k1}

// CHECK: vmaxps %zmm20, %zmm6, %zmm25 {%k1} {z}
// CHECK:  encoding: [0x62,0x21,0x4c,0xc9,0x5f,0xcc]
          vmaxps %zmm20, %zmm6, %zmm25 {%k1} {z}

// CHECK: vmaxps (%rcx), %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x09]
          vmaxps (%rcx), %zmm6, %zmm25

// CHECK: vmaxps 291(%rax,%r14,8), %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x21,0x4c,0x48,0x5f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmaxps 291(%rax,%r14,8), %zmm6, %zmm25

// CHECK: vmaxps (%rcx){1to16}, %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x09]
          vmaxps (%rcx){1to16}, %zmm6, %zmm25

// CHECK: vmaxps 8128(%rdx), %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x4a,0x7f]
          vmaxps 8128(%rdx), %zmm6, %zmm25

// CHECK: vmaxps 8192(%rdx), %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x8a,0x00,0x20,0x00,0x00]
          vmaxps 8192(%rdx), %zmm6, %zmm25

// CHECK: vmaxps -8192(%rdx), %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x4a,0x80]
          vmaxps -8192(%rdx), %zmm6, %zmm25

// CHECK: vmaxps -8256(%rdx), %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x8a,0xc0,0xdf,0xff,0xff]
          vmaxps -8256(%rdx), %zmm6, %zmm25

// CHECK: vmaxps 508(%rdx){1to16}, %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x4a,0x7f]
          vmaxps 508(%rdx){1to16}, %zmm6, %zmm25

// CHECK: vmaxps 512(%rdx){1to16}, %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x8a,0x00,0x02,0x00,0x00]
          vmaxps 512(%rdx){1to16}, %zmm6, %zmm25

// CHECK: vmaxps -512(%rdx){1to16}, %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x4a,0x80]
          vmaxps -512(%rdx){1to16}, %zmm6, %zmm25

// CHECK: vmaxps -516(%rdx){1to16}, %zmm6, %zmm25
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x8a,0xfc,0xfd,0xff,0xff]
          vmaxps -516(%rdx){1to16}, %zmm6, %zmm25

// CHECK: vminpd %zmm22, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xb1,0xcd,0x48,0x5d,0xf6]
          vminpd %zmm22, %zmm6, %zmm6

// CHECK: vminpd %zmm22, %zmm6, %zmm6 {%k7}
// CHECK:  encoding: [0x62,0xb1,0xcd,0x4f,0x5d,0xf6]
          vminpd %zmm22, %zmm6, %zmm6 {%k7}

// CHECK: vminpd %zmm22, %zmm6, %zmm6 {%k7} {z}
// CHECK:  encoding: [0x62,0xb1,0xcd,0xcf,0x5d,0xf6]
          vminpd %zmm22, %zmm6, %zmm6 {%k7} {z}

// CHECK: vminpd (%rcx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0x31]
          vminpd (%rcx), %zmm6, %zmm6

// CHECK: vminpd 291(%rax,%r14,8), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xb1,0xcd,0x48,0x5d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vminpd 291(%rax,%r14,8), %zmm6, %zmm6

// CHECK: vminpd (%rcx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0x31]
          vminpd (%rcx){1to8}, %zmm6, %zmm6

// CHECK: vminpd 8128(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0x72,0x7f]
          vminpd 8128(%rdx), %zmm6, %zmm6

// CHECK: vminpd 8192(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0xb2,0x00,0x20,0x00,0x00]
          vminpd 8192(%rdx), %zmm6, %zmm6

// CHECK: vminpd -8192(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0x72,0x80]
          vminpd -8192(%rdx), %zmm6, %zmm6

// CHECK: vminpd -8256(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0xb2,0xc0,0xdf,0xff,0xff]
          vminpd -8256(%rdx), %zmm6, %zmm6

// CHECK: vminpd 1016(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0x72,0x7f]
          vminpd 1016(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vminpd 1024(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0xb2,0x00,0x04,0x00,0x00]
          vminpd 1024(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vminpd -1024(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0x72,0x80]
          vminpd -1024(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vminpd -1032(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0xb2,0xf8,0xfb,0xff,0xff]
          vminpd -1032(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vminps %zmm7, %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0xdf]
          vminps %zmm7, %zmm3, %zmm3

// CHECK: vminps %zmm7, %zmm3, %zmm3 {%k3}
// CHECK:  encoding: [0x62,0xf1,0x64,0x4b,0x5d,0xdf]
          vminps %zmm7, %zmm3, %zmm3 {%k3}

// CHECK: vminps %zmm7, %zmm3, %zmm3 {%k3} {z}
// CHECK:  encoding: [0x62,0xf1,0x64,0xcb,0x5d,0xdf]
          vminps %zmm7, %zmm3, %zmm3 {%k3} {z}

// CHECK: vminps (%rcx), %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x19]
          vminps (%rcx), %zmm3, %zmm3

// CHECK: vminps 291(%rax,%r14,8), %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xb1,0x64,0x48,0x5d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vminps 291(%rax,%r14,8), %zmm3, %zmm3

// CHECK: vminps (%rcx){1to16}, %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x19]
          vminps (%rcx){1to16}, %zmm3, %zmm3

// CHECK: vminps 8128(%rdx), %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x5a,0x7f]
          vminps 8128(%rdx), %zmm3, %zmm3

// CHECK: vminps 8192(%rdx), %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x9a,0x00,0x20,0x00,0x00]
          vminps 8192(%rdx), %zmm3, %zmm3

// CHECK: vminps -8192(%rdx), %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x5a,0x80]
          vminps -8192(%rdx), %zmm3, %zmm3

// CHECK: vminps -8256(%rdx), %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x9a,0xc0,0xdf,0xff,0xff]
          vminps -8256(%rdx), %zmm3, %zmm3

// CHECK: vminps 508(%rdx){1to16}, %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x5a,0x7f]
          vminps 508(%rdx){1to16}, %zmm3, %zmm3

// CHECK: vminps 512(%rdx){1to16}, %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x9a,0x00,0x02,0x00,0x00]
          vminps 512(%rdx){1to16}, %zmm3, %zmm3

// CHECK: vminps -512(%rdx){1to16}, %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x5a,0x80]
          vminps -512(%rdx){1to16}, %zmm3, %zmm3

// CHECK: vminps -516(%rdx){1to16}, %zmm3, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x9a,0xfc,0xfd,0xff,0xff]
          vminps -516(%rdx){1to16}, %zmm3, %zmm3

// CHECK: vmovapd %zmm14, %zmm7
// CHECK:  encoding: [0x62,0xd1,0xfd,0x48,0x28,0xfe]
          vmovapd %zmm14, %zmm7

// CHECK: vmovapd %zmm14, %zmm7 {%k5}
// CHECK:  encoding: [0x62,0xd1,0xfd,0x4d,0x28,0xfe]
          vmovapd %zmm14, %zmm7 {%k5}

// CHECK: vmovapd %zmm14, %zmm7 {%k5} {z}
// CHECK:  encoding: [0x62,0xd1,0xfd,0xcd,0x28,0xfe]
          vmovapd %zmm14, %zmm7 {%k5} {z}

// CHECK: vmovapd (%rcx), %zmm7
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0x39]
          vmovapd (%rcx), %zmm7

// CHECK: vmovapd 291(%rax,%r14,8), %zmm7
// CHECK:  encoding: [0x62,0xb1,0xfd,0x48,0x28,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovapd 291(%rax,%r14,8), %zmm7

// CHECK: vmovapd 8128(%rdx), %zmm7
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0x7a,0x7f]
          vmovapd 8128(%rdx), %zmm7

// CHECK: vmovapd 8192(%rdx), %zmm7
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0xba,0x00,0x20,0x00,0x00]
          vmovapd 8192(%rdx), %zmm7

// CHECK: vmovapd -8192(%rdx), %zmm7
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0x7a,0x80]
          vmovapd -8192(%rdx), %zmm7

// CHECK: vmovapd -8256(%rdx), %zmm7
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0xba,0xc0,0xdf,0xff,0xff]
          vmovapd -8256(%rdx), %zmm7

// CHECK: vmovaps %zmm9, %zmm5
// CHECK:  encoding: [0x62,0xd1,0x7c,0x48,0x28,0xe9]
          vmovaps %zmm9, %zmm5

// CHECK: vmovaps %zmm9, %zmm5 {%k1}
// CHECK:  encoding: [0x62,0xd1,0x7c,0x49,0x28,0xe9]
          vmovaps %zmm9, %zmm5 {%k1}

// CHECK: vmovaps %zmm9, %zmm5 {%k1} {z}
// CHECK:  encoding: [0x62,0xd1,0x7c,0xc9,0x28,0xe9]
          vmovaps %zmm9, %zmm5 {%k1} {z}

// CHECK: vmovaps (%rcx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0x29]
          vmovaps (%rcx), %zmm5

// CHECK: vmovaps 291(%rax,%r14,8), %zmm5
// CHECK:  encoding: [0x62,0xb1,0x7c,0x48,0x28,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovaps 291(%rax,%r14,8), %zmm5

// CHECK: vmovaps 8128(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0x6a,0x7f]
          vmovaps 8128(%rdx), %zmm5

// CHECK: vmovaps 8192(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0xaa,0x00,0x20,0x00,0x00]
          vmovaps 8192(%rdx), %zmm5

// CHECK: vmovaps -8192(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0x6a,0x80]
          vmovaps -8192(%rdx), %zmm5

// CHECK: vmovaps -8256(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0xaa,0xc0,0xdf,0xff,0xff]
          vmovaps -8256(%rdx), %zmm5

// CHECK: vmovdqa32 %zmm18, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x6f,0xf2]
          vmovdqa32 %zmm18, %zmm22

// CHECK: vmovdqa32 %zmm18, %zmm22 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x7d,0x4e,0x6f,0xf2]
          vmovdqa32 %zmm18, %zmm22 {%k6}

// CHECK: vmovdqa32 %zmm18, %zmm22 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x7d,0xce,0x6f,0xf2]
          vmovdqa32 %zmm18, %zmm22 {%k6} {z}

// CHECK: vmovdqa32 (%rcx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x31]
          vmovdqa32 (%rcx), %zmm22

// CHECK: vmovdqa32 291(%rax,%r14,8), %zmm22
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 291(%rax,%r14,8), %zmm22

// CHECK: vmovdqa32 8128(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x72,0x7f]
          vmovdqa32 8128(%rdx), %zmm22

// CHECK: vmovdqa32 8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqa32 8192(%rdx), %zmm22

// CHECK: vmovdqa32 -8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x72,0x80]
          vmovdqa32 -8192(%rdx), %zmm22

// CHECK: vmovdqa32 -8256(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqa32 -8256(%rdx), %zmm22

// CHECK: vmovdqa64 %zmm12, %zmm22
// CHECK:  encoding: [0x62,0xc1,0xfd,0x48,0x6f,0xf4]
          vmovdqa64 %zmm12, %zmm22

// CHECK: vmovdqa64 %zmm12, %zmm22 {%k5}
// CHECK:  encoding: [0x62,0xc1,0xfd,0x4d,0x6f,0xf4]
          vmovdqa64 %zmm12, %zmm22 {%k5}

// CHECK: vmovdqa64 %zmm12, %zmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0xc1,0xfd,0xcd,0x6f,0xf4]
          vmovdqa64 %zmm12, %zmm22 {%k5} {z}

// CHECK: vmovdqa64 (%rcx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x31]
          vmovdqa64 (%rcx), %zmm22

// CHECK: vmovdqa64 291(%rax,%r14,8), %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 291(%rax,%r14,8), %zmm22

// CHECK: vmovdqa64 8128(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x72,0x7f]
          vmovdqa64 8128(%rdx), %zmm22

// CHECK: vmovdqa64 8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqa64 8192(%rdx), %zmm22

// CHECK: vmovdqa64 -8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x72,0x80]
          vmovdqa64 -8192(%rdx), %zmm22

// CHECK: vmovdqa64 -8256(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqa64 -8256(%rdx), %zmm22

// CHECK: vmovdqu32 %zmm24, %zmm5
// CHECK:  encoding: [0x62,0x91,0x7e,0x48,0x6f,0xe8]
          vmovdqu32 %zmm24, %zmm5

// CHECK: vmovdqu32 %zmm24, %zmm5 {%k5}
// CHECK:  encoding: [0x62,0x91,0x7e,0x4d,0x6f,0xe8]
          vmovdqu32 %zmm24, %zmm5 {%k5}

// CHECK: vmovdqu32 %zmm24, %zmm5 {%k5} {z}
// CHECK:  encoding: [0x62,0x91,0x7e,0xcd,0x6f,0xe8]
          vmovdqu32 %zmm24, %zmm5 {%k5} {z}

// CHECK: vmovdqu32 (%rcx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x29]
          vmovdqu32 (%rcx), %zmm5

// CHECK: vmovdqu32 291(%rax,%r14,8), %zmm5
// CHECK:  encoding: [0x62,0xb1,0x7e,0x48,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 291(%rax,%r14,8), %zmm5

// CHECK: vmovdqu32 8128(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x6a,0x7f]
          vmovdqu32 8128(%rdx), %zmm5

// CHECK: vmovdqu32 8192(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0xaa,0x00,0x20,0x00,0x00]
          vmovdqu32 8192(%rdx), %zmm5

// CHECK: vmovdqu32 -8192(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x6a,0x80]
          vmovdqu32 -8192(%rdx), %zmm5

// CHECK: vmovdqu32 -8256(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0xaa,0xc0,0xdf,0xff,0xff]
          vmovdqu32 -8256(%rdx), %zmm5

// CHECK: vmovdqu64 %zmm15, %zmm6
// CHECK:  encoding: [0x62,0xd1,0xfe,0x48,0x6f,0xf7]
          vmovdqu64 %zmm15, %zmm6

// CHECK: vmovdqu64 %zmm15, %zmm6 {%k3}
// CHECK:  encoding: [0x62,0xd1,0xfe,0x4b,0x6f,0xf7]
          vmovdqu64 %zmm15, %zmm6 {%k3}

// CHECK: vmovdqu64 %zmm15, %zmm6 {%k3} {z}
// CHECK:  encoding: [0x62,0xd1,0xfe,0xcb,0x6f,0xf7]
          vmovdqu64 %zmm15, %zmm6 {%k3} {z}

// CHECK: vmovdqu64 (%rcx), %zmm6
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0x31]
          vmovdqu64 (%rcx), %zmm6

// CHECK: vmovdqu64 291(%rax,%r14,8), %zmm6
// CHECK:  encoding: [0x62,0xb1,0xfe,0x48,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 291(%rax,%r14,8), %zmm6

// CHECK: vmovdqu64 8128(%rdx), %zmm6
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0x72,0x7f]
          vmovdqu64 8128(%rdx), %zmm6

// CHECK: vmovdqu64 8192(%rdx), %zmm6
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqu64 8192(%rdx), %zmm6

// CHECK: vmovdqu64 -8192(%rdx), %zmm6
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0x72,0x80]
          vmovdqu64 -8192(%rdx), %zmm6

// CHECK: vmovdqu64 -8256(%rdx), %zmm6
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqu64 -8256(%rdx), %zmm6

// CHECK: vmovntdq %zmm24, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x01]
          vmovntdq %zmm24, (%rcx)

// CHECK: vmovntdq %zmm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7d,0x48,0xe7,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovntdq %zmm24, 291(%rax,%r14,8)

// CHECK: vmovntdq %zmm24, 8128(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x42,0x7f]
          vmovntdq %zmm24, 8128(%rdx)

// CHECK: vmovntdq %zmm24, 8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x82,0x00,0x20,0x00,0x00]
          vmovntdq %zmm24, 8192(%rdx)

// CHECK: vmovntdq %zmm24, -8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x42,0x80]
          vmovntdq %zmm24, -8192(%rdx)

// CHECK: vmovntdq %zmm24, -8256(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x82,0xc0,0xdf,0xff,0xff]
          vmovntdq %zmm24, -8256(%rdx)

// CHECK: vmovntdqa (%rcx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x09]
          vmovntdqa (%rcx), %zmm17

// CHECK: vmovntdqa 291(%rax,%r14,8), %zmm17
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x2a,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovntdqa 291(%rax,%r14,8), %zmm17

// CHECK: vmovntdqa 8128(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x4a,0x7f]
          vmovntdqa 8128(%rdx), %zmm17

// CHECK: vmovntdqa 8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x8a,0x00,0x20,0x00,0x00]
          vmovntdqa 8192(%rdx), %zmm17

// CHECK: vmovntdqa -8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x4a,0x80]
          vmovntdqa -8192(%rdx), %zmm17

// CHECK: vmovntdqa -8256(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x8a,0xc0,0xdf,0xff,0xff]
          vmovntdqa -8256(%rdx), %zmm17

// CHECK: vmovntpd %zmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x09]
          vmovntpd %zmm17, (%rcx)

// CHECK: vmovntpd %zmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x2b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovntpd %zmm17, 291(%rax,%r14,8)

// CHECK: vmovntpd %zmm17, 8128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x4a,0x7f]
          vmovntpd %zmm17, 8128(%rdx)

// CHECK: vmovntpd %zmm17, 8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x8a,0x00,0x20,0x00,0x00]
          vmovntpd %zmm17, 8192(%rdx)

// CHECK: vmovntpd %zmm17, -8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x4a,0x80]
          vmovntpd %zmm17, -8192(%rdx)

// CHECK: vmovntpd %zmm17, -8256(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x8a,0xc0,0xdf,0xff,0xff]
          vmovntpd %zmm17, -8256(%rdx)

// CHECK: vmovntps %zmm5, (%rcx)
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x29]
          vmovntps %zmm5, (%rcx)

// CHECK: vmovntps %zmm5, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb1,0x7c,0x48,0x2b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovntps %zmm5, 291(%rax,%r14,8)

// CHECK: vmovntps %zmm5, 8128(%rdx)
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x6a,0x7f]
          vmovntps %zmm5, 8128(%rdx)

// CHECK: vmovntps %zmm5, 8192(%rdx)
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0xaa,0x00,0x20,0x00,0x00]
          vmovntps %zmm5, 8192(%rdx)

// CHECK: vmovntps %zmm5, -8192(%rdx)
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x6a,0x80]
          vmovntps %zmm5, -8192(%rdx)

// CHECK: vmovntps %zmm5, -8256(%rdx)
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0xaa,0xc0,0xdf,0xff,0xff]
          vmovntps %zmm5, -8256(%rdx)

// CHECK: vmovupd %zmm9, %zmm27
// CHECK:  encoding: [0x62,0x41,0xfd,0x48,0x10,0xd9]
          vmovupd %zmm9, %zmm27

// CHECK: vmovupd %zmm9, %zmm27 {%k2}
// CHECK:  encoding: [0x62,0x41,0xfd,0x4a,0x10,0xd9]
          vmovupd %zmm9, %zmm27 {%k2}

// CHECK: vmovupd %zmm9, %zmm27 {%k2} {z}
// CHECK:  encoding: [0x62,0x41,0xfd,0xca,0x10,0xd9]
          vmovupd %zmm9, %zmm27 {%k2} {z}

// CHECK: vmovupd (%rcx), %zmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x19]
          vmovupd (%rcx), %zmm27

// CHECK: vmovupd 291(%rax,%r14,8), %zmm27
// CHECK:  encoding: [0x62,0x21,0xfd,0x48,0x10,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovupd 291(%rax,%r14,8), %zmm27

// CHECK: vmovupd 8128(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x5a,0x7f]
          vmovupd 8128(%rdx), %zmm27

// CHECK: vmovupd 8192(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x9a,0x00,0x20,0x00,0x00]
          vmovupd 8192(%rdx), %zmm27

// CHECK: vmovupd -8192(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x5a,0x80]
          vmovupd -8192(%rdx), %zmm27

// CHECK: vmovupd -8256(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x9a,0xc0,0xdf,0xff,0xff]
          vmovupd -8256(%rdx), %zmm27

// CHECK: vmovups %zmm22, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x7c,0x48,0x10,0xf6]
          vmovups %zmm22, %zmm22

// CHECK: vmovups %zmm22, %zmm22 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x7c,0x4b,0x10,0xf6]
          vmovups %zmm22, %zmm22 {%k3}

// CHECK: vmovups %zmm22, %zmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x7c,0xcb,0x10,0xf6]
          vmovups %zmm22, %zmm22 {%k3} {z}

// CHECK: vmovups (%rcx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0x31]
          vmovups (%rcx), %zmm22

// CHECK: vmovups 291(%rax,%r14,8), %zmm22
// CHECK:  encoding: [0x62,0xa1,0x7c,0x48,0x10,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovups 291(%rax,%r14,8), %zmm22

// CHECK: vmovups 8128(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0x72,0x7f]
          vmovups 8128(%rdx), %zmm22

// CHECK: vmovups 8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0xb2,0x00,0x20,0x00,0x00]
          vmovups 8192(%rdx), %zmm22

// CHECK: vmovups -8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0x72,0x80]
          vmovups -8192(%rdx), %zmm22

// CHECK: vmovups -8256(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0xb2,0xc0,0xdf,0xff,0xff]
          vmovups -8256(%rdx), %zmm22

// CHECK: vmulpd %zmm23, %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x21,0xdd,0x48,0x59,0xc7]
          vmulpd %zmm23, %zmm4, %zmm24

// CHECK: vmulpd %zmm23, %zmm4, %zmm24 {%k6}
// CHECK:  encoding: [0x62,0x21,0xdd,0x4e,0x59,0xc7]
          vmulpd %zmm23, %zmm4, %zmm24 {%k6}

// CHECK: vmulpd %zmm23, %zmm4, %zmm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0xdd,0xce,0x59,0xc7]
          vmulpd %zmm23, %zmm4, %zmm24 {%k6} {z}

// CHECK: vmulpd (%rcx), %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x01]
          vmulpd (%rcx), %zmm4, %zmm24

// CHECK: vmulpd 291(%rax,%r14,8), %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x21,0xdd,0x48,0x59,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmulpd 291(%rax,%r14,8), %zmm4, %zmm24

// CHECK: vmulpd (%rcx){1to8}, %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x01]
          vmulpd (%rcx){1to8}, %zmm4, %zmm24

// CHECK: vmulpd 8128(%rdx), %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x42,0x7f]
          vmulpd 8128(%rdx), %zmm4, %zmm24

// CHECK: vmulpd 8192(%rdx), %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x82,0x00,0x20,0x00,0x00]
          vmulpd 8192(%rdx), %zmm4, %zmm24

// CHECK: vmulpd -8192(%rdx), %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x42,0x80]
          vmulpd -8192(%rdx), %zmm4, %zmm24

// CHECK: vmulpd -8256(%rdx), %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x82,0xc0,0xdf,0xff,0xff]
          vmulpd -8256(%rdx), %zmm4, %zmm24

// CHECK: vmulpd 1016(%rdx){1to8}, %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x42,0x7f]
          vmulpd 1016(%rdx){1to8}, %zmm4, %zmm24

// CHECK: vmulpd 1024(%rdx){1to8}, %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x82,0x00,0x04,0x00,0x00]
          vmulpd 1024(%rdx){1to8}, %zmm4, %zmm24

// CHECK: vmulpd -1024(%rdx){1to8}, %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x42,0x80]
          vmulpd -1024(%rdx){1to8}, %zmm4, %zmm24

// CHECK: vmulpd -1032(%rdx){1to8}, %zmm4, %zmm24
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x82,0xf8,0xfb,0xff,0xff]
          vmulpd -1032(%rdx){1to8}, %zmm4, %zmm24

// CHECK: vmulps %zmm24, %zmm6, %zmm3
// CHECK:  encoding: [0x62,0x91,0x4c,0x48,0x59,0xd8]
          vmulps %zmm24, %zmm6, %zmm3

// CHECK: vmulps %zmm24, %zmm6, %zmm3 {%k4}
// CHECK:  encoding: [0x62,0x91,0x4c,0x4c,0x59,0xd8]
          vmulps %zmm24, %zmm6, %zmm3 {%k4}

// CHECK: vmulps %zmm24, %zmm6, %zmm3 {%k4} {z}
// CHECK:  encoding: [0x62,0x91,0x4c,0xcc,0x59,0xd8]
          vmulps %zmm24, %zmm6, %zmm3 {%k4} {z}

// CHECK: vmulps (%rcx), %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x19]
          vmulps (%rcx), %zmm6, %zmm3

// CHECK: vmulps 291(%rax,%r14,8), %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xb1,0x4c,0x48,0x59,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmulps 291(%rax,%r14,8), %zmm6, %zmm3

// CHECK: vmulps (%rcx){1to16}, %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x19]
          vmulps (%rcx){1to16}, %zmm6, %zmm3

// CHECK: vmulps 8128(%rdx), %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x5a,0x7f]
          vmulps 8128(%rdx), %zmm6, %zmm3

// CHECK: vmulps 8192(%rdx), %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x9a,0x00,0x20,0x00,0x00]
          vmulps 8192(%rdx), %zmm6, %zmm3

// CHECK: vmulps -8192(%rdx), %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x5a,0x80]
          vmulps -8192(%rdx), %zmm6, %zmm3

// CHECK: vmulps -8256(%rdx), %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x9a,0xc0,0xdf,0xff,0xff]
          vmulps -8256(%rdx), %zmm6, %zmm3

// CHECK: vmulps 508(%rdx){1to16}, %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x5a,0x7f]
          vmulps 508(%rdx){1to16}, %zmm6, %zmm3

// CHECK: vmulps 512(%rdx){1to16}, %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x9a,0x00,0x02,0x00,0x00]
          vmulps 512(%rdx){1to16}, %zmm6, %zmm3

// CHECK: vmulps -512(%rdx){1to16}, %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x5a,0x80]
          vmulps -512(%rdx){1to16}, %zmm6, %zmm3

// CHECK: vmulps -516(%rdx){1to16}, %zmm6, %zmm3
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x9a,0xfc,0xfd,0xff,0xff]
          vmulps -516(%rdx){1to16}, %zmm6, %zmm3

// CHECK: vpabsd %zmm14, %zmm15
// CHECK:  encoding: [0x62,0x52,0x7d,0x48,0x1e,0xfe]
          vpabsd %zmm14, %zmm15

// CHECK: vpabsd %zmm14, %zmm15 {%k6}
// CHECK:  encoding: [0x62,0x52,0x7d,0x4e,0x1e,0xfe]
          vpabsd %zmm14, %zmm15 {%k6}

// CHECK: vpabsd %zmm14, %zmm15 {%k6} {z}
// CHECK:  encoding: [0x62,0x52,0x7d,0xce,0x1e,0xfe]
          vpabsd %zmm14, %zmm15 {%k6} {z}

// CHECK: vpabsd (%rcx), %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0x39]
          vpabsd (%rcx), %zmm15

// CHECK: vpabsd (%rcx), %zmm15 {%k1}
// CHECK:  encoding: [0x62,0x72,0x7d,0x49,0x1e,0x39]
          vpabsd (%rcx), %zmm15 {%k1}

// CHECK: vpabsd (%rcx), %zmm15 {%k1} {z}
// CHECK:  encoding: [0x62,0x72,0x7d,0xc9,0x1e,0x39]
          vpabsd (%rcx), %zmm15 {%k1} {z}

// CHECK: vpabsd 291(%rax,%r14,8), %zmm15
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x1e,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpabsd 291(%rax,%r14,8), %zmm15

// CHECK: vpabsd (%rcx){1to16}, %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0x39]
          vpabsd (%rcx){1to16}, %zmm15

// CHECK: vpabsd 8128(%rdx), %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0x7a,0x7f]
          vpabsd 8128(%rdx), %zmm15

// CHECK: vpabsd 8192(%rdx), %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0xba,0x00,0x20,0x00,0x00]
          vpabsd 8192(%rdx), %zmm15

// CHECK: vpabsd -8192(%rdx), %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0x7a,0x80]
          vpabsd -8192(%rdx), %zmm15

// CHECK: vpabsd -8256(%rdx), %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0xba,0xc0,0xdf,0xff,0xff]
          vpabsd -8256(%rdx), %zmm15

// CHECK: vpabsd 508(%rdx){1to16}, %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0x7a,0x7f]
          vpabsd 508(%rdx){1to16}, %zmm15

// CHECK: vpabsd 512(%rdx){1to16}, %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0xba,0x00,0x02,0x00,0x00]
          vpabsd 512(%rdx){1to16}, %zmm15

// CHECK: vpabsd -512(%rdx){1to16}, %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0x7a,0x80]
          vpabsd -512(%rdx){1to16}, %zmm15

// CHECK: vpabsd -516(%rdx){1to16}, %zmm15
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0xba,0xfc,0xfd,0xff,0xff]
          vpabsd -516(%rdx){1to16}, %zmm15

// CHECK: vpabsd (%rcx){1to16}, %zmm15 {%k2}
// CHECK:  encoding: [0x62,0x72,0x7d,0x5a,0x1e,0x39]
          vpabsd (%rcx){1to16}, %zmm15 {%k2}

// CHECK: vpabsd (%rcx){1to16}, %zmm15 {%k2} {z}
// CHECK:  encoding: [0x62,0x72,0x7d,0xda,0x1e,0x39]
          vpabsd (%rcx){1to16}, %zmm15 {%k2} {z}

// CHECK: vpabsq %zmm24, %zmm5
// CHECK:  encoding: [0x62,0x92,0xfd,0x48,0x1f,0xe8]
          vpabsq %zmm24, %zmm5

// CHECK: vpabsq %zmm24, %zmm5 {%k6}
// CHECK:  encoding: [0x62,0x92,0xfd,0x4e,0x1f,0xe8]
          vpabsq %zmm24, %zmm5 {%k6}

// CHECK: vpabsq %zmm24, %zmm5 {%k6} {z}
// CHECK:  encoding: [0x62,0x92,0xfd,0xce,0x1f,0xe8]
          vpabsq %zmm24, %zmm5 {%k6} {z}

// CHECK: vpabsq (%rcx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x29]
          vpabsq (%rcx), %zmm5

// CHECK: vpabsq 291(%rax,%r14,8), %zmm5
// CHECK:  encoding: [0x62,0xb2,0xfd,0x48,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpabsq 291(%rax,%r14,8), %zmm5

// CHECK: vpabsq (%rcx){1to8}, %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x29]
          vpabsq (%rcx){1to8}, %zmm5

// CHECK: vpabsq 8128(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x6a,0x7f]
          vpabsq 8128(%rdx), %zmm5

// CHECK: vpabsq 8192(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0xaa,0x00,0x20,0x00,0x00]
          vpabsq 8192(%rdx), %zmm5

// CHECK: vpabsq -8192(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x6a,0x80]
          vpabsq -8192(%rdx), %zmm5

// CHECK: vpabsq -8256(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0xaa,0xc0,0xdf,0xff,0xff]
          vpabsq -8256(%rdx), %zmm5

// CHECK: vpabsq 1016(%rdx){1to8}, %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x6a,0x7f]
          vpabsq 1016(%rdx){1to8}, %zmm5

// CHECK: vpabsq 1024(%rdx){1to8}, %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0xaa,0x00,0x04,0x00,0x00]
          vpabsq 1024(%rdx){1to8}, %zmm5

// CHECK: vpabsq -1024(%rdx){1to8}, %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x6a,0x80]
          vpabsq -1024(%rdx){1to8}, %zmm5

// CHECK: vpabsq -1032(%rdx){1to8}, %zmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0xaa,0xf8,0xfb,0xff,0xff]
          vpabsq -1032(%rdx){1to8}, %zmm5

// CHECK: vpaddd %zmm20, %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x21,0x55,0x48,0xfe,0xd4]
          vpaddd %zmm20, %zmm5, %zmm26

// CHECK: vpaddd %zmm20, %zmm5, %zmm26 {%k1}
// CHECK:  encoding: [0x62,0x21,0x55,0x49,0xfe,0xd4]
          vpaddd %zmm20, %zmm5, %zmm26 {%k1}

// CHECK: vpaddd %zmm20, %zmm5, %zmm26 {%k1} {z}
// CHECK:  encoding: [0x62,0x21,0x55,0xc9,0xfe,0xd4]
          vpaddd %zmm20, %zmm5, %zmm26 {%k1} {z}

// CHECK: vpaddd (%rcx), %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x11]
          vpaddd (%rcx), %zmm5, %zmm26

// CHECK: vpaddd (%rcx), %zmm5, %zmm26 {%k2}
// CHECK:  encoding: [0x62,0x61,0x55,0x4a,0xfe,0x11]
          vpaddd (%rcx), %zmm5, %zmm26 {%k2}

// CHECK: vpaddd (%rcx), %zmm5, %zmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x61,0x55,0xca,0xfe,0x11]
          vpaddd (%rcx), %zmm5, %zmm26 {%k2} {z}

// CHECK: vpaddd 291(%rax,%r14,8), %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x21,0x55,0x48,0xfe,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpaddd 291(%rax,%r14,8), %zmm5, %zmm26

// CHECK: vpaddd (%rcx){1to16}, %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x11]
          vpaddd (%rcx){1to16}, %zmm5, %zmm26

// CHECK: vpaddd 8128(%rdx), %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x52,0x7f]
          vpaddd 8128(%rdx), %zmm5, %zmm26

// CHECK: vpaddd 8192(%rdx), %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x92,0x00,0x20,0x00,0x00]
          vpaddd 8192(%rdx), %zmm5, %zmm26

// CHECK: vpaddd -8192(%rdx), %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x52,0x80]
          vpaddd -8192(%rdx), %zmm5, %zmm26

// CHECK: vpaddd -8256(%rdx), %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x92,0xc0,0xdf,0xff,0xff]
          vpaddd -8256(%rdx), %zmm5, %zmm26

// CHECK: vpaddd (%rcx){1to16}, %zmm5, %zmm26 {%k2}
// CHECK:  encoding: [0x62,0x61,0x55,0x5a,0xfe,0x11]
          vpaddd (%rcx){1to16}, %zmm5, %zmm26 {%k2}

// CHECK: vpaddd (%rcx){1to16}, %zmm5, %zmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x61,0x55,0xda,0xfe,0x11]
          vpaddd (%rcx){1to16}, %zmm5, %zmm26 {%k2} {z}

// CHECK: vpaddd 508(%rdx){1to16}, %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x52,0x7f]
          vpaddd 508(%rdx){1to16}, %zmm5, %zmm26

// CHECK: vpaddd 512(%rdx){1to16}, %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x92,0x00,0x02,0x00,0x00]
          vpaddd 512(%rdx){1to16}, %zmm5, %zmm26

// CHECK: vpaddd -512(%rdx){1to16}, %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x52,0x80]
          vpaddd -512(%rdx){1to16}, %zmm5, %zmm26

// CHECK: vpaddd -516(%rdx){1to16}, %zmm5, %zmm26
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x92,0xfc,0xfd,0xff,0xff]
          vpaddd -516(%rdx){1to16}, %zmm5, %zmm26

// CHECK: vpaddq %zmm14, %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x51,0xb5,0x40,0xd4,0xc6]
          vpaddq %zmm14, %zmm25, %zmm8

// CHECK: vpaddq %zmm14, %zmm25, %zmm8 {%k3}
// CHECK:  encoding: [0x62,0x51,0xb5,0x43,0xd4,0xc6]
          vpaddq %zmm14, %zmm25, %zmm8 {%k3}

// CHECK: vpaddq %zmm14, %zmm25, %zmm8 {%k3} {z}
// CHECK:  encoding: [0x62,0x51,0xb5,0xc3,0xd4,0xc6]
          vpaddq %zmm14, %zmm25, %zmm8 {%k3} {z}

// CHECK: vpaddq (%rcx), %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x01]
          vpaddq (%rcx), %zmm25, %zmm8

// CHECK: vpaddq 291(%rax,%r14,8), %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x31,0xb5,0x40,0xd4,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpaddq 291(%rax,%r14,8), %zmm25, %zmm8

// CHECK: vpaddq (%rcx){1to8}, %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x01]
          vpaddq (%rcx){1to8}, %zmm25, %zmm8

// CHECK: vpaddq 8128(%rdx), %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x42,0x7f]
          vpaddq 8128(%rdx), %zmm25, %zmm8

// CHECK: vpaddq 8192(%rdx), %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x82,0x00,0x20,0x00,0x00]
          vpaddq 8192(%rdx), %zmm25, %zmm8

// CHECK: vpaddq -8192(%rdx), %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x42,0x80]
          vpaddq -8192(%rdx), %zmm25, %zmm8

// CHECK: vpaddq -8256(%rdx), %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x82,0xc0,0xdf,0xff,0xff]
          vpaddq -8256(%rdx), %zmm25, %zmm8

// CHECK: vpaddq 1016(%rdx){1to8}, %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x42,0x7f]
          vpaddq 1016(%rdx){1to8}, %zmm25, %zmm8

// CHECK: vpaddq 1024(%rdx){1to8}, %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x82,0x00,0x04,0x00,0x00]
          vpaddq 1024(%rdx){1to8}, %zmm25, %zmm8

// CHECK: vpaddq -1024(%rdx){1to8}, %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x42,0x80]
          vpaddq -1024(%rdx){1to8}, %zmm25, %zmm8

// CHECK: vpaddq -1032(%rdx){1to8}, %zmm25, %zmm8
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x82,0xf8,0xfb,0xff,0xff]
          vpaddq -1032(%rdx){1to8}, %zmm25, %zmm8

// CHECK: vpandd %zmm25, %zmm22, %zmm19
// CHECK:  encoding: [0x62,0x81,0x4d,0x40,0xdb,0xd9]
          vpandd %zmm25, %zmm22, %zmm19

// CHECK: vpandd %zmm25, %zmm22, %zmm19 {%k1}
// CHECK:  encoding: [0x62,0x81,0x4d,0x41,0xdb,0xd9]
          vpandd %zmm25, %zmm22, %zmm19 {%k1}

// CHECK: vpandd %zmm25, %zmm22, %zmm19 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0x4d,0xc1,0xdb,0xd9]
          vpandd %zmm25, %zmm22, %zmm19 {%k1} {z}

// CHECK: vpandd (%rcx), %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x19]
          vpandd (%rcx), %zmm22, %zmm19

// CHECK: vpandd 291(%rax,%r14,8), %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xdb,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpandd 291(%rax,%r14,8), %zmm22, %zmm19

// CHECK: vpandd (%rcx){1to16}, %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x19]
          vpandd (%rcx){1to16}, %zmm22, %zmm19

// CHECK: vpandd 8128(%rdx), %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x5a,0x7f]
          vpandd 8128(%rdx), %zmm22, %zmm19

// CHECK: vpandd 8192(%rdx), %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x9a,0x00,0x20,0x00,0x00]
          vpandd 8192(%rdx), %zmm22, %zmm19

// CHECK: vpandd -8192(%rdx), %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x5a,0x80]
          vpandd -8192(%rdx), %zmm22, %zmm19

// CHECK: vpandd -8256(%rdx), %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x9a,0xc0,0xdf,0xff,0xff]
          vpandd -8256(%rdx), %zmm22, %zmm19

// CHECK: vpandd 508(%rdx){1to16}, %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x5a,0x7f]
          vpandd 508(%rdx){1to16}, %zmm22, %zmm19

// CHECK: vpandd 512(%rdx){1to16}, %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x9a,0x00,0x02,0x00,0x00]
          vpandd 512(%rdx){1to16}, %zmm22, %zmm19

// CHECK: vpandd -512(%rdx){1to16}, %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x5a,0x80]
          vpandd -512(%rdx){1to16}, %zmm22, %zmm19

// CHECK: vpandd -516(%rdx){1to16}, %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x9a,0xfc,0xfd,0xff,0xff]
          vpandd -516(%rdx){1to16}, %zmm22, %zmm19

// CHECK: vpandnd %zmm15, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x41,0x1d,0x40,0xdf,0xf7]
          vpandnd %zmm15, %zmm28, %zmm30

// CHECK: vpandnd %zmm15, %zmm28, %zmm30 {%k3}
// CHECK:  encoding: [0x62,0x41,0x1d,0x43,0xdf,0xf7]
          vpandnd %zmm15, %zmm28, %zmm30 {%k3}

// CHECK: vpandnd %zmm15, %zmm28, %zmm30 {%k3} {z}
// CHECK:  encoding: [0x62,0x41,0x1d,0xc3,0xdf,0xf7]
          vpandnd %zmm15, %zmm28, %zmm30 {%k3} {z}

// CHECK: vpandnd (%rcx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0x31]
          vpandnd (%rcx), %zmm28, %zmm30

// CHECK: vpandnd 291(%rax,%r14,8), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x21,0x1d,0x40,0xdf,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpandnd 291(%rax,%r14,8), %zmm28, %zmm30

// CHECK: vpandnd (%rcx){1to16}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0x31]
          vpandnd (%rcx){1to16}, %zmm28, %zmm30

// CHECK: vpandnd 8128(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0x72,0x7f]
          vpandnd 8128(%rdx), %zmm28, %zmm30

// CHECK: vpandnd 8192(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0xb2,0x00,0x20,0x00,0x00]
          vpandnd 8192(%rdx), %zmm28, %zmm30

// CHECK: vpandnd -8192(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0x72,0x80]
          vpandnd -8192(%rdx), %zmm28, %zmm30

// CHECK: vpandnd -8256(%rdx), %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0xb2,0xc0,0xdf,0xff,0xff]
          vpandnd -8256(%rdx), %zmm28, %zmm30

// CHECK: vpandnd 508(%rdx){1to16}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0x72,0x7f]
          vpandnd 508(%rdx){1to16}, %zmm28, %zmm30

// CHECK: vpandnd 512(%rdx){1to16}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0xb2,0x00,0x02,0x00,0x00]
          vpandnd 512(%rdx){1to16}, %zmm28, %zmm30

// CHECK: vpandnd -512(%rdx){1to16}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0x72,0x80]
          vpandnd -512(%rdx){1to16}, %zmm28, %zmm30

// CHECK: vpandnd -516(%rdx){1to16}, %zmm28, %zmm30
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0xb2,0xfc,0xfd,0xff,0xff]
          vpandnd -516(%rdx){1to16}, %zmm28, %zmm30

// CHECK: vpandnq %zmm19, %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xa1,0xc5,0x48,0xdf,0xe3]
          vpandnq %zmm19, %zmm7, %zmm20

// CHECK: vpandnq %zmm19, %zmm7, %zmm20 {%k5}
// CHECK:  encoding: [0x62,0xa1,0xc5,0x4d,0xdf,0xe3]
          vpandnq %zmm19, %zmm7, %zmm20 {%k5}

// CHECK: vpandnq %zmm19, %zmm7, %zmm20 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0xc5,0xcd,0xdf,0xe3]
          vpandnq %zmm19, %zmm7, %zmm20 {%k5} {z}

// CHECK: vpandnq (%rcx), %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0x21]
          vpandnq (%rcx), %zmm7, %zmm20

// CHECK: vpandnq 291(%rax,%r14,8), %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xa1,0xc5,0x48,0xdf,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpandnq 291(%rax,%r14,8), %zmm7, %zmm20

// CHECK: vpandnq (%rcx){1to8}, %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0x21]
          vpandnq (%rcx){1to8}, %zmm7, %zmm20

// CHECK: vpandnq 8128(%rdx), %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0x62,0x7f]
          vpandnq 8128(%rdx), %zmm7, %zmm20

// CHECK: vpandnq 8192(%rdx), %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0xa2,0x00,0x20,0x00,0x00]
          vpandnq 8192(%rdx), %zmm7, %zmm20

// CHECK: vpandnq -8192(%rdx), %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0x62,0x80]
          vpandnq -8192(%rdx), %zmm7, %zmm20

// CHECK: vpandnq -8256(%rdx), %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0xa2,0xc0,0xdf,0xff,0xff]
          vpandnq -8256(%rdx), %zmm7, %zmm20

// CHECK: vpandnq 1016(%rdx){1to8}, %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0x62,0x7f]
          vpandnq 1016(%rdx){1to8}, %zmm7, %zmm20

// CHECK: vpandnq 1024(%rdx){1to8}, %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0xa2,0x00,0x04,0x00,0x00]
          vpandnq 1024(%rdx){1to8}, %zmm7, %zmm20

// CHECK: vpandnq -1024(%rdx){1to8}, %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0x62,0x80]
          vpandnq -1024(%rdx){1to8}, %zmm7, %zmm20

// CHECK: vpandnq -1032(%rdx){1to8}, %zmm7, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0xa2,0xf8,0xfb,0xff,0xff]
          vpandnq -1032(%rdx){1to8}, %zmm7, %zmm20

// CHECK: vpandq %zmm26, %zmm4, %zmm17
// CHECK:  encoding: [0x62,0x81,0xdd,0x48,0xdb,0xca]
          vpandq %zmm26, %zmm4, %zmm17

// CHECK: vpandq %zmm26, %zmm4, %zmm17 {%k7}
// CHECK:  encoding: [0x62,0x81,0xdd,0x4f,0xdb,0xca]
          vpandq %zmm26, %zmm4, %zmm17 {%k7}

// CHECK: vpandq %zmm26, %zmm4, %zmm17 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0xdd,0xcf,0xdb,0xca]
          vpandq %zmm26, %zmm4, %zmm17 {%k7} {z}

// CHECK: vpandq (%rcx), %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x09]
          vpandq (%rcx), %zmm4, %zmm17

// CHECK: vpandq 291(%rax,%r14,8), %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xa1,0xdd,0x48,0xdb,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpandq 291(%rax,%r14,8), %zmm4, %zmm17

// CHECK: vpandq (%rcx){1to8}, %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x09]
          vpandq (%rcx){1to8}, %zmm4, %zmm17

// CHECK: vpandq 8128(%rdx), %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x4a,0x7f]
          vpandq 8128(%rdx), %zmm4, %zmm17

// CHECK: vpandq 8192(%rdx), %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x8a,0x00,0x20,0x00,0x00]
          vpandq 8192(%rdx), %zmm4, %zmm17

// CHECK: vpandq -8192(%rdx), %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x4a,0x80]
          vpandq -8192(%rdx), %zmm4, %zmm17

// CHECK: vpandq -8256(%rdx), %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x8a,0xc0,0xdf,0xff,0xff]
          vpandq -8256(%rdx), %zmm4, %zmm17

// CHECK: vpandq 1016(%rdx){1to8}, %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x4a,0x7f]
          vpandq 1016(%rdx){1to8}, %zmm4, %zmm17

// CHECK: vpandq 1024(%rdx){1to8}, %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x8a,0x00,0x04,0x00,0x00]
          vpandq 1024(%rdx){1to8}, %zmm4, %zmm17

// CHECK: vpandq -1024(%rdx){1to8}, %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x4a,0x80]
          vpandq -1024(%rdx){1to8}, %zmm4, %zmm17

// CHECK: vpandq -1032(%rdx){1to8}, %zmm4, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x8a,0xf8,0xfb,0xff,0xff]
          vpandq -1032(%rdx){1to8}, %zmm4, %zmm17

// CHECK: vpcmpd $171, %zmm10, %zmm25, %k5
// CHECK:  encoding: [0x62,0xd3,0x35,0x40,0x1f,0xea,0xab]
          vpcmpd $171, %zmm10, %zmm25, %k5

// CHECK: vpcmpd $171, %zmm10, %zmm25, %k5 {%k3}
// CHECK:  encoding: [0x62,0xd3,0x35,0x43,0x1f,0xea,0xab]
          vpcmpd $171, %zmm10, %zmm25, %k5 {%k3}

// CHECK: vpcmpd $123, %zmm10, %zmm25, %k5
// CHECK:  encoding: [0x62,0xd3,0x35,0x40,0x1f,0xea,0x7b]
          vpcmpd $123, %zmm10, %zmm25, %k5

// CHECK: vpcmpd $123, (%rcx), %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0x29,0x7b]
          vpcmpd $123, (%rcx), %zmm25, %k5

// CHECK: vpcmpd $123, 291(%rax,%r14,8), %zmm25, %k5
// CHECK:  encoding: [0x62,0xb3,0x35,0x40,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpd $123, 291(%rax,%r14,8), %zmm25, %k5

// CHECK: vpcmpd $123, (%rcx){1to16}, %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0x29,0x7b]
          vpcmpd $123, (%rcx){1to16}, %zmm25, %k5

// CHECK: vpcmpd $123, 8128(%rdx), %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0x6a,0x7f,0x7b]
          vpcmpd $123, 8128(%rdx), %zmm25, %k5

// CHECK: vpcmpd $123, 8192(%rdx), %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vpcmpd $123, 8192(%rdx), %zmm25, %k5

// CHECK: vpcmpd $123, -8192(%rdx), %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0x6a,0x80,0x7b]
          vpcmpd $123, -8192(%rdx), %zmm25, %k5

// CHECK: vpcmpd $123, -8256(%rdx), %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpd $123, -8256(%rdx), %zmm25, %k5

// CHECK: vpcmpd $123, 508(%rdx){1to16}, %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0x6a,0x7f,0x7b]
          vpcmpd $123, 508(%rdx){1to16}, %zmm25, %k5

// CHECK: vpcmpd $123, 512(%rdx){1to16}, %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0xaa,0x00,0x02,0x00,0x00,0x7b]
          vpcmpd $123, 512(%rdx){1to16}, %zmm25, %k5

// CHECK: vpcmpd $123, -512(%rdx){1to16}, %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0x6a,0x80,0x7b]
          vpcmpd $123, -512(%rdx){1to16}, %zmm25, %k5

// CHECK: vpcmpd $123, -516(%rdx){1to16}, %zmm25, %k5
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0xaa,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpd $123, -516(%rdx){1to16}, %zmm25, %k5

// CHECK: vpcmpeqd %zmm10, %zmm2, %k5
// CHECK:  encoding: [0x62,0xd1,0x6d,0x48,0x76,0xea]
          vpcmpeqd %zmm10, %zmm2, %k5

// CHECK: vpcmpeqd %zmm10, %zmm2, %k5 {%k7}
// CHECK:  encoding: [0x62,0xd1,0x6d,0x4f,0x76,0xea]
          vpcmpeqd %zmm10, %zmm2, %k5 {%k7}

// CHECK: vpcmpeqd (%rcx), %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0x29]
          vpcmpeqd (%rcx), %zmm2, %k5

// CHECK: vpcmpeqd 291(%rax,%r14,8), %zmm2, %k5
// CHECK:  encoding: [0x62,0xb1,0x6d,0x48,0x76,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqd 291(%rax,%r14,8), %zmm2, %k5

// CHECK: vpcmpeqd (%rcx){1to16}, %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0x29]
          vpcmpeqd (%rcx){1to16}, %zmm2, %k5

// CHECK: vpcmpeqd 8128(%rdx), %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0x6a,0x7f]
          vpcmpeqd 8128(%rdx), %zmm2, %k5

// CHECK: vpcmpeqd 8192(%rdx), %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0xaa,0x00,0x20,0x00,0x00]
          vpcmpeqd 8192(%rdx), %zmm2, %k5

// CHECK: vpcmpeqd -8192(%rdx), %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0x6a,0x80]
          vpcmpeqd -8192(%rdx), %zmm2, %k5

// CHECK: vpcmpeqd -8256(%rdx), %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0xaa,0xc0,0xdf,0xff,0xff]
          vpcmpeqd -8256(%rdx), %zmm2, %k5

// CHECK: vpcmpeqd 508(%rdx){1to16}, %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0x6a,0x7f]
          vpcmpeqd 508(%rdx){1to16}, %zmm2, %k5

// CHECK: vpcmpeqd 512(%rdx){1to16}, %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0xaa,0x00,0x02,0x00,0x00]
          vpcmpeqd 512(%rdx){1to16}, %zmm2, %k5

// CHECK: vpcmpeqd -512(%rdx){1to16}, %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0x6a,0x80]
          vpcmpeqd -512(%rdx){1to16}, %zmm2, %k5

// CHECK: vpcmpeqd -516(%rdx){1to16}, %zmm2, %k5
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0xaa,0xfc,0xfd,0xff,0xff]
          vpcmpeqd -516(%rdx){1to16}, %zmm2, %k5

// CHECK: vpcmpeqq %zmm2, %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0xda]
          vpcmpeqq %zmm2, %zmm22, %k3

// CHECK: vpcmpeqq %zmm2, %zmm22, %k3 {%k6}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x46,0x29,0xda]
          vpcmpeqq %zmm2, %zmm22, %k3 {%k6}

// CHECK: vpcmpeqq (%rcx), %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x19]
          vpcmpeqq (%rcx), %zmm22, %k3

// CHECK: vpcmpeqq 291(%rax,%r14,8), %zmm22, %k3
// CHECK:  encoding: [0x62,0xb2,0xcd,0x40,0x29,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqq 291(%rax,%r14,8), %zmm22, %k3

// CHECK: vpcmpeqq (%rcx){1to8}, %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x19]
          vpcmpeqq (%rcx){1to8}, %zmm22, %k3

// CHECK: vpcmpeqq 8128(%rdx), %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x5a,0x7f]
          vpcmpeqq 8128(%rdx), %zmm22, %k3

// CHECK: vpcmpeqq 8192(%rdx), %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x9a,0x00,0x20,0x00,0x00]
          vpcmpeqq 8192(%rdx), %zmm22, %k3

// CHECK: vpcmpeqq -8192(%rdx), %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x5a,0x80]
          vpcmpeqq -8192(%rdx), %zmm22, %k3

// CHECK: vpcmpeqq -8256(%rdx), %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x9a,0xc0,0xdf,0xff,0xff]
          vpcmpeqq -8256(%rdx), %zmm22, %k3

// CHECK: vpcmpeqq 1016(%rdx){1to8}, %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x5a,0x7f]
          vpcmpeqq 1016(%rdx){1to8}, %zmm22, %k3

// CHECK: vpcmpeqq 1024(%rdx){1to8}, %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x9a,0x00,0x04,0x00,0x00]
          vpcmpeqq 1024(%rdx){1to8}, %zmm22, %k3

// CHECK: vpcmpeqq -1024(%rdx){1to8}, %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x5a,0x80]
          vpcmpeqq -1024(%rdx){1to8}, %zmm22, %k3

// CHECK: vpcmpeqq -1032(%rdx){1to8}, %zmm22, %k3
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x9a,0xf8,0xfb,0xff,0xff]
          vpcmpeqq -1032(%rdx){1to8}, %zmm22, %k3

// CHECK: vpcmpgtd %zmm8, %zmm21, %k5
// CHECK:  encoding: [0x62,0xd1,0x55,0x40,0x66,0xe8]
          vpcmpgtd %zmm8, %zmm21, %k5

// CHECK: vpcmpgtd %zmm8, %zmm21, %k5 {%k5}
// CHECK:  encoding: [0x62,0xd1,0x55,0x45,0x66,0xe8]
          vpcmpgtd %zmm8, %zmm21, %k5 {%k5}

// CHECK: vpcmpgtd (%rcx), %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0x29]
          vpcmpgtd (%rcx), %zmm21, %k5

// CHECK: vpcmpgtd 291(%rax,%r14,8), %zmm21, %k5
// CHECK:  encoding: [0x62,0xb1,0x55,0x40,0x66,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtd 291(%rax,%r14,8), %zmm21, %k5

// CHECK: vpcmpgtd (%rcx){1to16}, %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0x29]
          vpcmpgtd (%rcx){1to16}, %zmm21, %k5

// CHECK: vpcmpgtd 8128(%rdx), %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0x6a,0x7f]
          vpcmpgtd 8128(%rdx), %zmm21, %k5

// CHECK: vpcmpgtd 8192(%rdx), %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0xaa,0x00,0x20,0x00,0x00]
          vpcmpgtd 8192(%rdx), %zmm21, %k5

// CHECK: vpcmpgtd -8192(%rdx), %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0x6a,0x80]
          vpcmpgtd -8192(%rdx), %zmm21, %k5

// CHECK: vpcmpgtd -8256(%rdx), %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0xaa,0xc0,0xdf,0xff,0xff]
          vpcmpgtd -8256(%rdx), %zmm21, %k5

// CHECK: vpcmpgtd 508(%rdx){1to16}, %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0x6a,0x7f]
          vpcmpgtd 508(%rdx){1to16}, %zmm21, %k5

// CHECK: vpcmpgtd 512(%rdx){1to16}, %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0xaa,0x00,0x02,0x00,0x00]
          vpcmpgtd 512(%rdx){1to16}, %zmm21, %k5

// CHECK: vpcmpgtd -512(%rdx){1to16}, %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0x6a,0x80]
          vpcmpgtd -512(%rdx){1to16}, %zmm21, %k5

// CHECK: vpcmpgtd -516(%rdx){1to16}, %zmm21, %k5
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0xaa,0xfc,0xfd,0xff,0xff]
          vpcmpgtd -516(%rdx){1to16}, %zmm21, %k5

// CHECK: vpcmpgtq %zmm17, %zmm20, %k2
// CHECK:  encoding: [0x62,0xb2,0xdd,0x40,0x37,0xd1]
          vpcmpgtq %zmm17, %zmm20, %k2

// CHECK: vpcmpgtq %zmm17, %zmm20, %k2 {%k3}
// CHECK:  encoding: [0x62,0xb2,0xdd,0x43,0x37,0xd1]
          vpcmpgtq %zmm17, %zmm20, %k2 {%k3}

// CHECK: vpcmpgtq (%rcx), %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x11]
          vpcmpgtq (%rcx), %zmm20, %k2

// CHECK: vpcmpgtq 291(%rax,%r14,8), %zmm20, %k2
// CHECK:  encoding: [0x62,0xb2,0xdd,0x40,0x37,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtq 291(%rax,%r14,8), %zmm20, %k2

// CHECK: vpcmpgtq (%rcx){1to8}, %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x11]
          vpcmpgtq (%rcx){1to8}, %zmm20, %k2

// CHECK: vpcmpgtq 8128(%rdx), %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x52,0x7f]
          vpcmpgtq 8128(%rdx), %zmm20, %k2

// CHECK: vpcmpgtq 8192(%rdx), %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x92,0x00,0x20,0x00,0x00]
          vpcmpgtq 8192(%rdx), %zmm20, %k2

// CHECK: vpcmpgtq -8192(%rdx), %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x52,0x80]
          vpcmpgtq -8192(%rdx), %zmm20, %k2

// CHECK: vpcmpgtq -8256(%rdx), %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x92,0xc0,0xdf,0xff,0xff]
          vpcmpgtq -8256(%rdx), %zmm20, %k2

// CHECK: vpcmpgtq 1016(%rdx){1to8}, %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x52,0x7f]
          vpcmpgtq 1016(%rdx){1to8}, %zmm20, %k2

// CHECK: vpcmpgtq 1024(%rdx){1to8}, %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x92,0x00,0x04,0x00,0x00]
          vpcmpgtq 1024(%rdx){1to8}, %zmm20, %k2

// CHECK: vpcmpgtq -1024(%rdx){1to8}, %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x52,0x80]
          vpcmpgtq -1024(%rdx){1to8}, %zmm20, %k2

// CHECK: vpcmpgtq -1032(%rdx){1to8}, %zmm20, %k2
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x92,0xf8,0xfb,0xff,0xff]
          vpcmpgtq -1032(%rdx){1to8}, %zmm20, %k2

// CHECK: vpcmpq $171, %zmm28, %zmm28, %k5
// CHECK:  encoding: [0x62,0x93,0x9d,0x40,0x1f,0xec,0xab]
          vpcmpq $171, %zmm28, %zmm28, %k5

// CHECK: vpcmpq $171, %zmm28, %zmm28, %k5 {%k3}
// CHECK:  encoding: [0x62,0x93,0x9d,0x43,0x1f,0xec,0xab]
          vpcmpq $171, %zmm28, %zmm28, %k5 {%k3}

// CHECK: vpcmpq $123, %zmm28, %zmm28, %k5
// CHECK:  encoding: [0x62,0x93,0x9d,0x40,0x1f,0xec,0x7b]
          vpcmpq $123, %zmm28, %zmm28, %k5

// CHECK: vpcmpq $123, (%rcx), %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0x29,0x7b]
          vpcmpq $123, (%rcx), %zmm28, %k5

// CHECK: vpcmpq $123, 291(%rax,%r14,8), %zmm28, %k5
// CHECK:  encoding: [0x62,0xb3,0x9d,0x40,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpq $123, 291(%rax,%r14,8), %zmm28, %k5

// CHECK: vpcmpq $123, (%rcx){1to8}, %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0x29,0x7b]
          vpcmpq $123, (%rcx){1to8}, %zmm28, %k5

// CHECK: vpcmpq $123, 8128(%rdx), %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0x6a,0x7f,0x7b]
          vpcmpq $123, 8128(%rdx), %zmm28, %k5

// CHECK: vpcmpq $123, 8192(%rdx), %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vpcmpq $123, 8192(%rdx), %zmm28, %k5

// CHECK: vpcmpq $123, -8192(%rdx), %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0x6a,0x80,0x7b]
          vpcmpq $123, -8192(%rdx), %zmm28, %k5

// CHECK: vpcmpq $123, -8256(%rdx), %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpq $123, -8256(%rdx), %zmm28, %k5

// CHECK: vpcmpq $123, 1016(%rdx){1to8}, %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0x6a,0x7f,0x7b]
          vpcmpq $123, 1016(%rdx){1to8}, %zmm28, %k5

// CHECK: vpcmpq $123, 1024(%rdx){1to8}, %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vpcmpq $123, 1024(%rdx){1to8}, %zmm28, %k5

// CHECK: vpcmpq $123, -1024(%rdx){1to8}, %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0x6a,0x80,0x7b]
          vpcmpq $123, -1024(%rdx){1to8}, %zmm28, %k5

// CHECK: vpcmpq $123, -1032(%rdx){1to8}, %zmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpq $123, -1032(%rdx){1to8}, %zmm28, %k5

// CHECK: vpcmpud $171, %zmm7, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0xd7,0xab]
          vpcmpud $171, %zmm7, %zmm25, %k2

// CHECK: vpcmpud $171, %zmm7, %zmm25, %k2 {%k1}
// CHECK:  encoding: [0x62,0xf3,0x35,0x41,0x1e,0xd7,0xab]
          vpcmpud $171, %zmm7, %zmm25, %k2 {%k1}

// CHECK: vpcmpud $123, %zmm7, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0xd7,0x7b]
          vpcmpud $123, %zmm7, %zmm25, %k2

// CHECK: vpcmpud $123, (%rcx), %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x11,0x7b]
          vpcmpud $123, (%rcx), %zmm25, %k2

// CHECK: vpcmpud $123, 291(%rax,%r14,8), %zmm25, %k2
// CHECK:  encoding: [0x62,0xb3,0x35,0x40,0x1e,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpud $123, 291(%rax,%r14,8), %zmm25, %k2

// CHECK: vpcmpud $123, (%rcx){1to16}, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x11,0x7b]
          vpcmpud $123, (%rcx){1to16}, %zmm25, %k2

// CHECK: vpcmpud $123, 8128(%rdx), %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x52,0x7f,0x7b]
          vpcmpud $123, 8128(%rdx), %zmm25, %k2

// CHECK: vpcmpud $123, 8192(%rdx), %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpcmpud $123, 8192(%rdx), %zmm25, %k2

// CHECK: vpcmpud $123, -8192(%rdx), %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x52,0x80,0x7b]
          vpcmpud $123, -8192(%rdx), %zmm25, %k2

// CHECK: vpcmpud $123, -8256(%rdx), %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpud $123, -8256(%rdx), %zmm25, %k2

// CHECK: vpcmpud $123, 508(%rdx){1to16}, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x52,0x7f,0x7b]
          vpcmpud $123, 508(%rdx){1to16}, %zmm25, %k2

// CHECK: vpcmpud $123, 512(%rdx){1to16}, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x92,0x00,0x02,0x00,0x00,0x7b]
          vpcmpud $123, 512(%rdx){1to16}, %zmm25, %k2

// CHECK: vpcmpud $123, -512(%rdx){1to16}, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x52,0x80,0x7b]
          vpcmpud $123, -512(%rdx){1to16}, %zmm25, %k2

// CHECK: vpcmpud $123, -516(%rdx){1to16}, %zmm25, %k2
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpud $123, -516(%rdx){1to16}, %zmm25, %k2

// CHECK: vpcmpuq $171, %zmm8, %zmm14, %k3
// CHECK:  encoding: [0x62,0xd3,0x8d,0x48,0x1e,0xd8,0xab]
          vpcmpuq $171, %zmm8, %zmm14, %k3

// CHECK: vpcmpuq $171, %zmm8, %zmm14, %k3 {%k2}
// CHECK:  encoding: [0x62,0xd3,0x8d,0x4a,0x1e,0xd8,0xab]
          vpcmpuq $171, %zmm8, %zmm14, %k3 {%k2}

// CHECK: vpcmpuq $123, %zmm8, %zmm14, %k3
// CHECK:  encoding: [0x62,0xd3,0x8d,0x48,0x1e,0xd8,0x7b]
          vpcmpuq $123, %zmm8, %zmm14, %k3

// CHECK: vpcmpuq $123, (%rcx), %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x19,0x7b]
          vpcmpuq $123, (%rcx), %zmm14, %k3

// CHECK: vpcmpuq $123, 291(%rax,%r14,8), %zmm14, %k3
// CHECK:  encoding: [0x62,0xb3,0x8d,0x48,0x1e,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuq $123, 291(%rax,%r14,8), %zmm14, %k3

// CHECK: vpcmpuq $123, (%rcx){1to8}, %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x19,0x7b]
          vpcmpuq $123, (%rcx){1to8}, %zmm14, %k3

// CHECK: vpcmpuq $123, 8128(%rdx), %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x5a,0x7f,0x7b]
          vpcmpuq $123, 8128(%rdx), %zmm14, %k3

// CHECK: vpcmpuq $123, 8192(%rdx), %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpcmpuq $123, 8192(%rdx), %zmm14, %k3

// CHECK: vpcmpuq $123, -8192(%rdx), %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x5a,0x80,0x7b]
          vpcmpuq $123, -8192(%rdx), %zmm14, %k3

// CHECK: vpcmpuq $123, -8256(%rdx), %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpuq $123, -8256(%rdx), %zmm14, %k3

// CHECK: vpcmpuq $123, 1016(%rdx){1to8}, %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x5a,0x7f,0x7b]
          vpcmpuq $123, 1016(%rdx){1to8}, %zmm14, %k3

// CHECK: vpcmpuq $123, 1024(%rdx){1to8}, %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vpcmpuq $123, 1024(%rdx){1to8}, %zmm14, %k3

// CHECK: vpcmpuq $123, -1024(%rdx){1to8}, %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x5a,0x80,0x7b]
          vpcmpuq $123, -1024(%rdx){1to8}, %zmm14, %k3

// CHECK: vpcmpuq $123, -1032(%rdx){1to8}, %zmm14, %k3
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpuq $123, -1032(%rdx){1to8}, %zmm14, %k3

// CHECK: vpmaxsd %zmm16, %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xb2,0x3d,0x48,0x3d,0xf0]
          vpmaxsd %zmm16, %zmm8, %zmm6

// CHECK: vpmaxsd %zmm16, %zmm8, %zmm6 {%k3}
// CHECK:  encoding: [0x62,0xb2,0x3d,0x4b,0x3d,0xf0]
          vpmaxsd %zmm16, %zmm8, %zmm6 {%k3}

// CHECK: vpmaxsd %zmm16, %zmm8, %zmm6 {%k3} {z}
// CHECK:  encoding: [0x62,0xb2,0x3d,0xcb,0x3d,0xf0]
          vpmaxsd %zmm16, %zmm8, %zmm6 {%k3} {z}

// CHECK: vpmaxsd (%rcx), %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0x31]
          vpmaxsd (%rcx), %zmm8, %zmm6

// CHECK: vpmaxsd 291(%rax,%r14,8), %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xb2,0x3d,0x48,0x3d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsd 291(%rax,%r14,8), %zmm8, %zmm6

// CHECK: vpmaxsd (%rcx){1to16}, %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0x31]
          vpmaxsd (%rcx){1to16}, %zmm8, %zmm6

// CHECK: vpmaxsd 8128(%rdx), %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0x72,0x7f]
          vpmaxsd 8128(%rdx), %zmm8, %zmm6

// CHECK: vpmaxsd 8192(%rdx), %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0xb2,0x00,0x20,0x00,0x00]
          vpmaxsd 8192(%rdx), %zmm8, %zmm6

// CHECK: vpmaxsd -8192(%rdx), %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0x72,0x80]
          vpmaxsd -8192(%rdx), %zmm8, %zmm6

// CHECK: vpmaxsd -8256(%rdx), %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0xb2,0xc0,0xdf,0xff,0xff]
          vpmaxsd -8256(%rdx), %zmm8, %zmm6

// CHECK: vpmaxsd 508(%rdx){1to16}, %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0x72,0x7f]
          vpmaxsd 508(%rdx){1to16}, %zmm8, %zmm6

// CHECK: vpmaxsd 512(%rdx){1to16}, %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0xb2,0x00,0x02,0x00,0x00]
          vpmaxsd 512(%rdx){1to16}, %zmm8, %zmm6

// CHECK: vpmaxsd -512(%rdx){1to16}, %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0x72,0x80]
          vpmaxsd -512(%rdx){1to16}, %zmm8, %zmm6

// CHECK: vpmaxsd -516(%rdx){1to16}, %zmm8, %zmm6
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0xb2,0xfc,0xfd,0xff,0xff]
          vpmaxsd -516(%rdx){1to16}, %zmm8, %zmm6

// CHECK: vpmaxsq %zmm1, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0xf1]
          vpmaxsq %zmm1, %zmm6, %zmm6

// CHECK: vpmaxsq %zmm1, %zmm6, %zmm6 {%k7}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x4f,0x3d,0xf1]
          vpmaxsq %zmm1, %zmm6, %zmm6 {%k7}

// CHECK: vpmaxsq %zmm1, %zmm6, %zmm6 {%k7} {z}
// CHECK:  encoding: [0x62,0xf2,0xcd,0xcf,0x3d,0xf1]
          vpmaxsq %zmm1, %zmm6, %zmm6 {%k7} {z}

// CHECK: vpmaxsq (%rcx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0x31]
          vpmaxsq (%rcx), %zmm6, %zmm6

// CHECK: vpmaxsq 291(%rax,%r14,8), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xb2,0xcd,0x48,0x3d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsq 291(%rax,%r14,8), %zmm6, %zmm6

// CHECK: vpmaxsq (%rcx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0x31]
          vpmaxsq (%rcx){1to8}, %zmm6, %zmm6

// CHECK: vpmaxsq 8128(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0x72,0x7f]
          vpmaxsq 8128(%rdx), %zmm6, %zmm6

// CHECK: vpmaxsq 8192(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0xb2,0x00,0x20,0x00,0x00]
          vpmaxsq 8192(%rdx), %zmm6, %zmm6

// CHECK: vpmaxsq -8192(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0x72,0x80]
          vpmaxsq -8192(%rdx), %zmm6, %zmm6

// CHECK: vpmaxsq -8256(%rdx), %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0xb2,0xc0,0xdf,0xff,0xff]
          vpmaxsq -8256(%rdx), %zmm6, %zmm6

// CHECK: vpmaxsq 1016(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0x72,0x7f]
          vpmaxsq 1016(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vpmaxsq 1024(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0xb2,0x00,0x04,0x00,0x00]
          vpmaxsq 1024(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vpmaxsq -1024(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0x72,0x80]
          vpmaxsq -1024(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vpmaxsq -1032(%rdx){1to8}, %zmm6, %zmm6
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0xb2,0xf8,0xfb,0xff,0xff]
          vpmaxsq -1032(%rdx){1to8}, %zmm6, %zmm6

// CHECK: vpmaxud %zmm25, %zmm7, %zmm17
// CHECK:  encoding: [0x62,0x82,0x45,0x48,0x3f,0xc9]
          vpmaxud %zmm25, %zmm7, %zmm17

// CHECK: vpmaxud %zmm25, %zmm7, %zmm17 {%k5}
// CHECK:  encoding: [0x62,0x82,0x45,0x4d,0x3f,0xc9]
          vpmaxud %zmm25, %zmm7, %zmm17 {%k5}

// CHECK: vpmaxud %zmm25, %zmm7, %zmm17 {%k5} {z}
// CHECK:  encoding: [0x62,0x82,0x45,0xcd,0x3f,0xc9]
          vpmaxud %zmm25, %zmm7, %zmm17 {%k5} {z}

// CHECK: vpmaxud (%rcx), %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x09]
          vpmaxud (%rcx), %zmm7, %zmm17

// CHECK: vpmaxud 291(%rax,%r14,8), %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xa2,0x45,0x48,0x3f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxud 291(%rax,%r14,8), %zmm7, %zmm17

// CHECK: vpmaxud (%rcx){1to16}, %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x09]
          vpmaxud (%rcx){1to16}, %zmm7, %zmm17

// CHECK: vpmaxud 8128(%rdx), %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x4a,0x7f]
          vpmaxud 8128(%rdx), %zmm7, %zmm17

// CHECK: vpmaxud 8192(%rdx), %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x8a,0x00,0x20,0x00,0x00]
          vpmaxud 8192(%rdx), %zmm7, %zmm17

// CHECK: vpmaxud -8192(%rdx), %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x4a,0x80]
          vpmaxud -8192(%rdx), %zmm7, %zmm17

// CHECK: vpmaxud -8256(%rdx), %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x8a,0xc0,0xdf,0xff,0xff]
          vpmaxud -8256(%rdx), %zmm7, %zmm17

// CHECK: vpmaxud 508(%rdx){1to16}, %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x4a,0x7f]
          vpmaxud 508(%rdx){1to16}, %zmm7, %zmm17

// CHECK: vpmaxud 512(%rdx){1to16}, %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x8a,0x00,0x02,0x00,0x00]
          vpmaxud 512(%rdx){1to16}, %zmm7, %zmm17

// CHECK: vpmaxud -512(%rdx){1to16}, %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x4a,0x80]
          vpmaxud -512(%rdx){1to16}, %zmm7, %zmm17

// CHECK: vpmaxud -516(%rdx){1to16}, %zmm7, %zmm17
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x8a,0xfc,0xfd,0xff,0xff]
          vpmaxud -516(%rdx){1to16}, %zmm7, %zmm17

// CHECK: vpmaxuq %zmm25, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x02,0xcd,0x40,0x3f,0xf1]
          vpmaxuq %zmm25, %zmm22, %zmm30

// CHECK: vpmaxuq %zmm25, %zmm22, %zmm30 {%k1}
// CHECK:  encoding: [0x62,0x02,0xcd,0x41,0x3f,0xf1]
          vpmaxuq %zmm25, %zmm22, %zmm30 {%k1}

// CHECK: vpmaxuq %zmm25, %zmm22, %zmm30 {%k1} {z}
// CHECK:  encoding: [0x62,0x02,0xcd,0xc1,0x3f,0xf1]
          vpmaxuq %zmm25, %zmm22, %zmm30 {%k1} {z}

// CHECK: vpmaxuq (%rcx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0x31]
          vpmaxuq (%rcx), %zmm22, %zmm30

// CHECK: vpmaxuq 291(%rax,%r14,8), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x22,0xcd,0x40,0x3f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuq 291(%rax,%r14,8), %zmm22, %zmm30

// CHECK: vpmaxuq (%rcx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0x31]
          vpmaxuq (%rcx){1to8}, %zmm22, %zmm30

// CHECK: vpmaxuq 8128(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0x72,0x7f]
          vpmaxuq 8128(%rdx), %zmm22, %zmm30

// CHECK: vpmaxuq 8192(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0xb2,0x00,0x20,0x00,0x00]
          vpmaxuq 8192(%rdx), %zmm22, %zmm30

// CHECK: vpmaxuq -8192(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0x72,0x80]
          vpmaxuq -8192(%rdx), %zmm22, %zmm30

// CHECK: vpmaxuq -8256(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0xb2,0xc0,0xdf,0xff,0xff]
          vpmaxuq -8256(%rdx), %zmm22, %zmm30

// CHECK: vpmaxuq 1016(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0x72,0x7f]
          vpmaxuq 1016(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vpmaxuq 1024(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0xb2,0x00,0x04,0x00,0x00]
          vpmaxuq 1024(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vpmaxuq -1024(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0x72,0x80]
          vpmaxuq -1024(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vpmaxuq -1032(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0xb2,0xf8,0xfb,0xff,0xff]
          vpmaxuq -1032(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vpminsd %zmm24, %zmm16, %zmm2
// CHECK:  encoding: [0x62,0x92,0x7d,0x40,0x39,0xd0]
          vpminsd %zmm24, %zmm16, %zmm2

// CHECK: vpminsd %zmm24, %zmm16, %zmm2 {%k3}
// CHECK:  encoding: [0x62,0x92,0x7d,0x43,0x39,0xd0]
          vpminsd %zmm24, %zmm16, %zmm2 {%k3}

// CHECK: vpminsd %zmm24, %zmm16, %zmm2 {%k3} {z}
// CHECK:  encoding: [0x62,0x92,0x7d,0xc3,0x39,0xd0]
          vpminsd %zmm24, %zmm16, %zmm2 {%k3} {z}

// CHECK: vpminsd (%rcx), %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x11]
          vpminsd (%rcx), %zmm16, %zmm2

// CHECK: vpminsd 291(%rax,%r14,8), %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xb2,0x7d,0x40,0x39,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpminsd 291(%rax,%r14,8), %zmm16, %zmm2

// CHECK: vpminsd (%rcx){1to16}, %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x11]
          vpminsd (%rcx){1to16}, %zmm16, %zmm2

// CHECK: vpminsd 8128(%rdx), %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x52,0x7f]
          vpminsd 8128(%rdx), %zmm16, %zmm2

// CHECK: vpminsd 8192(%rdx), %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x92,0x00,0x20,0x00,0x00]
          vpminsd 8192(%rdx), %zmm16, %zmm2

// CHECK: vpminsd -8192(%rdx), %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x52,0x80]
          vpminsd -8192(%rdx), %zmm16, %zmm2

// CHECK: vpminsd -8256(%rdx), %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x92,0xc0,0xdf,0xff,0xff]
          vpminsd -8256(%rdx), %zmm16, %zmm2

// CHECK: vpminsd 508(%rdx){1to16}, %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x52,0x7f]
          vpminsd 508(%rdx){1to16}, %zmm16, %zmm2

// CHECK: vpminsd 512(%rdx){1to16}, %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x92,0x00,0x02,0x00,0x00]
          vpminsd 512(%rdx){1to16}, %zmm16, %zmm2

// CHECK: vpminsd -512(%rdx){1to16}, %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x52,0x80]
          vpminsd -512(%rdx){1to16}, %zmm16, %zmm2

// CHECK: vpminsd -516(%rdx){1to16}, %zmm16, %zmm2
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x92,0xfc,0xfd,0xff,0xff]
          vpminsd -516(%rdx){1to16}, %zmm16, %zmm2

// CHECK: vpminsq %zmm17, %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xa2,0xfd,0x40,0x39,0xe1]
          vpminsq %zmm17, %zmm16, %zmm20

// CHECK: vpminsq %zmm17, %zmm16, %zmm20 {%k6}
// CHECK:  encoding: [0x62,0xa2,0xfd,0x46,0x39,0xe1]
          vpminsq %zmm17, %zmm16, %zmm20 {%k6}

// CHECK: vpminsq %zmm17, %zmm16, %zmm20 {%k6} {z}
// CHECK:  encoding: [0x62,0xa2,0xfd,0xc6,0x39,0xe1]
          vpminsq %zmm17, %zmm16, %zmm20 {%k6} {z}

// CHECK: vpminsq (%rcx), %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0x21]
          vpminsq (%rcx), %zmm16, %zmm20

// CHECK: vpminsq 291(%rax,%r14,8), %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xa2,0xfd,0x40,0x39,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpminsq 291(%rax,%r14,8), %zmm16, %zmm20

// CHECK: vpminsq (%rcx){1to8}, %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0x21]
          vpminsq (%rcx){1to8}, %zmm16, %zmm20

// CHECK: vpminsq 8128(%rdx), %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0x62,0x7f]
          vpminsq 8128(%rdx), %zmm16, %zmm20

// CHECK: vpminsq 8192(%rdx), %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0xa2,0x00,0x20,0x00,0x00]
          vpminsq 8192(%rdx), %zmm16, %zmm20

// CHECK: vpminsq -8192(%rdx), %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0x62,0x80]
          vpminsq -8192(%rdx), %zmm16, %zmm20

// CHECK: vpminsq -8256(%rdx), %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0xa2,0xc0,0xdf,0xff,0xff]
          vpminsq -8256(%rdx), %zmm16, %zmm20

// CHECK: vpminsq 1016(%rdx){1to8}, %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0x62,0x7f]
          vpminsq 1016(%rdx){1to8}, %zmm16, %zmm20

// CHECK: vpminsq 1024(%rdx){1to8}, %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0xa2,0x00,0x04,0x00,0x00]
          vpminsq 1024(%rdx){1to8}, %zmm16, %zmm20

// CHECK: vpminsq -1024(%rdx){1to8}, %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0x62,0x80]
          vpminsq -1024(%rdx){1to8}, %zmm16, %zmm20

// CHECK: vpminsq -1032(%rdx){1to8}, %zmm16, %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0xa2,0xf8,0xfb,0xff,0xff]
          vpminsq -1032(%rdx){1to8}, %zmm16, %zmm20

// CHECK: vpminud %zmm20, %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xb2,0x45,0x40,0x3b,0xdc]
          vpminud %zmm20, %zmm23, %zmm3

// CHECK: vpminud %zmm20, %zmm23, %zmm3 {%k3}
// CHECK:  encoding: [0x62,0xb2,0x45,0x43,0x3b,0xdc]
          vpminud %zmm20, %zmm23, %zmm3 {%k3}

// CHECK: vpminud %zmm20, %zmm23, %zmm3 {%k3} {z}
// CHECK:  encoding: [0x62,0xb2,0x45,0xc3,0x3b,0xdc]
          vpminud %zmm20, %zmm23, %zmm3 {%k3} {z}

// CHECK: vpminud (%rcx), %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x19]
          vpminud (%rcx), %zmm23, %zmm3

// CHECK: vpminud 291(%rax,%r14,8), %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xb2,0x45,0x40,0x3b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminud 291(%rax,%r14,8), %zmm23, %zmm3

// CHECK: vpminud (%rcx){1to16}, %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x19]
          vpminud (%rcx){1to16}, %zmm23, %zmm3

// CHECK: vpminud 8128(%rdx), %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x5a,0x7f]
          vpminud 8128(%rdx), %zmm23, %zmm3

// CHECK: vpminud 8192(%rdx), %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x9a,0x00,0x20,0x00,0x00]
          vpminud 8192(%rdx), %zmm23, %zmm3

// CHECK: vpminud -8192(%rdx), %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x5a,0x80]
          vpminud -8192(%rdx), %zmm23, %zmm3

// CHECK: vpminud -8256(%rdx), %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x9a,0xc0,0xdf,0xff,0xff]
          vpminud -8256(%rdx), %zmm23, %zmm3

// CHECK: vpminud 508(%rdx){1to16}, %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x5a,0x7f]
          vpminud 508(%rdx){1to16}, %zmm23, %zmm3

// CHECK: vpminud 512(%rdx){1to16}, %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x9a,0x00,0x02,0x00,0x00]
          vpminud 512(%rdx){1to16}, %zmm23, %zmm3

// CHECK: vpminud -512(%rdx){1to16}, %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x5a,0x80]
          vpminud -512(%rdx){1to16}, %zmm23, %zmm3

// CHECK: vpminud -516(%rdx){1to16}, %zmm23, %zmm3
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x9a,0xfc,0xfd,0xff,0xff]
          vpminud -516(%rdx){1to16}, %zmm23, %zmm3

// CHECK: vpminuq %zmm7, %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0xdf]
          vpminuq %zmm7, %zmm26, %zmm11

// CHECK: vpminuq %zmm7, %zmm26, %zmm11 {%k5}
// CHECK:  encoding: [0x62,0x72,0xad,0x45,0x3b,0xdf]
          vpminuq %zmm7, %zmm26, %zmm11 {%k5}

// CHECK: vpminuq %zmm7, %zmm26, %zmm11 {%k5} {z}
// CHECK:  encoding: [0x62,0x72,0xad,0xc5,0x3b,0xdf]
          vpminuq %zmm7, %zmm26, %zmm11 {%k5} {z}

// CHECK: vpminuq (%rcx), %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x19]
          vpminuq (%rcx), %zmm26, %zmm11

// CHECK: vpminuq 291(%rax,%r14,8), %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x32,0xad,0x40,0x3b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminuq 291(%rax,%r14,8), %zmm26, %zmm11

// CHECK: vpminuq (%rcx){1to8}, %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x19]
          vpminuq (%rcx){1to8}, %zmm26, %zmm11

// CHECK: vpminuq 8128(%rdx), %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x5a,0x7f]
          vpminuq 8128(%rdx), %zmm26, %zmm11

// CHECK: vpminuq 8192(%rdx), %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x9a,0x00,0x20,0x00,0x00]
          vpminuq 8192(%rdx), %zmm26, %zmm11

// CHECK: vpminuq -8192(%rdx), %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x5a,0x80]
          vpminuq -8192(%rdx), %zmm26, %zmm11

// CHECK: vpminuq -8256(%rdx), %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x9a,0xc0,0xdf,0xff,0xff]
          vpminuq -8256(%rdx), %zmm26, %zmm11

// CHECK: vpminuq 1016(%rdx){1to8}, %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x5a,0x7f]
          vpminuq 1016(%rdx){1to8}, %zmm26, %zmm11

// CHECK: vpminuq 1024(%rdx){1to8}, %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x9a,0x00,0x04,0x00,0x00]
          vpminuq 1024(%rdx){1to8}, %zmm26, %zmm11

// CHECK: vpminuq -1024(%rdx){1to8}, %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x5a,0x80]
          vpminuq -1024(%rdx){1to8}, %zmm26, %zmm11

// CHECK: vpminuq -1032(%rdx){1to8}, %zmm26, %zmm11
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x9a,0xf8,0xfb,0xff,0xff]
          vpminuq -1032(%rdx){1to8}, %zmm26, %zmm11

// CHECK: vpmovsxbd %xmm7, %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0xdf]
          vpmovsxbd %xmm7, %zmm27

// CHECK: vpmovsxbd %xmm7, %zmm27 {%k5}
// CHECK:  encoding: [0x62,0x62,0x7d,0x4d,0x21,0xdf]
          vpmovsxbd %xmm7, %zmm27 {%k5}

// CHECK: vpmovsxbd %xmm7, %zmm27 {%k5} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xcd,0x21,0xdf]
          vpmovsxbd %xmm7, %zmm27 {%k5} {z}

// CHECK: vpmovsxbd (%rcx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x19]
          vpmovsxbd (%rcx), %zmm27

// CHECK: vpmovsxbd 291(%rax,%r14,8), %zmm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x21,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxbd 291(%rax,%r14,8), %zmm27

// CHECK: vpmovsxbd 2032(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x5a,0x7f]
          vpmovsxbd 2032(%rdx), %zmm27

// CHECK: vpmovsxbd 2048(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x9a,0x00,0x08,0x00,0x00]
          vpmovsxbd 2048(%rdx), %zmm27

// CHECK: vpmovsxbd -2048(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x5a,0x80]
          vpmovsxbd -2048(%rdx), %zmm27

// CHECK: vpmovsxbd -2064(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x9a,0xf0,0xf7,0xff,0xff]
          vpmovsxbd -2064(%rdx), %zmm27

// CHECK: vpmovsxbd (%rcx), %zmm27 {%k1}
// CHECK:  encoding: [0x62,0x62,0x7d,0x49,0x21,0x19]
          vpmovsxbd (%rcx), %zmm27 {%k1}

// CHECK: vpmovsxbd (%rcx), %zmm27 {%k2} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xca,0x21,0x19]
          vpmovsxbd (%rcx), %zmm27 {%k2} {z}

// CHECK: vpmovsxbq %xmm11, %zmm11
// CHECK:  encoding: [0x62,0x52,0x7d,0x48,0x22,0xdb]
          vpmovsxbq %xmm11, %zmm11

// CHECK: vpmovsxbq %xmm11, %zmm11 {%k5}
// CHECK:  encoding: [0x62,0x52,0x7d,0x4d,0x22,0xdb]
          vpmovsxbq %xmm11, %zmm11 {%k5}

// CHECK: vpmovsxbq %xmm11, %zmm11 {%k5} {z}
// CHECK:  encoding: [0x62,0x52,0x7d,0xcd,0x22,0xdb]
          vpmovsxbq %xmm11, %zmm11 {%k5} {z}

// CHECK: vpmovsxbq (%rcx), %zmm11
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x19]
          vpmovsxbq (%rcx), %zmm11

// CHECK: vpmovsxbq 291(%rax,%r14,8), %zmm11
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x22,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxbq 291(%rax,%r14,8), %zmm11

// CHECK: vpmovsxbq 1016(%rdx), %zmm11
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x5a,0x7f]
          vpmovsxbq 1016(%rdx), %zmm11

// CHECK: vpmovsxbq 1024(%rdx), %zmm11
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x9a,0x00,0x04,0x00,0x00]
          vpmovsxbq 1024(%rdx), %zmm11

// CHECK: vpmovsxbq -1024(%rdx), %zmm11
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x5a,0x80]
          vpmovsxbq -1024(%rdx), %zmm11

// CHECK: vpmovsxbq -1032(%rdx), %zmm11
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x9a,0xf8,0xfb,0xff,0xff]
          vpmovsxbq -1032(%rdx), %zmm11

// CHECK: vpmovsxdq %ymm29, %zmm26
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x25,0xd5]
          vpmovsxdq %ymm29, %zmm26

// CHECK: vpmovsxdq %ymm29, %zmm26 {%k1}
// CHECK:  encoding: [0x62,0x02,0x7d,0x49,0x25,0xd5]
          vpmovsxdq %ymm29, %zmm26 {%k1}

// CHECK: vpmovsxdq %ymm29, %zmm26 {%k1} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xc9,0x25,0xd5]
          vpmovsxdq %ymm29, %zmm26 {%k1} {z}

// CHECK: vpmovsxdq (%rcx), %zmm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x11]
          vpmovsxdq (%rcx), %zmm26

// CHECK: vpmovsxdq 291(%rax,%r14,8), %zmm26
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x25,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxdq 291(%rax,%r14,8), %zmm26

// CHECK: vpmovsxdq 4064(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x52,0x7f]
          vpmovsxdq 4064(%rdx), %zmm26

// CHECK: vpmovsxdq 4096(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x92,0x00,0x10,0x00,0x00]
          vpmovsxdq 4096(%rdx), %zmm26

// CHECK: vpmovsxdq -4096(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x52,0x80]
          vpmovsxdq -4096(%rdx), %zmm26

// CHECK: vpmovsxdq -4128(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x92,0xe0,0xef,0xff,0xff]
          vpmovsxdq -4128(%rdx), %zmm26

// CHECK: vpmovsxwd %ymm11, %zmm23
// CHECK:  encoding: [0x62,0xc2,0x7d,0x48,0x23,0xfb]
          vpmovsxwd %ymm11, %zmm23

// CHECK: vpmovsxwd %ymm11, %zmm23 {%k2}
// CHECK:  encoding: [0x62,0xc2,0x7d,0x4a,0x23,0xfb]
          vpmovsxwd %ymm11, %zmm23 {%k2}

// CHECK: vpmovsxwd %ymm11, %zmm23 {%k2} {z}
// CHECK:  encoding: [0x62,0xc2,0x7d,0xca,0x23,0xfb]
          vpmovsxwd %ymm11, %zmm23 {%k2} {z}

// CHECK: vpmovsxwd (%rcx), %zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0x39]
          vpmovsxwd (%rcx), %zmm23

// CHECK: vpmovsxwd 291(%rax,%r14,8), %zmm23
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x23,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxwd 291(%rax,%r14,8), %zmm23

// CHECK: vpmovsxwd 4064(%rdx), %zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0x7a,0x7f]
          vpmovsxwd 4064(%rdx), %zmm23

// CHECK: vpmovsxwd 4096(%rdx), %zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0xba,0x00,0x10,0x00,0x00]
          vpmovsxwd 4096(%rdx), %zmm23

// CHECK: vpmovsxwd -4096(%rdx), %zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0x7a,0x80]
          vpmovsxwd -4096(%rdx), %zmm23

// CHECK: vpmovsxwd -4128(%rdx), %zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0xba,0xe0,0xef,0xff,0xff]
          vpmovsxwd -4128(%rdx), %zmm23

// CHECK: vpmovsxwq %xmm25, %zmm25
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x24,0xc9]
          vpmovsxwq %xmm25, %zmm25

// CHECK: vpmovsxwq %xmm25, %zmm25 {%k4}
// CHECK:  encoding: [0x62,0x02,0x7d,0x4c,0x24,0xc9]
          vpmovsxwq %xmm25, %zmm25 {%k4}

// CHECK: vpmovsxwq %xmm25, %zmm25 {%k4} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xcc,0x24,0xc9]
          vpmovsxwq %xmm25, %zmm25 {%k4} {z}

// CHECK: vpmovsxwq (%rcx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x09]
          vpmovsxwq (%rcx), %zmm25

// CHECK: vpmovsxwq 291(%rax,%r14,8), %zmm25
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x24,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxwq 291(%rax,%r14,8), %zmm25

// CHECK: vpmovsxwq 2032(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x4a,0x7f]
          vpmovsxwq 2032(%rdx), %zmm25

// CHECK: vpmovsxwq 2048(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x8a,0x00,0x08,0x00,0x00]
          vpmovsxwq 2048(%rdx), %zmm25

// CHECK: vpmovsxwq -2048(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x4a,0x80]
          vpmovsxwq -2048(%rdx), %zmm25

// CHECK: vpmovsxwq -2064(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x8a,0xf0,0xf7,0xff,0xff]
          vpmovsxwq -2064(%rdx), %zmm25

// CHECK: vpmovzxbd %xmm25, %zmm18
// CHECK:  encoding: [0x62,0x82,0x7d,0x48,0x31,0xd1]
          vpmovzxbd %xmm25, %zmm18

// CHECK: vpmovzxbd %xmm25, %zmm18 {%k7}
// CHECK:  encoding: [0x62,0x82,0x7d,0x4f,0x31,0xd1]
          vpmovzxbd %xmm25, %zmm18 {%k7}

// CHECK: vpmovzxbd %xmm25, %zmm18 {%k7} {z}
// CHECK:  encoding: [0x62,0x82,0x7d,0xcf,0x31,0xd1]
          vpmovzxbd %xmm25, %zmm18 {%k7} {z}

// CHECK: vpmovzxbd (%rcx), %zmm18
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x11]
          vpmovzxbd (%rcx), %zmm18

// CHECK: vpmovzxbd 291(%rax,%r14,8), %zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x31,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxbd 291(%rax,%r14,8), %zmm18

// CHECK: vpmovzxbd 2032(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x52,0x7f]
          vpmovzxbd 2032(%rdx), %zmm18

// CHECK: vpmovzxbd 2048(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x92,0x00,0x08,0x00,0x00]
          vpmovzxbd 2048(%rdx), %zmm18

// CHECK: vpmovzxbd -2048(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x52,0x80]
          vpmovzxbd -2048(%rdx), %zmm18

// CHECK: vpmovzxbd -2064(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x92,0xf0,0xf7,0xff,0xff]
          vpmovzxbd -2064(%rdx), %zmm18

// CHECK: vpmovzxbq %xmm15, %zmm5
// CHECK:  encoding: [0x62,0xd2,0x7d,0x48,0x32,0xef]
          vpmovzxbq %xmm15, %zmm5

// CHECK: vpmovzxbq %xmm15, %zmm5 {%k1}
// CHECK:  encoding: [0x62,0xd2,0x7d,0x49,0x32,0xef]
          vpmovzxbq %xmm15, %zmm5 {%k1}

// CHECK: vpmovzxbq %xmm15, %zmm5 {%k1} {z}
// CHECK:  encoding: [0x62,0xd2,0x7d,0xc9,0x32,0xef]
          vpmovzxbq %xmm15, %zmm5 {%k1} {z}

// CHECK: vpmovzxbq (%rcx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0x29]
          vpmovzxbq (%rcx), %zmm5

// CHECK: vpmovzxbq 291(%rax,%r14,8), %zmm5
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x32,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxbq 291(%rax,%r14,8), %zmm5

// CHECK: vpmovzxbq 1016(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0x6a,0x7f]
          vpmovzxbq 1016(%rdx), %zmm5

// CHECK: vpmovzxbq 1024(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0xaa,0x00,0x04,0x00,0x00]
          vpmovzxbq 1024(%rdx), %zmm5

// CHECK: vpmovzxbq -1024(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0x6a,0x80]
          vpmovzxbq -1024(%rdx), %zmm5

// CHECK: vpmovzxbq -1032(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0xaa,0xf8,0xfb,0xff,0xff]
          vpmovzxbq -1032(%rdx), %zmm5

// CHECK: vpmovzxdq %ymm4, %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0xe4]
          vpmovzxdq %ymm4, %zmm20

// CHECK: vpmovzxdq %ymm4, %zmm20 {%k3}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x4b,0x35,0xe4]
          vpmovzxdq %ymm4, %zmm20 {%k3}

// CHECK: vpmovzxdq %ymm4, %zmm20 {%k3} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0xcb,0x35,0xe4]
          vpmovzxdq %ymm4, %zmm20 {%k3} {z}

// CHECK: vpmovzxdq (%rcx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0x21]
          vpmovzxdq (%rcx), %zmm20

// CHECK: vpmovzxdq 291(%rax,%r14,8), %zmm20
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x35,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxdq 291(%rax,%r14,8), %zmm20

// CHECK: vpmovzxdq 4064(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0x62,0x7f]
          vpmovzxdq 4064(%rdx), %zmm20

// CHECK: vpmovzxdq 4096(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0xa2,0x00,0x10,0x00,0x00]
          vpmovzxdq 4096(%rdx), %zmm20

// CHECK: vpmovzxdq -4096(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0x62,0x80]
          vpmovzxdq -4096(%rdx), %zmm20

// CHECK: vpmovzxdq -4128(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0xa2,0xe0,0xef,0xff,0xff]
          vpmovzxdq -4128(%rdx), %zmm20

// CHECK: vpmovzxwd %ymm6, %zmm8
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0xc6]
          vpmovzxwd %ymm6, %zmm8

// CHECK: vpmovzxwd %ymm6, %zmm8 {%k7}
// CHECK:  encoding: [0x62,0x72,0x7d,0x4f,0x33,0xc6]
          vpmovzxwd %ymm6, %zmm8 {%k7}

// CHECK: vpmovzxwd %ymm6, %zmm8 {%k7} {z}
// CHECK:  encoding: [0x62,0x72,0x7d,0xcf,0x33,0xc6]
          vpmovzxwd %ymm6, %zmm8 {%k7} {z}

// CHECK: vpmovzxwd (%rcx), %zmm8
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x01]
          vpmovzxwd (%rcx), %zmm8

// CHECK: vpmovzxwd 291(%rax,%r14,8), %zmm8
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x33,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxwd 291(%rax,%r14,8), %zmm8

// CHECK: vpmovzxwd 4064(%rdx), %zmm8
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x42,0x7f]
          vpmovzxwd 4064(%rdx), %zmm8

// CHECK: vpmovzxwd 4096(%rdx), %zmm8
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x82,0x00,0x10,0x00,0x00]
          vpmovzxwd 4096(%rdx), %zmm8

// CHECK: vpmovzxwd -4096(%rdx), %zmm8
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x42,0x80]
          vpmovzxwd -4096(%rdx), %zmm8

// CHECK: vpmovzxwd -4128(%rdx), %zmm8
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x82,0xe0,0xef,0xff,0xff]
          vpmovzxwd -4128(%rdx), %zmm8

// CHECK: vpmovzxwq %xmm15, %zmm5
// CHECK:  encoding: [0x62,0xd2,0x7d,0x48,0x34,0xef]
          vpmovzxwq %xmm15, %zmm5

// CHECK: vpmovzxwq %xmm15, %zmm5 {%k7}
// CHECK:  encoding: [0x62,0xd2,0x7d,0x4f,0x34,0xef]
          vpmovzxwq %xmm15, %zmm5 {%k7}

// CHECK: vpmovzxwq %xmm15, %zmm5 {%k7} {z}
// CHECK:  encoding: [0x62,0xd2,0x7d,0xcf,0x34,0xef]
          vpmovzxwq %xmm15, %zmm5 {%k7} {z}

// CHECK: vpmovzxwq (%rcx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0x29]
          vpmovzxwq (%rcx), %zmm5

// CHECK: vpmovzxwq 291(%rax,%r14,8), %zmm5
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x34,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxwq 291(%rax,%r14,8), %zmm5

// CHECK: vpmovzxwq 2032(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0x6a,0x7f]
          vpmovzxwq 2032(%rdx), %zmm5

// CHECK: vpmovzxwq 2048(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0xaa,0x00,0x08,0x00,0x00]
          vpmovzxwq 2048(%rdx), %zmm5

// CHECK: vpmovzxwq -2048(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0x6a,0x80]
          vpmovzxwq -2048(%rdx), %zmm5

// CHECK: vpmovzxwq -2064(%rdx), %zmm5
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0xaa,0xf0,0xf7,0xff,0xff]
          vpmovzxwq -2064(%rdx), %zmm5

// CHECK: vpmuldq %zmm9, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x42,0xb5,0x48,0x28,0xe9]
          vpmuldq %zmm9, %zmm9, %zmm29

// CHECK: vpmuldq %zmm9, %zmm9, %zmm29 {%k5}
// CHECK:  encoding: [0x62,0x42,0xb5,0x4d,0x28,0xe9]
          vpmuldq %zmm9, %zmm9, %zmm29 {%k5}

// CHECK: vpmuldq %zmm9, %zmm9, %zmm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x42,0xb5,0xcd,0x28,0xe9]
          vpmuldq %zmm9, %zmm9, %zmm29 {%k5} {z}

// CHECK: vpmuldq (%rcx), %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0x29]
          vpmuldq (%rcx), %zmm9, %zmm29

// CHECK: vpmuldq (%rcx), %zmm9, %zmm29 {%k6}
// CHECK:  encoding: [0x62,0x62,0xb5,0x4e,0x28,0x29]
          vpmuldq (%rcx), %zmm9, %zmm29 {%k6}

// CHECK: vpmuldq (%rcx), %zmm9, %zmm29 {%k6} {z}
// CHECK:  encoding: [0x62,0x62,0xb5,0xce,0x28,0x29]
          vpmuldq (%rcx), %zmm9, %zmm29 {%k6} {z}

// CHECK: vpmuldq 291(%rax,%r14,8), %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x22,0xb5,0x48,0x28,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmuldq 291(%rax,%r14,8), %zmm9, %zmm29

// CHECK: vpmuldq (%rcx){1to8}, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0x29]
          vpmuldq (%rcx){1to8}, %zmm9, %zmm29

// CHECK: vpmuldq (%rcx){1to8}, %zmm9, %zmm29 {%k3}
// CHECK:  encoding: [0x62,0x62,0xb5,0x5b,0x28,0x29]
          vpmuldq (%rcx){1to8}, %zmm9, %zmm29 {%k3}

// CHECK: vpmuldq (%rcx){1to8}, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0xdb,0x28,0x29]
          vpmuldq (%rcx){1to8}, %zmm9, %zmm29 {%k3} {z}

// CHECK: vpmuldq 8128(%rdx), %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0x6a,0x7f]
          vpmuldq 8128(%rdx), %zmm9, %zmm29

// CHECK: vpmuldq 8192(%rdx), %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0xaa,0x00,0x20,0x00,0x00]
          vpmuldq 8192(%rdx), %zmm9, %zmm29

// CHECK: vpmuldq -8192(%rdx), %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0x6a,0x80]
          vpmuldq -8192(%rdx), %zmm9, %zmm29

// CHECK: vpmuldq -8256(%rdx), %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0xaa,0xc0,0xdf,0xff,0xff]
          vpmuldq -8256(%rdx), %zmm9, %zmm29

// CHECK: vpmuldq 1016(%rdx){1to8}, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0x6a,0x7f]
          vpmuldq 1016(%rdx){1to8}, %zmm9, %zmm29

// CHECK: vpmuldq 1024(%rdx){1to8}, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0xaa,0x00,0x04,0x00,0x00]
          vpmuldq 1024(%rdx){1to8}, %zmm9, %zmm29

// CHECK: vpmuldq -1024(%rdx){1to8}, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0x6a,0x80]
          vpmuldq -1024(%rdx){1to8}, %zmm9, %zmm29

// CHECK: vpmuldq -1032(%rdx){1to8}, %zmm9, %zmm29
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0xaa,0xf8,0xfb,0xff,0xff]
          vpmuldq -1032(%rdx){1to8}, %zmm9, %zmm29

// CHECK: vpmulld %zmm2, %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0xe2]
          vpmulld %zmm2, %zmm3, %zmm12

// CHECK: vpmulld %zmm2, %zmm3, %zmm12 {%k6}
// CHECK:  encoding: [0x62,0x72,0x65,0x4e,0x40,0xe2]
          vpmulld %zmm2, %zmm3, %zmm12 {%k6}

// CHECK: vpmulld %zmm2, %zmm3, %zmm12 {%k6} {z}
// CHECK:  encoding: [0x62,0x72,0x65,0xce,0x40,0xe2]
          vpmulld %zmm2, %zmm3, %zmm12 {%k6} {z}

// CHECK: vpmulld (%rcx), %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0x21]
          vpmulld (%rcx), %zmm3, %zmm12

// CHECK: vpmulld 291(%rax,%r14,8), %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x32,0x65,0x48,0x40,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmulld 291(%rax,%r14,8), %zmm3, %zmm12

// CHECK: vpmulld (%rcx){1to16}, %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0x21]
          vpmulld (%rcx){1to16}, %zmm3, %zmm12

// CHECK: vpmulld 8128(%rdx), %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0x62,0x7f]
          vpmulld 8128(%rdx), %zmm3, %zmm12

// CHECK: vpmulld 8192(%rdx), %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0xa2,0x00,0x20,0x00,0x00]
          vpmulld 8192(%rdx), %zmm3, %zmm12

// CHECK: vpmulld -8192(%rdx), %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0x62,0x80]
          vpmulld -8192(%rdx), %zmm3, %zmm12

// CHECK: vpmulld -8256(%rdx), %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0xa2,0xc0,0xdf,0xff,0xff]
          vpmulld -8256(%rdx), %zmm3, %zmm12

// CHECK: vpmulld 508(%rdx){1to16}, %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0x62,0x7f]
          vpmulld 508(%rdx){1to16}, %zmm3, %zmm12

// CHECK: vpmulld 512(%rdx){1to16}, %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0xa2,0x00,0x02,0x00,0x00]
          vpmulld 512(%rdx){1to16}, %zmm3, %zmm12

// CHECK: vpmulld -512(%rdx){1to16}, %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0x62,0x80]
          vpmulld -512(%rdx){1to16}, %zmm3, %zmm12

// CHECK: vpmulld -516(%rdx){1to16}, %zmm3, %zmm12
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0xa2,0xfc,0xfd,0xff,0xff]
          vpmulld -516(%rdx){1to16}, %zmm3, %zmm12

// CHECK: vpmuludq %zmm9, %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xc1,0xd5,0x48,0xf4,0xf9]
          vpmuludq %zmm9, %zmm5, %zmm23

// CHECK: vpmuludq %zmm9, %zmm5, %zmm23 {%k4}
// CHECK:  encoding: [0x62,0xc1,0xd5,0x4c,0xf4,0xf9]
          vpmuludq %zmm9, %zmm5, %zmm23 {%k4}

// CHECK: vpmuludq %zmm9, %zmm5, %zmm23 {%k4} {z}
// CHECK:  encoding: [0x62,0xc1,0xd5,0xcc,0xf4,0xf9]
          vpmuludq %zmm9, %zmm5, %zmm23 {%k4} {z}

// CHECK: vpmuludq (%rcx), %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0x39]
          vpmuludq (%rcx), %zmm5, %zmm23

// CHECK: vpmuludq 291(%rax,%r14,8), %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xa1,0xd5,0x48,0xf4,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmuludq 291(%rax,%r14,8), %zmm5, %zmm23

// CHECK: vpmuludq (%rcx){1to8}, %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0x39]
          vpmuludq (%rcx){1to8}, %zmm5, %zmm23

// CHECK: vpmuludq 8128(%rdx), %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0x7a,0x7f]
          vpmuludq 8128(%rdx), %zmm5, %zmm23

// CHECK: vpmuludq 8192(%rdx), %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0xba,0x00,0x20,0x00,0x00]
          vpmuludq 8192(%rdx), %zmm5, %zmm23

// CHECK: vpmuludq -8192(%rdx), %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0x7a,0x80]
          vpmuludq -8192(%rdx), %zmm5, %zmm23

// CHECK: vpmuludq -8256(%rdx), %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0xba,0xc0,0xdf,0xff,0xff]
          vpmuludq -8256(%rdx), %zmm5, %zmm23

// CHECK: vpmuludq 1016(%rdx){1to8}, %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0x7a,0x7f]
          vpmuludq 1016(%rdx){1to8}, %zmm5, %zmm23

// CHECK: vpmuludq 1024(%rdx){1to8}, %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0xba,0x00,0x04,0x00,0x00]
          vpmuludq 1024(%rdx){1to8}, %zmm5, %zmm23

// CHECK: vpmuludq -1024(%rdx){1to8}, %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0x7a,0x80]
          vpmuludq -1024(%rdx){1to8}, %zmm5, %zmm23

// CHECK: vpmuludq -1032(%rdx){1to8}, %zmm5, %zmm23
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0xba,0xf8,0xfb,0xff,0xff]
          vpmuludq -1032(%rdx){1to8}, %zmm5, %zmm23

// CHECK: vpord  %zmm20, %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x6d,0x48,0xeb,0xfc]
          vpord  %zmm20, %zmm2, %zmm23

// CHECK: vpord  %zmm20, %zmm2, %zmm23 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x6d,0x4a,0xeb,0xfc]
          vpord  %zmm20, %zmm2, %zmm23 {%k2}

// CHECK: vpord  %zmm20, %zmm2, %zmm23 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x6d,0xca,0xeb,0xfc]
          vpord  %zmm20, %zmm2, %zmm23 {%k2} {z}

// CHECK: vpord  (%rcx), %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0x39]
          vpord  (%rcx), %zmm2, %zmm23

// CHECK: vpord  291(%rax,%r14,8), %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x6d,0x48,0xeb,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpord  291(%rax,%r14,8), %zmm2, %zmm23

// CHECK: vpord  (%rcx){1to16}, %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0x39]
          vpord  (%rcx){1to16}, %zmm2, %zmm23

// CHECK: vpord  8128(%rdx), %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0x7a,0x7f]
          vpord  8128(%rdx), %zmm2, %zmm23

// CHECK: vpord  8192(%rdx), %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0xba,0x00,0x20,0x00,0x00]
          vpord  8192(%rdx), %zmm2, %zmm23

// CHECK: vpord  -8192(%rdx), %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0x7a,0x80]
          vpord  -8192(%rdx), %zmm2, %zmm23

// CHECK: vpord  -8256(%rdx), %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0xba,0xc0,0xdf,0xff,0xff]
          vpord  -8256(%rdx), %zmm2, %zmm23

// CHECK: vpord  508(%rdx){1to16}, %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0x7a,0x7f]
          vpord  508(%rdx){1to16}, %zmm2, %zmm23

// CHECK: vpord  512(%rdx){1to16}, %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0xba,0x00,0x02,0x00,0x00]
          vpord  512(%rdx){1to16}, %zmm2, %zmm23

// CHECK: vpord  -512(%rdx){1to16}, %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0x7a,0x80]
          vpord  -512(%rdx){1to16}, %zmm2, %zmm23

// CHECK: vpord  -516(%rdx){1to16}, %zmm2, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0xba,0xfc,0xfd,0xff,0xff]
          vpord  -516(%rdx){1to16}, %zmm2, %zmm23

// CHECK: vporq  %zmm6, %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0xce]
          vporq  %zmm6, %zmm10, %zmm1

// CHECK: vporq  %zmm6, %zmm10, %zmm1 {%k2}
// CHECK:  encoding: [0x62,0xf1,0xad,0x4a,0xeb,0xce]
          vporq  %zmm6, %zmm10, %zmm1 {%k2}

// CHECK: vporq  %zmm6, %zmm10, %zmm1 {%k2} {z}
// CHECK:  encoding: [0x62,0xf1,0xad,0xca,0xeb,0xce]
          vporq  %zmm6, %zmm10, %zmm1 {%k2} {z}

// CHECK: vporq  (%rcx), %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x09]
          vporq  (%rcx), %zmm10, %zmm1

// CHECK: vporq  291(%rax,%r14,8), %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xb1,0xad,0x48,0xeb,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vporq  291(%rax,%r14,8), %zmm10, %zmm1

// CHECK: vporq  (%rcx){1to8}, %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x09]
          vporq  (%rcx){1to8}, %zmm10, %zmm1

// CHECK: vporq  8128(%rdx), %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x4a,0x7f]
          vporq  8128(%rdx), %zmm10, %zmm1

// CHECK: vporq  8192(%rdx), %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x8a,0x00,0x20,0x00,0x00]
          vporq  8192(%rdx), %zmm10, %zmm1

// CHECK: vporq  -8192(%rdx), %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x4a,0x80]
          vporq  -8192(%rdx), %zmm10, %zmm1

// CHECK: vporq  -8256(%rdx), %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x8a,0xc0,0xdf,0xff,0xff]
          vporq  -8256(%rdx), %zmm10, %zmm1

// CHECK: vporq  1016(%rdx){1to8}, %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x4a,0x7f]
          vporq  1016(%rdx){1to8}, %zmm10, %zmm1

// CHECK: vporq  1024(%rdx){1to8}, %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x8a,0x00,0x04,0x00,0x00]
          vporq  1024(%rdx){1to8}, %zmm10, %zmm1

// CHECK: vporq  -1024(%rdx){1to8}, %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x4a,0x80]
          vporq  -1024(%rdx){1to8}, %zmm10, %zmm1

// CHECK: vporq  -1032(%rdx){1to8}, %zmm10, %zmm1
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x8a,0xf8,0xfb,0xff,0xff]
          vporq  -1032(%rdx){1to8}, %zmm10, %zmm1

// CHECK: vpsubd %zmm7, %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0xff]
          vpsubd %zmm7, %zmm28, %zmm7

// CHECK: vpsubd %zmm7, %zmm28, %zmm7 {%k3}
// CHECK:  encoding: [0x62,0xf1,0x1d,0x43,0xfa,0xff]
          vpsubd %zmm7, %zmm28, %zmm7 {%k3}

// CHECK: vpsubd %zmm7, %zmm28, %zmm7 {%k3} {z}
// CHECK:  encoding: [0x62,0xf1,0x1d,0xc3,0xfa,0xff]
          vpsubd %zmm7, %zmm28, %zmm7 {%k3} {z}

// CHECK: vpsubd (%rcx), %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0x39]
          vpsubd (%rcx), %zmm28, %zmm7

// CHECK: vpsubd 291(%rax,%r14,8), %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xb1,0x1d,0x40,0xfa,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpsubd 291(%rax,%r14,8), %zmm28, %zmm7

// CHECK: vpsubd (%rcx){1to16}, %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0x39]
          vpsubd (%rcx){1to16}, %zmm28, %zmm7

// CHECK: vpsubd 8128(%rdx), %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0x7a,0x7f]
          vpsubd 8128(%rdx), %zmm28, %zmm7

// CHECK: vpsubd 8192(%rdx), %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0xba,0x00,0x20,0x00,0x00]
          vpsubd 8192(%rdx), %zmm28, %zmm7

// CHECK: vpsubd -8192(%rdx), %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0x7a,0x80]
          vpsubd -8192(%rdx), %zmm28, %zmm7

// CHECK: vpsubd -8256(%rdx), %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0xba,0xc0,0xdf,0xff,0xff]
          vpsubd -8256(%rdx), %zmm28, %zmm7

// CHECK: vpsubd 508(%rdx){1to16}, %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0x7a,0x7f]
          vpsubd 508(%rdx){1to16}, %zmm28, %zmm7

// CHECK: vpsubd 512(%rdx){1to16}, %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0xba,0x00,0x02,0x00,0x00]
          vpsubd 512(%rdx){1to16}, %zmm28, %zmm7

// CHECK: vpsubd -512(%rdx){1to16}, %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0x7a,0x80]
          vpsubd -512(%rdx){1to16}, %zmm28, %zmm7

// CHECK: vpsubd -516(%rdx){1to16}, %zmm28, %zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0xba,0xfc,0xfd,0xff,0xff]
          vpsubd -516(%rdx){1to16}, %zmm28, %zmm7

// CHECK: vpsubq %zmm17, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0xfb,0xe9]
          vpsubq %zmm17, %zmm28, %zmm29

// CHECK: vpsubq %zmm17, %zmm28, %zmm29 {%k2}
// CHECK:  encoding: [0x62,0x21,0x9d,0x42,0xfb,0xe9]
          vpsubq %zmm17, %zmm28, %zmm29 {%k2}

// CHECK: vpsubq %zmm17, %zmm28, %zmm29 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x9d,0xc2,0xfb,0xe9]
          vpsubq %zmm17, %zmm28, %zmm29 {%k2} {z}

// CHECK: vpsubq (%rcx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0x29]
          vpsubq (%rcx), %zmm28, %zmm29

// CHECK: vpsubq 291(%rax,%r14,8), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0xfb,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpsubq 291(%rax,%r14,8), %zmm28, %zmm29

// CHECK: vpsubq (%rcx){1to8}, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0x29]
          vpsubq (%rcx){1to8}, %zmm28, %zmm29

// CHECK: vpsubq 8128(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0x6a,0x7f]
          vpsubq 8128(%rdx), %zmm28, %zmm29

// CHECK: vpsubq 8192(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0xaa,0x00,0x20,0x00,0x00]
          vpsubq 8192(%rdx), %zmm28, %zmm29

// CHECK: vpsubq -8192(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0x6a,0x80]
          vpsubq -8192(%rdx), %zmm28, %zmm29

// CHECK: vpsubq -8256(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0xaa,0xc0,0xdf,0xff,0xff]
          vpsubq -8256(%rdx), %zmm28, %zmm29

// CHECK: vpsubq 1016(%rdx){1to8}, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0x6a,0x7f]
          vpsubq 1016(%rdx){1to8}, %zmm28, %zmm29

// CHECK: vpsubq 1024(%rdx){1to8}, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0xaa,0x00,0x04,0x00,0x00]
          vpsubq 1024(%rdx){1to8}, %zmm28, %zmm29

// CHECK: vpsubq -1024(%rdx){1to8}, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0x6a,0x80]
          vpsubq -1024(%rdx){1to8}, %zmm28, %zmm29

// CHECK: vpsubq -1032(%rdx){1to8}, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0xaa,0xf8,0xfb,0xff,0xff]
          vpsubq -1032(%rdx){1to8}, %zmm28, %zmm29

// CHECK: vpxord %zmm24, %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x11,0x1d,0x48,0xef,0xc0]
          vpxord %zmm24, %zmm12, %zmm8

// CHECK: vpxord %zmm24, %zmm12, %zmm8 {%k6}
// CHECK:  encoding: [0x62,0x11,0x1d,0x4e,0xef,0xc0]
          vpxord %zmm24, %zmm12, %zmm8 {%k6}

// CHECK: vpxord %zmm24, %zmm12, %zmm8 {%k6} {z}
// CHECK:  encoding: [0x62,0x11,0x1d,0xce,0xef,0xc0]
          vpxord %zmm24, %zmm12, %zmm8 {%k6} {z}

// CHECK: vpxord (%rcx), %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x01]
          vpxord (%rcx), %zmm12, %zmm8

// CHECK: vpxord 291(%rax,%r14,8), %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x31,0x1d,0x48,0xef,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpxord 291(%rax,%r14,8), %zmm12, %zmm8

// CHECK: vpxord (%rcx){1to16}, %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x01]
          vpxord (%rcx){1to16}, %zmm12, %zmm8

// CHECK: vpxord 8128(%rdx), %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x42,0x7f]
          vpxord 8128(%rdx), %zmm12, %zmm8

// CHECK: vpxord 8192(%rdx), %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x82,0x00,0x20,0x00,0x00]
          vpxord 8192(%rdx), %zmm12, %zmm8

// CHECK: vpxord -8192(%rdx), %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x42,0x80]
          vpxord -8192(%rdx), %zmm12, %zmm8

// CHECK: vpxord -8256(%rdx), %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x82,0xc0,0xdf,0xff,0xff]
          vpxord -8256(%rdx), %zmm12, %zmm8

// CHECK: vpxord 508(%rdx){1to16}, %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x42,0x7f]
          vpxord 508(%rdx){1to16}, %zmm12, %zmm8

// CHECK: vpxord 512(%rdx){1to16}, %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x82,0x00,0x02,0x00,0x00]
          vpxord 512(%rdx){1to16}, %zmm12, %zmm8

// CHECK: vpxord -512(%rdx){1to16}, %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x42,0x80]
          vpxord -512(%rdx){1to16}, %zmm12, %zmm8

// CHECK: vpxord -516(%rdx){1to16}, %zmm12, %zmm8
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x82,0xfc,0xfd,0xff,0xff]
          vpxord -516(%rdx){1to16}, %zmm12, %zmm8

// CHECK: vpxorq %zmm10, %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xd1,0xcd,0x40,0xef,0xfa]
          vpxorq %zmm10, %zmm22, %zmm7

// CHECK: vpxorq %zmm10, %zmm22, %zmm7 {%k6}
// CHECK:  encoding: [0x62,0xd1,0xcd,0x46,0xef,0xfa]
          vpxorq %zmm10, %zmm22, %zmm7 {%k6}

// CHECK: vpxorq %zmm10, %zmm22, %zmm7 {%k6} {z}
// CHECK:  encoding: [0x62,0xd1,0xcd,0xc6,0xef,0xfa]
          vpxorq %zmm10, %zmm22, %zmm7 {%k6} {z}

// CHECK: vpxorq (%rcx), %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0x39]
          vpxorq (%rcx), %zmm22, %zmm7

// CHECK: vpxorq 291(%rax,%r14,8), %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xb1,0xcd,0x40,0xef,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpxorq 291(%rax,%r14,8), %zmm22, %zmm7

// CHECK: vpxorq (%rcx){1to8}, %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0x39]
          vpxorq (%rcx){1to8}, %zmm22, %zmm7

// CHECK: vpxorq 8128(%rdx), %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0x7a,0x7f]
          vpxorq 8128(%rdx), %zmm22, %zmm7

// CHECK: vpxorq 8192(%rdx), %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0xba,0x00,0x20,0x00,0x00]
          vpxorq 8192(%rdx), %zmm22, %zmm7

// CHECK: vpxorq -8192(%rdx), %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0x7a,0x80]
          vpxorq -8192(%rdx), %zmm22, %zmm7

// CHECK: vpxorq -8256(%rdx), %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0xba,0xc0,0xdf,0xff,0xff]
          vpxorq -8256(%rdx), %zmm22, %zmm7

// CHECK: vpxorq 1016(%rdx){1to8}, %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0x7a,0x7f]
          vpxorq 1016(%rdx){1to8}, %zmm22, %zmm7

// CHECK: vpxorq 1024(%rdx){1to8}, %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0xba,0x00,0x04,0x00,0x00]
          vpxorq 1024(%rdx){1to8}, %zmm22, %zmm7

// CHECK: vpxorq -1024(%rdx){1to8}, %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0x7a,0x80]
          vpxorq -1024(%rdx){1to8}, %zmm22, %zmm7

// CHECK: vpxorq -1032(%rdx){1to8}, %zmm22, %zmm7
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0xba,0xf8,0xfb,0xff,0xff]
          vpxorq -1032(%rdx){1to8}, %zmm22, %zmm7

// CHECK: vsubpd %zmm9, %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x51,0x9d,0x48,0x5c,0xc9]
          vsubpd %zmm9, %zmm12, %zmm9

// CHECK: vsubpd %zmm9, %zmm12, %zmm9 {%k7}
// CHECK:  encoding: [0x62,0x51,0x9d,0x4f,0x5c,0xc9]
          vsubpd %zmm9, %zmm12, %zmm9 {%k7}

// CHECK: vsubpd %zmm9, %zmm12, %zmm9 {%k7} {z}
// CHECK:  encoding: [0x62,0x51,0x9d,0xcf,0x5c,0xc9]
          vsubpd %zmm9, %zmm12, %zmm9 {%k7} {z}

// CHECK: vsubpd (%rcx), %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x09]
          vsubpd (%rcx), %zmm12, %zmm9

// CHECK: vsubpd 291(%rax,%r14,8), %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x31,0x9d,0x48,0x5c,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vsubpd 291(%rax,%r14,8), %zmm12, %zmm9

// CHECK: vsubpd (%rcx){1to8}, %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x09]
          vsubpd (%rcx){1to8}, %zmm12, %zmm9

// CHECK: vsubpd 8128(%rdx), %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x4a,0x7f]
          vsubpd 8128(%rdx), %zmm12, %zmm9

// CHECK: vsubpd 8192(%rdx), %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x8a,0x00,0x20,0x00,0x00]
          vsubpd 8192(%rdx), %zmm12, %zmm9

// CHECK: vsubpd -8192(%rdx), %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x4a,0x80]
          vsubpd -8192(%rdx), %zmm12, %zmm9

// CHECK: vsubpd -8256(%rdx), %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x8a,0xc0,0xdf,0xff,0xff]
          vsubpd -8256(%rdx), %zmm12, %zmm9

// CHECK: vsubpd 1016(%rdx){1to8}, %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x4a,0x7f]
          vsubpd 1016(%rdx){1to8}, %zmm12, %zmm9

// CHECK: vsubpd 1024(%rdx){1to8}, %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x8a,0x00,0x04,0x00,0x00]
          vsubpd 1024(%rdx){1to8}, %zmm12, %zmm9

// CHECK: vsubpd -1024(%rdx){1to8}, %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x4a,0x80]
          vsubpd -1024(%rdx){1to8}, %zmm12, %zmm9

// CHECK: vsubpd -1032(%rdx){1to8}, %zmm12, %zmm9
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x8a,0xf8,0xfb,0xff,0xff]
          vsubpd -1032(%rdx){1to8}, %zmm12, %zmm9

// CHECK: vsubps %zmm21, %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x31,0x24,0x40,0x5c,0xf5]
          vsubps %zmm21, %zmm27, %zmm14

// CHECK: vsubps %zmm21, %zmm27, %zmm14 {%k5}
// CHECK:  encoding: [0x62,0x31,0x24,0x45,0x5c,0xf5]
          vsubps %zmm21, %zmm27, %zmm14 {%k5}

// CHECK: vsubps %zmm21, %zmm27, %zmm14 {%k5} {z}
// CHECK:  encoding: [0x62,0x31,0x24,0xc5,0x5c,0xf5]
          vsubps %zmm21, %zmm27, %zmm14 {%k5} {z}

// CHECK: vsubps (%rcx), %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0x31]
          vsubps (%rcx), %zmm27, %zmm14

// CHECK: vsubps 291(%rax,%r14,8), %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x31,0x24,0x40,0x5c,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vsubps 291(%rax,%r14,8), %zmm27, %zmm14

// CHECK: vsubps (%rcx){1to16}, %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0x31]
          vsubps (%rcx){1to16}, %zmm27, %zmm14

// CHECK: vsubps 8128(%rdx), %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0x72,0x7f]
          vsubps 8128(%rdx), %zmm27, %zmm14

// CHECK: vsubps 8192(%rdx), %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0xb2,0x00,0x20,0x00,0x00]
          vsubps 8192(%rdx), %zmm27, %zmm14

// CHECK: vsubps -8192(%rdx), %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0x72,0x80]
          vsubps -8192(%rdx), %zmm27, %zmm14

// CHECK: vsubps -8256(%rdx), %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0xb2,0xc0,0xdf,0xff,0xff]
          vsubps -8256(%rdx), %zmm27, %zmm14

// CHECK: vsubps 508(%rdx){1to16}, %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0x72,0x7f]
          vsubps 508(%rdx){1to16}, %zmm27, %zmm14

// CHECK: vsubps 512(%rdx){1to16}, %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0xb2,0x00,0x02,0x00,0x00]
          vsubps 512(%rdx){1to16}, %zmm27, %zmm14

// CHECK: vsubps -512(%rdx){1to16}, %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0x72,0x80]
          vsubps -512(%rdx){1to16}, %zmm27, %zmm14

// CHECK: vsubps -516(%rdx){1to16}, %zmm27, %zmm14
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0xb2,0xfc,0xfd,0xff,0xff]
          vsubps -516(%rdx){1to16}, %zmm27, %zmm14

// CHECK: kandw  %k6, %k5, %k2
// CHECK:  encoding: [0xc5,0xd4,0x41,0xd6]
          kandw  %k6, %k5, %k2

// CHECK: kandnw %k7, %k6, %k4
// CHECK:  encoding: [0xc5,0xcc,0x42,0xe7]
          kandnw %k7, %k6, %k4

// CHECK: korw   %k7, %k6, %k4
// CHECK:  encoding: [0xc5,0xcc,0x45,0xe7]
          korw   %k7, %k6, %k4

// CHECK: kxnorw %k5, %k5, %k3
// CHECK:  encoding: [0xc5,0xd4,0x46,0xdd]
          kxnorw %k5, %k5, %k3

// CHECK: kxorw  %k7, %k6, %k2
// CHECK:  encoding: [0xc5,0xcc,0x47,0xd7]
          kxorw  %k7, %k6, %k2

// CHECK: knotw  %k6, %k3
// CHECK:  encoding: [0xc5,0xf8,0x44,0xde]
          knotw  %k6, %k3

// CHECK: kmovw  %k5, %k4
// CHECK:  encoding: [0xc5,0xf8,0x90,0xe5]
          kmovw  %k5, %k4

// CHECK: kmovw  (%rcx), %k4
// CHECK:  encoding: [0xc5,0xf8,0x90,0x21]
          kmovw  (%rcx), %k4

// CHECK: kmovw  291(%rax,%r14,8), %k4
// CHECK:  encoding: [0xc4,0xa1,0x78,0x90,0xa4,0xf0,0x23,0x01,0x00,0x00]
          kmovw  291(%rax,%r14,8), %k4

// CHECK: kmovw  %k4, (%rcx)
// CHECK:  encoding: [0xc5,0xf8,0x91,0x21]
          kmovw  %k4, (%rcx)

// CHECK: kmovw  %k4, 291(%rax,%r14,8)
// CHECK:  encoding: [0xc4,0xa1,0x78,0x91,0xa4,0xf0,0x23,0x01,0x00,0x00]
          kmovw  %k4, 291(%rax,%r14,8)

// CHECK: kmovw  %eax, %k3
// CHECK:  encoding: [0xc5,0xf8,0x92,0xd8]
          kmovw  %eax, %k3

// CHECK: kmovw  %ebp, %k3
// CHECK:  encoding: [0xc5,0xf8,0x92,0xdd]
          kmovw  %ebp, %k3

// CHECK: kmovw  %r13d, %k3
// CHECK:  encoding: [0xc4,0xc1,0x78,0x92,0xdd]
          kmovw  %r13d, %k3

// CHECK: kmovw  %k2, %eax
// CHECK:  encoding: [0xc5,0xf8,0x93,0xc2]
          kmovw  %k2, %eax

// CHECK: kmovw  %k2, %ebp
// CHECK:  encoding: [0xc5,0xf8,0x93,0xea]
          kmovw  %k2, %ebp

// CHECK: kmovw  %k2, %r13d
// CHECK:  encoding: [0xc5,0x78,0x93,0xea]
          kmovw  %k2, %r13d

// CHECK: vmovapd %zmm18, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x11]
          vmovapd %zmm18, (%rcx)

// CHECK: vmovapd %zmm18, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x4e,0x29,0x11]
          vmovapd %zmm18, (%rcx) {%k6}

// CHECK: vmovapd %zmm18, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x29,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovapd %zmm18, 291(%rax,%r14,8)

// CHECK: vmovapd %zmm18, 8128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x52,0x7f]
          vmovapd %zmm18, 8128(%rdx)

// CHECK: vmovapd %zmm18, 8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x92,0x00,0x20,0x00,0x00]
          vmovapd %zmm18, 8192(%rdx)

// CHECK: vmovapd %zmm18, -8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x52,0x80]
          vmovapd %zmm18, -8192(%rdx)

// CHECK: vmovapd %zmm18, -8256(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x92,0xc0,0xdf,0xff,0xff]
          vmovapd %zmm18, -8256(%rdx)

// CHECK: vmovaps %zmm9, (%rcx)
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x09]
          vmovaps %zmm9, (%rcx)

// CHECK: vmovaps %zmm9, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0x71,0x7c,0x4b,0x29,0x09]
          vmovaps %zmm9, (%rcx) {%k3}

// CHECK: vmovaps %zmm9, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x31,0x7c,0x48,0x29,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovaps %zmm9, 291(%rax,%r14,8)

// CHECK: vmovaps %zmm9, 8128(%rdx)
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x4a,0x7f]
          vmovaps %zmm9, 8128(%rdx)

// CHECK: vmovaps %zmm9, 8192(%rdx)
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x8a,0x00,0x20,0x00,0x00]
          vmovaps %zmm9, 8192(%rdx)

// CHECK: vmovaps %zmm9, -8192(%rdx)
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x4a,0x80]
          vmovaps %zmm9, -8192(%rdx)

// CHECK: vmovaps %zmm9, -8256(%rdx)
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x8a,0xc0,0xdf,0xff,0xff]
          vmovaps %zmm9, -8256(%rdx)

// CHECK: vmovdqa32 %zmm18, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x11]
          vmovdqa32 %zmm18, (%rcx)

// CHECK: vmovdqa32 %zmm18, (%rcx) {%k4}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x4c,0x7f,0x11]
          vmovdqa32 %zmm18, (%rcx) {%k4}

// CHECK: vmovdqa32 %zmm18, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x7f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 %zmm18, 291(%rax,%r14,8)

// CHECK: vmovdqa32 %zmm18, 8128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x52,0x7f]
          vmovdqa32 %zmm18, 8128(%rdx)

// CHECK: vmovdqa32 %zmm18, 8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x92,0x00,0x20,0x00,0x00]
          vmovdqa32 %zmm18, 8192(%rdx)

// CHECK: vmovdqa32 %zmm18, -8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x52,0x80]
          vmovdqa32 %zmm18, -8192(%rdx)

// CHECK: vmovdqa32 %zmm18, -8256(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x92,0xc0,0xdf,0xff,0xff]
          vmovdqa32 %zmm18, -8256(%rdx)

// CHECK: vmovdqa64 %zmm19, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x19]
          vmovdqa64 %zmm19, (%rcx)

// CHECK: vmovdqa64 %zmm19, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x4d,0x7f,0x19]
          vmovdqa64 %zmm19, (%rcx) {%k5}

// CHECK: vmovdqa64 %zmm19, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x7f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 %zmm19, 291(%rax,%r14,8)

// CHECK: vmovdqa64 %zmm19, 8128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5a,0x7f]
          vmovdqa64 %zmm19, 8128(%rdx)

// CHECK: vmovdqa64 %zmm19, 8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x9a,0x00,0x20,0x00,0x00]
          vmovdqa64 %zmm19, 8192(%rdx)

// CHECK: vmovdqa64 %zmm19, -8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5a,0x80]
          vmovdqa64 %zmm19, -8192(%rdx)

// CHECK: vmovdqa64 %zmm19, -8256(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x9a,0xc0,0xdf,0xff,0xff]
          vmovdqa64 %zmm19, -8256(%rdx)

// CHECK: vmovdqu32 %zmm22, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x31]
          vmovdqu32 %zmm22, (%rcx)

// CHECK: vmovdqu32 %zmm22, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x49,0x7f,0x31]
          vmovdqu32 %zmm22, (%rcx) {%k1}

// CHECK: vmovdqu32 %zmm22, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x7f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 %zmm22, 291(%rax,%r14,8)

// CHECK: vmovdqu32 %zmm22, 8128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x72,0x7f]
          vmovdqu32 %zmm22, 8128(%rdx)

// CHECK: vmovdqu32 %zmm22, 8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqu32 %zmm22, 8192(%rdx)

// CHECK: vmovdqu32 %zmm22, -8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x72,0x80]
          vmovdqu32 %zmm22, -8192(%rdx)

// CHECK: vmovdqu32 %zmm22, -8256(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqu32 %zmm22, -8256(%rdx)

// CHECK: vmovdqu64 %zmm24, (%rcx)
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x01]
          vmovdqu64 %zmm24, (%rcx)

// CHECK: vmovdqu64 %zmm24, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0x61,0xfe,0x4d,0x7f,0x01]
          vmovdqu64 %zmm24, (%rcx) {%k5}

// CHECK: vmovdqu64 %zmm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0xfe,0x48,0x7f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 %zmm24, 291(%rax,%r14,8)

// CHECK: vmovdqu64 %zmm24, 8128(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x42,0x7f]
          vmovdqu64 %zmm24, 8128(%rdx)

// CHECK: vmovdqu64 %zmm24, 8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x82,0x00,0x20,0x00,0x00]
          vmovdqu64 %zmm24, 8192(%rdx)

// CHECK: vmovdqu64 %zmm24, -8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x42,0x80]
          vmovdqu64 %zmm24, -8192(%rdx)

// CHECK: vmovdqu64 %zmm24, -8256(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x82,0xc0,0xdf,0xff,0xff]
          vmovdqu64 %zmm24, -8256(%rdx)

// CHECK: vmovupd %zmm10, (%rcx)
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x11]
          vmovupd %zmm10, (%rcx)

// CHECK: vmovupd %zmm10, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0x71,0xfd,0x4f,0x11,0x11]
          vmovupd %zmm10, (%rcx) {%k7}

// CHECK: vmovupd %zmm10, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x31,0xfd,0x48,0x11,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovupd %zmm10, 291(%rax,%r14,8)

// CHECK: vmovupd %zmm10, 8128(%rdx)
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x52,0x7f]
          vmovupd %zmm10, 8128(%rdx)

// CHECK: vmovupd %zmm10, 8192(%rdx)
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x92,0x00,0x20,0x00,0x00]
          vmovupd %zmm10, 8192(%rdx)

// CHECK: vmovupd %zmm10, -8192(%rdx)
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x52,0x80]
          vmovupd %zmm10, -8192(%rdx)

// CHECK: vmovupd %zmm10, -8256(%rdx)
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x92,0xc0,0xdf,0xff,0xff]
          vmovupd %zmm10, -8256(%rdx)

// CHECK: vmovups %zmm24, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x01]
          vmovups %zmm24, (%rcx)

// CHECK: vmovups %zmm24, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0x61,0x7c,0x4f,0x11,0x01]
          vmovups %zmm24, (%rcx) {%k7}

// CHECK: vmovups %zmm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7c,0x48,0x11,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovups %zmm24, 291(%rax,%r14,8)

// CHECK: vmovups %zmm24, 8128(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x42,0x7f]
          vmovups %zmm24, 8128(%rdx)

// CHECK: vmovups %zmm24, 8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x82,0x00,0x20,0x00,0x00]
          vmovups %zmm24, 8192(%rdx)

// CHECK: vmovups %zmm24, -8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x42,0x80]
          vmovups %zmm24, -8192(%rdx)

// CHECK: vmovups %zmm24, -8256(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x82,0xc0,0xdf,0xff,0xff]
          vmovups %zmm24, -8256(%rdx)

// CHECK: vpmovqb %zmm2, %xmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0xd3]
          vpmovqb %zmm2, %xmm3

// CHECK: vpmovqb %zmm2, %xmm3 {%k1}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x49,0x32,0xd3]
          vpmovqb %zmm2, %xmm3 {%k1}

// CHECK: vpmovqb %zmm2, %xmm3 {%k1} {z}
// CHECK:  encoding: [0x62,0xf2,0x7e,0xc9,0x32,0xd3]
          vpmovqb %zmm2, %xmm3 {%k1} {z}

// CHECK: vpmovsqb %zmm29, %xmm30
// CHECK:  encoding: [0x62,0x02,0x7e,0x48,0x22,0xee]
          vpmovsqb %zmm29, %xmm30

// CHECK: vpmovsqb %zmm29, %xmm30 {%k5}
// CHECK:  encoding: [0x62,0x02,0x7e,0x4d,0x22,0xee]
          vpmovsqb %zmm29, %xmm30 {%k5}

// CHECK: vpmovsqb %zmm29, %xmm30 {%k5} {z}
// CHECK:  encoding: [0x62,0x02,0x7e,0xcd,0x22,0xee]
          vpmovsqb %zmm29, %xmm30 {%k5} {z}

// CHECK: vpmovusqb %zmm28, %xmm24
// CHECK:  encoding: [0x62,0x02,0x7e,0x48,0x12,0xe0]
          vpmovusqb %zmm28, %xmm24

// CHECK: vpmovusqb %zmm28, %xmm24 {%k7}
// CHECK:  encoding: [0x62,0x02,0x7e,0x4f,0x12,0xe0]
          vpmovusqb %zmm28, %xmm24 {%k7}

// CHECK: vpmovusqb %zmm28, %xmm24 {%k7} {z}
// CHECK:  encoding: [0x62,0x02,0x7e,0xcf,0x12,0xe0]
          vpmovusqb %zmm28, %xmm24 {%k7} {z}

// CHECK: vpmovqw %zmm18, %xmm6
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x34,0xd6]
          vpmovqw %zmm18, %xmm6

// CHECK: vpmovqw %zmm18, %xmm6 {%k1}
// CHECK:  encoding: [0x62,0xe2,0x7e,0x49,0x34,0xd6]
          vpmovqw %zmm18, %xmm6 {%k1}

// CHECK: vpmovqw %zmm18, %xmm6 {%k1} {z}
// CHECK:  encoding: [0x62,0xe2,0x7e,0xc9,0x34,0xd6]
          vpmovqw %zmm18, %xmm6 {%k1} {z}

// CHECK: vpmovsqw %zmm19, %xmm27
// CHECK:  encoding: [0x62,0x82,0x7e,0x48,0x24,0xdb]
          vpmovsqw %zmm19, %xmm27

// CHECK: vpmovsqw %zmm19, %xmm27 {%k6}
// CHECK:  encoding: [0x62,0x82,0x7e,0x4e,0x24,0xdb]
          vpmovsqw %zmm19, %xmm27 {%k6}

// CHECK: vpmovsqw %zmm19, %xmm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x82,0x7e,0xce,0x24,0xdb]
          vpmovsqw %zmm19, %xmm27 {%k6} {z}

// CHECK: vpmovusqw %zmm10, %xmm28
// CHECK:  encoding: [0x62,0x12,0x7e,0x48,0x14,0xd4]
          vpmovusqw %zmm10, %xmm28

// CHECK: vpmovusqw %zmm10, %xmm28 {%k7}
// CHECK:  encoding: [0x62,0x12,0x7e,0x4f,0x14,0xd4]
          vpmovusqw %zmm10, %xmm28 {%k7}

// CHECK: vpmovusqw %zmm10, %xmm28 {%k7} {z}
// CHECK:  encoding: [0x62,0x12,0x7e,0xcf,0x14,0xd4]
          vpmovusqw %zmm10, %xmm28 {%k7} {z}

// CHECK: vpmovqd %zmm25, %ymm6
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0xce]
          vpmovqd %zmm25, %ymm6

// CHECK: vpmovqd %zmm25, %ymm6 {%k5}
// CHECK:  encoding: [0x62,0x62,0x7e,0x4d,0x35,0xce]
          vpmovqd %zmm25, %ymm6 {%k5}

// CHECK: vpmovqd %zmm25, %ymm6 {%k5} {z}
// CHECK:  encoding: [0x62,0x62,0x7e,0xcd,0x35,0xce]
          vpmovqd %zmm25, %ymm6 {%k5} {z}

// CHECK: vpmovsqd %zmm2, %ymm15
// CHECK:  encoding: [0x62,0xd2,0x7e,0x48,0x25,0xd7]
          vpmovsqd %zmm2, %ymm15

// CHECK: vpmovsqd %zmm2, %ymm15 {%k2}
// CHECK:  encoding: [0x62,0xd2,0x7e,0x4a,0x25,0xd7]
          vpmovsqd %zmm2, %ymm15 {%k2}

// CHECK: vpmovsqd %zmm2, %ymm15 {%k2} {z}
// CHECK:  encoding: [0x62,0xd2,0x7e,0xca,0x25,0xd7]
          vpmovsqd %zmm2, %ymm15 {%k2} {z}

// CHECK: vpmovusqd %zmm4, %ymm8
// CHECK:  encoding: [0x62,0xd2,0x7e,0x48,0x15,0xe0]
          vpmovusqd %zmm4, %ymm8

// CHECK: vpmovusqd %zmm4, %ymm8 {%k4}
// CHECK:  encoding: [0x62,0xd2,0x7e,0x4c,0x15,0xe0]
          vpmovusqd %zmm4, %ymm8 {%k4}

// CHECK: vpmovusqd %zmm4, %ymm8 {%k4} {z}
// CHECK:  encoding: [0x62,0xd2,0x7e,0xcc,0x15,0xe0]
          vpmovusqd %zmm4, %ymm8 {%k4} {z}

// CHECK: vpmovdb %zmm5, %xmm2
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x31,0xea]
          vpmovdb %zmm5, %xmm2

// CHECK: vpmovdb %zmm5, %xmm2 {%k5}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4d,0x31,0xea]
          vpmovdb %zmm5, %xmm2 {%k5}

// CHECK: vpmovdb %zmm5, %xmm2 {%k5} {z}
// CHECK:  encoding: [0x62,0xf2,0x7e,0xcd,0x31,0xea]
          vpmovdb %zmm5, %xmm2 {%k5} {z}

// CHECK: vpmovsdb %zmm2, %xmm21
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x21,0xd5]
          vpmovsdb %zmm2, %xmm21

// CHECK: vpmovsdb %zmm2, %xmm21 {%k4}
// CHECK:  encoding: [0x62,0xb2,0x7e,0x4c,0x21,0xd5]
          vpmovsdb %zmm2, %xmm21 {%k4}

// CHECK: vpmovsdb %zmm2, %xmm21 {%k4} {z}
// CHECK:  encoding: [0x62,0xb2,0x7e,0xcc,0x21,0xd5]
          vpmovsdb %zmm2, %xmm21 {%k4} {z}

// CHECK: vpmovusdb %zmm2, %xmm20
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x11,0xd4]
          vpmovusdb %zmm2, %xmm20

// CHECK: vpmovusdb %zmm2, %xmm20 {%k3}
// CHECK:  encoding: [0x62,0xb2,0x7e,0x4b,0x11,0xd4]
          vpmovusdb %zmm2, %xmm20 {%k3}

// CHECK: vpmovusdb %zmm2, %xmm20 {%k3} {z}
// CHECK:  encoding: [0x62,0xb2,0x7e,0xcb,0x11,0xd4]
          vpmovusdb %zmm2, %xmm20 {%k3} {z}

// CHECK: vpmovdw %zmm29, %ymm22
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x33,0xee]
          vpmovdw %zmm29, %ymm22

// CHECK: vpmovdw %zmm29, %ymm22 {%k5}
// CHECK:  encoding: [0x62,0x22,0x7e,0x4d,0x33,0xee]
          vpmovdw %zmm29, %ymm22 {%k5}

// CHECK: vpmovdw %zmm29, %ymm22 {%k5} {z}
// CHECK:  encoding: [0x62,0x22,0x7e,0xcd,0x33,0xee]
          vpmovdw %zmm29, %ymm22 {%k5} {z}

// CHECK: vpmovsdw %zmm14, %ymm25
// CHECK:  encoding: [0x62,0x12,0x7e,0x48,0x23,0xf1]
          vpmovsdw %zmm14, %ymm25

// CHECK: vpmovsdw %zmm14, %ymm25 {%k4}
// CHECK:  encoding: [0x62,0x12,0x7e,0x4c,0x23,0xf1]
          vpmovsdw %zmm14, %ymm25 {%k4}

// CHECK: vpmovsdw %zmm14, %ymm25 {%k4} {z}
// CHECK:  encoding: [0x62,0x12,0x7e,0xcc,0x23,0xf1]
          vpmovsdw %zmm14, %ymm25 {%k4} {z}

// CHECK: vpmovusdw %zmm7, %ymm8
// CHECK:  encoding: [0x62,0xd2,0x7e,0x48,0x13,0xf8]
          vpmovusdw %zmm7, %ymm8

// CHECK: vpmovusdw %zmm7, %ymm8 {%k1}
// CHECK:  encoding: [0x62,0xd2,0x7e,0x49,0x13,0xf8]
          vpmovusdw %zmm7, %ymm8 {%k1}

// CHECK: vpmovusdw %zmm7, %ymm8 {%k1} {z}
// CHECK:  encoding: [0x62,0xd2,0x7e,0xc9,0x13,0xf8]
          vpmovusdw %zmm7, %ymm8 {%k1} {z}

// CHECK: vpmovqb %zmm3, (%rcx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x19]
          vpmovqb %zmm3, (%rcx)

// CHECK: vpmovqb %zmm3, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4f,0x32,0x19]
          vpmovqb %zmm3, (%rcx) {%k7}

// CHECK: vpmovqb %zmm3, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x32,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovqb %zmm3, 291(%rax,%r14,8)

// CHECK: vpmovqb %zmm3, 1016(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x5a,0x7f]
          vpmovqb %zmm3, 1016(%rdx)

// CHECK: vpmovqb %zmm3, 1024(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x9a,0x00,0x04,0x00,0x00]
          vpmovqb %zmm3, 1024(%rdx)

// CHECK: vpmovqb %zmm3, -1024(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x5a,0x80]
          vpmovqb %zmm3, -1024(%rdx)

// CHECK: vpmovqb %zmm3, -1032(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x9a,0xf8,0xfb,0xff,0xff]
          vpmovqb %zmm3, -1032(%rdx)

// CHECK: vpmovsqb %zmm16, (%rcx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x01]
          vpmovsqb %zmm16, (%rcx)

// CHECK: vpmovsqb %zmm16, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0xe2,0x7e,0x4a,0x22,0x01]
          vpmovsqb %zmm16, (%rcx) {%k2}

// CHECK: vpmovsqb %zmm16, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x22,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmovsqb %zmm16, 291(%rax,%r14,8)

// CHECK: vpmovsqb %zmm16, 1016(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x42,0x7f]
          vpmovsqb %zmm16, 1016(%rdx)

// CHECK: vpmovsqb %zmm16, 1024(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x82,0x00,0x04,0x00,0x00]
          vpmovsqb %zmm16, 1024(%rdx)

// CHECK: vpmovsqb %zmm16, -1024(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x42,0x80]
          vpmovsqb %zmm16, -1024(%rdx)

// CHECK: vpmovsqb %zmm16, -1032(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x82,0xf8,0xfb,0xff,0xff]
          vpmovsqb %zmm16, -1032(%rdx)

// CHECK: vpmovusqb %zmm28, (%rcx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0x21]
          vpmovusqb %zmm28, (%rcx)

// CHECK: vpmovusqb %zmm28, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0x62,0x7e,0x49,0x12,0x21]
          vpmovusqb %zmm28, (%rcx) {%k1}

// CHECK: vpmovusqb %zmm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x12,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovusqb %zmm28, 291(%rax,%r14,8)

// CHECK: vpmovusqb %zmm28, 1016(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0x62,0x7f]
          vpmovusqb %zmm28, 1016(%rdx)

// CHECK: vpmovusqb %zmm28, 1024(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0xa2,0x00,0x04,0x00,0x00]
          vpmovusqb %zmm28, 1024(%rdx)

// CHECK: vpmovusqb %zmm28, -1024(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0x62,0x80]
          vpmovusqb %zmm28, -1024(%rdx)

// CHECK: vpmovusqb %zmm28, -1032(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0xa2,0xf8,0xfb,0xff,0xff]
          vpmovusqb %zmm28, -1032(%rdx)

// CHECK: vpmovqw %zmm7, (%rcx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0x39]
          vpmovqw %zmm7, (%rcx)

// CHECK: vpmovqw %zmm7, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4e,0x34,0x39]
          vpmovqw %zmm7, (%rcx) {%k6}

// CHECK: vpmovqw %zmm7, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x34,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovqw %zmm7, 291(%rax,%r14,8)

// CHECK: vpmovqw %zmm7, 2032(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0x7a,0x7f]
          vpmovqw %zmm7, 2032(%rdx)

// CHECK: vpmovqw %zmm7, 2048(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0xba,0x00,0x08,0x00,0x00]
          vpmovqw %zmm7, 2048(%rdx)

// CHECK: vpmovqw %zmm7, -2048(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0x7a,0x80]
          vpmovqw %zmm7, -2048(%rdx)

// CHECK: vpmovqw %zmm7, -2064(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0xba,0xf0,0xf7,0xff,0xff]
          vpmovqw %zmm7, -2064(%rdx)

// CHECK: vpmovsqw %zmm1, (%rcx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x09]
          vpmovsqw %zmm1, (%rcx)

// CHECK: vpmovsqw %zmm1, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4d,0x24,0x09]
          vpmovsqw %zmm1, (%rcx) {%k5}

// CHECK: vpmovsqw %zmm1, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x24,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsqw %zmm1, 291(%rax,%r14,8)

// CHECK: vpmovsqw %zmm1, 2032(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x4a,0x7f]
          vpmovsqw %zmm1, 2032(%rdx)

// CHECK: vpmovsqw %zmm1, 2048(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x8a,0x00,0x08,0x00,0x00]
          vpmovsqw %zmm1, 2048(%rdx)

// CHECK: vpmovsqw %zmm1, -2048(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x4a,0x80]
          vpmovsqw %zmm1, -2048(%rdx)

// CHECK: vpmovsqw %zmm1, -2064(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x8a,0xf0,0xf7,0xff,0xff]
          vpmovsqw %zmm1, -2064(%rdx)

// CHECK: vpmovusqw %zmm25, (%rcx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x09]
          vpmovusqw %zmm25, (%rcx)

// CHECK: vpmovusqw %zmm25, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0x62,0x7e,0x4b,0x14,0x09]
          vpmovusqw %zmm25, (%rcx) {%k3}

// CHECK: vpmovusqw %zmm25, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x14,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovusqw %zmm25, 291(%rax,%r14,8)

// CHECK: vpmovusqw %zmm25, 2032(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x4a,0x7f]
          vpmovusqw %zmm25, 2032(%rdx)

// CHECK: vpmovusqw %zmm25, 2048(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x8a,0x00,0x08,0x00,0x00]
          vpmovusqw %zmm25, 2048(%rdx)

// CHECK: vpmovusqw %zmm25, -2048(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x4a,0x80]
          vpmovusqw %zmm25, -2048(%rdx)

// CHECK: vpmovusqw %zmm25, -2064(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x8a,0xf0,0xf7,0xff,0xff]
          vpmovusqw %zmm25, -2064(%rdx)

// CHECK: vpmovqd %zmm28, (%rcx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0x21]
          vpmovqd %zmm28, (%rcx)

// CHECK: vpmovqd %zmm28, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0x62,0x7e,0x4d,0x35,0x21]
          vpmovqd %zmm28, (%rcx) {%k5}

// CHECK: vpmovqd %zmm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x35,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovqd %zmm28, 291(%rax,%r14,8)

// CHECK: vpmovqd %zmm28, 4064(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0x62,0x7f]
          vpmovqd %zmm28, 4064(%rdx)

// CHECK: vpmovqd %zmm28, 4096(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0xa2,0x00,0x10,0x00,0x00]
          vpmovqd %zmm28, 4096(%rdx)

// CHECK: vpmovqd %zmm28, -4096(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0x62,0x80]
          vpmovqd %zmm28, -4096(%rdx)

// CHECK: vpmovqd %zmm28, -4128(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0xa2,0xe0,0xef,0xff,0xff]
          vpmovqd %zmm28, -4128(%rdx)

// CHECK: vpmovsqd %zmm9, (%rcx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x09]
          vpmovsqd %zmm9, (%rcx)

// CHECK: vpmovsqd %zmm9, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0x72,0x7e,0x4f,0x25,0x09]
          vpmovsqd %zmm9, (%rcx) {%k7}

// CHECK: vpmovsqd %zmm9, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x32,0x7e,0x48,0x25,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsqd %zmm9, 291(%rax,%r14,8)

// CHECK: vpmovsqd %zmm9, 4064(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x4a,0x7f]
          vpmovsqd %zmm9, 4064(%rdx)

// CHECK: vpmovsqd %zmm9, 4096(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x8a,0x00,0x10,0x00,0x00]
          vpmovsqd %zmm9, 4096(%rdx)

// CHECK: vpmovsqd %zmm9, -4096(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x4a,0x80]
          vpmovsqd %zmm9, -4096(%rdx)

// CHECK: vpmovsqd %zmm9, -4128(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x8a,0xe0,0xef,0xff,0xff]
          vpmovsqd %zmm9, -4128(%rdx)

// CHECK: vpmovusqd %zmm22, (%rcx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0x31]
          vpmovusqd %zmm22, (%rcx)

// CHECK: vpmovusqd %zmm22, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe2,0x7e,0x49,0x15,0x31]
          vpmovusqd %zmm22, (%rcx) {%k1}

// CHECK: vpmovusqd %zmm22, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x15,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovusqd %zmm22, 291(%rax,%r14,8)

// CHECK: vpmovusqd %zmm22, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0x72,0x7f]
          vpmovusqd %zmm22, 4064(%rdx)

// CHECK: vpmovusqd %zmm22, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0xb2,0x00,0x10,0x00,0x00]
          vpmovusqd %zmm22, 4096(%rdx)

// CHECK: vpmovusqd %zmm22, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0x72,0x80]
          vpmovusqd %zmm22, -4096(%rdx)

// CHECK: vpmovusqd %zmm22, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0xb2,0xe0,0xef,0xff,0xff]
          vpmovusqd %zmm22, -4128(%rdx)

// CHECK: vpmovdb %zmm12, (%rcx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0x21]
          vpmovdb %zmm12, (%rcx)

// CHECK: vpmovdb %zmm12, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0x72,0x7e,0x4b,0x31,0x21]
          vpmovdb %zmm12, (%rcx) {%k3}

// CHECK: vpmovdb %zmm12, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x32,0x7e,0x48,0x31,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovdb %zmm12, 291(%rax,%r14,8)

// CHECK: vpmovdb %zmm12, 2032(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0x62,0x7f]
          vpmovdb %zmm12, 2032(%rdx)

// CHECK: vpmovdb %zmm12, 2048(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0xa2,0x00,0x08,0x00,0x00]
          vpmovdb %zmm12, 2048(%rdx)

// CHECK: vpmovdb %zmm12, -2048(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0x62,0x80]
          vpmovdb %zmm12, -2048(%rdx)

// CHECK: vpmovdb %zmm12, -2064(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0xa2,0xf0,0xf7,0xff,0xff]
          vpmovdb %zmm12, -2064(%rdx)

// CHECK: vpmovsdb %zmm6, (%rcx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0x31]
          vpmovsdb %zmm6, (%rcx)

// CHECK: vpmovsdb %zmm6, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x49,0x21,0x31]
          vpmovsdb %zmm6, (%rcx) {%k1}

// CHECK: vpmovsdb %zmm6, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x21,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovsdb %zmm6, 291(%rax,%r14,8)

// CHECK: vpmovsdb %zmm6, 2032(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0x72,0x7f]
          vpmovsdb %zmm6, 2032(%rdx)

// CHECK: vpmovsdb %zmm6, 2048(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0xb2,0x00,0x08,0x00,0x00]
          vpmovsdb %zmm6, 2048(%rdx)

// CHECK: vpmovsdb %zmm6, -2048(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0x72,0x80]
          vpmovsdb %zmm6, -2048(%rdx)

// CHECK: vpmovsdb %zmm6, -2064(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0xb2,0xf0,0xf7,0xff,0xff]
          vpmovsdb %zmm6, -2064(%rdx)

// CHECK: vpmovusdb %zmm23, (%rcx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0x39]
          vpmovusdb %zmm23, (%rcx)

// CHECK: vpmovusdb %zmm23, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xe2,0x7e,0x4b,0x11,0x39]
          vpmovusdb %zmm23, (%rcx) {%k3}

// CHECK: vpmovusdb %zmm23, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x11,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovusdb %zmm23, 291(%rax,%r14,8)

// CHECK: vpmovusdb %zmm23, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0x7a,0x7f]
          vpmovusdb %zmm23, 2032(%rdx)

// CHECK: vpmovusdb %zmm23, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0xba,0x00,0x08,0x00,0x00]
          vpmovusdb %zmm23, 2048(%rdx)

// CHECK: vpmovusdb %zmm23, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0x7a,0x80]
          vpmovusdb %zmm23, -2048(%rdx)

// CHECK: vpmovusdb %zmm23, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0xba,0xf0,0xf7,0xff,0xff]
          vpmovusdb %zmm23, -2064(%rdx)

// CHECK: vpmovdw %zmm7, (%rcx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0x39]
          vpmovdw %zmm7, (%rcx)

// CHECK: vpmovdw %zmm7, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4f,0x33,0x39]
          vpmovdw %zmm7, (%rcx) {%k7}

// CHECK: vpmovdw %zmm7, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x33,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovdw %zmm7, 291(%rax,%r14,8)

// CHECK: vpmovdw %zmm7, 4064(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0x7a,0x7f]
          vpmovdw %zmm7, 4064(%rdx)

// CHECK: vpmovdw %zmm7, 4096(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0xba,0x00,0x10,0x00,0x00]
          vpmovdw %zmm7, 4096(%rdx)

// CHECK: vpmovdw %zmm7, -4096(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0x7a,0x80]
          vpmovdw %zmm7, -4096(%rdx)

// CHECK: vpmovdw %zmm7, -4128(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0xba,0xe0,0xef,0xff,0xff]
          vpmovdw %zmm7, -4128(%rdx)

// CHECK: vpmovsdw %zmm14, (%rcx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0x31]
          vpmovsdw %zmm14, (%rcx)

// CHECK: vpmovsdw %zmm14, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0x72,0x7e,0x4e,0x23,0x31]
          vpmovsdw %zmm14, (%rcx) {%k6}

// CHECK: vpmovsdw %zmm14, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x32,0x7e,0x48,0x23,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovsdw %zmm14, 291(%rax,%r14,8)

// CHECK: vpmovsdw %zmm14, 4064(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0x72,0x7f]
          vpmovsdw %zmm14, 4064(%rdx)

// CHECK: vpmovsdw %zmm14, 4096(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0xb2,0x00,0x10,0x00,0x00]
          vpmovsdw %zmm14, 4096(%rdx)

// CHECK: vpmovsdw %zmm14, -4096(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0x72,0x80]
          vpmovsdw %zmm14, -4096(%rdx)

// CHECK: vpmovsdw %zmm14, -4128(%rdx)
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0xb2,0xe0,0xef,0xff,0xff]
          vpmovsdw %zmm14, -4128(%rdx)

// CHECK: vpmovusdw %zmm5, (%rcx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0x29]
          vpmovusdw %zmm5, (%rcx)

// CHECK: vpmovusdw %zmm5, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4b,0x13,0x29]
          vpmovusdw %zmm5, (%rcx) {%k3}

// CHECK: vpmovusdw %zmm5, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x13,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmovusdw %zmm5, 291(%rax,%r14,8)

// CHECK: vpmovusdw %zmm5, 4064(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0x6a,0x7f]
          vpmovusdw %zmm5, 4064(%rdx)

// CHECK: vpmovusdw %zmm5, 4096(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0xaa,0x00,0x10,0x00,0x00]
          vpmovusdw %zmm5, 4096(%rdx)

// CHECK: vpmovusdw %zmm5, -4096(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0x6a,0x80]
          vpmovusdw %zmm5, -4096(%rdx)

// CHECK: vpmovusdw %zmm5, -4128(%rdx)
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0xaa,0xe0,0xef,0xff,0xff]
          vpmovusdw %zmm5, -4128(%rdx)

// CHECK: vinserti32x4
// CHECK: encoding: [0x62,0xa3,0x55,0x48,0x38,0xcd,0x01]
vinserti32x4  $1, %xmm21, %zmm5, %zmm17

// CHECK: vinserti32x4
// CHECK: encoding: [0x62,0xe3,0x1d,0x40,0x38,0x4f,0x10,0x01]
vinserti32x4  $1, 256(%rdi), %zmm28, %zmm17

// CHECK: vextracti32x4
// CHECK: encoding: [0x62,0x33,0x7d,0x48,0x39,0xc9,0x01]
vextracti32x4  $1, %zmm9, %xmm17

// CHECK: vextracti64x4
// CHECK: encoding: [0x62,0x33,0xfd,0x48,0x3b,0xc9,0x01]
vextracti64x4  $1, %zmm9, %ymm17

// CHECK: vextracti64x4
// CHECK: encoding: [0x62,0x73,0xfd,0x48,0x3b,0x4f,0x10,0x01]
vextracti64x4  $1, %zmm9, 512(%rdi)

// CHECK: vpsrad
// CHECK: encoding: [0x62,0xb1,0x35,0x40,0x72,0xe1,0x02]
vpsrad $2, %zmm17, %zmm25

// CHECK: vpsrad
// CHECK: encoding: [0x62,0xf1,0x35,0x40,0x72,0x64,0xb7,0x08,0x02]
vpsrad $2, 512(%rdi, %rsi, 4), %zmm25

// CHECK: vpsrad
// CHECK: encoding: [0x62,0x21,0x1d,0x48,0xe2,0xc9]
vpsrad %xmm17, %zmm12, %zmm25

// CHECK: vpsrad
// CHECK: encoding: [0x62,0x61,0x1d,0x48,0xe2,0x4c,0xb7,0x20]
vpsrad 512(%rdi, %rsi, 4), %zmm12, %zmm25

// CHECK: vpbroadcastd {{.*}} {%k1} {z}
// CHECK: encoding: [0x62,0xf2,0x7d,0xc9,0x58,0xc8]
vpbroadcastd  %xmm0, %zmm1 {%k1} {z}

// CHECK: vbroadcasti32x4 {{.*}} {%k7} {z}
// CHECK: encoding: [0x67,0x62,0xf2,0x7d,0xcf,0x5a,0x52,0x02]
vbroadcasti32x4 0x20(%edx), %zmm2 {%k7} {z}

// CHECK: vbroadcasti64x4 {{.*}} %zmm22
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x72,0x02]
vbroadcasti64x4 0x40(%rdx), %zmm22

// CHECK: vmovdqu64 {{.*}} {%k3}
// CHECK: encoding: [0x62,0xf1,0xfe,0x4b,0x7f,0x07]
vmovdqu64 %zmm0, (%rdi) {%k3}

// CHECK: vmovdqa32 {{.*}} {%k4}
// CHECK: encoding: [0x62,0x61,0x7d,0x4c,0x6f,0x1e]
vmovdqa32 (%rsi), %zmm27 {%k4}

// CHECK: vmovd
// CHECK: encoding: [0x62,0xe1,0x7d,0x08,0x7e,0x74,0x24,0xeb]
vmovd %xmm22, -84(%rsp)

// CHECK: vextractps
// CHECK: encoding: [0x62,0xe3,0x7d,0x08,0x17,0x61,0x1f,0x02]
vextractps      $2, %xmm20, 124(%rcx)

// CHECK: vaddpd {{.*}}{1to8}
// CHECK: encoding: [0x62,0x61,0xdd,0x50,0x58,0x74,0xf7,0x40]
vaddpd 512(%rdi, %rsi, 8) {1to8}, %zmm20, %zmm30

// CHECK: vaddps {{.*}}{1to16}
// CHECK: encoding: [0x62,0x61,0x5c,0x50,0x58,0xb4,0xf7,0x00,0x02,0x00,0x00]
vaddps 512(%rdi, %rsi, 8) {1to16}, %zmm20, %zmm30

// CHECK: vmovntdqa
// CHECK: encoding: [0x62,0x72,0x7d,0x48,0x2a,0xab,0x78,0x56,0x34,0x12]
vmovntdqa 0x12345678(%rbx), %zmm13

// CHECK: vmovntdqa
// CHECK: encoding: [0x62,0xc2,0x7d,0x48,0x2a,0x14,0x56]
vmovntdqa (%r14,%rdx,2), %zmm18

// CHECK: vmovntdqa
// CHECK: encoding: [0x62,0xc2,0x7d,0x48,0x2a,0x7c,0x14,0x02]
vmovntdqa 128(%r12,%rdx), %zmm23

// CHECK: vmovntdq
// CHECK: encoding: [0x62,0x21,0x7d,0x48,0xe7,0x24,0xa9]
vmovntdq %zmm28, (%rcx,%r13,4)

// CHECK: vmovntpd
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0xb2,0x04,0x00,0x00,0x00]
vmovntpd %zmm6, 4(%rdx)

// CHECK: vmovntps
// CHECK: encoding: [0x62,0x51,0x7c,0x48,0x2b,0x5c,0x8d,0x00]
vmovntps %zmm11, (%r13,%rcx,4)

// CHECK: vcmpps $14
// CHECK: encoding: [0x62,0xb1,0x54,0x48,0xc2,0xd1,0x0e]
vcmpgtps %zmm17, %zmm5, %k2

// CHECK: vcmppd $13
// CHECK: encoding: [0x62,0xd1,0xf5,0x40,0xc2,0x76,0x02,0x0d]
vcmpgepd 0x80(%r14), %zmm17, %k6

// CHECK: vpcmpd $1,
// CHECK: encoding: [0x62,0x93,0x45,0x4c,0x1f,0xe8,0x01]
vpcmpd $1, %zmm24, %zmm7, %k5{%k4}

// CHECK: vpcmpuq $2,
// CHECK: encoding: [0x62,0xf3,0xf5,0x47,0x1e,0x72,0x01,0x02]
vpcmpuq $2, 0x40(%rdx), %zmm17, %k6{%k7}

// ERR: invalid operand for instruction
vpcmpd $1, %zmm24, %zmm7, %k5{%k0}

// CHECK: vpermi2d
// CHECK: encoding: [0x62,0x42,0x6d,0x4b,0x76,0xd6]
vpermi2d %zmm14, %zmm2, %zmm26 {%k3}

// CHECK: vpermt2pd
// CHECK: encoding: [0x62,0xf2,0xcd,0xc6,0x7f,0xf3]
vpermt2pd %zmm3, %zmm22, %zmm6 {%k6} {z}

// CHECK: vpermi2q
// CHECK: encoding: [0x62,0x62,0xed,0x4b,0x76,0x54,0x58,0x02]
vpermi2q 0x80(%rax,%rbx,2), %zmm2, %zmm26 {%k3}

// CHECK: vpermt2d
// CHECK: encoding: [0x62,0x32,0x4d,0xc2,0x7e,0x24,0xad,0x05,0x00,0x00,0x00]	
vpermt2d 5(,%r13,4), %zmm22, %zmm12 {%k2} {z}

// CHECK: valignq $2
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x03,0x4c,0x24,0x04,0x02]
valignq  $2, 0x100(%rsp), %zmm0, %zmm1

// CHECK: valignq $3
// CHECK: encoding: [0x62,0xf3,0xfd,0x49,0x03,0xcb,0x03]
valignq  $3, %zmm3, %zmm0, %zmm1 {%k1}
