// RUN: rm -rf %t
// RUN: %clang_cc1 -objcmt-migrate-property -objcmt-migrate-readonly-property -mt-migrate-directory %t %s -x objective-c -fobjc-runtime-has-weak -fobjc-arc -fobjc-default-synthesize-properties -triple x86_64-apple-darwin11
// RUN: c-arcmt-test -mt-migrate-directory %t | arcmt-test -verify-transformed-files %s.result
// RUN: %clang_cc1 -triple x86_64-apple-darwin10 -fsyntax-only -x objective-c -fobjc-runtime-has-weak -fobjc-arc -fobjc-default-synthesize-properties %s.result

#define WEBKIT_OBJC_METHOD_ANNOTATION(ANNOTATION) ANNOTATION
#define WEAK_IMPORT_ATTRIBUTE __attribute__((objc_arc_weak_reference_unavailable))
#define AVAILABLE_WEBKIT_VERSION_3_0_AND_LATER

typedef char BOOL;
@class NSString;
@protocol NSCopying @end

@interface NSObject <NSCopying>
@end

@interface NSDictionary : NSObject
@end

@interface I : NSObject {
  int ivarVal;
}
- (void) setWeakProp : (NSString *__weak)Val;
- (NSString *__weak) WeakProp;

- (NSString *) StrongProp;
- (void) setStrongProp : (NSString *)Val;

- (NSString *) UnavailProp  __attribute__((unavailable));
- (void) setUnavailProp  : (NSString *)Val;

- (NSString *) UnavailProp1  __attribute__((unavailable));
- (void) setUnavailProp1  : (NSString *)Val  __attribute__((unavailable));

- (NSString *) UnavailProp2;
- (void) setUnavailProp2  : (NSString *)Val  __attribute__((unavailable));

- (NSDictionary*) undoAction;
- (void) setUndoAction: (NSDictionary*)Arg;
@end

@implementation I
@end

@class NSArray;

@interface MyClass2  {
@private
    NSArray *_names1;
    NSArray *_names2;
    NSArray *_names3;
    NSArray *_names4;
}
- (void)setNames1:(NSArray *)names;
- (void)setNames4:(__strong NSArray *)names;
- (void)setNames3:(__strong NSArray *)names;
- (void)setNames2:(NSArray *)names;
- (NSArray *) names2;
- (NSArray *)names3;
- (__strong NSArray *)names4;
- (NSArray *) names1;
@end

// Properties that contain the name "delegate" or "dataSource",
// or have exact name "target" have unsafe_unretained attribute.
@interface NSInvocation 
- (id)target;
- (void)setTarget:(id)target;

- (id) dataSource;

- (id)xxxdelegateYYY;
- (void)setXxxdelegateYYY:(id)delegate;

- (void)setDataSource:(id)source;

- (id)MYtarget;
- (void)setMYtarget: (id)target;

- (id)targetX;
- (void)setTargetX: (id)t;
 
- (int)value;
- (void)setValue: (int)val;

-(BOOL) isContinuous;
-(void) setContinuous:(BOOL)value;

- (id) isAnObject;
- (void)setAnObject : (id) object;

- (BOOL) isinValid;
- (void) setInValid : (BOOL) arg;

- (void) Nothing;
- (int) Length;
- (id) object;
+ (double) D;
- (void *)JSObject WEBKIT_OBJC_METHOD_ANNOTATION(AVAILABLE_WEBKIT_VERSION_3_0_AND_LATER);
- (BOOL)isIgnoringInteractionEvents;

- (NSString *)getStringValue;
- (BOOL)getCounterValue;
- (void)setStringValue:(NSString *)stringValue AVAILABLE_WEBKIT_VERSION_3_0_AND_LATER;
- (NSDictionary *)getns_dixtionary;

- (BOOL)is3bar; // watch out
- (NSString *)get3foo; // watch out

- (BOOL) getM;
- (BOOL) getMA;
- (BOOL) getALL;
- (BOOL) getMANY;
- (BOOL) getSome;
@end


