; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X32,AVX512_32,AVX512_32_WIN,AVX512DQVL_32_WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X32,AVX512_32,AVX512_32_LIN,AVX512DQVL_32_LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X64,AVX512_64,AVX512_64_WIN,AVX512DQVL_64_WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X32,AVX512_64,AVX512_64_LIN,AVX512DQVL_64_LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=CHECK,X32,AVX512_32,AVX512_32_WIN,AVX512DQ_32_WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=CHECK,X32,AVX512_32,AVX512_32_LIN,AVX512DQ_32_LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=CHECK,X64,AVX512_64,AVX512_64_WIN,AVX512DQ_64_WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=CHECK,X32,AVX512_64,AVX512_64_LIN,AVX512DQ_64_LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X32,AVX512_32,AVX512_32_WIN,AVX512F_32_WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X32,AVX512_32,AVX512_32_LIN,AVX512F_32_LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X64,AVX512_64,AVX512_64_WIN,AVX512F_64_WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X32,AVX512_64,AVX512_64_LIN,AVX512F_64_LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+sse3 | FileCheck %s --check-prefixes=CHECK,X32,SSE3_32,SSE3_32_WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+sse3 | FileCheck %s --check-prefixes=CHECK,X32,SSE3_32,SSE3_32_LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+sse3 | FileCheck %s --check-prefixes=CHECK,X64,SSE3_64,SSE3_64_WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+sse3 | FileCheck %s --check-prefixes=CHECK,X64,SSE3_64,SSE3_64_LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X32,SSE2_32,SSE2_32_WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X32,SSE2_32,SSE2_32_LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X64,SSE2_64,SSE2_64_WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X64,SSE2_64,SSE2_64_LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=-sse  | FileCheck %s --check-prefixes=CHECK,X32,X87,X87_WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=-sse  | FileCheck %s --check-prefixes=CHECK,X32,X87,X87_LIN

; Check that scalar FP conversions to signed and unsigned int64 are using
; reasonable sequences, across platforms and target switches.
;
; The signed case is straight forward, and the tests here basically
; ensure successful compilation (f80 with avx512 was broken at one point).
;
; For the unsigned case there are many possible sequences, so to avoid
; a fragile test we just check for the presence of a few key instructions.
; AVX512 on Intel64 can use vcvtts[ds]2usi directly for float and double.
; Otherwise the sequence will involve an FP subtract (fsub, subss or subsd),
; and a truncating conversion (cvtts[ds]2si, fisttp, or fnstcw+fist).  When
; both a subtract and fnstcw are needed, they can occur in either order.
;
; The interesting subtargets are AVX512F (vcvtts[ds]2usi), SSE3 (fisttp),
; SSE2 (cvtts[ds]2si) and vanilla X87 (fnstcw+fist, 32-bit only).

define i64 @f_to_u64(float %a) nounwind {
; AVX512DQVL_32_WIN-LABEL: f_to_u64:
; AVX512DQVL_32_WIN:       # %bb.0:
; AVX512DQVL_32_WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQVL_32_WIN-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512DQVL_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_WIN-NEXT:    vzeroupper
; AVX512DQVL_32_WIN-NEXT:    retl
;
; AVX512DQVL_32_LIN-LABEL: f_to_u64:
; AVX512DQVL_32_LIN:       # %bb.0:
; AVX512DQVL_32_LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQVL_32_LIN-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512DQVL_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_LIN-NEXT:    vzeroupper
; AVX512DQVL_32_LIN-NEXT:    retl
;
; AVX512_64-LABEL: f_to_u64:
; AVX512_64:       # %bb.0:
; AVX512_64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512_64-NEXT:    retq
;
; AVX512DQ_32_WIN-LABEL: f_to_u64:
; AVX512DQ_32_WIN:       # %bb.0:
; AVX512DQ_32_WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQ_32_WIN-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_WIN-NEXT:    vzeroupper
; AVX512DQ_32_WIN-NEXT:    retl
;
; AVX512DQ_32_LIN-LABEL: f_to_u64:
; AVX512DQ_32_LIN:       # %bb.0:
; AVX512DQ_32_LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQ_32_LIN-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_LIN-NEXT:    vzeroupper
; AVX512DQ_32_LIN-NEXT:    retl
;
; AVX512F_32_WIN-LABEL: f_to_u64:
; AVX512F_32_WIN:       # %bb.0:
; AVX512F_32_WIN-NEXT:    pushl %ebp
; AVX512F_32_WIN-NEXT:    movl %esp, %ebp
; AVX512F_32_WIN-NEXT:    andl $-8, %esp
; AVX512F_32_WIN-NEXT:    subl $16, %esp
; AVX512F_32_WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F_32_WIN-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512F_32_WIN-NEXT:    vcmpltss %xmm1, %xmm0, %k1
; AVX512F_32_WIN-NEXT:    vsubss %xmm1, %xmm0, %xmm2
; AVX512F_32_WIN-NEXT:    vmovss %xmm0, %xmm0, %xmm2 {%k1}
; AVX512F_32_WIN-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    fisttpll (%esp)
; AVX512F_32_WIN-NEXT:    xorl %edx, %edx
; AVX512F_32_WIN-NEXT:    vucomiss %xmm0, %xmm1
; AVX512F_32_WIN-NEXT:    setbe %dl
; AVX512F_32_WIN-NEXT:    shll $31, %edx
; AVX512F_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512F_32_WIN-NEXT:    movl (%esp), %eax
; AVX512F_32_WIN-NEXT:    movl %ebp, %esp
; AVX512F_32_WIN-NEXT:    popl %ebp
; AVX512F_32_WIN-NEXT:    retl
;
; AVX512F_32_LIN-LABEL: f_to_u64:
; AVX512F_32_LIN:       # %bb.0:
; AVX512F_32_LIN-NEXT:    subl $20, %esp
; AVX512F_32_LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F_32_LIN-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512F_32_LIN-NEXT:    vcmpltss %xmm1, %xmm0, %k1
; AVX512F_32_LIN-NEXT:    vsubss %xmm1, %xmm0, %xmm2
; AVX512F_32_LIN-NEXT:    vmovss %xmm0, %xmm0, %xmm2 {%k1}
; AVX512F_32_LIN-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    fisttpll (%esp)
; AVX512F_32_LIN-NEXT:    xorl %edx, %edx
; AVX512F_32_LIN-NEXT:    vucomiss %xmm0, %xmm1
; AVX512F_32_LIN-NEXT:    setbe %dl
; AVX512F_32_LIN-NEXT:    shll $31, %edx
; AVX512F_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512F_32_LIN-NEXT:    movl (%esp), %eax
; AVX512F_32_LIN-NEXT:    addl $20, %esp
; AVX512F_32_LIN-NEXT:    retl
;
; SSE3_32_WIN-LABEL: f_to_u64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl %ebp
; SSE3_32_WIN-NEXT:    movl %esp, %ebp
; SSE3_32_WIN-NEXT:    andl $-8, %esp
; SSE3_32_WIN-NEXT:    subl $16, %esp
; SSE3_32_WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE3_32_WIN-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE3_32_WIN-NEXT:    movaps %xmm0, %xmm2
; SSE3_32_WIN-NEXT:    cmpltss %xmm1, %xmm2
; SSE3_32_WIN-NEXT:    movaps %xmm2, %xmm3
; SSE3_32_WIN-NEXT:    andps %xmm0, %xmm2
; SSE3_32_WIN-NEXT:    xorl %edx, %edx
; SSE3_32_WIN-NEXT:    ucomiss %xmm0, %xmm1
; SSE3_32_WIN-NEXT:    subss %xmm1, %xmm0
; SSE3_32_WIN-NEXT:    andnps %xmm0, %xmm3
; SSE3_32_WIN-NEXT:    orps %xmm3, %xmm2
; SSE3_32_WIN-NEXT:    movss %xmm2, {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    fisttpll (%esp)
; SSE3_32_WIN-NEXT:    setbe %dl
; SSE3_32_WIN-NEXT:    shll $31, %edx
; SSE3_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE3_32_WIN-NEXT:    movl (%esp), %eax
; SSE3_32_WIN-NEXT:    movl %ebp, %esp
; SSE3_32_WIN-NEXT:    popl %ebp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: f_to_u64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $20, %esp
; SSE3_32_LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE3_32_LIN-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE3_32_LIN-NEXT:    movaps %xmm0, %xmm2
; SSE3_32_LIN-NEXT:    cmpltss %xmm1, %xmm2
; SSE3_32_LIN-NEXT:    movaps %xmm2, %xmm3
; SSE3_32_LIN-NEXT:    andps %xmm0, %xmm2
; SSE3_32_LIN-NEXT:    xorl %edx, %edx
; SSE3_32_LIN-NEXT:    ucomiss %xmm0, %xmm1
; SSE3_32_LIN-NEXT:    subss %xmm1, %xmm0
; SSE3_32_LIN-NEXT:    andnps %xmm0, %xmm3
; SSE3_32_LIN-NEXT:    orps %xmm3, %xmm2
; SSE3_32_LIN-NEXT:    movss %xmm2, {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fisttpll (%esp)
; SSE3_32_LIN-NEXT:    setbe %dl
; SSE3_32_LIN-NEXT:    shll $31, %edx
; SSE3_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE3_32_LIN-NEXT:    movl (%esp), %eax
; SSE3_32_LIN-NEXT:    addl $20, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64-LABEL: f_to_u64:
; SSE3_64:       # %bb.0:
; SSE3_64-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE3_64-NEXT:    movaps %xmm0, %xmm2
; SSE3_64-NEXT:    subss %xmm1, %xmm2
; SSE3_64-NEXT:    cvttss2si %xmm2, %rax
; SSE3_64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; SSE3_64-NEXT:    xorq %rax, %rcx
; SSE3_64-NEXT:    cvttss2si %xmm0, %rax
; SSE3_64-NEXT:    ucomiss %xmm1, %xmm0
; SSE3_64-NEXT:    cmovaeq %rcx, %rax
; SSE3_64-NEXT:    retq
;
; SSE2_32_WIN-LABEL: f_to_u64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl %ebp
; SSE2_32_WIN-NEXT:    movl %esp, %ebp
; SSE2_32_WIN-NEXT:    andl $-8, %esp
; SSE2_32_WIN-NEXT:    subl $24, %esp
; SSE2_32_WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2_32_WIN-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2_32_WIN-NEXT:    movaps %xmm0, %xmm2
; SSE2_32_WIN-NEXT:    cmpltss %xmm1, %xmm2
; SSE2_32_WIN-NEXT:    movaps %xmm2, %xmm3
; SSE2_32_WIN-NEXT:    andps %xmm0, %xmm2
; SSE2_32_WIN-NEXT:    xorl %edx, %edx
; SSE2_32_WIN-NEXT:    ucomiss %xmm0, %xmm1
; SSE2_32_WIN-NEXT:    subss %xmm1, %xmm0
; SSE2_32_WIN-NEXT:    andnps %xmm0, %xmm3
; SSE2_32_WIN-NEXT:    orps %xmm3, %xmm2
; SSE2_32_WIN-NEXT:    movss %xmm2, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    setbe %dl
; SSE2_32_WIN-NEXT:    shll $31, %edx
; SSE2_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movl %ebp, %esp
; SSE2_32_WIN-NEXT:    popl %ebp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: f_to_u64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $28, %esp
; SSE2_32_LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2_32_LIN-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2_32_LIN-NEXT:    movaps %xmm0, %xmm2
; SSE2_32_LIN-NEXT:    cmpltss %xmm1, %xmm2
; SSE2_32_LIN-NEXT:    movaps %xmm2, %xmm3
; SSE2_32_LIN-NEXT:    andps %xmm0, %xmm2
; SSE2_32_LIN-NEXT:    xorl %edx, %edx
; SSE2_32_LIN-NEXT:    ucomiss %xmm0, %xmm1
; SSE2_32_LIN-NEXT:    subss %xmm1, %xmm0
; SSE2_32_LIN-NEXT:    andnps %xmm0, %xmm3
; SSE2_32_LIN-NEXT:    orps %xmm3, %xmm2
; SSE2_32_LIN-NEXT:    movss %xmm2, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    setbe %dl
; SSE2_32_LIN-NEXT:    shll $31, %edx
; SSE2_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    addl $28, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64-LABEL: f_to_u64:
; SSE2_64:       # %bb.0:
; SSE2_64-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2_64-NEXT:    movaps %xmm0, %xmm2
; SSE2_64-NEXT:    subss %xmm1, %xmm2
; SSE2_64-NEXT:    cvttss2si %xmm2, %rax
; SSE2_64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; SSE2_64-NEXT:    xorq %rax, %rcx
; SSE2_64-NEXT:    cvttss2si %xmm0, %rax
; SSE2_64-NEXT:    ucomiss %xmm1, %xmm0
; SSE2_64-NEXT:    cmovaeq %rcx, %rax
; SSE2_64-NEXT:    retq
;
; X87_WIN-LABEL: f_to_u64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl %ebp
; X87_WIN-NEXT:    movl %esp, %ebp
; X87_WIN-NEXT:    andl $-8, %esp
; X87_WIN-NEXT:    subl $16, %esp
; X87_WIN-NEXT:    flds 8(%ebp)
; X87_WIN-NEXT:    flds __real@5f000000
; X87_WIN-NEXT:    fld %st(1)
; X87_WIN-NEXT:    fsub %st(1)
; X87_WIN-NEXT:    fxch %st(1)
; X87_WIN-NEXT:    fucomp %st(2)
; X87_WIN-NEXT:    fnstsw %ax
; X87_WIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87_WIN-NEXT:    sahf
; X87_WIN-NEXT:    ja LBB0_2
; X87_WIN-NEXT:  # %bb.1:
; X87_WIN-NEXT:    fstp %st(1)
; X87_WIN-NEXT:    fldz
; X87_WIN-NEXT:  LBB0_2:
; X87_WIN-NEXT:    fstp %st(0)
; X87_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    setbe %al
; X87_WIN-NEXT:    movzbl %al, %edx
; X87_WIN-NEXT:    shll $31, %edx
; X87_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movl %ebp, %esp
; X87_WIN-NEXT:    popl %ebp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: f_to_u64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $20, %esp
; X87_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    flds {{\.LCPI.*}}
; X87_LIN-NEXT:    fld %st(1)
; X87_LIN-NEXT:    fsub %st(1)
; X87_LIN-NEXT:    fxch %st(1)
; X87_LIN-NEXT:    fucomp %st(2)
; X87_LIN-NEXT:    fnstsw %ax
; X87_LIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87_LIN-NEXT:    sahf
; X87_LIN-NEXT:    ja .LBB0_2
; X87_LIN-NEXT:  # %bb.1:
; X87_LIN-NEXT:    fstp %st(1)
; X87_LIN-NEXT:    fldz
; X87_LIN-NEXT:  .LBB0_2:
; X87_LIN-NEXT:    fstp %st(0)
; X87_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    setbe %al
; X87_LIN-NEXT:    movzbl %al, %edx
; X87_LIN-NEXT:    shll $31, %edx
; X87_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    addl $20, %esp
; X87_LIN-NEXT:    retl
  %r = fptoui float %a to i64
  ret i64 %r
}

define i64 @f_to_s64(float %a) nounwind {
; AVX512DQVL_32_WIN-LABEL: f_to_s64:
; AVX512DQVL_32_WIN:       # %bb.0:
; AVX512DQVL_32_WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQVL_32_WIN-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512DQVL_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_WIN-NEXT:    vzeroupper
; AVX512DQVL_32_WIN-NEXT:    retl
;
; AVX512DQVL_32_LIN-LABEL: f_to_s64:
; AVX512DQVL_32_LIN:       # %bb.0:
; AVX512DQVL_32_LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQVL_32_LIN-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512DQVL_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_LIN-NEXT:    vzeroupper
; AVX512DQVL_32_LIN-NEXT:    retl
;
; AVX512_64-LABEL: f_to_s64:
; AVX512_64:       # %bb.0:
; AVX512_64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512_64-NEXT:    retq
;
; AVX512DQ_32_WIN-LABEL: f_to_s64:
; AVX512DQ_32_WIN:       # %bb.0:
; AVX512DQ_32_WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQ_32_WIN-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_WIN-NEXT:    vzeroupper
; AVX512DQ_32_WIN-NEXT:    retl
;
; AVX512DQ_32_LIN-LABEL: f_to_s64:
; AVX512DQ_32_LIN:       # %bb.0:
; AVX512DQ_32_LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512DQ_32_LIN-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_LIN-NEXT:    vzeroupper
; AVX512DQ_32_LIN-NEXT:    retl
;
; AVX512F_32_WIN-LABEL: f_to_s64:
; AVX512F_32_WIN:       # %bb.0:
; AVX512F_32_WIN-NEXT:    pushl %ebp
; AVX512F_32_WIN-NEXT:    movl %esp, %ebp
; AVX512F_32_WIN-NEXT:    andl $-8, %esp
; AVX512F_32_WIN-NEXT:    subl $16, %esp
; AVX512F_32_WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F_32_WIN-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    fisttpll (%esp)
; AVX512F_32_WIN-NEXT:    movl (%esp), %eax
; AVX512F_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F_32_WIN-NEXT:    movl %ebp, %esp
; AVX512F_32_WIN-NEXT:    popl %ebp
; AVX512F_32_WIN-NEXT:    retl
;
; AVX512F_32_LIN-LABEL: f_to_s64:
; AVX512F_32_LIN:       # %bb.0:
; AVX512F_32_LIN-NEXT:    subl $20, %esp
; AVX512F_32_LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F_32_LIN-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    fisttpll (%esp)
; AVX512F_32_LIN-NEXT:    movl (%esp), %eax
; AVX512F_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F_32_LIN-NEXT:    addl $20, %esp
; AVX512F_32_LIN-NEXT:    retl
;
; SSE3_32_WIN-LABEL: f_to_s64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl %ebp
; SSE3_32_WIN-NEXT:    movl %esp, %ebp
; SSE3_32_WIN-NEXT:    andl $-8, %esp
; SSE3_32_WIN-NEXT:    subl $16, %esp
; SSE3_32_WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE3_32_WIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    fisttpll (%esp)
; SSE3_32_WIN-NEXT:    movl (%esp), %eax
; SSE3_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE3_32_WIN-NEXT:    movl %ebp, %esp
; SSE3_32_WIN-NEXT:    popl %ebp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: f_to_s64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $20, %esp
; SSE3_32_LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE3_32_LIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fisttpll (%esp)
; SSE3_32_LIN-NEXT:    movl (%esp), %eax
; SSE3_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE3_32_LIN-NEXT:    addl $20, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64-LABEL: f_to_s64:
; SSE3_64:       # %bb.0:
; SSE3_64-NEXT:    cvttss2si %xmm0, %rax
; SSE3_64-NEXT:    retq
;
; SSE2_32_WIN-LABEL: f_to_s64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl %ebp
; SSE2_32_WIN-NEXT:    movl %esp, %ebp
; SSE2_32_WIN-NEXT:    andl $-8, %esp
; SSE2_32_WIN-NEXT:    subl $24, %esp
; SSE2_32_WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2_32_WIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE2_32_WIN-NEXT:    movl %ebp, %esp
; SSE2_32_WIN-NEXT:    popl %ebp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: f_to_s64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $28, %esp
; SSE2_32_LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2_32_LIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE2_32_LIN-NEXT:    addl $28, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64-LABEL: f_to_s64:
; SSE2_64:       # %bb.0:
; SSE2_64-NEXT:    cvttss2si %xmm0, %rax
; SSE2_64-NEXT:    retq
;
; X87_WIN-LABEL: f_to_s64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl %ebp
; X87_WIN-NEXT:    movl %esp, %ebp
; X87_WIN-NEXT:    andl $-8, %esp
; X87_WIN-NEXT:    subl $16, %esp
; X87_WIN-NEXT:    flds 8(%ebp)
; X87_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87_WIN-NEXT:    movl %ebp, %esp
; X87_WIN-NEXT:    popl %ebp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: f_to_s64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $20, %esp
; X87_LIN-NEXT:    flds {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87_LIN-NEXT:    addl $20, %esp
; X87_LIN-NEXT:    retl
  %r = fptosi float %a to i64
  ret i64 %r
}

define i64 @d_to_u64(double %a) nounwind {
; AVX512DQVL_32_WIN-LABEL: d_to_u64:
; AVX512DQVL_32_WIN:       # %bb.0:
; AVX512DQVL_32_WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQVL_32_WIN-NEXT:    vcvttpd2uqq %ymm0, %ymm0
; AVX512DQVL_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_WIN-NEXT:    vzeroupper
; AVX512DQVL_32_WIN-NEXT:    retl
;
; AVX512DQVL_32_LIN-LABEL: d_to_u64:
; AVX512DQVL_32_LIN:       # %bb.0:
; AVX512DQVL_32_LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQVL_32_LIN-NEXT:    vcvttpd2uqq %ymm0, %ymm0
; AVX512DQVL_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_LIN-NEXT:    vzeroupper
; AVX512DQVL_32_LIN-NEXT:    retl
;
; AVX512_64-LABEL: d_to_u64:
; AVX512_64:       # %bb.0:
; AVX512_64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512_64-NEXT:    retq
;
; AVX512DQ_32_WIN-LABEL: d_to_u64:
; AVX512DQ_32_WIN:       # %bb.0:
; AVX512DQ_32_WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ_32_WIN-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; AVX512DQ_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_WIN-NEXT:    vzeroupper
; AVX512DQ_32_WIN-NEXT:    retl
;
; AVX512DQ_32_LIN-LABEL: d_to_u64:
; AVX512DQ_32_LIN:       # %bb.0:
; AVX512DQ_32_LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ_32_LIN-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; AVX512DQ_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_LIN-NEXT:    vzeroupper
; AVX512DQ_32_LIN-NEXT:    retl
;
; AVX512F_32_WIN-LABEL: d_to_u64:
; AVX512F_32_WIN:       # %bb.0:
; AVX512F_32_WIN-NEXT:    pushl %ebp
; AVX512F_32_WIN-NEXT:    movl %esp, %ebp
; AVX512F_32_WIN-NEXT:    andl $-8, %esp
; AVX512F_32_WIN-NEXT:    subl $16, %esp
; AVX512F_32_WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F_32_WIN-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512F_32_WIN-NEXT:    vcmpltsd %xmm1, %xmm0, %k1
; AVX512F_32_WIN-NEXT:    vsubsd %xmm1, %xmm0, %xmm2
; AVX512F_32_WIN-NEXT:    vmovsd %xmm0, %xmm0, %xmm2 {%k1}
; AVX512F_32_WIN-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    fisttpll (%esp)
; AVX512F_32_WIN-NEXT:    xorl %edx, %edx
; AVX512F_32_WIN-NEXT:    vucomisd %xmm0, %xmm1
; AVX512F_32_WIN-NEXT:    setbe %dl
; AVX512F_32_WIN-NEXT:    shll $31, %edx
; AVX512F_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512F_32_WIN-NEXT:    movl (%esp), %eax
; AVX512F_32_WIN-NEXT:    movl %ebp, %esp
; AVX512F_32_WIN-NEXT:    popl %ebp
; AVX512F_32_WIN-NEXT:    retl
;
; AVX512F_32_LIN-LABEL: d_to_u64:
; AVX512F_32_LIN:       # %bb.0:
; AVX512F_32_LIN-NEXT:    subl $20, %esp
; AVX512F_32_LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F_32_LIN-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512F_32_LIN-NEXT:    vcmpltsd %xmm1, %xmm0, %k1
; AVX512F_32_LIN-NEXT:    vsubsd %xmm1, %xmm0, %xmm2
; AVX512F_32_LIN-NEXT:    vmovsd %xmm0, %xmm0, %xmm2 {%k1}
; AVX512F_32_LIN-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    fisttpll (%esp)
; AVX512F_32_LIN-NEXT:    xorl %edx, %edx
; AVX512F_32_LIN-NEXT:    vucomisd %xmm0, %xmm1
; AVX512F_32_LIN-NEXT:    setbe %dl
; AVX512F_32_LIN-NEXT:    shll $31, %edx
; AVX512F_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512F_32_LIN-NEXT:    movl (%esp), %eax
; AVX512F_32_LIN-NEXT:    addl $20, %esp
; AVX512F_32_LIN-NEXT:    retl
;
; SSE3_32_WIN-LABEL: d_to_u64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl %ebp
; SSE3_32_WIN-NEXT:    movl %esp, %ebp
; SSE3_32_WIN-NEXT:    andl $-8, %esp
; SSE3_32_WIN-NEXT:    subl $16, %esp
; SSE3_32_WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE3_32_WIN-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE3_32_WIN-NEXT:    movapd %xmm0, %xmm2
; SSE3_32_WIN-NEXT:    cmpltsd %xmm1, %xmm2
; SSE3_32_WIN-NEXT:    movapd %xmm2, %xmm3
; SSE3_32_WIN-NEXT:    andpd %xmm0, %xmm2
; SSE3_32_WIN-NEXT:    xorl %edx, %edx
; SSE3_32_WIN-NEXT:    ucomisd %xmm0, %xmm1
; SSE3_32_WIN-NEXT:    subsd %xmm1, %xmm0
; SSE3_32_WIN-NEXT:    andnpd %xmm0, %xmm3
; SSE3_32_WIN-NEXT:    orpd %xmm3, %xmm2
; SSE3_32_WIN-NEXT:    movsd %xmm2, {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    fisttpll (%esp)
; SSE3_32_WIN-NEXT:    setbe %dl
; SSE3_32_WIN-NEXT:    shll $31, %edx
; SSE3_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE3_32_WIN-NEXT:    movl (%esp), %eax
; SSE3_32_WIN-NEXT:    movl %ebp, %esp
; SSE3_32_WIN-NEXT:    popl %ebp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: d_to_u64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $20, %esp
; SSE3_32_LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE3_32_LIN-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE3_32_LIN-NEXT:    movapd %xmm0, %xmm2
; SSE3_32_LIN-NEXT:    cmpltsd %xmm1, %xmm2
; SSE3_32_LIN-NEXT:    movapd %xmm2, %xmm3
; SSE3_32_LIN-NEXT:    andpd %xmm0, %xmm2
; SSE3_32_LIN-NEXT:    xorl %edx, %edx
; SSE3_32_LIN-NEXT:    ucomisd %xmm0, %xmm1
; SSE3_32_LIN-NEXT:    subsd %xmm1, %xmm0
; SSE3_32_LIN-NEXT:    andnpd %xmm0, %xmm3
; SSE3_32_LIN-NEXT:    orpd %xmm3, %xmm2
; SSE3_32_LIN-NEXT:    movsd %xmm2, {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fisttpll (%esp)
; SSE3_32_LIN-NEXT:    setbe %dl
; SSE3_32_LIN-NEXT:    shll $31, %edx
; SSE3_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE3_32_LIN-NEXT:    movl (%esp), %eax
; SSE3_32_LIN-NEXT:    addl $20, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64-LABEL: d_to_u64:
; SSE3_64:       # %bb.0:
; SSE3_64-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE3_64-NEXT:    movapd %xmm0, %xmm2
; SSE3_64-NEXT:    subsd %xmm1, %xmm2
; SSE3_64-NEXT:    cvttsd2si %xmm2, %rax
; SSE3_64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; SSE3_64-NEXT:    xorq %rax, %rcx
; SSE3_64-NEXT:    cvttsd2si %xmm0, %rax
; SSE3_64-NEXT:    ucomisd %xmm1, %xmm0
; SSE3_64-NEXT:    cmovaeq %rcx, %rax
; SSE3_64-NEXT:    retq
;
; SSE2_32_WIN-LABEL: d_to_u64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl %ebp
; SSE2_32_WIN-NEXT:    movl %esp, %ebp
; SSE2_32_WIN-NEXT:    andl $-8, %esp
; SSE2_32_WIN-NEXT:    subl $24, %esp
; SSE2_32_WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2_32_WIN-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2_32_WIN-NEXT:    movapd %xmm0, %xmm2
; SSE2_32_WIN-NEXT:    cmpltsd %xmm1, %xmm2
; SSE2_32_WIN-NEXT:    movapd %xmm2, %xmm3
; SSE2_32_WIN-NEXT:    andpd %xmm0, %xmm2
; SSE2_32_WIN-NEXT:    xorl %edx, %edx
; SSE2_32_WIN-NEXT:    ucomisd %xmm0, %xmm1
; SSE2_32_WIN-NEXT:    subsd %xmm1, %xmm0
; SSE2_32_WIN-NEXT:    andnpd %xmm0, %xmm3
; SSE2_32_WIN-NEXT:    orpd %xmm3, %xmm2
; SSE2_32_WIN-NEXT:    movsd %xmm2, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    setbe %dl
; SSE2_32_WIN-NEXT:    shll $31, %edx
; SSE2_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movl %ebp, %esp
; SSE2_32_WIN-NEXT:    popl %ebp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: d_to_u64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $28, %esp
; SSE2_32_LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2_32_LIN-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2_32_LIN-NEXT:    movapd %xmm0, %xmm2
; SSE2_32_LIN-NEXT:    cmpltsd %xmm1, %xmm2
; SSE2_32_LIN-NEXT:    movapd %xmm2, %xmm3
; SSE2_32_LIN-NEXT:    andpd %xmm0, %xmm2
; SSE2_32_LIN-NEXT:    xorl %edx, %edx
; SSE2_32_LIN-NEXT:    ucomisd %xmm0, %xmm1
; SSE2_32_LIN-NEXT:    subsd %xmm1, %xmm0
; SSE2_32_LIN-NEXT:    andnpd %xmm0, %xmm3
; SSE2_32_LIN-NEXT:    orpd %xmm3, %xmm2
; SSE2_32_LIN-NEXT:    movsd %xmm2, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    setbe %dl
; SSE2_32_LIN-NEXT:    shll $31, %edx
; SSE2_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    addl $28, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64-LABEL: d_to_u64:
; SSE2_64:       # %bb.0:
; SSE2_64-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2_64-NEXT:    movapd %xmm0, %xmm2
; SSE2_64-NEXT:    subsd %xmm1, %xmm2
; SSE2_64-NEXT:    cvttsd2si %xmm2, %rax
; SSE2_64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; SSE2_64-NEXT:    xorq %rax, %rcx
; SSE2_64-NEXT:    cvttsd2si %xmm0, %rax
; SSE2_64-NEXT:    ucomisd %xmm1, %xmm0
; SSE2_64-NEXT:    cmovaeq %rcx, %rax
; SSE2_64-NEXT:    retq
;
; X87_WIN-LABEL: d_to_u64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl %ebp
; X87_WIN-NEXT:    movl %esp, %ebp
; X87_WIN-NEXT:    andl $-8, %esp
; X87_WIN-NEXT:    subl $16, %esp
; X87_WIN-NEXT:    fldl 8(%ebp)
; X87_WIN-NEXT:    flds __real@5f000000
; X87_WIN-NEXT:    fld %st(1)
; X87_WIN-NEXT:    fsub %st(1)
; X87_WIN-NEXT:    fxch %st(1)
; X87_WIN-NEXT:    fucomp %st(2)
; X87_WIN-NEXT:    fnstsw %ax
; X87_WIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87_WIN-NEXT:    sahf
; X87_WIN-NEXT:    ja LBB2_2
; X87_WIN-NEXT:  # %bb.1:
; X87_WIN-NEXT:    fstp %st(1)
; X87_WIN-NEXT:    fldz
; X87_WIN-NEXT:  LBB2_2:
; X87_WIN-NEXT:    fstp %st(0)
; X87_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    setbe %al
; X87_WIN-NEXT:    movzbl %al, %edx
; X87_WIN-NEXT:    shll $31, %edx
; X87_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movl %ebp, %esp
; X87_WIN-NEXT:    popl %ebp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: d_to_u64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $20, %esp
; X87_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    flds {{\.LCPI.*}}
; X87_LIN-NEXT:    fld %st(1)
; X87_LIN-NEXT:    fsub %st(1)
; X87_LIN-NEXT:    fxch %st(1)
; X87_LIN-NEXT:    fucomp %st(2)
; X87_LIN-NEXT:    fnstsw %ax
; X87_LIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87_LIN-NEXT:    sahf
; X87_LIN-NEXT:    ja .LBB2_2
; X87_LIN-NEXT:  # %bb.1:
; X87_LIN-NEXT:    fstp %st(1)
; X87_LIN-NEXT:    fldz
; X87_LIN-NEXT:  .LBB2_2:
; X87_LIN-NEXT:    fstp %st(0)
; X87_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    setbe %al
; X87_LIN-NEXT:    movzbl %al, %edx
; X87_LIN-NEXT:    shll $31, %edx
; X87_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    addl $20, %esp
; X87_LIN-NEXT:    retl
  %r = fptoui double %a to i64
  ret i64 %r
}

define i64 @d_to_s64(double %a) nounwind {
; AVX512DQVL_32_WIN-LABEL: d_to_s64:
; AVX512DQVL_32_WIN:       # %bb.0:
; AVX512DQVL_32_WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQVL_32_WIN-NEXT:    vcvttpd2qq %ymm0, %ymm0
; AVX512DQVL_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_WIN-NEXT:    vzeroupper
; AVX512DQVL_32_WIN-NEXT:    retl
;
; AVX512DQVL_32_LIN-LABEL: d_to_s64:
; AVX512DQVL_32_LIN:       # %bb.0:
; AVX512DQVL_32_LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQVL_32_LIN-NEXT:    vcvttpd2qq %ymm0, %ymm0
; AVX512DQVL_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQVL_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQVL_32_LIN-NEXT:    vzeroupper
; AVX512DQVL_32_LIN-NEXT:    retl
;
; AVX512_64-LABEL: d_to_s64:
; AVX512_64:       # %bb.0:
; AVX512_64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512_64-NEXT:    retq
;
; AVX512DQ_32_WIN-LABEL: d_to_s64:
; AVX512DQ_32_WIN:       # %bb.0:
; AVX512DQ_32_WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ_32_WIN-NEXT:    vcvttpd2qq %zmm0, %zmm0
; AVX512DQ_32_WIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_WIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_WIN-NEXT:    vzeroupper
; AVX512DQ_32_WIN-NEXT:    retl
;
; AVX512DQ_32_LIN-LABEL: d_to_s64:
; AVX512DQ_32_LIN:       # %bb.0:
; AVX512DQ_32_LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ_32_LIN-NEXT:    vcvttpd2qq %zmm0, %zmm0
; AVX512DQ_32_LIN-NEXT:    vmovd %xmm0, %eax
; AVX512DQ_32_LIN-NEXT:    vpextrd $1, %xmm0, %edx
; AVX512DQ_32_LIN-NEXT:    vzeroupper
; AVX512DQ_32_LIN-NEXT:    retl
;
; AVX512F_32_WIN-LABEL: d_to_s64:
; AVX512F_32_WIN:       # %bb.0:
; AVX512F_32_WIN-NEXT:    pushl %ebp
; AVX512F_32_WIN-NEXT:    movl %esp, %ebp
; AVX512F_32_WIN-NEXT:    andl $-8, %esp
; AVX512F_32_WIN-NEXT:    subl $16, %esp
; AVX512F_32_WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F_32_WIN-NEXT:    vmovsd %xmm0, {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F_32_WIN-NEXT:    fisttpll (%esp)
; AVX512F_32_WIN-NEXT:    movl (%esp), %eax
; AVX512F_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F_32_WIN-NEXT:    movl %ebp, %esp
; AVX512F_32_WIN-NEXT:    popl %ebp
; AVX512F_32_WIN-NEXT:    retl
;
; AVX512F_32_LIN-LABEL: d_to_s64:
; AVX512F_32_LIN:       # %bb.0:
; AVX512F_32_LIN-NEXT:    subl $20, %esp
; AVX512F_32_LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F_32_LIN-NEXT:    vmovsd %xmm0, {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F_32_LIN-NEXT:    fisttpll (%esp)
; AVX512F_32_LIN-NEXT:    movl (%esp), %eax
; AVX512F_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F_32_LIN-NEXT:    addl $20, %esp
; AVX512F_32_LIN-NEXT:    retl
;
; SSE3_32_WIN-LABEL: d_to_s64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl %ebp
; SSE3_32_WIN-NEXT:    movl %esp, %ebp
; SSE3_32_WIN-NEXT:    andl $-8, %esp
; SSE3_32_WIN-NEXT:    subl $16, %esp
; SSE3_32_WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE3_32_WIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    fisttpll (%esp)
; SSE3_32_WIN-NEXT:    movl (%esp), %eax
; SSE3_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE3_32_WIN-NEXT:    movl %ebp, %esp
; SSE3_32_WIN-NEXT:    popl %ebp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: d_to_s64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $20, %esp
; SSE3_32_LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE3_32_LIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fisttpll (%esp)
; SSE3_32_LIN-NEXT:    movl (%esp), %eax
; SSE3_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE3_32_LIN-NEXT:    addl $20, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64-LABEL: d_to_s64:
; SSE3_64:       # %bb.0:
; SSE3_64-NEXT:    cvttsd2si %xmm0, %rax
; SSE3_64-NEXT:    retq
;
; SSE2_32_WIN-LABEL: d_to_s64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl %ebp
; SSE2_32_WIN-NEXT:    movl %esp, %ebp
; SSE2_32_WIN-NEXT:    andl $-8, %esp
; SSE2_32_WIN-NEXT:    subl $24, %esp
; SSE2_32_WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2_32_WIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE2_32_WIN-NEXT:    movl %ebp, %esp
; SSE2_32_WIN-NEXT:    popl %ebp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: d_to_s64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $28, %esp
; SSE2_32_LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2_32_LIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE2_32_LIN-NEXT:    addl $28, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64-LABEL: d_to_s64:
; SSE2_64:       # %bb.0:
; SSE2_64-NEXT:    cvttsd2si %xmm0, %rax
; SSE2_64-NEXT:    retq
;
; X87_WIN-LABEL: d_to_s64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl %ebp
; X87_WIN-NEXT:    movl %esp, %ebp
; X87_WIN-NEXT:    andl $-8, %esp
; X87_WIN-NEXT:    subl $16, %esp
; X87_WIN-NEXT:    fldl 8(%ebp)
; X87_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87_WIN-NEXT:    movl %ebp, %esp
; X87_WIN-NEXT:    popl %ebp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: d_to_s64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $20, %esp
; X87_LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87_LIN-NEXT:    addl $20, %esp
; X87_LIN-NEXT:    retl
  %r = fptosi double %a to i64
  ret i64 %r
}

define i64 @x_to_u64(x86_fp80 %a) nounwind {
; AVX512_32_WIN-LABEL: x_to_u64:
; AVX512_32_WIN:       # %bb.0:
; AVX512_32_WIN-NEXT:    pushl %ebp
; AVX512_32_WIN-NEXT:    movl %esp, %ebp
; AVX512_32_WIN-NEXT:    andl $-8, %esp
; AVX512_32_WIN-NEXT:    subl $8, %esp
; AVX512_32_WIN-NEXT:    fldt 8(%ebp)
; AVX512_32_WIN-NEXT:    flds __real@5f000000
; AVX512_32_WIN-NEXT:    fld %st(1)
; AVX512_32_WIN-NEXT:    fsub %st(1)
; AVX512_32_WIN-NEXT:    xorl %edx, %edx
; AVX512_32_WIN-NEXT:    fxch %st(1)
; AVX512_32_WIN-NEXT:    fucompi %st(2)
; AVX512_32_WIN-NEXT:    fcmovnbe %st(1), %st(0)
; AVX512_32_WIN-NEXT:    fstp %st(1)
; AVX512_32_WIN-NEXT:    fisttpll (%esp)
; AVX512_32_WIN-NEXT:    setbe %dl
; AVX512_32_WIN-NEXT:    shll $31, %edx
; AVX512_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512_32_WIN-NEXT:    movl (%esp), %eax
; AVX512_32_WIN-NEXT:    movl %ebp, %esp
; AVX512_32_WIN-NEXT:    popl %ebp
; AVX512_32_WIN-NEXT:    retl
;
; AVX512_32_LIN-LABEL: x_to_u64:
; AVX512_32_LIN:       # %bb.0:
; AVX512_32_LIN-NEXT:    subl $12, %esp
; AVX512_32_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; AVX512_32_LIN-NEXT:    flds {{\.LCPI.*}}
; AVX512_32_LIN-NEXT:    fld %st(1)
; AVX512_32_LIN-NEXT:    fsub %st(1)
; AVX512_32_LIN-NEXT:    xorl %edx, %edx
; AVX512_32_LIN-NEXT:    fxch %st(1)
; AVX512_32_LIN-NEXT:    fucompi %st(2)
; AVX512_32_LIN-NEXT:    fcmovnbe %st(1), %st(0)
; AVX512_32_LIN-NEXT:    fstp %st(1)
; AVX512_32_LIN-NEXT:    fisttpll (%esp)
; AVX512_32_LIN-NEXT:    setbe %dl
; AVX512_32_LIN-NEXT:    shll $31, %edx
; AVX512_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512_32_LIN-NEXT:    movl (%esp), %eax
; AVX512_32_LIN-NEXT:    addl $12, %esp
; AVX512_32_LIN-NEXT:    retl
;
; AVX512_64_WIN-LABEL: x_to_u64:
; AVX512_64_WIN:       # %bb.0:
; AVX512_64_WIN-NEXT:    pushq %rax
; AVX512_64_WIN-NEXT:    fldt (%rcx)
; AVX512_64_WIN-NEXT:    flds __real@{{.*}}(%rip)
; AVX512_64_WIN-NEXT:    fld %st(1)
; AVX512_64_WIN-NEXT:    fsub %st(1)
; AVX512_64_WIN-NEXT:    xorl %ecx, %ecx
; AVX512_64_WIN-NEXT:    fxch %st(1)
; AVX512_64_WIN-NEXT:    fucompi %st(2)
; AVX512_64_WIN-NEXT:    fcmovnbe %st(1), %st(0)
; AVX512_64_WIN-NEXT:    fstp %st(1)
; AVX512_64_WIN-NEXT:    fisttpll (%rsp)
; AVX512_64_WIN-NEXT:    setbe %cl
; AVX512_64_WIN-NEXT:    shll $31, %ecx
; AVX512_64_WIN-NEXT:    xorl {{[0-9]+}}(%rsp), %ecx
; AVX512_64_WIN-NEXT:    shlq $32, %rcx
; AVX512_64_WIN-NEXT:    movl (%rsp), %eax
; AVX512_64_WIN-NEXT:    orq %rcx, %rax
; AVX512_64_WIN-NEXT:    popq %rcx
; AVX512_64_WIN-NEXT:    retq
;
; AVX512_64_LIN-LABEL: x_to_u64:
; AVX512_64_LIN:       # %bb.0:
; AVX512_64_LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; AVX512_64_LIN-NEXT:    flds {{.*}}(%rip)
; AVX512_64_LIN-NEXT:    fld %st(1)
; AVX512_64_LIN-NEXT:    fsub %st(1)
; AVX512_64_LIN-NEXT:    xorl %ecx, %ecx
; AVX512_64_LIN-NEXT:    fxch %st(1)
; AVX512_64_LIN-NEXT:    fucompi %st(2)
; AVX512_64_LIN-NEXT:    fcmovnbe %st(1), %st(0)
; AVX512_64_LIN-NEXT:    fstp %st(1)
; AVX512_64_LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; AVX512_64_LIN-NEXT:    setbe %cl
; AVX512_64_LIN-NEXT:    shll $31, %ecx
; AVX512_64_LIN-NEXT:    xorl -{{[0-9]+}}(%rsp), %ecx
; AVX512_64_LIN-NEXT:    shlq $32, %rcx
; AVX512_64_LIN-NEXT:    movl -{{[0-9]+}}(%rsp), %eax
; AVX512_64_LIN-NEXT:    orq %rcx, %rax
; AVX512_64_LIN-NEXT:    retq
;
; SSE3_32_WIN-LABEL: x_to_u64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl %ebp
; SSE3_32_WIN-NEXT:    movl %esp, %ebp
; SSE3_32_WIN-NEXT:    andl $-8, %esp
; SSE3_32_WIN-NEXT:    subl $8, %esp
; SSE3_32_WIN-NEXT:    fldt 8(%ebp)
; SSE3_32_WIN-NEXT:    flds __real@5f000000
; SSE3_32_WIN-NEXT:    fld %st(1)
; SSE3_32_WIN-NEXT:    fsub %st(1)
; SSE3_32_WIN-NEXT:    xorl %edx, %edx
; SSE3_32_WIN-NEXT:    fxch %st(1)
; SSE3_32_WIN-NEXT:    fucompi %st(2)
; SSE3_32_WIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE3_32_WIN-NEXT:    fstp %st(1)
; SSE3_32_WIN-NEXT:    fisttpll (%esp)
; SSE3_32_WIN-NEXT:    setbe %dl
; SSE3_32_WIN-NEXT:    shll $31, %edx
; SSE3_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE3_32_WIN-NEXT:    movl (%esp), %eax
; SSE3_32_WIN-NEXT:    movl %ebp, %esp
; SSE3_32_WIN-NEXT:    popl %ebp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: x_to_u64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $12, %esp
; SSE3_32_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    flds {{\.LCPI.*}}
; SSE3_32_LIN-NEXT:    fld %st(1)
; SSE3_32_LIN-NEXT:    fsub %st(1)
; SSE3_32_LIN-NEXT:    xorl %edx, %edx
; SSE3_32_LIN-NEXT:    fxch %st(1)
; SSE3_32_LIN-NEXT:    fucompi %st(2)
; SSE3_32_LIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE3_32_LIN-NEXT:    fstp %st(1)
; SSE3_32_LIN-NEXT:    fisttpll (%esp)
; SSE3_32_LIN-NEXT:    setbe %dl
; SSE3_32_LIN-NEXT:    shll $31, %edx
; SSE3_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE3_32_LIN-NEXT:    movl (%esp), %eax
; SSE3_32_LIN-NEXT:    addl $12, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64_WIN-LABEL: x_to_u64:
; SSE3_64_WIN:       # %bb.0:
; SSE3_64_WIN-NEXT:    pushq %rax
; SSE3_64_WIN-NEXT:    fldt (%rcx)
; SSE3_64_WIN-NEXT:    flds __real@{{.*}}(%rip)
; SSE3_64_WIN-NEXT:    fld %st(1)
; SSE3_64_WIN-NEXT:    fsub %st(1)
; SSE3_64_WIN-NEXT:    xorl %eax, %eax
; SSE3_64_WIN-NEXT:    fxch %st(1)
; SSE3_64_WIN-NEXT:    fucompi %st(2)
; SSE3_64_WIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE3_64_WIN-NEXT:    fstp %st(1)
; SSE3_64_WIN-NEXT:    fisttpll (%rsp)
; SSE3_64_WIN-NEXT:    setbe %al
; SSE3_64_WIN-NEXT:    shlq $63, %rax
; SSE3_64_WIN-NEXT:    xorq (%rsp), %rax
; SSE3_64_WIN-NEXT:    popq %rcx
; SSE3_64_WIN-NEXT:    retq
;
; SSE3_64_LIN-LABEL: x_to_u64:
; SSE3_64_LIN:       # %bb.0:
; SSE3_64_LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; SSE3_64_LIN-NEXT:    flds {{.*}}(%rip)
; SSE3_64_LIN-NEXT:    fld %st(1)
; SSE3_64_LIN-NEXT:    fsub %st(1)
; SSE3_64_LIN-NEXT:    xorl %eax, %eax
; SSE3_64_LIN-NEXT:    fxch %st(1)
; SSE3_64_LIN-NEXT:    fucompi %st(2)
; SSE3_64_LIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE3_64_LIN-NEXT:    fstp %st(1)
; SSE3_64_LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; SSE3_64_LIN-NEXT:    setbe %al
; SSE3_64_LIN-NEXT:    shlq $63, %rax
; SSE3_64_LIN-NEXT:    xorq -{{[0-9]+}}(%rsp), %rax
; SSE3_64_LIN-NEXT:    retq
;
; SSE2_32_WIN-LABEL: x_to_u64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl %ebp
; SSE2_32_WIN-NEXT:    movl %esp, %ebp
; SSE2_32_WIN-NEXT:    andl $-8, %esp
; SSE2_32_WIN-NEXT:    subl $16, %esp
; SSE2_32_WIN-NEXT:    fldt 8(%ebp)
; SSE2_32_WIN-NEXT:    flds __real@5f000000
; SSE2_32_WIN-NEXT:    fld %st(1)
; SSE2_32_WIN-NEXT:    fsub %st(1)
; SSE2_32_WIN-NEXT:    xorl %edx, %edx
; SSE2_32_WIN-NEXT:    fxch %st(1)
; SSE2_32_WIN-NEXT:    fucompi %st(2)
; SSE2_32_WIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE2_32_WIN-NEXT:    fstp %st(1)
; SSE2_32_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    setbe %dl
; SSE2_32_WIN-NEXT:    shll $31, %edx
; SSE2_32_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movl %ebp, %esp
; SSE2_32_WIN-NEXT:    popl %ebp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: x_to_u64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $20, %esp
; SSE2_32_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    flds {{\.LCPI.*}}
; SSE2_32_LIN-NEXT:    fld %st(1)
; SSE2_32_LIN-NEXT:    fsub %st(1)
; SSE2_32_LIN-NEXT:    xorl %edx, %edx
; SSE2_32_LIN-NEXT:    fxch %st(1)
; SSE2_32_LIN-NEXT:    fucompi %st(2)
; SSE2_32_LIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE2_32_LIN-NEXT:    fstp %st(1)
; SSE2_32_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    setbe %dl
; SSE2_32_LIN-NEXT:    shll $31, %edx
; SSE2_32_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    addl $20, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64_WIN-LABEL: x_to_u64:
; SSE2_64_WIN:       # %bb.0:
; SSE2_64_WIN-NEXT:    subq $16, %rsp
; SSE2_64_WIN-NEXT:    fldt (%rcx)
; SSE2_64_WIN-NEXT:    flds __real@{{.*}}(%rip)
; SSE2_64_WIN-NEXT:    fld %st(1)
; SSE2_64_WIN-NEXT:    fsub %st(1)
; SSE2_64_WIN-NEXT:    xorl %eax, %eax
; SSE2_64_WIN-NEXT:    fxch %st(1)
; SSE2_64_WIN-NEXT:    fucompi %st(2)
; SSE2_64_WIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE2_64_WIN-NEXT:    fstp %st(1)
; SSE2_64_WIN-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; SSE2_64_WIN-NEXT:    movw $3199, {{[0-9]+}}(%rsp) # imm = 0xC7F
; SSE2_64_WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    fistpll {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    setbe %al
; SSE2_64_WIN-NEXT:    shlq $63, %rax
; SSE2_64_WIN-NEXT:    xorq {{[0-9]+}}(%rsp), %rax
; SSE2_64_WIN-NEXT:    addq $16, %rsp
; SSE2_64_WIN-NEXT:    retq
;
; SSE2_64_LIN-LABEL: x_to_u64:
; SSE2_64_LIN:       # %bb.0:
; SSE2_64_LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    flds {{.*}}(%rip)
; SSE2_64_LIN-NEXT:    fld %st(1)
; SSE2_64_LIN-NEXT:    fsub %st(1)
; SSE2_64_LIN-NEXT:    xorl %eax, %eax
; SSE2_64_LIN-NEXT:    fxch %st(1)
; SSE2_64_LIN-NEXT:    fucompi %st(2)
; SSE2_64_LIN-NEXT:    fcmovnbe %st(1), %st(0)
; SSE2_64_LIN-NEXT:    fstp %st(1)
; SSE2_64_LIN-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    movzwl -{{[0-9]+}}(%rsp), %ecx
; SSE2_64_LIN-NEXT:    movw $3199, -{{[0-9]+}}(%rsp) # imm = 0xC7F
; SSE2_64_LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    movw %cx, -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    fistpll -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    setbe %al
; SSE2_64_LIN-NEXT:    shlq $63, %rax
; SSE2_64_LIN-NEXT:    xorq -{{[0-9]+}}(%rsp), %rax
; SSE2_64_LIN-NEXT:    retq
;
; X87_WIN-LABEL: x_to_u64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl %ebp
; X87_WIN-NEXT:    movl %esp, %ebp
; X87_WIN-NEXT:    andl $-8, %esp
; X87_WIN-NEXT:    subl $16, %esp
; X87_WIN-NEXT:    fldt 8(%ebp)
; X87_WIN-NEXT:    flds __real@5f000000
; X87_WIN-NEXT:    fld %st(1)
; X87_WIN-NEXT:    fsub %st(1)
; X87_WIN-NEXT:    fxch %st(1)
; X87_WIN-NEXT:    fucomp %st(2)
; X87_WIN-NEXT:    fnstsw %ax
; X87_WIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87_WIN-NEXT:    sahf
; X87_WIN-NEXT:    ja LBB4_2
; X87_WIN-NEXT:  # %bb.1:
; X87_WIN-NEXT:    fstp %st(1)
; X87_WIN-NEXT:    fldz
; X87_WIN-NEXT:  LBB4_2:
; X87_WIN-NEXT:    fstp %st(0)
; X87_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    setbe %al
; X87_WIN-NEXT:    movzbl %al, %edx
; X87_WIN-NEXT:    shll $31, %edx
; X87_WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movl %ebp, %esp
; X87_WIN-NEXT:    popl %ebp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: x_to_u64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $20, %esp
; X87_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    flds {{\.LCPI.*}}
; X87_LIN-NEXT:    fld %st(1)
; X87_LIN-NEXT:    fsub %st(1)
; X87_LIN-NEXT:    fxch %st(1)
; X87_LIN-NEXT:    fucomp %st(2)
; X87_LIN-NEXT:    fnstsw %ax
; X87_LIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87_LIN-NEXT:    sahf
; X87_LIN-NEXT:    ja .LBB4_2
; X87_LIN-NEXT:  # %bb.1:
; X87_LIN-NEXT:    fstp %st(1)
; X87_LIN-NEXT:    fldz
; X87_LIN-NEXT:  .LBB4_2:
; X87_LIN-NEXT:    fstp %st(0)
; X87_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    setbe %al
; X87_LIN-NEXT:    movzbl %al, %edx
; X87_LIN-NEXT:    shll $31, %edx
; X87_LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    addl $20, %esp
; X87_LIN-NEXT:    retl
  %r = fptoui x86_fp80 %a to i64
  ret i64 %r
}

define i64 @x_to_s64(x86_fp80 %a) nounwind {
; AVX512_32_WIN-LABEL: x_to_s64:
; AVX512_32_WIN:       # %bb.0:
; AVX512_32_WIN-NEXT:    pushl %ebp
; AVX512_32_WIN-NEXT:    movl %esp, %ebp
; AVX512_32_WIN-NEXT:    andl $-8, %esp
; AVX512_32_WIN-NEXT:    subl $8, %esp
; AVX512_32_WIN-NEXT:    fldt 8(%ebp)
; AVX512_32_WIN-NEXT:    fisttpll (%esp)
; AVX512_32_WIN-NEXT:    movl (%esp), %eax
; AVX512_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512_32_WIN-NEXT:    movl %ebp, %esp
; AVX512_32_WIN-NEXT:    popl %ebp
; AVX512_32_WIN-NEXT:    retl
;
; AVX512_32_LIN-LABEL: x_to_s64:
; AVX512_32_LIN:       # %bb.0:
; AVX512_32_LIN-NEXT:    subl $12, %esp
; AVX512_32_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; AVX512_32_LIN-NEXT:    fisttpll (%esp)
; AVX512_32_LIN-NEXT:    movl (%esp), %eax
; AVX512_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512_32_LIN-NEXT:    addl $12, %esp
; AVX512_32_LIN-NEXT:    retl
;
; AVX512_64_WIN-LABEL: x_to_s64:
; AVX512_64_WIN:       # %bb.0:
; AVX512_64_WIN-NEXT:    pushq %rax
; AVX512_64_WIN-NEXT:    fldt (%rcx)
; AVX512_64_WIN-NEXT:    fisttpll (%rsp)
; AVX512_64_WIN-NEXT:    movq (%rsp), %rax
; AVX512_64_WIN-NEXT:    popq %rcx
; AVX512_64_WIN-NEXT:    retq
;
; AVX512_64_LIN-LABEL: x_to_s64:
; AVX512_64_LIN:       # %bb.0:
; AVX512_64_LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; AVX512_64_LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; AVX512_64_LIN-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512_64_LIN-NEXT:    retq
;
; SSE3_32_WIN-LABEL: x_to_s64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl %ebp
; SSE3_32_WIN-NEXT:    movl %esp, %ebp
; SSE3_32_WIN-NEXT:    andl $-8, %esp
; SSE3_32_WIN-NEXT:    subl $8, %esp
; SSE3_32_WIN-NEXT:    fldt 8(%ebp)
; SSE3_32_WIN-NEXT:    fisttpll (%esp)
; SSE3_32_WIN-NEXT:    movl (%esp), %eax
; SSE3_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE3_32_WIN-NEXT:    movl %ebp, %esp
; SSE3_32_WIN-NEXT:    popl %ebp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: x_to_s64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $12, %esp
; SSE3_32_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    fisttpll (%esp)
; SSE3_32_LIN-NEXT:    movl (%esp), %eax
; SSE3_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE3_32_LIN-NEXT:    addl $12, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64_WIN-LABEL: x_to_s64:
; SSE3_64_WIN:       # %bb.0:
; SSE3_64_WIN-NEXT:    pushq %rax
; SSE3_64_WIN-NEXT:    fldt (%rcx)
; SSE3_64_WIN-NEXT:    fisttpll (%rsp)
; SSE3_64_WIN-NEXT:    movq (%rsp), %rax
; SSE3_64_WIN-NEXT:    popq %rcx
; SSE3_64_WIN-NEXT:    retq
;
; SSE3_64_LIN-LABEL: x_to_s64:
; SSE3_64_LIN:       # %bb.0:
; SSE3_64_LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; SSE3_64_LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; SSE3_64_LIN-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; SSE3_64_LIN-NEXT:    retq
;
; SSE2_32_WIN-LABEL: x_to_s64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl %ebp
; SSE2_32_WIN-NEXT:    movl %esp, %ebp
; SSE2_32_WIN-NEXT:    andl $-8, %esp
; SSE2_32_WIN-NEXT:    subl $16, %esp
; SSE2_32_WIN-NEXT:    fldt 8(%ebp)
; SSE2_32_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE2_32_WIN-NEXT:    movl %ebp, %esp
; SSE2_32_WIN-NEXT:    popl %ebp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: x_to_s64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $20, %esp
; SSE2_32_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2_32_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE2_32_LIN-NEXT:    addl $20, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64_WIN-LABEL: x_to_s64:
; SSE2_64_WIN:       # %bb.0:
; SSE2_64_WIN-NEXT:    subq $16, %rsp
; SSE2_64_WIN-NEXT:    fldt (%rcx)
; SSE2_64_WIN-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; SSE2_64_WIN-NEXT:    movw $3199, {{[0-9]+}}(%rsp) # imm = 0xC7F
; SSE2_64_WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    movw %ax, {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    fistpll {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; SSE2_64_WIN-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE2_64_WIN-NEXT:    addq $16, %rsp
; SSE2_64_WIN-NEXT:    retq
;
; SSE2_64_LIN-LABEL: x_to_s64:
; SSE2_64_LIN:       # %bb.0:
; SSE2_64_LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    movzwl -{{[0-9]+}}(%rsp), %eax
; SSE2_64_LIN-NEXT:    movw $3199, -{{[0-9]+}}(%rsp) # imm = 0xC7F
; SSE2_64_LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    movw %ax, -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    fistpll -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE2_64_LIN-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; SSE2_64_LIN-NEXT:    retq
;
; X87_WIN-LABEL: x_to_s64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl %ebp
; X87_WIN-NEXT:    movl %esp, %ebp
; X87_WIN-NEXT:    andl $-8, %esp
; X87_WIN-NEXT:    subl $16, %esp
; X87_WIN-NEXT:    fldt 8(%ebp)
; X87_WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87_WIN-NEXT:    movl %ebp, %esp
; X87_WIN-NEXT:    popl %ebp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: x_to_s64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $20, %esp
; X87_LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movw $3199, {{[0-9]+}}(%esp) # imm = 0xC7F
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87_LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87_LIN-NEXT:    addl $20, %esp
; X87_LIN-NEXT:    retl
  %r = fptosi x86_fp80 %a to i64
  ret i64 %r
}

define i64 @t_to_u64(fp128 %a) nounwind {
; AVX512_32_WIN-LABEL: t_to_u64:
; AVX512_32_WIN:       # %bb.0:
; AVX512_32_WIN-NEXT:    subl $16, %esp
; AVX512_32_WIN-NEXT:    vmovups {{[0-9]+}}(%esp), %xmm0
; AVX512_32_WIN-NEXT:    vmovups %xmm0, (%esp)
; AVX512_32_WIN-NEXT:    calll ___fixunstfdi
; AVX512_32_WIN-NEXT:    addl $16, %esp
; AVX512_32_WIN-NEXT:    retl
;
; AVX512_32_LIN-LABEL: t_to_u64:
; AVX512_32_LIN:       # %bb.0:
; AVX512_32_LIN-NEXT:    subl $28, %esp
; AVX512_32_LIN-NEXT:    vmovaps {{[0-9]+}}(%esp), %xmm0
; AVX512_32_LIN-NEXT:    vmovups %xmm0, (%esp)
; AVX512_32_LIN-NEXT:    calll __fixunstfdi
; AVX512_32_LIN-NEXT:    addl $28, %esp
; AVX512_32_LIN-NEXT:    retl
;
; AVX512_64_WIN-LABEL: t_to_u64:
; AVX512_64_WIN:       # %bb.0:
; AVX512_64_WIN-NEXT:    subq $40, %rsp
; AVX512_64_WIN-NEXT:    callq __fixunstfdi
; AVX512_64_WIN-NEXT:    addq $40, %rsp
; AVX512_64_WIN-NEXT:    retq
;
; AVX512_64_LIN-LABEL: t_to_u64:
; AVX512_64_LIN:       # %bb.0:
; AVX512_64_LIN-NEXT:    pushq %rax
; AVX512_64_LIN-NEXT:    callq __fixunstfdi
; AVX512_64_LIN-NEXT:    popq %rcx
; AVX512_64_LIN-NEXT:    retq
;
; SSE3_32_WIN-LABEL: t_to_u64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    calll ___fixunstfdi
; SSE3_32_WIN-NEXT:    addl $16, %esp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: t_to_u64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $12, %esp
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    calll __fixunstfdi
; SSE3_32_LIN-NEXT:    addl $28, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64_WIN-LABEL: t_to_u64:
; SSE3_64_WIN:       # %bb.0:
; SSE3_64_WIN-NEXT:    subq $40, %rsp
; SSE3_64_WIN-NEXT:    callq __fixunstfdi
; SSE3_64_WIN-NEXT:    addq $40, %rsp
; SSE3_64_WIN-NEXT:    retq
;
; SSE3_64_LIN-LABEL: t_to_u64:
; SSE3_64_LIN:       # %bb.0:
; SSE3_64_LIN-NEXT:    pushq %rax
; SSE3_64_LIN-NEXT:    callq __fixunstfdi
; SSE3_64_LIN-NEXT:    popq %rcx
; SSE3_64_LIN-NEXT:    retq
;
; SSE2_32_WIN-LABEL: t_to_u64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    calll ___fixunstfdi
; SSE2_32_WIN-NEXT:    addl $16, %esp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: t_to_u64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $12, %esp
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    calll __fixunstfdi
; SSE2_32_LIN-NEXT:    addl $28, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64_WIN-LABEL: t_to_u64:
; SSE2_64_WIN:       # %bb.0:
; SSE2_64_WIN-NEXT:    subq $40, %rsp
; SSE2_64_WIN-NEXT:    callq __fixunstfdi
; SSE2_64_WIN-NEXT:    addq $40, %rsp
; SSE2_64_WIN-NEXT:    retq
;
; SSE2_64_LIN-LABEL: t_to_u64:
; SSE2_64_LIN:       # %bb.0:
; SSE2_64_LIN-NEXT:    pushq %rax
; SSE2_64_LIN-NEXT:    callq __fixunstfdi
; SSE2_64_LIN-NEXT:    popq %rcx
; SSE2_64_LIN-NEXT:    retq
;
; X87_WIN-LABEL: t_to_u64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    calll ___fixunstfdi
; X87_WIN-NEXT:    addl $16, %esp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: t_to_u64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $12, %esp
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    calll __fixunstfdi
; X87_LIN-NEXT:    addl $28, %esp
; X87_LIN-NEXT:    retl
  %r = fptoui fp128 %a to i64
  ret i64 %r
}

define i64 @t_to_s64(fp128 %a) nounwind {
; AVX512_32_WIN-LABEL: t_to_s64:
; AVX512_32_WIN:       # %bb.0:
; AVX512_32_WIN-NEXT:    subl $16, %esp
; AVX512_32_WIN-NEXT:    vmovups {{[0-9]+}}(%esp), %xmm0
; AVX512_32_WIN-NEXT:    vmovups %xmm0, (%esp)
; AVX512_32_WIN-NEXT:    calll ___fixtfdi
; AVX512_32_WIN-NEXT:    addl $16, %esp
; AVX512_32_WIN-NEXT:    retl
;
; AVX512_32_LIN-LABEL: t_to_s64:
; AVX512_32_LIN:       # %bb.0:
; AVX512_32_LIN-NEXT:    subl $28, %esp
; AVX512_32_LIN-NEXT:    vmovaps {{[0-9]+}}(%esp), %xmm0
; AVX512_32_LIN-NEXT:    vmovups %xmm0, (%esp)
; AVX512_32_LIN-NEXT:    calll __fixtfdi
; AVX512_32_LIN-NEXT:    addl $28, %esp
; AVX512_32_LIN-NEXT:    retl
;
; AVX512_64_WIN-LABEL: t_to_s64:
; AVX512_64_WIN:       # %bb.0:
; AVX512_64_WIN-NEXT:    subq $40, %rsp
; AVX512_64_WIN-NEXT:    callq __fixtfdi
; AVX512_64_WIN-NEXT:    addq $40, %rsp
; AVX512_64_WIN-NEXT:    retq
;
; AVX512_64_LIN-LABEL: t_to_s64:
; AVX512_64_LIN:       # %bb.0:
; AVX512_64_LIN-NEXT:    pushq %rax
; AVX512_64_LIN-NEXT:    callq __fixtfdi
; AVX512_64_LIN-NEXT:    popq %rcx
; AVX512_64_LIN-NEXT:    retq
;
; SSE3_32_WIN-LABEL: t_to_s64:
; SSE3_32_WIN:       # %bb.0:
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_WIN-NEXT:    calll ___fixtfdi
; SSE3_32_WIN-NEXT:    addl $16, %esp
; SSE3_32_WIN-NEXT:    retl
;
; SSE3_32_LIN-LABEL: t_to_s64:
; SSE3_32_LIN:       # %bb.0:
; SSE3_32_LIN-NEXT:    subl $12, %esp
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE3_32_LIN-NEXT:    calll __fixtfdi
; SSE3_32_LIN-NEXT:    addl $28, %esp
; SSE3_32_LIN-NEXT:    retl
;
; SSE3_64_WIN-LABEL: t_to_s64:
; SSE3_64_WIN:       # %bb.0:
; SSE3_64_WIN-NEXT:    subq $40, %rsp
; SSE3_64_WIN-NEXT:    callq __fixtfdi
; SSE3_64_WIN-NEXT:    addq $40, %rsp
; SSE3_64_WIN-NEXT:    retq
;
; SSE3_64_LIN-LABEL: t_to_s64:
; SSE3_64_LIN:       # %bb.0:
; SSE3_64_LIN-NEXT:    pushq %rax
; SSE3_64_LIN-NEXT:    callq __fixtfdi
; SSE3_64_LIN-NEXT:    popq %rcx
; SSE3_64_LIN-NEXT:    retq
;
; SSE2_32_WIN-LABEL: t_to_s64:
; SSE2_32_WIN:       # %bb.0:
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_WIN-NEXT:    calll ___fixtfdi
; SSE2_32_WIN-NEXT:    addl $16, %esp
; SSE2_32_WIN-NEXT:    retl
;
; SSE2_32_LIN-LABEL: t_to_s64:
; SSE2_32_LIN:       # %bb.0:
; SSE2_32_LIN-NEXT:    subl $12, %esp
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; SSE2_32_LIN-NEXT:    calll __fixtfdi
; SSE2_32_LIN-NEXT:    addl $28, %esp
; SSE2_32_LIN-NEXT:    retl
;
; SSE2_64_WIN-LABEL: t_to_s64:
; SSE2_64_WIN:       # %bb.0:
; SSE2_64_WIN-NEXT:    subq $40, %rsp
; SSE2_64_WIN-NEXT:    callq __fixtfdi
; SSE2_64_WIN-NEXT:    addq $40, %rsp
; SSE2_64_WIN-NEXT:    retq
;
; SSE2_64_LIN-LABEL: t_to_s64:
; SSE2_64_LIN:       # %bb.0:
; SSE2_64_LIN-NEXT:    pushq %rax
; SSE2_64_LIN-NEXT:    callq __fixtfdi
; SSE2_64_LIN-NEXT:    popq %rcx
; SSE2_64_LIN-NEXT:    retq
;
; X87_WIN-LABEL: t_to_s64:
; X87_WIN:       # %bb.0:
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_WIN-NEXT:    calll ___fixtfdi
; X87_WIN-NEXT:    addl $16, %esp
; X87_WIN-NEXT:    retl
;
; X87_LIN-LABEL: t_to_s64:
; X87_LIN:       # %bb.0:
; X87_LIN-NEXT:    subl $12, %esp
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87_LIN-NEXT:    calll __fixtfdi
; X87_LIN-NEXT:    addl $28, %esp
; X87_LIN-NEXT:    retl
  %r = fptosi fp128 %a to i64
  ret i64 %r
}
