; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define <4 x i32> @vec_select(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: @vec_select(
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw <4 x i32> zeroinitializer, [[A:%.*]]
; CHECK-NEXT:    [[ISNEG:%.*]] = icmp slt <4 x i32> [[B:%.*]], zeroinitializer
; CHECK-NEXT:    [[T2:%.*]] = select <4 x i1> [[ISNEG]], <4 x i32> zeroinitializer, <4 x i32> [[A]]
; CHECK-NEXT:    [[ISNEG1:%.*]] = icmp slt <4 x i32> [[B]], zeroinitializer
; CHECK-NEXT:    [[T3:%.*]] = select <4 x i1> [[ISNEG1]], <4 x i32> [[SUB]], <4 x i32> zeroinitializer
; CHECK-NEXT:    [[COND:%.*]] = or <4 x i32> [[T2]], [[T3]]
; CHECK-NEXT:    ret <4 x i32> [[COND]]
;
  %cmp = icmp slt <4 x i32> %b, zeroinitializer
  %sext = sext <4 x i1> %cmp to <4 x i32>
  %sub = sub nsw <4 x i32> zeroinitializer, %a
  %t0 = icmp slt <4 x i32> %sext, zeroinitializer
  %sext3 = sext <4 x i1> %t0 to <4 x i32>
  %t1 = xor <4 x i32> %sext3, <i32 -1, i32 -1, i32 -1, i32 -1>
  %t2 = and <4 x i32> %a, %t1
  %t3 = and <4 x i32> %sext3, %sub
  %cond = or <4 x i32> %t2, %t3
  ret <4 x i32> %cond
}

define <4 x i32> @vec_select_alternate_sign_bit_test(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: @vec_select_alternate_sign_bit_test(
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw <4 x i32> zeroinitializer, [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt <4 x i32> [[B:%.*]], zeroinitializer
; CHECK-NEXT:    [[COND:%.*]] = select <4 x i1> [[CMP1]], <4 x i32> [[A]], <4 x i32> [[SUB]]
; CHECK-NEXT:    ret <4 x i32> [[COND]]
;
  %cmp = icmp sgt <4 x i32> %b, <i32 -1, i32 -1, i32 -1, i32 -1>
  %sext = sext <4 x i1> %cmp to <4 x i32>
  %sub = sub nsw <4 x i32> zeroinitializer, %a
  %t0 = icmp slt <4 x i32> %sext, zeroinitializer
  %sext3 = sext <4 x i1> %t0 to <4 x i32>
  %t1 = xor <4 x i32> %sext3, <i32 -1, i32 -1, i32 -1, i32 -1>
  %t2 = and <4 x i32> %a, %t1
  %t3 = and <4 x i32> %sext3, %sub
  %cond = or <4 x i32> %t2, %t3
  ret <4 x i32> %cond
}

define <2 x i32> @is_negative_undef_elt(<2 x i32> %a) {
; CHECK-LABEL: @is_negative_undef_elt(
; CHECK-NEXT:    [[A_LOBIT:%.*]] = ashr <2 x i32> [[A:%.*]], <i32 31, i32 31>
; CHECK-NEXT:    ret <2 x i32> [[A_LOBIT]]
;
  %cmp = icmp slt <2 x i32> %a, <i32 0, i32 undef>
  %sext = sext <2 x i1> %cmp to <2 x i32>
  ret <2 x i32> %sext

}

define <2 x i32> @is_positive_undef_elt(<2 x i32> %a) {
; CHECK-LABEL: @is_positive_undef_elt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <2 x i32> [[A:%.*]], <i32 undef, i32 -1>
; CHECK-NEXT:    [[SEXT:%.*]] = sext <2 x i1> [[CMP]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[SEXT]]
;
  %cmp = icmp sgt <2 x i32> %a, <i32 undef, i32 -1>
  %sext = sext <2 x i1> %cmp to <2 x i32>
  ret <2 x i32> %sext
}

