// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -disable-O0-optnone \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

// CHECK-RV64-LABEL: @test_vsm_v_b1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv64i1.i64(<vscale x 64 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b1(uint8_t *base, vbool1_t value, size_t vl) {
  return vsm_v_b1(base, value, vl);
}

// CHECK-RV64-LABEL: @test_vsm_v_b2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv32i1.i64(<vscale x 32 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b2(uint8_t *base, vbool2_t value, size_t vl) {
  return vsm_v_b2(base, value, vl);
}

// CHECK-RV64-LABEL: @test_vsm_v_b4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv16i1.i64(<vscale x 16 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b4(uint8_t *base, vbool4_t value, size_t vl) {
  return vsm_v_b4(base, value, vl);
}

// CHECK-RV64-LABEL: @test_vsm_v_b8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv8i1.i64(<vscale x 8 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b8(uint8_t *base, vbool8_t value, size_t vl) {
  return vsm_v_b8(base, value, vl);
}

// CHECK-RV64-LABEL: @test_vsm_v_b16(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv4i1.i64(<vscale x 4 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b16(uint8_t *base, vbool16_t value, size_t vl) {
  return vsm_v_b16(base, value, vl);
}

// CHECK-RV64-LABEL: @test_vsm_v_b32(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv2i1.i64(<vscale x 2 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b32(uint8_t *base, vbool32_t value, size_t vl) {
  return vsm_v_b32(base, value, vl);
}

// CHECK-RV64-LABEL: @test_vsm_v_b64(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsm.nxv1i1.i64(<vscale x 1 x i1> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsm_v_b64(uint8_t *base, vbool64_t value, size_t vl) {
  return vsm_v_b64(base, value, vl);
}

