// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve -mfloat-abi hard -O0 -disable-O0-optnone -S -emit-llvm -o - %s | opt -S -mem2reg | FileCheck %s
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve -mfloat-abi hard -O0 -disable-O0-optnone -DPOLYMORPHIC -S -emit-llvm -o - %s | opt -S -mem2reg | FileCheck %s

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_mve.h>

// CHECK-LABEL: @test_vidupq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vidup.v16i8(i32 [[A:%.*]], i32 4)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP1]]
//
uint8x16_t test_vidupq_n_u8(uint32_t a)
{
#ifdef POLYMORPHIC
    return vidupq_u8(a, 4);
#else /* POLYMORPHIC */
    return vidupq_n_u8(a, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vidup.v8i16(i32 [[A:%.*]], i32 1)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP1]]
//
uint16x8_t test_vidupq_n_u16(uint32_t a)
{
#ifdef POLYMORPHIC
    return vidupq_u16(a, 1);
#else /* POLYMORPHIC */
    return vidupq_n_u16(a, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vidup.v4i32(i32 [[A:%.*]], i32 4)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP1]]
//
uint32x4_t test_vidupq_n_u32(uint32_t a)
{
#ifdef POLYMORPHIC
    return vidupq_u32(a, 4);
#else /* POLYMORPHIC */
    return vidupq_n_u32(a, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vddup.v16i8(i32 [[A:%.*]], i32 2)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP1]]
//
uint8x16_t test_vddupq_n_u8(uint32_t a)
{
#ifdef POLYMORPHIC
    return vddupq_u8(a, 2);
#else /* POLYMORPHIC */
    return vddupq_n_u8(a, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vddup.v8i16(i32 [[A:%.*]], i32 4)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP1]]
//
uint16x8_t test_vddupq_n_u16(uint32_t a)
{
#ifdef POLYMORPHIC
    return vddupq_u16(a, 4);
#else /* POLYMORPHIC */
    return vddupq_n_u16(a, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vddup.v4i32(i32 [[A:%.*]], i32 2)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP1]]
//
uint32x4_t test_vddupq_n_u32(uint32_t a)
{
#ifdef POLYMORPHIC
    return vddupq_u32(a, 2);
#else /* POLYMORPHIC */
    return vddupq_n_u32(a, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.viwdup.v16i8(i32 [[A:%.*]], i32 [[B:%.*]], i32 4)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP1]]
//
uint8x16_t test_viwdupq_n_u8(uint32_t a, uint32_t b)
{
#ifdef POLYMORPHIC
    return viwdupq_u8(a, b, 4);
#else /* POLYMORPHIC */
    return viwdupq_n_u8(a, b, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.viwdup.v8i16(i32 [[A:%.*]], i32 [[B:%.*]], i32 2)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP1]]
//
uint16x8_t test_viwdupq_n_u16(uint32_t a, uint32_t b)
{
#ifdef POLYMORPHIC
    return viwdupq_u16(a, b, 2);
#else /* POLYMORPHIC */
    return viwdupq_n_u16(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.viwdup.v4i32(i32 [[A:%.*]], i32 [[B:%.*]], i32 8)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP1]]
//
uint32x4_t test_viwdupq_n_u32(uint32_t a, uint32_t b)
{
#ifdef POLYMORPHIC
    return viwdupq_u32(a, b, 8);
#else /* POLYMORPHIC */
    return viwdupq_n_u32(a, b, 8);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vdwdup.v16i8(i32 [[A:%.*]], i32 [[B:%.*]], i32 4)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP1]]
//
uint8x16_t test_vdwdupq_n_u8(uint32_t a, uint32_t b)
{
#ifdef POLYMORPHIC
    return vdwdupq_u8(a, b, 4);
#else /* POLYMORPHIC */
    return vdwdupq_n_u8(a, b, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vdwdup.v8i16(i32 [[A:%.*]], i32 [[B:%.*]], i32 8)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP1]]
//
uint16x8_t test_vdwdupq_n_u16(uint32_t a, uint32_t b)
{
#ifdef POLYMORPHIC
    return vdwdupq_u16(a, b, 8);
#else /* POLYMORPHIC */
    return vdwdupq_n_u16(a, b, 8);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vdwdup.v4i32(i32 [[A:%.*]], i32 [[B:%.*]], i32 1)
// CHECK-NEXT:    [[TMP1:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP0]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP1]]
//
uint32x4_t test_vdwdupq_n_u32(uint32_t a, uint32_t b)
{
#ifdef POLYMORPHIC
    return vdwdupq_u32(a, b, 1);
#else /* POLYMORPHIC */
    return vdwdupq_n_u32(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vidup.v16i8(i32 [[TMP0]], i32 8)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vidupq_wb_u8(uint32_t *a)
{
#ifdef POLYMORPHIC
    return vidupq_u8(a, 8);
#else /* POLYMORPHIC */
    return vidupq_wb_u8(a, 8);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vidup.v8i16(i32 [[TMP0]], i32 1)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vidupq_wb_u16(uint32_t *a)
{
#ifdef POLYMORPHIC
    return vidupq_u16(a, 1);
#else /* POLYMORPHIC */
    return vidupq_wb_u16(a, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vidup.v4i32(i32 [[TMP0]], i32 4)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vidupq_wb_u32(uint32_t *a)
{
#ifdef POLYMORPHIC
    return vidupq_u32(a, 4);
#else /* POLYMORPHIC */
    return vidupq_wb_u32(a, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vddup.v16i8(i32 [[TMP0]], i32 2)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vddupq_wb_u8(uint32_t *a)
{
#ifdef POLYMORPHIC
    return vddupq_u8(a, 2);
#else /* POLYMORPHIC */
    return vddupq_wb_u8(a, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vddup.v8i16(i32 [[TMP0]], i32 8)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vddupq_wb_u16(uint32_t *a)
{
#ifdef POLYMORPHIC
    return vddupq_u16(a, 8);
#else /* POLYMORPHIC */
    return vddupq_wb_u16(a, 8);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vddup.v4i32(i32 [[TMP0]], i32 2)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vddupq_wb_u32(uint32_t *a)
{
#ifdef POLYMORPHIC
    return vddupq_u32(a, 2);
#else /* POLYMORPHIC */
    return vddupq_wb_u32(a, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vdwdup.v16i8(i32 [[TMP0]], i32 [[B:%.*]], i32 4)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vdwdupq_wb_u8(uint32_t *a, uint32_t b)
{
#ifdef POLYMORPHIC
    return vdwdupq_u8(a, b, 4);
#else /* POLYMORPHIC */
    return vdwdupq_wb_u8(a, b, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vdwdup.v8i16(i32 [[TMP0]], i32 [[B:%.*]], i32 4)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vdwdupq_wb_u16(uint32_t *a, uint32_t b)
{
#ifdef POLYMORPHIC
    return vdwdupq_u16(a, b, 4);
#else /* POLYMORPHIC */
    return vdwdupq_wb_u16(a, b, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.viwdup.v16i8(i32 [[TMP0]], i32 [[B:%.*]], i32 1)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_viwdupq_wb_u8(uint32_t *a, uint32_t b)
{
#ifdef POLYMORPHIC
    return viwdupq_u8(a, b, 1);
#else /* POLYMORPHIC */
    return viwdupq_wb_u8(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.viwdup.v8i16(i32 [[TMP0]], i32 [[B:%.*]], i32 1)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_viwdupq_wb_u16(uint32_t *a, uint32_t b)
{
#ifdef POLYMORPHIC
    return viwdupq_u16(a, b, 1);
#else /* POLYMORPHIC */
    return viwdupq_wb_u16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.viwdup.v4i32(i32 [[TMP0]], i32 [[B:%.*]], i32 8)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_viwdupq_wb_u32(uint32_t *a, uint32_t b)
{
#ifdef POLYMORPHIC
    return viwdupq_u32(a, b, 8);
#else /* POLYMORPHIC */
    return viwdupq_wb_u32(a, b, 8);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vdwdup.v4i32(i32 [[TMP0]], i32 [[B:%.*]], i32 2)
// CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 1
// CHECK-NEXT:    store i32 [[TMP2]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP1]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vdwdupq_wb_u32(uint32_t *a, uint32_t b)
{
#ifdef POLYMORPHIC
    return vdwdupq_u32(a, b, 2);
#else /* POLYMORPHIC */
    return vdwdupq_wb_u32(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vidup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 8, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vidupq_m_n_u8(uint8x16_t inactive, uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_m(inactive, a, 8, p);
#else /* POLYMORPHIC */
    return vidupq_m_n_u8(inactive, a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vidup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 8, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vidupq_m_n_u16(uint16x8_t inactive, uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_m(inactive, a, 8, p);
#else /* POLYMORPHIC */
    return vidupq_m_n_u16(inactive, a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vidup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 2, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vidupq_m_n_u32(uint32x4_t inactive, uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_m(inactive, a, 2, p);
#else /* POLYMORPHIC */
    return vidupq_m_n_u32(inactive, a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vddup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 8, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vddupq_m_n_u8(uint8x16_t inactive, uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_m(inactive, a, 8, p);
#else /* POLYMORPHIC */
    return vddupq_m_n_u8(inactive, a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vddup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 2, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vddupq_m_n_u16(uint16x8_t inactive, uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_m(inactive, a, 2, p);
#else /* POLYMORPHIC */
    return vddupq_m_n_u16(inactive, a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vddup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 8, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vddupq_m_n_u32(uint32x4_t inactive, uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_m(inactive, a, 8, p);
#else /* POLYMORPHIC */
    return vddupq_m_n_u32(inactive, a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.viwdup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 [[B:%.*]], i32 8, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_viwdupq_m_n_u8(uint8x16_t inactive, uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_m(inactive, a, b, 8, p);
#else /* POLYMORPHIC */
    return viwdupq_m_n_u8(inactive, a, b, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.viwdup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 [[B:%.*]], i32 8, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_viwdupq_m_n_u16(uint16x8_t inactive, uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_m(inactive, a, b, 8, p);
#else /* POLYMORPHIC */
    return viwdupq_m_n_u16(inactive, a, b, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.viwdup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 [[B:%.*]], i32 4, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_viwdupq_m_n_u32(uint32x4_t inactive, uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_m(inactive, a, b, 4, p);
#else /* POLYMORPHIC */
    return viwdupq_m_n_u32(inactive, a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vdwdup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 [[B:%.*]], i32 1, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vdwdupq_m_n_u8(uint8x16_t inactive, uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_m(inactive, a, b, 1, p);
#else /* POLYMORPHIC */
    return vdwdupq_m_n_u8(inactive, a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vdwdup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 [[B:%.*]], i32 2, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vdwdupq_m_n_u16(uint16x8_t inactive, uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_m(inactive, a, b, 2, p);
#else /* POLYMORPHIC */
    return vdwdupq_m_n_u16(inactive, a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vdwdup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[A:%.*]], i32 [[B:%.*]], i32 4, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vdwdupq_m_n_u32(uint32x4_t inactive, uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_m(inactive, a, b, 4, p);
#else /* POLYMORPHIC */
    return vdwdupq_m_n_u32(inactive, a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_m_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vidup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[TMP0]], i32 8, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_vidupq_m_wb_u8(uint8x16_t inactive, uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_m(inactive, a, 8, p);
#else /* POLYMORPHIC */
    return vidupq_m_wb_u8(inactive, a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_m_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vidup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[TMP0]], i32 2, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_vidupq_m_wb_u16(uint16x8_t inactive, uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_m(inactive, a, 2, p);
#else /* POLYMORPHIC */
    return vidupq_m_wb_u16(inactive, a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_m_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vidup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[TMP0]], i32 8, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_vidupq_m_wb_u32(uint32x4_t inactive, uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_m(inactive, a, 8, p);
#else /* POLYMORPHIC */
    return vidupq_m_wb_u32(inactive, a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_m_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vddup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[TMP0]], i32 1, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_vddupq_m_wb_u8(uint8x16_t inactive, uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_m(inactive, a, 1, p);
#else /* POLYMORPHIC */
    return vddupq_m_wb_u8(inactive, a, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_m_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vddup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[TMP0]], i32 1, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_vddupq_m_wb_u16(uint16x8_t inactive, uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_m(inactive, a, 1, p);
#else /* POLYMORPHIC */
    return vddupq_m_wb_u16(inactive, a, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_m_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vddup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[TMP0]], i32 4, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_vddupq_m_wb_u32(uint32x4_t inactive, uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_m(inactive, a, 4, p);
#else /* POLYMORPHIC */
    return vddupq_m_wb_u32(inactive, a, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_m_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.viwdup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[TMP0]], i32 [[B:%.*]], i32 8, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_viwdupq_m_wb_u8(uint8x16_t inactive, uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_m(inactive, a, b, 8, p);
#else /* POLYMORPHIC */
    return viwdupq_m_wb_u8(inactive, a, b, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_m_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.viwdup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[TMP0]], i32 [[B:%.*]], i32 8, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_viwdupq_m_wb_u16(uint16x8_t inactive, uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_m(inactive, a, b, 8, p);
#else /* POLYMORPHIC */
    return viwdupq_m_wb_u16(inactive, a, b, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_m_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.viwdup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[TMP0]], i32 [[B:%.*]], i32 4, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_viwdupq_m_wb_u32(uint32x4_t inactive, uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_m(inactive, a, b, 4, p);
#else /* POLYMORPHIC */
    return viwdupq_m_wb_u32(inactive, a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_m_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vdwdup.predicated.v16i8.v16i1(<16 x i8> [[INACTIVE:%.*]], i32 [[TMP0]], i32 [[B:%.*]], i32 1, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_vdwdupq_m_wb_u8(uint8x16_t inactive, uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_m(inactive, a, b, 1, p);
#else /* POLYMORPHIC */
    return vdwdupq_m_wb_u8(inactive, a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_m_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vdwdup.predicated.v8i16.v8i1(<8 x i16> [[INACTIVE:%.*]], i32 [[TMP0]], i32 [[B:%.*]], i32 4, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_vdwdupq_m_wb_u16(uint16x8_t inactive, uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_m(inactive, a, b, 4, p);
#else /* POLYMORPHIC */
    return vdwdupq_m_wb_u16(inactive, a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_m_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vdwdup.predicated.v4i32.v4i1(<4 x i32> [[INACTIVE:%.*]], i32 [[TMP0]], i32 [[B:%.*]], i32 4, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_vdwdupq_m_wb_u32(uint32x4_t inactive, uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_m(inactive, a, b, 4, p);
#else /* POLYMORPHIC */
    return vdwdupq_m_wb_u32(inactive, a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_x_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vidup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[A:%.*]], i32 2, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vidupq_x_n_u8(uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_x_u8(a, 2, p);
#else /* POLYMORPHIC */
    return vidupq_x_n_u8(a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_x_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vidup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[A:%.*]], i32 2, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vidupq_x_n_u16(uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_x_u16(a, 2, p);
#else /* POLYMORPHIC */
    return vidupq_x_n_u16(a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_x_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vidup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[A:%.*]], i32 8, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vidupq_x_n_u32(uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_x_u32(a, 8, p);
#else /* POLYMORPHIC */
    return vidupq_x_n_u32(a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_x_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vddup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[A:%.*]], i32 8, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vddupq_x_n_u8(uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_x_u8(a, 8, p);
#else /* POLYMORPHIC */
    return vddupq_x_n_u8(a, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_x_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vddup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[A:%.*]], i32 4, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vddupq_x_n_u16(uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_x_u16(a, 4, p);
#else /* POLYMORPHIC */
    return vddupq_x_n_u16(a, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_x_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vddup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[A:%.*]], i32 2, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vddupq_x_n_u32(uint32_t a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_x_u32(a, 2, p);
#else /* POLYMORPHIC */
    return vddupq_x_n_u32(a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_x_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.viwdup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[A:%.*]], i32 [[B:%.*]], i32 2, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_viwdupq_x_n_u8(uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_x_u8(a, b, 2, p);
#else /* POLYMORPHIC */
    return viwdupq_x_n_u8(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_x_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.viwdup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[A:%.*]], i32 [[B:%.*]], i32 4, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_viwdupq_x_n_u16(uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_x_u16(a, b, 4, p);
#else /* POLYMORPHIC */
    return viwdupq_x_n_u16(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_x_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.viwdup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[A:%.*]], i32 [[B:%.*]], i32 2, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_viwdupq_x_n_u32(uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_x_u32(a, b, 2, p);
#else /* POLYMORPHIC */
    return viwdupq_x_n_u32(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_x_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vdwdup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[A:%.*]], i32 [[B:%.*]], i32 2, <16 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP3]]
//
uint8x16_t test_vdwdupq_x_n_u8(uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_x_u8(a, b, 2, p);
#else /* POLYMORPHIC */
    return vdwdupq_x_n_u8(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_x_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vdwdup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[A:%.*]], i32 [[B:%.*]], i32 2, <8 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP3]]
//
uint16x8_t test_vdwdupq_x_n_u16(uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_x_u16(a, b, 2, p);
#else /* POLYMORPHIC */
    return vdwdupq_x_n_u16(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_x_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vdwdup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[A:%.*]], i32 [[B:%.*]], i32 8, <4 x i1> [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP2]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP3]]
//
uint32x4_t test_vdwdupq_x_n_u32(uint32_t a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_x_u32(a, b, 8, p);
#else /* POLYMORPHIC */
    return vdwdupq_x_n_u32(a, b, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_x_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vidup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[TMP0]], i32 2, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_vidupq_x_wb_u8(uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_x_u8(a, 2, p);
#else /* POLYMORPHIC */
    return vidupq_x_wb_u8(a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_x_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vidup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[TMP0]], i32 4, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_vidupq_x_wb_u16(uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_x_u16(a, 4, p);
#else /* POLYMORPHIC */
    return vidupq_x_wb_u16(a, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vidupq_x_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vidup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[TMP0]], i32 2, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_vidupq_x_wb_u32(uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vidupq_x_u32(a, 2, p);
#else /* POLYMORPHIC */
    return vidupq_x_wb_u32(a, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_x_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vddup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[TMP0]], i32 1, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_vddupq_x_wb_u8(uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_x_u8(a, 1, p);
#else /* POLYMORPHIC */
    return vddupq_x_wb_u8(a, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_x_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vddup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[TMP0]], i32 4, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_vddupq_x_wb_u16(uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_x_u16(a, 4, p);
#else /* POLYMORPHIC */
    return vddupq_x_wb_u16(a, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vddupq_x_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vddup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[TMP0]], i32 4, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_vddupq_x_wb_u32(uint32_t *a, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vddupq_x_u32(a, 4, p);
#else /* POLYMORPHIC */
    return vddupq_x_wb_u32(a, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_x_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.viwdup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[TMP0]], i32 [[B:%.*]], i32 1, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_viwdupq_x_wb_u8(uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_x_u8(a, b, 1, p);
#else /* POLYMORPHIC */
    return viwdupq_x_wb_u8(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_x_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.viwdup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[TMP0]], i32 [[B:%.*]], i32 2, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_viwdupq_x_wb_u16(uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_x_u16(a, b, 2, p);
#else /* POLYMORPHIC */
    return viwdupq_x_wb_u16(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_viwdupq_x_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.viwdup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[TMP0]], i32 [[B:%.*]], i32 1, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_viwdupq_x_wb_u32(uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return viwdupq_x_u32(a, b, 1, p);
#else /* POLYMORPHIC */
    return viwdupq_x_wb_u32(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_x_wb_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <16 x i8>, i32 } @llvm.arm.mve.vdwdup.predicated.v16i8.v16i1(<16 x i8> undef, i32 [[TMP0]], i32 [[B:%.*]], i32 4, <16 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <16 x i8>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <16 x i8> [[TMP5]]
//
uint8x16_t test_vdwdupq_x_wb_u8(uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_x_u8(a, b, 4, p);
#else /* POLYMORPHIC */
    return vdwdupq_x_wb_u8(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_x_wb_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <8 x i16>, i32 } @llvm.arm.mve.vdwdup.predicated.v8i16.v8i1(<8 x i16> undef, i32 [[TMP0]], i32 [[B:%.*]], i32 4, <8 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <8 x i16>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <8 x i16> [[TMP5]]
//
uint16x8_t test_vdwdupq_x_wb_u16(uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_x_u16(a, b, 4, p);
#else /* POLYMORPHIC */
    return vdwdupq_x_wb_u16(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vdwdupq_x_wb_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A:%.*]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP1]])
// CHECK-NEXT:    [[TMP3:%.*]] = call { <4 x i32>, i32 } @llvm.arm.mve.vdwdup.predicated.v4i32.v4i1(<4 x i32> undef, i32 [[TMP0]], i32 [[B:%.*]], i32 4, <4 x i1> [[TMP2]])
// CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 1
// CHECK-NEXT:    store i32 [[TMP4]], i32* [[A]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = extractvalue { <4 x i32>, i32 } [[TMP3]], 0
// CHECK-NEXT:    ret <4 x i32> [[TMP5]]
//
uint32x4_t test_vdwdupq_x_wb_u32(uint32_t *a, uint32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vdwdupq_x_u32(a, b, 4, p);
#else /* POLYMORPHIC */
    return vdwdupq_x_wb_u32(a, b, 4, p);
#endif /* POLYMORPHIC */
}
