//===-------------------------- test_demangle.cpp -------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// The demangler does not pass all these tests with the system dylibs on macOS.
// XFAIL: use_system_cxx_lib && target={{.+}}-apple-macosx10.{{9|10|11|12|13|14|15}}

#include "support/timer.h"
#include <cassert>
#include <cstdio>
#include <cstdlib>
#include <cxxabi.h>
#include <string>

// Is long double fp80?  (Only x87 extended double has 64-bit mantissa)
#define LDBL_FP80 (__LDBL_MANT_DIG__ == 64)
// Is long double fp128?
#define LDBL_FP128 (__LDBL_MANT_DIG__ == 113)

const char* cases[][2] =
{
    {"_Z1A", "A"},
    {"_Z1Av", "A()"},
    {"_Z1A1B1C", "A(B, C)"},
    {"_Z4testI1A1BE1Cv", "C test<A, B>()"},
    {"_Z4testI1A1BET0_T_S3_", "B test<A, B>(A, A)"},
    {"_ZN1SgtEi", "S::operator>(int)"},
    {"_ZrsI1QEiT_i", "int operator>><Q>(Q, int)"},
    {"_ZN13dyldbootstrap5startEPK12macho_headeriPPKcl", "dyldbootstrap::start(macho_header const*, int, char const**, long)"},
    {"_ZN4dyld17getExecutablePathEv", "dyld::getExecutablePath()"},
    {"_ZN4dyld22mainExecutablePreboundEv", "dyld::mainExecutablePrebound()"},
    {"_ZN4dyld14mainExecutableEv", "dyld::mainExecutable()"},
    {"_ZN4dyld21findImageByMachHeaderEPK11mach_header", "dyld::findImageByMachHeader(mach_header const*)"},
    {"_ZN4dyld26findImageContainingAddressEPKv", "dyld::findImageContainingAddress(void const*)"},
    {"_ZN4dyld17clearErrorMessageEv", "dyld::clearErrorMessage()"},
    {"_ZN4dyld15getErrorMessageEv", "dyld::getErrorMessage()"},
    {"_ZN4dyld24registerUndefinedHandlerEPFvPKcE", "dyld::registerUndefinedHandler(void (*)(char const*))"},
    {"_ZN4dyld19openSharedCacheFileEv", "dyld::openSharedCacheFile()"},
    {"_ZN4dyld15setErrorMessageEPKc", "dyld::setErrorMessage(char const*)"},
    {"_ZN4dyld22registerRemoveCallbackEPFvPK11mach_headerlE", "dyld::registerRemoveCallback(void (*)(mach_header const*, long))"},
    {"_ZN4dyld13inSharedCacheEPKc", "dyld::inSharedCache(char const*)"},
    {"_ZN4dyld15runInitializersEP11ImageLoader", "dyld::runInitializers(ImageLoader*)"},
    {"_ZN4dyld27findCoalescedExportedSymbolEPKcPPKN11ImageLoader6SymbolEPPKS2_", "dyld::findCoalescedExportedSymbol(char const*, ImageLoader::Symbol const**, ImageLoader const**)"},
    {"_ZN4dyld22flatFindExportedSymbolEPKcPPKN11ImageLoader6SymbolEPPKS2_", "dyld::flatFindExportedSymbol(char const*, ImageLoader::Symbol const**, ImageLoader const**)"},
    {"_ZN4dyld15findLoadedImageERK4stat", "dyld::findLoadedImage(stat const&)"},
    {"_ZN4dyld24initializeMainExecutableEv", "dyld::initializeMainExecutable()"},
    {"_ZN4dyld4warnEPKcz", "dyld::warn(char const*, ...)"},
    {"_ZN4dyld29processDyldEnvironmentVaribleEPKcS1_", "dyld::processDyldEnvironmentVarible(char const*, char const*)"},
    {"_ZN4dyld3logEPKcz", "dyld::log(char const*, ...)"},
    {"_ZN4dyld6throwfEPKcz", "dyld::throwf(char const*, ...)"},
    {"_ZN4dyld9mkstringfEPKcz", "dyld::mkstringf(char const*, ...)"},
    {"_ZN4dyld14addMappedRangeEP11ImageLoadermm", "dyld::addMappedRange(ImageLoader*, unsigned long, unsigned long)"},
    {"_Z28coresymbolication_load_imageP25CSCppDyldSharedMemoryPagePK11ImageLoadery", "coresymbolication_load_image(CSCppDyldSharedMemoryPage*, ImageLoader const*, unsigned long long)"},
    {"_Z30coresymbolication_unload_imageP25CSCppDyldSharedMemoryPagePK11ImageLoader", "coresymbolication_unload_image(CSCppDyldSharedMemoryPage*, ImageLoader const*)"},
    {"_ZN4dyld18getCoalescedImagesEPP11ImageLoader", "dyld::getCoalescedImages(ImageLoader**)"},
    {"_ZN4dyld25findImageContainingSymbolEPKv", "dyld::findImageContainingSymbol(void const*)"},
    {"_ZN4dyld19registerAddCallbackEPFvPK11mach_headerlE", "dyld::registerAddCallback(void (*)(mach_header const*, long))"},
    {"_ZN4dyld14forEachImageDoEPFvP11ImageLoaderPvES2_", "dyld::forEachImageDo(void (*)(ImageLoader*, void*), void*)"},
    {"_ZN4dyld15getIndexedImageEj", "dyld::getIndexedImage(unsigned int)"},
    {"_ZN4dyld13getImageCountEv", "dyld::getImageCount()"},
    {"_ZN4dyld10validImageEPK11ImageLoader", "dyld::validImage(ImageLoader const*)"},
    {"_ZN4dyld30flatFindExportedSymbolWithHintEPKcS1_PPKN11ImageLoader6SymbolEPPKS2_", "dyld::flatFindExportedSymbolWithHint(char const*, char const*, ImageLoader::Symbol const**, ImageLoader const**)"},
    {"_ZN4dyld14loadFromMemoryEPKhyPKc", "dyld::loadFromMemory(unsigned char const*, unsigned long long, char const*)"},
    {"_ZN4dyld36registerImageStateBatchChangeHandlerE17dyld_image_statesPFPKcS0_jPK15dyld_image_infoE", "dyld::registerImageStateBatchChangeHandler(dyld_image_states, char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*))"},
    {"_ZN4dyld37registerImageStateSingleChangeHandlerE17dyld_image_statesPFPKcS0_jPK15dyld_image_infoE", "dyld::registerImageStateSingleChangeHandler(dyld_image_states, char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*))"},
    {"_ZN4dyld4haltEPKc", "dyld::halt(char const*)"},
    {"_ZN4dyld18fastBindLazySymbolEPP11ImageLoaderm", "dyld::fastBindLazySymbol(ImageLoader**, unsigned long)"},
    {"_ZN4dyld14bindLazySymbolEPK11mach_headerPm", "dyld::bindLazySymbol(mach_header const*, unsigned long*)"},
    {"_ZN4dyld14runTerminatorsEPv", "dyld::runTerminators(void*)"},
    {"_ZN4dyld11removeImageEP11ImageLoader", "dyld::removeImage(ImageLoader*)"},
    {"_ZN4dyld20garbageCollectImagesEv", "dyld::garbageCollectImages()"},
    {"_ZN4dyld9preflightEP11ImageLoaderRKNS0_10RPathChainE", "dyld::preflight(ImageLoader*, ImageLoader::RPathChain const&)"},
    {"_ZN4dyld4linkEP11ImageLoaderbRKNS0_10RPathChainE", "dyld::link(ImageLoader*, bool, ImageLoader::RPathChain const&)"},
    {"_ZN4dyld10cloneImageEP11ImageLoader", "dyld::cloneImage(ImageLoader*)"},
    {"_ZN4dyld4loadEPKcRKNS_11LoadContextE", "dyld::load(char const*, dyld::LoadContext const&)"},
    {"_ZN4dyld5_mainEPK12macho_headermiPPKcS5_S5_", "dyld::_main(macho_header const*, unsigned long, int, char const**, char const**, char const**)"},
    {"_ZNSt6vectorIN4dyld13RegisteredDOFESaIS1_EE5eraseEN9__gnu_cxx17__normal_iteratorIPS1_S3_EE", "std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::erase(__gnu_cxx::__normal_iterator<dyld::RegisteredDOF*, std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> > >)"},
    {"_ZNSt12_Vector_baseIPKcSaIS1_EED2Ev", "std::_Vector_base<char const*, std::allocator<char const*> >::~_Vector_base()"},
    {"_ZNSt6vectorIPKcSaIS1_EED2Ev", "std::vector<char const*, std::allocator<char const*> >::~vector()"},
    {"_ZNSt12_Vector_baseIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EED2Ev", "std::_Vector_base<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::~_Vector_base()"},
    {"_ZNSt6vectorIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EED2Ev", "std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::~vector()"},
    {"_ZNSt12_Vector_baseIPFvPK11mach_headerlESaIS4_EED2Ev", "std::_Vector_base<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::~_Vector_base()"},
    {"_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EED2Ev", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::~vector()"},
    {"_ZNSt12_Vector_baseIN4dyld13RegisteredDOFESaIS1_EED2Ev", "std::_Vector_base<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::~_Vector_base()"},
    {"_ZNSt6vectorIN4dyld13RegisteredDOFESaIS1_EED2Ev", "std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::~vector()"},
    {"_ZNSt12_Vector_baseIP11ImageLoaderSaIS1_EED2Ev", "std::_Vector_base<ImageLoader*, std::allocator<ImageLoader*> >::~_Vector_base()"},
    {"_ZNSt6vectorIP11ImageLoaderSaIS1_EED2Ev", "std::vector<ImageLoader*, std::allocator<ImageLoader*> >::~vector()"},
    {"_ZN9__gnu_cxx13new_allocatorIPFPKc17dyld_image_statesjPK15dyld_image_infoEE8allocateEmPKv", "__gnu_cxx::new_allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)>::allocate(unsigned long, void const*)"},
    {"_ZN9__gnu_cxx13new_allocatorIPFvPK11mach_headerlEE8allocateEmPKv", "__gnu_cxx::new_allocator<void (*)(mach_header const*, long)>::allocate(unsigned long, void const*)"},
    {"_ZN9__gnu_cxx13new_allocatorIPKcE8allocateEmPKv", "__gnu_cxx::new_allocator<char const*>::allocate(unsigned long, void const*)"},
    {"_ZN9__gnu_cxx13new_allocatorIP11ImageLoaderE8allocateEmPKv", "__gnu_cxx::new_allocator<ImageLoader*>::allocate(unsigned long, void const*)"},
    {"_ZN9__gnu_cxx13new_allocatorIN4dyld13RegisteredDOFEE8allocateEmPKv", "__gnu_cxx::new_allocator<dyld::RegisteredDOF>::allocate(unsigned long, void const*)"},
    {"_ZNSt6vectorIN4dyld13RegisteredDOFESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::_M_insert_aux(__gnu_cxx::__normal_iterator<dyld::RegisteredDOF*, std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> > >, dyld::RegisteredDOF const&)"},
    {"_ZNSt6vectorIN4dyld13RegisteredDOFESaIS1_EE9push_backERKS1_", "std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::push_back(dyld::RegisteredDOF const&)"},
    {"_ZSt18uninitialized_copyIPPFPKc17dyld_image_statesjPK15dyld_image_infoES8_ET0_T_SA_S9_", "char const* (**std::uninitialized_copy<char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*)>(char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*)))(dyld_image_states, unsigned int, dyld_image_info const*)"},
    {"_ZSt18uninitialized_copyIPPFvPK11mach_headerlES5_ET0_T_S7_S6_", "void (**std::uninitialized_copy<void (**)(mach_header const*, long), void (**)(mach_header const*, long)>(void (**)(mach_header const*, long), void (**)(mach_header const*, long), void (**)(mach_header const*, long)))(mach_header const*, long)"},
    {"_ZSt18uninitialized_copyIPPKcS2_ET0_T_S4_S3_", "char const** std::uninitialized_copy<char const**, char const**>(char const**, char const**, char const**)"},
    {"_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIPFPKc17dyld_image_statesjPK15dyld_image_infoEEEPT_PKSB_SE_SC_", "char const* (**std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)>(char const* (* const*)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (* const*)(dyld_image_states, unsigned int, dyld_image_info const*), char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*)))(dyld_image_states, unsigned int, dyld_image_info const*)"},
    {"_ZNSt6vectorIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS7_S9_EERKS7_", "std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::_M_insert_aux(__gnu_cxx::__normal_iterator<char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> > >, char const* (* const&)(dyld_image_states, unsigned int, dyld_image_info const*))"},
    {"_ZNSt6vectorIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EE6insertEN9__gnu_cxx17__normal_iteratorIPS7_S9_EERKS7_", "std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::insert(__gnu_cxx::__normal_iterator<char const* (**)(dyld_image_states, unsigned int, dyld_image_info const*), std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> > >, char const* (* const&)(dyld_image_states, unsigned int, dyld_image_info const*))"},
    {"_ZNSt6vectorIPFPKc17dyld_image_statesjPK15dyld_image_infoESaIS7_EE9push_backERKS7_", "std::vector<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*), std::allocator<char const* (*)(dyld_image_states, unsigned int, dyld_image_info const*)> >::push_back(char const* (* const&)(dyld_image_states, unsigned int, dyld_image_info const*))"},
    {"_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIPFvPK11mach_headerlEEEPT_PKS8_SB_S9_", "void (**std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<void (*)(mach_header const*, long)>(void (* const*)(mach_header const*, long), void (* const*)(mach_header const*, long), void (**)(mach_header const*, long)))(mach_header const*, long)"},
    {"_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS4_S6_EERKS4_", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::_M_insert_aux(__gnu_cxx::__normal_iterator<void (**)(mach_header const*, long), std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> > >, void (* const&)(mach_header const*, long))"},
    {"_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE9push_backERKS4_", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::push_back(void (* const&)(mach_header const*, long))"},
    {"_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIPKcEEPT_PKS5_S8_S6_", "char const** std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<char const*>(char const* const*, char const* const*, char const**)"},
    {"_ZNSt6vectorIPKcSaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<char const*, std::allocator<char const*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<char const**, std::vector<char const*, std::allocator<char const*> > >, char const* const&)"},
    {"_ZNSt6vectorIPKcSaIS1_EE9push_backERKS1_", "std::vector<char const*, std::allocator<char const*> >::push_back(char const* const&)"},
    {"_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIP11ImageLoaderEEPT_PKS5_S8_S6_", "ImageLoader** std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<ImageLoader*>(ImageLoader* const*, ImageLoader* const*, ImageLoader**)"},
    {"_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE20_M_allocate_and_copyIPS4_EES8_mT_S9_", "void (**std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::_M_allocate_and_copy<void (**)(mach_header const*, long)>(unsigned long, void (**)(mach_header const*, long), void (**)(mach_header const*, long)))(mach_header const*, long)"},
    {"_ZNSt6vectorIPFvPK11mach_headerlESaIS4_EE7reserveEm", "std::vector<void (*)(mach_header const*, long), std::allocator<void (*)(mach_header const*, long)> >::reserve(unsigned long)"},
    {"_ZNSt6vectorIN4dyld13RegisteredDOFESaIS1_EE20_M_allocate_and_copyIPS1_EES5_mT_S6_", "dyld::RegisteredDOF* std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::_M_allocate_and_copy<dyld::RegisteredDOF*>(unsigned long, dyld::RegisteredDOF*, dyld::RegisteredDOF*)"},
    {"_ZNSt6vectorIN4dyld13RegisteredDOFESaIS1_EE7reserveEm", "std::vector<dyld::RegisteredDOF, std::allocator<dyld::RegisteredDOF> >::reserve(unsigned long)"},
    {"_ZSt18uninitialized_copyIPP11ImageLoaderS2_ET0_T_S4_S3_", "ImageLoader** std::uninitialized_copy<ImageLoader**, ImageLoader**>(ImageLoader**, ImageLoader**, ImageLoader**)"},
    {"_ZNSt6vectorIP11ImageLoaderSaIS1_EE20_M_allocate_and_copyIPS1_EES5_mT_S6_", "ImageLoader** std::vector<ImageLoader*, std::allocator<ImageLoader*> >::_M_allocate_and_copy<ImageLoader**>(unsigned long, ImageLoader**, ImageLoader**)"},
    {"_ZNSt6vectorIP11ImageLoaderSaIS1_EE7reserveEm", "std::vector<ImageLoader*, std::allocator<ImageLoader*> >::reserve(unsigned long)"},
    {"_ZNSt6vectorIP11ImageLoaderSaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<ImageLoader*, std::allocator<ImageLoader*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<ImageLoader**, std::vector<ImageLoader*, std::allocator<ImageLoader*> > >, ImageLoader* const&)"},
    {"_ZNSt6vectorIP11ImageLoaderSaIS1_EE9push_backERKS1_", "std::vector<ImageLoader*, std::allocator<ImageLoader*> >::push_back(ImageLoader* const&)"},
    {"_ZNSt6vectorIP11ImageLoaderSaIS1_EE5eraseEN9__gnu_cxx17__normal_iteratorIPS1_S3_EE", "std::vector<ImageLoader*, std::allocator<ImageLoader*> >::erase(__gnu_cxx::__normal_iterator<ImageLoader**, std::vector<ImageLoader*, std::allocator<ImageLoader*> > >)"},
    {"_Z18lookupDyldFunctionPKcPm", "lookupDyldFunction(char const*, unsigned long*)"},
    {"_ZNSt12_Vector_baseIP19__NSObjectFileImageSaIS1_EED2Ev", "std::_Vector_base<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> >::~_Vector_base()"},
    {"_ZNSt6vectorIP19__NSObjectFileImageSaIS1_EED2Ev", "std::vector<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> >::~vector()"},
    {"_ZNSt15__copy_backwardILb1ESt26random_access_iterator_tagE8__copy_bIP19__NSObjectFileImageEEPT_PKS5_S8_S6_", "__NSObjectFileImage** std::__copy_backward<true, std::random_access_iterator_tag>::__copy_b<__NSObjectFileImage*>(__NSObjectFileImage* const*, __NSObjectFileImage* const*, __NSObjectFileImage**)"},
    {"_ZN9__gnu_cxx13new_allocatorIP19__NSObjectFileImageE8allocateEmPKv", "__gnu_cxx::new_allocator<__NSObjectFileImage*>::allocate(unsigned long, void const*)"},
    {"_ZNSt6vectorIP19__NSObjectFileImageSaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<__NSObjectFileImage**, std::vector<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> > >, __NSObjectFileImage* const&)"},
    {"_ZNSt6vectorIP19__NSObjectFileImageSaIS1_EE9push_backERKS1_", "std::vector<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> >::push_back(__NSObjectFileImage* const&)"},
    {"_ZNSt6vectorIP19__NSObjectFileImageSaIS1_EE5eraseEN9__gnu_cxx17__normal_iteratorIPS1_S3_EE", "std::vector<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> >::erase(__gnu_cxx::__normal_iterator<__NSObjectFileImage**, std::vector<__NSObjectFileImage*, std::allocator<__NSObjectFileImage*> > >)"},
    {"_Z19setAlImageInfosHaltPKcm", "setAlImageInfosHalt(char const*, unsigned long)"},
    {"_Z24removeImageFromAllImagesPK11mach_header", "removeImageFromAllImages(mach_header const*)"},
    {"_Z20addImagesToAllImagesjPK15dyld_image_info", "addImagesToAllImages(unsigned int, dyld_image_info const*)"},
    {"_ZNSt6vectorI15dyld_image_infoSaIS0_EE5eraseEN9__gnu_cxx17__normal_iteratorIPS0_S2_EE", "std::vector<dyld_image_info, std::allocator<dyld_image_info> >::erase(__gnu_cxx::__normal_iterator<dyld_image_info*, std::vector<dyld_image_info, std::allocator<dyld_image_info> > >)"},
    {"_ZNSt12_Vector_baseI15dyld_image_infoSaIS0_EED2Ev", "std::_Vector_base<dyld_image_info, std::allocator<dyld_image_info> >::~_Vector_base()"},
    {"_ZNSt6vectorI15dyld_image_infoSaIS0_EED2Ev", "std::vector<dyld_image_info, std::allocator<dyld_image_info> >::~vector()"},
    {"_ZN9__gnu_cxx13new_allocatorI15dyld_image_infoE8allocateEmPKv", "__gnu_cxx::new_allocator<dyld_image_info>::allocate(unsigned long, void const*)"},
    {"_ZNSt6vectorI15dyld_image_infoSaIS0_EE20_M_allocate_and_copyIPS0_EES4_mT_S5_", "dyld_image_info* std::vector<dyld_image_info, std::allocator<dyld_image_info> >::_M_allocate_and_copy<dyld_image_info*>(unsigned long, dyld_image_info*, dyld_image_info*)"},
    {"_ZNSt6vectorI15dyld_image_infoSaIS0_EE7reserveEm", "std::vector<dyld_image_info, std::allocator<dyld_image_info> >::reserve(unsigned long)"},
    {"_ZNSt6vectorI15dyld_image_infoSaIS0_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS0_S2_EERKS0_", "std::vector<dyld_image_info, std::allocator<dyld_image_info> >::_M_insert_aux(__gnu_cxx::__normal_iterator<dyld_image_info*, std::vector<dyld_image_info, std::allocator<dyld_image_info> > >, dyld_image_info const&)"},
    {"_ZNSt6vectorI15dyld_image_infoSaIS0_EE9push_backERKS0_", "std::vector<dyld_image_info, std::allocator<dyld_image_info> >::push_back(dyld_image_info const&)"},
    {"_ZN10__cxxabiv112__unexpectedEPFvvE", "__cxxabiv1::__unexpected(void (*)())"},
    {"_ZN10__cxxabiv111__terminateEPFvvE", "__cxxabiv1::__terminate(void (*)())"},
    {"_ZSt10unexpectedv", "std::unexpected()"},
    {"_ZSt9terminatev", "std::terminate()"},
    {"_ZN11ImageLoaderC2EPKcj", "ImageLoader::ImageLoader(char const*, unsigned int)"},
    {"_ZN11ImageLoader11deleteImageEPS_", "ImageLoader::deleteImage(ImageLoader*)"},
    {"_ZN11ImageLoader11setFileInfoEiyl", "ImageLoader::setFileInfo(int, unsigned long long, long)"},
    {"_ZN11ImageLoader9setMappedERKNS_11LinkContextE", "ImageLoader::setMapped(ImageLoader::LinkContext const&)"},
    {"_ZNK11ImageLoader7compareEPKS_", "ImageLoader::compare(ImageLoader const*) const"},
    {"_ZN11ImageLoader4hashEPKc", "ImageLoader::hash(char const*)"},
    {"_ZNK11ImageLoader16matchInstallPathEv", "ImageLoader::matchInstallPath() const"},
    {"_ZN11ImageLoader19setMatchInstallPathEb", "ImageLoader::setMatchInstallPath(bool)"},
    {"_ZNK11ImageLoader9statMatchERK4stat", "ImageLoader::statMatch(stat const&) const"},
    {"_ZN11ImageLoader14setLeaveMappedEv", "ImageLoader::setLeaveMapped()"},
    {"_ZN11ImageLoader14setHideExportsEb", "ImageLoader::setHideExports(bool)"},
    {"_ZNK11ImageLoader16hasHiddenExportsEv", "ImageLoader::hasHiddenExports() const"},
    {"_ZNK11ImageLoader8isLinkedEv", "ImageLoader::isLinked() const"},
    {"_ZNK11ImageLoader12lastModifiedEv", "ImageLoader::lastModified() const"},
    {"_ZNK11ImageLoader24overlapsWithAddressRangeEPKvS1_", "ImageLoader::overlapsWithAddressRange(void const*, void const*) const"},
    {"_ZNK11ImageLoader16getMappedRegionsERPNS_12MappedRegionE", "ImageLoader::getMappedRegions(ImageLoader::MappedRegion*&) const"},
    {"_ZNK11ImageLoader41findExportedSymbolInDependentImagesExceptEPKcPPKS_RS4_S4_S4_", "ImageLoader::findExportedSymbolInDependentImagesExcept(char const*, ImageLoader const**, ImageLoader const**&, ImageLoader const**, ImageLoader const**) const"},
    {"_ZN11ImageLoader29decrementDlopenReferenceCountEv", "ImageLoader::decrementDlopenReferenceCount()"},
    {"_ZN11ImageLoader19bindAllLazyPointersERKNS_11LinkContextEb", "ImageLoader::bindAllLazyPointers(ImageLoader::LinkContext const&, bool)"},
    {"_ZNK11ImageLoader35allDependentLibrariesAsWhenPreBoundEv", "ImageLoader::allDependentLibrariesAsWhenPreBound() const"},
    {"_ZN11ImageLoader20recursiveUpdateDepthEj", "ImageLoader::recursiveUpdateDepth(unsigned int)"},
    {"_ZN11ImageLoader23recursiveGetDOFSectionsERKNS_11LinkContextERSt6vectorINS_7DOFInfoESaIS4_EE", "ImageLoader::recursiveGetDOFSections(ImageLoader::LinkContext const&, std::vector<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> >&)"},
    {"_ZNK11ImageLoader12getShortNameEv", "ImageLoader::getShortName() const"},
    {"_ZN11ImageLoader9addSuffixEPKcS1_Pc", "ImageLoader::addSuffix(char const*, char const*, char*)"},
    {"_ZN11ImageLoader15printStatisticsEj", "ImageLoader::printStatistics(unsigned int)"},
    {"_ZN11ImageLoader13recursiveBindERKNS_11LinkContextEb", "ImageLoader::recursiveBind(ImageLoader::LinkContext const&, bool)"},
    {"_ZN11ImageLoader25recursiveApplyInterposingERKNS_11LinkContextE", "ImageLoader::recursiveApplyInterposing(ImageLoader::LinkContext const&)"},
    {"_ZN11ImageLoader16applyInterposingERKNS_11LinkContextE", "ImageLoader::applyInterposing(ImageLoader::LinkContext const&)"},
    {"_ZN11ImageLoader15recursiveRebaseERKNS_11LinkContextE", "ImageLoader::recursiveRebase(ImageLoader::LinkContext const&)"},
    {"_ZNK11ImageLoader42findExportedSymbolInImageOrDependentImagesEPKcRKNS_11LinkContextEPPKS_", "ImageLoader::findExportedSymbolInImageOrDependentImages(char const*, ImageLoader::LinkContext const&, ImageLoader const**) const"},
    {"_ZNK11ImageLoader35findExportedSymbolInDependentImagesEPKcRKNS_11LinkContextEPPKS_", "ImageLoader::findExportedSymbolInDependentImages(char const*, ImageLoader::LinkContext const&, ImageLoader const**) const"},
    {"_ZN11ImageLoader8reExportEPS_", "ImageLoader::reExport(ImageLoader*)"},
    {"_ZN11ImageLoader19addDynamicReferenceEPKS_", "ImageLoader::addDynamicReference(ImageLoader const*)"},
    {"_ZN11ImageLoader14setPathUnownedEPKc", "ImageLoader::setPathUnowned(char const*)"},
    {"_ZN11ImageLoader7setPathEPKc", "ImageLoader::setPath(char const*)"},
    {"_ZN11ImageLoaderD0Ev", "ImageLoader::~ImageLoader()"},
    {"_ZNK11ImageLoader15containsAddressEPKv", "ImageLoader::containsAddress(void const*) const"},
    {"_ZN11ImageLoaderD2Ev", "ImageLoader::~ImageLoader()"},
    {"_ZN11ImageLoaderD1Ev", "ImageLoader::~ImageLoader()"},
    {"_ZN11ImageLoader23recursiveInitializationERKNS_11LinkContextEj", "ImageLoader::recursiveInitialization(ImageLoader::LinkContext const&, unsigned int)"},
    {"_ZN11ImageLoader15runInitializersERKNS_11LinkContextE", "ImageLoader::runInitializers(ImageLoader::LinkContext const&)"},
    {"_ZN11ImageLoader8weakBindERKNS_11LinkContextE", "ImageLoader::weakBind(ImageLoader::LinkContext const&)"},
    {"_ZN11ImageLoader22recursiveLoadLibrariesERKNS_11LinkContextEbRKNS_10RPathChainE", "ImageLoader::recursiveLoadLibraries(ImageLoader::LinkContext const&, bool, ImageLoader::RPathChain const&)"},
    {"_ZN11ImageLoader4linkERKNS_11LinkContextEbbRKNS_10RPathChainE", "ImageLoader::link(ImageLoader::LinkContext const&, bool, bool, ImageLoader::RPathChain const&)"},
    {"_ZNSt12_Vector_baseIN11ImageLoader7DOFInfoESaIS1_EED2Ev", "std::_Vector_base<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> >::~_Vector_base()"},
    {"_ZNSt6vectorIN11ImageLoader7DOFInfoESaIS1_EED2Ev", "std::vector<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> >::~vector()"},
    {"_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_erase(std::_Rb_tree_node<ImageLoader const*>*)"},
    {"_ZNSt12_Vector_baseIN11ImageLoader14InterposeTupleESaIS1_EED2Ev", "std::_Vector_base<ImageLoader::InterposeTuple, std::allocator<ImageLoader::InterposeTuple> >::~_Vector_base()"},
    {"_ZNSt6vectorIN11ImageLoader14InterposeTupleESaIS1_EED2Ev", "std::vector<ImageLoader::InterposeTuple, std::allocator<ImageLoader::InterposeTuple> >::~vector()"},
    {"_ZNSt12_Vector_baseISt4pairIP11ImageLoaderS2_ESaIS3_EED2Ev", "std::_Vector_base<std::pair<ImageLoader*, ImageLoader*>, std::allocator<std::pair<ImageLoader*, ImageLoader*> > >::~_Vector_base()"},
    {"_ZNSt6vectorISt4pairIP11ImageLoaderS2_ESaIS3_EED2Ev", "std::vector<std::pair<ImageLoader*, ImageLoader*>, std::allocator<std::pair<ImageLoader*, ImageLoader*> > >::~vector()"},
    {"_ZN9__gnu_cxx13new_allocatorISt13_Rb_tree_nodeIPK11ImageLoaderEE8allocateEmPKv", "__gnu_cxx::new_allocator<std::_Rb_tree_node<ImageLoader const*> >::allocate(unsigned long, void const*)"},
    {"_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE14_M_create_nodeERKS2_", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_create_node(ImageLoader const* const&)"},
    {"_ZN9__gnu_cxx13new_allocatorISt4pairIP11ImageLoaderS3_EE8allocateEmPKv", "__gnu_cxx::new_allocator<std::pair<ImageLoader*, ImageLoader*> >::allocate(unsigned long, void const*)"},
    {"_ZNSt6vectorISt4pairIP11ImageLoaderS2_ESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<std::pair<ImageLoader*, ImageLoader*>, std::allocator<std::pair<ImageLoader*, ImageLoader*> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<ImageLoader*, ImageLoader*>*, std::vector<std::pair<ImageLoader*, ImageLoader*>, std::allocator<std::pair<ImageLoader*, ImageLoader*> > > >, std::pair<ImageLoader*, ImageLoader*> const&)"},
    {"_ZNSt6vectorISt4pairIP11ImageLoaderS2_ESaIS3_EE9push_backERKS3_", "std::vector<std::pair<ImageLoader*, ImageLoader*>, std::allocator<std::pair<ImageLoader*, ImageLoader*> > >::push_back(std::pair<ImageLoader*, ImageLoader*> const&)"},
    {"_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE9_M_insertEPSt18_Rb_tree_node_baseSA_RKS2_", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, ImageLoader const* const&)"},
    {"_ZNSt8_Rb_treeIPK11ImageLoaderS2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE16_M_insert_uniqueERKS2_", "std::_Rb_tree<ImageLoader const*, ImageLoader const*, std::_Identity<ImageLoader const*>, std::less<ImageLoader const*>, std::allocator<ImageLoader const*> >::_M_insert_unique(ImageLoader const* const&)"},
    {"_ZNK16ImageLoaderMachO12segmentCountEv", "ImageLoaderMachO::segmentCount() const"},
    {"_ZN16ImageLoaderMachO22segHasTrailingZeroFillEj", "ImageLoaderMachO::segHasTrailingZeroFill(unsigned int)"},
    {"_ZNK16ImageLoaderMachO19segActualEndAddressEj", "ImageLoaderMachO::segActualEndAddress(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO25segmentsMustSlideTogetherEv", "ImageLoaderMachO::segmentsMustSlideTogether() const"},
    {"_ZNK16ImageLoaderMachO16segmentsCanSlideEv", "ImageLoaderMachO::segmentsCanSlide() const"},
    {"_ZNK16ImageLoaderMachO8isBundleEv", "ImageLoaderMachO::isBundle() const"},
    {"_ZNK16ImageLoaderMachO7isDylibEv", "ImageLoaderMachO::isDylib() const"},
    {"_ZNK16ImageLoaderMachO12isExecutableEv", "ImageLoaderMachO::isExecutable() const"},
    {"_ZNK16ImageLoaderMachO31isPositionIndependentExecutableEv", "ImageLoaderMachO::isPositionIndependentExecutable() const"},
    {"_ZNK16ImageLoaderMachO9forceFlatEv", "ImageLoaderMachO::forceFlat() const"},
    {"_ZNK16ImageLoaderMachO21usesTwoLevelNameSpaceEv", "ImageLoaderMachO::usesTwoLevelNameSpace() const"},
    {"_ZNK16ImageLoaderMachO13isPrebindableEv", "ImageLoaderMachO::isPrebindable() const"},
    {"_ZNK16ImageLoaderMachO19hasCoalescedExportsEv", "ImageLoaderMachO::hasCoalescedExports() const"},
    {"_ZN16ImageLoaderMachO8setSlideEl", "ImageLoaderMachO::setSlide(long)"},
    {"_ZNK16ImageLoaderMachO14getInstallPathEv", "ImageLoaderMachO::getInstallPath() const"},
    {"_ZNK16ImageLoaderMachO7getMainEv", "ImageLoaderMachO::getMain() const"},
    {"_ZN16ImageLoaderMachO16doGetLibraryInfoEv", "ImageLoaderMachO::doGetLibraryInfo()"},
    {"_ZNK16ImageLoaderMachO21getExportedSymbolInfoEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getExportedSymbolInfo(ImageLoader::Symbol const*) const"},
    {"_ZNK16ImageLoaderMachO21getExportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getExportedSymbolName(ImageLoader::Symbol const*) const"},
    {"_ZNK16ImageLoaderMachO22getExportedSymbolCountEv", "ImageLoaderMachO::getExportedSymbolCount() const"},
    {"_ZNK16ImageLoaderMachO24getIndexedExportedSymbolEj", "ImageLoaderMachO::getIndexedExportedSymbol(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO22getImportedSymbolCountEv", "ImageLoaderMachO::getImportedSymbolCount() const"},
    {"_ZNK16ImageLoaderMachO24getIndexedImportedSymbolEj", "ImageLoaderMachO::getIndexedImportedSymbol(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO21getImportedSymbolInfoEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getImportedSymbolInfo(ImageLoader::Symbol const*) const"},
    {"_ZNK16ImageLoaderMachO21getImportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachO::getImportedSymbolName(ImageLoader::Symbol const*) const"},
    {"_ZN16ImageLoaderMachO13getUnwindInfoEP20dyld_unwind_sections", "ImageLoaderMachO::getUnwindInfo(dyld_unwind_sections*)"},
    {"_ZN16ImageLoaderMachO11findSectionEPKvPPKcS4_Pm", "ImageLoaderMachO::findSection(void const*, char const**, char const**, unsigned long*)"},
    {"_ZNK16ImageLoaderMachO10machHeaderEv", "ImageLoaderMachO::machHeader() const"},
    {"_ZNK16ImageLoaderMachO8getSlideEv", "ImageLoaderMachO::getSlide() const"},
    {"_ZNK16ImageLoaderMachO17lookupProgramVarsERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::lookupProgramVars(ImageLoader::LinkContext const&) const"},
    {"_ZN16ImageLoaderMachO19needsInitializationEv", "ImageLoaderMachO::needsInitialization()"},
    {"_ZN16ImageLoaderMachO16needsTerminationEv", "ImageLoaderMachO::needsTermination()"},
    {"_ZN16ImageLoaderMachO10segProtectEjRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::segProtect(unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO18doModInitFunctionsERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doModInitFunctions(ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO11doImageInitERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doImageInit(ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO16doInitializationERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doInitialization(ImageLoader::LinkContext const&)"},
    {"_ZNK16ImageLoaderMachO16getSymbolAddressEPKN11ImageLoader6SymbolEPKS0_RKNS0_11LinkContextE", "ImageLoaderMachO::getSymbolAddress(ImageLoader::Symbol const*, ImageLoader const*, ImageLoader::LinkContext const&) const"},
    {"_ZNK16ImageLoaderMachO24getExportedSymbolAddressEPKN11ImageLoader6SymbolERKNS0_11LinkContextEPKS0_", "ImageLoaderMachO::getExportedSymbolAddress(ImageLoader::Symbol const*, ImageLoader::LinkContext const&, ImageLoader const*) const"},
    {"_ZN16ImageLoaderMachO19throwSymbolNotFoundEPKcS1_S1_", "ImageLoaderMachO::throwSymbolNotFound(char const*, char const*, char const*)"},
    {"_ZN16ImageLoaderMachO21reserveAnAddressRangeEmRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::reserveAnAddressRange(unsigned long, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO23setupLazyPointerHandlerERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::setupLazyPointerHandler(ImageLoader::LinkContext const&)"},
    {"_ZNK16ImageLoaderMachO6getEndEv", "ImageLoaderMachO::getEnd() const"},
    {"_ZN16ImageLoaderMachO17getSectionContentEPKcS1_PPvPm", "ImageLoaderMachO::getSectionContent(char const*, char const*, void**, unsigned long*)"},
    {"_ZN16ImageLoaderMachO13parseLoadCmdsEv", "ImageLoaderMachO::parseLoadCmds()"},
    {"_ZN16ImageLoaderMachO15printStatisticsEj", "ImageLoaderMachO::printStatistics(unsigned int)"},
    {"_ZN16ImageLoaderMachO12bindLocationERKN11ImageLoader11LinkContextEmmPKS0_hPKclS7_", "ImageLoaderMachO::bindLocation(ImageLoader::LinkContext const&, unsigned long, unsigned long, ImageLoader const*, unsigned char, char const*, long, char const*)"},
    {"_ZN16ImageLoaderMachO16doGetDOFSectionsERKN11ImageLoader11LinkContextERSt6vectorINS0_7DOFInfoESaIS5_EE", "ImageLoaderMachO::doGetDOFSections(ImageLoader::LinkContext const&, std::vector<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> >&)"},
    {"_ZNK16ImageLoaderMachO16usablePrebindingERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::usablePrebinding(ImageLoader::LinkContext const&) const"},
    {"_ZNK16ImageLoaderMachO7getUUIDEPh", "ImageLoaderMachO::getUUID(unsigned char*) const"},
    {"_ZN16ImageLoaderMachO26needsAddedLibSystemDepencyEjPK12macho_header", "ImageLoaderMachO::needsAddedLibSystemDepency(unsigned int, macho_header const*)"},
    {"_ZN16ImageLoaderMachO23doGetDependentLibrariesEPN11ImageLoader20DependentLibraryInfoE", "ImageLoaderMachO::doGetDependentLibraries(ImageLoader::DependentLibraryInfo*)"},
    {"_ZN16ImageLoaderMachO17sniffLoadCommandsEPK12macho_headerPKcPbPjS6_", "ImageLoaderMachO::sniffLoadCommands(macho_header const*, char const*, bool*, unsigned int*, unsigned int*)"},
    {"_ZNK16ImageLoaderMachO24participatesInCoalescingEv", "ImageLoaderMachO::participatesInCoalescing() const"},
    {"_ZN16ImageLoaderMachO12preFetchDATAEiyRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::preFetchDATA(int, unsigned long long, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO13UnmapSegmentsEv", "ImageLoaderMachO::UnmapSegments()"},
    {"_ZN16ImageLoaderMachO7destroyEv", "ImageLoaderMachO::destroy()"},
    {"_ZN16ImageLoaderMachO21instantiateFromMemoryEPKcPK12macho_headeryRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateFromMemory(char const*, macho_header const*, unsigned long long, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO20instantiateFromCacheEPK12macho_headerPKcRK4statRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateFromCache(macho_header const*, char const*, stat const&, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO19instantiateFromFileEPKciPKhyyRK4statRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateFromFile(char const*, int, unsigned char const*, unsigned long long, unsigned long long, stat const&, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO25instantiateMainExecutableEPK12macho_headermPKcRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::instantiateMainExecutable(macho_header const*, unsigned long, char const*, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachOC2EPK12macho_headerPKcjPjj", "ImageLoaderMachO::ImageLoaderMachO(macho_header const*, char const*, unsigned int, unsigned int*, unsigned int)"},
    {"_ZN16ImageLoaderMachO13doTerminationERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doTermination(ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO8doRebaseERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::doRebase(ImageLoader::LinkContext const&)"},
    {"_ZNK16ImageLoaderMachO9getRPathsERKN11ImageLoader11LinkContextERSt6vectorIPKcSaIS6_EE", "ImageLoaderMachO::getRPaths(ImageLoader::LinkContext const&, std::vector<char const*, std::allocator<char const*> >&) const"},
    {"_ZN16ImageLoaderMachO19registerInterposingEv", "ImageLoaderMachO::registerInterposing()"},
    {"_ZNK16ImageLoaderMachO18findExportedSymbolEPKcbPPK11ImageLoader", "ImageLoaderMachO::findExportedSymbol(char const*, bool, ImageLoader const**) const"},
    {"_ZN16ImageLoaderMachO22assignSegmentAddressesERKN11ImageLoader11LinkContextE", "ImageLoaderMachO::assignSegmentAddresses(ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO11mapSegmentsEPKvyRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::mapSegments(void const*, unsigned long long, ImageLoader::LinkContext const&)"},
    {"_ZN16ImageLoaderMachO11mapSegmentsEiyyyRKN11ImageLoader11LinkContextE", "ImageLoaderMachO::mapSegments(int, unsigned long long, unsigned long long, unsigned long long, ImageLoader::LinkContext const&)"},
    {"_ZNK16ImageLoaderMachO23segPreferredLoadAddressEj", "ImageLoaderMachO::segPreferredLoadAddress(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO26segHasPreferredLoadAddressEj", "ImageLoaderMachO::segHasPreferredLoadAddress(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO15segUnaccessibleEj", "ImageLoaderMachO::segUnaccessible(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO13segExecutableEj", "ImageLoaderMachO::segExecutable(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO20segActualLoadAddressEj", "ImageLoaderMachO::segActualLoadAddress(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO7segSizeEj", "ImageLoaderMachO::segSize(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO7segNameEj", "ImageLoaderMachO::segName(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO12segWriteableEj", "ImageLoaderMachO::segWriteable(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO11segReadableEj", "ImageLoaderMachO::segReadable(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO13segFileOffsetEj", "ImageLoaderMachO::segFileOffset(unsigned int) const"},
    {"_ZNK16ImageLoaderMachO11segFileSizeEj", "ImageLoaderMachO::segFileSize(unsigned int) const"},
    {"_ZN16ImageLoaderMachOD2Ev", "ImageLoaderMachO::~ImageLoaderMachO()"},
    {"_ZN16ImageLoaderMachOD1Ev", "ImageLoaderMachO::~ImageLoaderMachO()"},
    {"_ZN16ImageLoaderMachOD0Ev", "ImageLoaderMachO::~ImageLoaderMachO()"},
    {"_ZN9__gnu_cxx13new_allocatorIN11ImageLoader7DOFInfoEE8allocateEmPKv", "__gnu_cxx::new_allocator<ImageLoader::DOFInfo>::allocate(unsigned long, void const*)"},
    {"_ZN9__gnu_cxx13new_allocatorIN11ImageLoader14InterposeTupleEE8allocateEmPKv", "__gnu_cxx::new_allocator<ImageLoader::InterposeTuple>::allocate(unsigned long, void const*)"},
    {"_ZNSt6vectorIN11ImageLoader7DOFInfoESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> >::_M_insert_aux(__gnu_cxx::__normal_iterator<ImageLoader::DOFInfo*, std::vector<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> > >, ImageLoader::DOFInfo const&)"},
    {"_ZNSt6vectorIN11ImageLoader7DOFInfoESaIS1_EE9push_backERKS1_", "std::vector<ImageLoader::DOFInfo, std::allocator<ImageLoader::DOFInfo> >::push_back(ImageLoader::DOFInfo const&)"},
    {"_ZNSt6vectorIN11ImageLoader14InterposeTupleESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<ImageLoader::InterposeTuple, std::allocator<ImageLoader::InterposeTuple> >::_M_insert_aux(__gnu_cxx::__normal_iterator<ImageLoader::InterposeTuple*, std::vector<ImageLoader::InterposeTuple, std::allocator<ImageLoader::InterposeTuple> > >, ImageLoader::InterposeTuple const&)"},
    {"_ZNSt6vectorIN11ImageLoader14InterposeTupleESaIS1_EE9push_backERKS1_", "std::vector<ImageLoader::InterposeTuple, std::allocator<ImageLoader::InterposeTuple> >::push_back(ImageLoader::InterposeTuple const&)"},
    {"_ZNK23ImageLoaderMachOClassic21segmentCommandOffsetsEv", "ImageLoaderMachOClassic::segmentCommandOffsets() const"},
    {"_ZNK23ImageLoaderMachOClassic8libImageEj", "ImageLoaderMachOClassic::libImage(unsigned int) const"},
    {"_ZNK23ImageLoaderMachOClassic13libReExportedEj", "ImageLoaderMachOClassic::libReExported(unsigned int) const"},
    {"_ZN23ImageLoaderMachOClassic11setLibImageEjP11ImageLoaderb", "ImageLoaderMachOClassic::setLibImage(unsigned int, ImageLoader*, bool)"},
    {"_ZN23ImageLoaderMachOClassic18setSymbolTableInfoEPK11macho_nlistPKcPK16dysymtab_command", "ImageLoaderMachOClassic::setSymbolTableInfo(macho_nlist const*, char const*, dysymtab_command const*)"},
    {"_ZNK23ImageLoaderMachOClassic14containsSymbolEPKv", "ImageLoaderMachOClassic::containsSymbol(void const*) const"},
    {"_ZNK23ImageLoaderMachOClassic21exportedSymbolAddressEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::exportedSymbolAddress(ImageLoader::Symbol const*) const"},
    {"_ZNK23ImageLoaderMachOClassic29exportedSymbolIsWeakDefintionEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::exportedSymbolIsWeakDefintion(ImageLoader::Symbol const*) const"},
    {"_ZNK23ImageLoaderMachOClassic18exportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::exportedSymbolName(ImageLoader::Symbol const*) const"},
    {"_ZNK23ImageLoaderMachOClassic19exportedSymbolCountEv", "ImageLoaderMachOClassic::exportedSymbolCount() const"},
    {"_ZNK23ImageLoaderMachOClassic21exportedSymbolIndexedEj", "ImageLoaderMachOClassic::exportedSymbolIndexed(unsigned int) const"},
    {"_ZNK23ImageLoaderMachOClassic19importedSymbolCountEv", "ImageLoaderMachOClassic::importedSymbolCount() const"},
    {"_ZNK23ImageLoaderMachOClassic21importedSymbolIndexedEj", "ImageLoaderMachOClassic::importedSymbolIndexed(unsigned int) const"},
    {"_ZNK23ImageLoaderMachOClassic18importedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOClassic::importedSymbolName(ImageLoader::Symbol const*) const"},
    {"_ZN23ImageLoaderMachOClassic22initializeCoalIteratorERN11ImageLoader12CoalIteratorEj", "ImageLoaderMachOClassic::initializeCoalIterator(ImageLoader::CoalIterator&, unsigned int)"},
    {"_ZN23ImageLoaderMachOClassic21incrementCoalIteratorERN11ImageLoader12CoalIteratorE", "ImageLoaderMachOClassic::incrementCoalIterator(ImageLoader::CoalIterator&)"},
    {"_ZN23ImageLoaderMachOClassic22getAddressCoalIteratorERN11ImageLoader12CoalIteratorERKNS0_11LinkContextE", "ImageLoaderMachOClassic::getAddressCoalIterator(ImageLoader::CoalIterator&, ImageLoader::LinkContext const&)"},
    {"_ZNK23ImageLoaderMachOClassic17findClosestSymbolEPKvPS1_", "ImageLoaderMachOClassic::findClosestSymbol(void const*, void const**) const"},
    {"_ZN23ImageLoaderMachOClassic20doBindFastLazySymbolEjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindFastLazySymbol(unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic30getFirstWritableSegmentAddressEv", "ImageLoaderMachOClassic::getFirstWritableSegmentAddress()"},
    {"_ZN23ImageLoaderMachOClassic18bindIndirectSymbolEPmPK13macho_sectionPKcmPK11ImageLoaderRKNS6_11LinkContextE", "ImageLoaderMachOClassic::bindIndirectSymbol(unsigned long*, macho_section const*, char const*, unsigned long, ImageLoader const*, ImageLoader::LinkContext const&)"},
    {"_ZNK23ImageLoaderMachOClassic12binarySearchEPKcS1_PK11macho_nlistj", "ImageLoaderMachOClassic::binarySearch(char const*, char const*, macho_nlist const*, unsigned int) const"},
    {"_ZNK23ImageLoaderMachOClassic19binarySearchWithTocEPKcS1_PK11macho_nlistPK23dylib_table_of_contentsjj", "ImageLoaderMachOClassic::binarySearchWithToc(char const*, char const*, macho_nlist const*, dylib_table_of_contents const*, unsigned int, unsigned int) const"},
    {"_ZNK23ImageLoaderMachOClassic18findExportedSymbolEPKcPPK11ImageLoader", "ImageLoaderMachOClassic::findExportedSymbol(char const*, ImageLoader const**) const"},
    {"_ZNK23ImageLoaderMachOClassic13hasSubLibraryERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOClassic::hasSubLibrary(ImageLoader::LinkContext const&, ImageLoader const*) const"},
    {"_ZNK23ImageLoaderMachOClassic16isSubframeworkOfERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOClassic::isSubframeworkOf(ImageLoader::LinkContext const&, ImageLoader const*) const"},
    {"_ZN23ImageLoaderMachOClassic18mapSegmentsClassicEiyyyRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::mapSegmentsClassic(int, unsigned long long, unsigned long long, unsigned long long, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic16prefetchLINKEDITERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::prefetchLINKEDIT(ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassicD2Ev", "ImageLoaderMachOClassic::~ImageLoaderMachOClassic()"},
    {"_ZN23ImageLoaderMachOClassicD1Ev", "ImageLoaderMachOClassic::~ImageLoaderMachOClassic()"},
    {"_ZN23ImageLoaderMachOClassicD0Ev", "ImageLoaderMachOClassic::~ImageLoaderMachOClassic()"},
    {"_ZN23ImageLoaderMachOClassic17instantiateFinishERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFinish(ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic6rebaseERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::rebase(ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic11doInterposeERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doInterpose(ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic16resolveUndefinedERKN11ImageLoader11LinkContextEPK11macho_nlistbbPPKS0_", "ImageLoaderMachOClassic::resolveUndefined(ImageLoader::LinkContext const&, macho_nlist const*, bool, bool, ImageLoader const**)"},
    {"_ZN23ImageLoaderMachOClassic26bindIndirectSymbolPointersERKN11ImageLoader11LinkContextEbb", "ImageLoaderMachOClassic::bindIndirectSymbolPointers(ImageLoader::LinkContext const&, bool, bool)"},
    {"_ZN23ImageLoaderMachOClassic16doBindJustLaziesERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindJustLazies(ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic16doBindLazySymbolEPmRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindLazySymbol(unsigned long*, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic16instantiateStartEPK12macho_headerPKcjj", "ImageLoaderMachOClassic::instantiateStart(macho_header const*, char const*, unsigned int, unsigned int)"},
    {"_ZN23ImageLoaderMachOClassic21instantiateFromMemoryEPKcPK12macho_headeryjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFromMemory(char const*, macho_header const*, unsigned long long, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic20instantiateFromCacheEPK12macho_headerPKcRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFromCache(macho_header const*, char const*, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic19instantiateFromFileEPKciPKhyyRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateFromFile(char const*, int, unsigned char const*, unsigned long long, unsigned long long, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic25instantiateMainExecutableEPK12macho_headermPKcjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::instantiateMainExecutable(macho_header const*, unsigned long, char const*, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic22updateUsesCoalIteratorERN11ImageLoader12CoalIteratorEmPS0_RKNS0_11LinkContextE", "ImageLoaderMachOClassic::updateUsesCoalIterator(ImageLoader::CoalIterator&, unsigned long, ImageLoader*, ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic25doBindExternalRelocationsERKN11ImageLoader11LinkContextE", "ImageLoaderMachOClassic::doBindExternalRelocations(ImageLoader::LinkContext const&)"},
    {"_ZN23ImageLoaderMachOClassic6doBindERKN11ImageLoader11LinkContextEb", "ImageLoaderMachOClassic::doBind(ImageLoader::LinkContext const&, bool)"},
    {"_ZN23ImageLoaderMachOClassic11setDyldInfoEPK17dyld_info_command", "ImageLoaderMachOClassic::setDyldInfo(dyld_info_command const*)"},
    {"_ZNK26ImageLoaderMachOCompressed21segmentCommandOffsetsEv", "ImageLoaderMachOCompressed::segmentCommandOffsets() const"},
    {"_ZNK26ImageLoaderMachOCompressed8libImageEj", "ImageLoaderMachOCompressed::libImage(unsigned int) const"},
    {"_ZNK26ImageLoaderMachOCompressed13libReExportedEj", "ImageLoaderMachOCompressed::libReExported(unsigned int) const"},
    {"_ZN26ImageLoaderMachOCompressed11setLibImageEjP11ImageLoaderb", "ImageLoaderMachOCompressed::setLibImage(unsigned int, ImageLoader*, bool)"},
    {"_ZNK26ImageLoaderMachOCompressed14containsSymbolEPKv", "ImageLoaderMachOCompressed::containsSymbol(void const*) const"},
    {"_ZN26ImageLoaderMachOCompressed22initializeCoalIteratorERN11ImageLoader12CoalIteratorEj", "ImageLoaderMachOCompressed::initializeCoalIterator(ImageLoader::CoalIterator&, unsigned int)"},
    {"_ZN26ImageLoaderMachOCompressed22getAddressCoalIteratorERN11ImageLoader12CoalIteratorERKNS0_11LinkContextE", "ImageLoaderMachOCompressed::getAddressCoalIterator(ImageLoader::CoalIterator&, ImageLoader::LinkContext const&)"},
    {"_ZNK26ImageLoaderMachOCompressed17findClosestSymbolEPKvPS1_", "ImageLoaderMachOCompressed::findClosestSymbol(void const*, void const**) const"},
    {"_ZNK26ImageLoaderMachOCompressed18importedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::importedSymbolName(ImageLoader::Symbol const*) const"},
    {"_ZNK26ImageLoaderMachOCompressed21importedSymbolIndexedEj", "ImageLoaderMachOCompressed::importedSymbolIndexed(unsigned int) const"},
    {"_ZNK26ImageLoaderMachOCompressed19importedSymbolCountEv", "ImageLoaderMachOCompressed::importedSymbolCount() const"},
    {"_ZNK26ImageLoaderMachOCompressed21exportedSymbolIndexedEj", "ImageLoaderMachOCompressed::exportedSymbolIndexed(unsigned int) const"},
    {"_ZNK26ImageLoaderMachOCompressed19exportedSymbolCountEv", "ImageLoaderMachOCompressed::exportedSymbolCount() const"},
    {"_ZNK26ImageLoaderMachOCompressed18exportedSymbolNameEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::exportedSymbolName(ImageLoader::Symbol const*) const"},
    {"_ZN26ImageLoaderMachOCompressed15resolveTwolevelERKN11ImageLoader11LinkContextEPKS0_bPKcPS5_", "ImageLoaderMachOCompressed::resolveTwolevel(ImageLoader::LinkContext const&, ImageLoader const*, bool, char const*, ImageLoader const**)"},
    {"_ZN26ImageLoaderMachOCompressed11resolveFlatERKN11ImageLoader11LinkContextEPKcbPPKS0_", "ImageLoaderMachOCompressed::resolveFlat(ImageLoader::LinkContext const&, char const*, bool, ImageLoader const**)"},
    {"_ZN26ImageLoaderMachOCompressed7resolveERKN11ImageLoader11LinkContextEPKchiPPKS0_PNS_10LastLookupE", "ImageLoaderMachOCompressed::resolve(ImageLoader::LinkContext const&, char const*, unsigned char, int, ImageLoader const**, ImageLoaderMachOCompressed::LastLookup*)"},
    {"_ZN26ImageLoaderMachOCompressed6bindAtERKN11ImageLoader11LinkContextEmhPKchliS5_PNS_10LastLookupE", "ImageLoaderMachOCompressed::bindAt(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*)"},
    {"_ZN26ImageLoaderMachOCompressed11interposeAtERKN11ImageLoader11LinkContextEmhPKchliS5_PNS_10LastLookupE", "ImageLoaderMachOCompressed::interposeAt(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*)"},
    {"_ZN26ImageLoaderMachOCompressed16instantiateStartEPK12macho_headerPKcjj", "ImageLoaderMachOCompressed::instantiateStart(macho_header const*, char const*, unsigned int, unsigned int)"},
    {"_ZN26ImageLoaderMachOCompressed16doBindLazySymbolEPmRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doBindLazySymbol(unsigned long*, ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed20instantiateFromCacheEPK12macho_headerPKcRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateFromCache(macho_header const*, char const*, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed21instantiateFromMemoryEPKcPK12macho_headeryjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateFromMemory(char const*, macho_header const*, unsigned long long, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed25instantiateMainExecutableEPK12macho_headermPKcjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateMainExecutable(macho_header const*, unsigned long, char const*, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressedD0Ev", "ImageLoaderMachOCompressed::~ImageLoaderMachOCompressed()"},
    {"_ZN26ImageLoaderMachOCompressedD1Ev", "ImageLoaderMachOCompressed::~ImageLoaderMachOCompressed()"},
    {"_ZN26ImageLoaderMachOCompressed19instantiateFromFileEPKciPKhyyRK4statjjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::instantiateFromFile(char const*, int, unsigned char const*, unsigned long long, unsigned long long, stat const&, unsigned int, unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZNK26ImageLoaderMachOCompressed29exportedSymbolIsWeakDefintionEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::exportedSymbolIsWeakDefintion(ImageLoader::Symbol const*) const"},
    {"_ZNK26ImageLoaderMachOCompressed21exportedSymbolAddressEPKN11ImageLoader6SymbolE", "ImageLoaderMachOCompressed::exportedSymbolAddress(ImageLoader::Symbol const*) const"},
    {"_ZNK26ImageLoaderMachOCompressed18findExportedSymbolEPKcPPK11ImageLoader", "ImageLoaderMachOCompressed::findExportedSymbol(char const*, ImageLoader const**) const"},
    {"_ZN26ImageLoaderMachOCompressed6rebaseERKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::rebase(ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed22updateUsesCoalIteratorERN11ImageLoader12CoalIteratorEmPS0_RKNS0_11LinkContextE", "ImageLoaderMachOCompressed::updateUsesCoalIterator(ImageLoader::CoalIterator&, unsigned long, ImageLoader*, ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed21incrementCoalIteratorERN11ImageLoader12CoalIteratorE", "ImageLoaderMachOCompressed::incrementCoalIterator(ImageLoader::CoalIterator&)"},
    {"_ZN26ImageLoaderMachOCompressed20doBindFastLazySymbolEjRKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doBindFastLazySymbol(unsigned int, ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed12eachLazyBindERKN11ImageLoader11LinkContextEMS_FmS3_mhPKchliS5_PNS_10LastLookupEE", "ImageLoaderMachOCompressed::eachLazyBind(ImageLoader::LinkContext const&, unsigned long (ImageLoaderMachOCompressed::*)(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*))"},
    {"_ZN26ImageLoaderMachOCompressed16doBindJustLaziesERKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doBindJustLazies(ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed8eachBindERKN11ImageLoader11LinkContextEMS_FmS3_mhPKchliS5_PNS_10LastLookupEE", "ImageLoaderMachOCompressed::eachBind(ImageLoader::LinkContext const&, unsigned long (ImageLoaderMachOCompressed::*)(ImageLoader::LinkContext const&, unsigned long, unsigned char, char const*, unsigned char, long, int, char const*, ImageLoaderMachOCompressed::LastLookup*))"},
    {"_ZN26ImageLoaderMachOCompressed11doInterposeERKN11ImageLoader11LinkContextE", "ImageLoaderMachOCompressed::doInterpose(ImageLoader::LinkContext const&)"},
    {"_ZN26ImageLoaderMachOCompressed6doBindERKN11ImageLoader11LinkContextEb", "ImageLoaderMachOCompressed::doBind(ImageLoader::LinkContext const&, bool)"},
    {"_ZN26ImageLoaderMachOCompressed11setDyldInfoEPK17dyld_info_command", "ImageLoaderMachOCompressed::setDyldInfo(dyld_info_command const*)"},
    {"_ZN26ImageLoaderMachOCompressed18setSymbolTableInfoEPK11macho_nlistPKcPK16dysymtab_command", "ImageLoaderMachOCompressed::setSymbolTableInfo(macho_nlist const*, char const*, dysymtab_command const*)"},
    {"_ZNK26ImageLoaderMachOCompressed16isSubframeworkOfERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOCompressed::isSubframeworkOf(ImageLoader::LinkContext const&, ImageLoader const*) const"},
    {"_ZNK26ImageLoaderMachOCompressed13hasSubLibraryERKN11ImageLoader11LinkContextEPKS0_", "ImageLoaderMachOCompressed::hasSubLibrary(ImageLoader::LinkContext const&, ImageLoader const*) const"},
    {"_ZSt17__throw_bad_allocv", "std::__throw_bad_alloc()"},
    {"_ZSt20__throw_length_errorPKc", "std::__throw_length_error(char const*)"},
    {"_ZSt19__throw_logic_errorPKc", "std::__throw_logic_error(char const*)"},
    {"_ZNSt12length_errorD0Ev", "std::length_error::~length_error()"},
    {"_ZNSt12length_errorD2Ev", "std::length_error::~length_error()"},
    {"_ZNSt12length_errorD1Ev", "std::length_error::~length_error()"},
    {"_ZNKSt11logic_error4whatEv", "std::logic_error::what() const"},
    {"_ZNSt11logic_errorC2ERKSs", "std::logic_error::logic_error(std::string const&)"},
    {"_ZNSt11logic_errorC1ERKSs", "std::logic_error::logic_error(std::string const&)"},
    {"_ZNSt12length_errorC1ERKSs", "std::length_error::length_error(std::string const&)"},
    {"_ZNSt11logic_errorD0Ev", "std::logic_error::~logic_error()"},
    {"_ZNSt11logic_errorD2Ev", "std::logic_error::~logic_error()"},
    {"_ZNSt11logic_errorD1Ev", "std::logic_error::~logic_error()"},
    {"_ZSt18_Rb_tree_decrementPSt18_Rb_tree_node_base", "std::_Rb_tree_decrement(std::_Rb_tree_node_base*)"},
    {"_ZSt29_Rb_tree_insert_and_rebalancebPSt18_Rb_tree_node_baseS0_RS_", "std::_Rb_tree_insert_and_rebalance(bool, std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::_Rb_tree_node_base&)"},
    {"_ZSt18_Rb_tree_incrementPKSt18_Rb_tree_node_base", "std::_Rb_tree_increment(std::_Rb_tree_node_base const*)"},
    {"_ZNSs4_Rep10_M_disposeERKSaIcE", "std::string::_Rep::_M_dispose(std::allocator<char> const&)"},
    {"_ZNSs4_Rep9_S_createEmmRKSaIcE", "std::string::_Rep::_S_create(unsigned long, unsigned long, std::allocator<char> const&)"},
    {"_ZNSs4_Rep8_M_cloneERKSaIcEm", "std::string::_Rep::_M_clone(std::allocator<char> const&, unsigned long)"},
    {"_ZNSs4_Rep7_M_grabERKSaIcES2_", "std::string::_Rep::_M_grab(std::allocator<char> const&, std::allocator<char> const&)"},
    {"_ZNSsC2ERKSs", "std::basic_string<char, std::char_traits<char>, std::allocator<char> >::basic_string(std::string const&)"},
    {"_ZNSsC1ERKSs", "std::basic_string<char, std::char_traits<char>, std::allocator<char> >::basic_string(std::string const&)"},
    {"_ZNSs12_S_constructIPKcEEPcT_S3_RKSaIcESt20forward_iterator_tag", "char* std::string::_S_construct<char const*>(char const*, char const*, std::allocator<char> const&, std::forward_iterator_tag)"},
    {"_ZNSsC2EPKcRKSaIcE", "std::basic_string<char, std::char_traits<char>, std::allocator<char> >::basic_string(char const*, std::allocator<char> const&)"},
    {"_ZNSsC1EPKcRKSaIcE", "std::basic_string<char, std::char_traits<char>, std::allocator<char> >::basic_string(char const*, std::allocator<char> const&)"},
    {"_ZN9__gnu_cxx13new_allocatorIcE8allocateEmPKv", "__gnu_cxx::new_allocator<char>::allocate(unsigned long, void const*)"},
    {"_ZdlPv", "operator delete(void*)"},
    {"_ZdaPv", "operator delete[](void*)"},
    {"_ZNK9__gnu_cxx24__concurrence_lock_error4whatEv", "__gnu_cxx::__concurrence_lock_error::what() const"},
    {"_ZNK9__gnu_cxx26__concurrence_unlock_error4whatEv", "__gnu_cxx::__concurrence_unlock_error::what() const"},
    {"_ZN9__gnu_cxx32__throw_concurrence_unlock_errorEv", "__gnu_cxx::__throw_concurrence_unlock_error()"},
    {"_ZN9__gnu_cxx30__throw_concurrence_lock_errorEv", "__gnu_cxx::__throw_concurrence_lock_error()"},
    {"_ZN9__gnu_cxx7__mutex4lockEv", "__gnu_cxx::__mutex::lock()"},
    {"_ZN9__gnu_cxx26__concurrence_unlock_errorD0Ev", "__gnu_cxx::__concurrence_unlock_error::~__concurrence_unlock_error()"},
    {"_ZN9__gnu_cxx26__concurrence_unlock_errorD2Ev", "__gnu_cxx::__concurrence_unlock_error::~__concurrence_unlock_error()"},
    {"_ZN9__gnu_cxx26__concurrence_unlock_errorD1Ev", "__gnu_cxx::__concurrence_unlock_error::~__concurrence_unlock_error()"},
    {"_ZN9__gnu_cxx24__concurrence_lock_errorD0Ev", "__gnu_cxx::__concurrence_lock_error::~__concurrence_lock_error()"},
    {"_ZN9__gnu_cxx24__concurrence_lock_errorD2Ev", "__gnu_cxx::__concurrence_lock_error::~__concurrence_lock_error()"},
    {"_ZN9__gnu_cxx24__concurrence_lock_errorD1Ev", "__gnu_cxx::__concurrence_lock_error::~__concurrence_lock_error()"},
    {"_ZN9__gnu_cxx7__mutex6unlockEv", "__gnu_cxx::__mutex::unlock()"},
    {"_ZN9__gnu_cxx13__scoped_lockD2Ev", "__gnu_cxx::__scoped_lock::~__scoped_lock()"},
    {"_ZNKSt9exception4whatEv", "std::exception::what() const"},
    {"_ZNKSt13bad_exception4whatEv", "std::bad_exception::what() const"},
    {"_ZNSt13bad_exceptionD0Ev", "std::bad_exception::~bad_exception()"},
    {"_ZNSt9exceptionD0Ev", "std::exception::~exception()"},
    {"_ZNSt9exceptionD2Ev", "std::exception::~exception()"},
    {"_ZNSt13bad_exceptionD1Ev", "std::bad_exception::~bad_exception()"},
    {"_ZNSt9exceptionD1Ev", "std::exception::~exception()"},
    {"_ZNKSt9bad_alloc4whatEv", "std::bad_alloc::what() const"},
    {"_ZNSt9bad_allocD0Ev", "std::bad_alloc::~bad_alloc()"},
    {"_ZNSt9bad_allocD2Ev", "std::bad_alloc::~bad_alloc()"},
    {"_ZNSt9bad_allocD1Ev", "std::bad_alloc::~bad_alloc()"},
    {"_Znwm", "operator new(unsigned long)"},
    {"_Znam", "operator new[](unsigned long)"},
    {"_ZNKSt9type_info14__is_pointer_pEv", "std::type_info::__is_pointer_p() const"},
    {"_ZNKSt9type_info15__is_function_pEv", "std::type_info::__is_function_p() const"},
    {"_ZNKSt9type_info11__do_upcastEPKN10__cxxabiv117__class_type_infoEPPv", "std::type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void**) const"},
    {"_ZNK10__cxxabiv117__class_type_info10__do_catchEPKSt9type_infoPPvj", "__cxxabiv1::__class_type_info::__do_catch(std::type_info const*, void**, unsigned int) const"},
    {"_ZNK10__cxxabiv117__class_type_info11__do_upcastEPKS0_PPv", "__cxxabiv1::__class_type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void**) const"},
    {"_ZNK10__cxxabiv117__class_type_info20__do_find_public_srcElPKvPKS0_S2_", "__cxxabiv1::__class_type_info::__do_find_public_src(long, void const*, __cxxabiv1::__class_type_info const*, void const*) const"},
    {"_ZNK10__cxxabiv117__class_type_info11__do_upcastEPKS0_PKvRNS0_15__upcast_resultE", "__cxxabiv1::__class_type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__upcast_result&) const"},
    {"_ZN10__cxxabiv117__class_type_infoD0Ev", "__cxxabiv1::__class_type_info::~__class_type_info()"},
    {"_ZN10__cxxabiv117__class_type_infoD1Ev", "__cxxabiv1::__class_type_info::~__class_type_info()"},
    {"_ZNSt9type_infoD0Ev", "std::type_info::~type_info()"},
    {"_ZNSt9type_infoD1Ev", "std::type_info::~type_info()"},
    {"_ZNSt9type_infoD2Ev", "std::type_info::~type_info()"},
    {"_ZNKSt9type_info10__do_catchEPKS_PPvj", "std::type_info::__do_catch(std::type_info const*, void**, unsigned int) const"},
    {"_ZNK10__cxxabiv117__class_type_info12__do_dyncastElNS0_10__sub_kindEPKS0_PKvS3_S5_RNS0_16__dyncast_resultE", "__cxxabiv1::__class_type_info::__do_dyncast(long, __cxxabiv1::__class_type_info::__sub_kind, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__dyncast_result&) const"},
    {"_ZNK10__cxxabiv120__si_class_type_info20__do_find_public_srcElPKvPKNS_17__class_type_infoES2_", "__cxxabiv1::__si_class_type_info::__do_find_public_src(long, void const*, __cxxabiv1::__class_type_info const*, void const*) const"},
    {"_ZNK10__cxxabiv120__si_class_type_info12__do_dyncastElNS_17__class_type_info10__sub_kindEPKS1_PKvS4_S6_RNS1_16__dyncast_resultE", "__cxxabiv1::__si_class_type_info::__do_dyncast(long, __cxxabiv1::__class_type_info::__sub_kind, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__dyncast_result&) const"},
    {"_ZNK10__cxxabiv120__si_class_type_info11__do_upcastEPKNS_17__class_type_infoEPKvRNS1_15__upcast_resultE", "__cxxabiv1::__si_class_type_info::__do_upcast(__cxxabiv1::__class_type_info const*, void const*, __cxxabiv1::__class_type_info::__upcast_result&) const"},
    {"_ZN10__cxxabiv120__si_class_type_infoD0Ev", "__cxxabiv1::__si_class_type_info::~__si_class_type_info()"},
    {"_ZN10__cxxabiv120__si_class_type_infoD2Ev", "__cxxabiv1::__si_class_type_info::~__si_class_type_info()"},
    {"_ZN10__cxxabiv120__si_class_type_infoD1Ev", "__cxxabiv1::__si_class_type_info::~__si_class_type_info()"},
    {"_ZNK10__cxxabiv119__pointer_type_info14__is_pointer_pEv", "__cxxabiv1::__pointer_type_info::__is_pointer_p() const"},
    {"_ZN10__cxxabiv117__pbase_type_infoD0Ev", "__cxxabiv1::__pbase_type_info::~__pbase_type_info()"},
    {"_ZN10__cxxabiv117__pbase_type_infoD2Ev", "__cxxabiv1::__pbase_type_info::~__pbase_type_info()"},
    {"_ZN10__cxxabiv119__pointer_type_infoD0Ev", "__cxxabiv1::__pointer_type_info::~__pointer_type_info()"},
    {"_ZN10__cxxabiv119__pointer_type_infoD2Ev", "__cxxabiv1::__pointer_type_info::~__pointer_type_info()"},
    {"_ZN10__cxxabiv119__pointer_type_infoD1Ev", "__cxxabiv1::__pointer_type_info::~__pointer_type_info()"},
    {"_ZN10__cxxabiv117__pbase_type_infoD1Ev", "__cxxabiv1::__pbase_type_info::~__pbase_type_info()"},
    {"_ZN10__cxxabiv123__fundamental_type_infoD0Ev", "__cxxabiv1::__fundamental_type_info::~__fundamental_type_info()"},
    {"_ZN10__cxxabiv123__fundamental_type_infoD2Ev", "__cxxabiv1::__fundamental_type_info::~__fundamental_type_info()"},
    {"_ZN10__cxxabiv123__fundamental_type_infoD1Ev", "__cxxabiv1::__fundamental_type_info::~__fundamental_type_info()"},
    {"_ZNK10__cxxabiv117__pbase_type_info10__do_catchEPKSt9type_infoPPvj", "__cxxabiv1::__pbase_type_info::__do_catch(std::type_info const*, void**, unsigned int) const"},
    {"_ZNK10__cxxabiv119__pointer_type_info15__pointer_catchEPKNS_17__pbase_type_infoEPPvj", "__cxxabiv1::__pointer_type_info::__pointer_catch(__cxxabiv1::__pbase_type_info const*, void**, unsigned int) const"},
    {"_ZNK10__cxxabiv117__pbase_type_info15__pointer_catchEPKS0_PPvj", "__cxxabiv1::__pbase_type_info::__pointer_catch(__cxxabiv1::__pbase_type_info const*, void**, unsigned int) const"},
    {"_ZN16CSCppTimeoutLockD1Ev", "CSCppTimeoutLock::~CSCppTimeoutLock()"},
    {"_ZN16CSCppTimeoutLockC2EPjj", "CSCppTimeoutLock::CSCppTimeoutLock(unsigned int*, unsigned int)"},
    {"_ZN16CSCppTimeoutLockC1EPjj", "CSCppTimeoutLock::CSCppTimeoutLock(unsigned int*, unsigned int)"},
    {"_ZN25CSCppDyldSharedMemoryPage11send_noticeEjRjS0_", "CSCppDyldSharedMemoryPage::send_notice(unsigned int, unsigned int&, unsigned int&)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE8validRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::validReg(int)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE13validFloatRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::validFloatReg(int)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE7getInfoEP15unw_proc_info_t", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getInfo(unw_proc_info_t*)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE15getRegisterNameEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getRegisterName(int)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE13isSignalFrameEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::isSignalFrame()"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EED0Ev", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::~UnwindCursor()"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE33getInfoFromCompactEncodingSectionEyyy", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getInfoFromCompactEncodingSection(unsigned long long, unsigned long long, unsigned long long)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE24setInfoBasedOnIPRegisterEb", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::setInfoBasedOnIPRegister(bool)"},
    {"_ZN9libunwind17LocalAddressSpace16findFunctionNameEyPcmPy", "libunwind::LocalAddressSpace::findFunctionName(unsigned long long, char*, unsigned long, unsigned long long*)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE15getFunctionNameEPcmPy", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getFunctionName(char*, unsigned long, unsigned long long*)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE6jumptoEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::jumpto()"},
    {"_ZN9libunwind22CompactUnwinder_x86_64INS_17LocalAddressSpaceEE32stepWithCompactEncodingFramelessEjyRS1_RNS_16Registers_x86_64Eb", "libunwind::CompactUnwinder_x86_64<libunwind::LocalAddressSpace>::stepWithCompactEncodingFrameless(unsigned int, unsigned long long, libunwind::LocalAddressSpace&, libunwind::Registers_x86_64&, bool)"},
    {"_ZN9libunwind22CompactUnwinder_x86_64INS_17LocalAddressSpaceEE31stepWithCompactEncodingRBPFrameEjyRS1_RNS_16Registers_x86_64E", "libunwind::CompactUnwinder_x86_64<libunwind::LocalAddressSpace>::stepWithCompactEncodingRBPFrame(unsigned int, unsigned long long, libunwind::LocalAddressSpace&, libunwind::Registers_x86_64&)"},
    {"_ZN9libunwind22CompactUnwinder_x86_64INS_17LocalAddressSpaceEE23stepWithCompactEncodingEjyRS1_RNS_16Registers_x86_64E", "libunwind::CompactUnwinder_x86_64<libunwind::LocalAddressSpace>::stepWithCompactEncoding(unsigned int, unsigned long long, libunwind::LocalAddressSpace&, libunwind::Registers_x86_64&)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE23stepWithCompactEncodingEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::stepWithCompactEncoding()"},
    {"_ZN9libunwind16Registers_x86_6411setRegisterEiy", "libunwind::Registers_x86_64::setRegister(int, unsigned long long)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE6setRegEiy", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::setReg(int, unsigned long long)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE6getRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getReg(int)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EED1Ev", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::~UnwindCursor()"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE4stepEv", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::step()"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE11setFloatRegEid", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::setFloatReg(int, double)"},
    {"_ZN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EE11getFloatRegEi", "libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>::getFloatReg(int)"},
    {"_ZN9libunwind16Registers_x86_646jumptoEv", "libunwind::Registers_x86_64::jumpto()"},
    {"_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"},
    {"_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"},
    {"_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"},
    {"_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"},
    {"_Z41__static_initialization_and_destruction_0ii", "__static_initialization_and_destruction_0(int, int)"},
    {"_ZZ34dyld_image_path_containing_addressE8__func__", "dyld_image_path_containing_address::__func__"},
    {"_ZZ40dyld_register_image_state_change_handlerE8__func__", "dyld_register_image_state_change_handler::__func__"},
    {"_ZZ5dlsymE8__func__", "dlsym::__func__"},
    {"_ZZ7dlerrorE8__func__", "dlerror::__func__"},
    {"_ZZ6dladdrE8__func__", "dladdr::__func__"},
    {"_ZZ7dlcloseE8__func__", "dlclose::__func__"},
    {"_ZZ6dlopenE8__func__", "dlopen::__func__"},
    {"_ZZ16dlopen_preflightE8__func__", "dlopen_preflight::__func__"},
    {"_ZZ23_dyld_launched_preboundE8__func__", "_dyld_launched_prebound::__func__"},
    {"_ZZ14NSUnLinkModuleE8__func__", "NSUnLinkModule::__func__"},
    {"_ZZ22NSLibraryNameForModuleE8__func__", "NSLibraryNameForModule::__func__"},
    {"_ZZ14NSNameOfModuleE8__func__", "NSNameOfModule::__func__"},
    {"_ZZ22NSLookupSymbolInModuleE8__func__", "NSLookupSymbolInModule::__func__"},
    {"_ZZ12NSLinkModuleE8__func__", "NSLinkModule::__func__"},
    {"_ZZ34NSIsSymbolDefinedInObjectFileImageE8__func__", "NSIsSymbolDefinedInObjectFileImage::__func__"},
    {"_ZZ33NSGetSectionDataInObjectFileImageE8__func__", "NSGetSectionDataInObjectFileImage::__func__"},
    {"_ZZ38NSSymbolReferenceNameInObjectFileImageE8__func__", "NSSymbolReferenceNameInObjectFileImage::__func__"},
    {"_ZZ39NSSymbolReferenceCountInObjectFileImageE8__func__", "NSSymbolReferenceCountInObjectFileImage::__func__"},
    {"_ZZ39NSSymbolDefinitionNameInObjectFileImageE8__func__", "NSSymbolDefinitionNameInObjectFileImage::__func__"},
    {"_ZZ40NSSymbolDefinitionCountInObjectFileImageE8__func__", "NSSymbolDefinitionCountInObjectFileImage::__func__"},
    {"_ZZ27NSHasModInitObjectFileImageE8__func__", "NSHasModInitObjectFileImage::__func__"},
    {"_ZZ24NSDestroyObjectFileImageE8__func__", "NSDestroyObjectFileImage::__func__"},
    {"_ZZ33NSCreateObjectFileImageFromMemoryE8__func__", "NSCreateObjectFileImageFromMemory::__func__"},
    {"_ZZ31NSCreateObjectFileImageFromFileE8__func__", "NSCreateObjectFileImageFromFile::__func__"},
    {"_ZZ30_dyld_image_containing_addressE8__func__", "_dyld_image_containing_address::__func__"},
    {"_ZZ41_dyld_bind_fully_image_containing_addressE8__func__", "_dyld_bind_fully_image_containing_address::__func__"},
    {"_ZZ22_dyld_bind_objc_moduleE8__func__", "_dyld_bind_objc_module::__func__"},
    {"_ZZ35_dyld_all_twolevel_modules_preboundE8__func__", "_dyld_all_twolevel_modules_prebound::__func__"},
    {"_ZZ17NSModuleForSymbolE8__func__", "NSModuleForSymbol::__func__"},
    {"_ZZ17NSAddressOfSymbolE8__func__", "NSAddressOfSymbol::__func__"},
    {"_ZZ14NSNameOfSymbolE8__func__", "NSNameOfSymbol::__func__"},
    {"_ZZ29NSIsSymbolNameDefinedWithHintE8__func__", "NSIsSymbolNameDefinedWithHint::__func__"},
    {"_ZZ21NSLookupSymbolInImageE8__func__", "NSLookupSymbolInImage::__func__"},
    {"_ZZ28NSIsSymbolNameDefinedInImageE8__func__", "NSIsSymbolNameDefinedInImage::__func__"},
    {"_ZZ25NSAddLibraryWithSearchingE8__func__", "NSAddLibraryWithSearching::__func__"},
    {"_ZZ12NSAddLibraryE8__func__", "NSAddLibrary::__func__"},
    {"_ZZ10NSAddImageE8__func__", "NSAddImage::__func__"},
    {"_ZZ29NSLookupAndBindSymbolWithHintE8__func__", "NSLookupAndBindSymbolWithHint::__func__"},
    {"_ZZ21NSLookupAndBindSymbolE8__func__", "NSLookupAndBindSymbol::__func__"},
    {"_ZZ31_dyld_lookup_and_bind_with_hintE8__func__", "_dyld_lookup_and_bind_with_hint::__func__"},
    {"_ZZ27_dyld_lookup_and_bind_fullyE8__func__", "_dyld_lookup_and_bind_fully::__func__"},
    {"_ZZ36_dyld_register_func_for_remove_imageE8__func__", "_dyld_register_func_for_remove_image::__func__"},
    {"_ZZ33_dyld_register_func_for_add_imageE8__func__", "_dyld_register_func_for_add_image::__func__"},
    {"_ZZ41_dyld_get_image_header_containing_addressE8__func__", "_dyld_get_image_header_containing_address::__func__"},
    {"_ZZ20_dyld_get_image_nameE8__func__", "_dyld_get_image_name::__func__"},
    {"_ZZ21_dyld_get_image_slideE8__func__", "_dyld_get_image_slide::__func__"},
    {"_ZZ28_dyld_get_image_vmaddr_slideE8__func__", "_dyld_get_image_vmaddr_slide::__func__"},
    {"_ZZ22_dyld_get_image_headerE8__func__", "_dyld_get_image_header::__func__"},
    {"_ZZ17_dyld_image_countE8__func__", "_dyld_image_count::__func__"},
    {"_ZZ20_NSGetExecutablePathE8__func__", "_NSGetExecutablePath::__func__"},
    {"_ZTSSt11logic_error", "typeinfo name for std::logic_error"},
    {"_ZTSSt13bad_exception", "typeinfo name for std::bad_exception"},
    {"_ZTSSt9exception", "typeinfo name for std::exception"},
    {"_ZTSSt9bad_alloc", "typeinfo name for std::bad_alloc"},
    {"_ZTSN10__cxxabiv120__si_class_type_infoE", "typeinfo name for __cxxabiv1::__si_class_type_info"},
    {"_ZTSN10__cxxabiv117__class_type_infoE", "typeinfo name for __cxxabiv1::__class_type_info"},
    {"_ZTSSt9type_info", "typeinfo name for std::type_info"},
    {"_ZTSPKc", "typeinfo name for char const*"},
    {"_ZTSPc", "typeinfo name for char*"},
    {"_ZTSc", "typeinfo name for char"},
    {"_ZTSv", "typeinfo name for void"},
    {"_ZTSN10__cxxabiv119__pointer_type_infoE", "typeinfo name for __cxxabiv1::__pointer_type_info"},
    {"_ZTSN10__cxxabiv117__pbase_type_infoE", "typeinfo name for __cxxabiv1::__pbase_type_info"},
    {"_ZTSN10__cxxabiv123__fundamental_type_infoE", "typeinfo name for __cxxabiv1::__fundamental_type_info"},
    {"_ZTSSt12length_error", "typeinfo name for std::length_error"},
    {"_ZTSN9__gnu_cxx24__concurrence_lock_errorE", "typeinfo name for __gnu_cxx::__concurrence_lock_error"},
    {"_ZTSN9__gnu_cxx26__concurrence_unlock_errorE", "typeinfo name for __gnu_cxx::__concurrence_unlock_error"},
    {"_ZTV11ImageLoader", "vtable for ImageLoader"},
    {"_ZTV16ImageLoaderMachO", "vtable for ImageLoaderMachO"},
    {"_ZTV23ImageLoaderMachOClassic", "vtable for ImageLoaderMachOClassic"},
    {"_ZTV26ImageLoaderMachOCompressed", "vtable for ImageLoaderMachOCompressed"},
    {"_ZTISt12length_error", "typeinfo for std::length_error"},
    {"_ZTVSt12length_error", "vtable for std::length_error"},
    {"_ZTVSt11logic_error", "vtable for std::logic_error"},
    {"_ZTISt11logic_error", "typeinfo for std::logic_error"},
    {"_ZTIN9__gnu_cxx24__concurrence_lock_errorE", "typeinfo for __gnu_cxx::__concurrence_lock_error"},
    {"_ZTVN9__gnu_cxx24__concurrence_lock_errorE", "vtable for __gnu_cxx::__concurrence_lock_error"},
    {"_ZTIN9__gnu_cxx26__concurrence_unlock_errorE", "typeinfo for __gnu_cxx::__concurrence_unlock_error"},
    {"_ZTVN9__gnu_cxx26__concurrence_unlock_errorE", "vtable for __gnu_cxx::__concurrence_unlock_error"},
    {"_ZTVSt13bad_exception", "vtable for std::bad_exception"},
    {"_ZTVSt9exception", "vtable for std::exception"},
    {"_ZTISt13bad_exception", "typeinfo for std::bad_exception"},
    {"_ZTISt9exception", "typeinfo for std::exception"},
    {"_ZTVSt9bad_alloc", "vtable for std::bad_alloc"},
    {"_ZTISt9bad_alloc", "typeinfo for std::bad_alloc"},
    {"_ZTVN10__cxxabiv120__si_class_type_infoE", "vtable for __cxxabiv1::__si_class_type_info"},
    {"_ZTVN10__cxxabiv117__class_type_infoE", "vtable for __cxxabiv1::__class_type_info"},
    {"_ZTVSt9type_info", "vtable for std::type_info"},
    {"_ZTIN10__cxxabiv120__si_class_type_infoE", "typeinfo for __cxxabiv1::__si_class_type_info"},
    {"_ZTIN10__cxxabiv117__class_type_infoE", "typeinfo for __cxxabiv1::__class_type_info"},
    {"_ZTISt9type_info", "typeinfo for std::type_info"},
    {"_ZTVN10__cxxabiv119__pointer_type_infoE", "vtable for __cxxabiv1::__pointer_type_info"},
    {"_ZTVN10__cxxabiv117__pbase_type_infoE", "vtable for __cxxabiv1::__pbase_type_info"},
    {"_ZTVN10__cxxabiv123__fundamental_type_infoE", "vtable for __cxxabiv1::__fundamental_type_info"},
    {"_ZTIPKc", "typeinfo for char const*"},
    {"_ZTIPc", "typeinfo for char*"},
    {"_ZTIc", "typeinfo for char"},
    {"_ZTIv", "typeinfo for void"},
    {"_ZTIN10__cxxabiv119__pointer_type_infoE", "typeinfo for __cxxabiv1::__pointer_type_info"},
    {"_ZTIN10__cxxabiv117__pbase_type_infoE", "typeinfo for __cxxabiv1::__pbase_type_info"},
    {"_ZTIN10__cxxabiv123__fundamental_type_infoE", "typeinfo for __cxxabiv1::__fundamental_type_info"},
    {"_ZTVN9libunwind12UnwindCursorINS_17LocalAddressSpaceENS_16Registers_x86_64EEE", "vtable for libunwind::UnwindCursor<libunwind::LocalAddressSpace, libunwind::Registers_x86_64>"},
    {"_ZN4dyld8gLogAPIsE", "dyld::gLogAPIs"},
    {"_ZN4dyld17gLibSystemHelpersE", "dyld::gLibSystemHelpers"},
    {"_ZN10__cxxabiv119__terminate_handlerE", "__cxxabiv1::__terminate_handler"},
    {"_ZN10__cxxabiv120__unexpected_handlerE", "__cxxabiv1::__unexpected_handler"},
    {"_ZN11ImageLoader27fgImagesUsedFromSharedCacheE", "ImageLoader::fgImagesUsedFromSharedCache"},
    {"_ZN11ImageLoader26fgImagesWithUsedPrebindingE", "ImageLoader::fgImagesWithUsedPrebinding"},
    {"_ZN11ImageLoader25fgImagesRequiringNoFixupsE", "ImageLoader::fgImagesRequiringNoFixups"},
    {"_ZN11ImageLoader27fgImagesRequiringCoalescingE", "ImageLoader::fgImagesRequiringCoalescing"},
    {"_ZN11ImageLoader26fgImagesHasWeakDefinitionsE", "ImageLoader::fgImagesHasWeakDefinitions"},
    {"_ZN11ImageLoader19fgTotalRebaseFixupsE", "ImageLoader::fgTotalRebaseFixups"},
    {"_ZN11ImageLoader17fgTotalBindFixupsE", "ImageLoader::fgTotalBindFixups"},
    {"_ZN11ImageLoader26fgTotalBindSymbolsResolvedE", "ImageLoader::fgTotalBindSymbolsResolved"},
    {"_ZN11ImageLoader24fgTotalBindImageSearchesE", "ImageLoader::fgTotalBindImageSearches"},
    {"_ZN11ImageLoader21fgTotalLazyBindFixupsE", "ImageLoader::fgTotalLazyBindFixups"},
    {"_ZN11ImageLoader29fgTotalPossibleLazyBindFixupsE", "ImageLoader::fgTotalPossibleLazyBindFixups"},
    {"_ZN11ImageLoader21fgTotalSegmentsMappedE", "ImageLoader::fgTotalSegmentsMapped"},
    {"_ZN11ImageLoader18fgTotalBytesMappedE", "ImageLoader::fgTotalBytesMapped"},
    {"_ZN11ImageLoader22fgTotalBytesPreFetchedE", "ImageLoader::fgTotalBytesPreFetched"},
    {"_ZN11ImageLoader21fgNextPIEDylibAddressE", "ImageLoader::fgNextPIEDylibAddress"},
    {"_ZN16ImageLoaderMachO26fgSymbolTableBinarySearchsE", "ImageLoaderMachO::fgSymbolTableBinarySearchs"},
    {"_ZN16ImageLoaderMachO19fgSymbolTrieSearchsE", "ImageLoaderMachO::fgSymbolTrieSearchs"},
    {"_ZN4dyld12gLinkContextE", "dyld::gLinkContext"},
    {"_ZN11ImageLoader24fgTotalLoadLibrariesTimeE", "ImageLoader::fgTotalLoadLibrariesTime"},
    {"_ZN11ImageLoader17fgTotalRebaseTimeE", "ImageLoader::fgTotalRebaseTime"},
    {"_ZN11ImageLoader15fgTotalBindTimeE", "ImageLoader::fgTotalBindTime"},
    {"_ZN11ImageLoader19fgTotalWeakBindTimeE", "ImageLoader::fgTotalWeakBindTime"},
    {"_ZN11ImageLoader10fgTotalDOFE", "ImageLoader::fgTotalDOF"},
    {"_ZN11ImageLoader15fgTotalInitTimeE", "ImageLoader::fgTotalInitTime"},
    {"_ZN11ImageLoader23fgDynamicImageReExportsE", "ImageLoader::fgDynamicImageReExports"},
    {"_ZN11ImageLoader19fgInterposingTuplesE", "ImageLoader::fgInterposingTuples"},
    {"_ZNSs4_Rep20_S_empty_rep_storageE", "std::string::_Rep::_S_empty_rep_storage"},
    {"_ZZN23ImageLoaderMachOClassic26bindIndirectSymbolPointersERKN11ImageLoader11LinkContextEbbE13alreadyWarned", "ImageLoaderMachOClassic::bindIndirectSymbolPointers(ImageLoader::LinkContext const&, bool, bool)::alreadyWarned"},
    {"_ZN12_GLOBAL__N_115emergency_mutexE", "(anonymous namespace)::emergency_mutex"},

    // clang

    {"_ZN4llvm8DenseMapIjcNS_12DenseMapInfoIjEENS1_IcEEE6insertERKSt4pairIjcE", "llvm::DenseMap<unsigned int, char, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<char> >::insert(std::pair<unsigned int, char> const&)"},
    {"_ZN4llvm8DenseMapIjcNS_12DenseMapInfoIjEENS1_IcEEE16InsertIntoBucketERKjRKcPSt4pairIjcE", "llvm::DenseMap<unsigned int, char, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<char> >::InsertIntoBucket(unsigned int const&, char const&, std::pair<unsigned int, char>*)"},
    {"_ZN4llvm8DenseMapIjcNS_12DenseMapInfoIjEENS1_IcEEE4growEj", "llvm::DenseMap<unsigned int, char, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<char> >::grow(unsigned int)"},
    {"_ZN4llvm19MachinePassRegistry3AddEPNS_23MachinePassRegistryNodeE", "llvm::MachinePassRegistry::Add(llvm::MachinePassRegistryNode*)"},
    {"_ZN4llvm2cl6valuesIiEENS0_11ValuesClassIT_EEPKcS3_S6_z", "llvm::cl::ValuesClass<int> llvm::cl::values<int>(char const*, int, char const*, ...)"},
    {"_ZN4llvm2cl11ValuesClassIiEC2EPKciS4_P13__va_list_tag", "llvm::cl::ValuesClass<int>::ValuesClass(char const*, int, char const*, __va_list_tag*)"},
    {"_ZN4llvm24PassRegistrationListenerC2Ev", "llvm::PassRegistrationListener::PassRegistrationListener()"},
    {"_ZN4llvm24PassRegistrationListener15enumeratePassesEv", "llvm::PassRegistrationListener::enumeratePasses()"},
    {"_ZN4llvm12PassRegistry15getPassRegistryEv", "llvm::PassRegistry::getPassRegistry()"},
    {"_ZNK4llvm12PassRegistry7getImplEv", "llvm::PassRegistry::getImpl() const"},
    {"_ZN4llvm12PassRegistry13enumerateWithEPNS_24PassRegistrationListenerE", "llvm::PassRegistry::enumerateWith(llvm::PassRegistrationListener*)"},
    {"_ZN4llvm12PassRegistry23addRegistrationListenerEPNS_24PassRegistrationListenerE", "llvm::PassRegistry::addRegistrationListener(llvm::PassRegistrationListener*)"},
    {"_ZNSt6vectorIPN4llvm24PassRegistrationListenerESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<llvm::PassRegistrationListener*, std::allocator<llvm::PassRegistrationListener*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<llvm::PassRegistrationListener**, std::vector<llvm::PassRegistrationListener*, std::allocator<llvm::PassRegistrationListener*> > >, llvm::PassRegistrationListener* const&)"},
    {"_ZN4llvm3sys11MemoryFenceEv", "llvm::sys::MemoryFence()"},
    {"_ZN4llvm2cl6Option11addArgumentEv", "llvm::cl::Option::addArgument()"},
    {"_ZN4llvm2cl18MarkOptionsChangedEv", "llvm::cl::MarkOptionsChanged()"},
    {"_ZNK4llvm17ManagedStaticBase21RegisterManagedStaticEPFPvvEPFvS1_E", "llvm::ManagedStaticBase::RegisterManagedStatic(void* (*)(), void (*)(void*)) const"},
    {"_ZN4llvm3sys9MutexImplC2Eb", "llvm::sys::MutexImpl::MutexImpl(bool)"},
    {"_ZN4llvm3sys9MutexImpl7acquireEv", "llvm::sys::MutexImpl::acquire()"},
    {"_ZN4llvm3sys9MutexImpl7releaseEv", "llvm::sys::MutexImpl::release()"},
    {"_ZN4llvm15SmallVectorBase8grow_podEmm", "llvm::SmallVectorBase::grow_pod(unsigned long, unsigned long)"},
    {"_ZN4llvm3sys15ThreadLocalImplC2Ev", "llvm::sys::ThreadLocalImpl::ThreadLocalImpl()"},
    {"_ZN4llvm21llvm_is_multithreadedEv", "llvm::llvm_is_multithreaded()"},
    {"_ZN4llvm24llvm_acquire_global_lockEv", "llvm::llvm_acquire_global_lock()"},
    {"_ZN4llvm24llvm_release_global_lockEv", "llvm::llvm_release_global_lock()"},
    {"_ZN4llvm15system_categoryEv", "llvm::system_category()"},
    {"_Z8cc1_mainPPKcS1_S0_Pv", "cc1_main(char const**, char const**, char const*, void*)"},
    {"_Z16LLVMErrorHandlerPvRKSs", "LLVMErrorHandler(void*, std::string const&)"},
    {"_ZNK5clang17DiagnosticBuilder9AddStringEN4llvm9StringRefE", "clang::DiagnosticBuilder::AddString(llvm::StringRef) const"},
    {"_ZNK4llvm18IntrusiveRefCntPtrIN5clang10DiagnosticEE6getPtrEv", "llvm::IntrusiveRefCntPtr<clang::Diagnostic>::getPtr() const"},
    {"_ZN5clang16DiagnosticClient15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::DiagnosticClient::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"},
    {"_ZN5clang16DiagnosticClient13EndSourceFileEv", "clang::DiagnosticClient::EndSourceFile()"},
    {"_ZN5clang18CompilerInvocationD2Ev", "clang::CompilerInvocation::~CompilerInvocation()"},
    {"_ZN5clang14CodeGenOptionsD2Ev", "clang::CodeGenOptions::~CodeGenOptions()"},
    {"_ZN5clang23DependencyOutputOptionsD2Ev", "clang::DependencyOutputOptions::~DependencyOutputOptions()"},
    {"_ZN5clang15FrontendOptionsD2Ev", "clang::FrontendOptions::~FrontendOptions()"},
    {"_ZNSt6vectorIS_ISsSaISsEESaIS1_EED2Ev", "std::vector<std::vector<std::string, std::allocator<std::string> >, std::allocator<std::vector<std::string, std::allocator<std::string> > > >::~vector()"},
    {"_ZN5clang19HeaderSearchOptionsD2Ev", "clang::HeaderSearchOptions::~HeaderSearchOptions()"},
    {"_ZN5clang19PreprocessorOptionsD2Ev", "clang::PreprocessorOptions::~PreprocessorOptions()"},
    {"_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE8_M_eraseEPSt13_Rb_tree_nodeISsE", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_erase(std::_Rb_tree_node<std::string>*)"},
    {"_ZNSt6vectorISt4pairISsSsESaIS1_EED2Ev", "std::vector<std::pair<std::string, std::string>, std::allocator<std::pair<std::string, std::string> > >::~vector()"},
    {"_ZN5clang13TargetOptionsD2Ev", "clang::TargetOptions::~TargetOptions()"},
    {"_ZN5clang18CompilerInvocationC2Ev", "clang::CompilerInvocation::CompilerInvocation()"},
    {"_Z10cc1as_mainPPKcS1_S0_Pv", "cc1as_main(char const**, char const**, char const*, void*)"},
    {"_Z16LLVMErrorHandlerPvRKSs", "LLVMErrorHandler(void*, std::string const&)"},
    {"_ZN4llvm23PrettyStackTraceProgramD1Ev", "llvm::PrettyStackTraceProgram::~PrettyStackTraceProgram()"},
    {"_ZN4llvm23PrettyStackTraceProgramD0Ev", "llvm::PrettyStackTraceProgram::~PrettyStackTraceProgram()"},
    {"_ZN4llvm21formatted_raw_ostream9setStreamERNS_11raw_ostreamEb", "llvm::formatted_raw_ostream::setStream(llvm::raw_ostream&, bool)"},
    {"_ZN4llvm21formatted_raw_ostreamD1Ev", "llvm::formatted_raw_ostream::~formatted_raw_ostream()"},
    {"_ZN4llvm21formatted_raw_ostreamD0Ev", "llvm::formatted_raw_ostream::~formatted_raw_ostream()"},
    {"_ZN4llvm11raw_ostream11changeColorENS0_6ColorsEbb", "llvm::raw_ostream::changeColor(llvm::raw_ostream::Colors, bool, bool)"},
    {"_ZN4llvm11raw_ostream10resetColorEv", "llvm::raw_ostream::resetColor()"},
    {"_ZNK4llvm11raw_ostream12is_displayedEv", "llvm::raw_ostream::is_displayed() const"},
    {"_ZNK4llvm21formatted_raw_ostream11current_posEv", "llvm::formatted_raw_ostream::current_pos() const"},
    {"_ZN4llvm21formatted_raw_ostream13releaseStreamEv", "llvm::formatted_raw_ostream::releaseStream()"},
    {"_ZNSt6vectorISsSaISsEEaSERKS1_", "std::vector<std::string, std::allocator<std::string> >::operator=(std::vector<std::string, std::allocator<std::string> > const&)"},
    {"_ZNSt6vectorIN4llvm9SourceMgr9SrcBufferESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<llvm::SourceMgr::SrcBuffer, std::allocator<llvm::SourceMgr::SrcBuffer> >::_M_insert_aux(__gnu_cxx::__normal_iterator<llvm::SourceMgr::SrcBuffer*, std::vector<llvm::SourceMgr::SrcBuffer, std::allocator<llvm::SourceMgr::SrcBuffer> > >, llvm::SourceMgr::SrcBuffer const&)"},
    {"_ZN4llvm10error_code21unspecified_bool_trueEv", "llvm::error_code::unspecified_bool_true()"},
    {"_Z17GetExecutablePathPKcb", "GetExecutablePath(char const*, bool)"},
    {"_Z17ExpandArgsFromBufPKcRN4llvm15SmallVectorImplIS0_EERSt3setISsSt4lessISsESaISsEE", "ExpandArgsFromBuf(char const*, llvm::SmallVectorImpl<char const*>&, std::set<std::string, std::less<std::string>, std::allocator<std::string> >&)"},
    {"_ZN4llvm15SmallVectorImplIPKcE6insertIN9__gnu_cxx17__normal_iteratorIPS2_St6vectorIS2_SaIS2_EEEEEES7_S7_T_SC_", "char const** llvm::SmallVectorImpl<char const*>::insert<__gnu_cxx::__normal_iterator<char const**, std::vector<char const*, std::allocator<char const*> > > >(char const**, __gnu_cxx::__normal_iterator<char const**, std::vector<char const*, std::allocator<char const*> > >, __gnu_cxx::__normal_iterator<char const**, std::vector<char const*, std::allocator<char const*> > >)"},
    {"_ZNSt6vectorIPKcSaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<char const*, std::allocator<char const*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<char const**, std::vector<char const*, std::allocator<char const*> > >, char const* const&)"},
    {"_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE16_M_insert_uniqueERKSs", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_insert_unique(std::string const&)"},
    {"_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE9_M_insertEPSt18_Rb_tree_node_baseS7_RKSs", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::string const&)"},
    {"_ZN4llvm15SmallVectorImplIPKcE6insertEPS2_RKS2_", "llvm::SmallVectorImpl<char const*>::insert(char const**, char const* const&)"},
    {"_ZN5clang25ExecuteCompilerInvocationEPNS_16CompilerInstanceE", "clang::ExecuteCompilerInvocation(clang::CompilerInstance*)"},
    {"_ZN5clang14FrontendAction21BeginSourceFileActionERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::FrontendAction::BeginSourceFileAction(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang14FrontendAction19EndSourceFileActionEv", "clang::FrontendAction::EndSourceFileAction()"},
    {"_ZNK5clang26PreprocessorFrontendAction20usesPreprocessorOnlyEv", "clang::PreprocessorFrontendAction::usesPreprocessorOnly() const"},
    {"_ZN5clang14FrontendAction27usesCompleteTranslationUnitEv", "clang::FrontendAction::usesCompleteTranslationUnit()"},
    {"_ZNK5clang14FrontendAction13hasPCHSupportEv", "clang::FrontendAction::hasPCHSupport() const"},
    {"_ZNK5clang14FrontendAction17hasASTFileSupportEv", "clang::FrontendAction::hasASTFileSupport() const"},
    {"_ZNK5clang14FrontendAction12hasIRSupportEv", "clang::FrontendAction::hasIRSupport() const"},
    {"_ZNK5clang14FrontendAction24hasCodeCompletionSupportEv", "clang::FrontendAction::hasCodeCompletionSupport() const"},
    {"_ZN5clang26PreprocessorFrontendActionD1Ev", "clang::PreprocessorFrontendAction::~PreprocessorFrontendAction()"},
    {"_ZN5clang26PreprocessorFrontendActionD0Ev", "clang::PreprocessorFrontendAction::~PreprocessorFrontendAction()"},
    {"_ZNK5clang17ASTFrontendAction20usesPreprocessorOnlyEv", "clang::ASTFrontendAction::usesPreprocessorOnly() const"},
    {"_ZN5clang17ASTFrontendActionD1Ev", "clang::ASTFrontendAction::~ASTFrontendAction()"},
    {"_ZN5clang17ASTFrontendActionD0Ev", "clang::ASTFrontendAction::~ASTFrontendAction()"},
    {"_ZNK5clang23PrintPreprocessedAction13hasPCHSupportEv", "clang::PrintPreprocessedAction::hasPCHSupport() const"},
    {"_ZN5clang19PrintPreambleAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::PrintPreambleAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZNK5clang19PrintPreambleAction20usesPreprocessorOnlyEv", "clang::PrintPreambleAction::usesPreprocessorOnly() const"},
    {"_ZN5clang16SyntaxOnlyActionD1Ev", "clang::SyntaxOnlyAction::~SyntaxOnlyAction()"},
    {"_ZN5clang16SyntaxOnlyActionD0Ev", "clang::SyntaxOnlyAction::~SyntaxOnlyAction()"},
    {"_ZNK5clang16SyntaxOnlyAction24hasCodeCompletionSupportEv", "clang::SyntaxOnlyAction::hasCodeCompletionSupport() const"},
    {"_ZNK5clang14InitOnlyAction20usesPreprocessorOnlyEv", "clang::InitOnlyAction::usesPreprocessorOnly() const"},
    {"_ZN5clang17GeneratePCHAction27usesCompleteTranslationUnitEv", "clang::GeneratePCHAction::usesCompleteTranslationUnit()"},
    {"_ZNK5clang17GeneratePCHAction17hasASTFileSupportEv", "clang::GeneratePCHAction::hasASTFileSupport() const"},
    {"_ZN5clang16CreateASTPrinterEPN4llvm11raw_ostreamE", "clang::CreateASTPrinter(llvm::raw_ostream*)"},
    {"_ZN5clang19CreateASTPrinterXMLEPN4llvm11raw_ostreamE", "clang::CreateASTPrinterXML(llvm::raw_ostream*)"},
    {"_ZN5clang15CreateASTDumperEv", "clang::CreateASTDumper()"},
    {"_ZN5clang15CreateASTViewerEv", "clang::CreateASTViewer()"},
    {"_ZN5clang24CreateDeclContextPrinterEv", "clang::CreateDeclContextPrinter()"},
    {"_ZN5clang23CreateInheritanceViewerERKSs", "clang::CreateInheritanceViewer(std::string const&)"},
    {"_ZN5clang18CreateASTDumperXMLERN4llvm11raw_ostreamE", "clang::CreateASTDumperXML(llvm::raw_ostream&)"},
    {"_ZN12_GLOBAL__N_110ASTDumpXMLD1Ev", "(anonymous namespace)::ASTDumpXML::~ASTDumpXML()"},
    {"_ZN12_GLOBAL__N_110ASTDumpXMLD0Ev", "(anonymous namespace)::ASTDumpXML::~ASTDumpXML()"},
    {"_ZN12_GLOBAL__N_110ASTDumpXML21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::ASTDumpXML::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_117InheritanceViewerD1Ev", "(anonymous namespace)::InheritanceViewer::~InheritanceViewer()"},
    {"_ZN12_GLOBAL__N_117InheritanceViewerD0Ev", "(anonymous namespace)::InheritanceViewer::~InheritanceViewer()"},
    {"_ZN12_GLOBAL__N_117InheritanceViewer21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::InheritanceViewer::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_118DeclContextPrinterD1Ev", "(anonymous namespace)::DeclContextPrinter::~DeclContextPrinter()"},
    {"_ZN12_GLOBAL__N_118DeclContextPrinterD0Ev", "(anonymous namespace)::DeclContextPrinter::~DeclContextPrinter()"},
    {"_ZN12_GLOBAL__N_118DeclContextPrinter21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::DeclContextPrinter::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_118DeclContextPrinter16PrintDeclContextEPKN5clang11DeclContextEj", "(anonymous namespace)::DeclContextPrinter::PrintDeclContext(clang::DeclContext const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_19ASTViewerD1Ev", "(anonymous namespace)::ASTViewer::~ASTViewer()"},
    {"_ZN12_GLOBAL__N_19ASTViewerD0Ev", "(anonymous namespace)::ASTViewer::~ASTViewer()"},
    {"_ZN12_GLOBAL__N_19ASTViewer10InitializeERN5clang10ASTContextE", "(anonymous namespace)::ASTViewer::Initialize(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_19ASTViewer18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::ASTViewer::HandleTopLevelDecl(clang::DeclGroupRef)"},
    {"_ZN12_GLOBAL__N_113ASTPrinterXMLD1Ev", "(anonymous namespace)::ASTPrinterXML::~ASTPrinterXML()"},
    {"_ZN12_GLOBAL__N_113ASTPrinterXMLD0Ev", "(anonymous namespace)::ASTPrinterXML::~ASTPrinterXML()"},
    {"_ZN12_GLOBAL__N_113ASTPrinterXML10InitializeERN5clang10ASTContextE", "(anonymous namespace)::ASTPrinterXML::Initialize(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_113ASTPrinterXML21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::ASTPrinterXML::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_110ASTPrinterD1Ev", "(anonymous namespace)::ASTPrinter::~ASTPrinter()"},
    {"_ZN12_GLOBAL__N_110ASTPrinterD0Ev", "(anonymous namespace)::ASTPrinter::~ASTPrinter()"},
    {"_ZN12_GLOBAL__N_110ASTPrinter21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::ASTPrinter::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZNSt5dequeISsSaISsEED2Ev", "std::deque<std::string, std::allocator<std::string> >::~deque()"},
    {"_ZNSt5dequeISsSaISsEE19_M_destroy_data_auxESt15_Deque_iteratorISsRSsPSsES5_", "std::deque<std::string, std::allocator<std::string> >::_M_destroy_data_aux(std::_Deque_iterator<std::string, std::string&, std::string*>, std::_Deque_iterator<std::string, std::string&, std::string*>)"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_jESt10_Select1stIS4_ENS0_16QualTypeOrderingESaIS4_EE8_M_eraseEPSt13_Rb_tree_nodeIS4_E", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, unsigned int>, std::_Select1st<std::pair<clang::QualType const, unsigned int> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::QualType const, unsigned int> >*)"},
    {"_ZN5clang14ASTMergeAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTMergeAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang14ASTMergeAction21BeginSourceFileActionERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTMergeAction::BeginSourceFileAction(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang14ASTMergeAction13ExecuteActionEv", "clang::ASTMergeAction::ExecuteAction()"},
    {"_ZN5clang14ASTMergeAction19EndSourceFileActionEv", "clang::ASTMergeAction::EndSourceFileAction()"},
    {"_ZN5clang14ASTMergeActionC1EPNS_14FrontendActionEPSsj", "clang::ASTMergeAction::ASTMergeAction(clang::FrontendAction*, std::string*, unsigned int)"},
    {"_ZN5clang14ASTMergeActionC2EPNS_14FrontendActionEPSsj", "clang::ASTMergeAction::ASTMergeAction(clang::FrontendAction*, std::string*, unsigned int)"},
    {"_ZN5clang14ASTMergeActionD0Ev", "clang::ASTMergeAction::~ASTMergeAction()"},
    {"_ZN5clang14ASTMergeActionD1Ev", "clang::ASTMergeAction::~ASTMergeAction()"},
    {"_ZN5clang14ASTMergeActionD2Ev", "clang::ASTMergeAction::~ASTMergeAction()"},
    {"_ZNK5clang14ASTMergeAction20usesPreprocessorOnlyEv", "clang::ASTMergeAction::usesPreprocessorOnly() const"},
    {"_ZN5clang14ASTMergeAction27usesCompleteTranslationUnitEv", "clang::ASTMergeAction::usesCompleteTranslationUnit()"},
    {"_ZNK5clang14ASTMergeAction13hasPCHSupportEv", "clang::ASTMergeAction::hasPCHSupport() const"},
    {"_ZNK5clang14ASTMergeAction17hasASTFileSupportEv", "clang::ASTMergeAction::hasASTFileSupport() const"},
    {"_ZNK5clang14ASTMergeAction24hasCodeCompletionSupportEv", "clang::ASTMergeAction::hasCodeCompletionSupport() const"},
    {"_ZN5clang7ASTUnitC1Eb", "clang::ASTUnit::ASTUnit(bool)"},
    {"_ZN5clang7ASTUnitC2Eb", "clang::ASTUnit::ASTUnit(bool)"},
    {"_ZN5clang7ASTUnitC3Eb", "clang::ASTUnit::ASTUnit(bool)"},
    {"_ZN5clang7ASTUnitC4Eb", "clang::ASTUnit::ASTUnit(bool)"},
    {"_ZN5clang7ASTUnitC5Eb", "clang::ASTUnit::ASTUnit(bool)"},
    {"_ZN5clang7ASTUnitD0Ev", "clang::ASTUnit::~ASTUnit()"},
    {"_ZN5clang7ASTUnitD1Ev", "clang::ASTUnit::~ASTUnit()"},
    {"_ZN5clang7ASTUnitD2Ev", "clang::ASTUnit::~ASTUnit()"},
    {"_ZN5clang7ASTUnitD4Ev", "clang::ASTUnit::~ASTUnit()"},
    {"_ZN5clang7ASTUnitD5Ev", "clang::ASTUnit::~ASTUnit()"},
    {"_ZN5clang7ASTUnit19CleanTemporaryFilesEv", "clang::ASTUnit::CleanTemporaryFiles()"},
    {"_ZN5clang7ASTUnit28ClearCachedCompletionResultsEv", "clang::ASTUnit::ClearCachedCompletionResults()"},
    {"_ZN5clang7ASTUnit26CacheCodeCompletionResultsEv", "clang::ASTUnit::CacheCodeCompletionResults()"},
    {"_ZNK5clang7ASTUnit15getMainFileNameEv", "clang::ASTUnit::getMainFileName() const"},
    {"_ZN12_GLOBAL__N_111SimpleTimerD1Ev", "(anonymous namespace)::SimpleTimer::~SimpleTimer()"},
    {"_ZN5clang7ASTUnit25getOriginalSourceFileNameEv", "clang::ASTUnit::getOriginalSourceFileName()"},
    {"_ZN5clang7ASTUnit14getASTFileNameEv", "clang::ASTUnit::getASTFileName()"},
    {"_ZN5clang7ASTUnit16getBufferForFileEN4llvm9StringRefEPSs", "clang::ASTUnit::getBufferForFile(llvm::StringRef, std::string*)"},
    {"_ZN5clang7ASTUnit14ConfigureDiagsERN4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEEPPKcS8_RS0_b", "clang::ASTUnit::ConfigureDiags(llvm::IntrusiveRefCntPtr<clang::Diagnostic>&, char const**, char const**, clang::ASTUnit&, bool)"},
    {"_ZN5clang7ASTUnit15LoadFromASTFileERKSsN4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEERKNS_17FileSystemOptionsEbPSt4pairISsPKNS3_12MemoryBufferEEjb", "clang::ASTUnit::LoadFromASTFile(std::string const&, llvm::IntrusiveRefCntPtr<clang::Diagnostic>, clang::FileSystemOptions const&, bool, std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int, bool)"},
    {"_ZN5clang7ASTUnit5ParseEPN4llvm12MemoryBufferE", "clang::ASTUnit::Parse(llvm::MemoryBuffer*)"},
    {"_ZN5clang7ASTUnit15ComputePreambleERNS_18CompilerInvocationEjRb", "clang::ASTUnit::ComputePreamble(clang::CompilerInvocation&, unsigned int, bool&)"},
    {"_ZN5clang7ASTUnit36getMainBufferWithPrecompiledPreambleENS_18CompilerInvocationEbj", "clang::ASTUnit::getMainBufferWithPrecompiledPreamble(clang::CompilerInvocation, bool, unsigned int)"},
    {"_ZN5clang7ASTUnit32RealizeTopLevelDeclsFromPreambleEv", "clang::ASTUnit::RealizeTopLevelDeclsFromPreamble()"},
    {"_ZN5clang7ASTUnit39RealizePreprocessedEntitiesFromPreambleEv", "clang::ASTUnit::RealizePreprocessedEntitiesFromPreamble()"},
    {"_ZN5clang7ASTUnit15pp_entity_beginEv", "clang::ASTUnit::pp_entity_begin()"},
    {"_ZN5clang7ASTUnit13pp_entity_endEv", "clang::ASTUnit::pp_entity_end()"},
    {"_ZNK5clang7ASTUnit14getMaxPCHLevelEv", "clang::ASTUnit::getMaxPCHLevel() const"},
    {"_ZN5clang7ASTUnit26LoadFromCompilerInvocationEb", "clang::ASTUnit::LoadFromCompilerInvocation(bool)"},
    {"_ZN5clang7ASTUnit26LoadFromCompilerInvocationEPNS_18CompilerInvocationEN4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEEbbbbb", "clang::ASTUnit::LoadFromCompilerInvocation(clang::CompilerInvocation*, llvm::IntrusiveRefCntPtr<clang::Diagnostic>, bool, bool, bool, bool, bool)"},
    {"_ZN5clang7ASTUnit19LoadFromCommandLineEPPKcS3_N4llvm18IntrusiveRefCntPtrINS_10DiagnosticEEENS4_9StringRefEbbPSt4pairISsPKNS4_12MemoryBufferEEjbbbbb", "clang::ASTUnit::LoadFromCommandLine(char const**, char const**, llvm::IntrusiveRefCntPtr<clang::Diagnostic>, llvm::StringRef, bool, bool, std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int, bool, bool, bool, bool, bool)"},
    {"_ZN5clang7ASTUnit7ReparseEPSt4pairISsPKN4llvm12MemoryBufferEEj", "clang::ASTUnit::Reparse(std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int)"},
    {"_ZN5clang7ASTUnit12CodeCompleteEN4llvm9StringRefEjjPSt4pairISsPKNS1_12MemoryBufferEEjbbRNS_20CodeCompleteConsumerERNS_10DiagnosticERNS_11LangOptionsERNS_13SourceManagerERNS_11FileManagerERNS1_15SmallVectorImplINS_16StoredDiagnosticEEERNSJ_IS6_EE", "clang::ASTUnit::CodeComplete(llvm::StringRef, unsigned int, unsigned int, std::pair<std::string, llvm::MemoryBuffer const*>*, unsigned int, bool, bool, clang::CodeCompleteConsumer&, clang::Diagnostic&, clang::LangOptions&, clang::SourceManager&, clang::FileManager&, llvm::SmallVectorImpl<clang::StoredDiagnostic>&, llvm::SmallVectorImpl<llvm::MemoryBuffer const*>&)"},
    {"_ZN5clang7ASTUnit4SaveEN4llvm9StringRefE", "clang::ASTUnit::Save(llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumerD1Ev", "(anonymous namespace)::AugmentedCodeCompleteConsumer::~AugmentedCodeCompleteConsumer()"},
    {"_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumerD0Ev", "(anonymous namespace)::AugmentedCodeCompleteConsumer::~AugmentedCodeCompleteConsumer()"},
    {"_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumer26ProcessCodeCompleteResultsERN5clang4SemaENS1_21CodeCompletionContextEPNS1_20CodeCompletionResultEj", "(anonymous namespace)::AugmentedCodeCompleteConsumer::ProcessCodeCompleteResults(clang::Sema&, clang::CodeCompletionContext, clang::CodeCompletionResult*, unsigned int)"},
    {"_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumer25ProcessOverloadCandidatesERN5clang4SemaEjPNS1_20CodeCompleteConsumer17OverloadCandidateEj", "(anonymous namespace)::AugmentedCodeCompleteConsumer::ProcessOverloadCandidates(clang::Sema&, unsigned int, clang::CodeCompleteConsumer::OverloadCandidate*, unsigned int)"},
    {"_ZN12_GLOBAL__N_129AugmentedCodeCompleteConsumer12getAllocatorEv", "(anonymous namespace)::AugmentedCodeCompleteConsumer::getAllocator()"},
    {"_ZN12_GLOBAL__N_122StoredDiagnosticClientD1Ev", "(anonymous namespace)::StoredDiagnosticClient::~StoredDiagnosticClient()"},
    {"_ZN12_GLOBAL__N_122StoredDiagnosticClientD0Ev", "(anonymous namespace)::StoredDiagnosticClient::~StoredDiagnosticClient()"},
    {"_ZN12_GLOBAL__N_122StoredDiagnosticClient16HandleDiagnosticEN5clang10Diagnostic5LevelERKNS1_14DiagnosticInfoE", "(anonymous namespace)::StoredDiagnosticClient::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"},
    {"_ZN12_GLOBAL__N_124PrecompilePreambleAction17CreateASTConsumerERN5clang16CompilerInstanceEN4llvm9StringRefE", "(anonymous namespace)::PrecompilePreambleAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_124PrecompilePreambleActionD1Ev", "(anonymous namespace)::PrecompilePreambleAction::~PrecompilePreambleAction()"},
    {"_ZN12_GLOBAL__N_124PrecompilePreambleActionD0Ev", "(anonymous namespace)::PrecompilePreambleAction::~PrecompilePreambleAction()"},
    {"_ZN12_GLOBAL__N_124PrecompilePreambleAction27usesCompleteTranslationUnitEv", "(anonymous namespace)::PrecompilePreambleAction::usesCompleteTranslationUnit()"},
    {"_ZNK12_GLOBAL__N_124PrecompilePreambleAction17hasASTFileSupportEv", "(anonymous namespace)::PrecompilePreambleAction::hasASTFileSupport() const"},
    {"_ZNK12_GLOBAL__N_124PrecompilePreambleAction24hasCodeCompletionSupportEv", "(anonymous namespace)::PrecompilePreambleAction::hasCodeCompletionSupport() const"},
    {"_ZN12_GLOBAL__N_126PrecompilePreambleConsumerD1Ev", "(anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"},
    {"_ZN12_GLOBAL__N_126PrecompilePreambleConsumerD0Ev", "(anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"},
    {"_ZN12_GLOBAL__N_126PrecompilePreambleConsumer18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::PrecompilePreambleConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"},
    {"_ZN12_GLOBAL__N_126PrecompilePreambleConsumer21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::PrecompilePreambleConsumer::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_126PrecompilePreambleConsumer27GetASTSerializationListenerEv", "(anonymous namespace)::PrecompilePreambleConsumer::GetASTSerializationListener()"},
    {"_ZN12_GLOBAL__N_126PrecompilePreambleConsumer28SerializedPreprocessedEntityEPN5clang18PreprocessedEntityEy", "(anonymous namespace)::PrecompilePreambleConsumer::SerializedPreprocessedEntity(clang::PreprocessedEntity*, unsigned long long)"},
    {"_ZThn1912_N12_GLOBAL__N_126PrecompilePreambleConsumerD1Ev", "non-virtual thunk to (anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"},
    {"_ZThn1912_N12_GLOBAL__N_126PrecompilePreambleConsumerD0Ev", "non-virtual thunk to (anonymous namespace)::PrecompilePreambleConsumer::~PrecompilePreambleConsumer()"},
    {"_ZThn1912_N12_GLOBAL__N_126PrecompilePreambleConsumer28SerializedPreprocessedEntityEPN5clang18PreprocessedEntityEy", "non-virtual thunk to (anonymous namespace)::PrecompilePreambleConsumer::SerializedPreprocessedEntity(clang::PreprocessedEntity*, unsigned long long)"},
    {"_ZN12_GLOBAL__N_125TopLevelDeclTrackerAction17CreateASTConsumerERN5clang16CompilerInstanceEN4llvm9StringRefE", "(anonymous namespace)::TopLevelDeclTrackerAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_125TopLevelDeclTrackerActionD1Ev", "(anonymous namespace)::TopLevelDeclTrackerAction::~TopLevelDeclTrackerAction()"},
    {"_ZN12_GLOBAL__N_125TopLevelDeclTrackerActionD0Ev", "(anonymous namespace)::TopLevelDeclTrackerAction::~TopLevelDeclTrackerAction()"},
    {"_ZN12_GLOBAL__N_125TopLevelDeclTrackerAction27usesCompleteTranslationUnitEv", "(anonymous namespace)::TopLevelDeclTrackerAction::usesCompleteTranslationUnit()"},
    {"_ZNK12_GLOBAL__N_125TopLevelDeclTrackerAction24hasCodeCompletionSupportEv", "(anonymous namespace)::TopLevelDeclTrackerAction::hasCodeCompletionSupport() const"},
    {"_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumerD1Ev", "(anonymous namespace)::TopLevelDeclTrackerConsumer::~TopLevelDeclTrackerConsumer()"},
    {"_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumerD0Ev", "(anonymous namespace)::TopLevelDeclTrackerConsumer::~TopLevelDeclTrackerConsumer()"},
    {"_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumer18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::TopLevelDeclTrackerConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"},
    {"_ZN12_GLOBAL__N_127TopLevelDeclTrackerConsumer21HandleInterestingDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::TopLevelDeclTrackerConsumer::HandleInterestingDecl(clang::DeclGroupRef)"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollectorD1Ev", "(anonymous namespace)::ASTInfoCollector::~ASTInfoCollector()"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollectorD0Ev", "(anonymous namespace)::ASTInfoCollector::~ASTInfoCollector()"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollector19ReadLanguageOptionsERKN5clang11LangOptionsE", "(anonymous namespace)::ASTInfoCollector::ReadLanguageOptions(clang::LangOptions const&)"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollector16ReadTargetTripleEN4llvm9StringRefE", "(anonymous namespace)::ASTInfoCollector::ReadTargetTriple(llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollector20ReadPredefinesBufferERKN4llvm11SmallVectorIN5clang18PCHPredefinesBlockELj2EEENS1_9StringRefERSs", "(anonymous namespace)::ASTInfoCollector::ReadPredefinesBuffer(llvm::SmallVector<clang::PCHPredefinesBlock, 2u> const&, llvm::StringRef, std::string&)"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollector18ReadHeaderFileInfoERKN5clang14HeaderFileInfoEj", "(anonymous namespace)::ASTInfoCollector::ReadHeaderFileInfo(clang::HeaderFileInfo const&, unsigned int)"},
    {"_ZN12_GLOBAL__N_116ASTInfoCollector11ReadCounterEj", "(anonymous namespace)::ASTInfoCollector::ReadCounter(unsigned int)"},
    {"_ZN5clang19PreprocessorOptions15addRemappedFileEN4llvm9StringRefEPKNS1_12MemoryBufferE", "clang::PreprocessorOptions::addRemappedFile(llvm::StringRef, llvm::MemoryBuffer const*)"},
    {"_ZN4llvm15SmallVectorImplIPKcE6insertIPS2_EES5_S5_T_S6_", "char const** llvm::SmallVectorImpl<char const*>::insert<char const**>(char const**, char const**, char const**)"},
    {"_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE4swapERS3_", "llvm::SmallVectorImpl<clang::StoredDiagnostic>::swap(llvm::SmallVectorImpl<clang::StoredDiagnostic>&)"},
    {"_ZN5clang11LangOptionsaSERKS0_", "clang::LangOptions::operator=(clang::LangOptions const&)"},
    {"_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE6insertIPS2_EES5_S5_T_S6_", "clang::StoredDiagnostic* llvm::SmallVectorImpl<clang::StoredDiagnostic>::insert<clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"},
    {"_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE9push_backERKS2_", "llvm::SmallVectorImpl<clang::StoredDiagnostic>::push_back(clang::StoredDiagnostic const&)"},
    {"_ZN5clang9ASTWriterD1Ev", "clang::ASTWriter::~ASTWriter()"},
    {"_ZN4llvm15SmallVectorImplIN5clang16StoredDiagnosticEE6appendIPS2_EEvT_S6_", "void llvm::SmallVectorImpl<clang::StoredDiagnostic>::append<clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang16StoredDiagnosticELb0EE18uninitialized_copyIPS2_S5_EEvT_S6_T0_", "void llvm::SmallVectorTemplateBase<clang::StoredDiagnostic, false>::uninitialized_copy<clang::StoredDiagnostic*, clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"},
    {"_ZNSt6vectorIN5clang15CharSourceRangeESaIS1_EEaSERKS3_", "std::vector<clang::CharSourceRange, std::allocator<clang::CharSourceRange> >::operator=(std::vector<clang::CharSourceRange, std::allocator<clang::CharSourceRange> > const&)"},
    {"_ZNSt6vectorIN5clang9FixItHintESaIS1_EEaSERKS3_", "std::vector<clang::FixItHint, std::allocator<clang::FixItHint> >::operator=(std::vector<clang::FixItHint, std::allocator<clang::FixItHint> > const&)"},
    {"_ZNSt6vectorIN5clang9FixItHintESaIS1_EEC2ERKS3_", "std::vector<clang::FixItHint, std::allocator<clang::FixItHint> >::vector(std::vector<clang::FixItHint, std::allocator<clang::FixItHint> > const&)"},
    {"_ZNSt6vectorIN5clang15CharSourceRangeESaIS1_EEC2ERKS3_", "std::vector<clang::CharSourceRange, std::allocator<clang::CharSourceRange> >::vector(std::vector<clang::CharSourceRange, std::allocator<clang::CharSourceRange> > const&)"},
    {"_ZNSt6__copyILb0ESt26random_access_iterator_tagE4copyIPN5clang16StoredDiagnosticES5_EET0_T_S7_S6_", "clang::StoredDiagnostic* std::__copy<false, std::random_access_iterator_tag>::copy<clang::StoredDiagnostic*, clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"},
    {"_ZNSt15__copy_backwardILb0ESt26random_access_iterator_tagE8__copy_bIPN5clang16StoredDiagnosticES5_EET0_T_S7_S6_", "clang::StoredDiagnostic* std::__copy_backward<false, std::random_access_iterator_tag>::__copy_b<clang::StoredDiagnostic*, clang::StoredDiagnostic*>(clang::StoredDiagnostic*, clang::StoredDiagnostic*, clang::StoredDiagnostic*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang16StoredDiagnosticELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::StoredDiagnostic, false>::grow(unsigned long)"},
    {"_ZNSt6vectorIPN5clang18PreprocessedEntityESaIS2_EE15_M_range_insertIN9__gnu_cxx17__normal_iteratorIPS2_S4_EEEEvS9_T_SA_St20forward_iterator_tag", "void std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> >::_M_range_insert<__gnu_cxx::__normal_iterator<clang::PreprocessedEntity**, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > > >(__gnu_cxx::__normal_iterator<clang::PreprocessedEntity**, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > >, __gnu_cxx::__normal_iterator<clang::PreprocessedEntity**, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > >, __gnu_cxx::__normal_iterator<clang::PreprocessedEntity**, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > >, std::forward_iterator_tag)"},
    {"_ZNSt6vectorIPN5clang18PreprocessedEntityESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::PreprocessedEntity**, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > >, clang::PreprocessedEntity* const&)"},
    {"_ZNSt6vectorIPN5clang4DeclESaIS2_EE15_M_range_insertIN9__gnu_cxx17__normal_iteratorIPS2_S4_EEEEvS9_T_SA_St20forward_iterator_tag", "void std::vector<clang::Decl*, std::allocator<clang::Decl*> >::_M_range_insert<__gnu_cxx::__normal_iterator<clang::Decl**, std::vector<clang::Decl*, std::allocator<clang::Decl*> > > >(__gnu_cxx::__normal_iterator<clang::Decl**, std::vector<clang::Decl*, std::allocator<clang::Decl*> > >, __gnu_cxx::__normal_iterator<clang::Decl**, std::vector<clang::Decl*, std::allocator<clang::Decl*> > >, __gnu_cxx::__normal_iterator<clang::Decl**, std::vector<clang::Decl*, std::allocator<clang::Decl*> > >, std::forward_iterator_tag)"},
    {"_ZN4llvm9StringMapISt4pairIxlENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<std::pair<long long, long> >& llvm::StringMap<std::pair<long long, long>, llvm::MallocAllocator>::GetOrCreateValue<std::pair<long long, long> >(llvm::StringRef, std::pair<long long, long>)"},
    {"_ZNSt8_Rb_treeIN5clang6FileIDESt4pairIKS1_St6vectorIPNS0_18PreprocessedEntityESaIS6_EEESt10_Select1stIS9_ESt4lessIS1_ESaIS9_EE8_M_eraseEPSt13_Rb_tree_nodeIS9_E", "std::_Rb_tree<clang::FileID, std::pair<clang::FileID const, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > >, std::_Select1st<std::pair<clang::FileID const, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > > >, std::less<clang::FileID>, std::allocator<std::pair<clang::FileID const, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > > > >::_M_erase(std::_Rb_tree_node<std::pair<clang::FileID const, std::vector<clang::PreprocessedEntity*, std::allocator<clang::PreprocessedEntity*> > > >*)"},
    {"_ZNSt6vectorIN5clang7ASTUnit26CachedCodeCompletionResultESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::ASTUnit::CachedCodeCompletionResult, std::allocator<clang::ASTUnit::CachedCodeCompletionResult> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::ASTUnit::CachedCodeCompletionResult*, std::vector<clang::ASTUnit::CachedCodeCompletionResult, std::allocator<clang::ASTUnit::CachedCodeCompletionResult> > >, clang::ASTUnit::CachedCodeCompletionResult const&)"},
    {"_ZN4llvm8DenseMapIN5clang7CanQualINS1_4TypeEEEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::CanQual<clang::Type>, unsigned int, llvm::DenseMapInfo<clang::CanQual<clang::Type> >, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::CanQual<clang::Type> const&, unsigned int const&, std::pair<clang::CanQual<clang::Type>, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIN5clang7CanQualINS1_4TypeEEEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::CanQual<clang::Type>, unsigned int, llvm::DenseMapInfo<clang::CanQual<clang::Type> >, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZNSt6vectorIPN5clang4DeclESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::Decl*, std::allocator<clang::Decl*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::Decl**, std::vector<clang::Decl*, std::allocator<clang::Decl*> > >, clang::Decl* const&)"},
    {"_ZN4llvm15BitstreamWriterD2Ev", "llvm::BitstreamWriter::~BitstreamWriter()"},
    {"_ZThn8_N5clang9ASTWriterD1Ev", "non-virtual thunk to clang::ASTWriter::~ASTWriter()"},
    {"_ZN5clang9ASTWriterD2Ev", "clang::ASTWriter::~ASTWriter()"},
    {"_ZN5clang9ASTWriterD0Ev", "clang::ASTWriter::~ASTWriter()"},
    {"_ZThn8_N5clang9ASTWriterD0Ev", "non-virtual thunk to clang::ASTWriter::~ASTWriter()"},
    {"_ZNSt8_Rb_treeIPN5clang10SwitchCaseESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<clang::SwitchCase*, std::pair<clang::SwitchCase* const, unsigned int>, std::_Select1st<std::pair<clang::SwitchCase* const, unsigned int> >, std::less<clang::SwitchCase*>, std::allocator<std::pair<clang::SwitchCase* const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::SwitchCase* const, unsigned int> >*)"},
    {"_ZNSt8_Rb_treeIPN5clang9LabelStmtESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<clang::LabelStmt*, std::pair<clang::LabelStmt* const, unsigned int>, std::_Select1st<std::pair<clang::LabelStmt* const, unsigned int> >, std::less<clang::LabelStmt*>, std::allocator<std::pair<clang::LabelStmt* const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::LabelStmt* const, unsigned int> >*)"},
    {"_ZN4llvm15SmallVectorImplIN5clang20CodeCompletionResultEE6insertIPS2_EES5_S5_T_S6_", "clang::CodeCompletionResult* llvm::SmallVectorImpl<clang::CodeCompletionResult>::insert<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang20CodeCompletionResultELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeCompletionResult, false>::grow(unsigned long)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang20CodeCompletionString5ChunkELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeCompletionString::Chunk, false>::grow(unsigned long)"},
    {"_ZN4llvm9StringSetINS_16BumpPtrAllocatorEE6insertENS_9StringRefE", "llvm::StringSet<llvm::BumpPtrAllocator>::insert(llvm::StringRef)"},
    {"_ZNSt6vectorISt4pairISsSsESaIS1_EE5clearEv", "std::vector<std::pair<std::string, std::string>, std::allocator<std::pair<std::string, std::string> > >::clear()"},
    {"_ZN5clang18CompilerInvocationC2ERKS0_", "clang::CompilerInvocation::CompilerInvocation(clang::CompilerInvocation const&)"},
    {"_ZN5clang19PreprocessorOptionsC2ERKS0_", "clang::PreprocessorOptions::PreprocessorOptions(clang::PreprocessorOptions const&)"},
    {"_ZNSt6vectorISt4pairISsPKN4llvm12MemoryBufferEESaIS5_EEC2ERKS7_", "std::vector<std::pair<std::string, llvm::MemoryBuffer const*>, std::allocator<std::pair<std::string, llvm::MemoryBuffer const*> > >::vector(std::vector<std::pair<std::string, llvm::MemoryBuffer const*>, std::allocator<std::pair<std::string, llvm::MemoryBuffer const*> > > const&)"},
    {"_ZNSt6vectorISt4pairISsSsESaIS1_EEC2ERKS3_", "std::vector<std::pair<std::string, std::string>, std::allocator<std::pair<std::string, std::string> > >::vector(std::vector<std::pair<std::string, std::string>, std::allocator<std::pair<std::string, std::string> > > const&)"},
    {"_ZNSt6vectorISt4pairISsbESaIS1_EEC2ERKS3_", "std::vector<std::pair<std::string, bool>, std::allocator<std::pair<std::string, bool> > >::vector(std::vector<std::pair<std::string, bool>, std::allocator<std::pair<std::string, bool> > > const&)"},
    {"_ZNSt6vectorIN5clang19HeaderSearchOptions5EntryESaIS2_EEC2ERKS4_", "std::vector<clang::HeaderSearchOptions::Entry, std::allocator<clang::HeaderSearchOptions::Entry> >::vector(std::vector<clang::HeaderSearchOptions::Entry, std::allocator<clang::HeaderSearchOptions::Entry> > const&)"},
    {"_ZN5clang15FrontendOptionsC2ERKS0_", "clang::FrontendOptions::FrontendOptions(clang::FrontendOptions const&)"},
    {"_ZNSt6vectorIS_ISsSaISsEESaIS1_EEC2ERKS3_", "std::vector<std::vector<std::string, std::allocator<std::string> >, std::allocator<std::vector<std::string, std::allocator<std::string> > > >::vector(std::vector<std::vector<std::string, std::allocator<std::string> >, std::allocator<std::vector<std::string, std::allocator<std::string> > > > const&)"},
    {"_ZNSt6vectorISt4pairIN5clang9InputKindESsESaIS3_EEC2ERKS5_", "std::vector<std::pair<clang::InputKind, std::string>, std::allocator<std::pair<clang::InputKind, std::string> > >::vector(std::vector<std::pair<clang::InputKind, std::string>, std::allocator<std::pair<clang::InputKind, std::string> > > const&)"},
    {"_ZN5clang17DiagnosticOptionsC2ERKS0_", "clang::DiagnosticOptions::DiagnosticOptions(clang::DiagnosticOptions const&)"},
    {"_ZN5clang14CodeGenOptionsC2ERKS0_", "clang::CodeGenOptions::CodeGenOptions(clang::CodeGenOptions const&)"},
    {"_ZN5clang15AnalyzerOptionsC2ERKS0_", "clang::AnalyzerOptions::AnalyzerOptions(clang::AnalyzerOptions const&)"},
    {"_ZNSt6vectorIN5clang8AnalysesESaIS1_EEC2ERKS3_", "std::vector<clang::Analyses, std::allocator<clang::Analyses> >::vector(std::vector<clang::Analyses, std::allocator<clang::Analyses> > const&)"},
    {"_ZN5clang12PCHGenerator14InitializeSemaERNS_4SemaE", "clang::PCHGenerator::InitializeSema(clang::Sema&)"},
    {"_ZNSt6vectorIySaIyEE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPyS1_EERKy", "std::vector<unsigned long long, std::allocator<unsigned long long> >::_M_insert_aux(__gnu_cxx::__normal_iterator<unsigned long long*, std::vector<unsigned long long, std::allocator<unsigned long long> > >, unsigned long long const&)"},
    {"_ZN5clang12PCHGeneratorD1Ev", "clang::PCHGenerator::~PCHGenerator()"},
    {"_ZN5clang12PCHGeneratorD0Ev", "clang::PCHGenerator::~PCHGenerator()"},
    {"_ZNSt6vectorISt4pairISsPKN4llvm12MemoryBufferEESaIS5_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS5_S7_EERKS5_", "std::vector<std::pair<std::string, llvm::MemoryBuffer const*>, std::allocator<std::pair<std::string, llvm::MemoryBuffer const*> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<std::string, llvm::MemoryBuffer const*>*, std::vector<std::pair<std::string, llvm::MemoryBuffer const*>, std::allocator<std::pair<std::string, llvm::MemoryBuffer const*> > > >, std::pair<std::string, llvm::MemoryBuffer const*> const&)"},
    {"_ZN5clang14BoostConAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::BoostConAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_119BoostConASTConsumerD1Ev", "(anonymous namespace)::BoostConASTConsumer::~BoostConASTConsumer()"},
    {"_ZN12_GLOBAL__N_119BoostConASTConsumerD0Ev", "(anonymous namespace)::BoostConASTConsumer::~BoostConASTConsumer()"},
    {"_ZN12_GLOBAL__N_119BoostConASTConsumer21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::BoostConASTConsumer::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE12TraverseDeclEPNS_4DeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseDecl(clang::Decl*)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE12TraverseStmtEPNS_4StmtE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseStmt(clang::Stmt*)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE15TraverseTypeLocENS_7TypeLocE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseTypeLoc(clang::TypeLoc)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE27TraverseNestedNameSpecifierEPNS_19NestedNameSpecifierE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseNestedNameSpecifier(clang::NestedNameSpecifier*)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE27TraverseTemplateArgumentLocERKNS_19TemplateArgumentLocE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseTemplateArgumentLoc(clang::TemplateArgumentLoc const&)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE24TraverseTemplateArgumentERKNS_16TemplateArgumentE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseTemplateArgument(clang::TemplateArgument const&)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE12TraverseTypeENS_8QualTypeE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseType(clang::QualType)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE24TraverseDeclaratorHelperEPNS_14DeclaratorDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseDeclaratorHelper(clang::DeclaratorDecl*)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE22TraverseFunctionHelperEPNS_12FunctionDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseFunctionHelper(clang::FunctionDecl*)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE23TraverseCXXRecordHelperEPNS_13CXXRecordDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::TraverseCXXRecordHelper(clang::CXXRecordDecl*)"},
    {"_ZN5clang19RecursiveASTVisitorIN12_GLOBAL__N_119BoostConASTConsumerEE23WalkUpFromCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::RecursiveASTVisitor<(anonymous namespace)::BoostConASTConsumer>::WalkUpFromCXXRecordDecl(clang::CXXRecordDecl*)"},
    {"_ZN5clang14BoostConActionD1Ev", "clang::BoostConAction::~BoostConAction()"},
    {"_ZN5clang14BoostConActionD0Ev", "clang::BoostConAction::~BoostConAction()"},
    {"_ZNK5clang38DependentTemplateSpecializationTypeLoc9getArgLocEj", "clang::DependentTemplateSpecializationTypeLoc::getArgLoc(unsigned int) const"},
    {"_ZNK5clang29TemplateSpecializationTypeLoc9getArgLocEj", "clang::TemplateSpecializationTypeLoc::getArgLoc(unsigned int) const"},
    {"_ZN5clang11CacheTokensERNS_12PreprocessorEPN4llvm14raw_fd_ostreamE", "clang::CacheTokens(clang::Preprocessor&, llvm::raw_fd_ostream*)"},
    {"_ZN5clang31OnDiskChainedHashTableGeneratorIN12_GLOBAL__N_121FileEntryPTHEntryInfoEE6insertENS1_18PTHEntryKeyVariantERKNS1_8PTHEntryE", "clang::OnDiskChainedHashTableGenerator<(anonymous namespace)::FileEntryPTHEntryInfo>::insert((anonymous namespace)::PTHEntryKeyVariant, (anonymous namespace)::PTHEntry const&)"},
    {"_ZN12_GLOBAL__N_19PTHWriter9EmitTokenERKN5clang5TokenE", "(anonymous namespace)::PTHWriter::EmitToken(clang::Token const&)"},
    {"_ZN12_GLOBAL__N_112StatListenerD1Ev", "(anonymous namespace)::StatListener::~StatListener()"},
    {"_ZN12_GLOBAL__N_112StatListenerD0Ev", "(anonymous namespace)::StatListener::~StatListener()"},
    {"_ZN12_GLOBAL__N_112StatListener7getStatEPKcR4statPi", "(anonymous namespace)::StatListener::getStat(char const*, stat&, int*)"},
    {"_ZN5clang2io6Emit32ERN4llvm11raw_ostreamEj", "clang::io::Emit32(llvm::raw_ostream&, unsigned int)"},
    {"_ZN5clang2io6Emit64ERN4llvm11raw_ostreamEy", "clang::io::Emit64(llvm::raw_ostream&, unsigned long long)"},
    {"_ZN4llvm8DenseMapIPKN5clang14IdentifierInfoEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::IdentifierInfo const*, unsigned int, llvm::DenseMapInfo<clang::IdentifierInfo const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::IdentifierInfo const* const&, unsigned int const&, std::pair<clang::IdentifierInfo const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang14IdentifierInfoEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::IdentifierInfo const*, unsigned int, llvm::DenseMapInfo<clang::IdentifierInfo const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZN5clang16CompilerInstanceC1Ev", "clang::CompilerInstance::CompilerInstance()"},
    {"_ZN5clang16CompilerInstanceC2Ev", "clang::CompilerInstance::CompilerInstance()"},
    {"_ZN5clang16CompilerInstanceD1Ev", "clang::CompilerInstance::~CompilerInstance()"},
    {"_ZN5clang16CompilerInstanceD2Ev", "clang::CompilerInstance::~CompilerInstance()"},
    {"_ZN5clang16CompilerInstance14setLLVMContextEPN4llvm11LLVMContextE", "clang::CompilerInstance::setLLVMContext(llvm::LLVMContext*)"},
    {"_ZN5clang16CompilerInstance13setInvocationEPNS_18CompilerInvocationE", "clang::CompilerInstance::setInvocation(clang::CompilerInvocation*)"},
    {"_ZN5clang16CompilerInstance14setDiagnosticsEPNS_10DiagnosticE", "clang::CompilerInstance::setDiagnostics(clang::Diagnostic*)"},
    {"_ZN5clang16CompilerInstance9setTargetEPNS_10TargetInfoE", "clang::CompilerInstance::setTarget(clang::TargetInfo*)"},
    {"_ZN5clang16CompilerInstance14setFileManagerEPNS_11FileManagerE", "clang::CompilerInstance::setFileManager(clang::FileManager*)"},
    {"_ZN5clang16CompilerInstance16setSourceManagerEPNS_13SourceManagerE", "clang::CompilerInstance::setSourceManager(clang::SourceManager*)"},
    {"_ZN5clang16CompilerInstance15setPreprocessorEPNS_12PreprocessorE", "clang::CompilerInstance::setPreprocessor(clang::Preprocessor*)"},
    {"_ZN5clang16CompilerInstance13setASTContextEPNS_10ASTContextE", "clang::CompilerInstance::setASTContext(clang::ASTContext*)"},
    {"_ZN5clang16CompilerInstance7setSemaEPNS_4SemaE", "clang::CompilerInstance::setSema(clang::Sema*)"},
    {"_ZN5clang16CompilerInstance14setASTConsumerEPNS_11ASTConsumerE", "clang::CompilerInstance::setASTConsumer(clang::ASTConsumer*)"},
    {"_ZN5clang16CompilerInstance25setCodeCompletionConsumerEPNS_20CodeCompleteConsumerE", "clang::CompilerInstance::setCodeCompletionConsumer(clang::CodeCompleteConsumer*)"},
    {"_ZN5clang16CompilerInstance17createDiagnosticsEiPKPKcPNS_16DiagnosticClientE", "clang::CompilerInstance::createDiagnostics(int, char const* const*, clang::DiagnosticClient*)"},
    {"_ZN5clang16CompilerInstance17createDiagnosticsERKNS_17DiagnosticOptionsEiPKPKcPNS_16DiagnosticClientE", "clang::CompilerInstance::createDiagnostics(clang::DiagnosticOptions const&, int, char const* const*, clang::DiagnosticClient*)"},
    {"_ZN5clang16CompilerInstance17createFileManagerEv", "clang::CompilerInstance::createFileManager()"},
    {"_ZN5clang16CompilerInstance19createSourceManagerERNS_11FileManagerE", "clang::CompilerInstance::createSourceManager(clang::FileManager&)"},
    {"_ZN5clang16CompilerInstance18createPreprocessorEv", "clang::CompilerInstance::createPreprocessor()"},
    {"_ZN5clang16CompilerInstance18createPreprocessorERNS_10DiagnosticERKNS_11LangOptionsERKNS_19PreprocessorOptionsERKNS_19HeaderSearchOptionsERKNS_23DependencyOutputOptionsERKNS_10TargetInfoERKNS_15FrontendOptionsERNS_13SourceManagerERNS_11FileManagerE", "clang::CompilerInstance::createPreprocessor(clang::Diagnostic&, clang::LangOptions const&, clang::PreprocessorOptions const&, clang::HeaderSearchOptions const&, clang::DependencyOutputOptions const&, clang::TargetInfo const&, clang::FrontendOptions const&, clang::SourceManager&, clang::FileManager&)"},
    {"_ZN5clang16CompilerInstance16createASTContextEv", "clang::CompilerInstance::createASTContext()"},
    {"_ZN5clang16CompilerInstance26createPCHExternalASTSourceEN4llvm9StringRefEbbPv", "clang::CompilerInstance::createPCHExternalASTSource(llvm::StringRef, bool, bool, void*)"},
    {"_ZN5clang16CompilerInstance26createPCHExternalASTSourceEN4llvm9StringRefERKSsbbRNS_12PreprocessorERNS_10ASTContextEPvb", "clang::CompilerInstance::createPCHExternalASTSource(llvm::StringRef, std::string const&, bool, bool, clang::Preprocessor&, clang::ASTContext&, void*, bool)"},
    {"_ZN5clang16CompilerInstance28createCodeCompletionConsumerEv", "clang::CompilerInstance::createCodeCompletionConsumer()"},
    {"_ZN5clang16CompilerInstance28createCodeCompletionConsumerERNS_12PreprocessorERKSsjjbbbRN4llvm11raw_ostreamE", "clang::CompilerInstance::createCodeCompletionConsumer(clang::Preprocessor&, std::string const&, unsigned int, unsigned int, bool, bool, bool, llvm::raw_ostream&)"},
    {"_Z20EnableCodeCompletionRN5clang12PreprocessorERKSsjj", "EnableCodeCompletion(clang::Preprocessor&, std::string const&, unsigned int, unsigned int)"},
    {"_ZN5clang16CompilerInstance19createFrontendTimerEv", "clang::CompilerInstance::createFrontendTimer()"},
    {"_ZN5clang16CompilerInstance10createSemaEbPNS_20CodeCompleteConsumerE", "clang::CompilerInstance::createSema(bool, clang::CodeCompleteConsumer*)"},
    {"_ZN5clang16CompilerInstance13addOutputFileERKNS0_10OutputFileE", "clang::CompilerInstance::addOutputFile(clang::CompilerInstance::OutputFile const&)"},
    {"_ZN5clang16CompilerInstance16clearOutputFilesEb", "clang::CompilerInstance::clearOutputFiles(bool)"},
    {"_ZN5clang16CompilerInstance23createDefaultOutputFileEbN4llvm9StringRefES2_", "clang::CompilerInstance::createDefaultOutputFile(bool, llvm::StringRef, llvm::StringRef)"},
    {"_ZN5clang16CompilerInstance16createOutputFileEN4llvm9StringRefEbbS2_S2_", "clang::CompilerInstance::createOutputFile(llvm::StringRef, bool, bool, llvm::StringRef, llvm::StringRef)"},
    {"_ZN5clang16CompilerInstance16createOutputFileEN4llvm9StringRefERSsbbS2_S2_PSsS4_", "clang::CompilerInstance::createOutputFile(llvm::StringRef, std::string&, bool, bool, llvm::StringRef, llvm::StringRef, std::string*, std::string*)"},
    {"_ZN5clang16CompilerInstance23InitializeSourceManagerEN4llvm9StringRefE", "clang::CompilerInstance::InitializeSourceManager(llvm::StringRef)"},
    {"_ZN5clang16CompilerInstance23InitializeSourceManagerEN4llvm9StringRefERNS_10DiagnosticERNS_11FileManagerERNS_13SourceManagerERKNS_15FrontendOptionsE", "clang::CompilerInstance::InitializeSourceManager(llvm::StringRef, clang::Diagnostic&, clang::FileManager&, clang::SourceManager&, clang::FrontendOptions const&)"},
    {"_ZN5clang16CompilerInstance13ExecuteActionERNS_14FrontendActionE", "clang::CompilerInstance::ExecuteAction(clang::FrontendAction&)"},
    {"_ZNSt10_List_baseIN5clang16CompilerInstance10OutputFileESaIS2_EE8_M_clearEv", "std::_List_base<clang::CompilerInstance::OutputFile, std::allocator<clang::CompilerInstance::OutputFile> >::_M_clear()"},
    {"_ZN5clang28PrintingCodeCompleteConsumer12getAllocatorEv", "clang::PrintingCodeCompleteConsumer::getAllocator()"},
    {"_ZN5clang20CodeCompleteConsumer26ProcessCodeCompleteResultsERNS_4SemaENS_21CodeCompletionContextEPNS_20CodeCompletionResultEj", "clang::CodeCompleteConsumer::ProcessCodeCompleteResults(clang::Sema&, clang::CodeCompletionContext, clang::CodeCompletionResult*, unsigned int)"},
    {"_ZN5clang20CodeCompleteConsumer25ProcessOverloadCandidatesERNS_4SemaEjPNS0_17OverloadCandidateEj", "clang::CodeCompleteConsumer::ProcessOverloadCandidates(clang::Sema&, unsigned int, clang::CodeCompleteConsumer::OverloadCandidate*, unsigned int)"},
    {"_ZN5clang23ChainedDiagnosticClientD1Ev", "clang::ChainedDiagnosticClient::~ChainedDiagnosticClient()"},
    {"_ZN5clang23ChainedDiagnosticClientD0Ev", "clang::ChainedDiagnosticClient::~ChainedDiagnosticClient()"},
    {"_ZN5clang23ChainedDiagnosticClient15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::ChainedDiagnosticClient::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"},
    {"_ZN5clang23ChainedDiagnosticClient13EndSourceFileEv", "clang::ChainedDiagnosticClient::EndSourceFile()"},
    {"_ZNK5clang23ChainedDiagnosticClient25IncludeInDiagnosticCountsEv", "clang::ChainedDiagnosticClient::IncludeInDiagnosticCounts() const"},
    {"_ZN5clang23ChainedDiagnosticClient16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::ChainedDiagnosticClient::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"},
    {"_ZN5clang18CompilerInvocation6toArgsERSt6vectorISsSaISsEE", "clang::CompilerInvocation::toArgs(std::vector<std::string, std::allocator<std::string> >&)"},
    {"_ZN5clang18CompilerInvocation16GetResourcesPathEPKcPv", "clang::CompilerInvocation::GetResourcesPath(char const*, void*)"},
    {"_ZN5clang18CompilerInvocation15setLangDefaultsERNS_11LangOptionsENS_9InputKindENS_12LangStandard4KindE", "clang::CompilerInvocation::setLangDefaults(clang::LangOptions&, clang::InputKind, clang::LangStandard::Kind)"},
    {"_ZN5clang18CompilerInvocation14CreateFromArgsERS0_PKPKcS5_RNS_10DiagnosticE", "clang::CompilerInvocation::CreateFromArgs(clang::CompilerInvocation&, char const* const*, char const* const*, clang::Diagnostic&)"},
    {"_ZN5clang19PreprocessorOptions11addMacroDefEN4llvm9StringRefE", "clang::PreprocessorOptions::addMacroDef(llvm::StringRef)"},
    {"_ZN5clang19PreprocessorOptions13addMacroUndefEN4llvm9StringRefE", "clang::PreprocessorOptions::addMacroUndef(llvm::StringRef)"},
    {"_ZN5clang19PreprocessorOptions15addRemappedFileEN4llvm9StringRefES2_", "clang::PreprocessorOptions::addRemappedFile(llvm::StringRef, llvm::StringRef)"},
    {"_ZNSt6vectorISt4pairISsSsESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<std::pair<std::string, std::string>, std::allocator<std::pair<std::string, std::string> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<std::string, std::string>*, std::vector<std::pair<std::string, std::string>, std::allocator<std::pair<std::string, std::string> > > >, std::pair<std::string, std::string> const&)"},
    {"_ZNSt6vectorISsSaISsEE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPSsS1_EERKSs", "std::vector<std::string, std::allocator<std::string> >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::string*, std::vector<std::string, std::allocator<std::string> > >, std::string const&)"},
    {"_ZNSt6vectorISt4pairISsbESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<std::pair<std::string, bool>, std::allocator<std::pair<std::string, bool> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<std::string, bool>*, std::vector<std::pair<std::string, bool>, std::allocator<std::pair<std::string, bool> > > >, std::pair<std::string, bool> const&)"},
    {"_ZN5clang19HeaderSearchOptions7AddPathEN4llvm9StringRefENS_8frontend15IncludeDirGroupEbbb", "clang::HeaderSearchOptions::AddPath(llvm::StringRef, clang::frontend::IncludeDirGroup, bool, bool, bool)"},
    {"_ZNSt6vectorIN5clang19HeaderSearchOptions5EntryESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::HeaderSearchOptions::Entry, std::allocator<clang::HeaderSearchOptions::Entry> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::HeaderSearchOptions::Entry*, std::vector<clang::HeaderSearchOptions::Entry, std::allocator<clang::HeaderSearchOptions::Entry> > >, clang::HeaderSearchOptions::Entry const&)"},
    {"_ZN5clang20ParsedSourceLocation10FromStringEN4llvm9StringRefE", "clang::ParsedSourceLocation::FromString(llvm::StringRef)"},
    {"_ZNSt6vectorISt4pairIN5clang9InputKindESsESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<std::pair<clang::InputKind, std::string>, std::allocator<std::pair<clang::InputKind, std::string> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<clang::InputKind, std::string>*, std::vector<std::pair<clang::InputKind, std::string>, std::allocator<std::pair<clang::InputKind, std::string> > > >, std::pair<clang::InputKind, std::string> const&)"},
    {"_ZNSt6vectorIS_ISsSaISsEESaIS1_EE15_M_erase_at_endEPS1_", "std::vector<std::vector<std::string, std::allocator<std::string> >, std::allocator<std::vector<std::string, std::allocator<std::string> > > >::_M_erase_at_end(std::vector<std::string, std::allocator<std::string> >*)"},
    {"_ZNSt6vectorIS_ISsSaISsEESaIS1_EE14_M_fill_insertEN9__gnu_cxx17__normal_iteratorIPS1_S3_EEmRKS1_", "std::vector<std::vector<std::string, std::allocator<std::string> >, std::allocator<std::vector<std::string, std::allocator<std::string> > > >::_M_fill_insert(__gnu_cxx::__normal_iterator<std::vector<std::string, std::allocator<std::string> >*, std::vector<std::vector<std::string, std::allocator<std::string> >, std::allocator<std::vector<std::string, std::allocator<std::string> > > > >, unsigned long, std::vector<std::string, std::allocator<std::string> > const&)"},
    {"_ZNSt6vectorISsSaISsEEC2ERKS1_", "std::vector<std::string, std::allocator<std::string> >::vector(std::vector<std::string, std::allocator<std::string> > const&)"},
    {"_ZNSt6vectorIN5clang8AnalysesESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<clang::Analyses, std::allocator<clang::Analyses> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::Analyses*, std::vector<clang::Analyses, std::allocator<clang::Analyses> > >, clang::Analyses const&)"},
    {"_ZN5clang11DocumentXML14writeDeclToXMLEPNS_4DeclE", "clang::DocumentXML::writeDeclToXML(clang::Decl*)"},
    {"_ZN5clang11DeclVisitorINS_11DocumentXML11DeclPrinterEvE5VisitEPNS_4DeclE", "clang::DeclVisitor<clang::DocumentXML::DeclPrinter, void>::Visit(clang::Decl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter20VisitLinkageSpecDeclEPNS_15LinkageSpecDeclE", "clang::DocumentXML::DeclPrinter::VisitLinkageSpecDecl(clang::LinkageSpecDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter18VisitNamespaceDeclEPNS_13NamespaceDeclE", "clang::DocumentXML::DeclPrinter::VisitNamespaceDecl(clang::NamespaceDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter23VisitNamespaceAliasDeclEPNS_18NamespaceAliasDeclE", "clang::DocumentXML::DeclPrinter::VisitNamespaceAliasDecl(clang::NamespaceAliasDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter13VisitEnumDeclEPNS_8EnumDeclE", "clang::DocumentXML::DeclPrinter::VisitEnumDecl(clang::EnumDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter15VisitRecordDeclEPNS_10RecordDeclE", "clang::DocumentXML::DeclPrinter::VisitRecordDecl(clang::RecordDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter18VisitCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXRecordDecl(clang::CXXRecordDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter25VisitTemplateTypeParmDeclEPNS_20TemplateTypeParmDeclE", "clang::DocumentXML::DeclPrinter::VisitTemplateTypeParmDecl(clang::TemplateTypeParmDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter16VisitTypedefDeclEPNS_11TypedefDeclE", "clang::DocumentXML::DeclPrinter::VisitTypedefDecl(clang::TypedefDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter14VisitUsingDeclEPNS_9UsingDeclE", "clang::DocumentXML::DeclPrinter::VisitUsingDecl(clang::UsingDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter23VisitUsingDirectiveDeclEPNS_18UsingDirectiveDeclE", "clang::DocumentXML::DeclPrinter::VisitUsingDirectiveDecl(clang::UsingDirectiveDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter20VisitUsingShadowDeclEPNS_15UsingShadowDeclE", "clang::DocumentXML::DeclPrinter::VisitUsingShadowDecl(clang::UsingShadowDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter14VisitFieldDeclEPNS_9FieldDeclE", "clang::DocumentXML::DeclPrinter::VisitFieldDecl(clang::FieldDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter17VisitFunctionDeclEPNS_12FunctionDeclE", "clang::DocumentXML::DeclPrinter::VisitFunctionDecl(clang::FunctionDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter18VisitCXXMethodDeclEPNS_13CXXMethodDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXMethodDecl(clang::CXXMethodDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter23VisitCXXConstructorDeclEPNS_18CXXConstructorDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXConstructorDecl(clang::CXXConstructorDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter22VisitCXXConversionDeclEPNS_17CXXConversionDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXConversionDecl(clang::CXXConversionDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter22VisitCXXDestructorDeclEPNS_17CXXDestructorDeclE", "clang::DocumentXML::DeclPrinter::VisitCXXDestructorDecl(clang::CXXDestructorDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter12VisitVarDeclEPNS_7VarDeclE", "clang::DocumentXML::DeclPrinter::VisitVarDecl(clang::VarDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter16VisitParmVarDeclEPNS_11ParmVarDeclE", "clang::DocumentXML::DeclPrinter::VisitParmVarDecl(clang::ParmVarDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter21VisitEnumConstantDeclEPNS_16EnumConstantDeclE", "clang::DocumentXML::DeclPrinter::VisitEnumConstantDecl(clang::EnumConstantDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter9VisitDeclEPNS_4DeclE", "clang::DocumentXML::DeclPrinter::VisitDecl(clang::Decl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter15addFunctionBodyEPNS_12FunctionDeclE", "clang::DocumentXML::DeclPrinter::addFunctionBody(clang::FunctionDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter11addSubNodesEPNS_13CXXRecordDeclE", "clang::DocumentXML::DeclPrinter::addSubNodes(clang::CXXRecordDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter11addSubNodesEPNS_10RecordDeclE", "clang::DocumentXML::DeclPrinter::addSubNodes(clang::RecordDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter11addSubNodesEPNS_8EnumDeclE", "clang::DocumentXML::DeclPrinter::addSubNodes(clang::EnumDecl*)"},
    {"_ZN5clang11DocumentXML11DeclPrinter17VisitTemplateDeclEPNS_12TemplateDeclE", "clang::DocumentXML::DeclPrinter::VisitTemplateDecl(clang::TemplateDecl*)"},
    {"_ZN5clang23AttachDependencyFileGenERNS_12PreprocessorERKNS_23DependencyOutputOptionsE", "clang::AttachDependencyFileGen(clang::Preprocessor&, clang::DependencyOutputOptions const&)"},
    {"_ZN12_GLOBAL__N_122DependencyFileCallbackD1Ev", "(anonymous namespace)::DependencyFileCallback::~DependencyFileCallback()"},
    {"_ZN12_GLOBAL__N_122DependencyFileCallbackD0Ev", "(anonymous namespace)::DependencyFileCallback::~DependencyFileCallback()"},
    {"_ZN12_GLOBAL__N_122DependencyFileCallback11FileChangedEN5clang14SourceLocationENS1_11PPCallbacks16FileChangeReasonENS1_6SrcMgr18CharacteristicKindE", "(anonymous namespace)::DependencyFileCallback::FileChanged(clang::SourceLocation, clang::PPCallbacks::FileChangeReason, clang::SrcMgr::CharacteristicKind)"},
    {"_ZN12_GLOBAL__N_122DependencyFileCallback13EndOfMainFileEv", "(anonymous namespace)::DependencyFileCallback::EndOfMainFile()"},
    {"_ZN5clang11DocumentXMLC1ERKSsRN4llvm11raw_ostreamE", "clang::DocumentXML::DocumentXML(std::string const&, llvm::raw_ostream&)"},
    {"_ZN5clang11DocumentXMLC2ERKSsRN4llvm11raw_ostreamE", "clang::DocumentXML::DocumentXML(std::string const&, llvm::raw_ostream&)"},
    {"_ZN5clang11DocumentXML10addSubNodeERKSs", "clang::DocumentXML::addSubNode(std::string const&)"},
    {"_ZN5clang11DocumentXML6IndentEv", "clang::DocumentXML::Indent()"},
    {"_ZN5clang11DocumentXML8toParentEv", "clang::DocumentXML::toParent()"},
    {"_ZN5clang11DocumentXML12escapeStringEPKcm", "clang::DocumentXML::escapeString(char const*, unsigned long)"},
    {"_ZN5clang11DocumentXML8finalizeEv", "clang::DocumentXML::finalize()"},
    {"_ZN5clang11DocumentXML12addAttributeEPKcRKNS_8QualTypeE", "clang::DocumentXML::addAttribute(char const*, clang::QualType const&)"},
    {"_ZN5clang11DocumentXML18addTypeRecursivelyERKNS_8QualTypeE", "clang::DocumentXML::addTypeRecursively(clang::QualType const&)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_4TypeE", "clang::DocumentXML::addPtrAttribute(char const*, clang::Type const*)"},
    {"_ZN5clang11DocumentXML18addTypeRecursivelyEPKNS_4TypeE", "clang::DocumentXML::addTypeRecursively(clang::Type const*)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_19NestedNameSpecifierE", "clang::DocumentXML::addPtrAttribute(char const*, clang::NestedNameSpecifier const*)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_13NamespaceDeclE", "clang::DocumentXML::addPtrAttribute(char const*, clang::NamespaceDecl const*)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_11DeclContextE", "clang::DocumentXML::addPtrAttribute(char const*, clang::DeclContext const*)"},
    {"_ZN5clang11DocumentXML22addContextsRecursivelyEPKNS_11DeclContextE", "clang::DocumentXML::addContextsRecursively(clang::DeclContext const*)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_9NamedDeclE", "clang::DocumentXML::addPtrAttribute(char const*, clang::NamedDecl const*)"},
    {"_ZN5clang11DocumentXML22addSourceFileAttributeERKSs", "clang::DocumentXML::addSourceFileAttribute(std::string const&)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcPKNS_9LabelStmtE", "clang::DocumentXML::addPtrAttribute(char const*, clang::LabelStmt const*)"},
    {"_ZN5clang11DocumentXML11addLocationERKNS_14SourceLocationE", "clang::DocumentXML::addLocation(clang::SourceLocation const&)"},
    {"_ZN5clang11DocumentXML16addLocationRangeERKNS_11SourceRangeE", "clang::DocumentXML::addLocationRange(clang::SourceRange const&)"},
    {"_ZN5clang11DocumentXML9PrintDeclEPNS_4DeclE", "clang::DocumentXML::PrintDecl(clang::Decl*)"},
    {"_ZN5clang11DocumentXML12addAttributeISsEEvPKcRKT_", "void clang::DocumentXML::addAttribute<std::string>(char const*, std::string const&)"},
    {"_ZN5clang11DocumentXML15addPtrAttributeEPKcS2_", "clang::DocumentXML::addPtrAttribute(char const*, char const*)"},
    {"_ZN5clang11DocumentXML12addAttributeIjEEvPKcRKT_", "void clang::DocumentXML::addAttribute<unsigned int>(char const*, unsigned int const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang9LabelStmtEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::LabelStmt const*, unsigned int, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::LabelStmt const* const&, unsigned int const&, std::pair<clang::LabelStmt const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang9LabelStmtEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::LabelStmt const*, unsigned int, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang9LabelStmtEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::LabelStmt const*, unsigned int, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::LabelStmt const*, unsigned int> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang11DeclContextEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::DeclContext const*, unsigned int, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::DeclContext const*, unsigned int> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang11DeclContextEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::DeclContext const*, unsigned int, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::DeclContext const* const&, unsigned int const&, std::pair<clang::DeclContext const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang11DeclContextEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::DeclContext const*, unsigned int, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang9NamedDeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::NamedDecl const*, unsigned int, llvm::DenseMapInfo<clang::NamedDecl const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::NamedDecl const*, unsigned int> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::Type const*, unsigned int, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::Type const*, unsigned int> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::Type const*, unsigned int, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::Type const* const&, unsigned int const&, std::pair<clang::Type const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::Type const*, unsigned int, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_jESt10_Select1stIS4_ENS0_16QualTypeOrderingESaIS4_EE16_M_insert_uniqueERKS4_", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, unsigned int>, std::_Select1st<std::pair<clang::QualType const, unsigned int> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, unsigned int> > >::_M_insert_unique(std::pair<clang::QualType const, unsigned int> const&)"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_jESt10_Select1stIS4_ENS0_16QualTypeOrderingESaIS4_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS4_ERKS4_", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, unsigned int>, std::_Select1st<std::pair<clang::QualType const, unsigned int> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, unsigned int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::QualType const, unsigned int> >, std::pair<clang::QualType const, unsigned int> const&)"},
    {"_ZNSt5dequeISsSaISsEE8pop_backEv", "std::deque<std::string, std::allocator<std::string> >::pop_back()"},
    {"_ZNSt11_Deque_baseISsSaISsEE17_M_initialize_mapEm", "std::_Deque_base<std::string, std::allocator<std::string> >::_M_initialize_map(unsigned long)"},
    {"_ZNSt5dequeISsSaISsEEC2ERKS1_", "std::deque<std::string, std::allocator<std::string> >::deque(std::deque<std::string, std::allocator<std::string> > const&)"},
    {"_ZN5clang14FrontendActionC1Ev", "clang::FrontendAction::FrontendAction()"},
    {"_ZN5clang14FrontendActionC2Ev", "clang::FrontendAction::FrontendAction()"},
    {"_ZN5clang14FrontendActionD0Ev", "clang::FrontendAction::~FrontendAction()"},
    {"_ZN5clang14FrontendActionD1Ev", "clang::FrontendAction::~FrontendAction()"},
    {"_ZN5clang14FrontendActionD2Ev", "clang::FrontendAction::~FrontendAction()"},
    {"_ZN5clang14FrontendAction14setCurrentFileEN4llvm9StringRefENS_9InputKindEPNS_7ASTUnitE", "clang::FrontendAction::setCurrentFile(llvm::StringRef, clang::InputKind, clang::ASTUnit*)"},
    {"_ZN5clang14FrontendAction24CreateWrappedASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::FrontendAction::CreateWrappedASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang14FrontendAction15BeginSourceFileERNS_16CompilerInstanceEN4llvm9StringRefENS_9InputKindE", "clang::FrontendAction::BeginSourceFile(clang::CompilerInstance&, llvm::StringRef, clang::InputKind)"},
    {"_ZN5clang14FrontendAction7ExecuteEv", "clang::FrontendAction::Execute()"},
    {"_ZN5clang14FrontendAction13EndSourceFileEv", "clang::FrontendAction::EndSourceFile()"},
    {"_ZN5clang17ASTFrontendAction13ExecuteActionEv", "clang::ASTFrontendAction::ExecuteAction()"},
    {"_ZN5clang26PreprocessorFrontendAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::PreprocessorFrontendAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_124DeserializedDeclsCheckerD1Ev", "(anonymous namespace)::DeserializedDeclsChecker::~DeserializedDeclsChecker()"},
    {"_ZN12_GLOBAL__N_124DeserializedDeclsCheckerD0Ev", "(anonymous namespace)::DeserializedDeclsChecker::~DeserializedDeclsChecker()"},
    {"_ZN12_GLOBAL__N_124DeserializedDeclsChecker8DeclReadEjPKN5clang4DeclE", "(anonymous namespace)::DeserializedDeclsChecker::DeclRead(unsigned int, clang::Decl const*)"},
    {"_ZN12_GLOBAL__N_123DeserializedDeclsDumperD1Ev", "(anonymous namespace)::DeserializedDeclsDumper::~DeserializedDeclsDumper()"},
    {"_ZN12_GLOBAL__N_123DeserializedDeclsDumperD0Ev", "(anonymous namespace)::DeserializedDeclsDumper::~DeserializedDeclsDumper()"},
    {"_ZN12_GLOBAL__N_123DeserializedDeclsDumper8DeclReadEjPKN5clang4DeclE", "(anonymous namespace)::DeserializedDeclsDumper::DeclRead(unsigned int, clang::Decl const*)"},
    {"_ZNSt6vectorIPN5clang11ASTConsumerESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::ASTConsumer*, std::allocator<clang::ASTConsumer*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::ASTConsumer**, std::vector<clang::ASTConsumer*, std::allocator<clang::ASTConsumer*> > >, clang::ASTConsumer* const&)"},
    {"_ZN5clang26ASTDeserializationListener17ReaderInitializedEPNS_9ASTReaderE", "clang::ASTDeserializationListener::ReaderInitialized(clang::ASTReader*)"},
    {"_ZN5clang26ASTDeserializationListener14IdentifierReadEjPNS_14IdentifierInfoE", "clang::ASTDeserializationListener::IdentifierRead(unsigned int, clang::IdentifierInfo*)"},
    {"_ZN5clang26ASTDeserializationListener8TypeReadENS_13serialization7TypeIdxENS_8QualTypeE", "clang::ASTDeserializationListener::TypeRead(clang::serialization::TypeIdx, clang::QualType)"},
    {"_ZN5clang26ASTDeserializationListener12SelectorReadEjNS_8SelectorE", "clang::ASTDeserializationListener::SelectorRead(unsigned int, clang::Selector)"},
    {"_ZN5clang26ASTDeserializationListener19MacroDefinitionReadEjPNS_15MacroDefinitionE", "clang::ASTDeserializationListener::MacroDefinitionRead(unsigned int, clang::MacroDefinition*)"},
    {"_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE4findERKSs", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::find(std::string const&)"},
    {"_ZNSt8_Rb_treeISsSsSt9_IdentityISsESt4lessISsESaISsEE7_M_copyEPKSt13_Rb_tree_nodeISsEPS7_", "std::_Rb_tree<std::string, std::string, std::_Identity<std::string>, std::less<std::string>, std::allocator<std::string> >::_M_copy(std::_Rb_tree_node<std::string> const*, std::_Rb_tree_node<std::string>*)"},
    {"_ZN5clang26ASTDeserializationListener8DeclReadEjPKNS_4DeclE", "clang::ASTDeserializationListener::DeclRead(unsigned int, clang::Decl const*)"},
    {"_ZN5clang14InitOnlyAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::InitOnlyAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang14InitOnlyAction13ExecuteActionEv", "clang::InitOnlyAction::ExecuteAction()"},
    {"_ZN5clang14ASTPrintAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTPrintAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang17ASTPrintXMLAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTPrintXMLAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang13ASTDumpAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTDumpAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang16ASTDumpXMLAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTDumpXMLAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang13ASTViewAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::ASTViewAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang22DeclContextPrintAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::DeclContextPrintAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang17GeneratePCHAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::GeneratePCHAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang17GeneratePCHAction27ComputeASTConsumerArgumentsERNS_16CompilerInstanceEN4llvm9StringRefERSsRPNS3_11raw_ostreamERb", "clang::GeneratePCHAction::ComputeASTConsumerArguments(clang::CompilerInstance&, llvm::StringRef, std::string&, llvm::raw_ostream*&, bool&)"},
    {"_ZN5clang21InheritanceViewAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::InheritanceViewAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang16SyntaxOnlyAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::SyntaxOnlyAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_ZN5clang19DumpRawTokensAction13ExecuteActionEv", "clang::DumpRawTokensAction::ExecuteAction()"},
    {"_ZN5clang16DumpTokensAction13ExecuteActionEv", "clang::DumpTokensAction::ExecuteAction()"},
    {"_ZN5clang17GeneratePTHAction13ExecuteActionEv", "clang::GeneratePTHAction::ExecuteAction()"},
    {"_ZN5clang20PreprocessOnlyAction13ExecuteActionEv", "clang::PreprocessOnlyAction::ExecuteAction()"},
    {"_ZN5clang23PrintPreprocessedAction13ExecuteActionEv", "clang::PrintPreprocessedAction::ExecuteAction()"},
    {"_ZN5clang19PrintPreambleAction13ExecuteActionEv", "clang::PrintPreambleAction::ExecuteAction()"},
    {"_ZN5clang5LexerD1Ev", "clang::Lexer::~Lexer()"},
    {"_ZN5clang12Preprocessor3LexERNS_5TokenE", "clang::Preprocessor::Lex(clang::Token&)"},
    {"_ZN5clang14InitOnlyActionD1Ev", "clang::InitOnlyAction::~InitOnlyAction()"},
    {"_ZN5clang14InitOnlyActionD0Ev", "clang::InitOnlyAction::~InitOnlyAction()"},
    {"_ZN5clang14ASTPrintActionD1Ev", "clang::ASTPrintAction::~ASTPrintAction()"},
    {"_ZN5clang14ASTPrintActionD0Ev", "clang::ASTPrintAction::~ASTPrintAction()"},
    {"_ZN5clang17ASTPrintXMLActionD1Ev", "clang::ASTPrintXMLAction::~ASTPrintXMLAction()"},
    {"_ZN5clang17ASTPrintXMLActionD0Ev", "clang::ASTPrintXMLAction::~ASTPrintXMLAction()"},
    {"_ZN5clang13ASTDumpActionD1Ev", "clang::ASTDumpAction::~ASTDumpAction()"},
    {"_ZN5clang13ASTDumpActionD0Ev", "clang::ASTDumpAction::~ASTDumpAction()"},
    {"_ZN5clang16ASTDumpXMLActionD1Ev", "clang::ASTDumpXMLAction::~ASTDumpXMLAction()"},
    {"_ZN5clang16ASTDumpXMLActionD0Ev", "clang::ASTDumpXMLAction::~ASTDumpXMLAction()"},
    {"_ZN5clang13ASTViewActionD1Ev", "clang::ASTViewAction::~ASTViewAction()"},
    {"_ZN5clang13ASTViewActionD0Ev", "clang::ASTViewAction::~ASTViewAction()"},
    {"_ZN5clang22DeclContextPrintActionD1Ev", "clang::DeclContextPrintAction::~DeclContextPrintAction()"},
    {"_ZN5clang22DeclContextPrintActionD0Ev", "clang::DeclContextPrintAction::~DeclContextPrintAction()"},
    {"_ZN5clang17GeneratePCHActionD1Ev", "clang::GeneratePCHAction::~GeneratePCHAction()"},
    {"_ZN5clang17GeneratePCHActionD0Ev", "clang::GeneratePCHAction::~GeneratePCHAction()"},
    {"_ZN5clang21InheritanceViewActionD1Ev", "clang::InheritanceViewAction::~InheritanceViewAction()"},
    {"_ZN5clang21InheritanceViewActionD0Ev", "clang::InheritanceViewAction::~InheritanceViewAction()"},
    {"_ZN5clang19PrintPreambleActionD1Ev", "clang::PrintPreambleAction::~PrintPreambleAction()"},
    {"_ZN5clang19PrintPreambleActionD0Ev", "clang::PrintPreambleAction::~PrintPreambleAction()"},
    {"_ZN5clang19DumpRawTokensActionD1Ev", "clang::DumpRawTokensAction::~DumpRawTokensAction()"},
    {"_ZN5clang19DumpRawTokensActionD0Ev", "clang::DumpRawTokensAction::~DumpRawTokensAction()"},
    {"_ZN5clang16DumpTokensActionD1Ev", "clang::DumpTokensAction::~DumpTokensAction()"},
    {"_ZN5clang16DumpTokensActionD0Ev", "clang::DumpTokensAction::~DumpTokensAction()"},
    {"_ZN5clang17GeneratePTHActionD1Ev", "clang::GeneratePTHAction::~GeneratePTHAction()"},
    {"_ZN5clang17GeneratePTHActionD0Ev", "clang::GeneratePTHAction::~GeneratePTHAction()"},
    {"_ZN5clang20PreprocessOnlyActionD1Ev", "clang::PreprocessOnlyAction::~PreprocessOnlyAction()"},
    {"_ZN5clang20PreprocessOnlyActionD0Ev", "clang::PreprocessOnlyAction::~PreprocessOnlyAction()"},
    {"_ZN5clang23PrintPreprocessedActionD1Ev", "clang::PrintPreprocessedAction::~PrintPreprocessedAction()"},
    {"_ZN5clang23PrintPreprocessedActionD0Ev", "clang::PrintPreprocessedAction::~PrintPreprocessedAction()"},
    {"_ZN5clang5LexerD0Ev", "clang::Lexer::~Lexer()"},
    {"_ZN5clang5Lexer11IndirectLexERNS_5TokenE", "clang::Lexer::IndirectLex(clang::Token&)"},
    {"_ZN5clang5Lexer17getSourceLocationEv", "clang::Lexer::getSourceLocation()"},
    {"_ZN5clang17PreprocessorLexerD1Ev", "clang::PreprocessorLexer::~PreprocessorLexer()"},
    {"_ZN5clang17PreprocessorLexerD0Ev", "clang::PreprocessorLexer::~PreprocessorLexer()"},
    {"_ZN5clang11ASTConsumerD1Ev", "clang::ASTConsumer::~ASTConsumer()"},
    {"_ZN5clang11ASTConsumerD0Ev", "clang::ASTConsumer::~ASTConsumer()"},
    {"_ZN5clang11ASTConsumer10InitializeERNS_10ASTContextE", "clang::ASTConsumer::Initialize(clang::ASTContext&)"},
    {"_ZN5clang11ASTConsumer21HandleTranslationUnitERNS_10ASTContextE", "clang::ASTConsumer::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN5clang11ASTConsumer23HandleTagDeclDefinitionEPNS_7TagDeclE", "clang::ASTConsumer::HandleTagDeclDefinition(clang::TagDecl*)"},
    {"_ZN5clang11ASTConsumer27CompleteTentativeDefinitionEPNS_7VarDeclE", "clang::ASTConsumer::CompleteTentativeDefinition(clang::VarDecl*)"},
    {"_ZN5clang11ASTConsumer12HandleVTableEPNS_13CXXRecordDeclEb", "clang::ASTConsumer::HandleVTable(clang::CXXRecordDecl*, bool)"},
    {"_ZN5clang11ASTConsumer22GetASTMutationListenerEv", "clang::ASTConsumer::GetASTMutationListener()"},
    {"_ZN5clang11ASTConsumer29GetASTDeserializationListenerEv", "clang::ASTConsumer::GetASTDeserializationListener()"},
    {"_ZN5clang11ASTConsumer10PrintStatsEv", "clang::ASTConsumer::PrintStats()"},
    {"_ZN5clang15FrontendOptions24getInputKindForExtensionEN4llvm9StringRefE", "clang::FrontendOptions::getInputKindForExtension(llvm::StringRef)"},
    {"_ZN4llvm12StringSwitchIN5clang9InputKindES2_E5CasesILj4ELj4ELj4ELj4ELj4EEERS3_RAT__KcRAT0__S6_RAT1__S6_RAT2__S6_RAT3__S6_RKS2_", "llvm::StringSwitch<clang::InputKind, clang::InputKind>& llvm::StringSwitch<clang::InputKind, clang::InputKind>::Cases<4u, 4u, 4u, 4u, 4u>(char const (&) [4u], char const (&) [4u], char const (&) [4u], char const (&) [4u], char const (&) [4u], clang::InputKind const&)"},
    {"_ZN5clang22AttachHeaderIncludeGenERNS_12PreprocessorEbN4llvm9StringRefE", "clang::AttachHeaderIncludeGen(clang::Preprocessor&, bool, llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_122HeaderIncludesCallbackD1Ev", "(anonymous namespace)::HeaderIncludesCallback::~HeaderIncludesCallback()"},
    {"_ZN12_GLOBAL__N_122HeaderIncludesCallbackD0Ev", "(anonymous namespace)::HeaderIncludesCallback::~HeaderIncludesCallback()"},
    {"_ZN12_GLOBAL__N_122HeaderIncludesCallback11FileChangedEN5clang14SourceLocationENS1_11PPCallbacks16FileChangeReasonENS1_6SrcMgr18CharacteristicKindE", "(anonymous namespace)::HeaderIncludesCallback::FileChanged(clang::SourceLocation, clang::PPCallbacks::FileChangeReason, clang::SrcMgr::CharacteristicKind)"},
    {"_ZN5clang24ApplyHeaderSearchOptionsERNS_12HeaderSearchERKNS_19HeaderSearchOptionsERKNS_11LangOptionsERKN4llvm6TripleE", "clang::ApplyHeaderSearchOptions(clang::HeaderSearch&, clang::HeaderSearchOptions const&, clang::LangOptions const&, llvm::Triple const&)"},
    {"_ZN12_GLOBAL__N_116InitHeaderSearch7AddPathERKN4llvm5TwineEN5clang8frontend15IncludeDirGroupEbbbb", "(anonymous namespace)::InitHeaderSearch::AddPath(llvm::Twine const&, clang::frontend::IncludeDirGroup, bool, bool, bool, bool)"},
    {"_ZN12_GLOBAL__N_116InitHeaderSearch17AddDelimitedPathsEN4llvm9StringRefE", "(anonymous namespace)::InitHeaderSearch::AddDelimitedPaths(llvm::StringRef)"},
    {"_Z16RemoveDuplicatesRSt6vectorIN5clang15DirectoryLookupESaIS1_EEb", "RemoveDuplicates(std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> >&, bool)"},
    {"_ZN12_GLOBAL__N_116InitHeaderSearch27AddGnuCPlusPlusIncludePathsEN4llvm9StringRefES2_S2_S2_RKNS1_6TripleE", "(anonymous namespace)::InitHeaderSearch::AddGnuCPlusPlusIncludePaths(llvm::StringRef, llvm::StringRef, llvm::StringRef, llvm::StringRef, llvm::Triple const&)"},
    {"_ZN12_GLOBAL__N_116InitHeaderSearch29AddMinGWCPlusPlusIncludePathsEN4llvm9StringRefES2_S2_", "(anonymous namespace)::InitHeaderSearch::AddMinGWCPlusPlusIncludePaths(llvm::StringRef, llvm::StringRef, llvm::StringRef)"},
    {"_ZNSt6vectorIN5clang15DirectoryLookupESaIS1_EEaSERKS3_", "std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> >::operator=(std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> > const&)"},
    {"_ZNSt6vectorIN5clang15DirectoryLookupESaIS1_EE15_M_range_insertIN9__gnu_cxx17__normal_iteratorIPS1_S3_EEEEvS8_T_S9_St20forward_iterator_tag", "void std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> >::_M_range_insert<__gnu_cxx::__normal_iterator<clang::DirectoryLookup*, std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> > > >(__gnu_cxx::__normal_iterator<clang::DirectoryLookup*, std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> > >, __gnu_cxx::__normal_iterator<clang::DirectoryLookup*, std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> > >, __gnu_cxx::__normal_iterator<clang::DirectoryLookup*, std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> > >, std::forward_iterator_tag)"},
    {"_ZNSt6vectorIN5clang15DirectoryLookupESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::DirectoryLookup*, std::vector<clang::DirectoryLookup, std::allocator<clang::DirectoryLookup> > >, clang::DirectoryLookup const&)"},
    {"_ZN5clang24NormalizeDashIncludePathEN4llvm9StringRefE", "clang::NormalizeDashIncludePath(llvm::StringRef)"},
    {"_ZN5clang22InitializePreprocessorERNS_12PreprocessorERKNS_19PreprocessorOptionsERKNS_19HeaderSearchOptionsERKNS_15FrontendOptionsE", "clang::InitializePreprocessor(clang::Preprocessor&, clang::PreprocessorOptions const&, clang::HeaderSearchOptions const&, clang::FrontendOptions const&)"},
    {"_Z18AddImplicitIncludeRN5clang12MacroBuilderEN4llvm9StringRefE", "AddImplicitInclude(clang::MacroBuilder&, llvm::StringRef)"},
    {"_Z17DefineFloatMacrosRN5clang12MacroBuilderEN4llvm9StringRefEPKNS2_12fltSemanticsE", "DefineFloatMacros(clang::MacroBuilder&, llvm::StringRef, llvm::fltSemantics const*)"},
    {"_Z23DefineExactWidthIntTypeN5clang10TargetInfo7IntTypeERKS0_RNS_12MacroBuilderE", "DefineExactWidthIntType(clang::TargetInfo::IntType, clang::TargetInfo const&, clang::MacroBuilder&)"},
    {"_ZN5clang12LangStandard22getLangStandardForKindENS0_4KindE", "clang::LangStandard::getLangStandardForKind(clang::LangStandard::Kind)"},
    {"_ZN5clang12LangStandard22getLangStandardForNameEN4llvm9StringRefE", "clang::LangStandard::getLangStandardForName(llvm::StringRef)"},
    {"_ZN5clang35MultiplexASTDeserializationListenerC1ERKSt6vectorIPNS_26ASTDeserializationListenerESaIS3_EE", "clang::MultiplexASTDeserializationListener::MultiplexASTDeserializationListener(std::vector<clang::ASTDeserializationListener*, std::allocator<clang::ASTDeserializationListener*> > const&)"},
    {"_ZN5clang35MultiplexASTDeserializationListenerC2ERKSt6vectorIPNS_26ASTDeserializationListenerESaIS3_EE", "clang::MultiplexASTDeserializationListener::MultiplexASTDeserializationListener(std::vector<clang::ASTDeserializationListener*, std::allocator<clang::ASTDeserializationListener*> > const&)"},
    {"_ZN5clang35MultiplexASTDeserializationListener17ReaderInitializedEPNS_9ASTReaderE", "clang::MultiplexASTDeserializationListener::ReaderInitialized(clang::ASTReader*)"},
    {"_ZN5clang35MultiplexASTDeserializationListener14IdentifierReadEjPNS_14IdentifierInfoE", "clang::MultiplexASTDeserializationListener::IdentifierRead(unsigned int, clang::IdentifierInfo*)"},
    {"_ZN5clang35MultiplexASTDeserializationListener8TypeReadENS_13serialization7TypeIdxENS_8QualTypeE", "clang::MultiplexASTDeserializationListener::TypeRead(clang::serialization::TypeIdx, clang::QualType)"},
    {"_ZN5clang35MultiplexASTDeserializationListener8DeclReadEjPKNS_4DeclE", "clang::MultiplexASTDeserializationListener::DeclRead(unsigned int, clang::Decl const*)"},
    {"_ZN5clang35MultiplexASTDeserializationListener12SelectorReadEjNS_8SelectorE", "clang::MultiplexASTDeserializationListener::SelectorRead(unsigned int, clang::Selector)"},
    {"_ZN5clang35MultiplexASTDeserializationListener19MacroDefinitionReadEjPNS_15MacroDefinitionE", "clang::MultiplexASTDeserializationListener::MacroDefinitionRead(unsigned int, clang::MacroDefinition*)"},
    {"_ZN5clang28MultiplexASTMutationListenerC1ERKSt6vectorIPNS_19ASTMutationListenerESaIS3_EE", "clang::MultiplexASTMutationListener::MultiplexASTMutationListener(std::vector<clang::ASTMutationListener*, std::allocator<clang::ASTMutationListener*> > const&)"},
    {"_ZN5clang28MultiplexASTMutationListenerC2ERKSt6vectorIPNS_19ASTMutationListenerESaIS3_EE", "clang::MultiplexASTMutationListener::MultiplexASTMutationListener(std::vector<clang::ASTMutationListener*, std::allocator<clang::ASTMutationListener*> > const&)"},
    {"_ZN5clang28MultiplexASTMutationListener22CompletedTagDefinitionEPKNS_7TagDeclE", "clang::MultiplexASTMutationListener::CompletedTagDefinition(clang::TagDecl const*)"},
    {"_ZN5clang28MultiplexASTMutationListener16AddedVisibleDeclEPKNS_11DeclContextEPKNS_4DeclE", "clang::MultiplexASTMutationListener::AddedVisibleDecl(clang::DeclContext const*, clang::Decl const*)"},
    {"_ZN5clang28MultiplexASTMutationListener22AddedCXXImplicitMemberEPKNS_13CXXRecordDeclEPKNS_4DeclE", "clang::MultiplexASTMutationListener::AddedCXXImplicitMember(clang::CXXRecordDecl const*, clang::Decl const*)"},
    {"_ZN5clang28MultiplexASTMutationListener30AddedCXXTemplateSpecializationEPKNS_17ClassTemplateDeclEPKNS_31ClassTemplateSpecializationDeclE", "clang::MultiplexASTMutationListener::AddedCXXTemplateSpecialization(clang::ClassTemplateDecl const*, clang::ClassTemplateSpecializationDecl const*)"},
    {"_ZN5clang17MultiplexConsumerC1ERKSt6vectorIPNS_11ASTConsumerESaIS3_EE", "clang::MultiplexConsumer::MultiplexConsumer(std::vector<clang::ASTConsumer*, std::allocator<clang::ASTConsumer*> > const&)"},
    {"_ZN5clang17MultiplexConsumerC2ERKSt6vectorIPNS_11ASTConsumerESaIS3_EE", "clang::MultiplexConsumer::MultiplexConsumer(std::vector<clang::ASTConsumer*, std::allocator<clang::ASTConsumer*> > const&)"},
    {"_ZN5clang17MultiplexConsumerD0Ev", "clang::MultiplexConsumer::~MultiplexConsumer()"},
    {"_ZN5clang17MultiplexConsumerD1Ev", "clang::MultiplexConsumer::~MultiplexConsumer()"},
    {"_ZN5clang17MultiplexConsumerD2Ev", "clang::MultiplexConsumer::~MultiplexConsumer()"},
    {"_ZN5clang17MultiplexConsumer10InitializeERNS_10ASTContextE", "clang::MultiplexConsumer::Initialize(clang::ASTContext&)"},
    {"_ZN5clang17MultiplexConsumer18HandleTopLevelDeclENS_12DeclGroupRefE", "clang::MultiplexConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"},
    {"_ZN5clang17MultiplexConsumer21HandleInterestingDeclENS_12DeclGroupRefE", "clang::MultiplexConsumer::HandleInterestingDecl(clang::DeclGroupRef)"},
    {"_ZN5clang17MultiplexConsumer21HandleTranslationUnitERNS_10ASTContextE", "clang::MultiplexConsumer::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN5clang17MultiplexConsumer23HandleTagDeclDefinitionEPNS_7TagDeclE", "clang::MultiplexConsumer::HandleTagDeclDefinition(clang::TagDecl*)"},
    {"_ZN5clang17MultiplexConsumer27CompleteTentativeDefinitionEPNS_7VarDeclE", "clang::MultiplexConsumer::CompleteTentativeDefinition(clang::VarDecl*)"},
    {"_ZN5clang17MultiplexConsumer12HandleVTableEPNS_13CXXRecordDeclEb", "clang::MultiplexConsumer::HandleVTable(clang::CXXRecordDecl*, bool)"},
    {"_ZN5clang17MultiplexConsumer22GetASTMutationListenerEv", "clang::MultiplexConsumer::GetASTMutationListener()"},
    {"_ZN5clang17MultiplexConsumer29GetASTDeserializationListenerEv", "clang::MultiplexConsumer::GetASTDeserializationListener()"},
    {"_ZN5clang17MultiplexConsumer10PrintStatsEv", "clang::MultiplexConsumer::PrintStats()"},
    {"_ZN5clang17MultiplexConsumer14InitializeSemaERNS_4SemaE", "clang::MultiplexConsumer::InitializeSema(clang::Sema&)"},
    {"_ZN5clang17MultiplexConsumer10ForgetSemaEv", "clang::MultiplexConsumer::ForgetSema()"},
    {"_ZN5clang35MultiplexASTDeserializationListenerD1Ev", "clang::MultiplexASTDeserializationListener::~MultiplexASTDeserializationListener()"},
    {"_ZN5clang35MultiplexASTDeserializationListenerD0Ev", "clang::MultiplexASTDeserializationListener::~MultiplexASTDeserializationListener()"},
    {"_ZN5clang28MultiplexASTMutationListenerD1Ev", "clang::MultiplexASTMutationListener::~MultiplexASTMutationListener()"},
    {"_ZN5clang28MultiplexASTMutationListenerD0Ev", "clang::MultiplexASTMutationListener::~MultiplexASTMutationListener()"},
    {"_ZNSt6vectorIPN5clang26ASTDeserializationListenerESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::ASTDeserializationListener*, std::allocator<clang::ASTDeserializationListener*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::ASTDeserializationListener**, std::vector<clang::ASTDeserializationListener*, std::allocator<clang::ASTDeserializationListener*> > >, clang::ASTDeserializationListener* const&)"},
    {"_ZNSt6vectorIPN5clang19ASTMutationListenerESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::ASTMutationListener*, std::allocator<clang::ASTMutationListener*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::ASTMutationListener**, std::vector<clang::ASTMutationListener*, std::allocator<clang::ASTMutationListener*> > >, clang::ASTMutationListener* const&)"},
    {"_ZN5clang12SemaConsumerD1Ev", "clang::SemaConsumer::~SemaConsumer()"},
    {"_ZN5clang12SemaConsumerD0Ev", "clang::SemaConsumer::~SemaConsumer()"},
    {"_ZN5clang12SemaConsumer14InitializeSemaERNS_4SemaE", "clang::SemaConsumer::InitializeSema(clang::Sema&)"},
    {"_ZN5clang12SemaConsumer10ForgetSemaEv", "clang::SemaConsumer::ForgetSema()"},
    {"_ZN5clang24DoPrintPreprocessedInputERNS_12PreprocessorEPN4llvm11raw_ostreamERKNS_25PreprocessorOutputOptionsE", "clang::DoPrintPreprocessedInput(clang::Preprocessor&, llvm::raw_ostream*, clang::PreprocessorOutputOptions const&)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks10MoveToLineEj", "(anonymous namespace)::PrintPPOutputPPCallbacks::MoveToLine(unsigned int)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks13WriteLineInfoEjPKcj", "(anonymous namespace)::PrintPPOutputPPCallbacks::WriteLineInfo(unsigned int, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_120UnknownPragmaHandlerD1Ev", "(anonymous namespace)::UnknownPragmaHandler::~UnknownPragmaHandler()"},
    {"_ZN12_GLOBAL__N_120UnknownPragmaHandlerD0Ev", "(anonymous namespace)::UnknownPragmaHandler::~UnknownPragmaHandler()"},
    {"_ZN12_GLOBAL__N_120UnknownPragmaHandler12HandlePragmaERN5clang12PreprocessorENS1_20PragmaIntroducerKindERNS1_5TokenE", "(anonymous namespace)::UnknownPragmaHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacksD1Ev", "(anonymous namespace)::PrintPPOutputPPCallbacks::~PrintPPOutputPPCallbacks()"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacksD0Ev", "(anonymous namespace)::PrintPPOutputPPCallbacks::~PrintPPOutputPPCallbacks()"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks11FileChangedEN5clang14SourceLocationENS1_11PPCallbacks16FileChangeReasonENS1_6SrcMgr18CharacteristicKindE", "(anonymous namespace)::PrintPPOutputPPCallbacks::FileChanged(clang::SourceLocation, clang::PPCallbacks::FileChangeReason, clang::SrcMgr::CharacteristicKind)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks5IdentEN5clang14SourceLocationERKSs", "(anonymous namespace)::PrintPPOutputPPCallbacks::Ident(clang::SourceLocation, std::string const&)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks13PragmaCommentEN5clang14SourceLocationEPKNS1_14IdentifierInfoERKSs", "(anonymous namespace)::PrintPPOutputPPCallbacks::PragmaComment(clang::SourceLocation, clang::IdentifierInfo const*, std::string const&)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks13PragmaMessageEN5clang14SourceLocationEN4llvm9StringRefE", "(anonymous namespace)::PrintPPOutputPPCallbacks::PragmaMessage(clang::SourceLocation, llvm::StringRef)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks12MacroDefinedERKN5clang5TokenEPKNS1_9MacroInfoE", "(anonymous namespace)::PrintPPOutputPPCallbacks::MacroDefined(clang::Token const&, clang::MacroInfo const*)"},
    {"_ZN12_GLOBAL__N_124PrintPPOutputPPCallbacks14MacroUndefinedERKN5clang5TokenEPKNS1_9MacroInfoE", "(anonymous namespace)::PrintPPOutputPPCallbacks::MacroUndefined(clang::Token const&, clang::MacroInfo const*)"},
    {"_Z20PrintMacroDefinitionRKN5clang14IdentifierInfoERKNS_9MacroInfoERNS_12PreprocessorERN4llvm11raw_ostreamE", "PrintMacroDefinition(clang::IdentifierInfo const&, clang::MacroInfo const&, clang::Preprocessor&, llvm::raw_ostream&)"},
    {"_Z14MacroIDComparePKvS0_", "MacroIDCompare(void const*, void const*)"},
    {"_ZN4llvm15SmallVectorImplISt4pairIPN5clang14IdentifierInfoEPNS2_9MacroInfoEEE6appendINS_16DenseMapIteratorIS4_S6_NS_12DenseMapInfoIS4_EENSB_IS6_EELb1EEEEEvT_SF_", "void llvm::SmallVectorImpl<std::pair<clang::IdentifierInfo*, clang::MacroInfo*> >::append<llvm::DenseMapIterator<clang::IdentifierInfo*, clang::MacroInfo*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::MacroInfo*>, true> >(llvm::DenseMapIterator<clang::IdentifierInfo*, clang::MacroInfo*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::MacroInfo*>, true>, llvm::DenseMapIterator<clang::IdentifierInfo*, clang::MacroInfo*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::MacroInfo*>, true>)"},
    {"_ZN5clang11DocumentXML9PrintStmtEPKNS_4StmtE", "clang::DocumentXML::PrintStmt(clang::Stmt const*)"},
    {"_ZN12_GLOBAL__N_17StmtXML11DumpSubTreeEPN5clang4StmtE", "(anonymous namespace)::StmtXML::DumpSubTree(clang::Stmt*)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_17StmtXMLEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::StmtXML, void>::Visit(clang::Stmt*)"},
    {"_ZN12_GLOBAL__N_17StmtXML19VisitBinaryOperatorEPN5clang14BinaryOperatorE", "(anonymous namespace)::StmtXML::VisitBinaryOperator(clang::BinaryOperator*)"},
    {"_ZN12_GLOBAL__N_17StmtXML21VisitCXXConstructExprEPN5clang16CXXConstructExprE", "(anonymous namespace)::StmtXML::VisitCXXConstructExpr(clang::CXXConstructExpr*)"},
    {"_ZN12_GLOBAL__N_17StmtXML13VisitCallExprEPN5clang8CallExprE", "(anonymous namespace)::StmtXML::VisitCallExpr(clang::CallExpr*)"},
    {"_ZN12_GLOBAL__N_17StmtXML18VisitUnaryOperatorEPN5clang13UnaryOperatorE", "(anonymous namespace)::StmtXML::VisitUnaryOperator(clang::UnaryOperator*)"},
    {"_ZN12_GLOBAL__N_17StmtXML9VisitStmtEPN5clang4StmtE", "(anonymous namespace)::StmtXML::VisitStmt(clang::Stmt*)"},
    {"_ZN12_GLOBAL__N_17StmtXML21VisitCXXNamedCastExprEPN5clang16CXXNamedCastExprE", "(anonymous namespace)::StmtXML::VisitCXXNamedCastExpr(clang::CXXNamedCastExpr*)"},
    {"_ZN5clang20TextDiagnosticBuffer16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::TextDiagnosticBuffer::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"},
    {"_ZNK5clang20TextDiagnosticBuffer16FlushDiagnosticsERNS_10DiagnosticE", "clang::TextDiagnosticBuffer::FlushDiagnostics(clang::Diagnostic&) const"},
    {"_ZN5clang20TextDiagnosticBufferD1Ev", "clang::TextDiagnosticBuffer::~TextDiagnosticBuffer()"},
    {"_ZN5clang20TextDiagnosticBufferD0Ev", "clang::TextDiagnosticBuffer::~TextDiagnosticBuffer()"},
    {"_ZNSt6vectorISt4pairIN5clang14SourceLocationESsESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string>*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >, std::pair<clang::SourceLocation, std::string> const&)"},
    {"_ZN5clang20TextDiagnosticBufferD2Ev", "clang::TextDiagnosticBuffer::~TextDiagnosticBuffer()"},
    {"_ZN5clang21TextDiagnosticPrinterC1ERN4llvm11raw_ostreamERKNS_17DiagnosticOptionsEb", "clang::TextDiagnosticPrinter::TextDiagnosticPrinter(llvm::raw_ostream&, clang::DiagnosticOptions const&, bool)"},
    {"_ZN5clang21TextDiagnosticPrinterC2ERN4llvm11raw_ostreamERKNS_17DiagnosticOptionsEb", "clang::TextDiagnosticPrinter::TextDiagnosticPrinter(llvm::raw_ostream&, clang::DiagnosticOptions const&, bool)"},
    {"_ZN5clang21TextDiagnosticPrinterD0Ev", "clang::TextDiagnosticPrinter::~TextDiagnosticPrinter()"},
    {"_ZN5clang21TextDiagnosticPrinterD1Ev", "clang::TextDiagnosticPrinter::~TextDiagnosticPrinter()"},
    {"_ZN5clang21TextDiagnosticPrinterD2Ev", "clang::TextDiagnosticPrinter::~TextDiagnosticPrinter()"},
    {"_ZN5clang21TextDiagnosticPrinter17PrintIncludeStackENS_14SourceLocationERKNS_13SourceManagerE", "clang::TextDiagnosticPrinter::PrintIncludeStack(clang::SourceLocation, clang::SourceManager const&)"},
    {"_ZN5clang21TextDiagnosticPrinter14HighlightRangeERKNS_15CharSourceRangeERKNS_13SourceManagerEjNS_6FileIDERSsRKSs", "clang::TextDiagnosticPrinter::HighlightRange(clang::CharSourceRange const&, clang::SourceManager const&, unsigned int, clang::FileID, std::string&, std::string const&)"},
    {"_ZN5clang21TextDiagnosticPrinter19EmitCaretDiagnosticENS_14SourceLocationEPNS_15CharSourceRangeEjRKNS_13SourceManagerEPKNS_9FixItHintEjjjjj", "clang::TextDiagnosticPrinter::EmitCaretDiagnostic(clang::SourceLocation, clang::CharSourceRange*, unsigned int, clang::SourceManager const&, clang::FixItHint const*, unsigned int, unsigned int, unsigned int, unsigned int, unsigned int)"},
    {"_ZN5clang21TextDiagnosticPrinter16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::TextDiagnosticPrinter::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"},
    {"_Z13findEndOfWordjRKN4llvm15SmallVectorImplIcEEjjj", "findEndOfWord(unsigned int, llvm::SmallVectorImpl<char> const&, unsigned int, unsigned int, unsigned int)"},
    {"_ZNK5clang13SourceManager16getDecomposedLocENS_14SourceLocationE", "clang::SourceManager::getDecomposedLoc(clang::SourceLocation) const"},
    {"_ZNK5clang13SourceManager29getDecomposedInstantiationLocENS_14SourceLocationE", "clang::SourceManager::getDecomposedInstantiationLoc(clang::SourceLocation) const"},
    {"_ZN5clang21TextDiagnosticPrinter15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::TextDiagnosticPrinter::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"},
    {"_ZN5clang21TextDiagnosticPrinter13EndSourceFileEv", "clang::TextDiagnosticPrinter::EndSourceFile()"},
    {"_ZNK5clang13SourceManager16isOffsetInFileIDENS_6FileIDEj", "clang::SourceManager::isOffsetInFileID(clang::FileID, unsigned int) const"},
    {"_ZN5clang11DocumentXML14addParentTypesEPKNS_4TypeE", "clang::DocumentXML::addParentTypes(clang::Type const*)"},
    {"_ZN5clang11DocumentXML14writeTypeToXMLEPKNS_4TypeE", "clang::DocumentXML::writeTypeToXML(clang::Type const*)"},
    {"_ZN5clang11DocumentXML14writeTypeToXMLERKNS_8QualTypeE", "clang::DocumentXML::writeTypeToXML(clang::QualType const&)"},
    {"_ZN5clang3XML12_GLOBAL__N_110TypeWriter9VisitTypeEPKNS_4TypeE", "clang::XML::(anonymous namespace)::TypeWriter::VisitType(clang::Type const*)"},
    {"_ZN5clang11TypeVisitorINS_11DocumentXML9TypeAdderEvE5VisitEPKNS_4TypeE", "clang::TypeVisitor<clang::DocumentXML::TypeAdder, void>::Visit(clang::Type const*)"},
    {"_ZN5clang11DocumentXML12addAttributeIN4llvm5APIntEEEvPKcRKT_", "void clang::DocumentXML::addAttribute<llvm::APInt>(char const*, llvm::APInt const&)"},
    {"_ZN5clang11DocumentXML12addAttributeINS_10Qualifiers2GCEEEvPKcRKT_", "void clang::DocumentXML::addAttribute<clang::Qualifiers::GC>(char const*, clang::Qualifiers::GC const&)"},
    {"_ZN5clang23VerifyDiagnosticsClientC1ERNS_10DiagnosticEPNS_16DiagnosticClientE", "clang::VerifyDiagnosticsClient::VerifyDiagnosticsClient(clang::Diagnostic&, clang::DiagnosticClient*)"},
    {"_ZN5clang23VerifyDiagnosticsClientC2ERNS_10DiagnosticEPNS_16DiagnosticClientE", "clang::VerifyDiagnosticsClient::VerifyDiagnosticsClient(clang::Diagnostic&, clang::DiagnosticClient*)"},
    {"_ZN5clang23VerifyDiagnosticsClientD0Ev", "clang::VerifyDiagnosticsClient::~VerifyDiagnosticsClient()"},
    {"_ZN5clang23VerifyDiagnosticsClientD1Ev", "clang::VerifyDiagnosticsClient::~VerifyDiagnosticsClient()"},
    {"_ZN5clang23VerifyDiagnosticsClientD2Ev", "clang::VerifyDiagnosticsClient::~VerifyDiagnosticsClient()"},
    {"_ZN5clang23VerifyDiagnosticsClient16CheckDiagnosticsEv", "clang::VerifyDiagnosticsClient::CheckDiagnostics()"},
    {"_ZN5clang23VerifyDiagnosticsClient15BeginSourceFileERKNS_11LangOptionsEPKNS_12PreprocessorE", "clang::VerifyDiagnosticsClient::BeginSourceFile(clang::LangOptions const&, clang::Preprocessor const*)"},
    {"_ZN5clang23VerifyDiagnosticsClient13EndSourceFileEv", "clang::VerifyDiagnosticsClient::EndSourceFile()"},
    {"_ZN5clang23VerifyDiagnosticsClient16HandleDiagnosticENS_10Diagnostic5LevelERKNS_14DiagnosticInfoE", "clang::VerifyDiagnosticsClient::HandleDiagnostic(clang::Diagnostic::Level, clang::DiagnosticInfo const&)"},
    {"_Z12PrintProblemRN5clang10DiagnosticEPNS_13SourceManagerEN9__gnu_cxx17__normal_iteratorIPKSt4pairINS_14SourceLocationESsESt6vectorIS8_SaIS8_EEEESE_PKcb", "PrintProblem(clang::Diagnostic&, clang::SourceManager*, __gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >, __gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >, char const*, bool)"},
    {"_Z10CheckListsRN5clang10DiagnosticERNS_13SourceManagerEPKcRSt6vectorIPN12_GLOBAL__N_19DirectiveESaIS9_EEN9__gnu_cxx17__normal_iteratorIPKSt4pairINS_14SourceLocationESsES6_ISH_SaISH_EEEESM_", "CheckLists(clang::Diagnostic&, clang::SourceManager&, char const*, std::vector<(anonymous namespace)::Directive*, std::allocator<(anonymous namespace)::Directive*> >&, __gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >, __gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >)"},
    {"_ZNSt6vectorIPN12_GLOBAL__N_19DirectiveESaIS2_EE9push_backERKS2_", "std::vector<(anonymous namespace)::Directive*, std::allocator<(anonymous namespace)::Directive*> >::push_back((anonymous namespace)::Directive* const&)"},
    {"_ZN12_GLOBAL__N_117StandardDirectiveD1Ev", "(anonymous namespace)::StandardDirective::~StandardDirective()"},
    {"_ZN12_GLOBAL__N_117StandardDirectiveD0Ev", "(anonymous namespace)::StandardDirective::~StandardDirective()"},
    {"_ZN12_GLOBAL__N_117StandardDirective7isValidERSs", "(anonymous namespace)::StandardDirective::isValid(std::string&)"},
    {"_ZN12_GLOBAL__N_117StandardDirective5MatchERKSs", "(anonymous namespace)::StandardDirective::Match(std::string const&)"},
    {"_ZN12_GLOBAL__N_19DirectiveD1Ev", "(anonymous namespace)::Directive::~Directive()"},
    {"_ZN12_GLOBAL__N_19DirectiveD0Ev", "(anonymous namespace)::Directive::~Directive()"},
    {"_ZN12_GLOBAL__N_114RegexDirectiveD1Ev", "(anonymous namespace)::RegexDirective::~RegexDirective()"},
    {"_ZN12_GLOBAL__N_114RegexDirectiveD0Ev", "(anonymous namespace)::RegexDirective::~RegexDirective()"},
    {"_ZN12_GLOBAL__N_114RegexDirective7isValidERSs", "(anonymous namespace)::RegexDirective::isValid(std::string&)"},
    {"_ZN12_GLOBAL__N_114RegexDirective5MatchERKSs", "(anonymous namespace)::RegexDirective::Match(std::string const&)"},
    {"_ZNSt6vectorISt4pairIN5clang14SourceLocationESsESaIS3_EE19_M_range_initializeIN9__gnu_cxx17__normal_iteratorIPKS3_S5_EEEEvT_SC_St20forward_iterator_tag", "void std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > >::_M_range_initialize<__gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > > >(__gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >, __gnu_cxx::__normal_iterator<std::pair<clang::SourceLocation, std::string> const*, std::vector<std::pair<clang::SourceLocation, std::string>, std::allocator<std::pair<clang::SourceLocation, std::string> > > >, std::forward_iterator_tag)"},
    {"_ZSt6searchIPKcS1_ET_S2_S2_T0_S3_", "char const* std::search<char const*, char const*>(char const*, char const*, char const*, char const*)"},
    {"_ZN5clang21ProcessWarningOptionsERNS_10DiagnosticERKNS_17DiagnosticOptionsE", "clang::ProcessWarningOptions(clang::Diagnostic&, clang::DiagnosticOptions const&)"},
    {"_ZN5clang6driver6ActionD0Ev", "clang::driver::Action::~Action()"},
    {"_ZN5clang6driver6ActionD1Ev", "clang::driver::Action::~Action()"},
    {"_ZN5clang6driver6ActionD2Ev", "clang::driver::Action::~Action()"},
    {"_ZN5clang6driver6Action12getClassNameENS1_11ActionClassE", "clang::driver::Action::getClassName(clang::driver::Action::ActionClass)"},
    {"_ZN5clang6driver11InputActionC1ERKNS0_3ArgENS0_5types2IDE", "clang::driver::InputAction::InputAction(clang::driver::Arg const&, clang::driver::types::ID)"},
    {"_ZN5clang6driver11InputActionC2ERKNS0_3ArgENS0_5types2IDE", "clang::driver::InputAction::InputAction(clang::driver::Arg const&, clang::driver::types::ID)"},
    {"_ZN5clang6driver14BindArchActionC1EPNS0_6ActionEPKc", "clang::driver::BindArchAction::BindArchAction(clang::driver::Action*, char const*)"},
    {"_ZN5clang6driver14BindArchActionC2EPNS0_6ActionEPKc", "clang::driver::BindArchAction::BindArchAction(clang::driver::Action*, char const*)"},
    {"_ZN5clang6driver9JobActionC1ENS0_6Action11ActionClassEPS2_NS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver9JobActionC2ENS0_6Action11ActionClassEPS2_NS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver9JobActionC1ENS0_6Action11ActionClassERKN4llvm11SmallVectorIPS2_Lj3EEENS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, llvm::SmallVector<clang::driver::Action*, 3u> const&, clang::driver::types::ID)"},
    {"_ZN5clang6driver9JobActionC2ENS0_6Action11ActionClassERKN4llvm11SmallVectorIPS2_Lj3EEENS0_5types2IDE", "clang::driver::JobAction::JobAction(clang::driver::Action::ActionClass, llvm::SmallVector<clang::driver::Action*, 3u> const&, clang::driver::types::ID)"},
    {"_ZN5clang6driver19PreprocessJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::PreprocessJobAction::PreprocessJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver19PreprocessJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::PreprocessJobAction::PreprocessJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver19PrecompileJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::PrecompileJobAction::PrecompileJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver19PrecompileJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::PrecompileJobAction::PrecompileJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver16AnalyzeJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::AnalyzeJobAction::AnalyzeJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver16AnalyzeJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::AnalyzeJobAction::AnalyzeJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver16CompileJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::CompileJobAction::CompileJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver16CompileJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::CompileJobAction::CompileJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver17AssembleJobActionC1EPNS0_6ActionENS0_5types2IDE", "clang::driver::AssembleJobAction::AssembleJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver17AssembleJobActionC2EPNS0_6ActionENS0_5types2IDE", "clang::driver::AssembleJobAction::AssembleJobAction(clang::driver::Action*, clang::driver::types::ID)"},
    {"_ZN5clang6driver13LinkJobActionC1ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LinkJobAction::LinkJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"},
    {"_ZN5clang6driver13LinkJobActionC2ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LinkJobAction::LinkJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"},
    {"_ZN5clang6driver13LipoJobActionC1ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LipoJobAction::LipoJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"},
    {"_ZN5clang6driver13LipoJobActionC2ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::LipoJobAction::LipoJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"},
    {"_ZN5clang6driver17DsymutilJobActionC1ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::DsymutilJobAction::DsymutilJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"},
    {"_ZN5clang6driver17DsymutilJobActionC2ERN4llvm11SmallVectorIPNS0_6ActionELj3EEENS0_5types2IDE", "clang::driver::DsymutilJobAction::DsymutilJobAction(llvm::SmallVector<clang::driver::Action*, 3u>&, clang::driver::types::ID)"},
    {"_ZN5clang6driver17DsymutilJobActionD1Ev", "clang::driver::DsymutilJobAction::~DsymutilJobAction()"},
    {"_ZN5clang6driver17DsymutilJobActionD0Ev", "clang::driver::DsymutilJobAction::~DsymutilJobAction()"},
    {"_ZN5clang6driver13LipoJobActionD1Ev", "clang::driver::LipoJobAction::~LipoJobAction()"},
    {"_ZN5clang6driver13LipoJobActionD0Ev", "clang::driver::LipoJobAction::~LipoJobAction()"},
    {"_ZN5clang6driver13LinkJobActionD1Ev", "clang::driver::LinkJobAction::~LinkJobAction()"},
    {"_ZN5clang6driver13LinkJobActionD0Ev", "clang::driver::LinkJobAction::~LinkJobAction()"},
    {"_ZN5clang6driver17AssembleJobActionD1Ev", "clang::driver::AssembleJobAction::~AssembleJobAction()"},
    {"_ZN5clang6driver17AssembleJobActionD0Ev", "clang::driver::AssembleJobAction::~AssembleJobAction()"},
    {"_ZN5clang6driver16CompileJobActionD1Ev", "clang::driver::CompileJobAction::~CompileJobAction()"},
    {"_ZN5clang6driver16CompileJobActionD0Ev", "clang::driver::CompileJobAction::~CompileJobAction()"},
    {"_ZN5clang6driver16AnalyzeJobActionD1Ev", "clang::driver::AnalyzeJobAction::~AnalyzeJobAction()"},
    {"_ZN5clang6driver16AnalyzeJobActionD0Ev", "clang::driver::AnalyzeJobAction::~AnalyzeJobAction()"},
    {"_ZN5clang6driver19PrecompileJobActionD1Ev", "clang::driver::PrecompileJobAction::~PrecompileJobAction()"},
    {"_ZN5clang6driver19PrecompileJobActionD0Ev", "clang::driver::PrecompileJobAction::~PrecompileJobAction()"},
    {"_ZN5clang6driver19PreprocessJobActionD1Ev", "clang::driver::PreprocessJobAction::~PreprocessJobAction()"},
    {"_ZN5clang6driver19PreprocessJobActionD0Ev", "clang::driver::PreprocessJobAction::~PreprocessJobAction()"},
    {"_ZN5clang6driver9JobActionD1Ev", "clang::driver::JobAction::~JobAction()"},
    {"_ZN5clang6driver9JobActionD0Ev", "clang::driver::JobAction::~JobAction()"},
    {"_ZN5clang6driver14BindArchActionD1Ev", "clang::driver::BindArchAction::~BindArchAction()"},
    {"_ZN5clang6driver14BindArchActionD0Ev", "clang::driver::BindArchAction::~BindArchAction()"},
    {"_ZN5clang6driver11InputActionD1Ev", "clang::driver::InputAction::~InputAction()"},
    {"_ZN5clang6driver11InputActionD0Ev", "clang::driver::InputAction::~InputAction()"},
    {"_ZN4llvm15SmallVectorImplIPN5clang6driver6ActionEEaSERKS5_", "llvm::SmallVectorImpl<clang::driver::Action*>::operator=(llvm::SmallVectorImpl<clang::driver::Action*> const&)"},
    {"_ZN5clang6driver3ArgC1EPKNS0_6OptionEjPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, clang::driver::Arg const*)"},
    {"_ZN5clang6driver3ArgC2EPKNS0_6OptionEjPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, clang::driver::Arg const*)"},
    {"_ZN5clang6driver3ArgC1EPKNS0_6OptionEjPKcPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, clang::driver::Arg const*)"},
    {"_ZN5clang6driver3ArgC2EPKNS0_6OptionEjPKcPKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, clang::driver::Arg const*)"},
    {"_ZN5clang6driver3ArgC1EPKNS0_6OptionEjPKcS6_PKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, char const*, clang::driver::Arg const*)"},
    {"_ZN5clang6driver3ArgC2EPKNS0_6OptionEjPKcS6_PKS1_", "clang::driver::Arg::Arg(clang::driver::Option const*, unsigned int, char const*, char const*, clang::driver::Arg const*)"},
    {"_ZN5clang6driver3ArgD1Ev", "clang::driver::Arg::~Arg()"},
    {"_ZN5clang6driver3ArgD2Ev", "clang::driver::Arg::~Arg()"},
    {"_ZNK5clang6driver3Arg4dumpEv", "clang::driver::Arg::dump() const"},
    {"_ZNK5clang6driver3Arg11getAsStringERKNS0_7ArgListE", "clang::driver::Arg::getAsString(clang::driver::ArgList const&) const"},
    {"_ZNK5clang6driver3Arg6renderERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::Arg::render(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver3Arg13renderAsInputERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::Arg::renderAsInput(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZN5clang6driver12arg_iterator13SkipToNextArgEv", "clang::driver::arg_iterator::SkipToNextArg()"},
    {"_ZN5clang6driver7ArgListC1Ev", "clang::driver::ArgList::ArgList()"},
    {"_ZN5clang6driver7ArgListC2Ev", "clang::driver::ArgList::ArgList()"},
    {"_ZN5clang6driver7ArgListD0Ev", "clang::driver::ArgList::~ArgList()"},
    {"_ZN5clang6driver7ArgListD1Ev", "clang::driver::ArgList::~ArgList()"},
    {"_ZN5clang6driver7ArgListD2Ev", "clang::driver::ArgList::~ArgList()"},
    {"_ZN5clang6driver7ArgList6appendEPNS0_3ArgE", "clang::driver::ArgList::append(clang::driver::Arg*)"},
    {"_ZNK5clang6driver7ArgList17getLastArgNoClaimENS0_12OptSpecifierE", "clang::driver::ArgList::getLastArgNoClaim(clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierE", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierES2_", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierES2_S2_", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList10getLastArgENS0_12OptSpecifierES2_S2_S2_", "clang::driver::ArgList::getLastArg(clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList7hasFlagENS0_12OptSpecifierES2_b", "clang::driver::ArgList::hasFlag(clang::driver::OptSpecifier, clang::driver::OptSpecifier, bool) const"},
    {"_ZNK5clang6driver7ArgList15getLastArgValueENS0_12OptSpecifierEN4llvm9StringRefE", "clang::driver::ArgList::getLastArgValue(clang::driver::OptSpecifier, llvm::StringRef) const"},
    {"_ZNK5clang6driver7ArgList18getLastArgIntValueENS0_12OptSpecifierEiRNS_10DiagnosticE", "clang::driver::ArgList::getLastArgIntValue(clang::driver::OptSpecifier, int, clang::Diagnostic&) const"},
    {"_ZNK5clang6driver7ArgList15getAllArgValuesENS0_12OptSpecifierE", "clang::driver::ArgList::getAllArgValues(clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList15AddAllArgValuesERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierES8_S8_", "clang::driver::ArgList::AddAllArgValues(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList10AddLastArgERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierE", "clang::driver::ArgList::AddLastArg(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList10AddAllArgsERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierES8_S8_", "clang::driver::ArgList::AddAllArgs(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier, clang::driver::OptSpecifier, clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList20AddAllArgsTranslatedERN4llvm11SmallVectorIPKcLj16EEENS0_12OptSpecifierES5_b", "clang::driver::ArgList::AddAllArgsTranslated(llvm::SmallVector<char const*, 16u>&, clang::driver::OptSpecifier, char const*, bool) const"},
    {"_ZNK5clang6driver7ArgList13MakeArgStringERKN4llvm5TwineE", "clang::driver::ArgList::MakeArgString(llvm::Twine const&) const"},
    {"_ZNK5clang6driver7ArgList12ClaimAllArgsENS0_12OptSpecifierE", "clang::driver::ArgList::ClaimAllArgs(clang::driver::OptSpecifier) const"},
    {"_ZNK5clang6driver7ArgList24GetOrMakeJoinedArgStringEjN4llvm9StringRefES3_", "clang::driver::ArgList::GetOrMakeJoinedArgString(unsigned int, llvm::StringRef, llvm::StringRef) const"},
    {"_ZN5clang6driver12InputArgListC1EPKPKcS5_", "clang::driver::InputArgList::InputArgList(char const* const*, char const* const*)"},
    {"_ZN5clang6driver12InputArgListC2EPKPKcS5_", "clang::driver::InputArgList::InputArgList(char const* const*, char const* const*)"},
    {"_ZN5clang6driver12InputArgListD0Ev", "clang::driver::InputArgList::~InputArgList()"},
    {"_ZN5clang6driver12InputArgListD1Ev", "clang::driver::InputArgList::~InputArgList()"},
    {"_ZN5clang6driver12InputArgListD2Ev", "clang::driver::InputArgList::~InputArgList()"},
    {"_ZNK5clang6driver12InputArgList9MakeIndexEN4llvm9StringRefE", "clang::driver::InputArgList::MakeIndex(llvm::StringRef) const"},
    {"_ZNK5clang6driver12InputArgList9MakeIndexEN4llvm9StringRefES3_", "clang::driver::InputArgList::MakeIndex(llvm::StringRef, llvm::StringRef) const"},
    {"_ZNK5clang6driver12InputArgList13MakeArgStringEN4llvm9StringRefE", "clang::driver::InputArgList::MakeArgString(llvm::StringRef) const"},
    {"_ZN5clang6driver14DerivedArgListC1ERKNS0_12InputArgListE", "clang::driver::DerivedArgList::DerivedArgList(clang::driver::InputArgList const&)"},
    {"_ZN5clang6driver14DerivedArgListC2ERKNS0_12InputArgListE", "clang::driver::DerivedArgList::DerivedArgList(clang::driver::InputArgList const&)"},
    {"_ZN5clang6driver14DerivedArgListD0Ev", "clang::driver::DerivedArgList::~DerivedArgList()"},
    {"_ZN5clang6driver14DerivedArgListD1Ev", "clang::driver::DerivedArgList::~DerivedArgList()"},
    {"_ZN5clang6driver14DerivedArgListD2Ev", "clang::driver::DerivedArgList::~DerivedArgList()"},
    {"_ZNK5clang6driver14DerivedArgList13MakeArgStringEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakeArgString(llvm::StringRef) const"},
    {"_ZNK5clang6driver14DerivedArgList11MakeFlagArgEPKNS0_3ArgEPKNS0_6OptionE", "clang::driver::DerivedArgList::MakeFlagArg(clang::driver::Arg const*, clang::driver::Option const*) const"},
    {"_ZNK5clang6driver14DerivedArgList17MakePositionalArgEPKNS0_3ArgEPKNS0_6OptionEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakePositionalArg(clang::driver::Arg const*, clang::driver::Option const*, llvm::StringRef) const"},
    {"_ZNK5clang6driver14DerivedArgList15MakeSeparateArgEPKNS0_3ArgEPKNS0_6OptionEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakeSeparateArg(clang::driver::Arg const*, clang::driver::Option const*, llvm::StringRef) const"},
    {"_ZNK5clang6driver14DerivedArgList13MakeJoinedArgEPKNS0_3ArgEPKNS0_6OptionEN4llvm9StringRefE", "clang::driver::DerivedArgList::MakeJoinedArg(clang::driver::Arg const*, clang::driver::Option const*, llvm::StringRef) const"},
    {"_ZNK5clang6driver12InputArgList12getArgStringEj", "clang::driver::InputArgList::getArgString(unsigned int) const"},
    {"_ZNK5clang6driver12InputArgList21getNumInputArgStringsEv", "clang::driver::InputArgList::getNumInputArgStrings() const"},
    {"_ZNK5clang6driver14DerivedArgList12getArgStringEj", "clang::driver::DerivedArgList::getArgString(unsigned int) const"},
    {"_ZNK5clang6driver14DerivedArgList21getNumInputArgStringsEv", "clang::driver::DerivedArgList::getNumInputArgStrings() const"},
    {"_ZNSt6vectorISsSaISsEE22_M_initialize_dispatchIPPKcEEvT_S6_St12__false_type", "void std::vector<std::string, std::allocator<std::string> >::_M_initialize_dispatch<char const**>(char const**, char const**, std::__false_type)"},
    {"_ZN5clang6driver19createCC1AsOptTableEv", "clang::driver::createCC1AsOptTable()"},
    {"_ZN5clang6driver17createCC1OptTableEv", "clang::driver::createCC1OptTable()"},
    {"_ZN5clang6driver11CompilationC1ERKNS0_6DriverERKNS0_9ToolChainEPNS0_12InputArgListEPNS0_14DerivedArgListE", "clang::driver::Compilation::Compilation(clang::driver::Driver const&, clang::driver::ToolChain const&, clang::driver::InputArgList*, clang::driver::DerivedArgList*)"},
    {"_ZN5clang6driver11CompilationC2ERKNS0_6DriverERKNS0_9ToolChainEPNS0_12InputArgListEPNS0_14DerivedArgListE", "clang::driver::Compilation::Compilation(clang::driver::Driver const&, clang::driver::ToolChain const&, clang::driver::InputArgList*, clang::driver::DerivedArgList*)"},
    {"_ZN5clang6driver11CompilationD1Ev", "clang::driver::Compilation::~Compilation()"},
    {"_ZN5clang6driver11CompilationD2Ev", "clang::driver::Compilation::~Compilation()"},
    {"_ZN5clang6driver11Compilation19getArgsForToolChainEPKNS0_9ToolChainEPKc", "clang::driver::Compilation::getArgsForToolChain(clang::driver::ToolChain const*, char const*)"},
    {"_ZNK5clang6driver11Compilation8PrintJobERN4llvm11raw_ostreamERKNS0_3JobEPKcb", "clang::driver::Compilation::PrintJob(llvm::raw_ostream&, clang::driver::Job const&, char const*, bool) const"},
    {"_ZNK5clang6driver11Compilation15CleanupFileListERKN4llvm11SmallVectorIPKcLj16EEEb", "clang::driver::Compilation::CleanupFileList(llvm::SmallVector<char const*, 16u> const&, bool) const"},
    {"_ZNK5clang6driver11Compilation14ExecuteCommandERKNS0_7CommandERPS3_", "clang::driver::Compilation::ExecuteCommand(clang::driver::Command const&, clang::driver::Command const*&) const"},
    {"_ZNK5clang6driver11Compilation10ExecuteJobERKNS0_3JobERPKNS0_7CommandE", "clang::driver::Compilation::ExecuteJob(clang::driver::Job const&, clang::driver::Command const*&) const"},
    {"_ZNK4llvm8DenseMapISt4pairIPKN5clang6driver9ToolChainEPKcEPNS3_14DerivedArgListENS_12DenseMapInfoIS9_EENSC_ISB_EEE15LookupBucketForERKS9_RPS1_IS9_SB_E", "llvm::DenseMap<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*, llvm::DenseMapInfo<std::pair<clang::driver::ToolChain const*, char const*> >, llvm::DenseMapInfo<clang::driver::DerivedArgList*> >::LookupBucketFor(std::pair<clang::driver::ToolChain const*, char const*> const&, std::pair<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*>*&) const"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang6driver9ToolChainEPKcEPNS3_14DerivedArgListENS_12DenseMapInfoIS9_EENSC_ISB_EEE16InsertIntoBucketERKS9_RKSB_PS1_IS9_SB_E", "llvm::DenseMap<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*, llvm::DenseMapInfo<std::pair<clang::driver::ToolChain const*, char const*> >, llvm::DenseMapInfo<clang::driver::DerivedArgList*> >::InsertIntoBucket(std::pair<clang::driver::ToolChain const*, char const*> const&, clang::driver::DerivedArgList* const&, std::pair<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*>*)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang6driver9ToolChainEPKcEPNS3_14DerivedArgListENS_12DenseMapInfoIS9_EENSC_ISB_EEE4growEj", "llvm::DenseMap<std::pair<clang::driver::ToolChain const*, char const*>, clang::driver::DerivedArgList*, llvm::DenseMapInfo<std::pair<clang::driver::ToolChain const*, char const*> >, llvm::DenseMapInfo<clang::driver::DerivedArgList*> >::grow(unsigned int)"},
    {"_ZN5clang6driver6DriverC1EN4llvm9StringRefES3_S3_bbRNS_10DiagnosticE", "clang::driver::Driver::Driver(llvm::StringRef, llvm::StringRef, llvm::StringRef, bool, bool, clang::Diagnostic&)"},
    {"_ZN5clang6driver6DriverC2EN4llvm9StringRefES3_S3_bbRNS_10DiagnosticE", "clang::driver::Driver::Driver(llvm::StringRef, llvm::StringRef, llvm::StringRef, bool, bool, clang::Diagnostic&)"},
    {"_ZN5clang6driver6DriverD1Ev", "clang::driver::Driver::~Driver()"},
    {"_ZN5clang6driver6DriverD2Ev", "clang::driver::Driver::~Driver()"},
    {"_ZN5clang6driver6Driver15ParseArgStringsEPPKcS4_", "clang::driver::Driver::ParseArgStrings(char const**, char const**)"},
    {"_ZNK5clang6driver6Driver18TranslateInputArgsERKNS0_12InputArgListE", "clang::driver::Driver::TranslateInputArgs(clang::driver::InputArgList const&) const"},
    {"_ZN5clang6driver6Driver16BuildCompilationEiPPKc", "clang::driver::Driver::BuildCompilation(int, char const**)"},
    {"_ZNK5clang6driver6Driver11GetHostInfoEPKc", "clang::driver::Driver::GetHostInfo(char const*) const"},
    {"_ZNK5clang6driver6Driver12PrintOptionsERKNS0_7ArgListE", "clang::driver::Driver::PrintOptions(clang::driver::ArgList const&) const"},
    {"_ZN5clang6driver6Driver19HandleImmediateArgsERKNS0_11CompilationE", "clang::driver::Driver::HandleImmediateArgs(clang::driver::Compilation const&)"},
    {"_ZNK5clang6driver6Driver21BuildUniversalActionsERKNS0_9ToolChainERKNS0_7ArgListERN4llvm11SmallVectorIPNS0_6ActionELj3EEE", "clang::driver::Driver::BuildUniversalActions(clang::driver::ToolChain const&, clang::driver::ArgList const&, llvm::SmallVector<clang::driver::Action*, 3u>&) const"},
    {"_ZNK5clang6driver6Driver12BuildActionsERKNS0_9ToolChainERKNS0_7ArgListERN4llvm11SmallVectorIPNS0_6ActionELj3EEE", "clang::driver::Driver::BuildActions(clang::driver::ToolChain const&, clang::driver::ArgList const&, llvm::SmallVector<clang::driver::Action*, 3u>&) const"},
    {"_ZNK5clang6driver6Driver12PrintActionsERKNS0_11CompilationE", "clang::driver::Driver::PrintActions(clang::driver::Compilation const&) const"},
    {"_ZNK5clang6driver6Driver9BuildJobsERNS0_11CompilationE", "clang::driver::Driver::BuildJobs(clang::driver::Compilation&) const"},
    {"_ZNK5clang6driver6Driver18ExecuteCompilationERKNS0_11CompilationE", "clang::driver::Driver::ExecuteCompilation(clang::driver::Compilation const&) const"},
    {"_ZNK5clang6driver6Driver9PrintHelpEb", "clang::driver::Driver::PrintHelp(bool) const"},
    {"_ZNK5clang6driver6Driver12PrintVersionERKNS0_11CompilationERN4llvm11raw_ostreamE", "clang::driver::Driver::PrintVersion(clang::driver::Compilation const&, llvm::raw_ostream&) const"},
    {"_ZNK5clang6driver6Driver11GetFilePathEPKcRKNS0_9ToolChainE", "clang::driver::Driver::GetFilePath(char const*, clang::driver::ToolChain const&) const"},
    {"_ZNK5clang6driver6Driver14GetProgramPathEPKcRKNS0_9ToolChainEb", "clang::driver::Driver::GetProgramPath(char const*, clang::driver::ToolChain const&, bool) const"},
    {"_Z13PrintActions1RKN5clang6driver11CompilationEPNS0_6ActionERSt3mapIS5_jSt4lessIS5_ESaISt4pairIKS5_jEEE", "PrintActions1(clang::driver::Compilation const&, clang::driver::Action*, std::map<clang::driver::Action*, unsigned int, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >&)"},
    {"_Z21ContainsCompileActionPKN5clang6driver6ActionE", "ContainsCompileAction(clang::driver::Action const*)"},
    {"_ZNK5clang6driver6Driver20ConstructPhaseActionERKNS0_7ArgListENS0_6phases2IDEPNS0_6ActionE", "clang::driver::Driver::ConstructPhaseAction(clang::driver::ArgList const&, clang::driver::phases::ID, clang::driver::Action*) const"},
    {"_ZNK5clang6driver6Driver18BuildJobsForActionERNS0_11CompilationEPKNS0_6ActionEPKNS0_9ToolChainEPKcbSB_RNS0_9InputInfoE", "clang::driver::Driver::BuildJobsForAction(clang::driver::Compilation&, clang::driver::Action const*, clang::driver::ToolChain const*, char const*, bool, char const*, clang::driver::InputInfo&) const"},
    {"_ZNK5clang6driver6Driver18GetNamedOutputPathERNS0_11CompilationERKNS0_9JobActionEPKcb", "clang::driver::Driver::GetNamedOutputPath(clang::driver::Compilation&, clang::driver::JobAction const&, char const*, bool) const"},
    {"_ZNK5clang6driver6Driver16GetTemporaryPathEPKc", "clang::driver::Driver::GetTemporaryPath(char const*) const"},
    {"_ZNK5clang6driver6Driver22ShouldUseClangCompilerERKNS0_11CompilationERKNS0_9JobActionERKN4llvm6TripleE", "clang::driver::Driver::ShouldUseClangCompiler(clang::driver::Compilation const&, clang::driver::JobAction const&, llvm::Triple const&) const"},
    {"_ZN5clang6driver6Driver17GetReleaseVersionEPKcRjS4_S4_Rb", "clang::driver::Driver::GetReleaseVersion(char const*, unsigned int&, unsigned int&, unsigned int&, bool&)"},
    {"_ZN4llvm22PrettyStackTraceStringD1Ev", "llvm::PrettyStackTraceString::~PrettyStackTraceString()"},
    {"_ZN4llvm9StringSetINS_15MallocAllocatorEE6insertENS_9StringRefE", "llvm::StringSet<llvm::MallocAllocator>::insert(llvm::StringRef)"},
    {"_ZNK5clang6driver9InputInfo11getAsStringEv", "clang::driver::InputInfo::getAsString() const"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang6driver9InputInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::driver::InputInfo, false>::grow(unsigned long)"},
    {"_ZN4llvm23SmallVectorTemplateBaseISsLb0EE4growEm", "llvm::SmallVectorTemplateBase<std::string, false>::grow(unsigned long)"},
    {"_ZNSt8_Rb_treeIN4llvm6Triple8ArchTypeES2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E", "std::_Rb_tree<llvm::Triple::ArchType, llvm::Triple::ArchType, std::_Identity<llvm::Triple::ArchType>, std::less<llvm::Triple::ArchType>, std::allocator<llvm::Triple::ArchType> >::_M_erase(std::_Rb_tree_node<llvm::Triple::ArchType>*)"},
    {"_ZNSt8_Rb_treeIN4llvm6Triple8ArchTypeES2_St9_IdentityIS2_ESt4lessIS2_ESaIS2_EE16_M_insert_uniqueERKS2_", "std::_Rb_tree<llvm::Triple::ArchType, llvm::Triple::ArchType, std::_Identity<llvm::Triple::ArchType>, std::less<llvm::Triple::ArchType>, std::allocator<llvm::Triple::ArchType> >::_M_insert_unique(llvm::Triple::ArchType const&)"},
    {"_ZNSt8_Rb_treeIPN5clang6driver6ActionESt4pairIKS3_jESt10_Select1stIS6_ESt4lessIS3_ESaIS6_EE8_M_eraseEPSt13_Rb_tree_nodeIS6_E", "std::_Rb_tree<clang::driver::Action*, std::pair<clang::driver::Action* const, unsigned int>, std::_Select1st<std::pair<clang::driver::Action* const, unsigned int> >, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::driver::Action* const, unsigned int> >*)"},
    {"_ZNK4llvm18raw_string_ostream11current_posEv", "llvm::raw_string_ostream::current_pos() const"},
    {"_ZNSt8_Rb_treeIPN5clang6driver6ActionESt4pairIKS3_jESt10_Select1stIS6_ESt4lessIS3_ESaIS6_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS6_ERKS6_", "std::_Rb_tree<clang::driver::Action*, std::pair<clang::driver::Action* const, unsigned int>, std::_Select1st<std::pair<clang::driver::Action* const, unsigned int> >, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::driver::Action* const, unsigned int> >, std::pair<clang::driver::Action* const, unsigned int> const&)"},
    {"_ZNSt8_Rb_treeIPN5clang6driver6ActionESt4pairIKS3_jESt10_Select1stIS6_ESt4lessIS3_ESaIS6_EE16_M_insert_uniqueERKS6_", "std::_Rb_tree<clang::driver::Action*, std::pair<clang::driver::Action* const, unsigned int>, std::_Select1st<std::pair<clang::driver::Action* const, unsigned int> >, std::less<clang::driver::Action*>, std::allocator<std::pair<clang::driver::Action* const, unsigned int> > >::_M_insert_unique(std::pair<clang::driver::Action* const, unsigned int> const&)"},
    {"_ZN4llvm6TripleC2ENS_9StringRefES1_S1_", "llvm::Triple::Triple(llvm::StringRef, llvm::StringRef, llvm::StringRef)"},
    {"_ZN4llvm22PrettyStackTraceStringD0Ev", "llvm::PrettyStackTraceString::~PrettyStackTraceString()"},
    {"_ZN5clang6driver20createDriverOptTableEv", "clang::driver::createDriverOptTable()"},
    {"_ZN5clang6driver8HostInfoC1ERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::HostInfo::HostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver8HostInfoC2ERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::HostInfo::HostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver8HostInfoD0Ev", "clang::driver::HostInfo::~HostInfo()"},
    {"_ZN5clang6driver8HostInfoD1Ev", "clang::driver::HostInfo::~HostInfo()"},
    {"_ZN5clang6driver8HostInfoD2Ev", "clang::driver::HostInfo::~HostInfo()"},
    {"_ZN5clang6driver22createAuroraUXHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createAuroraUXHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver20createDarwinHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createDarwinHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver21createOpenBSDHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createOpenBSDHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver21createFreeBSDHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createFreeBSDHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver20createNetBSDHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createNetBSDHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver19createMinixHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createMinixHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver23createDragonFlyHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createDragonFlyHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver19createLinuxHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createLinuxHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver17createTCEHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createTCEHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver21createWindowsHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createWindowsHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver19createMinGWHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createMinGWHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN5clang6driver21createUnknownHostInfoERKNS0_6DriverERKN4llvm6TripleE", "clang::driver::createUnknownHostInfo(clang::driver::Driver const&, llvm::Triple const&)"},
    {"_ZN12_GLOBAL__N_115UnknownHostInfoD1Ev", "(anonymous namespace)::UnknownHostInfo::~UnknownHostInfo()"},
    {"_ZN12_GLOBAL__N_115UnknownHostInfoD0Ev", "(anonymous namespace)::UnknownHostInfo::~UnknownHostInfo()"},
    {"_ZNK12_GLOBAL__N_115UnknownHostInfo15useDriverDriverEv", "(anonymous namespace)::UnknownHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_115UnknownHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::UnknownHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_115UnknownHostInfoD2Ev", "(anonymous namespace)::UnknownHostInfo::~UnknownHostInfo()"},
    {"_ZN12_GLOBAL__N_113MinGWHostInfoD1Ev", "(anonymous namespace)::MinGWHostInfo::~MinGWHostInfo()"},
    {"_ZN12_GLOBAL__N_113MinGWHostInfoD0Ev", "(anonymous namespace)::MinGWHostInfo::~MinGWHostInfo()"},
    {"_ZN12_GLOBAL__N_115WindowsHostInfoD1Ev", "(anonymous namespace)::WindowsHostInfo::~WindowsHostInfo()"},
    {"_ZN12_GLOBAL__N_115WindowsHostInfoD0Ev", "(anonymous namespace)::WindowsHostInfo::~WindowsHostInfo()"},
    {"_ZNK12_GLOBAL__N_115WindowsHostInfo15useDriverDriverEv", "(anonymous namespace)::WindowsHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_115WindowsHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::WindowsHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZNK12_GLOBAL__N_115WindowsHostInfo22lookupTypeForExtensionEPKc", "(anonymous namespace)::WindowsHostInfo::lookupTypeForExtension(char const*) const"},
    {"_ZN12_GLOBAL__N_111TCEHostInfoD1Ev", "(anonymous namespace)::TCEHostInfo::~TCEHostInfo()"},
    {"_ZN12_GLOBAL__N_111TCEHostInfoD0Ev", "(anonymous namespace)::TCEHostInfo::~TCEHostInfo()"},
    {"_ZNK12_GLOBAL__N_111TCEHostInfo15useDriverDriverEv", "(anonymous namespace)::TCEHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_111TCEHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::TCEHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_113LinuxHostInfoD1Ev", "(anonymous namespace)::LinuxHostInfo::~LinuxHostInfo()"},
    {"_ZN12_GLOBAL__N_113LinuxHostInfoD0Ev", "(anonymous namespace)::LinuxHostInfo::~LinuxHostInfo()"},
    {"_ZNK12_GLOBAL__N_113LinuxHostInfo15useDriverDriverEv", "(anonymous namespace)::LinuxHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_113LinuxHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::LinuxHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_117DragonFlyHostInfoD1Ev", "(anonymous namespace)::DragonFlyHostInfo::~DragonFlyHostInfo()"},
    {"_ZN12_GLOBAL__N_117DragonFlyHostInfoD0Ev", "(anonymous namespace)::DragonFlyHostInfo::~DragonFlyHostInfo()"},
    {"_ZNK12_GLOBAL__N_117DragonFlyHostInfo15useDriverDriverEv", "(anonymous namespace)::DragonFlyHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_117DragonFlyHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::DragonFlyHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_113MinixHostInfoD1Ev", "(anonymous namespace)::MinixHostInfo::~MinixHostInfo()"},
    {"_ZN12_GLOBAL__N_113MinixHostInfoD0Ev", "(anonymous namespace)::MinixHostInfo::~MinixHostInfo()"},
    {"_ZNK12_GLOBAL__N_113MinixHostInfo15useDriverDriverEv", "(anonymous namespace)::MinixHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_113MinixHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::MinixHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_114NetBSDHostInfoD1Ev", "(anonymous namespace)::NetBSDHostInfo::~NetBSDHostInfo()"},
    {"_ZN12_GLOBAL__N_114NetBSDHostInfoD0Ev", "(anonymous namespace)::NetBSDHostInfo::~NetBSDHostInfo()"},
    {"_ZNK12_GLOBAL__N_114NetBSDHostInfo15useDriverDriverEv", "(anonymous namespace)::NetBSDHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_114NetBSDHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::NetBSDHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_115FreeBSDHostInfoD1Ev", "(anonymous namespace)::FreeBSDHostInfo::~FreeBSDHostInfo()"},
    {"_ZN12_GLOBAL__N_115FreeBSDHostInfoD0Ev", "(anonymous namespace)::FreeBSDHostInfo::~FreeBSDHostInfo()"},
    {"_ZNK12_GLOBAL__N_115FreeBSDHostInfo15useDriverDriverEv", "(anonymous namespace)::FreeBSDHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_115FreeBSDHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::FreeBSDHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_115OpenBSDHostInfoD1Ev", "(anonymous namespace)::OpenBSDHostInfo::~OpenBSDHostInfo()"},
    {"_ZN12_GLOBAL__N_115OpenBSDHostInfoD0Ev", "(anonymous namespace)::OpenBSDHostInfo::~OpenBSDHostInfo()"},
    {"_ZNK12_GLOBAL__N_115OpenBSDHostInfo15useDriverDriverEv", "(anonymous namespace)::OpenBSDHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_115OpenBSDHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::OpenBSDHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_114DarwinHostInfoD1Ev", "(anonymous namespace)::DarwinHostInfo::~DarwinHostInfo()"},
    {"_ZN12_GLOBAL__N_114DarwinHostInfoD0Ev", "(anonymous namespace)::DarwinHostInfo::~DarwinHostInfo()"},
    {"_ZNK12_GLOBAL__N_114DarwinHostInfo15useDriverDriverEv", "(anonymous namespace)::DarwinHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_114DarwinHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::DarwinHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN12_GLOBAL__N_116AuroraUXHostInfoD1Ev", "(anonymous namespace)::AuroraUXHostInfo::~AuroraUXHostInfo()"},
    {"_ZN12_GLOBAL__N_116AuroraUXHostInfoD0Ev", "(anonymous namespace)::AuroraUXHostInfo::~AuroraUXHostInfo()"},
    {"_ZNK12_GLOBAL__N_116AuroraUXHostInfo15useDriverDriverEv", "(anonymous namespace)::AuroraUXHostInfo::useDriverDriver() const"},
    {"_ZNK12_GLOBAL__N_116AuroraUXHostInfo15CreateToolChainERKN5clang6driver7ArgListEPKc", "(anonymous namespace)::AuroraUXHostInfo::CreateToolChain(clang::driver::ArgList const&, char const*) const"},
    {"_ZN4llvm9StringMapIPN5clang6driver9ToolChainENS_15MallocAllocatorEE16GetOrCreateValueIS4_EERNS_14StringMapEntryIS4_EENS_9StringRefET_", "llvm::StringMapEntry<clang::driver::ToolChain*>& llvm::StringMap<clang::driver::ToolChain*, llvm::MallocAllocator>::GetOrCreateValue<clang::driver::ToolChain*>(llvm::StringRef, clang::driver::ToolChain*)"},
    {"_ZNK5clang6driver9ToolChain13TranslateArgsERKNS0_14DerivedArgListEPKc", "clang::driver::ToolChain::TranslateArgs(clang::driver::DerivedArgList const&, char const*) const"},
    {"_ZNK5clang6driver9ToolChain15IsBlocksDefaultEv", "clang::driver::ToolChain::IsBlocksDefault() const"},
    {"_ZNK5clang6driver9ToolChain28IsIntegratedAssemblerDefaultEv", "clang::driver::ToolChain::IsIntegratedAssemblerDefault() const"},
    {"_ZNK5clang6driver9ToolChain23IsStrictAliasingDefaultEv", "clang::driver::ToolChain::IsStrictAliasingDefault() const"},
    {"_ZNK5clang6driver9ToolChain35IsObjCDefaultSynthPropertiesDefaultEv", "clang::driver::ToolChain::IsObjCDefaultSynthPropertiesDefault() const"},
    {"_ZNK5clang6driver9ToolChain26IsObjCNonFragileABIDefaultEv", "clang::driver::ToolChain::IsObjCNonFragileABIDefault() const"},
    {"_ZNK5clang6driver9ToolChain27IsObjCLegacyDispatchDefaultEv", "clang::driver::ToolChain::IsObjCLegacyDispatchDefault() const"},
    {"_ZNK5clang6driver9ToolChain20UseObjCMixedDispatchEv", "clang::driver::ToolChain::UseObjCMixedDispatch() const"},
    {"_ZNK5clang6driver9ToolChain29GetDefaultStackProtectorLevelEv", "clang::driver::ToolChain::GetDefaultStackProtectorLevel() const"},
    {"_ZNK5clang6driver10toolchains18Darwin_Generic_GCC25GetDefaultRelocationModelEv", "clang::driver::toolchains::Darwin_Generic_GCC::GetDefaultRelocationModel() const"},
    {"_ZNK5clang6driver9ToolChain14SupportsObjCGCEv", "clang::driver::ToolChain::SupportsObjCGC() const"},
    {"_ZNK5clang6driver9ToolChain18UseDwarfDebugFlagsEv", "clang::driver::ToolChain::UseDwarfDebugFlags() const"},
    {"_ZNK5clang6driver9ToolChain17UseSjLjExceptionsEv", "clang::driver::ToolChain::UseSjLjExceptions() const"},
    {"_ZN4llvm8DenseMapIjPN5clang6driver9ToolChainENS_12DenseMapInfoIjEENS5_IS4_EEE16InsertIntoBucketERKjRKS4_PSt4pairIjS4_E", "llvm::DenseMap<unsigned int, clang::driver::ToolChain*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::ToolChain*> >::InsertIntoBucket(unsigned int const&, clang::driver::ToolChain* const&, std::pair<unsigned int, clang::driver::ToolChain*>*)"},
    {"_ZN4llvm8DenseMapIjPN5clang6driver9ToolChainENS_12DenseMapInfoIjEENS5_IS4_EEE4growEj", "llvm::DenseMap<unsigned int, clang::driver::ToolChain*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::ToolChain*> >::grow(unsigned int)"},
    {"_ZN5clang6driver3JobD0Ev", "clang::driver::Job::~Job()"},
    {"_ZN5clang6driver3JobD1Ev", "clang::driver::Job::~Job()"},
    {"_ZN5clang6driver3JobD2Ev", "clang::driver::Job::~Job()"},
    {"_ZN5clang6driver7CommandC1ERKNS0_6ActionERKNS0_4ToolEPKcRKN4llvm11SmallVectorIS9_Lj16EEE", "clang::driver::Command::Command(clang::driver::Action const&, clang::driver::Tool const&, char const*, llvm::SmallVector<char const*, 16u> const&)"},
    {"_ZN5clang6driver7CommandC2ERKNS0_6ActionERKNS0_4ToolEPKcRKN4llvm11SmallVectorIS9_Lj16EEE", "clang::driver::Command::Command(clang::driver::Action const&, clang::driver::Tool const&, char const*, llvm::SmallVector<char const*, 16u> const&)"},
    {"_ZN5clang6driver7JobListC1Ev", "clang::driver::JobList::JobList()"},
    {"_ZN5clang6driver7JobListC2Ev", "clang::driver::JobList::JobList()"},
    {"_ZN5clang6driver7JobListD0Ev", "clang::driver::JobList::~JobList()"},
    {"_ZN5clang6driver7JobListD1Ev", "clang::driver::JobList::~JobList()"},
    {"_ZN5clang6driver7JobListD2Ev", "clang::driver::JobList::~JobList()"},
    {"_ZN5clang6driver3Job10addCommandEPNS0_7CommandE", "clang::driver::Job::addCommand(clang::driver::Command*)"},
    {"_ZN5clang6driver7CommandD1Ev", "clang::driver::Command::~Command()"},
    {"_ZN5clang6driver7CommandD0Ev", "clang::driver::Command::~Command()"},
    {"_ZN4llvm15SmallVectorImplIPKcEaSERKS3_", "llvm::SmallVectorImpl<char const*>::operator=(llvm::SmallVectorImpl<char const*> const&)"},
    {"_ZN5clang6driver12OptSpecifierC1EPKNS0_6OptionE", "clang::driver::OptSpecifier::OptSpecifier(clang::driver::Option const*)"},
    {"_ZN5clang6driver12OptSpecifierC2EPKNS0_6OptionE", "clang::driver::OptSpecifier::OptSpecifier(clang::driver::Option const*)"},
    {"_ZN5clang6driver8OptTableC1EPKNS1_4InfoEj", "clang::driver::OptTable::OptTable(clang::driver::OptTable::Info const*, unsigned int)"},
    {"_ZN5clang6driver8OptTableC2EPKNS1_4InfoEj", "clang::driver::OptTable::OptTable(clang::driver::OptTable::Info const*, unsigned int)"},
    {"_ZN5clang6driver8OptTableD1Ev", "clang::driver::OptTable::~OptTable()"},
    {"_ZN5clang6driver8OptTableD2Ev", "clang::driver::OptTable::~OptTable()"},
    {"_ZNK5clang6driver8OptTable12CreateOptionEj", "clang::driver::OptTable::CreateOption(unsigned int) const"},
    {"_ZNK5clang6driver8OptTable11ParseOneArgERKNS0_7ArgListERj", "clang::driver::OptTable::ParseOneArg(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZNK5clang6driver8OptTable9ParseArgsEPKPKcS5_RjS6_", "clang::driver::OptTable::ParseArgs(char const* const*, char const* const*, unsigned int&, unsigned int&) const"},
    {"_ZNK5clang6driver8OptTable9PrintHelpERN4llvm11raw_ostreamEPKcS6_b", "clang::driver::OptTable::PrintHelp(llvm::raw_ostream&, char const*, char const*, bool) const"},
    {"_ZNSt3mapISsSt6vectorISt4pairISsPKcESaIS4_EESt4lessISsESaIS1_IKSsS6_EEEixERS9_", "std::map<std::string, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > >, std::less<std::string>, std::allocator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > > >::operator[](std::string const&)"},
    {"_ZNSt6vectorISt4pairISsPKcESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<std::string, char const*>*, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > >, std::pair<std::string, char const*> const&)"},
    {"_ZNSt6vectorISt4pairISsPKcESaIS3_EEC2ERKS5_", "std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > >::vector(std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsSt6vectorIS0_ISsPKcESaIS5_EEESt10_Select1stIS8_ESt4lessISsESaIS8_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS8_ERKS8_", "std::_Rb_tree<std::string, std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > >, std::_Select1st<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >, std::less<std::string>, std::allocator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >, std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsSt6vectorIS0_ISsPKcESaIS5_EEESt10_Select1stIS8_ESt4lessISsESaIS8_EE9_M_insertEPSt18_Rb_tree_node_baseSG_RKS8_", "std::_Rb_tree<std::string, std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > >, std::_Select1st<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >, std::less<std::string>, std::allocator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > > >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsSt6vectorIS0_ISsPKcESaIS5_EEESt10_Select1stIS8_ESt4lessISsESaIS8_EE16_M_insert_uniqueERKS8_", "std::_Rb_tree<std::string, std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > >, std::_Select1st<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >, std::less<std::string>, std::allocator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > > >::_M_insert_unique(std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsSt6vectorIS0_ISsPKcESaIS5_EEESt10_Select1stIS8_ESt4lessISsESaIS8_EE8_M_eraseEPSt13_Rb_tree_nodeIS8_E", "std::_Rb_tree<std::string, std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > >, std::_Select1st<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >, std::less<std::string>, std::allocator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > > >::_M_erase(std::_Rb_tree_node<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >*)"},
    {"_ZN9__gnu_cxx13new_allocatorISt4pairIKSsSt6vectorIS1_ISsPKcESaIS6_EEEE7destroyEPS9_", "__gnu_cxx::new_allocator<std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > > >::destroy(std::pair<std::string const, std::vector<std::pair<std::string, char const*>, std::allocator<std::pair<std::string, char const*> > > >*)"},
    {"_ZN5clang6driver6OptionC1ENS1_11OptionClassENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKS1_", "clang::driver::Option::Option(clang::driver::Option::OptionClass, clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver6OptionC2ENS1_11OptionClassENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKS1_", "clang::driver::Option::Option(clang::driver::Option::OptionClass, clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver6OptionD0Ev", "clang::driver::Option::~Option()"},
    {"_ZN5clang6driver6OptionD1Ev", "clang::driver::Option::~Option()"},
    {"_ZN5clang6driver6OptionD2Ev", "clang::driver::Option::~Option()"},
    {"_ZNK5clang6driver6Option4dumpEv", "clang::driver::Option::dump() const"},
    {"_ZNK5clang6driver6Option7matchesENS0_12OptSpecifierE", "clang::driver::Option::matches(clang::driver::OptSpecifier) const"},
    {"_ZN5clang6driver11OptionGroupC1ENS0_12OptSpecifierEPKcPKS1_", "clang::driver::OptionGroup::OptionGroup(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*)"},
    {"_ZN5clang6driver11OptionGroupC2ENS0_12OptSpecifierEPKcPKS1_", "clang::driver::OptionGroup::OptionGroup(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*)"},
    {"_ZNK5clang6driver11OptionGroup6acceptERKNS0_7ArgListERj", "clang::driver::OptionGroup::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver11InputOptionC1ENS0_12OptSpecifierE", "clang::driver::InputOption::InputOption(clang::driver::OptSpecifier)"},
    {"_ZN5clang6driver11InputOptionC2ENS0_12OptSpecifierE", "clang::driver::InputOption::InputOption(clang::driver::OptSpecifier)"},
    {"_ZNK5clang6driver11InputOption6acceptERKNS0_7ArgListERj", "clang::driver::InputOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver13UnknownOptionC1ENS0_12OptSpecifierE", "clang::driver::UnknownOption::UnknownOption(clang::driver::OptSpecifier)"},
    {"_ZN5clang6driver13UnknownOptionC2ENS0_12OptSpecifierE", "clang::driver::UnknownOption::UnknownOption(clang::driver::OptSpecifier)"},
    {"_ZNK5clang6driver13UnknownOption6acceptERKNS0_7ArgListERj", "clang::driver::UnknownOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver10FlagOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::FlagOption::FlagOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver10FlagOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::FlagOption::FlagOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZNK5clang6driver10FlagOption6acceptERKNS0_7ArgListERj", "clang::driver::FlagOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver12JoinedOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOption::JoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver12JoinedOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOption::JoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZNK5clang6driver12JoinedOption6acceptERKNS0_7ArgListERj", "clang::driver::JoinedOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver17CommaJoinedOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::CommaJoinedOption::CommaJoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver17CommaJoinedOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::CommaJoinedOption::CommaJoinedOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZNK5clang6driver17CommaJoinedOption6acceptERKNS0_7ArgListERj", "clang::driver::CommaJoinedOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver14SeparateOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::SeparateOption::SeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver14SeparateOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::SeparateOption::SeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZNK5clang6driver14SeparateOption6acceptERKNS0_7ArgListERj", "clang::driver::SeparateOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver14MultiArgOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionEj", "clang::driver::MultiArgOption::MultiArgOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*, unsigned int)"},
    {"_ZN5clang6driver14MultiArgOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionEj", "clang::driver::MultiArgOption::MultiArgOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*, unsigned int)"},
    {"_ZNK5clang6driver14MultiArgOption6acceptERKNS0_7ArgListERj", "clang::driver::MultiArgOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver22JoinedOrSeparateOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOrSeparateOption::JoinedOrSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver22JoinedOrSeparateOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedOrSeparateOption::JoinedOrSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZNK5clang6driver22JoinedOrSeparateOption6acceptERKNS0_7ArgListERj", "clang::driver::JoinedOrSeparateOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver23JoinedAndSeparateOptionC1ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedAndSeparateOption::JoinedAndSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZN5clang6driver23JoinedAndSeparateOptionC2ENS0_12OptSpecifierEPKcPKNS0_11OptionGroupEPKNS0_6OptionE", "clang::driver::JoinedAndSeparateOption::JoinedAndSeparateOption(clang::driver::OptSpecifier, char const*, clang::driver::OptionGroup const*, clang::driver::Option const*)"},
    {"_ZNK5clang6driver23JoinedAndSeparateOption6acceptERKNS0_7ArgListERj", "clang::driver::JoinedAndSeparateOption::accept(clang::driver::ArgList const&, unsigned int&) const"},
    {"_ZN5clang6driver11OptionGroupD1Ev", "clang::driver::OptionGroup::~OptionGroup()"},
    {"_ZN5clang6driver11OptionGroupD0Ev", "clang::driver::OptionGroup::~OptionGroup()"},
    {"_ZN5clang6driver11InputOptionD1Ev", "clang::driver::InputOption::~InputOption()"},
    {"_ZN5clang6driver11InputOptionD0Ev", "clang::driver::InputOption::~InputOption()"},
    {"_ZN5clang6driver13UnknownOptionD1Ev", "clang::driver::UnknownOption::~UnknownOption()"},
    {"_ZN5clang6driver13UnknownOptionD0Ev", "clang::driver::UnknownOption::~UnknownOption()"},
    {"_ZN5clang6driver10FlagOptionD1Ev", "clang::driver::FlagOption::~FlagOption()"},
    {"_ZN5clang6driver10FlagOptionD0Ev", "clang::driver::FlagOption::~FlagOption()"},
    {"_ZN5clang6driver12JoinedOptionD1Ev", "clang::driver::JoinedOption::~JoinedOption()"},
    {"_ZN5clang6driver12JoinedOptionD0Ev", "clang::driver::JoinedOption::~JoinedOption()"},
    {"_ZN5clang6driver17CommaJoinedOptionD1Ev", "clang::driver::CommaJoinedOption::~CommaJoinedOption()"},
    {"_ZN5clang6driver17CommaJoinedOptionD0Ev", "clang::driver::CommaJoinedOption::~CommaJoinedOption()"},
    {"_ZN5clang6driver14SeparateOptionD1Ev", "clang::driver::SeparateOption::~SeparateOption()"},
    {"_ZN5clang6driver14SeparateOptionD0Ev", "clang::driver::SeparateOption::~SeparateOption()"},
    {"_ZN5clang6driver14MultiArgOptionD1Ev", "clang::driver::MultiArgOption::~MultiArgOption()"},
    {"_ZN5clang6driver14MultiArgOptionD0Ev", "clang::driver::MultiArgOption::~MultiArgOption()"},
    {"_ZN5clang6driver22JoinedOrSeparateOptionD1Ev", "clang::driver::JoinedOrSeparateOption::~JoinedOrSeparateOption()"},
    {"_ZN5clang6driver22JoinedOrSeparateOptionD0Ev", "clang::driver::JoinedOrSeparateOption::~JoinedOrSeparateOption()"},
    {"_ZN5clang6driver23JoinedAndSeparateOptionD1Ev", "clang::driver::JoinedAndSeparateOption::~JoinedAndSeparateOption()"},
    {"_ZN5clang6driver23JoinedAndSeparateOptionD0Ev", "clang::driver::JoinedAndSeparateOption::~JoinedAndSeparateOption()"},
    {"_ZN5clang6driver6phases12getPhaseNameENS1_2IDE", "clang::driver::phases::getPhaseName(clang::driver::phases::ID)"},
    {"_ZN5clang6driver4ToolC1EPKcS3_RKNS0_9ToolChainE", "clang::driver::Tool::Tool(char const*, char const*, clang::driver::ToolChain const&)"},
    {"_ZN5clang6driver4ToolC2EPKcS3_RKNS0_9ToolChainE", "clang::driver::Tool::Tool(char const*, char const*, clang::driver::ToolChain const&)"},
    {"_ZN5clang6driver4ToolD0Ev", "clang::driver::Tool::~Tool()"},
    {"_ZN5clang6driver4ToolD1Ev", "clang::driver::Tool::~Tool()"},
    {"_ZN5clang6driver4ToolD2Ev", "clang::driver::Tool::~Tool()"},
    {"_ZN5clang6driver9ToolChainC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::ToolChain::ToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver9ToolChainC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::ToolChain::ToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver9ToolChainD0Ev", "clang::driver::ToolChain::~ToolChain()"},
    {"_ZN5clang6driver9ToolChainD1Ev", "clang::driver::ToolChain::~ToolChain()"},
    {"_ZN5clang6driver9ToolChainD2Ev", "clang::driver::ToolChain::~ToolChain()"},
    {"_ZNK5clang6driver9ToolChain9getDriverEv", "clang::driver::ToolChain::getDriver() const"},
    {"_ZNK5clang6driver9ToolChain11GetFilePathEPKc", "clang::driver::ToolChain::GetFilePath(char const*) const"},
    {"_ZNK5clang6driver9ToolChain14GetProgramPathEPKcb", "clang::driver::ToolChain::GetProgramPath(char const*, bool) const"},
    {"_ZNK5clang6driver9ToolChain22LookupTypeForExtensionEPKc", "clang::driver::ToolChain::LookupTypeForExtension(char const*) const"},
    {"_ZNK5clang6driver9ToolChain20HasNativeLLVMSupportEv", "clang::driver::ToolChain::HasNativeLLVMSupport() const"},
    {"_ZNK5clang6driver9ToolChain17ComputeLLVMTripleERKNS0_7ArgListE", "clang::driver::ToolChain::ComputeLLVMTriple(clang::driver::ArgList const&) const"},
    {"_ZNK5clang6driver9ToolChain27ComputeEffectiveClangTripleERKNS0_7ArgListE", "clang::driver::ToolChain::ComputeEffectiveClangTriple(clang::driver::ArgList const&) const"},
    {"_ZNK5clang6driver9ToolChain16GetCXXStdlibTypeERKNS0_7ArgListE", "clang::driver::ToolChain::GetCXXStdlibType(clang::driver::ArgList const&) const"},
    {"_ZNK5clang6driver9ToolChain28AddClangCXXStdlibIncludeArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::ToolChain::AddClangCXXStdlibIncludeArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver9ToolChain19AddCXXStdlibLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::ToolChain::AddCXXStdlibLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver9ToolChain16AddCCKextLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::ToolChain::AddCCKextLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZN5clang6driver10toolchains6DarwinC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Darwin::Darwin(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains6DarwinC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Darwin::Darwin(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains6Darwin22LookupTypeForExtensionEPKc", "clang::driver::toolchains::Darwin::LookupTypeForExtension(char const*) const"},
    {"_ZNK5clang6driver10toolchains6Darwin20HasNativeLLVMSupportEv", "clang::driver::toolchains::Darwin::HasNativeLLVMSupport() const"},
    {"_ZNK5clang6driver10toolchains6Darwin17getDarwinArchNameERKNS0_7ArgListE", "clang::driver::toolchains::Darwin::getDarwinArchName(clang::driver::ArgList const&) const"},
    {"_ZN5clang6driver10toolchains9DarwinGCCC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinGCC::DarwinGCC(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains9DarwinGCCC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinGCC::DarwinGCC(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains6DarwinD0Ev", "clang::driver::toolchains::Darwin::~Darwin()"},
    {"_ZN5clang6driver10toolchains6DarwinD1Ev", "clang::driver::toolchains::Darwin::~Darwin()"},
    {"_ZN5clang6driver10toolchains6DarwinD2Ev", "clang::driver::toolchains::Darwin::~Darwin()"},
    {"_ZNK5clang6driver10toolchains6Darwin27ComputeEffectiveClangTripleERKNS0_7ArgListE", "clang::driver::toolchains::Darwin::ComputeEffectiveClangTriple(clang::driver::ArgList const&) const"},
    {"_ZNK5clang6driver10toolchains6Darwin10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Darwin::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZNK5clang6driver10toolchains9DarwinGCC21AddLinkSearchPathArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinGCC::AddLinkSearchPathArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver10toolchains9DarwinGCC21AddLinkRuntimeLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinGCC::AddLinkRuntimeLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZN5clang6driver10toolchains11DarwinClangC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinClang::DarwinClang(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains11DarwinClangC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DarwinClang::DarwinClang(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains11DarwinClang21AddLinkSearchPathArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddLinkSearchPathArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver10toolchains11DarwinClang21AddLinkRuntimeLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddLinkRuntimeLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver10toolchains6Darwin19AddDeploymentTargetERNS0_14DerivedArgListE", "clang::driver::toolchains::Darwin::AddDeploymentTarget(clang::driver::DerivedArgList&) const"},
    {"_ZNK5clang6driver10toolchains11DarwinClang19AddCXXStdlibLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddCXXStdlibLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver10toolchains11DarwinClang16AddCCKextLibArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::toolchains::DarwinClang::AddCCKextLibArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver10toolchains6Darwin13TranslateArgsERKNS0_14DerivedArgListEPKc", "clang::driver::toolchains::Darwin::TranslateArgs(clang::driver::DerivedArgList const&, char const*) const"},
    {"_ZNK5clang6driver10toolchains6Darwin21IsUnwindTablesDefaultEv", "clang::driver::toolchains::Darwin::IsUnwindTablesDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin18UseDwarfDebugFlagsEv", "clang::driver::toolchains::Darwin::UseDwarfDebugFlags() const"},
    {"_ZNK5clang6driver10toolchains6Darwin17UseSjLjExceptionsEv", "clang::driver::toolchains::Darwin::UseSjLjExceptions() const"},
    {"_ZNK5clang6driver10toolchains6Darwin25GetDefaultRelocationModelEv", "clang::driver::toolchains::Darwin::GetDefaultRelocationModel() const"},
    {"_ZNK5clang6driver10toolchains6Darwin17GetForcedPicModelEv", "clang::driver::toolchains::Darwin::GetForcedPicModel() const"},
    {"_ZNK5clang6driver10toolchains6Darwin14SupportsObjCGCEv", "clang::driver::toolchains::Darwin::SupportsObjCGC() const"},
    {"_ZNK5clang6driver10toolchains18Darwin_Generic_GCC27ComputeEffectiveClangTripleERKNS0_7ArgListE", "clang::driver::toolchains::Darwin_Generic_GCC::ComputeEffectiveClangTriple(clang::driver::ArgList const&) const"},
    {"_ZN5clang6driver10toolchains11Generic_GCCC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Generic_GCC::Generic_GCC(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains11Generic_GCCC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Generic_GCC::Generic_GCC(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains11Generic_GCCD0Ev", "clang::driver::toolchains::Generic_GCC::~Generic_GCC()"},
    {"_ZN5clang6driver10toolchains11Generic_GCCD1Ev", "clang::driver::toolchains::Generic_GCC::~Generic_GCC()"},
    {"_ZN5clang6driver10toolchains11Generic_GCCD2Ev", "clang::driver::toolchains::Generic_GCC::~Generic_GCC()"},
    {"_ZNK5clang6driver10toolchains11Generic_GCC10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Generic_GCC::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZNK5clang6driver10toolchains11Generic_GCC21IsUnwindTablesDefaultEv", "clang::driver::toolchains::Generic_GCC::IsUnwindTablesDefault() const"},
    {"_ZNK5clang6driver10toolchains11Generic_GCC25GetDefaultRelocationModelEv", "clang::driver::toolchains::Generic_GCC::GetDefaultRelocationModel() const"},
    {"_ZNK5clang6driver10toolchains11Generic_GCC17GetForcedPicModelEv", "clang::driver::toolchains::Generic_GCC::GetForcedPicModel() const"},
    {"_ZN5clang6driver10toolchains12TCEToolChainC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::TCEToolChain::TCEToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains12TCEToolChainC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::TCEToolChain::TCEToolChain(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains12TCEToolChainD0Ev", "clang::driver::toolchains::TCEToolChain::~TCEToolChain()"},
    {"_ZN5clang6driver10toolchains12TCEToolChainD1Ev", "clang::driver::toolchains::TCEToolChain::~TCEToolChain()"},
    {"_ZN5clang6driver10toolchains12TCEToolChainD2Ev", "clang::driver::toolchains::TCEToolChain::~TCEToolChain()"},
    {"_ZNK5clang6driver10toolchains12TCEToolChain18IsMathErrnoDefaultEv", "clang::driver::toolchains::TCEToolChain::IsMathErrnoDefault() const"},
    {"_ZNK5clang6driver10toolchains12TCEToolChain21IsUnwindTablesDefaultEv", "clang::driver::toolchains::TCEToolChain::IsUnwindTablesDefault() const"},
    {"_ZNK5clang6driver10toolchains12TCEToolChain25GetDefaultRelocationModelEv", "clang::driver::toolchains::TCEToolChain::GetDefaultRelocationModel() const"},
    {"_ZNK5clang6driver10toolchains12TCEToolChain17GetForcedPicModelEv", "clang::driver::toolchains::TCEToolChain::GetForcedPicModel() const"},
    {"_ZNK5clang6driver10toolchains12TCEToolChain10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::TCEToolChain::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains7OpenBSDC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::OpenBSD::OpenBSD(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains7OpenBSDC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::OpenBSD::OpenBSD(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains7OpenBSD10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::OpenBSD::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains7FreeBSDC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::FreeBSD::FreeBSD(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains7FreeBSDC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::FreeBSD::FreeBSD(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains7FreeBSD10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::FreeBSD::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains6NetBSDC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::NetBSD::NetBSD(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains6NetBSDC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::NetBSD::NetBSD(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains6NetBSD10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::NetBSD::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains5MinixC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Minix::Minix(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains5MinixC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Minix::Minix(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains5Minix10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Minix::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains8AuroraUXC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::AuroraUX::AuroraUX(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains8AuroraUXC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::AuroraUX::AuroraUX(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains8AuroraUX10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::AuroraUX::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains5LinuxC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Linux::Linux(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains5LinuxC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Linux::Linux(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains5Linux20HasNativeLLVMSupportEv", "clang::driver::toolchains::Linux::HasNativeLLVMSupport() const"},
    {"_ZNK5clang6driver10toolchains5Linux10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Linux::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains9DragonFlyC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DragonFly::DragonFly(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains9DragonFlyC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::DragonFly::DragonFly(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains9DragonFly10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::DragonFly::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZN5clang6driver10toolchains7WindowsC1ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Windows::Windows(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZN5clang6driver10toolchains7WindowsC2ERKNS0_8HostInfoERKN4llvm6TripleE", "clang::driver::toolchains::Windows::Windows(clang::driver::HostInfo const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver10toolchains7Windows10SelectToolERKNS0_11CompilationERKNS0_9JobActionE", "clang::driver::toolchains::Windows::SelectTool(clang::driver::Compilation const&, clang::driver::JobAction const&) const"},
    {"_ZNK5clang6driver10toolchains7Windows28IsIntegratedAssemblerDefaultEv", "clang::driver::toolchains::Windows::IsIntegratedAssemblerDefault() const"},
    {"_ZNK5clang6driver10toolchains7Windows21IsUnwindTablesDefaultEv", "clang::driver::toolchains::Windows::IsUnwindTablesDefault() const"},
    {"_ZNK5clang6driver10toolchains7Windows25GetDefaultRelocationModelEv", "clang::driver::toolchains::Windows::GetDefaultRelocationModel() const"},
    {"_ZNK5clang6driver10toolchains7Windows17GetForcedPicModelEv", "clang::driver::toolchains::Windows::GetForcedPicModel() const"},
    {"_ZN5clang6driver10toolchains18Darwin_Generic_GCCD1Ev", "clang::driver::toolchains::Darwin_Generic_GCC::~Darwin_Generic_GCC()"},
    {"_ZN5clang6driver10toolchains18Darwin_Generic_GCCD0Ev", "clang::driver::toolchains::Darwin_Generic_GCC::~Darwin_Generic_GCC()"},
    {"_ZNK5clang6driver10toolchains6Darwin15IsBlocksDefaultEv", "clang::driver::toolchains::Darwin::IsBlocksDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin28IsIntegratedAssemblerDefaultEv", "clang::driver::toolchains::Darwin::IsIntegratedAssemblerDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin23IsStrictAliasingDefaultEv", "clang::driver::toolchains::Darwin::IsStrictAliasingDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin35IsObjCDefaultSynthPropertiesDefaultEv", "clang::driver::toolchains::Darwin::IsObjCDefaultSynthPropertiesDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin26IsObjCNonFragileABIDefaultEv", "clang::driver::toolchains::Darwin::IsObjCNonFragileABIDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin27IsObjCLegacyDispatchDefaultEv", "clang::driver::toolchains::Darwin::IsObjCLegacyDispatchDefault() const"},
    {"_ZNK5clang6driver10toolchains6Darwin20UseObjCMixedDispatchEv", "clang::driver::toolchains::Darwin::UseObjCMixedDispatch() const"},
    {"_ZNK5clang6driver10toolchains6Darwin29GetDefaultStackProtectorLevelEv", "clang::driver::toolchains::Darwin::GetDefaultStackProtectorLevel() const"},
    {"_ZN5clang6driver10toolchains9DarwinGCCD1Ev", "clang::driver::toolchains::DarwinGCC::~DarwinGCC()"},
    {"_ZN5clang6driver10toolchains9DarwinGCCD0Ev", "clang::driver::toolchains::DarwinGCC::~DarwinGCC()"},
    {"_ZN5clang6driver10toolchains11DarwinClangD1Ev", "clang::driver::toolchains::DarwinClang::~DarwinClang()"},
    {"_ZN5clang6driver10toolchains11DarwinClangD0Ev", "clang::driver::toolchains::DarwinClang::~DarwinClang()"},
    {"_ZN5clang6driver10toolchains7OpenBSDD1Ev", "clang::driver::toolchains::OpenBSD::~OpenBSD()"},
    {"_ZN5clang6driver10toolchains7OpenBSDD0Ev", "clang::driver::toolchains::OpenBSD::~OpenBSD()"},
    {"_ZNK5clang6driver10toolchains11Generic_ELF28IsIntegratedAssemblerDefaultEv", "clang::driver::toolchains::Generic_ELF::IsIntegratedAssemblerDefault() const"},
    {"_ZN5clang6driver10toolchains7FreeBSDD1Ev", "clang::driver::toolchains::FreeBSD::~FreeBSD()"},
    {"_ZN5clang6driver10toolchains7FreeBSDD0Ev", "clang::driver::toolchains::FreeBSD::~FreeBSD()"},
    {"_ZN5clang6driver10toolchains6NetBSDD1Ev", "clang::driver::toolchains::NetBSD::~NetBSD()"},
    {"_ZN5clang6driver10toolchains6NetBSDD0Ev", "clang::driver::toolchains::NetBSD::~NetBSD()"},
    {"_ZN5clang6driver10toolchains5MinixD1Ev", "clang::driver::toolchains::Minix::~Minix()"},
    {"_ZN5clang6driver10toolchains5MinixD0Ev", "clang::driver::toolchains::Minix::~Minix()"},
    {"_ZN5clang6driver10toolchains8AuroraUXD1Ev", "clang::driver::toolchains::AuroraUX::~AuroraUX()"},
    {"_ZN5clang6driver10toolchains8AuroraUXD0Ev", "clang::driver::toolchains::AuroraUX::~AuroraUX()"},
    {"_ZN5clang6driver10toolchains5LinuxD1Ev", "clang::driver::toolchains::Linux::~Linux()"},
    {"_ZN5clang6driver10toolchains5LinuxD0Ev", "clang::driver::toolchains::Linux::~Linux()"},
    {"_ZN5clang6driver10toolchains9DragonFlyD1Ev", "clang::driver::toolchains::DragonFly::~DragonFly()"},
    {"_ZN5clang6driver10toolchains9DragonFlyD0Ev", "clang::driver::toolchains::DragonFly::~DragonFly()"},
    {"_ZN5clang6driver10toolchains7WindowsD1Ev", "clang::driver::toolchains::Windows::~Windows()"},
    {"_ZN5clang6driver10toolchains7WindowsD0Ev", "clang::driver::toolchains::Windows::~Windows()"},
    {"_ZN4llvm8DenseMapIjPN5clang6driver4ToolENS_12DenseMapInfoIjEENS5_IS4_EEE16InsertIntoBucketERKjRKS4_PSt4pairIjS4_E", "llvm::DenseMap<unsigned int, clang::driver::Tool*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::Tool*> >::InsertIntoBucket(unsigned int const&, clang::driver::Tool* const&, std::pair<unsigned int, clang::driver::Tool*>*)"},
    {"_ZN4llvm8DenseMapIjPN5clang6driver4ToolENS_12DenseMapInfoIjEENS5_IS4_EEE4growEj", "llvm::DenseMap<unsigned int, clang::driver::Tool*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::driver::Tool*> >::grow(unsigned int)"},
    {"_ZN5clang6driver10toolchains11Generic_ELFD1Ev", "clang::driver::toolchains::Generic_ELF::~Generic_ELF()"},
    {"_ZN5clang6driver10toolchains11Generic_ELFD0Ev", "clang::driver::toolchains::Generic_ELF::~Generic_ELF()"},
    {"_ZN5clang6driver10toolchains5LinuxD2Ev", "clang::driver::toolchains::Linux::~Linux()"},
    {"_ZNK5clang6driver4Tool22hasIntegratedAssemblerEv", "clang::driver::Tool::hasIntegratedAssembler() const"},
    {"_ZNK5clang6driver5tools12visualstudio4Link16hasIntegratedCPPEv", "clang::driver::tools::visualstudio::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver4Tool18hasGoodDiagnosticsEv", "clang::driver::Tool::hasGoodDiagnostics() const"},
    {"_ZNK5clang6driver5tools9dragonfly4Link16hasIntegratedCPPEv", "clang::driver::tools::dragonfly::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools9dragonfly8Assemble16hasIntegratedCPPEv", "clang::driver::tools::dragonfly::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools10linuxtools4Link16hasIntegratedCPPEv", "clang::driver::tools::linuxtools::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools10linuxtools8Assemble16hasIntegratedCPPEv", "clang::driver::tools::linuxtools::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools8auroraux4Link16hasIntegratedCPPEv", "clang::driver::tools::auroraux::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools8auroraux8Assemble16hasIntegratedCPPEv", "clang::driver::tools::auroraux::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools5minix4Link16hasIntegratedCPPEv", "clang::driver::tools::minix::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools5minix8Assemble16hasIntegratedCPPEv", "clang::driver::tools::minix::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools6netbsd4Link16hasIntegratedCPPEv", "clang::driver::tools::netbsd::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools6netbsd8Assemble16hasIntegratedCPPEv", "clang::driver::tools::netbsd::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools7freebsd4Link16hasIntegratedCPPEv", "clang::driver::tools::freebsd::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools7freebsd8Assemble16hasIntegratedCPPEv", "clang::driver::tools::freebsd::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools7openbsd4Link16hasIntegratedCPPEv", "clang::driver::tools::openbsd::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools7openbsd8Assemble16hasIntegratedCPPEv", "clang::driver::tools::openbsd::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools3gcc4Link16hasIntegratedCPPEv", "clang::driver::tools::gcc::Link::hasIntegratedCPP() const"},
    {"_ZN5clang6driver5tools3gcc6CommonD1Ev", "clang::driver::tools::gcc::Common::~Common()"},
    {"_ZN5clang6driver5tools3gcc6CommonD0Ev", "clang::driver::tools::gcc::Common::~Common()"},
    {"_ZNK5clang6driver5tools3gcc8Assemble16hasIntegratedCPPEv", "clang::driver::tools::gcc::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools3gcc7Compile16hasIntegratedCPPEv", "clang::driver::tools::gcc::Compile::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools3gcc7Compile18hasGoodDiagnosticsEv", "clang::driver::tools::gcc::Compile::hasGoodDiagnostics() const"},
    {"_ZNK5clang6driver5tools3gcc10Precompile16hasIntegratedCPPEv", "clang::driver::tools::gcc::Precompile::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools3gcc10Precompile18hasGoodDiagnosticsEv", "clang::driver::tools::gcc::Precompile::hasGoodDiagnostics() const"},
    {"_ZNK5clang6driver5tools3gcc10Preprocess16hasIntegratedCPPEv", "clang::driver::tools::gcc::Preprocess::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools3gcc10Preprocess18hasGoodDiagnosticsEv", "clang::driver::tools::gcc::Preprocess::hasGoodDiagnostics() const"},
    {"_ZNK5clang6driver5tools6darwin8Dsymutil16hasIntegratedCPPEv", "clang::driver::tools::darwin::Dsymutil::hasIntegratedCPP() const"},
    {"_ZN5clang6driver5tools6darwin10DarwinToolD1Ev", "clang::driver::tools::darwin::DarwinTool::~DarwinTool()"},
    {"_ZN5clang6driver5tools6darwin10DarwinToolD0Ev", "clang::driver::tools::darwin::DarwinTool::~DarwinTool()"},
    {"_ZNK5clang6driver5tools6darwin4Lipo16hasIntegratedCPPEv", "clang::driver::tools::darwin::Lipo::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools6darwin4Link16hasIntegratedCPPEv", "clang::driver::tools::darwin::Link::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools6darwin8Assemble16hasIntegratedCPPEv", "clang::driver::tools::darwin::Assemble::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools7ClangAs22hasIntegratedAssemblerEv", "clang::driver::tools::ClangAs::hasIntegratedAssembler() const"},
    {"_ZNK5clang6driver5tools7ClangAs16hasIntegratedCPPEv", "clang::driver::tools::ClangAs::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools7ClangAs18hasGoodDiagnosticsEv", "clang::driver::tools::ClangAs::hasGoodDiagnostics() const"},
    {"_ZNK5clang6driver5tools6darwin3CC116hasIntegratedCPPEv", "clang::driver::tools::darwin::CC1::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools6darwin3CC118hasGoodDiagnosticsEv", "clang::driver::tools::darwin::CC1::hasGoodDiagnostics() const"},
    {"_ZN5clang6driver5tools6darwin3CC1D1Ev", "clang::driver::tools::darwin::CC1::~CC1()"},
    {"_ZN5clang6driver5tools6darwin3CC1D0Ev", "clang::driver::tools::darwin::CC1::~CC1()"},
    {"_ZNK5clang6driver5tools5Clang22hasIntegratedAssemblerEv", "clang::driver::tools::Clang::hasIntegratedAssembler() const"},
    {"_ZNK5clang6driver5tools5Clang16hasIntegratedCPPEv", "clang::driver::tools::Clang::hasIntegratedCPP() const"},
    {"_ZNK5clang6driver5tools5Clang18hasGoodDiagnosticsEv", "clang::driver::tools::Clang::hasGoodDiagnostics() const"},
    {"_ZNK5clang6driver5tools5Clang23AddPreprocessingOptionsERKNS0_6DriverERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS0_9InputInfoERKNSA_ISF_Lj4EEE", "clang::driver::tools::Clang::AddPreprocessingOptions(clang::driver::Driver const&, clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&) const"},
    {"_Z25CheckPreprocessingOptionsRKN5clang6driver6DriverERKNS0_7ArgListE", "CheckPreprocessingOptions(clang::driver::Driver const&, clang::driver::ArgList const&)"},
    {"_ZN5clang6driver5tools6darwin3CC121getDependencyFileNameERKNS0_7ArgListERKN4llvm11SmallVectorINS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::getDependencyFileName(clang::driver::ArgList const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&)"},
    {"_Z11QuoteTargetN4llvm9StringRefERNS_15SmallVectorImplIcEE", "QuoteTarget(llvm::StringRef, llvm::SmallVectorImpl<char>&)"},
    {"_ZNK5clang6driver5tools5Clang16AddARMTargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddARMTargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_Z15getARMTargetCPURKN5clang6driver7ArgListERKN4llvm6TripleE", "getARMTargetCPU(clang::driver::ArgList const&, llvm::Triple const&)"},
    {"_ZNK5clang6driver5tools5Clang17AddMIPSTargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddMIPSTargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools5Clang18AddSparcTargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddSparcTargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools5Clang16AddX86TargetArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::Clang::AddX86TargetArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools5Clang12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS8_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::Clang::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZN5clang6driver5tools6darwin3CC116getBaseInputNameERKNS0_7ArgListERKN4llvm11SmallVectorINS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::getBaseInputName(clang::driver::ArgList const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&)"},
    {"_Z26CheckCodeGenerationOptionsRKN5clang6driver6DriverERKNS0_7ArgListE", "CheckCodeGenerationOptions(clang::driver::Driver const&, clang::driver::ArgList const&)"},
    {"_ZNK5clang6driver5tools7ClangAs12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS8_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::ClangAs::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools3gcc6Common12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::gcc::Common::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools3gcc10Preprocess19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Preprocess::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools3gcc10Precompile19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Precompile::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools3gcc7Compile19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Compile::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools3gcc8Assemble19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Assemble::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools3gcc4Link19RenderExtraToolArgsERKNS0_9JobActionERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::gcc::Link::RenderExtraToolArgs(clang::driver::JobAction const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools6darwin3CC110getCC1NameENS0_5types2IDE", "clang::driver::tools::darwin::CC1::getCC1Name(clang::driver::types::ID) const"},
    {"_ZN5clang6driver5tools6darwin3CC116getBaseInputStemERKNS0_7ArgListERKN4llvm11SmallVectorINS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::getBaseInputStem(clang::driver::ArgList const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&)"},
    {"_ZNK5clang6driver5tools6darwin3CC110AddCC1ArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::CC1::AddCC1Args(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools6darwin3CC117AddCC1OptionsArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS8_INS0_9InputInfoELj4EEERKSB_", "clang::driver::tools::darwin::CC1::AddCC1OptionsArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, llvm::SmallVector<char const*, 16u> const&) const"},
    {"_ZNK5clang6driver5tools6darwin3CC117AddCPPOptionsArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS8_INS0_9InputInfoELj4EEERKSB_", "clang::driver::tools::darwin::CC1::AddCPPOptionsArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, llvm::SmallVector<char const*, 16u> const&) const"},
    {"_ZNK5clang6driver5tools6darwin3CC123AddCPPUniqueOptionsArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEERKNS8_INS0_9InputInfoELj4EEE", "clang::driver::tools::darwin::CC1::AddCPPUniqueOptionsArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&) const"},
    {"_ZNK5clang6driver5tools6darwin3CC110AddCPPArgsERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::CC1::AddCPPArgs(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools6darwin10Preprocess12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Preprocess::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools6darwin7Compile12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Compile::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools6darwin8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools6darwin10DarwinTool13AddDarwinArchERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::DarwinTool::AddDarwinArch(clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools6darwin4Link11AddLinkArgsERNS0_11CompilationERKNS0_7ArgListERN4llvm11SmallVectorIPKcLj16EEE", "clang::driver::tools::darwin::Link::AddLinkArgs(clang::driver::Compilation&, clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&) const"},
    {"_ZNK5clang6driver5tools6darwin4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_Z15AddLinkerInputsRKN5clang6driver9ToolChainERKN4llvm11SmallVectorINS0_9InputInfoELj4EEERKNS0_7ArgListERNS5_IPKcLj16EEE", "AddLinkerInputs(clang::driver::ToolChain const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, llvm::SmallVector<char const*, 16u>&)"},
    {"_ZNK5clang6driver5tools6darwin4Lipo12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Lipo::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools6darwin8Dsymutil12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::darwin::Dsymutil::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools8auroraux8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::auroraux::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools8auroraux4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::auroraux::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools7openbsd8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::openbsd::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools7openbsd4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::openbsd::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools7freebsd8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::freebsd::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools7freebsd4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::freebsd::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools6netbsd8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::netbsd::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools6netbsd4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::netbsd::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools10linuxtools8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::linuxtools::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools10linuxtools4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::linuxtools::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools5minix8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::minix::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools5minix4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::minix::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools9dragonfly8Assemble12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::dragonfly::Assemble::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools9dragonfly4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::dragonfly::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZNK5clang6driver5tools12visualstudio4Link12ConstructJobERNS0_11CompilationERKNS0_9JobActionERKNS0_9InputInfoERKN4llvm11SmallVectorIS9_Lj4EEERKNS0_7ArgListEPKc", "clang::driver::tools::visualstudio::Link::ConstructJob(clang::driver::Compilation&, clang::driver::JobAction const&, clang::driver::InputInfo const&, llvm::SmallVector<clang::driver::InputInfo, 4u> const&, clang::driver::ArgList const&, char const*) const"},
    {"_ZN5clang6driver5tools5ClangD1Ev", "clang::driver::tools::Clang::~Clang()"},
    {"_ZN5clang6driver5tools5ClangD0Ev", "clang::driver::tools::Clang::~Clang()"},
    {"_ZN5clang6driver5tools7ClangAsD1Ev", "clang::driver::tools::ClangAs::~ClangAs()"},
    {"_ZN5clang6driver5tools7ClangAsD0Ev", "clang::driver::tools::ClangAs::~ClangAs()"},
    {"_ZN5clang6driver5tools3gcc10PreprocessD1Ev", "clang::driver::tools::gcc::Preprocess::~Preprocess()"},
    {"_ZN5clang6driver5tools3gcc10PreprocessD0Ev", "clang::driver::tools::gcc::Preprocess::~Preprocess()"},
    {"_ZN5clang6driver5tools3gcc10PrecompileD1Ev", "clang::driver::tools::gcc::Precompile::~Precompile()"},
    {"_ZN5clang6driver5tools3gcc10PrecompileD0Ev", "clang::driver::tools::gcc::Precompile::~Precompile()"},
    {"_ZN5clang6driver5tools3gcc7CompileD1Ev", "clang::driver::tools::gcc::Compile::~Compile()"},
    {"_ZN5clang6driver5tools3gcc7CompileD0Ev", "clang::driver::tools::gcc::Compile::~Compile()"},
    {"_ZN5clang6driver5tools3gcc8AssembleD1Ev", "clang::driver::tools::gcc::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools3gcc8AssembleD0Ev", "clang::driver::tools::gcc::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools3gcc4LinkD1Ev", "clang::driver::tools::gcc::Link::~Link()"},
    {"_ZN5clang6driver5tools3gcc4LinkD0Ev", "clang::driver::tools::gcc::Link::~Link()"},
    {"_ZN5clang6driver5tools6darwin10PreprocessD1Ev", "clang::driver::tools::darwin::Preprocess::~Preprocess()"},
    {"_ZN5clang6driver5tools6darwin10PreprocessD0Ev", "clang::driver::tools::darwin::Preprocess::~Preprocess()"},
    {"_ZN5clang6driver5tools6darwin7CompileD1Ev", "clang::driver::tools::darwin::Compile::~Compile()"},
    {"_ZN5clang6driver5tools6darwin7CompileD0Ev", "clang::driver::tools::darwin::Compile::~Compile()"},
    {"_ZN5clang6driver5tools6darwin8AssembleD1Ev", "clang::driver::tools::darwin::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools6darwin8AssembleD0Ev", "clang::driver::tools::darwin::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools6darwin4LinkD1Ev", "clang::driver::tools::darwin::Link::~Link()"},
    {"_ZN5clang6driver5tools6darwin4LinkD0Ev", "clang::driver::tools::darwin::Link::~Link()"},
    {"_ZN5clang6driver5tools6darwin4LipoD1Ev", "clang::driver::tools::darwin::Lipo::~Lipo()"},
    {"_ZN5clang6driver5tools6darwin4LipoD0Ev", "clang::driver::tools::darwin::Lipo::~Lipo()"},
    {"_ZN5clang6driver5tools6darwin8DsymutilD1Ev", "clang::driver::tools::darwin::Dsymutil::~Dsymutil()"},
    {"_ZN5clang6driver5tools6darwin8DsymutilD0Ev", "clang::driver::tools::darwin::Dsymutil::~Dsymutil()"},
    {"_ZN5clang6driver5tools7openbsd8AssembleD1Ev", "clang::driver::tools::openbsd::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools7openbsd8AssembleD0Ev", "clang::driver::tools::openbsd::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools7openbsd4LinkD1Ev", "clang::driver::tools::openbsd::Link::~Link()"},
    {"_ZN5clang6driver5tools7openbsd4LinkD0Ev", "clang::driver::tools::openbsd::Link::~Link()"},
    {"_ZN5clang6driver5tools7freebsd8AssembleD1Ev", "clang::driver::tools::freebsd::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools7freebsd8AssembleD0Ev", "clang::driver::tools::freebsd::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools7freebsd4LinkD1Ev", "clang::driver::tools::freebsd::Link::~Link()"},
    {"_ZN5clang6driver5tools7freebsd4LinkD0Ev", "clang::driver::tools::freebsd::Link::~Link()"},
    {"_ZN5clang6driver5tools6netbsd8AssembleD1Ev", "clang::driver::tools::netbsd::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools6netbsd8AssembleD0Ev", "clang::driver::tools::netbsd::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools6netbsd4LinkD1Ev", "clang::driver::tools::netbsd::Link::~Link()"},
    {"_ZN5clang6driver5tools6netbsd4LinkD0Ev", "clang::driver::tools::netbsd::Link::~Link()"},
    {"_ZN5clang6driver5tools10linuxtools8AssembleD1Ev", "clang::driver::tools::linuxtools::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools10linuxtools8AssembleD0Ev", "clang::driver::tools::linuxtools::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools10linuxtools4LinkD1Ev", "clang::driver::tools::linuxtools::Link::~Link()"},
    {"_ZN5clang6driver5tools10linuxtools4LinkD0Ev", "clang::driver::tools::linuxtools::Link::~Link()"},
    {"_ZN5clang6driver5tools5minix8AssembleD1Ev", "clang::driver::tools::minix::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools5minix8AssembleD0Ev", "clang::driver::tools::minix::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools5minix4LinkD1Ev", "clang::driver::tools::minix::Link::~Link()"},
    {"_ZN5clang6driver5tools5minix4LinkD0Ev", "clang::driver::tools::minix::Link::~Link()"},
    {"_ZN5clang6driver5tools8auroraux8AssembleD1Ev", "clang::driver::tools::auroraux::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools8auroraux8AssembleD0Ev", "clang::driver::tools::auroraux::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools8auroraux4LinkD1Ev", "clang::driver::tools::auroraux::Link::~Link()"},
    {"_ZN5clang6driver5tools8auroraux4LinkD0Ev", "clang::driver::tools::auroraux::Link::~Link()"},
    {"_ZN5clang6driver5tools9dragonfly8AssembleD1Ev", "clang::driver::tools::dragonfly::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools9dragonfly8AssembleD0Ev", "clang::driver::tools::dragonfly::Assemble::~Assemble()"},
    {"_ZN5clang6driver5tools9dragonfly4LinkD1Ev", "clang::driver::tools::dragonfly::Link::~Link()"},
    {"_ZN5clang6driver5tools9dragonfly4LinkD0Ev", "clang::driver::tools::dragonfly::Link::~Link()"},
    {"_ZN5clang6driver5tools12visualstudio4LinkD1Ev", "clang::driver::tools::visualstudio::Link::~Link()"},
    {"_ZN5clang6driver5tools12visualstudio4LinkD0Ev", "clang::driver::tools::visualstudio::Link::~Link()"},
    {"_ZN4llvm15SmallVectorImplISsEaSERKS1_", "llvm::SmallVectorImpl<std::string>::operator=(llvm::SmallVectorImpl<std::string> const&)"},
    {"_ZN5clang6driver5types11getTypeNameENS1_2IDE", "clang::driver::types::getTypeName(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types19getPreprocessedTypeENS1_2IDE", "clang::driver::types::getPreprocessedType(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types17getTypeTempSuffixENS1_2IDE", "clang::driver::types::getTypeTempSuffix(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types16onlyAssembleTypeENS1_2IDE", "clang::driver::types::onlyAssembleType(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types18onlyPrecompileTypeENS1_2IDE", "clang::driver::types::onlyPrecompileType(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types22canTypeBeUserSpecifiedENS1_2IDE", "clang::driver::types::canTypeBeUserSpecified(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types19appendSuffixForTypeENS1_2IDE", "clang::driver::types::appendSuffixForType(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types11canLipoTypeENS1_2IDE", "clang::driver::types::canLipoType(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types17isAcceptedByClangENS1_2IDE", "clang::driver::types::isAcceptedByClang(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types21isOnlyAcceptedByClangENS1_2IDE", "clang::driver::types::isOnlyAcceptedByClang(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types6isObjCENS1_2IDE", "clang::driver::types::isObjC(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types5isCXXENS1_2IDE", "clang::driver::types::isCXX(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types22lookupTypeForExtensionEPKc", "clang::driver::types::lookupTypeForExtension(char const*)"},
    {"_ZN5clang6driver5types26lookupTypeForTypeSpecifierEPKc", "clang::driver::types::lookupTypeForTypeSpecifier(char const*)"},
    {"_ZN5clang6driver5types23getNumCompilationPhasesENS1_2IDE", "clang::driver::types::getNumCompilationPhases(clang::driver::types::ID)"},
    {"_ZN5clang6driver5types19getCompilationPhaseENS1_2IDEj", "clang::driver::types::getCompilationPhase(clang::driver::types::ID, unsigned int)"},
    {"_ZN5clang6driver5types21lookupCXXTypeForCTypeENS1_2IDE", "clang::driver::types::lookupCXXTypeForCType(clang::driver::types::ID)"},
    {"_ZN5clang26ASTDeserializationListenerD0Ev", "clang::ASTDeserializationListener::~ASTDeserializationListener()"},
    {"_ZN5clang26ASTDeserializationListenerD1Ev", "clang::ASTDeserializationListener::~ASTDeserializationListener()"},
    {"_ZN5clang26ASTDeserializationListenerD2Ev", "clang::ASTDeserializationListener::~ASTDeserializationListener()"},
    {"_ZN5clang13serialization18TypeIdxFromBuiltinEPKNS_11BuiltinTypeE", "clang::serialization::TypeIdxFromBuiltin(clang::BuiltinType const*)"},
    {"_ZN5clang13serialization11ComputeHashENS_8SelectorE", "clang::serialization::ComputeHash(clang::Selector)"},
    {"_ZN5clang17ASTReaderListenerD0Ev", "clang::ASTReaderListener::~ASTReaderListener()"},
    {"_ZN5clang17ASTReaderListenerD1Ev", "clang::ASTReaderListener::~ASTReaderListener()"},
    {"_ZN5clang17ASTReaderListenerD2Ev", "clang::ASTReaderListener::~ASTReaderListener()"},
    {"_ZN5clang12PCHValidator19ReadLanguageOptionsERKNS_11LangOptionsE", "clang::PCHValidator::ReadLanguageOptions(clang::LangOptions const&)"},
    {"_ZN5clang9ASTReader4DiagEj", "clang::ASTReader::Diag(unsigned int)"},
    {"_ZN5clang12PCHValidator16ReadTargetTripleEN4llvm9StringRefE", "clang::PCHValidator::ReadTargetTriple(llvm::StringRef)"},
    {"_ZN5clang12PCHValidator20ReadPredefinesBufferERKN4llvm11SmallVectorINS_18PCHPredefinesBlockELj2EEENS1_9StringRefERSs", "clang::PCHValidator::ReadPredefinesBuffer(llvm::SmallVector<clang::PCHPredefinesBlock, 2u> const&, llvm::StringRef, std::string&)"},
    {"_ZN5clang9ASTReader4DiagENS_14SourceLocationEj", "clang::ASTReader::Diag(clang::SourceLocation, unsigned int)"},
    {"_ZN5clang12PCHValidator18ReadHeaderFileInfoERKNS_14HeaderFileInfoEj", "clang::PCHValidator::ReadHeaderFileInfo(clang::HeaderFileInfo const&, unsigned int)"},
    {"_ZN5clang12PCHValidator11ReadCounterEj", "clang::PCHValidator::ReadCounter(unsigned int)"},
    {"_ZN5clang9ASTReader26setDeserializationListenerEPNS_26ASTDeserializationListenerE", "clang::ASTReader::setDeserializationListener(clang::ASTDeserializationListener*)"},
    {"_ZN5clang9ASTReader22ReadDeclContextStorageERN4llvm15BitstreamCursorERKSt4pairIyyERNS0_15DeclContextInfoE", "clang::ASTReader::ReadDeclContextStorage(llvm::BitstreamCursor&, std::pair<unsigned long long, unsigned long long> const&, clang::ASTReader::DeclContextInfo&)"},
    {"_ZN5clang9ASTReader5ErrorEPKc", "clang::ASTReader::Error(char const*)"},
    {"_ZN5clang9ASTReader22CheckPredefinesBuffersEv", "clang::ASTReader::CheckPredefinesBuffers()"},
    {"_ZN5clang9ASTReader14ParseLineTableERNS0_11PerFileDataERN4llvm15SmallVectorImplIyEE", "clang::ASTReader::ParseLineTable(clang::ASTReader::PerFileData&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTReader28MaybeAddSystemRootToFilenameERSs", "clang::ASTReader::MaybeAddSystemRootToFilename(std::string&)"},
    {"_ZN5clang9ASTReader22ReadSourceManagerBlockERNS0_11PerFileDataE", "clang::ASTReader::ReadSourceManagerBlock(clang::ASTReader::PerFileData&)"},
    {"_ZN5clang9ASTReader15SLocCursorForIDEj", "clang::ASTReader::SLocCursorForID(unsigned int)"},
    {"_ZN5clang9ASTReader19ReadSLocEntryRecordEj", "clang::ASTReader::ReadSLocEntryRecord(unsigned int)"},
    {"_ZN5clang9ASTReader16ReadBlockAbbrevsERN4llvm15BitstreamCursorEj", "clang::ASTReader::ReadBlockAbbrevs(llvm::BitstreamCursor&, unsigned int)"},
    {"_ZN5clang9ASTReader15ReadMacroRecordERNS0_11PerFileDataEy", "clang::ASTReader::ReadMacroRecord(clang::ASTReader::PerFileData&, unsigned long long)"},
    {"_ZN5clang9ASTReader20DecodeIdentifierInfoEj", "clang::ASTReader::DecodeIdentifierInfo(unsigned int)"},
    {"_ZN5clang9ASTReader18getMacroDefinitionEj", "clang::ASTReader::getMacroDefinition(unsigned int)"},
    {"_ZN5clang9ASTReader22LoadPreprocessedEntityERNS0_11PerFileDataE", "clang::ASTReader::LoadPreprocessedEntity(clang::ASTReader::PerFileData&)"},
    {"_ZN5clang9ASTReader20SetIdentifierIsMacroEPNS_14IdentifierInfoERNS0_11PerFileDataEy", "clang::ASTReader::SetIdentifierIsMacro(clang::IdentifierInfo*, clang::ASTReader::PerFileData&, unsigned long long)"},
    {"_ZN5clang9ASTReader17ReadDefinedMacrosEv", "clang::ASTReader::ReadDefinedMacros()"},
    {"_ZN5clang9ASTReader19LoadMacroDefinitionEN4llvm16DenseMapIteratorIPNS_14IdentifierInfoEyNS1_12DenseMapInfoIS4_EENS5_IyEELb0EEE", "clang::ASTReader::LoadMacroDefinition(llvm::DenseMapIterator<clang::IdentifierInfo*, unsigned long long, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<unsigned long long>, false>)"},
    {"_ZN5clang9ASTReader19LoadMacroDefinitionEPNS_14IdentifierInfoE", "clang::ASTReader::LoadMacroDefinition(clang::IdentifierInfo*)"},
    {"_ZN5clang9ASTReader12ReadASTBlockERNS0_11PerFileDataE", "clang::ASTReader::ReadASTBlock(clang::ASTReader::PerFileData&)"},
    {"_ZN5clang9ASTReader11ReadASTCoreEN4llvm9StringRefENS0_11ASTFileTypeE", "clang::ASTReader::ReadASTCore(llvm::StringRef, clang::ASTReader::ASTFileType)"},
    {"_ZN5clang9ASTReader20ParseLanguageOptionsERKN4llvm15SmallVectorImplIyEE", "clang::ASTReader::ParseLanguageOptions(llvm::SmallVectorImpl<unsigned long long> const&)"},
    {"_ZN5clang9ASTReader7ReadASTERKSsNS0_11ASTFileTypeE", "clang::ASTReader::ReadAST(std::string const&, clang::ASTReader::ASTFileType)"},
    {"_ZN5clang9ASTReader17InitializeContextERNS_10ASTContextE", "clang::ASTReader::InitializeContext(clang::ASTContext&)"},
    {"_ZN5clang9ASTReader11PerFileDataC1ENS0_11ASTFileTypeE", "clang::ASTReader::PerFileData::PerFileData(clang::ASTReader::ASTFileType)"},
    {"_ZN5clang9ASTReader15setPreprocessorERNS_12PreprocessorE", "clang::ASTReader::setPreprocessor(clang::Preprocessor&)"},
    {"_ZN5clang9ASTReader22GetTranslationUnitDeclEv", "clang::ASTReader::GetTranslationUnitDecl()"},
    {"_ZN5clang9ASTReader7GetTypeEj", "clang::ASTReader::GetType(unsigned int)"},
    {"_ZN5clang9ASTReader28ReadPragmaDiagnosticMappingsERNS_10DiagnosticE", "clang::ASTReader::ReadPragmaDiagnosticMappings(clang::Diagnostic&)"},
    {"_ZN5clang9ASTReader7GetDeclEj", "clang::ASTReader::GetDecl(unsigned int)"},
    {"_ZN5clang9ASTReader21getOriginalSourceFileERKSsRNS_11FileManagerERNS_10DiagnosticE", "clang::ASTReader::getOriginalSourceFile(std::string const&, clang::FileManager&, clang::Diagnostic&)"},
    {"_ZThn8_N5clang9ASTReader24ReadPreprocessedEntitiesEv", "non-virtual thunk to clang::ASTReader::ReadPreprocessedEntities()"},
    {"_ZN5clang9ASTReader24ReadPreprocessedEntitiesEv", "clang::ASTReader::ReadPreprocessedEntities()"},
    {"_ZThn8_N5clang9ASTReader22ReadPreprocessedEntityEy", "non-virtual thunk to clang::ASTReader::ReadPreprocessedEntity(unsigned long long)"},
    {"_ZN5clang9ASTReader22ReadPreprocessedEntityEy", "clang::ASTReader::ReadPreprocessedEntity(unsigned long long)"},
    {"_ZN5clang9ASTReader18TypeCursorForIndexEj", "clang::ASTReader::TypeCursorForIndex(unsigned int)"},
    {"_ZN5clang9ASTReader14ReadTypeRecordEj", "clang::ASTReader::ReadTypeRecord(unsigned int)"},
    {"_ZN5clang9ASTReader9ReadAPIntERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadAPInt(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader23ReadNestedNameSpecifierERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadNestedNameSpecifier(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader20ReadTemplateArgumentERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateArgument(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader15ReadSourceRangeERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadSourceRange(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader16ReadTemplateNameERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateName(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader24ReadTemplateArgumentListERN4llvm11SmallVectorINS_16TemplateArgumentELj8EEERNS0_11PerFileDataERKNS2_IyLj64EEERj", "clang::ASTReader::ReadTemplateArgumentList(llvm::SmallVector<clang::TemplateArgument, 8u>&, clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang13TypeLocReader21VisitQualifiedTypeLocENS_16QualifiedTypeLocE", "clang::TypeLocReader::VisitQualifiedTypeLoc(clang::QualifiedTypeLoc)"},
    {"_ZN5clang13TypeLocReader19VisitBuiltinTypeLocENS_14BuiltinTypeLocE", "clang::TypeLocReader::VisitBuiltinTypeLoc(clang::BuiltinTypeLoc)"},
    {"_ZN5clang13TypeLocReader19VisitComplexTypeLocENS_14ComplexTypeLocE", "clang::TypeLocReader::VisitComplexTypeLoc(clang::ComplexTypeLoc)"},
    {"_ZN5clang13TypeLocReader19VisitPointerTypeLocENS_14PointerTypeLocE", "clang::TypeLocReader::VisitPointerTypeLoc(clang::PointerTypeLoc)"},
    {"_ZN5clang13TypeLocReader24VisitBlockPointerTypeLocENS_19BlockPointerTypeLocE", "clang::TypeLocReader::VisitBlockPointerTypeLoc(clang::BlockPointerTypeLoc)"},
    {"_ZN5clang13TypeLocReader27VisitLValueReferenceTypeLocENS_22LValueReferenceTypeLocE", "clang::TypeLocReader::VisitLValueReferenceTypeLoc(clang::LValueReferenceTypeLoc)"},
    {"_ZN5clang13TypeLocReader27VisitRValueReferenceTypeLocENS_22RValueReferenceTypeLocE", "clang::TypeLocReader::VisitRValueReferenceTypeLoc(clang::RValueReferenceTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitMemberPointerTypeLocENS_20MemberPointerTypeLocE", "clang::TypeLocReader::VisitMemberPointerTypeLoc(clang::MemberPointerTypeLoc)"},
    {"_ZN5clang13TypeLocReader17VisitArrayTypeLocENS_12ArrayTypeLocE", "clang::TypeLocReader::VisitArrayTypeLoc(clang::ArrayTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitConstantArrayTypeLocENS_20ConstantArrayTypeLocE", "clang::TypeLocReader::VisitConstantArrayTypeLoc(clang::ConstantArrayTypeLoc)"},
    {"_ZN5clang13TypeLocReader27VisitIncompleteArrayTypeLocENS_22IncompleteArrayTypeLocE", "clang::TypeLocReader::VisitIncompleteArrayTypeLoc(clang::IncompleteArrayTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitVariableArrayTypeLocENS_20VariableArrayTypeLocE", "clang::TypeLocReader::VisitVariableArrayTypeLoc(clang::VariableArrayTypeLoc)"},
    {"_ZN5clang13TypeLocReader31VisitDependentSizedArrayTypeLocENS_26DependentSizedArrayTypeLocE", "clang::TypeLocReader::VisitDependentSizedArrayTypeLoc(clang::DependentSizedArrayTypeLoc)"},
    {"_ZN5clang13TypeLocReader35VisitDependentSizedExtVectorTypeLocENS_30DependentSizedExtVectorTypeLocE", "clang::TypeLocReader::VisitDependentSizedExtVectorTypeLoc(clang::DependentSizedExtVectorTypeLoc)"},
    {"_ZN5clang13TypeLocReader18VisitVectorTypeLocENS_13VectorTypeLocE", "clang::TypeLocReader::VisitVectorTypeLoc(clang::VectorTypeLoc)"},
    {"_ZN5clang13TypeLocReader21VisitExtVectorTypeLocENS_16ExtVectorTypeLocE", "clang::TypeLocReader::VisitExtVectorTypeLoc(clang::ExtVectorTypeLoc)"},
    {"_ZN5clang13TypeLocReader20VisitFunctionTypeLocENS_15FunctionTypeLocE", "clang::TypeLocReader::VisitFunctionTypeLoc(clang::FunctionTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitFunctionProtoTypeLocENS_20FunctionProtoTypeLocE", "clang::TypeLocReader::VisitFunctionProtoTypeLoc(clang::FunctionProtoTypeLoc)"},
    {"_ZN5clang13TypeLocReader27VisitFunctionNoProtoTypeLocENS_22FunctionNoProtoTypeLocE", "clang::TypeLocReader::VisitFunctionNoProtoTypeLoc(clang::FunctionNoProtoTypeLoc)"},
    {"_ZN5clang13TypeLocReader27VisitUnresolvedUsingTypeLocENS_22UnresolvedUsingTypeLocE", "clang::TypeLocReader::VisitUnresolvedUsingTypeLoc(clang::UnresolvedUsingTypeLoc)"},
    {"_ZN5clang13TypeLocReader19VisitTypedefTypeLocENS_14TypedefTypeLocE", "clang::TypeLocReader::VisitTypedefTypeLoc(clang::TypedefTypeLoc)"},
    {"_ZN5clang13TypeLocReader22VisitTypeOfExprTypeLocENS_17TypeOfExprTypeLocE", "clang::TypeLocReader::VisitTypeOfExprTypeLoc(clang::TypeOfExprTypeLoc)"},
    {"_ZN5clang13TypeLocReader18VisitTypeOfTypeLocENS_13TypeOfTypeLocE", "clang::TypeLocReader::VisitTypeOfTypeLoc(clang::TypeOfTypeLoc)"},
    {"_ZN5clang9ASTReader17GetTypeSourceInfoERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::GetTypeSourceInfo(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang13TypeLocReader20VisitDecltypeTypeLocENS_15DecltypeTypeLocE", "clang::TypeLocReader::VisitDecltypeTypeLoc(clang::DecltypeTypeLoc)"},
    {"_ZN5clang13TypeLocReader18VisitRecordTypeLocENS_13RecordTypeLocE", "clang::TypeLocReader::VisitRecordTypeLoc(clang::RecordTypeLoc)"},
    {"_ZN5clang13TypeLocReader16VisitEnumTypeLocENS_11EnumTypeLocE", "clang::TypeLocReader::VisitEnumTypeLoc(clang::EnumTypeLoc)"},
    {"_ZN5clang13TypeLocReader22VisitAttributedTypeLocENS_17AttributedTypeLocE", "clang::TypeLocReader::VisitAttributedTypeLoc(clang::AttributedTypeLoc)"},
    {"_ZN5clang13TypeLocReader28VisitTemplateTypeParmTypeLocENS_23TemplateTypeParmTypeLocE", "clang::TypeLocReader::VisitTemplateTypeParmTypeLoc(clang::TemplateTypeParmTypeLoc)"},
    {"_ZN5clang13TypeLocReader33VisitSubstTemplateTypeParmTypeLocENS_28SubstTemplateTypeParmTypeLocE", "clang::TypeLocReader::VisitSubstTemplateTypeParmTypeLoc(clang::SubstTemplateTypeParmTypeLoc)"},
    {"_ZN5clang13TypeLocReader37VisitSubstTemplateTypeParmPackTypeLocENS_32SubstTemplateTypeParmPackTypeLocE", "clang::TypeLocReader::VisitSubstTemplateTypeParmPackTypeLoc(clang::SubstTemplateTypeParmPackTypeLoc)"},
    {"_ZN5clang13TypeLocReader34VisitTemplateSpecializationTypeLocENS_29TemplateSpecializationTypeLocE", "clang::TypeLocReader::VisitTemplateSpecializationTypeLoc(clang::TemplateSpecializationTypeLoc)"},
    {"_ZN5clang9ASTReader26GetTemplateArgumentLocInfoERNS0_11PerFileDataENS_16TemplateArgument7ArgKindERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::GetTemplateArgumentLocInfo(clang::ASTReader::PerFileData&, clang::TemplateArgument::ArgKind, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang13TypeLocReader17VisitParenTypeLocENS_12ParenTypeLocE", "clang::TypeLocReader::VisitParenTypeLoc(clang::ParenTypeLoc)"},
    {"_ZN5clang13TypeLocReader22VisitElaboratedTypeLocENS_17ElaboratedTypeLocE", "clang::TypeLocReader::VisitElaboratedTypeLoc(clang::ElaboratedTypeLoc)"},
    {"_ZN5clang13TypeLocReader29VisitInjectedClassNameTypeLocENS_24InjectedClassNameTypeLocE", "clang::TypeLocReader::VisitInjectedClassNameTypeLoc(clang::InjectedClassNameTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitDependentNameTypeLocENS_20DependentNameTypeLocE", "clang::TypeLocReader::VisitDependentNameTypeLoc(clang::DependentNameTypeLoc)"},
    {"_ZN5clang13TypeLocReader43VisitDependentTemplateSpecializationTypeLocENS_38DependentTemplateSpecializationTypeLocE", "clang::TypeLocReader::VisitDependentTemplateSpecializationTypeLoc(clang::DependentTemplateSpecializationTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitPackExpansionTypeLocENS_20PackExpansionTypeLocE", "clang::TypeLocReader::VisitPackExpansionTypeLoc(clang::PackExpansionTypeLoc)"},
    {"_ZN5clang13TypeLocReader25VisitObjCInterfaceTypeLocENS_20ObjCInterfaceTypeLocE", "clang::TypeLocReader::VisitObjCInterfaceTypeLoc(clang::ObjCInterfaceTypeLoc)"},
    {"_ZN5clang13TypeLocReader22VisitObjCObjectTypeLocENS_17ObjCObjectTypeLocE", "clang::TypeLocReader::VisitObjCObjectTypeLoc(clang::ObjCObjectTypeLoc)"},
    {"_ZN5clang13TypeLocReader29VisitObjCObjectPointerTypeLocENS_24ObjCObjectPointerTypeLocE", "clang::TypeLocReader::VisitObjCObjectPointerTypeLoc(clang::ObjCObjectPointerTypeLoc)"},
    {"_ZNK5clang9ASTReader9GetTypeIDENS_8QualTypeE", "clang::ASTReader::GetTypeID(clang::QualType) const"},
    {"_ZNK5clang9ASTReader10GetTypeIdxENS_8QualTypeE", "clang::ASTReader::GetTypeIdx(clang::QualType) const"},
    {"_ZNK5clang9ASTReader28getTotalNumCXXBaseSpecifiersEv", "clang::ASTReader::getTotalNumCXXBaseSpecifiers() const"},
    {"_ZN5clang9ASTReader23ReadTemplateArgumentLocERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateArgumentLoc(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZThn16_N5clang9ASTReader15GetExternalDeclEj", "non-virtual thunk to clang::ASTReader::GetExternalDecl(unsigned int)"},
    {"_ZN5clang9ASTReader15GetExternalDeclEj", "clang::ASTReader::GetExternalDecl(unsigned int)"},
    {"_ZN5clang9ASTReader26GetCXXBaseSpecifiersOffsetEj", "clang::ASTReader::GetCXXBaseSpecifiersOffset(unsigned int)"},
    {"_ZThn16_N5clang9ASTReader28GetExternalCXXBaseSpecifiersEy", "non-virtual thunk to clang::ASTReader::GetExternalCXXBaseSpecifiers(unsigned long long)"},
    {"_ZN5clang9ASTReader28GetExternalCXXBaseSpecifiersEy", "clang::ASTReader::GetExternalCXXBaseSpecifiers(unsigned long long)"},
    {"_ZN5clang9ASTReader20ReadCXXBaseSpecifierERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadCXXBaseSpecifier(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZThn16_N5clang9ASTReader19GetExternalDeclStmtEy", "non-virtual thunk to clang::ASTReader::GetExternalDeclStmt(unsigned long long)"},
    {"_ZN5clang9ASTReader19GetExternalDeclStmtEy", "clang::ASTReader::GetExternalDeclStmt(unsigned long long)"},
    {"_ZN5clang9ASTReader18ClearSwitchCaseIDsEv", "clang::ASTReader::ClearSwitchCaseIDs()"},
    {"_ZThn16_N5clang9ASTReader24FindExternalLexicalDeclsEPKNS_11DeclContextEPFbNS_4Decl4KindEERN4llvm15SmallVectorImplIPS4_EE", "non-virtual thunk to clang::ASTReader::FindExternalLexicalDecls(clang::DeclContext const*, bool (*)(clang::Decl::Kind), llvm::SmallVectorImpl<clang::Decl*>&)"},
    {"_ZN5clang9ASTReader24FindExternalLexicalDeclsEPKNS_11DeclContextEPFbNS_4Decl4KindEERN4llvm15SmallVectorImplIPS4_EE", "clang::ASTReader::FindExternalLexicalDecls(clang::DeclContext const*, bool (*)(clang::Decl::Kind), llvm::SmallVectorImpl<clang::Decl*>&)"},
    {"_ZThn16_N5clang9ASTReader30FindExternalVisibleDeclsByNameEPKNS_11DeclContextENS_15DeclarationNameE", "non-virtual thunk to clang::ASTReader::FindExternalVisibleDeclsByName(clang::DeclContext const*, clang::DeclarationName)"},
    {"_ZN5clang9ASTReader30FindExternalVisibleDeclsByNameEPKNS_11DeclContextENS_15DeclarationNameE", "clang::ASTReader::FindExternalVisibleDeclsByName(clang::DeclContext const*, clang::DeclarationName)"},
    {"_ZThn16_N5clang9ASTReader23MaterializeVisibleDeclsEPKNS_11DeclContextE", "non-virtual thunk to clang::ASTReader::MaterializeVisibleDecls(clang::DeclContext const*)"},
    {"_ZN5clang9ASTReader23MaterializeVisibleDeclsEPKNS_11DeclContextE", "clang::ASTReader::MaterializeVisibleDecls(clang::DeclContext const*)"},
    {"_ZN5clang9ASTReader30PassInterestingDeclsToConsumerEv", "clang::ASTReader::PassInterestingDeclsToConsumer()"},
    {"_ZThn16_N5clang9ASTReader20StartTranslationUnitEPNS_11ASTConsumerE", "non-virtual thunk to clang::ASTReader::StartTranslationUnit(clang::ASTConsumer*)"},
    {"_ZN5clang9ASTReader20StartTranslationUnitEPNS_11ASTConsumerE", "clang::ASTReader::StartTranslationUnit(clang::ASTConsumer*)"},
    {"_ZThn16_N5clang9ASTReader10PrintStatsEv", "non-virtual thunk to clang::ASTReader::PrintStats()"},
    {"_ZN5clang9ASTReader10PrintStatsEv", "clang::ASTReader::PrintStats()"},
    {"_ZThn16_N5clang9ASTReader14InitializeSemaERNS_4SemaE", "non-virtual thunk to clang::ASTReader::InitializeSema(clang::Sema&)"},
    {"_ZN5clang9ASTReader14InitializeSemaERNS_4SemaE", "clang::ASTReader::InitializeSema(clang::Sema&)"},
    {"_ZN5clang9ASTReader14DecodeSelectorEj", "clang::ASTReader::DecodeSelector(unsigned int)"},
    {"_ZN5clang9ASTReader3getEPKcS2_", "clang::ASTReader::get(char const*, char const*)"},
    {"_ZN5clang21ASTIdentifierIteratorC1ERKNS_9ASTReaderE", "clang::ASTIdentifierIterator::ASTIdentifierIterator(clang::ASTReader const&)"},
    {"_ZN5clang21ASTIdentifierIteratorC2ERKNS_9ASTReaderE", "clang::ASTIdentifierIterator::ASTIdentifierIterator(clang::ASTReader const&)"},
    {"_ZN5clang21ASTIdentifierIterator4NextEv", "clang::ASTIdentifierIterator::Next()"},
    {"_ZThn32_NK5clang9ASTReader14getIdentifiersEv", "non-virtual thunk to clang::ASTReader::getIdentifiers() const"},
    {"_ZNK5clang9ASTReader14getIdentifiersEv", "clang::ASTReader::getIdentifiers() const"},
    {"_ZThn16_N5clang9ASTReader14ReadMethodPoolENS_8SelectorE", "non-virtual thunk to clang::ASTReader::ReadMethodPool(clang::Selector)"},
    {"_ZN5clang9ASTReader14ReadMethodPoolENS_8SelectorE", "clang::ASTReader::ReadMethodPool(clang::Selector)"},
    {"_ZN5clang9ASTReader12LoadSelectorENS_8SelectorE", "clang::ASTReader::LoadSelector(clang::Selector)"},
    {"_ZN5clang9ASTReader17SetIdentifierInfoEjPNS_14IdentifierInfoE", "clang::ASTReader::SetIdentifierInfo(unsigned int, clang::IdentifierInfo*)"},
    {"_ZN5clang9ASTReader23SetGloballyVisibleDeclsEPNS_14IdentifierInfoERKN4llvm15SmallVectorImplIjEEb", "clang::ASTReader::SetGloballyVisibleDecls(clang::IdentifierInfo*, llvm::SmallVectorImpl<unsigned int> const&, bool)"},
    {"_ZThn48_N5clang9ASTReader13ReadSLocEntryEj", "non-virtual thunk to clang::ASTReader::ReadSLocEntry(unsigned int)"},
    {"_ZN5clang9ASTReader13ReadSLocEntryEj", "clang::ASTReader::ReadSLocEntry(unsigned int)"},
    {"_ZN12_GLOBAL__N_122ASTSelectorLookupTrait7ReadKeyEPKhj", "(anonymous namespace)::ASTSelectorLookupTrait::ReadKey(unsigned char const*, unsigned int)"},
    {"_ZThn16_N5clang9ASTReader19GetExternalSelectorEj", "non-virtual thunk to clang::ASTReader::GetExternalSelector(unsigned int)"},
    {"_ZN5clang9ASTReader19GetExternalSelectorEj", "clang::ASTReader::GetExternalSelector(unsigned int)"},
    {"_ZThn16_N5clang9ASTReader23GetNumExternalSelectorsEv", "non-virtual thunk to clang::ASTReader::GetNumExternalSelectors()"},
    {"_ZN5clang9ASTReader23GetNumExternalSelectorsEv", "clang::ASTReader::GetNumExternalSelectors()"},
    {"_ZN5clang9ASTReader19ReadDeclarationNameERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadDeclarationName(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader22ReadDeclarationNameLocERNS0_11PerFileDataERNS_18DeclarationNameLocENS_15DeclarationNameERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadDeclarationNameLoc(clang::ASTReader::PerFileData&, clang::DeclarationNameLoc&, clang::DeclarationName, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader23ReadDeclarationNameInfoERNS0_11PerFileDataERNS_19DeclarationNameInfoERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadDeclarationNameInfo(clang::ASTReader::PerFileData&, clang::DeclarationNameInfo&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader17ReadQualifierInfoERNS0_11PerFileDataERNS_13QualifierInfoERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadQualifierInfo(clang::ASTReader::PerFileData&, clang::QualifierInfo&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader25ReadTemplateParameterListERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadTemplateParameterList(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader10ReadAPSIntERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadAPSInt(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader17ReadUnresolvedSetERNS_17UnresolvedSetImplERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadUnresolvedSet(clang::UnresolvedSetImpl&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader23ReadCXXCtorInitializersERNS0_11PerFileDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadCXXCtorInitializers(clang::ASTReader::PerFileData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader11ReadAPFloatERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadAPFloat(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader10ReadStringERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadString(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader16ReadCXXTemporaryERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTReader::ReadCXXTemporary(llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang9ASTReader18getIdentifierTableEv", "clang::ASTReader::getIdentifierTable()"},
    {"_ZN5clang9ASTReader18RecordSwitchCaseIDEPNS_10SwitchCaseEj", "clang::ASTReader::RecordSwitchCaseID(clang::SwitchCase*, unsigned int)"},
    {"_ZN5clang9ASTReader19getSwitchCaseWithIDEj", "clang::ASTReader::getSwitchCaseWithID(unsigned int)"},
    {"_ZN5clang9ASTReader15RecordLabelStmtEPNS_9LabelStmtEj", "clang::ASTReader::RecordLabelStmt(clang::LabelStmt*, unsigned int)"},
    {"_ZN5clang9ASTReader10SetLabelOfEPNS_8GotoStmtEj", "clang::ASTReader::SetLabelOf(clang::GotoStmt*, unsigned int)"},
    {"_ZN5clang9ASTReader10SetLabelOfEPNS_13AddrLabelExprEj", "clang::ASTReader::SetLabelOf(clang::AddrLabelExpr*, unsigned int)"},
    {"_ZThn16_N5clang9ASTReader21FinishedDeserializingEv", "non-virtual thunk to clang::ASTReader::FinishedDeserializing()"},
    {"_ZN5clang9ASTReader21FinishedDeserializingEv", "clang::ASTReader::FinishedDeserializing()"},
    {"_ZN5clang9ASTReaderC1ERNS_12PreprocessorEPNS_10ASTContextEPKcbb", "clang::ASTReader::ASTReader(clang::Preprocessor&, clang::ASTContext*, char const*, bool, bool)"},
    {"_ZN5clang9ASTReaderC2ERNS_12PreprocessorEPNS_10ASTContextEPKcbb", "clang::ASTReader::ASTReader(clang::Preprocessor&, clang::ASTContext*, char const*, bool, bool)"},
    {"_ZN5clang9ASTReaderC1ERNS_13SourceManagerERNS_11FileManagerERNS_10DiagnosticEPKcbb", "clang::ASTReader::ASTReader(clang::SourceManager&, clang::FileManager&, clang::Diagnostic&, char const*, bool, bool)"},
    {"_ZN5clang9ASTReaderC2ERNS_13SourceManagerERNS_11FileManagerERNS_10DiagnosticEPKcbb", "clang::ASTReader::ASTReader(clang::SourceManager&, clang::FileManager&, clang::Diagnostic&, char const*, bool, bool)"},
    {"_ZThn8_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZN5clang9ASTReaderD0Ev", "clang::ASTReader::~ASTReader()"},
    {"_ZThn16_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn32_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn40_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn48_N5clang9ASTReaderD0Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZN5clang9ASTReaderD1Ev", "clang::ASTReader::~ASTReader()"},
    {"_ZThn8_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn16_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn32_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn40_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZThn48_N5clang9ASTReaderD1Ev", "non-virtual thunk to clang::ASTReader::~ASTReader()"},
    {"_ZN5clang9ASTReaderD2Ev", "clang::ASTReader::~ASTReader()"},
    {"_ZN5clang9ASTReader11PerFileDataD1Ev", "clang::ASTReader::PerFileData::~PerFileData()"},
    {"_ZN5clang9ASTReader11PerFileDataC2ENS0_11ASTFileTypeE", "clang::ASTReader::PerFileData::PerFileData(clang::ASTReader::ASTFileType)"},
    {"_ZN5clang9ASTReader11PerFileDataD2Ev", "clang::ASTReader::PerFileData::~PerFileData()"},
    {"_ZN12_GLOBAL__N_129ASTDeclContextNameLookupTrait7ReadKeyEPKhj", "(anonymous namespace)::ASTDeclContextNameLookupTrait::ReadKey(unsigned char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_112ASTStatCacheD1Ev", "(anonymous namespace)::ASTStatCache::~ASTStatCache()"},
    {"_ZN12_GLOBAL__N_112ASTStatCacheD0Ev", "(anonymous namespace)::ASTStatCache::~ASTStatCache()"},
    {"_ZN12_GLOBAL__N_112ASTStatCache7getStatEPKcR4statPi", "(anonymous namespace)::ASTStatCache::getStat(char const*, stat&, int*)"},
    {"_ZSt14set_differenceIPN4llvm9StringRefES2_St20back_insert_iteratorISt6vectorIS1_SaIS1_EEEET1_T_S9_T0_SA_S8_", "std::back_insert_iterator<std::vector<llvm::StringRef, std::allocator<llvm::StringRef> > > std::set_difference<llvm::StringRef*, llvm::StringRef*, std::back_insert_iterator<std::vector<llvm::StringRef, std::allocator<llvm::StringRef> > > >(llvm::StringRef*, llvm::StringRef*, llvm::StringRef*, llvm::StringRef*, std::back_insert_iterator<std::vector<llvm::StringRef, std::allocator<llvm::StringRef> > >)"},
    {"_ZN4llvm15BitstreamCursor10ReadRecordEjRNS_15SmallVectorImplIyEEPPKcPj", "llvm::BitstreamCursor::ReadRecord(unsigned int, llvm::SmallVectorImpl<unsigned long long>&, char const**, unsigned int*)"},
    {"_ZNSt6vectorIN5clang9LineEntryESaIS1_EE7reserveEm", "std::vector<clang::LineEntry, std::allocator<clang::LineEntry> >::reserve(unsigned long)"},
    {"_ZN4llvm15BitstreamCursoraSERKS0_", "llvm::BitstreamCursor::operator=(llvm::BitstreamCursor const&)"},
    {"_ZN4llvm15BitstreamCursor9SkipBlockEv", "llvm::BitstreamCursor::SkipBlock()"},
    {"_ZN4llvm15BitstreamCursor13EnterSubBlockEjPj", "llvm::BitstreamCursor::EnterSubBlock(unsigned int, unsigned int*)"},
    {"_ZN4llvm15BitstreamCursor14ReadSubBlockIDEv", "llvm::BitstreamCursor::ReadSubBlockID()"},
    {"_ZN4llvm15BitstreamCursor16ReadAbbrevRecordEv", "llvm::BitstreamCursor::ReadAbbrevRecord()"},
    {"_ZN4llvm15SmallVectorImplIyE4swapERS1_", "llvm::SmallVectorImpl<unsigned long long>::swap(llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN4llvm15SmallVectorImplIyE6insertIPyEES3_S3_T_S4_", "unsigned long long* llvm::SmallVectorImpl<unsigned long long>::insert<unsigned long long*>(unsigned long long*, unsigned long long*, unsigned long long*)"},
    {"_ZN4llvm15SmallVectorImplIPN5clang15MacroDefinitionEE6resizeEj", "llvm::SmallVectorImpl<clang::MacroDefinition*>::resize(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIN5clang8SelectorEE6resizeEj", "llvm::SmallVectorImpl<clang::Selector>::resize(unsigned int)"},
    {"_ZN5clang22OnDiskChainedHashTableINS_24ASTIdentifierLookupTraitEE4findERKSt4pairIPKcjEPS1_", "clang::OnDiskChainedHashTable<clang::ASTIdentifierLookupTrait>::find(std::pair<char const*, unsigned int> const&, clang::ASTIdentifierLookupTrait*)"},
    {"_ZN4llvm15BitstreamCursor4ReadEj", "llvm::BitstreamCursor::Read(unsigned int)"},
    {"_ZN4llvm15BitstreamCursor18ReadBlockInfoBlockEv", "llvm::BitstreamCursor::ReadBlockInfoBlock()"},
    {"_ZN4llvm15SmallVectorImplIN5clang9ASTReader15DeclContextInfoEE4swapERS4_", "llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>::swap(llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>&)"},
    {"_ZN5clang14TypeLocVisitorINS_13TypeLocReaderEvE5VisitENS_7TypeLocE", "clang::TypeLocVisitor<clang::TypeLocReader, void>::Visit(clang::TypeLoc)"},
    {"_ZN5clang13serialization10MakeTypeIDISt9binder1stISt16const_mem_fun1_tINS0_7TypeIdxENS_9ASTReaderENS_8QualTypeEEEEEjS6_T_", "unsigned int clang::serialization::MakeTypeID<std::binder1st<std::const_mem_fun1_t<clang::serialization::TypeIdx, clang::ASTReader, clang::QualType> > >(clang::QualType, std::binder1st<std::const_mem_fun1_t<clang::serialization::TypeIdx, clang::ASTReader, clang::QualType> >)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorENS1_14SourceLocationENS_12DenseMapInfoIS2_EENS4_IS3_EEE6insertERKSt4pairIS2_S3_E", "llvm::DenseMap<clang::Selector, clang::SourceLocation, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<clang::SourceLocation> >::insert(std::pair<clang::Selector, clang::SourceLocation> const&)"},
    {"_ZNSt5dequeISt4pairIPN5clang9ValueDeclENS1_14SourceLocationEESaIS5_EE9push_backERKS5_", "std::deque<std::pair<clang::ValueDecl*, clang::SourceLocation>, std::allocator<std::pair<clang::ValueDecl*, clang::SourceLocation> > >::push_back(std::pair<clang::ValueDecl*, clang::SourceLocation> const&)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoENS1_4Sema8WeakInfoENS_12DenseMapInfoIS3_EENS6_IS5_EEE6insertERKSt4pairIS3_S5_E", "llvm::DenseMap<clang::IdentifierInfo*, clang::Sema::WeakInfo, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::Sema::WeakInfo> >::insert(std::pair<clang::IdentifierInfo*, clang::Sema::WeakInfo> const&)"},
    {"_ZN5clang17ASTReaderListener19ReadLanguageOptionsERKNS_11LangOptionsE", "clang::ASTReaderListener::ReadLanguageOptions(clang::LangOptions const&)"},
    {"_ZN5clang17ASTReaderListener16ReadTargetTripleEN4llvm9StringRefE", "clang::ASTReaderListener::ReadTargetTriple(llvm::StringRef)"},
    {"_ZN5clang17ASTReaderListener20ReadPredefinesBufferERKN4llvm11SmallVectorINS_18PCHPredefinesBlockELj2EEENS1_9StringRefERSs", "clang::ASTReaderListener::ReadPredefinesBuffer(llvm::SmallVector<clang::PCHPredefinesBlock, 2u> const&, llvm::StringRef, std::string&)"},
    {"_ZN5clang17ASTReaderListener18ReadHeaderFileInfoERKNS_14HeaderFileInfoEj", "clang::ASTReaderListener::ReadHeaderFileInfo(clang::HeaderFileInfo const&, unsigned int)"},
    {"_ZN5clang17ASTReaderListener11ReadCounterEj", "clang::ASTReaderListener::ReadCounter(unsigned int)"},
    {"_ZN5clang12PCHValidatorD1Ev", "clang::PCHValidator::~PCHValidator()"},
    {"_ZN5clang12PCHValidatorD0Ev", "clang::PCHValidator::~PCHValidator()"},
    {"_ZN5clang9ASTReader20StartedDeserializingEv", "clang::ASTReader::StartedDeserializing()"},
    {"_ZN5clang9ASTReader10ForgetSemaEv", "clang::ASTReader::ForgetSema()"},
    {"_ZN5clang9ASTReader3getEN4llvm9StringRefE", "clang::ASTReader::get(llvm::StringRef)"},
    {"_ZN5clang9ASTReader13GetIdentifierEj", "clang::ASTReader::GetIdentifier(unsigned int)"},
    {"_ZThn16_N5clang9ASTReader20StartedDeserializingEv", "non-virtual thunk to clang::ASTReader::StartedDeserializing()"},
    {"_ZThn16_N5clang9ASTReader10ForgetSemaEv", "non-virtual thunk to clang::ASTReader::ForgetSema()"},
    {"_ZThn32_N5clang9ASTReader3getEN4llvm9StringRefE", "non-virtual thunk to clang::ASTReader::get(llvm::StringRef)"},
    {"_ZThn40_N5clang9ASTReader13GetIdentifierEj", "non-virtual thunk to clang::ASTReader::GetIdentifier(unsigned int)"},
    {"_ZN5clang21ASTIdentifierIteratorD1Ev", "clang::ASTIdentifierIterator::~ASTIdentifierIterator()"},
    {"_ZN5clang21ASTIdentifierIteratorD0Ev", "clang::ASTIdentifierIterator::~ASTIdentifierIterator()"},
    {"_ZNSt5dequeIN5clang9ASTReader21PendingIdentifierInfoESaIS2_EED2Ev", "std::deque<clang::ASTReader::PendingIdentifierInfo, std::allocator<clang::ASTReader::PendingIdentifierInfo> >::~deque()"},
    {"_ZNSt5dequeIN5clang9ASTReader21PendingIdentifierInfoESaIS2_EE19_M_destroy_data_auxESt15_Deque_iteratorIS2_RS2_PS2_ES8_", "std::deque<clang::ASTReader::PendingIdentifierInfo, std::allocator<clang::ASTReader::PendingIdentifierInfo> >::_M_destroy_data_aux(std::_Deque_iterator<clang::ASTReader::PendingIdentifierInfo, clang::ASTReader::PendingIdentifierInfo&, clang::ASTReader::PendingIdentifierInfo*>, std::_Deque_iterator<clang::ASTReader::PendingIdentifierInfo, clang::ASTReader::PendingIdentifierInfo&, clang::ASTReader::PendingIdentifierInfo*>)"},
    {"_ZNSt11_Deque_baseIPN5clang4DeclESaIS2_EE17_M_initialize_mapEm", "std::_Deque_base<clang::Decl*, std::allocator<clang::Decl*> >::_M_initialize_map(unsigned long)"},
    {"_ZNSt11_Deque_baseIN5clang9ASTReader21PendingIdentifierInfoESaIS2_EE17_M_initialize_mapEm", "std::_Deque_base<clang::ASTReader::PendingIdentifierInfo, std::allocator<clang::ASTReader::PendingIdentifierInfo> >::_M_initialize_map(unsigned long)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang13AddrLabelExprEESt10_Select1stIS5_ESt4lessIjESaIS5_EE5eraseESt17_Rb_tree_iteratorIS5_ESD_", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::AddrLabelExpr*>, std::_Select1st<std::pair<unsigned int const, clang::AddrLabelExpr*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::AddrLabelExpr*> > >::erase(std::_Rb_tree_iterator<std::pair<unsigned int const, clang::AddrLabelExpr*> >, std::_Rb_tree_iterator<std::pair<unsigned int const, clang::AddrLabelExpr*> >)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang13AddrLabelExprEESt10_Select1stIS5_ESt4lessIjESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::AddrLabelExpr*>, std::_Select1st<std::pair<unsigned int const, clang::AddrLabelExpr*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::AddrLabelExpr*> > >::_M_erase(std::_Rb_tree_node<std::pair<unsigned int const, clang::AddrLabelExpr*> >*)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang8GotoStmtEESt10_Select1stIS5_ESt4lessIjESaIS5_EE5eraseESt17_Rb_tree_iteratorIS5_ESD_", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::GotoStmt*>, std::_Select1st<std::pair<unsigned int const, clang::GotoStmt*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::GotoStmt*> > >::erase(std::_Rb_tree_iterator<std::pair<unsigned int const, clang::GotoStmt*> >, std::_Rb_tree_iterator<std::pair<unsigned int const, clang::GotoStmt*> >)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang8GotoStmtEESt10_Select1stIS5_ESt4lessIjESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::GotoStmt*>, std::_Select1st<std::pair<unsigned int const, clang::GotoStmt*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::GotoStmt*> > >::_M_erase(std::_Rb_tree_node<std::pair<unsigned int const, clang::GotoStmt*> >*)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang9LabelStmtEESt10_Select1stIS5_ESt4lessIjESaIS5_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS5_ERKS5_", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::LabelStmt*>, std::_Select1st<std::pair<unsigned int const, clang::LabelStmt*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::LabelStmt*> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<unsigned int const, clang::LabelStmt*> >, std::pair<unsigned int const, clang::LabelStmt*> const&)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang9LabelStmtEESt10_Select1stIS5_ESt4lessIjESaIS5_EE16_M_insert_uniqueERKS5_", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::LabelStmt*>, std::_Select1st<std::pair<unsigned int const, clang::LabelStmt*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::LabelStmt*> > >::_M_insert_unique(std::pair<unsigned int const, clang::LabelStmt*> const&)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang10SwitchCaseEESt10_Select1stIS5_ESt4lessIjESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::SwitchCase*>, std::_Select1st<std::pair<unsigned int const, clang::SwitchCase*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::SwitchCase*> > >::_M_erase(std::_Rb_tree_node<std::pair<unsigned int const, clang::SwitchCase*> >*)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang10SwitchCaseEESt10_Select1stIS5_ESt4lessIjESaIS5_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS5_ERKS5_", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::SwitchCase*>, std::_Select1st<std::pair<unsigned int const, clang::SwitchCase*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::SwitchCase*> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<unsigned int const, clang::SwitchCase*> >, std::pair<unsigned int const, clang::SwitchCase*> const&)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang10SwitchCaseEESt10_Select1stIS5_ESt4lessIjESaIS5_EE16_M_insert_uniqueERKS5_", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::SwitchCase*>, std::_Select1st<std::pair<unsigned int const, clang::SwitchCase*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::SwitchCase*> > >::_M_insert_unique(std::pair<unsigned int const, clang::SwitchCase*> const&)"},
    {"_ZNSt5dequeIN5clang9ASTReader21PendingIdentifierInfoESaIS2_EE16_M_push_back_auxERKS2_", "std::deque<clang::ASTReader::PendingIdentifierInfo, std::allocator<clang::ASTReader::PendingIdentifierInfo> >::_M_push_back_aux(clang::ASTReader::PendingIdentifierInfo const&)"},
    {"_ZNSt5dequeIN5clang9ASTReader21PendingIdentifierInfoESaIS2_EE17_M_reallocate_mapEmb", "std::deque<clang::ASTReader::PendingIdentifierInfo, std::allocator<clang::ASTReader::PendingIdentifierInfo> >::_M_reallocate_map(unsigned long, bool)"},
    {"_ZN4llvm8DenseMapIPN5clang13CXXRecordDeclEbNS_12DenseMapInfoIS3_EENS4_IbEEE16InsertIntoBucketERKS3_RKbPSt4pairIS3_bE", "llvm::DenseMap<clang::CXXRecordDecl*, bool, llvm::DenseMapInfo<clang::CXXRecordDecl*>, llvm::DenseMapInfo<bool> >::InsertIntoBucket(clang::CXXRecordDecl* const&, bool const&, std::pair<clang::CXXRecordDecl*, bool>*)"},
    {"_ZN4llvm8DenseMapIPN5clang13CXXRecordDeclEbNS_12DenseMapInfoIS3_EENS4_IbEEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl*, bool, llvm::DenseMapInfo<clang::CXXRecordDecl*>, llvm::DenseMapInfo<bool> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoENS1_4Sema8WeakInfoENS_12DenseMapInfoIS3_EENS6_IS5_EEE16InsertIntoBucketERKS3_RKS5_PSt4pairIS3_S5_E", "llvm::DenseMap<clang::IdentifierInfo*, clang::Sema::WeakInfo, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::Sema::WeakInfo> >::InsertIntoBucket(clang::IdentifierInfo* const&, clang::Sema::WeakInfo const&, std::pair<clang::IdentifierInfo*, clang::Sema::WeakInfo>*)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoENS1_4Sema8WeakInfoENS_12DenseMapInfoIS3_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::IdentifierInfo*, clang::Sema::WeakInfo, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::Sema::WeakInfo> >::grow(unsigned int)"},
    {"_ZNSt5dequeISt4pairIPN5clang9ValueDeclENS1_14SourceLocationEESaIS5_EE17_M_reallocate_mapEmb", "std::deque<std::pair<clang::ValueDecl*, clang::SourceLocation>, std::allocator<std::pair<clang::ValueDecl*, clang::SourceLocation> > >::_M_reallocate_map(unsigned long, bool)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorENS1_14SourceLocationENS_12DenseMapInfoIS2_EENS4_IS3_EEE16InsertIntoBucketERKS2_RKS3_PSt4pairIS2_S3_E", "llvm::DenseMap<clang::Selector, clang::SourceLocation, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<clang::SourceLocation> >::InsertIntoBucket(clang::Selector const&, clang::SourceLocation const&, std::pair<clang::Selector, clang::SourceLocation>*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorENS1_14SourceLocationENS_12DenseMapInfoIS2_EENS4_IS3_EEE4growEj", "llvm::DenseMap<clang::Selector, clang::SourceLocation, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<clang::SourceLocation> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIN5clang15DeclarationNameEPNS1_9NamedDeclENS_12DenseMapInfoIS2_EENS5_IS4_EEE16InsertIntoBucketERKS2_RKS4_PSt4pairIS2_S4_E", "llvm::DenseMap<clang::DeclarationName, clang::NamedDecl*, llvm::DenseMapInfo<clang::DeclarationName>, llvm::DenseMapInfo<clang::NamedDecl*> >::InsertIntoBucket(clang::DeclarationName const&, clang::NamedDecl* const&, std::pair<clang::DeclarationName, clang::NamedDecl*>*)"},
    {"_ZN4llvm8DenseMapIN5clang15DeclarationNameEPNS1_9NamedDeclENS_12DenseMapInfoIS2_EENS5_IS4_EEE4growEj", "llvm::DenseMap<clang::DeclarationName, clang::NamedDecl*, llvm::DenseMapInfo<clang::DeclarationName>, llvm::DenseMapInfo<clang::NamedDecl*> >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIN5clang9ASTReader15DeclContextInfoEEaSERKS4_", "llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>::operator=(llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo> const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang9ASTReader15DeclContextInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ASTReader::DeclContextInfo, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIN5clang8QualTypeENS1_13serialization7TypeIdxENS3_26UnsafeQualTypeDenseMapInfoENS_12DenseMapInfoIS4_EEE16InsertIntoBucketERKS2_RKS4_PSt4pairIS2_S4_E", "llvm::DenseMap<clang::QualType, clang::serialization::TypeIdx, clang::serialization::UnsafeQualTypeDenseMapInfo, llvm::DenseMapInfo<clang::serialization::TypeIdx> >::InsertIntoBucket(clang::QualType const&, clang::serialization::TypeIdx const&, std::pair<clang::QualType, clang::serialization::TypeIdx>*)"},
    {"_ZN4llvm8DenseMapIN5clang8QualTypeENS1_13serialization7TypeIdxENS3_26UnsafeQualTypeDenseMapInfoENS_12DenseMapInfoIS4_EEE4growEj", "llvm::DenseMap<clang::QualType, clang::serialization::TypeIdx, clang::serialization::UnsafeQualTypeDenseMapInfo, llvm::DenseMapInfo<clang::serialization::TypeIdx> >::grow(unsigned int)"},
    {"_ZN5clang24ASTIdentifierLookupTrait8ReadDataERKSt4pairIPKcjEPKhj", "clang::ASTIdentifierLookupTrait::ReadData(std::pair<char const*, unsigned int> const&, unsigned char const*, unsigned int)"},
    {"_ZNSt6vectorIPN5clang4DeclESaIS2_EE14_M_fill_insertEN9__gnu_cxx17__normal_iteratorIPS2_S4_EEmRKS2_", "std::vector<clang::Decl*, std::allocator<clang::Decl*> >::_M_fill_insert(__gnu_cxx::__normal_iterator<clang::Decl**, std::vector<clang::Decl*, std::allocator<clang::Decl*> > >, unsigned long, clang::Decl* const&)"},
    {"_ZNSt6vectorIN5clang8QualTypeESaIS1_EE14_M_fill_insertEN9__gnu_cxx17__normal_iteratorIPS1_S3_EEmRKS1_", "std::vector<clang::QualType, std::allocator<clang::QualType> >::_M_fill_insert(__gnu_cxx::__normal_iterator<clang::QualType*, std::vector<clang::QualType, std::allocator<clang::QualType> > >, unsigned long, clang::QualType const&)"},
    {"_ZNSt6vectorIPN5clang14IdentifierInfoESaIS2_EE14_M_fill_insertEN9__gnu_cxx17__normal_iteratorIPS2_S4_EEmRKS2_", "std::vector<clang::IdentifierInfo*, std::allocator<clang::IdentifierInfo*> >::_M_fill_insert(__gnu_cxx::__normal_iterator<clang::IdentifierInfo**, std::vector<clang::IdentifierInfo*, std::allocator<clang::IdentifierInfo*> > >, unsigned long, clang::IdentifierInfo* const&)"},
    {"_ZN4llvm8DenseMapIjSt4pairIPN5clang9ASTReader11PerFileDataEyENS_12DenseMapInfoIjEENS7_IS6_EEE16InsertIntoBucketERKjRKS6_PS1_IjS6_E", "llvm::DenseMap<unsigned int, std::pair<clang::ASTReader::PerFileData*, unsigned long long>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<std::pair<clang::ASTReader::PerFileData*, unsigned long long> > >::InsertIntoBucket(unsigned int const&, std::pair<clang::ASTReader::PerFileData*, unsigned long long> const&, std::pair<unsigned int, std::pair<clang::ASTReader::PerFileData*, unsigned long long> >*)"},
    {"_ZN4llvm8DenseMapIjSt4pairIPN5clang9ASTReader11PerFileDataEyENS_12DenseMapInfoIjEENS7_IS6_EEE4growEj", "llvm::DenseMap<unsigned int, std::pair<clang::ASTReader::PerFileData*, unsigned long long>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<std::pair<clang::ASTReader::PerFileData*, unsigned long long> > >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIjNS_11SmallVectorISt4pairIPN5clang9ASTReader11PerFileDataEyELj2EEENS_12DenseMapInfoIjEENS9_IS8_EEE16FindAndConstructERKj", "llvm::DenseMap<unsigned int, llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u> > >::FindAndConstruct(unsigned int const&)"},
    {"_ZN4llvm8DenseMapIjNS_11SmallVectorISt4pairIPN5clang9ASTReader11PerFileDataEyELj2EEENS_12DenseMapInfoIjEENS9_IS8_EEE16InsertIntoBucketERKjRKS8_PS2_IjS8_E", "llvm::DenseMap<unsigned int, llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u> > >::InsertIntoBucket(unsigned int const&, llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u> const&, std::pair<unsigned int, llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u> >*)"},
    {"_ZN4llvm8DenseMapIjNS_11SmallVectorISt4pairIPN5clang9ASTReader11PerFileDataEyELj2EEENS_12DenseMapInfoIjEENS9_IS8_EEE4growEj", "llvm::DenseMap<unsigned int, llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<clang::ASTReader::PerFileData*, unsigned long long>, 2u> > >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplISt4pairIPN5clang9ASTReader11PerFileDataEyEEaSERKS7_", "llvm::SmallVectorImpl<std::pair<clang::ASTReader::PerFileData*, unsigned long long> >::operator=(llvm::SmallVectorImpl<std::pair<clang::ASTReader::PerFileData*, unsigned long long> > const&)"},
    {"_ZN4llvm8DenseMapIjNS_11SmallVectorIPvLj1EEENS_12DenseMapInfoIjEENS4_IS3_EEE16FindAndConstructERKj", "llvm::DenseMap<unsigned int, llvm::SmallVector<void*, 1u>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<llvm::SmallVector<void*, 1u> > >::FindAndConstruct(unsigned int const&)"},
    {"_ZN4llvm8DenseMapIjNS_11SmallVectorIPvLj1EEENS_12DenseMapInfoIjEENS4_IS3_EEE16InsertIntoBucketERKjRKS3_PSt4pairIjS3_E", "llvm::DenseMap<unsigned int, llvm::SmallVector<void*, 1u>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<llvm::SmallVector<void*, 1u> > >::InsertIntoBucket(unsigned int const&, llvm::SmallVector<void*, 1u> const&, std::pair<unsigned int, llvm::SmallVector<void*, 1u> >*)"},
    {"_ZN4llvm8DenseMapIjNS_11SmallVectorIPvLj1EEENS_12DenseMapInfoIjEENS4_IS3_EEE4growEj", "llvm::DenseMap<unsigned int, llvm::SmallVector<void*, 1u>, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<llvm::SmallVector<void*, 1u> > >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIPvEaSERKS2_", "llvm::SmallVectorImpl<void*>::operator=(llvm::SmallVectorImpl<void*> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang11DeclContextENS_11SmallVectorINS1_9ASTReader15DeclContextInfoELj1EEENS_12DenseMapInfoIS4_EENS9_IS8_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::DeclContext const*, llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u>, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u> > >::FindAndConstruct(clang::DeclContext const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang11DeclContextENS_11SmallVectorINS1_9ASTReader15DeclContextInfoELj1EEENS_12DenseMapInfoIS4_EENS9_IS8_EEE16InsertIntoBucketERKS4_RKS8_PSt4pairIS4_S8_E", "llvm::DenseMap<clang::DeclContext const*, llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u>, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u> > >::InsertIntoBucket(clang::DeclContext const* const&, llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u> const&, std::pair<clang::DeclContext const*, llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang11DeclContextENS_11SmallVectorINS1_9ASTReader15DeclContextInfoELj1EEENS_12DenseMapInfoIS4_EENS9_IS8_EEE4growEj", "llvm::DenseMap<clang::DeclContext const*, llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u>, llvm::DenseMapInfo<clang::DeclContext const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ASTReader::DeclContextInfo, 1u> > >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEyNS_12DenseMapInfoIS3_EENS4_IyEEE16InsertIntoBucketERKS3_RKyPSt4pairIS3_yE", "llvm::DenseMap<clang::IdentifierInfo*, unsigned long long, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<unsigned long long> >::InsertIntoBucket(clang::IdentifierInfo* const&, unsigned long long const&, std::pair<clang::IdentifierInfo*, unsigned long long>*)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEyNS_12DenseMapInfoIS3_EENS4_IyEEE4growEj", "llvm::DenseMap<clang::IdentifierInfo*, unsigned long long, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<unsigned long long> >::grow(unsigned int)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang18PCHPredefinesBlockELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::PCHPredefinesBlock, false>::grow(unsigned long)"},
    {"_ZNSt8_Rb_treeIiSt4pairIKiiESt10_Select1stIS2_ESt4lessIiESaIS2_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS2_ERKS2_", "std::_Rb_tree<int, std::pair<int const, int>, std::_Select1st<std::pair<int const, int> >, std::less<int>, std::allocator<std::pair<int const, int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<int const, int> >, std::pair<int const, int> const&)"},
    {"_ZNSt8_Rb_treeIiSt4pairIKiiESt10_Select1stIS2_ESt4lessIiESaIS2_EE16_M_insert_uniqueERKS2_", "std::_Rb_tree<int, std::pair<int const, int>, std::_Select1st<std::pair<int const, int> >, std::less<int>, std::allocator<std::pair<int const, int> > >::_M_insert_unique(std::pair<int const, int> const&)"},
    {"_ZSt16__introsort_loopIPN4llvm9StringRefElEvT_S3_T0_", "void std::__introsort_loop<llvm::StringRef*, long>(llvm::StringRef*, llvm::StringRef*, long)"},
    {"_ZSt22__final_insertion_sortIPN4llvm9StringRefEEvT_S3_", "void std::__final_insertion_sort<llvm::StringRef*>(llvm::StringRef*, llvm::StringRef*)"},
    {"_ZSt16__insertion_sortIPN4llvm9StringRefEEvT_S3_", "void std::__insertion_sort<llvm::StringRef*>(llvm::StringRef*, llvm::StringRef*)"},
    {"_ZSt21__unguarded_partitionIPN4llvm9StringRefES1_ET_S3_S3_T0_", "llvm::StringRef* std::__unguarded_partition<llvm::StringRef*, llvm::StringRef>(llvm::StringRef*, llvm::StringRef*, llvm::StringRef)"},
    {"_ZSt8__medianIN4llvm9StringRefEERKT_S4_S4_S4_", "llvm::StringRef const& std::__median<llvm::StringRef>(llvm::StringRef const&, llvm::StringRef const&, llvm::StringRef const&)"},
    {"_ZSt13__heap_selectIPN4llvm9StringRefEEvT_S3_S3_", "void std::__heap_select<llvm::StringRef*>(llvm::StringRef*, llvm::StringRef*, llvm::StringRef*)"},
    {"_ZSt13__adjust_heapIPN4llvm9StringRefElS1_EvT_T0_S4_T1_", "void std::__adjust_heap<llvm::StringRef*, long, llvm::StringRef>(llvm::StringRef*, long, long, llvm::StringRef)"},
    {"_ZN4llvm15SmallVectorImplIN5clang18PCHPredefinesBlockEEaSERKS3_", "llvm::SmallVectorImpl<clang::PCHPredefinesBlock>::operator=(llvm::SmallVectorImpl<clang::PCHPredefinesBlock> const&)"},
    {"_ZN4llvm15SmallVectorImplINS_9StringRefEEaSERKS2_", "llvm::SmallVectorImpl<llvm::StringRef>::operator=(llvm::SmallVectorImpl<llvm::StringRef> const&)"},
    {"_ZNSt8_Rb_treeIjSt4pairIKjPN5clang9LabelStmtEESt10_Select1stIS5_ESt4lessIjESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<unsigned int, std::pair<unsigned int const, clang::LabelStmt*>, std::_Select1st<std::pair<unsigned int const, clang::LabelStmt*> >, std::less<unsigned int>, std::allocator<std::pair<unsigned int const, clang::LabelStmt*> > >::_M_erase(std::_Rb_tree_node<std::pair<unsigned int const, clang::LabelStmt*> >*)"},
    {"_ZN5clang18ExternalSemaSource14InitializeSemaERNS_4SemaE", "clang::ExternalSemaSource::InitializeSema(clang::Sema&)"},
    {"_ZN5clang18ExternalSemaSource10ForgetSemaEv", "clang::ExternalSemaSource::ForgetSema()"},
    {"_ZN4llvm15BitstreamReaderD2Ev", "llvm::BitstreamReader::~BitstreamReader()"},
    {"_ZN4llvm15BitstreamReader9BlockInfoD2Ev", "llvm::BitstreamReader::BlockInfo::~BlockInfo()"},
    {"_ZN4llvm15BitstreamReader20getOrCreateBlockInfoEj", "llvm::BitstreamReader::getOrCreateBlockInfo(unsigned int)"},
    {"_ZNSt6vectorISt4pairIjSsESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<std::pair<unsigned int, std::string>, std::allocator<std::pair<unsigned int, std::string> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<unsigned int, std::string>*, std::vector<std::pair<unsigned int, std::string>, std::allocator<std::pair<unsigned int, std::string> > > >, std::pair<unsigned int, std::string> const&)"},
    {"_ZN9__gnu_cxx13new_allocatorIN4llvm15BitstreamReader9BlockInfoEE9constructEPS3_RKS3_", "__gnu_cxx::new_allocator<llvm::BitstreamReader::BlockInfo>::construct(llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo const&)"},
    {"_ZNSt6vectorIN4llvm15BitstreamReader9BlockInfoESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<llvm::BitstreamReader::BlockInfo, std::allocator<llvm::BitstreamReader::BlockInfo> >::_M_insert_aux(__gnu_cxx::__normal_iterator<llvm::BitstreamReader::BlockInfo*, std::vector<llvm::BitstreamReader::BlockInfo, std::allocator<llvm::BitstreamReader::BlockInfo> > >, llvm::BitstreamReader::BlockInfo const&)"},
    {"_ZSt24__uninitialized_copy_auxIPN4llvm15BitstreamReader9BlockInfoES3_ET0_T_S5_S4_St12__false_type", "llvm::BitstreamReader::BlockInfo* std::__uninitialized_copy_aux<llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo*>(llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo*, llvm::BitstreamReader::BlockInfo*, std::__false_type)"},
    {"_ZNSt6vectorIPN4llvm13BitCodeAbbrevESaIS2_EEaSERKS4_", "std::vector<llvm::BitCodeAbbrev*, std::allocator<llvm::BitCodeAbbrev*> >::operator=(std::vector<llvm::BitCodeAbbrev*, std::allocator<llvm::BitCodeAbbrev*> > const&)"},
    {"_ZNSt6vectorISt4pairIjSsESaIS1_EEaSERKS3_", "std::vector<std::pair<unsigned int, std::string>, std::allocator<std::pair<unsigned int, std::string> > >::operator=(std::vector<std::pair<unsigned int, std::string>, std::allocator<std::pair<unsigned int, std::string> > > const&)"},
    {"_ZNSt6vectorISt4pairIjSsESaIS1_EEC2ERKS3_", "std::vector<std::pair<unsigned int, std::string>, std::allocator<std::pair<unsigned int, std::string> > >::vector(std::vector<std::pair<unsigned int, std::string>, std::allocator<std::pair<unsigned int, std::string> > > const&)"},
    {"_ZNSt6vectorIPN4llvm13BitCodeAbbrevESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<llvm::BitCodeAbbrev*, std::allocator<llvm::BitCodeAbbrev*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<llvm::BitCodeAbbrev**, std::vector<llvm::BitCodeAbbrev*, std::allocator<llvm::BitCodeAbbrev*> > >, llvm::BitCodeAbbrev* const&)"},
    {"_ZN4llvm15BitstreamCursor9freeStateEv", "llvm::BitstreamCursor::freeState()"},
    {"_ZN5clang19FileSystemStatCacheD1Ev", "clang::FileSystemStatCache::~FileSystemStatCache()"},
    {"_ZN5clang19FileSystemStatCacheD0Ev", "clang::FileSystemStatCache::~FileSystemStatCache()"},
    {"_ZN4llvm15BitstreamCursorD2Ev", "llvm::BitstreamCursor::~BitstreamCursor()"},
    {"_ZN4llvm23SmallVectorTemplateBaseINS_15BitCodeAbbrevOpELb0EE4growEm", "llvm::SmallVectorTemplateBase<llvm::BitCodeAbbrevOp, false>::grow(unsigned long)"},
    {"_ZN4llvm15BitstreamCursor13PopBlockScopeEv", "llvm::BitstreamCursor::PopBlockScope()"},
    {"_ZN4llvm15SmallVectorImplINS_15BitstreamCursor5BlockEE9push_backERKS2_", "llvm::SmallVectorImpl<llvm::BitstreamCursor::Block>::push_back(llvm::BitstreamCursor::Block const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseINS_15BitstreamCursor5BlockELb0EE4growEm", "llvm::SmallVectorTemplateBase<llvm::BitstreamCursor::Block, false>::grow(unsigned long)"},
    {"_ZN4llvm23SmallVectorTemplateBaseINS_15BitstreamCursor5BlockELb0EE18uninitialized_copyIPS2_S5_EEvT_S6_T0_", "void llvm::SmallVectorTemplateBase<llvm::BitstreamCursor::Block, false>::uninitialized_copy<llvm::BitstreamCursor::Block*, llvm::BitstreamCursor::Block*>(llvm::BitstreamCursor::Block*, llvm::BitstreamCursor::Block*, llvm::BitstreamCursor::Block*)"},
    {"_ZNSt8_Rb_treeIiSt4pairIKiiESt10_Select1stIS2_ESt4lessIiESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E", "std::_Rb_tree<int, std::pair<int const, int>, std::_Select1st<std::pair<int const, int> >, std::less<int>, std::allocator<std::pair<int const, int> > >::_M_erase(std::_Rb_tree_node<std::pair<int const, int> >*)"},
    {"_ZN4llvm15BitstreamCursor20ReadAbbreviatedFieldERKNS_15BitCodeAbbrevOpERNS_15SmallVectorImplIyEE", "llvm::BitstreamCursor::ReadAbbreviatedField(llvm::BitCodeAbbrevOp const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang13ASTDeclReader22GetCurrentCursorOffsetEv", "clang::ASTDeclReader::GetCurrentCursorOffset()"},
    {"_ZN5clang13ASTDeclReader5VisitEPNS_4DeclE", "clang::ASTDeclReader::Visit(clang::Decl*)"},
    {"_ZN5clang13ASTDeclReader9VisitDeclEPNS_4DeclE", "clang::ASTDeclReader::VisitDecl(clang::Decl*)"},
    {"_ZN5clang9ASTReader14ReadAttributesERNS0_11PerFileDataERN4llvm11SmallVectorIPNS_4AttrELj2EEERKNS4_IyLj64EEERj", "clang::ASTReader::ReadAttributes(clang::ASTReader::PerFileData&, llvm::SmallVector<clang::Attr*, 2u>&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang13ASTDeclReader24VisitTranslationUnitDeclEPNS_19TranslationUnitDeclE", "clang::ASTDeclReader::VisitTranslationUnitDecl(clang::TranslationUnitDecl*)"},
    {"_ZN5clang13ASTDeclReader14VisitNamedDeclEPNS_9NamedDeclE", "clang::ASTDeclReader::VisitNamedDecl(clang::NamedDecl*)"},
    {"_ZN5clang13ASTDeclReader13VisitTypeDeclEPNS_8TypeDeclE", "clang::ASTDeclReader::VisitTypeDecl(clang::TypeDecl*)"},
    {"_ZN5clang13ASTDeclReader16VisitTypedefDeclEPNS_11TypedefDeclE", "clang::ASTDeclReader::VisitTypedefDecl(clang::TypedefDecl*)"},
    {"_ZN5clang13ASTDeclReader12VisitTagDeclEPNS_7TagDeclE", "clang::ASTDeclReader::VisitTagDecl(clang::TagDecl*)"},
    {"_ZN5clang13ASTDeclReader13VisitEnumDeclEPNS_8EnumDeclE", "clang::ASTDeclReader::VisitEnumDecl(clang::EnumDecl*)"},
    {"_ZN5clang13ASTDeclReader15VisitRecordDeclEPNS_10RecordDeclE", "clang::ASTDeclReader::VisitRecordDecl(clang::RecordDecl*)"},
    {"_ZN5clang13ASTDeclReader14VisitValueDeclEPNS_9ValueDeclE", "clang::ASTDeclReader::VisitValueDecl(clang::ValueDecl*)"},
    {"_ZN5clang13ASTDeclReader21VisitEnumConstantDeclEPNS_16EnumConstantDeclE", "clang::ASTDeclReader::VisitEnumConstantDecl(clang::EnumConstantDecl*)"},
    {"_ZN5clang13ASTDeclReader19VisitDeclaratorDeclEPNS_14DeclaratorDeclE", "clang::ASTDeclReader::VisitDeclaratorDecl(clang::DeclaratorDecl*)"},
    {"_ZN5clang13ASTDeclReader17VisitFunctionDeclEPNS_12FunctionDeclE", "clang::ASTDeclReader::VisitFunctionDecl(clang::FunctionDecl*)"},
    {"_ZN5clang13ASTDeclReader19VisitObjCMethodDeclEPNS_14ObjCMethodDeclE", "clang::ASTDeclReader::VisitObjCMethodDecl(clang::ObjCMethodDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitObjCContainerDeclEPNS_17ObjCContainerDeclE", "clang::ASTDeclReader::VisitObjCContainerDecl(clang::ObjCContainerDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitObjCInterfaceDeclEPNS_17ObjCInterfaceDeclE", "clang::ASTDeclReader::VisitObjCInterfaceDecl(clang::ObjCInterfaceDecl*)"},
    {"_ZN5clang13ASTDeclReader17VisitObjCIvarDeclEPNS_12ObjCIvarDeclE", "clang::ASTDeclReader::VisitObjCIvarDecl(clang::ObjCIvarDecl*)"},
    {"_ZN5clang13ASTDeclReader14VisitFieldDeclEPNS_9FieldDeclE", "clang::ASTDeclReader::VisitFieldDecl(clang::FieldDecl*)"},
    {"_ZN5clang13ASTDeclReader21VisitObjCProtocolDeclEPNS_16ObjCProtocolDeclE", "clang::ASTDeclReader::VisitObjCProtocolDecl(clang::ObjCProtocolDecl*)"},
    {"_ZN5clang13ASTDeclReader24VisitObjCAtDefsFieldDeclEPNS_19ObjCAtDefsFieldDeclE", "clang::ASTDeclReader::VisitObjCAtDefsFieldDecl(clang::ObjCAtDefsFieldDecl*)"},
    {"_ZN5clang13ASTDeclReader18VisitObjCClassDeclEPNS_13ObjCClassDeclE", "clang::ASTDeclReader::VisitObjCClassDecl(clang::ObjCClassDecl*)"},
    {"_ZN5clang13ASTDeclReader28VisitObjCForwardProtocolDeclEPNS_23ObjCForwardProtocolDeclE", "clang::ASTDeclReader::VisitObjCForwardProtocolDecl(clang::ObjCForwardProtocolDecl*)"},
    {"_ZN5clang13ASTDeclReader21VisitObjCCategoryDeclEPNS_16ObjCCategoryDeclE", "clang::ASTDeclReader::VisitObjCCategoryDecl(clang::ObjCCategoryDecl*)"},
    {"_ZN5clang13ASTDeclReader28VisitObjCCompatibleAliasDeclEPNS_23ObjCCompatibleAliasDeclE", "clang::ASTDeclReader::VisitObjCCompatibleAliasDecl(clang::ObjCCompatibleAliasDecl*)"},
    {"_ZN5clang13ASTDeclReader21VisitObjCPropertyDeclEPNS_16ObjCPropertyDeclE", "clang::ASTDeclReader::VisitObjCPropertyDecl(clang::ObjCPropertyDecl*)"},
    {"_ZN5clang13ASTDeclReader17VisitObjCImplDeclEPNS_12ObjCImplDeclE", "clang::ASTDeclReader::VisitObjCImplDecl(clang::ObjCImplDecl*)"},
    {"_ZN5clang13ASTDeclReader25VisitObjCCategoryImplDeclEPNS_20ObjCCategoryImplDeclE", "clang::ASTDeclReader::VisitObjCCategoryImplDecl(clang::ObjCCategoryImplDecl*)"},
    {"_ZN5clang13ASTDeclReader27VisitObjCImplementationDeclEPNS_22ObjCImplementationDeclE", "clang::ASTDeclReader::VisitObjCImplementationDecl(clang::ObjCImplementationDecl*)"},
    {"_ZN5clang13ASTDeclReader25VisitObjCPropertyImplDeclEPNS_20ObjCPropertyImplDeclE", "clang::ASTDeclReader::VisitObjCPropertyImplDecl(clang::ObjCPropertyImplDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitIndirectFieldDeclEPNS_17IndirectFieldDeclE", "clang::ASTDeclReader::VisitIndirectFieldDecl(clang::IndirectFieldDecl*)"},
    {"_ZN5clang13ASTDeclReader12VisitVarDeclEPNS_7VarDeclE", "clang::ASTDeclReader::VisitVarDecl(clang::VarDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitImplicitParamDeclEPNS_17ImplicitParamDeclE", "clang::ASTDeclReader::VisitImplicitParamDecl(clang::ImplicitParamDecl*)"},
    {"_ZN5clang13ASTDeclReader16VisitParmVarDeclEPNS_11ParmVarDeclE", "clang::ASTDeclReader::VisitParmVarDecl(clang::ParmVarDecl*)"},
    {"_ZN5clang13ASTDeclReader21VisitFileScopeAsmDeclEPNS_16FileScopeAsmDeclE", "clang::ASTDeclReader::VisitFileScopeAsmDecl(clang::FileScopeAsmDecl*)"},
    {"_ZN5clang13ASTDeclReader14VisitBlockDeclEPNS_9BlockDeclE", "clang::ASTDeclReader::VisitBlockDecl(clang::BlockDecl*)"},
    {"_ZN5clang13ASTDeclReader20VisitLinkageSpecDeclEPNS_15LinkageSpecDeclE", "clang::ASTDeclReader::VisitLinkageSpecDecl(clang::LinkageSpecDecl*)"},
    {"_ZN5clang13ASTDeclReader18VisitNamespaceDeclEPNS_13NamespaceDeclE", "clang::ASTDeclReader::VisitNamespaceDecl(clang::NamespaceDecl*)"},
    {"_ZN5clang13ASTDeclReader23VisitNamespaceAliasDeclEPNS_18NamespaceAliasDeclE", "clang::ASTDeclReader::VisitNamespaceAliasDecl(clang::NamespaceAliasDecl*)"},
    {"_ZN5clang13ASTDeclReader14VisitUsingDeclEPNS_9UsingDeclE", "clang::ASTDeclReader::VisitUsingDecl(clang::UsingDecl*)"},
    {"_ZN5clang13ASTDeclReader20VisitUsingShadowDeclEPNS_15UsingShadowDeclE", "clang::ASTDeclReader::VisitUsingShadowDecl(clang::UsingShadowDecl*)"},
    {"_ZN5clang13ASTDeclReader23VisitUsingDirectiveDeclEPNS_18UsingDirectiveDeclE", "clang::ASTDeclReader::VisitUsingDirectiveDecl(clang::UsingDirectiveDecl*)"},
    {"_ZN5clang13ASTDeclReader29VisitUnresolvedUsingValueDeclEPNS_24UnresolvedUsingValueDeclE", "clang::ASTDeclReader::VisitUnresolvedUsingValueDecl(clang::UnresolvedUsingValueDecl*)"},
    {"_ZN5clang13ASTDeclReader32VisitUnresolvedUsingTypenameDeclEPNS_27UnresolvedUsingTypenameDeclE", "clang::ASTDeclReader::VisitUnresolvedUsingTypenameDecl(clang::UnresolvedUsingTypenameDecl*)"},
    {"_ZN5clang13ASTDeclReader21ReadCXXDefinitionDataERNS_13CXXRecordDecl14DefinitionDataERKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTDeclReader::ReadCXXDefinitionData(clang::CXXRecordDecl::DefinitionData&, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang13ASTDeclReader27InitializeCXXDefinitionDataEPNS_13CXXRecordDeclES2_RKN4llvm11SmallVectorIyLj64EEERj", "clang::ASTDeclReader::InitializeCXXDefinitionData(clang::CXXRecordDecl*, clang::CXXRecordDecl*, llvm::SmallVector<unsigned long long, 64u> const&, unsigned int&)"},
    {"_ZN5clang13ASTDeclReader18VisitCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::ASTDeclReader::VisitCXXRecordDecl(clang::CXXRecordDecl*)"},
    {"_ZN5clang13ASTDeclReader18VisitCXXMethodDeclEPNS_13CXXMethodDeclE", "clang::ASTDeclReader::VisitCXXMethodDecl(clang::CXXMethodDecl*)"},
    {"_ZN5clang13ASTDeclReader23VisitCXXConstructorDeclEPNS_18CXXConstructorDeclE", "clang::ASTDeclReader::VisitCXXConstructorDecl(clang::CXXConstructorDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitCXXDestructorDeclEPNS_17CXXDestructorDeclE", "clang::ASTDeclReader::VisitCXXDestructorDecl(clang::CXXDestructorDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitCXXConversionDeclEPNS_17CXXConversionDeclE", "clang::ASTDeclReader::VisitCXXConversionDecl(clang::CXXConversionDecl*)"},
    {"_ZN5clang13ASTDeclReader19VisitAccessSpecDeclEPNS_14AccessSpecDeclE", "clang::ASTDeclReader::VisitAccessSpecDecl(clang::AccessSpecDecl*)"},
    {"_ZN5clang13ASTDeclReader15VisitFriendDeclEPNS_10FriendDeclE", "clang::ASTDeclReader::VisitFriendDecl(clang::FriendDecl*)"},
    {"_ZN5clang13ASTDeclReader23VisitFriendTemplateDeclEPNS_18FriendTemplateDeclE", "clang::ASTDeclReader::VisitFriendTemplateDecl(clang::FriendTemplateDecl*)"},
    {"_ZN5clang13ASTDeclReader17VisitTemplateDeclEPNS_12TemplateDeclE", "clang::ASTDeclReader::VisitTemplateDecl(clang::TemplateDecl*)"},
    {"_ZN5clang13ASTDeclReader29VisitRedeclarableTemplateDeclEPNS_24RedeclarableTemplateDeclE", "clang::ASTDeclReader::VisitRedeclarableTemplateDecl(clang::RedeclarableTemplateDecl*)"},
    {"_ZN5clang13ASTDeclReader22VisitClassTemplateDeclEPNS_17ClassTemplateDeclE", "clang::ASTDeclReader::VisitClassTemplateDecl(clang::ClassTemplateDecl*)"},
    {"_ZN5clang13ASTDeclReader36VisitClassTemplateSpecializationDeclEPNS_31ClassTemplateSpecializationDeclE", "clang::ASTDeclReader::VisitClassTemplateSpecializationDecl(clang::ClassTemplateSpecializationDecl*)"},
    {"_ZN5clang13ASTDeclReader43VisitClassTemplatePartialSpecializationDeclEPNS_38ClassTemplatePartialSpecializationDeclE", "clang::ASTDeclReader::VisitClassTemplatePartialSpecializationDecl(clang::ClassTemplatePartialSpecializationDecl*)"},
    {"_ZN5clang13ASTDeclReader25VisitFunctionTemplateDeclEPNS_20FunctionTemplateDeclE", "clang::ASTDeclReader::VisitFunctionTemplateDecl(clang::FunctionTemplateDecl*)"},
    {"_ZN5clang13ASTDeclReader25VisitTemplateTypeParmDeclEPNS_20TemplateTypeParmDeclE", "clang::ASTDeclReader::VisitTemplateTypeParmDecl(clang::TemplateTypeParmDecl*)"},
    {"_ZN5clang13ASTDeclReader28VisitNonTypeTemplateParmDeclEPNS_23NonTypeTemplateParmDeclE", "clang::ASTDeclReader::VisitNonTypeTemplateParmDecl(clang::NonTypeTemplateParmDecl*)"},
    {"_ZN5clang13ASTDeclReader29VisitTemplateTemplateParmDeclEPNS_24TemplateTemplateParmDeclE", "clang::ASTDeclReader::VisitTemplateTemplateParmDecl(clang::TemplateTemplateParmDecl*)"},
    {"_ZN5clang13ASTDeclReader21VisitStaticAssertDeclEPNS_16StaticAssertDeclE", "clang::ASTDeclReader::VisitStaticAssertDecl(clang::StaticAssertDecl*)"},
    {"_ZN5clang13ASTDeclReader16VisitDeclContextEPNS_11DeclContextE", "clang::ASTDeclReader::VisitDeclContext(clang::DeclContext*)"},
    {"_ZN5clang9ASTReader18DeclCursorForIndexEjj", "clang::ASTReader::DeclCursorForIndex(unsigned int, unsigned int)"},
    {"_ZN5clang9ASTReader14ReadDeclRecordEjj", "clang::ASTReader::ReadDeclRecord(unsigned int, unsigned int)"},
    {"_ZN5clang13ASTDeclReader10UpdateDeclEPNS_4DeclERKN4llvm11SmallVectorIyLj64EEE", "clang::ASTDeclReader::UpdateDecl(clang::Decl*, llvm::SmallVector<unsigned long long, 64u> const&)"},
    {"_ZN5clang11DeclVisitorINS_13ASTDeclReaderEvE5VisitEPNS_4DeclE", "clang::DeclVisitor<clang::ASTDeclReader, void>::Visit(clang::Decl*)"},
    {"_ZN5clang13ASTDeclReader17VisitRedeclarableINS_7TagDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclReader::VisitRedeclarable<clang::TagDecl>(clang::Redeclarable<clang::TagDecl>*)"},
    {"_ZN5clang13ASTDeclReader17VisitRedeclarableINS_12FunctionDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclReader::VisitRedeclarable<clang::FunctionDecl>(clang::Redeclarable<clang::FunctionDecl>*)"},
    {"_ZN5clang13ASTDeclReader17VisitRedeclarableINS_7VarDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclReader::VisitRedeclarable<clang::VarDecl>(clang::Redeclarable<clang::VarDecl>*)"},
    {"_ZN5clang14AccessSpecDecl6CreateERNS_10ASTContextENS_4Decl10EmptyShellE", "clang::AccessSpecDecl::Create(clang::ASTContext&, clang::Decl::EmptyShell)"},
    {"_ZN4llvm15SmallVectorImplIN5clang9ASTReader15DeclContextInfoEE6insertEPS3_RKS3_", "llvm::SmallVectorImpl<clang::ASTReader::DeclContextInfo>::insert(clang::ASTReader::DeclContextInfo*, clang::ASTReader::DeclContextInfo const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_11SmallVectorIPS2_Lj4EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::SmallVector<clang::CXXRecordDecl*, 4u>, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::CXXRecordDecl*, 4u> > >::FindAndConstruct(clang::CXXRecordDecl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_11SmallVectorIPS2_Lj4EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::SmallVector<clang::CXXRecordDecl*, 4u>, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::CXXRecordDecl*, 4u> > >::InsertIntoBucket(clang::CXXRecordDecl const* const&, llvm::SmallVector<clang::CXXRecordDecl*, 4u> const&, std::pair<clang::CXXRecordDecl const*, llvm::SmallVector<clang::CXXRecordDecl*, 4u> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_11SmallVectorIPS2_Lj4EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::SmallVector<clang::CXXRecordDecl*, 4u>, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::CXXRecordDecl*, 4u> > >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIPN5clang13CXXRecordDeclEEaSERKS4_", "llvm::SmallVectorImpl<clang::CXXRecordDecl*>::operator=(llvm::SmallVectorImpl<clang::CXXRecordDecl*> const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang9BlockDecl7CaptureELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::BlockDecl::Capture, false>::grow(unsigned long)"},
    {"_ZN5clang13ASTStmtReader32ReadExplicitTemplateArgumentListERNS_28ExplicitTemplateArgumentListEj", "clang::ASTStmtReader::ReadExplicitTemplateArgumentList(clang::ExplicitTemplateArgumentList&, unsigned int)"},
    {"_ZN5clang13ASTStmtReader9VisitStmtEPNS_4StmtE", "clang::ASTStmtReader::VisitStmt(clang::Stmt*)"},
    {"_ZN5clang13ASTStmtReader13VisitNullStmtEPNS_8NullStmtE", "clang::ASTStmtReader::VisitNullStmt(clang::NullStmt*)"},
    {"_ZN5clang13ASTStmtReader17VisitCompoundStmtEPNS_12CompoundStmtE", "clang::ASTStmtReader::VisitCompoundStmt(clang::CompoundStmt*)"},
    {"_ZN5clang13ASTStmtReader15VisitSwitchCaseEPNS_10SwitchCaseE", "clang::ASTStmtReader::VisitSwitchCase(clang::SwitchCase*)"},
    {"_ZN5clang13ASTStmtReader13VisitCaseStmtEPNS_8CaseStmtE", "clang::ASTStmtReader::VisitCaseStmt(clang::CaseStmt*)"},
    {"_ZN5clang9ASTReader11ReadSubExprEv", "clang::ASTReader::ReadSubExpr()"},
    {"_ZN5clang13ASTStmtReader16VisitDefaultStmtEPNS_11DefaultStmtE", "clang::ASTStmtReader::VisitDefaultStmt(clang::DefaultStmt*)"},
    {"_ZN5clang13ASTStmtReader14VisitLabelStmtEPNS_9LabelStmtE", "clang::ASTStmtReader::VisitLabelStmt(clang::LabelStmt*)"},
    {"_ZN5clang13ASTStmtReader11VisitIfStmtEPNS_6IfStmtE", "clang::ASTStmtReader::VisitIfStmt(clang::IfStmt*)"},
    {"_ZN5clang13ASTStmtReader15VisitSwitchStmtEPNS_10SwitchStmtE", "clang::ASTStmtReader::VisitSwitchStmt(clang::SwitchStmt*)"},
    {"_ZN5clang13ASTStmtReader14VisitWhileStmtEPNS_9WhileStmtE", "clang::ASTStmtReader::VisitWhileStmt(clang::WhileStmt*)"},
    {"_ZN5clang13ASTStmtReader11VisitDoStmtEPNS_6DoStmtE", "clang::ASTStmtReader::VisitDoStmt(clang::DoStmt*)"},
    {"_ZN5clang13ASTStmtReader12VisitForStmtEPNS_7ForStmtE", "clang::ASTStmtReader::VisitForStmt(clang::ForStmt*)"},
    {"_ZN5clang13ASTStmtReader13VisitGotoStmtEPNS_8GotoStmtE", "clang::ASTStmtReader::VisitGotoStmt(clang::GotoStmt*)"},
    {"_ZN5clang13ASTStmtReader21VisitIndirectGotoStmtEPNS_16IndirectGotoStmtE", "clang::ASTStmtReader::VisitIndirectGotoStmt(clang::IndirectGotoStmt*)"},
    {"_ZN5clang13ASTStmtReader17VisitContinueStmtEPNS_12ContinueStmtE", "clang::ASTStmtReader::VisitContinueStmt(clang::ContinueStmt*)"},
    {"_ZN5clang13ASTStmtReader14VisitBreakStmtEPNS_9BreakStmtE", "clang::ASTStmtReader::VisitBreakStmt(clang::BreakStmt*)"},
    {"_ZN5clang13ASTStmtReader15VisitReturnStmtEPNS_10ReturnStmtE", "clang::ASTStmtReader::VisitReturnStmt(clang::ReturnStmt*)"},
    {"_ZN5clang13ASTStmtReader13VisitDeclStmtEPNS_8DeclStmtE", "clang::ASTStmtReader::VisitDeclStmt(clang::DeclStmt*)"},
    {"_ZN5clang13ASTStmtReader12VisitAsmStmtEPNS_7AsmStmtE", "clang::ASTStmtReader::VisitAsmStmt(clang::AsmStmt*)"},
    {"_ZN5clang13ASTStmtReader9VisitExprEPNS_4ExprE", "clang::ASTStmtReader::VisitExpr(clang::Expr*)"},
    {"_ZN5clang13ASTStmtReader19VisitPredefinedExprEPNS_14PredefinedExprE", "clang::ASTStmtReader::VisitPredefinedExpr(clang::PredefinedExpr*)"},
    {"_ZN5clang13ASTStmtReader16VisitDeclRefExprEPNS_11DeclRefExprE", "clang::ASTStmtReader::VisitDeclRefExpr(clang::DeclRefExpr*)"},
    {"_ZN5clang13ASTStmtReader19VisitIntegerLiteralEPNS_14IntegerLiteralE", "clang::ASTStmtReader::VisitIntegerLiteral(clang::IntegerLiteral*)"},
    {"_ZN5clang13ASTStmtReader20VisitFloatingLiteralEPNS_15FloatingLiteralE", "clang::ASTStmtReader::VisitFloatingLiteral(clang::FloatingLiteral*)"},
    {"_ZN5clang13ASTStmtReader21VisitImaginaryLiteralEPNS_16ImaginaryLiteralE", "clang::ASTStmtReader::VisitImaginaryLiteral(clang::ImaginaryLiteral*)"},
    {"_ZN5clang13ASTStmtReader18VisitStringLiteralEPNS_13StringLiteralE", "clang::ASTStmtReader::VisitStringLiteral(clang::StringLiteral*)"},
    {"_ZN5clang13ASTStmtReader21VisitCharacterLiteralEPNS_16CharacterLiteralE", "clang::ASTStmtReader::VisitCharacterLiteral(clang::CharacterLiteral*)"},
    {"_ZN5clang13ASTStmtReader14VisitParenExprEPNS_9ParenExprE", "clang::ASTStmtReader::VisitParenExpr(clang::ParenExpr*)"},
    {"_ZN5clang13ASTStmtReader18VisitParenListExprEPNS_13ParenListExprE", "clang::ASTStmtReader::VisitParenListExpr(clang::ParenListExpr*)"},
    {"_ZN5clang13ASTStmtReader18VisitUnaryOperatorEPNS_13UnaryOperatorE", "clang::ASTStmtReader::VisitUnaryOperator(clang::UnaryOperator*)"},
    {"_ZN5clang13ASTStmtReader17VisitOffsetOfExprEPNS_12OffsetOfExprE", "clang::ASTStmtReader::VisitOffsetOfExpr(clang::OffsetOfExpr*)"},
    {"_ZN5clang13ASTStmtReader22VisitSizeOfAlignOfExprEPNS_17SizeOfAlignOfExprE", "clang::ASTStmtReader::VisitSizeOfAlignOfExpr(clang::SizeOfAlignOfExpr*)"},
    {"_ZN5clang13ASTStmtReader23VisitArraySubscriptExprEPNS_18ArraySubscriptExprE", "clang::ASTStmtReader::VisitArraySubscriptExpr(clang::ArraySubscriptExpr*)"},
    {"_ZN5clang13ASTStmtReader13VisitCallExprEPNS_8CallExprE", "clang::ASTStmtReader::VisitCallExpr(clang::CallExpr*)"},
    {"_ZN5clang13ASTStmtReader15VisitMemberExprEPNS_10MemberExprE", "clang::ASTStmtReader::VisitMemberExpr(clang::MemberExpr*)"},
    {"_ZN5clang13ASTStmtReader16VisitObjCIsaExprEPNS_11ObjCIsaExprE", "clang::ASTStmtReader::VisitObjCIsaExpr(clang::ObjCIsaExpr*)"},
    {"_ZN5clang13ASTStmtReader13VisitCastExprEPNS_8CastExprE", "clang::ASTStmtReader::VisitCastExpr(clang::CastExpr*)"},
    {"_ZN5clang13ASTStmtReader19VisitBinaryOperatorEPNS_14BinaryOperatorE", "clang::ASTStmtReader::VisitBinaryOperator(clang::BinaryOperator*)"},
    {"_ZN5clang13ASTStmtReader27VisitCompoundAssignOperatorEPNS_22CompoundAssignOperatorE", "clang::ASTStmtReader::VisitCompoundAssignOperator(clang::CompoundAssignOperator*)"},
    {"_ZN5clang13ASTStmtReader24VisitConditionalOperatorEPNS_19ConditionalOperatorE", "clang::ASTStmtReader::VisitConditionalOperator(clang::ConditionalOperator*)"},
    {"_ZN5clang13ASTStmtReader21VisitImplicitCastExprEPNS_16ImplicitCastExprE", "clang::ASTStmtReader::VisitImplicitCastExpr(clang::ImplicitCastExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitExplicitCastExprEPNS_16ExplicitCastExprE", "clang::ASTStmtReader::VisitExplicitCastExpr(clang::ExplicitCastExpr*)"},
    {"_ZN5clang13ASTStmtReader19VisitCStyleCastExprEPNS_14CStyleCastExprE", "clang::ASTStmtReader::VisitCStyleCastExpr(clang::CStyleCastExpr*)"},
    {"_ZN5clang13ASTStmtReader24VisitCompoundLiteralExprEPNS_19CompoundLiteralExprE", "clang::ASTStmtReader::VisitCompoundLiteralExpr(clang::CompoundLiteralExpr*)"},
    {"_ZN5clang13ASTStmtReader25VisitExtVectorElementExprEPNS_20ExtVectorElementExprE", "clang::ASTStmtReader::VisitExtVectorElementExpr(clang::ExtVectorElementExpr*)"},
    {"_ZN5clang13ASTStmtReader17VisitInitListExprEPNS_12InitListExprE", "clang::ASTStmtReader::VisitInitListExpr(clang::InitListExpr*)"},
    {"_ZN5clang13ASTStmtReader23VisitDesignatedInitExprEPNS_18DesignatedInitExprE", "clang::ASTStmtReader::VisitDesignatedInitExpr(clang::DesignatedInitExpr*)"},
    {"_ZN5clang13ASTStmtReader26VisitImplicitValueInitExprEPNS_21ImplicitValueInitExprE", "clang::ASTStmtReader::VisitImplicitValueInitExpr(clang::ImplicitValueInitExpr*)"},
    {"_ZN5clang13ASTStmtReader14VisitVAArgExprEPNS_9VAArgExprE", "clang::ASTStmtReader::VisitVAArgExpr(clang::VAArgExpr*)"},
    {"_ZN5clang13ASTStmtReader18VisitAddrLabelExprEPNS_13AddrLabelExprE", "clang::ASTStmtReader::VisitAddrLabelExpr(clang::AddrLabelExpr*)"},
    {"_ZN5clang13ASTStmtReader13VisitStmtExprEPNS_8StmtExprE", "clang::ASTStmtReader::VisitStmtExpr(clang::StmtExpr*)"},
    {"_ZN5clang13ASTStmtReader15VisitChooseExprEPNS_10ChooseExprE", "clang::ASTStmtReader::VisitChooseExpr(clang::ChooseExpr*)"},
    {"_ZN5clang13ASTStmtReader16VisitGNUNullExprEPNS_11GNUNullExprE", "clang::ASTStmtReader::VisitGNUNullExpr(clang::GNUNullExpr*)"},
    {"_ZN5clang13ASTStmtReader22VisitShuffleVectorExprEPNS_17ShuffleVectorExprE", "clang::ASTStmtReader::VisitShuffleVectorExpr(clang::ShuffleVectorExpr*)"},
    {"_ZN5clang13ASTStmtReader14VisitBlockExprEPNS_9BlockExprE", "clang::ASTStmtReader::VisitBlockExpr(clang::BlockExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitBlockDeclRefExprEPNS_16BlockDeclRefExprE", "clang::ASTStmtReader::VisitBlockDeclRefExpr(clang::BlockDeclRefExpr*)"},
    {"_ZN5clang13ASTStmtReader22VisitObjCStringLiteralEPNS_17ObjCStringLiteralE", "clang::ASTStmtReader::VisitObjCStringLiteral(clang::ObjCStringLiteral*)"},
    {"_ZN5clang13ASTStmtReader19VisitObjCEncodeExprEPNS_14ObjCEncodeExprE", "clang::ASTStmtReader::VisitObjCEncodeExpr(clang::ObjCEncodeExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitObjCSelectorExprEPNS_16ObjCSelectorExprE", "clang::ASTStmtReader::VisitObjCSelectorExpr(clang::ObjCSelectorExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitObjCProtocolExprEPNS_16ObjCProtocolExprE", "clang::ASTStmtReader::VisitObjCProtocolExpr(clang::ObjCProtocolExpr*)"},
    {"_ZN5clang13ASTStmtReader20VisitObjCIvarRefExprEPNS_15ObjCIvarRefExprE", "clang::ASTStmtReader::VisitObjCIvarRefExpr(clang::ObjCIvarRefExpr*)"},
    {"_ZN5clang13ASTStmtReader24VisitObjCPropertyRefExprEPNS_19ObjCPropertyRefExprE", "clang::ASTStmtReader::VisitObjCPropertyRefExpr(clang::ObjCPropertyRefExpr*)"},
    {"_ZN5clang13ASTStmtReader20VisitObjCMessageExprEPNS_15ObjCMessageExprE", "clang::ASTStmtReader::VisitObjCMessageExpr(clang::ObjCMessageExpr*)"},
    {"_ZN5clang13ASTStmtReader26VisitObjCForCollectionStmtEPNS_21ObjCForCollectionStmtE", "clang::ASTStmtReader::VisitObjCForCollectionStmt(clang::ObjCForCollectionStmt*)"},
    {"_ZN5clang13ASTStmtReader20VisitObjCAtCatchStmtEPNS_15ObjCAtCatchStmtE", "clang::ASTStmtReader::VisitObjCAtCatchStmt(clang::ObjCAtCatchStmt*)"},
    {"_ZN5clang13ASTStmtReader22VisitObjCAtFinallyStmtEPNS_17ObjCAtFinallyStmtE", "clang::ASTStmtReader::VisitObjCAtFinallyStmt(clang::ObjCAtFinallyStmt*)"},
    {"_ZN5clang13ASTStmtReader18VisitObjCAtTryStmtEPNS_13ObjCAtTryStmtE", "clang::ASTStmtReader::VisitObjCAtTryStmt(clang::ObjCAtTryStmt*)"},
    {"_ZN5clang13ASTStmtReader27VisitObjCAtSynchronizedStmtEPNS_22ObjCAtSynchronizedStmtE", "clang::ASTStmtReader::VisitObjCAtSynchronizedStmt(clang::ObjCAtSynchronizedStmt*)"},
    {"_ZN5clang13ASTStmtReader20VisitObjCAtThrowStmtEPNS_15ObjCAtThrowStmtE", "clang::ASTStmtReader::VisitObjCAtThrowStmt(clang::ObjCAtThrowStmt*)"},
    {"_ZN5clang13ASTStmtReader17VisitCXXCatchStmtEPNS_12CXXCatchStmtE", "clang::ASTStmtReader::VisitCXXCatchStmt(clang::CXXCatchStmt*)"},
    {"_ZN5clang13ASTStmtReader15VisitCXXTryStmtEPNS_10CXXTryStmtE", "clang::ASTStmtReader::VisitCXXTryStmt(clang::CXXTryStmt*)"},
    {"_ZN5clang13ASTStmtReader24VisitCXXOperatorCallExprEPNS_19CXXOperatorCallExprE", "clang::ASTStmtReader::VisitCXXOperatorCallExpr(clang::CXXOperatorCallExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitCXXConstructExprEPNS_16CXXConstructExprE", "clang::ASTStmtReader::VisitCXXConstructExpr(clang::CXXConstructExpr*)"},
    {"_ZN5clang13ASTStmtReader27VisitCXXTemporaryObjectExprEPNS_22CXXTemporaryObjectExprE", "clang::ASTStmtReader::VisitCXXTemporaryObjectExpr(clang::CXXTemporaryObjectExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitCXXNamedCastExprEPNS_16CXXNamedCastExprE", "clang::ASTStmtReader::VisitCXXNamedCastExpr(clang::CXXNamedCastExpr*)"},
    {"_ZN5clang13ASTStmtReader22VisitCXXStaticCastExprEPNS_17CXXStaticCastExprE", "clang::ASTStmtReader::VisitCXXStaticCastExpr(clang::CXXStaticCastExpr*)"},
    {"_ZN5clang13ASTStmtReader23VisitCXXDynamicCastExprEPNS_18CXXDynamicCastExprE", "clang::ASTStmtReader::VisitCXXDynamicCastExpr(clang::CXXDynamicCastExpr*)"},
    {"_ZN5clang13ASTStmtReader27VisitCXXReinterpretCastExprEPNS_22CXXReinterpretCastExprE", "clang::ASTStmtReader::VisitCXXReinterpretCastExpr(clang::CXXReinterpretCastExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitCXXConstCastExprEPNS_16CXXConstCastExprE", "clang::ASTStmtReader::VisitCXXConstCastExpr(clang::CXXConstCastExpr*)"},
    {"_ZN5clang13ASTStmtReader26VisitCXXFunctionalCastExprEPNS_21CXXFunctionalCastExprE", "clang::ASTStmtReader::VisitCXXFunctionalCastExpr(clang::CXXFunctionalCastExpr*)"},
    {"_ZN5clang13ASTStmtReader23VisitCXXBoolLiteralExprEPNS_18CXXBoolLiteralExprE", "clang::ASTStmtReader::VisitCXXBoolLiteralExpr(clang::CXXBoolLiteralExpr*)"},
    {"_ZN5clang13ASTStmtReader26VisitCXXNullPtrLiteralExprEPNS_21CXXNullPtrLiteralExprE", "clang::ASTStmtReader::VisitCXXNullPtrLiteralExpr(clang::CXXNullPtrLiteralExpr*)"},
    {"_ZN5clang13ASTStmtReader18VisitCXXTypeidExprEPNS_13CXXTypeidExprE", "clang::ASTStmtReader::VisitCXXTypeidExpr(clang::CXXTypeidExpr*)"},
    {"_ZN5clang13ASTStmtReader18VisitCXXUuidofExprEPNS_13CXXUuidofExprE", "clang::ASTStmtReader::VisitCXXUuidofExpr(clang::CXXUuidofExpr*)"},
    {"_ZN5clang13ASTStmtReader16VisitCXXThisExprEPNS_11CXXThisExprE", "clang::ASTStmtReader::VisitCXXThisExpr(clang::CXXThisExpr*)"},
    {"_ZN5clang13ASTStmtReader17VisitCXXThrowExprEPNS_12CXXThrowExprE", "clang::ASTStmtReader::VisitCXXThrowExpr(clang::CXXThrowExpr*)"},
    {"_ZN5clang13ASTStmtReader22VisitCXXDefaultArgExprEPNS_17CXXDefaultArgExprE", "clang::ASTStmtReader::VisitCXXDefaultArgExpr(clang::CXXDefaultArgExpr*)"},
    {"_ZN5clang13ASTStmtReader25VisitCXXBindTemporaryExprEPNS_20CXXBindTemporaryExprE", "clang::ASTStmtReader::VisitCXXBindTemporaryExpr(clang::CXXBindTemporaryExpr*)"},
    {"_ZN5clang13ASTStmtReader27VisitCXXScalarValueInitExprEPNS_22CXXScalarValueInitExprE", "clang::ASTStmtReader::VisitCXXScalarValueInitExpr(clang::CXXScalarValueInitExpr*)"},
    {"_ZN5clang13ASTStmtReader15VisitCXXNewExprEPNS_10CXXNewExprE", "clang::ASTStmtReader::VisitCXXNewExpr(clang::CXXNewExpr*)"},
    {"_ZN5clang13ASTStmtReader18VisitCXXDeleteExprEPNS_13CXXDeleteExprE", "clang::ASTStmtReader::VisitCXXDeleteExpr(clang::CXXDeleteExpr*)"},
    {"_ZN5clang13ASTStmtReader28VisitCXXPseudoDestructorExprEPNS_23CXXPseudoDestructorExprE", "clang::ASTStmtReader::VisitCXXPseudoDestructorExpr(clang::CXXPseudoDestructorExpr*)"},
    {"_ZN5clang13ASTStmtReader21VisitExprWithCleanupsEPNS_16ExprWithCleanupsE", "clang::ASTStmtReader::VisitExprWithCleanups(clang::ExprWithCleanups*)"},
    {"_ZN5clang13ASTStmtReader32VisitCXXDependentScopeMemberExprEPNS_27CXXDependentScopeMemberExprE", "clang::ASTStmtReader::VisitCXXDependentScopeMemberExpr(clang::CXXDependentScopeMemberExpr*)"},
    {"_ZN5clang13ASTStmtReader30VisitDependentScopeDeclRefExprEPNS_25DependentScopeDeclRefExprE", "clang::ASTStmtReader::VisitDependentScopeDeclRefExpr(clang::DependentScopeDeclRefExpr*)"},
    {"_ZN5clang13ASTStmtReader31VisitCXXUnresolvedConstructExprEPNS_26CXXUnresolvedConstructExprE", "clang::ASTStmtReader::VisitCXXUnresolvedConstructExpr(clang::CXXUnresolvedConstructExpr*)"},
    {"_ZN5clang13ASTStmtReader17VisitOverloadExprEPNS_12OverloadExprE", "clang::ASTStmtReader::VisitOverloadExpr(clang::OverloadExpr*)"},
    {"_ZN5clang13ASTStmtReader25VisitUnresolvedMemberExprEPNS_20UnresolvedMemberExprE", "clang::ASTStmtReader::VisitUnresolvedMemberExpr(clang::UnresolvedMemberExpr*)"},
    {"_ZN5clang13ASTStmtReader25VisitUnresolvedLookupExprEPNS_20UnresolvedLookupExprE", "clang::ASTStmtReader::VisitUnresolvedLookupExpr(clang::UnresolvedLookupExpr*)"},
    {"_ZN5clang13ASTStmtReader23VisitUnaryTypeTraitExprEPNS_18UnaryTypeTraitExprE", "clang::ASTStmtReader::VisitUnaryTypeTraitExpr(clang::UnaryTypeTraitExpr*)"},
    {"_ZN5clang13ASTStmtReader24VisitBinaryTypeTraitExprEPNS_19BinaryTypeTraitExprE", "clang::ASTStmtReader::VisitBinaryTypeTraitExpr(clang::BinaryTypeTraitExpr*)"},
    {"_ZN5clang13ASTStmtReader20VisitCXXNoexceptExprEPNS_15CXXNoexceptExprE", "clang::ASTStmtReader::VisitCXXNoexceptExpr(clang::CXXNoexceptExpr*)"},
    {"_ZN5clang13ASTStmtReader22VisitPackExpansionExprEPNS_17PackExpansionExprE", "clang::ASTStmtReader::VisitPackExpansionExpr(clang::PackExpansionExpr*)"},
    {"_ZN5clang13ASTStmtReader19VisitSizeOfPackExprEPNS_14SizeOfPackExprE", "clang::ASTStmtReader::VisitSizeOfPackExpr(clang::SizeOfPackExpr*)"},
    {"_ZN5clang13ASTStmtReader37VisitSubstNonTypeTemplateParmPackExprEPNS_32SubstNonTypeTemplateParmPackExprE", "clang::ASTStmtReader::VisitSubstNonTypeTemplateParmPackExpr(clang::SubstNonTypeTemplateParmPackExpr*)"},
    {"_ZN5clang13ASTStmtReader20VisitOpaqueValueExprEPNS_15OpaqueValueExprE", "clang::ASTStmtReader::VisitOpaqueValueExpr(clang::OpaqueValueExpr*)"},
    {"_ZN5clang13ASTStmtReader23VisitCUDAKernelCallExprEPNS_18CUDAKernelCallExprE", "clang::ASTStmtReader::VisitCUDAKernelCallExpr(clang::CUDAKernelCallExpr*)"},
    {"_ZN5clang9ASTReader8ReadStmtERNS0_11PerFileDataE", "clang::ASTReader::ReadStmt(clang::ASTReader::PerFileData&)"},
    {"_ZN5clang9ASTReader18ReadStmtFromStreamERNS0_11PerFileDataE", "clang::ASTReader::ReadStmtFromStream(clang::ASTReader::PerFileData&)"},
    {"_ZN5clang9ASTReader8ReadExprERNS0_11PerFileDataE", "clang::ASTReader::ReadExpr(clang::ASTReader::PerFileData&)"},
    {"_ZN5clang11StmtVisitorINS_13ASTStmtReaderEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<clang::ASTStmtReader, void>::Visit(clang::Stmt*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang18DesignatedInitExpr10DesignatorELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::DesignatedInitExpr::Designator, false>::grow(unsigned long)"},
    {"_ZN5clang9ASTWriter19WriteBlockInfoBlockEv", "clang::ASTWriter::WriteBlockInfoBlock()"},
    {"_Z11EmitBlockIDjPKcRN4llvm15BitstreamWriterERNS1_15SmallVectorImplIyEE", "EmitBlockID(unsigned int, char const*, llvm::BitstreamWriter&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_Z12EmitRecordIDjPKcRN4llvm15BitstreamWriterERNS1_15SmallVectorImplIyEE", "EmitRecordID(unsigned int, char const*, llvm::BitstreamWriter&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter13WriteMetadataERNS_10ASTContextEPKc", "clang::ASTWriter::WriteMetadata(clang::ASTContext&, char const*)"},
    {"_ZN5clang9ASTWriter20WriteLanguageOptionsERKNS_11LangOptionsE", "clang::ASTWriter::WriteLanguageOptions(clang::LangOptions const&)"},
    {"_ZN5clang9ASTWriter14WriteStatCacheERNS_17MemorizeStatCallsE", "clang::ASTWriter::WriteStatCache(clang::MemorizeStatCalls&)"},
    {"_ZN5clang9ASTWriter23WriteSourceManagerBlockERNS_13SourceManagerERKNS_12PreprocessorEPKc", "clang::ASTWriter::WriteSourceManagerBlock(clang::SourceManager&, clang::Preprocessor const&, char const*)"},
    {"_ZN5clang9ASTWriter16AddIdentifierRefEPKNS_14IdentifierInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddIdentifierRef(clang::IdentifierInfo const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter17WritePreprocessorERKNS_12PreprocessorE", "clang::ASTWriter::WritePreprocessor(clang::Preprocessor const&)"},
    {"_ZN5clang9ASTWriter20getMacroDefinitionIDEPNS_15MacroDefinitionE", "clang::ASTWriter::getMacroDefinitionID(clang::MacroDefinition*)"},
    {"_ZN5clang9ASTWriter23WritePreprocessorDetailERNS_19PreprocessingRecordE", "clang::ASTWriter::WritePreprocessorDetail(clang::PreprocessingRecord&)"},
    {"_ZN5clang9ASTWriter17AddSourceLocationENS_14SourceLocationERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddSourceLocation(clang::SourceLocation, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter29WritePragmaDiagnosticMappingsERKNS_10DiagnosticE", "clang::ASTWriter::WritePragmaDiagnosticMappings(clang::Diagnostic const&)"},
    {"_ZN5clang9ASTWriter9WriteTypeENS_8QualTypeE", "clang::ASTWriter::WriteType(clang::QualType)"},
    {"_ZN5clang9ASTWriter10AddTypeRefENS_8QualTypeERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTypeRef(clang::QualType, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN12_GLOBAL__N_113ASTTypeWriter15VisitVectorTypeEPKN5clang10VectorTypeE", "(anonymous namespace)::ASTTypeWriter::VisitVectorType(clang::VectorType const*)"},
    {"_ZN5clang9ASTWriter28WriteDeclContextLexicalBlockERNS_10ASTContextEPNS_11DeclContextE", "clang::ASTWriter::WriteDeclContextLexicalBlock(clang::ASTContext&, clang::DeclContext*)"},
    {"_ZN5clang9ASTWriter10GetDeclRefEPKNS_4DeclE", "clang::ASTWriter::GetDeclRef(clang::Decl const*)"},
    {"_ZN5clang9ASTWriter20WriteTypeDeclOffsetsEv", "clang::ASTWriter::WriteTypeDeclOffsets()"},
    {"_ZN5clang9ASTWriter14WriteSelectorsERNS_4SemaE", "clang::ASTWriter::WriteSelectors(clang::Sema&)"},
    {"_ZN5clang9ASTWriter28WriteReferencedSelectorsPoolERNS_4SemaE", "clang::ASTWriter::WriteReferencedSelectorsPool(clang::Sema&)"},
    {"_ZN5clang9ASTWriter14AddSelectorRefENS_8SelectorERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddSelectorRef(clang::Selector, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter20WriteIdentifierTableERNS_12PreprocessorE", "clang::ASTWriter::WriteIdentifierTable(clang::Preprocessor&)"},
    {"_ZN5clang9ASTWriter16getIdentifierRefEPKNS_14IdentifierInfoE", "clang::ASTWriter::getIdentifierRef(clang::IdentifierInfo const*)"},
    {"_ZN5clang9ASTWriter28WriteDeclContextVisibleBlockERNS_10ASTContextEPNS_11DeclContextE", "clang::ASTWriter::WriteDeclContextVisibleBlock(clang::ASTContext&, clang::DeclContext*)"},
    {"_ZN5clang31OnDiskChainedHashTableGeneratorIN12_GLOBAL__N_129ASTDeclContextNameLookupTraitEE6insertENS_15DeclarationNameERKNS_23DeclContextLookupResultERS2_", "clang::OnDiskChainedHashTableGenerator<(anonymous namespace)::ASTDeclContextNameLookupTrait>::insert(clang::DeclarationName, clang::DeclContextLookupResult const&, (anonymous namespace)::ASTDeclContextNameLookupTrait&)"},
    {"_ZN5clang31OnDiskChainedHashTableGeneratorIN12_GLOBAL__N_129ASTDeclContextNameLookupTraitEE4EmitERN4llvm11raw_ostreamERS2_", "clang::OnDiskChainedHashTableGenerator<(anonymous namespace)::ASTDeclContextNameLookupTrait>::Emit(llvm::raw_ostream&, (anonymous namespace)::ASTDeclContextNameLookupTrait&)"},
    {"_ZN5clang9ASTWriter29WriteDeclContextVisibleUpdateEPKNS_11DeclContextE", "clang::ASTWriter::WriteDeclContextVisibleUpdate(clang::DeclContext const*)"},
    {"_ZN5clang9ASTWriter9getDeclIDEPKNS_4DeclE", "clang::ASTWriter::getDeclID(clang::Decl const*)"},
    {"_ZN5clang9ASTWriter15WriteAttributesERKN4llvm11SmallVectorIPNS_4AttrELj2EEERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::WriteAttributes(llvm::SmallVector<clang::Attr*, 2u> const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter9AddStringEN4llvm9StringRefERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddString(llvm::StringRef, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter17AddTypeSourceInfoEPNS_14TypeSourceInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTypeSourceInfo(clang::TypeSourceInfo*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter10AddDeclRefEPKNS_4DeclERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclRef(clang::Decl const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter19SetIdentifierOffsetEPKNS_14IdentifierInfoEj", "clang::ASTWriter::SetIdentifierOffset(clang::IdentifierInfo const*, unsigned int)"},
    {"_ZN5clang9ASTWriter17SetSelectorOffsetENS_8SelectorEj", "clang::ASTWriter::SetSelectorOffset(clang::Selector, unsigned int)"},
    {"_ZN5clang9ASTWriterC1ERN4llvm15BitstreamWriterE", "clang::ASTWriter::ASTWriter(llvm::BitstreamWriter&)"},
    {"_ZN5clang9ASTWriterC2ERN4llvm15BitstreamWriterE", "clang::ASTWriter::ASTWriter(llvm::BitstreamWriter&)"},
    {"_ZN5clang9ASTWriter8WriteASTERNS_4SemaEPNS_17MemorizeStatCallsEPKc", "clang::ASTWriter::WriteAST(clang::Sema&, clang::MemorizeStatCalls*, char const*)"},
    {"_ZN5clang9ASTWriter13WriteASTChainERNS_4SemaEPNS_17MemorizeStatCallsEPKc", "clang::ASTWriter::WriteASTChain(clang::Sema&, clang::MemorizeStatCalls*, char const*)"},
    {"_ZN5clang9ASTWriter12WriteASTCoreERNS_4SemaEPNS_17MemorizeStatCallsEPKc", "clang::ASTWriter::WriteASTCore(clang::Sema&, clang::MemorizeStatCalls*, char const*)"},
    {"_ZN5clang9ASTWriter22WriteDeclUpdatesBlocksEv", "clang::ASTWriter::WriteDeclUpdatesBlocks()"},
    {"_ZN5clang9ASTWriter26WriteDeclReplacementsBlockEv", "clang::ASTWriter::WriteDeclReplacementsBlock()"},
    {"_ZN5clang9ASTWriter14AddSourceRangeENS_11SourceRangeERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddSourceRange(clang::SourceRange, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter8AddAPIntERKN4llvm5APIntERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddAPInt(llvm::APInt const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter9AddAPSIntERKN4llvm6APSIntERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddAPSInt(llvm::APSInt const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter10AddAPFloatERKN4llvm7APFloatERNS1_15SmallVectorImplIyEE", "clang::ASTWriter::AddAPFloat(llvm::APFloat const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter14getSelectorRefENS_8SelectorE", "clang::ASTWriter::getSelectorRef(clang::Selector)"},
    {"_ZN5clang9ASTWriter15AddCXXTemporaryEPKNS_12CXXTemporaryERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXTemporary(clang::CXXTemporary const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter23AddCXXBaseSpecifiersRefEPKNS_16CXXBaseSpecifierES3_RN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXBaseSpecifiersRef(clang::CXXBaseSpecifier const*, clang::CXXBaseSpecifier const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter26AddTemplateArgumentLocInfoENS_16TemplateArgument7ArgKindERKNS_23TemplateArgumentLocInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgumentLocInfo(clang::TemplateArgument::ArgKind, clang::TemplateArgumentLocInfo const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter22AddTemplateArgumentLocERKNS_19TemplateArgumentLocERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgumentLoc(clang::TemplateArgumentLoc const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter19AddTemplateArgumentERKNS_16TemplateArgumentERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgument(clang::TemplateArgument const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter17GetOrCreateTypeIDENS_8QualTypeE", "clang::ASTWriter::GetOrCreateTypeID(clang::QualType)"},
    {"_ZN5clang9ASTWriter18GetOrCreateTypeIdxENS_8QualTypeE", "clang::ASTWriter::GetOrCreateTypeIdx(clang::QualType)"},
    {"_ZNK5clang9ASTWriter9getTypeIDENS_8QualTypeE", "clang::ASTWriter::getTypeID(clang::QualType) const"},
    {"_ZNK5clang9ASTWriter10getTypeIdxENS_8QualTypeE", "clang::ASTWriter::getTypeIdx(clang::QualType) const"},
    {"_ZN5clang9ASTWriter18AddDeclarationNameENS_15DeclarationNameERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclarationName(clang::DeclarationName, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter21AddDeclarationNameLocERKNS_18DeclarationNameLocENS_15DeclarationNameERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclarationNameLoc(clang::DeclarationNameLoc const&, clang::DeclarationName, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter22AddDeclarationNameInfoERKNS_19DeclarationNameInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddDeclarationNameInfo(clang::DeclarationNameInfo const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter16AddQualifierInfoERKNS_13QualifierInfoERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddQualifierInfo(clang::QualifierInfo const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter22AddNestedNameSpecifierEPNS_19NestedNameSpecifierERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddNestedNameSpecifier(clang::NestedNameSpecifier*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter24AddTemplateParameterListEPKNS_21TemplateParameterListERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateParameterList(clang::TemplateParameterList const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter15AddTemplateNameENS_12TemplateNameERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateName(clang::TemplateName, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter23AddTemplateArgumentListEPKNS_20TemplateArgumentListERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddTemplateArgumentList(clang::TemplateArgumentList const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter16AddUnresolvedSetERKNS_17UnresolvedSetImplERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddUnresolvedSet(clang::UnresolvedSetImpl const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter19AddCXXBaseSpecifierERKNS_16CXXBaseSpecifierERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXBaseSpecifier(clang::CXXBaseSpecifier const&, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter22FlushCXXBaseSpecifiersEv", "clang::ASTWriter::FlushCXXBaseSpecifiers()"},
    {"_ZN5clang9ASTWriter22AddCXXCtorInitializersEPKPKNS_18CXXCtorInitializerEjRN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXCtorInitializers(clang::CXXCtorInitializer const* const*, unsigned int, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter20AddCXXDefinitionDataEPKNS_13CXXRecordDeclERN4llvm15SmallVectorImplIyEE", "clang::ASTWriter::AddCXXDefinitionData(clang::CXXRecordDecl const*, llvm::SmallVectorImpl<unsigned long long>&)"},
    {"_ZN5clang9ASTWriter17ReaderInitializedEPNS_9ASTReaderE", "clang::ASTWriter::ReaderInitialized(clang::ASTReader*)"},
    {"_ZN5clang9ASTWriter14IdentifierReadEjPNS_14IdentifierInfoE", "clang::ASTWriter::IdentifierRead(unsigned int, clang::IdentifierInfo*)"},
    {"_ZN5clang9ASTWriter8TypeReadENS_13serialization7TypeIdxENS_8QualTypeE", "clang::ASTWriter::TypeRead(clang::serialization::TypeIdx, clang::QualType)"},
    {"_ZN5clang9ASTWriter8DeclReadEjPKNS_4DeclE", "clang::ASTWriter::DeclRead(unsigned int, clang::Decl const*)"},
    {"_ZN5clang9ASTWriter12SelectorReadEjNS_8SelectorE", "clang::ASTWriter::SelectorRead(unsigned int, clang::Selector)"},
    {"_ZN5clang9ASTWriter19MacroDefinitionReadEjPNS_15MacroDefinitionE", "clang::ASTWriter::MacroDefinitionRead(unsigned int, clang::MacroDefinition*)"},
    {"_ZThn8_N5clang9ASTWriter22CompletedTagDefinitionEPKNS_7TagDeclE", "non-virtual thunk to clang::ASTWriter::CompletedTagDefinition(clang::TagDecl const*)"},
    {"_ZN5clang9ASTWriter22CompletedTagDefinitionEPKNS_7TagDeclE", "clang::ASTWriter::CompletedTagDefinition(clang::TagDecl const*)"},
    {"_ZThn8_N5clang9ASTWriter16AddedVisibleDeclEPKNS_11DeclContextEPKNS_4DeclE", "non-virtual thunk to clang::ASTWriter::AddedVisibleDecl(clang::DeclContext const*, clang::Decl const*)"},
    {"_ZN5clang9ASTWriter16AddedVisibleDeclEPKNS_11DeclContextEPKNS_4DeclE", "clang::ASTWriter::AddedVisibleDecl(clang::DeclContext const*, clang::Decl const*)"},
    {"_ZThn8_N5clang9ASTWriter22AddedCXXImplicitMemberEPKNS_13CXXRecordDeclEPKNS_4DeclE", "non-virtual thunk to clang::ASTWriter::AddedCXXImplicitMember(clang::CXXRecordDecl const*, clang::Decl const*)"},
    {"_ZN5clang9ASTWriter22AddedCXXImplicitMemberEPKNS_13CXXRecordDeclEPKNS_4DeclE", "clang::ASTWriter::AddedCXXImplicitMember(clang::CXXRecordDecl const*, clang::Decl const*)"},
    {"_ZThn8_N5clang9ASTWriter30AddedCXXTemplateSpecializationEPKNS_17ClassTemplateDeclEPKNS_31ClassTemplateSpecializationDeclE", "non-virtual thunk to clang::ASTWriter::AddedCXXTemplateSpecialization(clang::ClassTemplateDecl const*, clang::ClassTemplateSpecializationDecl const*)"},
    {"_ZN5clang9ASTWriter30AddedCXXTemplateSpecializationEPKNS_17ClassTemplateDeclEPKNS_31ClassTemplateSpecializationDeclE", "clang::ASTWriter::AddedCXXTemplateSpecialization(clang::ClassTemplateDecl const*, clang::ClassTemplateSpecializationDecl const*)"},
    {"_ZN5clang24ASTSerializationListenerD0Ev", "clang::ASTSerializationListener::~ASTSerializationListener()"},
    {"_ZN5clang24ASTSerializationListenerD1Ev", "clang::ASTSerializationListener::~ASTSerializationListener()"},
    {"_ZN5clang24ASTSerializationListenerD2Ev", "clang::ASTSerializationListener::~ASTSerializationListener()"},
    {"_ZN12_GLOBAL__N_113TypeLocWriter20VisitFunctionTypeLocEN5clang15FunctionTypeLocE", "(anonymous namespace)::TypeLocWriter::VisitFunctionTypeLoc(clang::FunctionTypeLoc)"},
    {"_ZN12_GLOBAL__N_113TypeLocWriter17VisitArrayTypeLocEN5clang12ArrayTypeLocE", "(anonymous namespace)::TypeLocWriter::VisitArrayTypeLoc(clang::ArrayTypeLoc)"},
    {"_ZN12_GLOBAL__N_113ASTTypeWriter12VisitTagTypeEPKN5clang7TagTypeE", "(anonymous namespace)::ASTTypeWriter::VisitTagType(clang::TagType const*)"},
    {"_ZN12_GLOBAL__N_113ASTTypeWriter17VisitFunctionTypeEPKN5clang12FunctionTypeE", "(anonymous namespace)::ASTTypeWriter::VisitFunctionType(clang::FunctionType const*)"},
    {"_ZN12_GLOBAL__N_113ASTTypeWriter14VisitArrayTypeEPKN5clang9ArrayTypeE", "(anonymous namespace)::ASTTypeWriter::VisitArrayType(clang::ArrayType const*)"},
    {"_ZN4llvm15BitstreamWriter13EnterSubblockEjj", "llvm::BitstreamWriter::EnterSubblock(unsigned int, unsigned int)"},
    {"_ZN4llvm15BitstreamWriter9ExitBlockEv", "llvm::BitstreamWriter::ExitBlock()"},
    {"_ZN4llvm15BitstreamWriter10EmitRecordIyEEvjRNS_15SmallVectorImplIT_EEj", "void llvm::BitstreamWriter::EmitRecord<unsigned long long>(unsigned int, llvm::SmallVectorImpl<unsigned long long>&, unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIyE6insertIPKcEEPyS5_T_S6_", "unsigned long long* llvm::SmallVectorImpl<unsigned long long>::insert<char const*>(unsigned long long*, char const*, char const*)"},
    {"_ZN4llvm15BitstreamWriter4EmitEjj", "llvm::BitstreamWriter::Emit(unsigned int, unsigned int)"},
    {"_ZN5clang13serialization10MakeTypeIDISt9binder1stISt10mem_fun1_tINS0_7TypeIdxENS_9ASTWriterENS_8QualTypeEEEEEjS6_T_", "unsigned int clang::serialization::MakeTypeID<std::binder1st<std::mem_fun1_t<clang::serialization::TypeIdx, clang::ASTWriter, clang::QualType> > >(clang::QualType, std::binder1st<std::mem_fun1_t<clang::serialization::TypeIdx, clang::ASTWriter, clang::QualType> >)"},
    {"_ZN5clang13serialization10MakeTypeIDISt9binder1stISt16const_mem_fun1_tINS0_7TypeIdxENS_9ASTWriterENS_8QualTypeEEEEEjS6_T_", "unsigned int clang::serialization::MakeTypeID<std::binder1st<std::const_mem_fun1_t<clang::serialization::TypeIdx, clang::ASTWriter, clang::QualType> > >(clang::QualType, std::binder1st<std::const_mem_fun1_t<clang::serialization::TypeIdx, clang::ASTWriter, clang::QualType> >)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclENS_11SmallVectorIyLj2EEENS_12DenseMapInfoIS4_EENS7_IS6_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::Decl const*, llvm::SmallVector<unsigned long long, 2u>, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::SmallVector<unsigned long long, 2u> > >::FindAndConstruct(clang::Decl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclENS_11SmallVectorIyLj2EEENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::Decl const*, llvm::SmallVector<unsigned long long, 2u>, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::SmallVector<unsigned long long, 2u> > >::InsertIntoBucket(clang::Decl const* const&, llvm::SmallVector<unsigned long long, 2u> const&, std::pair<clang::Decl const*, llvm::SmallVector<unsigned long long, 2u> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclENS_11SmallVectorIyLj2EEENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::Decl const*, llvm::SmallVector<unsigned long long, 2u>, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::SmallVector<unsigned long long, 2u> > >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIyEaSERKS1_", "llvm::SmallVectorImpl<unsigned long long>::operator=(llvm::SmallVectorImpl<unsigned long long> const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang9ASTWriter23QueuedCXXBaseSpecifiersELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ASTWriter::QueuedCXXBaseSpecifiers, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIPKN5clang15MacroDefinitionEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::MacroDefinition const*, unsigned int, llvm::DenseMapInfo<clang::MacroDefinition const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::MacroDefinition const* const&, unsigned int const&, std::pair<clang::MacroDefinition const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang15MacroDefinitionEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::MacroDefinition const*, unsigned int, llvm::DenseMapInfo<clang::MacroDefinition const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZNSt5dequeIN5clang9ASTWriter10DeclOrTypeESaIS2_EE9push_backERKS2_", "std::deque<clang::ASTWriter::DeclOrType, std::allocator<clang::ASTWriter::DeclOrType> >::push_back(clang::ASTWriter::DeclOrType const&)"},
    {"_ZNSt5dequeIN5clang9ASTWriter10DeclOrTypeESaIS2_EE17_M_reallocate_mapEmb", "std::deque<clang::ASTWriter::DeclOrType, std::allocator<clang::ASTWriter::DeclOrType> >::_M_reallocate_map(unsigned long, bool)"},
    {"_ZNSt11_Deque_baseIN5clang9ASTWriter10DeclOrTypeESaIS2_EE17_M_initialize_mapEm", "std::_Deque_base<clang::ASTWriter::DeclOrType, std::allocator<clang::ASTWriter::DeclOrType> >::_M_initialize_map(unsigned long)"},
    {"_ZNSt5dequeIN5clang9ASTWriter10DeclOrTypeESaIS2_EEC2ERKS4_", "std::deque<clang::ASTWriter::DeclOrType, std::allocator<clang::ASTWriter::DeclOrType> >::deque(std::deque<clang::ASTWriter::DeclOrType, std::allocator<clang::ASTWriter::DeclOrType> > const&)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEjNS_12DenseMapInfoIS2_EENS3_IjEEE16InsertIntoBucketERKS2_RKjPSt4pairIS2_jE", "llvm::DenseMap<clang::Selector, unsigned int, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::Selector const&, unsigned int const&, std::pair<clang::Selector, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEjNS_12DenseMapInfoIS2_EENS3_IjEEE4growEj", "llvm::DenseMap<clang::Selector, unsigned int, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIPN5clang4DeclEE6appendINS1_18IdentifierResolver8iteratorEEEvT_S8_", "void llvm::SmallVectorImpl<clang::Decl*>::append<clang::IdentifierResolver::iterator>(clang::IdentifierResolver::iterator, clang::IdentifierResolver::iterator)"},
    {"_ZN4llvm15BitstreamWriter24EmitRecordWithAbbrevImplIyEEvjRNS_15SmallVectorImplIT_EENS_9StringRefE", "void llvm::BitstreamWriter::EmitRecordWithAbbrevImpl<unsigned long long>(unsigned int, llvm::SmallVectorImpl<unsigned long long>&, llvm::StringRef)"},
    {"_ZN4llvm15BitstreamWriter20EmitAbbreviatedFieldIhEEvRKNS_15BitCodeAbbrevOpET_", "void llvm::BitstreamWriter::EmitAbbreviatedField<unsigned char>(llvm::BitCodeAbbrevOp const&, unsigned char)"},
    {"_ZN4llvm15BitstreamWriter20EmitAbbreviatedFieldIyEEvRKNS_15BitCodeAbbrevOpET_", "void llvm::BitstreamWriter::EmitAbbreviatedField<unsigned long long>(llvm::BitCodeAbbrevOp const&, unsigned long long)"},
    {"_ZN4llvm15BitstreamWriter11FlushToWordEv", "llvm::BitstreamWriter::FlushToWord()"},
    {"_ZNSt6vectorIhSaIhEE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPhS1_EERKh", "std::vector<unsigned char, std::allocator<unsigned char> >::_M_insert_aux(__gnu_cxx::__normal_iterator<unsigned char*, std::vector<unsigned char, std::allocator<unsigned char> > >, unsigned char const&)"},
    {"_ZN4llvm15BitstreamWriter9EmitVBR64Eyj", "llvm::BitstreamWriter::EmitVBR64(unsigned long long, unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIyE6insertEPyRKy", "llvm::SmallVectorImpl<unsigned long long>::insert(unsigned long long*, unsigned long long const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang14IdentifierInfoEyNS_12DenseMapInfoIS4_EENS5_IyEEE16InsertIntoBucketERKS4_RKyPSt4pairIS4_yE", "llvm::DenseMap<clang::IdentifierInfo const*, unsigned long long, llvm::DenseMapInfo<clang::IdentifierInfo const*>, llvm::DenseMapInfo<unsigned long long> >::InsertIntoBucket(clang::IdentifierInfo const* const&, unsigned long long const&, std::pair<clang::IdentifierInfo const*, unsigned long long>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang14IdentifierInfoEyNS_12DenseMapInfoIS4_EENS5_IyEEE4growEj", "llvm::DenseMap<clang::IdentifierInfo const*, unsigned long long, llvm::DenseMapInfo<clang::IdentifierInfo const*>, llvm::DenseMapInfo<unsigned long long> >::grow(unsigned int)"},
    {"_ZN4llvm15BitstreamWriter12EncodeAbbrevEPNS_13BitCodeAbbrevE", "llvm::BitstreamWriter::EncodeAbbrev(llvm::BitCodeAbbrev*)"},
    {"_ZNSt6vectorIN4llvm15BitstreamWriter5BlockESaIS2_EE9push_backERKS2_", "std::vector<llvm::BitstreamWriter::Block, std::allocator<llvm::BitstreamWriter::Block> >::push_back(llvm::BitstreamWriter::Block const&)"},
    {"_ZNSt6vectorIN4llvm15BitstreamWriter5BlockESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<llvm::BitstreamWriter::Block, std::allocator<llvm::BitstreamWriter::Block> >::_M_insert_aux(__gnu_cxx::__normal_iterator<llvm::BitstreamWriter::Block*, std::vector<llvm::BitstreamWriter::Block, std::allocator<llvm::BitstreamWriter::Block> > >, llvm::BitstreamWriter::Block const&)"},
    {"_ZN5clang13ASTDeclWriter5VisitEPNS_4DeclE", "clang::ASTDeclWriter::Visit(clang::Decl*)"},
    {"_ZN5clang13ASTDeclWriter9VisitDeclEPNS_4DeclE", "clang::ASTDeclWriter::VisitDecl(clang::Decl*)"},
    {"_ZN5clang13ASTDeclWriter24VisitTranslationUnitDeclEPNS_19TranslationUnitDeclE", "clang::ASTDeclWriter::VisitTranslationUnitDecl(clang::TranslationUnitDecl*)"},
    {"_ZN5clang13ASTDeclWriter14VisitNamedDeclEPNS_9NamedDeclE", "clang::ASTDeclWriter::VisitNamedDecl(clang::NamedDecl*)"},
    {"_ZN5clang13ASTDeclWriter13VisitTypeDeclEPNS_8TypeDeclE", "clang::ASTDeclWriter::VisitTypeDecl(clang::TypeDecl*)"},
    {"_ZN5clang13ASTDeclWriter16VisitTypedefDeclEPNS_11TypedefDeclE", "clang::ASTDeclWriter::VisitTypedefDecl(clang::TypedefDecl*)"},
    {"_ZN5clang13ASTDeclWriter12VisitTagDeclEPNS_7TagDeclE", "clang::ASTDeclWriter::VisitTagDecl(clang::TagDecl*)"},
    {"_ZN5clang13ASTDeclWriter13VisitEnumDeclEPNS_8EnumDeclE", "clang::ASTDeclWriter::VisitEnumDecl(clang::EnumDecl*)"},
    {"_ZN5clang13ASTDeclWriter15VisitRecordDeclEPNS_10RecordDeclE", "clang::ASTDeclWriter::VisitRecordDecl(clang::RecordDecl*)"},
    {"_ZN5clang13ASTDeclWriter14VisitValueDeclEPNS_9ValueDeclE", "clang::ASTDeclWriter::VisitValueDecl(clang::ValueDecl*)"},
    {"_ZN5clang13ASTDeclWriter21VisitEnumConstantDeclEPNS_16EnumConstantDeclE", "clang::ASTDeclWriter::VisitEnumConstantDecl(clang::EnumConstantDecl*)"},
    {"_ZN5clang13ASTDeclWriter19VisitDeclaratorDeclEPNS_14DeclaratorDeclE", "clang::ASTDeclWriter::VisitDeclaratorDecl(clang::DeclaratorDecl*)"},
    {"_ZN5clang13ASTDeclWriter17VisitFunctionDeclEPNS_12FunctionDeclE", "clang::ASTDeclWriter::VisitFunctionDecl(clang::FunctionDecl*)"},
    {"_ZN5clang13ASTDeclWriter19VisitObjCMethodDeclEPNS_14ObjCMethodDeclE", "clang::ASTDeclWriter::VisitObjCMethodDecl(clang::ObjCMethodDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitObjCContainerDeclEPNS_17ObjCContainerDeclE", "clang::ASTDeclWriter::VisitObjCContainerDecl(clang::ObjCContainerDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitObjCInterfaceDeclEPNS_17ObjCInterfaceDeclE", "clang::ASTDeclWriter::VisitObjCInterfaceDecl(clang::ObjCInterfaceDecl*)"},
    {"_ZN5clang13ASTDeclWriter17VisitObjCIvarDeclEPNS_12ObjCIvarDeclE", "clang::ASTDeclWriter::VisitObjCIvarDecl(clang::ObjCIvarDecl*)"},
    {"_ZN5clang13ASTDeclWriter14VisitFieldDeclEPNS_9FieldDeclE", "clang::ASTDeclWriter::VisitFieldDecl(clang::FieldDecl*)"},
    {"_ZN5clang13ASTDeclWriter21VisitObjCProtocolDeclEPNS_16ObjCProtocolDeclE", "clang::ASTDeclWriter::VisitObjCProtocolDecl(clang::ObjCProtocolDecl*)"},
    {"_ZN5clang13ASTDeclWriter24VisitObjCAtDefsFieldDeclEPNS_19ObjCAtDefsFieldDeclE", "clang::ASTDeclWriter::VisitObjCAtDefsFieldDecl(clang::ObjCAtDefsFieldDecl*)"},
    {"_ZN5clang13ASTDeclWriter18VisitObjCClassDeclEPNS_13ObjCClassDeclE", "clang::ASTDeclWriter::VisitObjCClassDecl(clang::ObjCClassDecl*)"},
    {"_ZN5clang13ASTDeclWriter28VisitObjCForwardProtocolDeclEPNS_23ObjCForwardProtocolDeclE", "clang::ASTDeclWriter::VisitObjCForwardProtocolDecl(clang::ObjCForwardProtocolDecl*)"},
    {"_ZN5clang13ASTDeclWriter21VisitObjCCategoryDeclEPNS_16ObjCCategoryDeclE", "clang::ASTDeclWriter::VisitObjCCategoryDecl(clang::ObjCCategoryDecl*)"},
    {"_ZN5clang13ASTDeclWriter28VisitObjCCompatibleAliasDeclEPNS_23ObjCCompatibleAliasDeclE", "clang::ASTDeclWriter::VisitObjCCompatibleAliasDecl(clang::ObjCCompatibleAliasDecl*)"},
    {"_ZN5clang13ASTDeclWriter21VisitObjCPropertyDeclEPNS_16ObjCPropertyDeclE", "clang::ASTDeclWriter::VisitObjCPropertyDecl(clang::ObjCPropertyDecl*)"},
    {"_ZN5clang13ASTDeclWriter17VisitObjCImplDeclEPNS_12ObjCImplDeclE", "clang::ASTDeclWriter::VisitObjCImplDecl(clang::ObjCImplDecl*)"},
    {"_ZN5clang13ASTDeclWriter25VisitObjCCategoryImplDeclEPNS_20ObjCCategoryImplDeclE", "clang::ASTDeclWriter::VisitObjCCategoryImplDecl(clang::ObjCCategoryImplDecl*)"},
    {"_ZN5clang13ASTDeclWriter27VisitObjCImplementationDeclEPNS_22ObjCImplementationDeclE", "clang::ASTDeclWriter::VisitObjCImplementationDecl(clang::ObjCImplementationDecl*)"},
    {"_ZN5clang13ASTDeclWriter25VisitObjCPropertyImplDeclEPNS_20ObjCPropertyImplDeclE", "clang::ASTDeclWriter::VisitObjCPropertyImplDecl(clang::ObjCPropertyImplDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitIndirectFieldDeclEPNS_17IndirectFieldDeclE", "clang::ASTDeclWriter::VisitIndirectFieldDecl(clang::IndirectFieldDecl*)"},
    {"_ZN5clang13ASTDeclWriter12VisitVarDeclEPNS_7VarDeclE", "clang::ASTDeclWriter::VisitVarDecl(clang::VarDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitImplicitParamDeclEPNS_17ImplicitParamDeclE", "clang::ASTDeclWriter::VisitImplicitParamDecl(clang::ImplicitParamDecl*)"},
    {"_ZN5clang13ASTDeclWriter16VisitParmVarDeclEPNS_11ParmVarDeclE", "clang::ASTDeclWriter::VisitParmVarDecl(clang::ParmVarDecl*)"},
    {"_ZN5clang13ASTDeclWriter21VisitFileScopeAsmDeclEPNS_16FileScopeAsmDeclE", "clang::ASTDeclWriter::VisitFileScopeAsmDecl(clang::FileScopeAsmDecl*)"},
    {"_ZN5clang13ASTDeclWriter14VisitBlockDeclEPNS_9BlockDeclE", "clang::ASTDeclWriter::VisitBlockDecl(clang::BlockDecl*)"},
    {"_ZN5clang13ASTDeclWriter20VisitLinkageSpecDeclEPNS_15LinkageSpecDeclE", "clang::ASTDeclWriter::VisitLinkageSpecDecl(clang::LinkageSpecDecl*)"},
    {"_ZN5clang13ASTDeclWriter18VisitNamespaceDeclEPNS_13NamespaceDeclE", "clang::ASTDeclWriter::VisitNamespaceDecl(clang::NamespaceDecl*)"},
    {"_ZN5clang13ASTDeclWriter23VisitNamespaceAliasDeclEPNS_18NamespaceAliasDeclE", "clang::ASTDeclWriter::VisitNamespaceAliasDecl(clang::NamespaceAliasDecl*)"},
    {"_ZN5clang13ASTDeclWriter14VisitUsingDeclEPNS_9UsingDeclE", "clang::ASTDeclWriter::VisitUsingDecl(clang::UsingDecl*)"},
    {"_ZN5clang13ASTDeclWriter20VisitUsingShadowDeclEPNS_15UsingShadowDeclE", "clang::ASTDeclWriter::VisitUsingShadowDecl(clang::UsingShadowDecl*)"},
    {"_ZN5clang13ASTDeclWriter23VisitUsingDirectiveDeclEPNS_18UsingDirectiveDeclE", "clang::ASTDeclWriter::VisitUsingDirectiveDecl(clang::UsingDirectiveDecl*)"},
    {"_ZN5clang13ASTDeclWriter29VisitUnresolvedUsingValueDeclEPNS_24UnresolvedUsingValueDeclE", "clang::ASTDeclWriter::VisitUnresolvedUsingValueDecl(clang::UnresolvedUsingValueDecl*)"},
    {"_ZN5clang13ASTDeclWriter32VisitUnresolvedUsingTypenameDeclEPNS_27UnresolvedUsingTypenameDeclE", "clang::ASTDeclWriter::VisitUnresolvedUsingTypenameDecl(clang::UnresolvedUsingTypenameDecl*)"},
    {"_ZN5clang13ASTDeclWriter18VisitCXXRecordDeclEPNS_13CXXRecordDeclE", "clang::ASTDeclWriter::VisitCXXRecordDecl(clang::CXXRecordDecl*)"},
    {"_ZN5clang13ASTDeclWriter18VisitCXXMethodDeclEPNS_13CXXMethodDeclE", "clang::ASTDeclWriter::VisitCXXMethodDecl(clang::CXXMethodDecl*)"},
    {"_ZN5clang13ASTDeclWriter23VisitCXXConstructorDeclEPNS_18CXXConstructorDeclE", "clang::ASTDeclWriter::VisitCXXConstructorDecl(clang::CXXConstructorDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitCXXDestructorDeclEPNS_17CXXDestructorDeclE", "clang::ASTDeclWriter::VisitCXXDestructorDecl(clang::CXXDestructorDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitCXXConversionDeclEPNS_17CXXConversionDeclE", "clang::ASTDeclWriter::VisitCXXConversionDecl(clang::CXXConversionDecl*)"},
    {"_ZN5clang13ASTDeclWriter19VisitAccessSpecDeclEPNS_14AccessSpecDeclE", "clang::ASTDeclWriter::VisitAccessSpecDecl(clang::AccessSpecDecl*)"},
    {"_ZN5clang13ASTDeclWriter15VisitFriendDeclEPNS_10FriendDeclE", "clang::ASTDeclWriter::VisitFriendDecl(clang::FriendDecl*)"},
    {"_ZN5clang13ASTDeclWriter23VisitFriendTemplateDeclEPNS_18FriendTemplateDeclE", "clang::ASTDeclWriter::VisitFriendTemplateDecl(clang::FriendTemplateDecl*)"},
    {"_ZN5clang13ASTDeclWriter17VisitTemplateDeclEPNS_12TemplateDeclE", "clang::ASTDeclWriter::VisitTemplateDecl(clang::TemplateDecl*)"},
    {"_ZN5clang13ASTDeclWriter29VisitRedeclarableTemplateDeclEPNS_24RedeclarableTemplateDeclE", "clang::ASTDeclWriter::VisitRedeclarableTemplateDecl(clang::RedeclarableTemplateDecl*)"},
    {"_ZN5clang13ASTDeclWriter22VisitClassTemplateDeclEPNS_17ClassTemplateDeclE", "clang::ASTDeclWriter::VisitClassTemplateDecl(clang::ClassTemplateDecl*)"},
    {"_ZN5clang13ASTDeclWriter36VisitClassTemplateSpecializationDeclEPNS_31ClassTemplateSpecializationDeclE", "clang::ASTDeclWriter::VisitClassTemplateSpecializationDecl(clang::ClassTemplateSpecializationDecl*)"},
    {"_ZN5clang13ASTDeclWriter43VisitClassTemplatePartialSpecializationDeclEPNS_38ClassTemplatePartialSpecializationDeclE", "clang::ASTDeclWriter::VisitClassTemplatePartialSpecializationDecl(clang::ClassTemplatePartialSpecializationDecl*)"},
    {"_ZN5clang13ASTDeclWriter25VisitFunctionTemplateDeclEPNS_20FunctionTemplateDeclE", "clang::ASTDeclWriter::VisitFunctionTemplateDecl(clang::FunctionTemplateDecl*)"},
    {"_ZN5clang13ASTDeclWriter25VisitTemplateTypeParmDeclEPNS_20TemplateTypeParmDeclE", "clang::ASTDeclWriter::VisitTemplateTypeParmDecl(clang::TemplateTypeParmDecl*)"},
    {"_ZN5clang13ASTDeclWriter28VisitNonTypeTemplateParmDeclEPNS_23NonTypeTemplateParmDeclE", "clang::ASTDeclWriter::VisitNonTypeTemplateParmDecl(clang::NonTypeTemplateParmDecl*)"},
    {"_ZN5clang13ASTDeclWriter29VisitTemplateTemplateParmDeclEPNS_24TemplateTemplateParmDeclE", "clang::ASTDeclWriter::VisitTemplateTemplateParmDecl(clang::TemplateTemplateParmDecl*)"},
    {"_ZN5clang13ASTDeclWriter21VisitStaticAssertDeclEPNS_16StaticAssertDeclE", "clang::ASTDeclWriter::VisitStaticAssertDecl(clang::StaticAssertDecl*)"},
    {"_ZN5clang13ASTDeclWriter16VisitDeclContextEPNS_11DeclContextEyy", "clang::ASTDeclWriter::VisitDeclContext(clang::DeclContext*, unsigned long long, unsigned long long)"},
    {"_ZN5clang9ASTWriter22WriteDeclsBlockAbbrevsEv", "clang::ASTWriter::WriteDeclsBlockAbbrevs()"},
    {"_ZN5clang9ASTWriter9WriteDeclERNS_10ASTContextEPNS_4DeclE", "clang::ASTWriter::WriteDecl(clang::ASTContext&, clang::Decl*)"},
    {"_ZN5clang11DeclVisitorINS_13ASTDeclWriterEvE5VisitEPNS_4DeclE", "clang::DeclVisitor<clang::ASTDeclWriter, void>::Visit(clang::Decl*)"},
    {"_ZN5clang13ASTDeclWriter17VisitRedeclarableINS_7TagDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclWriter::VisitRedeclarable<clang::TagDecl>(clang::Redeclarable<clang::TagDecl>*)"},
    {"_ZN5clang13ASTDeclWriter17VisitRedeclarableINS_12FunctionDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclWriter::VisitRedeclarable<clang::FunctionDecl>(clang::Redeclarable<clang::FunctionDecl>*)"},
    {"_ZN5clang13ASTDeclWriter17VisitRedeclarableINS_7VarDeclEEEvPNS_12RedeclarableIT_EE", "void clang::ASTDeclWriter::VisitRedeclarable<clang::VarDecl>(clang::Redeclarable<clang::VarDecl>*)"},
    {"_ZN5clang13ASTStmtWriter31AddExplicitTemplateArgumentListERKNS_28ExplicitTemplateArgumentListE", "clang::ASTStmtWriter::AddExplicitTemplateArgumentList(clang::ExplicitTemplateArgumentList const&)"},
    {"_ZN5clang13ASTStmtWriter9VisitStmtEPNS_4StmtE", "clang::ASTStmtWriter::VisitStmt(clang::Stmt*)"},
    {"_ZN5clang13ASTStmtWriter13VisitNullStmtEPNS_8NullStmtE", "clang::ASTStmtWriter::VisitNullStmt(clang::NullStmt*)"},
    {"_ZN5clang13ASTStmtWriter17VisitCompoundStmtEPNS_12CompoundStmtE", "clang::ASTStmtWriter::VisitCompoundStmt(clang::CompoundStmt*)"},
    {"_ZN5clang13ASTStmtWriter15VisitSwitchCaseEPNS_10SwitchCaseE", "clang::ASTStmtWriter::VisitSwitchCase(clang::SwitchCase*)"},
    {"_ZN5clang9ASTWriter15getSwitchCaseIDEPNS_10SwitchCaseE", "clang::ASTWriter::getSwitchCaseID(clang::SwitchCase*)"},
    {"_ZN5clang13ASTStmtWriter13VisitCaseStmtEPNS_8CaseStmtE", "clang::ASTStmtWriter::VisitCaseStmt(clang::CaseStmt*)"},
    {"_ZN5clang13ASTStmtWriter16VisitDefaultStmtEPNS_11DefaultStmtE", "clang::ASTStmtWriter::VisitDefaultStmt(clang::DefaultStmt*)"},
    {"_ZN5clang13ASTStmtWriter14VisitLabelStmtEPNS_9LabelStmtE", "clang::ASTStmtWriter::VisitLabelStmt(clang::LabelStmt*)"},
    {"_ZN5clang9ASTWriter10GetLabelIDEPNS_9LabelStmtE", "clang::ASTWriter::GetLabelID(clang::LabelStmt*)"},
    {"_ZN5clang13ASTStmtWriter11VisitIfStmtEPNS_6IfStmtE", "clang::ASTStmtWriter::VisitIfStmt(clang::IfStmt*)"},
    {"_ZN5clang13ASTStmtWriter15VisitSwitchStmtEPNS_10SwitchStmtE", "clang::ASTStmtWriter::VisitSwitchStmt(clang::SwitchStmt*)"},
    {"_ZN5clang9ASTWriter18RecordSwitchCaseIDEPNS_10SwitchCaseE", "clang::ASTWriter::RecordSwitchCaseID(clang::SwitchCase*)"},
    {"_ZN5clang13ASTStmtWriter14VisitWhileStmtEPNS_9WhileStmtE", "clang::ASTStmtWriter::VisitWhileStmt(clang::WhileStmt*)"},
    {"_ZN5clang13ASTStmtWriter11VisitDoStmtEPNS_6DoStmtE", "clang::ASTStmtWriter::VisitDoStmt(clang::DoStmt*)"},
    {"_ZN5clang13ASTStmtWriter12VisitForStmtEPNS_7ForStmtE", "clang::ASTStmtWriter::VisitForStmt(clang::ForStmt*)"},
    {"_ZN5clang13ASTStmtWriter13VisitGotoStmtEPNS_8GotoStmtE", "clang::ASTStmtWriter::VisitGotoStmt(clang::GotoStmt*)"},
    {"_ZN5clang13ASTStmtWriter21VisitIndirectGotoStmtEPNS_16IndirectGotoStmtE", "clang::ASTStmtWriter::VisitIndirectGotoStmt(clang::IndirectGotoStmt*)"},
    {"_ZN5clang13ASTStmtWriter17VisitContinueStmtEPNS_12ContinueStmtE", "clang::ASTStmtWriter::VisitContinueStmt(clang::ContinueStmt*)"},
    {"_ZN5clang13ASTStmtWriter14VisitBreakStmtEPNS_9BreakStmtE", "clang::ASTStmtWriter::VisitBreakStmt(clang::BreakStmt*)"},
    {"_ZN5clang13ASTStmtWriter15VisitReturnStmtEPNS_10ReturnStmtE", "clang::ASTStmtWriter::VisitReturnStmt(clang::ReturnStmt*)"},
    {"_ZN5clang13ASTStmtWriter13VisitDeclStmtEPNS_8DeclStmtE", "clang::ASTStmtWriter::VisitDeclStmt(clang::DeclStmt*)"},
    {"_ZN5clang13ASTStmtWriter12VisitAsmStmtEPNS_7AsmStmtE", "clang::ASTStmtWriter::VisitAsmStmt(clang::AsmStmt*)"},
    {"_ZN5clang13ASTStmtWriter9VisitExprEPNS_4ExprE", "clang::ASTStmtWriter::VisitExpr(clang::Expr*)"},
    {"_ZN5clang13ASTStmtWriter19VisitPredefinedExprEPNS_14PredefinedExprE", "clang::ASTStmtWriter::VisitPredefinedExpr(clang::PredefinedExpr*)"},
    {"_ZN5clang13ASTStmtWriter16VisitDeclRefExprEPNS_11DeclRefExprE", "clang::ASTStmtWriter::VisitDeclRefExpr(clang::DeclRefExpr*)"},
    {"_ZN5clang13ASTStmtWriter19VisitIntegerLiteralEPNS_14IntegerLiteralE", "clang::ASTStmtWriter::VisitIntegerLiteral(clang::IntegerLiteral*)"},
    {"_ZN5clang13ASTStmtWriter20VisitFloatingLiteralEPNS_15FloatingLiteralE", "clang::ASTStmtWriter::VisitFloatingLiteral(clang::FloatingLiteral*)"},
    {"_ZN5clang13ASTStmtWriter21VisitImaginaryLiteralEPNS_16ImaginaryLiteralE", "clang::ASTStmtWriter::VisitImaginaryLiteral(clang::ImaginaryLiteral*)"},
    {"_ZN5clang13ASTStmtWriter18VisitStringLiteralEPNS_13StringLiteralE", "clang::ASTStmtWriter::VisitStringLiteral(clang::StringLiteral*)"},
    {"_ZN5clang13ASTStmtWriter21VisitCharacterLiteralEPNS_16CharacterLiteralE", "clang::ASTStmtWriter::VisitCharacterLiteral(clang::CharacterLiteral*)"},
    {"_ZN5clang13ASTStmtWriter14VisitParenExprEPNS_9ParenExprE", "clang::ASTStmtWriter::VisitParenExpr(clang::ParenExpr*)"},
    {"_ZN5clang13ASTStmtWriter18VisitParenListExprEPNS_13ParenListExprE", "clang::ASTStmtWriter::VisitParenListExpr(clang::ParenListExpr*)"},
    {"_ZN5clang13ASTStmtWriter18VisitUnaryOperatorEPNS_13UnaryOperatorE", "clang::ASTStmtWriter::VisitUnaryOperator(clang::UnaryOperator*)"},
    {"_ZN5clang13ASTStmtWriter17VisitOffsetOfExprEPNS_12OffsetOfExprE", "clang::ASTStmtWriter::VisitOffsetOfExpr(clang::OffsetOfExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitSizeOfAlignOfExprEPNS_17SizeOfAlignOfExprE", "clang::ASTStmtWriter::VisitSizeOfAlignOfExpr(clang::SizeOfAlignOfExpr*)"},
    {"_ZN5clang13ASTStmtWriter23VisitArraySubscriptExprEPNS_18ArraySubscriptExprE", "clang::ASTStmtWriter::VisitArraySubscriptExpr(clang::ArraySubscriptExpr*)"},
    {"_ZN5clang13ASTStmtWriter13VisitCallExprEPNS_8CallExprE", "clang::ASTStmtWriter::VisitCallExpr(clang::CallExpr*)"},
    {"_ZN5clang13ASTStmtWriter15VisitMemberExprEPNS_10MemberExprE", "clang::ASTStmtWriter::VisitMemberExpr(clang::MemberExpr*)"},
    {"_ZN5clang13ASTStmtWriter16VisitObjCIsaExprEPNS_11ObjCIsaExprE", "clang::ASTStmtWriter::VisitObjCIsaExpr(clang::ObjCIsaExpr*)"},
    {"_ZN5clang13ASTStmtWriter13VisitCastExprEPNS_8CastExprE", "clang::ASTStmtWriter::VisitCastExpr(clang::CastExpr*)"},
    {"_ZN5clang13ASTStmtWriter19VisitBinaryOperatorEPNS_14BinaryOperatorE", "clang::ASTStmtWriter::VisitBinaryOperator(clang::BinaryOperator*)"},
    {"_ZN5clang13ASTStmtWriter27VisitCompoundAssignOperatorEPNS_22CompoundAssignOperatorE", "clang::ASTStmtWriter::VisitCompoundAssignOperator(clang::CompoundAssignOperator*)"},
    {"_ZN5clang13ASTStmtWriter24VisitConditionalOperatorEPNS_19ConditionalOperatorE", "clang::ASTStmtWriter::VisitConditionalOperator(clang::ConditionalOperator*)"},
    {"_ZN5clang13ASTStmtWriter21VisitImplicitCastExprEPNS_16ImplicitCastExprE", "clang::ASTStmtWriter::VisitImplicitCastExpr(clang::ImplicitCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitExplicitCastExprEPNS_16ExplicitCastExprE", "clang::ASTStmtWriter::VisitExplicitCastExpr(clang::ExplicitCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter19VisitCStyleCastExprEPNS_14CStyleCastExprE", "clang::ASTStmtWriter::VisitCStyleCastExpr(clang::CStyleCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter24VisitCompoundLiteralExprEPNS_19CompoundLiteralExprE", "clang::ASTStmtWriter::VisitCompoundLiteralExpr(clang::CompoundLiteralExpr*)"},
    {"_ZN5clang13ASTStmtWriter25VisitExtVectorElementExprEPNS_20ExtVectorElementExprE", "clang::ASTStmtWriter::VisitExtVectorElementExpr(clang::ExtVectorElementExpr*)"},
    {"_ZN5clang13ASTStmtWriter17VisitInitListExprEPNS_12InitListExprE", "clang::ASTStmtWriter::VisitInitListExpr(clang::InitListExpr*)"},
    {"_ZN5clang13ASTStmtWriter23VisitDesignatedInitExprEPNS_18DesignatedInitExprE", "clang::ASTStmtWriter::VisitDesignatedInitExpr(clang::DesignatedInitExpr*)"},
    {"_ZN5clang13ASTStmtWriter26VisitImplicitValueInitExprEPNS_21ImplicitValueInitExprE", "clang::ASTStmtWriter::VisitImplicitValueInitExpr(clang::ImplicitValueInitExpr*)"},
    {"_ZN5clang13ASTStmtWriter14VisitVAArgExprEPNS_9VAArgExprE", "clang::ASTStmtWriter::VisitVAArgExpr(clang::VAArgExpr*)"},
    {"_ZN5clang13ASTStmtWriter18VisitAddrLabelExprEPNS_13AddrLabelExprE", "clang::ASTStmtWriter::VisitAddrLabelExpr(clang::AddrLabelExpr*)"},
    {"_ZN5clang13ASTStmtWriter13VisitStmtExprEPNS_8StmtExprE", "clang::ASTStmtWriter::VisitStmtExpr(clang::StmtExpr*)"},
    {"_ZN5clang13ASTStmtWriter15VisitChooseExprEPNS_10ChooseExprE", "clang::ASTStmtWriter::VisitChooseExpr(clang::ChooseExpr*)"},
    {"_ZN5clang13ASTStmtWriter16VisitGNUNullExprEPNS_11GNUNullExprE", "clang::ASTStmtWriter::VisitGNUNullExpr(clang::GNUNullExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitShuffleVectorExprEPNS_17ShuffleVectorExprE", "clang::ASTStmtWriter::VisitShuffleVectorExpr(clang::ShuffleVectorExpr*)"},
    {"_ZN5clang13ASTStmtWriter14VisitBlockExprEPNS_9BlockExprE", "clang::ASTStmtWriter::VisitBlockExpr(clang::BlockExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitBlockDeclRefExprEPNS_16BlockDeclRefExprE", "clang::ASTStmtWriter::VisitBlockDeclRefExpr(clang::BlockDeclRefExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitObjCStringLiteralEPNS_17ObjCStringLiteralE", "clang::ASTStmtWriter::VisitObjCStringLiteral(clang::ObjCStringLiteral*)"},
    {"_ZN5clang13ASTStmtWriter19VisitObjCEncodeExprEPNS_14ObjCEncodeExprE", "clang::ASTStmtWriter::VisitObjCEncodeExpr(clang::ObjCEncodeExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitObjCSelectorExprEPNS_16ObjCSelectorExprE", "clang::ASTStmtWriter::VisitObjCSelectorExpr(clang::ObjCSelectorExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitObjCProtocolExprEPNS_16ObjCProtocolExprE", "clang::ASTStmtWriter::VisitObjCProtocolExpr(clang::ObjCProtocolExpr*)"},
    {"_ZN5clang13ASTStmtWriter20VisitObjCIvarRefExprEPNS_15ObjCIvarRefExprE", "clang::ASTStmtWriter::VisitObjCIvarRefExpr(clang::ObjCIvarRefExpr*)"},
    {"_ZN5clang13ASTStmtWriter24VisitObjCPropertyRefExprEPNS_19ObjCPropertyRefExprE", "clang::ASTStmtWriter::VisitObjCPropertyRefExpr(clang::ObjCPropertyRefExpr*)"},
    {"_ZN5clang13ASTStmtWriter20VisitObjCMessageExprEPNS_15ObjCMessageExprE", "clang::ASTStmtWriter::VisitObjCMessageExpr(clang::ObjCMessageExpr*)"},
    {"_ZN5clang13ASTStmtWriter26VisitObjCForCollectionStmtEPNS_21ObjCForCollectionStmtE", "clang::ASTStmtWriter::VisitObjCForCollectionStmt(clang::ObjCForCollectionStmt*)"},
    {"_ZN5clang13ASTStmtWriter20VisitObjCAtCatchStmtEPNS_15ObjCAtCatchStmtE", "clang::ASTStmtWriter::VisitObjCAtCatchStmt(clang::ObjCAtCatchStmt*)"},
    {"_ZN5clang13ASTStmtWriter22VisitObjCAtFinallyStmtEPNS_17ObjCAtFinallyStmtE", "clang::ASTStmtWriter::VisitObjCAtFinallyStmt(clang::ObjCAtFinallyStmt*)"},
    {"_ZN5clang13ASTStmtWriter18VisitObjCAtTryStmtEPNS_13ObjCAtTryStmtE", "clang::ASTStmtWriter::VisitObjCAtTryStmt(clang::ObjCAtTryStmt*)"},
    {"_ZN5clang13ASTStmtWriter27VisitObjCAtSynchronizedStmtEPNS_22ObjCAtSynchronizedStmtE", "clang::ASTStmtWriter::VisitObjCAtSynchronizedStmt(clang::ObjCAtSynchronizedStmt*)"},
    {"_ZN5clang13ASTStmtWriter20VisitObjCAtThrowStmtEPNS_15ObjCAtThrowStmtE", "clang::ASTStmtWriter::VisitObjCAtThrowStmt(clang::ObjCAtThrowStmt*)"},
    {"_ZN5clang13ASTStmtWriter17VisitCXXCatchStmtEPNS_12CXXCatchStmtE", "clang::ASTStmtWriter::VisitCXXCatchStmt(clang::CXXCatchStmt*)"},
    {"_ZN5clang13ASTStmtWriter15VisitCXXTryStmtEPNS_10CXXTryStmtE", "clang::ASTStmtWriter::VisitCXXTryStmt(clang::CXXTryStmt*)"},
    {"_ZN5clang13ASTStmtWriter24VisitCXXOperatorCallExprEPNS_19CXXOperatorCallExprE", "clang::ASTStmtWriter::VisitCXXOperatorCallExpr(clang::CXXOperatorCallExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitCXXMemberCallExprEPNS_17CXXMemberCallExprE", "clang::ASTStmtWriter::VisitCXXMemberCallExpr(clang::CXXMemberCallExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitCXXConstructExprEPNS_16CXXConstructExprE", "clang::ASTStmtWriter::VisitCXXConstructExpr(clang::CXXConstructExpr*)"},
    {"_ZN5clang13ASTStmtWriter27VisitCXXTemporaryObjectExprEPNS_22CXXTemporaryObjectExprE", "clang::ASTStmtWriter::VisitCXXTemporaryObjectExpr(clang::CXXTemporaryObjectExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitCXXNamedCastExprEPNS_16CXXNamedCastExprE", "clang::ASTStmtWriter::VisitCXXNamedCastExpr(clang::CXXNamedCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitCXXStaticCastExprEPNS_17CXXStaticCastExprE", "clang::ASTStmtWriter::VisitCXXStaticCastExpr(clang::CXXStaticCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter23VisitCXXDynamicCastExprEPNS_18CXXDynamicCastExprE", "clang::ASTStmtWriter::VisitCXXDynamicCastExpr(clang::CXXDynamicCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter27VisitCXXReinterpretCastExprEPNS_22CXXReinterpretCastExprE", "clang::ASTStmtWriter::VisitCXXReinterpretCastExpr(clang::CXXReinterpretCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitCXXConstCastExprEPNS_16CXXConstCastExprE", "clang::ASTStmtWriter::VisitCXXConstCastExpr(clang::CXXConstCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter26VisitCXXFunctionalCastExprEPNS_21CXXFunctionalCastExprE", "clang::ASTStmtWriter::VisitCXXFunctionalCastExpr(clang::CXXFunctionalCastExpr*)"},
    {"_ZN5clang13ASTStmtWriter23VisitCXXBoolLiteralExprEPNS_18CXXBoolLiteralExprE", "clang::ASTStmtWriter::VisitCXXBoolLiteralExpr(clang::CXXBoolLiteralExpr*)"},
    {"_ZN5clang13ASTStmtWriter26VisitCXXNullPtrLiteralExprEPNS_21CXXNullPtrLiteralExprE", "clang::ASTStmtWriter::VisitCXXNullPtrLiteralExpr(clang::CXXNullPtrLiteralExpr*)"},
    {"_ZN5clang13ASTStmtWriter18VisitCXXTypeidExprEPNS_13CXXTypeidExprE", "clang::ASTStmtWriter::VisitCXXTypeidExpr(clang::CXXTypeidExpr*)"},
    {"_ZN5clang13ASTStmtWriter18VisitCXXUuidofExprEPNS_13CXXUuidofExprE", "clang::ASTStmtWriter::VisitCXXUuidofExpr(clang::CXXUuidofExpr*)"},
    {"_ZN5clang13ASTStmtWriter16VisitCXXThisExprEPNS_11CXXThisExprE", "clang::ASTStmtWriter::VisitCXXThisExpr(clang::CXXThisExpr*)"},
    {"_ZN5clang13ASTStmtWriter17VisitCXXThrowExprEPNS_12CXXThrowExprE", "clang::ASTStmtWriter::VisitCXXThrowExpr(clang::CXXThrowExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitCXXDefaultArgExprEPNS_17CXXDefaultArgExprE", "clang::ASTStmtWriter::VisitCXXDefaultArgExpr(clang::CXXDefaultArgExpr*)"},
    {"_ZN5clang13ASTStmtWriter25VisitCXXBindTemporaryExprEPNS_20CXXBindTemporaryExprE", "clang::ASTStmtWriter::VisitCXXBindTemporaryExpr(clang::CXXBindTemporaryExpr*)"},
    {"_ZN5clang13ASTStmtWriter27VisitCXXScalarValueInitExprEPNS_22CXXScalarValueInitExprE", "clang::ASTStmtWriter::VisitCXXScalarValueInitExpr(clang::CXXScalarValueInitExpr*)"},
    {"_ZN5clang13ASTStmtWriter15VisitCXXNewExprEPNS_10CXXNewExprE", "clang::ASTStmtWriter::VisitCXXNewExpr(clang::CXXNewExpr*)"},
    {"_ZN5clang13ASTStmtWriter18VisitCXXDeleteExprEPNS_13CXXDeleteExprE", "clang::ASTStmtWriter::VisitCXXDeleteExpr(clang::CXXDeleteExpr*)"},
    {"_ZN5clang13ASTStmtWriter28VisitCXXPseudoDestructorExprEPNS_23CXXPseudoDestructorExprE", "clang::ASTStmtWriter::VisitCXXPseudoDestructorExpr(clang::CXXPseudoDestructorExpr*)"},
    {"_ZN5clang13ASTStmtWriter21VisitExprWithCleanupsEPNS_16ExprWithCleanupsE", "clang::ASTStmtWriter::VisitExprWithCleanups(clang::ExprWithCleanups*)"},
    {"_ZN5clang13ASTStmtWriter32VisitCXXDependentScopeMemberExprEPNS_27CXXDependentScopeMemberExprE", "clang::ASTStmtWriter::VisitCXXDependentScopeMemberExpr(clang::CXXDependentScopeMemberExpr*)"},
    {"_ZN5clang13ASTStmtWriter30VisitDependentScopeDeclRefExprEPNS_25DependentScopeDeclRefExprE", "clang::ASTStmtWriter::VisitDependentScopeDeclRefExpr(clang::DependentScopeDeclRefExpr*)"},
    {"_ZN5clang13ASTStmtWriter31VisitCXXUnresolvedConstructExprEPNS_26CXXUnresolvedConstructExprE", "clang::ASTStmtWriter::VisitCXXUnresolvedConstructExpr(clang::CXXUnresolvedConstructExpr*)"},
    {"_ZN5clang13ASTStmtWriter17VisitOverloadExprEPNS_12OverloadExprE", "clang::ASTStmtWriter::VisitOverloadExpr(clang::OverloadExpr*)"},
    {"_ZN5clang13ASTStmtWriter25VisitUnresolvedMemberExprEPNS_20UnresolvedMemberExprE", "clang::ASTStmtWriter::VisitUnresolvedMemberExpr(clang::UnresolvedMemberExpr*)"},
    {"_ZN5clang13ASTStmtWriter25VisitUnresolvedLookupExprEPNS_20UnresolvedLookupExprE", "clang::ASTStmtWriter::VisitUnresolvedLookupExpr(clang::UnresolvedLookupExpr*)"},
    {"_ZN5clang13ASTStmtWriter23VisitUnaryTypeTraitExprEPNS_18UnaryTypeTraitExprE", "clang::ASTStmtWriter::VisitUnaryTypeTraitExpr(clang::UnaryTypeTraitExpr*)"},
    {"_ZN5clang13ASTStmtWriter24VisitBinaryTypeTraitExprEPNS_19BinaryTypeTraitExprE", "clang::ASTStmtWriter::VisitBinaryTypeTraitExpr(clang::BinaryTypeTraitExpr*)"},
    {"_ZN5clang13ASTStmtWriter20VisitCXXNoexceptExprEPNS_15CXXNoexceptExprE", "clang::ASTStmtWriter::VisitCXXNoexceptExpr(clang::CXXNoexceptExpr*)"},
    {"_ZN5clang13ASTStmtWriter22VisitPackExpansionExprEPNS_17PackExpansionExprE", "clang::ASTStmtWriter::VisitPackExpansionExpr(clang::PackExpansionExpr*)"},
    {"_ZN5clang13ASTStmtWriter19VisitSizeOfPackExprEPNS_14SizeOfPackExprE", "clang::ASTStmtWriter::VisitSizeOfPackExpr(clang::SizeOfPackExpr*)"},
    {"_ZN5clang13ASTStmtWriter37VisitSubstNonTypeTemplateParmPackExprEPNS_32SubstNonTypeTemplateParmPackExprE", "clang::ASTStmtWriter::VisitSubstNonTypeTemplateParmPackExpr(clang::SubstNonTypeTemplateParmPackExpr*)"},
    {"_ZN5clang13ASTStmtWriter20VisitOpaqueValueExprEPNS_15OpaqueValueExprE", "clang::ASTStmtWriter::VisitOpaqueValueExpr(clang::OpaqueValueExpr*)"},
    {"_ZN5clang13ASTStmtWriter23VisitCUDAKernelCallExprEPNS_18CUDAKernelCallExprE", "clang::ASTStmtWriter::VisitCUDAKernelCallExpr(clang::CUDAKernelCallExpr*)"},
    {"_ZN5clang9ASTWriter18ClearSwitchCaseIDsEv", "clang::ASTWriter::ClearSwitchCaseIDs()"},
    {"_ZN5clang9ASTWriter12WriteSubStmtEPNS_4StmtE", "clang::ASTWriter::WriteSubStmt(clang::Stmt*)"},
    {"_ZN5clang9ASTWriter10FlushStmtsEv", "clang::ASTWriter::FlushStmts()"},
    {"_ZN5clang11StmtVisitorINS_13ASTStmtWriterEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<clang::ASTStmtWriter, void>::Visit(clang::Stmt*)"},
    {"_ZNSt8_Rb_treeIPN5clang9LabelStmtESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS5_ERKS5_", "std::_Rb_tree<clang::LabelStmt*, std::pair<clang::LabelStmt* const, unsigned int>, std::_Select1st<std::pair<clang::LabelStmt* const, unsigned int> >, std::less<clang::LabelStmt*>, std::allocator<std::pair<clang::LabelStmt* const, unsigned int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::LabelStmt* const, unsigned int> >, std::pair<clang::LabelStmt* const, unsigned int> const&)"},
    {"_ZNSt8_Rb_treeIPN5clang9LabelStmtESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE16_M_insert_uniqueERKS5_", "std::_Rb_tree<clang::LabelStmt*, std::pair<clang::LabelStmt* const, unsigned int>, std::_Select1st<std::pair<clang::LabelStmt* const, unsigned int> >, std::less<clang::LabelStmt*>, std::allocator<std::pair<clang::LabelStmt* const, unsigned int> > >::_M_insert_unique(std::pair<clang::LabelStmt* const, unsigned int> const&)"},
    {"_ZNSt8_Rb_treeIPN5clang10SwitchCaseESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS5_ERKS5_", "std::_Rb_tree<clang::SwitchCase*, std::pair<clang::SwitchCase* const, unsigned int>, std::_Select1st<std::pair<clang::SwitchCase* const, unsigned int> >, std::less<clang::SwitchCase*>, std::allocator<std::pair<clang::SwitchCase* const, unsigned int> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::SwitchCase* const, unsigned int> >, std::pair<clang::SwitchCase* const, unsigned int> const&)"},
    {"_ZNSt8_Rb_treeIPN5clang10SwitchCaseESt4pairIKS2_jESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE16_M_insert_uniqueERKS5_", "std::_Rb_tree<clang::SwitchCase*, std::pair<clang::SwitchCase* const, unsigned int>, std::_Select1st<std::pair<clang::SwitchCase* const, unsigned int> >, std::less<clang::SwitchCase*>, std::allocator<std::pair<clang::SwitchCase* const, unsigned int> > >::_M_insert_unique(std::pair<clang::SwitchCase* const, unsigned int> const&)"},
    {"_ZN5clang12PCHGeneratorC1ERKNS_12PreprocessorEbPKcPN4llvm11raw_ostreamE", "clang::PCHGenerator::PCHGenerator(clang::Preprocessor const&, bool, char const*, llvm::raw_ostream*)"},
    {"_ZN5clang12PCHGeneratorC2ERKNS_12PreprocessorEbPKcPN4llvm11raw_ostreamE", "clang::PCHGenerator::PCHGenerator(clang::Preprocessor const&, bool, char const*, llvm::raw_ostream*)"},
    {"_ZN5clang12PCHGenerator21HandleTranslationUnitERNS_10ASTContextE", "clang::PCHGenerator::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN5clang12PCHGenerator22GetASTMutationListenerEv", "clang::PCHGenerator::GetASTMutationListener()"},
    {"_ZN5clang12PCHGenerator27GetASTSerializationListenerEv", "clang::PCHGenerator::GetASTSerializationListener()"},
    {"_ZN5clang12PCHGenerator29GetASTDeserializationListenerEv", "clang::PCHGenerator::GetASTDeserializationListener()"},
    {"_ZN5clang17EmitBackendOutputERNS_10DiagnosticERKNS_14CodeGenOptionsERKNS_13TargetOptionsEPN4llvm6ModuleENS_13BackendActionEPNS8_11raw_ostreamE", "clang::EmitBackendOutput(clang::Diagnostic&, clang::CodeGenOptions const&, clang::TargetOptions const&, llvm::Module*, clang::BackendAction, llvm::raw_ostream*)"},
    {"_ZN5clang7CodeGen11CGBlockInfoC1EPKNS_9BlockExprEPKc", "clang::CodeGen::CGBlockInfo::CGBlockInfo(clang::BlockExpr const*, char const*)"},
    {"_ZN5clang7CodeGen11CGBlockInfoC2EPKNS_9BlockExprEPKc", "clang::CodeGen::CGBlockInfo::CGBlockInfo(clang::BlockExpr const*, char const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitBlockLiteralEPKNS_9BlockExprE", "clang::CodeGen::CodeGenFunction::EmitBlockLiteral(clang::BlockExpr const*)"},
    {"_Z16computeBlockInfoRN5clang7CodeGen13CodeGenModuleERNS0_11CGBlockInfoE", "computeBlockInfo(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21GenerateBlockFunctionENS0_10GlobalDeclERKNS0_11CGBlockInfoEPKNS_4DeclERKN4llvm8DenseMapIS8_PNS9_5ValueENS9_12DenseMapInfoIS8_EENSD_ISC_EEEE", "clang::CodeGen::CodeGenFunction::GenerateBlockFunction(clang::CodeGen::GlobalDecl, clang::CodeGen::CGBlockInfo const&, clang::Decl const*, llvm::DenseMap<clang::Decl const*, llvm::Value*, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::Value*> > const&)"},
    {"_Z16buildGlobalBlockRN5clang7CodeGen13CodeGenModuleERKNS0_11CGBlockInfoEPN4llvm8ConstantE", "buildGlobalBlock(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&, llvm::Constant*)"},
    {"_Z20buildBlockDescriptorRN5clang7CodeGen13CodeGenModuleERKNS0_11CGBlockInfoE", "buildBlockDescriptor(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule22getBlockDescriptorTypeEv", "clang::CodeGen::CodeGenModule::getBlockDescriptorType()"},
    {"_ZN5clang7CodeGen13CodeGenModule26getGenericBlockLiteralTypeEv", "clang::CodeGen::CodeGenModule::getGenericBlockLiteralType()"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitBlockCallExprEPKNS_8CallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitBlockCallExpr(clang::CallExpr const*, clang::CodeGen::ReturnValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18GetAddrOfBlockDeclEPKNS_7VarDeclEb", "clang::CodeGen::CodeGenFunction::GetAddrOfBlockDecl(clang::VarDecl const*, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule20GetAddrOfGlobalBlockEPKNS_9BlockExprEPKc", "clang::CodeGen::CodeGenModule::GetAddrOfGlobalBlock(clang::BlockExpr const*, char const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26GenerateCopyHelperFunctionERKNS0_11CGBlockInfoE", "clang::CodeGen::CodeGenFunction::GenerateCopyHelperFunction(clang::CodeGen::CGBlockInfo const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction29GenerateDestroyHelperFunctionERKNS0_11CGBlockInfoE", "clang::CodeGen::CodeGenFunction::GenerateDestroyHelperFunction(clang::CodeGen::CGBlockInfo const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17BuildBlockReleaseEPN4llvm5ValueENS0_15BlockFieldFlagsE", "clang::CodeGen::CodeGenFunction::BuildBlockRelease(llvm::Value*, clang::CodeGen::BlockFieldFlags)"},
    {"_ZN5clang7CodeGen15CodeGenFunction31GeneratebyrefCopyHelperFunctionEPKN4llvm4TypeENS0_15BlockFieldFlagsEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::GeneratebyrefCopyHelperFunction(llvm::Type const*, clang::CodeGen::BlockFieldFlags, clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction34GeneratebyrefDestroyHelperFunctionEPKN4llvm4TypeENS0_15BlockFieldFlagsEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::GeneratebyrefDestroyHelperFunction(llvm::Type const*, clang::CodeGen::BlockFieldFlags, clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule20BuildbyrefCopyHelperEPKN4llvm4TypeENS0_15BlockFieldFlagsEjPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::BuildbyrefCopyHelper(llvm::Type const*, clang::CodeGen::BlockFieldFlags, unsigned int, clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule23BuildbyrefDestroyHelperEPKN4llvm4TypeENS0_15BlockFieldFlagsEjPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::BuildbyrefDestroyHelper(llvm::Type const*, clang::CodeGen::BlockFieldFlags, unsigned int, clang::VarDecl const*)"},
    {"_ZSt21__inplace_stable_sortIPN12_GLOBAL__N_116BlockLayoutChunkEEvT_S3_", "void std::__inplace_stable_sort<(anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"},
    {"_ZSt22__stable_sort_adaptiveIPN12_GLOBAL__N_116BlockLayoutChunkES2_lEvT_S3_T0_T1_", "void std::__stable_sort_adaptive<(anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long)"},
    {"_ZSt24__merge_sort_with_bufferIPN12_GLOBAL__N_116BlockLayoutChunkES2_EvT_S3_T0_", "void std::__merge_sort_with_buffer<(anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"},
    {"_ZSt16__merge_adaptiveIPN12_GLOBAL__N_116BlockLayoutChunkElS2_EvT_S3_S3_T0_S4_T1_S4_", "void std::__merge_adaptive<(anonymous namespace)::BlockLayoutChunk*, long, (anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long, long, (anonymous namespace)::BlockLayoutChunk*, long)"},
    {"_ZSt13copy_backwardIPN12_GLOBAL__N_116BlockLayoutChunkES2_ET0_T_S4_S3_", "(anonymous namespace)::BlockLayoutChunk* std::copy_backward<(anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"},
    {"_ZSt6rotateIPN12_GLOBAL__N_116BlockLayoutChunkEEvT_S3_S3_", "void std::rotate<(anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"},
    {"_ZSt16__insertion_sortIPN12_GLOBAL__N_116BlockLayoutChunkEEvT_S3_", "void std::__insertion_sort<(anonymous namespace)::BlockLayoutChunk*>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*)"},
    {"_ZSt22__merge_without_bufferIPN12_GLOBAL__N_116BlockLayoutChunkElEvT_S3_S3_T0_S4_", "void std::__merge_without_buffer<(anonymous namespace)::BlockLayoutChunk*, long>((anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, (anonymous namespace)::BlockLayoutChunk*, long, long)"},
    {"_Z15hasMutableFieldPKN5clang13CXXRecordDeclE", "hasMutableField(clang::CXXRecordDecl const*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN12_GLOBAL__N_116BlockLayoutChunkELb0EE4growEm", "llvm::SmallVectorTemplateBase<(anonymous namespace)::BlockLayoutChunk, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIyPNS_8ConstantENS_12DenseMapInfoIyEENS3_IS2_EEE16InsertIntoBucketERKyRKS2_PSt4pairIyS2_E", "llvm::DenseMap<unsigned long long, llvm::Constant*, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<llvm::Constant*> >::InsertIntoBucket(unsigned long long const&, llvm::Constant* const&, std::pair<unsigned long long, llvm::Constant*>*)"},
    {"_ZN4llvm8DenseMapIyPNS_8ConstantENS_12DenseMapInfoIyEENS3_IS2_EEE4growEj", "llvm::DenseMap<unsigned long long, llvm::Constant*, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<llvm::Constant*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang7VarDeclENS1_7CodeGen11CGBlockInfo7CaptureENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::VarDecl const*, clang::CodeGen::CGBlockInfo::Capture, llvm::DenseMapInfo<clang::VarDecl const*>, llvm::DenseMapInfo<clang::CodeGen::CGBlockInfo::Capture> >::InsertIntoBucket(clang::VarDecl const* const&, clang::CodeGen::CGBlockInfo::Capture const&, std::pair<clang::VarDecl const*, clang::CodeGen::CGBlockInfo::Capture>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang7VarDeclENS1_7CodeGen11CGBlockInfo7CaptureENS_12DenseMapInfoIS4_EENS8_IS7_EEE4growEj", "llvm::DenseMap<clang::VarDecl const*, clang::CodeGen::CGBlockInfo::Capture, llvm::DenseMapInfo<clang::VarDecl const*>, llvm::DenseMapInfo<clang::CodeGen::CGBlockInfo::Capture> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitBuiltinExprEPKNS_12FunctionDeclEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitBuiltinExpr(clang::FunctionDecl const*, unsigned int, clang::CallExpr const*)"},
    {"_Z8EmitFAbsRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueENS_8QualTypeE", "EmitFAbs(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::QualType)"},
    {"_Z16EmitBinaryAtomicRN5clang7CodeGen15CodeGenFunctionEN4llvm9Intrinsic2IDEPKNS_8CallExprE", "EmitBinaryAtomic(clang::CodeGen::CodeGenFunction&, llvm::Intrinsic::ID, clang::CallExpr const*)"},
    {"_Z20EmitBinaryAtomicPostRN5clang7CodeGen15CodeGenFunctionEN4llvm9Intrinsic2IDEPKNS_8CallExprENS3_11Instruction9BinaryOpsE", "EmitBinaryAtomicPost(clang::CodeGen::CodeGenFunction&, llvm::Intrinsic::ID, clang::CallExpr const*, llvm::Instruction::BinaryOps)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitTargetBuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitTargetBuiltinExpr(unsigned int, clang::CallExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitARMBuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitARMBuiltinExpr(unsigned int, clang::CallExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitX86BuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitX86BuiltinExpr(unsigned int, clang::CallExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitPPCBuiltinExprEjPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitPPCBuiltinExpr(unsigned int, clang::CallExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitNeonSplatEPN4llvm5ValueEPNS2_8ConstantE", "clang::CodeGen::CodeGenFunction::EmitNeonSplat(llvm::Value*, llvm::Constant*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitNeonCallEPN4llvm8FunctionERNS2_15SmallVectorImplIPNS2_5ValueEEEPKcjb", "clang::CodeGen::CodeGenFunction::EmitNeonCall(llvm::Function*, llvm::SmallVectorImpl<llvm::Value*>&, char const*, unsigned int, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitNeonShiftVectorEPN4llvm5ValueEPKNS2_4TypeEb", "clang::CodeGen::CodeGenFunction::EmitNeonShiftVector(llvm::Value*, llvm::Type const*, bool)"},
    {"_Z19GetPointeeAlignmentRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprE", "GetPointeeAlignment(clang::CodeGen::CodeGenFunction&, clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11BuildVectorERKN4llvm15SmallVectorImplIPNS2_5ValueEEE", "clang::CodeGen::CodeGenFunction::BuildVector(llvm::SmallVectorImpl<llvm::Value*> const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule28TryEmitBaseDestructorAsAliasEPKNS_17CXXDestructorDeclE", "clang::CodeGen::CodeGenModule::TryEmitBaseDestructorAsAlias(clang::CXXDestructorDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule24TryEmitDefinitionAsAliasENS0_10GlobalDeclES2_", "clang::CodeGen::CodeGenModule::TryEmitDefinitionAsAlias(clang::CodeGen::GlobalDecl, clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule19EmitCXXConstructorsEPKNS_18CXXConstructorDeclE", "clang::CodeGen::CodeGenModule::EmitCXXConstructors(clang::CXXConstructorDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule18EmitCXXConstructorEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeE", "clang::CodeGen::CodeGenModule::EmitCXXConstructor(clang::CXXConstructorDecl const*, clang::CXXCtorType)"},
    {"_ZN5clang7CodeGen13CodeGenModule23GetAddrOfCXXConstructorEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeE", "clang::CodeGen::CodeGenModule::GetAddrOfCXXConstructor(clang::CXXConstructorDecl const*, clang::CXXCtorType)"},
    {"_ZN5clang7CodeGen13CodeGenModule18EmitCXXDestructorsEPKNS_17CXXDestructorDeclE", "clang::CodeGen::CodeGenModule::EmitCXXDestructors(clang::CXXDestructorDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule17EmitCXXDestructorEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenModule::EmitCXXDestructor(clang::CXXDestructorDecl const*, clang::CXXDtorType)"},
    {"_ZN5clang7CodeGen13CodeGenModule22GetAddrOfCXXDestructorEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenModule::GetAddrOfCXXDestructor(clang::CXXDestructorDecl const*, clang::CXXDtorType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16BuildVirtualCallEPKNS_13CXXMethodDeclEPN4llvm5ValueEPKNS5_4TypeE", "clang::CodeGen::CodeGenFunction::BuildVirtualCall(clang::CXXMethodDecl const*, llvm::Value*, llvm::Type const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25BuildAppleKextVirtualCallEPKNS_13CXXMethodDeclEPNS_19NestedNameSpecifierEPKN4llvm4TypeE", "clang::CodeGen::CodeGenFunction::BuildAppleKextVirtualCall(clang::CXXMethodDecl const*, clang::NestedNameSpecifier*, llvm::Type const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction35BuildAppleKextVirtualDestructorCallEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenFunction::BuildAppleKextVirtualDestructorCall(clang::CXXDestructorDecl const*, clang::CXXDtorType, clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16BuildVirtualCallEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeEPN4llvm5ValueEPKNS6_4TypeE", "clang::CodeGen::CodeGenFunction::BuildVirtualCall(clang::CXXDestructorDecl const*, clang::CXXDtorType, llvm::Value*, llvm::Type const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule15GetAddrOfGlobalENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::GetAddrOfGlobal(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen8CGCXXABID0Ev", "clang::CodeGen::CGCXXABI::~CGCXXABI()"},
    {"_ZN5clang7CodeGen8CGCXXABID1Ev", "clang::CodeGen::CGCXXABI::~CGCXXABI()"},
    {"_ZN5clang7CodeGen8CGCXXABID2Ev", "clang::CodeGen::CGCXXABI::~CGCXXABI()"},
    {"_ZN5clang7CodeGen8CGCXXABI24ConvertMemberPointerTypeEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::ConvertMemberPointerType(clang::MemberPointerType const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI31EmitLoadOfMemberFunctionPointerERNS0_15CodeGenFunctionERPN4llvm5ValueES6_PKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitLoadOfMemberFunctionPointer(clang::CodeGen::CodeGenFunction&, llvm::Value*&, llvm::Value*, clang::MemberPointerType const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI28EmitMemberDataPointerAddressERNS0_15CodeGenFunctionEPN4llvm5ValueES6_PKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitMemberDataPointerAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI27EmitMemberPointerConversionERNS0_15CodeGenFunctionEPKNS_8CastExprEPN4llvm5ValueE", "clang::CodeGen::CGCXXABI::EmitMemberPointerConversion(clang::CodeGen::CodeGenFunction&, clang::CastExpr const*, llvm::Value*)"},
    {"_ZN5clang7CodeGen8CGCXXABI27EmitMemberPointerComparisonERNS0_15CodeGenFunctionEPN4llvm5ValueES6_PKNS_17MemberPointerTypeEb", "clang::CodeGen::CGCXXABI::EmitMemberPointerComparison(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*, bool)"},
    {"_ZN5clang7CodeGen8CGCXXABI26EmitMemberPointerIsNotNullERNS0_15CodeGenFunctionEPN4llvm5ValueEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitMemberPointerIsNotNull(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::MemberPointerType const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI27EmitMemberPointerConversionEPN4llvm8ConstantEPKNS_8CastExprE", "clang::CodeGen::CGCXXABI::EmitMemberPointerConversion(llvm::Constant*, clang::CastExpr const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI21EmitNullMemberPointerEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::EmitNullMemberPointer(clang::MemberPointerType const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI17EmitMemberPointerEPKNS_13CXXMethodDeclE", "clang::CodeGen::CGCXXABI::EmitMemberPointer(clang::CXXMethodDecl const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI21EmitMemberDataPointerEPKNS_17MemberPointerTypeENS_9CharUnitsE", "clang::CodeGen::CGCXXABI::EmitMemberDataPointer(clang::MemberPointerType const*, clang::CharUnits)"},
    {"_ZN5clang7CodeGen8CGCXXABI19isZeroInitializableEPKNS_17MemberPointerTypeE", "clang::CodeGen::CGCXXABI::isZeroInitializable(clang::MemberPointerType const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI14BuildThisParamERNS0_15CodeGenFunctionERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CGCXXABI::BuildThisParam(clang::CodeGen::CodeGenFunction&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN5clang7CodeGen8CGCXXABI13EmitThisParamERNS0_15CodeGenFunctionE", "clang::CodeGen::CGCXXABI::EmitThisParam(clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang7CodeGen8CGCXXABI19EmitReturnFromThunkERNS0_15CodeGenFunctionENS0_6RValueENS_8QualTypeE", "clang::CodeGen::CGCXXABI::EmitReturnFromThunk(clang::CodeGen::CodeGenFunction&, clang::CodeGen::RValue, clang::QualType)"},
    {"_ZN5clang7CodeGen8CGCXXABI18GetArrayCookieSizeEPKNS_10CXXNewExprE", "clang::CodeGen::CGCXXABI::GetArrayCookieSize(clang::CXXNewExpr const*)"},
    {"_ZN5clang7CodeGen8CGCXXABI21InitializeArrayCookieERNS0_15CodeGenFunctionEPN4llvm5ValueES6_PKNS_10CXXNewExprENS_8QualTypeE", "clang::CodeGen::CGCXXABI::InitializeArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::CXXNewExpr const*, clang::QualType)"},
    {"_ZN5clang7CodeGen8CGCXXABI15ReadArrayCookieERNS0_15CodeGenFunctionEPN4llvm5ValueEPKNS_13CXXDeleteExprENS_8QualTypeERS6_SB_RNS_9CharUnitsE", "clang::CodeGen::CGCXXABI::ReadArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::CXXDeleteExpr const*, clang::QualType, llvm::Value*&, llvm::Value*&, clang::CharUnits&)"},
    {"_ZN5clang7CodeGen8CGCXXABI15EmitGuardedInitERNS0_15CodeGenFunctionERKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CGCXXABI::EmitGuardedInit(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::GlobalVariable*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_7CanQualINS_19FunctionNoProtoTypeEEEb", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CanQual<clang::FunctionNoProtoType>, bool)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_7CanQualINS_4TypeEEERKN4llvm15SmallVectorImplIS4_EERKNS_12FunctionType7ExtInfoEb", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CanQual<clang::Type>, llvm::SmallVectorImpl<clang::CanQual<clang::Type> > const&, clang::FunctionType::ExtInfo const&, bool)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_7CanQualINS_17FunctionProtoTypeEEEb", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CanQual<clang::FunctionProtoType>, bool)"},
    {"_Z15getFunctionInfoRN5clang7CodeGen12CodeGenTypesERN4llvm15SmallVectorImplINS_7CanQualINS_4TypeEEEEENS5_INS_17FunctionProtoTypeEEEb", "getFunctionInfo(clang::CodeGen::CodeGenTypes&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&, clang::CanQual<clang::FunctionProtoType>, bool)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_13CXXRecordDeclEPKNS_17FunctionProtoTypeE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXRecordDecl const*, clang::FunctionProtoType const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_13CXXMethodDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXMethodDecl const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXConstructorDecl const*, clang::CXXCtorType)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CXXDestructorDecl const*, clang::CXXDtorType)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_12FunctionDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::FunctionDecl const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoEPKNS_14ObjCMethodDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::ObjCMethodDecl const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS0_10GlobalDeclE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_8QualTypeERKN4llvm11SmallVectorISt4pairINS0_6RValueES2_ELj16EEERKNS_12FunctionType7ExtInfoE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::QualType, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::FunctionType::ExtInfo const&)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15getFunctionInfoENS_8QualTypeERKN4llvm11SmallVectorISt4pairIPKNS_7VarDeclES2_ELj16EEERKNS_12FunctionType7ExtInfoE", "clang::CodeGen::CodeGenTypes::getFunctionInfo(clang::QualType, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&, clang::FunctionType::ExtInfo const&)"},
    {"_ZN5clang7CodeGen14CGFunctionInfoC1EjbjNS_7CanQualINS_4TypeEEEPKS4_j", "clang::CodeGen::CGFunctionInfo::CGFunctionInfo(unsigned int, bool, unsigned int, clang::CanQual<clang::Type>, clang::CanQual<clang::Type> const*, unsigned int)"},
    {"_ZN5clang7CodeGen14CGFunctionInfoC2EjbjNS_7CanQualINS_4TypeEEEPKS4_j", "clang::CodeGen::CGFunctionInfo::CGFunctionInfo(unsigned int, bool, unsigned int, clang::CanQual<clang::Type>, clang::CanQual<clang::Type> const*, unsigned int)"},
    {"_ZN5clang7CodeGen12CodeGenTypes16GetExpandedTypesENS_8QualTypeERSt6vectorIPKN4llvm4TypeESaIS7_EEb", "clang::CodeGen::CodeGenTypes::GetExpandedTypes(clang::QualType, std::vector<llvm::Type const*, std::allocator<llvm::Type const*> >&, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18ExpandTypeFromArgsENS_8QualTypeENS0_6LValueEN4llvm14ilist_iteratorINS4_8ArgumentEEE", "clang::CodeGen::CodeGenFunction::ExpandTypeFromArgs(clang::QualType, clang::CodeGen::LValue, llvm::ilist_iterator<llvm::Argument>)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16ExpandTypeToArgsENS_8QualTypeENS0_6RValueERN4llvm11SmallVectorIPNS4_5ValueELj16EEE", "clang::CodeGen::CodeGenFunction::ExpandTypeToArgs(clang::QualType, clang::CodeGen::RValue, llvm::SmallVector<llvm::Value*, 16u>&)"},
    {"_ZN5clang7CodeGen13CodeGenModule18ReturnTypeUsesSRetERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenModule::ReturnTypeUsesSRet(clang::CodeGen::CGFunctionInfo const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule19ReturnTypeUsesFPRetENS_8QualTypeE", "clang::CodeGen::CodeGenModule::ReturnTypeUsesFPRet(clang::QualType)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15GetFunctionTypeENS0_10GlobalDeclE", "clang::CodeGen::CodeGenTypes::GetFunctionType(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen12CodeGenTypes15GetFunctionTypeERKNS0_14CGFunctionInfoEbb", "clang::CodeGen::CodeGenTypes::GetFunctionType(clang::CodeGen::CGFunctionInfo const&, bool, bool)"},
    {"_ZN5clang7CodeGen12CodeGenTypes24GetFunctionTypeForVTableENS0_10GlobalDeclE", "clang::CodeGen::CodeGenTypes::GetFunctionTypeForVTable(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule22ConstructAttributeListERKNS0_14CGFunctionInfoEPKNS_4DeclERN4llvm11SmallVectorINS8_18AttributeWithIndexELj8EEERj", "clang::CodeGen::CodeGenModule::ConstructAttributeList(clang::CodeGen::CGFunctionInfo const&, clang::Decl const*, llvm::SmallVector<llvm::AttributeWithIndex, 8u>&, unsigned int&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitFunctionPrologERKNS0_14CGFunctionInfoEPN4llvm8FunctionERKNS5_11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitFunctionProlog(clang::CodeGen::CGFunctionInfo const&, llvm::Function*, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&)"},
    {"_Z18CreateCoercedStorePN4llvm5ValueES1_bRN5clang7CodeGen15CodeGenFunctionE", "CreateCoercedStore(llvm::Value*, llvm::Value*, bool, clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitFunctionEpilogERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenFunction::EmitFunctionEpilog(clang::CodeGen::CGFunctionInfo const&)"},
    {"_Z17CreateCoercedLoadPN4llvm5ValueEPKNS_4TypeERN5clang7CodeGen15CodeGenFunctionE", "CreateCoercedLoad(llvm::Value*, llvm::Type const*, clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitDelegateCallArgEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::EmitDelegateCallArg(clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitCallArgEPKNS_4ExprENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitCallArg(clang::Expr const*, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitCallOrInvokeEPN4llvm5ValueEPKS4_S6_RKNS2_5TwineE", "clang::CodeGen::CodeGenFunction::EmitCallOrInvoke(llvm::Value*, llvm::Value* const*, llvm::Value* const*, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction8EmitCallERKNS0_14CGFunctionInfoEPN4llvm5ValueENS0_15ReturnValueSlotERKNS5_11SmallVectorISt4pairINS0_6RValueENS_8QualTypeEELj16EEEPKNS_4DeclEPPNS5_11InstructionE", "clang::CodeGen::CodeGenFunction::EmitCall(clang::CodeGen::CGFunctionInfo const&, llvm::Value*, clang::CodeGen::ReturnValueSlot, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::Decl const*, llvm::Instruction**)"},
    {"_ZN5clang7CodeGen15CodeGenFunction9EmitVAArgEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitVAArg(llvm::Value*, clang::QualType)"},
    {"_Z34EnterStructPointerForCoercedAccessPN4llvm5ValueEPKNS_10StructTypeEyRN5clang7CodeGen15CodeGenFunctionE", "EnterStructPointerForCoercedAccess(llvm::Value*, llvm::StructType const*, unsigned long long, clang::CodeGen::CodeGenFunction&)"},
    {"_Z24CoerceIntOrPtrToIntOrPtrPN4llvm5ValueEPKNS_4TypeERN5clang7CodeGen15CodeGenFunctionE", "CoerceIntOrPtrToIntOrPtr(llvm::Value*, llvm::Type const*, clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang7CodeGen14CGFunctionInfo7ProfileIPKNS_7CanQualINS_4TypeEEEEEvRN4llvm16FoldingSetNodeIDERKNS_12FunctionType7ExtInfoES5_T_SF_", "void clang::CodeGen::CGFunctionInfo::Profile<clang::CanQual<clang::Type> const*>(llvm::FoldingSetNodeID&, clang::FunctionType::ExtInfo const&, clang::CanQual<clang::Type>, clang::CanQual<clang::Type> const*, clang::CanQual<clang::Type> const*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE18CreateConstGEP2_32EPNS_5ValueEjjRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstGEP2_32(llvm::Value*, unsigned int, unsigned int, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE13CreateRetVoidEv", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateRetVoid()"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateRetEPNS_5ValueE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateRet(llvm::Value*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateCallIPKPNS_5ValueEEEPNS_8CallInstES7_T_SC_RKNS_5TwineE", "llvm::CallInst* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall<llvm::Value* const*>(llvm::Value*, llvm::Value* const*, llvm::Value* const*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateInvokeIPKPNS_5ValueEEEPNS_10InvokeInstES7_PNS_10BasicBlockESD_T_SE_RKNS_5TwineE", "llvm::InvokeInst* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInvoke<llvm::Value* const*>(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*, llvm::Value* const*, llvm::Value* const*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE18CreateExtractValueEPNS_5ValueEjRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateExtractValue(llvm::Value*, unsigned int, llvm::Twine const&)"},
    {"_ZN4llvm10InvokeInstC2IPKPNS_5ValueEEES3_PNS_10BasicBlockES7_T_S8_jRKNS_5TwineEPNS_11InstructionE", "llvm::InvokeInst::InvokeInst<llvm::Value* const*>(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*, llvm::Value* const*, llvm::Value* const*, unsigned int, llvm::Twine const&, llvm::Instruction*)"},
    {"_ZN4llvm8CallInstC2IPKPNS_5ValueEEES3_T_S6_RKNS_5TwineEPNS_11InstructionE", "llvm::CallInst::CallInst<llvm::Value* const*>(llvm::Value*, llvm::Value* const*, llvm::Value* const*, llvm::Twine const&, llvm::Instruction*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE13CreateIntCastEPNS_5ValueEPKNS_4TypeEbRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateIntCast(llvm::Value*, llvm::Type const*, bool, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule28GetNonVirtualBaseClassOffsetEPKNS_13CXXRecordDeclEPKPKNS_16CXXBaseSpecifierES9_", "clang::CodeGen::CodeGenModule::GetNonVirtualBaseClassOffset(clang::CXXRecordDecl const*, clang::CXXBaseSpecifier const* const*, clang::CXXBaseSpecifier const* const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction37GetAddressOfDirectBaseInCompleteClassEPN4llvm5ValueEPKNS_13CXXRecordDeclES7_b", "clang::CodeGen::CodeGenFunction::GetAddressOfDirectBaseInCompleteClass(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXRecordDecl const*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21GetAddressOfBaseClassEPN4llvm5ValueEPKNS_13CXXRecordDeclEPKPKNS_16CXXBaseSpecifierESC_b", "clang::CodeGen::CodeGenFunction::GetAddressOfBaseClass(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXBaseSpecifier const* const*, clang::CXXBaseSpecifier const* const*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25GetVirtualBaseClassOffsetEPN4llvm5ValueEPKNS_13CXXRecordDeclES7_", "clang::CodeGen::CodeGenFunction::GetVirtualBaseClassOffset(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXRecordDecl const*)"},
    {"_Z31ApplyNonVirtualAndVirtualOffsetRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEyS5_", "ApplyNonVirtualAndVirtualOffset(clang::CodeGen::CodeGenFunction&, llvm::Value*, unsigned long long, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24GetAddressOfDerivedClassEPN4llvm5ValueEPKNS_13CXXRecordDeclEPKPKNS_16CXXBaseSpecifierESC_b", "clang::CodeGen::CodeGenFunction::GetAddressOfDerivedClass(llvm::Value*, clang::CXXRecordDecl const*, clang::CXXBaseSpecifier const* const*, clang::CXXBaseSpecifier const* const*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitConstructorBodyERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitConstructorBody(llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction30EmitDelegateCXXConstructorCallEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeERKN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitDelegateCXXConstructorCall(clang::CXXConstructorDecl const*, clang::CXXCtorType, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitCtorPrologueEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitCtorPrologue(clang::CXXConstructorDecl const*, clang::CXXCtorType, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24InitializeVTablePointersEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenFunction::InitializeVTablePointers(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitDestructorBodyERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitDestructorBody(llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EnterDtorCleanupsEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeE", "clang::CodeGen::CodeGenFunction::EnterDtorCleanups(clang::CXXDestructorDecl const*, clang::CXXDtorType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitCXXDestructorCallEPKNS_17CXXDestructorDeclENS_11CXXDtorTypeEbPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCXXDestructorCall(clang::CXXDestructorDecl const*, clang::CXXDtorType, bool, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitCXXAggrConstructorCallEPKNS_18CXXConstructorDeclEPKNS_17ConstantArrayTypeEPN4llvm5ValueENS_17ConstExprIteratorESB_b", "clang::CodeGen::CodeGenFunction::EmitCXXAggrConstructorCall(clang::CXXConstructorDecl const*, clang::ConstantArrayType const*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitCXXAggrConstructorCallEPKNS_18CXXConstructorDeclEPN4llvm5ValueES7_NS_17ConstExprIteratorES8_b", "clang::CodeGen::CodeGenFunction::EmitCXXAggrConstructorCall(clang::CXXConstructorDecl const*, llvm::Value*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitCXXConstructorCallEPKNS_18CXXConstructorDeclENS_11CXXCtorTypeEbPN4llvm5ValueENS_17ConstExprIteratorES9_", "clang::CodeGen::CodeGenFunction::EmitCXXConstructorCall(clang::CXXConstructorDecl const*, clang::CXXCtorType, bool, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25EmitCXXAggrDestructorCallEPKNS_17CXXDestructorDeclEPKNS_9ArrayTypeEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCXXAggrDestructorCall(clang::CXXDestructorDecl const*, clang::ArrayType const*, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25EmitCXXAggrDestructorCallEPKNS_17CXXDestructorDeclEPN4llvm5ValueES7_", "clang::CodeGen::CodeGenFunction::EmitCXXAggrDestructorCall(clang::CXXDestructorDecl const*, llvm::Value*, llvm::Value*)"},
    {"_Z15GetVTTParameterRN5clang7CodeGen15CodeGenFunctionENS0_10GlobalDeclEb", "GetVTTParameter(clang::CodeGen::CodeGenFunction&, clang::CodeGen::GlobalDecl, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction30EmitSynthesizedCXXCopyCtorCallEPKNS_18CXXConstructorDeclEPN4llvm5ValueES7_NS_17ConstExprIteratorES8_", "clang::CodeGen::CodeGenFunction::EmitSynthesizedCXXCopyCtorCall(clang::CXXConstructorDecl const*, llvm::Value*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21PushDestructorCleanupEPKNS_17CXXDestructorDeclEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::PushDestructorCleanup(clang::CXXDestructorDecl const*, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21PushDestructorCleanupENS_8QualTypeEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::PushDestructorCleanup(clang::QualType, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12GetVTablePtrEPN4llvm5ValueEPKNS2_4TypeE", "clang::CodeGen::CodeGenFunction::GetVTablePtr(llvm::Value*, llvm::Type const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction23InitializeVTablePointerENS0_13BaseSubobjectEPKNS_13CXXRecordDeclEyPN4llvm8ConstantES5_", "clang::CodeGen::CodeGenFunction::InitializeVTablePointer(clang::CodeGen::BaseSubobject, clang::CXXRecordDecl const*, unsigned long long, llvm::Constant*, clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24InitializeVTablePointersENS0_13BaseSubobjectEPKNS_13CXXRecordDeclEybPN4llvm8ConstantES5_RNS6_11SmallPtrSetIS5_Lj4EEE", "clang::CodeGen::CodeGenFunction::InitializeVTablePointers(clang::CodeGen::BaseSubobject, clang::CXXRecordDecl const*, unsigned long long, bool, llvm::Constant*, clang::CXXRecordDecl const*, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"},
    {"_ZN12_GLOBAL__N_113CallLocalDtorD1Ev", "(anonymous namespace)::CallLocalDtor::~CallLocalDtor()"},
    {"_ZN12_GLOBAL__N_113CallLocalDtorD0Ev", "(anonymous namespace)::CallLocalDtor::~CallLocalDtor()"},
    {"_ZN12_GLOBAL__N_113CallLocalDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallLocalDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_113CallFieldDtorD1Ev", "(anonymous namespace)::CallFieldDtor::~CallFieldDtor()"},
    {"_ZN12_GLOBAL__N_113CallFieldDtorD0Ev", "(anonymous namespace)::CallFieldDtor::~CallFieldDtor()"},
    {"_ZN12_GLOBAL__N_113CallFieldDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallFieldDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_118CallArrayFieldDtorD1Ev", "(anonymous namespace)::CallArrayFieldDtor::~CallArrayFieldDtor()"},
    {"_ZN12_GLOBAL__N_118CallArrayFieldDtorD0Ev", "(anonymous namespace)::CallArrayFieldDtor::~CallArrayFieldDtor()"},
    {"_ZN12_GLOBAL__N_118CallArrayFieldDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallArrayFieldDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_114CallDtorDeleteD1Ev", "(anonymous namespace)::CallDtorDelete::~CallDtorDelete()"},
    {"_ZN12_GLOBAL__N_114CallDtorDeleteD0Ev", "(anonymous namespace)::CallDtorDelete::~CallDtorDelete()"},
    {"_ZN12_GLOBAL__N_114CallDtorDelete4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallDtorDelete::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_112CallBaseDtorD1Ev", "(anonymous namespace)::CallBaseDtor::~CallBaseDtor()"},
    {"_ZN12_GLOBAL__N_112CallBaseDtorD0Ev", "(anonymous namespace)::CallBaseDtor::~CallBaseDtor()"},
    {"_ZN12_GLOBAL__N_112CallBaseDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallBaseDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_Z24EmitAggMemberInitializerRN5clang7CodeGen15CodeGenFunctionENS0_6LValueEPN4llvm5ValueEPNS_18CXXCtorInitializerENS_8QualTypeEj", "EmitAggMemberInitializer(clang::CodeGen::CodeGenFunction&, clang::CodeGen::LValue, llvm::Value*, clang::CXXCtorInitializer*, clang::QualType, unsigned int)"},
    {"_ZN12_GLOBAL__N_114CallMemberDtorD1Ev", "(anonymous namespace)::CallMemberDtor::~CallMemberDtor()"},
    {"_ZN12_GLOBAL__N_114CallMemberDtorD0Ev", "(anonymous namespace)::CallMemberDtor::~CallMemberDtor()"},
    {"_ZN12_GLOBAL__N_114CallMemberDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallMemberDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_121DynamicThisUseCheckerEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::DynamicThisUseChecker, void>::Visit(clang::Stmt*)"},
    {"_ZN5clang20EvaluatedExprVisitorIN12_GLOBAL__N_121DynamicThisUseCheckerEE9VisitStmtEPNS_4StmtE", "clang::EvaluatedExprVisitor<(anonymous namespace)::DynamicThisUseChecker>::VisitStmt(clang::Stmt*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE18CreateConstGEP1_64EPNS_5ValueEyRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstGEP1_64(llvm::Value*, unsigned long long, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE26CreateConstInBoundsGEP2_64EPNS_5ValueEyyRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstInBoundsGEP2_64(llvm::Value*, unsigned long long, unsigned long long, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15DominatingValueINS0_6RValueEE10saved_type11needsSavingES2_", "clang::CodeGen::DominatingValue<clang::CodeGen::RValue>::saved_type::needsSaving(clang::CodeGen::RValue)"},
    {"_ZN5clang7CodeGen15DominatingValueINS0_6RValueEE10saved_type4saveERNS0_15CodeGenFunctionES2_", "clang::CodeGen::DominatingValue<clang::CodeGen::RValue>::saved_type::save(clang::CodeGen::CodeGenFunction&, clang::CodeGen::RValue)"},
    {"_ZN5clang7CodeGen15DominatingValueINS0_6RValueEE10saved_type7restoreERNS0_15CodeGenFunctionE", "clang::CodeGen::DominatingValue<clang::CodeGen::RValue>::saved_type::restore(clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang7CodeGen12EHScopeStack8allocateEm", "clang::CodeGen::EHScopeStack::allocate(unsigned long)"},
    {"_ZNK5clang7CodeGen12EHScopeStack21getEnclosingEHCleanupENS1_8iteratorE", "clang::CodeGen::EHScopeStack::getEnclosingEHCleanup(clang::CodeGen::EHScopeStack::iterator) const"},
    {"_ZN5clang7CodeGen12EHScopeStack11pushCleanupENS0_11CleanupKindEm", "clang::CodeGen::EHScopeStack::pushCleanup(clang::CodeGen::CleanupKind, unsigned long)"},
    {"_ZN5clang7CodeGen12EHScopeStack10popCleanupEv", "clang::CodeGen::EHScopeStack::popCleanup()"},
    {"_ZN5clang7CodeGen12EHScopeStack13popNullFixupsEv", "clang::CodeGen::EHScopeStack::popNullFixups()"},
    {"_ZN5clang7CodeGen12EHScopeStack10pushFilterEj", "clang::CodeGen::EHScopeStack::pushFilter(unsigned int)"},
    {"_ZN5clang7CodeGen12EHScopeStack9popFilterEv", "clang::CodeGen::EHScopeStack::popFilter()"},
    {"_ZN5clang7CodeGen12EHScopeStack9pushCatchEj", "clang::CodeGen::EHScopeStack::pushCatch(unsigned int)"},
    {"_ZN5clang7CodeGen12EHScopeStack13pushTerminateEv", "clang::CodeGen::EHScopeStack::pushTerminate()"},
    {"_ZN5clang7CodeGen15CodeGenFunction19initFullExprCleanupEv", "clang::CodeGen::CodeGenFunction::initFullExprCleanup()"},
    {"_ZN5clang7CodeGen12EHScopeStack7CleanupD0Ev", "clang::CodeGen::EHScopeStack::Cleanup::~Cleanup()"},
    {"_ZN5clang7CodeGen12EHScopeStack7CleanupD1Ev", "clang::CodeGen::EHScopeStack::Cleanup::~Cleanup()"},
    {"_ZN5clang7CodeGen12EHScopeStack7CleanupD2Ev", "clang::CodeGen::EHScopeStack::Cleanup::~Cleanup()"},
    {"_ZN5clang7CodeGen15CodeGenFunction19ResolveBranchFixupsEPN4llvm10BasicBlockE", "clang::CodeGen::CodeGenFunction::ResolveBranchFixups(llvm::BasicBlock*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16PopCleanupBlocksENS0_12EHScopeStack15stable_iteratorE", "clang::CodeGen::CodeGenFunction::PopCleanupBlocks(clang::CodeGen::EHScopeStack::stable_iterator)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15PopCleanupBlockEb", "clang::CodeGen::CodeGenFunction::PopCleanupBlock(bool)"},
    {"_Z29ForwardPrebranchedFallthroughPN4llvm10BasicBlockES1_S1_", "ForwardPrebranchedFallthrough(llvm::BasicBlock*, llvm::BasicBlock*, llvm::BasicBlock*)"},
    {"_Z20SimplifyCleanupEntryRN5clang7CodeGen15CodeGenFunctionEPN4llvm10BasicBlockE", "SimplifyCleanupEntry(clang::CodeGen::CodeGenFunction&, llvm::BasicBlock*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20getEHCleanupDestSlotEv", "clang::CodeGen::CodeGenFunction::getEHCleanupDestSlot()"},
    {"_Z11EmitCleanupRN5clang7CodeGen15CodeGenFunctionEPNS0_12EHScopeStack7CleanupEbPN4llvm5ValueE", "EmitCleanup(clang::CodeGen::CodeGenFunction&, clang::CodeGen::EHScopeStack::Cleanup*, bool, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24getNormalCleanupDestSlotEv", "clang::CodeGen::CodeGenFunction::getNormalCleanupDestSlot()"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitBranchThroughCleanupENS1_8JumpDestE", "clang::CodeGen::CodeGenFunction::EmitBranchThroughCleanup(clang::CodeGen::CodeGenFunction::JumpDest)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitBranchThroughEHCleanupENS1_10UnwindDestE", "clang::CodeGen::CodeGenFunction::EmitBranchThroughEHCleanup(clang::CodeGen::CodeGenFunction::UnwindDest)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20ActivateCleanupBlockENS0_12EHScopeStack15stable_iteratorE", "clang::CodeGen::CodeGenFunction::ActivateCleanupBlock(clang::CodeGen::EHScopeStack::stable_iterator)"},
    {"_Z27SetupCleanupBlockActivationRN5clang7CodeGen15CodeGenFunctionENS0_12EHScopeStack15stable_iteratorE15ForActivation_t", "SetupCleanupBlockActivation(clang::CodeGen::CodeGenFunction&, clang::CodeGen::EHScopeStack::stable_iterator, ForActivation_t)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22DeactivateCleanupBlockENS0_12EHScopeStack15stable_iteratorE", "clang::CodeGen::CodeGenFunction::DeactivateCleanupBlock(clang::CodeGen::EHScopeStack::stable_iterator)"},
    {"_ZN5clang7CodeGen14EHCleanupScope14addBranchAfterEPN4llvm11ConstantIntEPNS2_10BasicBlockE", "clang::CodeGen::EHCleanupScope::addBranchAfter(llvm::ConstantInt*, llvm::BasicBlock*)"},
    {"_ZN5clang7CodeGen14EHCleanupScope16addEHBranchAfterEPN4llvm11ConstantIntEPNS2_10BasicBlockE", "clang::CodeGen::EHCleanupScope::addEHBranchAfter(llvm::ConstantInt*, llvm::BasicBlock*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang7CodeGen11BranchFixupELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeGen::BranchFixup, false>::grow(unsigned long)"},
    {"_ZN5clang7CodeGen14EHCleanupScopeD2Ev", "clang::CodeGen::EHCleanupScope::~EHCleanupScope()"},
    {"_ZN5clang7CodeGen11CGDebugInfoC1ERNS0_13CodeGenModuleE", "clang::CodeGen::CGDebugInfo::CGDebugInfo(clang::CodeGen::CodeGenModule&)"},
    {"_ZN5clang7CodeGen11CGDebugInfoC2ERNS0_13CodeGenModuleE", "clang::CodeGen::CGDebugInfo::CGDebugInfo(clang::CodeGen::CodeGenModule&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17CreateCompileUnitEv", "clang::CodeGen::CGDebugInfo::CreateCompileUnit()"},
    {"_ZN5clang7CodeGen11CGDebugInfoD1Ev", "clang::CodeGen::CGDebugInfo::~CGDebugInfo()"},
    {"_ZN5clang7CodeGen11CGDebugInfoD2Ev", "clang::CodeGen::CGDebugInfo::~CGDebugInfo()"},
    {"_ZN5clang7CodeGen11CGDebugInfo11setLocationENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::setLocation(clang::SourceLocation)"},
    {"_ZN5clang7CodeGen11CGDebugInfo20getContextDescriptorEPKNS_4DeclE", "clang::CodeGen::CGDebugInfo::getContextDescriptor(clang::Decl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo20getOrCreateNameSpaceEPKNS_13NamespaceDeclE", "clang::CodeGen::CGDebugInfo::getOrCreateNameSpace(clang::NamespaceDecl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo15getOrCreateTypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::getOrCreateType(clang::QualType, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo19getOrCreateMainFileEv", "clang::CodeGen::CGDebugInfo::getOrCreateMainFile()"},
    {"_ZN5clang7CodeGen11CGDebugInfo15getFunctionNameEPKNS_12FunctionDeclE", "clang::CodeGen::CGDebugInfo::getFunctionName(clang::FunctionDecl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17getObjCMethodNameEPKNS_14ObjCMethodDeclE", "clang::CodeGen::CGDebugInfo::getObjCMethodName(clang::ObjCMethodDecl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo12getClassNameEPNS_10RecordDeclE", "clang::CodeGen::CGDebugInfo::getClassName(clang::RecordDecl*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo15getOrCreateFileENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getOrCreateFile(clang::SourceLocation)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17getCurrentDirnameEv", "clang::CodeGen::CGDebugInfo::getCurrentDirname()"},
    {"_ZN5clang7CodeGen11CGDebugInfo13getLineNumberENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getLineNumber(clang::SourceLocation)"},
    {"_ZN5clang7CodeGen11CGDebugInfo15getColumnNumberENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getColumnNumber(clang::SourceLocation)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11BuiltinTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::BuiltinType const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11ComplexTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ComplexType const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo19CreateQualifiedTypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateQualifiedType(clang::QualType, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_21ObjCObjectPointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ObjCObjectPointerType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo21CreatePointerLikeTypeEjPKNS_4TypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreatePointerLikeType(unsigned int, clang::Type const*, clang::QualType, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11PointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::PointerType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17CreatePointeeTypeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreatePointeeType(clang::QualType, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_16BlockPointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::BlockPointerType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo16CreateMemberTypeEN4llvm6DIFileENS_8QualTypeENS2_9StringRefEPy", "clang::CodeGen::CGDebugInfo::CreateMemberType(llvm::DIFile, clang::QualType, llvm::StringRef, unsigned long long*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_11TypedefTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::TypedefType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_12FunctionTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::FunctionType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo19CollectRecordFieldsEPKNS_10RecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEE", "clang::CodeGen::CGDebugInfo::CollectRecordFields(clang::RecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo21getOrCreateMethodTypeEPKNS_13CXXMethodDeclEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::getOrCreateMethodType(clang::CXXMethodDecl const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo23CreateCXXMemberFunctionEPKNS_13CXXMethodDeclEN4llvm6DIFileENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CreateCXXMemberFunction(clang::CXXMethodDecl const*, llvm::DIFile, llvm::DIType)"},
    {"_ZN5clang7CodeGen11CGDebugInfo25CollectCXXMemberFunctionsEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CollectCXXMemberFunctions(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&, llvm::DIType)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17CollectCXXFriendsEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CollectCXXFriends(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&, llvm::DIType)"},
    {"_ZN5clang7CodeGen11CGDebugInfo15CollectCXXBasesEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEENS5_6DITypeE", "clang::CodeGen::CGDebugInfo::CollectCXXBases(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&, llvm::DIType)"},
    {"_ZN5clang7CodeGen11CGDebugInfo24getOrCreateVTablePtrTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::getOrCreateVTablePtrType(llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo13getVTableNameEPKNS_13CXXRecordDeclE", "clang::CodeGen::CGDebugInfo::getVTableName(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17CollectVTableInfoEPKNS_13CXXRecordDeclEN4llvm6DIFileERNS5_15SmallVectorImplIPNS5_5ValueEEE", "clang::CodeGen::CGDebugInfo::CollectVTableInfo(clang::CXXRecordDecl const*, llvm::DIFile, llvm::SmallVectorImpl<llvm::Value*>&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo21getOrCreateRecordTypeENS_8QualTypeENS_14SourceLocationE", "clang::CodeGen::CGDebugInfo::getOrCreateRecordType(clang::QualType, clang::SourceLocation)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_10RecordTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::RecordType const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_14ObjCObjectTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ObjCObjectType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_17ObjCInterfaceTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ObjCInterfaceType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_7TagTypeE", "clang::CodeGen::CGDebugInfo::CreateType(clang::TagType const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo14CreateEnumTypeEPKNS_8EnumDeclE", "clang::CodeGen::CGDebugInfo::CreateEnumType(clang::EnumDecl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_10VectorTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::VectorType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_9ArrayTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::ArrayType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_19LValueReferenceTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::LValueReferenceType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_19RValueReferenceTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::RValueReferenceType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo10CreateTypeEPKNS_17MemberPointerTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateType(clang::MemberPointerType const*, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo14CreateTypeNodeENS_8QualTypeEN4llvm6DIFileE", "clang::CodeGen::CGDebugInfo::CreateTypeNode(clang::QualType, llvm::DIFile)"},
    {"_ZN5clang7CodeGen11CGDebugInfo17EmitFunctionStartENS0_10GlobalDeclENS_8QualTypeEPN4llvm8FunctionERNS4_9IRBuilderILb0ENS4_14ConstantFolderENS4_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::EmitFunctionStart(clang::CodeGen::GlobalDecl, clang::QualType, llvm::Function*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo13EmitStopPointERN4llvm9IRBuilderILb0ENS2_14ConstantFolderENS2_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::EmitStopPoint(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo25UpdateLineDirectiveRegionERN4llvm9IRBuilderILb0ENS2_14ConstantFolderENS2_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::UpdateLineDirectiveRegion(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo15EmitRegionStartERN4llvm9IRBuilderILb0ENS2_14ConstantFolderENS2_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::EmitRegionStart(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo13EmitRegionEndERN4llvm9IRBuilderILb0ENS2_14ConstantFolderENS2_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::EmitRegionEnd(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo15EmitFunctionEndERN4llvm9IRBuilderILb0ENS2_14ConstantFolderENS2_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::EmitFunctionEnd(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo28EmitTypeForVarWithBlocksAttrEPKNS_9ValueDeclEPy", "clang::CodeGen::CGDebugInfo::EmitTypeForVarWithBlocksAttr(clang::ValueDecl const*, unsigned long long*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo11EmitDeclareEPKNS_7VarDeclEjPN4llvm5ValueERNS5_9IRBuilderILb0ENS5_14ConstantFolderENS5_24IRBuilderDefaultInserterILb0EEEEEb", "clang::CodeGen::CGDebugInfo::EmitDeclare(clang::VarDecl const*, unsigned int, llvm::Value*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, bool)"},
    {"_ZN5clang7CodeGen11CGDebugInfo11EmitDeclareEPKNS_7VarDeclEjPN4llvm5ValueERNS5_9IRBuilderILb0ENS5_14ConstantFolderENS5_24IRBuilderDefaultInserterILb0EEEEERKNS0_11CGBlockInfoE", "clang::CodeGen::CGDebugInfo::EmitDeclare(clang::VarDecl const*, unsigned int, llvm::Value*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::CodeGen::CGBlockInfo const&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo25EmitDeclareOfAutoVariableEPKNS_7VarDeclEPN4llvm5ValueERNS5_9IRBuilderILb0ENS5_14ConstantFolderENS5_24IRBuilderDefaultInserterILb0EEEEE", "clang::CodeGen::CGDebugInfo::EmitDeclareOfAutoVariable(clang::VarDecl const*, llvm::Value*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo33EmitDeclareOfBlockDeclRefVariableEPKNS_7VarDeclEPN4llvm5ValueERNS5_9IRBuilderILb0ENS5_14ConstantFolderENS5_24IRBuilderDefaultInserterILb0EEEEERKNS0_11CGBlockInfoE", "clang::CodeGen::CGDebugInfo::EmitDeclareOfBlockDeclRefVariable(clang::VarDecl const*, llvm::Value*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::CodeGen::CGBlockInfo const&)"},
    {"_ZN5clang7CodeGen11CGDebugInfo24EmitDeclareOfArgVariableEPKNS_7VarDeclEPN4llvm5ValueERNS5_9IRBuilderILb0ENS5_14ConstantFolderENS5_24IRBuilderDefaultInserterILb0EEEEEb", "clang::CodeGen::CGDebugInfo::EmitDeclareOfArgVariable(clang::VarDecl const*, llvm::Value*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, bool)"},
    {"_ZN5clang7CodeGen11CGDebugInfo18EmitGlobalVariableEPN4llvm14GlobalVariableEPKNS_7VarDeclE", "clang::CodeGen::CGDebugInfo::EmitGlobalVariable(llvm::GlobalVariable*, clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo18EmitGlobalVariableEPN4llvm14GlobalVariableEPNS_17ObjCInterfaceDeclE", "clang::CodeGen::CGDebugInfo::EmitGlobalVariable(llvm::GlobalVariable*, clang::ObjCInterfaceDecl*)"},
    {"_ZN5clang7CodeGen11CGDebugInfo18EmitGlobalVariableEPKNS_9ValueDeclEPN4llvm8ConstantE", "clang::CodeGen::CGDebugInfo::EmitGlobalVariable(clang::ValueDecl const*, llvm::Constant*)"},
    {"_ZNK5clang15ASTRecordLayout24getBaseClassOffsetInBitsEPKNS_13CXXRecordDeclE", "clang::ASTRecordLayout::getBaseClassOffsetInBits(clang::CXXRecordDecl const*) const"},
    {"_ZN4llvm8DenseMapIPKN5clang13NamespaceDeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::NamespaceDecl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::NamespaceDecl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::FindAndConstruct(clang::NamespaceDecl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13NamespaceDeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE16InsertIntoBucketERKS4_RKS5_PSt4pairIS4_S5_E", "llvm::DenseMap<clang::NamespaceDecl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::NamespaceDecl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::InsertIntoBucket(clang::NamespaceDecl const* const&, llvm::WeakVH const&, std::pair<clang::NamespaceDecl const*, llvm::WeakVH>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13NamespaceDeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::NamespaceDecl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::NamespaceDecl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::Decl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::FindAndConstruct(clang::Decl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE16InsertIntoBucketERKS4_RKS5_PSt4pairIS4_S5_E", "llvm::DenseMap<clang::Decl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::InsertIntoBucket(clang::Decl const* const&, llvm::WeakVH const&, std::pair<clang::Decl const*, llvm::WeakVH>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::Decl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::grow(unsigned int)"},
    {"_ZNSt6vectorIN4llvm10TrackingVHINS0_6MDNodeEEESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<llvm::TrackingVH<llvm::MDNode>, std::allocator<llvm::TrackingVH<llvm::MDNode> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<llvm::TrackingVH<llvm::MDNode>*, std::vector<llvm::TrackingVH<llvm::MDNode>, std::allocator<llvm::TrackingVH<llvm::MDNode> > > >, llvm::TrackingVH<llvm::MDNode> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang12FunctionDeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::FunctionDecl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::FunctionDecl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::FindAndConstruct(clang::FunctionDecl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang12FunctionDeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE16InsertIntoBucketERKS4_RKS5_PSt4pairIS4_S5_E", "llvm::DenseMap<clang::FunctionDecl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::FunctionDecl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::InsertIntoBucket(clang::FunctionDecl const* const&, llvm::WeakVH const&, std::pair<clang::FunctionDecl const*, llvm::WeakVH>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang12FunctionDeclENS_6WeakVHENS_12DenseMapInfoIS4_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::FunctionDecl const*, llvm::WeakVH, llvm::DenseMapInfo<clang::FunctionDecl const*>, llvm::DenseMapInfo<llvm::WeakVH> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPvNS_6WeakVHENS_12DenseMapInfoIS1_EENS3_IS2_EEE16FindAndConstructERKS1_", "llvm::DenseMap<void*, llvm::WeakVH, llvm::DenseMapInfo<void*>, llvm::DenseMapInfo<llvm::WeakVH> >::FindAndConstruct(void* const&)"},
    {"_ZN4llvm8DenseMapIPvNS_6WeakVHENS_12DenseMapInfoIS1_EENS3_IS2_EEE16InsertIntoBucketERKS1_RKS2_PSt4pairIS1_S2_E", "llvm::DenseMap<void*, llvm::WeakVH, llvm::DenseMapInfo<void*>, llvm::DenseMapInfo<llvm::WeakVH> >::InsertIntoBucket(void* const&, llvm::WeakVH const&, std::pair<void*, llvm::WeakVH>*)"},
    {"_ZN4llvm8DenseMapIPvNS_6WeakVHENS_12DenseMapInfoIS1_EENS3_IS2_EEE4growEj", "llvm::DenseMap<void*, llvm::WeakVH, llvm::DenseMapInfo<void*>, llvm::DenseMapInfo<llvm::WeakVH> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKcNS_6WeakVHENS_12DenseMapInfoIS2_EENS4_IS3_EEE16FindAndConstructERKS2_", "llvm::DenseMap<char const*, llvm::WeakVH, llvm::DenseMapInfo<char const*>, llvm::DenseMapInfo<llvm::WeakVH> >::FindAndConstruct(char const* const&)"},
    {"_ZN4llvm8DenseMapIPKcNS_6WeakVHENS_12DenseMapInfoIS2_EENS4_IS3_EEE16InsertIntoBucketERKS2_RKS3_PSt4pairIS2_S3_E", "llvm::DenseMap<char const*, llvm::WeakVH, llvm::DenseMapInfo<char const*>, llvm::DenseMapInfo<llvm::WeakVH> >::InsertIntoBucket(char const* const&, llvm::WeakVH const&, std::pair<char const*, llvm::WeakVH>*)"},
    {"_ZN4llvm8DenseMapIPKcNS_6WeakVHENS_12DenseMapInfoIS2_EENS4_IS3_EEE4growEj", "llvm::DenseMap<char const*, llvm::WeakVH, llvm::DenseMapInfo<char const*>, llvm::DenseMapInfo<llvm::WeakVH> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction8EmitDeclERKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitDecl(clang::Decl const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitVarDeclERKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::EmitVarDecl(clang::VarDecl const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitAutoVarDeclERKNS_7VarDeclEPFvRS1_S4_PN4llvm5ValueEE", "clang::CodeGen::CodeGenFunction::EmitAutoVarDecl(clang::VarDecl const&, void (*)(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::Value*))"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitStaticVarDeclERKNS_7VarDeclEN4llvm11GlobalValue12LinkageTypesE", "clang::CodeGen::CodeGenFunction::EmitStaticVarDecl(clang::VarDecl const&, llvm::GlobalValue::LinkageTypes)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19CreateStaticVarDeclERKNS_7VarDeclEPKcN4llvm11GlobalValue12LinkageTypesE", "clang::CodeGen::CodeGenFunction::CreateStaticVarDecl(clang::VarDecl const&, char const*, llvm::GlobalValue::LinkageTypes)"},
    {"_Z17GetStaticDeclNameRN5clang7CodeGen15CodeGenFunctionERKNS_7VarDeclEPKc", "GetStaticDeclName(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, char const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction29AddInitializerToStaticVarDeclERKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenFunction::AddInitializerToStaticVarDecl(clang::VarDecl const&, llvm::GlobalVariable*)"},
    {"_ZNK5clang7CodeGen15CodeGenFunction22getByRefValueLLVMFieldEPKNS_9ValueDeclE", "clang::CodeGen::CodeGenFunction::getByRefValueLLVMField(clang::ValueDecl const*) const"},
    {"_ZN5clang7CodeGen15CodeGenFunction22BuildBlockByrefAddressEPN4llvm5ValueEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::BuildBlockByrefAddress(llvm::Value*, clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14BuildByRefTypeEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::BuildByRefType(clang::VarDecl const*)"},
    {"_Z28emitStoresForInitAfterMemsetPN4llvm8ConstantEPNS_5ValueERNS_9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEEE", "emitStoresForInitAfterMemset(llvm::Constant*, llvm::Value*, llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitParmDeclERKNS_7VarDeclEPN4llvm5ValueEb", "clang::CodeGen::CodeGenFunction::EmitParmDecl(clang::VarDecl const&, llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_116CallBlockReleaseD1Ev", "(anonymous namespace)::CallBlockRelease::~CallBlockRelease()"},
    {"_ZN12_GLOBAL__N_116CallBlockReleaseD0Ev", "(anonymous namespace)::CallBlockRelease::~CallBlockRelease()"},
    {"_ZN12_GLOBAL__N_116CallBlockRelease4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallBlockRelease::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_119CallCleanupFunctionD1Ev", "(anonymous namespace)::CallCleanupFunction::~CallCleanupFunction()"},
    {"_ZN12_GLOBAL__N_119CallCleanupFunctionD0Ev", "(anonymous namespace)::CallCleanupFunction::~CallCleanupFunction()"},
    {"_ZN12_GLOBAL__N_119CallCleanupFunction4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallCleanupFunction::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_111CallVarDtorD1Ev", "(anonymous namespace)::CallVarDtor::~CallVarDtor()"},
    {"_ZN12_GLOBAL__N_111CallVarDtorD0Ev", "(anonymous namespace)::CallVarDtor::~CallVarDtor()"},
    {"_ZN12_GLOBAL__N_111CallVarDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallVarDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_113CallArrayDtorD1Ev", "(anonymous namespace)::CallArrayDtor::~CallArrayDtor()"},
    {"_ZN12_GLOBAL__N_113CallArrayDtorD0Ev", "(anonymous namespace)::CallArrayDtor::~CallArrayDtor()"},
    {"_ZN12_GLOBAL__N_113CallArrayDtor4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallArrayDtor::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_116CallStackRestoreD1Ev", "(anonymous namespace)::CallStackRestore::~CallStackRestore()"},
    {"_ZN12_GLOBAL__N_116CallStackRestoreD0Ev", "(anonymous namespace)::CallStackRestore::~CallStackRestore()"},
    {"_ZN12_GLOBAL__N_116CallStackRestore4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallStackRestore::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_Z35canEmitInitWithFewStoresAfterMemsetPN4llvm8ConstantERj", "canEmitInitWithFewStoresAfterMemset(llvm::Constant*, unsigned int&)"},
    {"_ZNK5clang4Decl7getAttrINS_11CleanupAttrEEEPT_v", "clang::CleanupAttr* clang::Decl::getAttr<clang::CleanupAttr>() const"},
    {"_ZN4llvm8DenseMapIPKN5clang9ValueDeclESt4pairIPKNS_4TypeEjENS_12DenseMapInfoIS4_EENSA_IS9_EEE16InsertIntoBucketERKS4_RKS9_PS5_IS4_S9_E", "llvm::DenseMap<clang::ValueDecl const*, std::pair<llvm::Type const*, unsigned int>, llvm::DenseMapInfo<clang::ValueDecl const*>, llvm::DenseMapInfo<std::pair<llvm::Type const*, unsigned int> > >::InsertIntoBucket(clang::ValueDecl const* const&, std::pair<llvm::Type const*, unsigned int> const&, std::pair<clang::ValueDecl const*, std::pair<llvm::Type const*, unsigned int> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang9ValueDeclESt4pairIPKNS_4TypeEjENS_12DenseMapInfoIS4_EENSA_IS9_EEE4growEj", "llvm::DenseMap<clang::ValueDecl const*, std::pair<llvm::Type const*, unsigned int>, llvm::DenseMapInfo<clang::ValueDecl const*>, llvm::DenseMapInfo<std::pair<llvm::Type const*, unsigned int> > >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitCXXGlobalVarDeclInitERKNS_7VarDeclEPN4llvm8ConstantE", "clang::CodeGen::CodeGenFunction::EmitCXXGlobalVarDeclInit(clang::VarDecl const&, llvm::Constant*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction29EmitCXXGlobalDtorRegistrationEPN4llvm8ConstantES4_", "clang::CodeGen::CodeGenFunction::EmitCXXGlobalDtorRegistration(llvm::Constant*, llvm::Constant*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitCXXGuardedInitERKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenFunction::EmitCXXGuardedInit(clang::VarDecl const&, llvm::GlobalVariable*)"},
    {"_ZN5clang7CodeGen13CodeGenModule28EmitCXXGlobalVarDeclInitFuncEPKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenModule::EmitCXXGlobalVarDeclInitFunc(clang::VarDecl const*, llvm::GlobalVariable*)"},
    {"_Z34CreateGlobalInitOrDestructFunctionRN5clang7CodeGen13CodeGenModuleEPKN4llvm12FunctionTypeENS3_9StringRefE", "CreateGlobalInitOrDestructFunction(clang::CodeGen::CodeGenModule&, llvm::FunctionType const*, llvm::StringRef)"},
    {"_ZN5clang7CodeGen15CodeGenFunction32GenerateCXXGlobalVarDeclInitFuncEPN4llvm8FunctionEPKNS_7VarDeclEPNS2_14GlobalVariableE", "clang::CodeGen::CodeGenFunction::GenerateCXXGlobalVarDeclInitFunc(llvm::Function*, clang::VarDecl const*, llvm::GlobalVariable*)"},
    {"_ZN5clang7CodeGen13CodeGenModule21EmitCXXGlobalInitFuncEv", "clang::CodeGen::CodeGenModule::EmitCXXGlobalInitFunc()"},
    {"_ZN5clang7CodeGen15CodeGenFunction25GenerateCXXGlobalInitFuncEPN4llvm8FunctionEPPNS2_8ConstantEj", "clang::CodeGen::CodeGenFunction::GenerateCXXGlobalInitFunc(llvm::Function*, llvm::Constant**, unsigned int)"},
    {"_ZN5clang7CodeGen13CodeGenModule21EmitCXXGlobalDtorFuncEv", "clang::CodeGen::CodeGenModule::EmitCXXGlobalDtorFunc()"},
    {"_ZN5clang7CodeGen15CodeGenFunction25GenerateCXXGlobalDtorFuncEPN4llvm8FunctionERKSt6vectorISt4pairINS2_6WeakVHEPNS2_8ConstantEESaISA_EE", "clang::CodeGen::CodeGenFunction::GenerateCXXGlobalDtorFunc(llvm::Function*, std::vector<std::pair<llvm::WeakVH, llvm::Constant*>, std::allocator<std::pair<llvm::WeakVH, llvm::Constant*> > > const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction31GenerateCXXAggrDestructorHelperEPKNS_17CXXDestructorDeclEPKNS_9ArrayTypeEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::GenerateCXXAggrDestructorHelper(clang::CXXDestructorDecl const*, clang::ArrayType const*, llvm::Value*)"},
    {"_ZN4llvm25array_pod_sort_comparatorISt4pairIN5clang7CodeGen16OrderGlobalInitsEPNS_8FunctionEEEEiPKvS9_", "int llvm::array_pod_sort_comparator<std::pair<clang::CodeGen::OrderGlobalInits, llvm::Function*> >(void const*, void const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule15AddCXXDtorEntryEPN4llvm8ConstantES4_", "clang::CodeGen::CodeGenModule::AddCXXDtorEntry(llvm::Constant*, llvm::Constant*)"},
    {"_ZNK5clang4Decl7getAttrINS_16InitPriorityAttrEEEPT_v", "clang::InitPriorityAttr* clang::Decl::getAttr<clang::InitPriorityAttr>() const"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateCallEPNS_5ValueERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall(llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseISt4pairIN5clang7CodeGen16OrderGlobalInitsEPNS_8FunctionEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::CodeGen::OrderGlobalInits, llvm::Function*>, false>::grow(unsigned long)"},
    {"_ZNSt6vectorISt4pairIN4llvm6WeakVHEPNS1_8ConstantEESaIS5_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS5_S7_EERKS5_", "std::vector<std::pair<llvm::WeakVH, llvm::Constant*>, std::allocator<std::pair<llvm::WeakVH, llvm::Constant*> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<llvm::WeakVH, llvm::Constant*>*, std::vector<std::pair<llvm::WeakVH, llvm::Constant*>, std::allocator<std::pair<llvm::WeakVH, llvm::Constant*> > > >, std::pair<llvm::WeakVH, llvm::Constant*> const&)"},
    {"_ZNSt15__copy_backwardILb0ESt26random_access_iterator_tagE8__copy_bIPSt4pairIN4llvm6WeakVHEPNS4_8ConstantEES9_EET0_T_SB_SA_", "std::pair<llvm::WeakVH, llvm::Constant*>* std::__copy_backward<false, std::random_access_iterator_tag>::__copy_b<std::pair<llvm::WeakVH, llvm::Constant*>*, std::pair<llvm::WeakVH, llvm::Constant*>*>(std::pair<llvm::WeakVH, llvm::Constant*>*, std::pair<llvm::WeakVH, llvm::Constant*>*, std::pair<llvm::WeakVH, llvm::Constant*>*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26getUnwindResumeOrRethrowFnEv", "clang::CodeGen::CodeGenFunction::getUnwindResumeOrRethrowFn()"},
    {"_ZN5clang7CodeGen13EHPersonality3getERKNS_11LangOptionsE", "clang::CodeGen::EHPersonality::get(clang::LangOptions const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule19SimplifyPersonalityEv", "clang::CodeGen::CodeGenModule::SimplifyPersonality()"},
    {"_Z25PersonalityHasOnlyCXXUsesPN4llvm8ConstantE", "PersonalityHasOnlyCXXUses(llvm::Constant*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16getExceptionSlotEv", "clang::CodeGen::CodeGenFunction::getExceptionSlot()"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitCXXThrowExprEPKNS_12CXXThrowExprE", "clang::CodeGen::CodeGenFunction::EmitCXXThrowExpr(clang::CXXThrowExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitStartEHSpecEPKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitStartEHSpec(clang::Decl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitEndEHSpecEPKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitEndEHSpec(clang::Decl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitCXXTryStmtERKNS_10CXXTryStmtE", "clang::CodeGen::CodeGenFunction::EmitCXXTryStmt(clang::CXXTryStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EnterCXXTryStmtERKNS_10CXXTryStmtEb", "clang::CodeGen::CodeGenFunction::EnterCXXTryStmt(clang::CXXTryStmt const&, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14ExitCXXTryStmtERKNS_10CXXTryStmtEb", "clang::CodeGen::CodeGenFunction::ExitCXXTryStmt(clang::CXXTryStmt const&, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17getInvokeDestImplEv", "clang::CodeGen::CodeGenFunction::getInvokeDestImpl()"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitLandingPadEv", "clang::CodeGen::CodeGenFunction::EmitLandingPad()"},
    {"_ZN5clang7CodeGen15CodeGenFunction22getTerminateLandingPadEv", "clang::CodeGen::CodeGenFunction::getTerminateLandingPad()"},
    {"_Z22getOpaquePersonalityFnRN5clang7CodeGen13CodeGenModuleERKNS0_13EHPersonalityE", "getOpaquePersonalityFn(clang::CodeGen::CodeGenModule&, clang::CodeGen::EHPersonality const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19getTerminateHandlerEv", "clang::CodeGen::CodeGenFunction::getTerminateHandler()"},
    {"_ZN5clang7CodeGen15CodeGenFunction14getRethrowDestEv", "clang::CodeGen::CodeGenFunction::getRethrowDest()"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EnterFinallyBlockEPKNS_4StmtEPN4llvm8ConstantES7_S7_", "clang::CodeGen::CodeGenFunction::EnterFinallyBlock(clang::Stmt const*, llvm::Constant*, llvm::Constant*, llvm::Constant*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16ExitFinallyBlockERNS1_11FinallyInfoE", "clang::CodeGen::CodeGenFunction::ExitFinallyBlock(clang::CodeGen::CodeGenFunction::FinallyInfo&)"},
    {"_Z14getTerminateFnRN5clang7CodeGen15CodeGenFunctionE", "getTerminateFn(clang::CodeGen::CodeGenFunction&)"},
    {"_ZN12_GLOBAL__N_114PerformFinallyD1Ev", "(anonymous namespace)::PerformFinally::~PerformFinally()"},
    {"_ZN12_GLOBAL__N_114PerformFinallyD0Ev", "(anonymous namespace)::PerformFinally::~PerformFinally()"},
    {"_ZN12_GLOBAL__N_114PerformFinally4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::PerformFinally::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_122CallEndCatchForFinallyD1Ev", "(anonymous namespace)::CallEndCatchForFinally::~CallEndCatchForFinally()"},
    {"_ZN12_GLOBAL__N_122CallEndCatchForFinallyD0Ev", "(anonymous namespace)::CallEndCatchForFinally::~CallEndCatchForFinally()"},
    {"_ZN12_GLOBAL__N_122CallEndCatchForFinally4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallEndCatchForFinally::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_111CallRethrowD1Ev", "(anonymous namespace)::CallRethrow::~CallRethrow()"},
    {"_ZN12_GLOBAL__N_111CallRethrowD0Ev", "(anonymous namespace)::CallRethrow::~CallRethrow()"},
    {"_ZN12_GLOBAL__N_111CallRethrow4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallRethrow::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_Z14CallBeginCatchRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEb", "CallBeginCatch(clang::CodeGen::CodeGenFunction&, llvm::Value*, bool)"},
    {"_Z14InitCatchParamRN5clang7CodeGen15CodeGenFunctionERKNS_7VarDeclEPN4llvm5ValueE", "InitCatchParam(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_112CallEndCatchD1Ev", "(anonymous namespace)::CallEndCatch::~CallEndCatch()"},
    {"_ZN12_GLOBAL__N_112CallEndCatchD0Ev", "(anonymous namespace)::CallEndCatch::~CallEndCatch()"},
    {"_ZN12_GLOBAL__N_112CallEndCatch4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallEndCatch::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~ConditionalCleanup1()"},
    {"_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~ConditionalCleanup1()"},
    {"_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::ConditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_113FreeException4EmitERN5clang7CodeGen15CodeGenFunctionEbPN4llvm5ValueE", "(anonymous namespace)::FreeException::Emit(clang::CodeGen::CodeGenFunction&, bool, llvm::Value*)"},
    {"_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~UnconditionalCleanup1()"},
    {"_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::~UnconditionalCleanup1()"},
    {"_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup1IN12_GLOBAL__N_113FreeExceptionEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::UnconditionalCleanup1<(anonymous namespace)::FreeException, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateInvokeEPNS_5ValueEPNS_10BasicBlockES8_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInvoke(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19getUnreachableBlockEv", "clang::CodeGen::CodeGenFunction::getUnreachableBlock()"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE13CreateInvoke3EPNS_5ValueEPNS_10BasicBlockES8_S6_S6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInvoke3(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*, llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang7CodeGen12EHCatchScope7HandlerELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeGen::EHCatchScope::Handler, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIPNS_5ValueEN5clang7CodeGen15CodeGenFunction10UnwindDestENS_12DenseMapInfoIS2_EENS7_IS6_EEE16InsertIntoBucketERKS2_RKS6_PSt4pairIS2_S6_E", "llvm::DenseMap<llvm::Value*, clang::CodeGen::CodeGenFunction::UnwindDest, llvm::DenseMapInfo<llvm::Value*>, llvm::DenseMapInfo<clang::CodeGen::CodeGenFunction::UnwindDest> >::InsertIntoBucket(llvm::Value* const&, clang::CodeGen::CodeGenFunction::UnwindDest const&, std::pair<llvm::Value*, clang::CodeGen::CodeGenFunction::UnwindDest>*)"},
    {"_ZN4llvm8DenseMapIPNS_5ValueEN5clang7CodeGen15CodeGenFunction10UnwindDestENS_12DenseMapInfoIS2_EENS7_IS6_EEE4growEj", "llvm::DenseMap<llvm::Value*, clang::CodeGen::CodeGenFunction::UnwindDest, llvm::DenseMapInfo<llvm::Value*>, llvm::DenseMapInfo<clang::CodeGen::CodeGenFunction::UnwindDest> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen19DominatingLLVMValue4saveERNS0_15CodeGenFunctionEPN4llvm5ValueE", "clang::CodeGen::DominatingLLVMValue::save(clang::CodeGen::CodeGenFunction&, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitCastToVoidPtrEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCastToVoidPtr(llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16CreateTempAllocaEPKN4llvm4TypeERKNS2_5TwineE", "clang::CodeGen::CodeGenFunction::CreateTempAlloca(llvm::Type const*, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14InitTempAllocaEPN4llvm10AllocaInstEPNS2_5ValueE", "clang::CodeGen::CodeGenFunction::InitTempAlloca(llvm::AllocaInst*, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12CreateIRTempENS_8QualTypeERKN4llvm5TwineE", "clang::CodeGen::CodeGenFunction::CreateIRTemp(clang::QualType, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13CreateMemTempENS_8QualTypeERKN4llvm5TwineE", "clang::CodeGen::CodeGenFunction::CreateMemTemp(clang::QualType, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EvaluateExprAsBoolEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EvaluateExprAsBool(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitIgnoredExprEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitIgnoredExpr(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitAnyExprEPKNS_4ExprENS0_12AggValueSlotEb", "clang::CodeGen::CodeGenFunction::EmitAnyExpr(clang::Expr const*, clang::CodeGen::AggValueSlot, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction10EmitLValueEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitLValue(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitAnyExprToTempEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitAnyExprToTemp(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitAnyExprToMemEPKNS_4ExprEPN4llvm5ValueEbb", "clang::CodeGen::CodeGenFunction::EmitAnyExprToMem(clang::Expr const*, llvm::Value*, bool, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitStoreThroughLValueENS0_6RValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughLValue(clang::CodeGen::RValue, clang::CodeGen::LValue, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitReferenceBindingToExprEPKNS_4ExprEPKNS_9NamedDeclE", "clang::CodeGen::CodeGenFunction::EmitReferenceBindingToExpr(clang::Expr const*, clang::NamedDecl const*)"},
    {"_Z27EmitExprForReferenceBindingRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprERPN4llvm5ValueERPKNS_17CXXDestructorDeclEPKNS_9NamedDeclE", "EmitExprForReferenceBinding(clang::CodeGen::CodeGenFunction&, clang::Expr const*, llvm::Value*&, clang::CXXDestructorDecl const*&, clang::NamedDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18getAccessedFieldNoEjPKN4llvm8ConstantE", "clang::CodeGen::CodeGenFunction::getAccessedFieldNo(unsigned int, llvm::Constant const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction9EmitCheckEPN4llvm5ValueEj", "clang::CodeGen::CodeGenFunction::EmitCheck(llvm::Value*, unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction9getTrapBBEv", "clang::CodeGen::CodeGenFunction::getTrapBB()"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitComplexPrePostIncDecEPKNS_13UnaryOperatorENS0_6LValueEbb", "clang::CodeGen::CodeGenFunction::EmitComplexPrePostIncDec(clang::UnaryOperator const*, clang::CodeGen::LValue, bool, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14GetUndefRValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::GetUndefRValue(clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitUnsupportedRValueEPKNS_4ExprEPKc", "clang::CodeGen::CodeGenFunction::EmitUnsupportedRValue(clang::Expr const*, char const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitUnsupportedLValueEPKNS_4ExprEPKc", "clang::CodeGen::CodeGenFunction::EmitUnsupportedLValue(clang::Expr const*, char const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitCheckedLValueEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitCheckedLValue(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitObjCSelectorLValueEPKNS_16ObjCSelectorExprE", "clang::CodeGen::CodeGenFunction::EmitObjCSelectorLValue(clang::ObjCSelectorExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitBinaryOperatorLValueEPKNS_14BinaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitBinaryOperatorLValue(clang::BinaryOperator const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitCallExprLValueEPKNS_8CallExprE", "clang::CodeGen::CodeGenFunction::EmitCallExprLValue(clang::CallExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitVAArgExprLValueEPKNS_9VAArgExprE", "clang::CodeGen::CodeGenFunction::EmitVAArgExprLValue(clang::VAArgExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitDeclRefLValueEPKNS_11DeclRefExprE", "clang::CodeGen::CodeGenFunction::EmitDeclRefLValue(clang::DeclRefExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitPredefinedLValueEPKNS_14PredefinedExprE", "clang::CodeGen::CodeGenFunction::EmitPredefinedLValue(clang::PredefinedExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction23EmitStringLiteralLValueEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenFunction::EmitStringLiteralLValue(clang::StringLiteral const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitObjCEncodeExprLValueEPKNS_14ObjCEncodeExprE", "clang::CodeGen::CodeGenFunction::EmitObjCEncodeExprLValue(clang::ObjCEncodeExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitBlockDeclRefLValueEPKNS_16BlockDeclRefExprE", "clang::CodeGen::CodeGenFunction::EmitBlockDeclRefLValue(clang::BlockDeclRefExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitCXXConstructLValueEPKNS_16CXXConstructExprE", "clang::CodeGen::CodeGenFunction::EmitCXXConstructLValue(clang::CXXConstructExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitCXXBindTemporaryLValueEPKNS_20CXXBindTemporaryExprE", "clang::CodeGen::CodeGenFunction::EmitCXXBindTemporaryLValue(clang::CXXBindTemporaryExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction28EmitNullInitializationLValueEPKNS_22CXXScalarValueInitExprE", "clang::CodeGen::CodeGenFunction::EmitNullInitializationLValue(clang::CXXScalarValueInitExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitCXXTypeidLValueEPKNS_13CXXTypeidExprE", "clang::CodeGen::CodeGenFunction::EmitCXXTypeidLValue(clang::CXXTypeidExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25EmitObjCMessageExprLValueEPKNS_15ObjCMessageExprE", "clang::CodeGen::CodeGenFunction::EmitObjCMessageExprLValue(clang::ObjCMessageExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitObjCIvarRefLValueEPKNS_15ObjCIvarRefExprE", "clang::CodeGen::CodeGenFunction::EmitObjCIvarRefLValue(clang::ObjCIvarRefExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitStmtExprLValueEPKNS_8StmtExprE", "clang::CodeGen::CodeGenFunction::EmitStmtExprLValue(clang::StmtExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitUnaryOpLValueEPKNS_13UnaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitUnaryOpLValue(clang::UnaryOperator const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitArraySubscriptExprEPKNS_18ArraySubscriptExprE", "clang::CodeGen::CodeGenFunction::EmitArraySubscriptExpr(clang::ArraySubscriptExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitExtVectorElementExprEPKNS_20ExtVectorElementExprE", "clang::CodeGen::CodeGenFunction::EmitExtVectorElementExpr(clang::ExtVectorElementExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitMemberExprEPKNS_10MemberExprE", "clang::CodeGen::CodeGenFunction::EmitMemberExpr(clang::MemberExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25EmitCompoundLiteralLValueEPKNS_19CompoundLiteralExprE", "clang::CodeGen::CodeGenFunction::EmitCompoundLiteralLValue(clang::CompoundLiteralExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction29EmitConditionalOperatorLValueEPKNS_19ConditionalOperatorE", "clang::CodeGen::CodeGenFunction::EmitConditionalOperatorLValue(clang::ConditionalOperator const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitCastLValueEPKNS_8CastExprE", "clang::CodeGen::CodeGenFunction::EmitCastLValue(clang::CastExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitLoadOfScalarEPN4llvm5ValueEbjNS_8QualTypeEPNS2_6MDNodeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfScalar(llvm::Value*, bool, unsigned int, clang::QualType, llvm::MDNode*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitFromMemoryEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitFromMemory(llvm::Value*, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitToMemoryEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitToMemory(llvm::Value*, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitStoreOfScalarEPN4llvm5ValueES4_bjNS_8QualTypeEPNS2_6MDNodeE", "clang::CodeGen::CodeGenFunction::EmitStoreOfScalar(llvm::Value*, llvm::Value*, bool, unsigned int, clang::QualType, llvm::MDNode*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitLoadOfLValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfLValue(clang::CodeGen::LValue, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction32EmitLoadOfExtVectorElementLValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfExtVectorElementLValue(clang::CodeGen::LValue, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24EmitLoadOfBitfieldLValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitLoadOfBitfieldLValue(clang::CodeGen::LValue, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction40EmitStoreThroughExtVectorComponentLValueENS0_6RValueENS0_6LValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughExtVectorComponentLValue(clang::CodeGen::RValue, clang::CodeGen::LValue, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction30EmitStoreThroughBitfieldLValueENS0_6RValueENS0_6LValueENS_8QualTypeEPPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughBitfieldLValue(clang::CodeGen::RValue, clang::CodeGen::LValue, clang::QualType, llvm::Value**)"},
    {"_Z23EmitGlobalVarDeclLValueRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprEPKNS_7VarDeclE", "EmitGlobalVarDeclLValue(clang::CodeGen::CodeGenFunction&, clang::Expr const*, clang::VarDecl const*)"},
    {"_Z20setObjCGCLValueClassRKN5clang10ASTContextEPKNS_4ExprERNS_7CodeGen6LValueE", "setObjCGCLValueClass(clang::ASTContext const&, clang::Expr const*, clang::CodeGen::LValue&)"},
    {"_Z22EmitFunctionDeclLValueRN5clang7CodeGen15CodeGenFunctionEPKNS_4ExprEPKNS_12FunctionDeclE", "EmitFunctionDeclLValue(clang::CodeGen::CodeGenFunction&, clang::Expr const*, clang::FunctionDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitLValueForFieldEPN4llvm5ValueEPKNS_9FieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForField(llvm::Value*, clang::FieldDecl const*, unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitLValueForBitfieldEPN4llvm5ValueEPKNS_9FieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForBitfield(llvm::Value*, clang::FieldDecl const*, unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction28EmitLValueForAnonRecordFieldEPN4llvm5ValueEPKNS_17IndirectFieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForAnonRecordField(llvm::Value*, clang::IndirectFieldDecl const*, unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction32EmitLValueForFieldInitializationEPN4llvm5ValueEPKNS_9FieldDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForFieldInitialization(llvm::Value*, clang::FieldDecl const*, unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitCallExprEPKNS_8CallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCallExpr(clang::CallExpr const*, clang::CodeGen::ReturnValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction8EmitCallENS_8QualTypeEPN4llvm5ValueENS0_15ReturnValueSlotENS_17ConstExprIteratorES7_PKNS_4DeclE", "clang::CodeGen::CodeGenFunction::EmitCall(clang::QualType, llvm::Value*, clang::CodeGen::ReturnValueSlot, clang::ConstExprIterator, clang::ConstExprIterator, clang::Decl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction33EmitPointerToDataMemberBinaryExprEPKNS_14BinaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitPointerToDataMemberBinaryExpr(clang::BinaryOperator const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitIvarOffsetEPKNS_17ObjCInterfaceDeclEPKNS_12ObjCIvarDeclE", "clang::CodeGen::CodeGenFunction::EmitIvarOffset(clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitLValueForIvarENS_8QualTypeEPN4llvm5ValueEPKNS_12ObjCIvarDeclEj", "clang::CodeGen::CodeGenFunction::EmitLValueForIvar(clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_119SubobjectAdjustmentEE9push_backERKS2_", "llvm::SmallVectorImpl<(anonymous namespace)::SubobjectAdjustment>::push_back((anonymous namespace)::SubobjectAdjustment const&)"},
    {"_Z24CreateReferenceTemporaryRN5clang7CodeGen15CodeGenFunctionENS_8QualTypeEPKNS_9NamedDeclE", "CreateReferenceTemporary(clang::CodeGen::CodeGenFunction&, clang::QualType, clang::NamedDecl const*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE17CreateInBoundsGEPIPPNS_5ValueEEES7_S7_T_S9_RKNS_5TwineE", "llvm::Value* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInBoundsGEP<llvm::Value**>(llvm::Value*, llvm::Value**, llvm::Value**, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitCallArgsINS_17FunctionProtoTypeEEEvRN4llvm11SmallVectorISt4pairINS0_6RValueENS_8QualTypeEELj16EEEPKT_NS_17ConstExprIteratorESF_", "void clang::CodeGen::CodeGenFunction::EmitCallArgs<clang::FunctionProtoType>(llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u>&, clang::FunctionProtoType const*, clang::ConstExprIterator, clang::ConstExprIterator)"},
    {"_ZN4llvm8DenseMapIPKN5clang4ExprENS1_7CodeGen6LValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::Expr const*, clang::CodeGen::LValue, llvm::DenseMapInfo<clang::Expr const*>, llvm::DenseMapInfo<clang::CodeGen::LValue> >::InsertIntoBucket(clang::Expr const* const&, clang::CodeGen::LValue const&, std::pair<clang::Expr const*, clang::CodeGen::LValue>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4ExprENS1_7CodeGen6LValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::Expr const*, clang::CodeGen::LValue, llvm::DenseMapInfo<clang::Expr const*>, llvm::DenseMapInfo<clang::CodeGen::LValue> >::grow(unsigned int)"},
    {"_ZN4llvm11SmallVectorIPNS_8ConstantELj4EEC2EjRKS2_", "llvm::SmallVector<llvm::Constant*, 4u>::SmallVector(unsigned int, llvm::Constant* const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitAggExprEPKNS_4ExprENS0_12AggValueSlotEb", "clang::CodeGen::CodeGenFunction::EmitAggExpr(clang::Expr const*, clang::CodeGen::AggValueSlot, bool)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_114AggExprEmitterEvE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::AggExprEmitter, void>::Visit(clang::Stmt*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitAggExprToLValueEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitAggExprToLValue(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitAggregateCopyEPN4llvm5ValueES4_NS_8QualTypeEb", "clang::CodeGen::CodeGenFunction::EmitAggregateCopy(llvm::Value*, llvm::Value*, clang::QualType, bool)"},
    {"_ZN12_GLOBAL__N_114AggExprEmitter13VisitCallExprEPKN5clang8CallExprE", "(anonymous namespace)::AggExprEmitter::VisitCallExpr(clang::CallExpr const*)"},
    {"_ZN12_GLOBAL__N_114AggExprEmitter17EmitFinalDestCopyEPKN5clang4ExprENS1_7CodeGen6LValueEb", "(anonymous namespace)::AggExprEmitter::EmitFinalDestCopy(clang::Expr const*, clang::CodeGen::LValue, bool)"},
    {"_ZN12_GLOBAL__N_114AggExprEmitter10EmitGCMoveEPKN5clang4ExprENS1_7CodeGen6RValueE", "(anonymous namespace)::AggExprEmitter::EmitGCMove(clang::Expr const*, clang::CodeGen::RValue)"},
    {"_ZN12_GLOBAL__N_114AggExprEmitter26EmitInitializationToLValueEPN5clang4ExprENS1_7CodeGen6LValueENS1_8QualTypeE", "(anonymous namespace)::AggExprEmitter::EmitInitializationToLValue(clang::Expr*, clang::CodeGen::LValue, clang::QualType)"},
    {"_ZN12_GLOBAL__N_114AggExprEmitter30EmitNullInitializationToLValueEN5clang7CodeGen6LValueENS1_8QualTypeE", "(anonymous namespace)::AggExprEmitter::EmitNullInitializationToLValue(clang::CodeGen::LValue, clang::QualType)"},
    {"_Z12isSimpleZeroPKN5clang4ExprERNS_7CodeGen15CodeGenFunctionE", "isSimpleZero(clang::Expr const*, clang::CodeGen::CodeGenFunction&)"},
    {"_ZN12_GLOBAL__N_114AggExprEmitter13VisitCastExprEPN5clang8CastExprE", "(anonymous namespace)::AggExprEmitter::VisitCastExpr(clang::CastExpr*)"},
    {"_Z24GetNumNonZeroBytesInInitPKN5clang4ExprERNS_7CodeGen15CodeGenFunctionE", "GetNumNonZeroBytesInInit(clang::Expr const*, clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitCXXMemberCallEPKNS_13CXXMethodDeclEPN4llvm5ValueENS0_15ReturnValueSlotES7_S7_NS_17ConstExprIteratorES9_", "clang::CodeGen::CodeGenFunction::EmitCXXMemberCall(clang::CXXMethodDecl const*, llvm::Value*, clang::CodeGen::ReturnValueSlot, llvm::Value*, llvm::Value*, clang::ConstExprIterator, clang::ConstExprIterator)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitCXXMemberCallExprEPKNS_17CXXMemberCallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXMemberCallExpr(clang::CXXMemberCallExpr const*, clang::CodeGen::ReturnValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction28EmitCXXMemberPointerCallExprEPKNS_17CXXMemberCallExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXMemberPointerCallExpr(clang::CXXMemberCallExpr const*, clang::CodeGen::ReturnValueSlot)"},
    {"_Z34canDevirtualizeMemberFunctionCallsRN5clang10ASTContextEPKNS_4ExprEPKNS_13CXXMethodDeclE", "canDevirtualizeMemberFunctionCalls(clang::ASTContext&, clang::Expr const*, clang::CXXMethodDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction29EmitCXXOperatorMemberCallExprEPKNS_19CXXOperatorCallExprEPKNS_13CXXMethodDeclENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXOperatorMemberCallExpr(clang::CXXOperatorCallExpr const*, clang::CXXMethodDecl const*, clang::CodeGen::ReturnValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitCXXConstructExprEPKNS_16CXXConstructExprENS0_12AggValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCXXConstructExpr(clang::CXXConstructExpr const*, clang::CodeGen::AggValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitSynthesizedCXXCopyCtorEPN4llvm5ValueES4_PKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitSynthesizedCXXCopyCtor(llvm::Value*, llvm::Value*, clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction23EmitNewArrayInitializerEPKNS_10CXXNewExprEPN4llvm5ValueES7_", "clang::CodeGen::CodeGenFunction::EmitNewArrayInitializer(clang::CXXNewExpr const*, llvm::Value*, llvm::Value*)"},
    {"_Z23StoreAnyExprIntoOneUnitRN5clang7CodeGen15CodeGenFunctionEPKNS_10CXXNewExprEPN4llvm5ValueE", "StoreAnyExprIntoOneUnit(clang::CodeGen::CodeGenFunction&, clang::CXXNewExpr const*, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitCXXNewExprEPKNS_10CXXNewExprE", "clang::CodeGen::CodeGenFunction::EmitCXXNewExpr(clang::CXXNewExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitDeleteCallEPKNS_12FunctionDeclEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitDeleteCall(clang::FunctionDecl const*, llvm::Value*, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitCXXDeleteExprEPKNS_13CXXDeleteExprE", "clang::CodeGen::CodeGenFunction::EmitCXXDeleteExpr(clang::CXXDeleteExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitCXXTypeidExprEPKNS_13CXXTypeidExprE", "clang::CodeGen::CodeGenFunction::EmitCXXTypeidExpr(clang::CXXTypeidExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitDynamicCastEPN4llvm5ValueEPKNS_18CXXDynamicCastExprE", "clang::CodeGen::CodeGenFunction::EmitDynamicCast(llvm::Value*, clang::CXXDynamicCastExpr const*)"},
    {"_ZN12_GLOBAL__N_116CallObjectDeleteD1Ev", "(anonymous namespace)::CallObjectDelete::~CallObjectDelete()"},
    {"_ZN12_GLOBAL__N_116CallObjectDeleteD0Ev", "(anonymous namespace)::CallObjectDelete::~CallObjectDelete()"},
    {"_ZN12_GLOBAL__N_116CallObjectDelete4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallObjectDelete::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_115CallArrayDeleteD1Ev", "(anonymous namespace)::CallArrayDelete::~CallArrayDelete()"},
    {"_ZN12_GLOBAL__N_115CallArrayDeleteD0Ev", "(anonymous namespace)::CallArrayDelete::~CallArrayDelete()"},
    {"_ZN12_GLOBAL__N_115CallArrayDelete4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallArrayDelete::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_130CallDeleteDuringConditionalNewD1Ev", "(anonymous namespace)::CallDeleteDuringConditionalNew::~CallDeleteDuringConditionalNew()"},
    {"_ZN12_GLOBAL__N_130CallDeleteDuringConditionalNewD0Ev", "(anonymous namespace)::CallDeleteDuringConditionalNew::~CallDeleteDuringConditionalNew()"},
    {"_ZN12_GLOBAL__N_130CallDeleteDuringConditionalNew4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallDeleteDuringConditionalNew::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_119CallDeleteDuringNewD1Ev", "(anonymous namespace)::CallDeleteDuringNew::~CallDeleteDuringNew()"},
    {"_ZN12_GLOBAL__N_119CallDeleteDuringNewD0Ev", "(anonymous namespace)::CallDeleteDuringNew::~CallDeleteDuringNew()"},
    {"_ZN12_GLOBAL__N_119CallDeleteDuringNew4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallDeleteDuringNew::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitComplexExprEPKNS_4ExprEbb", "clang::CodeGen::CodeGenFunction::EmitComplexExpr(clang::Expr const*, bool, bool)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter5VisitEPN5clang4ExprE", "(anonymous namespace)::ComplexExprEmitter::Visit(clang::Expr*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction23EmitComplexExprIntoAddrEPKNS_4ExprEPN4llvm5ValueEb", "clang::CodeGen::CodeGenFunction::EmitComplexExprIntoAddr(clang::Expr const*, llvm::Value*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18StoreComplexToAddrESt4pairIPN4llvm5ValueES5_ES5_b", "clang::CodeGen::CodeGenFunction::StoreComplexToAddr(std::pair<llvm::Value*, llvm::Value*>, llvm::Value*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19LoadComplexFromAddrEPN4llvm5ValueEb", "clang::CodeGen::CodeGenFunction::LoadComplexFromAddr(llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter17EmitLoadOfComplexEPN4llvm5ValueEb", "(anonymous namespace)::ComplexExprEmitter::EmitLoadOfComplex(llvm::Value*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction27EmitComplexAssignmentLValueEPKNS_14BinaryOperatorE", "clang::CodeGen::CodeGenFunction::EmitComplexAssignmentLValue(clang::BinaryOperator const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction35EmitComplexCompoundAssignmentLValueEPKNS_22CompoundAssignOperatorE", "clang::CodeGen::CodeGenFunction::EmitComplexCompoundAssignmentLValue(clang::CompoundAssignOperator const*)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinMulERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinMul((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinDivERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinDiv((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinSubERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinSub((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter10EmitBinAddERKNS0_9BinOpInfoE", "(anonymous namespace)::ComplexExprEmitter::EmitBinAdd((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter24EmitCompoundAssignLValueEPKN5clang22CompoundAssignOperatorEMS0_FSt4pairIPN4llvm5ValueES8_ERKNS0_9BinOpInfoEERS9_", "(anonymous namespace)::ComplexExprEmitter::EmitCompoundAssignLValue(clang::CompoundAssignOperator const*, std::pair<llvm::Value*, llvm::Value*> ((anonymous namespace)::ComplexExprEmitter::*)((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&), std::pair<llvm::Value*, llvm::Value*>&)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter24EmitComplexToComplexCastESt4pairIPN4llvm5ValueES4_EN5clang8QualTypeES7_", "(anonymous namespace)::ComplexExprEmitter::EmitComplexToComplexCast(std::pair<llvm::Value*, llvm::Value*>, clang::QualType, clang::QualType)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter22EmitStoreThroughLValueESt4pairIPN4llvm5ValueES4_EN5clang7CodeGen6LValueE", "(anonymous namespace)::ComplexExprEmitter::EmitStoreThroughLValue(std::pair<llvm::Value*, llvm::Value*>, clang::CodeGen::LValue)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_118ComplexExprEmitterESt4pairIPN4llvm5ValueES6_EE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::ComplexExprEmitter, std::pair<llvm::Value*, llvm::Value*> >::Visit(clang::Stmt*)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter9VisitExprEPN5clang4ExprE", "(anonymous namespace)::ComplexExprEmitter::VisitExpr(clang::Expr*)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter16EmitLoadOfLValueEPKN5clang4ExprE", "(anonymous namespace)::ComplexExprEmitter::EmitLoadOfLValue(clang::Expr const*)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter8EmitCastEN5clang8CastKindEPNS1_4ExprENS1_8QualTypeE", "(anonymous namespace)::ComplexExprEmitter::EmitCast(clang::CastKind, clang::Expr*, clang::QualType)"},
    {"_ZN12_GLOBAL__N_118ComplexExprEmitter18EmitCompoundAssignEPKN5clang22CompoundAssignOperatorEMS0_FSt4pairIPN4llvm5ValueES8_ERKNS0_9BinOpInfoEE", "(anonymous namespace)::ComplexExprEmitter::EmitCompoundAssign(clang::CompoundAssignOperator const*, std::pair<llvm::Value*, llvm::Value*> ((anonymous namespace)::ComplexExprEmitter::*)((anonymous namespace)::ComplexExprEmitter::BinOpInfo const&))"},
    {"_ZN4llvm8DenseMapIPKN5clang4ExprESt4pairIPNS_5ValueES7_ENS_12DenseMapInfoIS4_EENS9_IS8_EEE16InsertIntoBucketERKS4_RKS8_PS5_IS4_S8_E", "llvm::DenseMap<clang::Expr const*, std::pair<llvm::Value*, llvm::Value*>, llvm::DenseMapInfo<clang::Expr const*>, llvm::DenseMapInfo<std::pair<llvm::Value*, llvm::Value*> > >::InsertIntoBucket(clang::Expr const* const&, std::pair<llvm::Value*, llvm::Value*> const&, std::pair<clang::Expr const*, std::pair<llvm::Value*, llvm::Value*> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4ExprESt4pairIPNS_5ValueES7_ENS_12DenseMapInfoIS4_EENS9_IS8_EEE4growEj", "llvm::DenseMap<clang::Expr const*, std::pair<llvm::Value*, llvm::Value*>, llvm::DenseMapInfo<clang::Expr const*>, llvm::DenseMapInfo<std::pair<llvm::Value*, llvm::Value*> > >::grow(unsigned int)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateFNegEPNS_5ValueERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateFNeg(llvm::Value*, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule16EmitConstantExprEPKNS_4ExprENS_8QualTypeEPNS0_15CodeGenFunctionE", "clang::CodeGen::CodeGenModule::EmitConstantExpr(clang::Expr const*, clang::QualType, clang::CodeGen::CodeGenFunction*)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_116ConstExprEmitterEPN4llvm8ConstantEE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::ConstExprEmitter, llvm::Constant*>::Visit(clang::Stmt*)"},
    {"_ZN5clang7CodeGen13CodeGenModule24getMemberPointerConstantEPKNS_13UnaryOperatorE", "clang::CodeGen::CodeGenModule::getMemberPointerConstant(clang::UnaryOperator const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule16EmitNullConstantENS_8QualTypeE", "clang::CodeGen::CodeGenModule::EmitNullConstant(clang::QualType)"},
    {"_Z16EmitNullConstantRN5clang7CodeGen13CodeGenModuleEPKNS_13CXXRecordDeclE", "EmitNullConstant(clang::CodeGen::CodeGenModule&, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_116ConstExprEmitter21VisitCXXConstructExprEPN5clang16CXXConstructExprE", "(anonymous namespace)::ConstExprEmitter::VisitCXXConstructExpr(clang::CXXConstructExpr*)"},
    {"_ZN12_GLOBAL__N_116ConstExprEmitter23EmitArrayInitializationEPN5clang12InitListExprE", "(anonymous namespace)::ConstExprEmitter::EmitArrayInitialization(clang::InitListExpr*)"},
    {"_ZN12_GLOBAL__N_118ConstStructBuilder5BuildEPN5clang12InitListExprE", "(anonymous namespace)::ConstStructBuilder::Build(clang::InitListExpr*)"},
    {"_ZN12_GLOBAL__N_118ConstStructBuilder21ConvertStructToPackedEv", "(anonymous namespace)::ConstStructBuilder::ConvertStructToPacked()"},
    {"_ZN12_GLOBAL__N_118ConstStructBuilder13AppendPaddingEy", "(anonymous namespace)::ConstStructBuilder::AppendPadding(unsigned long long)"},
    {"_ZNK12_GLOBAL__N_118ConstStructBuilder14getSizeInBytesEPKN4llvm8ConstantE", "(anonymous namespace)::ConstStructBuilder::getSizeInBytes(llvm::Constant const*) const"},
    {"_ZN12_GLOBAL__N_116ConstExprEmitter13VisitCastExprEPN5clang8CastExprE", "(anonymous namespace)::ConstExprEmitter::VisitCastExpr(clang::CastExpr*)"},
    {"_Z28FillInNullDataMemberPointersRN5clang7CodeGen13CodeGenModuleENS_8QualTypeERSt6vectorIPN4llvm8ConstantESaIS7_EEy", "FillInNullDataMemberPointers(clang::CodeGen::CodeGenModule&, clang::QualType, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> >&, unsigned long long)"},
    {"_ZNSt6vectorIPN4llvm8ConstantESaIS2_EEaSERKS4_", "std::vector<llvm::Constant*, std::allocator<llvm::Constant*> >::operator=(std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclEPNS_5ValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::Decl const*, llvm::Value*, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::Value*> >::InsertIntoBucket(clang::Decl const* const&, llvm::Value* const&, std::pair<clang::Decl const*, llvm::Value*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclEPNS_5ValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::Decl const*, llvm::Value*, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<llvm::Value*> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitScalarExprEPKNS_4ExprEb", "clang::CodeGen::CodeGenFunction::EmitScalarExpr(clang::Expr const*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitScalarConversionEPN4llvm5ValueENS_8QualTypeES5_", "clang::CodeGen::CodeGenFunction::EmitScalarConversion(llvm::Value*, clang::QualType, clang::QualType)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter20EmitScalarConversionEPN4llvm5ValueEN5clang8QualTypeES5_", "(anonymous namespace)::ScalarExprEmitter::EmitScalarConversion(llvm::Value*, clang::QualType, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction29EmitComplexToScalarConversionESt4pairIPN4llvm5ValueES5_ENS_8QualTypeES7_", "clang::CodeGen::CodeGenFunction::EmitComplexToScalarConversion(std::pair<llvm::Value*, llvm::Value*>, clang::QualType, clang::QualType)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter29EmitComplexToScalarConversionESt4pairIPN4llvm5ValueES4_EN5clang8QualTypeES7_", "(anonymous namespace)::ScalarExprEmitter::EmitComplexToScalarConversion(std::pair<llvm::Value*, llvm::Value*>, clang::QualType, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction23EmitScalarPrePostIncDecEPKNS_13UnaryOperatorENS0_6LValueEbb", "clang::CodeGen::CodeGenFunction::EmitScalarPrePostIncDec(clang::UnaryOperator const*, clang::CodeGen::LValue, bool, bool)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter23EmitScalarPrePostIncDecEPKN5clang13UnaryOperatorENS1_7CodeGen6LValueEbb", "(anonymous namespace)::ScalarExprEmitter::EmitScalarPrePostIncDec(clang::UnaryOperator const*, clang::CodeGen::LValue, bool, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitObjCIsaExprEPKNS_11ObjCIsaExprE", "clang::CodeGen::CodeGenFunction::EmitObjCIsaExpr(clang::ObjCIsaExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction28EmitCompoundAssignmentLValueEPKNS_22CompoundAssignOperatorE", "clang::CodeGen::CodeGenFunction::EmitCompoundAssignmentLValue(clang::CompoundAssignOperator const*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter24EmitCompoundAssignLValueEPKN5clang22CompoundAssignOperatorEMS0_FPN4llvm5ValueERKNS_9BinOpInfoEERS7_", "(anonymous namespace)::ScalarExprEmitter::EmitCompoundAssignLValue(clang::CompoundAssignOperator const*, llvm::Value* ((anonymous namespace)::ScalarExprEmitter::*)((anonymous namespace)::BinOpInfo const&), llvm::Value*&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitMulERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitMul((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitDivERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitDiv((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitRemERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitRem((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitAddERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitAdd((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitSubERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitSub((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitShlERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitShl((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitShrERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitShr((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitAndERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitAnd((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter7EmitXorERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitXor((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter6EmitOrERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitOr((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter24EmitOverflowCheckedBinOpERKNS_9BinOpInfoE", "(anonymous namespace)::ScalarExprEmitter::EmitOverflowCheckedBinOp((anonymous namespace)::BinOpInfo const&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter42EmitUndefinedBehaviorIntegerDivAndRemCheckERKNS_9BinOpInfoEPN4llvm5ValueEb", "(anonymous namespace)::ScalarExprEmitter::EmitUndefinedBehaviorIntegerDivAndRemCheck((anonymous namespace)::BinOpInfo const&, llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter31EmitAddConsiderOverflowBehaviorEPKN5clang13UnaryOperatorEPN4llvm5ValueES7_b", "(anonymous namespace)::ScalarExprEmitter::EmitAddConsiderOverflowBehavior(clang::UnaryOperator const*, llvm::Value*, llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter25EmitFloatToBoolConversionEPN4llvm5ValueE", "(anonymous namespace)::ScalarExprEmitter::EmitFloatToBoolConversion(llvm::Value*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter23EmitIntToBoolConversionEPN4llvm5ValueE", "(anonymous namespace)::ScalarExprEmitter::EmitIntToBoolConversion(llvm::Value*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter27EmitPointerToBoolConversionEPN4llvm5ValueE", "(anonymous namespace)::ScalarExprEmitter::EmitPointerToBoolConversion(llvm::Value*)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_117ScalarExprEmitterEPN4llvm5ValueEE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::ScalarExprEmitter, llvm::Value*>::Visit(clang::Stmt*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter13VisitCallExprEPKN5clang8CallExprE", "(anonymous namespace)::ScalarExprEmitter::VisitCallExpr(clang::CallExpr const*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter13EmitNullValueEN5clang8QualTypeE", "(anonymous namespace)::ScalarExprEmitter::EmitNullValue(clang::QualType)"},
    {"_Z38isCheapEnoughToEvaluateUnconditionallyPKN5clang4ExprERNS_7CodeGen15CodeGenFunctionE", "isCheapEnoughToEvaluateUnconditionally(clang::Expr const*, clang::CodeGen::CodeGenFunction&)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter12EmitCastExprEPN5clang8CastExprE", "(anonymous namespace)::ScalarExprEmitter::EmitCastExpr(clang::CastExpr*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter18EmitCompoundAssignEPKN5clang22CompoundAssignOperatorEMS0_FPN4llvm5ValueERKNS_9BinOpInfoEE", "(anonymous namespace)::ScalarExprEmitter::EmitCompoundAssign(clang::CompoundAssignOperator const*, llvm::Value* ((anonymous namespace)::ScalarExprEmitter::*)((anonymous namespace)::BinOpInfo const&))"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter10EmitBinOpsEPKN5clang14BinaryOperatorE", "(anonymous namespace)::ScalarExprEmitter::EmitBinOps(clang::BinaryOperator const*)"},
    {"_ZN12_GLOBAL__N_117ScalarExprEmitter11EmitCompareEPKN5clang14BinaryOperatorEjjj", "(anonymous namespace)::ScalarExprEmitter::EmitCompare(clang::BinaryOperator const*, unsigned int, unsigned int, unsigned int)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateXorEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateXor(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateLShrEPNS_5ValueES6_RKNS_5TwineEb", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateLShr(llvm::Value*, llvm::Value*, llvm::Twine const&, bool)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateShlEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateShl(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateFSubEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateFSub(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateNegEPNS_5ValueERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateNeg(llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateSDivEPNS_5ValueES6_RKNS_5TwineEb", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateSDiv(llvm::Value*, llvm::Value*, llvm::Twine const&, bool)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE11CreateCall4EPNS_5ValueES6_S6_S6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall4(llvm::Value*, llvm::Value*, llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateFAddEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateFAdd(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateURemEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateURem(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateSRemEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateSRem(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateFDivEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateFDiv(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateUDivEPNS_5ValueES6_RKNS_5TwineEb", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateUDiv(llvm::Value*, llvm::Value*, llvm::Twine const&, bool)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateFCmpENS_7CmpInst9PredicateEPNS_5ValueES8_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateFCmp(llvm::CmpInst::Predicate, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateNSWMulEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateNSWMul(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateFMulEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateFMul(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE19CreateInsertElementEPNS_5ValueES6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInsertElement(llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE19CreateShuffleVectorEPNS_5ValueES6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateShuffleVector(llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE11CreateVAArgEPNS_5ValueEPKNS_4TypeERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateVAArg(llvm::Value*, llvm::Type const*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE20CreateExtractElementEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateExtractElement(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateNotEPNS_5ValueERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateNot(llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE19CreateZExtOrBitCastEPNS_5ValueEPKNS_4TypeERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateZExtOrBitCast(llvm::Value*, llvm::Type const*, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21EmitObjCStringLiteralEPKNS_17ObjCStringLiteralE", "clang::CodeGen::CodeGenFunction::EmitObjCStringLiteral(clang::ObjCStringLiteral const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitObjCSelectorExprEPKNS_16ObjCSelectorExprE", "clang::CodeGen::CodeGenFunction::EmitObjCSelectorExpr(clang::ObjCSelectorExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitObjCProtocolExprEPKNS_16ObjCProtocolExprE", "clang::CodeGen::CodeGenFunction::EmitObjCProtocolExpr(clang::ObjCProtocolExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitObjCMessageExprEPKNS_15ObjCMessageExprENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitObjCMessageExpr(clang::ObjCMessageExpr const*, clang::CodeGen::ReturnValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12LoadObjCSelfEv", "clang::CodeGen::CodeGenFunction::LoadObjCSelf()"},
    {"_ZN5clang7CodeGen15CodeGenFunction15StartObjCMethodEPKNS_14ObjCMethodDeclEPKNS_17ObjCContainerDeclE", "clang::CodeGen::CodeGenFunction::StartObjCMethod(clang::ObjCMethodDecl const*, clang::ObjCContainerDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18GenerateObjCMethodEPKNS_14ObjCMethodDeclE", "clang::CodeGen::CodeGenFunction::GenerateObjCMethod(clang::ObjCMethodDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18GenerateObjCGetterEPNS_22ObjCImplementationDeclEPKNS_20ObjCPropertyImplDeclE", "clang::CodeGen::CodeGenFunction::GenerateObjCGetter(clang::ObjCImplementationDecl*, clang::ObjCPropertyImplDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16TypeOfSelfObjectEv", "clang::CodeGen::CodeGenFunction::TypeOfSelfObject()"},
    {"_ZN5clang7CodeGen15CodeGenFunction25IvarTypeWithAggrGCObjectsENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::IvarTypeWithAggrGCObjects(clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18GenerateObjCSetterEPNS_22ObjCImplementationDeclEPKNS_20ObjCPropertyImplDeclE", "clang::CodeGen::CodeGenFunction::GenerateObjCSetter(clang::ObjCImplementationDecl*, clang::ObjCPropertyImplDecl const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction21IndirectObjCSetterArgERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenFunction::IndirectObjCSetterArg(clang::CodeGen::CGFunctionInfo const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26GenerateObjCCtorDtorMethodEPNS_22ObjCImplementationDeclEPNS_14ObjCMethodDeclEb", "clang::CodeGen::CodeGenFunction::GenerateObjCCtorDtorMethod(clang::ObjCImplementationDecl*, clang::ObjCMethodDecl*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25EmitObjCPropertyRefLValueEPKNS_19ObjCPropertyRefExprE", "clang::CodeGen::CodeGenFunction::EmitObjCPropertyRefLValue(clang::ObjCPropertyRefExpr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction27EmitLoadOfPropertyRefLValueENS0_6LValueENS0_15ReturnValueSlotE", "clang::CodeGen::CodeGenFunction::EmitLoadOfPropertyRefLValue(clang::CodeGen::LValue, clang::CodeGen::ReturnValueSlot)"},
    {"_Z24GenerateMessageSendSuperRN5clang7CodeGen15CodeGenFunctionENS0_15ReturnValueSlotENS_8QualTypeENS_8SelectorEPN4llvm5ValueERKNS6_11SmallVectorISt4pairINS0_6RValueES4_ELj16EEE", "GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction33EmitStoreThroughPropertyRefLValueENS0_6RValueENS0_6LValueE", "clang::CodeGen::CodeGenFunction::EmitStoreThroughPropertyRefLValue(clang::CodeGen::RValue, clang::CodeGen::LValue)"},
    {"_ZN5clang7CodeGen15CodeGenFunction25EmitObjCForCollectionStmtERKNS_21ObjCForCollectionStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCForCollectionStmt(clang::ObjCForCollectionStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitObjCAtTryStmtERKNS_13ObjCAtTryStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCAtTryStmt(clang::ObjCAtTryStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19EmitObjCAtThrowStmtERKNS_15ObjCAtThrowStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCAtThrowStmt(clang::ObjCAtThrowStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitObjCAtSynchronizedStmtERKNS_22ObjCAtSynchronizedStmtE", "clang::CodeGen::CodeGenFunction::EmitObjCAtSynchronizedStmt(clang::ObjCAtSynchronizedStmt const&)"},
    {"_ZN5clang7CodeGen13CGObjCRuntimeD0Ev", "clang::CodeGen::CGObjCRuntime::~CGObjCRuntime()"},
    {"_ZN5clang7CodeGen13CGObjCRuntimeD1Ev", "clang::CodeGen::CGObjCRuntime::~CGObjCRuntime()"},
    {"_ZN5clang7CodeGen13CGObjCRuntimeD2Ev", "clang::CodeGen::CGObjCRuntime::~CGObjCRuntime()"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitCallArgsINS_14ObjCMethodDeclEEEvRN4llvm11SmallVectorISt4pairINS0_6RValueENS_8QualTypeEELj16EEEPKT_NS_17ConstExprIteratorESF_", "void clang::CodeGen::CodeGenFunction::EmitCallArgs<clang::ObjCMethodDecl>(llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u>&, clang::ObjCMethodDecl const*, clang::ConstExprIterator, clang::ConstExprIterator)"},
    {"_ZNK5clang9ValueDecl7getTypeEv", "clang::ValueDecl::getType() const"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang7CodeGen15CodeGenFunction13BreakContinueELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeGen::CodeGenFunction::BreakContinue, false>::grow(unsigned long)"},
    {"_ZN5clang7CodeGen20CreateGNUObjCRuntimeERNS0_13CodeGenModuleE", "clang::CodeGen::CreateGNUObjCRuntime(clang::CodeGen::CodeGenModule&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNUD1Ev", "(anonymous namespace)::CGObjCGNU::~CGObjCGNU()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNUD0Ev", "(anonymous namespace)::CGObjCGNU::~CGObjCGNU()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU18ModuleInitFunctionEv", "(anonymous namespace)::CGObjCGNU::ModuleInitFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU11GetSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEN5clang8SelectorEb", "(anonymous namespace)::CGObjCGNU::GetSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::Selector, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU11GetSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCGNU::GetSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU9GetEHTypeEN5clang8QualTypeE", "(anonymous namespace)::CGObjCGNU::GetEHType(clang::QualType)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU22GenerateConstantStringEPKN5clang13StringLiteralE", "(anonymous namespace)::CGObjCGNU::GenerateConstantString(clang::StringLiteral const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU16GenerateCategoryEPKN5clang20ObjCCategoryImplDeclE", "(anonymous namespace)::CGObjCGNU::GenerateCategory(clang::ObjCCategoryImplDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU13GenerateClassEPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCGNU::GenerateClass(clang::ObjCImplementationDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU19GenerateMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueERKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_17ObjCInterfaceDeclEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCGNU::GenerateMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCInterfaceDecl const*, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU24GenerateMessageSendSuperERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPKNS1_17ObjCInterfaceDeclEbPN4llvm5ValueEbRKNSB_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCGNU::GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, clang::ObjCInterfaceDecl const*, bool, llvm::Value*, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU19GenerateProtocolRefERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCGNU::GenerateProtocolRef(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU16GenerateProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCGNU::GenerateProtocol(clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU14GenerateMethodEPKN5clang14ObjCMethodDeclEPKNS1_17ObjCContainerDeclE", "(anonymous namespace)::CGObjCGNU::GenerateMethod(clang::ObjCMethodDecl const*, clang::ObjCContainerDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU22GetPropertyGetFunctionEv", "(anonymous namespace)::CGObjCGNU::GetPropertyGetFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU22GetPropertySetFunctionEv", "(anonymous namespace)::CGObjCGNU::GetPropertySetFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU20GetGetStructFunctionEv", "(anonymous namespace)::CGObjCGNU::GetGetStructFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU20GetSetStructFunctionEv", "(anonymous namespace)::CGObjCGNU::GetSetStructFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU8GetClassERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang17ObjCInterfaceDeclE", "(anonymous namespace)::CGObjCGNU::GetClass(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCInterfaceDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU27EnumerationMutationFunctionEv", "(anonymous namespace)::CGObjCGNU::EnumerationMutationFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU20EmitSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_22ObjCAtSynchronizedStmtE", "(anonymous namespace)::CGObjCGNU::EmitSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtSynchronizedStmt const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU11EmitTryStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_13ObjCAtTryStmtE", "(anonymous namespace)::CGObjCGNU::EmitTryStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtTryStmt const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU13EmitThrowStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_15ObjCAtThrowStmtE", "(anonymous namespace)::CGObjCGNU::EmitThrowStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtThrowStmt const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU16EmitObjCWeakReadERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::CGObjCGNU::EmitObjCWeakRead(clang::CodeGen::CodeGenFunction&, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU18EmitObjCWeakAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCGNU::EmitObjCWeakAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU20EmitObjCGlobalAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_b", "(anonymous namespace)::CGObjCGNU::EmitObjCGlobalAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU18EmitObjCIvarAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCGNU::EmitObjCIvarAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU24EmitObjCStrongCastAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCGNU::EmitObjCStrongCastAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU20EmitObjCValueForIvarERN5clang7CodeGen15CodeGenFunctionENS1_8QualTypeEPN4llvm5ValueEPKNS1_12ObjCIvarDeclEj", "(anonymous namespace)::CGObjCGNU::EmitObjCValueForIvar(clang::CodeGen::CodeGenFunction&, clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU14EmitIvarOffsetERN5clang7CodeGen15CodeGenFunctionEPKNS1_17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCGNU::EmitIvarOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU24EmitGCMemmoveCollectableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCGNU::EmitGCMemmoveCollectable(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU18BuildGCBlockLayoutERN5clang7CodeGen13CodeGenModuleERKNS2_11CGBlockInfoE", "(anonymous namespace)::CGObjCGNU::BuildGCBlockLayout(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&)"},
    {"_Z17FindIvarInterfaceRN5clang10ASTContextEPKNS_17ObjCInterfaceDeclEPKNS_12ObjCIvarDeclE", "FindIvarInterface(clang::ASTContext&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN12_GLOBAL__N_112CallSyncExitD1Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"},
    {"_ZN12_GLOBAL__N_112CallSyncExitD0Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"},
    {"_ZN12_GLOBAL__N_112CallSyncExit4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallSyncExit::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU12EmitClassRefERKSs", "(anonymous namespace)::CGObjCGNU::EmitClassRef(std::string const&)"},
    {"_Z19SymbolNameForMethodRKSsS0_S0_b", "SymbolNameForMethod(std::string const&, std::string const&, std::string const&, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU20GenerateProtocolListERKN4llvm15SmallVectorImplISsEE", "(anonymous namespace)::CGObjCGNU::GenerateProtocolList(llvm::SmallVectorImpl<std::string> const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU26GenerateProtocolMethodListERKN4llvm15SmallVectorImplIPNS1_8ConstantEEES7_", "(anonymous namespace)::CGObjCGNU::GenerateProtocolMethodList(llvm::SmallVectorImpl<llvm::Constant*> const&, llvm::SmallVectorImpl<llvm::Constant*> const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU18GenerateMethodListERKSsS2_RKN4llvm15SmallVectorImplIN5clang8SelectorEEERKNS4_IPNS3_8ConstantEEEb", "(anonymous namespace)::CGObjCGNU::GenerateMethodList(std::string const&, std::string const&, llvm::SmallVectorImpl<clang::Selector> const&, llvm::SmallVectorImpl<llvm::Constant*> const&, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU16GenerateIvarListERKN4llvm15SmallVectorImplIPNS1_8ConstantEEES7_S7_", "(anonymous namespace)::CGObjCGNU::GenerateIvarList(llvm::SmallVectorImpl<llvm::Constant*> const&, llvm::SmallVectorImpl<llvm::Constant*> const&, llvm::SmallVectorImpl<llvm::Constant*> const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU22GenerateClassStructureEPN4llvm8ConstantES3_jPKcS3_S3_S3_S3_S3_S3_S3_b", "(anonymous namespace)::CGObjCGNU::GenerateClassStructure(llvm::Constant*, llvm::Constant*, unsigned int, char const*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, llvm::Constant*, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCGNU18ExportUniqueStringERKSsSs", "(anonymous namespace)::CGObjCGNU::ExportUniqueString(std::string const&, std::string)"},
    {"_Z19MangleSelectorTypesRKSs", "MangleSelectorTypes(std::string const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE11CreateCall3EPNS_5ValueES6_S6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall3(llvm::Value*, llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateLoadEPNS_5ValueEbRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateLoad(llvm::Value*, bool, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE11CreateCall2EPNS_5ValueES6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall2(llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateCallEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE17CreateUnreachableEv", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateUnreachable()"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateInvokeIPPNS_5ValueEEEPNS_10InvokeInstES7_PNS_10BasicBlockESC_T_SD_RKNS_5TwineE", "llvm::InvokeInst* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInvoke<llvm::Value**>(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*, llvm::Value**, llvm::Value**, llvm::Twine const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang7CanQualINS1_4TypeEEELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CanQual<clang::Type>, false>::grow(unsigned long)"},
    {"_ZN4llvm15SmallVectorImplISt4pairIN5clang7CodeGen6RValueENS2_8QualTypeEEE6insertIPKS6_EEPS6_SB_T_SC_", "std::pair<clang::CodeGen::RValue, clang::QualType>* llvm::SmallVectorImpl<std::pair<clang::CodeGen::RValue, clang::QualType> >::insert<std::pair<clang::CodeGen::RValue, clang::QualType> const*>(std::pair<clang::CodeGen::RValue, clang::QualType>*, std::pair<clang::CodeGen::RValue, clang::QualType> const*, std::pair<clang::CodeGen::RValue, clang::QualType> const*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateAllocaEPKNS_4TypeEPNS_5ValueERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateAlloca(llvm::Type const*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateCallIPPNS_5ValueEEEPNS_8CallInstES7_T_SB_RKNS_5TwineE", "llvm::CallInst* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall<llvm::Value**>(llvm::Value*, llvm::Value**, llvm::Value**, llvm::Twine const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseISt4pairIN5clang7CodeGen6RValueENS2_8QualTypeEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::CodeGen::RValue, clang::QualType>, false>::grow(unsigned long)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE8CreateBrEPNS_10BasicBlockE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateBr(llvm::BasicBlock*)"},
    {"_ZNSt3mapISt4pairISsSsEPN4llvm11GlobalAliasESt4lessIS1_ESaIS0_IKS1_S4_EEEixERS7_", "std::map<std::pair<std::string, std::string>, llvm::GlobalAlias*, std::less<std::pair<std::string, std::string> >, std::allocator<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> > >::operator[](std::pair<std::string, std::string> const&)"},
    {"_ZNKSt4lessISt4pairISsSsEEclERKS1_S4_", "std::less<std::pair<std::string, std::string> >::operator()(std::pair<std::string, std::string> const&, std::pair<std::string, std::string> const&) const"},
    {"_ZNSt8_Rb_treeISt4pairISsSsES0_IKS1_PN4llvm11GlobalAliasEESt10_Select1stIS6_ESt4lessIS1_ESaIS6_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS6_ERKS6_", "std::_Rb_tree<std::pair<std::string, std::string>, std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*>, std::_Select1st<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> >, std::less<std::pair<std::string, std::string> >, std::allocator<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> >, std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> const&)"},
    {"_ZNSt8_Rb_treeISt4pairISsSsES0_IKS1_PN4llvm11GlobalAliasEESt10_Select1stIS6_ESt4lessIS1_ESaIS6_EE9_M_insertEPSt18_Rb_tree_node_baseSE_RKS6_", "std::_Rb_tree<std::pair<std::string, std::string>, std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*>, std::_Select1st<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> >, std::less<std::pair<std::string, std::string> >, std::allocator<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> > >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> const&)"},
    {"_ZNSt8_Rb_treeISt4pairISsSsES0_IKS1_PN4llvm11GlobalAliasEESt10_Select1stIS6_ESt4lessIS1_ESaIS6_EE16_M_insert_uniqueERKS6_", "std::_Rb_tree<std::pair<std::string, std::string>, std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*>, std::_Select1st<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> >, std::less<std::pair<std::string, std::string> >, std::allocator<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> > >::_M_insert_unique(std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> const&)"},
    {"_ZN4llvm9StringMapIPNS_11GlobalAliasENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<llvm::GlobalAlias*>& llvm::StringMap<llvm::GlobalAlias*, llvm::MallocAllocator>::GetOrCreateValue<llvm::GlobalAlias*>(llvm::StringRef, llvm::GlobalAlias*)"},
    {"_ZNSt6vectorIPN4llvm8ConstantESaIS2_EE15_M_range_insertIN9__gnu_cxx17__normal_iteratorIPS2_S4_EEEEvS9_T_SA_St20forward_iterator_tag", "void std::vector<llvm::Constant*, std::allocator<llvm::Constant*> >::_M_range_insert<__gnu_cxx::__normal_iterator<llvm::Constant**, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > > >(__gnu_cxx::__normal_iterator<llvm::Constant**, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > >, __gnu_cxx::__normal_iterator<llvm::Constant**, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > >, __gnu_cxx::__normal_iterator<llvm::Constant**, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > >, std::forward_iterator_tag)"},
    {"_ZNSt8_Rb_treeISt4pairISsSsES0_IKS1_PN4llvm11GlobalAliasEESt10_Select1stIS6_ESt4lessIS1_ESaIS6_EE8_M_eraseEPSt13_Rb_tree_nodeIS6_E", "std::_Rb_tree<std::pair<std::string, std::string>, std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*>, std::_Select1st<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> >, std::less<std::pair<std::string, std::string> >, std::allocator<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> > >::_M_erase(std::_Rb_tree_node<std::pair<std::pair<std::string, std::string> const, llvm::GlobalAlias*> >*)"},
    {"_ZN5clang7CodeGen13CGObjCRuntime21ComputeIvarBaseOffsetERNS0_13CodeGenModuleEPKNS_17ObjCInterfaceDeclEPKNS_12ObjCIvarDeclE", "clang::CodeGen::CGObjCRuntime::ComputeIvarBaseOffset(clang::CodeGen::CodeGenModule&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_Z20LookupFieldBitOffsetRN5clang7CodeGen13CodeGenModuleEPKNS_17ObjCInterfaceDeclEPKNS_22ObjCImplementationDeclEPKNS_12ObjCIvarDeclE", "LookupFieldBitOffset(clang::CodeGen::CodeGenModule&, clang::ObjCInterfaceDecl const*, clang::ObjCImplementationDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN5clang7CodeGen13CGObjCRuntime21ComputeIvarBaseOffsetERNS0_13CodeGenModuleEPKNS_22ObjCImplementationDeclEPKNS_12ObjCIvarDeclE", "clang::CodeGen::CGObjCRuntime::ComputeIvarBaseOffset(clang::CodeGen::CodeGenModule&, clang::ObjCImplementationDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN5clang7CodeGen13CGObjCRuntime24EmitValueForIvarAtOffsetERNS0_15CodeGenFunctionEPKNS_17ObjCInterfaceDeclEPN4llvm5ValueEPKNS_12ObjCIvarDeclEjS9_", "clang::CodeGen::CGObjCRuntime::EmitValueForIvarAtOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int, llvm::Value*)"},
    {"_ZN5clang7CodeGen20CreateMacObjCRuntimeERNS0_13CodeGenModuleE", "clang::CodeGen::CreateMacObjCRuntime(clang::CodeGen::CodeGenModule&)"},
    {"_ZN5clang7CodeGen33CreateMacNonFragileABIObjCRuntimeERNS0_13CodeGenModuleE", "clang::CodeGen::CreateMacNonFragileABIObjCRuntime(clang::CodeGen::CodeGenModule&)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMacC2ERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::CGObjCCommonMac::CGObjCCommonMac(clang::CodeGen::CodeGenModule&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMacD1Ev", "(anonymous namespace)::CGObjCNonFragileABIMac::~CGObjCNonFragileABIMac()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMacD0Ev", "(anonymous namespace)::CGObjCNonFragileABIMac::~CGObjCNonFragileABIMac()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18ModuleInitFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::ModuleInitFunction()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac11GetSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEN5clang8SelectorEb", "(anonymous namespace)::CGObjCNonFragileABIMac::GetSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::Selector, bool)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac11GetSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac9GetEHTypeEN5clang8QualTypeE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetEHType(clang::QualType)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac22GenerateConstantStringEPKN5clang13StringLiteralE", "(anonymous namespace)::CGObjCCommonMac::GenerateConstantString(clang::StringLiteral const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac16GenerateCategoryEPKN5clang20ObjCCategoryImplDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateCategory(clang::ObjCCategoryImplDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac13GenerateClassEPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateClass(clang::ObjCImplementationDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac19GenerateMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueERKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_17ObjCInterfaceDeclEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCInterfaceDecl const*, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24GenerateMessageSendSuperERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPKNS1_17ObjCInterfaceDeclEbPN4llvm5ValueEbRKNSB_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, clang::ObjCInterfaceDecl const*, bool, llvm::Value*, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac19GenerateProtocolRefERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GenerateProtocolRef(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac16GenerateProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCCommonMac::GenerateProtocol(clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac14GenerateMethodEPKN5clang14ObjCMethodDeclEPKNS1_17ObjCContainerDeclE", "(anonymous namespace)::CGObjCCommonMac::GenerateMethod(clang::ObjCMethodDecl const*, clang::ObjCContainerDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac22GetPropertyGetFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetPropertyGetFunction()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac22GetPropertySetFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetPropertySetFunction()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20GetGetStructFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetGetStructFunction()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20GetSetStructFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::GetSetStructFunction()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac8GetClassERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang17ObjCInterfaceDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetClass(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCInterfaceDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac27EnumerationMutationFunctionEv", "(anonymous namespace)::CGObjCNonFragileABIMac::EnumerationMutationFunction()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20EmitSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_22ObjCAtSynchronizedStmtE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtSynchronizedStmt const&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac11EmitTryStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_13ObjCAtTryStmtE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitTryStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtTryStmt const&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac13EmitThrowStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_15ObjCAtThrowStmtE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitThrowStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtThrowStmt const&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac16EmitObjCWeakReadERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCWeakRead(clang::CodeGen::CodeGenFunction&, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18EmitObjCWeakAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCWeakAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20EmitObjCGlobalAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_b", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCGlobalAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18EmitObjCIvarAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCIvarAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24EmitObjCStrongCastAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCStrongCastAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20EmitObjCValueForIvarERN5clang7CodeGen15CodeGenFunctionENS1_8QualTypeEPN4llvm5ValueEPKNS1_12ObjCIvarDeclEj", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitObjCValueForIvar(clang::CodeGen::CodeGenFunction&, clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac14EmitIvarOffsetERN5clang7CodeGen15CodeGenFunctionEPKNS1_17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitIvarOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24EmitGCMemmoveCollectableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitGCMemmoveCollectable(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac18BuildGCBlockLayoutERN5clang7CodeGen13CodeGenModuleERKNS2_11CGBlockInfoE", "(anonymous namespace)::CGObjCCommonMac::BuildGCBlockLayout(clang::CodeGen::CodeGenModule&, clang::CodeGen::CGBlockInfo const&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac17GetOrEmitProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetOrEmitProtocol(clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac20GetOrEmitProtocolRefEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetOrEmitProtocolRef(clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac28GetMethodDescriptionConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetMethodDescriptionConstant(clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac12GetClassNameEPN5clang14IdentifierInfoE", "(anonymous namespace)::CGObjCCommonMac::GetClassName(clang::IdentifierInfo*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac16EmitProtocolListEN4llvm5TwineEPKPN5clang16ObjCProtocolDeclES7_", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitProtocolList(llvm::Twine, clang::ObjCProtocolDecl* const*, clang::ObjCProtocolDecl* const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac14EmitMethodListEN4llvm5TwineEPKcRKSt6vectorIPNS1_8ConstantESaIS7_EE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitMethodList(llvm::Twine, char const*, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > const&)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac16EmitPropertyListEN4llvm5TwineEPKN5clang4DeclEPKNS3_17ObjCContainerDeclERKNS_21ObjCCommonTypesHelperE", "(anonymous namespace)::CGObjCCommonMac::EmitPropertyList(llvm::Twine, clang::Decl const*, clang::ObjCContainerDecl const*, (anonymous namespace)::ObjCCommonTypesHelper const&)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac15GetPropertyNameEPN5clang14IdentifierInfoE", "(anonymous namespace)::CGObjCCommonMac::GetPropertyName(clang::IdentifierInfo*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac21GetPropertyTypeStringEPKN5clang16ObjCPropertyDeclEPKNS1_4DeclE", "(anonymous namespace)::CGObjCCommonMac::GetPropertyTypeString(clang::ObjCPropertyDecl const*, clang::Decl const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac22PushProtocolPropertiesERN4llvm11SmallPtrSetIPKN5clang14IdentifierInfoELj16EEERSt6vectorIPNS1_8ConstantESaISB_EEPKNS3_4DeclEPKNS3_16ObjCProtocolDeclERKNS_21ObjCCommonTypesHelperE", "(anonymous namespace)::CGObjCCommonMac::PushProtocolProperties(llvm::SmallPtrSet<clang::IdentifierInfo const*, 16u>&, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> >&, clang::Decl const*, clang::ObjCProtocolDecl const*, (anonymous namespace)::ObjCCommonTypesHelper const&)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac17CreateMetadataVarEN4llvm5TwineEPNS1_8ConstantEPKcjb", "(anonymous namespace)::CGObjCCommonMac::CreateMetadataVar(llvm::Twine, llvm::Constant*, char const*, unsigned int, bool)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac16GetMethodVarNameEN5clang8SelectorE", "(anonymous namespace)::CGObjCCommonMac::GetMethodVarName(clang::Selector)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac16GetMethodVarTypeEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCCommonMac::GetMethodVarType(clang::ObjCMethodDecl const*)"},
    {"_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREE9push_backERKS3_", "llvm::SmallVectorImpl<(anonymous namespace)::CGObjCCommonMac::GC_IVAR>::push_back((anonymous namespace)::CGObjCCommonMac::GC_IVAR const&)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac25BuildAggrIvarRecordLayoutEPKN5clang10RecordTypeEjbRb", "(anonymous namespace)::CGObjCCommonMac::BuildAggrIvarRecordLayout(clang::RecordType const*, unsigned int, bool, bool&)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac21BuildIvarLayoutBitmapERSs", "(anonymous namespace)::CGObjCCommonMac::BuildIvarLayoutBitmap(std::string&)"},
    {"_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_115CGObjCCommonMac9SKIP_SCANEE9push_backERKS3_", "llvm::SmallVectorImpl<(anonymous namespace)::CGObjCCommonMac::SKIP_SCAN>::push_back((anonymous namespace)::CGObjCCommonMac::SKIP_SCAN const&)"},
    {"_ZN4llvm25array_pod_sort_comparatorIN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREEEiPKvS5_", "int llvm::array_pod_sort_comparator<(anonymous namespace)::CGObjCCommonMac::GC_IVAR>(void const*, void const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac19BuildAggrIvarLayoutEPKN5clang22ObjCImplementationDeclEPKN4llvm12StructLayoutEPKNS1_10RecordDeclERKNS5_15SmallVectorImplIPNS1_9FieldDeclEEEjbRb", "(anonymous namespace)::CGObjCCommonMac::BuildAggrIvarLayout(clang::ObjCImplementationDecl const*, llvm::StructLayout const*, clang::RecordDecl const*, llvm::SmallVectorImpl<clang::FieldDecl*> const&, unsigned int, bool, bool&)"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper22GcMemmoveCollectableFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::GcMemmoveCollectableFn()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac22ObjCIvarOffsetVariableEPKN5clang17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::ObjCIvarOffsetVariable(clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper23getGcAssignStrongCastFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignStrongCastFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper17getGcAssignIvarFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignIvarFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper19getGcAssignGlobalFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignGlobalFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper24getGcAssignThreadLocalFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignThreadLocalFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper17getGcAssignWeakFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcAssignWeakFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper15getGcReadWeakFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGcReadWeakFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper19getExceptionThrowFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getExceptionThrowFn()"},
    {"_ZN12_GLOBAL__N_116CallObjCEndCatchD1Ev", "(anonymous namespace)::CallObjCEndCatch::~CallObjCEndCatch()"},
    {"_ZN12_GLOBAL__N_116CallObjCEndCatchD0Ev", "(anonymous namespace)::CallObjCEndCatch::~CallObjCEndCatch()"},
    {"_ZN12_GLOBAL__N_116CallObjCEndCatch4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallObjCEndCatch::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper14getSyncEnterFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getSyncEnterFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper13getSyncExitFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getSyncExitFn()"},
    {"_ZN12_GLOBAL__N_112CallSyncExitD1Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"},
    {"_ZN12_GLOBAL__N_112CallSyncExitD0Ev", "(anonymous namespace)::CallSyncExit::~CallSyncExit()"},
    {"_ZN12_GLOBAL__N_112CallSyncExit4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallSyncExit::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper24getEnumerationMutationFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getEnumerationMutationFn()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac14GetClassGlobalERKSs", "(anonymous namespace)::CGObjCNonFragileABIMac::GetClassGlobal(std::string const&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac12EmitClassRefERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang17ObjCInterfaceDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitClassRef(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCInterfaceDecl const*)"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper15getCopyStructFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getCopyStructFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper16getSetPropertyFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getSetPropertyFn()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelper16getGetPropertyFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getGetPropertyFn()"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24LegacyDispatchedSelectorEN5clang8SelectorE", "(anonymous namespace)::CGObjCNonFragileABIMac::LegacyDispatchedSelector(clang::Selector)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac21EmitLegacyMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeEPN4llvm5ValueES9_S6_bRKNS7_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclERKNS_21ObjCCommonTypesHelperE", "(anonymous namespace)::CGObjCCommonMac::EmitLegacyMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, llvm::Value*, llvm::Value*, clang::QualType, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*, (anonymous namespace)::ObjCCommonTypesHelper const&)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac12EmitSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEN5clang8SelectorEb", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::Selector, bool)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac15EmitMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueES6_bRKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEE", "(anonymous namespace)::CGObjCNonFragileABIMac::EmitMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, clang::QualType, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&)"},
    {"_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper21getMessageSendSuperFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendSuperFn() const"},
    {"_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper16getMessageSendFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendFn() const"},
    {"_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper22getMessageSendSuperFn2Ev", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendSuperFn2() const"},
    {"_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper21getMessageSendFpretFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendFpretFn() const"},
    {"_ZNK12_GLOBAL__N_121ObjCCommonTypesHelper21getMessageSendStretFnEv", "(anonymous namespace)::ObjCCommonTypesHelper::getMessageSendStretFn() const"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac24BuildClassRoTInitializerEjjjPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::BuildClassRoTInitializer(unsigned int, unsigned int, unsigned int, clang::ObjCImplementationDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18BuildClassMetaDataERSsPN4llvm8ConstantES4_S4_b", "(anonymous namespace)::CGObjCNonFragileABIMac::BuildClassMetaData(std::string&, llvm::Constant*, llvm::Constant*, llvm::Constant*, bool)"},
    {"_Z25hasObjCExceptionAttributeRN5clang10ASTContextEPKNS_17ObjCInterfaceDeclE", "hasObjCExceptionAttribute(clang::ASTContext&, clang::ObjCInterfaceDecl const*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18GetInterfaceEHTypeEPKN5clang17ObjCInterfaceDeclEb", "(anonymous namespace)::CGObjCNonFragileABIMac::GetInterfaceEHType(clang::ObjCInterfaceDecl const*, bool)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac15BuildIvarLayoutEPKN5clang22ObjCImplementationDeclEb", "(anonymous namespace)::CGObjCCommonMac::BuildIvarLayout(clang::ObjCImplementationDecl const*, bool)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac17GetMethodConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCNonFragileABIMac::GetMethodConstant(clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac16GetMethodVarTypeEPKN5clang9FieldDeclE", "(anonymous namespace)::CGObjCCommonMac::GetMethodVarType(clang::FieldDecl const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac19GetMethodDefinitionEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCCommonMac::GetMethodDefinition(clang::ObjCMethodDecl const*)"},
    {"_ZSt4sortIPN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREEvT_S4_", "void std::sort<(anonymous namespace)::CGObjCCommonMac::GC_IVAR*>((anonymous namespace)::CGObjCCommonMac::GC_IVAR*, (anonymous namespace)::CGObjCCommonMac::GC_IVAR*)"},
    {"_ZSt16__introsort_loopIPN12_GLOBAL__N_115CGObjCCommonMac7GC_IVARElEvT_S4_T0_", "void std::__introsort_loop<(anonymous namespace)::CGObjCCommonMac::GC_IVAR*, long>((anonymous namespace)::CGObjCCommonMac::GC_IVAR*, (anonymous namespace)::CGObjCCommonMac::GC_IVAR*, long)"},
    {"_ZSt16__insertion_sortIPN12_GLOBAL__N_115CGObjCCommonMac7GC_IVAREEvT_S4_", "void std::__insertion_sort<(anonymous namespace)::CGObjCCommonMac::GC_IVAR*>((anonymous namespace)::CGObjCCommonMac::GC_IVAR*, (anonymous namespace)::CGObjCCommonMac::GC_IVAR*)"},
    {"_ZN12_GLOBAL__N_122CGObjCNonFragileABIMac18AddModuleClassListERKSt6vectorIPN4llvm11GlobalValueESaIS4_EEPKcSA_", "(anonymous namespace)::CGObjCNonFragileABIMac::AddModuleClassList(std::vector<llvm::GlobalValue*, std::allocator<llvm::GlobalValue*> > const&, char const*, char const*)"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMac13EmitImageInfoEv", "(anonymous namespace)::CGObjCCommonMac::EmitImageInfo()"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMacD2Ev", "(anonymous namespace)::CGObjCCommonMac::~CGObjCCommonMac()"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMacD1Ev", "(anonymous namespace)::CGObjCCommonMac::~CGObjCCommonMac()"},
    {"_ZN12_GLOBAL__N_115CGObjCCommonMacD0Ev", "(anonymous namespace)::CGObjCCommonMac::~CGObjCCommonMac()"},
    {"_ZN12_GLOBAL__N_121ObjCCommonTypesHelperC2ERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::ObjCCommonTypesHelper::ObjCCommonTypesHelper(clang::CodeGen::CodeGenModule&)"},
    {"_ZN12_GLOBAL__N_19CGObjCMacD1Ev", "(anonymous namespace)::CGObjCMac::~CGObjCMac()"},
    {"_ZN12_GLOBAL__N_19CGObjCMacD0Ev", "(anonymous namespace)::CGObjCMac::~CGObjCMac()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac18ModuleInitFunctionEv", "(anonymous namespace)::CGObjCMac::ModuleInitFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac11GetSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEN5clang8SelectorEb", "(anonymous namespace)::CGObjCMac::GetSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::Selector, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac11GetSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GetSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac9GetEHTypeEN5clang8QualTypeE", "(anonymous namespace)::CGObjCMac::GetEHType(clang::QualType)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac16GenerateCategoryEPKN5clang20ObjCCategoryImplDeclE", "(anonymous namespace)::CGObjCMac::GenerateCategory(clang::ObjCCategoryImplDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac13GenerateClassEPKN5clang22ObjCImplementationDeclE", "(anonymous namespace)::CGObjCMac::GenerateClass(clang::ObjCImplementationDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac19GenerateMessageSendERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPN4llvm5ValueERKNS8_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_17ObjCInterfaceDeclEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GenerateMessageSend(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, llvm::Value*, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCInterfaceDecl const*, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac24GenerateMessageSendSuperERN5clang7CodeGen15CodeGenFunctionENS2_15ReturnValueSlotENS1_8QualTypeENS1_8SelectorEPKNS1_17ObjCInterfaceDeclEbPN4llvm5ValueEbRKNSB_11SmallVectorISt4pairINS2_6RValueES6_ELj16EEEPKNS1_14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GenerateMessageSendSuper(clang::CodeGen::CodeGenFunction&, clang::CodeGen::ReturnValueSlot, clang::QualType, clang::Selector, clang::ObjCInterfaceDecl const*, bool, llvm::Value*, bool, llvm::SmallVector<std::pair<clang::CodeGen::RValue, clang::QualType>, 16u> const&, clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac19GenerateProtocolRefERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCMac::GenerateProtocolRef(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac22GetPropertyGetFunctionEv", "(anonymous namespace)::CGObjCMac::GetPropertyGetFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac22GetPropertySetFunctionEv", "(anonymous namespace)::CGObjCMac::GetPropertySetFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac20GetGetStructFunctionEv", "(anonymous namespace)::CGObjCMac::GetGetStructFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac20GetSetStructFunctionEv", "(anonymous namespace)::CGObjCMac::GetSetStructFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac8GetClassERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang17ObjCInterfaceDeclE", "(anonymous namespace)::CGObjCMac::GetClass(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCInterfaceDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac27EnumerationMutationFunctionEv", "(anonymous namespace)::CGObjCMac::EnumerationMutationFunction()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac20EmitSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_22ObjCAtSynchronizedStmtE", "(anonymous namespace)::CGObjCMac::EmitSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtSynchronizedStmt const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac11EmitTryStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_13ObjCAtTryStmtE", "(anonymous namespace)::CGObjCMac::EmitTryStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtTryStmt const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac13EmitThrowStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_15ObjCAtThrowStmtE", "(anonymous namespace)::CGObjCMac::EmitThrowStmt(clang::CodeGen::CodeGenFunction&, clang::ObjCAtThrowStmt const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac16EmitObjCWeakReadERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::CGObjCMac::EmitObjCWeakRead(clang::CodeGen::CodeGenFunction&, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac18EmitObjCWeakAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCMac::EmitObjCWeakAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac20EmitObjCGlobalAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_b", "(anonymous namespace)::CGObjCMac::EmitObjCGlobalAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac18EmitObjCIvarAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCMac::EmitObjCIvarAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac24EmitObjCStrongCastAssignERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_", "(anonymous namespace)::CGObjCMac::EmitObjCStrongCastAssign(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac20EmitObjCValueForIvarERN5clang7CodeGen15CodeGenFunctionENS1_8QualTypeEPN4llvm5ValueEPKNS1_12ObjCIvarDeclEj", "(anonymous namespace)::CGObjCMac::EmitObjCValueForIvar(clang::CodeGen::CodeGenFunction&, clang::QualType, llvm::Value*, clang::ObjCIvarDecl const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac14EmitIvarOffsetERN5clang7CodeGen15CodeGenFunctionEPKNS1_17ObjCInterfaceDeclEPKNS1_12ObjCIvarDeclE", "(anonymous namespace)::CGObjCMac::EmitIvarOffset(clang::CodeGen::CodeGenFunction&, clang::ObjCInterfaceDecl const*, clang::ObjCIvarDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac24EmitGCMemmoveCollectableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_S7_", "(anonymous namespace)::CGObjCMac::EmitGCMemmoveCollectable(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac17GetOrEmitProtocolEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCMac::GetOrEmitProtocol(clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac20GetOrEmitProtocolRefEPKN5clang16ObjCProtocolDeclE", "(anonymous namespace)::CGObjCMac::GetOrEmitProtocolRef(clang::ObjCProtocolDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac28GetMethodDescriptionConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GetMethodDescriptionConstant(clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac16EmitProtocolListEN4llvm5TwineEPKPN5clang16ObjCProtocolDeclES7_", "(anonymous namespace)::CGObjCMac::EmitProtocolList(llvm::Twine, clang::ObjCProtocolDecl* const*, clang::ObjCProtocolDecl* const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac18EmitMethodDescListEN4llvm5TwineEPKcRKSt6vectorIPNS1_8ConstantESaIS7_EE", "(anonymous namespace)::CGObjCMac::EmitMethodDescList(llvm::Twine, char const*, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > const&)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac25EmitTryOrSynchronizedStmtERN5clang7CodeGen15CodeGenFunctionERKNS1_4StmtE", "(anonymous namespace)::CGObjCMac::EmitTryOrSynchronizedStmt(clang::CodeGen::CodeGenFunction&, clang::Stmt const&)"},
    {"_ZN12_GLOBAL__N_115ObjCTypesHelper22getExceptionTryEnterFnEv", "(anonymous namespace)::ObjCTypesHelper::getExceptionTryEnterFn()"},
    {"_ZN12_GLOBAL__N_115ObjCTypesHelper11getSetJmpFnEv", "(anonymous namespace)::ObjCTypesHelper::getSetJmpFn()"},
    {"_ZN12_GLOBAL__N_115ObjCTypesHelper21getExceptionExtractFnEv", "(anonymous namespace)::ObjCTypesHelper::getExceptionExtractFn()"},
    {"_ZN12_GLOBAL__N_19CGObjCMac12EmitClassRefERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEPKN5clang17ObjCInterfaceDeclE", "(anonymous namespace)::CGObjCMac::EmitClassRef(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::ObjCInterfaceDecl const*)"},
    {"_ZN12_GLOBAL__N_121PerformFragileFinallyD1Ev", "(anonymous namespace)::PerformFragileFinally::~PerformFragileFinally()"},
    {"_ZN12_GLOBAL__N_121PerformFragileFinallyD0Ev", "(anonymous namespace)::PerformFragileFinally::~PerformFragileFinally()"},
    {"_ZN12_GLOBAL__N_121PerformFragileFinally4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::PerformFragileFinally::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac12EmitSelectorERN4llvm9IRBuilderILb0ENS1_14ConstantFolderENS1_24IRBuilderDefaultInserterILb0EEEEEN5clang8SelectorEb", "(anonymous namespace)::CGObjCMac::EmitSelector(llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >&, clang::Selector, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac17GetMethodConstantEPKN5clang14ObjCMethodDeclE", "(anonymous namespace)::CGObjCMac::GetMethodConstant(clang::ObjCMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac12EmitIvarListEPKN5clang22ObjCImplementationDeclEb", "(anonymous namespace)::CGObjCMac::EmitIvarList(clang::ObjCImplementationDecl const*, bool)"},
    {"_ZN12_GLOBAL__N_19CGObjCMac14EmitMethodListEN4llvm5TwineEPKcRKSt6vectorIPNS1_8ConstantESaIS7_EE", "(anonymous namespace)::CGObjCMac::EmitMethodList(llvm::Twine, char const*, std::vector<llvm::Constant*, std::allocator<llvm::Constant*> > const&)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEPNS_14GlobalVariableENS_12DenseMapInfoIS3_EENS6_IS5_EEE16InsertIntoBucketERKS3_RKS5_PSt4pairIS3_S5_E", "llvm::DenseMap<clang::IdentifierInfo*, llvm::GlobalVariable*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<llvm::GlobalVariable*> >::InsertIntoBucket(clang::IdentifierInfo* const&, llvm::GlobalVariable* const&, std::pair<clang::IdentifierInfo*, llvm::GlobalVariable*>*)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEPNS_14GlobalVariableENS_12DenseMapInfoIS3_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::IdentifierInfo*, llvm::GlobalVariable*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<llvm::GlobalVariable*> >::grow(unsigned int)"},
    {"_ZN4llvm9StringMapIPNS_14GlobalVariableENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<llvm::GlobalVariable*>& llvm::StringMap<llvm::GlobalVariable*, llvm::MallocAllocator>::GetOrCreateValue<llvm::GlobalVariable*>(llvm::StringRef, llvm::GlobalVariable*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEPNS_14GlobalVariableENS_12DenseMapInfoIS2_EENS5_IS4_EEE16InsertIntoBucketERKS2_RKS4_PSt4pairIS2_S4_E", "llvm::DenseMap<clang::Selector, llvm::GlobalVariable*, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<llvm::GlobalVariable*> >::InsertIntoBucket(clang::Selector const&, llvm::GlobalVariable* const&, std::pair<clang::Selector, llvm::GlobalVariable*>*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEPNS_14GlobalVariableENS_12DenseMapInfoIS2_EENS5_IS4_EEE4growEj", "llvm::DenseMap<clang::Selector, llvm::GlobalVariable*, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<llvm::GlobalVariable*> >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIPN5clang9FieldDeclEE6appendINS1_11DeclContext22specific_decl_iteratorIS2_EEEEvT_S9_", "void llvm::SmallVectorImpl<clang::FieldDecl*>::append<clang::DeclContext::specific_decl_iterator<clang::FieldDecl> >(clang::DeclContext::specific_decl_iterator<clang::FieldDecl>, clang::DeclContext::specific_decl_iterator<clang::FieldDecl>)"},
    {"_ZN4llvm8DenseMapIPKN5clang14ObjCMethodDeclEPNS_8FunctionENS_12DenseMapInfoIS4_EENS7_IS6_EEE6insertERKSt4pairIS4_S6_E", "llvm::DenseMap<clang::ObjCMethodDecl const*, llvm::Function*, llvm::DenseMapInfo<clang::ObjCMethodDecl const*>, llvm::DenseMapInfo<llvm::Function*> >::insert(std::pair<clang::ObjCMethodDecl const*, llvm::Function*> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang14ObjCMethodDeclEPNS_8FunctionENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::ObjCMethodDecl const*, llvm::Function*, llvm::DenseMapInfo<clang::ObjCMethodDecl const*>, llvm::DenseMapInfo<llvm::Function*> >::InsertIntoBucket(clang::ObjCMethodDecl const* const&, llvm::Function* const&, std::pair<clang::ObjCMethodDecl const*, llvm::Function*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang14ObjCMethodDeclEPNS_8FunctionENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::ObjCMethodDecl const*, llvm::Function*, llvm::DenseMapInfo<clang::ObjCMethodDecl const*>, llvm::DenseMapInfo<llvm::Function*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEcNS_12DenseMapInfoIS3_EENS4_IcEEE6insertERKSt4pairIS3_cE", "llvm::DenseMap<clang::IdentifierInfo*, char, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<char> >::insert(std::pair<clang::IdentifierInfo*, char> const&)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEcNS_12DenseMapInfoIS3_EENS4_IcEEE16InsertIntoBucketERKS3_RKcPSt4pairIS3_cE", "llvm::DenseMap<clang::IdentifierInfo*, char, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<char> >::InsertIntoBucket(clang::IdentifierInfo* const&, char const&, std::pair<clang::IdentifierInfo*, char>*)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEcNS_12DenseMapInfoIS3_EENS4_IcEEE4growEj", "llvm::DenseMap<clang::IdentifierInfo*, char, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<char> >::grow(unsigned int)"},
    {"_ZN4llvm9SetVectorISsSt6vectorISsSaISsEENS_8SmallSetISsLj16EEEED2Ev", "llvm::SetVector<std::string, std::vector<std::string, std::allocator<std::string> >, llvm::SmallSet<std::string, 16u> >::~SetVector()"},
    {"_ZNSt6vectorIPN5clang14IdentifierInfoESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::IdentifierInfo*, std::allocator<clang::IdentifierInfo*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::IdentifierInfo**, std::vector<clang::IdentifierInfo*, std::allocator<clang::IdentifierInfo*> > >, clang::IdentifierInfo* const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateGEPIPPNS_5ValueEEES7_S7_T_S9_RKNS_5TwineE", "llvm::Value* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateGEP<llvm::Value**>(llvm::Value*, llvm::Value**, llvm::Value**, llvm::Twine const&)"},
    {"_ZN4llvm8SmallSetISsLj16EE6insertERKSs", "llvm::SmallSet<std::string, 16u>::insert(std::string const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule23GetAddrOfRTTIDescriptorENS_8QualTypeEb", "clang::CodeGen::CodeGenModule::GetAddrOfRTTIDescriptor(clang::QualType, bool)"},
    {"_ZN12_GLOBAL__N_111RTTIBuilder13BuildTypeInfoEN5clang8QualTypeEb", "(anonymous namespace)::RTTIBuilder::BuildTypeInfo(clang::QualType, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule29EmitFundamentalRTTIDescriptorENS_8QualTypeE", "clang::CodeGen::CodeGenModule::EmitFundamentalRTTIDescriptor(clang::QualType)"},
    {"_ZN5clang7CodeGen13CodeGenModule30EmitFundamentalRTTIDescriptorsEv", "clang::CodeGen::CodeGenModule::EmitFundamentalRTTIDescriptors()"},
    {"_Z18getTypeInfoLinkageRN5clang7CodeGen13CodeGenModuleENS_8QualTypeE", "getTypeInfoLinkage(clang::CodeGen::CodeGenModule&, clang::QualType)"},
    {"_Z23CanUseSingleInheritancePKN5clang13CXXRecordDeclE", "CanUseSingleInheritance(clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_111RTTIBuilder20BuildPointerTypeInfoEN5clang8QualTypeE", "(anonymous namespace)::RTTIBuilder::BuildPointerTypeInfo(clang::QualType)"},
    {"_Z27ContainsIncompleteClassTypeN5clang8QualTypeE", "ContainsIncompleteClassType(clang::QualType)"},
    {"_Z28ComputeVMIClassTypeInfoFlagsPKN5clang16CXXBaseSpecifierERN12_GLOBAL__N_19SeenBasesE", "ComputeVMIClassTypeInfoFlags(clang::CXXBaseSpecifier const*, (anonymous namespace)::SeenBases&)"},
    {"_ZN5clang7CodeGen14CGBitFieldInfo8MakeInfoERNS0_12CodeGenTypesEPKNS_9FieldDeclEyyyj", "clang::CodeGen::CGBitFieldInfo::MakeInfo(clang::CodeGen::CodeGenTypes&, clang::FieldDecl const*, unsigned long long, unsigned long long, unsigned long long, unsigned int)"},
    {"_ZN5clang7CodeGen14CGBitFieldInfo8MakeInfoERNS0_12CodeGenTypesEPKNS_9FieldDeclEyy", "clang::CodeGen::CGBitFieldInfo::MakeInfo(clang::CodeGen::CodeGenTypes&, clang::FieldDecl const*, unsigned long long, unsigned long long)"},
    {"_ZN5clang7CodeGen12CodeGenTypes19ComputeRecordLayoutEPKNS_10RecordDeclE", "clang::CodeGen::CodeGenTypes::ComputeRecordLayout(clang::RecordDecl const*)"},
    {"_ZNK5clang7CodeGen14CGRecordLayout4dumpEv", "clang::CodeGen::CGRecordLayout::dump() const"},
    {"_ZNK5clang7CodeGen14CGRecordLayout5printERN4llvm11raw_ostreamE", "clang::CodeGen::CGRecordLayout::print(llvm::raw_ostream&) const"},
    {"_ZNK5clang7CodeGen14CGBitFieldInfo5printERN4llvm11raw_ostreamE", "clang::CodeGen::CGBitFieldInfo::print(llvm::raw_ostream&) const"},
    {"_ZNK5clang7CodeGen14CGBitFieldInfo4dumpEv", "clang::CodeGen::CGBitFieldInfo::dump() const"},
    {"_ZN4llvm25array_pod_sort_comparatorISt4pairIjPKN5clang7CodeGen14CGBitFieldInfoEEEEiPKvS9_", "int llvm::array_pod_sort_comparator<std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*> >(void const*, void const*)"},
    {"_ZN12_GLOBAL__N_121CGRecordLayoutBuilder12LayoutFieldsEPKN5clang10RecordDeclE", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutFields(clang::RecordDecl const*)"},
    {"_ZN12_GLOBAL__N_121CGRecordLayoutBuilder18LayoutVirtualBasesEPKN5clang13CXXRecordDeclERKNS1_15ASTRecordLayoutE", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutVirtualBases(clang::CXXRecordDecl const*, clang::ASTRecordLayout const&)"},
    {"_ZN12_GLOBAL__N_121CGRecordLayoutBuilder17LayoutVirtualBaseEPKN5clang13CXXRecordDeclEy", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutVirtualBase(clang::CXXRecordDecl const*, unsigned long long)"},
    {"_ZN12_GLOBAL__N_121CGRecordLayoutBuilder20LayoutNonVirtualBaseEPKN5clang13CXXRecordDeclEy", "(anonymous namespace)::CGRecordLayoutBuilder::LayoutNonVirtualBase(clang::CXXRecordDecl const*, unsigned long long)"},
    {"_ZNSt6vectorISt4pairIjPKN5clang7CodeGen14CGBitFieldInfoEESaIS6_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS6_S8_EERKS6_", "std::vector<std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*>, std::allocator<std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*>*, std::vector<std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*>, std::allocator<std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*> > > >, std::pair<unsigned int, clang::CodeGen::CGBitFieldInfo const*> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang9FieldDeclENS1_7CodeGen14CGBitFieldInfoENS_12DenseMapInfoIS4_EENS7_IS6_EEE6insertERKSt4pairIS4_S6_E", "llvm::DenseMap<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo, llvm::DenseMapInfo<clang::FieldDecl const*>, llvm::DenseMapInfo<clang::CodeGen::CGBitFieldInfo> >::insert(std::pair<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang9FieldDeclENS1_7CodeGen14CGBitFieldInfoENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo, llvm::DenseMapInfo<clang::FieldDecl const*>, llvm::DenseMapInfo<clang::CodeGen::CGBitFieldInfo> >::InsertIntoBucket(clang::FieldDecl const* const&, clang::CodeGen::CGBitFieldInfo const&, std::pair<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang9FieldDeclENS1_7CodeGen14CGBitFieldInfoENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo, llvm::DenseMapInfo<clang::FieldDecl const*>, llvm::DenseMapInfo<clang::CodeGen::CGBitFieldInfo> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang9FieldDeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::FieldDecl const*, unsigned int, llvm::DenseMapInfo<clang::FieldDecl const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::FieldDecl const*, unsigned int> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang9FieldDeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::FieldDecl const*, unsigned int, llvm::DenseMapInfo<clang::FieldDecl const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::FieldDecl const* const&, unsigned int const&, std::pair<clang::FieldDecl const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang9FieldDeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::FieldDecl const*, unsigned int, llvm::DenseMapInfo<clang::FieldDecl const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE6insertERKSt4pairIS4_jE", "llvm::DenseMap<clang::CXXRecordDecl const*, unsigned int, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<unsigned int> >::insert(std::pair<clang::CXXRecordDecl const*, unsigned int> const&)"},
    {"_ZN5clang7CodeGen14CGRecordLayoutC2EPKN4llvm10StructTypeES5_b", "clang::CodeGen::CGRecordLayout::CGRecordLayout(llvm::StructType const*, llvm::StructType const*, bool)"},
    {"_ZNSt6vectorIPKN4llvm4TypeESaIS3_EEaSERKS5_", "std::vector<llvm::Type const*, std::allocator<llvm::Type const*> >::operator=(std::vector<llvm::Type const*, std::allocator<llvm::Type const*> > const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseISt4pairIPKN5clang9FieldDeclENS2_7CodeGen14CGBitFieldInfoEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::FieldDecl const*, clang::CodeGen::CGBitFieldInfo>, false>::grow(unsigned long)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitStopPointEPKNS_4StmtE", "clang::CodeGen::CodeGenFunction::EmitStopPoint(clang::Stmt const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction8EmitStmtEPKNS_4StmtE", "clang::CodeGen::CodeGenFunction::EmitStmt(clang::Stmt const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitSimpleStmtEPKNS_4StmtE", "clang::CodeGen::CodeGenFunction::EmitSimpleStmt(clang::Stmt const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitIndirectGotoStmtERKNS_16IndirectGotoStmtE", "clang::CodeGen::CodeGenFunction::EmitIndirectGotoStmt(clang::IndirectGotoStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction10EmitIfStmtERKNS_6IfStmtE", "clang::CodeGen::CodeGenFunction::EmitIfStmt(clang::IfStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitWhileStmtERKNS_9WhileStmtE", "clang::CodeGen::CodeGenFunction::EmitWhileStmt(clang::WhileStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction10EmitDoStmtERKNS_6DoStmtE", "clang::CodeGen::CodeGenFunction::EmitDoStmt(clang::DoStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitForStmtERKNS_7ForStmtE", "clang::CodeGen::CodeGenFunction::EmitForStmt(clang::ForStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitReturnStmtERKNS_10ReturnStmtE", "clang::CodeGen::CodeGenFunction::EmitReturnStmt(clang::ReturnStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14EmitSwitchStmtERKNS_10SwitchStmtE", "clang::CodeGen::CodeGenFunction::EmitSwitchStmt(clang::SwitchStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitAsmStmtERKNS_7AsmStmtE", "clang::CodeGen::CodeGenFunction::EmitAsmStmt(clang::AsmStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitCompoundStmtERKNS_12CompoundStmtEbNS0_12AggValueSlotE", "clang::CodeGen::CodeGenFunction::EmitCompoundStmt(clang::CompoundStmt const&, bool, clang::CodeGen::AggValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitDeclStmtERKNS_8DeclStmtE", "clang::CodeGen::CodeGenFunction::EmitDeclStmt(clang::DeclStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitLabelStmtERKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::EmitLabelStmt(clang::LabelStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitGotoStmtERKNS_8GotoStmtE", "clang::CodeGen::CodeGenFunction::EmitGotoStmt(clang::GotoStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitBreakStmtERKNS_9BreakStmtE", "clang::CodeGen::CodeGenFunction::EmitBreakStmt(clang::BreakStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitContinueStmtERKNS_12ContinueStmtE", "clang::CodeGen::CodeGenFunction::EmitContinueStmt(clang::ContinueStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitDefaultStmtERKNS_11DefaultStmtE", "clang::CodeGen::CodeGenFunction::EmitDefaultStmt(clang::DefaultStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitCaseStmtERKNS_8CaseStmtE", "clang::CodeGen::CodeGenFunction::EmitCaseStmt(clang::CaseStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction9EmitLabelERKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::EmitLabel(clang::LabelStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24SimplifyForwardingBlocksEPN4llvm10BasicBlockE", "clang::CodeGen::CodeGenFunction::SimplifyForwardingBlocks(llvm::BasicBlock*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction9EmitBlockEPN4llvm10BasicBlockEb", "clang::CodeGen::CodeGenFunction::EmitBlock(llvm::BasicBlock*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction10EmitBranchEPN4llvm10BasicBlockE", "clang::CodeGen::CodeGenFunction::EmitBranch(llvm::BasicBlock*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction19getJumpDestForLabelEPKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::getJumpDestForLabel(clang::LabelStmt const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitReturnOfRValueENS0_6RValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitReturnOfRValue(clang::CodeGen::RValue, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17EmitCaseStmtRangeERKNS_8CaseStmtE", "clang::CodeGen::CodeGenFunction::EmitCaseStmtRange(clang::CaseStmt const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction18EmitAsmInputLValueERKNS_7AsmStmtERKNS_10TargetInfo14ConstraintInfoENS0_6LValueENS_8QualTypeERSs", "clang::CodeGen::CodeGenFunction::EmitAsmInputLValue(clang::AsmStmt const&, clang::TargetInfo::ConstraintInfo const&, clang::CodeGen::LValue, clang::QualType, std::string&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12EmitAsmInputERKNS_7AsmStmtERKNS_10TargetInfo14ConstraintInfoEPKNS_4ExprERSs", "clang::CodeGen::CodeGenFunction::EmitAsmInput(clang::AsmStmt const&, clang::TargetInfo::ConstraintInfo const&, clang::Expr const*, std::string&)"},
    {"_Z18SimplifyConstraintPKcRKN5clang10TargetInfoEPN4llvm15SmallVectorImplINS2_14ConstraintInfoEEE", "SimplifyConstraint(char const*, clang::TargetInfo const&, llvm::SmallVectorImpl<clang::TargetInfo::ConstraintInfo>*)"},
    {"_Z22AddVariableConstraintsRKSsRKN5clang4ExprERKNS1_10TargetInfoERNS1_7CodeGen13CodeGenModuleERKNS1_7AsmStmtE", "AddVariableConstraints(std::string const&, clang::Expr const&, clang::TargetInfo const&, clang::CodeGen::CodeGenModule&, clang::AsmStmt const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateSwitchEPNS_5ValueEPNS_10BasicBlockEj", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateSwitch(llvm::Value*, llvm::BasicBlock*, unsigned int)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateCallIN9__gnu_cxx17__normal_iteratorIPPNS_5ValueESt6vectorIS9_SaIS9_EEEEEEPNS_8CallInstES9_T_SH_RKNS_5TwineE", "llvm::CallInst* llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCall<__gnu_cxx::__normal_iterator<llvm::Value**, std::vector<llvm::Value*, std::allocator<llvm::Value*> > > >(llvm::Value*, __gnu_cxx::__normal_iterator<llvm::Value**, std::vector<llvm::Value*, std::allocator<llvm::Value*> > >, __gnu_cxx::__normal_iterator<llvm::Value**, std::vector<llvm::Value*, std::allocator<llvm::Value*> > >, llvm::Twine const&)"},
    {"_ZNSt6vectorIN5clang7CodeGen6LValueESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::CodeGen::LValue, std::allocator<clang::CodeGen::LValue> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::CodeGen::LValue*, std::vector<clang::CodeGen::LValue, std::allocator<clang::CodeGen::LValue> > >, clang::CodeGen::LValue const&)"},
    {"_ZNSt6vectorIN5clang8QualTypeESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<clang::QualType, std::allocator<clang::QualType> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::QualType*, std::vector<clang::QualType, std::allocator<clang::QualType> > >, clang::QualType const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang7VarDeclEPNS_5ValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::VarDecl const*, llvm::Value*, llvm::DenseMapInfo<clang::VarDecl const*>, llvm::DenseMapInfo<llvm::Value*> >::InsertIntoBucket(clang::VarDecl const* const&, llvm::Value* const&, std::pair<clang::VarDecl const*, llvm::Value*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang7VarDeclEPNS_5ValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::VarDecl const*, llvm::Value*, llvm::DenseMapInfo<clang::VarDecl const*>, llvm::DenseMapInfo<llvm::Value*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang9LabelStmtENS1_7CodeGen15CodeGenFunction8JumpDestENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::LabelStmt const*, clang::CodeGen::CodeGenFunction::JumpDest, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<clang::CodeGen::CodeGenFunction::JumpDest> >::InsertIntoBucket(clang::LabelStmt const* const&, clang::CodeGen::CodeGenFunction::JumpDest const&, std::pair<clang::LabelStmt const*, clang::CodeGen::CodeGenFunction::JumpDest>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang9LabelStmtENS1_7CodeGen15CodeGenFunction8JumpDestENS_12DenseMapInfoIS4_EENS8_IS7_EEE4growEj", "llvm::DenseMap<clang::LabelStmt const*, clang::CodeGen::CodeGenFunction::JumpDest, llvm::DenseMapInfo<clang::LabelStmt const*>, llvm::DenseMapInfo<clang::CodeGen::CodeGenFunction::JumpDest> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitCXXTemporaryEPKNS_12CXXTemporaryEPN4llvm5ValueE", "clang::CodeGen::CodeGenFunction::EmitCXXTemporary(clang::CXXTemporary const*, llvm::Value*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitExprWithCleanupsEPKNS_16ExprWithCleanupsENS0_12AggValueSlotE", "clang::CodeGen::CodeGenFunction::EmitExprWithCleanups(clang::ExprWithCleanups const*, clang::CodeGen::AggValueSlot)"},
    {"_ZN5clang7CodeGen15CodeGenFunction26EmitExprWithCleanupsLValueEPKNS_16ExprWithCleanupsE", "clang::CodeGen::CodeGenFunction::EmitExprWithCleanupsLValue(clang::ExprWithCleanups const*)"},
    {"_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~ConditionalCleanup2()"},
    {"_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::ConditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~ConditionalCleanup2()"},
    {"_ZN5clang7CodeGen12EHScopeStack19ConditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::ConditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED1Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~UnconditionalCleanup2()"},
    {"_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEED0Ev", "clang::CodeGen::EHScopeStack::UnconditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::~UnconditionalCleanup2()"},
    {"_ZN5clang7CodeGen12EHScopeStack21UnconditionalCleanup2IN12_GLOBAL__N_116DestroyTemporaryEPKNS_17CXXDestructorDeclEPN4llvm5ValueEE4EmitERNS0_15CodeGenFunctionEb", "clang::CodeGen::EHScopeStack::UnconditionalCleanup2<(anonymous namespace)::DestroyTemporary, clang::CXXDestructorDecl const*, llvm::Value*>::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN5clang7CodeGen14CodeGenVTables17EmitVTTDefinitionEPN4llvm14GlobalVariableENS2_11GlobalValue12LinkageTypesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::EmitVTTDefinition(llvm::GlobalVariable*, llvm::GlobalValue::LinkageTypes, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_110VTTBuilderC1ERN5clang7CodeGen13CodeGenModuleEPKNS1_13CXXRecordDeclEb", "(anonymous namespace)::VTTBuilder::VTTBuilder(clang::CodeGen::CodeGenModule&, clang::CXXRecordDecl const*, bool)"},
    {"_ZN5clang7CodeGen14CodeGenVTables12GetAddrOfVTTEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::GetAddrOfVTT(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen14CodeGenVTables17needsVTTParameterENS0_10GlobalDeclE", "clang::CodeGen::CodeGenVTables::needsVTTParameter(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen14CodeGenVTables14getSubVTTIndexEPKNS_13CXXRecordDeclENS0_13BaseSubobjectE", "clang::CodeGen::CodeGenVTables::getSubVTTIndex(clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject)"},
    {"_ZN5clang7CodeGen14CodeGenVTables31getSecondaryVirtualPointerIndexEPKNS_13CXXRecordDeclENS0_13BaseSubobjectE", "clang::CodeGen::CodeGenVTables::getSecondaryVirtualPointerIndex(clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject)"},
    {"_ZN12_GLOBAL__N_110VTTBuilder9LayoutVTTEN5clang7CodeGen13BaseSubobjectEb", "(anonymous namespace)::VTTBuilder::LayoutVTT(clang::CodeGen::BaseSubobject, bool)"},
    {"_ZN12_GLOBAL__N_110VTTBuilder16AddVTablePointerEN5clang7CodeGen13BaseSubobjectEPN4llvm8ConstantEPKNS1_13CXXRecordDeclERKNS4_8DenseMapIS3_yNS4_12DenseMapInfoIS3_EENSB_IyEEEE", "(anonymous namespace)::VTTBuilder::AddVTablePointer(clang::CodeGen::BaseSubobject, llvm::Constant*, clang::CXXRecordDecl const*, llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> > const&)"},
    {"_ZN12_GLOBAL__N_110VTTBuilder17LayoutVirtualVTTsEPKN5clang13CXXRecordDeclERN4llvm11SmallPtrSetIS4_Lj4EEE", "(anonymous namespace)::VTTBuilder::LayoutVirtualVTTs(clang::CXXRecordDecl const*, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"},
    {"_ZN12_GLOBAL__N_110VTTBuilder30LayoutSecondaryVirtualPointersEN5clang7CodeGen13BaseSubobjectEbPN4llvm8ConstantEPKNS1_13CXXRecordDeclERKNS4_8DenseMapIS3_yNS4_12DenseMapInfoIS3_EENSB_IyEEEERNS4_11SmallPtrSetIS9_Lj4EEE", "(anonymous namespace)::VTTBuilder::LayoutSecondaryVirtualPointers(clang::CodeGen::BaseSubobject, bool, llvm::Constant*, clang::CXXRecordDecl const*, llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> > const&, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclENS2_7CodeGen13BaseSubobjectEEyNS_12DenseMapInfoIS8_EENS9_IyEEE6insertERKS1_IS8_yE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject> >, llvm::DenseMapInfo<unsigned long long> >::insert(std::pair<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long> const&)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen13BaseSubobjectEyNS_12DenseMapInfoIS3_EENS4_IyEEE16FindAndConstructERKS3_", "llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> >::FindAndConstruct(clang::CodeGen::BaseSubobject const&)"},
    {"_ZN5clang7CodeGen14CodeGenVTables26ComputeMethodVTableIndicesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::ComputeMethodVTableIndices(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen14CodeGenVTables29getNumVirtualFunctionPointersEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::getNumVirtualFunctionPointers(clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_127FindNearestOverriddenMethodEPKN5clang13CXXMethodDeclERN4llvm14SmallSetVectorIPKNS0_13CXXRecordDeclELj8EEE", "(anonymous namespace)::FindNearestOverriddenMethod(clang::CXXMethodDecl const*, llvm::SmallSetVector<clang::CXXRecordDecl const*, 8u>&)"},
    {"_ZN12_GLOBAL__N_133ComputeReturnAdjustmentBaseOffsetERN5clang10ASTContextEPKNS0_13CXXMethodDeclES5_", "(anonymous namespace)::ComputeReturnAdjustmentBaseOffset(clang::ASTContext&, clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"},
    {"_ZN5clang7CodeGen14CodeGenVTables20getMethodVTableIndexENS0_10GlobalDeclE", "clang::CodeGen::CodeGenVTables::getMethodVTableIndex(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen14CodeGenVTables24ShouldEmitVTableInThisTUEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::ShouldEmitVTableInThisTU(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen14CodeGenVTables26getVirtualBaseOffsetOffsetEPKNS_13CXXRecordDeclES4_", "clang::CodeGen::CodeGenVTables::getVirtualBaseOffsetOffset(clang::CXXRecordDecl const*, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilderC1EPKN5clang13CXXRecordDeclES4_PKNS_15FinalOverridersENS1_7CodeGen13BaseSubobjectEby", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::VCallAndVBaseOffsetBuilder(clang::CXXRecordDecl const*, clang::CXXRecordDecl const*, (anonymous namespace)::FinalOverriders const*, clang::CodeGen::BaseSubobject, bool, unsigned long long)"},
    {"_ZN5clang7CodeGen14CodeGenVTables15getAddressPointENS0_13BaseSubobjectEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::getAddressPoint(clang::CodeGen::BaseSubobject, clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule14GetAddrOfThunkENS0_10GlobalDeclERKNS_9ThunkInfoE", "clang::CodeGen::CodeGenModule::GetAddrOfThunk(clang::CodeGen::GlobalDecl, clang::ThunkInfo const&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13GenerateThunkEPN4llvm8FunctionENS0_10GlobalDeclERKNS_9ThunkInfoE", "clang::CodeGen::CodeGenFunction::GenerateThunk(llvm::Function*, clang::CodeGen::GlobalDecl, clang::ThunkInfo const&)"},
    {"_Z21PerformTypeAdjustmentRN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueExx", "PerformTypeAdjustment(clang::CodeGen::CodeGenFunction&, llvm::Value*, long long, long long)"},
    {"_ZN5clang7CodeGen14CodeGenVTables9EmitThunkENS0_10GlobalDeclERKNS_9ThunkInfoEb", "clang::CodeGen::CodeGenVTables::EmitThunk(clang::CodeGen::GlobalDecl, clang::ThunkInfo const&, bool)"},
    {"_ZN5clang7CodeGen14CodeGenVTables33MaybeEmitThunkAvailableExternallyENS0_10GlobalDeclERKNS_9ThunkInfoE", "clang::CodeGen::CodeGenVTables::MaybeEmitThunkAvailableExternally(clang::CodeGen::GlobalDecl, clang::ThunkInfo const&)"},
    {"_ZN5clang7CodeGen14CodeGenVTables10EmitThunksENS0_10GlobalDeclE", "clang::CodeGen::CodeGenVTables::EmitThunks(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen14CodeGenVTables31ComputeVTableRelatedInformationEPKNS_13CXXRecordDeclEb", "clang::CodeGen::CodeGenVTables::ComputeVTableRelatedInformation(clang::CXXRecordDecl const*, bool)"},
    {"_ZN12_GLOBAL__N_113VTableBuilderC1ERN5clang7CodeGen14CodeGenVTablesEPKNS1_13CXXRecordDeclEybS7_", "(anonymous namespace)::VTableBuilder::VTableBuilder(clang::CodeGen::CodeGenVTables&, clang::CXXRecordDecl const*, unsigned long long, bool, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_113VTableBuilderD1Ev", "(anonymous namespace)::VTableBuilder::~VTableBuilder()"},
    {"_ZN5clang7CodeGen14CodeGenVTables23CreateVTableInitializerEPKNS_13CXXRecordDeclEPKyjRKN4llvm11SmallVectorISt4pairIyNS_9ThunkInfoEELj1EEE", "clang::CodeGen::CodeGenVTables::CreateVTableInitializer(clang::CXXRecordDecl const*, unsigned long long const*, unsigned int, llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u> const&)"},
    {"_ZN5clang7CodeGen14CodeGenVTables15GetAddrOfVTableEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::GetAddrOfVTable(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen14CodeGenVTables20EmitVTableDefinitionEPN4llvm14GlobalVariableENS2_11GlobalValue12LinkageTypesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::EmitVTableDefinition(llvm::GlobalVariable*, llvm::GlobalValue::LinkageTypes, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder10dumpLayoutERN4llvm11raw_ostreamE", "(anonymous namespace)::VTableBuilder::dumpLayout(llvm::raw_ostream&)"},
    {"_ZN5clang7CodeGen14CodeGenVTables26GenerateConstructionVTableEPKNS_13CXXRecordDeclERKNS0_13BaseSubobjectEbRN4llvm8DenseMapIS5_yNS8_12DenseMapInfoIS5_EENSA_IyEEEE", "clang::CodeGen::CodeGenVTables::GenerateConstructionVTable(clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject const&, bool, llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> >&)"},
    {"_ZN5clang7CodeGen14CodeGenVTables17GenerateClassDataEN4llvm11GlobalValue12LinkageTypesEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenVTables::GenerateClassData(llvm::GlobalValue::LinkageTypes, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder32LayoutPrimaryAndSecondaryVTablesEN5clang7CodeGen13BaseSubobjectEbby", "(anonymous namespace)::VTableBuilder::LayoutPrimaryAndSecondaryVTables(clang::CodeGen::BaseSubobject, bool, bool, unsigned long long)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder28DeterminePrimaryVirtualBasesEPKN5clang13CXXRecordDeclEyRN4llvm11SmallPtrSetIS4_Lj4EEE", "(anonymous namespace)::VTableBuilder::DeterminePrimaryVirtualBases(clang::CXXRecordDecl const*, unsigned long long, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder28LayoutVTablesForVirtualBasesEPKN5clang13CXXRecordDeclERN4llvm11SmallPtrSetIS4_Lj4EEE", "(anonymous namespace)::VTableBuilder::LayoutVTablesForVirtualBases(clang::CXXRecordDecl const*, llvm::SmallPtrSet<clang::CXXRecordDecl const*, 4u>&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEN12_GLOBAL__N_114VCallOffsetMapENS_12DenseMapInfoIS4_EENS7_IS6_EEEixERKS4_", "llvm::DenseMap<clang::CXXRecordDecl const*, (anonymous namespace)::VCallOffsetMap, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<(anonymous namespace)::VCallOffsetMap> >::operator[](clang::CXXRecordDecl const* const&)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder10AddMethodsEN5clang7CodeGen13BaseSubobjectEyPKNS1_13CXXRecordDeclEyRN4llvm14SmallSetVectorIS6_Lj8EEE", "(anonymous namespace)::VTableBuilder::AddMethods(clang::CodeGen::BaseSubobject, unsigned long long, clang::CXXRecordDecl const*, unsigned long long, llvm::SmallSetVector<clang::CXXRecordDecl const*, 8u>&)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder22LayoutSecondaryVTablesEN5clang7CodeGen13BaseSubobjectEby", "(anonymous namespace)::VTableBuilder::LayoutSecondaryVTables(clang::CodeGen::BaseSubobject, bool, unsigned long long)"},
    {"_ZN12_GLOBAL__N_113VTableBuilder21ComputeThisAdjustmentEPKN5clang13CXXMethodDeclEyNS_15FinalOverriders13OverriderInfoE", "(anonymous namespace)::VTableBuilder::ComputeThisAdjustment(clang::CXXMethodDecl const*, unsigned long long, (anonymous namespace)::FinalOverriders::OverriderInfo)"},
    {"_ZN12_GLOBAL__N_114VCallOffsetMap26MethodsCanShareVCallOffsetEPKN5clang13CXXMethodDeclES4_", "(anonymous namespace)::VCallOffsetMap::MethodsCanShareVCallOffset(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_117ComputeBaseOffsetERN5clang10ASTContextEPKNS0_13CXXRecordDeclERKNS0_11CXXBasePathE", "(anonymous namespace)::ComputeBaseOffset(clang::ASTContext&, clang::CXXRecordDecl const*, clang::CXXBasePath const&)"},
    {"_ZNK4llvm8DenseMapISt4pairIPKN5clang13CXXMethodDeclEyEN12_GLOBAL__N_115FinalOverriders13OverriderInfoENS_12DenseMapInfoIS6_EENSA_IS9_EEE15LookupBucketForERKS6_RPS1_IS6_S9_E", "llvm::DenseMap<std::pair<clang::CXXMethodDecl const*, unsigned long long>, (anonymous namespace)::FinalOverriders::OverriderInfo, llvm::DenseMapInfo<std::pair<clang::CXXMethodDecl const*, unsigned long long> >, llvm::DenseMapInfo<(anonymous namespace)::FinalOverriders::OverriderInfo> >::LookupBucketFor(std::pair<clang::CXXMethodDecl const*, unsigned long long> const&, std::pair<std::pair<clang::CXXMethodDecl const*, unsigned long long>, (anonymous namespace)::FinalOverriders::OverriderInfo>*&) const"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXMethodDeclEN12_GLOBAL__N_113VTableBuilder10MethodInfoENS_12DenseMapInfoIS4_EENS8_IS7_EEE6insertERKSt4pairIS4_S7_E", "llvm::DenseMap<clang::CXXMethodDecl const*, (anonymous namespace)::VTableBuilder::MethodInfo, llvm::DenseMapInfo<clang::CXXMethodDecl const*>, llvm::DenseMapInfo<(anonymous namespace)::VTableBuilder::MethodInfo> >::insert(std::pair<clang::CXXMethodDecl const*, (anonymous namespace)::VTableBuilder::MethodInfo> const&)"},
    {"_ZN12_GLOBAL__N_130OverridesIndirectMethodInBasesEPKN5clang13CXXMethodDeclERN4llvm14SmallSetVectorIPKNS0_13CXXRecordDeclELj8EEE", "(anonymous namespace)::OverridesIndirectMethodInBases(clang::CXXMethodDecl const*, llvm::SmallSetVector<clang::CXXRecordDecl const*, 8u>&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXMethodDeclEN12_GLOBAL__N_113VTableBuilder10MethodInfoENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::CXXMethodDecl const*, (anonymous namespace)::VTableBuilder::MethodInfo, llvm::DenseMapInfo<clang::CXXMethodDecl const*>, llvm::DenseMapInfo<(anonymous namespace)::VTableBuilder::MethodInfo> >::InsertIntoBucket(clang::CXXMethodDecl const* const&, (anonymous namespace)::VTableBuilder::MethodInfo const&, std::pair<clang::CXXMethodDecl const*, (anonymous namespace)::VTableBuilder::MethodInfo>*)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN12_GLOBAL__N_115VTableComponentELb0EE4growEm", "llvm::SmallVectorTemplateBase<(anonymous namespace)::VTableComponent, false>::grow(unsigned long)"},
    {"_ZN12_GLOBAL__N_115FinalOverriders18ComputeBaseOffsetsEN5clang7CodeGen13BaseSubobjectEbyRN4llvm8DenseMapISt4pairIPKNS1_13CXXRecordDeclEjEyNS4_12DenseMapInfoISA_EENSB_IyEEEESF_RNS5_IS9_jNSB_IS9_EENSB_IjEEEE", "(anonymous namespace)::FinalOverriders::ComputeBaseOffsets(clang::CodeGen::BaseSubobject, bool, unsigned long long, llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, unsigned int> >, llvm::DenseMapInfo<unsigned long long> >&, llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, unsigned int> >, llvm::DenseMapInfo<unsigned long long> >&, llvm::DenseMap<clang::CXXRecordDecl const*, unsigned int, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<unsigned int> >&)"},
    {"_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilder23AddVCallAndVBaseOffsetsEN5clang7CodeGen13BaseSubobjectEby", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::AddVCallAndVBaseOffsets(clang::CodeGen::BaseSubobject, bool, unsigned long long)"},
    {"_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilder15AddVBaseOffsetsEPKN5clang13CXXRecordDeclEy", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::AddVBaseOffsets(clang::CXXRecordDecl const*, unsigned long long)"},
    {"_ZN12_GLOBAL__N_126VCallAndVBaseOffsetBuilder15AddVCallOffsetsEN5clang7CodeGen13BaseSubobjectEy", "(anonymous namespace)::VCallAndVBaseOffsetBuilder::AddVCallOffsets(clang::CodeGen::BaseSubobject, unsigned long long)"},
    {"_ZN12_GLOBAL__N_127ComputeAllOverriddenMethodsEPKN5clang13CXXMethodDeclERN4llvm11SmallPtrSetIS3_Lj8EEE", "(anonymous namespace)::ComputeAllOverriddenMethods(clang::CXXMethodDecl const*, llvm::SmallPtrSet<clang::CXXMethodDecl const*, 8u>&)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclES5_ExNS_12DenseMapInfoIS6_EENS7_IxEEE6insertERKS1_IS6_xE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*> >, llvm::DenseMapInfo<long long> >::insert(std::pair<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long> const&)"},
    {"_ZN4llvm15SmallVectorImplISt4pairIyN5clang9ThunkInfoEEE6appendINS_16DenseMapIteratorIyS3_NS_12DenseMapInfoIyEENS8_IS3_EELb1EEEEEvT_SC_", "void llvm::SmallVectorImpl<std::pair<unsigned long long, clang::ThunkInfo> >::append<llvm::DenseMapIterator<unsigned long long, clang::ThunkInfo, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<clang::ThunkInfo>, true> >(llvm::DenseMapIterator<unsigned long long, clang::ThunkInfo, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<clang::ThunkInfo>, true>, llvm::DenseMapIterator<unsigned long long, clang::ThunkInfo, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<clang::ThunkInfo>, true>)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEPNS_14GlobalVariableENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::GlobalVariable*, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::GlobalVariable*> >::InsertIntoBucket(clang::CXXRecordDecl const* const&, llvm::GlobalVariable* const&, std::pair<clang::CXXRecordDecl const*, llvm::GlobalVariable*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEPNS_14GlobalVariableENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::GlobalVariable*, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::GlobalVariable*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen13BaseSubobjectEyNS_12DenseMapInfoIS3_EENS4_IyEEE6insertERKSt4pairIS3_yE", "llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> >::insert(std::pair<clang::CodeGen::BaseSubobject, unsigned long long> const&)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen13BaseSubobjectEyNS_12DenseMapInfoIS3_EENS4_IyEEE16InsertIntoBucketERKS3_RKyPSt4pairIS3_yE", "llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> >::InsertIntoBucket(clang::CodeGen::BaseSubobject const&, unsigned long long const&, std::pair<clang::CodeGen::BaseSubobject, unsigned long long>*)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen13BaseSubobjectEyNS_12DenseMapInfoIS3_EENS4_IyEEE4growEj", "llvm::DenseMap<clang::CodeGen::BaseSubobject, unsigned long long, llvm::DenseMapInfo<clang::CodeGen::BaseSubobject>, llvm::DenseMapInfo<unsigned long long> >::grow(unsigned int)"},
    {"_ZNK4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclES5_ExNS_12DenseMapInfoIS6_EENS7_IxEEE15LookupBucketForERKS6_RPS1_IS6_xE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*> >, llvm::DenseMapInfo<long long> >::LookupBucketFor(std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*> const&, std::pair<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long>*&) const"},
    {"_ZNK4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclENS2_7CodeGen13BaseSubobjectEEyNS_12DenseMapInfoIS8_EENS9_IyEEE15LookupBucketForERKS8_RPS1_IS8_yE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject> >, llvm::DenseMapInfo<unsigned long long> >::LookupBucketFor(std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject> const&, std::pair<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long>*&) const"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclENS2_7CodeGen13BaseSubobjectEEyNS_12DenseMapInfoIS8_EENS9_IyEEE16InsertIntoBucketERKS8_RKyPS1_IS8_yE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject> >, llvm::DenseMapInfo<unsigned long long> >::InsertIntoBucket(std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject> const&, unsigned long long const&, std::pair<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long>*)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclENS2_7CodeGen13BaseSubobjectEEyNS_12DenseMapInfoIS8_EENS9_IyEEE4growEj", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CodeGen::BaseSubobject> >, llvm::DenseMapInfo<unsigned long long> >::grow(unsigned int)"},
    {"_ZSt16__introsort_loopIPSt4pairIyN5clang9ThunkInfoEElEvT_S5_T0_", "void std::__introsort_loop<std::pair<unsigned long long, clang::ThunkInfo>*, long>(std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>*, long)"},
    {"_ZSt22__final_insertion_sortIPSt4pairIyN5clang9ThunkInfoEEEvT_S5_", "void std::__final_insertion_sort<std::pair<unsigned long long, clang::ThunkInfo>*>(std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>*)"},
    {"_ZSt16__insertion_sortIPSt4pairIyN5clang9ThunkInfoEEEvT_S5_", "void std::__insertion_sort<std::pair<unsigned long long, clang::ThunkInfo>*>(std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>*)"},
    {"_ZSt21__unguarded_partitionIPSt4pairIyN5clang9ThunkInfoEES3_ET_S5_S5_T0_", "std::pair<unsigned long long, clang::ThunkInfo>* std::__unguarded_partition<std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo> >(std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>)"},
    {"_ZSt8__medianISt4pairIyN5clang9ThunkInfoEEERKT_S6_S6_S6_", "std::pair<unsigned long long, clang::ThunkInfo> const& std::__median<std::pair<unsigned long long, clang::ThunkInfo> >(std::pair<unsigned long long, clang::ThunkInfo> const&, std::pair<unsigned long long, clang::ThunkInfo> const&, std::pair<unsigned long long, clang::ThunkInfo> const&)"},
    {"_ZSt13__heap_selectIPSt4pairIyN5clang9ThunkInfoEEEvT_S5_S5_", "void std::__heap_select<std::pair<unsigned long long, clang::ThunkInfo>*>(std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>*, std::pair<unsigned long long, clang::ThunkInfo>*)"},
    {"_ZSt13__adjust_heapIPSt4pairIyN5clang9ThunkInfoEElS3_EvT_T0_S6_T1_", "void std::__adjust_heap<std::pair<unsigned long long, clang::ThunkInfo>*, long, std::pair<unsigned long long, clang::ThunkInfo> >(std::pair<unsigned long long, clang::ThunkInfo>*, long, long, std::pair<unsigned long long, clang::ThunkInfo>)"},
    {"_ZN4llvm23SmallVectorTemplateBaseISt4pairIyN5clang9ThunkInfoEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<unsigned long long, clang::ThunkInfo>, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_11SmallVectorISt4pairIyNS1_9ThunkInfoEELj1EEENS_12DenseMapInfoIS4_EENSA_IS9_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u>, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u> > >::FindAndConstruct(clang::CXXRecordDecl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_11SmallVectorISt4pairIyNS1_9ThunkInfoEELj1EEENS_12DenseMapInfoIS4_EENSA_IS9_EEE16InsertIntoBucketERKS4_RKS9_PS6_IS4_S9_E", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u>, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u> > >::InsertIntoBucket(clang::CXXRecordDecl const* const&, llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u> const&, std::pair<clang::CXXRecordDecl const*, llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_11SmallVectorISt4pairIyNS1_9ThunkInfoEELj1EEENS_12DenseMapInfoIS4_EENSA_IS9_EEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u>, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<unsigned long long, clang::ThunkInfo>, 1u> > >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplISt4pairIyN5clang9ThunkInfoEEEaSERKS5_", "llvm::SmallVectorImpl<std::pair<unsigned long long, clang::ThunkInfo> >::operator=(llvm::SmallVectorImpl<std::pair<unsigned long long, clang::ThunkInfo> > const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXMethodDeclENS_11SmallVectorINS1_9ThunkInfoELj1EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE6insertERKSt4pairIS4_S7_E", "llvm::DenseMap<clang::CXXMethodDecl const*, llvm::SmallVector<clang::ThunkInfo, 1u>, llvm::DenseMapInfo<clang::CXXMethodDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ThunkInfo, 1u> > >::insert(std::pair<clang::CXXMethodDecl const*, llvm::SmallVector<clang::ThunkInfo, 1u> > const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXMethodDeclENS_11SmallVectorINS1_9ThunkInfoELj1EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::CXXMethodDecl const*, llvm::SmallVector<clang::ThunkInfo, 1u>, llvm::DenseMapInfo<clang::CXXMethodDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ThunkInfo, 1u> > >::InsertIntoBucket(clang::CXXMethodDecl const* const&, llvm::SmallVector<clang::ThunkInfo, 1u> const&, std::pair<clang::CXXMethodDecl const*, llvm::SmallVector<clang::ThunkInfo, 1u> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXMethodDeclENS_11SmallVectorINS1_9ThunkInfoELj1EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE4growEj", "llvm::DenseMap<clang::CXXMethodDecl const*, llvm::SmallVector<clang::ThunkInfo, 1u>, llvm::DenseMapInfo<clang::CXXMethodDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ThunkInfo, 1u> > >::grow(unsigned int)"},
    {"_ZN4llvm15SmallVectorImplIN5clang9ThunkInfoEEaSERKS3_", "llvm::SmallVectorImpl<clang::ThunkInfo>::operator=(llvm::SmallVectorImpl<clang::ThunkInfo> const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang9ThunkInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ThunkInfo, false>::grow(unsigned long)"},
    {"_ZNSt6vectorIPKN5clang13CXXRecordDeclESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<clang::CXXRecordDecl const*, std::allocator<clang::CXXRecordDecl const*> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::CXXRecordDecl const**, std::vector<clang::CXXRecordDecl const*, std::allocator<clang::CXXRecordDecl const*> > >, clang::CXXRecordDecl const* const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_14PointerIntPairIPyLj1EbNS_21PointerLikeTypeTraitsIS6_EEEENS_12DenseMapInfoIS4_EENSA_IS9_EEE16InsertIntoBucketERKS4_RKS9_PSt4pairIS4_S9_E", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::PointerIntPair<unsigned long long*, 1u, bool, llvm::PointerLikeTypeTraits<unsigned long long*> >, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::PointerIntPair<unsigned long long*, 1u, bool, llvm::PointerLikeTypeTraits<unsigned long long*> > > >::InsertIntoBucket(clang::CXXRecordDecl const* const&, llvm::PointerIntPair<unsigned long long*, 1u, bool, llvm::PointerLikeTypeTraits<unsigned long long*> > const&, std::pair<clang::CXXRecordDecl const*, llvm::PointerIntPair<unsigned long long*, 1u, bool, llvm::PointerLikeTypeTraits<unsigned long long*> > >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclENS_14PointerIntPairIPyLj1EbNS_21PointerLikeTypeTraitsIS6_EEEENS_12DenseMapInfoIS4_EENSA_IS9_EEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, llvm::PointerIntPair<unsigned long long*, 1u, bool, llvm::PointerLikeTypeTraits<unsigned long long*> >, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<llvm::PointerIntPair<unsigned long long*, 1u, bool, llvm::PointerLikeTypeTraits<unsigned long long*> > > >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclES5_ExNS_12DenseMapInfoIS6_EENS7_IxEEE16InsertIntoBucketERKS6_RKxPS1_IS6_xE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*> >, llvm::DenseMapInfo<long long> >::InsertIntoBucket(std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*> const&, long long const&, std::pair<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long>*)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclES5_ExNS_12DenseMapInfoIS6_EENS7_IxEEE4growEj", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*>, long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, clang::CXXRecordDecl const*> >, llvm::DenseMapInfo<long long> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEyNS_12DenseMapInfoIS4_EENS5_IyEEE16InsertIntoBucketERKS4_RKyPSt4pairIS4_yE", "llvm::DenseMap<clang::CXXRecordDecl const*, unsigned long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<unsigned long long> >::InsertIntoBucket(clang::CXXRecordDecl const* const&, unsigned long long const&, std::pair<clang::CXXRecordDecl const*, unsigned long long>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEyNS_12DenseMapInfoIS4_EENS5_IyEEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, unsigned long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<unsigned long long> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen10GlobalDeclExNS_12DenseMapInfoIS3_EENS4_IxEEE16InsertIntoBucketERKS3_RKxPSt4pairIS3_xE", "llvm::DenseMap<clang::CodeGen::GlobalDecl, long long, llvm::DenseMapInfo<clang::CodeGen::GlobalDecl>, llvm::DenseMapInfo<long long> >::InsertIntoBucket(clang::CodeGen::GlobalDecl const&, long long const&, std::pair<clang::CodeGen::GlobalDecl, long long>*)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen10GlobalDeclExNS_12DenseMapInfoIS3_EENS4_IxEEE4growEj", "llvm::DenseMap<clang::CodeGen::GlobalDecl, long long, llvm::DenseMapInfo<clang::CodeGen::GlobalDecl>, llvm::DenseMapInfo<long long> >::grow(unsigned int)"},
    {"_ZNSt8_Rb_treeIySt4pairIKyN5clang7CodeGen13BaseSubobjectEESt10_Select1stIS5_ESt4lessIyESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<unsigned long long, std::pair<unsigned long long const, clang::CodeGen::BaseSubobject>, std::_Select1st<std::pair<unsigned long long const, clang::CodeGen::BaseSubobject> >, std::less<unsigned long long>, std::allocator<std::pair<unsigned long long const, clang::CodeGen::BaseSubobject> > >::_M_erase(std::_Rb_tree_node<std::pair<unsigned long long const, clang::CodeGen::BaseSubobject> >*)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsPKN5clang13CXXMethodDeclEESt10_Select1stIS6_ESt4lessISsESaIS6_EE8_M_eraseEPSt13_Rb_tree_nodeIS6_E", "std::_Rb_tree<std::string, std::pair<std::string const, clang::CXXMethodDecl const*>, std::_Select1st<std::pair<std::string const, clang::CXXMethodDecl const*> >, std::less<std::string>, std::allocator<std::pair<std::string const, clang::CXXMethodDecl const*> > >::_M_erase(std::_Rb_tree_node<std::pair<std::string const, clang::CXXMethodDecl const*> >*)"},
    {"_ZSt16__introsort_loopIPN5clang9ThunkInfoElEvT_S3_T0_", "void std::__introsort_loop<clang::ThunkInfo*, long>(clang::ThunkInfo*, clang::ThunkInfo*, long)"},
    {"_ZSt22__final_insertion_sortIPN5clang9ThunkInfoEEvT_S3_", "void std::__final_insertion_sort<clang::ThunkInfo*>(clang::ThunkInfo*, clang::ThunkInfo*)"},
    {"_ZSt16__insertion_sortIPN5clang9ThunkInfoEEvT_S3_", "void std::__insertion_sort<clang::ThunkInfo*>(clang::ThunkInfo*, clang::ThunkInfo*)"},
    {"_ZSt21__unguarded_partitionIPN5clang9ThunkInfoES1_ET_S3_S3_T0_", "clang::ThunkInfo* std::__unguarded_partition<clang::ThunkInfo*, clang::ThunkInfo>(clang::ThunkInfo*, clang::ThunkInfo*, clang::ThunkInfo)"},
    {"_ZSt8__medianIN5clang9ThunkInfoEERKT_S4_S4_S4_", "clang::ThunkInfo const& std::__median<clang::ThunkInfo>(clang::ThunkInfo const&, clang::ThunkInfo const&, clang::ThunkInfo const&)"},
    {"_ZSt13__heap_selectIPN5clang9ThunkInfoEEvT_S3_S3_", "void std::__heap_select<clang::ThunkInfo*>(clang::ThunkInfo*, clang::ThunkInfo*, clang::ThunkInfo*)"},
    {"_ZSt13__adjust_heapIPN5clang9ThunkInfoElS1_EvT_T0_S4_T1_", "void std::__adjust_heap<clang::ThunkInfo*, long, clang::ThunkInfo>(clang::ThunkInfo*, long, long, clang::ThunkInfo)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXMethodDeclENS_11SmallVectorINS1_9ThunkInfoELj1EEENS_12DenseMapInfoIS4_EENS8_IS7_EEE16FindAndConstructERKS4_", "llvm::DenseMap<clang::CXXMethodDecl const*, llvm::SmallVector<clang::ThunkInfo, 1u>, llvm::DenseMapInfo<clang::CXXMethodDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::ThunkInfo, 1u> > >::FindAndConstruct(clang::CXXMethodDecl const* const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsPKN5clang13CXXMethodDeclEESt10_Select1stIS6_ESt4lessISsESaIS6_EE16_M_insert_uniqueERKS6_", "std::_Rb_tree<std::string, std::pair<std::string const, clang::CXXMethodDecl const*>, std::_Select1st<std::pair<std::string const, clang::CXXMethodDecl const*> >, std::less<std::string>, std::allocator<std::pair<std::string const, clang::CXXMethodDecl const*> > >::_M_insert_unique(std::pair<std::string const, clang::CXXMethodDecl const*> const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsPKN5clang13CXXMethodDeclEESt10_Select1stIS6_ESt4lessISsESaIS6_EE9_M_insertEPSt18_Rb_tree_node_baseSE_RKS6_", "std::_Rb_tree<std::string, std::pair<std::string const, clang::CXXMethodDecl const*>, std::_Select1st<std::pair<std::string const, clang::CXXMethodDecl const*> >, std::less<std::string>, std::allocator<std::pair<std::string const, clang::CXXMethodDecl const*> > >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::pair<std::string const, clang::CXXMethodDecl const*> const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsxESt10_Select1stIS2_ESt4lessISsESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E", "std::_Rb_tree<std::string, std::pair<std::string const, long long>, std::_Select1st<std::pair<std::string const, long long> >, std::less<std::string>, std::allocator<std::pair<std::string const, long long> > >::_M_erase(std::_Rb_tree_node<std::pair<std::string const, long long> >*)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsxESt10_Select1stIS2_ESt4lessISsESaIS2_EE16_M_insert_uniqueERKS2_", "std::_Rb_tree<std::string, std::pair<std::string const, long long>, std::_Select1st<std::pair<std::string const, long long> >, std::less<std::string>, std::allocator<std::pair<std::string const, long long> > >::_M_insert_unique(std::pair<std::string const, long long> const&)"},
    {"_ZNSt8_Rb_treeISsSt4pairIKSsxESt10_Select1stIS2_ESt4lessISsESaIS2_EE9_M_insertEPSt18_Rb_tree_node_baseSA_RKS2_", "std::_Rb_tree<std::string, std::pair<std::string const, long long>, std::_Select1st<std::pair<std::string const, long long> >, std::less<std::string>, std::allocator<std::pair<std::string const, long long> > >::_M_insert(std::_Rb_tree_node_base*, std::_Rb_tree_node_base*, std::pair<std::string const, long long> const&)"},
    {"_ZNK5clang15ASTRecordLayout25getVBaseClassOffsetInBitsEPKNS_13CXXRecordDeclE", "clang::ASTRecordLayout::getVBaseClassOffsetInBits(clang::CXXRecordDecl const*) const"},
    {"_ZSt6__findIPN5clang9ThunkInfoES1_ET_S3_S3_RKT0_St26random_access_iterator_tag", "clang::ThunkInfo* std::__find<clang::ThunkInfo*, clang::ThunkInfo>(clang::ThunkInfo*, clang::ThunkInfo*, clang::ThunkInfo const&, std::random_access_iterator_tag)"},
    {"_ZN4llvm8DenseMapIyN5clang9ThunkInfoENS_12DenseMapInfoIyEENS3_IS2_EEE16InsertIntoBucketERKyRKS2_PSt4pairIyS2_E", "llvm::DenseMap<unsigned long long, clang::ThunkInfo, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<clang::ThunkInfo> >::InsertIntoBucket(unsigned long long const&, clang::ThunkInfo const&, std::pair<unsigned long long, clang::ThunkInfo>*)"},
    {"_ZN4llvm8DenseMapIyN5clang9ThunkInfoENS_12DenseMapInfoIyEENS3_IS2_EEE4growEj", "llvm::DenseMap<unsigned long long, clang::ThunkInfo, llvm::DenseMapInfo<unsigned long long>, llvm::DenseMapInfo<clang::ThunkInfo> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclExNS_12DenseMapInfoIS4_EENS5_IxEEE8CopyFromERKS8_", "llvm::DenseMap<clang::CXXRecordDecl const*, long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<long long> >::CopyFrom(llvm::DenseMap<clang::CXXRecordDecl const*, long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<long long> > const&)"},
    {"_ZN4llvm15SmallVectorImplISt4pairIPKN5clang13CXXMethodDeclExEEaSERKS7_", "llvm::SmallVectorImpl<std::pair<clang::CXXMethodDecl const*, long long> >::operator=(llvm::SmallVectorImpl<std::pair<clang::CXXMethodDecl const*, long long> > const&)"},
    {"_ZNK4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclEjEyNS_12DenseMapInfoIS6_EENS7_IyEEE15LookupBucketForERKS6_RPS1_IS6_yE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, unsigned int> >, llvm::DenseMapInfo<unsigned long long> >::LookupBucketFor(std::pair<clang::CXXRecordDecl const*, unsigned int> const&, std::pair<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long>*&) const"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclEjEyNS_12DenseMapInfoIS6_EENS7_IyEEE16InsertIntoBucketERKS6_RKyPS1_IS6_yE", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, unsigned int> >, llvm::DenseMapInfo<unsigned long long> >::InsertIntoBucket(std::pair<clang::CXXRecordDecl const*, unsigned int> const&, unsigned long long const&, std::pair<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long>*)"},
    {"_ZN4llvm8DenseMapISt4pairIPKN5clang13CXXRecordDeclEjEyNS_12DenseMapInfoIS6_EENS7_IyEEE4growEj", "llvm::DenseMap<std::pair<clang::CXXRecordDecl const*, unsigned int>, unsigned long long, llvm::DenseMapInfo<std::pair<clang::CXXRecordDecl const*, unsigned int> >, llvm::DenseMapInfo<unsigned long long> >::grow(unsigned int)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE26CreateConstInBoundsGEP1_64EPNS_5ValueEyRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstInBoundsGEP1_64(llvm::Value*, unsigned long long, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE17CreateInBoundsGEPEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInBoundsGEP(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclExNS_12DenseMapInfoIS4_EENS5_IxEEE6insertERKSt4pairIS4_xE", "llvm::DenseMap<clang::CXXRecordDecl const*, long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<long long> >::insert(std::pair<clang::CXXRecordDecl const*, long long> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclExNS_12DenseMapInfoIS4_EENS5_IxEEE16InsertIntoBucketERKS4_RKxPSt4pairIS4_xE", "llvm::DenseMap<clang::CXXRecordDecl const*, long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<long long> >::InsertIntoBucket(clang::CXXRecordDecl const* const&, long long const&, std::pair<clang::CXXRecordDecl const*, long long>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclExNS_12DenseMapInfoIS4_EENS5_IxEEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, long long, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<long long> >::grow(unsigned int)"},
    {"_ZN5clang15BackendConsumer21InlineAsmDiagHandler2ERKN4llvm12SMDiagnosticENS_14SourceLocationE", "clang::BackendConsumer::InlineAsmDiagHandler2(llvm::SMDiagnostic const&, clang::SourceLocation)"},
    {"_ZN5clang13CodeGenActionC1Ej", "clang::CodeGenAction::CodeGenAction(unsigned int)"},
    {"_ZN5clang13CodeGenActionC2Ej", "clang::CodeGenAction::CodeGenAction(unsigned int)"},
    {"_ZN5clang13CodeGenActionD0Ev", "clang::CodeGenAction::~CodeGenAction()"},
    {"_ZN5clang13CodeGenActionD1Ev", "clang::CodeGenAction::~CodeGenAction()"},
    {"_ZN5clang13CodeGenActionD2Ev", "clang::CodeGenAction::~CodeGenAction()"},
    {"_ZNK5clang13CodeGenAction12hasIRSupportEv", "clang::CodeGenAction::hasIRSupport() const"},
    {"_ZN5clang13CodeGenAction19EndSourceFileActionEv", "clang::CodeGenAction::EndSourceFileAction()"},
    {"_ZN5clang13CodeGenAction10takeModuleEv", "clang::CodeGenAction::takeModule()"},
    {"_ZN5clang13CodeGenAction17CreateASTConsumerERNS_16CompilerInstanceEN4llvm9StringRefE", "clang::CodeGenAction::CreateASTConsumer(clang::CompilerInstance&, llvm::StringRef)"},
    {"_Z15GetOutputStreamRN5clang16CompilerInstanceEN4llvm9StringRefENS_13BackendActionE", "GetOutputStream(clang::CompilerInstance&, llvm::StringRef, clang::BackendAction)"},
    {"_ZN5clang13CodeGenAction13ExecuteActionEv", "clang::CodeGenAction::ExecuteAction()"},
    {"_ZN5clang18EmitAssemblyActionC1Ev", "clang::EmitAssemblyAction::EmitAssemblyAction()"},
    {"_ZN5clang18EmitAssemblyActionC2Ev", "clang::EmitAssemblyAction::EmitAssemblyAction()"},
    {"_ZN5clang12EmitBCActionC1Ev", "clang::EmitBCAction::EmitBCAction()"},
    {"_ZN5clang12EmitBCActionC2Ev", "clang::EmitBCAction::EmitBCAction()"},
    {"_ZN5clang14EmitLLVMActionC1Ev", "clang::EmitLLVMAction::EmitLLVMAction()"},
    {"_ZN5clang14EmitLLVMActionC2Ev", "clang::EmitLLVMAction::EmitLLVMAction()"},
    {"_ZN5clang18EmitLLVMOnlyActionC1Ev", "clang::EmitLLVMOnlyAction::EmitLLVMOnlyAction()"},
    {"_ZN5clang18EmitLLVMOnlyActionC2Ev", "clang::EmitLLVMOnlyAction::EmitLLVMOnlyAction()"},
    {"_ZN5clang21EmitCodeGenOnlyActionC1Ev", "clang::EmitCodeGenOnlyAction::EmitCodeGenOnlyAction()"},
    {"_ZN5clang21EmitCodeGenOnlyActionC2Ev", "clang::EmitCodeGenOnlyAction::EmitCodeGenOnlyAction()"},
    {"_ZN5clang13EmitObjActionC1Ev", "clang::EmitObjAction::EmitObjAction()"},
    {"_ZN5clang13EmitObjActionC2Ev", "clang::EmitObjAction::EmitObjAction()"},
    {"_ZN4llvm7ParseIREPNS_12MemoryBufferERNS_12SMDiagnosticERNS_11LLVMContextE", "llvm::ParseIR(llvm::MemoryBuffer*, llvm::SMDiagnostic&, llvm::LLVMContext&)"},
    {"_ZN5clang13EmitObjActionD1Ev", "clang::EmitObjAction::~EmitObjAction()"},
    {"_ZN5clang13EmitObjActionD0Ev", "clang::EmitObjAction::~EmitObjAction()"},
    {"_ZN5clang21EmitCodeGenOnlyActionD1Ev", "clang::EmitCodeGenOnlyAction::~EmitCodeGenOnlyAction()"},
    {"_ZN5clang21EmitCodeGenOnlyActionD0Ev", "clang::EmitCodeGenOnlyAction::~EmitCodeGenOnlyAction()"},
    {"_ZN5clang18EmitLLVMOnlyActionD1Ev", "clang::EmitLLVMOnlyAction::~EmitLLVMOnlyAction()"},
    {"_ZN5clang18EmitLLVMOnlyActionD0Ev", "clang::EmitLLVMOnlyAction::~EmitLLVMOnlyAction()"},
    {"_ZN5clang14EmitLLVMActionD1Ev", "clang::EmitLLVMAction::~EmitLLVMAction()"},
    {"_ZN5clang14EmitLLVMActionD0Ev", "clang::EmitLLVMAction::~EmitLLVMAction()"},
    {"_ZN5clang12EmitBCActionD1Ev", "clang::EmitBCAction::~EmitBCAction()"},
    {"_ZN5clang12EmitBCActionD0Ev", "clang::EmitBCAction::~EmitBCAction()"},
    {"_ZN5clang18EmitAssemblyActionD1Ev", "clang::EmitAssemblyAction::~EmitAssemblyAction()"},
    {"_ZN5clang18EmitAssemblyActionD0Ev", "clang::EmitAssemblyAction::~EmitAssemblyAction()"},
    {"_ZN5clang15BackendConsumerD1Ev", "clang::BackendConsumer::~BackendConsumer()"},
    {"_ZN5clang15BackendConsumerD0Ev", "clang::BackendConsumer::~BackendConsumer()"},
    {"_ZN5clang15BackendConsumer10InitializeERNS_10ASTContextE", "clang::BackendConsumer::Initialize(clang::ASTContext&)"},
    {"_ZN5clang15BackendConsumer18HandleTopLevelDeclENS_12DeclGroupRefE", "clang::BackendConsumer::HandleTopLevelDecl(clang::DeclGroupRef)"},
    {"_ZN5clang15BackendConsumer21HandleTranslationUnitERNS_10ASTContextE", "clang::BackendConsumer::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN5clang15BackendConsumer23HandleTagDeclDefinitionEPNS_7TagDeclE", "clang::BackendConsumer::HandleTagDeclDefinition(clang::TagDecl*)"},
    {"_ZN5clang15BackendConsumer27CompleteTentativeDefinitionEPNS_7VarDeclE", "clang::BackendConsumer::CompleteTentativeDefinition(clang::VarDecl*)"},
    {"_ZN5clang15BackendConsumer12HandleVTableEPNS_13CXXRecordDeclEb", "clang::BackendConsumer::HandleVTable(clang::CXXRecordDecl*, bool)"},
    {"_ZN5clang20PrettyStackTraceDeclD1Ev", "clang::PrettyStackTraceDecl::~PrettyStackTraceDecl()"},
    {"_ZN5clang20PrettyStackTraceDeclD0Ev", "clang::PrettyStackTraceDecl::~PrettyStackTraceDecl()"},
    {"_ZN5clang15BackendConsumer20InlineAsmDiagHandlerERKN4llvm12SMDiagnosticEPvj", "clang::BackendConsumer::InlineAsmDiagHandler(llvm::SMDiagnostic const&, void*, unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunctionC1ERNS0_13CodeGenModuleE", "clang::CodeGen::CodeGenFunction::CodeGenFunction(clang::CodeGen::CodeGenModule&)"},
    {"_ZN5clang7CodeGen15CodeGenFunctionC2ERNS0_13CodeGenModuleE", "clang::CodeGen::CodeGenFunction::CodeGenFunction(clang::CodeGen::CodeGenModule&)"},
    {"_ZNK5clang7CodeGen15CodeGenFunction10getContextEv", "clang::CodeGen::CodeGenFunction::getContext() const"},
    {"_ZN5clang7CodeGen15CodeGenFunction17ConvertTypeForMemENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::ConvertTypeForMem(clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11ConvertTypeENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::ConvertType(clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20hasAggregateLLVMTypeENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::hasAggregateLLVMType(clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction15EmitReturnBlockEv", "clang::CodeGen::CodeGenFunction::EmitReturnBlock()"},
    {"_ZN5clang7CodeGen15CodeGenFunction14FinishFunctionENS_14SourceLocationE", "clang::CodeGen::CodeGenFunction::FinishFunction(clang::SourceLocation)"},
    {"_ZN5clang7CodeGen15CodeGenFunction27EmitFunctionInstrumentationEPKc", "clang::CodeGen::CodeGenFunction::EmitFunctionInstrumentation(char const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction24ShouldInstrumentFunctionEv", "clang::CodeGen::CodeGenFunction::ShouldInstrumentFunction()"},
    {"_ZN5clang7CodeGen15CodeGenFunction13StartFunctionENS0_10GlobalDeclENS_8QualTypeEPN4llvm8FunctionERKNS4_11SmallVectorISt4pairIPKNS_7VarDeclES3_ELj16EEENS_14SourceLocationE", "clang::CodeGen::CodeGenFunction::StartFunction(clang::CodeGen::GlobalDecl, clang::QualType, llvm::Function*, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u> const&, clang::SourceLocation)"},
    {"_ZN5clang7CodeGen15CodeGenFunction11EmitVLASizeENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitVLASize(clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitFunctionBodyERN4llvm11SmallVectorISt4pairIPKNS_7VarDeclENS_8QualTypeEELj16EEE", "clang::CodeGen::CodeGenFunction::EmitFunctionBody(llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction12GenerateCodeENS0_10GlobalDeclEPN4llvm8FunctionE", "clang::CodeGen::CodeGenFunction::GenerateCode(clang::CodeGen::GlobalDecl, llvm::Function*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction13ContainsLabelEPKNS_4StmtEb", "clang::CodeGen::CodeGenFunction::ContainsLabel(clang::Stmt const*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction28ConstantFoldsToSimpleIntegerEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::ConstantFoldsToSimpleInteger(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20EmitBranchOnBoolExprEPKNS_4ExprEPN4llvm10BasicBlockES7_", "clang::CodeGen::CodeGenFunction::EmitBranchOnBoolExpr(clang::Expr const*, llvm::BasicBlock*, llvm::BasicBlock*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16ErrorUnsupportedEPKNS_4StmtEPKcb", "clang::CodeGen::CodeGenFunction::ErrorUnsupported(clang::Stmt const*, char const*, bool)"},
    {"_ZN5clang7CodeGen15CodeGenFunction22EmitNullInitializationEPN4llvm5ValueENS_8QualTypeE", "clang::CodeGen::CodeGenFunction::EmitNullInitialization(llvm::Value*, clang::QualType)"},
    {"_ZN5clang7CodeGen15CodeGenFunction10GetVLASizeEPKNS_17VariableArrayTypeE", "clang::CodeGen::CodeGenFunction::GetVLASize(clang::VariableArrayType const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction14GetAddrOfLabelEPKNS_9LabelStmtE", "clang::CodeGen::CodeGenFunction::GetAddrOfLabel(clang::LabelStmt const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction20GetIndirectGotoBlockEv", "clang::CodeGen::CodeGenFunction::GetIndirectGotoBlock()"},
    {"_ZN5clang7CodeGen15CodeGenFunction13EmitVAListRefEPKNS_4ExprE", "clang::CodeGen::CodeGenFunction::EmitVAListRef(clang::Expr const*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction23EmitDeclRefExprDbgValueEPKNS_11DeclRefExprEPN4llvm8ConstantE", "clang::CodeGen::CodeGenFunction::EmitDeclRefExprDbgValue(clang::DeclRefExpr const*, llvm::Constant*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateMulEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateMul(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4ExprEPNS_5ValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::Expr const*, llvm::Value*, llvm::DenseMapInfo<clang::Expr const*>, llvm::DenseMapInfo<llvm::Value*> >::InsertIntoBucket(clang::Expr const* const&, llvm::Value* const&, std::pair<clang::Expr const*, llvm::Value*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4ExprEPNS_5ValueENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::Expr const*, llvm::Value*, llvm::DenseMapInfo<clang::Expr const*>, llvm::DenseMapInfo<llvm::Value*> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen13CodeGenModuleC1ERNS_10ASTContextERKNS_14CodeGenOptionsERN4llvm6ModuleERKNS7_10DataLayoutERNS_10DiagnosticE", "clang::CodeGen::CodeGenModule::CodeGenModule(clang::ASTContext&, clang::CodeGenOptions const&, llvm::Module&, llvm::DataLayout const&, clang::Diagnostic&)"},
    {"_ZN5clang7CodeGen13CodeGenModuleC2ERNS_10ASTContextERKNS_14CodeGenOptionsERN4llvm6ModuleERKNS7_10DataLayoutERNS_10DiagnosticE", "clang::CodeGen::CodeGenModule::CodeGenModule(clang::ASTContext&, clang::CodeGenOptions const&, llvm::Module&, llvm::DataLayout const&, clang::Diagnostic&)"},
    {"_ZN5clang7CodeGen13CodeGenModuleD1Ev", "clang::CodeGen::CodeGenModule::~CodeGenModule()"},
    {"_ZN5clang7CodeGen13CodeGenModuleD2Ev", "clang::CodeGen::CodeGenModule::~CodeGenModule()"},
    {"_ZN5clang7CodeGen13CodeGenModule17createObjCRuntimeEv", "clang::CodeGen::CodeGenModule::createObjCRuntime()"},
    {"_ZN5clang7CodeGen13CodeGenModule7ReleaseEv", "clang::CodeGen::CodeGenModule::Release()"},
    {"_ZN5clang7CodeGen13CodeGenModule12EmitDeferredEv", "clang::CodeGen::CodeGenModule::EmitDeferred()"},
    {"_ZN5clang7CodeGen13CodeGenModule13AddGlobalCtorEPN4llvm8FunctionEi", "clang::CodeGen::CodeGenModule::AddGlobalCtor(llvm::Function*, int)"},
    {"_ZN5clang7CodeGen13CodeGenModule12EmitCtorListERKSt6vectorISt4pairIPN4llvm8ConstantEiESaIS7_EEPKc", "clang::CodeGen::CodeGenModule::EmitCtorList(std::vector<std::pair<llvm::Constant*, int>, std::allocator<std::pair<llvm::Constant*, int> > > const&, char const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule15EmitAnnotationsEv", "clang::CodeGen::CodeGenModule::EmitAnnotations()"},
    {"_ZN5clang7CodeGen13CodeGenModule12EmitLLVMUsedEv", "clang::CodeGen::CodeGenModule::EmitLLVMUsed()"},
    {"_ZN5clang7CodeGen13CodeGenModule16EmitDeclMetadataEv", "clang::CodeGen::CodeGenModule::EmitDeclMetadata()"},
    {"_ZN5clang7CodeGen13CodeGenModule11getTBAAInfoENS_8QualTypeE", "clang::CodeGen::CodeGenModule::getTBAAInfo(clang::QualType)"},
    {"_ZN5clang7CodeGen13CodeGenModule19DecorateInstructionEPN4llvm11InstructionEPNS2_6MDNodeE", "clang::CodeGen::CodeGenModule::DecorateInstruction(llvm::Instruction*, llvm::MDNode*)"},
    {"_ZNK5clang7CodeGen13CodeGenModule14isTargetDarwinEv", "clang::CodeGen::CodeGenModule::isTargetDarwin() const"},
    {"_ZN5clang7CodeGen13CodeGenModule16ErrorUnsupportedEPKNS_4StmtEPKcb", "clang::CodeGen::CodeGenModule::ErrorUnsupported(clang::Stmt const*, char const*, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule16ErrorUnsupportedEPKNS_4DeclEPKcb", "clang::CodeGen::CodeGenModule::ErrorUnsupported(clang::Decl const*, char const*, bool)"},
    {"_ZNK5clang7CodeGen13CodeGenModule19setGlobalVisibilityEPN4llvm11GlobalValueEPKNS_9NamedDeclE", "clang::CodeGen::CodeGenModule::setGlobalVisibility(llvm::GlobalValue*, clang::NamedDecl const*) const"},
    {"_ZNK5clang7CodeGen13CodeGenModule17setTypeVisibilityEPN4llvm11GlobalValueEPKNS_13CXXRecordDeclENS1_18TypeVisibilityKindE", "clang::CodeGen::CodeGenModule::setTypeVisibility(llvm::GlobalValue*, clang::CXXRecordDecl const*, clang::CodeGen::CodeGenModule::TypeVisibilityKind) const"},
    {"_ZN5clang7CodeGen13CodeGenModule14getMangledNameENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::getMangledName(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule19getBlockMangledNameENS0_10GlobalDeclERNS_12MangleBufferEPKNS_9BlockDeclE", "clang::CodeGen::CodeGenModule::getBlockMangledName(clang::CodeGen::GlobalDecl, clang::MangleBuffer&, clang::BlockDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule14GetGlobalValueEN4llvm9StringRefE", "clang::CodeGen::CodeGenModule::GetGlobalValue(llvm::StringRef)"},
    {"_ZN5clang7CodeGen13CodeGenModule13AddGlobalDtorEPN4llvm8FunctionEi", "clang::CodeGen::CodeGenModule::AddGlobalDtor(llvm::Function*, int)"},
    {"_ZN5clang7CodeGen13CodeGenModule18getFunctionLinkageEPKNS_12FunctionDeclE", "clang::CodeGen::CodeGenModule::getFunctionLinkage(clang::FunctionDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule31SetFunctionDefinitionAttributesEPKNS_12FunctionDeclEPN4llvm11GlobalValueE", "clang::CodeGen::CodeGenModule::SetFunctionDefinitionAttributes(clang::FunctionDecl const*, llvm::GlobalValue*)"},
    {"_ZN5clang7CodeGen13CodeGenModule19SetCommonAttributesEPKNS_4DeclEPN4llvm11GlobalValueE", "clang::CodeGen::CodeGenModule::SetCommonAttributes(clang::Decl const*, llvm::GlobalValue*)"},
    {"_ZN5clang7CodeGen13CodeGenModule25SetLLVMFunctionAttributesEPKNS_4DeclERKNS0_14CGFunctionInfoEPN4llvm8FunctionE", "clang::CodeGen::CodeGenModule::SetLLVMFunctionAttributes(clang::Decl const*, clang::CodeGen::CGFunctionInfo const&, llvm::Function*)"},
    {"_ZN5clang7CodeGen13CodeGenModule38SetLLVMFunctionAttributesForDefinitionEPKNS_4DeclEPN4llvm8FunctionE", "clang::CodeGen::CodeGenModule::SetLLVMFunctionAttributesForDefinition(clang::Decl const*, llvm::Function*)"},
    {"_ZN5clang7CodeGen13CodeGenModule13AddUsedGlobalEPN4llvm11GlobalValueE", "clang::CodeGen::CodeGenModule::AddUsedGlobal(llvm::GlobalValue*)"},
    {"_ZN5clang7CodeGen13CodeGenModule29SetInternalFunctionAttributesEPKNS_4DeclEPN4llvm8FunctionERKNS0_14CGFunctionInfoE", "clang::CodeGen::CodeGenModule::SetInternalFunctionAttributes(clang::Decl const*, llvm::Function*, clang::CodeGen::CGFunctionInfo const&)"},
    {"_ZN5clang7CodeGen13CodeGenModule21SetFunctionAttributesENS0_10GlobalDeclEPN4llvm8FunctionEb", "clang::CodeGen::CodeGenModule::SetFunctionAttributes(clang::CodeGen::GlobalDecl, llvm::Function*, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule16getVTableLinkageEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenModule::getVTableLinkage(clang::CXXRecordDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule20EmitGlobalDefinitionENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitGlobalDefinition(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule16EmitAnnotateAttrEPN4llvm11GlobalValueEPKNS_12AnnotateAttrEj", "clang::CodeGen::CodeGenModule::EmitAnnotateAttr(llvm::GlobalValue*, clang::AnnotateAttr const*, unsigned int)"},
    {"_ZN5clang7CodeGen13CodeGenModule18MayDeferGenerationEPKNS_9ValueDeclE", "clang::CodeGen::CodeGenModule::MayDeferGeneration(clang::ValueDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule19GetWeakRefReferenceEPKNS_9ValueDeclE", "clang::CodeGen::CodeGenModule::GetWeakRefReference(clang::ValueDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule23GetOrCreateLLVMFunctionEN4llvm9StringRefEPKNS2_4TypeENS0_10GlobalDeclEb", "clang::CodeGen::CodeGenModule::GetOrCreateLLVMFunction(llvm::StringRef, llvm::Type const*, clang::CodeGen::GlobalDecl, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule21GetOrCreateLLVMGlobalEN4llvm9StringRefEPKNS2_11PointerTypeEPKNS_7VarDeclEb", "clang::CodeGen::CodeGenModule::GetOrCreateLLVMGlobal(llvm::StringRef, llvm::PointerType const*, clang::VarDecl const*, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule10EmitGlobalENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitGlobal(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule19EmitAliasDefinitionENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitAliasDefinition(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule28EmitGlobalFunctionDefinitionENS0_10GlobalDeclE", "clang::CodeGen::CodeGenModule::EmitGlobalFunctionDefinition(clang::CodeGen::GlobalDecl)"},
    {"_ZN5clang7CodeGen13CodeGenModule23EmitGlobalVarDefinitionEPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::EmitGlobalVarDefinition(clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule17GetAddrOfFunctionENS0_10GlobalDeclEPKN4llvm4TypeEb", "clang::CodeGen::CodeGenModule::GetAddrOfFunction(clang::CodeGen::GlobalDecl, llvm::Type const*, bool)"},
    {"_ZN5clang7CodeGen13CodeGenModule21CreateRuntimeFunctionEPKN4llvm12FunctionTypeENS2_9StringRefE", "clang::CodeGen::CodeGenModule::CreateRuntimeFunction(llvm::FunctionType const*, llvm::StringRef)"},
    {"_Z20DeclIsConstantGlobalRN5clang10ASTContextEPKNS_7VarDeclE", "DeclIsConstantGlobal(clang::ASTContext&, clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule33CreateOrReplaceCXXRuntimeVariableEN4llvm9StringRefEPKNS2_4TypeENS2_11GlobalValue12LinkageTypesE", "clang::CodeGen::CodeGenModule::CreateOrReplaceCXXRuntimeVariable(llvm::StringRef, llvm::Type const*, llvm::GlobalValue::LinkageTypes)"},
    {"_ZN5clang7CodeGen13CodeGenModule18GetAddrOfGlobalVarEPKNS_7VarDeclEPKN4llvm4TypeE", "clang::CodeGen::CodeGenModule::GetAddrOfGlobalVar(clang::VarDecl const*, llvm::Type const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule21CreateRuntimeVariableEPKN4llvm4TypeENS2_9StringRefE", "clang::CodeGen::CodeGenModule::CreateRuntimeVariable(llvm::Type const*, llvm::StringRef)"},
    {"_ZN5clang7CodeGen13CodeGenModule23EmitTentativeDefinitionEPKNS_7VarDeclE", "clang::CodeGen::CodeGenModule::EmitTentativeDefinition(clang::VarDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule10EmitVTableEPNS_13CXXRecordDeclEb", "clang::CodeGen::CodeGenModule::EmitVTable(clang::CXXRecordDecl*, bool)"},
    {"_ZNK5clang7CodeGen13CodeGenModule22GetTargetTypeStoreSizeEPKN4llvm4TypeE", "clang::CodeGen::CodeGenModule::GetTargetTypeStoreSize(llvm::Type const*) const"},
    {"_ZN5clang7CodeGen13CodeGenModule27GetLLVMLinkageVarDefinitionEPKNS_7VarDeclEPN4llvm14GlobalVariableE", "clang::CodeGen::CodeGenModule::GetLLVMLinkageVarDefinition(clang::VarDecl const*, llvm::GlobalVariable*)"},
    {"_ZN5clang7CodeGen13CodeGenModule21getBuiltinLibFunctionEPKNS_12FunctionDeclEj", "clang::CodeGen::CodeGenModule::getBuiltinLibFunction(clang::FunctionDecl const*, unsigned int)"},
    {"_ZN5clang7CodeGen13CodeGenModule12getIntrinsicEjPPKN4llvm4TypeEj", "clang::CodeGen::CodeGenModule::getIntrinsic(unsigned int, llvm::Type const**, unsigned int)"},
    {"_ZN5clang7CodeGen13CodeGenModule25GetAddrOfConstantCFStringEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantCFString(clang::StringLiteral const*)"},
    {"_Z24GetConstantCFStringEntryRN4llvm9StringMapIPNS_8ConstantENS_15MallocAllocatorEEEPKN5clang13StringLiteralEbRbRj", "GetConstantCFStringEntry(llvm::StringMap<llvm::Constant*, llvm::MallocAllocator>&, clang::StringLiteral const*, bool, bool&, unsigned int&)"},
    {"_ZN5clang7CodeGen13CodeGenModule23GetAddrOfConstantStringEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantString(clang::StringLiteral const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule25GetStringForStringLiteralEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetStringForStringLiteral(clang::StringLiteral const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule34GetAddrOfConstantStringFromLiteralEPKNS_13StringLiteralE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantStringFromLiteral(clang::StringLiteral const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule23GetAddrOfConstantStringERKSsPKc", "clang::CodeGen::CodeGenModule::GetAddrOfConstantString(std::string const&, char const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule37GetAddrOfConstantStringFromObjCEncodeEPKNS_14ObjCEncodeExprE", "clang::CodeGen::CodeGenModule::GetAddrOfConstantStringFromObjCEncode(clang::ObjCEncodeExpr const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule24GetAddrOfConstantCStringERKSsPKc", "clang::CodeGen::CodeGenModule::GetAddrOfConstantCString(std::string const&, char const*)"},
    {"_Z21GenerateStringLiteralRKSsbRN5clang7CodeGen13CodeGenModuleEPKc", "GenerateStringLiteral(std::string const&, bool, clang::CodeGen::CodeGenModule&, char const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule31EmitObjCPropertyImplementationsEPKNS_22ObjCImplementationDeclE", "clang::CodeGen::CodeGenModule::EmitObjCPropertyImplementations(clang::ObjCImplementationDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule27EmitObjCIvarInitializationsEPNS_22ObjCImplementationDeclE", "clang::CodeGen::CodeGenModule::EmitObjCIvarInitializations(clang::ObjCImplementationDecl*)"},
    {"_ZN5clang7CodeGen13CodeGenModule13EmitNamespaceEPKNS_13NamespaceDeclE", "clang::CodeGen::CodeGenModule::EmitNamespace(clang::NamespaceDecl const*)"},
    {"_ZN5clang7CodeGen13CodeGenModule16EmitTopLevelDeclEPNS_4DeclE", "clang::CodeGen::CodeGenModule::EmitTopLevelDecl(clang::Decl*)"},
    {"_ZN5clang7CodeGen13CodeGenModule15EmitLinkageSpecEPKNS_15LinkageSpecDeclE", "clang::CodeGen::CodeGenModule::EmitLinkageSpec(clang::LinkageSpecDecl const*)"},
    {"_Z22EmitGlobalDeclMetadataRN5clang7CodeGen13CodeGenModuleERPN4llvm11NamedMDNodeENS0_10GlobalDeclEPNS3_11GlobalValueE", "EmitGlobalDeclMetadata(clang::CodeGen::CodeGenModule&, llvm::NamedMDNode*&, clang::CodeGen::GlobalDecl, llvm::GlobalValue*)"},
    {"_ZN5clang7CodeGen15CodeGenFunction16EmitDeclMetadataEv", "clang::CodeGen::CodeGenFunction::EmitDeclMetadata()"},
    {"_ZN5clang7CodeGen13CodeGenModule21getBlockObjectDisposeEv", "clang::CodeGen::CodeGenModule::getBlockObjectDispose()"},
    {"_ZN5clang7CodeGen13CodeGenModule20getBlockObjectAssignEv", "clang::CodeGen::CodeGenModule::getBlockObjectAssign()"},
    {"_ZN5clang7CodeGen13CodeGenModule24getNSConcreteGlobalBlockEv", "clang::CodeGen::CodeGenModule::getNSConcreteGlobalBlock()"},
    {"_ZN5clang7CodeGen13CodeGenModule23getNSConcreteStackBlockEv", "clang::CodeGen::CodeGenModule::getNSConcreteStackBlock()"},
    {"_ZNK5clang4Decl7getAttrINS_11SectionAttrEEEPT_v", "clang::SectionAttr* clang::Decl::getAttr<clang::SectionAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_9AliasAttrEEEPT_v", "clang::AliasAttr* clang::Decl::getAttr<clang::AliasAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_12AnnotateAttrEEEPT_v", "clang::AnnotateAttr* clang::Decl::getAttr<clang::AnnotateAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_12NoCommonAttrEEEPT_v", "clang::NoCommonAttr* clang::Decl::getAttr<clang::NoCommonAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_10CommonAttrEEEPT_v", "clang::CommonAttr* clang::Decl::getAttr<clang::CommonAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_15ConstructorAttrEEEPT_v", "clang::ConstructorAttr* clang::Decl::getAttr<clang::ConstructorAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_14DestructorAttrEEEPT_v", "clang::DestructorAttr* clang::Decl::getAttr<clang::DestructorAttr>() const"},
    {"_ZN4llvm9StringMapIPNS_8ConstantENS_15MallocAllocatorEE16GetOrCreateValueIS2_EERNS_14StringMapEntryIS2_EENS_9StringRefET_", "llvm::StringMapEntry<llvm::Constant*>& llvm::StringMap<llvm::Constant*, llvm::MallocAllocator>::GetOrCreateValue<llvm::Constant*>(llvm::StringRef, llvm::Constant*)"},
    {"_ZN4llvm9StringMapIN5clang7CodeGen10GlobalDeclENS_15MallocAllocatorEE16GetOrCreateValueIS3_EERNS_14StringMapEntryIS3_EENS_9StringRefET_", "llvm::StringMapEntry<clang::CodeGen::GlobalDecl>& llvm::StringMap<clang::CodeGen::GlobalDecl, llvm::MallocAllocator>::GetOrCreateValue<clang::CodeGen::GlobalDecl>(llvm::StringRef, clang::CodeGen::GlobalDecl)"},
    {"_ZNSt6vectorIN5clang7CodeGen10GlobalDeclESaIS2_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS2_S4_EERKS2_", "std::vector<clang::CodeGen::GlobalDecl, std::allocator<clang::CodeGen::GlobalDecl> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::CodeGen::GlobalDecl*, std::vector<clang::CodeGen::GlobalDecl, std::allocator<clang::CodeGen::GlobalDecl> > >, clang::CodeGen::GlobalDecl const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE16InsertIntoBucketERKS4_RKjPSt4pairIS4_jE", "llvm::DenseMap<clang::Decl const*, unsigned int, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::Decl const* const&, unsigned int const&, std::pair<clang::Decl const*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4DeclEjNS_12DenseMapInfoIS4_EENS5_IjEEE4growEj", "llvm::DenseMap<clang::Decl const*, unsigned int, llvm::DenseMapInfo<clang::Decl const*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZNSt6vectorISt4pairIPN4llvm8ConstantEiESaIS4_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS4_S6_EERKS4_", "std::vector<std::pair<llvm::Constant*, int>, std::allocator<std::pair<llvm::Constant*, int> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<llvm::Constant*, int>*, std::vector<std::pair<llvm::Constant*, int>, std::allocator<std::pair<llvm::Constant*, int> > > >, std::pair<llvm::Constant*, int> const&)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen10GlobalDeclENS_9StringRefENS_12DenseMapInfoIS3_EENS5_IS4_EEE16InsertIntoBucketERKS3_RKS4_PSt4pairIS3_S4_E", "llvm::DenseMap<clang::CodeGen::GlobalDecl, llvm::StringRef, llvm::DenseMapInfo<clang::CodeGen::GlobalDecl>, llvm::DenseMapInfo<llvm::StringRef> >::InsertIntoBucket(clang::CodeGen::GlobalDecl const&, llvm::StringRef const&, std::pair<clang::CodeGen::GlobalDecl, llvm::StringRef>*)"},
    {"_ZN4llvm8DenseMapIN5clang7CodeGen10GlobalDeclENS_9StringRefENS_12DenseMapInfoIS3_EENS5_IS4_EEE4growEj", "llvm::DenseMap<clang::CodeGen::GlobalDecl, llvm::StringRef, llvm::DenseMapInfo<clang::CodeGen::GlobalDecl>, llvm::DenseMapInfo<llvm::StringRef> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen15CodeGenFunctionD2Ev", "clang::CodeGen::CodeGenFunction::~CodeGenFunction()"},
    {"_ZN5clang7CodeGen14CodeGenVTablesD2Ev", "clang::CodeGen::CodeGenVTables::~CodeGenVTables()"},
    {"_ZN5clang7CodeGen14CodeGenVTablesC2ERNS0_13CodeGenModuleE", "clang::CodeGen::CodeGenVTables::CodeGenVTables(clang::CodeGen::CodeGenModule&)"},
    {"_ZN5clang7CodeGen11CodeGenTBAAC1ERNS_10ASTContextERN4llvm11LLVMContextERKNS_11LangOptionsERNS_13MangleContextE", "clang::CodeGen::CodeGenTBAA::CodeGenTBAA(clang::ASTContext&, llvm::LLVMContext&, clang::LangOptions const&, clang::MangleContext&)"},
    {"_ZN5clang7CodeGen11CodeGenTBAAC2ERNS_10ASTContextERN4llvm11LLVMContextERKNS_11LangOptionsERNS_13MangleContextE", "clang::CodeGen::CodeGenTBAA::CodeGenTBAA(clang::ASTContext&, llvm::LLVMContext&, clang::LangOptions const&, clang::MangleContext&)"},
    {"_ZN5clang7CodeGen11CodeGenTBAAD1Ev", "clang::CodeGen::CodeGenTBAA::~CodeGenTBAA()"},
    {"_ZN5clang7CodeGen11CodeGenTBAAD2Ev", "clang::CodeGen::CodeGenTBAA::~CodeGenTBAA()"},
    {"_ZN5clang7CodeGen11CodeGenTBAA7getRootEv", "clang::CodeGen::CodeGenTBAA::getRoot()"},
    {"_ZN5clang7CodeGen11CodeGenTBAA23getTBAAInfoForNamedTypeEN4llvm9StringRefEPNS2_6MDNodeEb", "clang::CodeGen::CodeGenTBAA::getTBAAInfoForNamedType(llvm::StringRef, llvm::MDNode*, bool)"},
    {"_ZN5clang7CodeGen11CodeGenTBAA7getCharEv", "clang::CodeGen::CodeGenTBAA::getChar()"},
    {"_ZN5clang7CodeGen11CodeGenTBAA11getTBAAInfoENS_8QualTypeE", "clang::CodeGen::CodeGenTBAA::getTBAAInfo(clang::QualType)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEPNS_6MDNodeENS_12DenseMapInfoIS4_EENS7_IS6_EEE16InsertIntoBucketERKS4_RKS6_PSt4pairIS4_S6_E", "llvm::DenseMap<clang::Type const*, llvm::MDNode*, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<llvm::MDNode*> >::InsertIntoBucket(clang::Type const* const&, llvm::MDNode* const&, std::pair<clang::Type const*, llvm::MDNode*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEPNS_6MDNodeENS_12DenseMapInfoIS4_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::Type const*, llvm::MDNode*, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<llvm::MDNode*> >::grow(unsigned int)"},
    {"_ZN5clang7CodeGen12CodeGenTypesC1ERNS_10ASTContextERN4llvm6ModuleERKNS4_10DataLayoutERKNS_7ABIInfoERNS0_8CGCXXABIE", "clang::CodeGen::CodeGenTypes::CodeGenTypes(clang::ASTContext&, llvm::Module&, llvm::DataLayout const&, clang::ABIInfo const&, clang::CodeGen::CGCXXABI&)"},
    {"_ZN5clang7CodeGen12CodeGenTypesC2ERNS_10ASTContextERN4llvm6ModuleERKNS4_10DataLayoutERKNS_7ABIInfoERNS0_8CGCXXABIE", "clang::CodeGen::CodeGenTypes::CodeGenTypes(clang::ASTContext&, llvm::Module&, llvm::DataLayout const&, clang::ABIInfo const&, clang::CodeGen::CGCXXABI&)"},
    {"_ZN5clang7CodeGen12CodeGenTypesD1Ev", "clang::CodeGen::CodeGenTypes::~CodeGenTypes()"},
    {"_ZN5clang7CodeGen12CodeGenTypesD2Ev", "clang::CodeGen::CodeGenTypes::~CodeGenTypes()"},
    {"_ZN5clang7CodeGen12CodeGenTypes26HandleLateResolvedPointersEv", "clang::CodeGen::CodeGenTypes::HandleLateResolvedPointers()"},
    {"_ZN5clang7CodeGen12CodeGenTypes11ConvertTypeENS_8QualTypeEb", "clang::CodeGen::CodeGenTypes::ConvertType(clang::QualType, bool)"},
    {"_ZN5clang7CodeGen12CodeGenTypes20ConvertTypeRecursiveENS_8QualTypeE", "clang::CodeGen::CodeGenTypes::ConvertTypeRecursive(clang::QualType)"},
    {"_ZN5clang7CodeGen12CodeGenTypes14ConvertNewTypeENS_8QualTypeE", "clang::CodeGen::CodeGenTypes::ConvertNewType(clang::QualType)"},
    {"_ZN5clang7CodeGen12CodeGenTypes17ConvertTypeForMemENS_8QualTypeEb", "clang::CodeGen::CodeGenTypes::ConvertTypeForMem(clang::QualType, bool)"},
    {"_ZN5clang7CodeGen12CodeGenTypes22VerifyFuncTypeCompleteEPKNS_4TypeE", "clang::CodeGen::CodeGenTypes::VerifyFuncTypeComplete(clang::Type const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes19UpdateCompletedTypeEPKNS_7TagDeclE", "clang::CodeGen::CodeGenTypes::UpdateCompletedType(clang::TagDecl const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes18ConvertTagDeclTypeEPKNS_7TagDeclE", "clang::CodeGen::CodeGenTypes::ConvertTagDeclType(clang::TagDecl const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes17getCGRecordLayoutEPKNS_10RecordDeclE", "clang::CodeGen::CodeGenTypes::getCGRecordLayout(clang::RecordDecl const*)"},
    {"_ZN5clang7CodeGen12CodeGenTypes19isZeroInitializableENS_8QualTypeE", "clang::CodeGen::CodeGenTypes::isZeroInitializable(clang::QualType)"},
    {"_ZN5clang7CodeGen12CodeGenTypes19isZeroInitializableEPKNS_13CXXRecordDeclE", "clang::CodeGen::CodeGenTypes::isZeroInitializable(clang::CXXRecordDecl const*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeENS_12PATypeHolderENS_12DenseMapInfoIS4_EENS6_IS5_EEED1Ev", "llvm::DenseMap<clang::Type const*, llvm::PATypeHolder, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<llvm::PATypeHolder> >::~DenseMap()"},
    {"_ZN4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEED1Ev", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::~FoldingSet()"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeENS_12PATypeHolderENS_12DenseMapInfoIS4_EENS6_IS5_EEE6insertERKSt4pairIS4_S5_E", "llvm::DenseMap<clang::Type const*, llvm::PATypeHolder, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<llvm::PATypeHolder> >::insert(std::pair<clang::Type const*, llvm::PATypeHolder> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEPNS1_7CodeGen14CGRecordLayoutENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::Type const*, clang::CodeGen::CGRecordLayout*, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<clang::CodeGen::CGRecordLayout*> >::InsertIntoBucket(clang::Type const* const&, clang::CodeGen::CGRecordLayout* const&, std::pair<clang::Type const*, clang::CodeGen::CGRecordLayout*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeEPNS1_7CodeGen14CGRecordLayoutENS_12DenseMapInfoIS4_EENS8_IS7_EEE4growEj", "llvm::DenseMap<clang::Type const*, clang::CodeGen::CGRecordLayout*, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<clang::CodeGen::CGRecordLayout*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang17ObjCInterfaceTypeEPKNS_4TypeENS_12DenseMapInfoIS4_EENS8_IS7_EEE16InsertIntoBucketERKS4_RKS7_PSt4pairIS4_S7_E", "llvm::DenseMap<clang::ObjCInterfaceType const*, llvm::Type const*, llvm::DenseMapInfo<clang::ObjCInterfaceType const*>, llvm::DenseMapInfo<llvm::Type const*> >::InsertIntoBucket(clang::ObjCInterfaceType const* const&, llvm::Type const* const&, std::pair<clang::ObjCInterfaceType const*, llvm::Type const*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang17ObjCInterfaceTypeEPKNS_4TypeENS_12DenseMapInfoIS4_EENS8_IS7_EEE4growEj", "llvm::DenseMap<clang::ObjCInterfaceType const*, llvm::Type const*, llvm::DenseMapInfo<clang::ObjCInterfaceType const*>, llvm::DenseMapInfo<llvm::Type const*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeENS_12PATypeHolderENS_12DenseMapInfoIS4_EENS6_IS5_EEE16InsertIntoBucketERKS4_RKS5_PSt4pairIS4_S5_E", "llvm::DenseMap<clang::Type const*, llvm::PATypeHolder, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<llvm::PATypeHolder> >::InsertIntoBucket(clang::Type const* const&, llvm::PATypeHolder const&, std::pair<clang::Type const*, llvm::PATypeHolder>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeENS_12PATypeHolderENS_12DenseMapInfoIS4_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::Type const*, llvm::PATypeHolder, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<llvm::PATypeHolder> >::grow(unsigned int)"},
    {"_ZN4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEED0Ev", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::~FoldingSet()"},
    {"_ZNK4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEE14GetNodeProfileEPNS_14FoldingSetImpl4NodeERNS_16FoldingSetNodeIDE", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::GetNodeProfile(llvm::FoldingSetImpl::Node*, llvm::FoldingSetNodeID&) const"},
    {"_ZNK4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEE10NodeEqualsEPNS_14FoldingSetImpl4NodeERKNS_16FoldingSetNodeIDERS8_", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::NodeEquals(llvm::FoldingSetImpl::Node*, llvm::FoldingSetNodeID const&, llvm::FoldingSetNodeID&) const"},
    {"_ZNK4llvm10FoldingSetIN5clang7CodeGen14CGFunctionInfoEE15ComputeNodeHashEPNS_14FoldingSetImpl4NodeERNS_16FoldingSetNodeIDE", "llvm::FoldingSet<clang::CodeGen::CGFunctionInfo>::ComputeNodeHash(llvm::FoldingSetImpl::Node*, llvm::FoldingSetNodeID&) const"},
    {"_ZN5clang7CodeGen14CGFunctionInfo7ProfileERN4llvm16FoldingSetNodeIDE", "clang::CodeGen::CGFunctionInfo::Profile(llvm::FoldingSetNodeID&)"},
    {"_ZN5clang7CodeGen14CGRecordLayoutD2Ev", "clang::CodeGen::CGRecordLayout::~CGRecordLayout()"},
    {"_ZN5clang7CodeGen19CreateItaniumCXXABIERNS0_13CodeGenModuleE", "clang::CodeGen::CreateItaniumCXXABI(clang::CodeGen::CodeGenModule&)"},
    {"_ZN5clang7CodeGen15CreateARMCXXABIERNS0_13CodeGenModuleE", "clang::CodeGen::CreateARMCXXABI(clang::CodeGen::CodeGenModule&)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABID1Ev", "(anonymous namespace)::ARMCXXABI::~ARMCXXABI()"},
    {"_ZN12_GLOBAL__N_19ARMCXXABID0Ev", "(anonymous namespace)::ARMCXXABI::~ARMCXXABI()"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI24ConvertMemberPointerTypeEPKN5clang17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::ConvertMemberPointerType(clang::MemberPointerType const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI31EmitLoadOfMemberFunctionPointerERN5clang7CodeGen15CodeGenFunctionERPN4llvm5ValueES7_PKNS1_17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitLoadOfMemberFunctionPointer(clang::CodeGen::CodeGenFunction&, llvm::Value*&, llvm::Value*, clang::MemberPointerType const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI28EmitMemberDataPointerAddressERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberDataPointerAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI27EmitMemberPointerConversionERN5clang7CodeGen15CodeGenFunctionEPKNS1_8CastExprEPN4llvm5ValueE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerConversion(clang::CodeGen::CodeGenFunction&, clang::CastExpr const*, llvm::Value*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI27EmitMemberPointerConversionEPN4llvm8ConstantEPKN5clang8CastExprE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerConversion(llvm::Constant*, clang::CastExpr const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI19isZeroInitializableEPKN5clang17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::isZeroInitializable(clang::MemberPointerType const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI21EmitNullMemberPointerEPKN5clang17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitNullMemberPointer(clang::MemberPointerType const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI17EmitMemberPointerEPKN5clang13CXXMethodDeclE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointer(clang::CXXMethodDecl const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI21EmitMemberDataPointerEPKN5clang17MemberPointerTypeENS1_9CharUnitsE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberDataPointer(clang::MemberPointerType const*, clang::CharUnits)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI27EmitMemberPointerComparisonERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_17MemberPointerTypeEb", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerComparison(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::MemberPointerType const*, bool)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI26EmitMemberPointerIsNotNullERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEPKNS1_17MemberPointerTypeE", "(anonymous namespace)::ItaniumCXXABI::EmitMemberPointerIsNotNull(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::MemberPointerType const*)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI25BuildConstructorSignatureEPKN5clang18CXXConstructorDeclENS1_11CXXCtorTypeERNS1_7CanQualINS1_4TypeEEERN4llvm15SmallVectorImplIS8_EE", "(anonymous namespace)::ARMCXXABI::BuildConstructorSignature(clang::CXXConstructorDecl const*, clang::CXXCtorType, clang::CanQual<clang::Type>&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI24BuildDestructorSignatureEPKN5clang17CXXDestructorDeclENS1_11CXXDtorTypeERNS1_7CanQualINS1_4TypeEEERN4llvm15SmallVectorImplIS8_EE", "(anonymous namespace)::ARMCXXABI::BuildDestructorSignature(clang::CXXDestructorDecl const*, clang::CXXDtorType, clang::CanQual<clang::Type>&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI27BuildInstanceFunctionParamsERN5clang7CodeGen15CodeGenFunctionERNS1_8QualTypeERN4llvm11SmallVectorISt4pairIPKNS1_7VarDeclES5_ELj16EEE", "(anonymous namespace)::ARMCXXABI::BuildInstanceFunctionParams(clang::CodeGen::CodeGenFunction&, clang::QualType&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI26EmitInstanceFunctionPrologERN5clang7CodeGen15CodeGenFunctionE", "(anonymous namespace)::ARMCXXABI::EmitInstanceFunctionProlog(clang::CodeGen::CodeGenFunction&)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI19EmitReturnFromThunkERN5clang7CodeGen15CodeGenFunctionENS2_6RValueENS1_8QualTypeE", "(anonymous namespace)::ARMCXXABI::EmitReturnFromThunk(clang::CodeGen::CodeGenFunction&, clang::CodeGen::RValue, clang::QualType)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI18GetArrayCookieSizeEPKN5clang10CXXNewExprE", "(anonymous namespace)::ARMCXXABI::GetArrayCookieSize(clang::CXXNewExpr const*)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI21InitializeArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_10CXXNewExprENS1_8QualTypeE", "(anonymous namespace)::ARMCXXABI::InitializeArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::CXXNewExpr const*, clang::QualType)"},
    {"_ZN12_GLOBAL__N_19ARMCXXABI15ReadArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEPKNS1_13CXXDeleteExprENS1_8QualTypeERS7_SC_RNS1_9CharUnitsE", "(anonymous namespace)::ARMCXXABI::ReadArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::CXXDeleteExpr const*, clang::QualType, llvm::Value*&, llvm::Value*&, clang::CharUnits&)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI15EmitGuardedInitERN5clang7CodeGen15CodeGenFunctionERKNS1_7VarDeclEPN4llvm14GlobalVariableE", "(anonymous namespace)::ItaniumCXXABI::EmitGuardedInit(clang::CodeGen::CodeGenFunction&, clang::VarDecl const&, llvm::GlobalVariable*)"},
    {"_ZN12_GLOBAL__N_114CallGuardAbortD1Ev", "(anonymous namespace)::CallGuardAbort::~CallGuardAbort()"},
    {"_ZN12_GLOBAL__N_114CallGuardAbortD0Ev", "(anonymous namespace)::CallGuardAbort::~CallGuardAbort()"},
    {"_ZN12_GLOBAL__N_114CallGuardAbort4EmitERN5clang7CodeGen15CodeGenFunctionEb", "(anonymous namespace)::CallGuardAbort::Emit(clang::CodeGen::CodeGenFunction&, bool)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI26EmitInstanceFunctionPrologERN5clang7CodeGen15CodeGenFunctionE", "(anonymous namespace)::ItaniumCXXABI::EmitInstanceFunctionProlog(clang::CodeGen::CodeGenFunction&)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI27BuildInstanceFunctionParamsERN5clang7CodeGen15CodeGenFunctionERNS1_8QualTypeERN4llvm11SmallVectorISt4pairIPKNS1_7VarDeclES5_ELj16EEE", "(anonymous namespace)::ItaniumCXXABI::BuildInstanceFunctionParams(clang::CodeGen::CodeGenFunction&, clang::QualType&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI24BuildDestructorSignatureEPKN5clang17CXXDestructorDeclENS1_11CXXDtorTypeERNS1_7CanQualINS1_4TypeEEERN4llvm15SmallVectorImplIS8_EE", "(anonymous namespace)::ItaniumCXXABI::BuildDestructorSignature(clang::CXXDestructorDecl const*, clang::CXXDtorType, clang::CanQual<clang::Type>&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI25BuildConstructorSignatureEPKN5clang18CXXConstructorDeclENS1_11CXXCtorTypeERNS1_7CanQualINS1_4TypeEEERN4llvm15SmallVectorImplIS8_EE", "(anonymous namespace)::ItaniumCXXABI::BuildConstructorSignature(clang::CXXConstructorDecl const*, clang::CXXCtorType, clang::CanQual<clang::Type>&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABID1Ev", "(anonymous namespace)::ItaniumCXXABI::~ItaniumCXXABI()"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABID0Ev", "(anonymous namespace)::ItaniumCXXABI::~ItaniumCXXABI()"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI18GetArrayCookieSizeEPKN5clang10CXXNewExprE", "(anonymous namespace)::ItaniumCXXABI::GetArrayCookieSize(clang::CXXNewExpr const*)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI21InitializeArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueES7_PKNS1_10CXXNewExprENS1_8QualTypeE", "(anonymous namespace)::ItaniumCXXABI::InitializeArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, llvm::Value*, clang::CXXNewExpr const*, clang::QualType)"},
    {"_ZN12_GLOBAL__N_113ItaniumCXXABI15ReadArrayCookieERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueEPKNS1_13CXXDeleteExprENS1_8QualTypeERS7_SC_RNS1_9CharUnitsE", "(anonymous namespace)::ItaniumCXXABI::ReadArrayCookie(clang::CodeGen::CodeGenFunction&, llvm::Value*, clang::CXXDeleteExpr const*, clang::QualType, llvm::Value*&, llvm::Value*&, clang::CharUnits&)"},
    {"_ZN5clang7CodeGen15CodeGenFunction17GetAddrOfLocalVarEPKNS_7VarDeclE", "clang::CodeGen::CodeGenFunction::GetAddrOfLocalVar(clang::VarDecl const*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE8CreateOrEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateOr(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE11CreateBinOpENS_11Instruction9BinaryOpsEPNS_5ValueES8_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateBinOp(llvm::Instruction::BinaryOps, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateNSWSubEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateNSWSub(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateNSWAddEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateNSWAdd(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateSelectEPNS_5ValueES6_S6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateSelect(llvm::Value*, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE17CreateInsertValueEPNS_5ValueES6_jRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateInsertValue(llvm::Value*, llvm::Value*, unsigned int, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateAShrEPNS_5ValueES6_RKNS_5TwineEb", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateAShr(llvm::Value*, llvm::Value*, llvm::Twine const&, bool)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateSubEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateSub(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN5clang7CodeGen21CreateMicrosoftCXXABIERNS0_13CodeGenModuleE", "clang::CodeGen::CreateMicrosoftCXXABI(clang::CodeGen::CodeGenModule&)"},
    {"_ZN12_GLOBAL__N_115MicrosoftCXXABID1Ev", "(anonymous namespace)::MicrosoftCXXABI::~MicrosoftCXXABI()"},
    {"_ZN12_GLOBAL__N_115MicrosoftCXXABID0Ev", "(anonymous namespace)::MicrosoftCXXABI::~MicrosoftCXXABI()"},
    {"_ZN12_GLOBAL__N_115MicrosoftCXXABI25BuildConstructorSignatureEPKN5clang18CXXConstructorDeclENS1_11CXXCtorTypeERNS1_7CanQualINS1_4TypeEEERN4llvm15SmallVectorImplIS8_EE", "(anonymous namespace)::MicrosoftCXXABI::BuildConstructorSignature(clang::CXXConstructorDecl const*, clang::CXXCtorType, clang::CanQual<clang::Type>&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&)"},
    {"_ZN12_GLOBAL__N_115MicrosoftCXXABI24BuildDestructorSignatureEPKN5clang17CXXDestructorDeclENS1_11CXXDtorTypeERNS1_7CanQualINS1_4TypeEEERN4llvm15SmallVectorImplIS8_EE", "(anonymous namespace)::MicrosoftCXXABI::BuildDestructorSignature(clang::CXXDestructorDecl const*, clang::CXXDtorType, clang::CanQual<clang::Type>&, llvm::SmallVectorImpl<clang::CanQual<clang::Type> >&)"},
    {"_ZN12_GLOBAL__N_115MicrosoftCXXABI27BuildInstanceFunctionParamsERN5clang7CodeGen15CodeGenFunctionERNS1_8QualTypeERN4llvm11SmallVectorISt4pairIPKNS1_7VarDeclES5_ELj16EEE", "(anonymous namespace)::MicrosoftCXXABI::BuildInstanceFunctionParams(clang::CodeGen::CodeGenFunction&, clang::QualType&, llvm::SmallVector<std::pair<clang::VarDecl const*, clang::QualType>, 16u>&)"},
    {"_ZN12_GLOBAL__N_115MicrosoftCXXABI26EmitInstanceFunctionPrologERN5clang7CodeGen15CodeGenFunctionE", "(anonymous namespace)::MicrosoftCXXABI::EmitInstanceFunctionProlog(clang::CodeGen::CodeGenFunction&)"},
    {"_ZN5clang17CreateLLVMCodeGenERNS_10DiagnosticERKSsRKNS_14CodeGenOptionsERN4llvm11LLVMContextE", "clang::CreateLLVMCodeGen(clang::Diagnostic&, std::string const&, clang::CodeGenOptions const&, llvm::LLVMContext&)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImplD1Ev", "(anonymous namespace)::CodeGeneratorImpl::~CodeGeneratorImpl()"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImplD0Ev", "(anonymous namespace)::CodeGeneratorImpl::~CodeGeneratorImpl()"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl10InitializeERN5clang10ASTContextE", "(anonymous namespace)::CodeGeneratorImpl::Initialize(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl18HandleTopLevelDeclEN5clang12DeclGroupRefE", "(anonymous namespace)::CodeGeneratorImpl::HandleTopLevelDecl(clang::DeclGroupRef)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl21HandleTranslationUnitERN5clang10ASTContextE", "(anonymous namespace)::CodeGeneratorImpl::HandleTranslationUnit(clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl23HandleTagDeclDefinitionEPN5clang7TagDeclE", "(anonymous namespace)::CodeGeneratorImpl::HandleTagDeclDefinition(clang::TagDecl*)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl27CompleteTentativeDefinitionEPN5clang7VarDeclE", "(anonymous namespace)::CodeGeneratorImpl::CompleteTentativeDefinition(clang::VarDecl*)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl12HandleVTableEPN5clang13CXXRecordDeclEb", "(anonymous namespace)::CodeGeneratorImpl::HandleVTable(clang::CXXRecordDecl*, bool)"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl9GetModuleEv", "(anonymous namespace)::CodeGeneratorImpl::GetModule()"},
    {"_ZN12_GLOBAL__N_117CodeGeneratorImpl13ReleaseModuleEv", "(anonymous namespace)::CodeGeneratorImpl::ReleaseModule()"},
    {"_ZN5clang13CodeGeneratorD1Ev", "clang::CodeGenerator::~CodeGenerator()"},
    {"_ZN5clang13CodeGeneratorD0Ev", "clang::CodeGenerator::~CodeGenerator()"},
    {"_ZN5clang7ABIInfoD0Ev", "clang::ABIInfo::~ABIInfo()"},
    {"_ZN5clang7ABIInfoD1Ev", "clang::ABIInfo::~ABIInfo()"},
    {"_ZN5clang7ABIInfoD2Ev", "clang::ABIInfo::~ABIInfo()"},
    {"_ZNK5clang7ABIInfo10getContextEv", "clang::ABIInfo::getContext() const"},
    {"_ZNK5clang7ABIInfo12getVMContextEv", "clang::ABIInfo::getVMContext() const"},
    {"_ZNK5clang7ABIInfo13getDataLayoutEv", "clang::ABIInfo::getDataLayout() const"},
    {"_ZNK5clang10ABIArgInfo4dumpEv", "clang::ABIArgInfo::dump() const"},
    {"_ZN5clang17TargetCodeGenInfoD0Ev", "clang::TargetCodeGenInfo::~TargetCodeGenInfo()"},
    {"_ZN5clang17TargetCodeGenInfoD1Ev", "clang::TargetCodeGenInfo::~TargetCodeGenInfo()"},
    {"_ZN5clang17TargetCodeGenInfoD2Ev", "clang::TargetCodeGenInfo::~TargetCodeGenInfo()"},
    {"_ZN5clang7CodeGen13CodeGenModule20getTargetCodeGenInfoEv", "clang::CodeGen::CodeGenModule::getTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_123X86_64TargetCodeGenInfoD1Ev", "(anonymous namespace)::X86_64TargetCodeGenInfo::~X86_64TargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_123X86_64TargetCodeGenInfoD0Ev", "(anonymous namespace)::X86_64TargetCodeGenInfo::~X86_64TargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_123X86_64TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::X86_64TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK12_GLOBAL__N_123X86_64TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::X86_64TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZN12_GLOBAL__N_113X86_64ABIInfoD1Ev", "(anonymous namespace)::X86_64ABIInfo::~X86_64ABIInfo()"},
    {"_ZN12_GLOBAL__N_113X86_64ABIInfoD0Ev", "(anonymous namespace)::X86_64ABIInfo::~X86_64ABIInfo()"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::X86_64ABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::X86_64ABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo20classifyArgumentTypeEN5clang8QualTypeERjS3_", "(anonymous namespace)::X86_64ABIInfo::classifyArgumentType(clang::QualType, unsigned int&, unsigned int&) const"},
    {"_Z19EmitVAArgFromMemoryPN4llvm5ValueEN5clang8QualTypeERNS2_7CodeGen15CodeGenFunctionE", "EmitVAArgFromMemory(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&)"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo8classifyEN5clang8QualTypeEyRNS0_5ClassES4_", "(anonymous namespace)::X86_64ABIInfo::classify(clang::QualType, unsigned long long, (anonymous namespace)::X86_64ABIInfo::Class&, (anonymous namespace)::X86_64ABIInfo::Class&) const"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo17getIndirectResultEN5clang8QualTypeE", "(anonymous namespace)::X86_64ABIInfo::getIndirectResult(clang::QualType) const"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo22GetINTEGERTypeAtOffsetEPKN4llvm4TypeEjN5clang8QualTypeEj", "(anonymous namespace)::X86_64ABIInfo::GetINTEGERTypeAtOffset(llvm::Type const*, unsigned int, clang::QualType, unsigned int) const"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo18GetSSETypeAtOffsetEPKN4llvm4TypeEjN5clang8QualTypeEj", "(anonymous namespace)::X86_64ABIInfo::GetSSETypeAtOffset(llvm::Type const*, unsigned int, clang::QualType, unsigned int) const"},
    {"_ZNK12_GLOBAL__N_113X86_64ABIInfo19Get16ByteVectorTypeEN5clang8QualTypeE", "(anonymous namespace)::X86_64ABIInfo::Get16ByteVectorType(clang::QualType) const"},
    {"_Z26GetX86_64ByValArgumentPairPKN4llvm4TypeES2_RKNS_10DataLayoutE", "GetX86_64ByValArgumentPair(llvm::Type const*, llvm::Type const*, llvm::DataLayout const&)"},
    {"_Z21BitsContainNoUserDataN5clang8QualTypeEjjRNS_10ASTContextE", "BitsContainNoUserData(clang::QualType, unsigned int, unsigned int, clang::ASTContext&)"},
    {"_Z21ContainsFloatAtOffsetPKN4llvm4TypeEjRKNS_10DataLayoutE", "ContainsFloatAtOffset(llvm::Type const*, unsigned int, llvm::DataLayout const&)"},
    {"_ZN12_GLOBAL__N_126WinX86_64TargetCodeGenInfoD1Ev", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::~WinX86_64TargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_126WinX86_64TargetCodeGenInfoD0Ev", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::~WinX86_64TargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_126WinX86_64TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK12_GLOBAL__N_126WinX86_64TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::WinX86_64TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZN12_GLOBAL__N_116WinX86_64ABIInfoD1Ev", "(anonymous namespace)::WinX86_64ABIInfo::~WinX86_64ABIInfo()"},
    {"_ZN12_GLOBAL__N_116WinX86_64ABIInfoD0Ev", "(anonymous namespace)::WinX86_64ABIInfo::~WinX86_64ABIInfo()"},
    {"_ZNK12_GLOBAL__N_116WinX86_64ABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::WinX86_64ABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_116WinX86_64ABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::WinX86_64ABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_ZNK12_GLOBAL__N_116WinX86_64ABIInfo8classifyEN5clang8QualTypeE", "(anonymous namespace)::WinX86_64ABIInfo::classify(clang::QualType) const"},
    {"_ZN12_GLOBAL__N_123X86_32TargetCodeGenInfoD1Ev", "(anonymous namespace)::X86_32TargetCodeGenInfo::~X86_32TargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_123X86_32TargetCodeGenInfoD0Ev", "(anonymous namespace)::X86_32TargetCodeGenInfo::~X86_32TargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_123X86_32TargetCodeGenInfo19SetTargetAttributesEPKN5clang4DeclEPN4llvm11GlobalValueERNS1_7CodeGen13CodeGenModuleE", "(anonymous namespace)::X86_32TargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK12_GLOBAL__N_123X86_32TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::X86_32TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK12_GLOBAL__N_123X86_32TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::X86_32TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZN12_GLOBAL__N_113X86_32ABIInfoD1Ev", "(anonymous namespace)::X86_32ABIInfo::~X86_32ABIInfo()"},
    {"_ZN12_GLOBAL__N_113X86_32ABIInfoD0Ev", "(anonymous namespace)::X86_32ABIInfo::~X86_32ABIInfo()"},
    {"_ZNK12_GLOBAL__N_113X86_32ABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::X86_32ABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_113X86_32ABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::X86_32ABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_Z25isRecordWithSSEVectorTypeRN5clang10ASTContextENS_8QualTypeE", "isRecordWithSSEVectorType(clang::ASTContext&, clang::QualType)"},
    {"_Z21isSingleElementStructN5clang8QualTypeERNS_10ASTContextE", "isSingleElementStruct(clang::QualType, clang::ASTContext&)"},
    {"_ZN12_GLOBAL__N_113X86_32ABIInfo26shouldReturnTypeInRegisterEN5clang8QualTypeERNS1_10ASTContextE", "(anonymous namespace)::X86_32ABIInfo::shouldReturnTypeInRegister(clang::QualType, clang::ASTContext&)"},
    {"_Z12isEmptyFieldRN5clang10ASTContextEPKNS_9FieldDeclEb", "isEmptyField(clang::ASTContext&, clang::FieldDecl const*, bool)"},
    {"_Z13isEmptyRecordRN5clang10ASTContextENS_8QualTypeEb", "isEmptyRecord(clang::ASTContext&, clang::QualType, bool)"},
    {"_ZN12_GLOBAL__N_123MSP430TargetCodeGenInfoD1Ev", "(anonymous namespace)::MSP430TargetCodeGenInfo::~MSP430TargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_123MSP430TargetCodeGenInfoD0Ev", "(anonymous namespace)::MSP430TargetCodeGenInfo::~MSP430TargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_123MSP430TargetCodeGenInfo19SetTargetAttributesEPKN5clang4DeclEPN4llvm11GlobalValueERNS1_7CodeGen13CodeGenModuleE", "(anonymous namespace)::MSP430TargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"},
    {"_ZN12_GLOBAL__N_114DefaultABIInfoD1Ev", "(anonymous namespace)::DefaultABIInfo::~DefaultABIInfo()"},
    {"_ZN12_GLOBAL__N_114DefaultABIInfoD0Ev", "(anonymous namespace)::DefaultABIInfo::~DefaultABIInfo()"},
    {"_ZNK12_GLOBAL__N_114DefaultABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::DefaultABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_114DefaultABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::DefaultABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_ZN12_GLOBAL__N_123MBlazeTargetCodeGenInfoD1Ev", "(anonymous namespace)::MBlazeTargetCodeGenInfo::~MBlazeTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_123MBlazeTargetCodeGenInfoD0Ev", "(anonymous namespace)::MBlazeTargetCodeGenInfo::~MBlazeTargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_123MBlazeTargetCodeGenInfo19SetTargetAttributesEPKN5clang4DeclEPN4llvm11GlobalValueERNS1_7CodeGen13CodeGenModuleE", "(anonymous namespace)::MBlazeTargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"},
    {"_ZN12_GLOBAL__N_113MBlazeABIInfoD1Ev", "(anonymous namespace)::MBlazeABIInfo::~MBlazeABIInfo()"},
    {"_ZN12_GLOBAL__N_113MBlazeABIInfoD0Ev", "(anonymous namespace)::MBlazeABIInfo::~MBlazeABIInfo()"},
    {"_ZNK12_GLOBAL__N_113MBlazeABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::MBlazeABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_113MBlazeABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::MBlazeABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_ZN12_GLOBAL__N_124SystemZTargetCodeGenInfoD1Ev", "(anonymous namespace)::SystemZTargetCodeGenInfo::~SystemZTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_124SystemZTargetCodeGenInfoD0Ev", "(anonymous namespace)::SystemZTargetCodeGenInfo::~SystemZTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_114SystemZABIInfoD1Ev", "(anonymous namespace)::SystemZABIInfo::~SystemZABIInfo()"},
    {"_ZN12_GLOBAL__N_114SystemZABIInfoD0Ev", "(anonymous namespace)::SystemZABIInfo::~SystemZABIInfo()"},
    {"_ZNK12_GLOBAL__N_114SystemZABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::SystemZABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_114SystemZABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::SystemZABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_ZN12_GLOBAL__N_122PPC32TargetCodeGenInfoD1Ev", "(anonymous namespace)::PPC32TargetCodeGenInfo::~PPC32TargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_122PPC32TargetCodeGenInfoD0Ev", "(anonymous namespace)::PPC32TargetCodeGenInfo::~PPC32TargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_122PPC32TargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::PPC32TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK12_GLOBAL__N_122PPC32TargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::PPC32TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZN12_GLOBAL__N_124DefaultTargetCodeGenInfoD1Ev", "(anonymous namespace)::DefaultTargetCodeGenInfo::~DefaultTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_124DefaultTargetCodeGenInfoD0Ev", "(anonymous namespace)::DefaultTargetCodeGenInfo::~DefaultTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_120ARMTargetCodeGenInfoD1Ev", "(anonymous namespace)::ARMTargetCodeGenInfo::~ARMTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_120ARMTargetCodeGenInfoD0Ev", "(anonymous namespace)::ARMTargetCodeGenInfo::~ARMTargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_120ARMTargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::ARMTargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZN12_GLOBAL__N_110ARMABIInfoD1Ev", "(anonymous namespace)::ARMABIInfo::~ARMABIInfo()"},
    {"_ZN12_GLOBAL__N_110ARMABIInfoD0Ev", "(anonymous namespace)::ARMABIInfo::~ARMABIInfo()"},
    {"_ZNK12_GLOBAL__N_110ARMABIInfo11computeInfoERN5clang7CodeGen14CGFunctionInfoE", "(anonymous namespace)::ARMABIInfo::computeInfo(clang::CodeGen::CGFunctionInfo&) const"},
    {"_ZNK12_GLOBAL__N_110ARMABIInfo9EmitVAArgEPN4llvm5ValueEN5clang8QualTypeERNS4_7CodeGen15CodeGenFunctionE", "(anonymous namespace)::ARMABIInfo::EmitVAArg(llvm::Value*, clang::QualType, clang::CodeGen::CodeGenFunction&) const"},
    {"_Z17isIntegerLikeTypeN5clang8QualTypeERNS_10ASTContextERN4llvm11LLVMContextE", "isIntegerLikeType(clang::QualType, clang::ASTContext&, llvm::LLVMContext&)"},
    {"_ZN12_GLOBAL__N_121MIPSTargetCodeGenInfoD1Ev", "(anonymous namespace)::MIPSTargetCodeGenInfo::~MIPSTargetCodeGenInfo()"},
    {"_ZN12_GLOBAL__N_121MIPSTargetCodeGenInfoD0Ev", "(anonymous namespace)::MIPSTargetCodeGenInfo::~MIPSTargetCodeGenInfo()"},
    {"_ZNK12_GLOBAL__N_121MIPSTargetCodeGenInfo22getDwarfEHStackPointerERN5clang7CodeGen13CodeGenModuleE", "(anonymous namespace)::MIPSTargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK12_GLOBAL__N_121MIPSTargetCodeGenInfo23initDwarfEHRegSizeTableERN5clang7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "(anonymous namespace)::MIPSTargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZNK5clang17TargetCodeGenInfo19SetTargetAttributesEPKNS_4DeclEPN4llvm11GlobalValueERNS_7CodeGen13CodeGenModuleE", "clang::TargetCodeGenInfo::SetTargetAttributes(clang::Decl const*, llvm::GlobalValue*, clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK5clang17TargetCodeGenInfo21extendPointerWithSExtEv", "clang::TargetCodeGenInfo::extendPointerWithSExt() const"},
    {"_ZNK5clang17TargetCodeGenInfo22getDwarfEHStackPointerERNS_7CodeGen13CodeGenModuleE", "clang::TargetCodeGenInfo::getDwarfEHStackPointer(clang::CodeGen::CodeGenModule&) const"},
    {"_ZNK5clang17TargetCodeGenInfo23initDwarfEHRegSizeTableERNS_7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "clang::TargetCodeGenInfo::initDwarfEHRegSizeTable(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZNK5clang17TargetCodeGenInfo19decodeReturnAddressERNS_7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "clang::TargetCodeGenInfo::decodeReturnAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZNK5clang17TargetCodeGenInfo19encodeReturnAddressERNS_7CodeGen15CodeGenFunctionEPN4llvm5ValueE", "clang::TargetCodeGenInfo::encodeReturnAddress(clang::CodeGen::CodeGenFunction&, llvm::Value*) const"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE26CreateConstInBoundsGEP1_32EPNS_5ValueEjRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstInBoundsGEP1_32(llvm::Value*, unsigned int, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE11CreateStoreEPNS_5ValueES6_b", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateStore(llvm::Value*, llvm::Value*, bool)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateLoadEPNS_5ValueEPKc", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateLoad(llvm::Value*, char const*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateAndEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateAnd(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE12CreateCondBrEPNS_5ValueEPNS_10BasicBlockES8_", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCondBr(llvm::Value*, llvm::BasicBlock*, llvm::BasicBlock*)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateGEPEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateGEP(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateLoadEPNS_5ValueERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateLoad(llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE18CreateConstGEP1_32EPNS_5ValueEjRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstGEP1_32(llvm::Value*, unsigned int, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreateAddEPNS_5ValueES6_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateAdd(llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE9CreatePHIEPKNS_4TypeERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreatePHI(llvm::Type const*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateCastENS_11Instruction7CastOpsEPNS_5ValueEPKNS_4TypeERKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateCast(llvm::Instruction::CastOps, llvm::Value*, llvm::Type const*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE10CreateICmpENS_7CmpInst9PredicateEPNS_5ValueES8_RKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateICmp(llvm::CmpInst::Predicate, llvm::Value*, llvm::Value*, llvm::Twine const&)"},
    {"_ZN4llvm9IRBuilderILb0ENS_14ConstantFolderENS_24IRBuilderDefaultInserterILb0EEEE26CreateConstInBoundsGEP2_32EPNS_5ValueEjjRKNS_5TwineE", "llvm::IRBuilder<false, llvm::ConstantFolder, llvm::IRBuilderDefaultInserter<false> >::CreateConstInBoundsGEP2_32(llvm::Value*, unsigned int, unsigned int, llvm::Twine const&)"},
    {"_ZNK5clang4Decl7getAttrINS_19MSP430InterruptAttrEEEPT_v", "clang::MSP430InterruptAttr* clang::Decl::getAttr<clang::MSP430InterruptAttr>() const"},
    {"_ZN5clang8ParseASTERNS_12PreprocessorEPNS_11ASTConsumerERNS_10ASTContextEbbPNS_20CodeCompleteConsumerE", "clang::ParseAST(clang::Preprocessor&, clang::ASTConsumer*, clang::ASTContext&, bool, bool, clang::CodeCompleteConsumer*)"},
    {"_ZN5clang8ParseASTERNS_4SemaEb", "clang::ParseAST(clang::Sema&, bool)"},
    {"_ZN5clang6Parser23ParseCXXInlineMethodDefENS_15AccessSpecifierERNS_10DeclaratorERKNS0_18ParsedTemplateInfoERKNS_14VirtSpecifiersE", "clang::Parser::ParseCXXInlineMethodDef(clang::AccessSpecifier, clang::Declarator&, clang::Parser::ParsedTemplateInfo const&, clang::VirtSpecifiers const&)"},
    {"_ZN5clang6Parser21LateParsedDeclarationD0Ev", "clang::Parser::LateParsedDeclaration::~LateParsedDeclaration()"},
    {"_ZN5clang6Parser21LateParsedDeclarationD1Ev", "clang::Parser::LateParsedDeclaration::~LateParsedDeclaration()"},
    {"_ZN5clang6Parser21LateParsedDeclarationD2Ev", "clang::Parser::LateParsedDeclaration::~LateParsedDeclaration()"},
    {"_ZN5clang6Parser21LateParsedDeclaration28ParseLexedMethodDeclarationsEv", "clang::Parser::LateParsedDeclaration::ParseLexedMethodDeclarations()"},
    {"_ZN5clang6Parser21LateParsedDeclaration20ParseLexedMethodDefsEv", "clang::Parser::LateParsedDeclaration::ParseLexedMethodDefs()"},
    {"_ZN5clang6Parser15LateParsedClassC1EPS0_PNS0_12ParsingClassE", "clang::Parser::LateParsedClass::LateParsedClass(clang::Parser*, clang::Parser::ParsingClass*)"},
    {"_ZN5clang6Parser15LateParsedClassC2EPS0_PNS0_12ParsingClassE", "clang::Parser::LateParsedClass::LateParsedClass(clang::Parser*, clang::Parser::ParsingClass*)"},
    {"_ZN5clang6Parser15LateParsedClassD0Ev", "clang::Parser::LateParsedClass::~LateParsedClass()"},
    {"_ZN5clang6Parser15LateParsedClassD1Ev", "clang::Parser::LateParsedClass::~LateParsedClass()"},
    {"_ZN5clang6Parser15LateParsedClassD2Ev", "clang::Parser::LateParsedClass::~LateParsedClass()"},
    {"_ZN5clang6Parser15LateParsedClass28ParseLexedMethodDeclarationsEv", "clang::Parser::LateParsedClass::ParseLexedMethodDeclarations()"},
    {"_ZN5clang6Parser28ParseLexedMethodDeclarationsERNS0_12ParsingClassE", "clang::Parser::ParseLexedMethodDeclarations(clang::Parser::ParsingClass&)"},
    {"_ZN5clang6Parser15LateParsedClass20ParseLexedMethodDefsEv", "clang::Parser::LateParsedClass::ParseLexedMethodDefs()"},
    {"_ZN5clang6Parser20ParseLexedMethodDefsERNS0_12ParsingClassE", "clang::Parser::ParseLexedMethodDefs(clang::Parser::ParsingClass&)"},
    {"_ZN5clang6Parser27LateParsedMethodDeclaration28ParseLexedMethodDeclarationsEv", "clang::Parser::LateParsedMethodDeclaration::ParseLexedMethodDeclarations()"},
    {"_ZN5clang6Parser27ParseLexedMethodDeclarationERNS0_27LateParsedMethodDeclarationE", "clang::Parser::ParseLexedMethodDeclaration(clang::Parser::LateParsedMethodDeclaration&)"},
    {"_ZN5clang6Parser11LexedMethod20ParseLexedMethodDefsEv", "clang::Parser::LexedMethod::ParseLexedMethodDefs()"},
    {"_ZN5clang6Parser19ParseLexedMethodDefERNS0_11LexedMethodE", "clang::Parser::ParseLexedMethodDef(clang::Parser::LexedMethod&)"},
    {"_ZN5clang6Parser20ConsumeAndStoreUntilENS_3tok9TokenKindES2_RN4llvm11SmallVectorINS_5TokenELj4EEEbb", "clang::Parser::ConsumeAndStoreUntil(clang::tok::TokenKind, clang::tok::TokenKind, llvm::SmallVector<clang::Token, 4u>&, bool, bool)"},
    {"_ZN5clang6Parser11LexedMethodD1Ev", "clang::Parser::LexedMethod::~LexedMethod()"},
    {"_ZN5clang6Parser11LexedMethodD0Ev", "clang::Parser::LexedMethod::~LexedMethod()"},
    {"_ZN5clang6Parser27LateParsedMethodDeclarationD1Ev", "clang::Parser::LateParsedMethodDeclaration::~LateParsedMethodDeclaration()"},
    {"_ZN5clang6Parser27LateParsedMethodDeclarationD0Ev", "clang::Parser::LateParsedMethodDeclaration::~LateParsedMethodDeclaration()"},
    {"_ZN5clang6Parser13ParseTypeNameEPNS_11SourceRangeENS_10Declarator10TheContextE", "clang::Parser::ParseTypeName(clang::SourceRange*, clang::Declarator::TheContext)"},
    {"_ZN5clang6Parser27ParseSpecifierQualifierListERNS_8DeclSpecE", "clang::Parser::ParseSpecifierQualifierList(clang::DeclSpec&)"},
    {"_ZN5clang6Parser15ParseDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseDeclarator(clang::Declarator&)"},
    {"_ZN5clang6Parser18ParseGNUAttributesERNS_16ParsedAttributesEPNS_14SourceLocationE", "clang::Parser::ParseGNUAttributes(clang::ParsedAttributes&, clang::SourceLocation*)"},
    {"_ZN5clang6Parser22isDeclarationSpecifierEb", "clang::Parser::isDeclarationSpecifier(bool)"},
    {"_ZN5clang6Parser22ParseMicrosoftDeclSpecERNS_16ParsedAttributesE", "clang::Parser::ParseMicrosoftDeclSpec(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser28ParseMicrosoftTypeAttributesERNS_16ParsedAttributesE", "clang::Parser::ParseMicrosoftTypeAttributes(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser26ParseBorlandTypeAttributesERNS_16ParsedAttributesE", "clang::Parser::ParseBorlandTypeAttributes(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser28DiagnoseProhibitedAttributesERNS0_25ParsedAttributesWithRangeE", "clang::Parser::DiagnoseProhibitedAttributes(clang::Parser::ParsedAttributesWithRange&)"},
    {"_ZN5clang6Parser16ParseDeclarationERNS_15ASTOwningVectorIPNS_4StmtELj32EEEjRNS_14SourceLocationERNS0_25ParsedAttributesWithRangeE", "clang::Parser::ParseDeclaration(clang::ASTOwningVector<clang::Stmt*, 32u>&, unsigned int, clang::SourceLocation&, clang::Parser::ParsedAttributesWithRange&)"},
    {"_ZN5clang6Parser22ParseSimpleDeclarationERNS_15ASTOwningVectorIPNS_4StmtELj32EEEjRNS_14SourceLocationERNS_16ParsedAttributesEb", "clang::Parser::ParseSimpleDeclaration(clang::ASTOwningVector<clang::Stmt*, 32u>&, unsigned int, clang::SourceLocation&, clang::ParsedAttributes&, bool)"},
    {"_ZN5clang6Parser26ParseDeclarationSpecifiersERNS_8DeclSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierENS0_15DeclSpecContextE", "clang::Parser::ParseDeclarationSpecifiers(clang::DeclSpec&, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier, clang::Parser::DeclSpecContext)"},
    {"_ZN5clang6Parser39getDeclSpecContextFromDeclaratorContextEj", "clang::Parser::getDeclSpecContextFromDeclaratorContext(unsigned int)"},
    {"_ZN5clang6Parser14ParseDeclGroupERNS0_15ParsingDeclSpecEjbPNS_14SourceLocationE", "clang::Parser::ParseDeclGroup(clang::Parser::ParsingDeclSpec&, unsigned int, bool, clang::SourceLocation*)"},
    {"_ZN5clang6Parser31ParseDeclarationAfterDeclaratorERNS_10DeclaratorERKNS0_18ParsedTemplateInfoE", "clang::Parser::ParseDeclarationAfterDeclarator(clang::Declarator&, clang::Parser::ParsedTemplateInfo const&)"},
    {"_ZN5clang6Parser16ParseImplicitIntERNS_8DeclSpecEPNS_12CXXScopeSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierE", "clang::Parser::ParseImplicitInt(clang::DeclSpec&, clang::CXXScopeSpec*, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser18ParseEnumSpecifierENS_14SourceLocationERNS_8DeclSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierE", "clang::Parser::ParseEnumSpecifier(clang::SourceLocation, clang::DeclSpec&, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser23isConstructorDeclaratorEv", "clang::Parser::isConstructorDeclarator()"},
    {"_ZN5clang6Parser20ParseTypeofSpecifierERNS_8DeclSpecE", "clang::Parser::ParseTypeofSpecifier(clang::DeclSpec&)"},
    {"_ZN5clang6Parser26ParseOptionalTypeSpecifierERNS_8DeclSpecERbRPKcRjRKNS0_18ParsedTemplateInfoEb", "clang::Parser::ParseOptionalTypeSpecifier(clang::DeclSpec&, bool&, char const*&, unsigned int&, clang::Parser::ParsedTemplateInfo const&, bool)"},
    {"_ZN5clang6Parser22ParseStructDeclarationERNS_8DeclSpecERNS0_13FieldCallbackE", "clang::Parser::ParseStructDeclaration(clang::DeclSpec&, clang::Parser::FieldCallback&)"},
    {"_ZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclE", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)"},
    {"_ZZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclEEN14CFieldCallbackD1Ev", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)::CFieldCallback::~CFieldCallback()"},
    {"_ZN5clang6Parser13ParseEnumBodyENS_14SourceLocationEPNS_4DeclE", "clang::Parser::ParseEnumBody(clang::SourceLocation, clang::Decl*)"},
    {"_ZNK5clang6Parser15isTypeQualifierEv", "clang::Parser::isTypeQualifier() const"},
    {"_ZNK5clang6Parser24isKnownToBeTypeSpecifierERKNS_5TokenE", "clang::Parser::isKnownToBeTypeSpecifier(clang::Token const&) const"},
    {"_ZN5clang6Parser24isTypeSpecifierQualifierEv", "clang::Parser::isTypeSpecifierQualifier()"},
    {"_ZN5clang6Parser25ParseTypeQualifierListOptERNS_8DeclSpecEbb", "clang::Parser::ParseTypeQualifierListOpt(clang::DeclSpec&, bool, bool)"},
    {"_ZN5clang6Parser23ParseDeclaratorInternalERNS_10DeclaratorEMS0_FvS2_E", "clang::Parser::ParseDeclaratorInternal(clang::Declarator&, void (clang::Parser::*)(clang::Declarator&))"},
    {"_ZN5clang6Parser21ParseDirectDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseDirectDeclarator(clang::Declarator&)"},
    {"_ZN5clang6Parser20ParseParenDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseParenDeclarator(clang::Declarator&)"},
    {"_ZN5clang6Parser23ParseFunctionDeclaratorENS_14SourceLocationERNS_10DeclaratorERNS_16ParsedAttributesEb", "clang::Parser::ParseFunctionDeclarator(clang::SourceLocation, clang::Declarator&, clang::ParsedAttributes&, bool)"},
    {"_ZN5clang6Parser22ParseBracketDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseBracketDeclarator(clang::Declarator&)"},
    {"_ZN5clang6Parser37ParseFunctionDeclaratorIdentifierListENS_14SourceLocationEPNS_14IdentifierInfoES1_RNS_10DeclaratorE", "clang::Parser::ParseFunctionDeclaratorIdentifierList(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Declarator&)"},
    {"_ZN5clang6Parser30TryAltiVecVectorTokenOutOfLineEv", "clang::Parser::TryAltiVecVectorTokenOutOfLine()"},
    {"_ZN5clang6Parser24TryAltiVecTokenOutOfLineERNS_8DeclSpecENS_14SourceLocationERPKcRjRb", "clang::Parser::TryAltiVecTokenOutOfLine(clang::DeclSpec&, clang::SourceLocation, char const*&, unsigned int&, bool&)"},
    {"_ZZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclEEN14CFieldCallback6invokeERNS_15FieldDeclaratorE", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)::CFieldCallback::invoke(clang::FieldDeclarator&)"},
    {"_ZZN5clang6Parser20ParseStructUnionBodyENS_14SourceLocationEjPNS_4DeclEEN14CFieldCallbackD0Ev", "clang::Parser::ParseStructUnionBody(clang::SourceLocation, unsigned int, clang::Decl*)::CFieldCallback::~CFieldCallback()"},
    {"_ZN4llvm15SmallVectorImplIPN5clang4DeclEE6insertIPS3_EES6_S6_T_S7_", "clang::Decl** llvm::SmallVectorImpl<clang::Decl*>::insert<clang::Decl**>(clang::Decl**, clang::Decl**, clang::Decl**)"},
    {"_ZN5clang6Parser14ParseNamespaceEjRNS_14SourceLocationES1_", "clang::Parser::ParseNamespace(unsigned int, clang::SourceLocation&, clang::SourceLocation)"},
    {"_ZN5clang6Parser19ParseNamespaceAliasENS_14SourceLocationES1_PNS_14IdentifierInfoERS1_", "clang::Parser::ParseNamespaceAlias(clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation&)"},
    {"_ZN5clang6Parser12ParseLinkageERNS0_15ParsingDeclSpecEj", "clang::Parser::ParseLinkage(clang::Parser::ParsingDeclSpec&, unsigned int)"},
    {"_ZN5clang6Parser32ParseUsingDirectiveOrDeclarationEjRKNS0_18ParsedTemplateInfoERNS_14SourceLocationERNS0_25ParsedAttributesWithRangeE", "clang::Parser::ParseUsingDirectiveOrDeclaration(unsigned int, clang::Parser::ParsedTemplateInfo const&, clang::SourceLocation&, clang::Parser::ParsedAttributesWithRange&)"},
    {"_ZN5clang6Parser19ParseUsingDirectiveEjNS_14SourceLocationERS1_RNS_16ParsedAttributesE", "clang::Parser::ParseUsingDirective(unsigned int, clang::SourceLocation, clang::SourceLocation&, clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser21ParseUsingDeclarationEjRKNS0_18ParsedTemplateInfoENS_14SourceLocationERS4_NS_15AccessSpecifierE", "clang::Parser::ParseUsingDeclaration(unsigned int, clang::Parser::ParsedTemplateInfo const&, clang::SourceLocation, clang::SourceLocation&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser28ParseStaticAssertDeclarationERNS_14SourceLocationE", "clang::Parser::ParseStaticAssertDeclaration(clang::SourceLocation&)"},
    {"_ZN5clang6Parser22ParseDecltypeSpecifierERNS_8DeclSpecE", "clang::Parser::ParseDecltypeSpecifier(clang::DeclSpec&)"},
    {"_ZN5clang6Parser14ParseClassNameERNS_14SourceLocationEPNS_12CXXScopeSpecE", "clang::Parser::ParseClassName(clang::SourceLocation&, clang::CXXScopeSpec*)"},
    {"_ZN5clang6Parser19ParseClassSpecifierENS_3tok9TokenKindENS_14SourceLocationERNS_8DeclSpecERKNS0_18ParsedTemplateInfoENS_15AccessSpecifierEb", "clang::Parser::ParseClassSpecifier(clang::tok::TokenKind, clang::SourceLocation, clang::DeclSpec&, clang::Parser::ParsedTemplateInfo const&, clang::AccessSpecifier, bool)"},
    {"_ZNK5clang6Parser25isCXX0XClassVirtSpecifierEv", "clang::Parser::isCXX0XClassVirtSpecifier() const"},
    {"_ZN5clang6Parser27ParseCXXMemberSpecificationENS_14SourceLocationEjPNS_4DeclE", "clang::Parser::ParseCXXMemberSpecification(clang::SourceLocation, unsigned int, clang::Decl*)"},
    {"_ZN5clang6Parser15ParseBaseClauseEPNS_4DeclE", "clang::Parser::ParseBaseClause(clang::Decl*)"},
    {"_ZN5clang6Parser18ParseBaseSpecifierEPNS_4DeclE", "clang::Parser::ParseBaseSpecifier(clang::Decl*)"},
    {"_ZNK5clang6Parser27getAccessSpecifierIfPresentEv", "clang::Parser::getAccessSpecifierIfPresent() const"},
    {"_ZN5clang6Parser31HandleMemberFunctionDefaultArgsERNS_10DeclaratorEPNS_4DeclE", "clang::Parser::HandleMemberFunctionDefaultArgs(clang::Declarator&, clang::Decl*)"},
    {"_ZNK5clang6Parser20isCXX0XVirtSpecifierEv", "clang::Parser::isCXX0XVirtSpecifier() const"},
    {"_ZN5clang6Parser34ParseOptionalCXX0XVirtSpecifierSeqERNS_14VirtSpecifiersE", "clang::Parser::ParseOptionalCXX0XVirtSpecifierSeq(clang::VirtSpecifiers&)"},
    {"_ZN5clang6Parser39ParseOptionalCXX0XClassVirtSpecifierSeqERNS_19ClassVirtSpecifiersE", "clang::Parser::ParseOptionalCXX0XClassVirtSpecifierSeq(clang::ClassVirtSpecifiers&)"},
    {"_ZN5clang6Parser30ParseCXXClassMemberDeclarationENS_15AccessSpecifierERKNS0_18ParsedTemplateInfoEPNS0_21ParsingDeclRAIIObjectE", "clang::Parser::ParseCXXClassMemberDeclaration(clang::AccessSpecifier, clang::Parser::ParsedTemplateInfo const&, clang::Parser::ParsingDeclRAIIObject*)"},
    {"_ZN5clang6Parser27ParseConstructorInitializerEPNS_4DeclE", "clang::Parser::ParseConstructorInitializer(clang::Decl*)"},
    {"_ZN5clang6Parser19ParseMemInitializerEPNS_4DeclE", "clang::Parser::ParseMemInitializer(clang::Decl*)"},
    {"_ZN5clang6Parser27ParseExceptionSpecificationERNS_14SourceLocationERN4llvm15SmallVectorImplINS_9OpaquePtrINS_8QualTypeEEEEERNS4_INS_11SourceRangeEEERb", "clang::Parser::ParseExceptionSpecification(clang::SourceLocation&, llvm::SmallVectorImpl<clang::OpaquePtr<clang::QualType> >&, llvm::SmallVectorImpl<clang::SourceRange>&, bool&)"},
    {"_ZN5clang6Parser23ParseTrailingReturnTypeEv", "clang::Parser::ParseTrailingReturnType()"},
    {"_ZN5clang6Parser16PushParsingClassEPNS_4DeclEb", "clang::Parser::PushParsingClass(clang::Decl*, bool)"},
    {"_ZN5clang6Parser23DeallocateParsedClassesEPNS0_12ParsingClassE", "clang::Parser::DeallocateParsedClasses(clang::Parser::ParsingClass*)"},
    {"_ZN5clang6Parser15PopParsingClassEv", "clang::Parser::PopParsingClass()"},
    {"_ZN5clang6Parser20ParseCXX0XAttributesERNS0_25ParsedAttributesWithRangeEPNS_14SourceLocationE", "clang::Parser::ParseCXX0XAttributes(clang::Parser::ParsedAttributesWithRange&, clang::SourceLocation*)"},
    {"_ZN5clang6Parser23ParseCXX0XAlignArgumentENS_14SourceLocationE", "clang::Parser::ParseCXX0XAlignArgument(clang::SourceLocation)"},
    {"_ZN5clang6Parser24ParseMicrosoftAttributesERNS_16ParsedAttributesEPNS_14SourceLocationE", "clang::Parser::ParseMicrosoftAttributes(clang::ParsedAttributes&, clang::SourceLocation*)"},
    {"_ZNSt5dequeIPN5clang6Parser12ParsingClassESaIS3_EE9push_backERKS3_", "std::deque<clang::Parser::ParsingClass*, std::allocator<clang::Parser::ParsingClass*> >::push_back(clang::Parser::ParsingClass* const&)"},
    {"_ZNSt5dequeIPN5clang6Parser12ParsingClassESaIS3_EE17_M_reallocate_mapEmb", "std::deque<clang::Parser::ParsingClass*, std::allocator<clang::Parser::ParsingClass*> >::_M_reallocate_map(unsigned long, bool)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang6Parser25LateParsedDefaultArgumentELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Parser::LateParsedDefaultArgument, false>::grow(unsigned long)"},
    {"_ZN5clang6Parser15ParseExpressionEv", "clang::Parser::ParseExpression()"},
    {"_ZN5clang6Parser25ParseAssignmentExpressionEv", "clang::Parser::ParseAssignmentExpression()"},
    {"_ZN5clang6Parser26ParseRHSOfBinaryExpressionENS_12ActionResultIPNS_4ExprELb1EEENS_4prec5LevelE", "clang::Parser::ParseRHSOfBinaryExpression(clang::ActionResult<clang::Expr*, true>, clang::prec::Level)"},
    {"_ZN5clang6Parser28ParseExpressionWithLeadingAtENS_14SourceLocationE", "clang::Parser::ParseExpressionWithLeadingAt(clang::SourceLocation)"},
    {"_ZN5clang6Parser35ParseExpressionWithLeadingExtensionENS_14SourceLocationE", "clang::Parser::ParseExpressionWithLeadingExtension(clang::SourceLocation)"},
    {"_ZN5clang6Parser19ParseCastExpressionEbbNS_9OpaquePtrINS_8QualTypeEEE", "clang::Parser::ParseCastExpression(bool, bool, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang6Parser43ParseAssignmentExprWithObjCMessageExprStartENS_14SourceLocationES1_NS_9OpaquePtrINS_8QualTypeEEEPNS_4ExprE", "clang::Parser::ParseAssignmentExprWithObjCMessageExprStart(clang::SourceLocation, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::Expr*)"},
    {"_ZN5clang6Parser28ParsePostfixExpressionSuffixENS_12ActionResultIPNS_4ExprELb1EEE", "clang::Parser::ParsePostfixExpressionSuffix(clang::ActionResult<clang::Expr*, true>)"},
    {"_ZN5clang6Parser23ParseConstantExpressionEv", "clang::Parser::ParseConstantExpression()"},
    {"_ZN5clang6Parser19ParseCastExpressionEbbRbNS_9OpaquePtrINS_8QualTypeEEE", "clang::Parser::ParseCastExpression(bool, bool, bool&, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang6Parser20ParseParenExpressionERNS0_16ParenParseOptionEbNS_9OpaquePtrINS_8QualTypeEEERS5_RNS_14SourceLocationE", "clang::Parser::ParseParenExpression(clang::Parser::ParenParseOption&, bool, clang::OpaquePtr<clang::QualType>, clang::OpaquePtr<clang::QualType>&, clang::SourceLocation&)"},
    {"_ZN5clang6Parser28ParseStringLiteralExpressionEv", "clang::Parser::ParseStringLiteralExpression()"},
    {"_ZN5clang6Parser29ParseBuiltinPrimaryExpressionEv", "clang::Parser::ParseBuiltinPrimaryExpression()"},
    {"_ZN5clang6Parser28ParseSizeofAlignofExpressionEv", "clang::Parser::ParseSizeofAlignofExpression()"},
    {"_ZN5clang6Parser27ParseBlockLiteralExpressionEv", "clang::Parser::ParseBlockLiteralExpression()"},
    {"_ZN5clang6Parser19ParseExpressionListERN4llvm15SmallVectorImplIPNS_4ExprEEERNS2_INS_14SourceLocationEEEMNS_4SemaEFvPNS_5ScopeES4_PS4_jES4_", "clang::Parser::ParseExpressionList(llvm::SmallVectorImpl<clang::Expr*>&, llvm::SmallVectorImpl<clang::SourceLocation>&, void (clang::Sema::*)(clang::Scope*, clang::Expr*, clang::Expr**, unsigned int), clang::Expr*)"},
    {"_ZN5clang6Parser33ParseExprAfterTypeofSizeofAlignofERKNS_5TokenERbRNS_9OpaquePtrINS_8QualTypeEEERNS_11SourceRangeE", "clang::Parser::ParseExprAfterTypeofSizeofAlignof(clang::Token const&, bool&, clang::OpaquePtr<clang::QualType>&, clang::SourceRange&)"},
    {"_ZN5clang6Parser30ParseCompoundLiteralExpressionENS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationES4_", "clang::Parser::ParseCompoundLiteralExpression(clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang6Parser12ParseBlockIdEv", "clang::Parser::ParseBlockId()"},
    {"_ZN5clang6Parser30ParseOptionalCXXScopeSpecifierERNS_12CXXScopeSpecENS_9OpaquePtrINS_8QualTypeEEEbPb", "clang::Parser::ParseOptionalCXXScopeSpecifier(clang::CXXScopeSpec&, clang::OpaquePtr<clang::QualType>, bool, bool*)"},
    {"_ZN5clang6Parser26ParseUnqualifiedIdOperatorERNS_12CXXScopeSpecEbNS_9OpaquePtrINS_8QualTypeEEERNS_13UnqualifiedIdE", "clang::Parser::ParseUnqualifiedIdOperator(clang::CXXScopeSpec&, bool, clang::OpaquePtr<clang::QualType>, clang::UnqualifiedId&)"},
    {"_ZN5clang6Parser20ParseCXXIdExpressionEb", "clang::Parser::ParseCXXIdExpression(bool)"},
    {"_ZN5clang6Parser18ParseUnqualifiedIdERNS_12CXXScopeSpecEbbbNS_9OpaquePtrINS_8QualTypeEEERNS_13UnqualifiedIdE", "clang::Parser::ParseUnqualifiedId(clang::CXXScopeSpec&, bool, bool, bool, clang::OpaquePtr<clang::QualType>, clang::UnqualifiedId&)"},
    {"_ZN5clang6Parser13ParseCXXCastsEv", "clang::Parser::ParseCXXCasts()"},
    {"_ZN5clang6Parser14ParseCXXTypeidEv", "clang::Parser::ParseCXXTypeid()"},
    {"_ZN5clang6Parser14ParseCXXUuidofEv", "clang::Parser::ParseCXXUuidof()"},
    {"_ZN5clang6Parser24ParseCXXPseudoDestructorEPNS_4ExprENS_14SourceLocationENS_3tok9TokenKindERNS_12CXXScopeSpecENS_9OpaquePtrINS_8QualTypeEEE", "clang::Parser::ParseCXXPseudoDestructor(clang::Expr*, clang::SourceLocation, clang::tok::TokenKind, clang::CXXScopeSpec&, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang6Parser28ParseUnqualifiedIdTemplateIdERNS_12CXXScopeSpecEPNS_14IdentifierInfoENS_14SourceLocationEbNS_9OpaquePtrINS_8QualTypeEEERNS_13UnqualifiedIdEbS5_", "clang::Parser::ParseUnqualifiedIdTemplateId(clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::SourceLocation, bool, clang::OpaquePtr<clang::QualType>, clang::UnqualifiedId&, bool, clang::SourceLocation)"},
    {"_ZN5clang6Parser19ParseCXXBoolLiteralEv", "clang::Parser::ParseCXXBoolLiteral()"},
    {"_ZN5clang6Parser20ParseThrowExpressionEv", "clang::Parser::ParseThrowExpression()"},
    {"_ZN5clang6Parser12ParseCXXThisEv", "clang::Parser::ParseCXXThis()"},
    {"_ZN5clang6Parser31ParseCXXTypeConstructExpressionERKNS_8DeclSpecE", "clang::Parser::ParseCXXTypeConstructExpression(clang::DeclSpec const&)"},
    {"_ZN5clang6Parser17ParseCXXConditionERNS_12ActionResultIPNS_4ExprELb1EEERPNS_4DeclENS_14SourceLocationEb", "clang::Parser::ParseCXXCondition(clang::ActionResult<clang::Expr*, true>&, clang::Decl*&, clang::SourceLocation, bool)"},
    {"_ZNK5clang6Parser24isCXXSimpleTypeSpecifierEv", "clang::Parser::isCXXSimpleTypeSpecifier() const"},
    {"_ZN5clang6Parser27ParseCXXSimpleTypeSpecifierERNS_8DeclSpecE", "clang::Parser::ParseCXXSimpleTypeSpecifier(clang::DeclSpec&)"},
    {"_ZN5clang6Parser24ParseCXXTypeSpecifierSeqERNS_8DeclSpecE", "clang::Parser::ParseCXXTypeSpecifierSeq(clang::DeclSpec&)"},
    {"_ZN5clang6Parser21ParseCXXNewExpressionEbNS_14SourceLocationE", "clang::Parser::ParseCXXNewExpression(bool, clang::SourceLocation)"},
    {"_ZN5clang6Parser27ParseExpressionListOrTypeIdERN4llvm15SmallVectorImplIPNS_4ExprEEERNS_10DeclaratorE", "clang::Parser::ParseExpressionListOrTypeId(llvm::SmallVectorImpl<clang::Expr*>&, clang::Declarator&)"},
    {"_ZN5clang6Parser24ParseDirectNewDeclaratorERNS_10DeclaratorE", "clang::Parser::ParseDirectNewDeclarator(clang::Declarator&)"},
    {"_ZN5clang6Parser24ParseCXXDeleteExpressionEbNS_14SourceLocationE", "clang::Parser::ParseCXXDeleteExpression(bool, clang::SourceLocation)"},
    {"_ZN5clang6Parser19ParseUnaryTypeTraitEv", "clang::Parser::ParseUnaryTypeTrait()"},
    {"_ZN5clang6Parser20ParseBinaryTypeTraitEv", "clang::Parser::ParseBinaryTypeTrait()"},
    {"_ZN5clang6Parser32ParseCXXAmbiguousParenExpressionERNS0_16ParenParseOptionERNS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationERS7_", "clang::Parser::ParseCXXAmbiguousParenExpression(clang::Parser::ParenParseOption&, clang::OpaquePtr<clang::QualType>&, clang::SourceLocation, clang::SourceLocation&)"},
    {"_ZN5clang6Parser39ParseInitializerWithPotentialDesignatorEv", "clang::Parser::ParseInitializerWithPotentialDesignator()"},
    {"_ZN5clang6Parser21ParseBraceInitializerEv", "clang::Parser::ParseBraceInitializer()"},
    {"_ZN5clang6Parser21ParseObjCAtDirectivesEv", "clang::Parser::ParseObjCAtDirectives()"},
    {"_ZN5clang6Parser27ParseObjCAtClassDeclarationENS_14SourceLocationE", "clang::Parser::ParseObjCAtClassDeclaration(clang::SourceLocation)"},
    {"_ZN5clang6Parser31ParseObjCAtInterfaceDeclarationENS_14SourceLocationERNS_16ParsedAttributesE", "clang::Parser::ParseObjCAtInterfaceDeclaration(clang::SourceLocation, clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser30ParseObjCAtProtocolDeclarationENS_14SourceLocationERNS_16ParsedAttributesE", "clang::Parser::ParseObjCAtProtocolDeclaration(clang::SourceLocation, clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser36ParseObjCAtImplementationDeclarationENS_14SourceLocationE", "clang::Parser::ParseObjCAtImplementationDeclaration(clang::SourceLocation)"},
    {"_ZN5clang6Parser25ParseObjCAtEndDeclarationENS_11SourceRangeE", "clang::Parser::ParseObjCAtEndDeclaration(clang::SourceRange)"},
    {"_ZN5clang6Parser27ParseObjCAtAliasDeclarationENS_14SourceLocationE", "clang::Parser::ParseObjCAtAliasDeclaration(clang::SourceLocation)"},
    {"_ZN5clang6Parser27ParseObjCPropertySynthesizeENS_14SourceLocationE", "clang::Parser::ParseObjCPropertySynthesize(clang::SourceLocation)"},
    {"_ZN5clang6Parser24ParseObjCPropertyDynamicENS_14SourceLocationE", "clang::Parser::ParseObjCPropertyDynamic(clang::SourceLocation)"},
    {"_ZN5clang6Parser27ParseObjCProtocolReferencesERN4llvm15SmallVectorImplIPNS_4DeclEEERNS2_INS_14SourceLocationEEEbRS7_SA_", "clang::Parser::ParseObjCProtocolReferences(llvm::SmallVectorImpl<clang::Decl*>&, llvm::SmallVectorImpl<clang::SourceLocation>&, bool, clang::SourceLocation&, clang::SourceLocation&)"},
    {"_ZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationE", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)"},
    {"_ZN5clang6Parser26ParseObjCInterfaceDeclListEPNS_4DeclENS_3tok15ObjCKeywordKindE", "clang::Parser::ParseObjCInterfaceDeclList(clang::Decl*, clang::tok::ObjCKeywordKind)"},
    {"_ZN5clang6Parser24ParseObjCMethodPrototypeEPNS_4DeclENS_3tok15ObjCKeywordKindE", "clang::Parser::ParseObjCMethodPrototype(clang::Decl*, clang::tok::ObjCKeywordKind)"},
    {"_ZN5clang6Parser19ParseObjCMethodDeclENS_14SourceLocationENS_3tok9TokenKindEPNS_4DeclENS2_15ObjCKeywordKindE", "clang::Parser::ParseObjCMethodDecl(clang::SourceLocation, clang::tok::TokenKind, clang::Decl*, clang::tok::ObjCKeywordKind)"},
    {"_ZN5clang6Parser26ParseObjCPropertyAttributeERNS_12ObjCDeclSpecEPNS_4DeclE", "clang::Parser::ParseObjCPropertyAttribute(clang::ObjCDeclSpec&, clang::Decl*)"},
    {"_ZN5clang6Parser22ParseObjCSelectorPieceERNS_14SourceLocationE", "clang::Parser::ParseObjCSelectorPiece(clang::SourceLocation&)"},
    {"_ZNK5clang6Parser18isTokIdentifier_inEv", "clang::Parser::isTokIdentifier_in() const"},
    {"_ZN5clang6Parser26ParseObjCTypeQualifierListERNS_12ObjCDeclSpecEb", "clang::Parser::ParseObjCTypeQualifierList(clang::ObjCDeclSpec&, bool)"},
    {"_ZN5clang6Parser17ParseObjCTypeNameERNS_12ObjCDeclSpecEb", "clang::Parser::ParseObjCTypeName(clang::ObjCDeclSpec&, bool)"},
    {"_ZN5clang6Parser27ParseObjCProtocolQualifiersERNS_8DeclSpecE", "clang::Parser::ParseObjCProtocolQualifiers(clang::DeclSpec&)"},
    {"_ZZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationEEN16ObjCIvarCallbackD1Ev", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)::ObjCIvarCallback::~ObjCIvarCallback()"},
    {"_ZN5clang6Parser24FinishPendingObjCActionsEv", "clang::Parser::FinishPendingObjCActions()"},
    {"_ZN5clang6Parser18ParseObjCThrowStmtENS_14SourceLocationE", "clang::Parser::ParseObjCThrowStmt(clang::SourceLocation)"},
    {"_ZN5clang6Parser25ParseObjCSynchronizedStmtENS_14SourceLocationE", "clang::Parser::ParseObjCSynchronizedStmt(clang::SourceLocation)"},
    {"_ZN5clang6Parser16ParseObjCTryStmtENS_14SourceLocationE", "clang::Parser::ParseObjCTryStmt(clang::SourceLocation)"},
    {"_ZN5clang6Parser25ParseObjCMethodDefinitionEv", "clang::Parser::ParseObjCMethodDefinition()"},
    {"_ZN5clang6Parser20ParseObjCAtStatementENS_14SourceLocationE", "clang::Parser::ParseObjCAtStatement(clang::SourceLocation)"},
    {"_ZN5clang6Parser21ParseObjCAtExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCAtExpression(clang::SourceLocation)"},
    {"_ZN5clang6Parser22ParseObjCStringLiteralENS_14SourceLocationE", "clang::Parser::ParseObjCStringLiteral(clang::SourceLocation)"},
    {"_ZN5clang6Parser25ParseObjCEncodeExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCEncodeExpression(clang::SourceLocation)"},
    {"_ZN5clang6Parser27ParseObjCProtocolExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCProtocolExpression(clang::SourceLocation)"},
    {"_ZN5clang6Parser27ParseObjCSelectorExpressionENS_14SourceLocationE", "clang::Parser::ParseObjCSelectorExpression(clang::SourceLocation)"},
    {"_ZN5clang6Parser26ParseObjCXXMessageReceiverERbRPv", "clang::Parser::ParseObjCXXMessageReceiver(bool&, void*&)"},
    {"_ZN5clang6Parser29isSimpleObjCMessageExpressionEv", "clang::Parser::isSimpleObjCMessageExpression()"},
    {"_ZN5clang6Parser43isStartOfObjCClassMessageMissingOpenBracketEv", "clang::Parser::isStartOfObjCClassMessageMissingOpenBracket()"},
    {"_ZN5clang6Parser26ParseObjCMessageExpressionEv", "clang::Parser::ParseObjCMessageExpression()"},
    {"_ZN5clang6Parser30ParseObjCMessageExpressionBodyENS_14SourceLocationES1_NS_9OpaquePtrINS_8QualTypeEEEPNS_4ExprE", "clang::Parser::ParseObjCMessageExpressionBody(clang::SourceLocation, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::Expr*)"},
    {"_ZZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationEEN16ObjCIvarCallback6invokeERNS_15FieldDeclaratorE", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)::ObjCIvarCallback::invoke(clang::FieldDeclarator&)"},
    {"_ZZN5clang6Parser31ParseObjCClassInstanceVariablesEPNS_4DeclENS_3tok15ObjCKeywordKindENS_14SourceLocationEEN16ObjCIvarCallbackD0Ev", "clang::Parser::ParseObjCClassInstanceVariables(clang::Decl*, clang::tok::ObjCKeywordKind, clang::SourceLocation)::ObjCIvarCallback::~ObjCIvarCallback()"},
    {"_ZN5clang6Parser20ObjCPropertyCallbackD1Ev", "clang::Parser::ObjCPropertyCallback::~ObjCPropertyCallback()"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang15DeclaratorChunk9ParamInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::DeclaratorChunk::ParamInfo, false>::grow(unsigned long)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang4Sema11ObjCArgInfoELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Sema::ObjCArgInfo, false>::grow(unsigned long)"},
    {"_ZN5clang6Parser20ObjCPropertyCallback6invokeERNS_15FieldDeclaratorE", "clang::Parser::ObjCPropertyCallback::invoke(clang::FieldDeclarator&)"},
    {"_ZN5clang6Parser20ObjCPropertyCallbackD0Ev", "clang::Parser::ObjCPropertyCallback::~ObjCPropertyCallback()"},
    {"_ZN5clang6Parser18HandlePragmaUnusedEv", "clang::Parser::HandlePragmaUnused()"},
    {"_ZN5clang26PragmaGCCVisibilityHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaGCCVisibilityHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_ZN5clang17PragmaPackHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaPackHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_ZN5clang18PragmaAlignHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaAlignHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_Z16ParseAlignPragmaRN5clang4SemaERNS_12PreprocessorERNS_5TokenEb", "ParseAlignPragma(clang::Sema&, clang::Preprocessor&, clang::Token&, bool)"},
    {"_ZN5clang20PragmaOptionsHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaOptionsHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_ZN5clang19PragmaUnusedHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaUnusedHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_ZN5clang17PragmaWeakHandler12HandlePragmaERNS_12PreprocessorENS_20PragmaIntroducerKindERNS_5TokenE", "clang::PragmaWeakHandler::HandlePragma(clang::Preprocessor&, clang::PragmaIntroducerKind, clang::Token&)"},
    {"_ZN5clang18PragmaAlignHandlerD1Ev", "clang::PragmaAlignHandler::~PragmaAlignHandler()"},
    {"_ZN5clang18PragmaAlignHandlerD0Ev", "clang::PragmaAlignHandler::~PragmaAlignHandler()"},
    {"_ZN5clang26PragmaGCCVisibilityHandlerD1Ev", "clang::PragmaGCCVisibilityHandler::~PragmaGCCVisibilityHandler()"},
    {"_ZN5clang26PragmaGCCVisibilityHandlerD0Ev", "clang::PragmaGCCVisibilityHandler::~PragmaGCCVisibilityHandler()"},
    {"_ZN5clang20PragmaOptionsHandlerD1Ev", "clang::PragmaOptionsHandler::~PragmaOptionsHandler()"},
    {"_ZN5clang20PragmaOptionsHandlerD0Ev", "clang::PragmaOptionsHandler::~PragmaOptionsHandler()"},
    {"_ZN5clang17PragmaPackHandlerD1Ev", "clang::PragmaPackHandler::~PragmaPackHandler()"},
    {"_ZN5clang17PragmaPackHandlerD0Ev", "clang::PragmaPackHandler::~PragmaPackHandler()"},
    {"_ZN5clang19PragmaUnusedHandlerD1Ev", "clang::PragmaUnusedHandler::~PragmaUnusedHandler()"},
    {"_ZN5clang19PragmaUnusedHandlerD0Ev", "clang::PragmaUnusedHandler::~PragmaUnusedHandler()"},
    {"_ZN5clang17PragmaWeakHandlerD1Ev", "clang::PragmaWeakHandler::~PragmaWeakHandler()"},
    {"_ZN5clang17PragmaWeakHandlerD0Ev", "clang::PragmaWeakHandler::~PragmaWeakHandler()"},
    {"_ZN5clang6Parser27ParseStatementOrDeclarationERNS_15ASTOwningVectorIPNS_4StmtELj32EEEb", "clang::Parser::ParseStatementOrDeclaration(clang::ASTOwningVector<clang::Stmt*, 32u>&, bool)"},
    {"_ZN5clang6Parser21ParseLabeledStatementERNS_16ParsedAttributesE", "clang::Parser::ParseLabeledStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser18ParseCaseStatementERNS_16ParsedAttributesE", "clang::Parser::ParseCaseStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser21ParseDefaultStatementERNS_16ParsedAttributesE", "clang::Parser::ParseDefaultStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser22ParseCompoundStatementERNS_16ParsedAttributesEb", "clang::Parser::ParseCompoundStatement(clang::ParsedAttributes&, bool)"},
    {"_ZN5clang6Parser16ParseIfStatementERNS_16ParsedAttributesE", "clang::Parser::ParseIfStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser20ParseSwitchStatementERNS_16ParsedAttributesE", "clang::Parser::ParseSwitchStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser19ParseWhileStatementERNS_16ParsedAttributesE", "clang::Parser::ParseWhileStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser16ParseDoStatementERNS_16ParsedAttributesE", "clang::Parser::ParseDoStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser17ParseForStatementERNS_16ParsedAttributesE", "clang::Parser::ParseForStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser18ParseGotoStatementERNS_16ParsedAttributesE", "clang::Parser::ParseGotoStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser22ParseContinueStatementERNS_16ParsedAttributesE", "clang::Parser::ParseContinueStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser19ParseBreakStatementERNS_16ParsedAttributesE", "clang::Parser::ParseBreakStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser20ParseReturnStatementERNS_16ParsedAttributesE", "clang::Parser::ParseReturnStatement(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser17ParseAsmStatementERb", "clang::Parser::ParseAsmStatement(bool&)"},
    {"_ZN5clang6Parser16ParseCXXTryBlockERNS_16ParsedAttributesE", "clang::Parser::ParseCXXTryBlock(clang::ParsedAttributes&)"},
    {"_ZN5clang6Parser26ParseCompoundStatementBodyEb", "clang::Parser::ParseCompoundStatementBody(bool)"},
    {"_ZN5clang6Parser25ParseParenExprOrConditionERNS_12ActionResultIPNS_4ExprELb1EEERPNS_4DeclENS_14SourceLocationEb", "clang::Parser::ParseParenExprOrCondition(clang::ActionResult<clang::Expr*, true>&, clang::Decl*&, clang::SourceLocation, bool)"},
    {"_ZN5clang6Parser31FuzzyParseMicrosoftAsmStatementENS_14SourceLocationE", "clang::Parser::FuzzyParseMicrosoftAsmStatement(clang::SourceLocation)"},
    {"_ZN5clang6Parser19ParseAsmOperandsOptERN4llvm15SmallVectorImplIPNS_14IdentifierInfoEEERNS2_IPNS_4ExprEEESA_", "clang::Parser::ParseAsmOperandsOpt(llvm::SmallVectorImpl<clang::IdentifierInfo*>&, llvm::SmallVectorImpl<clang::Expr*>&, llvm::SmallVectorImpl<clang::Expr*>&)"},
    {"_ZN5clang6Parser26ParseFunctionStatementBodyEPNS_4DeclE", "clang::Parser::ParseFunctionStatementBody(clang::Decl*)"},
    {"_ZN5clang6Parser40trySkippingFunctionBodyForCodeCompletionEv", "clang::Parser::trySkippingFunctionBodyForCodeCompletion()"},
    {"_ZN5clang6Parser21ParseFunctionTryBlockEPNS_4DeclE", "clang::Parser::ParseFunctionTryBlock(clang::Decl*)"},
    {"_ZN5clang6Parser22ParseCXXTryBlockCommonENS_14SourceLocationE", "clang::Parser::ParseCXXTryBlockCommon(clang::SourceLocation)"},
    {"_ZN5clang6Parser18ParseCXXCatchBlockEv", "clang::Parser::ParseCXXCatchBlock()"},
    {"_ZN5clang6Parser36ParseDeclarationStartingWithTemplateEjRNS_14SourceLocationENS_15AccessSpecifierE", "clang::Parser::ParseDeclarationStartingWithTemplate(unsigned int, clang::SourceLocation&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser26ParseExplicitInstantiationENS_14SourceLocationES1_RS1_", "clang::Parser::ParseExplicitInstantiation(clang::SourceLocation, clang::SourceLocation, clang::SourceLocation&)"},
    {"_ZN5clang6Parser40ParseTemplateDeclarationOrSpecializationEjRNS_14SourceLocationENS_15AccessSpecifierE", "clang::Parser::ParseTemplateDeclarationOrSpecialization(unsigned int, clang::SourceLocation&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser23ParseTemplateParametersEjRN4llvm15SmallVectorImplIPNS_4DeclEEERNS_14SourceLocationES8_", "clang::Parser::ParseTemplateParameters(unsigned int, llvm::SmallVectorImpl<clang::Decl*>&, clang::SourceLocation&, clang::SourceLocation&)"},
    {"_ZN5clang6Parser35ParseSingleDeclarationAfterTemplateEjRKNS0_18ParsedTemplateInfoERNS0_21ParsingDeclRAIIObjectERNS_14SourceLocationENS_15AccessSpecifierE", "clang::Parser::ParseSingleDeclarationAfterTemplate(unsigned int, clang::Parser::ParsedTemplateInfo const&, clang::Parser::ParsingDeclRAIIObject&, clang::SourceLocation&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser26ParseTemplateParameterListEjRN4llvm15SmallVectorImplIPNS_4DeclEEE", "clang::Parser::ParseTemplateParameterList(unsigned int, llvm::SmallVectorImpl<clang::Decl*>&)"},
    {"_ZN5clang6Parser22ParseTemplateParameterEjj", "clang::Parser::ParseTemplateParameter(unsigned int, unsigned int)"},
    {"_ZN5clang6Parser30isStartOfTemplateTypeParameterEv", "clang::Parser::isStartOfTemplateTypeParameter()"},
    {"_ZN5clang6Parser18ParseTypeParameterEjj", "clang::Parser::ParseTypeParameter(unsigned int, unsigned int)"},
    {"_ZN5clang6Parser30ParseTemplateTemplateParameterEjj", "clang::Parser::ParseTemplateTemplateParameter(unsigned int, unsigned int)"},
    {"_ZN5clang6Parser29ParseNonTypeTemplateParameterEjj", "clang::Parser::ParseNonTypeTemplateParameter(unsigned int, unsigned int)"},
    {"_ZN5clang6Parser29ParseTemplateTemplateArgumentEv", "clang::Parser::ParseTemplateTemplateArgument()"},
    {"_ZN5clang6Parser32ParseTemplateIdAfterTemplateNameENS_9OpaquePtrINS_12TemplateNameEEENS_14SourceLocationEPKNS_12CXXScopeSpecEbRS4_RN4llvm11SmallVectorINS_22ParsedTemplateArgumentELj16EEES8_", "clang::Parser::ParseTemplateIdAfterTemplateName(clang::OpaquePtr<clang::TemplateName>, clang::SourceLocation, clang::CXXScopeSpec const*, bool, clang::SourceLocation&, llvm::SmallVector<clang::ParsedTemplateArgument, 16u>&, clang::SourceLocation&)"},
    {"_ZN5clang6Parser25ParseTemplateArgumentListERN4llvm11SmallVectorINS_22ParsedTemplateArgumentELj16EEE", "clang::Parser::ParseTemplateArgumentList(llvm::SmallVector<clang::ParsedTemplateArgument, 16u>&)"},
    {"_ZN5clang6Parser23AnnotateTemplateIdTokenENS_9OpaquePtrINS_12TemplateNameEEENS_16TemplateNameKindEPKNS_12CXXScopeSpecERNS_13UnqualifiedIdENS_14SourceLocationEb", "clang::Parser::AnnotateTemplateIdToken(clang::OpaquePtr<clang::TemplateName>, clang::TemplateNameKind, clang::CXXScopeSpec const*, clang::UnqualifiedId&, clang::SourceLocation, bool)"},
    {"_ZN5clang6Parser29AnnotateTemplateIdTokenAsTypeEPKNS_12CXXScopeSpecE", "clang::Parser::AnnotateTemplateIdTokenAsType(clang::CXXScopeSpec const*)"},
    {"_ZN5clang6Parser21ParseTemplateArgumentEv", "clang::Parser::ParseTemplateArgument()"},
    {"_ZN5clang6Parser22IsTemplateArgumentListEj", "clang::Parser::IsTemplateArgumentList(unsigned int)"},
    {"_ZNK5clang6Parser18ParsedTemplateInfo14getSourceRangeEv", "clang::Parser::ParsedTemplateInfo::getSourceRange() const"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang22ParsedTemplateArgumentELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ParsedTemplateArgument, false>::grow(unsigned long)"},
    {"_ZN5clang6Parser25isCXXDeclarationStatementEv", "clang::Parser::isCXXDeclarationStatement()"},
    {"_ZN5clang6Parser22isCXXSimpleDeclarationEv", "clang::Parser::isCXXSimpleDeclaration()"},
    {"_ZN5clang6Parser25isCXXDeclarationSpecifierEv", "clang::Parser::isCXXDeclarationSpecifier()"},
    {"_ZN5clang6Parser25TryParseSimpleDeclarationEv", "clang::Parser::TryParseSimpleDeclaration()"},
    {"_ZN5clang6Parser23TryParseTypeofSpecifierEv", "clang::Parser::TryParseTypeofSpecifier()"},
    {"_ZN5clang6Parser26TryParseProtocolQualifiersEv", "clang::Parser::TryParseProtocolQualifiers()"},
    {"_ZN5clang6Parser26TryParseInitDeclaratorListEv", "clang::Parser::TryParseInitDeclaratorList()"},
    {"_ZN5clang6Parser18TryParseDeclaratorEbb", "clang::Parser::TryParseDeclarator(bool, bool)"},
    {"_ZN5clang6Parser25isCXXConditionDeclarationEv", "clang::Parser::isCXXConditionDeclaration()"},
    {"_ZN5clang6Parser11isCXXTypeIdENS0_25TentativeCXXTypeIdContextERb", "clang::Parser::isCXXTypeId(clang::Parser::TentativeCXXTypeIdContext, bool&)"},
    {"_ZN5clang6Parser25isCXX0XAttributeSpecifierEbPNS_3tok9TokenKindE", "clang::Parser::isCXX0XAttributeSpecifier(bool, clang::tok::TokenKind*)"},
    {"_ZN5clang6Parser26TryParseFunctionDeclaratorEv", "clang::Parser::TryParseFunctionDeclarator()"},
    {"_ZN5clang6Parser23isCXXFunctionDeclaratorEb", "clang::Parser::isCXXFunctionDeclarator(bool)"},
    {"_ZN5clang6Parser25TryParseBracketDeclaratorEv", "clang::Parser::TryParseBracketDeclarator()"},
    {"_ZN5clang6Parser33isExpressionOrTypeSpecifierSimpleENS_3tok9TokenKindE", "clang::Parser::isExpressionOrTypeSpecifierSimple(clang::tok::TokenKind)"},
    {"_ZN5clang6Parser28TryParseDeclarationSpecifierEv", "clang::Parser::TryParseDeclarationSpecifier()"},
    {"_ZN5clang6Parser34TryParseParameterDeclarationClauseEv", "clang::Parser::TryParseParameterDeclarationClause()"},
    {"_ZN5clang6ParserC1ERNS_12PreprocessorERNS_4SemaE", "clang::Parser::Parser(clang::Preprocessor&, clang::Sema&)"},
    {"_ZN5clang6ParserC2ERNS_12PreprocessorERNS_4SemaE", "clang::Parser::Parser(clang::Preprocessor&, clang::Sema&)"},
    {"_ZNK5clang27PrettyStackTraceParserEntry5printERN4llvm11raw_ostreamE", "clang::PrettyStackTraceParserEntry::print(llvm::raw_ostream&) const"},
    {"_ZN5clang6Parser4DiagENS_14SourceLocationEj", "clang::Parser::Diag(clang::SourceLocation, unsigned int)"},
    {"_ZN5clang6Parser4DiagERKNS_5TokenEj", "clang::Parser::Diag(clang::Token const&, unsigned int)"},
    {"_ZN5clang6Parser18SuggestParenthesesENS_14SourceLocationEjNS_11SourceRangeE", "clang::Parser::SuggestParentheses(clang::SourceLocation, unsigned int, clang::SourceRange)"},
    {"_ZN5clang6Parser19MatchRHSPunctuationENS_3tok9TokenKindENS_14SourceLocationE", "clang::Parser::MatchRHSPunctuation(clang::tok::TokenKind, clang::SourceLocation)"},
    {"_ZN5clang6Parser16ExpectAndConsumeENS_3tok9TokenKindEjPKcS2_", "clang::Parser::ExpectAndConsume(clang::tok::TokenKind, unsigned int, char const*, clang::tok::TokenKind)"},
    {"_ZN5clang6Parser20ExpectAndConsumeSemiEj", "clang::Parser::ExpectAndConsumeSemi(unsigned int)"},
    {"_ZN5clang6Parser9SkipUntilEPKNS_3tok9TokenKindEjbbb", "clang::Parser::SkipUntil(clang::tok::TokenKind const*, unsigned int, bool, bool, bool)"},
    {"_ZN5clang6Parser10EnterScopeEj", "clang::Parser::EnterScope(unsigned int)"},
    {"_ZN5clang6Parser9ExitScopeEv", "clang::Parser::ExitScope()"},
    {"_ZN5clang6ParserD0Ev", "clang::Parser::~Parser()"},
    {"_ZN5clang6ParserD1Ev", "clang::Parser::~Parser()"},
    {"_ZN5clang6ParserD2Ev", "clang::Parser::~Parser()"},
    {"_ZN5clang6Parser10InitializeEv", "clang::Parser::Initialize()"},
    {"_ZN5clang6Parser17ParseTopLevelDeclERNS_9OpaquePtrINS_12DeclGroupRefEEE", "clang::Parser::ParseTopLevelDecl(clang::OpaquePtr<clang::DeclGroupRef>&)"},
    {"_ZN5clang6Parser24ParseExternalDeclarationERNS0_25ParsedAttributesWithRangeEPNS0_15ParsingDeclSpecE", "clang::Parser::ParseExternalDeclaration(clang::Parser::ParsedAttributesWithRange&, clang::Parser::ParsingDeclSpec*)"},
    {"_ZN5clang6Parser20ParseTranslationUnitEv", "clang::Parser::ParseTranslationUnit()"},
    {"_ZN5clang6Parser14ParseSimpleAsmEPNS_14SourceLocationE", "clang::Parser::ParseSimpleAsm(clang::SourceLocation*)"},
    {"_ZN5clang6Parser36ParseDeclarationOrFunctionDefinitionERNS0_15ParsingDeclSpecENS_15AccessSpecifierE", "clang::Parser::ParseDeclarationOrFunctionDefinition(clang::Parser::ParsingDeclSpec&, clang::AccessSpecifier)"},
    {"_ZN5clang6Parser36ParseDeclarationOrFunctionDefinitionERNS_16ParsedAttributesENS_15AccessSpecifierE", "clang::Parser::ParseDeclarationOrFunctionDefinition(clang::ParsedAttributes&, clang::AccessSpecifier)"},
    {"_ZNK5clang6Parser28isDeclarationAfterDeclaratorEv", "clang::Parser::isDeclarationAfterDeclarator() const"},
    {"_ZN5clang6Parser27isStartOfFunctionDefinitionERKNS0_17ParsingDeclaratorE", "clang::Parser::isStartOfFunctionDefinition(clang::Parser::ParsingDeclarator const&)"},
    {"_ZN5clang6Parser23ParseFunctionDefinitionERNS0_17ParsingDeclaratorERKNS0_18ParsedTemplateInfoE", "clang::Parser::ParseFunctionDefinition(clang::Parser::ParsingDeclarator&, clang::Parser::ParsedTemplateInfo const&)"},
    {"_ZN5clang6Parser25ParseKNRParamDeclarationsERNS_10DeclaratorE", "clang::Parser::ParseKNRParamDeclarations(clang::Declarator&)"},
    {"_ZN5clang6Parser21ParseAsmStringLiteralEv", "clang::Parser::ParseAsmStringLiteral()"},
    {"_ZN5clang6Parser27TryAnnotateTypeOrScopeTokenEb", "clang::Parser::TryAnnotateTypeOrScopeToken(bool)"},
    {"_ZN5clang6Parser24TryAnnotateCXXScopeTokenEb", "clang::Parser::TryAnnotateCXXScopeToken(bool)"},
    {"_ZN5clang6Parser32isTokenEqualOrMistypedEqualEqualEj", "clang::Parser::isTokenEqualOrMistypedEqualEqual(unsigned int)"},
    {"_ZN5clang6Parser22CodeCompletionRecoveryEv", "clang::Parser::CodeCompletionRecovery()"},
    {"_ZN5clang6Parser13FieldCallback7_anchorEv", "clang::Parser::FieldCallback::_anchor()"},
    {"_ZN5clang6Parser21CodeCompleteDirectiveEb", "clang::Parser::CodeCompleteDirective(bool)"},
    {"_ZN5clang6Parser34CodeCompleteInConditionalExclusionEv", "clang::Parser::CodeCompleteInConditionalExclusion()"},
    {"_ZN5clang6Parser21CodeCompleteMacroNameEb", "clang::Parser::CodeCompleteMacroName(bool)"},
    {"_ZN5clang6Parser34CodeCompletePreprocessorExpressionEv", "clang::Parser::CodeCompletePreprocessorExpression()"},
    {"_ZN5clang6Parser25CodeCompleteMacroArgumentEPNS_14IdentifierInfoEPNS_9MacroInfoEj", "clang::Parser::CodeCompleteMacroArgument(clang::IdentifierInfo*, clang::MacroInfo*, unsigned int)"},
    {"_ZN5clang6Parser27CodeCompleteNaturalLanguageEv", "clang::Parser::CodeCompleteNaturalLanguage()"},
    {"_ZN5clang6Parser15ConsumeAnyTokenEv", "clang::Parser::ConsumeAnyToken()"},
    {"_ZN5clang5Scope4InitEPS0_j", "clang::Scope::Init(clang::Scope*, unsigned int)"},
    {"_ZN5clang27PrettyStackTraceParserEntryD1Ev", "clang::PrettyStackTraceParserEntry::~PrettyStackTraceParserEntry()"},
    {"_ZN5clang27PrettyStackTraceParserEntryD0Ev", "clang::PrettyStackTraceParserEntry::~PrettyStackTraceParserEntry()"},
    {"_ZN5clang6Parser13FieldCallbackD1Ev", "clang::Parser::FieldCallback::~FieldCallback()"},
    {"_ZN5clang6Parser13FieldCallbackD0Ev", "clang::Parser::FieldCallback::~FieldCallback()"},
    {"_ZNSt11_Deque_baseIPN5clang6Parser12ParsingClassESaIS3_EE17_M_initialize_mapEm", "std::_Deque_base<clang::Parser::ParsingClass*, std::allocator<clang::Parser::ParsingClass*> >::_M_initialize_map(unsigned long)"},
    {"_ZNSt5dequeIPN5clang6Parser12ParsingClassESaIS3_EEC2ERKS5_", "std::deque<clang::Parser::ParsingClass*, std::allocator<clang::Parser::ParsingClass*> >::deque(std::deque<clang::Parser::ParsingClass*, std::allocator<clang::Parser::ParsingClass*> > const&)"},
    {"_ZN4llvm15SmallVectorImplIN5clang5TokenEE6insertEPS2_RKS2_", "llvm::SmallVectorImpl<clang::Token>::insert(clang::Token*, clang::Token const&)"},
    {"_ZN5clang4sema21AnalysisBasedWarnings6PolicyC1Ev", "clang::sema::AnalysisBasedWarnings::Policy::Policy()"},
    {"_ZN5clang4sema21AnalysisBasedWarnings6PolicyC2Ev", "clang::sema::AnalysisBasedWarnings::Policy::Policy()"},
    {"_ZN5clang4sema21AnalysisBasedWarningsC1ERNS_4SemaE", "clang::sema::AnalysisBasedWarnings::AnalysisBasedWarnings(clang::Sema&)"},
    {"_ZN5clang4sema21AnalysisBasedWarningsC2ERNS_4SemaE", "clang::sema::AnalysisBasedWarnings::AnalysisBasedWarnings(clang::Sema&)"},
    {"_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_4DeclENS_8QualTypeE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::Decl const*, clang::QualType)"},
    {"_ZN12_GLOBAL__N_122UninitValsDiagReporterD1Ev", "(anonymous namespace)::UninitValsDiagReporter::~UninitValsDiagReporter()"},
    {"_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_9BlockExprE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::BlockExpr const*)"},
    {"_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_14ObjCMethodDeclE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::ObjCMethodDecl const*)"},
    {"_ZN5clang4sema21AnalysisBasedWarnings13IssueWarningsENS1_6PolicyEPKNS_12FunctionDeclE", "clang::sema::AnalysisBasedWarnings::IssueWarnings(clang::sema::AnalysisBasedWarnings::Policy, clang::FunctionDecl const*)"},
    {"_ZN12_GLOBAL__N_122UninitValsDiagReporterD0Ev", "(anonymous namespace)::UninitValsDiagReporter::~UninitValsDiagReporter()"},
    {"_ZN12_GLOBAL__N_122UninitValsDiagReporter25handleUseOfUninitVariableEPKN5clang4ExprEPKNS1_7VarDeclE", "(anonymous namespace)::UninitValsDiagReporter::handleUseOfUninitVariable(clang::Expr const*, clang::VarDecl const*)"},
    {"_ZSt16__introsort_loopIPPKN5clang4ExprElN12_GLOBAL__N_18SLocSortEEvT_S7_T0_T1_", "void std::__introsort_loop<clang::Expr const**, long, (anonymous namespace)::SLocSort>(clang::Expr const**, clang::Expr const**, long, (anonymous namespace)::SLocSort)"},
    {"_ZSt16__insertion_sortIPPKN5clang4ExprEN12_GLOBAL__N_18SLocSortEEvT_S7_T0_", "void std::__insertion_sort<clang::Expr const**, (anonymous namespace)::SLocSort>(clang::Expr const**, clang::Expr const**, (anonymous namespace)::SLocSort)"},
    {"_ZSt25__unguarded_linear_insertIPPKN5clang4ExprES3_N12_GLOBAL__N_18SLocSortEEvT_T0_T1_", "void std::__unguarded_linear_insert<clang::Expr const**, clang::Expr const*, (anonymous namespace)::SLocSort>(clang::Expr const**, clang::Expr const*, (anonymous namespace)::SLocSort)"},
    {"_ZSt13__adjust_heapIPPKN5clang4ExprElS3_N12_GLOBAL__N_18SLocSortEEvT_T0_S8_T1_T2_", "void std::__adjust_heap<clang::Expr const**, long, clang::Expr const*, (anonymous namespace)::SLocSort>(clang::Expr const**, long, long, clang::Expr const*, (anonymous namespace)::SLocSort)"},
    {"_ZN12_GLOBAL__N_122UnreachableCodeHandlerD1Ev", "(anonymous namespace)::UnreachableCodeHandler::~UnreachableCodeHandler()"},
    {"_ZN12_GLOBAL__N_122UnreachableCodeHandlerD0Ev", "(anonymous namespace)::UnreachableCodeHandler::~UnreachableCodeHandler()"},
    {"_ZN12_GLOBAL__N_122UnreachableCodeHandler17HandleUnreachableEN5clang14SourceLocationENS1_11SourceRangeES3_", "(anonymous namespace)::UnreachableCodeHandler::HandleUnreachable(clang::SourceLocation, clang::SourceRange, clang::SourceRange)"},
    {"_ZN4llvm8DenseMapIPKN5clang7VarDeclEPNS_11SmallVectorIPKNS1_4ExprELj2EEENS_12DenseMapInfoIS4_EENSB_ISA_EEE16InsertIntoBucketERKS4_RKSA_PSt4pairIS4_SA_E", "llvm::DenseMap<clang::VarDecl const*, llvm::SmallVector<clang::Expr const*, 2u>*, llvm::DenseMapInfo<clang::VarDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::Expr const*, 2u>*> >::InsertIntoBucket(clang::VarDecl const* const&, llvm::SmallVector<clang::Expr const*, 2u>* const&, std::pair<clang::VarDecl const*, llvm::SmallVector<clang::Expr const*, 2u>*>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang7VarDeclEPNS_11SmallVectorIPKNS1_4ExprELj2EEENS_12DenseMapInfoIS4_EENSB_ISA_EEE4growEj", "llvm::DenseMap<clang::VarDecl const*, llvm::SmallVector<clang::Expr const*, 2u>*, llvm::DenseMapInfo<clang::VarDecl const*>, llvm::DenseMapInfo<llvm::SmallVector<clang::Expr const*, 2u>*> >::grow(unsigned int)"},
    {"_ZN5clang22UninitVariablesHandler25handleUseOfUninitVariableEPKNS_4ExprEPKNS_7VarDeclE", "clang::UninitVariablesHandler::handleUseOfUninitVariable(clang::Expr const*, clang::VarDecl const*)"},
    {"_ZN5clang14reachable_code8CallbackD1Ev", "clang::reachable_code::Callback::~Callback()"},
    {"_ZN5clang14reachable_code8CallbackD0Ev", "clang::reachable_code::Callback::~Callback()"},
    {"_ZSt6__findIPKPN5clang8CFGBlockES2_ET_S5_S5_RKT0_St26random_access_iterator_tag", "clang::CFGBlock* const* std::__find<clang::CFGBlock* const*, clang::CFGBlock*>(clang::CFGBlock* const*, clang::CFGBlock* const*, clang::CFGBlock* const&, std::random_access_iterator_tag)"},
    {"_ZN5clang13AttributeListC1ERN4llvm16BumpPtrAllocatorEPNS_14IdentifierInfoENS_14SourceLocationES5_S6_S5_S6_PPNS_4ExprEjbb", "clang::AttributeList::AttributeList(llvm::BumpPtrAllocator&, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Expr**, unsigned int, bool, bool)"},
    {"_ZN5clang13AttributeListC2ERN4llvm16BumpPtrAllocatorEPNS_14IdentifierInfoENS_14SourceLocationES5_S6_S5_S6_PPNS_4ExprEjbb", "clang::AttributeList::AttributeList(llvm::BumpPtrAllocator&, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Expr**, unsigned int, bool, bool)"},
    {"_ZN5clang13AttributeList7getKindEPKNS_14IdentifierInfoE", "clang::AttributeList::getKind(clang::IdentifierInfo const*)"},
    {"_ZNK5clang21CodeCompletionContext22wantConstructorResultsEv", "clang::CodeCompletionContext::wantConstructorResults() const"},
    {"_ZN5clang20CodeCompletionString5ChunkC1ENS0_9ChunkKindEPKc", "clang::CodeCompletionString::Chunk::Chunk(clang::CodeCompletionString::ChunkKind, char const*)"},
    {"_ZN5clang20CodeCompletionString5ChunkC2ENS0_9ChunkKindEPKc", "clang::CodeCompletionString::Chunk::Chunk(clang::CodeCompletionString::ChunkKind, char const*)"},
    {"_ZN5clang20CodeCompletionString5Chunk10CreateTextEPKc", "clang::CodeCompletionString::Chunk::CreateText(char const*)"},
    {"_ZN5clang20CodeCompletionString5Chunk14CreateOptionalEPS0_", "clang::CodeCompletionString::Chunk::CreateOptional(clang::CodeCompletionString*)"},
    {"_ZN5clang20CodeCompletionString5Chunk17CreatePlaceholderEPKc", "clang::CodeCompletionString::Chunk::CreatePlaceholder(char const*)"},
    {"_ZN5clang20CodeCompletionString5Chunk17CreateInformativeEPKc", "clang::CodeCompletionString::Chunk::CreateInformative(char const*)"},
    {"_ZN5clang20CodeCompletionString5Chunk16CreateResultTypeEPKc", "clang::CodeCompletionString::Chunk::CreateResultType(char const*)"},
    {"_ZN5clang20CodeCompletionString5Chunk22CreateCurrentParameterEPKc", "clang::CodeCompletionString::Chunk::CreateCurrentParameter(char const*)"},
    {"_ZN5clang20CodeCompletionStringC1EPKNS0_5ChunkEjj18CXAvailabilityKind", "clang::CodeCompletionString::CodeCompletionString(clang::CodeCompletionString::Chunk const*, unsigned int, unsigned int, CXAvailabilityKind)"},
    {"_ZN5clang20CodeCompletionStringC2EPKNS0_5ChunkEjj18CXAvailabilityKind", "clang::CodeCompletionString::CodeCompletionString(clang::CodeCompletionString::Chunk const*, unsigned int, unsigned int, CXAvailabilityKind)"},
    {"_ZNK5clang20CodeCompletionString11getAsStringEv", "clang::CodeCompletionString::getAsString() const"},
    {"_ZNK5clang20CodeCompletionString12getTypedTextEv", "clang::CodeCompletionString::getTypedText() const"},
    {"_ZN5clang23CodeCompletionAllocator10CopyStringEN4llvm9StringRefE", "clang::CodeCompletionAllocator::CopyString(llvm::StringRef)"},
    {"_ZN5clang21CodeCompletionBuilder10TakeStringEv", "clang::CodeCompletionBuilder::TakeString()"},
    {"_ZN5clang20CodeCompletionResult19getPriorityFromDeclEPNS_9NamedDeclE", "clang::CodeCompletionResult::getPriorityFromDecl(clang::NamedDecl*)"},
    {"_ZNK5clang20CodeCompleteConsumer17OverloadCandidate11getFunctionEv", "clang::CodeCompleteConsumer::OverloadCandidate::getFunction() const"},
    {"_ZNK5clang20CodeCompleteConsumer17OverloadCandidate15getFunctionTypeEv", "clang::CodeCompleteConsumer::OverloadCandidate::getFunctionType() const"},
    {"_ZN5clang20CodeCompleteConsumerD0Ev", "clang::CodeCompleteConsumer::~CodeCompleteConsumer()"},
    {"_ZN5clang20CodeCompleteConsumerD1Ev", "clang::CodeCompleteConsumer::~CodeCompleteConsumer()"},
    {"_ZN5clang20CodeCompleteConsumerD2Ev", "clang::CodeCompleteConsumer::~CodeCompleteConsumer()"},
    {"_ZN5clang28PrintingCodeCompleteConsumer26ProcessCodeCompleteResultsERNS_4SemaENS_21CodeCompletionContextEPNS_20CodeCompletionResultEj", "clang::PrintingCodeCompleteConsumer::ProcessCodeCompleteResults(clang::Sema&, clang::CodeCompletionContext, clang::CodeCompletionResult*, unsigned int)"},
    {"_ZN5clang28PrintingCodeCompleteConsumer25ProcessOverloadCandidatesERNS_4SemaEjPNS_20CodeCompleteConsumer17OverloadCandidateEj", "clang::PrintingCodeCompleteConsumer::ProcessOverloadCandidates(clang::Sema&, unsigned int, clang::CodeCompleteConsumer::OverloadCandidate*, unsigned int)"},
    {"_ZN5clang20CodeCompletionResult32computeCursorKindAndAvailabilityEv", "clang::CodeCompletionResult::computeCursorKindAndAvailability()"},
    {"_ZN5clangltERKNS_20CodeCompletionResultES2_", "clang::operator<(clang::CodeCompletionResult const&, clang::CodeCompletionResult const&)"},
    {"_Z14getOrderedNameRKN5clang20CodeCompletionResultERSs", "getOrderedName(clang::CodeCompletionResult const&, std::string&)"},
    {"_ZNK5clang4Decl7getAttrINS_15UnavailableAttrEEEPT_v", "clang::UnavailableAttr* clang::Decl::getAttr<clang::UnavailableAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_14DeprecatedAttrEEEPT_v", "clang::DeprecatedAttr* clang::Decl::getAttr<clang::DeprecatedAttr>() const"},
    {"_ZN5clang28PrintingCodeCompleteConsumerD1Ev", "clang::PrintingCodeCompleteConsumer::~PrintingCodeCompleteConsumer()"},
    {"_ZN5clang28PrintingCodeCompleteConsumerD0Ev", "clang::PrintingCodeCompleteConsumer::~PrintingCodeCompleteConsumer()"},
    {"_ZSt21__inplace_stable_sortIPN5clang20CodeCompletionResultEEvT_S3_", "void std::__inplace_stable_sort<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*)"},
    {"_ZSt22__stable_sort_adaptiveIPN5clang20CodeCompletionResultES2_lEvT_S3_T0_T1_", "void std::__stable_sort_adaptive<clang::CodeCompletionResult*, clang::CodeCompletionResult*, long>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long)"},
    {"_ZSt24__merge_sort_with_bufferIPN5clang20CodeCompletionResultES2_EvT_S3_T0_", "void std::__merge_sort_with_buffer<clang::CodeCompletionResult*, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"},
    {"_ZSt16__merge_adaptiveIPN5clang20CodeCompletionResultElS2_EvT_S3_S3_T0_S4_T1_S4_", "void std::__merge_adaptive<clang::CodeCompletionResult*, long, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long, long, clang::CodeCompletionResult*, long)"},
    {"_ZSt5mergeIPN5clang20CodeCompletionResultES2_S2_ET1_T_S4_T0_S5_S3_", "clang::CodeCompletionResult* std::merge<clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"},
    {"_ZSt16__merge_backwardIPN5clang20CodeCompletionResultES2_S2_ET1_T_S4_T0_S5_S3_", "clang::CodeCompletionResult* std::__merge_backward<clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*)"},
    {"_ZSt17__rotate_adaptiveIPN5clang20CodeCompletionResultES2_lET_S3_S3_S3_T1_S4_T0_S4_", "clang::CodeCompletionResult* std::__rotate_adaptive<clang::CodeCompletionResult*, clang::CodeCompletionResult*, long>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long, long, clang::CodeCompletionResult*, long)"},
    {"_ZSt8__rotateIPN5clang20CodeCompletionResultEEvT_S3_S3_St26random_access_iterator_tag", "void std::__rotate<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, std::random_access_iterator_tag)"},
    {"_ZSt16__insertion_sortIPN5clang20CodeCompletionResultEEvT_S3_", "void std::__insertion_sort<clang::CodeCompletionResult*>(clang::CodeCompletionResult*, clang::CodeCompletionResult*)"},
    {"_ZSt22__merge_without_bufferIPN5clang20CodeCompletionResultElEvT_S3_S3_T0_S4_", "void std::__merge_without_buffer<clang::CodeCompletionResult*, long>(clang::CodeCompletionResult*, clang::CodeCompletionResult*, clang::CodeCompletionResult*, long, long)"},
    {"_ZN5clang13UnqualifiedId13setTemplateIdEPNS_20TemplateIdAnnotationE", "clang::UnqualifiedId::setTemplateId(clang::TemplateIdAnnotation*)"},
    {"_ZN5clang13UnqualifiedId24setConstructorTemplateIdEPNS_20TemplateIdAnnotationE", "clang::UnqualifiedId::setConstructorTemplateId(clang::TemplateIdAnnotation*)"},
    {"_ZN5clang15DeclaratorChunk11getFunctionERKNS_16ParsedAttributesEbbNS_14SourceLocationEPNS0_9ParamInfoEjjbS4_bS4_bPNS_9OpaquePtrINS_8QualTypeEEEPNS_11SourceRangeEjS4_S4_RNS_10DeclaratorES9_", "clang::DeclaratorChunk::getFunction(clang::ParsedAttributes const&, bool, bool, clang::SourceLocation, clang::DeclaratorChunk::ParamInfo*, unsigned int, unsigned int, bool, clang::SourceLocation, bool, clang::SourceLocation, bool, clang::OpaquePtr<clang::QualType>*, clang::SourceRange*, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::Declarator&, clang::OpaquePtr<clang::QualType>)"},
    {"_ZNK5clang8DeclSpec19getParsedSpecifiersEv", "clang::DeclSpec::getParsedSpecifiers() const"},
    {"_ZN5clang8DeclSpec16getSpecifierNameENS0_3SCSE", "clang::DeclSpec::getSpecifierName(clang::DeclSpec::SCS)"},
    {"_ZN5clang8DeclSpec16getSpecifierNameENS_18TypeSpecifierWidthE", "clang::DeclSpec::getSpecifierName(clang::TypeSpecifierWidth)"},
    {"_ZN5clang8DeclSpec16getSpecifierNameENS0_3TSCE", "clang::DeclSpec::getSpecifierName(clang::DeclSpec::TSC)"},
    {"_ZN5clang8DeclSpec16getSpecifierNameENS_17TypeSpecifierSignE", "clang::DeclSpec::getSpecifierName(clang::TypeSpecifierSign)"},
    {"_ZN5clang8DeclSpec16getSpecifierNameENS_17TypeSpecifierTypeE", "clang::DeclSpec::getSpecifierName(clang::TypeSpecifierType)"},
    {"_ZN5clang8DeclSpec16getSpecifierNameENS0_2TQE", "clang::DeclSpec::getSpecifierName(clang::DeclSpec::TQ)"},
    {"_ZN5clang8DeclSpec19SetStorageClassSpecENS0_3SCSENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetStorageClassSpec(clang::DeclSpec::SCS, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec25SetStorageClassSpecThreadENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetStorageClassSpecThread(clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec16SetTypeSpecWidthENS_18TypeSpecifierWidthENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecWidth(clang::TypeSpecifierWidth, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec18SetTypeSpecComplexENS0_3TSCENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecComplex(clang::DeclSpec::TSC, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec15SetTypeSpecSignENS_17TypeSpecifierSignENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecSign(clang::TypeSpecifierSign, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRjNS_9OpaquePtrINS_8QualTypeEEE", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRjPNS_4ExprE", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&, clang::Expr*)"},
    {"_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRjPNS_4DeclEb", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&, clang::Decl*, bool)"},
    {"_ZN5clang8DeclSpec15SetTypeSpecTypeENS_17TypeSpecifierTypeENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeSpecType(clang::TypeSpecifierType, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec20SetTypeAltiVecVectorEbNS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeAltiVecVector(bool, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec19SetTypeAltiVecPixelEbNS_14SourceLocationERPKcRj", "clang::DeclSpec::SetTypeAltiVecPixel(bool, clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec16SetTypeSpecErrorEv", "clang::DeclSpec::SetTypeSpecError()"},
    {"_ZN5clang8DeclSpec11SetTypeQualENS0_2TQENS_14SourceLocationERPKcRjRKNS_11LangOptionsE", "clang::DeclSpec::SetTypeQual(clang::DeclSpec::TQ, clang::SourceLocation, char const*&, unsigned int&, clang::LangOptions const&)"},
    {"_ZN5clang8DeclSpec21SetFunctionSpecInlineENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFunctionSpecInline(clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec22SetFunctionSpecVirtualENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFunctionSpecVirtual(clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec23SetFunctionSpecExplicitENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFunctionSpecExplicit(clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec13SetFriendSpecENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetFriendSpec(clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec16SetConstexprSpecENS_14SourceLocationERPKcRj", "clang::DeclSpec::SetConstexprSpec(clang::SourceLocation, char const*&, unsigned int&)"},
    {"_ZN5clang8DeclSpec21setProtocolQualifiersEPKPNS_4DeclEjPNS_14SourceLocationES5_", "clang::DeclSpec::setProtocolQualifiers(clang::Decl* const*, unsigned int, clang::SourceLocation*, clang::SourceLocation)"},
    {"_ZN5clang8DeclSpec23SaveWrittenBuiltinSpecsEv", "clang::DeclSpec::SaveWrittenBuiltinSpecs()"},
    {"_ZN5clang8DeclSpec29SaveStorageSpecifierAsWrittenEv", "clang::DeclSpec::SaveStorageSpecifierAsWritten()"},
    {"_ZN5clang8DeclSpec6FinishERNS_10DiagnosticERNS_12PreprocessorE", "clang::DeclSpec::Finish(clang::Diagnostic&, clang::Preprocessor&)"},
    {"_ZN5clang8DeclSpec21isMissingDeclaratorOkEv", "clang::DeclSpec::isMissingDeclaratorOk()"},
    {"_ZN5clang13UnqualifiedId5clearEv", "clang::UnqualifiedId::clear()"},
    {"_ZN5clang13UnqualifiedId21setOperatorFunctionIdENS_14SourceLocationENS_22OverloadedOperatorKindEPS1_", "clang::UnqualifiedId::setOperatorFunctionId(clang::SourceLocation, clang::OverloadedOperatorKind, clang::SourceLocation*)"},
    {"_ZN5clang14VirtSpecifiers12SetSpecifierENS0_9SpecifierENS_14SourceLocationERPKc", "clang::VirtSpecifiers::SetSpecifier(clang::VirtSpecifiers::Specifier, clang::SourceLocation, char const*&)"},
    {"_ZN5clang14VirtSpecifiers16getSpecifierNameENS0_9SpecifierE", "clang::VirtSpecifiers::getSpecifierName(clang::VirtSpecifiers::Specifier)"},
    {"_ZN5clang19ClassVirtSpecifiers12SetSpecifierENS0_9SpecifierENS_14SourceLocationERPKc", "clang::ClassVirtSpecifiers::SetSpecifier(clang::ClassVirtSpecifiers::Specifier, clang::SourceLocation, char const*&)"},
    {"_ZN5clang19ClassVirtSpecifiers16getSpecifierNameENS0_9SpecifierE", "clang::ClassVirtSpecifiers::getSpecifierName(clang::ClassVirtSpecifiers::Specifier)"},
    {"_ZN5clang18IdentifierResolver10IdDeclInfo10RemoveDeclEPNS_9NamedDeclE", "clang::IdentifierResolver::IdDeclInfo::RemoveDecl(clang::NamedDecl*)"},
    {"_ZN5clang18IdentifierResolver10IdDeclInfo11ReplaceDeclEPNS_9NamedDeclES3_", "clang::IdentifierResolver::IdDeclInfo::ReplaceDecl(clang::NamedDecl*, clang::NamedDecl*)"},
    {"_ZN5clang18IdentifierResolverC1ERKNS_11LangOptionsE", "clang::IdentifierResolver::IdentifierResolver(clang::LangOptions const&)"},
    {"_ZN5clang18IdentifierResolverC2ERKNS_11LangOptionsE", "clang::IdentifierResolver::IdentifierResolver(clang::LangOptions const&)"},
    {"_ZN5clang18IdentifierResolverD1Ev", "clang::IdentifierResolver::~IdentifierResolver()"},
    {"_ZN5clang18IdentifierResolverD2Ev", "clang::IdentifierResolver::~IdentifierResolver()"},
    {"_ZNK5clang18IdentifierResolver13isDeclInScopeEPNS_4DeclEPNS_11DeclContextERNS_10ASTContextEPNS_5ScopeE", "clang::IdentifierResolver::isDeclInScope(clang::Decl*, clang::DeclContext*, clang::ASTContext&, clang::Scope*) const"},
    {"_ZN5clang18IdentifierResolver7AddDeclEPNS_9NamedDeclE", "clang::IdentifierResolver::AddDecl(clang::NamedDecl*)"},
    {"_ZN5clang18IdentifierResolver13IdDeclInfoMapixENS_15DeclarationNameE", "clang::IdentifierResolver::IdDeclInfoMap::operator[](clang::DeclarationName)"},
    {"_ZN5clang18IdentifierResolver10RemoveDeclEPNS_9NamedDeclE", "clang::IdentifierResolver::RemoveDecl(clang::NamedDecl*)"},
    {"_ZN5clang18IdentifierResolver11ReplaceDeclEPNS_9NamedDeclES2_", "clang::IdentifierResolver::ReplaceDecl(clang::NamedDecl*, clang::NamedDecl*)"},
    {"_ZN5clang18IdentifierResolver5beginENS_15DeclarationNameE", "clang::IdentifierResolver::begin(clang::DeclarationName)"},
    {"_ZN5clang18IdentifierResolver24AddDeclToIdentifierChainEPNS_14IdentifierInfoEPNS_9NamedDeclE", "clang::IdentifierResolver::AddDeclToIdentifierChain(clang::IdentifierInfo*, clang::NamedDecl*)"},
    {"_ZN5clang18IdentifierResolver8iterator17incrementSlowCaseEv", "clang::IdentifierResolver::iterator::incrementSlowCase()"},
    {"_ZN5clang4Sema20DiagnoseInvalidJumpsEPNS_4StmtE", "clang::Sema::DiagnoseInvalidJumps(clang::Stmt*)"},
    {"_ZN4llvm15SmallVectorImplIN12_GLOBAL__N_116JumpScopeChecker9GotoScopeEE9push_backERKS3_", "llvm::SmallVectorImpl<(anonymous namespace)::JumpScopeChecker::GotoScope>::push_back((anonymous namespace)::JumpScopeChecker::GotoScope const&)"},
    {"_ZN12_GLOBAL__N_116JumpScopeChecker21BuildScopeInformationEPN5clang4StmtEj", "(anonymous namespace)::JumpScopeChecker::BuildScopeInformation(clang::Stmt*, unsigned int)"},
    {"_ZN12_GLOBAL__N_116JumpScopeChecker9CheckJumpEPN5clang4StmtES3_NS1_14SourceLocationEj", "(anonymous namespace)::JumpScopeChecker::CheckJump(clang::Stmt*, clang::Stmt*, clang::SourceLocation, unsigned int)"},
    {"_ZN12_GLOBAL__N_116JumpScopeChecker21BuildScopeInformationEPN5clang4DeclERj", "(anonymous namespace)::JumpScopeChecker::BuildScopeInformation(clang::Decl*, unsigned int&)"},
    {"_ZN4llvm8DenseMapIjPN5clang9LabelStmtENS_12DenseMapInfoIjEENS4_IS3_EEE16InsertIntoBucketERKjRKS3_PSt4pairIjS3_E", "llvm::DenseMap<unsigned int, clang::LabelStmt*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::LabelStmt*> >::InsertIntoBucket(unsigned int const&, clang::LabelStmt* const&, std::pair<unsigned int, clang::LabelStmt*>*)"},
    {"_ZN4llvm8DenseMapIjPN5clang9LabelStmtENS_12DenseMapInfoIjEENS4_IS3_EEE4growEj", "llvm::DenseMap<unsigned int, clang::LabelStmt*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::LabelStmt*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIjPN5clang16IndirectGotoStmtENS_12DenseMapInfoIjEENS4_IS3_EEE16InsertIntoBucketERKjRKS3_PSt4pairIjS3_E", "llvm::DenseMap<unsigned int, clang::IndirectGotoStmt*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::IndirectGotoStmt*> >::InsertIntoBucket(unsigned int const&, clang::IndirectGotoStmt* const&, std::pair<unsigned int, clang::IndirectGotoStmt*>*)"},
    {"_ZN4llvm8DenseMapIjPN5clang16IndirectGotoStmtENS_12DenseMapInfoIjEENS4_IS3_EEE4growEj", "llvm::DenseMap<unsigned int, clang::IndirectGotoStmt*, llvm::DenseMapInfo<unsigned int>, llvm::DenseMapInfo<clang::IndirectGotoStmt*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPN5clang4StmtEjNS_12DenseMapInfoIS3_EENS4_IjEEE16InsertIntoBucketERKS3_RKjPSt4pairIS3_jE", "llvm::DenseMap<clang::Stmt*, unsigned int, llvm::DenseMapInfo<clang::Stmt*>, llvm::DenseMapInfo<unsigned int> >::InsertIntoBucket(clang::Stmt* const&, unsigned int const&, std::pair<clang::Stmt*, unsigned int>*)"},
    {"_ZN4llvm8DenseMapIPN5clang4StmtEjNS_12DenseMapInfoIS3_EENS4_IjEEE4growEj", "llvm::DenseMap<clang::Stmt*, unsigned int, llvm::DenseMapInfo<clang::Stmt*>, llvm::DenseMapInfo<unsigned int> >::grow(unsigned int)"},
    {"_ZN5clang4sema17FunctionScopeInfoD0Ev", "clang::sema::FunctionScopeInfo::~FunctionScopeInfo()"},
    {"_ZN5clang4sema17FunctionScopeInfoD1Ev", "clang::sema::FunctionScopeInfo::~FunctionScopeInfo()"},
    {"_ZN5clang4sema17FunctionScopeInfoD2Ev", "clang::sema::FunctionScopeInfo::~FunctionScopeInfo()"},
    {"_ZN5clang4sema17FunctionScopeInfo5ClearEv", "clang::sema::FunctionScopeInfo::Clear()"},
    {"_ZN5clang4sema14BlockScopeInfoD0Ev", "clang::sema::BlockScopeInfo::~BlockScopeInfo()"},
    {"_ZN5clang4sema14BlockScopeInfoD1Ev", "clang::sema::BlockScopeInfo::~BlockScopeInfo()"},
    {"_ZN5clang4sema14BlockScopeInfoD2Ev", "clang::sema::BlockScopeInfo::~BlockScopeInfo()"},
    {"_ZN5clang4Sema25ActOnTranslationUnitScopeEPNS_5ScopeE", "clang::Sema::ActOnTranslationUnitScope(clang::Scope*)"},
    {"_ZN5clang4SemaC1ERNS_12PreprocessorERNS_10ASTContextERNS_11ASTConsumerEbPNS_20CodeCompleteConsumerE", "clang::Sema::Sema(clang::Preprocessor&, clang::ASTContext&, clang::ASTConsumer&, bool, clang::CodeCompleteConsumer*)"},
    {"_ZN5clang4SemaC2ERNS_12PreprocessorERNS_10ASTContextERNS_11ASTConsumerEbPNS_20CodeCompleteConsumerE", "clang::Sema::Sema(clang::Preprocessor&, clang::ASTContext&, clang::ASTConsumer&, bool, clang::CodeCompleteConsumer*)"},
    {"_ZN5clang4Sema10InitializeEv", "clang::Sema::Initialize()"},
    {"_ZN5clang4SemaD1Ev", "clang::Sema::~Sema()"},
    {"_ZN5clang4SemaD2Ev", "clang::Sema::~Sema()"},
    {"_ZN5clang4Sema17ImpCastExprToTypeERPNS_4ExprENS_8QualTypeENS_8CastKindENS_13ExprValueKindEPKN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::ImpCastExprToType(clang::Expr*&, clang::QualType, clang::CastKind, clang::ExprValueKind, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u> const*)"},
    {"_ZN5clang4Sema12CastCategoryEPNS_4ExprE", "clang::Sema::CastCategory(clang::Expr*)"},
    {"_ZN5clang4Sema25ActOnEndOfTranslationUnitEv", "clang::Sema::ActOnEndOfTranslationUnit()"},
    {"_Z22ShouldRemoveFromUnusedPN5clang4SemaEPKNS_14DeclaratorDeclE", "ShouldRemoveFromUnused(clang::Sema*, clang::DeclaratorDecl const*)"},
    {"_ZN5clang4Sema4DiagENS_14SourceLocationEj", "clang::Sema::Diag(clang::SourceLocation, unsigned int)"},
    {"_ZN5clang4Sema21SemaDiagnosticBuilderD1Ev", "clang::Sema::SemaDiagnosticBuilder::~SemaDiagnosticBuilder()"},
    {"_ZN5clang4Sema27getFunctionLevelDeclContextEv", "clang::Sema::getFunctionLevelDeclContext()"},
    {"_ZN5clang4Sema18getCurFunctionDeclEv", "clang::Sema::getCurFunctionDecl()"},
    {"_ZN5clang4Sema16getCurMethodDeclEv", "clang::Sema::getCurMethodDecl()"},
    {"_ZN5clang4Sema26getCurFunctionOrMethodDeclEv", "clang::Sema::getCurFunctionOrMethodDecl()"},
    {"_ZN5clang4Sema21SemaDiagnosticBuilderD2Ev", "clang::Sema::SemaDiagnosticBuilder::~SemaDiagnosticBuilder()"},
    {"_ZN5clang4Sema4DiagENS_14SourceLocationERKNS_17PartialDiagnosticE", "clang::Sema::Diag(clang::SourceLocation, clang::PartialDiagnostic const&)"},
    {"_ZN5clang4Sema18getScopeForContextEPNS_11DeclContextE", "clang::Sema::getScopeForContext(clang::DeclContext*)"},
    {"_ZN5clang4Sema17PushFunctionScopeEv", "clang::Sema::PushFunctionScope()"},
    {"_ZN5clang4Sema14PushBlockScopeEPNS_5ScopeEPNS_9BlockDeclE", "clang::Sema::PushBlockScope(clang::Scope*, clang::BlockDecl*)"},
    {"_ZN5clang4Sema23PopFunctionOrBlockScopeEv", "clang::Sema::PopFunctionOrBlockScope()"},
    {"_ZNK5clang4Sema26hasAnyErrorsInThisFunctionEv", "clang::Sema::hasAnyErrorsInThisFunction() const"},
    {"_ZN5clang4Sema11getCurBlockEv", "clang::Sema::getCurBlock()"},
    {"_ZN5clang18ExternalSemaSourceD0Ev", "clang::ExternalSemaSource::~ExternalSemaSource()"},
    {"_ZN5clang18ExternalSemaSourceD1Ev", "clang::ExternalSemaSource::~ExternalSemaSource()"},
    {"_ZN5clang18ExternalSemaSourceD2Ev", "clang::ExternalSemaSource::~ExternalSemaSource()"},
    {"_ZN5clang18ExternalSemaSource14ReadMethodPoolENS_8SelectorE", "clang::ExternalSemaSource::ReadMethodPool(clang::Selector)"},
    {"_ZNK5clang25PrettyDeclStackTraceEntry5printERN4llvm11raw_ostreamE", "clang::PrettyDeclStackTraceEntry::print(llvm::raw_ostream&) const"},
    {"_ZN5clang4sema21TemplateDeductionInfo23addSuppressedDiagnosticENS_14SourceLocationERKNS_17PartialDiagnosticE", "clang::sema::TemplateDeductionInfo::addSuppressedDiagnostic(clang::SourceLocation, clang::PartialDiagnostic const&)"},
    {"_ZNK5clang17PartialDiagnostic4EmitERKNS_17DiagnosticBuilderE", "clang::PartialDiagnostic::Emit(clang::DiagnosticBuilder const&) const"},
    {"_ZN5clang25PrettyDeclStackTraceEntryD1Ev", "clang::PrettyDeclStackTraceEntry::~PrettyDeclStackTraceEntry()"},
    {"_ZN5clang25PrettyDeclStackTraceEntryD0Ev", "clang::PrettyDeclStackTraceEntry::~PrettyDeclStackTraceEntry()"},
    {"_ZSt9__find_ifIPPKN5clang14DeclaratorDeclESt9binder1stISt26pointer_to_binary_functionIPNS0_4SemaES3_bEEET_SB_SB_T0_St26random_access_iterator_tag", "clang::DeclaratorDecl const** std::__find_if<clang::DeclaratorDecl const**, std::binder1st<std::pointer_to_binary_function<clang::Sema*, clang::DeclaratorDecl const*, bool> > >(clang::DeclaratorDecl const**, clang::DeclaratorDecl const**, std::binder1st<std::pointer_to_binary_function<clang::Sema*, clang::DeclaratorDecl const*, bool> >, std::random_access_iterator_tag)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang4Sema33ExpressionEvaluationContextRecordELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Sema::ExpressionEvaluationContextRecord, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIPN5clang4DeclENS_11SmallVectorISt4pairINS1_14SourceLocationENS1_17PartialDiagnosticEELj1EEENS_12DenseMapInfoIS3_EENSA_IS9_EEED2Ev", "llvm::DenseMap<clang::Decl*, llvm::SmallVector<std::pair<clang::SourceLocation, clang::PartialDiagnostic>, 1u>, llvm::DenseMapInfo<clang::Decl*>, llvm::DenseMapInfo<llvm::SmallVector<std::pair<clang::SourceLocation, clang::PartialDiagnostic>, 1u> > >::~DenseMap()"},
    {"_ZNSt11_Deque_baseISt4pairIPN5clang9ValueDeclENS1_14SourceLocationEESaIS5_EE17_M_initialize_mapEm", "std::_Deque_base<std::pair<clang::ValueDecl*, clang::SourceLocation>, std::allocator<std::pair<clang::ValueDecl*, clang::SourceLocation> > >::_M_initialize_map(unsigned long)"},
    {"_ZN4llvm8DenseMapIPN5clang14IdentifierInfoEPNS1_9LabelStmtENS_12DenseMapInfoIS3_EENS6_IS5_EEE16shrink_and_clearEv", "llvm::DenseMap<clang::IdentifierInfo*, clang::LabelStmt*, llvm::DenseMapInfo<clang::IdentifierInfo*>, llvm::DenseMapInfo<clang::LabelStmt*> >::shrink_and_clear()"},
    {"_ZN5clang4sema14BlockScopeInfoC2ERNS_10DiagnosticEPNS_5ScopeEPNS_9BlockDeclE", "clang::sema::BlockScopeInfo::BlockScopeInfo(clang::Diagnostic&, clang::Scope*, clang::BlockDecl*)"},
    {"_ZN5clang17PartialDiagnostic11freeStorageEv", "clang::PartialDiagnostic::freeStorage()"},
    {"_ZN5clang17PartialDiagnosticC2ERKNS_14DiagnosticInfoERNS0_16StorageAllocatorE", "clang::PartialDiagnostic::PartialDiagnostic(clang::DiagnosticInfo const&, clang::PartialDiagnostic::StorageAllocator&)"},
    {"_ZNK5clang17PartialDiagnostic9AddStringEN4llvm9StringRefE", "clang::PartialDiagnostic::AddString(llvm::StringRef) const"},
    {"_ZNK5clang17PartialDiagnostic10getStorageEv", "clang::PartialDiagnostic::getStorage() const"},
    {"_ZN5clang17PartialDiagnostic16StorageAllocator8AllocateEv", "clang::PartialDiagnostic::StorageAllocator::Allocate()"},
    {"_ZN5clang17PartialDiagnostic7StorageaSERKS1_", "clang::PartialDiagnostic::Storage::operator=(clang::PartialDiagnostic::Storage const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseISt4pairIN5clang14SourceLocationENS2_17PartialDiagnosticEELb0EE4growEm", "llvm::SmallVectorTemplateBase<std::pair<clang::SourceLocation, clang::PartialDiagnostic>, false>::grow(unsigned long)"},
    {"_ZN5clang4Sema24SetMemberAccessSpecifierEPNS_9NamedDeclES2_NS_15AccessSpecifierE", "clang::Sema::SetMemberAccessSpecifier(clang::NamedDecl*, clang::NamedDecl*, clang::AccessSpecifier)"},
    {"_ZN5clang4Sema24HandleDelayedAccessCheckERNS_4sema17DelayedDiagnosticEPNS_4DeclE", "clang::Sema::HandleDelayedAccessCheck(clang::sema::DelayedDiagnostic&, clang::Decl*)"},
    {"_ZN12_GLOBAL__N_116EffectiveContextC1EPN5clang11DeclContextE", "(anonymous namespace)::EffectiveContext::EffectiveContext(clang::DeclContext*)"},
    {"_Z20CheckEffectiveAccessRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextENS_14SourceLocationERNS2_12AccessTargetE", "CheckEffectiveAccess(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::SourceLocation, (anonymous namespace)::AccessTarget&)"},
    {"_ZN5clang4Sema26HandleDependentAccessCheckERKNS_19DependentDiagnosticERKNS_30MultiLevelTemplateArgumentListE", "clang::Sema::HandleDependentAccessCheck(clang::DependentDiagnostic const&, clang::MultiLevelTemplateArgumentList const&)"},
    {"_Z11CheckAccessRN5clang4SemaENS_14SourceLocationERN12_GLOBAL__N_112AccessTargetE", "CheckAccess(clang::Sema&, clang::SourceLocation, (anonymous namespace)::AccessTarget&)"},
    {"_ZN5clang4Sema27CheckUnresolvedLookupAccessEPNS_20UnresolvedLookupExprENS_14DeclAccessPairE", "clang::Sema::CheckUnresolvedLookupAccess(clang::UnresolvedLookupExpr*, clang::DeclAccessPair)"},
    {"_ZN5clang4Sema27CheckUnresolvedMemberAccessEPNS_20UnresolvedMemberExprENS_14DeclAccessPairE", "clang::Sema::CheckUnresolvedMemberAccess(clang::UnresolvedMemberExpr*, clang::DeclAccessPair)"},
    {"_ZN5clang4Sema21CheckDestructorAccessENS_14SourceLocationEPNS_17CXXDestructorDeclERKNS_17PartialDiagnosticE", "clang::Sema::CheckDestructorAccess(clang::SourceLocation, clang::CXXDestructorDecl*, clang::PartialDiagnostic const&)"},
    {"_ZN5clang4Sema22CheckConstructorAccessENS_14SourceLocationEPNS_18CXXConstructorDeclERKNS_17InitializedEntityENS_15AccessSpecifierEb", "clang::Sema::CheckConstructorAccess(clang::SourceLocation, clang::CXXConstructorDecl*, clang::InitializedEntity const&, clang::AccessSpecifier, bool)"},
    {"_ZN5clang4Sema23CheckDirectMemberAccessENS_14SourceLocationEPNS_9NamedDeclERKNS_17PartialDiagnosticE", "clang::Sema::CheckDirectMemberAccess(clang::SourceLocation, clang::NamedDecl*, clang::PartialDiagnostic const&)"},
    {"_ZN5clang4Sema21CheckAllocationAccessENS_14SourceLocationENS_11SourceRangeEPNS_13CXXRecordDeclENS_14DeclAccessPairE", "clang::Sema::CheckAllocationAccess(clang::SourceLocation, clang::SourceRange, clang::CXXRecordDecl*, clang::DeclAccessPair)"},
    {"_ZN5clang4Sema25CheckMemberOperatorAccessENS_14SourceLocationEPNS_4ExprES3_NS_14DeclAccessPairE", "clang::Sema::CheckMemberOperatorAccess(clang::SourceLocation, clang::Expr*, clang::Expr*, clang::DeclAccessPair)"},
    {"_ZN5clang4Sema26CheckAddressOfMemberAccessEPNS_4ExprENS_14DeclAccessPairE", "clang::Sema::CheckAddressOfMemberAccess(clang::Expr*, clang::DeclAccessPair)"},
    {"_ZN5clang4Sema20CheckBaseClassAccessENS_14SourceLocationENS_8QualTypeES2_RKNS_11CXXBasePathEjbb", "clang::Sema::CheckBaseClassAccess(clang::SourceLocation, clang::QualType, clang::QualType, clang::CXXBasePath const&, unsigned int, bool, bool)"},
    {"_ZN5clang4Sema17CheckLookupAccessERKNS_12LookupResultE", "clang::Sema::CheckLookupAccess(clang::LookupResult const&)"},
    {"_ZN5clang4Sema33ActOnStartSuppressingAccessChecksEv", "clang::Sema::ActOnStartSuppressingAccessChecks()"},
    {"_ZN5clang4Sema32ActOnStopSuppressingAccessChecksEv", "clang::Sema::ActOnStopSuppressingAccessChecks()"},
    {"_Z18FindDeclaringClassPN5clang9NamedDeclE", "FindDeclaringClass(clang::NamedDecl*)"},
    {"_Z9HasAccessRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextEPKNS_13CXXRecordDeclENS_15AccessSpecifierERKNS2_12AccessTargetE", "HasAccess(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::CXXRecordDecl const*, clang::AccessSpecifier, (anonymous namespace)::AccessTarget const&)"},
    {"_Z12FindBestPathRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextERNS2_12AccessTargetENS_15AccessSpecifierERNS_12CXXBasePathsE", "FindBestPath(clang::Sema&, (anonymous namespace)::EffectiveContext const&, (anonymous namespace)::AccessTarget&, clang::AccessSpecifier, clang::CXXBasePaths&)"},
    {"_Z13GetFriendKindRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextEPKNS_13CXXRecordDeclE", "GetFriendKind(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::CXXRecordDecl const*)"},
    {"_Z13MatchesFriendRN5clang4SemaERKN12_GLOBAL__N_116EffectiveContextEPKNS_13CXXRecordDeclE", "MatchesFriend(clang::Sema&, (anonymous namespace)::EffectiveContext const&, clang::CXXRecordDecl const*)"},
    {"_Z18MightInstantiateToRN5clang4SemaEPNS_12FunctionDeclES3_", "MightInstantiateTo(clang::Sema&, clang::FunctionDecl*, clang::FunctionDecl*)"},
    {"_Z22IsDerivedFromInclusivePKN5clang13CXXRecordDeclES2_", "IsDerivedFromInclusive(clang::CXXRecordDecl const*, clang::CXXRecordDecl const*)"},
    {"_ZN12_GLOBAL__N_122ProtectedFriendContext14findFriendshipEPKN5clang13CXXRecordDeclEj", "(anonymous namespace)::ProtectedFriendContext::findFriendship(clang::CXXRecordDecl const*, unsigned int)"},
    {"_ZSt6__findIPKPN5clang13CXXRecordDeclEPKS1_ET_S7_S7_RKT0_St26random_access_iterator_tag", "clang::CXXRecordDecl* const* std::__find<clang::CXXRecordDecl* const*, clang::CXXRecordDecl const*>(clang::CXXRecordDecl* const*, clang::CXXRecordDecl* const*, clang::CXXRecordDecl const* const&, std::random_access_iterator_tag)"},
    {"_ZN5clang4Sema17FreePackedContextEv", "clang::Sema::FreePackedContext()"},
    {"_ZN5clang4Sema31AddAlignmentAttributesForRecordEPNS_10RecordDeclE", "clang::Sema::AddAlignmentAttributesForRecord(clang::RecordDecl*)"},
    {"_ZN5clang4Sema23ActOnPragmaOptionsAlignENS0_22PragmaOptionsAlignKindENS_14SourceLocationES2_", "clang::Sema::ActOnPragmaOptionsAlign(clang::Sema::PragmaOptionsAlignKind, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN12_GLOBAL__N_115PragmaPackStack4pushEPN5clang14IdentifierInfoE", "(anonymous namespace)::PragmaPackStack::push(clang::IdentifierInfo*)"},
    {"_ZN5clang4Sema15ActOnPragmaPackENS0_14PragmaPackKindEPNS_14IdentifierInfoEPNS_4ExprENS_14SourceLocationES6_S6_", "clang::Sema::ActOnPragmaPack(clang::Sema::PragmaPackKind, clang::IdentifierInfo*, clang::Expr*, clang::SourceLocation, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang4Sema17ActOnPragmaUnusedERKNS_5TokenEPNS_5ScopeENS_14SourceLocationE", "clang::Sema::ActOnPragmaUnused(clang::Token const&, clang::Scope*, clang::SourceLocation)"},
    {"_ZN5clang4Sema28AddPushedVisibilityAttributeEPNS_4DeclE", "clang::Sema::AddPushedVisibilityAttribute(clang::Decl*)"},
    {"_ZN5clang4Sema14FreeVisContextEv", "clang::Sema::FreeVisContext()"},
    {"_ZN5clang4Sema21ActOnPragmaVisibilityEbPKNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::ActOnPragmaVisibility(bool, clang::IdentifierInfo const*, clang::SourceLocation)"},
    {"_ZN5clang4Sema19PopPragmaVisibilityEv", "clang::Sema::PopPragmaVisibility()"},
    {"_ZN5clang4Sema27PushNamespaceVisibilityAttrEPKNS_14VisibilityAttrE", "clang::Sema::PushNamespaceVisibilityAttr(clang::VisibilityAttr const*)"},
    {"_ZN5clang4Decl7addAttrEPNS_4AttrE", "clang::Decl::addAttr(clang::Attr*)"},
    {"_ZNSt6vectorISt4pairIjN5clang14SourceLocationEESaIS3_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS3_S5_EERKS3_", "std::vector<std::pair<unsigned int, clang::SourceLocation>, std::allocator<std::pair<unsigned int, clang::SourceLocation> > >::_M_insert_aux(__gnu_cxx::__normal_iterator<std::pair<unsigned int, clang::SourceLocation>*, std::vector<std::pair<unsigned int, clang::SourceLocation>, std::allocator<std::pair<unsigned int, clang::SourceLocation> > > >, std::pair<unsigned int, clang::SourceLocation> const&)"},
    {"_ZN5clang15InheritableAttrD1Ev", "clang::InheritableAttr::~InheritableAttr()"},
    {"_ZN5clang15InheritableAttrD0Ev", "clang::InheritableAttr::~InheritableAttr()"},
    {"_ZN4llvm11SmallVectorIPN5clang4AttrELj2EEC2EjRKS3_", "llvm::SmallVector<clang::Attr*, 2u>::SmallVector(unsigned int, clang::Attr* const&)"},
    {"_ZN5clang4Sema17ActOnCXXNamedCastENS_14SourceLocationENS_3tok9TokenKindES1_NS_9OpaquePtrINS_8QualTypeEEES1_S1_PNS_4ExprES1_", "clang::Sema::ActOnCXXNamedCast(clang::SourceLocation, clang::tok::TokenKind, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema17BuildCXXNamedCastENS_14SourceLocationENS_3tok9TokenKindEPNS_14TypeSourceInfoEPNS_4ExprENS_11SourceRangeES8_", "clang::Sema::BuildCXXNamedCast(clang::SourceLocation, clang::tok::TokenKind, clang::TypeSourceInfo*, clang::Expr*, clang::SourceRange, clang::SourceRange)"},
    {"_ZN5clang4Sema18CXXCheckCStyleCastENS_11SourceRangeENS_8QualTypeERNS_13ExprValueKindERPNS_4ExprERNS_8CastKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEEb", "clang::Sema::CXXCheckCStyleCast(clang::SourceRange, clang::QualType, clang::ExprValueKind&, clang::Expr*&, clang::CastKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&, bool)"},
    {"_Z12TryConstCastRN5clang4SemaEPNS_4ExprENS_8QualTypeEbRj", "TryConstCast(clang::Sema&, clang::Expr*, clang::QualType, bool, unsigned int&)"},
    {"_Z13TryStaticCastRN5clang4SemaERPNS_4ExprENS_8QualTypeEbRKNS_11SourceRangeERjRNS_8CastKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "TryStaticCast(clang::Sema&, clang::Expr*&, clang::QualType, bool, clang::SourceRange const&, unsigned int&, clang::CastKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&)"},
    {"_Z18TryReinterpretCastRN5clang4SemaEPNS_4ExprENS_8QualTypeEbRKNS_11SourceRangeERjRNS_8CastKindE", "TryReinterpretCast(clang::Sema&, clang::Expr*, clang::QualType, bool, clang::SourceRange const&, unsigned int&, clang::CastKind&)"},
    {"_Z18CastsAwayConstnessRN5clang4SemaENS_8QualTypeES2_", "CastsAwayConstness(clang::Sema&, clang::QualType, clang::QualType)"},
    {"_Z17TryStaticDowncastRN5clang4SemaENS_7CanQualINS_4TypeEEES4_bRKNS_11SourceRangeENS_8QualTypeES8_RjRNS_8CastKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "TryStaticDowncast(clang::Sema&, clang::CanQual<clang::Type>, clang::CanQual<clang::Type>, bool, clang::SourceRange const&, clang::QualType, clang::QualType, unsigned int&, clang::CastKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&)"},
    {"_Z25NoteAllOverloadCandidatesPN5clang4ExprERNS_4SemaE", "NoteAllOverloadCandidates(clang::Expr*, clang::Sema&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang10QualifiersELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::Qualifiers, false>::grow(unsigned long)"},
    {"_ZN5clang4Sema18computeDeclContextENS_8QualTypeE", "clang::Sema::computeDeclContext(clang::QualType)"},
    {"_ZN5clang4Sema18computeDeclContextERKNS_12CXXScopeSpecEb", "clang::Sema::computeDeclContext(clang::CXXScopeSpec const&, bool)"},
    {"_ZN5clang4Sema25getCurrentInstantiationOfEPNS_19NestedNameSpecifierE", "clang::Sema::getCurrentInstantiationOf(clang::NestedNameSpecifier*)"},
    {"_ZN5clang4Sema25isDependentScopeSpecifierERKNS_12CXXScopeSpecE", "clang::Sema::isDependentScopeSpecifier(clang::CXXScopeSpec const&)"},
    {"_ZN5clang4Sema23isUnknownSpecializationERKNS_12CXXScopeSpecE", "clang::Sema::isUnknownSpecialization(clang::CXXScopeSpec const&)"},
    {"_ZN5clang4Sema26RequireCompleteDeclContextERNS_12CXXScopeSpecEPNS_11DeclContextE", "clang::Sema::RequireCompleteDeclContext(clang::CXXScopeSpec&, clang::DeclContext*)"},
    {"_ZN5clang4Sema28ActOnCXXGlobalScopeSpecifierEPNS_5ScopeENS_14SourceLocationE", "clang::Sema::ActOnCXXGlobalScopeSpecifier(clang::Scope*, clang::SourceLocation)"},
    {"_ZN5clang4Sema31isAcceptableNestedNameSpecifierEPNS_9NamedDeclE", "clang::Sema::isAcceptableNestedNameSpecifier(clang::NamedDecl*)"},
    {"_ZN5clang4Sema25FindFirstQualifierInScopeEPNS_5ScopeEPNS_19NestedNameSpecifierE", "clang::Sema::FindFirstQualifierInScope(clang::Scope*, clang::NestedNameSpecifier*)"},
    {"_ZN5clang4Sema28isNonTypeNestedNameSpecifierEPNS_5ScopeERNS_12CXXScopeSpecENS_14SourceLocationERNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::isNonTypeNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec&, clang::SourceLocation, clang::IdentifierInfo&, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang4Sema27BuildCXXNestedNameSpecifierEPNS_5ScopeERNS_12CXXScopeSpecENS_14SourceLocationES5_RNS_14IdentifierInfoENS_8QualTypeEPNS_9NamedDeclEbb", "clang::Sema::BuildCXXNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec&, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo&, clang::QualType, clang::NamedDecl*, bool, bool)"},
    {"_ZN5clang4Sema27ActOnCXXNestedNameSpecifierEPNS_5ScopeERNS_12CXXScopeSpecENS_14SourceLocationES5_RNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEEb", "clang::Sema::ActOnCXXNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec&, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo&, clang::OpaquePtr<clang::QualType>, bool)"},
    {"_ZN5clang4Sema25IsInvalidUnlessNestedNameEPNS_5ScopeERNS_12CXXScopeSpecERNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEEb", "clang::Sema::IsInvalidUnlessNestedName(clang::Scope*, clang::CXXScopeSpec&, clang::IdentifierInfo&, clang::OpaquePtr<clang::QualType>, bool)"},
    {"_ZN5clang4Sema27ActOnCXXNestedNameSpecifierEPNS_5ScopeERKNS_12CXXScopeSpecENS_9OpaquePtrINS_8QualTypeEEENS_11SourceRangeENS_14SourceLocationE", "clang::Sema::ActOnCXXNestedNameSpecifier(clang::Scope*, clang::CXXScopeSpec const&, clang::OpaquePtr<clang::QualType>, clang::SourceRange, clang::SourceLocation)"},
    {"_ZN5clang4Sema26ShouldEnterDeclaratorScopeEPNS_5ScopeERKNS_12CXXScopeSpecE", "clang::Sema::ShouldEnterDeclaratorScope(clang::Scope*, clang::CXXScopeSpec const&)"},
    {"_ZN5clang4Sema28ActOnCXXEnterDeclaratorScopeEPNS_5ScopeERNS_12CXXScopeSpecE", "clang::Sema::ActOnCXXEnterDeclaratorScope(clang::Scope*, clang::CXXScopeSpec&)"},
    {"_ZN5clang4Sema27ActOnCXXExitDeclaratorScopeEPNS_5ScopeERKNS_12CXXScopeSpecE", "clang::Sema::ActOnCXXExitDeclaratorScope(clang::Scope*, clang::CXXScopeSpec const&)"},
    {"_ZNK5clang4Sema30getLocationOfStringLiteralByteEPKNS_13StringLiteralEj", "clang::Sema::getLocationOfStringLiteralByte(clang::StringLiteral const*, unsigned int) const"},
    {"_ZN5clang4Sema19CheckablePrintfAttrEPKNS_10FormatAttrEPNS_8CallExprE", "clang::Sema::CheckablePrintfAttr(clang::FormatAttr const*, clang::CallExpr*)"},
    {"_ZN5clang4Sema24CheckBuiltinFunctionCallEjPNS_8CallExprE", "clang::Sema::CheckBuiltinFunctionCall(unsigned int, clang::CallExpr*)"},
    {"_ZN5clang4Sema22SemaBuiltinConstantArgEPNS_8CallExprEiRN4llvm6APSIntE", "clang::Sema::SemaBuiltinConstantArg(clang::CallExpr*, int, llvm::APSInt&)"},
    {"_ZN5clang4Sema15CheckObjCStringEPNS_4ExprE", "clang::Sema::CheckObjCString(clang::Expr*)"},
    {"_ZN5clang4Sema18SemaBuiltinVAStartEPNS_8CallExprE", "clang::Sema::SemaBuiltinVAStart(clang::CallExpr*)"},
    {"_ZN5clang4Sema27SemaBuiltinUnorderedCompareEPNS_8CallExprE", "clang::Sema::SemaBuiltinUnorderedCompare(clang::CallExpr*)"},
    {"_ZN5clang4Sema27SemaBuiltinFPClassificationEPNS_8CallExprEj", "clang::Sema::SemaBuiltinFPClassification(clang::CallExpr*, unsigned int)"},
    {"_ZN5clang4Sema24SemaBuiltinShuffleVectorEPNS_8CallExprE", "clang::Sema::SemaBuiltinShuffleVector(clang::CallExpr*)"},
    {"_ZN5clang4Sema19SemaBuiltinPrefetchEPNS_8CallExprE", "clang::Sema::SemaBuiltinPrefetch(clang::CallExpr*)"},
    {"_ZN5clang4Sema21SemaBuiltinObjectSizeEPNS_8CallExprE", "clang::Sema::SemaBuiltinObjectSize(clang::CallExpr*)"},
    {"_ZN5clang4Sema18SemaBuiltinLongjmpEPNS_8CallExprE", "clang::Sema::SemaBuiltinLongjmp(clang::CallExpr*)"},
    {"_ZN5clang4Sema27SemaBuiltinAtomicOverloadedENS_12ActionResultIPNS_4ExprELb1EEE", "clang::Sema::SemaBuiltinAtomicOverloaded(clang::ActionResult<clang::Expr*, true>)"},
    {"_ZN5clang4Sema27CheckARMBuiltinFunctionCallEjPNS_8CallExprE", "clang::Sema::CheckARMBuiltinFunctionCall(unsigned int, clang::CallExpr*)"},
    {"_ZN5clang4Sema17CheckFunctionCallEPNS_12FunctionDeclEPNS_8CallExprE", "clang::Sema::CheckFunctionCall(clang::FunctionDecl*, clang::CallExpr*)"},
    {"_ZN5clang4Sema25CheckPrintfScanfArgumentsEPKNS_8CallExprEbjjb", "clang::Sema::CheckPrintfScanfArguments(clang::CallExpr const*, bool, unsigned int, unsigned int, bool)"},
    {"_ZN5clang4Sema21CheckNonNullArgumentsEPKNS_11NonNullAttrEPKNS_8CallExprE", "clang::Sema::CheckNonNullArguments(clang::NonNullAttr const*, clang::CallExpr const*)"},
    {"_ZN5clang4Sema14CheckBlockCallEPNS_9NamedDeclEPNS_8CallExprE", "clang::Sema::CheckBlockCall(clang::NamedDecl*, clang::CallExpr*)"},
    {"_ZN5clang4Sema22SemaCheckStringLiteralEPKNS_4ExprEPKNS_8CallExprEbjjb", "clang::Sema::SemaCheckStringLiteral(clang::Expr const*, clang::CallExpr const*, bool, unsigned int, unsigned int, bool)"},
    {"_ZN5clang4Sema17CheckFormatStringEPKNS_13StringLiteralEPKNS_4ExprEPKNS_8CallExprEbjjb", "clang::Sema::CheckFormatString(clang::StringLiteral const*, clang::Expr const*, clang::CallExpr const*, bool, unsigned int, unsigned int, bool)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler14DoneProcessingEv", "(anonymous namespace)::CheckFormatHandler::DoneProcessing()"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandlerD1Ev", "(anonymous namespace)::CheckPrintfHandler::~CheckPrintfHandler()"},
    {"_ZN12_GLOBAL__N_117CheckScanfHandlerD1Ev", "(anonymous namespace)::CheckScanfHandler::~CheckScanfHandler()"},
    {"_ZN5clang4Sema20CheckReturnStackAddrEPNS_4ExprENS_8QualTypeENS_14SourceLocationE", "clang::Sema::CheckReturnStackAddr(clang::Expr*, clang::QualType, clang::SourceLocation)"},
    {"_Z8EvalAddrPN5clang4ExprERN4llvm15SmallVectorImplIPNS_11DeclRefExprEEE", "EvalAddr(clang::Expr*, llvm::SmallVectorImpl<clang::DeclRefExpr*>&)"},
    {"_Z7EvalValPN5clang4ExprERN4llvm15SmallVectorImplIPNS_11DeclRefExprEEE", "EvalVal(clang::Expr*, llvm::SmallVectorImpl<clang::DeclRefExpr*>&)"},
    {"_ZN5clang4Sema20CheckFloatComparisonENS_14SourceLocationEPNS_4ExprES3_", "clang::Sema::CheckFloatComparison(clang::SourceLocation, clang::Expr*, clang::Expr*)"},
    {"_ZN5clang4Sema24CheckImplicitConversionsEPNS_4ExprENS_14SourceLocationE", "clang::Sema::CheckImplicitConversions(clang::Expr*, clang::SourceLocation)"},
    {"_ZN12_GLOBAL__N_126AnalyzeImplicitConversionsERN5clang4SemaEPNS0_4ExprENS0_14SourceLocationE", "(anonymous namespace)::AnalyzeImplicitConversions(clang::Sema&, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema27CheckBitFieldInitializationENS_14SourceLocationEPNS_9FieldDeclEPNS_4ExprE", "clang::Sema::CheckBitFieldInitialization(clang::SourceLocation, clang::FieldDecl*, clang::Expr*)"},
    {"_ZN12_GLOBAL__N_125AnalyzeBitFieldAssignmentERN5clang4SemaEPNS0_9FieldDeclEPNS0_4ExprENS0_14SourceLocationE", "(anonymous namespace)::AnalyzeBitFieldAssignment(clang::Sema&, clang::FieldDecl*, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema24CheckParmsForFunctionDefEPPNS_11ParmVarDeclES3_b", "clang::Sema::CheckParmsForFunctionDef(clang::ParmVarDecl**, clang::ParmVarDecl**, bool)"},
    {"_ZN5clang4Sema14CheckCastAlignEPNS_4ExprENS_8QualTypeENS_11SourceRangeE", "clang::Sema::CheckCastAlign(clang::Expr*, clang::QualType, clang::SourceRange)"},
    {"_ZN12_GLOBAL__N_124CheckConditionalOperatorERN5clang4SemaEPNS0_19ConditionalOperatorENS0_8QualTypeE", "(anonymous namespace)::CheckConditionalOperator(clang::Sema&, clang::ConditionalOperator*, clang::QualType)"},
    {"_ZN12_GLOBAL__N_123CheckImplicitConversionERN5clang4SemaEPNS0_4ExprENS0_8QualTypeENS0_14SourceLocationEPb", "(anonymous namespace)::CheckImplicitConversion(clang::Sema&, clang::Expr*, clang::QualType, clang::SourceLocation, bool*)"},
    {"_ZN12_GLOBAL__N_130CheckTrivialUnsignedComparisonERN5clang4SemaEPNS0_14BinaryOperatorE", "(anonymous namespace)::CheckTrivialUnsignedComparison(clang::Sema&, clang::BinaryOperator*)"},
    {"_ZN12_GLOBAL__N_112GetExprRangeERN5clang10ASTContextEPNS0_4ExprEj", "(anonymous namespace)::GetExprRange(clang::ASTContext&, clang::Expr*, unsigned int)"},
    {"_ZN12_GLOBAL__N_113GetValueRangeERN5clang10ASTContextERNS0_7APValueENS0_8QualTypeEj", "(anonymous namespace)::GetValueRange(clang::ASTContext&, clang::APValue&, clang::QualType, unsigned int)"},
    {"_ZN12_GLOBAL__N_18IntRange14forValueOfTypeERN5clang10ASTContextENS1_8QualTypeE", "(anonymous namespace)::IntRange::forValueOfType(clang::ASTContext&, clang::QualType)"},
    {"_ZN12_GLOBAL__N_113GetValueRangeERN5clang10ASTContextERN4llvm6APSIntEj", "(anonymous namespace)::GetValueRange(clang::ASTContext&, llvm::APSInt&, unsigned int)"},
    {"_ZN12_GLOBAL__N_16IsZeroERN5clang4SemaEPNS0_4ExprE", "(anonymous namespace)::IsZero(clang::Sema&, clang::Expr*)"},
    {"_ZN12_GLOBAL__N_115DiagnoseImpCastERN5clang4SemaEPNS0_4ExprENS0_8QualTypeENS0_14SourceLocationEj", "(anonymous namespace)::DiagnoseImpCast(clang::Sema&, clang::Expr*, clang::QualType, clang::SourceLocation, unsigned int)"},
    {"_ZN12_GLOBAL__N_120IsSameFloatAfterCastERKN5clang7APValueERKN4llvm12fltSemanticsES7_", "(anonymous namespace)::IsSameFloatAfterCast(clang::APValue const&, llvm::fltSemantics const&, llvm::fltSemantics const&)"},
    {"_ZN12_GLOBAL__N_123CheckConditionalOperandERN5clang4SemaEPNS0_4ExprENS0_8QualTypeENS0_14SourceLocationERb", "(anonymous namespace)::CheckConditionalOperand(clang::Sema&, clang::Expr*, clang::QualType, clang::SourceLocation, bool&)"},
    {"_ZN12_GLOBAL__N_117CheckScanfHandlerD0Ev", "(anonymous namespace)::CheckScanfHandler::~CheckScanfHandler()"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler14HandleNullCharEPKc", "(anonymous namespace)::CheckFormatHandler::HandleNullChar(char const*)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler21HandleInvalidPositionEPKcjN5clang21analyze_format_string15PositionContextE", "(anonymous namespace)::CheckFormatHandler::HandleInvalidPosition(char const*, unsigned int, clang::analyze_format_string::PositionContext)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler18HandleZeroPositionEPKcj", "(anonymous namespace)::CheckFormatHandler::HandleZeroPosition(char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler25HandleIncompleteSpecifierEPKcj", "(anonymous namespace)::CheckFormatHandler::HandleIncompleteSpecifier(char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_117CheckScanfHandler37HandleInvalidScanfConversionSpecifierERKN5clang13analyze_scanf14ScanfSpecifierEPKcj", "(anonymous namespace)::CheckScanfHandler::HandleInvalidScanfConversionSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_117CheckScanfHandler20HandleScanfSpecifierERKN5clang13analyze_scanf14ScanfSpecifierEPKcj", "(anonymous namespace)::CheckScanfHandler::HandleScanfSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_117CheckScanfHandler24HandleIncompleteScanListEPKcS2_", "(anonymous namespace)::CheckScanfHandler::HandleIncompleteScanList(char const*, char const*)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler12CheckNumArgsERKN5clang21analyze_format_string15FormatSpecifierERKNS2_19ConversionSpecifierEPKcjj", "(anonymous namespace)::CheckFormatHandler::CheckNumArgs(clang::analyze_format_string::FormatSpecifier const&, clang::analyze_format_string::ConversionSpecifier const&, char const*, unsigned int, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandler32HandleInvalidConversionSpecifierEjN5clang14SourceLocationEPKcjS4_j", "(anonymous namespace)::CheckFormatHandler::HandleInvalidConversionSpecifier(unsigned int, clang::SourceLocation, char const*, unsigned int, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandlerD1Ev", "(anonymous namespace)::CheckFormatHandler::~CheckFormatHandler()"},
    {"_ZN12_GLOBAL__N_118CheckFormatHandlerD0Ev", "(anonymous namespace)::CheckFormatHandler::~CheckFormatHandler()"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandlerD0Ev", "(anonymous namespace)::CheckPrintfHandler::~CheckPrintfHandler()"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandler38HandleInvalidPrintfConversionSpecifierERKN5clang14analyze_printf15PrintfSpecifierEPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleInvalidPrintfConversionSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandler21HandlePrintfSpecifierERKN5clang14analyze_printf15PrintfSpecifierEPKcj", "(anonymous namespace)::CheckPrintfHandler::HandlePrintfSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandler12HandleAmountERKN5clang21analyze_format_string14OptionalAmountEjPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleAmount(clang::analyze_format_string::OptionalAmount const&, unsigned int, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandler19HandleInvalidAmountERKN5clang14analyze_printf15PrintfSpecifierERKNS1_21analyze_format_string14OptionalAmountEjPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleInvalidAmount(clang::analyze_printf::PrintfSpecifier const&, clang::analyze_format_string::OptionalAmount const&, unsigned int, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandler10HandleFlagERKN5clang14analyze_printf15PrintfSpecifierERKNS1_21analyze_format_string12OptionalFlagEPKcj", "(anonymous namespace)::CheckPrintfHandler::HandleFlag(clang::analyze_printf::PrintfSpecifier const&, clang::analyze_format_string::OptionalFlag const&, char const*, unsigned int)"},
    {"_ZN12_GLOBAL__N_118CheckPrintfHandler17HandleIgnoredFlagERKN5clang14analyze_printf15PrintfSpecifierERKNS1_21analyze_format_string12OptionalFlagES9_PKcj", "(anonymous namespace)::CheckPrintfHandler::HandleIgnoredFlag(clang::analyze_printf::PrintfSpecifier const&, clang::analyze_format_string::OptionalFlag const&, clang::analyze_format_string::OptionalFlag const&, char const*, unsigned int)"},
    {"_ZNK5clang4Decl7getAttrINS_13FormatArgAttrEEEPT_v", "clang::FormatArgAttr* clang::Decl::getAttr<clang::FormatArgAttr>() const"},
    {"_ZN4llvm11SmallVectorItLj128EEC2EjRKt", "llvm::SmallVector<unsigned short, 128u>::SmallVector(unsigned int, unsigned short const&)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler38HandleInvalidPrintfConversionSpecifierERKNS_14analyze_printf15PrintfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleInvalidPrintfConversionSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler21HandlePrintfSpecifierERKNS_14analyze_printf15PrintfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandlePrintfSpecifier(clang::analyze_printf::PrintfSpecifier const&, char const*, unsigned int)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler37HandleInvalidScanfConversionSpecifierERKNS_13analyze_scanf14ScanfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleInvalidScanfConversionSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler20HandleScanfSpecifierERKNS_13analyze_scanf14ScanfSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleScanfSpecifier(clang::analyze_scanf::ScanfSpecifier const&, char const*, unsigned int)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler24HandleIncompleteScanListEPKcS3_", "clang::analyze_format_string::FormatStringHandler::HandleIncompleteScanList(char const*, char const*)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler14HandleNullCharEPKc", "clang::analyze_format_string::FormatStringHandler::HandleNullChar(char const*)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler21HandleInvalidPositionEPKcjNS0_15PositionContextE", "clang::analyze_format_string::FormatStringHandler::HandleInvalidPosition(char const*, unsigned int, clang::analyze_format_string::PositionContext)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler18HandleZeroPositionEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleZeroPosition(char const*, unsigned int)"},
    {"_ZN5clang21analyze_format_string19FormatStringHandler25HandleIncompleteSpecifierEPKcj", "clang::analyze_format_string::FormatStringHandler::HandleIncompleteSpecifier(char const*, unsigned int)"},
    {"_ZN5clang22getSimplifiedTypeClassENS_7CanQualINS_4TypeEEE", "clang::getSimplifiedTypeClass(clang::CanQual<clang::Type>)"},
    {"_ZN5clang16getDeclUsageTypeERNS_10ASTContextEPNS_9NamedDeclE", "clang::getDeclUsageType(clang::ASTContext&, clang::NamedDecl*)"},
    {"_Z23GetCompletionTypeStringN5clang8QualTypeERNS_10ASTContextERNS_23CodeCompletionAllocatorE", "GetCompletionTypeString(clang::QualType, clang::ASTContext&, clang::CodeCompletionAllocator&)"},
    {"_ZN5clang20CodeCompletionResult26CreateCodeCompletionStringERNS_4SemaERNS_23CodeCompletionAllocatorE", "clang::CodeCompletionResult::CreateCodeCompletionString(clang::Sema&, clang::CodeCompletionAllocator&)"},
    {"_Z18AddResultTypeChunkRN5clang10ASTContextEPNS_9NamedDeclERNS_21CodeCompletionBuilderE", "AddResultTypeChunk(clang::ASTContext&, clang::NamedDecl*, clang::CodeCompletionBuilder&)"},
    {"_Z30AddQualifierToCompletionStringRN5clang21CodeCompletionBuilderEPNS_19NestedNameSpecifierEbRNS_10ASTContextE", "AddQualifierToCompletionString(clang::CodeCompletionBuilder&, clang::NestedNameSpecifier*, bool, clang::ASTContext&)"},
    {"_Z17AddTypedNameChunkRN5clang10ASTContextEPNS_9NamedDeclERNS_21CodeCompletionBuilderE", "AddTypedNameChunk(clang::ASTContext&, clang::NamedDecl*, clang::CodeCompletionBuilder&)"},
    {"_Z26AddFunctionParameterChunksRN5clang10ASTContextEPNS_12FunctionDeclERNS_21CodeCompletionBuilderEjb", "AddFunctionParameterChunks(clang::ASTContext&, clang::FunctionDecl*, clang::CodeCompletionBuilder&, unsigned int, bool)"},
    {"_Z38AddFunctionTypeQualsToCompletionStringRN5clang21CodeCompletionBuilderEPNS_12FunctionDeclE", "AddFunctionTypeQualsToCompletionString(clang::CodeCompletionBuilder&, clang::FunctionDecl*)"},
    {"_Z26AddTemplateParameterChunksRN5clang10ASTContextEPNS_12TemplateDeclERNS_21CodeCompletionBuilderEjjb", "AddTemplateParameterChunks(clang::ASTContext&, clang::TemplateDecl*, clang::CodeCompletionBuilder&, unsigned int, unsigned int, bool)"},
    {"_Z23FormatFunctionParameterRN5clang10ASTContextEPNS_11ParmVarDeclEb", "FormatFunctionParameter(clang::ASTContext&, clang::ParmVarDecl*, bool)"},
    {"_Z16MaybeAddSentinelRN5clang10ASTContextEPNS_9NamedDeclERNS_21CodeCompletionBuilderE", "MaybeAddSentinel(clang::ASTContext&, clang::NamedDecl*, clang::CodeCompletionBuilder&)"},
    {"_ZNK5clang20CodeCompleteConsumer17OverloadCandidate21CreateSignatureStringEjRNS_4SemaERNS_23CodeCompletionAllocatorE", "clang::CodeCompleteConsumer::OverloadCandidate::CreateSignatureString(unsigned int, clang::Sema&, clang::CodeCompletionAllocator&) const"},
    {"_ZN5clang21getMacroUsagePriorityEN4llvm9StringRefERKNS_11LangOptionsEb", "clang::getMacroUsagePriority(llvm::StringRef, clang::LangOptions const&, bool)"},
    {"_ZN5clang20getCursorKindForDeclEPNS_4DeclE", "clang::getCursorKindForDecl(clang::Decl*)"},
    {"_ZN5clang4Sema24CodeCompleteOrdinaryNameEPNS_5ScopeENS0_23ParserCompletionContextE", "clang::Sema::CodeCompleteOrdinaryName(clang::Scope*, clang::Sema::ParserCompletionContext)"},
    {"_ZN12_GLOBAL__N_113ResultBuilder13EnterNewScopeEv", "(anonymous namespace)::ResultBuilder::EnterNewScope()"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder22IsOrdinaryNonValueNameEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsOrdinaryNonValueName(clang::NamedDecl*) const"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder14IsOrdinaryNameEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsOrdinaryName(clang::NamedDecl*) const"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder21IsOrdinaryNonTypeNameEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsOrdinaryNonTypeName(clang::NamedDecl*) const"},
    {"_Z21MaybeAddOverrideCallsRN5clang4SemaEPNS_11DeclContextERN12_GLOBAL__N_113ResultBuilderE", "MaybeAddOverrideCalls(clang::Sema&, clang::DeclContext*, (anonymous namespace)::ResultBuilder&)"},
    {"_Z22AddOrdinaryNameResultsN5clang4Sema23ParserCompletionContextEPNS_5ScopeERS0_RN12_GLOBAL__N_113ResultBuilderE", "AddOrdinaryNameResults(clang::Sema::ParserCompletionContext, clang::Scope*, clang::Sema&, (anonymous namespace)::ResultBuilder&)"},
    {"_ZN12_GLOBAL__N_113ResultBuilder9ExitScopeEv", "(anonymous namespace)::ResultBuilder::ExitScope()"},
    {"_Z24AddPrettyFunctionResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddPrettyFunctionResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"},
    {"_Z15AddMacroResultsRN5clang12PreprocessorERN12_GLOBAL__N_113ResultBuilderEb", "AddMacroResults(clang::Preprocessor&, (anonymous namespace)::ResultBuilder&, bool)"},
    {"_ZN12_GLOBAL__N_126CodeCompletionDeclConsumerD1Ev", "(anonymous namespace)::CodeCompletionDeclConsumer::~CodeCompletionDeclConsumer()"},
    {"_ZN5clang4Sema20CodeCompleteDeclSpecEPNS_5ScopeERNS_8DeclSpecEbb", "clang::Sema::CodeCompleteDeclSpec(clang::Scope*, clang::DeclSpec&, bool, bool)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder21IsImpossibleToSatisfyEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsImpossibleToSatisfy(clang::NamedDecl*) const"},
    {"_Z26AddClassMessageCompletionsRN5clang4SemaEPNS_5ScopeENS_9OpaquePtrINS_8QualTypeEEEPPNS_14IdentifierInfoEjbbRN12_GLOBAL__N_113ResultBuilderE", "AddClassMessageCompletions(clang::Sema&, clang::Scope*, clang::OpaquePtr<clang::QualType>, clang::IdentifierInfo**, unsigned int, bool, bool, (anonymous namespace)::ResultBuilder&)"},
    {"_ZN5clang4Sema22CodeCompleteExpressionEPNS_5ScopeERKNS0_26CodeCompleteExpressionDataE", "clang::Sema::CodeCompleteExpression(clang::Scope*, clang::Sema::CodeCompleteExpressionData const&)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder16IsObjCCollectionEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsObjCCollection(clang::NamedDecl*) const"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder23IsIntegralConstantValueEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsIntegralConstantValue(clang::NamedDecl*) const"},
    {"_ZN5clang4Sema29CodeCompletePostfixExpressionEPNS_5ScopeENS_12ActionResultIPNS_4ExprELb1EEE", "clang::Sema::CodeCompletePostfixExpression(clang::Scope*, clang::ActionResult<clang::Expr*, true>)"},
    {"_ZN5clang4Sema31CodeCompleteObjCInstanceMessageEPNS_5ScopeEPNS_4ExprEPPNS_14IdentifierInfoEjbPNS_17ObjCInterfaceDeclE", "clang::Sema::CodeCompleteObjCInstanceMessage(clang::Scope*, clang::Expr*, clang::IdentifierInfo**, unsigned int, bool, clang::ObjCInterfaceDecl*)"},
    {"_ZN5clang4Sema31CodeCompleteMemberReferenceExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationEb", "clang::Sema::CodeCompleteMemberReferenceExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, bool)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder8IsMemberEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsMember(clang::NamedDecl*) const"},
    {"_Z17AddObjCPropertiesPN5clang17ObjCContainerDeclEbPNS_11DeclContextERN4llvm11SmallPtrSetIPNS_14IdentifierInfoELj16EEERN12_GLOBAL__N_113ResultBuilderE", "AddObjCProperties(clang::ObjCContainerDecl*, bool, clang::DeclContext*, llvm::SmallPtrSet<clang::IdentifierInfo*, 16u>&, (anonymous namespace)::ResultBuilder&)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder10IsObjCIvarEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsObjCIvar(clang::NamedDecl*) const"},
    {"_ZN5clang4Sema15CodeCompleteTagEPNS_5ScopeEj", "clang::Sema::CodeCompleteTag(clang::Scope*, unsigned int)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder6IsEnumEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsEnum(clang::NamedDecl*) const"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder7IsUnionEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsUnion(clang::NamedDecl*) const"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder15IsClassOrStructEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsClassOrStruct(clang::NamedDecl*) const"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder21IsNestedNameSpecifierEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsNestedNameSpecifier(clang::NamedDecl*) const"},
    {"_ZN5clang4Sema26CodeCompleteTypeQualifiersERNS_8DeclSpecE", "clang::Sema::CodeCompleteTypeQualifiers(clang::DeclSpec&)"},
    {"_ZN5clang4Sema16CodeCompleteCaseEPNS_5ScopeE", "clang::Sema::CodeCompleteCase(clang::Scope*)"},
    {"_Z24getRequiredQualificationRN5clang10ASTContextEPNS_11DeclContextES3_", "getRequiredQualification(clang::ASTContext&, clang::DeclContext*, clang::DeclContext*)"},
    {"_ZN12_GLOBAL__N_113ResultBuilder9AddResultEN5clang20CodeCompletionResultEPNS1_11DeclContextEPNS1_9NamedDeclEb", "(anonymous namespace)::ResultBuilder::AddResult(clang::CodeCompletionResult, clang::DeclContext*, clang::NamedDecl*, bool)"},
    {"_ZN5clang4Sema16CodeCompleteCallEPNS_5ScopeEPNS_4ExprEPS4_j", "clang::Sema::CodeCompleteCall(clang::Scope*, clang::Expr*, clang::Expr**, unsigned int)"},
    {"_ZN5clang4Sema23CodeCompleteInitializerEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteInitializer(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema18CodeCompleteReturnEPNS_5ScopeE", "clang::Sema::CodeCompleteReturn(clang::Scope*)"},
    {"_ZN5clang4Sema25CodeCompleteAssignmentRHSEPNS_5ScopeEPNS_4ExprE", "clang::Sema::CodeCompleteAssignmentRHS(clang::Scope*, clang::Expr*)"},
    {"_ZN5clang4Sema23CodeCompleteQualifiedIdEPNS_5ScopeERNS_12CXXScopeSpecEb", "clang::Sema::CodeCompleteQualifiedId(clang::Scope*, clang::CXXScopeSpec&, bool)"},
    {"_ZN5clang4Sema17CodeCompleteUsingEPNS_5ScopeE", "clang::Sema::CodeCompleteUsing(clang::Scope*)"},
    {"_ZN5clang4Sema26CodeCompleteUsingDirectiveEPNS_5ScopeE", "clang::Sema::CodeCompleteUsingDirective(clang::Scope*)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder18IsNamespaceOrAliasEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsNamespaceOrAlias(clang::NamedDecl*) const"},
    {"_ZN5clang4Sema25CodeCompleteNamespaceDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteNamespaceDecl(clang::Scope*)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder11IsNamespaceEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsNamespace(clang::NamedDecl*) const"},
    {"_ZN5clang4Sema30CodeCompleteNamespaceAliasDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteNamespaceAliasDecl(clang::Scope*)"},
    {"_ZN5clang4Sema24CodeCompleteOperatorNameEPNS_5ScopeE", "clang::Sema::CodeCompleteOperatorName(clang::Scope*)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder6IsTypeEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsType(clang::NamedDecl*) const"},
    {"_Z23AddTypeSpecifierResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddTypeSpecifierResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"},
    {"_ZN5clang4Sema34CodeCompleteConstructorInitializerEPNS_4DeclEPPNS_18CXXCtorInitializerEj", "clang::Sema::CodeCompleteConstructorInitializer(clang::Decl*, clang::CXXCtorInitializer**, unsigned int)"},
    {"_ZN5clang4Sema27CodeCompleteObjCAtDirectiveEPNS_5ScopeEPNS_4DeclEb", "clang::Sema::CodeCompleteObjCAtDirective(clang::Scope*, clang::Decl*, bool)"},
    {"_Z28AddObjCImplementationResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderEb", "AddObjCImplementationResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&, bool)"},
    {"_Z23AddObjCInterfaceResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderEb", "AddObjCInterfaceResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&, bool)"},
    {"_Z22AddObjCTopLevelResultsRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCTopLevelResults((anonymous namespace)::ResultBuilder&, bool)"},
    {"_ZN5clang4Sema28CodeCompleteObjCAtVisibilityEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCAtVisibility(clang::Scope*)"},
    {"_Z24AddObjCVisibilityResultsRKN5clang11LangOptionsERN12_GLOBAL__N_113ResultBuilderEb", "AddObjCVisibilityResults(clang::LangOptions const&, (anonymous namespace)::ResultBuilder&, bool)"},
    {"_ZN5clang4Sema27CodeCompleteObjCAtStatementEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCAtStatement(clang::Scope*)"},
    {"_Z23AddObjCStatementResultsRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCStatementResults((anonymous namespace)::ResultBuilder&, bool)"},
    {"_Z24AddObjCExpressionResultsRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCExpressionResults((anonymous namespace)::ResultBuilder&, bool)"},
    {"_ZN5clang4Sema28CodeCompleteObjCAtExpressionEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCAtExpression(clang::Scope*)"},
    {"_ZN5clang4Sema29CodeCompleteObjCPropertyFlagsEPNS_5ScopeERNS_12ObjCDeclSpecE", "clang::Sema::CodeCompleteObjCPropertyFlags(clang::Scope*, clang::ObjCDeclSpec&)"},
    {"_ZN5clang4Sema30CodeCompleteObjCPropertyGetterEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertyGetter(clang::Scope*, clang::Decl*)"},
    {"_Z14AddObjCMethodsPN5clang17ObjCContainerDeclEb14ObjCMethodKindPPNS_14IdentifierInfoEjPNS_11DeclContextERN4llvm11SmallPtrSetINS_8SelectorELj16EEEbRN12_GLOBAL__N_113ResultBuilderEb", "AddObjCMethods(clang::ObjCContainerDecl*, bool, ObjCMethodKind, clang::IdentifierInfo**, unsigned int, clang::DeclContext*, llvm::SmallPtrSet<clang::Selector, 16u>&, bool, (anonymous namespace)::ResultBuilder&, bool)"},
    {"_ZN5clang4Sema30CodeCompleteObjCPropertySetterEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertySetter(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema27CodeCompleteObjCPassingTypeEPNS_5ScopeERNS_12ObjCDeclSpecE", "clang::Sema::CodeCompleteObjCPassingType(clang::Scope*, clang::ObjCDeclSpec&)"},
    {"_ZN5clang4Sema31CodeCompleteObjCMessageReceiverEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCMessageReceiver(clang::Scope*)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder21IsObjCMessageReceiverEPN5clang9NamedDeclE", "(anonymous namespace)::ResultBuilder::IsObjCMessageReceiver(clang::NamedDecl*) const"},
    {"_Z22AddSuperSendCompletionRN5clang4SemaEbPPNS_14IdentifierInfoEjRN12_GLOBAL__N_113ResultBuilderE", "AddSuperSendCompletion(clang::Sema&, bool, clang::IdentifierInfo**, unsigned int, (anonymous namespace)::ResultBuilder&)"},
    {"_ZN5clang4Sema28CodeCompleteObjCSuperMessageEPNS_5ScopeENS_14SourceLocationEPPNS_14IdentifierInfoEjb", "clang::Sema::CodeCompleteObjCSuperMessage(clang::Scope*, clang::SourceLocation, clang::IdentifierInfo**, unsigned int, bool)"},
    {"_ZN5clang4Sema28CodeCompleteObjCClassMessageEPNS_5ScopeENS_9OpaquePtrINS_8QualTypeEEEPPNS_14IdentifierInfoEjbb", "clang::Sema::CodeCompleteObjCClassMessage(clang::Scope*, clang::OpaquePtr<clang::QualType>, clang::IdentifierInfo**, unsigned int, bool, bool)"},
    {"_Z38getPreferredArgumentTypeForMessageSendRN12_GLOBAL__N_113ResultBuilderEj", "getPreferredArgumentTypeForMessageSend((anonymous namespace)::ResultBuilder&, unsigned int)"},
    {"_ZN12_GLOBAL__N_113ResultBuilder14MaybeAddResultEN5clang20CodeCompletionResultEPNS1_11DeclContextE", "(anonymous namespace)::ResultBuilder::MaybeAddResult(clang::CodeCompletionResult, clang::DeclContext*)"},
    {"_ZN5clang4Sema29CodeCompleteObjCForCollectionEPNS_5ScopeENS_9OpaquePtrINS_12DeclGroupRefEEE", "clang::Sema::CodeCompleteObjCForCollection(clang::Scope*, clang::OpaquePtr<clang::DeclGroupRef>)"},
    {"_ZN5clang4Sema24CodeCompleteObjCSelectorEPNS_5ScopeEPPNS_14IdentifierInfoEj", "clang::Sema::CodeCompleteObjCSelector(clang::Scope*, clang::IdentifierInfo**, unsigned int)"},
    {"_Z24isAcceptableObjCSelectorN5clang8SelectorE14ObjCMethodKindPPNS_14IdentifierInfoEjb", "isAcceptableObjCSelector(clang::Selector, ObjCMethodKind, clang::IdentifierInfo**, unsigned int, bool)"},
    {"_ZN5clang4Sema34CodeCompleteObjCProtocolReferencesEPSt4pairIPNS_14IdentifierInfoENS_14SourceLocationEEj", "clang::Sema::CodeCompleteObjCProtocolReferences(std::pair<clang::IdentifierInfo*, clang::SourceLocation>*, unsigned int)"},
    {"_Z18AddProtocolResultsPN5clang11DeclContextES1_bRN12_GLOBAL__N_113ResultBuilderE", "AddProtocolResults(clang::DeclContext*, clang::DeclContext*, bool, (anonymous namespace)::ResultBuilder&)"},
    {"_ZN5clang4Sema28CodeCompleteObjCProtocolDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCProtocolDecl(clang::Scope*)"},
    {"_ZN5clang4Sema29CodeCompleteObjCInterfaceDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCInterfaceDecl(clang::Scope*)"},
    {"_Z19AddInterfaceResultsPN5clang11DeclContextES1_bbRN12_GLOBAL__N_113ResultBuilderE", "AddInterfaceResults(clang::DeclContext*, clang::DeclContext*, bool, bool, (anonymous namespace)::ResultBuilder&)"},
    {"_ZN5clang4Sema26CodeCompleteObjCSuperclassEPNS_5ScopeEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::CodeCompleteObjCSuperclass(clang::Scope*, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema34CodeCompleteObjCImplementationDeclEPNS_5ScopeE", "clang::Sema::CodeCompleteObjCImplementationDecl(clang::Scope*)"},
    {"_ZN5clang4Sema33CodeCompleteObjCInterfaceCategoryEPNS_5ScopeEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::CodeCompleteObjCInterfaceCategory(clang::Scope*, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema38CodeCompleteObjCImplementationCategoryEPNS_5ScopeEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::CodeCompleteObjCImplementationCategory(clang::Scope*, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema34CodeCompleteObjCPropertyDefinitionEPNS_5ScopeEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertyDefinition(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema38CodeCompleteObjCPropertySynthesizeIvarEPNS_5ScopeEPNS_14IdentifierInfoEPNS_4DeclE", "clang::Sema::CodeCompleteObjCPropertySynthesizeIvar(clang::Scope*, clang::IdentifierInfo*, clang::Decl*)"},
    {"_ZN5clang4Sema26CodeCompleteObjCMethodDeclEPNS_5ScopeEbNS_9OpaquePtrINS_8QualTypeEEEPNS_4DeclE", "clang::Sema::CodeCompleteObjCMethodDecl(clang::Scope*, bool, clang::OpaquePtr<clang::QualType>, clang::Decl*)"},
    {"_Z24FindImplementableMethodsRN5clang10ASTContextEPNS_17ObjCContainerDeclEbNS_8QualTypeERN4llvm8DenseMapINS_8SelectorESt4pairIPNS_14ObjCMethodDeclEbENS5_12DenseMapInfoIS7_EENSC_ISB_EEEEb", "FindImplementableMethods(clang::ASTContext&, clang::ObjCContainerDecl*, bool, clang::QualType, llvm::DenseMap<clang::Selector, std::pair<clang::ObjCMethodDecl*, bool>, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<std::pair<clang::ObjCMethodDecl*, bool> > >&, bool)"},
    {"_ZN5clang4Sema34CodeCompleteObjCMethodDeclSelectorEPNS_5ScopeEbbNS_9OpaquePtrINS_8QualTypeEEEPPNS_14IdentifierInfoEj", "clang::Sema::CodeCompleteObjCMethodDeclSelector(clang::Scope*, bool, bool, clang::OpaquePtr<clang::QualType>, clang::IdentifierInfo**, unsigned int)"},
    {"_ZN5clang4Sema33CodeCompletePreprocessorDirectiveEb", "clang::Sema::CodeCompletePreprocessorDirective(bool)"},
    {"_ZN5clang4Sema46CodeCompleteInPreprocessorConditionalExclusionEPNS_5ScopeE", "clang::Sema::CodeCompleteInPreprocessorConditionalExclusion(clang::Scope*)"},
    {"_ZN5clang4Sema33CodeCompletePreprocessorMacroNameEb", "clang::Sema::CodeCompletePreprocessorMacroName(bool)"},
    {"_ZN5clang4Sema34CodeCompletePreprocessorExpressionEv", "clang::Sema::CodeCompletePreprocessorExpression()"},
    {"_ZN5clang4Sema37CodeCompletePreprocessorMacroArgumentEPNS_5ScopeEPNS_14IdentifierInfoEPNS_9MacroInfoEj", "clang::Sema::CodeCompletePreprocessorMacroArgument(clang::Scope*, clang::IdentifierInfo*, clang::MacroInfo*, unsigned int)"},
    {"_ZN5clang4Sema27CodeCompleteNaturalLanguageEv", "clang::Sema::CodeCompleteNaturalLanguage()"},
    {"_ZN5clang4Sema27GatherGlobalCodeCompletionsERNS_23CodeCompletionAllocatorERN4llvm15SmallVectorImplINS_20CodeCompletionResultEEE", "clang::Sema::GatherGlobalCodeCompletions(clang::CodeCompletionAllocator&, llvm::SmallVectorImpl<clang::CodeCompletionResult>&)"},
    {"_ZSt21__inplace_stable_sortIPN5clang17OverloadCandidateEN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_", "void std::__inplace_stable_sort<clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZSt22__stable_sort_adaptiveIPN5clang17OverloadCandidateES2_lN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_T1_T2_", "void std::__stable_sort_adaptive<clang::OverloadCandidate*, clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZSt24__merge_sort_with_bufferIPN5clang17OverloadCandidateES2_N12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_T1_", "void std::__merge_sort_with_buffer<clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZSt16__merge_adaptiveIPN5clang17OverloadCandidateElS2_N12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_S5_T0_S6_T1_S6_T2_", "void std::__merge_adaptive<clang::OverloadCandidate*, long, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, long, clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZSt5mergeIPN5clang17OverloadCandidateES2_S2_N12_GLOBAL__N_125IsBetterOverloadCandidateEET1_T_S6_T0_S7_S5_T2_", "clang::OverloadCandidate* std::merge<clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZSt16__insertion_sortIPN5clang17OverloadCandidateEN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_T0_", "void std::__insertion_sort<clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZSt22__merge_without_bufferIPN5clang17OverloadCandidateElN12_GLOBAL__N_125IsBetterOverloadCandidateEEvT_S5_S5_T0_S6_T1_", "void std::__merge_without_buffer<clang::OverloadCandidate*, long, (anonymous namespace)::IsBetterOverloadCandidate>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, long, (anonymous namespace)::IsBetterOverloadCandidate)"},
    {"_ZNK12_GLOBAL__N_113ResultBuilder17isInterestingDeclEPN5clang9NamedDeclERb", "(anonymous namespace)::ResultBuilder::isInterestingDecl(clang::NamedDecl*, bool&) const"},
    {"_ZN12_GLOBAL__N_113ResultBuilder17CheckHiddenResultERN5clang20CodeCompletionResultEPNS1_11DeclContextEPNS1_9NamedDeclE", "(anonymous namespace)::ResultBuilder::CheckHiddenResult(clang::CodeCompletionResult&, clang::DeclContext*, clang::NamedDecl*)"},
    {"_ZN12_GLOBAL__N_113ResultBuilder27AdjustResultPriorityForDeclERN5clang20CodeCompletionResultE", "(anonymous namespace)::ResultBuilder::AdjustResultPriorityForDecl(clang::CodeCompletionResult&)"},
    {"_ZN12_GLOBAL__N_113ResultBuilder26MaybeAddConstructorResultsEN5clang20CodeCompletionResultE", "(anonymous namespace)::ResultBuilder::MaybeAddConstructorResults(clang::CodeCompletionResult)"},
    {"_ZN12_GLOBAL__N_126CodeCompletionDeclConsumerD0Ev", "(anonymous namespace)::CodeCompletionDeclConsumer::~CodeCompletionDeclConsumer()"},
    {"_ZN12_GLOBAL__N_126CodeCompletionDeclConsumer9FoundDeclEPN5clang9NamedDeclES3_b", "(anonymous namespace)::CodeCompletionDeclConsumer::FoundDecl(clang::NamedDecl*, clang::NamedDecl*, bool)"},
    {"_Z16AddTypedefResultRN12_GLOBAL__N_113ResultBuilderE", "AddTypedefResult((anonymous namespace)::ResultBuilder&)"},
    {"_Z20AddStorageSpecifiersN5clang4Sema23ParserCompletionContextERKNS_11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddStorageSpecifiers(clang::Sema::ParserCompletionContext, clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"},
    {"_Z21AddFunctionSpecifiersN5clang4Sema23ParserCompletionContextERKNS_11LangOptionsERN12_GLOBAL__N_113ResultBuilderE", "AddFunctionSpecifiers(clang::Sema::ParserCompletionContext, clang::LangOptions const&, (anonymous namespace)::ResultBuilder&)"},
    {"_ZNSt8_Rb_treeIPN5clang13NamespaceDeclESt4pairIKS2_S2_ESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS5_ERKS5_", "std::_Rb_tree<clang::NamespaceDecl*, std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*>, std::_Select1st<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> >, std::less<clang::NamespaceDecl*>, std::allocator<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> >, std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> const&)"},
    {"_ZNSt8_Rb_treeIPN5clang13NamespaceDeclESt4pairIKS2_S2_ESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE16_M_insert_uniqueERKS5_", "std::_Rb_tree<clang::NamespaceDecl*, std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*>, std::_Select1st<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> >, std::less<clang::NamespaceDecl*>, std::allocator<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> > >::_M_insert_unique(std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> const&)"},
    {"_ZNSt17_Temporary_bufferIPN5clang17OverloadCandidateES1_ED2Ev", "std::_Temporary_buffer<clang::OverloadCandidate*, clang::OverloadCandidate>::~_Temporary_buffer()"},
    {"_ZSt17__rotate_adaptiveIPN5clang17OverloadCandidateES2_lET_S3_S3_S3_T1_S4_T0_S4_", "clang::OverloadCandidate* std::__rotate_adaptive<clang::OverloadCandidate*, clang::OverloadCandidate*, long>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, long, long, clang::OverloadCandidate*, long)"},
    {"_ZSt8__rotateIPN5clang17OverloadCandidateEEvT_S3_S3_St26random_access_iterator_tag", "void std::__rotate<clang::OverloadCandidate*>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*, std::random_access_iterator_tag)"},
    {"_ZN4llvm15SmallVectorImplIN5clang26ImplicitConversionSequenceEEaSERKS3_", "llvm::SmallVectorImpl<clang::ImplicitConversionSequence>::operator=(llvm::SmallVectorImpl<clang::ImplicitConversionSequence> const&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang26ImplicitConversionSequenceELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::ImplicitConversionSequence, false>::grow(unsigned long)"},
    {"_ZSt4swapIN5clang17OverloadCandidateEEvRT_S3_", "void std::swap<clang::OverloadCandidate>(clang::OverloadCandidate&, clang::OverloadCandidate&)"},
    {"_ZNSt15__copy_backwardILb0ESt26random_access_iterator_tagE8__copy_bIPN5clang17OverloadCandidateES5_EET0_T_S7_S6_", "clang::OverloadCandidate* std::__copy_backward<false, std::random_access_iterator_tag>::__copy_b<clang::OverloadCandidate*, clang::OverloadCandidate*>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*)"},
    {"_ZNSt6__copyILb0ESt26random_access_iterator_tagE4copyIPN5clang17OverloadCandidateES5_EET0_T_S7_S6_", "clang::OverloadCandidate* std::__copy<false, std::random_access_iterator_tag>::copy<clang::OverloadCandidate*, clang::OverloadCandidate*>(clang::OverloadCandidate*, clang::OverloadCandidate*, clang::OverloadCandidate*)"},
    {"_ZSt26__uninitialized_fill_n_auxIPN5clang17OverloadCandidateElS1_EvT_T0_RKT1_St12__false_type", "void std::__uninitialized_fill_n_aux<clang::OverloadCandidate*, long, clang::OverloadCandidate>(clang::OverloadCandidate*, long, clang::OverloadCandidate const&, std::__false_type)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang20CodeCompleteConsumer17OverloadCandidateELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::CodeCompleteConsumer::OverloadCandidate, false>::grow(unsigned long)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorESt4pairIPNS1_14ObjCMethodDeclEbENS_12DenseMapInfoIS2_EENS7_IS6_EEE16InsertIntoBucketERKS2_RKS6_PS3_IS2_S6_E", "llvm::DenseMap<clang::Selector, std::pair<clang::ObjCMethodDecl*, bool>, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<std::pair<clang::ObjCMethodDecl*, bool> > >::InsertIntoBucket(clang::Selector const&, std::pair<clang::ObjCMethodDecl*, bool> const&, std::pair<clang::Selector, std::pair<clang::ObjCMethodDecl*, bool> >*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorESt4pairIPNS1_14ObjCMethodDeclEbENS_12DenseMapInfoIS2_EENS7_IS6_EEE4growEj", "llvm::DenseMap<clang::Selector, std::pair<clang::ObjCMethodDecl*, bool>, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<std::pair<clang::ObjCMethodDecl*, bool> > >::grow(unsigned int)"},
    {"_ZNSt6vectorIN5clang20CodeCompletionResultESaIS1_EE13_M_insert_auxEN9__gnu_cxx17__normal_iteratorIPS1_S3_EERKS1_", "std::vector<clang::CodeCompletionResult, std::allocator<clang::CodeCompletionResult> >::_M_insert_aux(__gnu_cxx::__normal_iterator<clang::CodeCompletionResult*, std::vector<clang::CodeCompletionResult, std::allocator<clang::CodeCompletionResult> > >, clang::CodeCompletionResult const&)"},
    {"_ZNSt8_Rb_treeIPN5clang13NamespaceDeclESt4pairIKS2_S2_ESt10_Select1stIS5_ESt4lessIS2_ESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<clang::NamespaceDecl*, std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*>, std::_Select1st<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> >, std::less<clang::NamespaceDecl*>, std::allocator<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::NamespaceDecl* const, clang::NamespaceDecl*> >*)"},
    {"_ZN4llvm15SmallVectorImplIN5clang17OverloadCandidateEED2Ev", "llvm::SmallVectorImpl<clang::OverloadCandidate>::~SmallVectorImpl()"},
    {"_ZNK5clang4Decl7getAttrINS_12SentinelAttrEEEPT_v", "clang::SentinelAttr* clang::Decl::getAttr<clang::SentinelAttr>() const"},
    {"_ZN5clang4Sema22ConvertDeclToDeclGroupEPNS_4DeclE", "clang::Sema::ConvertDeclToDeclGroup(clang::Decl*)"},
    {"_ZN5clang4Sema11getTypeNameERNS_14IdentifierInfoENS_14SourceLocationEPNS_5ScopeEPNS_12CXXScopeSpecEbbNS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::getTypeName(clang::IdentifierInfo&, clang::SourceLocation, clang::Scope*, clang::CXXScopeSpec*, bool, bool, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang4Sema9isTagNameERNS_14IdentifierInfoEPNS_5ScopeE", "clang::Sema::isTagName(clang::IdentifierInfo&, clang::Scope*)"},
    {"_ZN5clang4Sema23DiagnoseUnknownTypeNameERKNS_14IdentifierInfoENS_14SourceLocationEPNS_5ScopeEPNS_12CXXScopeSpecERNS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::DiagnoseUnknownTypeName(clang::IdentifierInfo const&, clang::SourceLocation, clang::Scope*, clang::CXXScopeSpec*, clang::OpaquePtr<clang::QualType>&)"},
    {"_ZN5clang4Sema15getContainingDCEPNS_11DeclContextE", "clang::Sema::getContainingDC(clang::DeclContext*)"},
    {"_ZN5clang4Sema15PushDeclContextEPNS_5ScopeEPNS_11DeclContextE", "clang::Sema::PushDeclContext(clang::Scope*, clang::DeclContext*)"},
    {"_ZN5clang4Sema14PopDeclContextEv", "clang::Sema::PopDeclContext()"},
    {"_ZN5clang4Sema22EnterDeclaratorContextEPNS_5ScopeEPNS_11DeclContextE", "clang::Sema::EnterDeclaratorContext(clang::Scope*, clang::DeclContext*)"},
    {"_ZN5clang4Sema21ExitDeclaratorContextEPNS_5ScopeE", "clang::Sema::ExitDeclaratorContext(clang::Scope*)"},
    {"_ZN5clang4Sema17PushOnScopeChainsEPNS_9NamedDeclEPNS_5ScopeEb", "clang::Sema::PushOnScopeChains(clang::NamedDecl*, clang::Scope*, bool)"},
    {"_ZN5clang4Sema13isDeclInScopeERPNS_9NamedDeclEPNS_11DeclContextEPNS_5ScopeE", "clang::Sema::isDeclInScope(clang::NamedDecl*&, clang::DeclContext*, clang::Scope*)"},
    {"_ZN5clang4Sema22getScopeForDeclContextEPNS_5ScopeEPNS_11DeclContextE", "clang::Sema::getScopeForDeclContext(clang::Scope*, clang::DeclContext*)"},
    {"_ZNK5clang4Sema32ShouldWarnIfUnusedFileScopedDeclEPKNS_14DeclaratorDeclE", "clang::Sema::ShouldWarnIfUnusedFileScopedDecl(clang::DeclaratorDecl const*) const"},
    {"_ZN5clang4Sema24MarkUnusedFileScopedDeclEPKNS_14DeclaratorDeclE", "clang::Sema::MarkUnusedFileScopedDecl(clang::DeclaratorDecl const*)"},
    {"_ZN5clang4Sema18DiagnoseUnusedDeclEPKNS_9NamedDeclE", "clang::Sema::DiagnoseUnusedDecl(clang::NamedDecl const*)"},
    {"_ZN5clang4Sema13ActOnPopScopeENS_14SourceLocationEPNS_5ScopeE", "clang::Sema::ActOnPopScope(clang::SourceLocation, clang::Scope*)"},
    {"_ZN5clang4Sema20getObjCInterfaceDeclERPNS_14IdentifierInfoENS_14SourceLocationEb", "clang::Sema::getObjCInterfaceDecl(clang::IdentifierInfo*&, clang::SourceLocation, bool)"},
    {"_ZN5clang4Sema20getNonFieldDeclScopeEPNS_5ScopeE", "clang::Sema::getNonFieldDeclScope(clang::Scope*)"},
    {"_ZN5clang4Sema19LazilyCreateBuiltinEPNS_14IdentifierInfoEjPNS_5ScopeEbNS_14SourceLocationE", "clang::Sema::LazilyCreateBuiltin(clang::IdentifierInfo*, unsigned int, clang::Scope*, bool, clang::SourceLocation)"},
    {"_ZN5clang4Sema26AddKnownFunctionAttributesEPNS_12FunctionDeclE", "clang::Sema::AddKnownFunctionAttributes(clang::FunctionDecl*)"},
    {"_ZN5clang4Sema16MergeTypeDefDeclEPNS_11TypedefDeclERNS_12LookupResultE", "clang::Sema::MergeTypeDefDecl(clang::TypedefDecl*, clang::LookupResult&)"},
    {"_ZN5clang4Sema16getSpecialMemberEPKNS_13CXXMethodDeclE", "clang::Sema::getSpecialMember(clang::CXXMethodDecl const*)"},
    {"_ZN5clang4Sema17MergeFunctionDeclEPNS_12FunctionDeclEPNS_4DeclE", "clang::Sema::MergeFunctionDecl(clang::FunctionDecl*, clang::Decl*)"},
    {"_ZN5clang4Sema28MergeCompatibleFunctionDeclsEPNS_12FunctionDeclES2_", "clang::Sema::MergeCompatibleFunctionDecls(clang::FunctionDecl*, clang::FunctionDecl*)"},
    {"_Z19MergeDeclAttributesPN5clang4DeclES1_RNS_10ASTContextE", "MergeDeclAttributes(clang::Decl*, clang::Decl*, clang::ASTContext&)"},
    {"_ZN5clang4Sema12MergeVarDeclEPNS_7VarDeclERNS_12LookupResultE", "clang::Sema::MergeVarDecl(clang::VarDecl*, clang::LookupResult&)"},
    {"_ZN5clang4Sema26ParsedFreeStandingDeclSpecEPNS_5ScopeENS_15AccessSpecifierERNS_8DeclSpecE", "clang::Sema::ParsedFreeStandingDeclSpec(clang::Scope*, clang::AccessSpecifier, clang::DeclSpec&)"},
    {"_ZN5clang4Sema27BuildAnonymousStructOrUnionEPNS_5ScopeERNS_8DeclSpecENS_15AccessSpecifierEPNS_10RecordDeclE", "clang::Sema::BuildAnonymousStructOrUnion(clang::Scope*, clang::DeclSpec&, clang::AccessSpecifier, clang::RecordDecl*)"},
    {"_ZN5clang4Sema30BuildMicrosoftCAnonymousStructEPNS_5ScopeERNS_8DeclSpecEPNS_10RecordDeclE", "clang::Sema::BuildMicrosoftCAnonymousStruct(clang::Scope*, clang::DeclSpec&, clang::RecordDecl*)"},
    {"_ZN5clang4Sema12ActOnVlaStmtERKNS_8DeclSpecE", "clang::Sema::ActOnVlaStmt(clang::DeclSpec const&)"},
    {"_ZN5clang4Sema20CheckNontrivialFieldEPNS_9FieldDeclE", "clang::Sema::CheckNontrivialField(clang::FieldDecl*)"},
    {"_Z35InjectAnonymousStructOrUnionMembersRN5clang4SemaEPNS_5ScopeEPNS_11DeclContextEPNS_10RecordDeclENS_15AccessSpecifierERN4llvm11SmallVectorIPNS_9NamedDeclELj2EEEb", "InjectAnonymousStructOrUnionMembers(clang::Sema&, clang::Scope*, clang::DeclContext*, clang::RecordDecl*, clang::AccessSpecifier, llvm::SmallVector<clang::NamedDecl*, 2u>&, bool)"},
    {"_ZN5clang4Sema20GetNameForDeclaratorERNS_10DeclaratorE", "clang::Sema::GetNameForDeclarator(clang::Declarator&)"},
    {"_ZN5clang4Sema24GetNameFromUnqualifiedIdERKNS_13UnqualifiedIdE", "clang::Sema::GetNameFromUnqualifiedId(clang::UnqualifiedId const&)"},
    {"_ZN5clang4Sema15ActOnDeclaratorEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnDeclarator(clang::Scope*, clang::Declarator&)"},
    {"_ZN5clang4Sema16HandleDeclaratorEPNS_5ScopeERNS_10DeclaratorENS_11ASTMultiPtrIPNS_21TemplateParameterListEEEb", "clang::Sema::HandleDeclarator(clang::Scope*, clang::Declarator&, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool)"},
    {"_ZN5clang4Sema22ActOnTypedefDeclaratorEPNS_5ScopeERNS_10DeclaratorEPNS_11DeclContextENS_8QualTypeEPNS_14TypeSourceInfoERNS_12LookupResultERb", "clang::Sema::ActOnTypedefDeclarator(clang::Scope*, clang::Declarator&, clang::DeclContext*, clang::QualType, clang::TypeSourceInfo*, clang::LookupResult&, bool&)"},
    {"_ZN5clang4Sema23ActOnFunctionDeclaratorEPNS_5ScopeERNS_10DeclaratorEPNS_11DeclContextENS_8QualTypeEPNS_14TypeSourceInfoERNS_12LookupResultENS_11ASTMultiPtrIPNS_21TemplateParameterListEEEbRb", "clang::Sema::ActOnFunctionDeclarator(clang::Scope*, clang::Declarator&, clang::DeclContext*, clang::QualType, clang::TypeSourceInfo*, clang::LookupResult&, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool, bool&)"},
    {"_ZN5clang4Sema23ActOnVariableDeclaratorEPNS_5ScopeERNS_10DeclaratorEPNS_11DeclContextENS_8QualTypeEPNS_14TypeSourceInfoERNS_12LookupResultENS_11ASTMultiPtrIPNS_21TemplateParameterListEEERb", "clang::Sema::ActOnVariableDeclarator(clang::Scope*, clang::Declarator&, clang::DeclContext*, clang::QualType, clang::TypeSourceInfo*, clang::LookupResult&, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool&)"},
    {"_ZN5clang4Sema32RegisterLocallyScopedExternCDeclEPNS_9NamedDeclERKNS_12LookupResultEPNS_5ScopeE", "clang::Sema::RegisterLocallyScopedExternCDecl(clang::NamedDecl*, clang::LookupResult const&, clang::Scope*)"},
    {"_ZN5clang4Sema26DiagnoseFunctionSpecifiersERNS_10DeclaratorE", "clang::Sema::DiagnoseFunctionSpecifiers(clang::Declarator&)"},
    {"_ZN5clang4Sema16ParseTypedefDeclEPNS_5ScopeERNS_10DeclaratorENS_8QualTypeEPNS_14TypeSourceInfoE", "clang::Sema::ParseTypedefDecl(clang::Scope*, clang::Declarator&, clang::QualType, clang::TypeSourceInfo*)"},
    {"_Z35TryToFixInvalidVariablyModifiedTypeN5clang8QualTypeERNS_10ASTContextERbRN4llvm6APSIntE", "TryToFixInvalidVariablyModifiedType(clang::QualType, clang::ASTContext&, bool&, llvm::APSInt&)"},
    {"_Z20FilterLookupForScopeRN5clang4SemaERNS_12LookupResultEPNS_11DeclContextEPNS_5ScopeEb", "FilterLookupForScope(clang::Sema&, clang::LookupResult&, clang::DeclContext*, clang::Scope*, bool)"},
    {"_ZN5clang4Sema11CheckShadowEPNS_5ScopeEPNS_7VarDeclERKNS_12LookupResultE", "clang::Sema::CheckShadow(clang::Scope*, clang::VarDecl*, clang::LookupResult const&)"},
    {"_ZN5clang4Sema24CheckVariableDeclarationEPNS_7VarDeclERNS_12LookupResultERb", "clang::Sema::CheckVariableDeclaration(clang::VarDecl*, clang::LookupResult&, bool&)"},
    {"_ZN5clang4Sema11CheckShadowEPNS_5ScopeEPNS_7VarDeclE", "clang::Sema::CheckShadow(clang::Scope*, clang::VarDecl*)"},
    {"_ZN5clang4Sema20AddOverriddenMethodsEPNS_13CXXRecordDeclEPNS_13CXXMethodDeclE", "clang::Sema::AddOverriddenMethods(clang::CXXRecordDecl*, clang::CXXMethodDecl*)"},
    {"_Z20FindOverriddenMethodPKN5clang16CXXBaseSpecifierERNS_11CXXBasePathEPv", "FindOverriddenMethod(clang::CXXBaseSpecifier const*, clang::CXXBasePath&, void*)"},
    {"_ZN5clang4Sema26BuildParmVarDeclForTypedefEPNS_11DeclContextENS_14SourceLocationENS_8QualTypeE", "clang::Sema::BuildParmVarDeclForTypedef(clang::DeclContext*, clang::SourceLocation, clang::QualType)"},
    {"_ZN5clang4Sema24CheckFunctionDeclarationEPNS_5ScopeEPNS_12FunctionDeclERNS_12LookupResultEbRb", "clang::Sema::CheckFunctionDeclaration(clang::Scope*, clang::FunctionDecl*, clang::LookupResult&, bool, bool&)"},
    {"_Z28DiagnoseInvalidRedeclarationRN5clang4SemaEPNS_12FunctionDeclE", "DiagnoseInvalidRedeclaration(clang::Sema&, clang::FunctionDecl*)"},
    {"_ZN5clang4Sema9CheckMainEPNS_12FunctionDeclE", "clang::Sema::CheckMain(clang::FunctionDecl*)"},
    {"_ZN5clang4Sema27CheckForConstantInitializerEPNS_4ExprENS_8QualTypeE", "clang::Sema::CheckForConstantInitializer(clang::Expr*, clang::QualType)"},
    {"_ZN5clang4Sema20AddInitializerToDeclEPNS_4DeclEPNS_4ExprE", "clang::Sema::AddInitializerToDecl(clang::Decl*, clang::Expr*)"},
    {"_ZN5clang4Sema20AddInitializerToDeclEPNS_4DeclEPNS_4ExprEb", "clang::Sema::AddInitializerToDecl(clang::Decl*, clang::Expr*, bool)"},
    {"_ZN5clang4Sema32CheckCompleteVariableDeclarationEPNS_7VarDeclE", "clang::Sema::CheckCompleteVariableDeclaration(clang::VarDecl*)"},
    {"_ZN5clang4Sema21ActOnInitializerErrorEPNS_4DeclE", "clang::Sema::ActOnInitializerError(clang::Decl*)"},
    {"_ZN5clang4Sema22ActOnUninitializedDeclEPNS_4DeclEb", "clang::Sema::ActOnUninitializedDecl(clang::Decl*, bool)"},
    {"_ZN5clang4Sema23FinalizeDeclaratorGroupEPNS_5ScopeERKNS_8DeclSpecEPPNS_4DeclEj", "clang::Sema::FinalizeDeclaratorGroup(clang::Scope*, clang::DeclSpec const&, clang::Decl**, unsigned int)"},
    {"_ZN5clang4Sema20ActOnParamDeclaratorEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnParamDeclarator(clang::Scope*, clang::Declarator&)"},
    {"_ZN5clang4Sema14CheckParameterEPNS_11DeclContextEPNS_14TypeSourceInfoENS_8QualTypeEPNS_14IdentifierInfoENS_14SourceLocationENS_12StorageClassES9_", "clang::Sema::CheckParameter(clang::DeclContext*, clang::TypeSourceInfo*, clang::QualType, clang::IdentifierInfo*, clang::SourceLocation, clang::StorageClass, clang::StorageClass)"},
    {"_ZN5clang4Sema24DiagnoseUnusedParametersEPKPNS_11ParmVarDeclES4_", "clang::Sema::DiagnoseUnusedParameters(clang::ParmVarDecl* const*, clang::ParmVarDecl* const*)"},
    {"_ZN5clang4Sema38DiagnoseSizeOfParametersAndReturnValueEPKPNS_11ParmVarDeclES4_NS_8QualTypeEPNS_9NamedDeclE", "clang::Sema::DiagnoseSizeOfParametersAndReturnValue(clang::ParmVarDecl* const*, clang::ParmVarDecl* const*, clang::QualType, clang::NamedDecl*)"},
    {"_ZN5clang4Sema31ActOnFinishKNRParamDeclarationsEPNS_5ScopeERNS_10DeclaratorENS_14SourceLocationE", "clang::Sema::ActOnFinishKNRParamDeclarations(clang::Scope*, clang::Declarator&, clang::SourceLocation)"},
    {"_ZN5clang4Sema23ActOnStartOfFunctionDefEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnStartOfFunctionDef(clang::Scope*, clang::Declarator&)"},
    {"_ZN5clang4Sema23ActOnStartOfFunctionDefEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartOfFunctionDef(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema23ActOnFinishFunctionBodyEPNS_4DeclEPNS_4StmtE", "clang::Sema::ActOnFinishFunctionBody(clang::Decl*, clang::Stmt*)"},
    {"_ZN5clang4Sema23ActOnFinishFunctionBodyEPNS_4DeclEPNS_4StmtEb", "clang::Sema::ActOnFinishFunctionBody(clang::Decl*, clang::Stmt*, bool)"},
    {"_ZN5clang4Sema24ImplicitlyDefineFunctionENS_14SourceLocationERNS_14IdentifierInfoEPNS_5ScopeE", "clang::Sema::ImplicitlyDefineFunction(clang::SourceLocation, clang::IdentifierInfo&, clang::Scope*)"},
    {"_ZN5clang4Sema28isAcceptableTagRedeclarationEPKNS_7TagDeclENS_11TagTypeKindENS_14SourceLocationERKNS_14IdentifierInfoE", "clang::Sema::isAcceptableTagRedeclaration(clang::TagDecl const*, clang::TagTypeKind, clang::SourceLocation, clang::IdentifierInfo const&)"},
    {"_ZN5clang4Sema8ActOnTagEPNS_5ScopeEjNS0_10TagUseKindENS_14SourceLocationERNS_12CXXScopeSpecEPNS_14IdentifierInfoES4_PNS_13AttributeListENS_15AccessSpecifierENS_11ASTMultiPtrIPNS_21TemplateParameterListEEERbSG_bbNS_12ActionResultINS_9OpaquePtrINS_8QualTypeEEELb0EEE", "clang::Sema::ActOnTag(clang::Scope*, unsigned int, clang::Sema::TagUseKind, clang::SourceLocation, clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::SourceLocation, clang::AttributeList*, clang::AccessSpecifier, clang::ASTMultiPtr<clang::TemplateParameterList*>, bool&, bool&, bool, bool, clang::ActionResult<clang::OpaquePtr<clang::QualType>, false>)"},
    {"_ZN5clang4Sema23ActOnTagStartDefinitionEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnTagStartDefinition(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema31ActOnStartCXXMemberDeclarationsEPNS_5ScopeEPNS_4DeclERNS_19ClassVirtSpecifiersENS_14SourceLocationE", "clang::Sema::ActOnStartCXXMemberDeclarations(clang::Scope*, clang::Decl*, clang::ClassVirtSpecifiers&, clang::SourceLocation)"},
    {"_ZN5clang4Sema24ActOnTagFinishDefinitionEPNS_5ScopeEPNS_4DeclENS_14SourceLocationE", "clang::Sema::ActOnTagFinishDefinition(clang::Scope*, clang::Decl*, clang::SourceLocation)"},
    {"_ZN5clang4Sema23ActOnTagDefinitionErrorEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnTagDefinitionError(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema14VerifyBitFieldENS_14SourceLocationEPNS_14IdentifierInfoENS_8QualTypeEPKNS_4ExprEPb", "clang::Sema::VerifyBitField(clang::SourceLocation, clang::IdentifierInfo*, clang::QualType, clang::Expr const*, bool*)"},
    {"_ZN5clang4Sema10ActOnFieldEPNS_5ScopeEPNS_4DeclENS_14SourceLocationERNS_10DeclaratorEPNS_4ExprE", "clang::Sema::ActOnField(clang::Scope*, clang::Decl*, clang::SourceLocation, clang::Declarator&, clang::Expr*)"},
    {"_ZN5clang4Sema11HandleFieldEPNS_5ScopeEPNS_10RecordDeclENS_14SourceLocationERNS_10DeclaratorEPNS_4ExprENS_15AccessSpecifierE", "clang::Sema::HandleField(clang::Scope*, clang::RecordDecl*, clang::SourceLocation, clang::Declarator&, clang::Expr*, clang::AccessSpecifier)"},
    {"_ZN5clang4Sema14CheckFieldDeclENS_15DeclarationNameENS_8QualTypeEPNS_14TypeSourceInfoEPNS_10RecordDeclENS_14SourceLocationEbPNS_4ExprES7_NS_15AccessSpecifierEPNS_9NamedDeclEPNS_10DeclaratorE", "clang::Sema::CheckFieldDecl(clang::DeclarationName, clang::QualType, clang::TypeSourceInfo*, clang::RecordDecl*, clang::SourceLocation, bool, clang::Expr*, clang::SourceLocation, clang::AccessSpecifier, clang::NamedDecl*, clang::Declarator*)"},
    {"_ZN5clang4Sema18DiagnoseNontrivialEPKNS_10RecordTypeENS0_16CXXSpecialMemberE", "clang::Sema::DiagnoseNontrivial(clang::RecordType const*, clang::Sema::CXXSpecialMember)"},
    {"_ZN5clang4Sema9ActOnIvarEPNS_5ScopeENS_14SourceLocationEPNS_4DeclERNS_10DeclaratorEPNS_4ExprENS_3tok15ObjCKeywordKindE", "clang::Sema::ActOnIvar(clang::Scope*, clang::SourceLocation, clang::Decl*, clang::Declarator&, clang::Expr*, clang::tok::ObjCKeywordKind)"},
    {"_ZN5clang4Sema17ActOnLastBitfieldENS_14SourceLocationEPNS_4DeclERN4llvm15SmallVectorImplIS3_EE", "clang::Sema::ActOnLastBitfield(clang::SourceLocation, clang::Decl*, llvm::SmallVectorImpl<clang::Decl*>&)"},
    {"_ZN5clang4Sema11ActOnFieldsEPNS_5ScopeENS_14SourceLocationEPNS_4DeclEPS5_jS3_S3_PNS_13AttributeListE", "clang::Sema::ActOnFields(clang::Scope*, clang::SourceLocation, clang::Decl*, clang::Decl**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::AttributeList*)"},
    {"_ZN5clang4Sema17CheckEnumConstantEPNS_8EnumDeclEPNS_16EnumConstantDeclENS_14SourceLocationEPNS_14IdentifierInfoEPNS_4ExprE", "clang::Sema::CheckEnumConstant(clang::EnumDecl*, clang::EnumConstantDecl*, clang::SourceLocation, clang::IdentifierInfo*, clang::Expr*)"},
    {"_Z27isRepresentableIntegerValueRN5clang10ASTContextERN4llvm6APSIntENS_8QualTypeE", "isRepresentableIntegerValue(clang::ASTContext&, llvm::APSInt&, clang::QualType)"},
    {"_ZN5clang4Sema17ActOnEnumConstantEPNS_5ScopeEPNS_4DeclES4_NS_14SourceLocationEPNS_14IdentifierInfoEPNS_13AttributeListES5_PNS_4ExprE", "clang::Sema::ActOnEnumConstant(clang::Scope*, clang::Decl*, clang::Decl*, clang::SourceLocation, clang::IdentifierInfo*, clang::AttributeList*, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema13ActOnEnumBodyENS_14SourceLocationES1_S1_PNS_4DeclEPS3_jPNS_5ScopeEPNS_13AttributeListE", "clang::Sema::ActOnEnumBody(clang::SourceLocation, clang::SourceLocation, clang::SourceLocation, clang::Decl*, clang::Decl**, unsigned int, clang::Scope*, clang::AttributeList*)"},
    {"_ZN5clang4Sema21ActOnFileScopeAsmDeclENS_14SourceLocationEPNS_4ExprE", "clang::Sema::ActOnFileScopeAsmDecl(clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema17ActOnPragmaWeakIDEPNS_14IdentifierInfoENS_14SourceLocationES3_", "clang::Sema::ActOnPragmaWeakID(clang::IdentifierInfo*, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang4Sema20ActOnPragmaWeakAliasEPNS_14IdentifierInfoES2_NS_14SourceLocationES3_S3_", "clang::Sema::ActOnPragmaWeakAlias(clang::IdentifierInfo*, clang::IdentifierInfo*, clang::SourceLocation, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang12RedeclarableINS_11TypedefDeclEE22setPreviousDeclarationEPS1_", "clang::Redeclarable<clang::TypedefDecl>::setPreviousDeclaration(clang::TypedefDecl*)"},
    {"_ZN5clang12RedeclarableINS_7VarDeclEE22setPreviousDeclarationEPS1_", "clang::Redeclarable<clang::VarDecl>::setPreviousDeclaration(clang::VarDecl*)"},
    {"_ZNK5clang4Decl7getAttrINS_13DLLImportAttrEEEPT_v", "clang::DLLImportAttr* clang::Decl::getAttr<clang::DLLImportAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_13DLLExportAttrEEEPT_v", "clang::DLLExportAttr* clang::Decl::getAttr<clang::DLLExportAttr>() const"},
    {"_ZNK5clang4Decl7getAttrINS_10FormatAttrEEEPT_v", "clang::FormatAttr* clang::Decl::getAttr<clang::FormatAttr>() const"},
    {"_ZNK5clang13CXXRecordDecl25hasTrivialCopyConstructorEv", "clang::CXXRecordDecl::hasTrivialCopyConstructor() const"},
    {"_ZNK5clang13CXXRecordDecl21hasTrivialConstructorEv", "clang::CXXRecordDecl::hasTrivialConstructor() const"},
    {"_ZNK5clang13CXXRecordDecl24hasTrivialCopyAssignmentEv", "clang::CXXRecordDecl::hasTrivialCopyAssignment() const"},
    {"_ZNK5clang13CXXRecordDecl20hasTrivialDestructorEv", "clang::CXXRecordDecl::hasTrivialDestructor() const"},
    {"_ZNK5clang4Decl7getAttrINS_10PackedAttrEEEPT_v", "clang::PackedAttr* clang::Decl::getAttr<clang::PackedAttr>() const"},
    {"_ZNK4llvm6APSInt10extOrTruncEj", "llvm::APSInt::extOrTrunc(unsigned int) const"},
    {"_ZN4llvm15SmallVectorImplIPN5clang9FieldDeclEE6resizeEj", "llvm::SmallVectorImpl<clang::FieldDecl*>::resize(unsigned int)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang15DeclaratorChunkELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::DeclaratorChunk, false>::grow(unsigned long)"},
    {"_ZN5clang12CXXBasePathsD2Ev", "clang::CXXBasePaths::~CXXBasePaths()"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_S2_IbjEESt10_Select1stIS5_ENS0_16QualTypeOrderingESaIS5_EE8_M_eraseEPSt13_Rb_tree_nodeIS5_E", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, std::pair<bool, unsigned int> >, std::_Select1st<std::pair<clang::QualType const, std::pair<bool, unsigned int> > >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, std::pair<bool, unsigned int> > > >::_M_erase(std::_Rb_tree_node<std::pair<clang::QualType const, std::pair<bool, unsigned int> > >*)"},
    {"_ZN5clang12LookupResult22resolveKindAfterFilterEv", "clang::LookupResult::resolveKindAfterFilter()"},
    {"_ZN5clang10Declarator5clearEv", "clang::Declarator::clear()"},
    {"_ZN4llvm15SmallVectorImplIPN5clang9NamedDeclEE6resizeEj", "llvm::SmallVectorImpl<clang::NamedDecl*>::resize(unsigned int)"},
    {"_ZN5clang4Sema17CheckNoReturnAttrERKNS_13AttributeListE", "clang::Sema::CheckNoReturnAttr(clang::AttributeList const&)"},
    {"_ZN5clang4Sema14AddAlignedAttrENS_14SourceLocationEPNS_4DeclEPNS_4ExprE", "clang::Sema::AddAlignedAttr(clang::SourceLocation, clang::Decl*, clang::Expr*)"},
    {"_ZN5clang4Sema14AddAlignedAttrENS_14SourceLocationEPNS_4DeclEPNS_14TypeSourceInfoE", "clang::Sema::AddAlignedAttr(clang::SourceLocation, clang::Decl*, clang::TypeSourceInfo*)"},
    {"_ZN5clang4Sema20CheckCallingConvAttrERKNS_13AttributeListERNS_11CallingConvE", "clang::Sema::CheckCallingConvAttr(clang::AttributeList const&, clang::CallingConv&)"},
    {"_ZN5clang4Sema16CheckRegparmAttrERKNS_13AttributeListERj", "clang::Sema::CheckRegparmAttr(clang::AttributeList const&, unsigned int&)"},
    {"_ZN5clang4Sema24ProcessDeclAttributeListEPNS_5ScopeEPNS_4DeclEPKNS_13AttributeListEbb", "clang::Sema::ProcessDeclAttributeList(clang::Scope*, clang::Decl*, clang::AttributeList const*, bool, bool)"},
    {"_ZN5clang4Sema19DeclClonePragmaWeakEPNS_9NamedDeclEPNS_14IdentifierInfoE", "clang::Sema::DeclClonePragmaWeak(clang::NamedDecl*, clang::IdentifierInfo*)"},
    {"_ZN5clang4Sema19DeclApplyPragmaWeakEPNS_5ScopeEPNS_9NamedDeclERNS0_8WeakInfoE", "clang::Sema::DeclApplyPragmaWeak(clang::Scope*, clang::NamedDecl*, clang::Sema::WeakInfo&)"},
    {"_ZN5clang4Sema21ProcessDeclAttributesEPNS_5ScopeEPNS_4DeclERKNS_10DeclaratorEbb", "clang::Sema::ProcessDeclAttributes(clang::Scope*, clang::Decl*, clang::Declarator const&, bool, bool)"},
    {"_ZN5clang4Sema22PushParsingDeclarationEv", "clang::Sema::PushParsingDeclaration()"},
    {"_ZN5clang4Sema21PopParsingDeclarationEmPNS_4DeclE", "clang::Sema::PopParsingDeclaration(unsigned long, clang::Decl*)"},
    {"_ZN5clang4Sema29HandleDelayedDeprecationCheckERNS_4sema17DelayedDiagnosticEPNS_4DeclE", "clang::Sema::HandleDelayedDeprecationCheck(clang::sema::DelayedDiagnostic&, clang::Decl*)"},
    {"_ZN5clang4Sema22EmitDeprecationWarningEPNS_9NamedDeclEN4llvm9StringRefENS_14SourceLocationEb", "clang::Sema::EmitDeprecationWarning(clang::NamedDecl*, llvm::StringRef, clang::SourceLocation, bool)"},
    {"_Z26ProcessInheritableDeclAttrPN5clang5ScopeEPNS_4DeclERKNS_13AttributeListERNS_4SemaE", "ProcessInheritableDeclAttr(clang::Scope*, clang::Decl*, clang::AttributeList const&, clang::Sema&)"},
    {"_Z15getFunctionTypePKN5clang4DeclEb", "getFunctionType(clang::Decl const*, bool)"},
    {"_ZN4llvm25array_pod_sort_comparatorIjEEiPKvS2_", "int llvm::array_pod_sort_comparator<unsigned int>(void const*, void const*)"},
    {"_Z14isNSStringTypeN5clang8QualTypeERNS_10ASTContextE", "isNSStringType(clang::QualType, clang::ASTContext&)"},
    {"_Z14isCFStringTypeN5clang8QualTypeERNS_10ASTContextE", "isCFStringType(clang::QualType, clang::ASTContext&)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang4sema17DelayedDiagnosticELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::sema::DelayedDiagnostic, false>::grow(unsigned long)"},
    {"_ZNK5clang4Decl7getAttrINS_13VecReturnAttrEEEPT_v", "clang::VecReturnAttr* clang::Decl::getAttr<clang::VecReturnAttr>() const"},
    {"_ZN5clang4Sema23SetParamDefaultArgumentEPNS_11ParmVarDeclEPNS_4ExprENS_14SourceLocationE", "clang::Sema::SetParamDefaultArgument(clang::ParmVarDecl*, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema25ActOnParamDefaultArgumentEPNS_4DeclENS_14SourceLocationEPNS_4ExprE", "clang::Sema::ActOnParamDefaultArgument(clang::Decl*, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang11StmtVisitorIN12_GLOBAL__N_127CheckDefaultArgumentVisitorEbE5VisitEPNS_4StmtE", "clang::StmtVisitor<(anonymous namespace)::CheckDefaultArgumentVisitor, bool>::Visit(clang::Stmt*)"},
    {"_ZN5clang4Sema33ActOnParamUnparsedDefaultArgumentEPNS_4DeclENS_14SourceLocationES3_", "clang::Sema::ActOnParamUnparsedDefaultArgument(clang::Decl*, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang4Sema30ActOnParamDefaultArgumentErrorEPNS_4DeclE", "clang::Sema::ActOnParamDefaultArgumentError(clang::Decl*)"},
    {"_ZN5clang4Sema29CheckExtraCXXDefaultArgumentsERNS_10DeclaratorE", "clang::Sema::CheckExtraCXXDefaultArguments(clang::Declarator&)"},
    {"_ZN5clang4Sema20MergeCXXFunctionDeclEPNS_12FunctionDeclES2_", "clang::Sema::MergeCXXFunctionDecl(clang::FunctionDecl*, clang::FunctionDecl*)"},
    {"_ZN5clang4Sema24CheckCXXDefaultArgumentsEPNS_12FunctionDeclE", "clang::Sema::CheckCXXDefaultArguments(clang::FunctionDecl*)"},
    {"_ZN5clang4Sema18isCurrentClassNameERKNS_14IdentifierInfoEPNS_5ScopeEPKNS_12CXXScopeSpecE", "clang::Sema::isCurrentClassName(clang::IdentifierInfo const&, clang::Scope*, clang::CXXScopeSpec const*)"},
    {"_ZN5clang4Sema18CheckBaseSpecifierEPNS_13CXXRecordDeclENS_11SourceRangeEbNS_15AccessSpecifierEPNS_14TypeSourceInfoENS_14SourceLocationE", "clang::Sema::CheckBaseSpecifier(clang::CXXRecordDecl*, clang::SourceRange, bool, clang::AccessSpecifier, clang::TypeSourceInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema18ActOnBaseSpecifierEPNS_4DeclENS_11SourceRangeEbNS_15AccessSpecifierENS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationES8_", "clang::Sema::ActOnBaseSpecifier(clang::Decl*, clang::SourceRange, bool, clang::AccessSpecifier, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang4Sema20AttachBaseSpecifiersEPNS_13CXXRecordDeclEPPNS_16CXXBaseSpecifierEj", "clang::Sema::AttachBaseSpecifiers(clang::CXXRecordDecl*, clang::CXXBaseSpecifier**, unsigned int)"},
    {"_ZN5clang4Sema19ActOnBaseSpecifiersEPNS_4DeclEPPNS_16CXXBaseSpecifierEj", "clang::Sema::ActOnBaseSpecifiers(clang::Decl*, clang::CXXBaseSpecifier**, unsigned int)"},
    {"_ZN5clang4Sema13IsDerivedFromENS_8QualTypeES1_", "clang::Sema::IsDerivedFrom(clang::QualType, clang::QualType)"},
    {"_Z15GetClassForTypeN5clang8QualTypeE", "GetClassForType(clang::QualType)"},
    {"_ZN5clang4Sema13IsDerivedFromENS_8QualTypeES1_RNS_12CXXBasePathsE", "clang::Sema::IsDerivedFrom(clang::QualType, clang::QualType, clang::CXXBasePaths&)"},
    {"_ZN5clang4Sema18BuildBasePathArrayERKNS_12CXXBasePathsERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::BuildBasePathArray(clang::CXXBasePaths const&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&)"},
    {"_ZN5clang4Sema27BasePathInvolvesVirtualBaseERKN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::BasePathInvolvesVirtualBase(llvm::SmallVector<clang::CXXBaseSpecifier*, 4u> const&)"},
    {"_ZN5clang4Sema28CheckDerivedToBaseConversionENS_8QualTypeES1_jjNS_14SourceLocationENS_11SourceRangeENS_15DeclarationNameEPN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEE", "clang::Sema::CheckDerivedToBaseConversion(clang::QualType, clang::QualType, unsigned int, unsigned int, clang::SourceLocation, clang::SourceRange, clang::DeclarationName, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>*)"},
    {"_ZN5clang4Sema30getAmbiguousPathsDisplayStringERNS_12CXXBasePathsE", "clang::Sema::getAmbiguousPathsDisplayString(clang::CXXBasePaths&)"},
    {"_ZN5clang4Sema28CheckDerivedToBaseConversionENS_8QualTypeES1_NS_14SourceLocationENS_11SourceRangeEPN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEEb", "clang::Sema::CheckDerivedToBaseConversion(clang::QualType, clang::QualType, clang::SourceLocation, clang::SourceRange, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>*, bool)"},
    {"_ZN5clang4Sema20ActOnAccessSpecifierENS_15AccessSpecifierENS_14SourceLocationES2_", "clang::Sema::ActOnAccessSpecifier(clang::AccessSpecifier, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang4Sema20CheckOverrideControlEPKNS_4DeclE", "clang::Sema::CheckOverrideControl(clang::Decl const*)"},
    {"_ZN5clang4Sema38CheckIfOverriddenFunctionIsMarkedFinalEPKNS_13CXXMethodDeclES3_", "clang::Sema::CheckIfOverriddenFunctionIsMarkedFinal(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"},
    {"_ZN5clang4Sema24ActOnCXXMemberDeclaratorEPNS_5ScopeENS_15AccessSpecifierERNS_10DeclaratorENS_11ASTMultiPtrIPNS_21TemplateParameterListEEEPNS_4ExprERKNS_14VirtSpecifiersESB_bb", "clang::Sema::ActOnCXXMemberDeclarator(clang::Scope*, clang::AccessSpecifier, clang::Declarator&, clang::ASTMultiPtr<clang::TemplateParameterList*>, clang::Expr*, clang::VirtSpecifiers const&, clang::Expr*, bool, bool)"},
    {"_ZN5clang4Sema14SetDeclDeletedEPNS_4DeclENS_14SourceLocationE", "clang::Sema::SetDeclDeleted(clang::Decl*, clang::SourceLocation)"},
    {"_ZN5clang4Sema19ActOnMemInitializerEPNS_4DeclEPNS_5ScopeERNS_12CXXScopeSpecEPNS_14IdentifierInfoENS_9OpaquePtrINS_8QualTypeEEENS_14SourceLocationESC_PPNS_4ExprEjSC_SC_", "clang::Sema::ActOnMemInitializer(clang::Decl*, clang::Scope*, clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::SourceLocation, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN5clang4Sema22BuildMemberInitializerEPNS_9ValueDeclEPPNS_4ExprEjNS_14SourceLocationES6_S6_", "clang::Sema::BuildMemberInitializer(clang::ValueDecl*, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::SourceLocation)"},
    {"_Z19FindBaseInitializerRN5clang4SemaEPNS_13CXXRecordDeclENS_8QualTypeERPKNS_16CXXBaseSpecifierES8_", "FindBaseInitializer(clang::Sema&, clang::CXXRecordDecl*, clang::QualType, clang::CXXBaseSpecifier const*&, clang::CXXBaseSpecifier const*&)"},
    {"_ZN5clang4Sema20BuildBaseInitializerENS_8QualTypeEPNS_14TypeSourceInfoEPPNS_4ExprEjNS_14SourceLocationES7_PNS_13CXXRecordDeclES7_", "clang::Sema::BuildBaseInitializer(clang::QualType, clang::TypeSourceInfo*, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::CXXRecordDecl*, clang::SourceLocation)"},
    {"_Z35InitExprContainsUninitializedFieldsPKN5clang4StmtEPKNS_9ValueDeclEPNS_14SourceLocationE", "InitExprContainsUninitializedFields(clang::Stmt const*, clang::ValueDecl const*, clang::SourceLocation*)"},
    {"_ZN5clang4Sema26BuildDelegatingInitializerEPNS_14TypeSourceInfoEPPNS_4ExprEjNS_14SourceLocationES6_PNS_13CXXRecordDeclES6_", "clang::Sema::BuildDelegatingInitializer(clang::TypeSourceInfo*, clang::Expr**, unsigned int, clang::SourceLocation, clang::SourceLocation, clang::CXXRecordDecl*, clang::SourceLocation)"},
    {"_ZN5clang4Sema19SetCtorInitializersEPNS_18CXXConstructorDeclEPPNS_18CXXCtorInitializerEjb", "clang::Sema::SetCtorInitializers(clang::CXXConstructorDecl*, clang::CXXCtorInitializer**, unsigned int, bool)"},
    {"_Z28BuildImplicitBaseInitializerRN5clang4SemaEPNS_18CXXConstructorDeclE23ImplicitInitializerKindPNS_16CXXBaseSpecifierEbRPNS_18CXXCtorInitializerE", "BuildImplicitBaseInitializer(clang::Sema&, clang::CXXConstructorDecl*, ImplicitInitializerKind, clang::CXXBaseSpecifier*, bool, clang::CXXCtorInitializer*&)"},
    {"_Z23CollectFieldInitializerRN12_GLOBAL__N_116BaseAndFieldInfoEPN5clang9FieldDeclES4_", "CollectFieldInitializer((anonymous namespace)::BaseAndFieldInfo&, clang::FieldDecl*, clang::FieldDecl*)"},
    {"_ZN5clang4Sema38MarkBaseAndMemberDestructorsReferencedENS_14SourceLocationEPNS_13CXXRecordDeclE", "clang::Sema::MarkBaseAndMemberDestructorsReferenced(clang::SourceLocation, clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema20ActOnMemInitializersEPNS_4DeclENS_14SourceLocationEPPNS_18CXXCtorInitializerEjb", "clang::Sema::ActOnMemInitializers(clang::Decl*, clang::SourceLocation, clang::CXXCtorInitializer**, unsigned int, bool)"},
    {"_ZN12_GLOBAL__N_118CheckRedundantInitERN5clang4SemaEPNS0_18CXXCtorInitializerERS4_", "(anonymous namespace)::CheckRedundantInit(clang::Sema&, clang::CXXCtorInitializer*, clang::CXXCtorInitializer*&)"},
    {"_ZN5clang4Sema28ActOnDefaultCtorInitializersEPNS_4DeclE", "clang::Sema::ActOnDefaultCtorInitializers(clang::Decl*)"},
    {"_ZN5clang4Sema22RequireNonAbstractTypeENS_14SourceLocationENS_8QualTypeEjNS0_17AbstractDiagSelIDE", "clang::Sema::RequireNonAbstractType(clang::SourceLocation, clang::QualType, unsigned int, clang::Sema::AbstractDiagSelID)"},
    {"_ZN5clang4Sema22RequireNonAbstractTypeENS_14SourceLocationENS_8QualTypeERKNS_17PartialDiagnosticE", "clang::Sema::RequireNonAbstractType(clang::SourceLocation, clang::QualType, clang::PartialDiagnostic const&)"},
    {"_ZN5clang4Sema20DiagnoseAbstractTypeEPKNS_13CXXRecordDeclE", "clang::Sema::DiagnoseAbstractType(clang::CXXRecordDecl const*)"},
    {"_ZN5clang4Sema22CheckCompletedCXXClassEPNS_13CXXRecordDeclE", "clang::Sema::CheckCompletedCXXClass(clang::CXXRecordDecl*)"},
    {"_Z23CheckAbstractClassUsageRN12_GLOBAL__N_117AbstractUsageInfoEPN5clang13CXXRecordDeclE", "CheckAbstractClassUsage((anonymous namespace)::AbstractUsageInfo&, clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema28DiagnoseHiddenVirtualMethodsEPNS_13CXXRecordDeclEPNS_13CXXMethodDeclE", "clang::Sema::DiagnoseHiddenVirtualMethods(clang::CXXRecordDecl*, clang::CXXMethodDecl*)"},
    {"_ZN5clang4Sema28DeclareInheritedConstructorsEPNS_13CXXRecordDeclE", "clang::Sema::DeclareInheritedConstructors(clang::CXXRecordDecl*)"},
    {"_Z23FindHiddenVirtualMethodPKN5clang16CXXBaseSpecifierERNS_11CXXBasePathEPv", "FindHiddenVirtualMethod(clang::CXXBaseSpecifier const*, clang::CXXBasePath&, void*)"},
    {"_ZN5clang4Sema33ActOnFinishCXXMemberSpecificationEPNS_5ScopeENS_14SourceLocationEPNS_4DeclES3_S3_PNS_13AttributeListE", "clang::Sema::ActOnFinishCXXMemberSpecification(clang::Scope*, clang::SourceLocation, clang::Decl*, clang::SourceLocation, clang::SourceLocation, clang::AttributeList*)"},
    {"_ZN5clang4Sema35AddImplicitlyDeclaredMembersToClassEPNS_13CXXRecordDeclE", "clang::Sema::AddImplicitlyDeclaredMembersToClass(clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema29DeclareImplicitCopyAssignmentEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitCopyAssignment(clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema25DeclareImplicitDestructorEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitDestructor(clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema25ActOnReenterTemplateScopeEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnReenterTemplateScope(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema35ActOnStartDelayedMemberDeclarationsEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartDelayedMemberDeclarations(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema36ActOnFinishDelayedMemberDeclarationsEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnFinishDelayedMemberDeclarations(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema37ActOnStartDelayedCXXMethodDeclarationEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartDelayedCXXMethodDeclaration(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema30ActOnDelayedCXXMethodParameterEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnDelayedCXXMethodParameter(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema38ActOnFinishDelayedCXXMethodDeclarationEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnFinishDelayedCXXMethodDeclaration(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema16CheckConstructorEPNS_18CXXConstructorDeclE", "clang::Sema::CheckConstructor(clang::CXXConstructorDecl*)"},
    {"_ZN5clang4Sema26CheckConstructorDeclaratorERNS_10DeclaratorENS_8QualTypeERNS_12StorageClassE", "clang::Sema::CheckConstructorDeclarator(clang::Declarator&, clang::QualType, clang::StorageClass&)"},
    {"_ZN5clang4Sema15CheckDestructorEPNS_17CXXDestructorDeclE", "clang::Sema::CheckDestructor(clang::CXXDestructorDecl*)"},
    {"_ZN5clang4Sema25CheckDestructorDeclaratorERNS_10DeclaratorENS_8QualTypeERNS_12StorageClassE", "clang::Sema::CheckDestructorDeclarator(clang::Declarator&, clang::QualType, clang::StorageClass&)"},
    {"_ZN5clang4Sema25CheckConversionDeclaratorERNS_10DeclaratorERNS_8QualTypeERNS_12StorageClassE", "clang::Sema::CheckConversionDeclarator(clang::Declarator&, clang::QualType&, clang::StorageClass&)"},
    {"_ZN5clang4Sema25ActOnConversionDeclaratorEPNS_17CXXConversionDeclE", "clang::Sema::ActOnConversionDeclarator(clang::CXXConversionDecl*)"},
    {"_ZN5clang4Sema22ActOnStartNamespaceDefEPNS_5ScopeENS_14SourceLocationES3_PNS_14IdentifierInfoES3_PNS_13AttributeListE", "clang::Sema::ActOnStartNamespaceDef(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::AttributeList*)"},
    {"_ZNK5clang4Sema15getStdNamespaceEv", "clang::Sema::getStdNamespace() const"},
    {"_ZN5clang4Sema23ActOnFinishNamespaceDefEPNS_4DeclENS_14SourceLocationE", "clang::Sema::ActOnFinishNamespaceDef(clang::Decl*, clang::SourceLocation)"},
    {"_ZNK5clang4Sema14getStdBadAllocEv", "clang::Sema::getStdBadAlloc() const"},
    {"_ZN5clang4Sema23getOrCreateStdNamespaceEv", "clang::Sema::getOrCreateStdNamespace()"},
    {"_ZN5clang4Sema19ActOnUsingDirectiveEPNS_5ScopeENS_14SourceLocationES3_RNS_12CXXScopeSpecES3_PNS_14IdentifierInfoEPNS_13AttributeListE", "clang::Sema::ActOnUsingDirective(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::CXXScopeSpec&, clang::SourceLocation, clang::IdentifierInfo*, clang::AttributeList*)"},
    {"_ZN5clang4Sema18PushUsingDirectiveEPNS_5ScopeEPNS_18UsingDirectiveDeclE", "clang::Sema::PushUsingDirective(clang::Scope*, clang::UsingDirectiveDecl*)"},
    {"_ZN5clang4Sema21ActOnUsingDeclarationEPNS_5ScopeENS_15AccessSpecifierEbNS_14SourceLocationERNS_12CXXScopeSpecERNS_13UnqualifiedIdEPNS_13AttributeListEbS4_", "clang::Sema::ActOnUsingDeclaration(clang::Scope*, clang::AccessSpecifier, bool, clang::SourceLocation, clang::CXXScopeSpec&, clang::UnqualifiedId&, clang::AttributeList*, bool, clang::SourceLocation)"},
    {"_ZN5clang4Sema21BuildUsingDeclarationEPNS_5ScopeENS_15AccessSpecifierENS_14SourceLocationERNS_12CXXScopeSpecERKNS_19DeclarationNameInfoEPNS_13AttributeListEbbS4_", "clang::Sema::BuildUsingDeclaration(clang::Scope*, clang::AccessSpecifier, clang::SourceLocation, clang::CXXScopeSpec&, clang::DeclarationNameInfo const&, clang::AttributeList*, bool, bool, clang::SourceLocation)"},
    {"_ZN5clang4Sema20CheckUsingShadowDeclEPNS_9UsingDeclEPNS_9NamedDeclERKNS_12LookupResultE", "clang::Sema::CheckUsingShadowDecl(clang::UsingDecl*, clang::NamedDecl*, clang::LookupResult const&)"},
    {"_ZN5clang4Sema20BuildUsingShadowDeclEPNS_5ScopeEPNS_9UsingDeclEPNS_9NamedDeclE", "clang::Sema::BuildUsingShadowDecl(clang::Scope*, clang::UsingDecl*, clang::NamedDecl*)"},
    {"_ZN5clang4Sema19HideUsingShadowDeclEPNS_5ScopeEPNS_15UsingShadowDeclE", "clang::Sema::HideUsingShadowDecl(clang::Scope*, clang::UsingShadowDecl*)"},
    {"_ZN5clang4Sema27CheckUsingDeclRedeclarationENS_14SourceLocationEbRKNS_12CXXScopeSpecES1_RKNS_12LookupResultE", "clang::Sema::CheckUsingDeclRedeclaration(clang::SourceLocation, bool, clang::CXXScopeSpec const&, clang::SourceLocation, clang::LookupResult const&)"},
    {"_ZN5clang4Sema23CheckUsingDeclQualifierENS_14SourceLocationERKNS_12CXXScopeSpecES1_", "clang::Sema::CheckUsingDeclQualifier(clang::SourceLocation, clang::CXXScopeSpec const&, clang::SourceLocation)"},
    {"_ZN5clang4Sema34CheckInheritedConstructorUsingDeclEPNS_9UsingDeclE", "clang::Sema::CheckInheritedConstructorUsingDecl(clang::UsingDecl*)"},
    {"_ZN5clang4Sema22ActOnNamespaceAliasDefEPNS_5ScopeENS_14SourceLocationES3_PNS_14IdentifierInfoERNS_12CXXScopeSpecES3_S5_", "clang::Sema::ActOnNamespaceAliasDef(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::IdentifierInfo*, clang::CXXScopeSpec&, clang::SourceLocation, clang::IdentifierInfo*)"},
    {"_ZN5clang4Sema33DeclareImplicitDefaultConstructorEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitDefaultConstructor(clang::CXXRecordDecl*)"},
    {"_ZN12_GLOBAL__N_130ImplicitExceptionSpecification10CalledDeclEPN5clang13CXXMethodDeclE", "(anonymous namespace)::ImplicitExceptionSpecification::CalledDecl(clang::CXXMethodDecl*)"},
    {"_Z27getDefaultConstructorUnsafeRN5clang4SemaEPNS_13CXXRecordDeclE", "getDefaultConstructorUnsafe(clang::Sema&, clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema32DefineImplicitDefaultConstructorENS_14SourceLocationEPNS_18CXXConstructorDeclE", "clang::Sema::DefineImplicitDefaultConstructor(clang::SourceLocation, clang::CXXConstructorDecl*)"},
    {"_ZN5clang4Sema14MarkVTableUsedENS_14SourceLocationEPNS_13CXXRecordDeclEb", "clang::Sema::MarkVTableUsed(clang::SourceLocation, clang::CXXRecordDecl*, bool)"},
    {"_ZN5clang4Sema24DefineImplicitDestructorENS_14SourceLocationEPNS_17CXXDestructorDeclE", "clang::Sema::DefineImplicitDestructor(clang::SourceLocation, clang::CXXDestructorDecl*)"},
    {"_Z22hasConstCopyAssignmentRN5clang4SemaEPKNS_13CXXRecordDeclE", "hasConstCopyAssignment(clang::Sema&, clang::CXXRecordDecl const*)"},
    {"_ZN5clang4Sema28DefineImplicitCopyAssignmentENS_14SourceLocationEPNS_13CXXMethodDeclE", "clang::Sema::DefineImplicitCopyAssignment(clang::SourceLocation, clang::CXXMethodDecl*)"},
    {"_Z21BuildSingleCopyAssignRN5clang4SemaENS_14SourceLocationENS_8QualTypeEPNS_4ExprES5_bj", "BuildSingleCopyAssign(clang::Sema&, clang::SourceLocation, clang::QualType, clang::Expr*, clang::Expr*, bool, unsigned int)"},
    {"_ZN5clang4Sema30DeclareImplicitCopyConstructorEPNS_13CXXRecordDeclE", "clang::Sema::DeclareImplicitCopyConstructor(clang::CXXRecordDecl*)"},
    {"_ZN5clang4Sema29DefineImplicitCopyConstructorENS_14SourceLocationEPNS_18CXXConstructorDeclEj", "clang::Sema::DefineImplicitCopyConstructor(clang::SourceLocation, clang::CXXConstructorDecl*, unsigned int)"},
    {"_ZN5clang4Sema21BuildCXXConstructExprENS_14SourceLocationENS_8QualTypeEPNS_18CXXConstructorDeclENS_11ASTMultiPtrIPNS_4ExprEEEbjNS_11SourceRangeE", "clang::Sema::BuildCXXConstructExpr(clang::SourceLocation, clang::QualType, clang::CXXConstructorDecl*, clang::ASTMultiPtr<clang::Expr*>, bool, unsigned int, clang::SourceRange)"},
    {"_ZN5clang4Sema21BuildCXXConstructExprENS_14SourceLocationENS_8QualTypeEPNS_18CXXConstructorDeclEbNS_11ASTMultiPtrIPNS_4ExprEEEbjNS_11SourceRangeE", "clang::Sema::BuildCXXConstructExpr(clang::SourceLocation, clang::QualType, clang::CXXConstructorDecl*, bool, clang::ASTMultiPtr<clang::Expr*>, bool, unsigned int, clang::SourceRange)"},
    {"_ZN5clang4Sema28InitializeVarWithConstructorEPNS_7VarDeclEPNS_18CXXConstructorDeclENS_11ASTMultiPtrIPNS_4ExprEEE", "clang::Sema::InitializeVarWithConstructor(clang::VarDecl*, clang::CXXConstructorDecl*, clang::ASTMultiPtr<clang::Expr*>)"},
    {"_ZN5clang4Sema25FinalizeVarWithDestructorEPNS_7VarDeclEPKNS_10RecordTypeE", "clang::Sema::FinalizeVarWithDestructor(clang::VarDecl*, clang::RecordType const*)"},
    {"_ZN5clang4Sema29AddCXXDirectInitializerToDeclEPNS_4DeclENS_14SourceLocationENS_11ASTMultiPtrIPNS_4ExprEEES3_", "clang::Sema::AddCXXDirectInitializerToDecl(clang::Decl*, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation)"},
    {"_ZN5clang4Sema23CompleteConstructorCallEPNS_18CXXConstructorDeclENS_11ASTMultiPtrIPNS_4ExprEEENS_14SourceLocationERNS_15ASTOwningVectorIS5_Lj8EEE", "clang::Sema::CompleteConstructorCall(clang::CXXConstructorDecl*, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation, clang::ASTOwningVector<clang::Expr*, 8u>&)"},
    {"_ZN5clang4Sema34CheckOverloadedOperatorDeclarationEPNS_12FunctionDeclE", "clang::Sema::CheckOverloadedOperatorDeclaration(clang::FunctionDecl*)"},
    {"_ZN5clang4Sema31CheckLiteralOperatorDeclarationEPNS_12FunctionDeclE", "clang::Sema::CheckLiteralOperatorDeclaration(clang::FunctionDecl*)"},
    {"_ZN5clang4Sema30ActOnStartLinkageSpecificationEPNS_5ScopeENS_14SourceLocationES3_N4llvm9StringRefES3_", "clang::Sema::ActOnStartLinkageSpecification(clang::Scope*, clang::SourceLocation, clang::SourceLocation, llvm::StringRef, clang::SourceLocation)"},
    {"_ZN5clang4Sema31ActOnFinishLinkageSpecificationEPNS_5ScopeEPNS_4DeclENS_14SourceLocationE", "clang::Sema::ActOnFinishLinkageSpecification(clang::Scope*, clang::Decl*, clang::SourceLocation)"},
    {"_ZN5clang4Sema25BuildExceptionDeclarationEPNS_5ScopeEPNS_14TypeSourceInfoEPNS_14IdentifierInfoENS_14SourceLocationE", "clang::Sema::BuildExceptionDeclaration(clang::Scope*, clang::TypeSourceInfo*, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema24ActOnExceptionDeclaratorEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnExceptionDeclarator(clang::Scope*, clang::Declarator&)"},
    {"_ZN5clang4Sema28ActOnStaticAssertDeclarationENS_14SourceLocationEPNS_4ExprES3_", "clang::Sema::ActOnStaticAssertDeclaration(clang::SourceLocation, clang::Expr*, clang::Expr*)"},
    {"_ZN5clang4Sema19CheckFriendTypeDeclENS_14SourceLocationEPNS_14TypeSourceInfoE", "clang::Sema::CheckFriendTypeDecl(clang::SourceLocation, clang::TypeSourceInfo*)"},
    {"_ZN5clang4Sema23ActOnTemplatedFriendTagEPNS_5ScopeENS_14SourceLocationEjS3_RNS_12CXXScopeSpecEPNS_14IdentifierInfoES3_PNS_13AttributeListENS_11ASTMultiPtrIPNS_21TemplateParameterListEEE", "clang::Sema::ActOnTemplatedFriendTag(clang::Scope*, clang::SourceLocation, unsigned int, clang::SourceLocation, clang::CXXScopeSpec&, clang::IdentifierInfo*, clang::SourceLocation, clang::AttributeList*, clang::ASTMultiPtr<clang::TemplateParameterList*>)"},
    {"_ZN5clang4Sema19ActOnFriendTypeDeclEPNS_5ScopeERKNS_8DeclSpecENS_11ASTMultiPtrIPNS_21TemplateParameterListEEE", "clang::Sema::ActOnFriendTypeDecl(clang::Scope*, clang::DeclSpec const&, clang::ASTMultiPtr<clang::TemplateParameterList*>)"},
    {"_ZN5clang4Sema23ActOnFriendFunctionDeclEPNS_5ScopeERNS_10DeclaratorEbNS_11ASTMultiPtrIPNS_21TemplateParameterListEEE", "clang::Sema::ActOnFriendFunctionDecl(clang::Scope*, clang::Declarator&, bool, clang::ASTMultiPtr<clang::TemplateParameterList*>)"},
    {"_ZN5clang4Sema43DiagnoseReturnInConstructorExceptionHandlerEPNS_10CXXTryStmtE", "clang::Sema::DiagnoseReturnInConstructorExceptionHandler(clang::CXXTryStmt*)"},
    {"_Z21SearchForReturnInStmtRN5clang4SemaEPNS_4StmtE", "SearchForReturnInStmt(clang::Sema&, clang::Stmt*)"},
    {"_ZN5clang4Sema33CheckOverridingFunctionReturnTypeEPKNS_13CXXMethodDeclES3_", "clang::Sema::CheckOverridingFunctionReturnType(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"},
    {"_ZN5clang4Sema15CheckPureMethodEPNS_13CXXMethodDeclENS_11SourceRangeE", "clang::Sema::CheckPureMethod(clang::CXXMethodDecl*, clang::SourceRange)"},
    {"_ZN5clang4Sema28ActOnCXXEnterDeclInitializerEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnCXXEnterDeclInitializer(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema27ActOnCXXExitDeclInitializerEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnCXXExitDeclInitializer(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema28ActOnCXXConditionDeclarationEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnCXXConditionDeclaration(clang::Scope*, clang::Declarator&)"},
    {"_ZN5clang4Sema28MarkVirtualMembersReferencedENS_14SourceLocationEPKNS_13CXXRecordDeclE", "clang::Sema::MarkVirtualMembersReferenced(clang::SourceLocation, clang::CXXRecordDecl const*)"},
    {"_ZN5clang4Sema17DefineUsedVTablesEv", "clang::Sema::DefineUsedVTables()"},
    {"_ZN5clang4Sema19SetIvarInitializersEPNS_22ObjCImplementationDeclE", "clang::Sema::SetIvarInitializers(clang::ObjCImplementationDecl*)"},
    {"_ZN12_GLOBAL__N_127CheckDefaultArgumentVisitor9VisitExprEPN5clang4ExprE", "(anonymous namespace)::CheckDefaultArgumentVisitor::VisitExpr(clang::Expr*)"},
    {"_Z38CheckOperatorNewDeleteDeclarationScopeRN5clang4SemaEPKNS_12FunctionDeclE", "CheckOperatorNewDeleteDeclarationScope(clang::Sema&, clang::FunctionDecl const*)"},
    {"_Z27CheckOperatorNewDeleteTypesRN5clang4SemaEPKNS_12FunctionDeclENS_7CanQualINS_4TypeEEES7_jj", "CheckOperatorNewDeleteTypes(clang::Sema&, clang::FunctionDecl const*, clang::CanQual<clang::Type>, clang::CanQual<clang::Type>, unsigned int, unsigned int)"},
    {"_ZZN5clang4Sema23CheckUsingDeclQualifierENS_14SourceLocationERKNS_12CXXScopeSpecES1_EN8UserData14doesNotContainEPKNS_13CXXRecordDeclEPv", "clang::Sema::CheckUsingDeclQualifier(clang::SourceLocation, clang::CXXScopeSpec const&, clang::SourceLocation)::UserData::doesNotContain(clang::CXXRecordDecl const*, void*)"},
    {"_ZZN5clang4Sema23CheckUsingDeclQualifierENS_14SourceLocationERKNS_12CXXScopeSpecES1_EN8UserData7collectEPKNS_13CXXRecordDeclEPv", "clang::Sema::CheckUsingDeclQualifier(clang::SourceLocation, clang::CXXScopeSpec const&, clang::SourceLocation)::UserData::collect(clang::CXXRecordDecl const*, void*)"},
    {"_ZN12_GLOBAL__N_118CheckAbstractUsage5VisitEN5clang7TypeLocENS1_4Sema17AbstractDiagSelIDE", "(anonymous namespace)::CheckAbstractUsage::Visit(clang::TypeLoc, clang::Sema::AbstractDiagSelID)"},
    {"_ZN12_GLOBAL__N_118CheckAbstractUsage5CheckEN5clang7TypeLocENS1_4Sema17AbstractDiagSelIDE", "(anonymous namespace)::CheckAbstractUsage::Check(clang::TypeLoc, clang::Sema::AbstractDiagSelID)"},
    {"_ZN5clang14AccessSpecDecl6CreateERNS_10ASTContextENS_15AccessSpecifierEPNS_11DeclContextENS_14SourceLocationES6_", "clang::AccessSpecDecl::Create(clang::ASTContext&, clang::AccessSpecifier, clang::DeclContext*, clang::SourceLocation, clang::SourceLocation)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeESt4pairINS1_7CanQualIS2_EEPNS1_18CXXConstructorDeclEENS_12DenseMapInfoIS4_EENSB_ISA_EEE6insertERKS5_IS4_SA_E", "llvm::DenseMap<clang::Type const*, std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*>, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*> > >::insert(std::pair<clang::Type const*, std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*> > const&)"},
    {"_ZN4llvm8DenseMapIPN5clang13CXXRecordDeclEbNS_12DenseMapInfoIS3_EENS4_IbEEE6insertERKSt4pairIS3_bE", "llvm::DenseMap<clang::CXXRecordDecl*, bool, llvm::DenseMapInfo<clang::CXXRecordDecl*>, llvm::DenseMapInfo<bool> >::insert(std::pair<clang::CXXRecordDecl*, bool> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeESt4pairINS1_7CanQualIS2_EEPNS1_18CXXConstructorDeclEENS_12DenseMapInfoIS4_EENSB_ISA_EEE16InsertIntoBucketERKS4_RKSA_PS5_IS4_SA_E", "llvm::DenseMap<clang::Type const*, std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*>, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*> > >::InsertIntoBucket(clang::Type const* const&, std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*> const&, std::pair<clang::Type const*, std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*> >*)"},
    {"_ZN4llvm8DenseMapIPKN5clang4TypeESt4pairINS1_7CanQualIS2_EEPNS1_18CXXConstructorDeclEENS_12DenseMapInfoIS4_EENSB_ISA_EEE4growEj", "llvm::DenseMap<clang::Type const*, std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*>, llvm::DenseMapInfo<clang::Type const*>, llvm::DenseMapInfo<std::pair<clang::CanQual<clang::Type>, clang::CXXConstructorDecl*> > >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPvPN5clang18CXXCtorInitializerENS_12DenseMapInfoIS1_EENS5_IS4_EEE16InsertIntoBucketERKS1_RKS4_PSt4pairIS1_S4_E", "llvm::DenseMap<void*, clang::CXXCtorInitializer*, llvm::DenseMapInfo<void*>, llvm::DenseMapInfo<clang::CXXCtorInitializer*> >::InsertIntoBucket(void* const&, clang::CXXCtorInitializer* const&, std::pair<void*, clang::CXXCtorInitializer*>*)"},
    {"_ZN4llvm8DenseMapIPvPN5clang18CXXCtorInitializerENS_12DenseMapInfoIS1_EENS5_IS4_EEE4growEj", "llvm::DenseMap<void*, clang::CXXCtorInitializer*, llvm::DenseMapInfo<void*>, llvm::DenseMapInfo<clang::CXXCtorInitializer*> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKvPN5clang18CXXCtorInitializerENS_12DenseMapInfoIS2_EENS6_IS5_EEE16InsertIntoBucketERKS2_RKS5_PSt4pairIS2_S5_E", "llvm::DenseMap<void const*, clang::CXXCtorInitializer*, llvm::DenseMapInfo<void const*>, llvm::DenseMapInfo<clang::CXXCtorInitializer*> >::InsertIntoBucket(void const* const&, clang::CXXCtorInitializer* const&, std::pair<void const*, clang::CXXCtorInitializer*>*)"},
    {"_ZN4llvm8DenseMapIPKvPN5clang18CXXCtorInitializerENS_12DenseMapInfoIS2_EENS6_IS5_EEE4growEj", "llvm::DenseMap<void const*, clang::CXXCtorInitializer*, llvm::DenseMapInfo<void const*>, llvm::DenseMapInfo<clang::CXXCtorInitializer*> >::grow(unsigned int)"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_PNS0_16CXXBaseSpecifierEESt10_Select1stIS6_ENS0_16QualTypeOrderingESaIS6_EE16_M_insert_uniqueESt17_Rb_tree_iteratorIS6_ERKS6_", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, clang::CXXBaseSpecifier*>, std::_Select1st<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> > >::_M_insert_unique(std::_Rb_tree_iterator<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> >, std::pair<clang::QualType const, clang::CXXBaseSpecifier*> const&)"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_PNS0_16CXXBaseSpecifierEESt10_Select1stIS6_ENS0_16QualTypeOrderingESaIS6_EE16_M_insert_uniqueERKS6_", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, clang::CXXBaseSpecifier*>, std::_Select1st<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> > >::_M_insert_unique(std::pair<clang::QualType const, clang::CXXBaseSpecifier*> const&)"},
    {"_ZN4llvm8DenseMapIPN5clang11ParmVarDeclENS1_14SourceLocationENS_12DenseMapInfoIS3_EENS5_IS4_EEE16InsertIntoBucketERKS3_RKS4_PSt4pairIS3_S4_E", "llvm::DenseMap<clang::ParmVarDecl*, clang::SourceLocation, llvm::DenseMapInfo<clang::ParmVarDecl*>, llvm::DenseMapInfo<clang::SourceLocation> >::InsertIntoBucket(clang::ParmVarDecl* const&, clang::SourceLocation const&, std::pair<clang::ParmVarDecl*, clang::SourceLocation>*)"},
    {"_ZN4llvm8DenseMapIPN5clang11ParmVarDeclENS1_14SourceLocationENS_12DenseMapInfoIS3_EENS5_IS4_EEE4growEj", "llvm::DenseMap<clang::ParmVarDecl*, clang::SourceLocation, llvm::DenseMapInfo<clang::ParmVarDecl*>, llvm::DenseMapInfo<clang::SourceLocation> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEcNS_12DenseMapInfoIS4_EENS5_IcEEE6insertERKSt4pairIS4_cE", "llvm::DenseMap<clang::CXXRecordDecl const*, char, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<char> >::insert(std::pair<clang::CXXRecordDecl const*, char> const&)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEcNS_12DenseMapInfoIS4_EENS5_IcEEE16InsertIntoBucketERKS4_RKcPSt4pairIS4_cE", "llvm::DenseMap<clang::CXXRecordDecl const*, char, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<char> >::InsertIntoBucket(clang::CXXRecordDecl const* const&, char const&, std::pair<clang::CXXRecordDecl const*, char>*)"},
    {"_ZN4llvm8DenseMapIPKN5clang13CXXRecordDeclEcNS_12DenseMapInfoIS4_EENS5_IcEEE4growEj", "llvm::DenseMap<clang::CXXRecordDecl const*, char, llvm::DenseMapInfo<clang::CXXRecordDecl const*>, llvm::DenseMapInfo<char> >::grow(unsigned int)"},
    {"_ZN5clang15UsingShadowDeclC2EPNS_11DeclContextENS_14SourceLocationEPNS_9UsingDeclEPNS_9NamedDeclE", "clang::UsingShadowDecl::UsingShadowDecl(clang::DeclContext*, clang::SourceLocation, clang::UsingDecl*, clang::NamedDecl*)"},
    {"_ZN5clang15UsingShadowDeclD1Ev", "clang::UsingShadowDecl::~UsingShadowDecl()"},
    {"_ZN5clang15UsingShadowDeclD0Ev", "clang::UsingShadowDecl::~UsingShadowDecl()"},
    {"_ZN4llvm8DenseMapIPN5clang10RecordDeclESt4pairIPNS1_9NamedDeclEPNS1_18CXXCtorInitializerEENS_12DenseMapInfoIS3_EENSA_IS9_EEE16InsertIntoBucketERKS3_RKS9_PS4_IS3_S9_E", "llvm::DenseMap<clang::RecordDecl*, std::pair<clang::NamedDecl*, clang::CXXCtorInitializer*>, llvm::DenseMapInfo<clang::RecordDecl*>, llvm::DenseMapInfo<std::pair<clang::NamedDecl*, clang::CXXCtorInitializer*> > >::InsertIntoBucket(clang::RecordDecl* const&, std::pair<clang::NamedDecl*, clang::CXXCtorInitializer*> const&, std::pair<clang::RecordDecl*, std::pair<clang::NamedDecl*, clang::CXXCtorInitializer*> >*)"},
    {"_ZN4llvm8DenseMapIPN5clang10RecordDeclESt4pairIPNS1_9NamedDeclEPNS1_18CXXCtorInitializerEENS_12DenseMapInfoIS3_EENSA_IS9_EEE4growEj", "llvm::DenseMap<clang::RecordDecl*, std::pair<clang::NamedDecl*, clang::CXXCtorInitializer*>, llvm::DenseMapInfo<clang::RecordDecl*>, llvm::DenseMapInfo<std::pair<clang::NamedDecl*, clang::CXXCtorInitializer*> > >::grow(unsigned int)"},
    {"_ZN4llvm23SmallVectorTemplateBaseIN5clang17InitializedEntityELb0EE4growEm", "llvm::SmallVectorTemplateBase<clang::InitializedEntity, false>::grow(unsigned long)"},
    {"_ZN5clang14AccessSpecDeclD1Ev", "clang::AccessSpecDecl::~AccessSpecDecl()"},
    {"_ZN5clang14AccessSpecDeclD0Ev", "clang::AccessSpecDecl::~AccessSpecDecl()"},
    {"_ZNK5clang14AccessSpecDecl14getSourceRangeEv", "clang::AccessSpecDecl::getSourceRange() const"},
    {"_ZNSt8_Rb_treeIN5clang8QualTypeESt4pairIKS1_PNS0_16CXXBaseSpecifierEESt10_Select1stIS6_ENS0_16QualTypeOrderingESaIS6_EE8_M_eraseEPSt13_Rb_tree_nodeIS6_E", "std::_Rb_tree<clang::QualType, std::pair<clang::QualType const, clang::CXXBaseSpecifier*>, std::_Select1st<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> >, clang::QualTypeOrdering, std::allocator<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> > >::_M_erase(std::_Rb_tree_node<std::pair<clang::QualType const, clang::CXXBaseSpecifier*> >*)"},
    {"_ZN5clang4Sema25ActOnStartOfObjCMethodDefEPNS_5ScopeEPNS_4DeclE", "clang::Sema::ActOnStartOfObjCMethodDef(clang::Scope*, clang::Decl*)"},
    {"_ZN5clang4Sema24ActOnStartClassInterfaceENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_PKPNS_4DeclEjPKS1_S1_PNS_13AttributeListE", "clang::Sema::ActOnStartClassInterface(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Decl* const*, unsigned int, clang::SourceLocation const*, clang::SourceLocation, clang::AttributeList*)"},
    {"_ZN5clang4Sema18CheckObjCDeclScopeEPNS_4DeclE", "clang::Sema::CheckObjCDeclScope(clang::Decl*)"},
    {"_ZN5clang4Sema22ActOnCompatiblityAliasENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_", "clang::Sema::ActOnCompatiblityAlias(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema52CheckForwardProtocolDeclarationForCircularDependencyEPNS_14IdentifierInfoERNS_14SourceLocationES3_RKNS_8ObjCListINS_16ObjCProtocolDeclEEE", "clang::Sema::CheckForwardProtocolDeclarationForCircularDependency(clang::IdentifierInfo*, clang::SourceLocation&, clang::SourceLocation, clang::ObjCList<clang::ObjCProtocolDecl> const&)"},
    {"_ZN5clang4Sema27ActOnStartProtocolInterfaceENS_14SourceLocationEPNS_14IdentifierInfoES1_PKPNS_4DeclEjPKS1_S1_PNS_13AttributeListE", "clang::Sema::ActOnStartProtocolInterface(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Decl* const*, unsigned int, clang::SourceLocation const*, clang::SourceLocation, clang::AttributeList*)"},
    {"_ZN5clang4Sema23FindProtocolDeclarationEbPKSt4pairIPNS_14IdentifierInfoENS_14SourceLocationEEjRN4llvm15SmallVectorImplIPNS_4DeclEEE", "clang::Sema::FindProtocolDeclaration(bool, std::pair<clang::IdentifierInfo*, clang::SourceLocation> const*, unsigned int, llvm::SmallVectorImpl<clang::Decl*>&)"},
    {"_ZN5clang4Sema32DiagnoseClassExtensionDupMethodsEPNS_16ObjCCategoryDeclEPNS_17ObjCInterfaceDeclE", "clang::Sema::DiagnoseClassExtensionDupMethods(clang::ObjCCategoryDecl*, clang::ObjCInterfaceDecl*)"},
    {"_ZN5clang4Sema26MatchTwoMethodDeclarationsEPKNS_14ObjCMethodDeclES3_bb", "clang::Sema::MatchTwoMethodDeclarations(clang::ObjCMethodDecl const*, clang::ObjCMethodDecl const*, bool, bool)"},
    {"_ZN5clang4Sema31ActOnForwardProtocolDeclarationENS_14SourceLocationEPKSt4pairIPNS_14IdentifierInfoES1_EjPNS_13AttributeListE", "clang::Sema::ActOnForwardProtocolDeclaration(clang::SourceLocation, std::pair<clang::IdentifierInfo*, clang::SourceLocation> const*, unsigned int, clang::AttributeList*)"},
    {"_ZN5clang4Sema27ActOnStartCategoryInterfaceENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_PKPNS_4DeclEjPKS1_S1_", "clang::Sema::ActOnStartCategoryInterface(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::Decl* const*, unsigned int, clang::SourceLocation const*, clang::SourceLocation)"},
    {"_ZN5clang4Sema32ActOnStartCategoryImplementationENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_", "clang::Sema::ActOnStartCategoryImplementation(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema29ActOnStartClassImplementationENS_14SourceLocationEPNS_14IdentifierInfoES1_S3_S1_", "clang::Sema::ActOnStartClassImplementation(clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation, clang::IdentifierInfo*, clang::SourceLocation)"},
    {"_ZN5clang4Sema24CheckImplementationIvarsEPNS_22ObjCImplementationDeclEPPNS_12ObjCIvarDeclEjNS_14SourceLocationE", "clang::Sema::CheckImplementationIvars(clang::ObjCImplementationDecl*, clang::ObjCIvarDecl**, unsigned int, clang::SourceLocation)"},
    {"_ZN5clang4Sema19WarnUndefinedMethodENS_14SourceLocationEPNS_14ObjCMethodDeclERbj", "clang::Sema::WarnUndefinedMethod(clang::SourceLocation, clang::ObjCMethodDecl*, bool&, unsigned int)"},
    {"_ZN5clang4Sema27WarnConflictingTypedMethodsEPNS_14ObjCMethodDeclES2_", "clang::Sema::WarnConflictingTypedMethods(clang::ObjCMethodDecl*, clang::ObjCMethodDecl*)"},
    {"_ZN5clang4Sema23CheckProtocolMethodDefsENS_14SourceLocationEPNS_16ObjCProtocolDeclERbRKN4llvm8DenseSetINS_8SelectorENS5_12DenseMapInfoIS7_EEEESC_PNS_17ObjCContainerDeclE", "clang::Sema::CheckProtocolMethodDefs(clang::SourceLocation, clang::ObjCProtocolDecl*, bool&, llvm::DenseSet<clang::Selector, llvm::DenseMapInfo<clang::Selector> > const&, llvm::DenseSet<clang::Selector, llvm::DenseMapInfo<clang::Selector> > const&, clang::ObjCContainerDecl*)"},
    {"_ZN5clang4Sema26MatchAllMethodDeclarationsERKN4llvm8DenseSetINS_8SelectorENS1_12DenseMapInfoIS3_EEEES8_RS6_S9_PNS_12ObjCImplDeclEPNS_17ObjCContainerDeclERbb", "clang::Sema::MatchAllMethodDeclarations(llvm::DenseSet<clang::Selector, llvm::DenseMapInfo<clang::Selector> > const&, llvm::DenseSet<clang::Selector, llvm::DenseMapInfo<clang::Selector> > const&, llvm::DenseSet<clang::Selector, llvm::DenseMapInfo<clang::Selector> >&, llvm::DenseSet<clang::Selector, llvm::DenseMapInfo<clang::Selector> >&, clang::ObjCImplDecl*, clang::ObjCContainerDecl*, bool&, bool)"},
    {"_ZN5clang4Sema25ImplMethodsVsClassMethodsEPNS_5ScopeEPNS_12ObjCImplDeclEPNS_17ObjCContainerDeclEb", "clang::Sema::ImplMethodsVsClassMethods(clang::Scope*, clang::ObjCImplDecl*, clang::ObjCContainerDecl*, bool)"},
    {"_ZN5clang4Sema28ActOnForwardClassDeclarationENS_14SourceLocationEPPNS_14IdentifierInfoEPS1_j", "clang::Sema::ActOnForwardClassDeclaration(clang::SourceLocation, clang::IdentifierInfo**, clang::SourceLocation*, unsigned int)"},
    {"_ZN5clang4Sema14ReadMethodPoolENS_8SelectorE", "clang::Sema::ReadMethodPool(clang::Selector)"},
    {"_ZN5clang4Sema21AddMethodToGlobalPoolEPNS_14ObjCMethodDeclEbb", "clang::Sema::AddMethodToGlobalPool(clang::ObjCMethodDecl*, bool, bool)"},
    {"_ZN5clang4Sema24LookupMethodInGlobalPoolENS_8SelectorENS_11SourceRangeEbbb", "clang::Sema::LookupMethodInGlobalPool(clang::Selector, clang::SourceRange, bool, bool, bool)"},
    {"_ZN5clang4Sema35LookupImplementedMethodInGlobalPoolENS_8SelectorE", "clang::Sema::LookupImplementedMethodInGlobalPool(clang::Selector)"},
    {"_ZN5clang4Sema33CompareMethodParamsInBaseAndSuperEPNS_4DeclEPNS_14ObjCMethodDeclEb", "clang::Sema::CompareMethodParamsInBaseAndSuper(clang::Decl*, clang::ObjCMethodDecl*, bool)"},
    {"_ZN5clang4Sema22DiagnoseDuplicateIvarsEPNS_17ObjCInterfaceDeclES2_", "clang::Sema::DiagnoseDuplicateIvars(clang::ObjCInterfaceDecl*, clang::ObjCInterfaceDecl*)"},
    {"_ZN5clang4Sema10ActOnAtEndEPNS_5ScopeENS_11SourceRangeEPNS_4DeclEPS5_jS6_jPNS_9OpaquePtrINS_12DeclGroupRefEEEj", "clang::Sema::ActOnAtEnd(clang::Scope*, clang::SourceRange, clang::Decl*, clang::Decl**, unsigned int, clang::Decl**, unsigned int, clang::OpaquePtr<clang::DeclGroupRef>*, unsigned int)"},
    {"_ZN5clang4Sema22ActOnMethodDeclarationEPNS_5ScopeENS_14SourceLocationES3_NS_3tok9TokenKindEPNS_4DeclERNS_12ObjCDeclSpecENS_9OpaquePtrINS_8QualTypeEEENS_8SelectorEPNS0_11ObjCArgInfoEPNS_15DeclaratorChunk9ParamInfoEjPNS_13AttributeListENS4_15ObjCKeywordKindEb", "clang::Sema::ActOnMethodDeclaration(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::tok::TokenKind, clang::Decl*, clang::ObjCDeclSpec&, clang::OpaquePtr<clang::QualType>, clang::Selector, clang::Sema::ObjCArgInfo*, clang::DeclaratorChunk::ParamInfo*, unsigned int, clang::AttributeList*, clang::tok::ObjCKeywordKind, bool)"},
    {"_ZN5clang4Sema9ActOnDefsEPNS_5ScopeEPNS_4DeclENS_14SourceLocationEPNS_14IdentifierInfoERN4llvm15SmallVectorImplIS4_EE", "clang::Sema::ActOnDefs(clang::Scope*, clang::Decl*, clang::SourceLocation, clang::IdentifierInfo*, llvm::SmallVectorImpl<clang::Decl*>&)"},
    {"_ZN5clang4Sema22BuildObjCExceptionDeclEPNS_14TypeSourceInfoENS_8QualTypeEPNS_14IdentifierInfoENS_14SourceLocationEb", "clang::Sema::BuildObjCExceptionDecl(clang::TypeSourceInfo*, clang::QualType, clang::IdentifierInfo*, clang::SourceLocation, bool)"},
    {"_ZN5clang4Sema22ActOnObjCExceptionDeclEPNS_5ScopeERNS_10DeclaratorE", "clang::Sema::ActOnObjCExceptionDecl(clang::Scope*, clang::Declarator&)"},
    {"_ZN5clang4Sema33CollectIvarsToConstructOrDestructEPNS_17ObjCInterfaceDeclERN4llvm15SmallVectorImplIPNS_12ObjCIvarDeclEEE", "clang::Sema::CollectIvarsToConstructOrDestruct(clang::ObjCInterfaceDecl*, llvm::SmallVectorImpl<clang::ObjCIvarDecl*>&)"},
    {"_ZN5clang22ObjCImplementationDecl19setIvarInitializersERNS_10ASTContextEPPNS_18CXXCtorInitializerEj", "clang::ObjCImplementationDecl::setIvarInitializers(clang::ASTContext&, clang::CXXCtorInitializer**, unsigned int)"},
    {"_ZN5clang4Sema35DiagnoseUseOfUnimplementedSelectorsEv", "clang::Sema::DiagnoseUseOfUnimplementedSelectors()"},
    {"_Z23isObjCTypeSubstitutableRN5clang10ASTContextEPKNS_21ObjCObjectPointerTypeES4_b", "isObjCTypeSubstitutable(clang::ASTContext&, clang::ObjCObjectPointerType const*, clang::ObjCObjectPointerType const*, bool)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorESt4pairINS1_14ObjCMethodListES4_ENS_12DenseMapInfoIS2_EENS6_IS5_EEE6insertERKS3_IS2_S5_E", "llvm::DenseMap<clang::Selector, std::pair<clang::ObjCMethodList, clang::ObjCMethodList>, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<std::pair<clang::ObjCMethodList, clang::ObjCMethodList> > >::insert(std::pair<clang::Selector, std::pair<clang::ObjCMethodList, clang::ObjCMethodList> > const&)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorESt4pairINS1_14ObjCMethodListES4_ENS_12DenseMapInfoIS2_EENS6_IS5_EEE16InsertIntoBucketERKS2_RKS5_PS3_IS2_S5_E", "llvm::DenseMap<clang::Selector, std::pair<clang::ObjCMethodList, clang::ObjCMethodList>, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<std::pair<clang::ObjCMethodList, clang::ObjCMethodList> > >::InsertIntoBucket(clang::Selector const&, std::pair<clang::ObjCMethodList, clang::ObjCMethodList> const&, std::pair<clang::Selector, std::pair<clang::ObjCMethodList, clang::ObjCMethodList> >*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorESt4pairINS1_14ObjCMethodListES4_ENS_12DenseMapInfoIS2_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::Selector, std::pair<clang::ObjCMethodList, clang::ObjCMethodList>, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<std::pair<clang::ObjCMethodList, clang::ObjCMethodList> > >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEcNS_12DenseMapInfoIS2_EENS3_IcEEE6insertERKSt4pairIS2_cE", "llvm::DenseMap<clang::Selector, char, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<char> >::insert(std::pair<clang::Selector, char> const&)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEcNS_12DenseMapInfoIS2_EENS3_IcEEE16InsertIntoBucketERKS2_RKcPSt4pairIS2_cE", "llvm::DenseMap<clang::Selector, char, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<char> >::InsertIntoBucket(clang::Selector const&, char const&, std::pair<clang::Selector, char>*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEcNS_12DenseMapInfoIS2_EENS3_IcEEE4growEj", "llvm::DenseMap<clang::Selector, char, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<char> >::grow(unsigned int)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEPKNS1_14ObjCMethodDeclENS_12DenseMapInfoIS2_EENS6_IS5_EEE16InsertIntoBucketERKS2_RKS5_PSt4pairIS2_S5_E", "llvm::DenseMap<clang::Selector, clang::ObjCMethodDecl const*, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<clang::ObjCMethodDecl const*> >::InsertIntoBucket(clang::Selector const&, clang::ObjCMethodDecl const* const&, std::pair<clang::Selector, clang::ObjCMethodDecl const*>*)"},
    {"_ZN4llvm8DenseMapIN5clang8SelectorEPKNS1_14ObjCMethodDeclENS_12DenseMapInfoIS2_EENS6_IS5_EEE4growEj", "llvm::DenseMap<clang::Selector, clang::ObjCMethodDecl const*, llvm::DenseMapInfo<clang::Selector>, llvm::DenseMapInfo<clang::ObjCMethodDecl const*> >::grow(unsigned int)"},
    {"_ZN5clang4Sema27CheckSpecifiedExceptionTypeENS_8QualTypeERKNS_11SourceRangeE", "clang::Sema::CheckSpecifiedExceptionType(clang::QualType, clang::SourceRange const&)"},
    {"_ZN5clang4Sema25CheckDistantExceptionSpecENS_8QualTypeE", "clang::Sema::CheckDistantExceptionSpec(clang::QualType)"},
    {"_ZN5clang4Sema28CheckEquivalentExceptionSpecEPNS_12FunctionDeclES2_", "clang::Sema::CheckEquivalentExceptionSpec(clang::FunctionDecl*, clang::FunctionDecl*)"},
    {"_ZN5clang4Sema28CheckEquivalentExceptionSpecERKNS_17PartialDiagnosticES3_PKNS_17FunctionProtoTypeENS_14SourceLocationES6_S7_PbS8_", "clang::Sema::CheckEquivalentExceptionSpec(clang::PartialDiagnostic const&, clang::PartialDiagnostic const&, clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation, bool*, bool*)"},
    {"_ZN5clang4Sema28CheckEquivalentExceptionSpecEPKNS_17FunctionProtoTypeENS_14SourceLocationES3_S4_", "clang::Sema::CheckEquivalentExceptionSpec(clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation)"},
    {"_ZN5clang4Sema24CheckExceptionSpecSubsetERKNS_17PartialDiagnosticES3_PKNS_17FunctionProtoTypeENS_14SourceLocationES6_S7_", "clang::Sema::CheckExceptionSpecSubset(clang::PartialDiagnostic const&, clang::PartialDiagnostic const&, clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation)"},
    {"_ZN5clang4Sema23CheckParamExceptionSpecERKNS_17PartialDiagnosticEPKNS_17FunctionProtoTypeENS_14SourceLocationES6_S7_", "clang::Sema::CheckParamExceptionSpec(clang::PartialDiagnostic const&, clang::FunctionProtoType const*, clang::SourceLocation, clang::FunctionProtoType const*, clang::SourceLocation)"},
    {"_ZN5clang4Sema31CheckExceptionSpecCompatibilityEPNS_4ExprENS_8QualTypeE", "clang::Sema::CheckExceptionSpecCompatibility(clang::Expr*, clang::QualType)"},
    {"_ZN5clang21GetUnderlyingFunctionENS_8QualTypeE", "clang::GetUnderlyingFunction(clang::QualType)"},
    {"_ZN5clang4Sema36CheckOverridingFunctionExceptionSpecEPKNS_13CXXMethodDeclES3_", "clang::Sema::CheckOverridingFunctionExceptionSpec(clang::CXXMethodDecl const*, clang::CXXMethodDecl const*)"},
    {"_ZN5clang4Sema17DiagnoseUseOfDeclEPNS_9NamedDeclENS_14SourceLocationEb", "clang::Sema::DiagnoseUseOfDecl(clang::NamedDecl*, clang::SourceLocation, bool)"},
    {"_ZN5clang4Sema21DiagnoseSentinelCallsEPNS_9NamedDeclENS_14SourceLocationEPPNS_4ExprEj", "clang::Sema::DiagnoseSentinelCalls(clang::NamedDecl*, clang::SourceLocation, clang::Expr**, unsigned int)"},
    {"_ZNK5clang4Sema12getExprRangeEPNS_4ExprE", "clang::Sema::getExprRange(clang::Expr*) const"},
    {"_ZN5clang4Sema30DefaultFunctionArrayConversionERPNS_4ExprE", "clang::Sema::DefaultFunctionArrayConversion(clang::Expr*&)"},
    {"_ZN5clang4Sema23DefaultLvalueConversionERPNS_4ExprE", "clang::Sema::DefaultLvalueConversion(clang::Expr*&)"},
    {"_ZN5clang4Sema24ConvertPropertyForRValueERPNS_4ExprE", "clang::Sema::ConvertPropertyForRValue(clang::Expr*&)"},
    {"_ZN5clang4Sema36DefaultFunctionArrayLvalueConversionERPNS_4ExprE", "clang::Sema::DefaultFunctionArrayLvalueConversion(clang::Expr*&)"},
    {"_ZN5clang4Sema21UsualUnaryConversionsERPNS_4ExprE", "clang::Sema::UsualUnaryConversions(clang::Expr*&)"},
    {"_ZN5clang4Sema24DefaultArgumentPromotionERPNS_4ExprE", "clang::Sema::DefaultArgumentPromotion(clang::Expr*&)"},
    {"_ZN5clang4Sema32DefaultVariadicArgumentPromotionERPNS_4ExprENS0_16VariadicCallTypeEPNS_12FunctionDeclE", "clang::Sema::DefaultVariadicArgumentPromotion(clang::Expr*&, clang::Sema::VariadicCallType, clang::FunctionDecl*)"},
    {"_ZN5clang4Sema19DiagRuntimeBehaviorENS_14SourceLocationERKNS_17PartialDiagnosticE", "clang::Sema::DiagRuntimeBehavior(clang::SourceLocation, clang::PartialDiagnostic const&)"},
    {"_ZN5clang4Sema26UsualArithmeticConversionsERPNS_4ExprES3_b", "clang::Sema::UsualArithmeticConversions(clang::Expr*&, clang::Expr*&, bool)"},
    {"_ZN5clang4Sema18ActOnStringLiteralEPKNS_5TokenEj", "clang::Sema::ActOnStringLiteral(clang::Token const*, unsigned int)"},
    {"_ZN5clang4Sema16BuildDeclRefExprEPNS_9ValueDeclENS_8QualTypeENS_13ExprValueKindENS_14SourceLocationEPKNS_12CXXScopeSpecE", "clang::Sema::BuildDeclRefExpr(clang::ValueDecl*, clang::QualType, clang::ExprValueKind, clang::SourceLocation, clang::CXXScopeSpec const*)"},
    {"_ZN5clang4Sema16BuildDeclRefExprEPNS_9ValueDeclENS_8QualTypeENS_13ExprValueKindERKNS_19DeclarationNameInfoEPKNS_12CXXScopeSpecE", "clang::Sema::BuildDeclRefExpr(clang::ValueDecl*, clang::QualType, clang::ExprValueKind, clang::DeclarationNameInfo const&, clang::CXXScopeSpec const*)"},
    {"_ZN5clang4Sema25MarkDeclarationReferencedENS_14SourceLocationEPNS_4DeclE", "clang::Sema::MarkDeclarationReferenced(clang::SourceLocation, clang::Decl*)"},
    {"_ZN5clang4Sema40BuildAnonymousStructUnionMemberReferenceERKNS_12CXXScopeSpecENS_14SourceLocationEPNS_17IndirectFieldDeclEPNS_4ExprES4_", "clang::Sema::BuildAnonymousStructUnionMemberReference(clang::CXXScopeSpec const&, clang::SourceLocation, clang::IndirectFieldDecl*, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema24BuildDeclarationNameExprERKNS_12CXXScopeSpecERKNS_19DeclarationNameInfoEPNS_9NamedDeclE", "clang::Sema::BuildDeclarationNameExpr(clang::CXXScopeSpec const&, clang::DeclarationNameInfo const&, clang::NamedDecl*)"},
    {"_Z23BuildFieldReferenceExprRN5clang4SemaEPNS_4ExprEbRKNS_12CXXScopeSpecEPNS_9FieldDeclENS_14DeclAccessPairERKNS_19DeclarationNameInfoE", "BuildFieldReferenceExpr(clang::Sema&, clang::Expr*, bool, clang::CXXScopeSpec const&, clang::FieldDecl*, clang::DeclAccessPair, clang::DeclarationNameInfo const&)"},
    {"_ZN5clang4Sema19DiagnoseEmptyLookupEPNS_5ScopeERNS_12CXXScopeSpecERNS_12LookupResultENS0_18CorrectTypoContextE", "clang::Sema::DiagnoseEmptyLookup(clang::Scope*, clang::CXXScopeSpec&, clang::LookupResult&, clang::Sema::CorrectTypoContext)"},
    {"_ZN5clang4Sema28canSynthesizeProvisionalIvarEPNS_14IdentifierInfoE", "clang::Sema::canSynthesizeProvisionalIvar(clang::IdentifierInfo*)"},
    {"_ZN5clang4Sema28canSynthesizeProvisionalIvarEPNS_16ObjCPropertyDeclE", "clang::Sema::canSynthesizeProvisionalIvar(clang::ObjCPropertyDecl*)"},
    {"_ZN5clang4Sema17ActOnIdExpressionEPNS_5ScopeERNS_12CXXScopeSpecERNS_13UnqualifiedIdEbb", "clang::Sema::ActOnIdExpression(clang::Scope*, clang::CXXScopeSpec&, clang::UnqualifiedId&, bool, bool)"},
    {"_Z22DecomposeUnqualifiedIdRN5clang4SemaERKNS_13UnqualifiedIdERNS_24TemplateArgumentListInfoERNS_19DeclarationNameInfoERPKS5_", "DecomposeUnqualifiedId(clang::Sema&, clang::UnqualifiedId const&, clang::TemplateArgumentListInfo&, clang::DeclarationNameInfo&, clang::TemplateArgumentListInfo const*&)"},
    {"_ZN5clang4Sema18LookupInObjCMethodERNS_12LookupResultEPNS_5ScopeEPNS_14IdentifierInfoEb", "clang::Sema::LookupInObjCMethod(clang::LookupResult&, clang::Scope*, clang::IdentifierInfo*, bool)"},
    {"_ZN5clang4Sema26UseArgumentDependentLookupERKNS_12CXXScopeSpecERKNS_12LookupResultEb", "clang::Sema::UseArgumentDependentLookup(clang::CXXScopeSpec const&, clang::LookupResult const&, bool)"},
    {"_ZN5clang4Sema31BuildPossibleImplicitMemberExprERKNS_12CXXScopeSpecERNS_12LookupResultEPKNS_24TemplateArgumentListInfoE", "clang::Sema::BuildPossibleImplicitMemberExpr(clang::CXXScopeSpec const&, clang::LookupResult&, clang::TemplateArgumentListInfo const*)"},
    {"_ZN5clang4Sema24BuildDeclarationNameExprERKNS_12CXXScopeSpecERNS_12LookupResultEb", "clang::Sema::BuildDeclarationNameExpr(clang::CXXScopeSpec const&, clang::LookupResult&, bool)"},
    {"_ZN5clang4Sema23BuildImplicitMemberExprERKNS_12CXXScopeSpecERNS_12LookupResultEPKNS_24TemplateArgumentListInfoEb", "clang::Sema::BuildImplicitMemberExpr(clang::CXXScopeSpec const&, clang::LookupResult&, clang::TemplateArgumentListInfo const*, bool)"},
    {"_Z25DiagnoseInstanceReferenceRN5clang4SemaERKNS_12CXXScopeSpecEPNS_9NamedDeclERKNS_19DeclarationNameInfoE", "DiagnoseInstanceReference(clang::Sema&, clang::CXXScopeSpec const&, clang::NamedDecl*, clang::DeclarationNameInfo const&)"},
    {"_ZN5clang4Sema33BuildQualifiedDeclarationNameExprERNS_12CXXScopeSpecERKNS_19DeclarationNameInfoE", "clang::Sema::BuildQualifiedDeclarationNameExpr(clang::CXXScopeSpec&, clang::DeclarationNameInfo const&)"},
    {"_ZN5clang4Sema29PerformObjectMemberConversionERPNS_4ExprEPNS_19NestedNameSpecifierEPNS_9NamedDeclES7_", "clang::Sema::PerformObjectMemberConversion(clang::Expr*&, clang::NestedNameSpecifier*, clang::NamedDecl*, clang::NamedDecl*)"},
    {"_ZN5clang4Sema24BuildMemberReferenceExprEPNS_4ExprENS_8QualTypeENS_14SourceLocationEbRKNS_12CXXScopeSpecEPNS_9NamedDeclERNS_12LookupResultEPKNS_24TemplateArgumentListInfoEb", "clang::Sema::BuildMemberReferenceExpr(clang::Expr*, clang::QualType, clang::SourceLocation, bool, clang::CXXScopeSpec const&, clang::NamedDecl*, clang::LookupResult&, clang::TemplateArgumentListInfo const*, bool)"},
    {"_Z15CheckDeclInExprRN5clang4SemaENS_14SourceLocationEPNS_9NamedDeclE", "CheckDeclInExpr(clang::Sema&, clang::SourceLocation, clang::NamedDecl*)"},
    {"_Z21BuildBlockDeclRefExprRN5clang4SemaEPNS_9ValueDeclERKNS_19DeclarationNameInfoEb", "BuildBlockDeclRefExpr(clang::Sema&, clang::ValueDecl*, clang::DeclarationNameInfo const&, bool)"},
    {"_ZN5clang4Sema19ActOnPredefinedExprENS_14SourceLocationENS_3tok9TokenKindE", "clang::Sema::ActOnPredefinedExpr(clang::SourceLocation, clang::tok::TokenKind)"},
    {"_ZN5clang4Sema22ActOnCharacterConstantERKNS_5TokenE", "clang::Sema::ActOnCharacterConstant(clang::Token const&)"},
    {"_ZN5clang4Sema20ActOnNumericConstantERKNS_5TokenE", "clang::Sema::ActOnNumericConstant(clang::Token const&)"},
    {"_ZN5clang4Sema14ActOnParenExprENS_14SourceLocationES1_PNS_4ExprE", "clang::Sema::ActOnParenExpr(clang::SourceLocation, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema25CheckSizeOfAlignOfOperandENS_8QualTypeENS_14SourceLocationENS_11SourceRangeEb", "clang::Sema::CheckSizeOfAlignOfOperand(clang::QualType, clang::SourceLocation, clang::SourceRange, bool)"},
    {"_ZN5clang4Sema23CreateSizeOfAlignOfExprEPNS_14TypeSourceInfoENS_14SourceLocationEbNS_11SourceRangeE", "clang::Sema::CreateSizeOfAlignOfExpr(clang::TypeSourceInfo*, clang::SourceLocation, bool, clang::SourceRange)"},
    {"_ZN5clang4Sema23CreateSizeOfAlignOfExprEPNS_4ExprENS_14SourceLocationEbNS_11SourceRangeE", "clang::Sema::CreateSizeOfAlignOfExpr(clang::Expr*, clang::SourceLocation, bool, clang::SourceRange)"},
    {"_ZN5clang4Sema20CheckPlaceholderExprEPNS_4ExprENS_14SourceLocationE", "clang::Sema::CheckPlaceholderExpr(clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema22ActOnSizeOfAlignOfExprENS_14SourceLocationEbbPvRKNS_11SourceRangeE", "clang::Sema::ActOnSizeOfAlignOfExpr(clang::SourceLocation, bool, bool, void*, clang::SourceRange const&)"},
    {"_ZN5clang4Sema19ActOnPostfixUnaryOpEPNS_5ScopeENS_14SourceLocationENS_3tok9TokenKindEPNS_4ExprE", "clang::Sema::ActOnPostfixUnaryOp(clang::Scope*, clang::SourceLocation, clang::tok::TokenKind, clang::Expr*)"},
    {"_ZN5clang4Sema12BuildUnaryOpEPNS_5ScopeENS_14SourceLocationENS_17UnaryOperatorKindEPNS_4ExprE", "clang::Sema::BuildUnaryOp(clang::Scope*, clang::SourceLocation, clang::UnaryOperatorKind, clang::Expr*)"},
    {"_ZN5clang4Sema23ActOnArraySubscriptExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationES4_S5_", "clang::Sema::ActOnArraySubscriptExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema36MaybeConvertParenListExprToParenExprEPNS_5ScopeEPNS_4ExprE", "clang::Sema::MaybeConvertParenListExprToParenExpr(clang::Scope*, clang::Expr*)"},
    {"_ZN5clang4Sema31CreateBuiltinArraySubscriptExprEPNS_4ExprENS_14SourceLocationES2_S3_", "clang::Sema::CreateBuiltinArraySubscriptExpr(clang::Expr*, clang::SourceLocation, clang::Expr*, clang::SourceLocation)"},
    {"_ZN5clang4Sema24ActOnDependentMemberExprEPNS_4ExprENS_8QualTypeEbNS_14SourceLocationERKNS_12CXXScopeSpecEPNS_9NamedDeclERKNS_19DeclarationNameInfoEPKNS_24TemplateArgumentListInfoE", "clang::Sema::ActOnDependentMemberExpr(clang::Expr*, clang::QualType, bool, clang::SourceLocation, clang::CXXScopeSpec const&, clang::NamedDecl*, clang::DeclarationNameInfo const&, clang::TemplateArgumentListInfo const*)"},
    {"_ZN5clang4Sema29CheckQualifiedMemberReferenceEPNS_4ExprENS_8QualTypeERKNS_12CXXScopeSpecERKNS_12LookupResultE", "clang::Sema::CheckQualifiedMemberReference(clang::Expr*, clang::QualType, clang::CXXScopeSpec const&, clang::LookupResult const&)"},
    {"_Z24IsProvablyNotDerivedFromRN5clang4SemaEPNS_13CXXRecordDeclERKN4llvm11SmallPtrSetIS3_Lj4EEE", "IsProvablyNotDerivedFrom(clang::Sema&, clang::CXXRecordDecl*, llvm::SmallPtrSet<clang::CXXRecordDecl*, 4u> const&)"},
    {"_ZN5clang4Sema24BuildMemberReferenceExprEPNS_4ExprENS_8QualTypeENS_14SourceLocationEbRNS_12CXXScopeSpecEPNS_9NamedDeclERKNS_19DeclarationNameInfoEPKNS_24TemplateArgumentListInfoE", "clang::Sema::BuildMemberReferenceExpr(clang::Expr*, clang::QualType, clang::SourceLocation, bool, clang::CXXScopeSpec&, clang::NamedDecl*, clang::DeclarationNameInfo const&, clang::TemplateArgumentListInfo const*)"},
    {"_Z24LookupMemberExprInRecordRN5clang4SemaERNS_12LookupResultENS_11SourceRangeEPKNS_10RecordTypeENS_14SourceLocationERNS_12CXXScopeSpecEb", "LookupMemberExprInRecord(clang::Sema&, clang::LookupResult&, clang::SourceRange, clang::RecordType const*, clang::SourceLocation, clang::CXXScopeSpec&, bool)"},
    {"_ZN5clang4Sema16LookupMemberExprERNS_12LookupResultERPNS_4ExprERbNS_14SourceLocationERNS_12CXXScopeSpecEPNS_4DeclEb", "clang::Sema::LookupMemberExpr(clang::LookupResult&, clang::Expr*&, bool&, clang::SourceLocation, clang::CXXScopeSpec&, clang::Decl*, bool)"},
    {"_Z34ShouldTryAgainWithRedefinitionTypeRN5clang4SemaERPNS_4ExprE", "ShouldTryAgainWithRedefinitionType(clang::Sema&, clang::Expr*&)"},
    {"_Z24FindGetterSetterNameDeclPKN5clang21ObjCObjectPointerTypeEPNS_14IdentifierInfoERKNS_8SelectorERNS_10ASTContextE", "FindGetterSetterNameDecl(clang::ObjCObjectPointerType const*, clang::IdentifierInfo*, clang::Selector const&, clang::ASTContext&)"},
    {"_ZN5clang4Sema13ActOnCallExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationENS_11ASTMultiPtrIS4_EES5_S4_", "clang::Sema::ActOnCallExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema21ActOnMemberAccessExprEPNS_5ScopeEPNS_4ExprENS_14SourceLocationENS_3tok9TokenKindERNS_12CXXScopeSpecERNS_13UnqualifiedIdEPNS_4DeclEb", "clang::Sema::ActOnMemberAccessExpr(clang::Scope*, clang::Expr*, clang::SourceLocation, clang::tok::TokenKind, clang::CXXScopeSpec&, clang::UnqualifiedId&, clang::Decl*, bool)"},
    {"_ZN5clang4Sema22BuildCXXDefaultArgExprENS_14SourceLocationEPNS_12FunctionDeclEPNS_11ParmVarDeclE", "clang::Sema::BuildCXXDefaultArgExpr(clang::SourceLocation, clang::FunctionDecl*, clang::ParmVarDecl*)"},
    {"_ZN5clang4Sema32MarkDeclarationsReferencedInExprEPNS_4ExprE", "clang::Sema::MarkDeclarationsReferencedInExpr(clang::Expr*)"},
    {"_ZN5clang4Sema23ConvertArgumentsForCallEPNS_8CallExprEPNS_4ExprEPNS_12FunctionDeclEPKNS_17FunctionProtoTypeEPS4_jNS_14SourceLocationE", "clang::Sema::ConvertArgumentsForCall(clang::CallExpr*, clang::Expr*, clang::FunctionDecl*, clang::FunctionProtoType const*, clang::Expr**, unsigned int, clang::SourceLocation)"},
    {"_ZN5clang4Sema22GatherArgumentsForCallENS_14SourceLocationEPNS_12FunctionDeclEPKNS_17FunctionProtoTypeEjPPNS_4ExprEjRN4llvm11SmallVectorIS8_Lj8EEENS0_16VariadicCallTypeE", "clang::Sema::GatherArgumentsForCall(clang::SourceLocation, clang::FunctionDecl*, clang::FunctionProtoType const*, unsigned int, clang::Expr**, unsigned int, llvm::SmallVector<clang::Expr*, 8u>&, clang::Sema::VariadicCallType)"},
    {"_ZN5clang4Sema19CheckCallReturnTypeENS_8QualTypeENS_14SourceLocationEPNS_8CallExprEPNS_12FunctionDeclE", "clang::Sema::CheckCallReturnType(clang::QualType, clang::SourceLocation, clang::CallExpr*, clang::FunctionDecl*)"},
    {"_ZN5clang4Sema21BuildResolvedCallExprEPNS_4ExprEPNS_9NamedDeclENS_14SourceLocationEPS2_jS5_S2_", "clang::Sema::BuildResolvedCallExpr(clang::Expr*, clang::NamedDecl*, clang::SourceLocation, clang::Expr**, unsigned int, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema23ActOnCUDAExecConfigExprEPNS_5ScopeENS_14SourceLocationENS_11ASTMultiPtrIPNS_4ExprEEES3_", "clang::Sema::ActOnCUDAExecConfigExpr(clang::Scope*, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation)"},
    {"_ZN5clang4Sema20ActOnCompoundLiteralENS_14SourceLocationENS_9OpaquePtrINS_8QualTypeEEES1_PNS_4ExprE", "clang::Sema::ActOnCompoundLiteral(clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema24BuildCompoundLiteralExprENS_14SourceLocationEPNS_14TypeSourceInfoES1_PNS_4ExprE", "clang::Sema::BuildCompoundLiteralExpr(clang::SourceLocation, clang::TypeSourceInfo*, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema13ActOnInitListENS_14SourceLocationENS_11ASTMultiPtrIPNS_4ExprEEES1_", "clang::Sema::ActOnInitList(clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::SourceLocation)"},
    {"_ZN5clang4Sema14CheckCastTypesENS_11SourceRangeENS_8QualTypeERPNS_4ExprERNS_8CastKindERNS_13ExprValueKindERN4llvm11SmallVectorIPNS_16CXXBaseSpecifierELj4EEEb", "clang::Sema::CheckCastTypes(clang::SourceRange, clang::QualType, clang::Expr*&, clang::CastKind&, clang::ExprValueKind&, llvm::SmallVector<clang::CXXBaseSpecifier*, 4u>&, bool)"},
    {"_ZN5clang4Sema18CheckExtVectorCastENS_11SourceRangeENS_8QualTypeERPNS_4ExprERNS_8CastKindE", "clang::Sema::CheckExtVectorCast(clang::SourceRange, clang::QualType, clang::Expr*&, clang::CastKind&)"},
    {"_ZN5clang4Sema15CheckVectorCastENS_11SourceRangeENS_8QualTypeES2_RNS_8CastKindE", "clang::Sema::CheckVectorCast(clang::SourceRange, clang::QualType, clang::QualType, clang::CastKind&)"},
    {"_Z17PrepareScalarCastRN5clang4SemaERPNS_4ExprENS_8QualTypeE", "PrepareScalarCast(clang::Sema&, clang::Expr*&, clang::QualType)"},
    {"_ZN5clang4Sema13ActOnCastExprEPNS_5ScopeENS_14SourceLocationENS_9OpaquePtrINS_8QualTypeEEES3_PNS_4ExprE", "clang::Sema::ActOnCastExpr(clang::Scope*, clang::SourceLocation, clang::OpaquePtr<clang::QualType>, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema24ActOnCastOfParenListExprEPNS_5ScopeENS_14SourceLocationES3_PNS_4ExprEPNS_14TypeSourceInfoE", "clang::Sema::ActOnCastOfParenListExpr(clang::Scope*, clang::SourceLocation, clang::SourceLocation, clang::Expr*, clang::TypeSourceInfo*)"},
    {"_ZN5clang4Sema19BuildCStyleCastExprENS_14SourceLocationEPNS_14TypeSourceInfoES1_PNS_4ExprE", "clang::Sema::BuildCStyleCastExpr(clang::SourceLocation, clang::TypeSourceInfo*, clang::SourceLocation, clang::Expr*)"},
    {"_ZN5clang4Sema10ActOnBinOpEPNS_5ScopeENS_14SourceLocationENS_3tok9TokenKindEPNS_4ExprES7_", "clang::Sema::ActOnBinOp(clang::Scope*, clang::SourceLocation, clang::tok::TokenKind, clang::Expr*, clang::Expr*)"},
    {"_ZN5clang4Sema25ActOnParenOrParenListExprENS_14SourceLocationES1_NS_11ASTMultiPtrIPNS_4ExprEEENS_9OpaquePtrINS_8QualTypeEEE", "clang::Sema::ActOnParenOrParenListExpr(clang::SourceLocation, clang::SourceLocation, clang::ASTMultiPtr<clang::Expr*>, clang::OpaquePtr<clang::QualType>)"},
    {"_ZN5clang4Sema24CheckConditionalOperandsERPNS_4ExprES3_S3_S3_RNS_13ExprValueKindERNS_14ExprObjectKindENS_14SourceLocationE", "clang::Sema::CheckConditionalOperands(clang::Expr*&, clang::Expr*&, clang::Expr*&, clang::Expr*&, clang::ExprValueKind&, clang::ExprObjectKind&, clang::SourceLocation)"},
    {"_ZN5clang4Sema19CheckVectorOperandsENS_14SourceLocationERPNS_4ExprES4_", "clang::Sema::CheckVectorOperands(clang::SourceLocation, clang::Expr*&, clang::Expr*&)"},
    {"_ZN5clang4Sema28FindCompositeObjCPointerTypeERPNS_4ExprES3_NS_14SourceLocationE", "clang::Sema::FindCompositeObjCPointerType(clang::Expr*&, clang::Expr*&, clang::SourceLocation)"},
    {"_ZN5clang4Sema18ActOnConditionalOpENS_14SourceLocationES1_PNS_4ExprES3_S3_", "clang::Sema::ActOnConditionalOp(clang::SourceLocation, clang::SourceLocation, clang::Expr*, clang::Expr*, clang::Expr*)"},
    {"_ZN5clang4Sema26CheckAssignmentConstraintsENS_14SourceLocationENS_8QualTypeES2_", "clang::Sema::CheckAssignmentConstraints(clang::SourceLocation, clang::QualType, clang::QualType)"},
    {"_ZN5clang4Sema26CheckAssignmentConstraintsENS_8QualTypeERPNS_4ExprERNS_8CastKindE", "clang::Sema::CheckAssignmentConstraints(clang::QualType, clang::Expr*&, clang::CastKind&)"},
    {"_ZN5clang4Sema40CheckTransparentUnionArgumentConstraintsENS_8QualTypeERPNS_4ExprE", "clang::Sema::CheckTransparentUnionArgumentConstraints(clang::QualType, clang::Expr*&)"},
    {"_ZN5clang4Sema32CheckSingleAssignmentConstraintsENS_8QualTypeERPNS_4ExprE", "clang::Sema::CheckSingleAssignmentConstraints(clang::QualType, clang::Expr*&)"},
    {"_ZN5clang4Sema15InvalidOperandsENS_14SourceLocationERPNS_4ExprES4_", "clang::Sema::InvalidOperands(clang::SourceLocation, clang::Expr*&, clang::Expr*&)"},
    {"_ZN5clang4Sema27CheckMultiplyDivideOperandsERPNS_4ExprES3_NS_14SourceLocationEbb", "clang::Sema::CheckMultiplyDivideOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, bool, bool)"},
    {"_ZN5clang4Sema22CheckRemainderOperandsERPNS_4ExprES3_NS_14SourceLocationEb", "clang::Sema::CheckRemainderOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, bool)"},
    {"_ZN5clang4Sema21CheckAdditionOperandsERPNS_4ExprES3_NS_14SourceLocationEPNS_8QualTypeE", "clang::Sema::CheckAdditionOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, clang::QualType*)"},
    {"_ZN5clang4Sema24CheckSubtractionOperandsERPNS_4ExprES3_NS_14SourceLocationEPNS_8QualTypeE", "clang::Sema::CheckSubtractionOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, clang::QualType*)"},
    {"_ZN5clang4Sema18CheckShiftOperandsERPNS_4ExprES3_NS_14SourceLocationEb", "clang::Sema::CheckShiftOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, bool)"},
    {"_ZN5clang4Sema20CheckCompareOperandsERPNS_4ExprES3_NS_14SourceLocationEjb", "clang::Sema::CheckCompareOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, unsigned int, bool)"},
    {"_ZN5clang4Sema26CheckVectorCompareOperandsERPNS_4ExprES3_NS_14SourceLocationEb", "clang::Sema::CheckVectorCompareOperands(clang::Expr*&, clang::Expr*&, clang::SourceLocation, bool)"},
    {"_ZN5clang4Sema23CheckAssignmentOperandsEPNS_4ExprERS2_NS_14SourceLocationENS_8QualTypeE", "clang::Sema::CheckAssignmentOperands(clang::Expr*, clang::Expr*&, clang::SourceLocation, clang::QualType)"},
    {"_Z24CheckForModifiableLvaluePN5clang4ExprENS_14SourceLocationERNS_4SemaE", "CheckForModifiableLvalue(clang::Expr*, clang::SourceLocation, clang::Sema&)"},
    {"_ZN5clang4Sema24ConvertPropertyForLValueERPNS_4ExprES3_RNS_8QualTypeE", "clang::Sema::ConvertPropertyForLValue(clang::Expr*&, clang::