; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabi -mattr=+armv8.2-a,+fullfp16,+neon -float-abi=hard < %s | FileCheck %s --check-prefix=CHECKHARD
; RUN: llc -mtriple=arm-eabi -mattr=+armv8.2-a,+fullfp16,+neon -float-abi=soft < %s | FileCheck %s --check-prefix=CHECKSOFT

define float @test_vget_lane_f16_1(<4 x half> %a) nounwind {
; CHECKHARD-LABEL: test_vget_lane_f16_1:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtt.f32.f16 s0, s0
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vget_lane_f16_1:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d0, r0, r1
; CHECKSOFT-NEXT:    vcvtt.f32.f16 s0, s0
; CHECKSOFT-NEXT:    vmov r0, s0
; CHECKSOFT-NEXT:    bx lr
entry:
  %elt = extractelement <4 x half> %a, i32 1
  %conv = fpext half %elt to float
  ret float %conv
}

define float @test_vget_lane_f16_2(<4 x half> %a) nounwind {
; CHECKHARD-LABEL: test_vget_lane_f16_2:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtb.f32.f16 s0, s1
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vget_lane_f16_2:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d0, r0, r1
; CHECKSOFT-NEXT:    vcvtb.f32.f16 s0, s1
; CHECKSOFT-NEXT:    vmov r0, s0
; CHECKSOFT-NEXT:    bx lr
entry:
  %elt = extractelement <4 x half> %a, i32 2
  %conv = fpext half %elt to float
  ret float %conv
}

define float @test_vget_laneq_f16_6(<8 x half> %a) nounwind {
; CHECKHARD-LABEL: test_vget_laneq_f16_6:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtb.f32.f16 s0, s3
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vget_laneq_f16_6:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d1, r2, r3
; CHECKSOFT-NEXT:    vcvtb.f32.f16 s0, s3
; CHECKSOFT-NEXT:    vmov r0, s0
; CHECKSOFT-NEXT:    bx lr
entry:
  %elt = extractelement <8 x half> %a, i32 6
  %conv = fpext half %elt to float
  ret float %conv
}

define float @test_vget_laneq_f16_7(<8 x half> %a) nounwind {
; CHECKHARD-LABEL: test_vget_laneq_f16_7:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtt.f32.f16 s0, s3
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vget_laneq_f16_7:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d1, r2, r3
; CHECKSOFT-NEXT:    vcvtt.f32.f16 s0, s3
; CHECKSOFT-NEXT:    vmov r0, s0
; CHECKSOFT-NEXT:    bx lr
entry:
  %elt = extractelement <8 x half> %a, i32 7
  %conv = fpext half %elt to float
  ret float %conv
}

define <4 x half> @test_vset_lane_f16(<4 x half> %a, float %fb) nounwind {
; CHECKHARD-LABEL: test_vset_lane_f16:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtt.f16.f32 s1, s2
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vset_lane_f16:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d0, r0, r1
; CHECKSOFT-NEXT:    vmov s2, r2
; CHECKSOFT-NEXT:    vcvtt.f16.f32 s1, s2
; CHECKSOFT-NEXT:    vmov r0, r1, d0
; CHECKSOFT-NEXT:    bx lr
entry:
  %b = fptrunc float %fb to half
  %x = insertelement <4 x half> %a, half %b, i32 3
  ret <4 x half> %x
}

define <8 x half> @test_vset_laneq_f16_1(<8 x half> %a, float %fb) nounwind {
; CHECKHARD-LABEL: test_vset_laneq_f16_1:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtt.f16.f32 s0, s4
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vset_laneq_f16_1:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d1, r2, r3
; CHECKSOFT-NEXT:    vldr s4, [sp]
; CHECKSOFT-NEXT:    vmov d0, r0, r1
; CHECKSOFT-NEXT:    vcvtt.f16.f32 s0, s4
; CHECKSOFT-NEXT:    vmov r2, r3, d1
; CHECKSOFT-NEXT:    vmov r0, r1, d0
; CHECKSOFT-NEXT:    bx lr
entry:
  %b = fptrunc float %fb to half
  %x = insertelement <8 x half> %a, half %b, i32 1
  ret <8 x half> %x
}

define <8 x half> @test_vset_laneq_f16_7(<8 x half> %a, float %fb) nounwind {
; CHECKHARD-LABEL: test_vset_laneq_f16_7:
; CHECKHARD:       @ %bb.0: @ %entry
; CHECKHARD-NEXT:    vcvtt.f16.f32 s3, s4
; CHECKHARD-NEXT:    bx lr
;
; CHECKSOFT-LABEL: test_vset_laneq_f16_7:
; CHECKSOFT:       @ %bb.0: @ %entry
; CHECKSOFT-NEXT:    vmov d1, r2, r3
; CHECKSOFT-NEXT:    vldr s4, [sp]
; CHECKSOFT-NEXT:    vmov d0, r0, r1
; CHECKSOFT-NEXT:    vcvtt.f16.f32 s3, s4
; CHECKSOFT-NEXT:    vmov r0, r1, d0
; CHECKSOFT-NEXT:    vmov r2, r3, d1
; CHECKSOFT-NEXT:    bx lr
entry:
  %b = fptrunc float %fb to half
  %x = insertelement <8 x half> %a, half %b, i32 7
  ret <8 x half> %x
}
