; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 -O3 | FileCheck %s --check-prefixes=SSE-X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 -O3 | FileCheck %s --check-prefixes=SSE-X64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=AVX-X86,AVX1-X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=AVX-X64,AVX1-X64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=AVX-X86,AVX512-X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=AVX-X64,AVX512-X64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=-sse -O3 | FileCheck %s --check-prefixes=X87

declare float @llvm.experimental.constrained.sitofp.f32.i1(i1, metadata, metadata)
declare float @llvm.experimental.constrained.sitofp.f32.i8(i8, metadata, metadata)
declare float @llvm.experimental.constrained.sitofp.f32.i16(i16, metadata, metadata)
declare float @llvm.experimental.constrained.sitofp.f32.i32(i32, metadata, metadata)
declare float @llvm.experimental.constrained.sitofp.f32.i64(i64, metadata, metadata)
declare float @llvm.experimental.constrained.uitofp.f32.i1(i1, metadata, metadata)
declare float @llvm.experimental.constrained.uitofp.f32.i8(i8, metadata, metadata)
declare float @llvm.experimental.constrained.uitofp.f32.i16(i16, metadata, metadata)
declare float @llvm.experimental.constrained.uitofp.f32.i32(i32, metadata, metadata)
declare float @llvm.experimental.constrained.uitofp.f32.i64(i64, metadata, metadata)

declare double @llvm.experimental.constrained.sitofp.f64.i1(i1, metadata, metadata)
declare double @llvm.experimental.constrained.sitofp.f64.i8(i8, metadata, metadata)
declare double @llvm.experimental.constrained.sitofp.f64.i16(i16, metadata, metadata)
declare double @llvm.experimental.constrained.sitofp.f64.i32(i32, metadata, metadata)
declare double @llvm.experimental.constrained.sitofp.f64.i64(i64, metadata, metadata)
declare double @llvm.experimental.constrained.uitofp.f64.i1(i1, metadata, metadata)
declare double @llvm.experimental.constrained.uitofp.f64.i8(i8, metadata, metadata)
declare double @llvm.experimental.constrained.uitofp.f64.i16(i16, metadata, metadata)
declare double @llvm.experimental.constrained.uitofp.f64.i32(i32, metadata, metadata)
declare double @llvm.experimental.constrained.uitofp.f64.i64(i64, metadata, metadata)

define float @sitofp_i1tof32(i1 %x) #0 {
; SSE-X86-LABEL: sitofp_i1tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; SSE-X86-NEXT:    andb $1, %al
; SSE-X86-NEXT:    negb %al
; SSE-X86-NEXT:    movsbl %al, %eax
; SSE-X86-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i1tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    andb $1, %dil
; SSE-X64-NEXT:    negb %dil
; SSE-X64-NEXT:    movsbl %dil, %eax
; SSE-X64-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i1tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; AVX-X86-NEXT:    andb $1, %al
; AVX-X86-NEXT:    negb %al
; AVX-X86-NEXT:    movsbl %al, %eax
; AVX-X86-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i1tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    andb $1, %dil
; AVX-X64-NEXT:    negb %dil
; AVX-X64-NEXT:    movsbl %dil, %eax
; AVX-X64-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i1tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movb {{[0-9]+}}(%esp), %al
; X87-NEXT:    andb $1, %al
; X87-NEXT:    negb %al
; X87-NEXT:    movsbl %al, %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.sitofp.f32.i1(i1 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @sitofp_i8tof32(i8 %x) #0 {
; SSE-X86-LABEL: sitofp_i8tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; SSE-X86-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i8tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movsbl %dil, %eax
; SSE-X64-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i8tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; AVX-X86-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i8tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movsbl %dil, %eax
; AVX-X64-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i8tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.sitofp.f32.i8(i8 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @sitofp_i16tof32(i16 %x) #0 {
; SSE-X86-LABEL: sitofp_i16tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movswl {{[0-9]+}}(%esp), %eax
; SSE-X86-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i16tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movswl %di, %eax
; SSE-X64-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i16tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    movswl {{[0-9]+}}(%esp), %eax
; AVX-X86-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i16tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movswl %di, %eax
; AVX-X64-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i16tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.sitofp.f32.i16(i16 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @sitofp_i32tof32(i32 %x) #0 {
; SSE-X86-LABEL: sitofp_i32tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    cvtsi2ssl {{[0-9]+}}(%esp), %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i32tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    cvtsi2ss %edi, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i32tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    vcvtsi2ssl {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i32tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    vcvtsi2ss %edi, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i32tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    fildl (%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.sitofp.f32.i32(i32 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @sitofp_i64tof32(i64 %x) #0 {
; SSE-X86-LABEL: sitofp_i64tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    fildll {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    fstps (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i64tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    cvtsi2ss %rdi, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i64tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    fildll {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    fstps (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i64tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    vcvtsi2ss %rdi, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i64tof32:
; X87:       # %bb.0:
; X87-NEXT:    fildll {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.sitofp.f32.i64(i64 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @uitofp_i1tof32(i1 %x) #0 {
; SSE-X86-LABEL: uitofp_i1tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; SSE-X86-NEXT:    andb $1, %al
; SSE-X86-NEXT:    movzbl %al, %eax
; SSE-X86-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i1tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    andl $1, %edi
; SSE-X64-NEXT:    cvtsi2ss %edi, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i1tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; AVX-X86-NEXT:    andb $1, %al
; AVX-X86-NEXT:    movzbl %al, %eax
; AVX-X86-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: uitofp_i1tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    andl $1, %edi
; AVX-X64-NEXT:    vcvtsi2ss %edi, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i1tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movb {{[0-9]+}}(%esp), %al
; X87-NEXT:    andb $1, %al
; X87-NEXT:    movzbl %al, %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.uitofp.f32.i1(i1 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @uitofp_i8tof32(i8 %x) #0 {
; SSE-X86-LABEL: uitofp_i8tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; SSE-X86-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i8tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movzbl %dil, %eax
; SSE-X64-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i8tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; AVX-X86-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: uitofp_i8tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movzbl %dil, %eax
; AVX-X64-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i8tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.uitofp.f32.i8(i8 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @uitofp_i16tof32(i16 %x) #0 {
; SSE-X86-LABEL: uitofp_i16tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SSE-X86-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i16tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movzwl %di, %eax
; SSE-X64-NEXT:    cvtsi2ss %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i16tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; AVX-X86-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    popl %eax
; AVX-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: uitofp_i16tof32:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movzwl %di, %eax
; AVX-X64-NEXT:    vcvtsi2ss %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i16tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    fildl (%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.uitofp.f32.i16(i16 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @uitofp_i32tof32(i32 %x) #0 {
; SSE-X86-LABEL: uitofp_i32tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-X86-NEXT:    orpd {{\.LCPI.*}}, %xmm0
; SSE-X86-NEXT:    subsd {{\.LCPI.*}}, %xmm0
; SSE-X86-NEXT:    cvtsd2ss %xmm0, %xmm0
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    popl %eax
; SSE-X86-NEXT:    .cfi_def_cfa_offset 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i32tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movl %edi, %eax
; SSE-X64-NEXT:    cvtsi2ss %rax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX1-X86-LABEL: uitofp_i32tof32:
; AVX1-X86:       # %bb.0:
; AVX1-X86-NEXT:    pushl %eax
; AVX1-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX1-X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-X86-NEXT:    vorpd {{\.LCPI.*}}, %xmm0, %xmm0
; AVX1-X86-NEXT:    vsubsd {{\.LCPI.*}}, %xmm0, %xmm0
; AVX1-X86-NEXT:    vcvtsd2ss %xmm0, %xmm0, %xmm0
; AVX1-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX1-X86-NEXT:    flds (%esp)
; AVX1-X86-NEXT:    wait
; AVX1-X86-NEXT:    popl %eax
; AVX1-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX1-X86-NEXT:    retl
;
; AVX1-X64-LABEL: uitofp_i32tof32:
; AVX1-X64:       # %bb.0:
; AVX1-X64-NEXT:    movl %edi, %eax
; AVX1-X64-NEXT:    vcvtsi2ss %rax, %xmm0, %xmm0
; AVX1-X64-NEXT:    retq
;
; AVX512-X86-LABEL: uitofp_i32tof32:
; AVX512-X86:       # %bb.0:
; AVX512-X86-NEXT:    pushl %eax
; AVX512-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX512-X86-NEXT:    vcvtusi2ssl {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX512-X86-NEXT:    flds (%esp)
; AVX512-X86-NEXT:    wait
; AVX512-X86-NEXT:    popl %eax
; AVX512-X86-NEXT:    .cfi_def_cfa_offset 4
; AVX512-X86-NEXT:    retl
;
; AVX512-X64-LABEL: uitofp_i32tof32:
; AVX512-X64:       # %bb.0:
; AVX512-X64-NEXT:    vcvtusi2ss %edi, %xmm0, %xmm0
; AVX512-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i32tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %ebp
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    .cfi_offset %ebp, -8
; X87-NEXT:    movl %esp, %ebp
; X87-NEXT:    .cfi_def_cfa_register %ebp
; X87-NEXT:    andl $-8, %esp
; X87-NEXT:    subl $8, %esp
; X87-NEXT:    movl 8(%ebp), %eax
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    movl $0, {{[0-9]+}}(%esp)
; X87-NEXT:    fildll (%esp)
; X87-NEXT:    wait
; X87-NEXT:    movl %ebp, %esp
; X87-NEXT:    popl %ebp
; X87-NEXT:    .cfi_def_cfa %esp, 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.uitofp.f32.i32(i32 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define float @uitofp_i64tof32(i64 %x) #0 {
; SSE-X86-LABEL: uitofp_i64tof32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $16, %esp
; SSE-X86-NEXT:    movl 12(%ebp), %eax
; SSE-X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-X86-NEXT:    movlps %xmm0, {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    shrl $31, %eax
; SSE-X86-NEXT:    fildll {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    fadds {{\.LCPI.*}}(,%eax,4)
; SSE-X86-NEXT:    fstps {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-X86-NEXT:    movss %xmm0, (%esp)
; SSE-X86-NEXT:    flds (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i64tof32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movq %rdi, %rax
; SSE-X64-NEXT:    shrq %rax
; SSE-X64-NEXT:    movl %edi, %ecx
; SSE-X64-NEXT:    andl $1, %ecx
; SSE-X64-NEXT:    orq %rax, %rcx
; SSE-X64-NEXT:    testq %rdi, %rdi
; SSE-X64-NEXT:    cmovnsq %rdi, %rcx
; SSE-X64-NEXT:    cvtsi2ss %rcx, %xmm0
; SSE-X64-NEXT:    jns .LBB9_2
; SSE-X64-NEXT:  # %bb.1:
; SSE-X64-NEXT:    addss %xmm0, %xmm0
; SSE-X64-NEXT:  .LBB9_2:
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i64tof32:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $16, %esp
; AVX-X86-NEXT:    movl 12(%ebp), %eax
; AVX-X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-X86-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    shrl $31, %eax
; AVX-X86-NEXT:    fildll {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    fadds {{\.LCPI.*}}(,%eax,4)
; AVX-X86-NEXT:    fstps {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-X86-NEXT:    vmovss %xmm0, (%esp)
; AVX-X86-NEXT:    flds (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX1-X64-LABEL: uitofp_i64tof32:
; AVX1-X64:       # %bb.0:
; AVX1-X64-NEXT:    movq %rdi, %rax
; AVX1-X64-NEXT:    shrq %rax
; AVX1-X64-NEXT:    movl %edi, %ecx
; AVX1-X64-NEXT:    andl $1, %ecx
; AVX1-X64-NEXT:    orq %rax, %rcx
; AVX1-X64-NEXT:    testq %rdi, %rdi
; AVX1-X64-NEXT:    cmovnsq %rdi, %rcx
; AVX1-X64-NEXT:    vcvtsi2ss %rcx, %xmm0, %xmm0
; AVX1-X64-NEXT:    jns .LBB9_2
; AVX1-X64-NEXT:  # %bb.1:
; AVX1-X64-NEXT:    vaddss %xmm0, %xmm0, %xmm0
; AVX1-X64-NEXT:  .LBB9_2:
; AVX1-X64-NEXT:    retq
;
; AVX512-X64-LABEL: uitofp_i64tof32:
; AVX512-X64:       # %bb.0:
; AVX512-X64-NEXT:    vcvtusi2ss %rdi, %xmm0, %xmm0
; AVX512-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i64tof32:
; X87:       # %bb.0:
; X87-NEXT:    pushl %ebp
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    .cfi_offset %ebp, -8
; X87-NEXT:    movl %esp, %ebp
; X87-NEXT:    .cfi_def_cfa_register %ebp
; X87-NEXT:    andl $-8, %esp
; X87-NEXT:    subl $16, %esp
; X87-NEXT:    movl 8(%ebp), %eax
; X87-NEXT:    movl 12(%ebp), %ecx
; X87-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X87-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X87-NEXT:    shrl $31, %ecx
; X87-NEXT:    fildll {{[0-9]+}}(%esp)
; X87-NEXT:    fadds {{\.LCPI.*}}(,%ecx,4)
; X87-NEXT:    fstps {{[0-9]+}}(%esp)
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    movl %ebp, %esp
; X87-NEXT:    popl %ebp
; X87-NEXT:    .cfi_def_cfa %esp, 4
; X87-NEXT:    retl
  %result = call float @llvm.experimental.constrained.uitofp.f32.i64(i64 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

define double @sitofp_i8tof64(i8 %x) #0 {
; SSE-X86-LABEL: sitofp_i8tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    movsbl 8(%ebp), %eax
; SSE-X86-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i8tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movsbl %dil, %eax
; SSE-X64-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i8tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    movsbl 8(%ebp), %eax
; AVX-X86-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i8tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movsbl %dil, %eax
; AVX-X64-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i8tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.sitofp.f64.i8(i8 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @sitofp_i16tof64(i16 %x) #0 {
; SSE-X86-LABEL: sitofp_i16tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    movswl 8(%ebp), %eax
; SSE-X86-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i16tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movswl %di, %eax
; SSE-X64-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i16tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    movswl 8(%ebp), %eax
; AVX-X86-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i16tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movswl %di, %eax
; AVX-X64-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i16tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.sitofp.f64.i16(i16 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @sitofp_i32tof64(i32 %x) #0 {
; SSE-X86-LABEL: sitofp_i32tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    cvtsi2sdl 8(%ebp), %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i32tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    cvtsi2sd %edi, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i32tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    vcvtsi2sdl 8(%ebp), %xmm0, %xmm0
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i32tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    vcvtsi2sd %edi, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i32tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    fildl (%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.sitofp.f64.i32(i32 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @sitofp_i64tof64(i64 %x) #0 {
; SSE-X86-LABEL: sitofp_i64tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    fildll 8(%ebp)
; SSE-X86-NEXT:    fstpl (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: sitofp_i64tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    cvtsi2sd %rdi, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: sitofp_i64tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    fildll 8(%ebp)
; AVX-X86-NEXT:    fstpl (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: sitofp_i64tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    vcvtsi2sd %rdi, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: sitofp_i64tof64:
; X87:       # %bb.0:
; X87-NEXT:    fildll {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.sitofp.f64.i64(i64 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @uitofp_i1tof64(i1 %x) #0 {
; SSE-X86-LABEL: uitofp_i1tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    movb 8(%ebp), %al
; SSE-X86-NEXT:    andb $1, %al
; SSE-X86-NEXT:    movzbl %al, %eax
; SSE-X86-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i1tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    andl $1, %edi
; SSE-X64-NEXT:    cvtsi2sd %edi, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i1tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    movb 8(%ebp), %al
; AVX-X86-NEXT:    andb $1, %al
; AVX-X86-NEXT:    movzbl %al, %eax
; AVX-X86-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: uitofp_i1tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    andl $1, %edi
; AVX-X64-NEXT:    vcvtsi2sd %edi, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i1tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movb {{[0-9]+}}(%esp), %al
; X87-NEXT:    andb $1, %al
; X87-NEXT:    movzbl %al, %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.uitofp.f64.i1(i1 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @uitofp_i8tof64(i8 %x) #0 {
; SSE-X86-LABEL: uitofp_i8tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    movzbl 8(%ebp), %eax
; SSE-X86-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i8tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movzbl %dil, %eax
; SSE-X64-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i8tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    movzbl 8(%ebp), %eax
; AVX-X86-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: uitofp_i8tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movzbl %dil, %eax
; AVX-X64-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i8tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    filds {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.uitofp.f64.i8(i8 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @uitofp_i16tof64(i16 %x) #0 {
; SSE-X86-LABEL: uitofp_i16tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    movzwl 8(%ebp), %eax
; SSE-X86-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i16tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movzwl %di, %eax
; SSE-X64-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i16tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $8, %esp
; AVX-X86-NEXT:    movzwl 8(%ebp), %eax
; AVX-X86-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX-X64-LABEL: uitofp_i16tof64:
; AVX-X64:       # %bb.0:
; AVX-X64-NEXT:    movzwl %di, %eax
; AVX-X64-NEXT:    vcvtsi2sd %eax, %xmm0, %xmm0
; AVX-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i16tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %eax
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    fildl (%esp)
; X87-NEXT:    wait
; X87-NEXT:    popl %eax
; X87-NEXT:    .cfi_def_cfa_offset 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.uitofp.f64.i16(i16 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @uitofp_i32tof64(i32 %x) #0 {
; SSE-X86-LABEL: uitofp_i32tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $8, %esp
; SSE-X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-X86-NEXT:    orpd {{\.LCPI.*}}, %xmm0
; SSE-X86-NEXT:    subsd {{\.LCPI.*}}, %xmm0
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i32tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movl %edi, %eax
; SSE-X64-NEXT:    cvtsi2sd %rax, %xmm0
; SSE-X64-NEXT:    retq
;
; AVX1-X86-LABEL: uitofp_i32tof64:
; AVX1-X86:       # %bb.0:
; AVX1-X86-NEXT:    pushl %ebp
; AVX1-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX1-X86-NEXT:    .cfi_offset %ebp, -8
; AVX1-X86-NEXT:    movl %esp, %ebp
; AVX1-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX1-X86-NEXT:    andl $-8, %esp
; AVX1-X86-NEXT:    subl $8, %esp
; AVX1-X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-X86-NEXT:    vorpd {{\.LCPI.*}}, %xmm0, %xmm0
; AVX1-X86-NEXT:    vsubsd {{\.LCPI.*}}, %xmm0, %xmm0
; AVX1-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX1-X86-NEXT:    fldl (%esp)
; AVX1-X86-NEXT:    wait
; AVX1-X86-NEXT:    movl %ebp, %esp
; AVX1-X86-NEXT:    popl %ebp
; AVX1-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX1-X86-NEXT:    retl
;
; AVX1-X64-LABEL: uitofp_i32tof64:
; AVX1-X64:       # %bb.0:
; AVX1-X64-NEXT:    movl %edi, %eax
; AVX1-X64-NEXT:    vcvtsi2sd %rax, %xmm0, %xmm0
; AVX1-X64-NEXT:    retq
;
; AVX512-X86-LABEL: uitofp_i32tof64:
; AVX512-X86:       # %bb.0:
; AVX512-X86-NEXT:    pushl %ebp
; AVX512-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX512-X86-NEXT:    .cfi_offset %ebp, -8
; AVX512-X86-NEXT:    movl %esp, %ebp
; AVX512-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX512-X86-NEXT:    andl $-8, %esp
; AVX512-X86-NEXT:    subl $8, %esp
; AVX512-X86-NEXT:    vcvtusi2sdl 8(%ebp), %xmm0, %xmm0
; AVX512-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX512-X86-NEXT:    fldl (%esp)
; AVX512-X86-NEXT:    wait
; AVX512-X86-NEXT:    movl %ebp, %esp
; AVX512-X86-NEXT:    popl %ebp
; AVX512-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX512-X86-NEXT:    retl
;
; AVX512-X64-LABEL: uitofp_i32tof64:
; AVX512-X64:       # %bb.0:
; AVX512-X64-NEXT:    vcvtusi2sd %edi, %xmm0, %xmm0
; AVX512-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i32tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %ebp
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    .cfi_offset %ebp, -8
; X87-NEXT:    movl %esp, %ebp
; X87-NEXT:    .cfi_def_cfa_register %ebp
; X87-NEXT:    andl $-8, %esp
; X87-NEXT:    subl $8, %esp
; X87-NEXT:    movl 8(%ebp), %eax
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    movl $0, {{[0-9]+}}(%esp)
; X87-NEXT:    fildll (%esp)
; X87-NEXT:    wait
; X87-NEXT:    movl %ebp, %esp
; X87-NEXT:    popl %ebp
; X87-NEXT:    .cfi_def_cfa %esp, 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.uitofp.f64.i32(i32 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

define double @uitofp_i64tof64(i64 %x) #0 {
; SSE-X86-LABEL: uitofp_i64tof64:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    pushl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_offset 8
; SSE-X86-NEXT:    .cfi_offset %ebp, -8
; SSE-X86-NEXT:    movl %esp, %ebp
; SSE-X86-NEXT:    .cfi_def_cfa_register %ebp
; SSE-X86-NEXT:    andl $-8, %esp
; SSE-X86-NEXT:    subl $24, %esp
; SSE-X86-NEXT:    movl 12(%ebp), %eax
; SSE-X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-X86-NEXT:    movlps %xmm0, {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    shrl $31, %eax
; SSE-X86-NEXT:    fildll {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    fadds {{\.LCPI.*}}(,%eax,4)
; SSE-X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-X86-NEXT:    movsd %xmm0, (%esp)
; SSE-X86-NEXT:    fldl (%esp)
; SSE-X86-NEXT:    wait
; SSE-X86-NEXT:    movl %ebp, %esp
; SSE-X86-NEXT:    popl %ebp
; SSE-X86-NEXT:    .cfi_def_cfa %esp, 4
; SSE-X86-NEXT:    retl
;
; SSE-X64-LABEL: uitofp_i64tof64:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movq %rdi, %rax
; SSE-X64-NEXT:    shrq %rax
; SSE-X64-NEXT:    movl %edi, %ecx
; SSE-X64-NEXT:    andl $1, %ecx
; SSE-X64-NEXT:    orq %rax, %rcx
; SSE-X64-NEXT:    testq %rdi, %rdi
; SSE-X64-NEXT:    cmovnsq %rdi, %rcx
; SSE-X64-NEXT:    cvtsi2sd %rcx, %xmm0
; SSE-X64-NEXT:    jns .LBB18_2
; SSE-X64-NEXT:  # %bb.1:
; SSE-X64-NEXT:    addsd %xmm0, %xmm0
; SSE-X64-NEXT:  .LBB18_2:
; SSE-X64-NEXT:    retq
;
; AVX-X86-LABEL: uitofp_i64tof64:
; AVX-X86:       # %bb.0:
; AVX-X86-NEXT:    pushl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_offset 8
; AVX-X86-NEXT:    .cfi_offset %ebp, -8
; AVX-X86-NEXT:    movl %esp, %ebp
; AVX-X86-NEXT:    .cfi_def_cfa_register %ebp
; AVX-X86-NEXT:    andl $-8, %esp
; AVX-X86-NEXT:    subl $24, %esp
; AVX-X86-NEXT:    movl 12(%ebp), %eax
; AVX-X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-X86-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    shrl $31, %eax
; AVX-X86-NEXT:    fildll {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    fadds {{\.LCPI.*}}(,%eax,4)
; AVX-X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-X86-NEXT:    vmovsd %xmm0, (%esp)
; AVX-X86-NEXT:    fldl (%esp)
; AVX-X86-NEXT:    wait
; AVX-X86-NEXT:    movl %ebp, %esp
; AVX-X86-NEXT:    popl %ebp
; AVX-X86-NEXT:    .cfi_def_cfa %esp, 4
; AVX-X86-NEXT:    retl
;
; AVX1-X64-LABEL: uitofp_i64tof64:
; AVX1-X64:       # %bb.0:
; AVX1-X64-NEXT:    movq %rdi, %rax
; AVX1-X64-NEXT:    shrq %rax
; AVX1-X64-NEXT:    movl %edi, %ecx
; AVX1-X64-NEXT:    andl $1, %ecx
; AVX1-X64-NEXT:    orq %rax, %rcx
; AVX1-X64-NEXT:    testq %rdi, %rdi
; AVX1-X64-NEXT:    cmovnsq %rdi, %rcx
; AVX1-X64-NEXT:    vcvtsi2sd %rcx, %xmm0, %xmm0
; AVX1-X64-NEXT:    jns .LBB18_2
; AVX1-X64-NEXT:  # %bb.1:
; AVX1-X64-NEXT:    vaddsd %xmm0, %xmm0, %xmm0
; AVX1-X64-NEXT:  .LBB18_2:
; AVX1-X64-NEXT:    retq
;
; AVX512-X64-LABEL: uitofp_i64tof64:
; AVX512-X64:       # %bb.0:
; AVX512-X64-NEXT:    vcvtusi2sd %rdi, %xmm0, %xmm0
; AVX512-X64-NEXT:    retq
;
; X87-LABEL: uitofp_i64tof64:
; X87:       # %bb.0:
; X87-NEXT:    pushl %ebp
; X87-NEXT:    .cfi_def_cfa_offset 8
; X87-NEXT:    .cfi_offset %ebp, -8
; X87-NEXT:    movl %esp, %ebp
; X87-NEXT:    .cfi_def_cfa_register %ebp
; X87-NEXT:    andl $-8, %esp
; X87-NEXT:    subl $16, %esp
; X87-NEXT:    movl 8(%ebp), %eax
; X87-NEXT:    movl 12(%ebp), %ecx
; X87-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X87-NEXT:    movl %eax, (%esp)
; X87-NEXT:    shrl $31, %ecx
; X87-NEXT:    fildll (%esp)
; X87-NEXT:    fadds {{\.LCPI.*}}(,%ecx,4)
; X87-NEXT:    fstpl {{[0-9]+}}(%esp)
; X87-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-NEXT:    wait
; X87-NEXT:    movl %ebp, %esp
; X87-NEXT:    popl %ebp
; X87-NEXT:    .cfi_def_cfa %esp, 4
; X87-NEXT:    retl
  %result = call double @llvm.experimental.constrained.uitofp.f64.i64(i64 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

attributes #0 = { strictfp }
