#!/bin/sh

#set -e

Cmdline ()
{
	for _PARAMETER in ${_CMDLINE}
	do
		case "${_PARAMETER}" in
			live-boot.read-only|read-only)
				LIVE_READ_ONLY="true"
				;;

			live-boot.swapon)
				LIVE_SWAPON="true"
				;;

			live-boot.verify-checksums|verify-checksums)
				LIVE_VERIFY_CHECKSUMS="true"
				;;

			# Special options
			live-boot.debug|debug)
				LIVE_DEBUG="true"
				;;


			# parameters below need review (FIXME)
			skipconfig)
				NOFSTAB="true"
				NONETWORKING="true"

				export NOFSTAB NONETWORKING
				;;

			BOOTIF=*)
				BOOTIF="${x#BOOTIF=}"
				;;

			dhcp)
				# Force dhcp even while netbooting
				# Use for debugging in case somebody works on fixing dhclient
				DHCP="true";
				export DHCP
				;;

			nodhcp)
				DHCP=""
				export DHCP
				;;

			ethdevice=*)
				DEVICE="${_PARAMETER#ethdevice=}"
				ETHDEVICE="${DEVICE}"
				export DEVICE ETHDEVICE
				;;

			ethdevice-timeout=*)
				ETHDEV_TIMEOUT="${_PARAMETER#ethdevice-timeout=}"
				export ETHDEV_TIMEOUT
				;;

			fetch=*)
				FETCH="${_PARAMETER#fetch=}"
				export FETCH
				;;

			findiso=*)
				FINDISO="${_PARAMETER#findiso=}"
				export FINDISO
				;;

			ftpfs=*)
				FTPFS="${_PARAMETER#ftpfs=}"
				export FTPFS
				;;

			httpfs=*)
				HTTPFS="${_PARAMETER#httpfs=}"
				export HTTPFS
				;;

			iscsi=*)
				ISCSI="${_PARAMETER#iscsi=}"
				#ip:port - separated by ;
				ISCSI_PORTAL="${ISCSI%;*}"
				if echo "${ISCSI_PORTAL}" | grep -q , ; then
					ISCSI_SERVER="${ISCSI_PORTAL%,*}"
					ISCSI_PORT="${ISCSI_PORTAL#*,}"
				fi
				#target name
				ISCSI_TARGET="${ISCSI#*;}"
				export ISCSI ISCSI_PORTAL ISCSI_TARGET ISCSI_SERVER ISCSI_PORT
				;;

			isofrom=*|fromiso=*)
				FROMISO="${_PARAMETER#*=}"
				export FROMISO
				;;

			ignore_uuid)
				IGNORE_UUID="true"
				export IGNORE_UUID
				;;

			ip=*)
				STATICIP="${_PARAMETER#ip=}"

				if [ -z "${STATICIP}" ]
				then
					STATICIP="frommedia"
				fi

				export STATICIP
				;;

			live-media=*|bootfrom=*)
				LIVE_MEDIA="${_PARAMETER#*=}"
				export LIVE_MEDIA
				;;

			live-media-encryption=*|encryption=*)
				LIVE_MEDIA_ENCRYPTION="${_PARAMETER#*=}"
				export LIVE_MEDIA_ENCRYPTION
				;;

			live-media-offset=*)
				LIVE_MEDIA_OFFSET="${_PARAMETER#live-media-offset=}"
				export LIVE_MEDIA_OFFSET
				;;

			live-media-path=*)
				LIVE_MEDIA_PATH="${_PARAMETER#live-media-path=}"
				export LIVE_MEDIA_PATH
				;;

			live-media-timeout=*)
				LIVE_MEDIA_TIMEOUT="${_PARAMETER#live-media-timeout=}"
				export LIVE_MEDIA_TIMEOUT
				;;

			module=*)
				MODULE="${_PARAMETER#module=}"
				export MODULE
				;;

			netboot=*)
				NETBOOT="${_PARAMETER#netboot=}"
				export NETBOOT
				;;

			nfsopts=*)
				NFSOPTS="${_PARAMETER#nfsopts=}"
				export NFSOPTS
				;;

			nfsoverlay=*)
				NFS_COW="${_PARAMETER#nfsoverlay=}"
				export NFS_COW
				;;

			nofstab)
				NOFSTAB="true"
				export NOFSTAB
				;;

			nonetworking)
				NONETWORKING="true"
				export NONETWORKING
				;;

			ramdisk-size=*)
				ramdisk_size="${_PARAMETER#ramdisk-size=}"
				;;

			persistence)
				PERSISTENCE="true"
				export PERSISTENCE
				;;

			persistence-encryption=*)
				PERSISTENCE_ENCRYPTION="${_PARAMETER#*=}"
				export PERSISTENCE_ENCRYPTION
				;;

			persistence-media=*)
				PERSISTENCE_MEDIA="${_PARAMETER#*=}"
				export PERSISTENCE_MEDIA
				;;
			persistence-method=*)
				PERSISTENCE_METHOD="${_PARAMETER#*=}"
				export PERSISTENCE_METHOD
				;;

			persistence-path=*)
				PERSISTENCE_PATH="${_PARAMETER#persistence-path=}"
				export PERSISTENCE_PATH
				;;
			persistence-read-only)
				PERSISTENCE_READONLY="true"
				export PERSISTENCE_READONLY
				;;

			persistence-storage=*)
				PERSISTENCE_STORAGE="${_PARAMETER#persistence-storage=}"
				export PERSISTENCE_STORAGE
				;;

			persistence-label=*)
				old_root_overlay_label="${_PARAMETER#persistence-label=*}"
				old_home_overlay_label="${_PARAMETER#persistence-label=*}"
				custom_overlay_label="${_PARAMETER#persistence-label=*}"
				;;

			nopersistence)
				NOPERSISTENCE="true"
				export NOPERSISTENCE
				;;

			quickusbmodules)
				QUICKUSBMODULES="true"
				export QUICKUSBMODULES
				;;

			showmounts)
				SHOWMOUNTS="true"
				export SHOWMOUNTS
				;;

			todisk=*)
				TODISK="${_PARAMETER#todisk=}"
				export TODISK
				;;

			toram)
				TORAM="true"
				export TORAM
				;;

			toram=*)
				TORAM="true"
				MODULETORAM="${_PARAMETER#toram=}"
				export TORAM MODULETORAM
				;;

			exposedroot)
				EXPOSED_ROOT="true"
				export EXPOSED_ROOT
				;;

			plainroot)
				PLAIN_ROOT="true"
				export PLAIN_ROOT
				;;

			skipunion)
				SKIP_UNION_MOUNTS="true"
				export SKIP_UNION_MOUNTS
				;;

			root=*)
				ROOT="${_PARAMETER#root=}"
				export ROOT
				;;

			union=*)
				UNIONTYPE="${_PARAMETER#union=}"
				export UNIONTYPE
				;;
		esac
	done

	# sort of compatibility with netboot.h from linux docs
	if [ -z "${NETBOOT}" ]
	then
		if [ "${ROOT}" = "/dev/nfs" ]
		then
			NETBOOT="nfs"
			export NETBOOT
		elif [ "${ROOT}" = "/dev/cifs" ]
		then
			NETBOOT="cifs"
			export NETBOOT
		fi
	fi

	if [ -z "${MODULE}" ]
	then
		MODULE="filesystem"
		export MODULE
	fi

	if [ -z "${UNIONTYPE}" ]
	then
		UNIONTYPE="aufs"
		export UNIONTYPE
	fi

	if [ -z "${PERSISTENCE_ENCRYPTION}" ]
	then
		PERSISTENCE_ENCRYPTION="none"
		export PERSISTENCE_ENCRYPTION
	elif is_in_comma_sep_list luks ${PERSISTENCE_ENCRYPTION}
	then
		if ! modprobe dm-crypt
		then
			log_warning_msg "Unable to load module dm-crypt"
			PERSISTENCE_ENCRYPTION=$(echo ${PERSISTENCE_ENCRYPTION} | sed -e 's/\<luks,\|,\?luks$//g')
			export PERSISTENCE_ENCRYPTION
		fi

		if [ ! -x /lib/cryptsetup/askpass ] || [ ! -x /sbin/cryptsetup ]
		then
			log_warning_msg "cryptsetup in unavailable"
			PERSISTENCE_ENCRYPTION=$(echo ${PERSISTENCE_ENCRYPTION} | sed -e 's/\<luks,\|,\?luks$//g')
			export PERSISTENCE_ENCRYPTION
		fi
	fi

	if [ -z "${PERSISTENCE_METHOD}" ]
	then
		PERSISTENCE_METHOD="overlay"
		export PERSISTENCE_METHOD
	fi

	if [ -z "${PERSISTENCE_STORAGE}" ]
	then
		PERSISTENCE_STORAGE="filesystem,file"
		export PERSISTENCE_STORAGE
	fi
}
