/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/environment.h"

extern void on_new ();
extern void on_open ();
extern void on_save ();
extern void on_saveas ();
extern void on_quit ();
extern void on_execute ();
extern void on_world (GtkWidget *w);
extern void on_program (GtkWidget *w);
extern void on_both (GtkWidget *w);
extern void on_grid (GtkWidget *w);
extern void on_about (GtkWidget *window);
extern gboolean on_delete ();

void create_interface ()
{	
	GtkAccelGroup *accel_group = gtk_accel_group_new ();

	GtkWidget *window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), _("Little Wizard"));
	gtk_window_set_default_size (GTK_WINDOW (window), 800, 580);
	
	GtkWidget *vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (window), vbox1);
	
/* Menu bar */

	GtkWidget *menubar1 = gtk_menu_bar_new ();
	gtk_widget_show (menubar1);
	gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);
	
	GtkWidget *menuitem4 = gtk_menu_item_new_with_mnemonic (_("_File"));
	gtk_widget_show (menuitem4);
	gtk_container_add (GTK_CONTAINER (menubar1), menuitem4);
	
	GtkWidget *menuitem4_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem4), menuitem4_menu);
	
	GtkWidget *minew = gtk_image_menu_item_new_from_stock ("gtk-new", accel_group);
	gtk_widget_show (minew);
	gtk_container_add (GTK_CONTAINER (menuitem4_menu), minew);
	
	GtkWidget *miopen = gtk_image_menu_item_new_from_stock ("gtk-open", accel_group);
	gtk_widget_show (miopen);
	gtk_container_add (GTK_CONTAINER (menuitem4_menu), miopen);
	
	GtkWidget *misave = gtk_image_menu_item_new_from_stock ("gtk-save", accel_group);
	gtk_widget_show (misave);
	gtk_container_add (GTK_CONTAINER (menuitem4_menu), misave);
	
	GtkWidget *misaveas = gtk_image_menu_item_new_from_stock ("gtk-save-as", accel_group);
	gtk_widget_show (misaveas);
	gtk_container_add (GTK_CONTAINER (menuitem4_menu), misaveas);
	
	GtkWidget *separatormenuitem1 = gtk_separator_menu_item_new ();
	gtk_widget_show (separatormenuitem1);
	gtk_container_add (GTK_CONTAINER (menuitem4_menu), separatormenuitem1);
	gtk_widget_set_sensitive (separatormenuitem1, FALSE);
	
	GtkWidget *miquit = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
	gtk_widget_show (miquit);
	gtk_container_add (GTK_CONTAINER (menuitem4_menu), miquit);

	GtkWidget *menuitem5 = gtk_menu_item_new_with_mnemonic (_("_Operations"));
	gtk_widget_show (menuitem5);
	gtk_container_add (GTK_CONTAINER (menubar1), menuitem5);

	GtkWidget *menuitem5_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem5), menuitem5_menu);
	
	GtkWidget *miexecute = gtk_image_menu_item_new_from_stock ("gtk-execute", accel_group);
	gtk_widget_show (miexecute);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), miexecute);

	GtkWidget *separator2 = gtk_separator_menu_item_new ();
	gtk_widget_show (separator2);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), separator2);
	gtk_widget_set_sensitive (separator2, FALSE);
	
	GtkWidget *miworld = gtk_radio_menu_item_new_with_mnemonic (NULL, _("Design world"));
	GSList *group1 = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (miworld));
	gtk_widget_show (miworld);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), miworld);

	GtkWidget *miprogram = gtk_radio_menu_item_new_with_mnemonic (group1, _("Design program"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (miprogram), TRUE);
	group1 = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (miprogram));
	gtk_widget_show (miprogram);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), miprogram);

	GtkWidget *miboth = gtk_radio_menu_item_new_with_mnemonic (group1, _("Dual mode"));
	gtk_widget_show (miboth);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), miboth);

	GtkWidget *separator3 = gtk_separator_menu_item_new ();
	gtk_widget_show (separator3);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), separator3);
	gtk_widget_set_sensitive (separator3, FALSE);

	GtkWidget *migrid = gtk_check_menu_item_new_with_mnemonic ( _("Enable grid"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (migrid), FALSE);
	gtk_widget_show (migrid);
	gtk_container_add (GTK_CONTAINER (menuitem5_menu), migrid);

	GtkWidget *menuitem6 = gtk_menu_item_new_with_mnemonic (_("_Help"));
	gtk_widget_show (menuitem6);
	gtk_container_add (GTK_CONTAINER (menubar1), menuitem6);

	GtkWidget *menuitem6_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem6), menuitem6_menu);

#ifdef GTK_STOCK_ABOUT
	GtkWidget *miabout = gtk_image_menu_item_new_from_stock ("gtk-about", accel_group);
#else
	GtkWidget *miabout = gtk_image_menu_item_new_with_mnemonic (_("About"));
#endif
	
	gtk_widget_show (miabout);
	gtk_container_add (GTK_CONTAINER (menuitem6_menu), miabout);


/* Toolbar */

	GtkWidget *toolbar1 = gtk_toolbar_new ();
	gtk_widget_show (toolbar1);
	gtk_box_pack_start (GTK_BOX (vbox1), toolbar1, FALSE, FALSE, 0);
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar1), GTK_TOOLBAR_BOTH);

	GtkWidget *tbnew = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-new");
	gtk_widget_show (tbnew);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbnew);

	GtkWidget *tbopen = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-open");
	gtk_widget_show (tbopen);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbopen);

	GtkWidget *tbsave = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-save");
	gtk_widget_show (tbsave);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbsave);

	GtkWidget *separatortoolitem1 = (GtkWidget*) gtk_separator_tool_item_new ();
	gtk_widget_show (separatortoolitem1);
	gtk_container_add (GTK_CONTAINER (toolbar1), separatortoolitem1);

	gchar *filename1 = LWEnvironment::buildPixmapFilename ("world.png");
	GtkWidget *icon1 = 	gtk_image_new_from_file (filename1);
	gtk_widget_show (icon1);
	GtkWidget *tbworld = (GtkWidget*) gtk_radio_tool_button_new (NULL);
    GSList *group2 = gtk_radio_tool_button_get_group (GTK_RADIO_TOOL_BUTTON (tbworld));
	gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (tbworld), icon1);
	gtk_tool_button_set_label (GTK_TOOL_BUTTON (tbworld),  _("World"));
	gtk_widget_show (tbworld);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbworld);
	g_free (filename1);
	
	gchar *filename2 = LWEnvironment::buildPixmapFilename ("program.png");
	GtkWidget *icon2 = 	gtk_image_new_from_file (filename2);
	gtk_widget_show (icon2);
	GtkWidget *tbcoding = (GtkWidget*) gtk_radio_tool_button_new (group2);
	gtk_toggle_tool_button_set_active (GTK_TOGGLE_TOOL_BUTTON (tbcoding), TRUE);
	group2 = gtk_radio_tool_button_get_group (GTK_RADIO_TOOL_BUTTON (tbcoding));
	gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (tbcoding), icon2);
	gtk_tool_button_set_label (GTK_TOOL_BUTTON (tbcoding),  _("Program"));
	gtk_widget_show (tbcoding);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbcoding);
	g_free (filename2);

	gchar *filename3 = LWEnvironment::buildPixmapFilename ("both.png");
	GtkWidget *icon3 = 	gtk_image_new_from_file (filename3);
	gtk_widget_show (icon3);
	GtkWidget *tbboth = (GtkWidget*) gtk_radio_tool_button_new (group2);
	gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (tbboth), icon3);
	gtk_tool_button_set_label (GTK_TOOL_BUTTON (tbboth),  _("Mixed"));
	gtk_widget_show (tbboth);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbboth);
	g_free (filename3);

	GtkWidget *separatortoolitem2 = (GtkWidget*) gtk_separator_tool_item_new ();
	gtk_widget_show (separatortoolitem2);
	gtk_container_add (GTK_CONTAINER (toolbar1), separatortoolitem2);

	gchar *filename4 = LWEnvironment::buildPixmapFilename ("grid.png");
	GtkWidget *icon4 = 	gtk_image_new_from_file (filename4);
	gtk_widget_show (icon4);
	GtkWidget *tbgrid = (GtkWidget*) gtk_toggle_tool_button_new ();
	gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (tbgrid), icon4);
	gtk_tool_button_set_label (GTK_TOOL_BUTTON (tbgrid),  _("Grid"));
	gtk_widget_show (tbgrid);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbgrid);
	g_free (filename4);

	GtkWidget *separatortoolitem3 = (GtkWidget*) gtk_separator_tool_item_new ();
	gtk_widget_show (separatortoolitem3);
	gtk_container_add (GTK_CONTAINER (toolbar1), separatortoolitem3);

	GtkWidget *tbexecute = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-execute");
	gtk_widget_show (tbexecute);
	gtk_container_add (GTK_CONTAINER (toolbar1), tbexecute);

/* Dodanie kontrolki środowiska */

	gtk_box_pack_start (GTK_BOX (vbox1), LWEnvironment::getWidget(), TRUE, TRUE, 0);

/* Wyświetlenie okna */
	gtk_widget_show (window);
	
/* Rejestracja funkcji zwrotnych */

	g_signal_connect (G_OBJECT (minew), "activate",
                    G_CALLBACK (on_new),
                    NULL);
					
	g_signal_connect (G_OBJECT (miopen), "activate",
                    G_CALLBACK (on_open),
                    NULL);
					
	g_signal_connect (G_OBJECT (misave), "activate",
                    G_CALLBACK (on_save),
                    NULL);
					
	g_signal_connect (G_OBJECT (misaveas), "activate",
                    G_CALLBACK (on_saveas),
                    NULL);
					
	g_signal_connect (G_OBJECT (miquit), "activate",
                    G_CALLBACK (on_quit),
                    NULL);
					
	g_signal_connect (G_OBJECT (miexecute), "activate",
                    G_CALLBACK (on_execute),
                    NULL);

	g_signal_connect_swapped (G_OBJECT (miabout), "activate",
                    G_CALLBACK (on_about),
                    (gpointer) window);

	g_signal_connect_swapped (G_OBJECT (miworld), "toggled",
                    G_CALLBACK (on_world),
                    (gpointer) tbworld);
					
	g_signal_connect_swapped (G_OBJECT (miprogram), "toggled",
                    G_CALLBACK (on_program),
                    (gpointer) tbcoding);

	g_signal_connect_swapped (G_OBJECT (miboth), "toggled",
                    G_CALLBACK (on_both),
                    (gpointer) tbboth);

	g_signal_connect_swapped (G_OBJECT (migrid), "toggled",
                    G_CALLBACK (on_grid),
                    (gpointer) tbgrid);
					
	g_signal_connect (G_OBJECT (tbnew), "clicked",
                    G_CALLBACK (on_new),
                    NULL);
					
	g_signal_connect (G_OBJECT (tbopen), "clicked",
                    G_CALLBACK (on_open),
                    NULL);
					
	g_signal_connect (G_OBJECT (tbsave), "clicked",
                    G_CALLBACK (on_save),
                    NULL);
					
	g_signal_connect_swapped (G_OBJECT (tbworld), "toggled",
                    G_CALLBACK (on_world),
                    (gpointer) miworld);
					
	g_signal_connect_swapped (G_OBJECT (tbcoding), "toggled",
                    G_CALLBACK (on_program),
                    (gpointer) miprogram);

	g_signal_connect_swapped (G_OBJECT (tbboth), "toggled",
                    G_CALLBACK (on_both),
                    (gpointer) miboth);

	g_signal_connect_swapped (G_OBJECT (tbgrid), "toggled",
                    G_CALLBACK (on_grid),
                    (gpointer) migrid);

	g_signal_connect (G_OBJECT (tbexecute), "clicked",
                    G_CALLBACK (on_execute),
                    NULL);

	g_signal_connect (G_OBJECT (window), "delete_event",
                    G_CALLBACK (on_delete),
                    NULL);

}
