/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file program.h 
	\brief Obsługa programu
*/

#ifndef __LW_PROGRAM_H
#define __LW_PROGRAM_H

#include "command.h"
#include "message.h"
#include "variable.h"

/*! \class LWProgram
	\brief Klasa reprezentująca program

	Klasa zarządzająca programem
*/

class LWProgram {
private:
LWBoard *world;
LWContext context;
GSList *list_vars;
gboolean finished;
gboolean stoped;
GNode *tree_piece;
LWPiece *begin_piece;
void executeOrderPost (LWCommand *cmd, GNode *children);
void executeNode (GNode *node);
LWValue *computeValue (GNode *node);
void setArguments (LWCommand *cmd, GNode *node);
void checkNode (GNode *node, gboolean hasMovedElement=FALSE);
void uninit ();
void showMessage (LWMessage *msg);
void registerVariable (LWVariable *variable);
public:
LWProgram ();
~LWProgram ();
gboolean parse (LWBoard *program);
void setWorld (LWBoard *a_world);
LWBoard *getWorld ();
void execute ();
void debugTree ();
gboolean isFinished();
void stop ();
};
#endif
