/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file environment.h 
	\brief Zarządzanie całym środowiskiem
*/

#ifndef __LW_ENVIRONMENT_H
#define __LW_ENVIRONMENT_H

#include <libxml/tree.h>

#include "project.h"
#include "pixmapset.h"
#include "program.h"

/*! \class LWEnvironment
	\brief Środowisko programistyczne i uruchomieniowe

	Główna klasa zarządzająca całym środowiskiem. Każda aplikacja
	przed wykonaniem jakich kolwiek metod w bibliotece musi zaincjować
	bibliotekę przez metodę init w tej klasie.
*/

typedef enum LWDesign {
LW_DESIGN_WORLD=0,
LW_DESIGN_PROGRAM=1,
LW_DESIGN_MIXED=2
};

class LWEnvironment {
static GtkWidget *widget;
static GtkWidget *program_paned;
static GtkWidget *world_paned;
static GtkWidget *both_paned;
static LWPixmapSet *pixmapset;
static LWBoardSet *icons;
static LWBoardSet *commands;
static LWProject *project;
static LWProgram *program;
static xmlNode *wizard_xml;
static LWDesign mode;
static GData *symbols;
static gboolean enabled_grid;
static xmlNode *initializeXMLTree (xmlDocPtr &doc);	
static void clear();
public:
static void init();
static void uninit ();
static LWPixmapSet *getPixmapSet ();
static xmlNode *getWizardXML ();
static void setDesignMode (LWDesign a_mode);
static void setProject (LWProject *a_project);
static void unsetProject ();
static LWProject *getProject ();
static void registerProgram (LWProgram *a_program);
static void unregisterProgram ();
static LWProgram *getProgram ();
static gchar *buildPixmapFilename (gchar *file);
static GData *getSymbols ();
static void enableGrid (gboolean enable);
static GtkWidget *getWidget ();
};

#endif
