# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###






import gtk
from config import config

from helper import SignalContainer

TIP = gtk.Tooltips()
def set_tip(widget,text):
    TIP.set_tip(widget,text,None)

class ScrolledWindow(gtk.ScrolledWindow):
    def __init__(self,widget,use_view_port=False,shadow=gtk.SHADOW_IN,hscrollbar_policy=gtk.POLICY_AUTOMATIC,vscrollbar_policy=gtk.POLICY_AUTOMATIC):
        super(ScrolledWindow,self).__init__()
        self.set_policy(hscrollbar_policy,vscrollbar_policy)
        if use_view_port:
            self.add_with_viewport(widget)
        else:
            self.add(widget)
        self.set_shadow_type(shadow)
        
class SimpleMenu(gtk.Menu,SignalContainer):
    def __init__(self):
        gtk.Menu.__init__(self)
        SignalContainer.__init__(self)

    def append_sep(self):
        self.append(gtk.SeparatorMenuItem())
         
    def insert_sep(self,pos):
        self.insert(gtk.SeparatorMenuItem(),pos)        
         
    def insert_item(self,obj,func,stock,pos=-1):
        item = gtk.ImageMenuItem(stock)
        self.autoconnect_object(item,"activate",func,obj)
        self.insert(item,pos)
        
    def insert_item_text(self,obj,func,text,pos=-1):
        item = gtk.MenuItem(text)
        self.autoconnect_object(self,"activate",func,obj)
        self.insert(item,pos)

    def popup(self,*args,**kwargs):
        super(SimpleMenu,self).popup(None,None,None,0,gtk.get_current_event_time())

class SimpleFontDialog(gtk.FontSelectionDialog):
    def __init__(self,conf_prefix):
        gtk.Window.__init__(self)
        super(SimpleFontDialog,self).__init__(_("Font"))
        
        self.conf_prefix = conf_prefix

        self.ok_button.connect("clicked",self.on_ok_clicked)
        self.apply_button.connect("clicked",self.on_apply_clicked)
        self.cancel_button.connect("clicked",self.on_cancel_clicked)

        self.read_config()

        self.show_all()

    def on_ok_clicked(self,button):
        self.save_config()
        self.quit()

    def on_apply_clicked(self,button):
        self.save_config()

    def on_cancel_clicked(self,button):
        self.quit()

    def read_config(self):
        try: 
            current_config = config.get("font",self.conf_prefix)
            self.set_font_name(current_config)
        except: pass        

    def save_config(self):
        config.set("font",self.conf_prefix,self.get_font_name())

    def quit(self,*arg):
        self.destroy()

       
class SimpleVBox(gtk.VBox):
    expand = False
    fill = False
    padding=0
    spacing=0
    homogeneous=False
    border_width = 0
    
    def __init__(self,*args,**kargs):
        for key,value in kargs.iteritems():
            setattr(self,key,value)
            
        super(SimpleVBox,self).__init__(self.homogeneous,self.spacing)
        for w in args:
            self.pack_start(w,self.expand,self.fill,self.padding)
            
        self.set_property("border_width",self.border_width)
        
class SimpleHBox(gtk.HBox):
    expand = False
    fill = False
    padding=0
    spacing=0
    homogeneous=False
    border_width = 0
    
    def __init__(self,*args,**kargs):
        for key,value in kargs.iteritems():
            setattr(self,key,value)
        super(SimpleHBox,self).__init__(self.homogeneous,self.spacing)
        for w in args:
            self.pack_start(w,self.expand,self.fill,self.padding)
        self.set_property("border_width",self.border_width)
            
class Label(gtk.Label):
    _use_markup = False
    _align =(0,0.5)
    def __init__(self,label,*args,**kargs):
        for key,value in kargs.iteritems():
            setattr(self,key,value)
            
        super(Label,self).__init__(label)
        self.set_alignment(*self._align)
        self.set_use_markup(self._use_markup)
            

class MarkupLabel(Label):
    _use_markup = True
            
class SimpleTable(gtk.Table):
    def __init__(self,*args,**kargs):
        super(SimpleTable,self).__init__(*args,**kargs)
        self.index = {}
        
    def pack_start_col(self, n , widget):
        if not self.index.has_key(n):  self.index[n] = 0
        else: self.index[n] += 1
        self.attach( widget, n, n+1, self.index[n], self.index[n]+1 )    
        

