

import gtk
import pango

try: import sexy
except: sexy = None

import utils

from source import Source,SourceItem
from lastfm_service import lastfm_info
from widget.misc import ScrolledWindow, set_tip
from widget.song_menu import SongMenuManager
from player import Player
from logger import Logger
from helper import SignalContainer, Dispatcher
from config import config
 
from stock import add_stock

class LastFmEventButton(gtk.Button):
    def set_url(self, url):
        self.url = url

class LastFmEventsBox(gtk.VBox, Logger, SignalContainer):

    def __init__(self):
        gtk.VBox.__init__(self,False,6)
        SignalContainer.__init__(self)
 
        label = gtk.Label(_("Search events for artist:"))

        if sexy:
            self.__entry = sexy.IconEntry()
            self.__entry.set_icon(sexy.ICON_ENTRY_PRIMARY,gtk.image_new_from_stock(gtk.STOCK_FIND,gtk.ICON_SIZE_BUTTON))
            self.__entry.add_clear_button()
        else:
            self.__entry = gtk.Entry()
         
        self.__entry.connect("activate", self.__search)
        box_search = gtk.HBox(False,6)
        box_search.pack_start(label, False, False)
        box_search.pack_start(self.__entry, True, True)

        self.autoconnect(Player,"new-song",self.__on_new_song)
    
        if not sexy:
            btn_clear = gtk.Button()
            btn_clear.add(gtk.image_new_from_stock(gtk.STOCK_CLEAR, gtk.ICON_SIZE_MENU))
            btn_clear.set_size_request(28,28)
            btn_clear.set_relief(gtk.RELIEF_NONE)
            self.autoconnect(btn_clear,"clicked",lambda widget:self.__entry.set_text(""))    
            box_search.pack_start(btn_clear,False,False)
 
            btn = gtk.Button()
            btn.add(gtk.image_new_from_stock(gtk.STOCK_FIND,gtk.ICON_SIZE_MENU))
            set_tip(btn, _("Search future artist's events"))
            self.autoconnect(btn,"clicked", self.__search)
            box_search.pack_start(btn, False, False)
                
        self.auto_update = gtk.CheckButton("Auto-updating")
        self.auto_update.set_property("active",True)
        
        box_search.pack_start(self.auto_update, False, False)

        self.pack_start(box_search, False, False)
        
        self.list_box = gtk.VBox(False,6)
        self.pack_start(ScrolledWindow(self.list_box,True,gtk.SHADOW_NONE),True,True)

        def song_menu_action(song_menu_manager,id_menu,songs):
            if id_menu == "lastfm_events" and songs:
                Dispatcher.select_source_id("lastfm_events")
                self.search_for_song(songs[0])

        self.autoconnect(SongMenuManager,"action",song_menu_action)
        SongMenuManager.register_item("lastfm_events", 81, 
                add_stock("lastfm_events", _("Look for events for this artist"), gtk.STOCK_ABOUT) )
        for type in [ "local","unknown_local"]:
            SongMenuManager.allow_item_for_type("lastfm_events",type)


        
    def __on_new_song(self, player, song):
        self.search_for_song(song)

    def search_for_song(self, song):
        if not self.auto_update.get_property("active"): return 
        if config.get("setting","offline") == "true" :
            self.set_list_box_text(_("Offline Mode"))
        else:
            text = song.get("artist")
            self.loginfo("Search events: %s", text)
            lastfm_info.get_events(text, self.fetch_info)
        
    def __search(self, *args, **kwargs):
        if config.get("setting","offline") == "true" :
            self.set_list_box_text(_("Offline Mode"))
        else:
            text = self.__entry.get_text()
            if text.strip() == "": return None
            self.loginfo("Search events: %s", text)
            self.set_list_box_text( _("Looking for <b>%s</b>'s events")%text )
            lastfm_info.get_events(text, self.fetch_info)

    def clear_list_box(self):
        self.list_box.foreach(self.list_box.remove)
        self.list_box.hide_all()

    def set_list_box_text(self, text):
        self.clear_list_box()
        label = gtk.Label()
        label.set_markup("\n\n<i>%s</i>"%text)
        label.set_alignment(0.1,0)
        self.list_box.pack_start(label, False, False)
        self.list_box.show_all()


    def fetch_info(self, items):
        artist = items["artist_name"]
        total = items["total"]
        events = items["events"]
        
        self.loginfo("found %d events", total)
        if not events:
            self.set_list_box_text(_("No event found"))
        else:
            self.clear_list_box()
            for event in events:
                # {event: title, artists, headliner, venue_name, city, country, image, url}
                btn = LastFmEventButton()
                btn.set_url(event["url"])
                btn.connect("clicked", lambda widget: utils.website(widget.url))
                event_box = gtk.HBox(False,6)
                
                lbl = gtk.Label()
                lbl.set_markup("<b>%s</b>\n%s, %s" % (utils.xmlescape(event["title"]), utils.xmlescape(event["country"]), utils.xmlescape(event["city"])))

                event_box.pack_start(lbl, False, False)
                event_box.pack_end(gtk.Label(utils.xmlescape(event["startdate"])), False, False)
                btn.add(event_box)
                
                self.list_box.pack_start(btn, False, False)
            self.list_box.show_all()

        
class LastFmEventsItem(SourceItem):
    widget_klass = LastFmEventsBox
    config_code = "events"
    label = _("Events")
    source_id = "lastfm_events"
    
class LastFmEventsSource(Source):
    PLUGIN_NAME="Last.fm events"
    PLUGIN_DESC = "Search future artist's events at Last.fm"
    PLUGIN_AUTHOR = "Pedro Abranches (pedrof.abranches@gmail.com)"
    
    categorie = "info"
    display_index = 1
    signal_collector_id = "lastfm_events"

    def __init__(self):
        super(LastFmEventsSource,self).__init__()
        self.items = [ LastFmEventsItem() ]
    
