# -*- coding: utf-8 -*-
# vim: ts=4
###
# written by xsdnyd <xsdnyd@gmail.com>
###

import urllib
import string

from plugins.lyrics import LyricsPlugin

class LyrikiPlugin(LyricsPlugin):
    PLUGIN_NAME = "lyriki.com"
    PLUGIN_DESC = "Add support of lyriki.com website to provide lyrics"
    PLUGIN_VERSION = "1.0"
    server_name = "lyriki.com"
    PLUGIN_AUTHOR = "xsdnyd <xsdnyd@gmail.com>"
    PLUGIN_WEBSITE = ""
    
    def process_lyrics(self,artist,album,title,song):
        url = "http://www.lyriki.com/%s:%s" % ( urllib.quote(string.replace(string.capwords(artist.encode('utf-8')), " ", "_")), 
                                                urllib.quote(string.replace(string.capwords(title.encode('utf-8')), " ", "_")))
        self.download_data(url,self.fetch_lyrics_lyriki,song)

    def fetch_lyrics_lyriki(self,html_buffer,song):
        startMarker = "<p>"
        endMarker = "</p>"
        lyric = html_buffer.read()
        pos = string.find(lyric, "Lyricists:")
        if pos < 0:
            self.render(_("Unable to find any matches for this song."))
        else:
            pos = string.find(lyric, startMarker, pos)
            lyric = lyric[pos + len(startMarker):string.find(lyric, endMarker, pos)]
            self.render(lyric,song,True)
