# -*- coding: utf-8 -*-
####
# Written by Vinicius de Figueiredo Silva <viniciusfs@gmail.com>
####

import urllib
import string
import re

from plugins.lyrics import LyricsPlugin

class LetrasMusBrPlugin(LyricsPlugin):
    PLUGIN_NAME = "letras.mus.br"
    PLUGIN_DESC = "Add support of letras.mus.br website to provide lyrics"
    PLUGIN_VERSION = "1.0"
    server_name = "letras.mus.br"
    PLUGIN_AUTHOR = "Vinicius de Figueiredo Silva <viniciusfs@gmail.com>"
    PLUGIN_WEBSITE = "http://vinicius.oitobits.net"
    
    def process_lyrics(self,artist,album,title,song):
        url = "http://letras.mus.br/winamp.php?musica=%s&artista=%s"%(
            urllib.quote(title.encode('utf-8')),
            urllib.quote(artist.encode('utf-8')))

        self.download_data(url,self.fetch_lyrics_terra,song)

    def fetch_lyrics_terra(self,html_buffer,song):
        content = html_buffer.read()
        error_msg = re.search('\<h3\>(?P<msg>.*)\<\/h3\>', content)

        if error_msg is not None:
            self.render(_("Lyrics not found."))
        else:
            start = "</p><p>"
            end = "</p></div>"
            lyric = content[content.find(start)+len(start):content.find(end)]
            lyric = lyric.replace("<br/>","<br />")
            self.render(lyric,song,True)
