# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###
#
# Inspired from Listen plugin for AWN by T.D. ter Braak

# import libraries
import dbus
import time
import os

import gtk

from helper import Dispatcher
from player import Player
from plugins.generic import GenericPlugin

from cover_manager import CoverManager

from config import config
import utils

# Change this if your Listen version uses a different format (\u266A is the musicnote)
SHOW_ALBUM_COVER = 1
SHOW_SONG_PROGRESS = 1 


class AWNPlugin(GenericPlugin):
    PLUGIN_NAME = "AWN Cover and progress"
    PLUGIN_DESC = "Plugin to show cover and progress en awn"
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "Mehdi ABAAKOUK and T.D. ter Braak"
    PLUGIN_WEBSITE = ""

    session_bus = None
    awn = None


    def dbus_get_awn(self):
        awn_obj = self.session_bus.get_object("com.google.code.Awn", "/com/google/code/Awn")
        return dbus.Interface(awn_obj, "com.google.code.Awn")

    def __init__(self):
        GenericPlugin.__init__(self)
        self.session_bus = dbus.SessionBus()
        self.awn = self.dbus_get_awn()

        self.autoconnect(Player.bin,"tick",self.on_tick)
        #self.autoconnect(Player,"new-song",self.on_new_song)
        self.autoconnect(Player,"play-end",self.reset_awn)
        self.autoconnect(Player,"stopped",self.reset_awn)
        gtk.quit_add(0, self.reset_awn)

    def on_tick(self,bin, position, length):
        icon_name = "listen"
        awn = self.awn
        awn.UnsetInfoByName(icon_name)

        # get path of the cover
        cover = CoverManager.get_cover_path(Player.song)
        # get the current position in the song
        #position = 100 * float(listen.current_position())
        # get the length of the current song
        #length = float(listen.current_song_length())

        if SHOW_ALBUM_COVER:
            # if the cover is available set it, else use default icon
            # NOTE: listen also provides cover-names that does not exist (extra check needed)
            if len(cover) and os.path.exists(cover):
                awn.SetTaskIconByName(icon_name, cover)
            else:
                awn.UnsetTaskIconByName(icon_name)

        if SHOW_SONG_PROGRESS:
            # set the progress indicator to the percentage of song played
            if position > 0 and length > 0:
                awn.SetProgressByName(icon_name, (position * 100 / length))

    def reset_awn(self,*args,**kwargs):
        icon_name = "listen"
        self.awn.UnsetTaskIconByName(icon_name)
        self.awn.SetProgressByName(icon_name, 100)
        self.awn.UnsetInfoByName(icon_name)
