# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gobject

import utils

class EventDispatcher(gobject.GObject):
    SIGNAL = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT))
    SIGNAL_SIMPLE = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))
    SIGNAL_COMP = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT,gobject.TYPE_INT))
    SIGNAL_COMP2 = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT))
    __gsignals__ = {
        "cur-playlist-enqueue" : SIGNAL_SIMPLE,
        "cur-playlist-play" : SIGNAL_SIMPLE,
        "config-changed" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
                (gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING)),
                
        "source-updated" : SIGNAL_SIMPLE,
        "edit-source" : SIGNAL_SIMPLE,
        "edit-playlist" :  SIGNAL_SIMPLE,

        "show-wikipedia" :(gobject.SIGNAL_RUN_LAST,  gobject.TYPE_NONE ,(gobject.TYPE_STRING,gobject.TYPE_PYOBJECT,)),
        "show-lyrics" :SIGNAL_SIMPLE,

        "select-source-id" :SIGNAL_SIMPLE,
        "volume" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_FLOAT,)),
        "play-device" :  (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,)),    
        "reload-plugins" : SIGNAL_SIMPLE,
        "update-queue": SIGNAL_SIMPLE,
        "quit": SIGNAL_SIMPLE,
    }
    def __init__(self):
        super(EventDispatcher,self).__init__()
        self.__update_source_id = None

    def cur_playlist_enqueue(self,song):
        self.emit("cur-playlist-enqueue",song)
        
    def cur_playlist_play(self,song):
        self.emit("cur-playlist-play",song)
       
    def config_change(self,section,option,value):
        self.emit("config-changed",section,option,value)
    
    def __reset_update_source_id(self):
        if self.__update_source_id:
            try: gobject.source_remove(self.__update_source_id)
            except: pass
            self.__update_source_id = None

    def update_source(self):
        self.__reset_update_source_id()
        self.__update_source_id = gobject.timeout_add(100, self.__real_update_source)

    def __real_update_source(self):
        self.__reset_update_source_id()
        self.emit("source-updated",None)
        
    def edit_playlist(self,pl):
        self.emit("edit-playlist",pl)
        
    def edit_source(self):
        self.emit("edit-source",None)

    def select_source_id(self,id):
        self.emit("select-source-id",id)
    
    def quit(self):
        self.emit("quit",None)
        
    def volume(self,value):
        self.emit("volume",value)
        
    def play_device(self,path):
        self.emit("play-device",path)

    def reload_plugins(self):
        self.emit("reload-plugins",None)
        
    def update_queue(self, queue):
        self.emit("update-queue", queue)
        
Dispatcher = EventDispatcher()

class SignalContainer:
    def __init__(self):
        self.dict = {}

    def autoconnect_object(self, obj, signal, func, obj_dest,*args):
        try:
            conns = self.dict[obj]
        except KeyError:
            conns = self.dict[obj] = []
        conns.append(obj.connect_after(signal, func, obj_dest, *args))

    def autoconnect_after(self, obj, signal, func, *args):
        try:
            conns = self.dict[obj]
        except KeyError:
            conns = self.dict[obj] = []
        conns.append(obj.connect_after(signal, func, *args))

    def autoconnect(self, obj, signal, func, *args):
        try:
            conns = self.dict[obj]
        except KeyError:
            conns = self.dict[obj] = []
        conns.append(obj.connect(signal, func, *args))

    def autodisconnect_object(self, obj):
        conns = self.dict.get(obj, None)
        if conns:
            for conn in conns:
                obj.disconnect(conn)
            del self.dict[obj]

    def autodisconnect_all(self):
        for obj, conns in self.dict.iteritems():
            for conn in conns:
                obj.disconnect(conn)
        self.dict = {}




class _SignalCollector(object):
    def __init__(self):
        self.dict = {}

    def connect(self, id, obj, signal, func, *args):
        self.dict.setdefault(id,{})
        try:
            conns = self.dict[id][obj]
        except KeyError:
            conns = self.dict[id][obj] = []
        conns.append(obj.connect(signal, func, *args))

    def disconnect_object(self, id, obj):
        if self.dict.has_key(id):
            conns = self.dict[id].get(obj, None)
            if conns:
                for conn in conns:
                    obj.disconnect(conn)
                del self.dict[id][obj]

    def disconnect_all(self, id ):
        if self.dict.has_key(id):
            for obj, conns in self.dict[id].iteritems():
                for conn in conns:
                    obj.disconnect(conn)
            self.dict[id] = {}

SignalCollector = _SignalCollector()
