# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk

from helper import Dispatcher
from player import Player
from vfs import async_parse_uris

from cover_manager import CoverManager

try: 
    import dbus
    import dbus.service
    #Try connection du message bus
    dbus_version = getattr(dbus, 'version',(0,0,0))
    if dbus_version >= (0,41,0) and dbus_version < (0,80,0):
        dbus.SessionBus()
        import dbus.glib
    elif dbus_version >= (0,80,0):
        from dbus.mainloop.glib import DBusGMainLoop
        DBusGMainLoop(set_as_default=True)
        dbus.SessionBus()

except: dbus_imported = False
else: dbus_imported=True

if not dbus_imported:
    class ListenDBus:
        def __init__(self,win,object_path="/org/gnome/listen"):
            self.win = win    
    print "No dbus support"
else:
    
    class ListenDBus(dbus.service.Object):
        def __init__(self,win,object_path="/org/gnome/listen"):
            self.win = win
            self.bus = dbus.SessionBus()
            bus_name = dbus.service.BusName("org.gnome.Listen", bus=self.bus)
            dbus.service.Object.__init__(self, bus_name, object_path)
            #print "DBUS INIT"
    
        @dbus.service.method("org.gnome.Listen")
        def hello(self):
            #self.win.grab_focus()
            if self.win.get_property('visible'):
               self.win.present()
            return "Running"
    
        @dbus.service.method("org.gnome.Listen")
        def focus(self):
            self.win.grab_focus()
            if self.win.get_property('visible'):
               self.win.present()
            return "Running"
    
        @dbus.service.method("org.gnome.Listen")
        def play(self,uris):
            print "DBUS: play()"
            self.win.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
            async_parse_uris(uris, True, True, 
                    self.win.playlist_ui.playlist.play_uris, pos = None, sort = True)
            return "Successful command "

        @dbus.service.method("org.gnome.Listen")
        def play_device(self,value):
            Dispatcher.play_device(value)
            return "Successful command "

        @dbus.service.method("org.gnome.Listen")
        def enqueue(self,uris):
            print "DBUS: enqueue()"
            self.win.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))    
            async_parse_uris(uris, True, True, 
                    self.win.playlist_ui.playlist.add_uris, pos = None, sort = True)
            return "Successful command "
    
    
        @dbus.service.method("org.gnome.Listen")
        def quit(self):
            Dispatcher.quit()
            return "Successful command "
        
        @dbus.service.method("org.gnome.Listen")
        def previous(self):
            Player.previous()
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def forward(self):
            Player.forward()
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def rewind(self):
            Player.rewind()
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def next(self):
            Player.next()
            return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def play_pause(self):
            Player.playpause()
            return "Successful command "

        #@dbus.service.method("org.gnome.Listen")
        #def stop(self):
        #    Player.stop()
        #    return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def volume(self,value):
            try: value = float(value)
            except:
                return _("Fail to set volume")
            else:
                Dispatcher.volume(value)
                return "Successful command "
    
        @dbus.service.method("org.gnome.Listen")
        def current_playing(self):
            if not Player.is_paused():
                song = Player.song    
                return str( song.get_str("title")+ " - ("+song.get_str("album")+" - "+song.get_str("artist")+")")
            else:
                return ""

        @dbus.service.method("org.gnome.Listen")
        def get_title(self):
            if not Player.is_paused():
                song = Player.song
                return song.get_str("title")
            else:
                return None

        @dbus.service.method("org.gnome.Listen")
        def get_artist(self):
            if not Player.is_paused():
                song = Player.song
                return song.get_str("artist")
            else:
                return ""
    
        @dbus.service.method("org.gnome.Listen")
        def get_uri(self):
            if not Player.is_paused():
                song = Player.song
                return song.get_str("uri")
            else:
                return ""

        @dbus.service.method("org.gnome.Listen")
        def get_album(self):
            if not Player.is_paused():
                song = Player.song
                return song.get_str("album")
            else:
                return ""

        @dbus.service.method("org.gnome.Listen")
        def current_position(self):
            return Player.get_position()/1000
            
        @dbus.service.method("org.gnome.Listen")
        def current_song_length(self):
            return Player.get_length()/1000

        @dbus.service.method("org.gnome.Listen")
        def get_cover_path(self):
            if not Player.is_paused() and Player.song:
                return CoverManager.get_cover_path(Player.song)
            else:
                return ""

        @dbus.service.method("org.gnome.Listen")
        def playing(self):
            return not Player.is_paused()

        @dbus.service.method("org.gnome.Listen")
        def dump_gstplayer_state(self):
            return Player.bin.dump_state()

