# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###
# Based on qlscrobbler.py from quodlibet
# Copyright (C) 2005 by Joshua Kwan <joshk@triplehelix.org>,
#                       Joe Wreschnig <piman@sacredchao.net>
###

import gobject
import md5
import os
import time
from urllib import urlencode
from urllib2 import urlopen

import threading

from library import ListenDB
from helper import Dispatcher
from config import config

PROTOCOL_VERSION = "1.2.1"
if "LISTEN_AUDIOSCROBBLER_TEST" not in os.environ :
    #FIXME: Need change client ID when i receive mine if one days audioscrobbler want answer me
    CLIENT = "lsn"
    VERSION = 0.6
else:
    CLIENT = "tst"
    VERSION = 1.0


class AudioScrobblerBadUser(Exception):
    pass
class AudioScrobblerCatastrophicFailure(Exception):
    pass
class AudioScrobblerBadAuth(Exception):
    pass
class AudioScrobblerBadSession(Exception):
    pass

class _AudioScrobblerManager:
    def __init__(self):

        self.password_hash = None
        self.submit_url = None
        self.queue = []
        self.interval_time = 0

        self.condition = threading.Condition()
        self.thread = threading.Thread(target=self.submit)
        self.thread.setDaemon(True)     # exit if only this thread is left
        self.thread.start()

    def get_root_url(self):
        return "http://%s/?hs=true&p=%s&c=%s&v=%s" % ( config.get("audioscrobbler","url"), PROTOCOL_VERSION, CLIENT, VERSION)

    def get_stamp(self,song):
        return str(int(time.time())--int(song.get('#duration')/2000)).encode('utf-8')
        #return time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime())
    
    def report_song(self,song,stamp=None):
        #some sanity control
        if song.get("#duration")<=30*1000 or \
           song.get("title")=="" or \
           not ListenDB.song_has_capability(song,"audioscrobbler"):
               return

        self.condition.acquire()
        if config.get("audioscrobbler","enable")=="true":
            self.username = config.get("audioscrobbler","username")
            self.md5_pass = config.get("audioscrobbler","password")
            self.queue.append((song,stamp or self.get_stamp(song)))
            #print "Queuing: %s - %s" % (song.sprint("artist"), song.sprint("title"))
            self.condition.notify()
        self.condition.release()

    def send_handshake(self):
    	timestamp=int(time.time())
    	auth=md5.new(self.md5_pass+str(timestamp));
    	authkey=auth.hexdigest()
        url = self.get_root_url() + "&u=%s&t=%s&a=%s" % (self.username,timestamp,authkey)

        print "Sending handshake to Audioscrobbler."
        resp = None
        try:
                resp = urlopen(url);
        except Exception,e:
                print "Server not responding, handshake failed.",e
                return False

        # check response
        lines = resp.read().rstrip().split("\n")
        status = lines.pop(0)

        if status.startswith("UPDATE"): print "Please update: %s" % status
        
        
        if status == "OK": 
            challenge = lines.pop(0)
            
            #print "Chanllenge ",self.challenge
            self.password_hash = challenge
            lines.pop(0)
            self.submit_url = lines.pop(0)
            print "Handshake SUCCESS",self.password_hash


        try: self.interval_time = int(lines.pop(0).split()[1])
        except: pass
        if status == "OK" : return True;
        elif status == "UPTODATE" or status.startswith("UPDATE"): return True
        elif status == "BADUSER": raise AudioScrobblerBadUser()
        else: print "Handshake failed: %s" % status; return False


    def submit(self):
        while True:
            self.condition.acquire()
            while not self.queue:
                self.condition.wait()
            self.condition.release()
            self.interval_time = 10
            try:
                while not self.send_handshake():
                    time.sleep(self.interval_time)
            except AudioScrobblerBadUser:
                print "Authentication failed: invalid username or bad password."
                self.condition.acquire()
                config.set("audioscrobbler","enable","false")
                self.queue = []
                self.condition.release()
                time.sleep(self.interval_time)
            else:
                last_handshake = time.time()
                submission_failures = 0
                while submission_failures < 3:
                    time.sleep(self.interval_time)
                    self.condition.acquire()
                    while not self.queue:
                        self.condition.wait()
                    tmp_queue = self.queue[:10]
                    self.condition.release()
                    try:
                        if self.submit_songs(tmp_queue): 
                            self.condition.acquire()
                            del self.queue[:len(tmp_queue)]
                            self.condition.release()
                    except AudioScrobblerCatastrophicFailure:
                        submission_failures += 1
                    except AudioScrobblerBadSession:
                        break
                    except AudioScrobblerBadAuth:
                        break
                time.sleep(max(self.interval_time, 30*60 + last_handshake - time.time()))
 
    def submit_songs(self, tmp_queue):
        data = {
                        's': self.password_hash
                }

        for i, (song, stamp) in enumerate(tmp_queue):
            stampstr =  stamp #time.strftime("%Y-%m-%d %H:%M:%S",stamp)
            print ("Sending song: %s - %s - %s" % (song.get_str('artist'), song.get_str('title'), stampstr ))
            data["a[%d]" % i] = song.get_str('artist').encode('utf-8')
            data["t[%d]" % i] = song.get_str('title').encode('utf-8')
            data["l[%d]" % i] = str(int(song.get('#duration')/1000)).encode('utf-8')
            data["b[%d]" % i] = song.get_str('album').encode('utf-8')
            data["m[%d]" % i] = "".encode('utf-8')
            data["i[%d]" % i] = stamp
            data["o[%d]" % i] = "P".encode('utf-8')
            data["n[%d]" % i] = "".encode('utf-8')
            data["r[%d]" % i] = "".encode('utf-8')



        (host, file) = self.submit_url[7:].split("/")
        url = "http://" + host + "/" + file
        resp = None
        try:
                data_str = urlencode(data)
                resp = urlopen(url, data_str)
                resp_save = resp.read()
        except Exception,e:
                print "Audioscrobbler server not responding, will try later.",e
                raise AudioScrobblerCatastrophicFailure()

        lines = resp_save.rstrip().split("\n")

        try: (status, interval) = lines
        except:
                try: status = lines[0]
                except:
                        print "Status incorect"
                        return False
        else: self.interval_time = int(interval.split()[1])

        #print "Submission status: %s" % status

        if status == "BADAUTH":
            print "Authentication failed: invalid username or bad password."
            print url
            print data
            raise AudioScrobblerBadAuth()
        
        elif status == "OK":
             print "Submit succesfull"
             return True
         
        elif status.startswith("FAILED"):
            print "FAILED response from server: %s" % status
            print "Dumping full response:"
            print resp_save
        elif status.startswith("BADSESSION"):
            print "Authentication failed: invalid session, need relogin"
            print url
            print data
            raise AudioScrobblerBadSession()
        else:
            print "Unknown response from server: %s" % status
            print "Dumping full response:"
            print resp_save
            
        return False


AudioScrobblerManager = _AudioScrobblerManager()
