/**
 * SECTION:updater
 * @short_description: All necessary methods to keep installed applications up-to-date
 * 
 * <para>This class allows installing updates for installed applications.</para>
 */
/**
 * LISTALLER_TYPE_UPDATER:
 * 
 * The type for <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link>.
 */
/**
 * listaller_updater_find_updates:
 * @self: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance
 * 
 * Find updates available for installed applications.
 */
/**
 * listaller_updater_apply_updates:
 * @self: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance
 * @update_list: (in): A list containing valid UpdateItems 
 * 
 * Apply updates selected in update_list.
 */
/**
 * listaller_updater_apply_updates_all:
 * @self: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance
 * 
 * Apply all available updates
 */
/**
 * listaller_updater_new:
 * @shared_mode: (in): Whether we are in shared mode or not. 
 * 
 * Create a new Listaller update manager
 */
/**
 * ListallerUpdater:settings:
 */
/**
 * listaller_updater_get_settings:
 * @self: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerUpdater--settings"><type>"settings"</type></link> property.
 * 
 * Returns: the value of the <link linkend="ListallerUpdater--settings"><type>"settings"</type></link> property
 */
/**
 * listaller_updater_set_settings:
 * @self: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerUpdater--settings"><type>"settings"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerUpdater--settings"><type>"settings"</type></link> property to @value.
 */
/**
 * ListallerUpdater:available-updates:
 */
/**
 * listaller_updater_get_available_updates:
 * @self: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerUpdater--available-updates"><type>"available-updates"</type></link> property.
 * 
 * Returns: the value of the <link linkend="ListallerUpdater--available-updates"><type>"available-updates"</type></link> property
 */
/**
 * ListallerUpdater::update:
 * @updater: the <link linkend="ListallerUpdater"><type>ListallerUpdater</type></link> instance that received the signal
 * @update: 
 */
/**
 * ListallerUpdater:
 * 
 * All necessary methods to keep installed applications up-to-date
 * 
 * <para>This class allows installing updates for installed applications.</para>
 */
/**
 * ListallerUpdaterClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-TYPE-UPDATER:CAPS"><literal>LISTALLER_TYPE_UPDATER</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
